import React from 'react';
import PropTypes from 'prop-types';
import reactCSS from 'reactcss';
import merge from 'lodash-es/merge';

import { ColorWrap, Saturation, Hue, Alpha, Checkboard } from '../common';
import ChromeFields from './ChromeFields';
import ChromePointer from './ChromePointer';
import ChromePointerCircle from './ChromePointerCircle';

export var Chrome = function Chrome(_ref) {
  var width = _ref.width,
      onChange = _ref.onChange,
      disableAlpha = _ref.disableAlpha,
      rgb = _ref.rgb,
      hsl = _ref.hsl,
      hsv = _ref.hsv,
      hex = _ref.hex,
      renderers = _ref.renderers,
      _ref$styles = _ref.styles,
      passedStyles = _ref$styles === undefined ? {} : _ref$styles,
      _ref$className = _ref.className,
      className = _ref$className === undefined ? '' : _ref$className,
      defaultView = _ref.defaultView;

  var styles = reactCSS(merge({
    'default': {
      picker: {
        width: width,
        background: '#fff',
        borderRadius: '2px',
        boxShadow: '0 0 2px rgba(0,0,0,.3), 0 4px 8px rgba(0,0,0,.3)',
        boxSizing: 'initial',
        fontFamily: 'Menlo'
      },
      saturation: {
        width: '100%',
        paddingBottom: '55%',
        position: 'relative',
        borderRadius: '2px 2px 0 0',
        overflow: 'hidden'
      },
      Saturation: {
        radius: '2px 2px 0 0'
      },
      body: {
        padding: '16px 16px 12px'
      },
      controls: {
        display: 'flex'
      },
      color: {
        width: '32px'
      },
      swatch: {
        marginTop: '6px',
        width: '16px',
        height: '16px',
        borderRadius: '8px',
        position: 'relative',
        overflow: 'hidden'
      },
      active: {
        absolute: '0px 0px 0px 0px',
        borderRadius: '8px',
        boxShadow: 'inset 0 0 0 1px rgba(0,0,0,.1)',
        background: 'rgba(' + rgb.r + ', ' + rgb.g + ', ' + rgb.b + ', ' + rgb.a + ')',
        zIndex: '2'
      },
      toggles: {
        flex: '1'
      },
      hue: {
        height: '10px',
        position: 'relative',
        marginBottom: '8px'
      },
      Hue: {
        radius: '2px'
      },
      alpha: {
        height: '10px',
        position: 'relative'
      },
      Alpha: {
        radius: '2px'
      }
    },
    'disableAlpha': {
      color: {
        width: '22px'
      },
      alpha: {
        display: 'none'
      },
      hue: {
        marginBottom: '0px'
      },
      swatch: {
        width: '10px',
        height: '10px',
        marginTop: '0px'
      }
    }
  }, passedStyles), { disableAlpha: disableAlpha });

  return React.createElement(
    'div',
    { style: styles.picker, className: 'chrome-picker ' + className },
    React.createElement(
      'div',
      { style: styles.saturation },
      React.createElement(Saturation, {
        style: styles.Saturation,
        hsl: hsl,
        hsv: hsv,
        pointer: ChromePointerCircle,
        onChange: onChange
      })
    ),
    React.createElement(
      'div',
      { style: styles.body },
      React.createElement(
        'div',
        { style: styles.controls, className: 'flexbox-fix' },
        React.createElement(
          'div',
          { style: styles.color },
          React.createElement(
            'div',
            { style: styles.swatch },
            React.createElement('div', { style: styles.active }),
            React.createElement(Checkboard, { renderers: renderers })
          )
        ),
        React.createElement(
          'div',
          { style: styles.toggles },
          React.createElement(
            'div',
            { style: styles.hue },
            React.createElement(Hue, {
              style: styles.Hue,
              hsl: hsl,
              pointer: ChromePointer,
              onChange: onChange
            })
          ),
          React.createElement(
            'div',
            { style: styles.alpha },
            React.createElement(Alpha, {
              style: styles.Alpha,
              rgb: rgb,
              hsl: hsl,
              pointer: ChromePointer,
              renderers: renderers,
              onChange: onChange
            })
          )
        )
      ),
      React.createElement(ChromeFields, {
        rgb: rgb,
        hsl: hsl,
        hex: hex,
        view: defaultView,
        onChange: onChange,
        disableAlpha: disableAlpha
      })
    )
  );
};

Chrome.propTypes = {
  width: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  disableAlpha: PropTypes.bool,
  styles: PropTypes.object,
  defaultView: PropTypes.oneOf(["hex", "rgb", "hsl"])
};

Chrome.defaultProps = {
  width: 225,
  disableAlpha: false,
  styles: {}
};

export default ColorWrap(Chrome);