/* peak-calculator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from peak-calculator.vala, do not modify */

#include <glib-object.h>
#include <glib.h>
#include <gst/gst.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define G4_TYPE_LEVEL_CALCULATOR (g4_level_calculator_get_type ())
#define G4_LEVEL_CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_LEVEL_CALCULATOR, G4LevelCalculator))
#define G4_LEVEL_CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_LEVEL_CALCULATOR, G4LevelCalculatorClass))
#define G4_IS_LEVEL_CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_LEVEL_CALCULATOR))
#define G4_IS_LEVEL_CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_LEVEL_CALCULATOR))
#define G4_LEVEL_CALCULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_LEVEL_CALCULATOR, G4LevelCalculatorClass))

typedef struct _G4LevelCalculator G4LevelCalculator;
typedef struct _G4LevelCalculatorClass G4LevelCalculatorClass;
typedef struct _G4LevelCalculatorPrivate G4LevelCalculatorPrivate;
typedef void (*G4LevelCalculatorLevelCalculateFunc) (guint8* data, guint num, guint channels, guint value_size, guint sample_size, gdouble* nps, gpointer user_data);

#define G4_LEVEL_CALCULATOR_TYPE_PEAK (g4_level_calculator_peak_get_type ())
typedef struct _G4LevelCalculatorPeak G4LevelCalculatorPeak;
#define _g4_level_calculator_peak_free0(var) ((var == NULL) ? NULL : (var = (g4_level_calculator_peak_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _gst_buffer_unref0(var) ((var == NULL) ? NULL : (var = (gst_buffer_unref (var), NULL)))
typedef struct _G4ParamSpecLevelCalculator G4ParamSpecLevelCalculator;

struct _G4LevelCalculator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	G4LevelCalculatorPrivate * priv;
};

struct _G4LevelCalculatorClass {
	GTypeClass parent_class;
	void (*finalize) (G4LevelCalculator *self);
};

struct _G4LevelCalculatorPeak {
	GstClockTime time;
	gdouble peak;
};

struct _G4LevelCalculatorPrivate {
	gint _audio_channels;
	gint _audio_bps;
	gint _sample_bps;
	GstCaps* _last_caps;
	GstClockTime _last_sample_time;
	G4LevelCalculatorLevelCalculateFunc _level_calculate;
	gpointer _level_calculate_target;
	GDestroyNotify _level_calculate_target_destroy_notify;
	GQueue* _peaks;
};

struct _G4ParamSpecLevelCalculator {
	GParamSpec parent_instance;
};

static gint G4LevelCalculator_private_offset;
static gpointer g4_level_calculator_parent_class = NULL;

VALA_EXTERN gpointer g4_level_calculator_ref (gpointer instance);
VALA_EXTERN void g4_level_calculator_unref (gpointer instance);
VALA_EXTERN GParamSpec* g4_param_spec_level_calculator (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void g4_value_set_level_calculator (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void g4_value_take_level_calculator (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer g4_value_get_level_calculator (const GValue* value);
VALA_EXTERN GType g4_level_calculator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4LevelCalculator, g4_level_calculator_unref)
static GType g4_level_calculator_peak_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static G4LevelCalculatorPeak* g4_level_calculator_peak_dup (const G4LevelCalculatorPeak* self);
static void g4_level_calculator_peak_free (G4LevelCalculatorPeak* self);
static void _g4_level_calculator_peak_free0_ (gpointer var);
static inline void _g_queue_free__g4_level_calculator_peak_free0_ (GQueue* self);
VALA_EXTERN void g4_level_calculator_clear (G4LevelCalculator* self);
VALA_EXTERN void g4_level_calculator_calculate_sample (G4LevelCalculator* self,
                                           GstSample* sample,
                                           GstClockTime position,
                                           gdouble* peak_value);
static gboolean g4_level_calculator_calculate_peak_in_sample (G4LevelCalculator* self,
                                                       GstSample* sample,
                                                       gdouble* peak);
static gboolean* _bool_dup (gboolean* self);
VALA_EXTERN void g4_level_calculate_int (guint8* data,
                             guint num,
                             guint channels,
                             guint value_size,
                             guint sample_size,
                             gdouble* nps);
static void _g4_level_calculate_int_g4_level_calculator_level_calculate_func (guint8* data,
                                                                       guint num,
                                                                       guint channels,
                                                                       guint value_size,
                                                                       guint sample_size,
                                                                       gdouble* nps,
                                                                       gpointer self);
VALA_EXTERN void g4_level_calculate_int16 (guint8* data,
                               guint num,
                               guint channels,
                               guint value_size,
                               guint sample_size,
                               gdouble* nps);
static void _g4_level_calculate_int16_g4_level_calculator_level_calculate_func (guint8* data,
                                                                         guint num,
                                                                         guint channels,
                                                                         guint value_size,
                                                                         guint sample_size,
                                                                         gdouble* nps,
                                                                         gpointer self);
VALA_EXTERN void g4_level_calculate_float (guint8* data,
                               guint num,
                               guint channels,
                               guint value_size,
                               guint sample_size,
                               gdouble* nps);
static void _g4_level_calculate_float_g4_level_calculator_level_calculate_func (guint8* data,
                                                                         guint num,
                                                                         guint channels,
                                                                         guint value_size,
                                                                         guint sample_size,
                                                                         gdouble* nps,
                                                                         gpointer self);
VALA_EXTERN void g4_level_calculate_double (guint8* data,
                                guint num,
                                guint channels,
                                guint value_size,
                                guint sample_size,
                                gdouble* nps);
static void _g4_level_calculate_double_g4_level_calculator_level_calculate_func (guint8* data,
                                                                          guint num,
                                                                          guint channels,
                                                                          guint value_size,
                                                                          guint sample_size,
                                                                          gdouble* nps,
                                                                          gpointer self);
static gsize* _size_t_dup (gsize* self);
static GstMapInfo* _gst_map_info_dup (GstMapInfo* self);
VALA_EXTERN G4LevelCalculator* g4_level_calculator_new (void);
VALA_EXTERN G4LevelCalculator* g4_level_calculator_construct (GType object_type);
static void g4_level_calculator_finalize (G4LevelCalculator * obj);
static GType g4_level_calculator_get_type_once (void);

static inline gpointer
g4_level_calculator_get_instance_private (G4LevelCalculator* self)
{
	return G_STRUCT_MEMBER_P (self, G4LevelCalculator_private_offset);
}

static void
_g4_level_calculator_peak_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g4_level_calculator_peak_free (var), NULL));
}

static inline void
_g_queue_free__g4_level_calculator_peak_free0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g4_level_calculator_peak_free0_);
}

void
g4_level_calculator_clear (G4LevelCalculator* self)
{
	GQueue* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_last_sample_time = GST_CLOCK_TIME_NONE;
	_tmp0_ = self->priv->_peaks;
	g_queue_clear (_tmp0_);
}

static gpointer
_g4_level_calculator_peak_dup0 (gpointer self)
{
	return self ? g4_level_calculator_peak_dup (self) : NULL;
}

void
g4_level_calculator_calculate_sample (G4LevelCalculator* self,
                                      GstSample* sample,
                                      GstClockTime position,
                                      gdouble* peak_value)
{
	G4LevelCalculatorPeak peak = {0};
	GstSegment* _tmp0_;
	gboolean _tmp1_ = FALSE;
	G4LevelCalculatorPeak _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sample != NULL);
	memset (&peak, 0, sizeof (G4LevelCalculatorPeak));
	_tmp0_ = gst_sample_get_segment (sample);
	peak.time = (GstClockTime) _tmp0_->position;
	_tmp2_ = peak;
	if (self->priv->_last_sample_time != _tmp2_.time) {
		gdouble _tmp3_ = 0.0;
		gboolean _tmp4_;
		_tmp4_ = g4_level_calculator_calculate_peak_in_sample (self, sample, &_tmp3_);
		peak.peak = _tmp3_;
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GQueue* _tmp5_;
		G4LevelCalculatorPeak _tmp6_;
		G4LevelCalculatorPeak* _tmp7_;
		G4LevelCalculatorPeak _tmp8_;
		_tmp5_ = self->priv->_peaks;
		_tmp6_ = peak;
		_tmp7_ = _g4_level_calculator_peak_dup0 (&_tmp6_);
		g_queue_push_tail (_tmp5_, _tmp7_);
		_tmp8_ = peak;
		self->priv->_last_sample_time = _tmp8_.time;
	}
	while (TRUE) {
		GQueue* _tmp9_;
		G4LevelCalculatorPeak p = {0};
		GQueue* _tmp10_;
		gconstpointer _tmp11_;
		G4LevelCalculatorPeak _tmp12_;
		_tmp9_ = self->priv->_peaks;
		if (!(_tmp9_->length > ((guint) 0))) {
			break;
		}
		_tmp10_ = self->priv->_peaks;
		_tmp11_ = g_queue_peek_head (_tmp10_);
		p = (G4LevelCalculatorPeak) (*((G4LevelCalculatorPeak*) _tmp11_));
		_tmp12_ = p;
		if (_tmp12_.time >= position) {
			G4LevelCalculatorPeak _tmp13_;
			GQueue* _tmp14_;
			gpointer _tmp15_;
			G4LevelCalculatorPeak* _tmp16_;
			_tmp13_ = p;
			*peak_value = _tmp13_.peak;
			_tmp14_ = self->priv->_peaks;
			_tmp15_ = g_queue_pop_head (_tmp14_);
			_tmp16_ = (G4LevelCalculatorPeak*) _tmp15_;
			_g4_level_calculator_peak_free0 (_tmp16_);
		} else {
			break;
		}
	}
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static void
_g4_level_calculate_int_g4_level_calculator_level_calculate_func (guint8* data,
                                                                  guint num,
                                                                  guint channels,
                                                                  guint value_size,
                                                                  guint sample_size,
                                                                  gdouble* nps,
                                                                  gpointer self)
{
	g4_level_calculate_int (data, num, channels, value_size, sample_size, nps);
}

static void
_g4_level_calculate_int16_g4_level_calculator_level_calculate_func (guint8* data,
                                                                    guint num,
                                                                    guint channels,
                                                                    guint value_size,
                                                                    guint sample_size,
                                                                    gdouble* nps,
                                                                    gpointer self)
{
	g4_level_calculate_int16 (data, num, channels, value_size, sample_size, nps);
}

static void
_g4_level_calculate_float_g4_level_calculator_level_calculate_func (guint8* data,
                                                                    guint num,
                                                                    guint channels,
                                                                    guint value_size,
                                                                    guint sample_size,
                                                                    gdouble* nps,
                                                                    gpointer self)
{
	g4_level_calculate_float (data, num, channels, value_size, sample_size, nps);
}

static void
_g4_level_calculate_double_g4_level_calculator_level_calculate_func (guint8* data,
                                                                     guint num,
                                                                     guint channels,
                                                                     guint value_size,
                                                                     guint sample_size,
                                                                     gdouble* nps,
                                                                     gpointer self)
{
	g4_level_calculate_double (data, num, channels, value_size, sample_size, nps);
}

static gpointer
_gst_buffer_ref0 (gpointer self)
{
	return self ? gst_buffer_ref (self) : NULL;
}

static gsize*
_size_t_dup (gsize* self)
{
	gsize* dup;
	dup = g_new0 (gsize, 1);
	memcpy (dup, self, sizeof (gsize));
	return dup;
}

static gpointer
__size_t_dup0 (gpointer self)
{
	return self ? _size_t_dup (self) : NULL;
}

static GstMapInfo*
_gst_map_info_dup (GstMapInfo* self)
{
	GstMapInfo* dup;
	dup = g_new0 (GstMapInfo, 1);
	memcpy (dup, self, sizeof (GstMapInfo));
	return dup;
}

static gpointer
__gst_map_info_dup0 (gpointer self)
{
	return self ? _gst_map_info_dup (self) : NULL;
}

static gboolean
g4_level_calculator_calculate_peak_in_sample (G4LevelCalculator* self,
                                              GstSample* sample,
                                              gdouble* peak)
{
	gdouble _vala_peak = 0.0;
	GstCaps* caps = NULL;
	GstCaps* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GstCaps* _tmp2_;
	GstCaps* _tmp3_;
	gint channels = 0;
	gint bps = 0;
	gint sample_size = 0;
	gint block_size = 0;
	GstBuffer* buffer = NULL;
	GstBuffer* _tmp26_;
	GstBuffer* _tmp27_;
	GstBuffer* _tmp28_ = NULL;
	GstBuffer* _tmp29_;
	gsize* _tmp30_ = NULL;
	gsize* _tmp33_ = NULL;
	gsize* _tmp34_;
	gsize size = 0UL;
	gsize* _tmp37_;
	gsize _tmp38_;
	GstMapInfo* map_info = NULL;
	GstBuffer* _tmp39_ = NULL;
	GstBuffer* _tmp40_;
	gboolean* _tmp41_ = NULL;
	gboolean* _tmp47_ = NULL;
	gboolean* _tmp48_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sample != NULL, FALSE);
	_vala_peak = (gdouble) 0;
	_tmp0_ = gst_sample_get_caps (sample);
	caps = _tmp0_;
	_tmp2_ = self->priv->_last_caps;
	_tmp3_ = caps;
	if (_tmp2_ != _tmp3_) {
		_tmp1_ = TRUE;
	} else {
		G4LevelCalculatorLevelCalculateFunc _tmp4_;
		gpointer _tmp4__target;
		_tmp4_ = self->priv->_level_calculate;
		_tmp4__target = self->priv->_level_calculate_target;
		_tmp1_ = _tmp4_ == NULL;
	}
	if (_tmp1_) {
		GstCaps* _tmp5_ = NULL;
		GstCaps* _tmp6_;
		GstStructure* _tmp7_ = NULL;
		GstStructure* st = NULL;
		GstStructure* _tmp9_ = NULL;
		GstStructure* _tmp10_;
		gboolean* _tmp11_ = NULL;
		GstStructure* _tmp15_ = NULL;
		GstStructure* _tmp16_;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* format = NULL;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		GQuark _tmp23_ = 0U;
		static GQuark _tmp22_label0 = 0;
		static GQuark _tmp22_label1 = 0;
		static GQuark _tmp22_label2 = 0;
		static GQuark _tmp22_label3 = 0;
		static GQuark _tmp22_label4 = 0;
		static GQuark _tmp22_label5 = 0;
		static GQuark _tmp22_label6 = 0;
		GstCaps* _tmp25_;
		_tmp6_ = caps;
		_tmp5_ = _tmp6_;
		_tmp7_ = NULL;
		if (_tmp5_ != NULL) {
			GstStructure* _tmp8_;
			_tmp8_ = gst_caps_get_structure ((GstCaps*) _tmp5_, (guint) 0);
			_tmp7_ = _tmp8_;
		}
		st = _tmp7_;
		_tmp10_ = st;
		_tmp9_ = _tmp10_;
		_tmp11_ = NULL;
		if (_tmp9_ != NULL) {
			gint _tmp12_ = 0;
			gboolean _tmp13_;
			gboolean* _tmp14_;
			_tmp13_ = gst_structure_get_int ((GstStructure*) _tmp9_, "channels", &_tmp12_);
			self->priv->_audio_channels = _tmp12_;
			_tmp14_ = __bool_dup0 (&_tmp13_);
			_g_free0 (_tmp11_);
			_tmp11_ = _tmp14_;
		}
		if (self->priv->_audio_channels == 0) {
			result = FALSE;
			_g_free0 (_tmp11_);
			if (peak) {
				*peak = _vala_peak;
			}
			return result;
		}
		_tmp16_ = st;
		_tmp15_ = _tmp16_;
		_tmp17_ = NULL;
		if (_tmp15_ != NULL) {
			const gchar* _tmp18_;
			_tmp18_ = gst_structure_get_string ((GstStructure*) _tmp15_, "format");
			_tmp17_ = _tmp18_;
		}
		_tmp19_ = _tmp17_;
		if (_tmp19_ == NULL) {
			_tmp19_ = "";
		}
		format = (const gchar*) _tmp19_;
		_tmp20_ = format;
		_tmp21_ = _tmp20_;
		_tmp23_ = (NULL == _tmp21_) ? 0 : g_quark_from_string (_tmp21_);
		if (_tmp23_ == ((0 != _tmp22_label0) ? _tmp22_label0 : (_tmp22_label0 = g_quark_from_static_string ("S8")))) {
			switch (0) {
				default:
				{
					self->priv->_sample_bps = 1;
					self->priv->_audio_bps = self->priv->_sample_bps;
					(self->priv->_level_calculate_target_destroy_notify == NULL) ? NULL : (self->priv->_level_calculate_target_destroy_notify (self->priv->_level_calculate_target), NULL);
					self->priv->_level_calculate = NULL;
					self->priv->_level_calculate_target = NULL;
					self->priv->_level_calculate_target_destroy_notify = NULL;
					self->priv->_level_calculate = _g4_level_calculate_int_g4_level_calculator_level_calculate_func;
					self->priv->_level_calculate_target = NULL;
					self->priv->_level_calculate_target_destroy_notify = NULL;
					break;
				}
			}
		} else if (_tmp23_ == ((0 != _tmp22_label1) ? _tmp22_label1 : (_tmp22_label1 = g_quark_from_static_string ("S16LE")))) {
			switch (0) {
				default:
				{
					self->priv->_sample_bps = 2;
					self->priv->_audio_bps = self->priv->_sample_bps;
					(self->priv->_level_calculate_target_destroy_notify == NULL) ? NULL : (self->priv->_level_calculate_target_destroy_notify (self->priv->_level_calculate_target), NULL);
					self->priv->_level_calculate = NULL;
					self->priv->_level_calculate_target = NULL;
					self->priv->_level_calculate_target_destroy_notify = NULL;
					self->priv->_level_calculate = _g4_level_calculate_int16_g4_level_calculator_level_calculate_func;
					self->priv->_level_calculate_target = NULL;
					self->priv->_level_calculate_target_destroy_notify = NULL;
					break;
				}
			}
		} else if (_tmp23_ == ((0 != _tmp22_label2) ? _tmp22_label2 : (_tmp22_label2 = g_quark_from_static_string ("S24LE")))) {
			switch (0) {
				default:
				{
					self->priv->_sample_bps = 3;
					self->priv->_audio_bps = self->priv->_sample_bps;
					(self->priv->_level_calculate_target_destroy_notify == NULL) ? NULL : (self->priv->_level_calculate_target_destroy_notify (self->priv->_level_calculate_target), NULL);
					self->priv->_level_calculate = NULL;
					self->priv->_level_calculate_target = NULL;
					self->priv->_level_calculate_target_destroy_notify = NULL;
					self->priv->_level_calculate = _g4_level_calculate_int_g4_level_calculator_level_calculate_func;
					self->priv->_level_calculate_target = NULL;
					self->priv->_level_calculate_target_destroy_notify = NULL;
					break;
				}
			}
		} else if (_tmp23_ == ((0 != _tmp22_label3) ? _tmp22_label3 : (_tmp22_label3 = g_quark_from_static_string ("S24_32LE")))) {
			switch (0) {
				default:
				{
					self->priv->_audio_bps = 3;
					self->priv->_sample_bps = 4;
					(self->priv->_level_calculate_target_destroy_notify == NULL) ? NULL : (self->priv->_level_calculate_target_destroy_notify (self->priv->_level_calculate_target), NULL);
					self->priv->_level_calculate = NULL;
					self->priv->_level_calculate_target = NULL;
					self->priv->_level_calculate_target_destroy_notify = NULL;
					self->priv->_level_calculate = _g4_level_calculate_int_g4_level_calculator_level_calculate_func;
					self->priv->_level_calculate_target = NULL;
					self->priv->_level_calculate_target_destroy_notify = NULL;
					break;
				}
			}
		} else if (_tmp23_ == ((0 != _tmp22_label4) ? _tmp22_label4 : (_tmp22_label4 = g_quark_from_static_string ("S32LE")))) {
			switch (0) {
				default:
				{
					self->priv->_sample_bps = 4;
					self->priv->_audio_bps = self->priv->_sample_bps;
					(self->priv->_level_calculate_target_destroy_notify == NULL) ? NULL : (self->priv->_level_calculate_target_destroy_notify (self->priv->_level_calculate_target), NULL);
					self->priv->_level_calculate = NULL;
					self->priv->_level_calculate_target = NULL;
					self->priv->_level_calculate_target_destroy_notify = NULL;
					self->priv->_level_calculate = _g4_level_calculate_int_g4_level_calculator_level_calculate_func;
					self->priv->_level_calculate_target = NULL;
					self->priv->_level_calculate_target_destroy_notify = NULL;
					break;
				}
			}
		} else if (_tmp23_ == ((0 != _tmp22_label5) ? _tmp22_label5 : (_tmp22_label5 = g_quark_from_static_string ("F32LE")))) {
			switch (0) {
				default:
				{
					self->priv->_sample_bps = 4;
					self->priv->_audio_bps = self->priv->_sample_bps;
					(self->priv->_level_calculate_target_destroy_notify == NULL) ? NULL : (self->priv->_level_calculate_target_destroy_notify (self->priv->_level_calculate_target), NULL);
					self->priv->_level_calculate = NULL;
					self->priv->_level_calculate_target = NULL;
					self->priv->_level_calculate_target_destroy_notify = NULL;
					self->priv->_level_calculate = _g4_level_calculate_float_g4_level_calculator_level_calculate_func;
					self->priv->_level_calculate_target = NULL;
					self->priv->_level_calculate_target_destroy_notify = NULL;
					break;
				}
			}
		} else if (_tmp23_ == ((0 != _tmp22_label6) ? _tmp22_label6 : (_tmp22_label6 = g_quark_from_static_string ("F64LE")))) {
			switch (0) {
				default:
				{
					self->priv->_sample_bps = 8;
					self->priv->_audio_bps = self->priv->_sample_bps;
					(self->priv->_level_calculate_target_destroy_notify == NULL) ? NULL : (self->priv->_level_calculate_target_destroy_notify (self->priv->_level_calculate_target), NULL);
					self->priv->_level_calculate = NULL;
					self->priv->_level_calculate_target = NULL;
					self->priv->_level_calculate_target_destroy_notify = NULL;
					self->priv->_level_calculate = _g4_level_calculate_double_g4_level_calculator_level_calculate_func;
					self->priv->_level_calculate_target = NULL;
					self->priv->_level_calculate_target_destroy_notify = NULL;
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					const gchar* _tmp24_;
					_tmp24_ = format;
					g_print ("Unsupported sample format: %s\n", _tmp24_);
					result = FALSE;
					_g_free0 (_tmp11_);
					if (peak) {
						*peak = _vala_peak;
					}
					return result;
				}
			}
		}
		_tmp25_ = caps;
		self->priv->_last_caps = _tmp25_;
		_g_free0 (_tmp11_);
	}
	channels = self->priv->_audio_channels;
	bps = self->priv->_audio_bps;
	sample_size = self->priv->_sample_bps;
	block_size = channels * sample_size;
	_tmp26_ = gst_sample_get_buffer (sample);
	_tmp27_ = _gst_buffer_ref0 (_tmp26_);
	buffer = _tmp27_;
	_tmp29_ = buffer;
	_tmp28_ = _tmp29_;
	_tmp30_ = NULL;
	if (_tmp28_ != NULL) {
		gsize _tmp31_;
		gsize* _tmp32_;
		_tmp31_ = gst_buffer_get_size ((GstBuffer*) _tmp28_);
		_tmp32_ = __size_t_dup0 (&_tmp31_);
		_g_free0 (_tmp30_);
		_tmp30_ = _tmp32_;
	}
	_tmp34_ = _tmp30_;
	_tmp30_ = NULL;
	_tmp33_ = _tmp34_;
	if (_tmp33_ == NULL) {
		gsize _tmp35_;
		gsize* _tmp36_;
		_tmp35_ = (gsize) 0;
		_tmp36_ = __size_t_dup0 (&_tmp35_);
		_g_free0 (_tmp33_);
		_tmp33_ = _tmp36_;
	}
	_tmp37_ = _tmp33_;
	_tmp33_ = NULL;
	_tmp38_ = (gsize) (*_tmp37_);
	_g_free0 (_tmp37_);
	size = _tmp38_;
	map_info = NULL;
	_tmp40_ = buffer;
	_tmp39_ = _tmp40_;
	_tmp41_ = NULL;
	if (_tmp39_ != NULL) {
		GstMapInfo _tmp42_ = {0};
		gboolean _tmp43_;
		GstMapInfo _tmp44_;
		GstMapInfo* _tmp45_;
		gboolean* _tmp46_;
		_tmp43_ = gst_buffer_map ((GstBuffer*) _tmp39_, &_tmp42_, GST_MAP_READ);
		_g_free0 (map_info);
		_tmp44_ = _tmp42_;
		_tmp45_ = __gst_map_info_dup0 (&_tmp44_);
		map_info = _tmp45_;
		_tmp46_ = __bool_dup0 (&_tmp43_);
		_g_free0 (_tmp41_);
		_tmp41_ = _tmp46_;
	}
	_tmp48_ = __bool_dup0 (_tmp41_);
	_tmp47_ = _tmp48_;
	if (_tmp47_ == NULL) {
		gboolean _tmp49_;
		gboolean* _tmp50_;
		_tmp49_ = FALSE;
		_tmp50_ = __bool_dup0 (&_tmp49_);
		_g_free0 (_tmp47_);
		_tmp47_ = _tmp50_;
	}
	if ((gboolean) (*_tmp47_)) {
		guint8* p = NULL;
		GstMapInfo* _tmp51_;
		guint8* _tmp52_;
		gint _tmp52__length1;
		guint num = 0U;
		gdouble total_nps = 0.0;
		GstBuffer* _tmp58_ = NULL;
		GstBuffer* _tmp59_;
		_tmp51_ = map_info;
		_tmp52_ = ((GstMapInfo) (*_tmp51_)).data;
		_tmp52__length1 = ((GstMapInfo) (*_tmp51_)).size;
		p = _tmp52_;
		num = (guint) (size / block_size);
		total_nps = (gdouble) 0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp53_ = FALSE;
				_tmp53_ = TRUE;
				while (TRUE) {
					gdouble nps = 0.0;
					G4LevelCalculatorLevelCalculateFunc _tmp55_;
					gpointer _tmp55__target;
					guint8* _tmp56_;
					gdouble _tmp57_ = 0.0;
					if (!_tmp53_) {
						gint _tmp54_;
						_tmp54_ = i;
						i = _tmp54_ + 1;
					}
					_tmp53_ = FALSE;
					if (!(i < channels)) {
						break;
					}
					nps = (gdouble) 0;
					_tmp55_ = self->priv->_level_calculate;
					_tmp55__target = self->priv->_level_calculate_target;
					_tmp56_ = p;
					_tmp55_ (_tmp56_ + (sample_size * i), num, (guint) channels, (guint) bps, (guint) sample_size, &_tmp57_, _tmp55__target);
					nps = _tmp57_;
					total_nps += nps;
				}
			}
		}
		_vala_peak = MIN (total_nps / channels, (gdouble) 1);
		_tmp59_ = buffer;
		_tmp58_ = _tmp59_;
		if (_tmp58_ != NULL) {
			GstMapInfo* _tmp60_;
			GstMapInfo _tmp61_;
			_tmp60_ = map_info;
			_tmp61_ = (GstMapInfo) (*_tmp60_);
			gst_buffer_unmap ((GstBuffer*) _tmp58_, &_tmp61_);
		}
		result = TRUE;
		_g_free0 (_tmp47_);
		_g_free0 (_tmp41_);
		_g_free0 (map_info);
		_g_free0 (_tmp33_);
		_g_free0 (_tmp30_);
		_gst_buffer_unref0 (buffer);
		if (peak) {
			*peak = _vala_peak;
		}
		return result;
	}
	result = FALSE;
	_g_free0 (_tmp47_);
	_g_free0 (_tmp41_);
	_g_free0 (map_info);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp30_);
	_gst_buffer_unref0 (buffer);
	if (peak) {
		*peak = _vala_peak;
	}
	return result;
}

G4LevelCalculator*
g4_level_calculator_construct (GType object_type)
{
	G4LevelCalculator* self = NULL;
	self = (G4LevelCalculator*) g_type_create_instance (object_type);
	return self;
}

G4LevelCalculator*
g4_level_calculator_new (void)
{
	return g4_level_calculator_construct (G4_TYPE_LEVEL_CALCULATOR);
}

static G4LevelCalculatorPeak*
g4_level_calculator_peak_dup (const G4LevelCalculatorPeak* self)
{
	G4LevelCalculatorPeak* dup;
	dup = g_new0 (G4LevelCalculatorPeak, 1);
	memcpy (dup, self, sizeof (G4LevelCalculatorPeak));
	return dup;
}

static void
g4_level_calculator_peak_free (G4LevelCalculatorPeak* self)
{
	g_free (self);
}

static GType
g4_level_calculator_peak_get_type_once (void)
{
	GType g4_level_calculator_peak_type_id;
	g4_level_calculator_peak_type_id = g_boxed_type_register_static ("G4LevelCalculatorPeak", (GBoxedCopyFunc) g4_level_calculator_peak_dup, (GBoxedFreeFunc) g4_level_calculator_peak_free);
	return g4_level_calculator_peak_type_id;
}

static GType
g4_level_calculator_peak_get_type (void)
{
	static volatile gsize g4_level_calculator_peak_type_id__once = 0;
	if (g_once_init_enter (&g4_level_calculator_peak_type_id__once)) {
		GType g4_level_calculator_peak_type_id;
		g4_level_calculator_peak_type_id = g4_level_calculator_peak_get_type_once ();
		g_once_init_leave (&g4_level_calculator_peak_type_id__once, g4_level_calculator_peak_type_id);
	}
	return g4_level_calculator_peak_type_id__once;
}

static void
g4_value_level_calculator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
g4_value_level_calculator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		g4_level_calculator_unref (value->data[0].v_pointer);
	}
}

static void
g4_value_level_calculator_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = g4_level_calculator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
g4_value_level_calculator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
g4_value_level_calculator_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		G4LevelCalculator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = g4_level_calculator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
g4_value_level_calculator_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	G4LevelCalculator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = g4_level_calculator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
g4_param_spec_level_calculator (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	G4ParamSpecLevelCalculator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, G4_TYPE_LEVEL_CALCULATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
g4_value_get_level_calculator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, G4_TYPE_LEVEL_CALCULATOR), NULL);
	return value->data[0].v_pointer;
}

void
g4_value_set_level_calculator (GValue* value,
                               gpointer v_object)
{
	G4LevelCalculator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, G4_TYPE_LEVEL_CALCULATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, G4_TYPE_LEVEL_CALCULATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		g4_level_calculator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		g4_level_calculator_unref (old);
	}
}

void
g4_value_take_level_calculator (GValue* value,
                                gpointer v_object)
{
	G4LevelCalculator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, G4_TYPE_LEVEL_CALCULATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, G4_TYPE_LEVEL_CALCULATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		g4_level_calculator_unref (old);
	}
}

static void
g4_level_calculator_class_init (G4LevelCalculatorClass * klass,
                                gpointer klass_data)
{
	g4_level_calculator_parent_class = g_type_class_peek_parent (klass);
	((G4LevelCalculatorClass *) klass)->finalize = g4_level_calculator_finalize;
	g_type_class_adjust_private_offset (klass, &G4LevelCalculator_private_offset);
}

static void
g4_level_calculator_instance_init (G4LevelCalculator * self,
                                   gpointer klass)
{
	GQueue* _tmp0_;
	self->priv = g4_level_calculator_get_instance_private (self);
	self->priv->_audio_channels = 2;
	self->priv->_audio_bps = 2;
	self->priv->_sample_bps = 2;
	self->priv->_last_caps = NULL;
	self->priv->_last_sample_time = GST_CLOCK_TIME_NONE;
	self->priv->_level_calculate = NULL;
	self->priv->_level_calculate_target = NULL;
	self->priv->_level_calculate_target_destroy_notify = NULL;
	_tmp0_ = g_queue_new ();
	self->priv->_peaks = _tmp0_;
	self->ref_count = 1;
}

static void
g4_level_calculator_finalize (G4LevelCalculator * obj)
{
	G4LevelCalculator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_TYPE_LEVEL_CALCULATOR, G4LevelCalculator);
	g_signal_handlers_destroy (self);
	(self->priv->_level_calculate_target_destroy_notify == NULL) ? NULL : (self->priv->_level_calculate_target_destroy_notify (self->priv->_level_calculate_target), NULL);
	self->priv->_level_calculate = NULL;
	self->priv->_level_calculate_target = NULL;
	self->priv->_level_calculate_target_destroy_notify = NULL;
	(self->priv->_peaks == NULL) ? NULL : (self->priv->_peaks = (_g_queue_free__g4_level_calculator_peak_free0_ (self->priv->_peaks), NULL));
}

static GType
g4_level_calculator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { g4_value_level_calculator_init, g4_value_level_calculator_free_value, g4_value_level_calculator_copy_value, g4_value_level_calculator_peek_pointer, "p", g4_value_level_calculator_collect_value, "p", g4_value_level_calculator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (G4LevelCalculatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_level_calculator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (G4LevelCalculator), 0, (GInstanceInitFunc) g4_level_calculator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType g4_level_calculator_type_id;
	g4_level_calculator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "G4LevelCalculator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	G4LevelCalculator_private_offset = g_type_add_instance_private (g4_level_calculator_type_id, sizeof (G4LevelCalculatorPrivate));
	return g4_level_calculator_type_id;
}

GType
g4_level_calculator_get_type (void)
{
	static volatile gsize g4_level_calculator_type_id__once = 0;
	if (g_once_init_enter (&g4_level_calculator_type_id__once)) {
		GType g4_level_calculator_type_id;
		g4_level_calculator_type_id = g4_level_calculator_get_type_once ();
		g_once_init_leave (&g4_level_calculator_type_id__once, g4_level_calculator_type_id);
	}
	return g4_level_calculator_type_id__once;
}

gpointer
g4_level_calculator_ref (gpointer instance)
{
	G4LevelCalculator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
g4_level_calculator_unref (gpointer instance)
{
	G4LevelCalculator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		G4_LEVEL_CALCULATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

void
g4_level_calculate_double (guint8* data,
                           guint num,
                           guint channels,
                           guint value_size,
                           guint sample_size,
                           gdouble* nps)
{
	gdouble _vala_nps = 0.0;
	gdouble peak = 0.0;
	gdouble* p = NULL;
	peak = (gdouble) 0;
	p = (gdouble*) data;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gdouble _tmp1_ = 0.0;
				gdouble* _tmp2_;
				gdouble _tmp3_;
				gdouble value = 0.0;
				if (!_tmp0_) {
					i += channels;
				}
				_tmp0_ = FALSE;
				if (!(i < num)) {
					break;
				}
				_tmp2_ = p;
				_tmp3_ = _tmp2_[i];
				if (_tmp3_ >= ((gdouble) 0)) {
					gdouble* _tmp4_;
					gdouble _tmp5_;
					_tmp4_ = p;
					_tmp5_ = _tmp4_[i];
					_tmp1_ = _tmp5_;
				} else {
					gdouble* _tmp6_;
					gdouble _tmp7_;
					_tmp6_ = p;
					_tmp7_ = _tmp6_[i];
					_tmp1_ = -_tmp7_;
				}
				value = _tmp1_;
				if (peak < value) {
					peak = value;
				}
			}
		}
	}
	_vala_nps = peak * peak;
	if (nps) {
		*nps = _vala_nps;
	}
}

void
g4_level_calculate_float (guint8* data,
                          guint num,
                          guint channels,
                          guint value_size,
                          guint sample_size,
                          gdouble* nps)
{
	gdouble _vala_nps = 0.0;
	gfloat peak = 0.0F;
	gfloat* p = NULL;
	peak = 0.f;
	p = (gfloat*) data;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gfloat _tmp1_ = 0.0F;
				gfloat* _tmp2_;
				gfloat _tmp3_;
				gfloat value = 0.0F;
				if (!_tmp0_) {
					i += channels;
				}
				_tmp0_ = FALSE;
				if (!(i < num)) {
					break;
				}
				_tmp2_ = p;
				_tmp3_ = _tmp2_[i];
				if (_tmp3_ >= ((gfloat) 0)) {
					gfloat* _tmp4_;
					gfloat _tmp5_;
					_tmp4_ = p;
					_tmp5_ = _tmp4_[i];
					_tmp1_ = _tmp5_;
				} else {
					gfloat* _tmp6_;
					gfloat _tmp7_;
					_tmp6_ = p;
					_tmp7_ = _tmp6_[i];
					_tmp1_ = -_tmp7_;
				}
				value = _tmp1_;
				if (peak < value) {
					peak = value;
				}
			}
		}
	}
	_vala_nps = ((gdouble) peak) * peak;
	if (nps) {
		*nps = _vala_nps;
	}
}

void
g4_level_calculate_int16 (guint8* data,
                          guint num,
                          guint channels,
                          guint value_size,
                          guint sample_size,
                          gdouble* nps)
{
	gdouble _vala_nps = 0.0;
	gint16 peak = 0;
	gint16* p = NULL;
	peak = (gint16) 0;
	p = (gint16*) data;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint16 _tmp1_ = 0;
				gint16* _tmp2_;
				gint16 _tmp3_;
				gint16 value = 0;
				if (!_tmp0_) {
					i += channels;
				}
				_tmp0_ = FALSE;
				if (!(i < num)) {
					break;
				}
				_tmp2_ = p;
				_tmp3_ = _tmp2_[i];
				if (((gint) _tmp3_) >= 0) {
					gint16* _tmp4_;
					gint16 _tmp5_;
					_tmp4_ = p;
					_tmp5_ = _tmp4_[i];
					_tmp1_ = _tmp5_;
				} else {
					gint16* _tmp6_;
					gint16 _tmp7_;
					_tmp6_ = p;
					_tmp7_ = _tmp6_[i];
					_tmp1_ = -_tmp7_;
				}
				value = _tmp1_;
				if (peak < value) {
					peak = value;
				}
			}
		}
	}
	_vala_nps = (((gdouble) peak) * peak) / (((gint64) 1) << (15 * 2));
	if (nps) {
		*nps = _vala_nps;
	}
}

void
g4_level_calculate_int (guint8* data,
                        guint num,
                        guint channels,
                        guint value_size,
                        guint sample_size,
                        gdouble* nps)
{
	gdouble _vala_nps = 0.0;
	gint32 peak = 0;
	guint block_size = 0U;
	peak = (gint32) 0;
	block_size = channels * sample_size;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint32 value = 0;
				guint8* p = NULL;
				gint32 _tmp5_ = 0;
				if (!_tmp0_) {
					i += channels;
				}
				_tmp0_ = FALSE;
				if (!(i < num)) {
					break;
				}
				value = (gint32) 0;
				p = ((guint8*) (&value)) + (4 - value_size);
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp1_ = FALSE;
						_tmp1_ = TRUE;
						while (TRUE) {
							guint8* _tmp3_;
							guint8 _tmp4_;
							if (!_tmp1_) {
								guint _tmp2_;
								_tmp2_ = j;
								j = _tmp2_ + 1;
							}
							_tmp1_ = FALSE;
							if (!(j < value_size)) {
								break;
							}
							_tmp3_ = p;
							_tmp4_ = data[j];
							_tmp3_[j] = _tmp4_;
						}
					}
				}
				data = data + block_size;
				if (value >= ((gint32) 0)) {
					_tmp5_ = value;
				} else {
					_tmp5_ = -value;
				}
				value = _tmp5_;
				if (peak < value) {
					peak = value;
				}
			}
		}
	}
	_vala_nps = (((gdouble) peak) * peak) / (((gint64) 1) << (31 * 2));
	if (nps) {
		*nps = _vala_nps;
	}
}

