/* dir-cache.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from dir-cache.vala, do not modify */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <gobject/gvaluecollector.h>

#define G4_CHILD_TYPE_NONE ((guint8) 0)
#define G4_CHILD_TYPE_FOLDER ((guint8) 1)
#define G4_CHILD_TYPE_MUSIC ((guint8) 2)
#define G4_CHILD_TYPE_PLAYLIST ((guint8) 3)
#define G4_CHILD_TYPE_COVER ((guint8) 4)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define G4_TYPE_DIR_CACHE (g4_dir_cache_get_type ())
#define G4_DIR_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_DIR_CACHE, G4DirCache))
#define G4_DIR_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_DIR_CACHE, G4DirCacheClass))
#define G4_IS_DIR_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_DIR_CACHE))
#define G4_IS_DIR_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_DIR_CACHE))
#define G4_DIR_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_DIR_CACHE, G4DirCacheClass))

typedef struct _G4DirCache G4DirCache;
typedef struct _G4DirCacheClass G4DirCacheClass;
typedef struct _G4DirCachePrivate G4DirCachePrivate;

#define G4_DIR_CACHE_TYPE_CHILD_INFO (g4_dir_cache_child_info_get_type ())
#define G4_DIR_CACHE_CHILD_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_DIR_CACHE_TYPE_CHILD_INFO, G4DirCacheChildInfo))
#define G4_DIR_CACHE_CHILD_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_DIR_CACHE_TYPE_CHILD_INFO, G4DirCacheChildInfoClass))
#define G4_DIR_CACHE_IS_CHILD_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_DIR_CACHE_TYPE_CHILD_INFO))
#define G4_DIR_CACHE_IS_CHILD_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_DIR_CACHE_TYPE_CHILD_INFO))
#define G4_DIR_CACHE_CHILD_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_DIR_CACHE_TYPE_CHILD_INFO, G4DirCacheChildInfoClass))

typedef struct _G4DirCacheChildInfo G4DirCacheChildInfo;
typedef struct _G4DirCacheChildInfoClass G4DirCacheChildInfoClass;
enum  {
	G4_DIR_CACHE_0_PROPERTY,
	G4_DIR_CACHE_DIR_PROPERTY,
	G4_DIR_CACHE_NUM_PROPERTIES
};
static GParamSpec* g4_dir_cache_properties[G4_DIR_CACHE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g4_dir_cache_child_info_unref0(var) ((var == NULL) ? NULL : (var = (g4_dir_cache_child_info_unref (var), NULL)))

#define G4_TYPE_MUSIC (g4_music_get_type ())
#define G4_MUSIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_MUSIC, G4Music))
#define G4_MUSIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_MUSIC, G4MusicClass))
#define G4_IS_MUSIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_MUSIC))
#define G4_IS_MUSIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_MUSIC))
#define G4_MUSIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_MUSIC, G4MusicClass))

typedef struct _G4Music G4Music;
typedef struct _G4MusicClass G4MusicClass;

#define G4_TYPE_DATA_INPUT_BYTES (g4_data_input_bytes_get_type ())
#define G4_DATA_INPUT_BYTES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_DATA_INPUT_BYTES, G4DataInputBytes))
#define G4_DATA_INPUT_BYTES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_DATA_INPUT_BYTES, G4DataInputBytesClass))
#define G4_IS_DATA_INPUT_BYTES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_DATA_INPUT_BYTES))
#define G4_IS_DATA_INPUT_BYTES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_DATA_INPUT_BYTES))
#define G4_DATA_INPUT_BYTES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_DATA_INPUT_BYTES, G4DataInputBytesClass))

typedef struct _G4DataInputBytes G4DataInputBytes;
typedef struct _G4DataInputBytesClass G4DataInputBytesClass;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define G4_TYPE_DATA_OUTPUT_BYTES (g4_data_output_bytes_get_type ())
#define G4_DATA_OUTPUT_BYTES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_DATA_OUTPUT_BYTES, G4DataOutputBytes))
#define G4_DATA_OUTPUT_BYTES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_DATA_OUTPUT_BYTES, G4DataOutputBytesClass))
#define G4_IS_DATA_OUTPUT_BYTES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_DATA_OUTPUT_BYTES))
#define G4_IS_DATA_OUTPUT_BYTES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_DATA_OUTPUT_BYTES))
#define G4_DATA_OUTPUT_BYTES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_DATA_OUTPUT_BYTES, G4DataOutputBytesClass))

typedef struct _G4DataOutputBytes G4DataOutputBytes;
typedef struct _G4DataOutputBytesClass G4DataOutputBytesClass;
typedef struct _G4DirCacheChildInfoPrivate G4DirCacheChildInfoPrivate;
typedef struct _G4DirCacheParamSpecChildInfo G4DirCacheParamSpecChildInfo;

struct _G4DirCache {
	GObject parent_instance;
	G4DirCachePrivate * priv;
};

struct _G4DirCacheClass {
	GObjectClass parent_class;
};

struct _G4DirCachePrivate {
	GFile* _dir;
	GFile* _file;
	gint64 _time;
	GPtrArray* _children;
};

struct _G4DirCacheChildInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	G4DirCacheChildInfoPrivate * priv;
	guint8 type;
	gchar* name;
	gint64 time;
};

struct _G4DirCacheChildInfoClass {
	GTypeClass parent_class;
	void (*finalize) (G4DirCacheChildInfo *self);
};

struct _G4DirCacheParamSpecChildInfo {
	GParamSpec parent_instance;
};

static gint G4DirCache_private_offset;
static gpointer g4_dir_cache_parent_class = NULL;
static guint32 g4_dir_cache_MAGIC;
static guint32 g4_dir_cache_MAGIC = (guint32) 0x44495231;
static gpointer g4_dir_cache_child_info_parent_class = NULL;

VALA_EXTERN GType g4_dir_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4DirCache, g_object_unref)
static gpointer g4_dir_cache_child_info_ref (gpointer instance);
static void g4_dir_cache_child_info_unref (gpointer instance);
static GParamSpec* g4_dir_cache_param_spec_child_info (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags) G_GNUC_UNUSED ;
static void g4_dir_cache_value_set_child_info (GValue* value,
                                        gpointer v_object) G_GNUC_UNUSED ;
static void g4_dir_cache_value_take_child_info (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED ;
static gpointer g4_dir_cache_value_get_child_info (const GValue* value) G_GNUC_UNUSED ;
static GType g4_dir_cache_child_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4DirCacheChildInfo, g4_dir_cache_child_info_unref)
static void _g4_dir_cache_child_info_unref0_ (gpointer var);
VALA_EXTERN G4DirCache* g4_dir_cache_new (GFile* dir,
                              GFileInfo* info);
VALA_EXTERN G4DirCache* g4_dir_cache_construct (GType object_type,
                                    GFile* dir,
                                    GFileInfo* info);
static gint64* _int64_dup (gint64* self);
VALA_EXTERN gboolean g4_dir_cache_check_valid (G4DirCache* self);
VALA_EXTERN void g4_dir_cache_delete (G4DirCache* self);
static void __lambda4_ (G4DirCache* self,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
VALA_EXTERN void g4_dir_cache_add_child (G4DirCache* self,
                             GFileInfo* info,
                             guint8 type);
static G4DirCacheChildInfo* g4_dir_cache_child_info_new (guint8 type,
                                                  const gchar* name,
                                                  gint64 time);
static G4DirCacheChildInfo* g4_dir_cache_child_info_construct (GType object_type,
                                                        guint8 type,
                                                        const gchar* name,
                                                        gint64 time);
VALA_EXTERN GType g4_music_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4Music, g_object_unref)
VALA_EXTERN gboolean g4_dir_cache_load (G4DirCache* self,
                            GQueue* stack,
                            GPtrArray* musics,
                            GPtrArray* playlists,
                            gchar** cover_name);
VALA_EXTERN GType g4_data_input_bytes_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4DataInputBytes, g_object_unref)
VALA_EXTERN G4DataInputBytes* g4_data_input_bytes_new (GBytes* bytes);
VALA_EXTERN G4DataInputBytes* g4_data_input_bytes_construct (GType object_type,
                                                 GBytes* bytes);
VALA_EXTERN guint32 g4_data_input_bytes_read_uint32 (G4DataInputBytes* self,
                                         GError** error);
VALA_EXTERN gchar* g4_data_input_bytes_read_string (G4DataInputBytes* self,
                                        GError** error);
VALA_EXTERN gsize g4_data_input_bytes_read_size (G4DataInputBytes* self,
                                     GError** error);
VALA_EXTERN guint8 g4_data_input_bytes_read_byte (G4DataInputBytes* self,
                                      GError** error);
VALA_EXTERN guint64 g4_data_input_bytes_read_uint64 (G4DataInputBytes* self,
                                         GError** error);
VALA_EXTERN G4Music* g4_music_new (const gchar* uri,
                       const gchar* title,
                       gint64 time);
VALA_EXTERN G4Music* g4_music_construct (GType object_type,
                             const gchar* uri,
                             const gchar* title,
                             gint64 time);
VALA_EXTERN void g4_dir_cache_save (G4DirCache* self);
static gboolean* _bool_dup (gboolean* self);
VALA_EXTERN GType g4_data_output_bytes_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4DataOutputBytes, g_object_unref)
VALA_EXTERN G4DataOutputBytes* g4_data_output_bytes_new (guint reserved_size);
VALA_EXTERN G4DataOutputBytes* g4_data_output_bytes_construct (GType object_type,
                                                   guint reserved_size);
VALA_EXTERN void g4_data_output_bytes_write_uint32 (G4DataOutputBytes* self,
                                        guint32 n);
VALA_EXTERN void g4_data_output_bytes_write_string (G4DataOutputBytes* self,
                                        const gchar* str);
VALA_EXTERN void g4_data_output_bytes_write_size (G4DataOutputBytes* self,
                                      gsize n);
VALA_EXTERN void g4_data_output_bytes_write_byte (G4DataOutputBytes* self,
                                      guint8 n);
VALA_EXTERN void g4_data_output_bytes_write_uint64 (G4DataOutputBytes* self,
                                        guint64 n);
VALA_EXTERN gboolean g4_data_output_bytes_write_to (G4DataOutputBytes* self,
                                        GOutputStream* stream,
                                        GError** error);
VALA_EXTERN GFile* g4_dir_cache_get_dir (G4DirCache* self);
static void g4_dir_cache_child_info_finalize (G4DirCacheChildInfo * obj);
static GType g4_dir_cache_child_info_get_type_once (void);
static void g4_dir_cache_finalize (GObject * obj);
static GType g4_dir_cache_get_type_once (void);
static void _vala_g4_dir_cache_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
g4_dir_cache_get_instance_private (G4DirCache* self)
{
	return G_STRUCT_MEMBER_P (self, G4DirCache_private_offset);
}

static void
_g4_dir_cache_child_info_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g4_dir_cache_child_info_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}

static gpointer
__int64_dup0 (gpointer self)
{
	return self ? _int64_dup (self) : NULL;
}

G4DirCache*
g4_dir_cache_construct (GType object_type,
                        GFile* dir,
                        GFileInfo* info)
{
	G4DirCache * self = NULL;
	GFile* _tmp0_;
	gchar* cache_dir = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* name = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GFile* _tmp9_;
	GFileInfo* _tmp10_ = NULL;
	GDateTime* _tmp11_ = NULL;
	GDateTime* _tmp13_ = NULL;
	gint64* _tmp14_ = NULL;
	gint64* _tmp17_ = NULL;
	gint64* _tmp18_;
	gint64* _tmp21_;
	g_return_val_if_fail (dir != NULL, NULL);
	self = (G4DirCache*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (dir);
	_g_object_unref0 (self->priv->_dir);
	self->priv->_dir = _tmp0_;
	_tmp1_ = g_get_user_cache_dir ();
	_tmp2_ = g_strdup (_tmp1_);
	cache_dir = _tmp2_;
	_tmp3_ = g_file_get_uri (dir);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp4_, (gsize) -1);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	name = _tmp6_;
	_tmp7_ = cache_dir;
	_tmp8_ = name;
	_tmp9_ = g_file_new_build_filename (_tmp7_, APP_ID, "dir-cache", _tmp8_, NULL);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp9_;
	_tmp10_ = info;
	_tmp11_ = NULL;
	if (_tmp10_ != NULL) {
		GDateTime* _tmp12_;
		_tmp12_ = g_file_info_get_modification_date_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_file_info_get_type (), GFileInfo));
		_g_date_time_unref0 (_tmp11_);
		_tmp11_ = _tmp12_;
	}
	_tmp13_ = _tmp11_;
	_tmp14_ = NULL;
	if (_tmp13_ != NULL) {
		gint64 _tmp15_;
		gint64* _tmp16_;
		_tmp15_ = g_date_time_to_unix ((GDateTime*) _tmp13_);
		_tmp16_ = __int64_dup0 (&_tmp15_);
		_g_free0 (_tmp14_);
		_tmp14_ = _tmp16_;
	}
	_tmp18_ = _tmp14_;
	_tmp14_ = NULL;
	_tmp17_ = _tmp18_;
	if (_tmp17_ == NULL) {
		gint64 _tmp19_;
		gint64* _tmp20_;
		_tmp19_ = (gint64) 0;
		_tmp20_ = __int64_dup0 (&_tmp19_);
		_g_free0 (_tmp17_);
		_tmp17_ = _tmp20_;
	}
	_tmp21_ = _tmp17_;
	_tmp17_ = NULL;
	self->priv->_time = (gint64) (*_tmp21_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp14_);
	_g_date_time_unref0 (_tmp11_);
	_g_free0 (name);
	_g_free0 (cache_dir);
	return self;
}

G4DirCache*
g4_dir_cache_new (GFile* dir,
                  GFileInfo* info)
{
	return g4_dir_cache_construct (G4_TYPE_DIR_CACHE, dir, info);
}

gboolean
g4_dir_cache_check_valid (G4DirCache* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GFileInfo* info = NULL;
		GFile* _tmp13_;
		GFileInfo* _tmp14_;
		GDateTime* _tmp15_ = NULL;
		GFileInfo* _tmp16_;
		GDateTime* _tmp17_;
		gint64* _tmp18_ = NULL;
		gint64* _tmp21_ = NULL;
		gint64* _tmp22_;
		if (self->priv->_time == ((gint64) 0)) {
			GFileInfo* info = NULL;
			GFile* _tmp0_;
			GFileInfo* _tmp1_;
			GDateTime* _tmp2_ = NULL;
			GFileInfo* _tmp3_;
			GDateTime* _tmp4_;
			gint64* _tmp5_ = NULL;
			gint64* _tmp8_ = NULL;
			gint64* _tmp9_;
			gint64* _tmp12_;
			_tmp0_ = self->priv->_dir;
			_tmp1_ = g_file_query_info (_tmp0_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			info = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = info;
			_tmp4_ = g_file_info_get_modification_date_time (_tmp3_);
			_tmp2_ = _tmp4_;
			_tmp5_ = NULL;
			if (_tmp2_ != NULL) {
				gint64 _tmp6_;
				gint64* _tmp7_;
				_tmp6_ = g_date_time_to_unix ((GDateTime*) _tmp2_);
				_tmp7_ = __int64_dup0 (&_tmp6_);
				_g_free0 (_tmp5_);
				_tmp5_ = _tmp7_;
			}
			_tmp9_ = _tmp5_;
			_tmp5_ = NULL;
			_tmp8_ = _tmp9_;
			if (_tmp8_ == NULL) {
				gint64 _tmp10_;
				gint64* _tmp11_;
				_tmp10_ = (gint64) 0;
				_tmp11_ = __int64_dup0 (&_tmp10_);
				_g_free0 (_tmp8_);
				_tmp8_ = _tmp11_;
			}
			_tmp12_ = _tmp8_;
			_tmp8_ = NULL;
			self->priv->_time = (gint64) (*_tmp12_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp8_);
			_g_free0 (_tmp5_);
			_g_date_time_unref0 (_tmp2_);
			_g_object_unref0 (info);
		}
		_tmp13_ = self->priv->_file;
		_tmp14_ = g_file_query_info (_tmp13_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp16_ = info;
		_tmp17_ = g_file_info_get_modification_date_time (_tmp16_);
		_tmp15_ = _tmp17_;
		_tmp18_ = NULL;
		if (_tmp15_ != NULL) {
			gint64 _tmp19_;
			gint64* _tmp20_;
			_tmp19_ = g_date_time_to_unix ((GDateTime*) _tmp15_);
			_tmp20_ = __int64_dup0 (&_tmp19_);
			_g_free0 (_tmp18_);
			_tmp18_ = _tmp20_;
		}
		_tmp22_ = __int64_dup0 (_tmp18_);
		_tmp21_ = _tmp22_;
		if (_tmp21_ == NULL) {
			gint64 _tmp23_;
			gint64* _tmp24_;
			_tmp23_ = (gint64) 0;
			_tmp24_ = __int64_dup0 (&_tmp23_);
			_g_free0 (_tmp21_);
			_tmp21_ = _tmp24_;
		}
		result = self->priv->_time <= (*_tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp18_);
		_g_date_time_unref0 (_tmp15_);
		_g_object_unref0 (info);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp25_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp25_;
	}
	result = FALSE;
	return result;
}

static void
__lambda4_ (G4DirCache* self,
            GObject* obj,
            GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GFile* _tmp0_;
		_tmp0_ = self->priv->_file;
		g_file_delete_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ ((G4DirCache*) self, source_object, res);
	g_object_unref (self);
}

void
g4_dir_cache_delete (G4DirCache* self)
{
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_file;
	g_file_delete_async (_tmp0_, G_PRIORITY_DEFAULT, NULL, ___lambda4__gasync_ready_callback, g_object_ref (self));
}

static gpointer
_g4_dir_cache_child_info_ref0 (gpointer self)
{
	return self ? g4_dir_cache_child_info_ref (self) : NULL;
}

void
g4_dir_cache_add_child (G4DirCache* self,
                        GFileInfo* info,
                        guint8 type)
{
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_;
	gint64* _tmp2_ = NULL;
	gint64* _tmp5_ = NULL;
	gint64* _tmp6_;
	gint64 time = 0LL;
	gint64* _tmp9_;
	gint64 _tmp10_;
	G4DirCacheChildInfo* child = NULL;
	const gchar* _tmp11_;
	G4DirCacheChildInfo* _tmp12_;
	GPtrArray* _tmp13_;
	G4DirCacheChildInfo* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp1_ = g_file_info_get_modification_date_time (info);
	_tmp0_ = _tmp1_;
	_tmp2_ = NULL;
	if (_tmp0_ != NULL) {
		gint64 _tmp3_;
		gint64* _tmp4_;
		_tmp3_ = g_date_time_to_unix ((GDateTime*) _tmp0_);
		_tmp4_ = __int64_dup0 (&_tmp3_);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp4_;
	}
	_tmp6_ = _tmp2_;
	_tmp2_ = NULL;
	_tmp5_ = _tmp6_;
	if (_tmp5_ == NULL) {
		gint64 _tmp7_;
		gint64* _tmp8_;
		_tmp7_ = (gint64) 0;
		_tmp8_ = __int64_dup0 (&_tmp7_);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp8_;
	}
	_tmp9_ = _tmp5_;
	_tmp5_ = NULL;
	_tmp10_ = (gint64) (*_tmp9_);
	_g_free0 (_tmp9_);
	time = _tmp10_;
	_tmp11_ = g_file_info_get_name (info);
	_tmp12_ = g4_dir_cache_child_info_new (type, _tmp11_, time);
	child = _tmp12_;
	_tmp13_ = self->priv->_children;
	_tmp14_ = _g4_dir_cache_child_info_ref0 (child);
	g_ptr_array_add (_tmp13_, _tmp14_);
	_g4_dir_cache_child_info_unref0 (child);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	_g_date_time_unref0 (_tmp0_);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gboolean
g4_dir_cache_load (G4DirCache* self,
                   GQueue* stack,
                   GPtrArray* musics,
                   GPtrArray* playlists,
                   gchar** cover_name)
{
	gchar* _vala_cover_name = NULL;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (stack != NULL, FALSE);
	g_return_val_if_fail (musics != NULL, FALSE);
	_g_free0 (_vala_cover_name);
	_vala_cover_name = NULL;
	{
		gchar* _tmp0_ = NULL;
		GFile* _tmp1_;
		gchar* _tmp2_;
		GMappedFile* mapped = NULL;
		GMappedFile* _tmp4_;
		G4DataInputBytes* dis = NULL;
		GMappedFile* _tmp5_;
		GBytes* _tmp6_;
		GBytes* _tmp7_;
		G4DataInputBytes* _tmp8_;
		G4DataInputBytes* _tmp9_;
		guint32 magic = 0U;
		G4DataInputBytes* _tmp10_;
		gchar* _tmp17_ = NULL;
		GFile* _tmp18_;
		gchar* _tmp19_;
		gchar* base_name = NULL;
		gchar* _tmp21_;
		gchar* bname = NULL;
		G4DataInputBytes* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gsize count = 0UL;
		G4DataInputBytes* _tmp34_;
		_tmp1_ = self->priv->_file;
		_tmp2_ = g_file_get_path (_tmp1_);
		_tmp0_ = _tmp2_;
		if (_tmp0_ == NULL) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("");
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp3_;
		}
		_tmp4_ = g_mapped_file_new ((const gchar*) _tmp0_, FALSE, &_inner_error0_);
		mapped = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp5_ = mapped;
		_tmp6_ = g_mapped_file_get_bytes (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g4_data_input_bytes_new (_tmp7_);
		_tmp9_ = _tmp8_;
		_g_bytes_unref0 (_tmp7_);
		dis = _tmp9_;
		_tmp10_ = dis;
		magic = g4_data_input_bytes_read_uint32 (_tmp10_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dis);
			_g_mapped_file_unref0 (mapped);
			_g_free0 (_tmp0_);
			goto __catch0_g_error;
		}
		if (magic != g4_dir_cache_MAGIC) {
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			GError* _tmp15_;
			GError* _tmp16_;
			_tmp11_ = g_strdup_printf ("%u", magic);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat ("Magic:", _tmp12_, NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_INVALID_DATA, _tmp14_);
			_tmp16_ = _tmp15_;
			_g_free0 (_tmp14_);
			_g_free0 (_tmp12_);
			_inner_error0_ = _tmp16_;
			_g_object_unref0 (dis);
			_g_mapped_file_unref0 (mapped);
			_g_free0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp18_ = self->priv->_dir;
		_tmp19_ = g_file_get_basename (_tmp18_);
		_tmp17_ = _tmp19_;
		if (_tmp17_ == NULL) {
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("");
			_g_free0 (_tmp17_);
			_tmp17_ = _tmp20_;
		}
		_tmp21_ = _tmp17_;
		_tmp17_ = NULL;
		base_name = (gchar*) _tmp21_;
		_tmp22_ = dis;
		_tmp23_ = g4_data_input_bytes_read_string (_tmp22_, &_inner_error0_);
		bname = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (base_name);
			_g_free0 (_tmp17_);
			_g_object_unref0 (dis);
			_g_mapped_file_unref0 (mapped);
			_g_free0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp24_ = bname;
		_tmp25_ = base_name;
		if (g_strcmp0 (_tmp24_, _tmp25_) != 0) {
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			GError* _tmp32_;
			GError* _tmp33_;
			_tmp26_ = bname;
			_tmp27_ = string_to_string (_tmp26_);
			_tmp28_ = base_name;
			_tmp29_ = string_to_string (_tmp28_);
			_tmp30_ = g_strconcat ("Name:", _tmp27_, "!=", _tmp29_, NULL);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_INVALID_DATA, _tmp31_);
			_tmp33_ = _tmp32_;
			_g_free0 (_tmp31_);
			_inner_error0_ = _tmp33_;
			_g_free0 (bname);
			_g_free0 (base_name);
			_g_free0 (_tmp17_);
			_g_object_unref0 (dis);
			_g_mapped_file_unref0 (mapped);
			_g_free0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp34_ = dis;
		count = g4_data_input_bytes_read_size (_tmp34_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (bname);
			_g_free0 (base_name);
			_g_free0 (_tmp17_);
			_g_object_unref0 (dis);
			_g_mapped_file_unref0 (mapped);
			_g_free0 (_tmp0_);
			goto __catch0_g_error;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp35_ = FALSE;
				_tmp35_ = TRUE;
				while (TRUE) {
					guint8 type = 0U;
					G4DataInputBytes* _tmp37_;
					gchar* name = NULL;
					G4DataInputBytes* _tmp38_;
					gchar* _tmp39_;
					guint64 _tmp40_ = 0ULL;
					G4DataInputBytes* _tmp41_;
					gint64 time = 0LL;
					GFile* child = NULL;
					GFile* _tmp42_;
					const gchar* _tmp43_;
					GFile* _tmp44_;
					if (!_tmp35_) {
						gint _tmp36_;
						_tmp36_ = i;
						i = _tmp36_ + 1;
					}
					_tmp35_ = FALSE;
					if (!(((gsize) i) < count)) {
						break;
					}
					_tmp37_ = dis;
					type = g4_data_input_bytes_read_byte (_tmp37_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (bname);
						_g_free0 (base_name);
						_g_free0 (_tmp17_);
						_g_object_unref0 (dis);
						_g_mapped_file_unref0 (mapped);
						_g_free0 (_tmp0_);
						goto __catch0_g_error;
					}
					_tmp38_ = dis;
					_tmp39_ = g4_data_input_bytes_read_string (_tmp38_, &_inner_error0_);
					name = _tmp39_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (bname);
						_g_free0 (base_name);
						_g_free0 (_tmp17_);
						_g_object_unref0 (dis);
						_g_mapped_file_unref0 (mapped);
						_g_free0 (_tmp0_);
						goto __catch0_g_error;
					}
					_tmp41_ = dis;
					_tmp40_ = g4_data_input_bytes_read_uint64 (_tmp41_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (name);
						_g_free0 (bname);
						_g_free0 (base_name);
						_g_free0 (_tmp17_);
						_g_object_unref0 (dis);
						_g_mapped_file_unref0 (mapped);
						_g_free0 (_tmp0_);
						goto __catch0_g_error;
					}
					time = (gint64) _tmp40_;
					_tmp42_ = self->priv->_dir;
					_tmp43_ = name;
					_tmp44_ = g_file_get_child (_tmp42_, _tmp43_);
					child = _tmp44_;
					if (type == G4_CHILD_TYPE_MUSIC) {
						GFile* _tmp45_;
						gchar* _tmp46_;
						gchar* _tmp47_;
						const gchar* _tmp48_;
						G4Music* _tmp49_;
						_tmp45_ = child;
						_tmp46_ = g_file_get_uri (_tmp45_);
						_tmp47_ = _tmp46_;
						_tmp48_ = name;
						_tmp49_ = g4_music_new (_tmp47_, _tmp48_, time);
						g_ptr_array_add (musics, _tmp49_);
						_g_free0 (_tmp47_);
					} else {
						if (type == G4_CHILD_TYPE_FOLDER) {
							GFile* _tmp50_;
							G4DirCache* _tmp51_;
							_tmp50_ = child;
							_tmp51_ = g4_dir_cache_new (_tmp50_, NULL);
							g_queue_push_head (stack, _tmp51_);
						} else {
							if (type == G4_CHILD_TYPE_PLAYLIST) {
								GPtrArray* _tmp52_ = NULL;
								_tmp52_ = playlists;
								if (_tmp52_ != NULL) {
									GFile* _tmp53_;
									GFile* _tmp54_;
									_tmp53_ = child;
									_tmp54_ = _g_object_ref0 (_tmp53_);
									g_ptr_array_add ((GPtrArray*) _tmp52_, _tmp54_);
								}
							} else {
								if (type == G4_CHILD_TYPE_COVER) {
									const gchar* _tmp55_;
									gchar* _tmp56_;
									_tmp55_ = name;
									_tmp56_ = g_strdup (_tmp55_);
									_g_free0 (_vala_cover_name);
									_vala_cover_name = _tmp56_;
								}
							}
						}
					}
					_g_object_unref0 (child);
					_g_free0 (name);
				}
			}
		}
		result = TRUE;
		_g_free0 (bname);
		_g_free0 (base_name);
		_g_free0 (_tmp17_);
		_g_object_unref0 (dis);
		_g_mapped_file_unref0 (mapped);
		_g_free0 (_tmp0_);
		if (cover_name) {
			*cover_name = _vala_cover_name;
		} else {
			_g_free0 (_vala_cover_name);
		}
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp57_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp57_ = e;
		if (_tmp57_->code != G_FILE_ERROR_NOENT) {
			GError* _tmp58_;
			const gchar* _tmp59_;
			_tmp58_ = e;
			_tmp59_ = _tmp58_->message;
			g_print ("Load dir error: %s\n", _tmp59_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp60_ = FALSE;
		_g_free0 (_vala_cover_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp60_;
	}
	result = FALSE;
	if (cover_name) {
		*cover_name = _vala_cover_name;
	} else {
		_g_free0 (_vala_cover_name);
	}
	return result;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

void
g4_dir_cache_save (G4DirCache* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFile* parent = NULL;
		GFile* _tmp0_;
		GFile* _tmp1_;
		GFile* _tmp2_ = NULL;
		GFile* _tmp3_;
		gboolean* _tmp4_ = NULL;
		gboolean* _tmp7_ = NULL;
		gboolean* _tmp8_;
		gboolean exists = FALSE;
		gboolean* _tmp11_;
		gboolean _tmp12_;
		GFileOutputStream* fos = NULL;
		GFile* _tmp18_;
		GFileOutputStream* _tmp19_;
		G4DataOutputBytes* dos = NULL;
		G4DataOutputBytes* _tmp20_;
		G4DataOutputBytes* _tmp21_;
		gchar* _tmp22_ = NULL;
		GFile* _tmp23_;
		gchar* _tmp24_;
		G4DataOutputBytes* _tmp26_;
		G4DataOutputBytes* _tmp27_;
		GPtrArray* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		GPtrArray* _tmp31_;
		G4DataOutputBytes* _tmp40_;
		GFileOutputStream* _tmp41_;
		_tmp0_ = self->priv->_file;
		_tmp1_ = g_file_get_parent (_tmp0_);
		parent = _tmp1_;
		_tmp3_ = parent;
		_tmp2_ = _tmp3_;
		_tmp4_ = NULL;
		if (_tmp2_ != NULL) {
			gboolean _tmp5_;
			gboolean* _tmp6_;
			_tmp5_ = g_file_query_exists (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_file_get_type (), GFile), NULL);
			_tmp6_ = __bool_dup0 (&_tmp5_);
			_g_free0 (_tmp4_);
			_tmp4_ = _tmp6_;
		}
		_tmp8_ = _tmp4_;
		_tmp4_ = NULL;
		_tmp7_ = _tmp8_;
		if (_tmp7_ == NULL) {
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp9_ = FALSE;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (_tmp7_);
			_tmp7_ = _tmp10_;
		}
		_tmp11_ = _tmp7_;
		_tmp7_ = NULL;
		_tmp12_ = (gboolean) (*_tmp11_);
		_g_free0 (_tmp11_);
		exists = _tmp12_;
		if (!exists) {
			GFile* _tmp13_ = NULL;
			GFile* _tmp14_;
			gboolean* _tmp15_ = NULL;
			_tmp14_ = parent;
			_tmp13_ = _tmp14_;
			_tmp15_ = NULL;
			if (_tmp13_ != NULL) {
				gboolean _tmp16_ = FALSE;
				gboolean* _tmp17_;
				_tmp16_ = g_file_make_directory_with_parents (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_file_get_type (), GFile), NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (_tmp15_);
					_g_free0 (_tmp7_);
					_g_free0 (_tmp4_);
					_g_object_unref0 (parent);
					goto __catch0_g_error;
				}
				_tmp17_ = __bool_dup0 (&_tmp16_);
				_g_free0 (_tmp15_);
				_tmp15_ = _tmp17_;
			}
			_g_free0 (_tmp15_);
		}
		_tmp18_ = self->priv->_file;
		_tmp19_ = g_file_replace (_tmp18_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		fos = _tmp19_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_free0 (_tmp4_);
			_g_object_unref0 (parent);
			goto __catch0_g_error;
		}
		_tmp20_ = g4_data_output_bytes_new ((guint) 4096);
		dos = _tmp20_;
		_tmp21_ = dos;
		g4_data_output_bytes_write_uint32 (_tmp21_, g4_dir_cache_MAGIC);
		_tmp23_ = self->priv->_dir;
		_tmp24_ = g_file_get_basename (_tmp23_);
		_tmp22_ = _tmp24_;
		if (_tmp22_ == NULL) {
			gchar* _tmp25_;
			_tmp25_ = g_strdup ("");
			_g_free0 (_tmp22_);
			_tmp22_ = _tmp25_;
		}
		_tmp26_ = dos;
		g4_data_output_bytes_write_string (_tmp26_, (const gchar*) _tmp22_);
		_tmp27_ = dos;
		_tmp28_ = self->priv->_children;
		_tmp29_ = vala_g_ptr_array_get_length (_tmp28_);
		_tmp30_ = _tmp29_;
		g4_data_output_bytes_write_size (_tmp27_, (gsize) _tmp30_);
		_tmp31_ = self->priv->_children;
		{
			GPtrArray* child_collection = NULL;
			guint child_index = 0U;
			child_collection = _tmp31_;
			for (child_index = 0; child_index < child_collection->len; child_index = child_index + 1) {
				G4DirCacheChildInfo* _tmp32_;
				G4DirCacheChildInfo* child = NULL;
				_tmp32_ = _g4_dir_cache_child_info_ref0 ((G4DirCacheChildInfo*) g_ptr_array_index (child_collection, child_index));
				child = _tmp32_;
				{
					G4DataOutputBytes* _tmp33_;
					G4DirCacheChildInfo* _tmp34_;
					G4DataOutputBytes* _tmp35_;
					G4DirCacheChildInfo* _tmp36_;
					const gchar* _tmp37_;
					G4DataOutputBytes* _tmp38_;
					G4DirCacheChildInfo* _tmp39_;
					_tmp33_ = dos;
					_tmp34_ = child;
					g4_data_output_bytes_write_byte (_tmp33_, _tmp34_->type);
					_tmp35_ = dos;
					_tmp36_ = child;
					_tmp37_ = _tmp36_->name;
					g4_data_output_bytes_write_string (_tmp35_, _tmp37_);
					_tmp38_ = dos;
					_tmp39_ = child;
					g4_data_output_bytes_write_uint64 (_tmp38_, (guint64) _tmp39_->time);
					_g4_dir_cache_child_info_unref0 (child);
				}
			}
		}
		_tmp40_ = dos;
		_tmp41_ = fos;
		g4_data_output_bytes_write_to (_tmp40_, (GOutputStream*) _tmp41_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp22_);
			_g_object_unref0 (dos);
			_g_object_unref0 (fos);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp4_);
			_g_object_unref0 (parent);
			goto __catch0_g_error;
		}
		_g_free0 (_tmp22_);
		_g_object_unref0 (dos);
		_g_object_unref0 (fos);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp4_);
		_g_object_unref0 (parent);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp42_;
		const gchar* _tmp43_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		g_print ("Save dir error: %s\n", _tmp43_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

GFile*
g4_dir_cache_get_dir (G4DirCache* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dir;
	result = _tmp0_;
	return result;
}

static G4DirCacheChildInfo*
g4_dir_cache_child_info_construct (GType object_type,
                                   guint8 type,
                                   const gchar* name,
                                   gint64 time)
{
	G4DirCacheChildInfo* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (G4DirCacheChildInfo*) g_type_create_instance (object_type);
	self->type = type;
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	self->time = time;
	return self;
}

static G4DirCacheChildInfo*
g4_dir_cache_child_info_new (guint8 type,
                             const gchar* name,
                             gint64 time)
{
	return g4_dir_cache_child_info_construct (G4_DIR_CACHE_TYPE_CHILD_INFO, type, name, time);
}

static void
g4_dir_cache_value_child_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
g4_dir_cache_value_child_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		g4_dir_cache_child_info_unref (value->data[0].v_pointer);
	}
}

static void
g4_dir_cache_value_child_info_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = g4_dir_cache_child_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
g4_dir_cache_value_child_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
g4_dir_cache_value_child_info_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		G4DirCacheChildInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = g4_dir_cache_child_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
g4_dir_cache_value_child_info_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	G4DirCacheChildInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = g4_dir_cache_child_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
g4_dir_cache_param_spec_child_info (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	G4DirCacheParamSpecChildInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, G4_DIR_CACHE_TYPE_CHILD_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
g4_dir_cache_value_get_child_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, G4_DIR_CACHE_TYPE_CHILD_INFO), NULL);
	return value->data[0].v_pointer;
}

static void
g4_dir_cache_value_set_child_info (GValue* value,
                                   gpointer v_object)
{
	G4DirCacheChildInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, G4_DIR_CACHE_TYPE_CHILD_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, G4_DIR_CACHE_TYPE_CHILD_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		g4_dir_cache_child_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		g4_dir_cache_child_info_unref (old);
	}
}

static void
g4_dir_cache_value_take_child_info (GValue* value,
                                    gpointer v_object)
{
	G4DirCacheChildInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, G4_DIR_CACHE_TYPE_CHILD_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, G4_DIR_CACHE_TYPE_CHILD_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		g4_dir_cache_child_info_unref (old);
	}
}

static void
g4_dir_cache_child_info_class_init (G4DirCacheChildInfoClass * klass,
                                    gpointer klass_data)
{
	g4_dir_cache_child_info_parent_class = g_type_class_peek_parent (klass);
	((G4DirCacheChildInfoClass *) klass)->finalize = g4_dir_cache_child_info_finalize;
}

static void
g4_dir_cache_child_info_instance_init (G4DirCacheChildInfo * self,
                                       gpointer klass)
{
	self->ref_count = 1;
}

static void
g4_dir_cache_child_info_finalize (G4DirCacheChildInfo * obj)
{
	G4DirCacheChildInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_DIR_CACHE_TYPE_CHILD_INFO, G4DirCacheChildInfo);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
}

static GType
g4_dir_cache_child_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { g4_dir_cache_value_child_info_init, g4_dir_cache_value_child_info_free_value, g4_dir_cache_value_child_info_copy_value, g4_dir_cache_value_child_info_peek_pointer, "p", g4_dir_cache_value_child_info_collect_value, "p", g4_dir_cache_value_child_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (G4DirCacheChildInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_dir_cache_child_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (G4DirCacheChildInfo), 0, (GInstanceInitFunc) g4_dir_cache_child_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType g4_dir_cache_child_info_type_id;
	g4_dir_cache_child_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "G4DirCacheChildInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return g4_dir_cache_child_info_type_id;
}

static GType
g4_dir_cache_child_info_get_type (void)
{
	static volatile gsize g4_dir_cache_child_info_type_id__once = 0;
	if (g_once_init_enter (&g4_dir_cache_child_info_type_id__once)) {
		GType g4_dir_cache_child_info_type_id;
		g4_dir_cache_child_info_type_id = g4_dir_cache_child_info_get_type_once ();
		g_once_init_leave (&g4_dir_cache_child_info_type_id__once, g4_dir_cache_child_info_type_id);
	}
	return g4_dir_cache_child_info_type_id__once;
}

static gpointer
g4_dir_cache_child_info_ref (gpointer instance)
{
	G4DirCacheChildInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
g4_dir_cache_child_info_unref (gpointer instance)
{
	G4DirCacheChildInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		G4_DIR_CACHE_CHILD_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
g4_dir_cache_class_init (G4DirCacheClass * klass,
                         gpointer klass_data)
{
	g4_dir_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &G4DirCache_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_g4_dir_cache_get_property;
	G_OBJECT_CLASS (klass)->finalize = g4_dir_cache_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_DIR_CACHE_DIR_PROPERTY, g4_dir_cache_properties[G4_DIR_CACHE_DIR_PROPERTY] = g_param_spec_object ("dir", "dir", "dir", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
g4_dir_cache_instance_init (G4DirCache * self,
                            gpointer klass)
{
	GPtrArray* _tmp0_;
	self->priv = g4_dir_cache_get_instance_private (self);
	_tmp0_ = g_ptr_array_new_full ((guint) 128, _g4_dir_cache_child_info_unref0_);
	self->priv->_children = _tmp0_;
}

static void
g4_dir_cache_finalize (GObject * obj)
{
	G4DirCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_TYPE_DIR_CACHE, G4DirCache);
	_g_object_unref0 (self->priv->_dir);
	_g_object_unref0 (self->priv->_file);
	_g_ptr_array_unref0 (self->priv->_children);
	G_OBJECT_CLASS (g4_dir_cache_parent_class)->finalize (obj);
}

static GType
g4_dir_cache_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (G4DirCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_dir_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (G4DirCache), 0, (GInstanceInitFunc) g4_dir_cache_instance_init, NULL };
	GType g4_dir_cache_type_id;
	g4_dir_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "G4DirCache", &g_define_type_info, 0);
	G4DirCache_private_offset = g_type_add_instance_private (g4_dir_cache_type_id, sizeof (G4DirCachePrivate));
	return g4_dir_cache_type_id;
}

GType
g4_dir_cache_get_type (void)
{
	static volatile gsize g4_dir_cache_type_id__once = 0;
	if (g_once_init_enter (&g4_dir_cache_type_id__once)) {
		GType g4_dir_cache_type_id;
		g4_dir_cache_type_id = g4_dir_cache_get_type_once ();
		g_once_init_leave (&g4_dir_cache_type_id__once, g4_dir_cache_type_id);
	}
	return g4_dir_cache_type_id__once;
}

static void
_vala_g4_dir_cache_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	G4DirCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_DIR_CACHE, G4DirCache);
	switch (property_id) {
		case G4_DIR_CACHE_DIR_PROPERTY:
		g_value_set_object (value, g4_dir_cache_get_dir (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

