/* music-library.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from music-library.vala, do not modify */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define G4_SORT_MODE_ALBUM ((guint) 0)
#define G4_SORT_MODE_ARTIST ((guint) 1)
#define G4_SORT_MODE_ARTIST_ALBUM ((guint) 2)
#define G4_SORT_MODE_TITLE ((guint) 3)
#define G4_SORT_MODE_RECENT ((guint) 4)
#define G4_SORT_MODE_SHUFFLE ((guint) 5)
#define G4_SORT_MODE_MAX ((guint) 5)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define G4_TYPE_MUSIC (g4_music_get_type ())
#define G4_MUSIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_MUSIC, G4Music))
#define G4_MUSIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_MUSIC, G4MusicClass))
#define G4_IS_MUSIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_MUSIC))
#define G4_IS_MUSIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_MUSIC))
#define G4_MUSIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_MUSIC, G4MusicClass))

typedef struct _G4Music G4Music;
typedef struct _G4MusicClass G4MusicClass;
typedef struct _G4MusicPrivate G4MusicPrivate;

#define G4_TYPE_ALBUM (g4_album_get_type ())
#define G4_ALBUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_ALBUM, G4Album))
#define G4_ALBUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_ALBUM, G4AlbumClass))
#define G4_IS_ALBUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_ALBUM))
#define G4_IS_ALBUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_ALBUM))
#define G4_ALBUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_ALBUM, G4AlbumClass))

typedef struct _G4Album G4Album;
typedef struct _G4AlbumClass G4AlbumClass;
typedef struct _G4AlbumPrivate G4AlbumPrivate;
enum  {
	G4_ALBUM_0_PROPERTY,
	G4_ALBUM_LENGTH_PROPERTY,
	G4_ALBUM_NUM_PROPERTIES
};
static GParamSpec* g4_album_properties[G4_ALBUM_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block49Data Block49Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block44Data Block44Data;

#define G4_TYPE_ARTIST (g4_artist_get_type ())
#define G4_ARTIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_ARTIST, G4Artist))
#define G4_ARTIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_ARTIST, G4ArtistClass))
#define G4_IS_ARTIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_ARTIST))
#define G4_IS_ARTIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_ARTIST))
#define G4_ARTIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_ARTIST, G4ArtistClass))

typedef struct _G4Artist G4Artist;
typedef struct _G4ArtistClass G4ArtistClass;
typedef struct _G4ArtistPrivate G4ArtistPrivate;
enum  {
	G4_ARTIST_0_PROPERTY,
	G4_ARTIST_LENGTH_PROPERTY,
	G4_ARTIST_NUM_PROPERTIES
};
static GParamSpec* g4_artist_properties[G4_ARTIST_NUM_PROPERTIES];
typedef struct _Block50Data Block50Data;
typedef struct _Block51Data Block51Data;
typedef struct _Block52Data Block52Data;
typedef struct _Block53Data Block53Data;

#define G4_TYPE_PLAYLIST (g4_playlist_get_type ())
#define G4_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_PLAYLIST, G4Playlist))
#define G4_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_PLAYLIST, G4PlaylistClass))
#define G4_IS_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_PLAYLIST))
#define G4_IS_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_PLAYLIST))
#define G4_PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_PLAYLIST, G4PlaylistClass))

typedef struct _G4Playlist G4Playlist;
typedef struct _G4PlaylistClass G4PlaylistClass;
typedef struct _G4PlaylistPrivate G4PlaylistPrivate;
enum  {
	G4_PLAYLIST_0_PROPERTY,
	G4_PLAYLIST_LENGTH_PROPERTY,
	G4_PLAYLIST_NUM_PROPERTIES
};
static GParamSpec* g4_playlist_properties[G4_PLAYLIST_NUM_PROPERTIES];

#define G4_TYPE_MUSIC_LIBRARY (g4_music_library_get_type ())
#define G4_MUSIC_LIBRARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_MUSIC_LIBRARY, G4MusicLibrary))
#define G4_MUSIC_LIBRARY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_MUSIC_LIBRARY, G4MusicLibraryClass))
#define G4_IS_MUSIC_LIBRARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_MUSIC_LIBRARY))
#define G4_IS_MUSIC_LIBRARY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_MUSIC_LIBRARY))
#define G4_MUSIC_LIBRARY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_MUSIC_LIBRARY, G4MusicLibraryClass))

typedef struct _G4MusicLibrary G4MusicLibrary;
typedef struct _G4MusicLibraryClass G4MusicLibraryClass;
typedef struct _G4MusicLibraryPrivate G4MusicLibraryPrivate;
enum  {
	G4_MUSIC_LIBRARY_0_PROPERTY,
	G4_MUSIC_LIBRARY_EMPTY_PROPERTY,
	G4_MUSIC_LIBRARY_ALBUM_COUNT_PROPERTY,
	G4_MUSIC_LIBRARY_ARTIST_COUNT_PROPERTY,
	G4_MUSIC_LIBRARY_PLAYLIST_COUNT_PROPERTY,
	G4_MUSIC_LIBRARY_NUM_PROPERTIES
};
static GParamSpec* g4_music_library_properties[G4_MUSIC_LIBRARY_NUM_PROPERTIES];
typedef struct _Block54Data Block54Data;
typedef struct _Block55Data Block55Data;
typedef struct _Block56Data Block56Data;
typedef struct _Block57Data Block57Data;
typedef struct _Block58Data Block58Data;
typedef struct _Block11Data Block11Data;
typedef struct _Block59Data Block59Data;
typedef struct _Block60Data Block60Data;
typedef struct _Block61Data Block61Data;

struct _G4Music {
	GObject parent_instance;
	G4MusicPrivate * priv;
	gchar* album;
	gchar* artist;
	gchar* title;
	gchar* album_artist;
	guint32 date;
	gchar* genre;
	gint track;
	gint disc;
	gboolean has_cover;
	gint64 modified_time;
	gchar* uri;
	gchar* cover_uri;
	gchar* _album_key;
	gchar* _artist_key;
	gchar* _title_key;
	gint _order;
};

struct _G4MusicClass {
	GObjectClass parent_class;
	gchar* (*get_abbreviation) (G4Music* self);
};

struct _G4Album {
	G4Music parent_instance;
	G4AlbumPrivate * priv;
	GHashTable* _musics;
};

struct _G4AlbumClass {
	G4MusicClass parent_class;
	void (*get_sorted_musics) (G4Album* self, GPtrArray* musics);
	void (*sort) (G4Album* self, GPtrArray* arr);
};

struct _Block49Data {
	int _ref_count_;
	G4Album* self;
	GPtrArray* musics;
};

struct _Block44Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareFunc compare_func;
};

struct _G4Artist {
	G4Music parent_instance;
	G4ArtistPrivate * priv;
	GHashTable* _albums;
};

struct _G4ArtistClass {
	G4MusicClass parent_class;
};

struct _Block50Data {
	int _ref_count_;
	G4Artist* self;
	gchar* artist;
};

struct _Block51Data {
	int _ref_count_;
	G4Artist* self;
	GPtrArray* albums;
};

struct _Block52Data {
	int _ref_count_;
	G4Artist* self;
	GPtrArray* musics;
};

struct _Block53Data {
	int _ref_count_;
	G4Artist* self;
	G4Music* music;
};

struct _G4Playlist {
	G4Album parent_instance;
	G4PlaylistPrivate * priv;
	GPtrArray* items;
	gchar* list_uri;
};

struct _G4PlaylistClass {
	G4AlbumClass parent_class;
};

struct _G4MusicLibrary {
	GObject parent_instance;
	G4MusicLibraryPrivate * priv;
};

struct _G4MusicLibraryClass {
	GObjectClass parent_class;
};

struct _G4MusicLibraryPrivate {
	GHashTable* _albums;
	GRecMutex __lock__albums;
	GHashTable* _artists;
	GRecMutex __lock__artists;
	GHashTable* _playlists;
	GRecMutex __lock__playlists;
};

struct _Block54Data {
	int _ref_count_;
	G4MusicLibrary* self;
	GPtrArray* arr;
};

struct _Block55Data {
	int _ref_count_;
	G4MusicLibrary* self;
	GPtrArray* arr;
};

struct _Block56Data {
	int _ref_count_;
	G4MusicLibrary* self;
	GPtrArray* arr;
};

struct _Block57Data {
	int _ref_count_;
	G4MusicLibrary* self;
	G4Music* music;
};

struct _Block58Data {
	int _ref_count_;
	G4MusicLibrary* self;
	gchar* prefix;
	GHashTable* removed;
};

struct _Block11Data {
	int _ref_count_;
	GHashTable* self;
	GFunc func;
	gpointer func_target;
};

struct _Block59Data {
	int _ref_count_;
	G4MusicLibrary* self;
	G4Music* music;
};

struct _Block60Data {
	int _ref_count_;
	GHashTable* map;
};

struct _Block61Data {
	int _ref_count_;
	G4Playlist* playlist;
};

static gpointer g4_album_parent_class = NULL;
static gpointer g4_artist_parent_class = NULL;
static gpointer g4_playlist_parent_class = NULL;
static gint G4MusicLibrary_private_offset;
static gpointer g4_music_library_parent_class = NULL;

VALA_EXTERN GType g4_music_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4Music, g_object_unref)
VALA_EXTERN GType g4_album_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4Album, g_object_unref)
VALA_EXTERN void g4_album_get_sorted_musics (G4Album* self,
                                 GPtrArray* musics);
VALA_EXTERN void g4_album_sort (G4Album* self,
                    GPtrArray* arr);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN G4Album* g4_album_new (G4Music* music);
VALA_EXTERN G4Album* g4_album_construct (GType object_type,
                             G4Music* music);
VALA_EXTERN G4Music* g4_music_new_titled (const gchar* title,
                              const gchar* uri);
VALA_EXTERN G4Music* g4_music_construct_titled (GType object_type,
                                    const gchar* title,
                                    const gchar* uri);
VALA_EXTERN gboolean g4_album_add_music (G4Album* self,
                             G4Music* music);
VALA_EXTERN gboolean g4_album_insert_music (G4Album* self,
                                G4Music* music);
VALA_EXTERN gboolean g4_album_contains (G4Album* self,
                            const gchar* uri);
VALA_EXTERN guint g4_album_foreach_remove (G4Album* self,
                               GHRFunc func,
                               gpointer func_target);
static void g4_album_real_get_sorted_musics (G4Album* self,
                                      GPtrArray* musics);
static Block49Data* block49_data_ref (Block49Data* _data49_);
static void block49_data_unref (void * _userdata_);
static void __lambda6_ (Block49Data* _data49_,
                 const gchar* name,
                 G4Music* music);
static void ___lambda6__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
VALA_EXTERN void g4_album_overwrite_to (G4Album* self,
                            GListStore* store);
VALA_EXTERN gboolean g4_album_remove_music (G4Album* self,
                                G4Music* music);
static void g4_album_real_sort (G4Album* self,
                         GPtrArray* arr);
static Block44Data* block44_data_ref (Block44Data* _data44_);
static void block44_data_unref (void * _userdata_);
static gint ___lambda0__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
VALA_EXTERN gint g4_music_compare_by_album (G4Music* s1,
                                G4Music* s2);
static gint _g4_music_compare_by_album_gcompare_func (gconstpointer a,
                                               gconstpointer b);
VALA_EXTERN guint g4_album_get_length (G4Album* self);
static void g4_album_finalize (GObject * obj);
static GType g4_album_get_type_once (void);
static void _vala_g4_album_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
VALA_EXTERN GType g4_artist_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4Artist, g_object_unref)
VALA_EXTERN gchar* g4_music_get_abbreviation (G4Music* self);
VALA_EXTERN G4Artist* g4_artist_new (G4Music* music,
                         const gchar* artist_name);
VALA_EXTERN G4Artist* g4_artist_construct (GType object_type,
                               G4Music* music,
                               const gchar* artist_name);
static gchar* g4_artist_real_get_abbreviation (G4Music* base);
VALA_EXTERN gchar* g4_parse_abbreviation (const gchar* text);
VALA_EXTERN gboolean g4_artist_add_music (G4Artist* self,
                              G4Music* music);
VALA_EXTERN const gchar* g4_music_get_album_key (G4Music* self);
VALA_EXTERN G4Album* g4_artist_find_by_partial_artist (G4Artist* self,
                                           const gchar* artist);
static Block50Data* block50_data_ref (Block50Data* _data50_);
static void block50_data_unref (void * _userdata_);
static gboolean __lambda7_ (Block50Data* _data50_,
                     const gchar* name,
                     G4Album* album);
static gboolean ___lambda7__ghr_func (gconstpointer key,
                               gconstpointer value,
                               gpointer self);
VALA_EXTERN G4Album* g4_artist_get (G4Artist* self,
                        const gchar* name);
VALA_EXTERN void g4_artist_get_sorted_albums (G4Artist* self,
                                  GPtrArray* albums);
static Block51Data* block51_data_ref (Block51Data* _data51_);
static void block51_data_unref (void * _userdata_);
static void __lambda8_ (Block51Data* _data51_,
                 const gchar* name,
                 G4Album* album);
static void ___lambda8__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
static gint g4_artist_compare_album (G4Music* m1,
                              G4Music* m2);
static gint _g4_artist_compare_album_gcompare_func (gconstpointer a,
                                             gconstpointer b);
VALA_EXTERN void g4_artist_get_sorted_musics (G4Artist* self,
                                  GPtrArray* musics);
static Block52Data* block52_data_ref (Block52Data* _data52_);
static void block52_data_unref (void * _userdata_);
static void __lambda9_ (Block52Data* _data52_,
                 G4Album* album);
static void ___lambda9__gfunc (gconstpointer data,
                        gpointer self);
VALA_EXTERN void g4_artist_overwrite_store (G4Artist* self,
                                GListStore* store);
VALA_EXTERN gboolean g4_artist_remove_music (G4Artist* self,
                                 G4Music* music);
static Block53Data* block53_data_ref (Block53Data* _data53_);
static void block53_data_unref (void * _userdata_);
static gboolean __lambda10_ (Block53Data* _data53_,
                      const gchar* name,
                      G4Album* album);
static gboolean ___lambda10__ghr_func (gconstpointer key,
                                gconstpointer value,
                                gpointer self);
VALA_EXTERN GType g4_playlist_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4Playlist, g_object_unref)
VALA_EXTERN G4Playlist* g4_artist_to_playlist (G4Artist* self);
VALA_EXTERN G4Playlist* g4_playlist_new (const gchar* name,
                             const gchar* uri);
VALA_EXTERN G4Playlist* g4_playlist_construct (GType object_type,
                                   const gchar* name,
                                   const gchar* uri);
VALA_EXTERN void g4_playlist_set_cover_uri (G4Playlist* self);
VALA_EXTERN guint g4_artist_get_length (G4Artist* self);
static void g4_artist_finalize (GObject * obj);
static GType g4_artist_get_type_once (void);
static void _vala_g4_artist_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
VALA_EXTERN void g4_playlist_set_list_uri (G4Playlist* self,
                               const gchar* uri);
VALA_EXTERN gboolean g4_playlist_add_music (G4Playlist* self,
                                G4Music* music);
VALA_EXTERN void g4_playlist_clear (G4Playlist* self);
VALA_EXTERN void g4_playlist_copy_from (G4Playlist* self,
                            G4Playlist* playlist);
VALA_EXTERN void g4_playlist_extend (G4Playlist* self,
                         GPtrArray* musics);
VALA_EXTERN void g4_playlist_set_title (G4Playlist* self,
                            const gchar* title);
static G4Music* __lambda11_ (G4Playlist* self,
                      G4Music* src);
static gpointer ___lambda11__gcopy_func (gconstpointer src,
                                  gpointer self);
VALA_EXTERN gboolean g4_playlist_remove_music (G4Playlist* self,
                                   G4Music* music);
static void g4_playlist_real_get_sorted_musics (G4Album* base,
                                         GPtrArray* musics);
static G4Music* __lambda12_ (G4Playlist* self,
                      G4Music* src);
static gpointer ___lambda12__gcopy_func (gconstpointer src,
                                  gpointer self);
VALA_EXTERN void g4_playlist_insert_to_store (G4Playlist* self,
                                  GListStore* store,
                                  guint position);
VALA_EXTERN void g4_playlist_reset_original_order (G4Playlist* self);
VALA_EXTERN void g4_music_original_order (GPtrArray* arr);
static void g4_playlist_real_sort (G4Album* base,
                            GPtrArray* arr);
VALA_EXTERN gint g4_music_compare_by_order (G4Music* s1,
                                G4Music* s2);
static gint _g4_music_compare_by_order_gcompare_func (gconstpointer a,
                                               gconstpointer b);
VALA_EXTERN guint g4_playlist_get_length (G4Playlist* self);
static void g4_playlist_finalize (GObject * obj);
static GType g4_playlist_get_type_once (void);
static void _vala_g4_playlist_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
VALA_EXTERN GType g4_music_library_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4MusicLibrary, g_object_unref)
VALA_EXTERN gboolean g4_music_library_add_music (G4MusicLibrary* self,
                                     G4Music* music);
VALA_EXTERN const gchar* g4_music_get_artist_name (G4Music* self);
VALA_EXTERN G4Playlist* g4_music_library_add_playlist (G4MusicLibrary* self,
                                           G4Playlist* playlist);
VALA_EXTERN G4Album* g4_music_library_get_album (G4MusicLibrary* self,
                                     const gchar* key);
VALA_EXTERN G4Artist* g4_music_library_get_artist (G4MusicLibrary* self,
                                       const gchar* key);
VALA_EXTERN G4Playlist* g4_music_library_get_playlist (G4MusicLibrary* self,
                                           const gchar* key);
VALA_EXTERN void g4_music_library_overwrite_albums_to (G4MusicLibrary* self,
                                           GListStore* store);
static Block54Data* block54_data_ref (Block54Data* _data54_);
static void block54_data_unref (void * _userdata_);
static void ___lambda13_ (Block54Data* _data54_,
                   const gchar* name,
                   G4Album* album);
static void ____lambda13__gh_func (gconstpointer key,
                            gconstpointer value,
                            gpointer self);
VALA_EXTERN void g4_music_library_overwrite_artists_to (G4MusicLibrary* self,
                                            GListStore* store);
static Block55Data* block55_data_ref (Block55Data* _data55_);
static void block55_data_unref (void * _userdata_);
static void ___lambda14_ (Block55Data* _data55_,
                   const gchar* name,
                   G4Artist* artist);
static void ____lambda14__gh_func (gconstpointer key,
                            gconstpointer value,
                            gpointer self);
VALA_EXTERN gint g4_music_compare_by_artist (G4Music* s1,
                                 G4Music* s2);
static gint _g4_music_compare_by_artist_gcompare_func (gconstpointer a,
                                                gconstpointer b);
VALA_EXTERN void g4_music_library_overwrite_playlists_to (G4MusicLibrary* self,
                                              GListStore* store);
static Block56Data* block56_data_ref (Block56Data* _data56_);
static void block56_data_unref (void * _userdata_);
static void ___lambda15_ (Block56Data* _data56_,
                   const gchar* uri,
                   G4Playlist* playlist);
static void ____lambda15__gh_func (gconstpointer key,
                            gconstpointer value,
                            gpointer self);
VALA_EXTERN gint g4_music_compare_by_title (G4Music* s1,
                                G4Music* s2);
static gint _g4_music_compare_by_title_gcompare_func (gconstpointer a,
                                               gconstpointer b);
VALA_EXTERN void g4_music_library_remove_music (G4MusicLibrary* self,
                                    G4Music* music);
static Block57Data* block57_data_ref (Block57Data* _data57_);
static void block57_data_unref (void * _userdata_);
static gboolean ____lambda16_ (Block57Data* _data57_,
                        const gchar* name,
                        G4Album* album);
static gboolean _____lambda16__ghr_func (gconstpointer key,
                                  gconstpointer value,
                                  gpointer self);
static gboolean ____lambda17_ (Block57Data* _data57_,
                        const gchar* name,
                        G4Artist* artist);
static gboolean _____lambda17__ghr_func (gconstpointer key,
                                  gconstpointer value,
                                  gpointer self);
VALA_EXTERN gboolean g4_music_library_remove_playlist (G4MusicLibrary* self,
                                           const gchar* key);
VALA_EXTERN gboolean g4_music_library_remove_uri (G4MusicLibrary* self,
                                      const gchar* uri,
                                      GHashTable* removed);
static Block58Data* block58_data_ref (Block58Data* _data58_);
static void block58_data_unref (void * _userdata_);
static gboolean ___lambda18_ (Block58Data* _data58_,
                       const gchar* name,
                       G4Album* album);
static gboolean __lambda19_ (Block58Data* _data58_,
                      const gchar* uri,
                      G4Music* music);
static gboolean ___lambda19__ghr_func (gconstpointer key,
                                gconstpointer value,
                                gpointer self);
static gboolean ____lambda18__ghr_func (gconstpointer key,
                                 gconstpointer value,
                                 gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void ___lambda2__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
static void __lambda20_ (G4MusicLibrary* self,
                  G4Music* music);
static Block59Data* block59_data_ref (Block59Data* _data59_);
static void block59_data_unref (void * _userdata_);
static gboolean ___lambda21_ (Block59Data* _data59_,
                       const gchar* name,
                       G4Artist* artist);
static gboolean ____lambda21__ghr_func (gconstpointer key,
                                 gconstpointer value,
                                 gpointer self);
static void ___lambda20__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN void g4_music_library_remove_all (G4MusicLibrary* self);
VALA_EXTERN G4MusicLibrary* g4_music_library_new (void);
VALA_EXTERN G4MusicLibrary* g4_music_library_construct (GType object_type);
VALA_EXTERN gboolean g4_music_library_get_empty (G4MusicLibrary* self);
VALA_EXTERN guint g4_music_library_get_album_count (G4MusicLibrary* self);
VALA_EXTERN guint g4_music_library_get_artist_count (G4MusicLibrary* self);
VALA_EXTERN guint g4_music_library_get_playlist_count (G4MusicLibrary* self);
static void g4_music_library_finalize (GObject * obj);
static GType g4_music_library_get_type_once (void);
static void _vala_g4_music_library_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
VALA_EXTERN gint g4_find_item_in_model (GListModel* model,
                            GObject* obj,
                            gint start_pos);
VALA_EXTERN gboolean g4_merge_items_to_store (GListStore* store,
                                  GPtrArray* arr,
                                  guint* position);
VALA_EXTERN gint g4_remove_items_from_store (GListStore* store,
                                 GPtrArray* arr,
                                 gint* first_pos);
static Block60Data* block60_data_ref (Block60Data* _data60_);
static void block60_data_unref (void * _userdata_);
static void __lambda48_ (Block60Data* _data60_,
                  G4Music* obj);
static void ___lambda48__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN void g4_sort_music_array (GPtrArray* arr,
                          guint sort_mode);
VALA_EXTERN void g4_music_shuffle_order (GPtrArray* arr);
VALA_EXTERN gint g4_music_compare_by_artist_album (G4Music* s1,
                                       G4Music* s2);
static gint _g4_music_compare_by_artist_album_gcompare_func (gconstpointer a,
                                                      gconstpointer b);
VALA_EXTERN gint g4_music_compare_by_recent (G4Music* s1,
                                 G4Music* s2);
static gint _g4_music_compare_by_recent_gcompare_func (gconstpointer a,
                                                gconstpointer b);
VALA_EXTERN void g4_sort_music_store (GListStore* store,
                          guint sort_mode);
VALA_EXTERN G4Playlist* g4_to_playlist (G4Music** musics,
                            gint musics_length1,
                            const gchar* title);
static Block61Data* block61_data_ref (Block61Data* _data61_);
static void block61_data_unref (void * _userdata_);
static void __lambda63_ (Block61Data* _data61_,
                  G4Music* music);
static void ___lambda63__gfunc (gconstpointer data,
                         gpointer self);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

G4Album*
g4_album_construct (GType object_type,
                    G4Music* music)
{
	G4Album * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (music != NULL, NULL);
	_tmp0_ = music->album;
	_tmp1_ = music->uri;
	self = (G4Album*) g4_music_construct_titled (object_type, _tmp0_, _tmp1_);
	_tmp2_ = music->album;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->album);
	G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->album = _tmp3_;
	_tmp4_ = music->artist;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->artist);
	G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->artist = _tmp5_;
	_tmp6_ = music->_album_key;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->_album_key);
	G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->_album_key = _tmp7_;
	_tmp8_ = music->_artist_key;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->_artist_key);
	G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->_artist_key = _tmp9_;
	G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->date = music->date;
	G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->track = music->track;
	_tmp10_ = music->uri;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->uri);
	G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->uri = _tmp11_;
	return self;
}

G4Album*
g4_album_new (G4Music* music)
{
	return g4_album_construct (G4_TYPE_ALBUM, music);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
g4_album_add_music (G4Album* self,
                    G4Music* music)
{
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp3_;
	const gchar* _tmp4_;
	G4Music* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (music != NULL, FALSE);
	if (music->has_cover) {
		_tmp0_ = music->track < ((G4Music*) self)->track;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		((G4Music*) self)->has_cover = TRUE;
		_tmp1_ = music->uri;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (((G4Music*) self)->uri);
		((G4Music*) self)->uri = _tmp2_;
	}
	_tmp3_ = self->_musics;
	_tmp4_ = music->uri;
	_tmp5_ = _g_object_ref0 (music);
	result = g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
	return result;
}

gboolean
g4_album_insert_music (G4Album* self,
                       G4Music* music)
{
	guint count = 0U;
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GHashTable* _tmp3_;
	const gchar* _tmp4_;
	G4Music* _tmp5_;
	GHashTable* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (music != NULL, FALSE);
	_tmp0_ = self->_musics;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	count = _tmp2_;
	_tmp3_ = self->_musics;
	_tmp4_ = music->uri;
	_tmp5_ = _g_object_ref0 (music);
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
	_tmp6_ = self->_musics;
	_tmp7_ = g_hash_table_size (_tmp6_);
	_tmp8_ = _tmp7_;
	result = _tmp8_ > count;
	return result;
}

gboolean
g4_album_contains (G4Album* self,
                   const gchar* uri)
{
	GHashTable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = self->_musics;
	result = g_hash_table_contains (_tmp0_, uri);
	return result;
}

guint
g4_album_foreach_remove (G4Album* self,
                         GHRFunc func,
                         gpointer func_target)
{
	GHashTable* _tmp0_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->_musics;
	result = g_hash_table_foreach_remove (_tmp0_, func, func_target);
	return result;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static Block49Data*
block49_data_ref (Block49Data* _data49_)
{
	g_atomic_int_inc (&_data49_->_ref_count_);
	return _data49_;
}

static void
block49_data_unref (void * _userdata_)
{
	Block49Data* _data49_;
	_data49_ = (Block49Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data49_->_ref_count_)) {
		G4Album* self;
		self = _data49_->self;
		_g_ptr_array_unref0 (_data49_->musics);
		_g_object_unref0 (self);
		g_slice_free (Block49Data, _data49_);
	}
}

static void
__lambda6_ (Block49Data* _data49_,
            const gchar* name,
            G4Music* music)
{
	G4Album* self;
	G4Music* _tmp0_;
	self = _data49_->self;
	g_return_if_fail (name != NULL);
	g_return_if_fail (music != NULL);
	_tmp0_ = _g_object_ref0 (music);
	g_ptr_array_add (_data49_->musics, _tmp0_);
}

static void
___lambda6__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda6_ (self, (const gchar*) key, (G4Music*) value);
}

static void
g4_album_real_get_sorted_musics (G4Album* self,
                                 GPtrArray* musics)
{
	Block49Data* _data49_;
	GPtrArray* _tmp0_;
	GHashTable* _tmp1_;
	g_return_if_fail (musics != NULL);
	_data49_ = g_slice_new0 (Block49Data);
	_data49_->_ref_count_ = 1;
	_data49_->self = g_object_ref (self);
	_tmp0_ = _g_ptr_array_ref0 (musics);
	_g_ptr_array_unref0 (_data49_->musics);
	_data49_->musics = _tmp0_;
	_tmp1_ = self->_musics;
	g_hash_table_foreach (_tmp1_, ___lambda6__gh_func, _data49_);
	g4_album_sort (self, _data49_->musics);
	block49_data_unref (_data49_);
	_data49_ = NULL;
}

void
g4_album_get_sorted_musics (G4Album* self,
                            GPtrArray* musics)
{
	G4AlbumClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = G4_ALBUM_GET_CLASS (self);
	if (_klass_->get_sorted_musics) {
		_klass_->get_sorted_musics (self, musics);
	}
}

void
g4_album_overwrite_to (G4Album* self,
                       GListStore* store)
{
	GPtrArray* musics = NULL;
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GPtrArray* _tmp3_;
	gpointer* _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = self->_musics;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_ptr_array_new_full (_tmp2_, _g_object_unref0_);
	musics = _tmp3_;
	g4_album_get_sorted_musics (self, musics);
	_tmp4_ = musics->pdata;
	_tmp4__length1 = musics->len;
	g_list_store_splice (store, (guint) 0, g_list_model_get_n_items ((GListModel*) store), (GObject**) _tmp4_, (guint) ((_tmp4__length1 * sizeof (G4Music*)) / sizeof (GObject*)));
	_g_ptr_array_unref0 (musics);
}

gboolean
g4_album_remove_music (G4Album* self,
                       G4Music* music)
{
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (music != NULL, FALSE);
	_tmp0_ = self->_musics;
	_tmp1_ = music->uri;
	result = g_hash_table_remove (_tmp0_, _tmp1_);
	return result;
}

static Block44Data*
block44_data_ref (Block44Data* _data44_)
{
	g_atomic_int_inc (&_data44_->_ref_count_);
	return _data44_;
}

static void
block44_data_unref (void * _userdata_)
{
	Block44Data* _data44_;
	_data44_ = (Block44Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data44_->_ref_count_)) {
		GPtrArray* self;
		self = _data44_->self;
		_g_ptr_array_unref0 (self);
		g_slice_free (Block44Data, _data44_);
	}
}

static gint
__lambda0_ (Block44Data* _data44_,
            gconstpointer** a,
            gconstpointer** b)
{
	GPtrArray* self;
	gint result;
	self = _data44_->self;
	result = _data44_->compare_func ((gconstpointer**) (*a), (gconstpointer**) (*b));
	return result;
}

static gint
___lambda0__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda0_ (self, a, b);
	return result;
}

static void
vala_g_ptr_array_sort (GPtrArray* self,
                       GCompareFunc compare_func)
{
	Block44Data* _data44_;
	g_return_if_fail (self != NULL);
	_data44_ = g_slice_new0 (Block44Data);
	_data44_->_ref_count_ = 1;
	_data44_->self = g_ptr_array_ref (self);
	_data44_->compare_func = compare_func;
	g_ptr_array_sort_with_data (self, ___lambda0__gcompare_data_func, _data44_);
	block44_data_unref (_data44_);
	_data44_ = NULL;
}

static gint
_g4_music_compare_by_album_gcompare_func (gconstpointer a,
                                          gconstpointer b)
{
	gint result;
	result = g4_music_compare_by_album ((G4Music*) a, (G4Music*) b);
	return result;
}

static void
g4_album_real_sort (G4Album* self,
                    GPtrArray* arr)
{
	g_return_if_fail (arr != NULL);
	vala_g_ptr_array_sort (arr, _g4_music_compare_by_album_gcompare_func);
}

void
g4_album_sort (G4Album* self,
               GPtrArray* arr)
{
	G4AlbumClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = G4_ALBUM_GET_CLASS (self);
	if (_klass_->sort) {
		_klass_->sort (self, arr);
	}
}

guint
g4_album_get_length (G4Album* self)
{
	guint result;
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->_musics;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
g4_album_class_init (G4AlbumClass * klass,
                     gpointer klass_data)
{
	g4_album_parent_class = g_type_class_peek_parent (klass);
	((G4AlbumClass *) klass)->get_sorted_musics = (void (*) (G4Album*, GPtrArray*)) g4_album_real_get_sorted_musics;
	((G4AlbumClass *) klass)->sort = (void (*) (G4Album*, GPtrArray*)) g4_album_real_sort;
	G_OBJECT_CLASS (klass)->get_property = _vala_g4_album_get_property;
	G_OBJECT_CLASS (klass)->finalize = g4_album_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_ALBUM_LENGTH_PROPERTY, g4_album_properties[G4_ALBUM_LENGTH_PROPERTY] = g_param_spec_uint ("length", "length", "length", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
g4_album_instance_init (G4Album * self,
                        gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_object_unref0_);
	self->_musics = _tmp2_;
}

static void
g4_album_finalize (GObject * obj)
{
	G4Album * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_TYPE_ALBUM, G4Album);
	_g_hash_table_unref0 (self->_musics);
	G_OBJECT_CLASS (g4_album_parent_class)->finalize (obj);
}

static GType
g4_album_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (G4AlbumClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_album_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (G4Album), 0, (GInstanceInitFunc) g4_album_instance_init, NULL };
	GType g4_album_type_id;
	g4_album_type_id = g_type_register_static (G4_TYPE_MUSIC, "G4Album", &g_define_type_info, 0);
	return g4_album_type_id;
}

GType
g4_album_get_type (void)
{
	static volatile gsize g4_album_type_id__once = 0;
	if (g_once_init_enter (&g4_album_type_id__once)) {
		GType g4_album_type_id;
		g4_album_type_id = g4_album_get_type_once ();
		g_once_init_leave (&g4_album_type_id__once, g4_album_type_id);
	}
	return g4_album_type_id__once;
}

static void
_vala_g4_album_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	G4Album * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_ALBUM, G4Album);
	switch (property_id) {
		case G4_ALBUM_LENGTH_PROPERTY:
		g_value_set_uint (value, g4_album_get_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

G4Artist*
g4_artist_construct (GType object_type,
                     G4Music* music,
                     const gchar* artist_name)
{
	G4Artist * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (music != NULL, NULL);
	g_return_val_if_fail (artist_name != NULL, NULL);
	_tmp0_ = music->uri;
	self = (G4Artist*) g4_music_construct_titled (object_type, artist_name, _tmp0_);
	_tmp1_ = g_strdup (artist_name);
	_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->artist);
	G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->artist = _tmp1_;
	_tmp2_ = music->album_artist;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->album_artist);
	G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->album_artist = _tmp3_;
	_tmp4_ = g_utf8_collate_key_for_filename (artist_name, (gssize) -1);
	_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->_artist_key);
	G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->_artist_key = _tmp4_;
	G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->date = music->date;
	_tmp5_ = music->uri;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->uri);
	G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_MUSIC, G4Music)->uri = _tmp6_;
	return self;
}

G4Artist*
g4_artist_new (G4Music* music,
               const gchar* artist_name)
{
	return g4_artist_construct (G4_TYPE_ARTIST, music, artist_name);
}

static gchar*
g4_artist_real_get_abbreviation (G4Music* base)
{
	G4Artist * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (G4Artist*) base;
	_tmp0_ = ((G4Music*) self)->artist;
	_tmp1_ = g4_parse_abbreviation (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
g4_artist_add_music (G4Artist* self,
                     G4Music* music)
{
	const gchar* key = NULL;
	const gchar* album_key = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	G4Album* album = NULL;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	gconstpointer _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	gboolean _tmp6_;
	G4Album* _tmp7_;
	gboolean added = FALSE;
	G4Album* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (music != NULL, FALSE);
	_tmp0_ = g4_music_get_album_key (music);
	_tmp1_ = _tmp0_;
	album_key = _tmp1_;
	_tmp2_ = self->_albums;
	_tmp3_ = album_key;
	_tmp6_ = g_hash_table_lookup_extended (_tmp2_, _tmp3_, &_tmp4_, &_tmp5_);
	key = (const gchar*) _tmp4_;
	_g_object_unref0 (album);
	_tmp7_ = _g_object_ref0 ((G4Album*) _tmp5_);
	album = _tmp7_;
	if (!_tmp6_) {
		G4Album* _tmp8_;
		G4Album* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		GHashTable* _tmp12_;
		const gchar* _tmp13_;
		G4Album* _tmp14_;
		G4Album* _tmp15_;
		_tmp8_ = g4_album_new (music);
		_g_object_unref0 (album);
		album = _tmp8_;
		_tmp9_ = album;
		_tmp10_ = ((G4Music*) self)->artist;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (((G4Music*) _tmp9_)->album_artist);
		((G4Music*) _tmp9_)->album_artist = _tmp11_;
		_tmp12_ = self->_albums;
		_tmp13_ = album_key;
		_tmp14_ = album;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		g_hash_table_insert (_tmp12_, _tmp13_, _tmp15_);
	}
	_tmp16_ = album;
	added = g4_album_add_music (_tmp16_, music);
	if (added) {
		G4Album* _tmp19_;
		_tmp19_ = album;
		_tmp18_ = ((G4Music*) _tmp19_)->has_cover;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		_tmp17_ = !((G4Music*) self)->has_cover;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		G4Album* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		((G4Music*) self)->has_cover = TRUE;
		_tmp20_ = album;
		_tmp21_ = ((G4Music*) _tmp20_)->uri;
		_tmp22_ = g_strdup (_tmp21_);
		_g_free0 (((G4Music*) self)->uri);
		((G4Music*) self)->uri = _tmp22_;
	}
	result = added;
	_g_object_unref0 (album);
	return result;
}

static Block50Data*
block50_data_ref (Block50Data* _data50_)
{
	g_atomic_int_inc (&_data50_->_ref_count_);
	return _data50_;
}

static void
block50_data_unref (void * _userdata_)
{
	Block50Data* _data50_;
	_data50_ = (Block50Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data50_->_ref_count_)) {
		G4Artist* self;
		self = _data50_->self;
		_g_free0 (_data50_->artist);
		_g_object_unref0 (self);
		g_slice_free (Block50Data, _data50_);
	}
}

static gboolean
__lambda7_ (Block50Data* _data50_,
            const gchar* name,
            G4Album* album)
{
	G4Artist* self;
	const gchar* _tmp0_;
	gboolean result;
	self = _data50_->self;
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (album != NULL, FALSE);
	_tmp0_ = ((G4Music*) album)->artist;
	result = g_str_match_string (_data50_->artist, _tmp0_, TRUE);
	return result;
}

static gboolean
___lambda7__ghr_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	gboolean result;
	result = __lambda7_ (self, (const gchar*) key, (G4Album*) value);
	return result;
}

G4Album*
g4_artist_find_by_partial_artist (G4Artist* self,
                                  const gchar* artist)
{
	Block50Data* _data50_;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	G4Album* _tmp3_;
	G4Album* _tmp4_;
	G4Album* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (artist != NULL, NULL);
	_data50_ = g_slice_new0 (Block50Data);
	_data50_->_ref_count_ = 1;
	_data50_->self = g_object_ref (self);
	_tmp0_ = g_strdup (artist);
	_g_free0 (_data50_->artist);
	_data50_->artist = _tmp0_;
	_tmp1_ = self->_albums;
	_tmp2_ = g_hash_table_find (_tmp1_, ___lambda7__ghr_func, _data50_);
	_tmp3_ = (G4Album*) _tmp2_;
	_tmp4_ = _g_object_ref0 (G4_IS_ALBUM (_tmp3_) ? ((G4Album*) _tmp3_) : NULL);
	result = _tmp4_;
	block50_data_unref (_data50_);
	_data50_ = NULL;
	return result;
}

G4Album*
g4_artist_get (G4Artist* self,
               const gchar* name)
{
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	G4Album* _tmp2_;
	G4Album* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->_albums;
	_tmp1_ = g_hash_table_lookup (_tmp0_, name);
	_tmp2_ = _g_object_ref0 ((G4Album*) _tmp1_);
	result = _tmp2_;
	return result;
}

static Block51Data*
block51_data_ref (Block51Data* _data51_)
{
	g_atomic_int_inc (&_data51_->_ref_count_);
	return _data51_;
}

static void
block51_data_unref (void * _userdata_)
{
	Block51Data* _data51_;
	_data51_ = (Block51Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data51_->_ref_count_)) {
		G4Artist* self;
		self = _data51_->self;
		_g_ptr_array_unref0 (_data51_->albums);
		_g_object_unref0 (self);
		g_slice_free (Block51Data, _data51_);
	}
}

static void
__lambda8_ (Block51Data* _data51_,
            const gchar* name,
            G4Album* album)
{
	G4Artist* self;
	G4Album* _tmp0_;
	self = _data51_->self;
	g_return_if_fail (name != NULL);
	g_return_if_fail (album != NULL);
	_tmp0_ = _g_object_ref0 (album);
	g_ptr_array_add (_data51_->albums, _tmp0_);
}

static void
___lambda8__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda8_ (self, (const gchar*) key, (G4Album*) value);
}

static gint
_g4_artist_compare_album_gcompare_func (gconstpointer a,
                                        gconstpointer b)
{
	gint result;
	result = g4_artist_compare_album ((G4Music*) a, (G4Music*) b);
	return result;
}

void
g4_artist_get_sorted_albums (G4Artist* self,
                             GPtrArray* albums)
{
	Block51Data* _data51_;
	GPtrArray* _tmp0_;
	GHashTable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (albums != NULL);
	_data51_ = g_slice_new0 (Block51Data);
	_data51_->_ref_count_ = 1;
	_data51_->self = g_object_ref (self);
	_tmp0_ = _g_ptr_array_ref0 (albums);
	_g_ptr_array_unref0 (_data51_->albums);
	_data51_->albums = _tmp0_;
	_tmp1_ = self->_albums;
	g_hash_table_foreach (_tmp1_, ___lambda8__gh_func, _data51_);
	vala_g_ptr_array_sort (_data51_->albums, _g4_artist_compare_album_gcompare_func);
	block51_data_unref (_data51_);
	_data51_ = NULL;
}

static Block52Data*
block52_data_ref (Block52Data* _data52_)
{
	g_atomic_int_inc (&_data52_->_ref_count_);
	return _data52_;
}

static void
block52_data_unref (void * _userdata_)
{
	Block52Data* _data52_;
	_data52_ = (Block52Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data52_->_ref_count_)) {
		G4Artist* self;
		self = _data52_->self;
		_g_ptr_array_unref0 (_data52_->musics);
		_g_object_unref0 (self);
		g_slice_free (Block52Data, _data52_);
	}
}

static void
__lambda9_ (Block52Data* _data52_,
            G4Album* album)
{
	G4Artist* self;
	self = _data52_->self;
	g_return_if_fail (album != NULL);
	g4_album_get_sorted_musics (album, _data52_->musics);
}

static void
___lambda9__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda9_ (self, (G4Album*) data);
}

void
g4_artist_get_sorted_musics (G4Artist* self,
                             GPtrArray* musics)
{
	Block52Data* _data52_;
	GPtrArray* _tmp0_;
	GPtrArray* arr = NULL;
	GHashTable* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GPtrArray* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (musics != NULL);
	_data52_ = g_slice_new0 (Block52Data);
	_data52_->_ref_count_ = 1;
	_data52_->self = g_object_ref (self);
	_tmp0_ = _g_ptr_array_ref0 (musics);
	_g_ptr_array_unref0 (_data52_->musics);
	_data52_->musics = _tmp0_;
	_tmp1_ = self->_albums;
	_tmp2_ = g_hash_table_size (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_ptr_array_new_full (_tmp3_, _g_object_unref0_);
	arr = _tmp4_;
	g4_artist_get_sorted_albums (self, arr);
	g_ptr_array_foreach (arr, ___lambda9__gfunc, _data52_);
	_g_ptr_array_unref0 (arr);
	block52_data_unref (_data52_);
	_data52_ = NULL;
}

void
g4_artist_overwrite_store (G4Artist* self,
                           GListStore* store)
{
	GPtrArray* arr = NULL;
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GPtrArray* _tmp3_;
	gpointer* _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = self->_albums;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_ptr_array_new_full (_tmp2_, _g_object_unref0_);
	arr = _tmp3_;
	g4_artist_get_sorted_albums (self, arr);
	_tmp4_ = arr->pdata;
	_tmp4__length1 = arr->len;
	g_list_store_splice (store, (guint) 0, g_list_model_get_n_items ((GListModel*) store), (GObject**) _tmp4_, (guint) ((_tmp4__length1 * sizeof (G4Album*)) / sizeof (GObject*)));
	_g_ptr_array_unref0 (arr);
}

static Block53Data*
block53_data_ref (Block53Data* _data53_)
{
	g_atomic_int_inc (&_data53_->_ref_count_);
	return _data53_;
}

static void
block53_data_unref (void * _userdata_)
{
	Block53Data* _data53_;
	_data53_ = (Block53Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data53_->_ref_count_)) {
		G4Artist* self;
		self = _data53_->self;
		_g_object_unref0 (_data53_->music);
		_g_object_unref0 (self);
		g_slice_free (Block53Data, _data53_);
	}
}

static gboolean
__lambda10_ (Block53Data* _data53_,
             const gchar* name,
             G4Album* album)
{
	G4Artist* self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = _data53_->self;
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (album != NULL, FALSE);
	if (g4_album_remove_music (album, _data53_->music)) {
		guint _tmp1_;
		guint _tmp2_;
		_tmp1_ = g4_album_get_length (album);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
___lambda10__ghr_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	gboolean result;
	result = __lambda10_ (self, (const gchar*) key, (G4Album*) value);
	return result;
}

gboolean
g4_artist_remove_music (G4Artist* self,
                        G4Music* music)
{
	Block53Data* _data53_;
	G4Music* _tmp0_;
	const gchar* album_key = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	G4Album* album = NULL;
	GHashTable* _tmp3_;
	const gchar* _tmp4_;
	gconstpointer _tmp5_;
	G4Album* _tmp6_;
	G4Album* _tmp7_;
	GHashTable* _tmp14_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (music != NULL, FALSE);
	_data53_ = g_slice_new0 (Block53Data);
	_data53_->_ref_count_ = 1;
	_data53_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (music);
	_g_object_unref0 (_data53_->music);
	_data53_->music = _tmp0_;
	_tmp1_ = g4_music_get_album_key (_data53_->music);
	_tmp2_ = _tmp1_;
	album_key = _tmp2_;
	_tmp3_ = self->_albums;
	_tmp4_ = album_key;
	_tmp5_ = g_hash_table_lookup (_tmp3_, _tmp4_);
	_tmp6_ = _g_object_ref0 ((G4Album*) _tmp5_);
	album = _tmp6_;
	_tmp7_ = album;
	if (G4_IS_ALBUM (_tmp7_)) {
		gboolean ret = FALSE;
		G4Album* _tmp8_;
		G4Album* _tmp9_;
		guint _tmp10_;
		guint _tmp11_;
		_tmp8_ = album;
		ret = g4_album_remove_music (_tmp8_, _data53_->music);
		_tmp9_ = album;
		_tmp10_ = g4_album_get_length (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == ((guint) 0)) {
			GHashTable* _tmp12_;
			const gchar* _tmp13_;
			_tmp12_ = self->_albums;
			_tmp13_ = album_key;
			g_hash_table_remove (_tmp12_, _tmp13_);
		}
		result = ret;
		_g_object_unref0 (album);
		block53_data_unref (_data53_);
		_data53_ = NULL;
		return result;
	}
	_tmp14_ = self->_albums;
	result = g_hash_table_foreach_remove (_tmp14_, ___lambda10__ghr_func, _data53_) > ((guint) 0);
	_g_object_unref0 (album);
	block53_data_unref (_data53_);
	_data53_ = NULL;
	return result;
}

G4Playlist*
g4_artist_to_playlist (G4Artist* self)
{
	G4Playlist* playlist = NULL;
	const gchar* _tmp0_;
	G4Playlist* _tmp1_;
	GPtrArray* _tmp2_;
	G4Playlist* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((G4Music*) self)->title;
	_tmp1_ = g4_playlist_new (_tmp0_, "");
	playlist = _tmp1_;
	_tmp2_ = playlist->items;
	g4_artist_get_sorted_musics (self, _tmp2_);
	g4_playlist_set_cover_uri (playlist);
	result = playlist;
	return result;
}

static gint
g4_artist_compare_album (G4Music* m1,
                         G4Music* m2)
{
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint result;
	g_return_val_if_fail (m1 != NULL, 0);
	g_return_val_if_fail (m2 != NULL, 0);
	if (m1->date > ((guint32) 0)) {
		_tmp1_ = m2->date > ((guint32) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = (gint) (m1->date - m2->date);
	} else {
		GCompareFunc _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = ((GCompareFunc) g_strcmp0);
		_tmp3_ = m1->_album_key;
		_tmp4_ = m2->_album_key;
		_tmp0_ = _tmp2_ (_tmp3_, _tmp4_);
	}
	result = _tmp0_;
	return result;
}

guint
g4_artist_get_length (G4Artist* self)
{
	guint result;
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->_albums;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
g4_artist_class_init (G4ArtistClass * klass,
                      gpointer klass_data)
{
	g4_artist_parent_class = g_type_class_peek_parent (klass);
	((G4MusicClass *) klass)->get_abbreviation = (gchar* (*) (G4Music*)) g4_artist_real_get_abbreviation;
	G_OBJECT_CLASS (klass)->get_property = _vala_g4_artist_get_property;
	G_OBJECT_CLASS (klass)->finalize = g4_artist_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_ARTIST_LENGTH_PROPERTY, g4_artist_properties[G4_ARTIST_LENGTH_PROPERTY] = g_param_spec_uint ("length", "length", "length", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
g4_artist_instance_init (G4Artist * self,
                         gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_object_unref0_);
	self->_albums = _tmp2_;
}

static void
g4_artist_finalize (GObject * obj)
{
	G4Artist * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_TYPE_ARTIST, G4Artist);
	_g_hash_table_unref0 (self->_albums);
	G_OBJECT_CLASS (g4_artist_parent_class)->finalize (obj);
}

static GType
g4_artist_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (G4ArtistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_artist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (G4Artist), 0, (GInstanceInitFunc) g4_artist_instance_init, NULL };
	GType g4_artist_type_id;
	g4_artist_type_id = g_type_register_static (G4_TYPE_MUSIC, "G4Artist", &g_define_type_info, 0);
	return g4_artist_type_id;
}

GType
g4_artist_get_type (void)
{
	static volatile gsize g4_artist_type_id__once = 0;
	if (g_once_init_enter (&g4_artist_type_id__once)) {
		GType g4_artist_type_id;
		g4_artist_type_id = g4_artist_get_type_once ();
		g_once_init_leave (&g4_artist_type_id__once, g4_artist_type_id);
	}
	return g4_artist_type_id__once;
}

static void
_vala_g4_artist_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	G4Artist * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_ARTIST, G4Artist);
	switch (property_id) {
		case G4_ARTIST_LENGTH_PROPERTY:
		g_value_set_uint (value, g4_artist_get_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

G4Playlist*
g4_playlist_construct (GType object_type,
                       const gchar* name,
                       const gchar* uri)
{
	G4Playlist * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	self = (G4Playlist*) g4_music_construct_titled (object_type, name, "");
	_tmp0_ = g_strdup (name);
	_g_free0 (((G4Music*) G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_ALBUM, G4Album))->album);
	((G4Music*) G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_ALBUM, G4Album))->album = _tmp0_;
	g4_playlist_set_list_uri (self, uri);
	return self;
}

G4Playlist*
g4_playlist_new (const gchar* name,
                 const gchar* uri)
{
	return g4_playlist_construct (G4_TYPE_PLAYLIST, name, uri);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

gboolean
g4_playlist_add_music (G4Playlist* self,
                       G4Music* music)
{
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	G4Music* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (music != NULL, FALSE);
	_tmp0_ = ((G4Album*) self)->_musics;
	_tmp1_ = music->uri;
	_tmp2_ = _g_object_ref0 (music);
	if (g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_)) {
		gint count = 0;
		GPtrArray* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		GPtrArray* _tmp6_;
		G4Music* _tmp7_;
		GPtrArray* _tmp8_;
		gconstpointer _tmp9_;
		_tmp3_ = self->items;
		_tmp4_ = vala_g_ptr_array_get_length (_tmp3_);
		_tmp5_ = _tmp4_;
		count = _tmp5_;
		_tmp6_ = self->items;
		_tmp7_ = _g_object_ref0 (music);
		g_ptr_array_add (_tmp6_, _tmp7_);
		_tmp8_ = self->items;
		_tmp9_ = g_ptr_array_index (_tmp8_, (guint) count);
		((G4Music*) _tmp9_)->_order = count;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

void
g4_playlist_clear (G4Playlist* self)
{
	GHashTable* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((G4Album*) self)->_musics;
	g_hash_table_remove_all (_tmp0_);
	_tmp1_ = self->items;
	_tmp2_ = self->items;
	_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
	_tmp4_ = _tmp3_;
	g_ptr_array_remove_range (_tmp1_, (guint) 0, (guint) _tmp4_);
}

void
g4_playlist_copy_from (G4Playlist* self,
                       G4Playlist* playlist)
{
	GPtrArray* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (playlist != NULL);
	g4_playlist_clear (self);
	_tmp0_ = playlist->items;
	g4_playlist_extend (self, _tmp0_);
	g4_playlist_set_cover_uri (self);
	_tmp1_ = ((G4Music*) playlist)->title;
	g4_playlist_set_title (self, _tmp1_);
}

static G4Music*
__lambda11_ (G4Playlist* self,
             G4Music* src)
{
	G4Music* _tmp0_;
	G4Music* result;
	g_return_val_if_fail (src != NULL, NULL);
	_tmp0_ = _g_object_ref0 (src);
	result = _tmp0_;
	return result;
}

static gpointer
___lambda11__gcopy_func (gconstpointer src,
                         gpointer self)
{
	gpointer result;
	result = __lambda11_ ((G4Playlist*) self, (G4Music*) src);
	return result;
}

void
g4_playlist_extend (G4Playlist* self,
                    GPtrArray* musics)
{
	GPtrArray* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (musics != NULL);
	_tmp0_ = self->items;
	g_ptr_array_extend (_tmp0_, musics, ___lambda11__gcopy_func, self);
}

gboolean
g4_playlist_remove_music (G4Playlist* self,
                          G4Music* music)
{
	GPtrArray* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (music != NULL, FALSE);
	g4_album_remove_music (G_TYPE_CHECK_INSTANCE_CAST (self, G4_TYPE_ALBUM, G4Album), music);
	_tmp0_ = self->items;
	result = g_ptr_array_remove (_tmp0_, music);
	return result;
}

static G4Music*
__lambda12_ (G4Playlist* self,
             G4Music* src)
{
	G4Music* _tmp0_;
	G4Music* result;
	g_return_val_if_fail (src != NULL, NULL);
	_tmp0_ = _g_object_ref0 (src);
	result = _tmp0_;
	return result;
}

static gpointer
___lambda12__gcopy_func (gconstpointer src,
                         gpointer self)
{
	gpointer result;
	result = __lambda12_ ((G4Playlist*) self, (G4Music*) src);
	return result;
}

static void
g4_playlist_real_get_sorted_musics (G4Album* base,
                                    GPtrArray* musics)
{
	G4Playlist * self;
	GPtrArray* _tmp0_;
	self = (G4Playlist*) base;
	g_return_if_fail (musics != NULL);
	_tmp0_ = self->items;
	g_ptr_array_extend (musics, _tmp0_, ___lambda12__gcopy_func, self);
}

void
g4_playlist_insert_to_store (G4Playlist* self,
                             GListStore* store,
                             guint position)
{
	guint size = 0U;
	GPtrArray* _tmp0_;
	gpointer* _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	size = g_list_model_get_n_items ((GListModel*) store);
	_tmp0_ = self->items;
	_tmp1_ = _tmp0_->pdata;
	_tmp1__length1 = _tmp0_->len;
	g_list_store_splice (store, MIN (position, size), (guint) 0, (GObject**) _tmp1_, (guint) ((_tmp1__length1 * sizeof (G4Music*)) / sizeof (GObject*)));
}

void
g4_playlist_reset_original_order (G4Playlist* self)
{
	GPtrArray* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->items;
	g4_music_original_order (_tmp0_);
}

void
g4_playlist_set_cover_uri (G4Playlist* self)
{
	GPtrArray* _tmp0_;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	((G4Music*) self)->has_cover = FALSE;
	_tmp0_ = self->items;
	{
		GPtrArray* music_collection = NULL;
		guint music_index = 0U;
		music_collection = _tmp0_;
		for (music_index = 0; music_index < music_collection->len; music_index = music_index + 1) {
			G4Music* _tmp1_;
			G4Music* music = NULL;
			_tmp1_ = _g_object_ref0 ((G4Music*) g_ptr_array_index (music_collection, music_index));
			music = _tmp1_;
			{
				G4Music* _tmp2_;
				_tmp2_ = music;
				if (_tmp2_->has_cover) {
					G4Music* _tmp3_;
					const gchar* _tmp4_;
					gchar* _tmp5_;
					((G4Music*) self)->has_cover = TRUE;
					_tmp3_ = music;
					_tmp4_ = _tmp3_->uri;
					_tmp5_ = g_strdup (_tmp4_);
					_g_free0 (((G4Music*) self)->uri);
					((G4Music*) self)->uri = _tmp5_;
					_g_object_unref0 (music);
					break;
				}
				_g_object_unref0 (music);
			}
		}
	}
	if (!((G4Music*) self)->has_cover) {
		GPtrArray* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp7_ = self->items;
		_tmp8_ = vala_g_ptr_array_get_length (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp6_ = _tmp9_ > 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GPtrArray* _tmp10_;
		gconstpointer _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		((G4Music*) self)->has_cover = TRUE;
		_tmp10_ = self->items;
		_tmp11_ = g_ptr_array_index (_tmp10_, (guint) 0);
		_tmp12_ = ((G4Music*) _tmp11_)->uri;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (((G4Music*) self)->uri);
		((G4Music*) self)->uri = _tmp13_;
	}
}

void
g4_playlist_set_list_uri (G4Playlist* self,
                          const gchar* uri)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_strdup (uri);
	_g_free0 (((G4Music*) self)->_album_key);
	((G4Music*) self)->_album_key = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (self->list_uri);
	self->list_uri = _tmp1_;
}

void
g4_playlist_set_title (G4Playlist* self,
                       const gchar* title)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = g_strdup (title);
	_g_free0 (((G4Music*) self)->album);
	((G4Music*) self)->album = _tmp0_;
	_tmp1_ = g_strdup (title);
	_g_free0 (((G4Music*) self)->title);
	((G4Music*) self)->title = _tmp1_;
	_tmp2_ = g_utf8_collate_key_for_filename (title, (gssize) -1);
	_g_free0 (((G4Music*) self)->_title_key);
	((G4Music*) self)->_title_key = _tmp2_;
}

static gint
_g4_music_compare_by_order_gcompare_func (gconstpointer a,
                                          gconstpointer b)
{
	gint result;
	result = g4_music_compare_by_order ((G4Music*) a, (G4Music*) b);
	return result;
}

static void
g4_playlist_real_sort (G4Album* base,
                       GPtrArray* arr)
{
	G4Playlist * self;
	GPtrArray* _tmp0_;
	self = (G4Playlist*) base;
	g_return_if_fail (arr != NULL);
	_tmp0_ = self->items;
	g4_music_original_order (_tmp0_);
	vala_g_ptr_array_sort (arr, _g4_music_compare_by_order_gcompare_func);
}

guint
g4_playlist_get_length (G4Playlist* self)
{
	guint result;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->items;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

static void
g4_playlist_class_init (G4PlaylistClass * klass,
                        gpointer klass_data)
{
	g4_playlist_parent_class = g_type_class_peek_parent (klass);
	((G4AlbumClass *) klass)->get_sorted_musics = (void (*) (G4Album*, GPtrArray*)) g4_playlist_real_get_sorted_musics;
	((G4AlbumClass *) klass)->sort = (void (*) (G4Album*, GPtrArray*)) g4_playlist_real_sort;
	G_OBJECT_CLASS (klass)->get_property = _vala_g4_playlist_get_property;
	G_OBJECT_CLASS (klass)->finalize = g4_playlist_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_PLAYLIST_LENGTH_PROPERTY, g4_playlist_properties[G4_PLAYLIST_LENGTH_PROPERTY] = g_param_spec_uint ("length", "length", "length", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
g4_playlist_instance_init (G4Playlist * self,
                           gpointer klass)
{
	GPtrArray* _tmp0_;
	_tmp0_ = g_ptr_array_new_full ((guint) 128, _g_object_unref0_);
	self->items = _tmp0_;
}

static void
g4_playlist_finalize (GObject * obj)
{
	G4Playlist * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_TYPE_PLAYLIST, G4Playlist);
	_g_ptr_array_unref0 (self->items);
	_g_free0 (self->list_uri);
	G_OBJECT_CLASS (g4_playlist_parent_class)->finalize (obj);
}

static GType
g4_playlist_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (G4PlaylistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_playlist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (G4Playlist), 0, (GInstanceInitFunc) g4_playlist_instance_init, NULL };
	GType g4_playlist_type_id;
	g4_playlist_type_id = g_type_register_static (G4_TYPE_ALBUM, "G4Playlist", &g_define_type_info, 0);
	return g4_playlist_type_id;
}

GType
g4_playlist_get_type (void)
{
	static volatile gsize g4_playlist_type_id__once = 0;
	if (g_once_init_enter (&g4_playlist_type_id__once)) {
		GType g4_playlist_type_id;
		g4_playlist_type_id = g4_playlist_get_type_once ();
		g_once_init_leave (&g4_playlist_type_id__once, g4_playlist_type_id);
	}
	return g4_playlist_type_id__once;
}

static void
_vala_g4_playlist_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	G4Playlist * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_PLAYLIST, G4Playlist);
	switch (property_id) {
		case G4_PLAYLIST_LENGTH_PROPERTY:
		g_value_set_uint (value, g4_playlist_get_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
g4_music_library_get_instance_private (G4MusicLibrary* self)
{
	return G_STRUCT_MEMBER_P (self, G4MusicLibrary_private_offset);
}

gboolean
g4_music_library_add_music (G4MusicLibrary* self,
                            G4Music* music)
{
	const gchar* key = NULL;
	const gchar* album_key = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	G4Album* album = NULL;
	gboolean added = FALSE;
	G4Album* _tmp18_;
	const gchar* artist_name = NULL;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	G4Artist* artist = NULL;
	G4Artist* _tmp36_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (music != NULL, FALSE);
	_tmp0_ = g4_music_get_album_key (music);
	_tmp1_ = _tmp0_;
	album_key = _tmp1_;
	{
		GHashTable* _tmp2_;
		_tmp2_ = self->priv->_albums;
		g_rec_mutex_lock (&self->priv->__lock__albums);
		{
			GHashTable* _tmp3_;
			const gchar* _tmp4_;
			gconstpointer _tmp5_ = NULL;
			gconstpointer _tmp6_ = NULL;
			gboolean _tmp7_;
			G4Album* _tmp8_;
			_tmp3_ = self->priv->_albums;
			_tmp4_ = album_key;
			_tmp7_ = g_hash_table_lookup_extended (_tmp3_, _tmp4_, &_tmp5_, &_tmp6_);
			key = (const gchar*) _tmp5_;
			_g_object_unref0 (album);
			_tmp8_ = _g_object_ref0 ((G4Album*) _tmp6_);
			album = _tmp8_;
			if (!_tmp7_) {
				G4Album* _tmp9_;
				G4Album* _tmp10_;
				gchar* _tmp11_;
				GHashTable* _tmp12_;
				const gchar* _tmp13_;
				G4Album* _tmp14_;
				G4Album* _tmp15_;
				_tmp9_ = g4_album_new (music);
				_g_object_unref0 (album);
				album = _tmp9_;
				_tmp10_ = album;
				_tmp11_ = g_strdup ("");
				_g_free0 (((G4Music*) _tmp10_)->album_artist);
				((G4Music*) _tmp10_)->album_artist = _tmp11_;
				_tmp12_ = self->priv->_albums;
				_tmp13_ = album_key;
				_tmp14_ = album;
				_tmp15_ = _g_object_ref0 (_tmp14_);
				g_hash_table_insert (_tmp12_, _tmp13_, _tmp15_);
			}
		}
		__finally0:
		{
			GHashTable* _tmp16_;
			_tmp16_ = self->priv->_albums;
			g_rec_mutex_unlock (&self->priv->__lock__albums);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp17_ = FALSE;
			_g_object_unref0 (album);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp17_;
		}
	}
	_tmp18_ = album;
	added = g4_album_add_music (_tmp18_, music);
	_tmp19_ = g4_music_get_artist_name (music);
	_tmp20_ = _tmp19_;
	artist_name = _tmp20_;
	{
		GHashTable* _tmp21_;
		_tmp21_ = self->priv->_artists;
		g_rec_mutex_lock (&self->priv->__lock__artists);
		{
			GHashTable* _tmp22_;
			const gchar* _tmp23_;
			gconstpointer _tmp24_ = NULL;
			gconstpointer _tmp25_ = NULL;
			gboolean _tmp26_;
			G4Artist* _tmp27_;
			_tmp22_ = self->priv->_artists;
			_tmp23_ = artist_name;
			_tmp26_ = g_hash_table_lookup_extended (_tmp22_, _tmp23_, &_tmp24_, &_tmp25_);
			key = (const gchar*) _tmp24_;
			_g_object_unref0 (artist);
			_tmp27_ = _g_object_ref0 ((G4Artist*) _tmp25_);
			artist = _tmp27_;
			if (!_tmp26_) {
				const gchar* _tmp28_;
				G4Artist* _tmp29_;
				GHashTable* _tmp30_;
				const gchar* _tmp31_;
				G4Artist* _tmp32_;
				G4Artist* _tmp33_;
				_tmp28_ = artist_name;
				_tmp29_ = g4_artist_new (music, _tmp28_);
				_g_object_unref0 (artist);
				artist = _tmp29_;
				_tmp30_ = self->priv->_artists;
				_tmp31_ = artist_name;
				_tmp32_ = artist;
				_tmp33_ = _g_object_ref0 (_tmp32_);
				g_hash_table_insert (_tmp30_, _tmp31_, _tmp33_);
			}
		}
		__finally1:
		{
			GHashTable* _tmp34_;
			_tmp34_ = self->priv->_artists;
			g_rec_mutex_unlock (&self->priv->__lock__artists);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp35_ = FALSE;
			_g_object_unref0 (artist);
			_g_object_unref0 (album);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp35_;
		}
	}
	_tmp36_ = artist;
	added |= g4_artist_add_music (_tmp36_, music);
	result = added;
	_g_object_unref0 (artist);
	_g_object_unref0 (album);
	return result;
}

G4Playlist*
g4_music_library_add_playlist (G4MusicLibrary* self,
                               G4Playlist* playlist)
{
	const gchar* key = NULL;
	G4Playlist* oldlist = NULL;
	G4Playlist* _tmp16_;
	GError* _inner_error0_ = NULL;
	G4Playlist* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (playlist != NULL, NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->_playlists;
		g_rec_mutex_lock (&self->priv->__lock__playlists);
		{
			GHashTable* _tmp1_;
			const gchar* _tmp2_;
			gconstpointer _tmp3_ = NULL;
			gconstpointer _tmp4_ = NULL;
			gboolean _tmp5_;
			G4Playlist* _tmp6_;
			_tmp1_ = self->priv->_playlists;
			_tmp2_ = playlist->list_uri;
			_tmp5_ = g_hash_table_lookup_extended (_tmp1_, _tmp2_, &_tmp3_, &_tmp4_);
			key = (const gchar*) _tmp3_;
			_g_object_unref0 (oldlist);
			_tmp6_ = _g_object_ref0 ((G4Playlist*) _tmp4_);
			oldlist = _tmp6_;
			if (_tmp5_) {
				G4Playlist* _tmp7_;
				G4Playlist* _tmp9_;
				G4Playlist* _tmp10_;
				_tmp7_ = oldlist;
				if (_tmp7_ != playlist) {
					G4Playlist* _tmp8_;
					_tmp8_ = oldlist;
					g4_playlist_copy_from (_tmp8_, playlist);
				}
				_tmp9_ = oldlist;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				result = _tmp10_;
				{
					GHashTable* _tmp11_;
					_tmp11_ = self->priv->_playlists;
					g_rec_mutex_unlock (&self->priv->__lock__playlists);
				}
				_g_object_unref0 (oldlist);
				return result;
			} else {
				GHashTable* _tmp12_;
				const gchar* _tmp13_;
				G4Playlist* _tmp14_;
				_tmp12_ = self->priv->_playlists;
				_tmp13_ = playlist->list_uri;
				_tmp14_ = _g_object_ref0 (playlist);
				g_hash_table_insert (_tmp12_, _tmp13_, _tmp14_);
			}
		}
		__finally0:
		{
			GHashTable* _tmp15_;
			_tmp15_ = self->priv->_playlists;
			g_rec_mutex_unlock (&self->priv->__lock__playlists);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (oldlist);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp16_ = _g_object_ref0 (playlist);
	result = _tmp16_;
	_g_object_unref0 (oldlist);
	return result;
}

G4Album*
g4_music_library_get_album (G4MusicLibrary* self,
                            const gchar* key)
{
	GError* _inner_error0_ = NULL;
	G4Album* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->_albums;
		g_rec_mutex_lock (&self->priv->__lock__albums);
		{
			GHashTable* _tmp1_;
			gconstpointer _tmp2_;
			G4Album* _tmp3_;
			_tmp1_ = self->priv->_albums;
			_tmp2_ = g_hash_table_lookup (_tmp1_, key);
			_tmp3_ = _g_object_ref0 ((G4Album*) _tmp2_);
			result = _tmp3_;
			{
				GHashTable* _tmp4_;
				_tmp4_ = self->priv->_albums;
				g_rec_mutex_unlock (&self->priv->__lock__albums);
			}
			return result;
		}
		__finally0:
		{
			GHashTable* _tmp5_;
			_tmp5_ = self->priv->_albums;
			g_rec_mutex_unlock (&self->priv->__lock__albums);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

G4Artist*
g4_music_library_get_artist (G4MusicLibrary* self,
                             const gchar* key)
{
	GError* _inner_error0_ = NULL;
	G4Artist* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->_artists;
		g_rec_mutex_lock (&self->priv->__lock__artists);
		{
			GHashTable* _tmp1_;
			gconstpointer _tmp2_;
			G4Artist* _tmp3_;
			_tmp1_ = self->priv->_artists;
			_tmp2_ = g_hash_table_lookup (_tmp1_, key);
			_tmp3_ = _g_object_ref0 ((G4Artist*) _tmp2_);
			result = _tmp3_;
			{
				GHashTable* _tmp4_;
				_tmp4_ = self->priv->_artists;
				g_rec_mutex_unlock (&self->priv->__lock__artists);
			}
			return result;
		}
		__finally0:
		{
			GHashTable* _tmp5_;
			_tmp5_ = self->priv->_artists;
			g_rec_mutex_unlock (&self->priv->__lock__artists);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

G4Playlist*
g4_music_library_get_playlist (G4MusicLibrary* self,
                               const gchar* key)
{
	GError* _inner_error0_ = NULL;
	G4Playlist* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->_playlists;
		g_rec_mutex_lock (&self->priv->__lock__playlists);
		{
			GHashTable* _tmp1_;
			gconstpointer _tmp2_;
			G4Playlist* _tmp3_;
			_tmp1_ = self->priv->_playlists;
			_tmp2_ = g_hash_table_lookup (_tmp1_, key);
			_tmp3_ = _g_object_ref0 ((G4Playlist*) _tmp2_);
			result = _tmp3_;
			{
				GHashTable* _tmp4_;
				_tmp4_ = self->priv->_playlists;
				g_rec_mutex_unlock (&self->priv->__lock__playlists);
			}
			return result;
		}
		__finally0:
		{
			GHashTable* _tmp5_;
			_tmp5_ = self->priv->_playlists;
			g_rec_mutex_unlock (&self->priv->__lock__playlists);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static Block54Data*
block54_data_ref (Block54Data* _data54_)
{
	g_atomic_int_inc (&_data54_->_ref_count_);
	return _data54_;
}

static void
block54_data_unref (void * _userdata_)
{
	Block54Data* _data54_;
	_data54_ = (Block54Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data54_->_ref_count_)) {
		G4MusicLibrary* self;
		self = _data54_->self;
		_g_ptr_array_unref0 (_data54_->arr);
		_g_object_unref0 (self);
		g_slice_free (Block54Data, _data54_);
	}
}

static void
___lambda13_ (Block54Data* _data54_,
              const gchar* name,
              G4Album* album)
{
	G4MusicLibrary* self;
	G4Music* _tmp0_;
	self = _data54_->self;
	g_return_if_fail (name != NULL);
	g_return_if_fail (album != NULL);
	_tmp0_ = _g_object_ref0 ((G4Music*) album);
	g_ptr_array_add (_data54_->arr, _tmp0_);
}

static void
____lambda13__gh_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	___lambda13_ (self, (const gchar*) key, (G4Album*) value);
}

void
g4_music_library_overwrite_albums_to (G4MusicLibrary* self,
                                      GListStore* store)
{
	Block54Data* _data54_;
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GPtrArray* _tmp3_;
	gpointer* _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_data54_ = g_slice_new0 (Block54Data);
	_data54_->_ref_count_ = 1;
	_data54_->self = g_object_ref (self);
	_tmp0_ = self->priv->_albums;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_ptr_array_new_full (_tmp2_, _g_object_unref0_);
	_data54_->arr = _tmp3_;
	{
		GHashTable* _tmp4_;
		_tmp4_ = self->priv->_albums;
		g_rec_mutex_lock (&self->priv->__lock__albums);
		{
			GHashTable* _tmp5_;
			_tmp5_ = self->priv->_albums;
			g_hash_table_foreach (_tmp5_, ____lambda13__gh_func, _data54_);
		}
		__finally0:
		{
			GHashTable* _tmp6_;
			_tmp6_ = self->priv->_albums;
			g_rec_mutex_unlock (&self->priv->__lock__albums);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block54_data_unref (_data54_);
			_data54_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	vala_g_ptr_array_sort (_data54_->arr, _g4_music_compare_by_album_gcompare_func);
	_tmp7_ = _data54_->arr->pdata;
	_tmp7__length1 = _data54_->arr->len;
	g_list_store_splice (store, (guint) 0, g_list_model_get_n_items ((GListModel*) store), (GObject**) _tmp7_, (guint) ((_tmp7__length1 * sizeof (G4Music*)) / sizeof (GObject*)));
	block54_data_unref (_data54_);
	_data54_ = NULL;
}

static Block55Data*
block55_data_ref (Block55Data* _data55_)
{
	g_atomic_int_inc (&_data55_->_ref_count_);
	return _data55_;
}

static void
block55_data_unref (void * _userdata_)
{
	Block55Data* _data55_;
	_data55_ = (Block55Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data55_->_ref_count_)) {
		G4MusicLibrary* self;
		self = _data55_->self;
		_g_ptr_array_unref0 (_data55_->arr);
		_g_object_unref0 (self);
		g_slice_free (Block55Data, _data55_);
	}
}

static void
___lambda14_ (Block55Data* _data55_,
              const gchar* name,
              G4Artist* artist)
{
	G4MusicLibrary* self;
	G4Music* _tmp0_;
	self = _data55_->self;
	g_return_if_fail (name != NULL);
	g_return_if_fail (artist != NULL);
	_tmp0_ = _g_object_ref0 ((G4Music*) artist);
	g_ptr_array_add (_data55_->arr, _tmp0_);
}

static void
____lambda14__gh_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	___lambda14_ (self, (const gchar*) key, (G4Artist*) value);
}

static gint
_g4_music_compare_by_artist_gcompare_func (gconstpointer a,
                                           gconstpointer b)
{
	gint result;
	result = g4_music_compare_by_artist ((G4Music*) a, (G4Music*) b);
	return result;
}

void
g4_music_library_overwrite_artists_to (G4MusicLibrary* self,
                                       GListStore* store)
{
	Block55Data* _data55_;
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GPtrArray* _tmp3_;
	gpointer* _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_data55_ = g_slice_new0 (Block55Data);
	_data55_->_ref_count_ = 1;
	_data55_->self = g_object_ref (self);
	_tmp0_ = self->priv->_artists;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_ptr_array_new_full (_tmp2_, _g_object_unref0_);
	_data55_->arr = _tmp3_;
	{
		GHashTable* _tmp4_;
		_tmp4_ = self->priv->_artists;
		g_rec_mutex_lock (&self->priv->__lock__artists);
		{
			GHashTable* _tmp5_;
			_tmp5_ = self->priv->_artists;
			g_hash_table_foreach (_tmp5_, ____lambda14__gh_func, _data55_);
		}
		__finally0:
		{
			GHashTable* _tmp6_;
			_tmp6_ = self->priv->_artists;
			g_rec_mutex_unlock (&self->priv->__lock__artists);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block55_data_unref (_data55_);
			_data55_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	vala_g_ptr_array_sort (_data55_->arr, _g4_music_compare_by_artist_gcompare_func);
	_tmp7_ = _data55_->arr->pdata;
	_tmp7__length1 = _data55_->arr->len;
	g_list_store_splice (store, (guint) 0, g_list_model_get_n_items ((GListModel*) store), (GObject**) _tmp7_, (guint) ((_tmp7__length1 * sizeof (G4Music*)) / sizeof (GObject*)));
	block55_data_unref (_data55_);
	_data55_ = NULL;
}

static Block56Data*
block56_data_ref (Block56Data* _data56_)
{
	g_atomic_int_inc (&_data56_->_ref_count_);
	return _data56_;
}

static void
block56_data_unref (void * _userdata_)
{
	Block56Data* _data56_;
	_data56_ = (Block56Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data56_->_ref_count_)) {
		G4MusicLibrary* self;
		self = _data56_->self;
		_g_ptr_array_unref0 (_data56_->arr);
		_g_object_unref0 (self);
		g_slice_free (Block56Data, _data56_);
	}
}

static void
___lambda15_ (Block56Data* _data56_,
              const gchar* uri,
              G4Playlist* playlist)
{
	G4MusicLibrary* self;
	G4Music* _tmp0_;
	self = _data56_->self;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (playlist != NULL);
	_tmp0_ = _g_object_ref0 ((G4Music*) playlist);
	g_ptr_array_add (_data56_->arr, _tmp0_);
}

static void
____lambda15__gh_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	___lambda15_ (self, (const gchar*) key, (G4Playlist*) value);
}

static gint
_g4_music_compare_by_title_gcompare_func (gconstpointer a,
                                          gconstpointer b)
{
	gint result;
	result = g4_music_compare_by_title ((G4Music*) a, (G4Music*) b);
	return result;
}

void
g4_music_library_overwrite_playlists_to (G4MusicLibrary* self,
                                         GListStore* store)
{
	Block56Data* _data56_;
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GPtrArray* _tmp3_;
	gpointer* _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_data56_ = g_slice_new0 (Block56Data);
	_data56_->_ref_count_ = 1;
	_data56_->self = g_object_ref (self);
	_tmp0_ = self->priv->_playlists;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_ptr_array_new_full (_tmp2_, _g_object_unref0_);
	_data56_->arr = _tmp3_;
	{
		GHashTable* _tmp4_;
		_tmp4_ = self->priv->_playlists;
		g_rec_mutex_lock (&self->priv->__lock__playlists);
		{
			GHashTable* _tmp5_;
			_tmp5_ = self->priv->_playlists;
			g_hash_table_foreach (_tmp5_, ____lambda15__gh_func, _data56_);
		}
		__finally0:
		{
			GHashTable* _tmp6_;
			_tmp6_ = self->priv->_playlists;
			g_rec_mutex_unlock (&self->priv->__lock__playlists);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block56_data_unref (_data56_);
			_data56_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	vala_g_ptr_array_sort (_data56_->arr, _g4_music_compare_by_title_gcompare_func);
	_tmp7_ = _data56_->arr->pdata;
	_tmp7__length1 = _data56_->arr->len;
	g_list_store_splice (store, (guint) 0, g_list_model_get_n_items ((GListModel*) store), (GObject**) _tmp7_, (guint) ((_tmp7__length1 * sizeof (G4Music*)) / sizeof (GObject*)));
	block56_data_unref (_data56_);
	_data56_ = NULL;
}

static Block57Data*
block57_data_ref (Block57Data* _data57_)
{
	g_atomic_int_inc (&_data57_->_ref_count_);
	return _data57_;
}

static void
block57_data_unref (void * _userdata_)
{
	Block57Data* _data57_;
	_data57_ = (Block57Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data57_->_ref_count_)) {
		G4MusicLibrary* self;
		self = _data57_->self;
		_g_object_unref0 (_data57_->music);
		_g_object_unref0 (self);
		g_slice_free (Block57Data, _data57_);
	}
}

static gboolean
____lambda16_ (Block57Data* _data57_,
               const gchar* name,
               G4Album* album)
{
	G4MusicLibrary* self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = _data57_->self;
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (album != NULL, FALSE);
	if (g4_album_remove_music (album, _data57_->music)) {
		guint _tmp1_;
		guint _tmp2_;
		_tmp1_ = g4_album_get_length (album);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
_____lambda16__ghr_func (gconstpointer key,
                         gconstpointer value,
                         gpointer self)
{
	gboolean result;
	result = ____lambda16_ (self, (const gchar*) key, (G4Album*) value);
	return result;
}

static gboolean
____lambda17_ (Block57Data* _data57_,
               const gchar* name,
               G4Artist* artist)
{
	G4MusicLibrary* self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = _data57_->self;
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (artist != NULL, FALSE);
	if (g4_artist_remove_music (artist, _data57_->music)) {
		guint _tmp1_;
		guint _tmp2_;
		_tmp1_ = g4_artist_get_length (artist);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
_____lambda17__ghr_func (gconstpointer key,
                         gconstpointer value,
                         gpointer self)
{
	gboolean result;
	result = ____lambda17_ (self, (const gchar*) key, (G4Artist*) value);
	return result;
}

void
g4_music_library_remove_music (G4MusicLibrary* self,
                               G4Music* music)
{
	Block57Data* _data57_;
	G4Music* _tmp0_;
	const gchar* album_key = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* artist_name = NULL;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (music != NULL);
	_data57_ = g_slice_new0 (Block57Data);
	_data57_->_ref_count_ = 1;
	_data57_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (music);
	_g_object_unref0 (_data57_->music);
	_data57_->music = _tmp0_;
	_tmp1_ = g4_music_get_album_key (_data57_->music);
	_tmp2_ = _tmp1_;
	album_key = _tmp2_;
	{
		GHashTable* _tmp3_;
		_tmp3_ = self->priv->_albums;
		g_rec_mutex_lock (&self->priv->__lock__albums);
		{
			G4Album* album = NULL;
			GHashTable* _tmp4_;
			const gchar* _tmp5_;
			gconstpointer _tmp6_;
			G4Album* _tmp7_;
			G4Album* _tmp8_;
			_tmp4_ = self->priv->_albums;
			_tmp5_ = album_key;
			_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
			_tmp7_ = _g_object_ref0 ((G4Album*) _tmp6_);
			album = _tmp7_;
			_tmp8_ = album;
			if (G4_IS_ALBUM (_tmp8_)) {
				G4Album* _tmp9_;
				G4Album* _tmp10_;
				guint _tmp11_;
				guint _tmp12_;
				_tmp9_ = album;
				g4_album_remove_music (_tmp9_, _data57_->music);
				_tmp10_ = album;
				_tmp11_ = g4_album_get_length (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_ == ((guint) 0)) {
					GHashTable* _tmp13_;
					const gchar* _tmp14_;
					_tmp13_ = self->priv->_albums;
					_tmp14_ = album_key;
					g_hash_table_remove (_tmp13_, _tmp14_);
				}
			} else {
				GHashTable* _tmp15_;
				_tmp15_ = self->priv->_albums;
				g_hash_table_foreach_remove (_tmp15_, _____lambda16__ghr_func, _data57_);
			}
			_g_object_unref0 (album);
		}
		__finally0:
		{
			GHashTable* _tmp16_;
			_tmp16_ = self->priv->_albums;
			g_rec_mutex_unlock (&self->priv->__lock__albums);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block57_data_unref (_data57_);
			_data57_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp17_ = g4_music_get_artist_name (_data57_->music);
	_tmp18_ = _tmp17_;
	artist_name = _tmp18_;
	{
		GHashTable* _tmp19_;
		_tmp19_ = self->priv->_artists;
		g_rec_mutex_lock (&self->priv->__lock__artists);
		{
			G4Artist* artist = NULL;
			GHashTable* _tmp20_;
			const gchar* _tmp21_;
			gconstpointer _tmp22_;
			G4Artist* _tmp23_;
			G4Artist* _tmp24_;
			_tmp20_ = self->priv->_artists;
			_tmp21_ = artist_name;
			_tmp22_ = g_hash_table_lookup (_tmp20_, _tmp21_);
			_tmp23_ = _g_object_ref0 ((G4Artist*) _tmp22_);
			artist = _tmp23_;
			_tmp24_ = artist;
			if (G4_IS_ARTIST (_tmp24_)) {
				G4Artist* _tmp25_;
				G4Artist* _tmp26_;
				guint _tmp27_;
				guint _tmp28_;
				_tmp25_ = artist;
				g4_artist_remove_music (_tmp25_, _data57_->music);
				_tmp26_ = artist;
				_tmp27_ = g4_artist_get_length (_tmp26_);
				_tmp28_ = _tmp27_;
				if (_tmp28_ == ((guint) 0)) {
					GHashTable* _tmp29_;
					const gchar* _tmp30_;
					_tmp29_ = self->priv->_artists;
					_tmp30_ = artist_name;
					g_hash_table_remove (_tmp29_, _tmp30_);
				}
			} else {
				GHashTable* _tmp31_;
				_tmp31_ = self->priv->_artists;
				g_hash_table_foreach_remove (_tmp31_, _____lambda17__ghr_func, _data57_);
			}
			_g_object_unref0 (artist);
		}
		__finally1:
		{
			GHashTable* _tmp32_;
			_tmp32_ = self->priv->_artists;
			g_rec_mutex_unlock (&self->priv->__lock__artists);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block57_data_unref (_data57_);
			_data57_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	block57_data_unref (_data57_);
	_data57_ = NULL;
}

gboolean
g4_music_library_remove_playlist (G4MusicLibrary* self,
                                  const gchar* key)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	{
		GHashTable* _tmp0_;
		gboolean _tmp4_ = FALSE;
		_tmp0_ = self->priv->_playlists;
		g_rec_mutex_lock (&self->priv->__lock__playlists);
		{
			GHashTable* _tmp1_;
			_tmp1_ = self->priv->_playlists;
			result = g_hash_table_remove (_tmp1_, key);
			{
				GHashTable* _tmp2_;
				_tmp2_ = self->priv->_playlists;
				g_rec_mutex_unlock (&self->priv->__lock__playlists);
			}
			return result;
		}
		__finally0:
		{
			GHashTable* _tmp3_;
			_tmp3_ = self->priv->_playlists;
			g_rec_mutex_unlock (&self->priv->__lock__playlists);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static Block58Data*
block58_data_ref (Block58Data* _data58_)
{
	g_atomic_int_inc (&_data58_->_ref_count_);
	return _data58_;
}

static void
block58_data_unref (void * _userdata_)
{
	Block58Data* _data58_;
	_data58_ = (Block58Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data58_->_ref_count_)) {
		G4MusicLibrary* self;
		self = _data58_->self;
		_g_free0 (_data58_->prefix);
		_g_hash_table_unref0 (_data58_->removed);
		_g_object_unref0 (self);
		g_slice_free (Block58Data, _data58_);
	}
}

static gboolean
__lambda19_ (Block58Data* _data58_,
             const gchar* uri,
             G4Music* music)
{
	G4MusicLibrary* self;
	const gchar* uri2 = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	self = _data58_->self;
	g_return_val_if_fail (uri != NULL, FALSE);
	g_return_val_if_fail (music != NULL, FALSE);
	_tmp0_ = music->uri;
	uri2 = _tmp0_;
	_tmp1_ = uri2;
	_tmp2_ = _data58_->prefix;
	if (g_str_has_prefix (_tmp1_, _tmp2_)) {
		G4Music* _tmp3_;
		_tmp3_ = _g_object_ref0 (music);
		g_hash_table_add (_data58_->removed, _tmp3_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda19__ghr_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	gboolean result;
	result = __lambda19_ (self, (const gchar*) key, (G4Music*) value);
	return result;
}

static gboolean
___lambda18_ (Block58Data* _data58_,
              const gchar* name,
              G4Album* album)
{
	G4MusicLibrary* self;
	guint _tmp0_;
	guint _tmp1_;
	gboolean result;
	self = _data58_->self;
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (album != NULL, FALSE);
	g4_album_foreach_remove (album, ___lambda19__ghr_func, _data58_);
	_tmp0_ = g4_album_get_length (album);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == ((guint) 0);
	return result;
}

static gboolean
____lambda18__ghr_func (gconstpointer key,
                        gconstpointer value,
                        gpointer self)
{
	gboolean result;
	result = ___lambda18_ (self, (const gchar*) key, (G4Album*) value);
	return result;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		GHashTable* self;
		self = _data11_->self;
		_g_hash_table_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
__lambda2_ (Block11Data* _data11_,
            gconstpointer k,
            gconstpointer v)
{
	GHashTable* self;
	self = _data11_->self;
	_data11_->func (v, _data11_->func_target);
}

static void
___lambda2__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda2_ (self, key, value);
}

static void
_vala_g_hash_set_foreach (GHashTable* self,
                          GFunc func,
                          gpointer func_target)
{
	Block11Data* _data11_;
	g_return_if_fail (self != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_hash_table_ref (self);
	_data11_->func = func;
	_data11_->func_target = func_target;
	g_hash_table_foreach ((GHashTable*) self, ___lambda2__gh_func, _data11_);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

static Block59Data*
block59_data_ref (Block59Data* _data59_)
{
	g_atomic_int_inc (&_data59_->_ref_count_);
	return _data59_;
}

static void
block59_data_unref (void * _userdata_)
{
	Block59Data* _data59_;
	_data59_ = (Block59Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data59_->_ref_count_)) {
		G4MusicLibrary* self;
		self = _data59_->self;
		_g_object_unref0 (_data59_->music);
		_g_object_unref0 (self);
		g_slice_free (Block59Data, _data59_);
	}
}

static gboolean
___lambda21_ (Block59Data* _data59_,
              const gchar* name,
              G4Artist* artist)
{
	G4MusicLibrary* self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = _data59_->self;
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (artist != NULL, FALSE);
	if (g4_artist_remove_music (artist, _data59_->music)) {
		guint _tmp1_;
		guint _tmp2_;
		_tmp1_ = g4_artist_get_length (artist);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
____lambda21__ghr_func (gconstpointer key,
                        gconstpointer value,
                        gpointer self)
{
	gboolean result;
	result = ___lambda21_ (self, (const gchar*) key, (G4Artist*) value);
	return result;
}

static void
__lambda20_ (G4MusicLibrary* self,
             G4Music* music)
{
	Block59Data* _data59_;
	G4Music* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (music != NULL);
	_data59_ = g_slice_new0 (Block59Data);
	_data59_->_ref_count_ = 1;
	_data59_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (music);
	_g_object_unref0 (_data59_->music);
	_data59_->music = _tmp0_;
	{
		GHashTable* _tmp1_;
		_tmp1_ = self->priv->_artists;
		g_rec_mutex_lock (&self->priv->__lock__artists);
		{
			GHashTable* _tmp2_;
			_tmp2_ = self->priv->_artists;
			g_hash_table_foreach_remove (_tmp2_, ____lambda21__ghr_func, _data59_);
		}
		__finally0:
		{
			GHashTable* _tmp3_;
			_tmp3_ = self->priv->_artists;
			g_rec_mutex_unlock (&self->priv->__lock__artists);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block59_data_unref (_data59_);
			_data59_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	block59_data_unref (_data59_);
	_data59_ = NULL;
}

static void
___lambda20__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda20_ ((G4MusicLibrary*) self, (G4Music*) data);
}

gboolean
g4_music_library_remove_uri (G4MusicLibrary* self,
                             const gchar* uri,
                             GHashTable* removed)
{
	Block58Data* _data58_;
	GHashTable* _tmp0_;
	gchar* key = NULL;
	G4Playlist* oldlist = NULL;
	gchar* _tmp11_;
	guint n_removed = 0U;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	g_return_val_if_fail (removed != NULL, FALSE);
	_data58_ = g_slice_new0 (Block58Data);
	_data58_->_ref_count_ = 1;
	_data58_->self = g_object_ref (self);
	_tmp0_ = _g_hash_table_ref0 (removed);
	_g_hash_table_unref0 (_data58_->removed);
	_data58_->removed = _tmp0_;
	{
		GHashTable* _tmp1_;
		_tmp1_ = self->priv->_playlists;
		g_rec_mutex_lock (&self->priv->__lock__playlists);
		{
			GHashTable* _tmp2_;
			gpointer _tmp3_ = NULL;
			gpointer _tmp4_ = NULL;
			gboolean _tmp5_;
			gchar* _tmp6_;
			_tmp2_ = self->priv->_playlists;
			_tmp5_ = g_hash_table_steal_extended (_tmp2_, uri, &_tmp3_, &_tmp4_);
			_g_free0 (key);
			_tmp6_ = g_strdup ((const gchar*) _tmp3_);
			key = _tmp6_;
			_g_object_unref0 (oldlist);
			oldlist = (G4Playlist*) _tmp4_;
			if (_tmp5_) {
				G4Playlist* _tmp7_;
				_tmp7_ = oldlist;
				g4_playlist_clear (_tmp7_);
				result = TRUE;
				{
					GHashTable* _tmp8_;
					_tmp8_ = self->priv->_playlists;
					g_rec_mutex_unlock (&self->priv->__lock__playlists);
				}
				_g_object_unref0 (oldlist);
				_g_free0 (key);
				block58_data_unref (_data58_);
				_data58_ = NULL;
				return result;
			}
		}
		__finally0:
		{
			GHashTable* _tmp9_;
			_tmp9_ = self->priv->_playlists;
			g_rec_mutex_unlock (&self->priv->__lock__playlists);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp10_ = FALSE;
			_g_object_unref0 (oldlist);
			_g_free0 (key);
			block58_data_unref (_data58_);
			_data58_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
	}
	_tmp11_ = g_strconcat (uri, "/", NULL);
	_data58_->prefix = _tmp11_;
	n_removed = (guint) 0;
	{
		GHashTable* _tmp12_;
		_tmp12_ = self->priv->_albums;
		g_rec_mutex_lock (&self->priv->__lock__albums);
		{
			GHashTable* _tmp13_;
			_tmp13_ = self->priv->_albums;
			n_removed = g_hash_table_foreach_remove (_tmp13_, ____lambda18__ghr_func, _data58_);
		}
		__finally1:
		{
			GHashTable* _tmp14_;
			_tmp14_ = self->priv->_albums;
			g_rec_mutex_unlock (&self->priv->__lock__albums);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp15_ = FALSE;
			_g_object_unref0 (oldlist);
			_g_free0 (key);
			block58_data_unref (_data58_);
			_data58_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp15_;
		}
	}
	_vala_g_hash_set_foreach (_data58_->removed, ___lambda20__gfunc, self);
	result = n_removed != ((guint) 0);
	_g_object_unref0 (oldlist);
	_g_free0 (key);
	block58_data_unref (_data58_);
	_data58_ = NULL;
	return result;
}

void
g4_music_library_remove_all (G4MusicLibrary* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->_albums;
		g_rec_mutex_lock (&self->priv->__lock__albums);
		{
			GHashTable* _tmp1_;
			_tmp1_ = self->priv->_albums;
			g_hash_table_remove_all (_tmp1_);
		}
		__finally0:
		{
			GHashTable* _tmp2_;
			_tmp2_ = self->priv->_albums;
			g_rec_mutex_unlock (&self->priv->__lock__albums);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		GHashTable* _tmp3_;
		_tmp3_ = self->priv->_artists;
		g_rec_mutex_lock (&self->priv->__lock__artists);
		{
			GHashTable* _tmp4_;
			_tmp4_ = self->priv->_artists;
			g_hash_table_remove_all (_tmp4_);
		}
		__finally1:
		{
			GHashTable* _tmp5_;
			_tmp5_ = self->priv->_artists;
			g_rec_mutex_unlock (&self->priv->__lock__artists);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		GHashTable* _tmp6_;
		_tmp6_ = self->priv->_playlists;
		g_rec_mutex_lock (&self->priv->__lock__playlists);
		{
			GHashTable* _tmp7_;
			_tmp7_ = self->priv->_playlists;
			g_hash_table_remove_all (_tmp7_);
		}
		__finally2:
		{
			GHashTable* _tmp8_;
			_tmp8_ = self->priv->_playlists;
			g_rec_mutex_unlock (&self->priv->__lock__playlists);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

G4MusicLibrary*
g4_music_library_construct (GType object_type)
{
	G4MusicLibrary * self = NULL;
	self = (G4MusicLibrary*) g_object_new (object_type, NULL);
	return self;
}

G4MusicLibrary*
g4_music_library_new (void)
{
	return g4_music_library_construct (G4_TYPE_MUSIC_LIBRARY);
}

gboolean
g4_music_library_get_empty (G4MusicLibrary* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GHashTable* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->priv->_albums;
	_tmp3_ = g_hash_table_size (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == ((guint) 0)) {
		GHashTable* _tmp5_;
		guint _tmp6_;
		guint _tmp7_;
		_tmp5_ = self->priv->_artists;
		_tmp6_ = g_hash_table_size (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_ == ((guint) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GHashTable* _tmp8_;
		guint _tmp9_;
		guint _tmp10_;
		_tmp8_ = self->priv->_playlists;
		_tmp9_ = g_hash_table_size (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = _tmp10_ == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

guint
g4_music_library_get_album_count (G4MusicLibrary* self)
{
	guint result;
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_albums;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

guint
g4_music_library_get_artist_count (G4MusicLibrary* self)
{
	guint result;
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_artists;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

guint
g4_music_library_get_playlist_count (G4MusicLibrary* self)
{
	guint result;
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_playlists;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
g4_music_library_class_init (G4MusicLibraryClass * klass,
                             gpointer klass_data)
{
	g4_music_library_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &G4MusicLibrary_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_g4_music_library_get_property;
	G_OBJECT_CLASS (klass)->finalize = g4_music_library_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_MUSIC_LIBRARY_EMPTY_PROPERTY, g4_music_library_properties[G4_MUSIC_LIBRARY_EMPTY_PROPERTY] = g_param_spec_boolean ("empty", "empty", "empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_MUSIC_LIBRARY_ALBUM_COUNT_PROPERTY, g4_music_library_properties[G4_MUSIC_LIBRARY_ALBUM_COUNT_PROPERTY] = g_param_spec_uint ("album-count", "album-count", "album-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_MUSIC_LIBRARY_ARTIST_COUNT_PROPERTY, g4_music_library_properties[G4_MUSIC_LIBRARY_ARTIST_COUNT_PROPERTY] = g_param_spec_uint ("artist-count", "artist-count", "artist-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_MUSIC_LIBRARY_PLAYLIST_COUNT_PROPERTY, g4_music_library_properties[G4_MUSIC_LIBRARY_PLAYLIST_COUNT_PROPERTY] = g_param_spec_uint ("playlist-count", "playlist-count", "playlist-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
g4_music_library_instance_init (G4MusicLibrary * self,
                                gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	self->priv = g4_music_library_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock__albums);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_object_unref0_);
	self->priv->_albums = _tmp2_;
	g_rec_mutex_init (&self->priv->__lock__artists);
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, NULL, _g_object_unref0_);
	self->priv->_artists = _tmp5_;
	g_rec_mutex_init (&self->priv->__lock__playlists);
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, NULL, _g_object_unref0_);
	self->priv->_playlists = _tmp8_;
}

static void
g4_music_library_finalize (GObject * obj)
{
	G4MusicLibrary * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_TYPE_MUSIC_LIBRARY, G4MusicLibrary);
	g_rec_mutex_clear (&self->priv->__lock__albums);
	_g_hash_table_unref0 (self->priv->_albums);
	g_rec_mutex_clear (&self->priv->__lock__artists);
	_g_hash_table_unref0 (self->priv->_artists);
	g_rec_mutex_clear (&self->priv->__lock__playlists);
	_g_hash_table_unref0 (self->priv->_playlists);
	G_OBJECT_CLASS (g4_music_library_parent_class)->finalize (obj);
}

static GType
g4_music_library_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (G4MusicLibraryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_music_library_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (G4MusicLibrary), 0, (GInstanceInitFunc) g4_music_library_instance_init, NULL };
	GType g4_music_library_type_id;
	g4_music_library_type_id = g_type_register_static (G_TYPE_OBJECT, "G4MusicLibrary", &g_define_type_info, 0);
	G4MusicLibrary_private_offset = g_type_add_instance_private (g4_music_library_type_id, sizeof (G4MusicLibraryPrivate));
	return g4_music_library_type_id;
}

GType
g4_music_library_get_type (void)
{
	static volatile gsize g4_music_library_type_id__once = 0;
	if (g_once_init_enter (&g4_music_library_type_id__once)) {
		GType g4_music_library_type_id;
		g4_music_library_type_id = g4_music_library_get_type_once ();
		g_once_init_leave (&g4_music_library_type_id__once, g4_music_library_type_id);
	}
	return g4_music_library_type_id__once;
}

static void
_vala_g4_music_library_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	G4MusicLibrary * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_MUSIC_LIBRARY, G4MusicLibrary);
	switch (property_id) {
		case G4_MUSIC_LIBRARY_EMPTY_PROPERTY:
		g_value_set_boolean (value, g4_music_library_get_empty (self));
		break;
		case G4_MUSIC_LIBRARY_ALBUM_COUNT_PROPERTY:
		g_value_set_uint (value, g4_music_library_get_album_count (self));
		break;
		case G4_MUSIC_LIBRARY_ARTIST_COUNT_PROPERTY:
		g_value_set_uint (value, g4_music_library_get_artist_count (self));
		break;
		case G4_MUSIC_LIBRARY_PLAYLIST_COUNT_PROPERTY:
		g_value_set_uint (value, g4_music_library_get_playlist_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

gint
g4_find_item_in_model (GListModel* model,
                       GObject* obj,
                       gint start_pos)
{
	guint count = 0U;
	gint result;
	g_return_val_if_fail (model != NULL, 0);
	count = g_list_model_get_n_items (model);
	{
		gint i = 0;
		i = start_pos;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GObject* _tmp2_;
				GObject* _tmp3_;
				gboolean _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((guint) i) < count)) {
					break;
				}
				_tmp2_ = g_list_model_get_item (model, (guint) i);
				_tmp3_ = _tmp2_;
				_tmp4_ = _tmp3_ == obj;
				_g_object_unref0 (_tmp3_);
				if (_tmp4_) {
					result = (gint) i;
					return result;
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				GObject* _tmp7_;
				GObject* _tmp8_;
				gboolean _tmp9_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				if (!(i < start_pos)) {
					break;
				}
				_tmp7_ = g_list_model_get_item (model, (guint) i);
				_tmp8_ = _tmp7_;
				_tmp9_ = _tmp8_ == obj;
				_g_object_unref0 (_tmp8_);
				if (_tmp9_) {
					result = (gint) i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

gboolean
g4_merge_items_to_store (GListStore* store,
                         GPtrArray* arr,
                         guint* position)
{
	gint first_pos = 0;
	gint removed = 0;
	gint _tmp0_ = 0;
	gint _tmp1_;
	gpointer* _tmp2_;
	gint _tmp2__length1;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_;
	gint _tmp5_;
	gboolean result;
	g_return_val_if_fail (store != NULL, FALSE);
	g_return_val_if_fail (arr != NULL, FALSE);
	first_pos = -1;
	_tmp1_ = g4_remove_items_from_store (store, arr, &_tmp0_);
	first_pos = _tmp0_;
	removed = _tmp1_;
	if ((*position) >= ((guint) (first_pos + removed))) {
		*position = (*position) - removed;
	}
	*position = MIN (*position, g_list_model_get_n_items ((GListModel*) store));
	_tmp2_ = arr->pdata;
	_tmp2__length1 = arr->len;
	g_list_store_splice (store, *position, (guint) 0, (GObject**) _tmp2_, (guint) ((_tmp2__length1 * sizeof (G4Music*)) / sizeof (GObject*)));
	_tmp4_ = vala_g_ptr_array_get_length (arr);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 1) {
		gconstpointer _tmp6_;
		GObject* _tmp7_;
		GObject* _tmp8_;
		_tmp6_ = g_ptr_array_index (arr, (guint) 0);
		_tmp7_ = g_list_model_get_item ((GListModel*) store, (guint) first_pos);
		_tmp8_ = _tmp7_;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST ((G4Music*) _tmp6_, G_TYPE_OBJECT, GObject) == _tmp8_;
		_g_object_unref0 (_tmp8_);
	} else {
		_tmp3_ = FALSE;
	}
	result = !_tmp3_;
	return result;
}

static Block60Data*
block60_data_ref (Block60Data* _data60_)
{
	g_atomic_int_inc (&_data60_->_ref_count_);
	return _data60_;
}

static void
block60_data_unref (void * _userdata_)
{
	Block60Data* _data60_;
	_data60_ = (Block60Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data60_->_ref_count_)) {
		_g_hash_table_unref0 (_data60_->map);
		g_slice_free (Block60Data, _data60_);
	}
}

static void
__lambda48_ (Block60Data* _data60_,
             G4Music* obj)
{
	GHashTable* _tmp0_;
	GObject* _tmp1_;
	g_return_if_fail (obj != NULL);
	_tmp0_ = _data60_->map;
	_tmp1_ = _g_object_ref0 ((GObject*) obj);
	g_hash_table_add (_tmp0_, _tmp1_);
}

static void
___lambda48__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda48_ (self, (G4Music*) data);
}

gint
g4_remove_items_from_store (GListStore* store,
                            GPtrArray* arr,
                            gint* first_pos)
{
	gint _vala_first_pos = 0;
	Block60Data* _data60_;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gint removed = 0;
	gint first_removed = 0;
	gint size = 0;
	gint _tmp3_;
	gint _tmp4_;
	gint result;
	g_return_val_if_fail (store != NULL, 0);
	g_return_val_if_fail (arr != NULL, 0);
	_data60_ = g_slice_new0 (Block60Data);
	_data60_->_ref_count_ = 1;
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_object_unref0_);
	_data60_->map = _tmp2_;
	g_ptr_array_foreach (arr, ___lambda48__gfunc, _data60_);
	removed = 0;
	first_removed = -1;
	size = (gint) g_list_model_get_n_items ((GListModel*) store);
	_tmp3_ = vala_g_ptr_array_get_length (arr);
	_tmp4_ = _tmp3_;
	if (_tmp4_ < (size / 4)) {
		{
			gint i = 0;
			i = size - 1;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					GObject* obj = NULL;
					GObject* _tmp7_;
					GHashTable* _tmp8_;
					GObject* _tmp9_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ - 1;
					}
					_tmp5_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp7_ = g_list_model_get_item ((GListModel*) store, (guint) i);
					obj = _tmp7_;
					_tmp8_ = _data60_->map;
					_tmp9_ = obj;
					if (g_hash_table_contains (_tmp8_, _tmp9_)) {
						gint _tmp10_;
						g_list_store_remove (store, (guint) i);
						_tmp10_ = removed;
						removed = _tmp10_ + 1;
						first_removed = i;
					}
					_g_object_unref0 (obj);
				}
			}
		}
	} else {
		GPtrArray* remain = NULL;
		GPtrArray* _tmp11_;
		GPtrArray* _tmp21_;
		gpointer* _tmp22_;
		gint _tmp22__length1;
		_tmp11_ = g_ptr_array_new_full ((guint) size, _g_object_unref0_);
		remain = _tmp11_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp12_ = FALSE;
				_tmp12_ = TRUE;
				while (TRUE) {
					GObject* obj = NULL;
					GObject* _tmp14_;
					GHashTable* _tmp15_;
					GObject* _tmp16_;
					if (!_tmp12_) {
						gint _tmp13_;
						_tmp13_ = i;
						i = _tmp13_ + 1;
					}
					_tmp12_ = FALSE;
					if (!(i < size)) {
						break;
					}
					_tmp14_ = g_list_model_get_item ((GListModel*) store, (guint) i);
					obj = _tmp14_;
					_tmp15_ = _data60_->map;
					_tmp16_ = obj;
					if (!g_hash_table_contains (_tmp15_, _tmp16_)) {
						GPtrArray* _tmp17_;
						GObject* _tmp18_;
						G4Music* _tmp19_;
						_tmp17_ = remain;
						_tmp18_ = obj;
						_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, G4_TYPE_MUSIC, G4Music));
						g_ptr_array_add (_tmp17_, _tmp19_);
					} else {
						gint _tmp20_;
						_tmp20_ = removed;
						removed = _tmp20_ + 1;
						if (first_removed == -1) {
							first_removed = i;
						}
					}
					_g_object_unref0 (obj);
				}
			}
		}
		_tmp21_ = remain;
		_tmp22_ = _tmp21_->pdata;
		_tmp22__length1 = _tmp21_->len;
		g_list_store_splice (store, (guint) 0, (guint) size, (GObject**) _tmp22_, (guint) ((_tmp22__length1 * sizeof (G4Music*)) / sizeof (GObject*)));
		_g_ptr_array_unref0 (remain);
	}
	_vala_first_pos = first_removed;
	result = removed;
	block60_data_unref (_data60_);
	_data60_ = NULL;
	if (first_pos) {
		*first_pos = _vala_first_pos;
	}
	return result;
}

static gint
_g4_music_compare_by_artist_album_gcompare_func (gconstpointer a,
                                                 gconstpointer b)
{
	gint result;
	result = g4_music_compare_by_artist_album ((G4Music*) a, (G4Music*) b);
	return result;
}

static gint
_g4_music_compare_by_recent_gcompare_func (gconstpointer a,
                                           gconstpointer b)
{
	gint result;
	result = g4_music_compare_by_recent ((G4Music*) a, (G4Music*) b);
	return result;
}

void
g4_sort_music_array (GPtrArray* arr,
                     guint sort_mode)
{
	GCompareFunc compare = NULL;
	GCompareFunc _tmp0_;
	g_return_if_fail (arr != NULL);
	if (sort_mode == G4_SORT_MODE_SHUFFLE) {
		g4_music_shuffle_order (arr);
	}
	compare = _g4_music_compare_by_order_gcompare_func;
	switch (sort_mode) {
		case G4_SORT_MODE_ALBUM:
		{
			compare = _g4_music_compare_by_album_gcompare_func;
			break;
		}
		case G4_SORT_MODE_ARTIST:
		{
			compare = _g4_music_compare_by_artist_gcompare_func;
			break;
		}
		case G4_SORT_MODE_ARTIST_ALBUM:
		{
			compare = _g4_music_compare_by_artist_album_gcompare_func;
			break;
		}
		case G4_SORT_MODE_TITLE:
		{
			compare = _g4_music_compare_by_title_gcompare_func;
			break;
		}
		case G4_SORT_MODE_RECENT:
		{
			compare = _g4_music_compare_by_recent_gcompare_func;
			break;
		}
		default:
		break;
	}
	_tmp0_ = compare;
	vala_g_ptr_array_sort (arr, _tmp0_);
}

void
g4_sort_music_store (GListStore* store,
                     guint sort_mode)
{
	guint count = 0U;
	GPtrArray* arr = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp5_;
	GPtrArray* _tmp6_;
	gpointer* _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (store != NULL);
	count = g_list_model_get_n_items ((GListModel*) store);
	_tmp0_ = g_ptr_array_new_full (count, _g_object_unref0_);
	arr = _tmp0_;
	{
		gint pos = 0;
		pos = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp3_;
				GObject* _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = pos;
					pos = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((guint) pos) < count)) {
					break;
				}
				_tmp3_ = arr;
				_tmp4_ = g_list_model_get_item ((GListModel*) store, (guint) pos);
				g_ptr_array_add (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, G4_TYPE_MUSIC, G4Music));
			}
		}
	}
	_tmp5_ = arr;
	g4_sort_music_array (_tmp5_, sort_mode);
	_tmp6_ = arr;
	_tmp7_ = _tmp6_->pdata;
	_tmp7__length1 = _tmp6_->len;
	g_list_store_splice (store, (guint) 0, count, (GObject**) _tmp7_, (guint) ((_tmp7__length1 * sizeof (G4Music*)) / sizeof (GObject*)));
	_g_ptr_array_unref0 (arr);
}

static Block61Data*
block61_data_ref (Block61Data* _data61_)
{
	g_atomic_int_inc (&_data61_->_ref_count_);
	return _data61_;
}

static void
block61_data_unref (void * _userdata_)
{
	Block61Data* _data61_;
	_data61_ = (Block61Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data61_->_ref_count_)) {
		_g_object_unref0 (_data61_->playlist);
		g_slice_free (Block61Data, _data61_);
	}
}

static void
__lambda63_ (Block61Data* _data61_,
             G4Music* music)
{
	g_return_if_fail (music != NULL);
	g4_playlist_add_music (_data61_->playlist, music);
}

static void
___lambda63__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda63_ (self, (G4Music*) data);
}

G4Playlist*
g4_to_playlist (G4Music** musics,
                gint musics_length1,
                const gchar* title)
{
	Block61Data* _data61_;
	gint count = 0;
	GPtrArray* arr = NULL;
	GPtrArray* _tmp0_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp14_ = NULL;
	G4Playlist* _tmp15_;
	GPtrArray* _tmp16_;
	G4Playlist* _tmp17_;
	G4Playlist* result;
	_data61_ = g_slice_new0 (Block61Data);
	_data61_->_ref_count_ = 1;
	count = musics_length1;
	_tmp0_ = g_ptr_array_new_full ((guint) count, _g_object_unref0_);
	arr = _tmp0_;
	{
		G4Music** music_collection = NULL;
		gint music_collection_length1 = 0;
		gint _music_collection_size_ = 0;
		gint music_it = 0;
		music_collection = musics;
		music_collection_length1 = musics_length1;
		for (music_it = 0; music_it < music_collection_length1; music_it = music_it + 1) {
			G4Music* _tmp1_;
			G4Music* music = NULL;
			_tmp1_ = _g_object_ref0 (music_collection[music_it]);
			music = _tmp1_;
			{
				G4Music* _tmp2_;
				_tmp2_ = music;
				if (G4_IS_ARTIST (_tmp2_)) {
					G4Music* _tmp3_;
					GPtrArray* _tmp4_;
					_tmp3_ = music;
					_tmp4_ = arr;
					g4_artist_get_sorted_musics (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G4_TYPE_ARTIST, G4Artist), _tmp4_);
				} else {
					G4Music* _tmp5_;
					_tmp5_ = music;
					if (G4_IS_ALBUM (_tmp5_)) {
						G4Music* _tmp6_;
						GPtrArray* _tmp7_;
						_tmp6_ = music;
						_tmp7_ = arr;
						g4_album_get_sorted_musics (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, G4_TYPE_ALBUM, G4Album), _tmp7_);
					} else {
						GPtrArray* _tmp8_;
						G4Music* _tmp9_;
						G4Music* _tmp10_;
						_tmp8_ = arr;
						_tmp9_ = music;
						_tmp10_ = _g_object_ref0 (_tmp9_);
						g_ptr_array_add (_tmp8_, _tmp10_);
					}
				}
				_g_object_unref0 (music);
			}
		}
	}
	if (title == NULL) {
		_tmp11_ = count == 1;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		G4Music* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = musics[0];
		_tmp13_ = _tmp12_->title;
		title = _tmp13_;
	}
	_tmp14_ = title;
	if (_tmp14_ == NULL) {
		_tmp14_ = _ ("Untitled");
	}
	_tmp15_ = g4_playlist_new ((const gchar*) _tmp14_, "");
	_data61_->playlist = _tmp15_;
	_tmp16_ = arr;
	g_ptr_array_foreach (_tmp16_, ___lambda63__gfunc, _data61_);
	_tmp17_ = _g_object_ref0 (_data61_->playlist);
	result = _tmp17_;
	_g_ptr_array_unref0 (arr);
	block61_data_unref (_data61_);
	_data61_ = NULL;
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

