/* music-loader.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from music-loader.vala, do not modify */

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define G4_MUSIC_LOADER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN "," G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_TIME_MODIFIED
#define G4_SORT_MODE_MAX ((guint) 5)
#define G4_CHILD_TYPE_FOLDER ((guint8) 1)
#define G4_CHILD_TYPE_MUSIC ((guint8) 2)
#define G4_CHILD_TYPE_PLAYLIST ((guint8) 3)
#define G4_CHILD_TYPE_COVER ((guint8) 4)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define G4_TYPE_PROGRESS (g4_progress_get_type ())
#define G4_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_PROGRESS, G4Progress))
#define G4_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_PROGRESS, G4ProgressClass))
#define G4_IS_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_PROGRESS))
#define G4_IS_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_PROGRESS))
#define G4_PROGRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_PROGRESS, G4ProgressClass))

typedef struct _G4Progress G4Progress;
typedef struct _G4ProgressClass G4ProgressClass;
typedef struct _G4ProgressPrivate G4ProgressPrivate;
typedef struct _G4ParamSpecProgress G4ParamSpecProgress;

#define G4_TYPE_STOP_WATCH (g4_stop_watch_get_type ())
#define G4_STOP_WATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_STOP_WATCH, G4StopWatch))
#define G4_STOP_WATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_STOP_WATCH, G4StopWatchClass))
#define G4_IS_STOP_WATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_STOP_WATCH))
#define G4_IS_STOP_WATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_STOP_WATCH))
#define G4_STOP_WATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_STOP_WATCH, G4StopWatchClass))

typedef struct _G4StopWatch G4StopWatch;
typedef struct _G4StopWatchClass G4StopWatchClass;
typedef struct _G4StopWatchPrivate G4StopWatchPrivate;
typedef struct _G4ParamSpecStopWatch G4ParamSpecStopWatch;

#define G4_TYPE_MUSIC_LOADER (g4_music_loader_get_type ())
#define G4_MUSIC_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_MUSIC_LOADER, G4MusicLoader))
#define G4_MUSIC_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_MUSIC_LOADER, G4MusicLoaderClass))
#define G4_IS_MUSIC_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_MUSIC_LOADER))
#define G4_IS_MUSIC_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_MUSIC_LOADER))
#define G4_MUSIC_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_MUSIC_LOADER, G4MusicLoaderClass))

typedef struct _G4MusicLoader G4MusicLoader;
typedef struct _G4MusicLoaderClass G4MusicLoaderClass;
typedef struct _G4MusicLoaderPrivate G4MusicLoaderPrivate;

#define G4_TYPE_COVER_CACHE (g4_cover_cache_get_type ())
#define G4_COVER_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_COVER_CACHE, G4CoverCache))
#define G4_COVER_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_COVER_CACHE, G4CoverCacheClass))
#define G4_IS_COVER_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_COVER_CACHE))
#define G4_IS_COVER_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_COVER_CACHE))
#define G4_COVER_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_COVER_CACHE, G4CoverCacheClass))

typedef struct _G4CoverCache G4CoverCache;
typedef struct _G4CoverCacheClass G4CoverCacheClass;

#define G4_TYPE_DIR_MONITOR (g4_dir_monitor_get_type ())
#define G4_DIR_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_DIR_MONITOR, G4DirMonitor))
#define G4_DIR_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_DIR_MONITOR, G4DirMonitorClass))
#define G4_IS_DIR_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_DIR_MONITOR))
#define G4_IS_DIR_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_DIR_MONITOR))
#define G4_DIR_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_DIR_MONITOR, G4DirMonitorClass))

typedef struct _G4DirMonitor G4DirMonitor;
typedef struct _G4DirMonitorClass G4DirMonitorClass;

#define G4_TYPE_MUSIC_LIBRARY (g4_music_library_get_type ())
#define G4_MUSIC_LIBRARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_MUSIC_LIBRARY, G4MusicLibrary))
#define G4_MUSIC_LIBRARY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_MUSIC_LIBRARY, G4MusicLibraryClass))
#define G4_IS_MUSIC_LIBRARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_MUSIC_LIBRARY))
#define G4_IS_MUSIC_LIBRARY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_MUSIC_LIBRARY))
#define G4_MUSIC_LIBRARY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_MUSIC_LIBRARY, G4MusicLibraryClass))

typedef struct _G4MusicLibrary G4MusicLibrary;
typedef struct _G4MusicLibraryClass G4MusicLibraryClass;

#define G4_TYPE_TAG_CACHE (g4_tag_cache_get_type ())
#define G4_TAG_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_TAG_CACHE, G4TagCache))
#define G4_TAG_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_TAG_CACHE, G4TagCacheClass))
#define G4_IS_TAG_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_TAG_CACHE))
#define G4_IS_TAG_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_TAG_CACHE))
#define G4_TAG_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_TAG_CACHE, G4TagCacheClass))

typedef struct _G4TagCache G4TagCache;
typedef struct _G4TagCacheClass G4TagCacheClass;
enum  {
	G4_MUSIC_LOADER_0_PROPERTY,
	G4_MUSIC_LOADER_COVER_CACHE_PROPERTY,
	G4_MUSIC_LOADER_MONITOR_CHANGES_PROPERTY,
	G4_MUSIC_LOADER_LOADING_PROGRESS_PROPERTY,
	G4_MUSIC_LOADER_LIBRARY_PROPERTY,
	G4_MUSIC_LOADER_NUM_PROPERTIES
};
static GParamSpec* g4_music_loader_properties[G4_MUSIC_LOADER_NUM_PROPERTIES];

#define G4_TYPE_DIR_CACHE (g4_dir_cache_get_type ())
#define G4_DIR_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_DIR_CACHE, G4DirCache))
#define G4_DIR_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_DIR_CACHE, G4DirCacheClass))
#define G4_IS_DIR_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_DIR_CACHE))
#define G4_IS_DIR_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_DIR_CACHE))
#define G4_DIR_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_DIR_CACHE, G4DirCacheClass))

typedef struct _G4DirCache G4DirCache;
typedef struct _G4DirCacheClass G4DirCacheClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g4_progress_unref0(var) ((var == NULL) ? NULL : (var = (g4_progress_unref (var), NULL)))
#define _g4_tag_cache_unref0(var) ((var == NULL) ? NULL : (var = (g4_tag_cache_unref (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))

#define G4_TYPE_MUSIC (g4_music_get_type ())
#define G4_MUSIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_MUSIC, G4Music))
#define G4_MUSIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_MUSIC, G4MusicClass))
#define G4_IS_MUSIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_MUSIC))
#define G4_IS_MUSIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_MUSIC))
#define G4_MUSIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_MUSIC, G4MusicClass))

typedef struct _G4Music G4Music;
typedef struct _G4MusicClass G4MusicClass;
typedef void (*G4VoidFunc) (gpointer user_data);
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block62Data Block62Data;

#define G4_TYPE_ALBUM (g4_album_get_type ())
#define G4_ALBUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_ALBUM, G4Album))
#define G4_ALBUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_ALBUM, G4AlbumClass))
#define G4_IS_ALBUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_ALBUM))
#define G4_IS_ALBUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_ALBUM))
#define G4_ALBUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_ALBUM, G4AlbumClass))

typedef struct _G4Album G4Album;
typedef struct _G4AlbumClass G4AlbumClass;

#define G4_TYPE_PLAYLIST (g4_playlist_get_type ())
#define G4_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_PLAYLIST, G4Playlist))
#define G4_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_PLAYLIST, G4PlaylistClass))
#define G4_IS_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_PLAYLIST))
#define G4_IS_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_PLAYLIST))
#define G4_PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_PLAYLIST, G4PlaylistClass))

typedef struct _G4Playlist G4Playlist;
typedef struct _G4PlaylistClass G4PlaylistClass;
#define _g4_stop_watch_unref0(var) ((var == NULL) ? NULL : (var = (g4_stop_watch_unref (var), NULL)))
typedef struct _G4MusicLoaderLoadFilesAsyncData G4MusicLoaderLoadFilesAsyncData;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _G4MusicPrivate G4MusicPrivate;
typedef struct _G4AlbumPrivate G4AlbumPrivate;
typedef struct _G4PlaylistPrivate G4PlaylistPrivate;
typedef struct _Block63Data Block63Data;
typedef struct _Block64Data Block64Data;
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
typedef gpointer (*G4MusicLoaderThreadFunc) (gpointer user_data);
typedef struct _G4MusicLoaderOnFileAddedData G4MusicLoaderOnFileAddedData;
typedef struct _Block65Data Block65Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _G4MusicLoaderOnFileRemovedData G4MusicLoaderOnFileRemovedData;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
enum  {
	G4_MUSIC_LOADER_LOADING_CHANGED_SIGNAL,
	G4_MUSIC_LOADER_MUSIC_FOUND_SIGNAL,
	G4_MUSIC_LOADER_MUSIC_LOST_SIGNAL,
	G4_MUSIC_LOADER_NUM_SIGNALS
};
static guint g4_music_loader_signals[G4_MUSIC_LOADER_NUM_SIGNALS] = {0};

struct _G4Progress {
	GTypeInstance parent_instance;
	volatile int ref_count;
	G4ProgressPrivate * priv;
};

struct _G4ProgressClass {
	GTypeClass parent_class;
	void (*finalize) (G4Progress *self);
};

struct _G4ProgressPrivate {
	gint _progress;
	gint _total;
};

struct _G4ParamSpecProgress {
	GParamSpec parent_instance;
};

struct _G4StopWatch {
	GTypeInstance parent_instance;
	volatile int ref_count;
	G4StopWatchPrivate * priv;
};

struct _G4StopWatchClass {
	GTypeClass parent_class;
	void (*finalize) (G4StopWatch *self);
};

struct _G4StopWatchPrivate {
	gint64 _start_time;
};

struct _G4ParamSpecStopWatch {
	GParamSpec parent_instance;
};

struct _G4MusicLoader {
	GObject parent_instance;
	G4MusicLoaderPrivate * priv;
};

struct _G4MusicLoaderClass {
	GObjectClass parent_class;
};

struct _G4MusicLoaderPrivate {
	G4CoverCache* _cover_cache;
	G4DirMonitor* _dir_monitor;
	G4MusicLibrary* _library;
	G4Progress* _progress;
	G4TagCache* _tag_cache;
};

struct _Block62Data {
	int _ref_count_;
	G4MusicLoader* self;
	GPtrArray* dirs;
	GFile** files;
	gint files_length1;
	GPtrArray* musics;
	gboolean ignore_exists;
	gboolean merge_lists;
	guint sort_mode;
	gpointer _async_data_;
};

struct _G4MusicLoaderLoadFilesAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	G4MusicLoader* self;
	GFile** files;
	gint files_length1;
	GPtrArray* musics;
	gboolean ignore_exists;
	gboolean merge_lists;
	guint sort_mode;
	Block62Data* _data62_;
	GPtrArray* _tmp0_;
	G4Progress* _tmp1_;
};

struct _G4Music {
	GObject parent_instance;
	G4MusicPrivate * priv;
	gchar* album;
	gchar* artist;
	gchar* title;
	gchar* album_artist;
	guint32 date;
	gchar* genre;
	gint track;
	gint disc;
	gboolean has_cover;
	gint64 modified_time;
	gchar* uri;
	gchar* cover_uri;
	gchar* _album_key;
	gchar* _artist_key;
	gchar* _title_key;
	gint _order;
};

struct _G4MusicClass {
	GObjectClass parent_class;
	gchar* (*get_abbreviation) (G4Music* self);
};

struct _G4Album {
	G4Music parent_instance;
	G4AlbumPrivate * priv;
	GHashTable* _musics;
};

struct _G4AlbumClass {
	G4MusicClass parent_class;
	void (*get_sorted_musics) (G4Album* self, GPtrArray* musics);
	void (*sort) (G4Album* self, GPtrArray* arr);
};

struct _G4Playlist {
	G4Album parent_instance;
	G4PlaylistPrivate * priv;
	GPtrArray* items;
	gchar* list_uri;
};

struct _G4PlaylistClass {
	G4AlbumClass parent_class;
};

struct _Block63Data {
	int _ref_count_;
	G4MusicLoader* self;
	G4Playlist* playlist;
};

struct _Block64Data {
	int _ref_count_;
	G4MusicLoader* self;
	GAsyncQueue* queue;
};

struct _G4MusicLoaderOnFileAddedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	G4MusicLoader* self;
	GFile* file;
	GFileInfo* info;
	GFileInfo* _tmp0_;
	GPtrArray* arr;
	GPtrArray* _tmp1_;
	gint n_playlists;
	G4MusicLibrary* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GFile* _tmp5_;
	GFile** _tmp6_;
	GPtrArray* _tmp7_;
	G4MusicLibrary* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	gboolean _tmp11_;
	GPtrArray* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GPtrArray* _tmp15_;
	GError* _inner_error0_;
};

struct _Block65Data {
	int _ref_count_;
	G4MusicLoader* self;
	gboolean _result_;
	GHashTable* removed;
	GFile* file;
	gpointer _async_data_;
};

struct _G4MusicLoaderOnFileRemovedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	G4MusicLoader* self;
	GFile* file;
	Block65Data* _data65_;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gboolean _tmp3_;
	GHashTable* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	GHashTable* _tmp7_;
};

static gint G4Progress_private_offset;
static gpointer g4_progress_parent_class = NULL;
static gint G4StopWatch_private_offset;
static gpointer g4_stop_watch_parent_class = NULL;
static gint G4MusicLoader_private_offset;
static gpointer g4_music_loader_parent_class = NULL;
static GOnce g4_music_loader__save_dir_pool;
static GOnce g4_music_loader__save_dir_pool = G_ONCE_INIT;

VALA_EXTERN gpointer g4_progress_ref (gpointer instance);
VALA_EXTERN void g4_progress_unref (gpointer instance);
VALA_EXTERN GParamSpec* g4_param_spec_progress (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void g4_value_set_progress (GValue* value,
                            gpointer v_object);
VALA_EXTERN void g4_value_take_progress (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer g4_value_get_progress (const GValue* value);
VALA_EXTERN GType g4_progress_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4Progress, g4_progress_unref)
VALA_EXTERN G4Progress* g4_progress_new (gint total);
VALA_EXTERN G4Progress* g4_progress_construct (GType object_type,
                                   gint total);
VALA_EXTERN void g4_progress_reset (G4Progress* self);
VALA_EXTERN void g4_progress_step (G4Progress* self);
VALA_EXTERN gint g4_progress_get_total (G4Progress* self);
VALA_EXTERN void g4_progress_set_total (G4Progress* self,
                            gint value);
VALA_EXTERN gdouble g4_progress_get_fraction (G4Progress* self);
static void g4_progress_finalize (G4Progress * obj);
static GType g4_progress_get_type_once (void);
VALA_EXTERN gpointer g4_stop_watch_ref (gpointer instance);
VALA_EXTERN void g4_stop_watch_unref (gpointer instance);
VALA_EXTERN GParamSpec* g4_param_spec_stop_watch (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void g4_value_set_stop_watch (GValue* value,
                              gpointer v_object);
VALA_EXTERN void g4_value_take_stop_watch (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer g4_value_get_stop_watch (const GValue* value);
VALA_EXTERN GType g4_stop_watch_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4StopWatch, g4_stop_watch_unref)
VALA_EXTERN G4StopWatch* g4_stop_watch_new (void);
VALA_EXTERN G4StopWatch* g4_stop_watch_construct (GType object_type);
VALA_EXTERN gint64 g4_stop_watch_lap (G4StopWatch* self);
static void g4_stop_watch_finalize (G4StopWatch * obj);
static GType g4_stop_watch_get_type_once (void);
VALA_EXTERN GType g4_music_loader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4MusicLoader, g_object_unref)
VALA_EXTERN GType g4_cover_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4CoverCache, g_object_unref)
VALA_EXTERN GType g4_dir_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4DirMonitor, g_object_unref)
VALA_EXTERN GType g4_music_library_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4MusicLibrary, g_object_unref)
VALA_EXTERN gpointer g4_tag_cache_ref (gpointer instance);
VALA_EXTERN void g4_tag_cache_unref (gpointer instance);
VALA_EXTERN GParamSpec* g4_param_spec_tag_cache (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void g4_value_set_tag_cache (GValue* value,
                             gpointer v_object);
VALA_EXTERN void g4_value_take_tag_cache (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer g4_value_get_tag_cache (const GValue* value);
VALA_EXTERN GType g4_tag_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4TagCache, g4_tag_cache_unref)
VALA_EXTERN GType g4_dir_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4DirCache, g_object_unref)
VALA_EXTERN G4CoverCache* g4_cover_cache_new (void);
VALA_EXTERN G4CoverCache* g4_cover_cache_construct (GType object_type);
VALA_EXTERN G4DirMonitor* g4_dir_monitor_new (void);
VALA_EXTERN G4DirMonitor* g4_dir_monitor_construct (GType object_type);
VALA_EXTERN G4MusicLibrary* g4_music_library_new (void);
VALA_EXTERN G4MusicLibrary* g4_music_library_construct (GType object_type);
VALA_EXTERN G4TagCache* g4_tag_cache_new (const gchar* name);
VALA_EXTERN G4TagCache* g4_tag_cache_construct (GType object_type,
                                    const gchar* name);
static GThreadPool* g4_music_loader_get_save_dir_pool (void);
static GThreadPool* __lambda23_ (void);
static void ___lambda24_ (G4DirCache* cache);
VALA_EXTERN void g4_dir_cache_save (G4DirCache* self);
static void ____lambda24__gfunc (gpointer data,
                          gpointer self);
static gpointer ___lambda23__gthread_func (gpointer self);
VALA_EXTERN G4MusicLoader* g4_music_loader_new (void);
VALA_EXTERN G4MusicLoader* g4_music_loader_construct (GType object_type);
VALA_EXTERN void g4_music_loader_on_file_added (G4MusicLoader* self,
                                    GFile* file,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN void g4_music_loader_on_file_added_finish (G4MusicLoader* self,
                                           GAsyncResult* _res_);
static void _g4_music_loader_on_file_added_g4_dir_monitor_add_file (G4DirMonitor* _sender,
                                                             GFile* file,
                                                             gpointer self);
VALA_EXTERN void g4_music_loader_on_file_removed (G4MusicLoader* self,
                                      GFile* file,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN void g4_music_loader_on_file_removed_finish (G4MusicLoader* self,
                                             GAsyncResult* _res_);
static void _g4_music_loader_on_file_removed_g4_dir_monitor_remove_file (G4DirMonitor* _sender,
                                                                  GFile* file,
                                                                  gpointer self);
VALA_EXTERN GType g4_music_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4Music, g_object_unref)
VALA_EXTERN void g4_music_loader_add_to_cache (G4MusicLoader* self,
                                   G4Music* music);
VALA_EXTERN void g4_tag_cache_add (G4TagCache* self,
                       G4Music* music);
VALA_EXTERN G4Music* g4_music_loader_find_cache (G4MusicLoader* self,
                                     const gchar* uri);
VALA_EXTERN G4Music* g4_tag_cache_get (G4TagCache* self,
                           const gchar* uri);
VALA_EXTERN void g4_music_loader_load_tag_cache (G4MusicLoader* self);
VALA_EXTERN void g4_run_void_async (G4VoidFunc task,
                        gpointer task_target,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_);
VALA_EXTERN void g4_run_void_finish (GAsyncResult* _res_);
VALA_EXTERN void g4_tag_cache_load (G4TagCache* self);
static void _g4_tag_cache_load_g4_void_func (gpointer self);
static void __lambda36_ (G4MusicLoader* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda36__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void g4_music_loader_save_tag_cache (G4MusicLoader* self);
VALA_EXTERN gboolean g4_tag_cache_get_modified (G4TagCache* self);
VALA_EXTERN void g4_tag_cache_save (G4TagCache* self);
static void _g4_tag_cache_save_g4_void_func (gpointer self);
static void ___lambda34_ (G4MusicLoader* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda34__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void g4_music_loader_load_files_async_data_free (gpointer _data);
VALA_EXTERN void g4_music_loader_load_files_async (G4MusicLoader* self,
                                       GFile** files,
                                       gint files_length1,
                                       GPtrArray* musics,
                                       gboolean ignore_exists,
                                       gboolean merge_lists,
                                       guint sort_mode,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void g4_music_loader_load_files_finish (G4MusicLoader* self,
                                        GAsyncResult* _res_);
static gboolean g4_music_loader_load_files_async_co (G4MusicLoaderLoadFilesAsyncData* _data_);
static Block62Data* block62_data_ref (Block62Data* _data62_);
static void block62_data_unref (void * _userdata_);
static void _g_object_unref0_ (gpointer var);
static void __lambda28_ (Block62Data* _data62_);
static void g4_music_loader_add_file (G4MusicLoader* self,
                               GFile* file,
                               GPtrArray* musics,
                               GPtrArray* dirs,
                               GPtrArray* playlists);
VALA_EXTERN GType g4_album_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4Album, g_object_unref)
VALA_EXTERN GType g4_playlist_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4Playlist, g_object_unref)
static void g4_music_loader_load_playlists (G4MusicLoader* self,
                                     GPtrArray* musics,
                                     GPtrArray* list_files,
                                     GPtrArray* playlists,
                                     gboolean merge_lists);
static void g4_music_loader_load_tags_in_threads (G4MusicLoader* self,
                                           GPtrArray* musics);
static void g4_music_loader_add_musics_to_library (G4MusicLoader* self,
                                            GPtrArray* musics,
                                            GPtrArray* playlists,
                                            gboolean ignore_exists);
VALA_EXTERN void g4_sort_music_array (GPtrArray* arr,
                          guint sort_mode);
VALA_EXTERN guint g4_music_library_get_artist_count (G4MusicLibrary* self);
VALA_EXTERN guint g4_music_library_get_album_count (G4MusicLibrary* self);
VALA_EXTERN guint g4_music_library_get_playlist_count (G4MusicLibrary* self);
static void ___lambda28__g4_void_func (gpointer self);
static void g4_music_loader_load_files_async_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void __lambda32_ (Block62Data* _data62_);
VALA_EXTERN void g4_dir_monitor_monitor (G4DirMonitor* self,
                             GPtrArray* dirs);
static void ___lambda32__g4_void_func (gpointer self);
static void __lambda33_ (Block62Data* _data62_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda33__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void g4_music_loader_remove_all (G4MusicLoader* self);
VALA_EXTERN void g4_dir_monitor_remove_all (G4DirMonitor* self);
VALA_EXTERN void g4_music_library_remove_all (G4MusicLibrary* self);
VALA_EXTERN G4DirCache* g4_dir_cache_new (GFile* dir,
                              GFileInfo* info);
VALA_EXTERN G4DirCache* g4_dir_cache_construct (GType object_type,
                                    GFile* dir,
                                    GFileInfo* info);
VALA_EXTERN GFile* g4_dir_cache_get_dir (G4DirCache* self);
static void g4_music_loader_add_directory (G4MusicLoader* self,
                                    G4DirCache* cache,
                                    GQueue* stack,
                                    GPtrArray* musics,
                                    GPtrArray* playlists);
static inline void _g_queue_free__g_object_unref0_ (GQueue* self);
VALA_EXTERN gboolean g4_is_music_type (const gchar* content_type);
static gint64* _int64_dup (gint64* self);
VALA_EXTERN G4Music* g4_music_new (const gchar* uri,
                       const gchar* title,
                       gint64 time);
VALA_EXTERN G4Music* g4_music_construct (GType object_type,
                             const gchar* uri,
                             const gchar* title,
                             gint64 time);
VALA_EXTERN gboolean g4_is_playlist_file (const gchar* mimetype);
VALA_EXTERN gboolean g4_is_cover_file (const gchar* content_type,
                           const gchar* name);
VALA_EXTERN void g4_cover_cache_put (G4CoverCache* self,
                         GFile* dir,
                         const gchar* child);
VALA_EXTERN gboolean g4_dir_cache_check_valid (G4DirCache* self);
VALA_EXTERN gboolean g4_dir_cache_load (G4DirCache* self,
                            GQueue* stack,
                            GPtrArray* musics,
                            GPtrArray* playlists,
                            gchar** cover_name);
VALA_EXTERN void g4_dir_cache_add_child (G4DirCache* self,
                             GFileInfo* info,
                             guint8 type);
static void g4_music_loader_add_music_file (G4MusicLoader* self,
                                     GFile* file,
                                     GPtrArray* musics);
VALA_EXTERN gboolean g4_music_library_add_music (G4MusicLibrary* self,
                                     G4Music* music);
VALA_EXTERN void g4_playlist_set_cover_uri (G4Playlist* self);
VALA_EXTERN G4Playlist* g4_music_library_add_playlist (G4MusicLibrary* self,
                                           G4Playlist* playlist);
static void _g_free0_ (gpointer var);
VALA_EXTERN gchar* g4_load_playlist_file (GFile* file,
                              GPtrArray* uris);
static Block63Data* block63_data_ref (Block63Data* _data63_);
static void block63_data_unref (void * _userdata_);
VALA_EXTERN G4Playlist* g4_playlist_new (const gchar* name,
                             const gchar* uri);
VALA_EXTERN G4Playlist* g4_playlist_construct (GType object_type,
                                   const gchar* name,
                                   const gchar* uri);
static void ______lambda29_ (Block63Data* _data63_,
                      const gchar* uri);
static void _______lambda29__gfunc (gconstpointer data,
                             gpointer self);
static G4Music* _______lambda30_ (G4MusicLoader* self,
                           G4Music* src);
static gpointer ________lambda30__gcopy_func (gconstpointer src,
                                       gpointer self);
static Block64Data* block64_data_ref (Block64Data* _data64_);
static void block64_data_unref (void * _userdata_);
VALA_EXTERN void g4_tag_cache_wait_loading (G4TagCache* self);
static void g4_music_loader_run_in_threads (GType g_type,
                                     GBoxedCopyFunc g_dup_func,
                                     GDestroyNotify g_destroy_func,
                                     G4MusicLoaderThreadFunc func,
                                     gpointer func_target,
                                     GDestroyNotify func_target_destroy_notify,
                                     guint num_tasks);
static void ___lambda31_ (Block64Data* _data64_);
VALA_EXTERN void g4_music_parse_tags (G4Music* self);
static gpointer ____lambda31__g4_music_loader_thread_func (gpointer self);
static void g4_music_loader_on_file_added_data_free (gpointer _data);
static gboolean g4_music_loader_on_file_added_co (G4MusicLoaderOnFileAddedData* _data_);
static void g4_music_loader_on_file_added_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void g4_music_loader_on_file_removed_data_free (gpointer _data);
static gboolean g4_music_loader_on_file_removed_co (G4MusicLoaderOnFileRemovedData* _data_);
static Block65Data* block65_data_ref (Block65Data* _data65_);
static void block65_data_unref (void * _userdata_);
static void __lambda35_ (Block65Data* _data65_);
VALA_EXTERN G4Music* g4_tag_cache_remove (G4TagCache* self,
                              const gchar* uri);
VALA_EXTERN void g4_music_library_remove_music (G4MusicLibrary* self,
                                    G4Music* music);
VALA_EXTERN gboolean g4_music_library_remove_uri (G4MusicLibrary* self,
                                      const gchar* uri,
                                      GHashTable* removed);
VALA_EXTERN void g4_dir_cache_delete (G4DirCache* self);
static void ___lambda35__g4_void_func (gpointer self);
static void g4_music_loader_on_file_removed_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
VALA_EXTERN G4CoverCache* g4_music_loader_get_cover_cache (G4MusicLoader* self);
VALA_EXTERN gboolean g4_music_loader_get_monitor_changes (G4MusicLoader* self);
VALA_EXTERN gboolean g4_dir_monitor_get_enabled (G4DirMonitor* self);
VALA_EXTERN void g4_music_loader_set_monitor_changes (G4MusicLoader* self,
                                          gboolean value);
VALA_EXTERN void g4_dir_monitor_set_enabled (G4DirMonitor* self,
                                 gboolean value);
VALA_EXTERN gdouble g4_music_loader_get_loading_progress (G4MusicLoader* self);
VALA_EXTERN G4MusicLibrary* g4_music_loader_get_library (G4MusicLoader* self);
static void g4_music_loader_finalize (GObject * obj);
static GType g4_music_loader_get_type_once (void);
static void _vala_g4_music_loader_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_g4_music_loader_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
g4_progress_get_instance_private (G4Progress* self)
{
	return G_STRUCT_MEMBER_P (self, G4Progress_private_offset);
}

G4Progress*
g4_progress_construct (GType object_type,
                       gint total)
{
	G4Progress* self = NULL;
	self = (G4Progress*) g_type_create_instance (object_type);
	self->priv->_total = total;
	return self;
}

G4Progress*
g4_progress_new (gint total)
{
	return g4_progress_construct (G4_TYPE_PROGRESS, total);
}

void
g4_progress_reset (G4Progress* self)
{
	g_return_if_fail (self != NULL);
	self->priv->_progress = 0;
	self->priv->_total = 0;
}

void
g4_progress_step (G4Progress* self)
{
	g_return_if_fail (self != NULL);
	g_atomic_int_inc ((volatile gint *) (&self->priv->_progress));
}

gint
g4_progress_get_total (G4Progress* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_atomic_int_get ((volatile gint *) (&self->priv->_total));
	result = _tmp0_;
	return result;
}

void
g4_progress_set_total (G4Progress* self,
                       gint value)
{
	g_return_if_fail (self != NULL);
	g_atomic_int_set ((volatile gint *) (&self->priv->_total), value);
}

gdouble
g4_progress_get_fraction (G4Progress* self)
{
	gdouble result;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	if (self->priv->_total > 0) {
		_tmp0_ = self->priv->_progress / ((gdouble) self->priv->_total);
	} else {
		_tmp0_ = (gdouble) 0;
	}
	result = _tmp0_;
	return result;
}

static void
g4_value_progress_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
g4_value_progress_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		g4_progress_unref (value->data[0].v_pointer);
	}
}

static void
g4_value_progress_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = g4_progress_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
g4_value_progress_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
g4_value_progress_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		G4Progress * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = g4_progress_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
g4_value_progress_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	G4Progress ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = g4_progress_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
g4_param_spec_progress (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	G4ParamSpecProgress* spec;
	g_return_val_if_fail (g_type_is_a (object_type, G4_TYPE_PROGRESS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
g4_value_get_progress (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, G4_TYPE_PROGRESS), NULL);
	return value->data[0].v_pointer;
}

void
g4_value_set_progress (GValue* value,
                       gpointer v_object)
{
	G4Progress * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, G4_TYPE_PROGRESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, G4_TYPE_PROGRESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		g4_progress_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		g4_progress_unref (old);
	}
}

void
g4_value_take_progress (GValue* value,
                        gpointer v_object)
{
	G4Progress * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, G4_TYPE_PROGRESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, G4_TYPE_PROGRESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		g4_progress_unref (old);
	}
}

static void
g4_progress_class_init (G4ProgressClass * klass,
                        gpointer klass_data)
{
	g4_progress_parent_class = g_type_class_peek_parent (klass);
	((G4ProgressClass *) klass)->finalize = g4_progress_finalize;
	g_type_class_adjust_private_offset (klass, &G4Progress_private_offset);
}

static void
g4_progress_instance_init (G4Progress * self,
                           gpointer klass)
{
	self->priv = g4_progress_get_instance_private (self);
	self->priv->_progress = 0;
	self->priv->_total = 0;
	self->ref_count = 1;
}

static void
g4_progress_finalize (G4Progress * obj)
{
	G4Progress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_TYPE_PROGRESS, G4Progress);
	g_signal_handlers_destroy (self);
}

static GType
g4_progress_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { g4_value_progress_init, g4_value_progress_free_value, g4_value_progress_copy_value, g4_value_progress_peek_pointer, "p", g4_value_progress_collect_value, "p", g4_value_progress_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (G4ProgressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_progress_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (G4Progress), 0, (GInstanceInitFunc) g4_progress_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType g4_progress_type_id;
	g4_progress_type_id = g_type_register_fundamental (g_type_fundamental_next (), "G4Progress", &g_define_type_info, &g_define_type_fundamental_info, 0);
	G4Progress_private_offset = g_type_add_instance_private (g4_progress_type_id, sizeof (G4ProgressPrivate));
	return g4_progress_type_id;
}

GType
g4_progress_get_type (void)
{
	static volatile gsize g4_progress_type_id__once = 0;
	if (g_once_init_enter (&g4_progress_type_id__once)) {
		GType g4_progress_type_id;
		g4_progress_type_id = g4_progress_get_type_once ();
		g_once_init_leave (&g4_progress_type_id__once, g4_progress_type_id);
	}
	return g4_progress_type_id__once;
}

gpointer
g4_progress_ref (gpointer instance)
{
	G4Progress * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
g4_progress_unref (gpointer instance)
{
	G4Progress * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		G4_PROGRESS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
g4_stop_watch_get_instance_private (G4StopWatch* self)
{
	return G_STRUCT_MEMBER_P (self, G4StopWatch_private_offset);
}

G4StopWatch*
g4_stop_watch_construct (GType object_type)
{
	G4StopWatch* self = NULL;
	self = (G4StopWatch*) g_type_create_instance (object_type);
	self->priv->_start_time = g_get_monotonic_time ();
	return self;
}

G4StopWatch*
g4_stop_watch_new (void)
{
	return g4_stop_watch_construct (G4_TYPE_STOP_WATCH);
}

gint64
g4_stop_watch_lap (G4StopWatch* self)
{
	gint64 now = 0LL;
	gint64 used = 0LL;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	now = g_get_monotonic_time ();
	used = now - self->priv->_start_time;
	self->priv->_start_time = now;
	result = used;
	return result;
}

static void
g4_value_stop_watch_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
g4_value_stop_watch_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		g4_stop_watch_unref (value->data[0].v_pointer);
	}
}

static void
g4_value_stop_watch_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = g4_stop_watch_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
g4_value_stop_watch_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
g4_value_stop_watch_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		G4StopWatch * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = g4_stop_watch_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
g4_value_stop_watch_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	G4StopWatch ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = g4_stop_watch_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
g4_param_spec_stop_watch (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	G4ParamSpecStopWatch* spec;
	g_return_val_if_fail (g_type_is_a (object_type, G4_TYPE_STOP_WATCH), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
g4_value_get_stop_watch (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, G4_TYPE_STOP_WATCH), NULL);
	return value->data[0].v_pointer;
}

void
g4_value_set_stop_watch (GValue* value,
                         gpointer v_object)
{
	G4StopWatch * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, G4_TYPE_STOP_WATCH));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, G4_TYPE_STOP_WATCH));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		g4_stop_watch_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		g4_stop_watch_unref (old);
	}
}

void
g4_value_take_stop_watch (GValue* value,
                          gpointer v_object)
{
	G4StopWatch * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, G4_TYPE_STOP_WATCH));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, G4_TYPE_STOP_WATCH));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		g4_stop_watch_unref (old);
	}
}

static void
g4_stop_watch_class_init (G4StopWatchClass * klass,
                          gpointer klass_data)
{
	g4_stop_watch_parent_class = g_type_class_peek_parent (klass);
	((G4StopWatchClass *) klass)->finalize = g4_stop_watch_finalize;
	g_type_class_adjust_private_offset (klass, &G4StopWatch_private_offset);
}

static void
g4_stop_watch_instance_init (G4StopWatch * self,
                             gpointer klass)
{
	self->priv = g4_stop_watch_get_instance_private (self);
	self->ref_count = 1;
}

static void
g4_stop_watch_finalize (G4StopWatch * obj)
{
	G4StopWatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_TYPE_STOP_WATCH, G4StopWatch);
	g_signal_handlers_destroy (self);
}

static GType
g4_stop_watch_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { g4_value_stop_watch_init, g4_value_stop_watch_free_value, g4_value_stop_watch_copy_value, g4_value_stop_watch_peek_pointer, "p", g4_value_stop_watch_collect_value, "p", g4_value_stop_watch_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (G4StopWatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_stop_watch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (G4StopWatch), 0, (GInstanceInitFunc) g4_stop_watch_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType g4_stop_watch_type_id;
	g4_stop_watch_type_id = g_type_register_fundamental (g_type_fundamental_next (), "G4StopWatch", &g_define_type_info, &g_define_type_fundamental_info, 0);
	G4StopWatch_private_offset = g_type_add_instance_private (g4_stop_watch_type_id, sizeof (G4StopWatchPrivate));
	return g4_stop_watch_type_id;
}

GType
g4_stop_watch_get_type (void)
{
	static volatile gsize g4_stop_watch_type_id__once = 0;
	if (g_once_init_enter (&g4_stop_watch_type_id__once)) {
		GType g4_stop_watch_type_id;
		g4_stop_watch_type_id = g4_stop_watch_get_type_once ();
		g_once_init_leave (&g4_stop_watch_type_id__once, g4_stop_watch_type_id);
	}
	return g4_stop_watch_type_id__once;
}

gpointer
g4_stop_watch_ref (gpointer instance)
{
	G4StopWatch * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
g4_stop_watch_unref (gpointer instance)
{
	G4StopWatch * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		G4_STOP_WATCH_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
g4_music_loader_get_instance_private (G4MusicLoader* self)
{
	return G_STRUCT_MEMBER_P (self, G4MusicLoader_private_offset);
}

static void
___lambda24_ (G4DirCache* cache)
{
	g_return_if_fail (cache != NULL);
	g4_dir_cache_save (cache);
	_g_object_unref0 (cache);
}

static void
____lambda24__gfunc (gpointer data,
                     gpointer self)
{
	___lambda24_ ((G4DirCache*) data);
}

static GThreadPool*
__lambda23_ (void)
{
	GError* _inner_error0_ = NULL;
	GThreadPool* result;
	{
		GThreadPool* _tmp0_ = NULL;
		GThreadPool* _tmp1_;
		GThreadPool* _tmp2_;
		_tmp1_ = g_thread_pool_new (____lambda24__gfunc, NULL, 1, FALSE, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp2_;
		_g_thread_pool_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static gpointer
___lambda23__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda23_ ();
	return result;
}

static GThreadPool*
g4_music_loader_get_save_dir_pool (void)
{
	gconstpointer _tmp0_;
	GThreadPool* result;
	_tmp0_ = g_once (&g4_music_loader__save_dir_pool, ___lambda23__gthread_func, NULL);
	result = (GThreadPool*) _tmp0_;
	return result;
}

static void
_g4_music_loader_on_file_added_g4_dir_monitor_add_file (G4DirMonitor* _sender,
                                                        GFile* file,
                                                        gpointer self)
{
	g4_music_loader_on_file_added ((G4MusicLoader*) self, file, NULL, NULL);
}

static void
_g4_music_loader_on_file_removed_g4_dir_monitor_remove_file (G4DirMonitor* _sender,
                                                             GFile* file,
                                                             gpointer self)
{
	g4_music_loader_on_file_removed ((G4MusicLoader*) self, file, NULL, NULL);
}

G4MusicLoader*
g4_music_loader_construct (GType object_type)
{
	G4MusicLoader * self = NULL;
	G4DirMonitor* _tmp0_;
	G4DirMonitor* _tmp1_;
	self = (G4MusicLoader*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->_dir_monitor;
	g_signal_connect_object (_tmp0_, "add-file", (GCallback) _g4_music_loader_on_file_added_g4_dir_monitor_add_file, self, 0);
	_tmp1_ = self->priv->_dir_monitor;
	g_signal_connect_object (_tmp1_, "remove-file", (GCallback) _g4_music_loader_on_file_removed_g4_dir_monitor_remove_file, self, 0);
	return self;
}

G4MusicLoader*
g4_music_loader_new (void)
{
	return g4_music_loader_construct (G4_TYPE_MUSIC_LOADER);
}

void
g4_music_loader_add_to_cache (G4MusicLoader* self,
                              G4Music* music)
{
	G4TagCache* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (music != NULL);
	_tmp0_ = self->priv->_tag_cache;
	g4_tag_cache_add (_tmp0_, music);
}

G4Music*
g4_music_loader_find_cache (G4MusicLoader* self,
                            const gchar* uri)
{
	G4TagCache* _tmp0_;
	G4Music* _tmp1_;
	G4Music* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = self->priv->_tag_cache;
	_tmp1_ = g4_tag_cache_get (_tmp0_, uri);
	result = _tmp1_;
	return result;
}

static void
_g4_tag_cache_load_g4_void_func (gpointer self)
{
	g4_tag_cache_load ((G4TagCache*) self);
}

static void
__lambda36_ (G4MusicLoader* self,
             GObject* obj,
             GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	g4_run_void_finish (res);
}

static void
___lambda36__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda36_ ((G4MusicLoader*) self, source_object, res);
	g_object_unref (self);
}

void
g4_music_loader_load_tag_cache (G4MusicLoader* self)
{
	G4TagCache* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_tag_cache;
	g4_run_void_async (_g4_tag_cache_load_g4_void_func, _tmp0_, ___lambda36__gasync_ready_callback, g_object_ref (self));
}

static void
_g4_tag_cache_save_g4_void_func (gpointer self)
{
	g4_tag_cache_save ((G4TagCache*) self);
}

static void
___lambda34_ (G4MusicLoader* self,
              GObject* obj,
              GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	g4_run_void_finish (res);
}

static void
____lambda34__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda34_ ((G4MusicLoader*) self, source_object, res);
	g_object_unref (self);
}

void
g4_music_loader_save_tag_cache (G4MusicLoader* self)
{
	G4TagCache* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_tag_cache;
	_tmp1_ = g4_tag_cache_get_modified (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		G4TagCache* _tmp3_;
		_tmp3_ = self->priv->_tag_cache;
		g4_run_void_async (_g4_tag_cache_save_g4_void_func, _tmp3_, ____lambda34__gasync_ready_callback, g_object_ref (self));
	}
}

static void
g4_music_loader_load_files_async_data_free (gpointer _data)
{
	G4MusicLoaderLoadFilesAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (G4MusicLoaderLoadFilesAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

void
g4_music_loader_load_files_async (G4MusicLoader* self,
                                  GFile** files,
                                  gint files_length1,
                                  GPtrArray* musics,
                                  gboolean ignore_exists,
                                  gboolean merge_lists,
                                  guint sort_mode,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	G4MusicLoaderLoadFilesAsyncData* _data_;
	G4MusicLoader* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (musics != NULL);
	_data_ = g_slice_new0 (G4MusicLoaderLoadFilesAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, g4_music_loader_load_files_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->files = (_vala_array_free (_data_->files, _data_->files_length1, (GDestroyNotify) g_object_unref), NULL);
	_data_->files = files;
	_data_->files_length1 = files_length1;
	_tmp1_ = _g_ptr_array_ref0 (musics);
	_g_ptr_array_unref0 (_data_->musics);
	_data_->musics = _tmp1_;
	_data_->ignore_exists = ignore_exists;
	_data_->merge_lists = merge_lists;
	_data_->sort_mode = sort_mode;
	g4_music_loader_load_files_async_co (_data_);
}

void
g4_music_loader_load_files_finish (G4MusicLoader* self,
                                   GAsyncResult* _res_)
{
	G4MusicLoaderLoadFilesAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block62Data*
block62_data_ref (Block62Data* _data62_)
{
	g_atomic_int_inc (&_data62_->_ref_count_);
	return _data62_;
}

static void
block62_data_unref (void * _userdata_)
{
	Block62Data* _data62_;
	_data62_ = (Block62Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data62_->_ref_count_)) {
		G4MusicLoader* self;
		self = _data62_->self;
		_g_ptr_array_unref0 (_data62_->dirs);
		_data62_->files = (_vala_array_free (_data62_->files, _data62_->files_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_ptr_array_unref0 (_data62_->musics);
		_g_object_unref0 (self);
		g_slice_free (Block62Data, _data62_);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
__lambda28_ (Block62Data* _data62_)
{
	G4MusicLoader* self;
	GPtrArray* list_files = NULL;
	GPtrArray* _tmp0_;
	G4StopWatch* stop_watch = NULL;
	G4StopWatch* _tmp1_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	G4StopWatch* _tmp9_;
	GPtrArray* playlists = NULL;
	GPtrArray* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GPtrArray* _tmp13_;
	GPtrArray* _tmp14_;
	GPtrArray* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	G4StopWatch* _tmp18_;
	GPtrArray* _tmp19_;
	G4MusicLibrary* _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	G4MusicLibrary* _tmp23_;
	guint _tmp24_;
	guint _tmp25_;
	G4MusicLibrary* _tmp26_;
	guint _tmp27_;
	guint _tmp28_;
	G4StopWatch* _tmp29_;
	self = _data62_->self;
	_tmp0_ = g_ptr_array_new_full ((guint) 128, _g_object_unref0_);
	list_files = _tmp0_;
	_tmp1_ = g4_stop_watch_new ();
	stop_watch = _tmp1_;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = _data62_->files;
		file_collection_length1 = _data62_->files_length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			GFile* _tmp2_;
			GFile* file = NULL;
			_tmp2_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp2_;
			{
				GFile* _tmp3_;
				GPtrArray* _tmp4_;
				_tmp3_ = file;
				_tmp4_ = list_files;
				g4_music_loader_add_file (self, _tmp3_, _data62_->musics, _data62_->dirs, _tmp4_);
				_g_object_unref0 (file);
			}
		}
	}
	_tmp5_ = vala_g_ptr_array_get_length (_data62_->musics);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_g_ptr_array_get_length (_data62_->dirs);
	_tmp8_ = _tmp7_;
	_tmp9_ = stop_watch;
	g_print ("Find %u files in %d folders in %lld ms\n", (guint) _tmp6_, _tmp8_, g4_stop_watch_lap (_tmp9_) / 1000);
	_tmp10_ = list_files;
	_tmp11_ = vala_g_ptr_array_get_length (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_ptr_array_new_full ((guint) _tmp12_, _g_object_unref0_);
	playlists = _tmp13_;
	_tmp14_ = list_files;
	_tmp15_ = playlists;
	g4_music_loader_load_playlists (self, _data62_->musics, _tmp14_, _tmp15_, _data62_->merge_lists);
	g4_music_loader_load_tags_in_threads (self, _data62_->musics);
	_tmp16_ = vala_g_ptr_array_get_length (_data62_->musics);
	_tmp17_ = _tmp16_;
	_tmp18_ = stop_watch;
	g_print ("Load %u musics in %lld ms\n", (guint) _tmp17_, g4_stop_watch_lap (_tmp18_) / 1000);
	_tmp19_ = playlists;
	g4_music_loader_add_musics_to_library (self, _data62_->musics, _tmp19_, _data62_->ignore_exists);
	if (_data62_->sort_mode <= G4_SORT_MODE_MAX) {
		g4_sort_music_array (_data62_->musics, _data62_->sort_mode);
	}
	_tmp20_ = self->priv->_library;
	_tmp21_ = g4_music_library_get_artist_count (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = self->priv->_library;
	_tmp24_ = g4_music_library_get_album_count (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = self->priv->_library;
	_tmp27_ = g4_music_library_get_playlist_count (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = stop_watch;
	g_print ("Group %u artists %u albums %u playlists in %lld ms\n", _tmp22_, _tmp25_, _tmp28_, g4_stop_watch_lap (_tmp29_) / 1000);
	_g_ptr_array_unref0 (playlists);
	_g4_stop_watch_unref0 (stop_watch);
	_g_ptr_array_unref0 (list_files);
}

static void
___lambda28__g4_void_func (gpointer self)
{
	__lambda28_ (self);
}

static void
g4_music_loader_load_files_async_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	G4MusicLoaderLoadFilesAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	g4_music_loader_load_files_async_co (_data_);
}

static void
__lambda32_ (Block62Data* _data62_)
{
	G4MusicLoader* self;
	G4DirMonitor* _tmp0_;
	self = _data62_->self;
	_tmp0_ = self->priv->_dir_monitor;
	g4_dir_monitor_monitor (_tmp0_, _data62_->dirs);
}

static void
___lambda32__g4_void_func (gpointer self)
{
	__lambda32_ (self);
}

static void
__lambda33_ (Block62Data* _data62_,
             GObject* obj,
             GAsyncResult* res)
{
	G4MusicLoader* self;
	self = _data62_->self;
	g_return_if_fail (res != NULL);
	g4_run_void_finish (res);
}

static void
___lambda33__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda33_ (self, source_object, res);
	block62_data_unref (self);
}

static gboolean
g4_music_loader_load_files_async_co (G4MusicLoaderLoadFilesAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data62_ = g_slice_new0 (Block62Data);
	_data_->_data62_->_ref_count_ = 1;
	_data_->_data62_->self = g_object_ref (_data_->self);
	_data_->_data62_->files = (_vala_array_free (_data_->_data62_->files, _data_->_data62_->files_length1, (GDestroyNotify) g_object_unref), NULL);
	_data_->_data62_->files = _data_->files;
	_data_->_data62_->files_length1 = _data_->files_length1;
	_g_ptr_array_unref0 (_data_->_data62_->musics);
	_data_->_data62_->musics = _data_->musics;
	_data_->_data62_->ignore_exists = _data_->ignore_exists;
	_data_->_data62_->merge_lists = _data_->merge_lists;
	_data_->_data62_->sort_mode = _data_->sort_mode;
	_data_->_data62_->_async_data_ = _data_;
	_data_->_tmp0_ = g_ptr_array_new_full ((guint) 128, _g_object_unref0_);
	_data_->_data62_->dirs = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->_progress;
	g4_progress_reset (_data_->_tmp1_);
	g_signal_emit (_data_->self, g4_music_loader_signals[G4_MUSIC_LOADER_LOADING_CHANGED_SIGNAL], 0, TRUE);
	_data_->_state_ = 1;
	g4_run_void_async (___lambda28__g4_void_func, _data_->_data62_, g4_music_loader_load_files_async_ready, _data_);
	return FALSE;
	_state_1:
	g4_run_void_finish (_data_->_res_);
	g_signal_emit (_data_->self, g4_music_loader_signals[G4_MUSIC_LOADER_LOADING_CHANGED_SIGNAL], 0, FALSE);
	g4_run_void_async (___lambda32__g4_void_func, _data_->_data62_, ___lambda33__gasync_ready_callback, block62_data_ref (_data_->_data62_));
	g4_music_loader_save_tag_cache (_data_->self);
	block62_data_unref (_data_->_data62_);
	_data_->_data62_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
g4_music_loader_remove_all (G4MusicLoader* self)
{
	G4DirMonitor* _tmp0_;
	G4MusicLibrary* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_dir_monitor;
	g4_dir_monitor_remove_all (_tmp0_);
	_tmp1_ = self->priv->_library;
	g4_music_library_remove_all (_tmp1_);
}

static inline void
_g_queue_free__g_object_unref0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}

static gpointer
__int64_dup0 (gpointer self)
{
	return self ? _int64_dup (self) : NULL;
}

static void
g4_music_loader_add_file (G4MusicLoader* self,
                          GFile* file,
                          GPtrArray* musics,
                          GPtrArray* dirs,
                          GPtrArray* playlists)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (musics != NULL);
	g_return_if_fail (dirs != NULL);
	g_return_if_fail (playlists != NULL);
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp0_;
		_tmp0_ = g_file_query_info (file, G4_MUSIC_LOADER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (g_file_info_get_file_type (info) == G_FILE_TYPE_DIRECTORY) {
			GQueue* stack = NULL;
			GQueue* _tmp1_;
			GQueue* _tmp2_;
			G4DirCache* _tmp3_;
			_tmp1_ = g_queue_new ();
			stack = _tmp1_;
			_tmp2_ = stack;
			_tmp3_ = g4_dir_cache_new (file, info);
			g_queue_push_head (_tmp2_, _tmp3_);
			while (TRUE) {
				GQueue* _tmp4_;
				G4DirCache* cache = NULL;
				GQueue* _tmp5_;
				gpointer _tmp6_;
				G4DirCache* _tmp7_;
				GFile* _tmp8_;
				GFile* _tmp9_;
				GFile* _tmp10_;
				G4DirCache* _tmp11_;
				GQueue* _tmp12_;
				_tmp4_ = stack;
				if (!(_tmp4_->length > ((guint) 0))) {
					break;
				}
				_tmp5_ = stack;
				_tmp6_ = g_queue_pop_head (_tmp5_);
				cache = (G4DirCache*) _tmp6_;
				_tmp7_ = cache;
				_tmp8_ = g4_dir_cache_get_dir (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				g_ptr_array_add (dirs, _tmp10_);
				_tmp11_ = cache;
				_tmp12_ = stack;
				g4_music_loader_add_directory (self, _tmp11_, _tmp12_, musics, playlists);
				_g_object_unref0 (cache);
			}
			(stack == NULL) ? NULL : (stack = (_g_queue_free__g_object_unref0_ (stack), NULL));
		} else {
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_;
			const gchar* ctype = NULL;
			const gchar* name = NULL;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp14_ = g_file_info_get_content_type (info);
			_tmp13_ = _tmp14_;
			if (_tmp13_ == NULL) {
				_tmp13_ = "";
			}
			ctype = (const gchar*) _tmp13_;
			_tmp15_ = g_file_info_get_name (info);
			name = _tmp15_;
			_tmp16_ = ctype;
			if (g4_is_music_type (_tmp16_)) {
				GDateTime* _tmp17_ = NULL;
				GDateTime* _tmp18_;
				gint64* _tmp19_ = NULL;
				gint64* _tmp22_ = NULL;
				gint64* _tmp23_;
				gint64 time = 0LL;
				gint64* _tmp26_;
				gint64 _tmp27_;
				G4Music* music = NULL;
				gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				G4Music* _tmp31_;
				G4Music* _tmp32_;
				G4Music* _tmp33_;
				G4Music* _tmp34_;
				_tmp18_ = g_file_info_get_modification_date_time (info);
				_tmp17_ = _tmp18_;
				_tmp19_ = NULL;
				if (_tmp17_ != NULL) {
					gint64 _tmp20_;
					gint64* _tmp21_;
					_tmp20_ = g_date_time_to_unix ((GDateTime*) _tmp17_);
					_tmp21_ = __int64_dup0 (&_tmp20_);
					_g_free0 (_tmp19_);
					_tmp19_ = _tmp21_;
				}
				_tmp23_ = _tmp19_;
				_tmp19_ = NULL;
				_tmp22_ = _tmp23_;
				if (_tmp22_ == NULL) {
					gint64 _tmp24_;
					gint64* _tmp25_;
					_tmp24_ = (gint64) 0;
					_tmp25_ = __int64_dup0 (&_tmp24_);
					_g_free0 (_tmp22_);
					_tmp22_ = _tmp25_;
				}
				_tmp26_ = _tmp22_;
				_tmp22_ = NULL;
				_tmp27_ = (gint64) (*_tmp26_);
				_g_free0 (_tmp26_);
				time = _tmp27_;
				_tmp28_ = g_file_get_uri (file);
				_tmp29_ = _tmp28_;
				_tmp30_ = name;
				_tmp31_ = g4_music_new (_tmp29_, _tmp30_, time);
				_tmp32_ = _tmp31_;
				_g_free0 (_tmp29_);
				music = _tmp32_;
				_tmp33_ = music;
				_tmp34_ = _g_object_ref0 (_tmp33_);
				g_ptr_array_add (musics, _tmp34_);
				_g_object_unref0 (music);
				_g_free0 (_tmp22_);
				_g_free0 (_tmp19_);
				_g_date_time_unref0 (_tmp17_);
			} else {
				const gchar* _tmp35_;
				_tmp35_ = ctype;
				if (g4_is_playlist_file (_tmp35_)) {
					GFile* _tmp36_;
					_tmp36_ = _g_object_ref0 (file);
					g_ptr_array_add (playlists, _tmp36_);
				} else {
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					_tmp37_ = ctype;
					_tmp38_ = name;
					if (g4_is_cover_file (_tmp37_, _tmp38_)) {
						GFile* parent = NULL;
						GFile* _tmp39_;
						GFile* _tmp40_;
						_tmp39_ = g_file_get_parent (file);
						parent = _tmp39_;
						_tmp40_ = parent;
						if (_tmp40_ != NULL) {
							G4CoverCache* _tmp41_;
							GFile* _tmp42_;
							const gchar* _tmp43_;
							_tmp41_ = self->priv->_cover_cache;
							_tmp42_ = parent;
							_tmp43_ = name;
							g4_cover_cache_put (_tmp41_, G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, g_file_get_type (), GFile), _tmp43_);
						}
						_g_object_unref0 (parent);
					} else {
						gchar* _tmp44_ = NULL;
						gchar* _tmp45_;
						const gchar* _tmp47_;
						_tmp45_ = g_file_get_path (file);
						_tmp44_ = _tmp45_;
						if (_tmp44_ == NULL) {
							gchar* _tmp46_;
							_tmp46_ = g_strdup ("");
							_g_free0 (_tmp44_);
							_tmp44_ = _tmp46_;
						}
						_tmp47_ = ctype;
						g_print ("unknown type: %s, %s\n", _tmp47_, (const gchar*) _tmp44_);
						_g_free0 (_tmp44_);
					}
				}
			}
		}
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp48_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp48_ = e;
		if (_tmp48_->code != G_IO_ERROR_NOT_FOUND) {
			gchar* _tmp49_;
			gchar* _tmp50_;
			GError* _tmp51_;
			const gchar* _tmp52_;
			_tmp49_ = g_file_get_parse_name (file);
			_tmp50_ = _tmp49_;
			_tmp51_ = e;
			_tmp52_ = _tmp51_->message;
			g_print ("Query %s: %s\n", _tmp50_, _tmp52_);
			_g_free0 (_tmp50_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
g4_music_loader_add_directory (G4MusicLoader* self,
                               G4DirCache* cache,
                               GQueue* stack,
                               GPtrArray* musics,
                               GPtrArray* playlists)
{
	GFile* dir = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gint start = 0;
	gint _tmp3_;
	gint _tmp4_;
	gchar* cover_name = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp89_ = FALSE;
	const gchar* _tmp90_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cache != NULL);
	g_return_if_fail (stack != NULL);
	g_return_if_fail (musics != NULL);
	g_return_if_fail (playlists != NULL);
	_tmp0_ = g4_dir_cache_get_dir (cache);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	dir = _tmp2_;
	_tmp3_ = vala_g_ptr_array_get_length (musics);
	_tmp4_ = _tmp3_;
	start = _tmp4_;
	cover_name = NULL;
	if (g4_dir_cache_check_valid (cache)) {
		gchar* _tmp6_ = NULL;
		gboolean _tmp7_;
		_tmp7_ = g4_dir_cache_load (cache, stack, musics, playlists, &_tmp6_);
		_g_free0 (cover_name);
		cover_name = _tmp6_;
		_tmp5_ = _tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_;
		G4CoverCache* _tmp10_;
		GFile* _tmp11_;
		_tmp9_ = cover_name;
		_tmp8_ = _tmp9_;
		if (_tmp8_ == NULL) {
			_tmp8_ = "";
		}
		_tmp10_ = self->priv->_cover_cache;
		_tmp11_ = dir;
		g4_cover_cache_put (_tmp10_, _tmp11_, (const gchar*) _tmp8_);
	} else {
		{
			GFileInfo* pi = NULL;
			GFileEnumerator* enumerator = NULL;
			GFile* _tmp12_;
			GFileEnumerator* _tmp13_;
			const gchar* _tmp76_ = NULL;
			const gchar* _tmp77_;
			G4CoverCache* _tmp78_;
			GFile* _tmp79_;
			GThreadPool* _tmp80_ = NULL;
			GThreadPool* _tmp81_;
			pi = NULL;
			_tmp12_ = dir;
			_tmp13_ = g_file_enumerate_children (_tmp12_, G4_MUSIC_LOADER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			enumerator = _tmp13_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (pi);
				goto __catch0_g_error;
			}
			while (TRUE) {
				GFileInfo* _tmp14_ = NULL;
				GFileEnumerator* _tmp15_;
				GFileInfo* _tmp16_;
				GFileInfo* _tmp17_;
				GFileInfo* _tmp18_;
				GFileInfo* info = NULL;
				GFileInfo* _tmp19_;
				GFileInfo* _tmp20_;
				GFileInfo* _tmp21_;
				_tmp15_ = enumerator;
				_tmp16_ = g_file_enumerator_next_file (_tmp15_, NULL, &_inner_error0_);
				_tmp14_ = _tmp16_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (enumerator);
					_g_object_unref0 (pi);
					goto __catch0_g_error;
				}
				_tmp17_ = _tmp14_;
				_tmp14_ = NULL;
				_g_object_unref0 (pi);
				pi = _tmp17_;
				_tmp18_ = pi;
				if (!(_tmp18_ != NULL)) {
					_g_object_unref0 (_tmp14_);
					break;
				}
				_tmp19_ = pi;
				_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, g_file_info_get_type (), GFileInfo));
				info = _tmp20_;
				_tmp21_ = info;
				if (g_file_info_get_is_hidden (_tmp21_)) {
					_g_object_unref0 (info);
					_g_object_unref0 (_tmp14_);
					continue;
				} else {
					GFileInfo* _tmp22_;
					_tmp22_ = info;
					if (g_file_info_get_file_type (_tmp22_) == G_FILE_TYPE_DIRECTORY) {
						GFile* child = NULL;
						GFile* _tmp23_;
						GFileInfo* _tmp24_;
						const gchar* _tmp25_;
						GFile* _tmp26_;
						GFile* _tmp27_;
						GFileInfo* _tmp28_;
						G4DirCache* _tmp29_;
						GFileInfo* _tmp30_;
						_tmp23_ = dir;
						_tmp24_ = info;
						_tmp25_ = g_file_info_get_name (_tmp24_);
						_tmp26_ = g_file_get_child (_tmp23_, _tmp25_);
						child = _tmp26_;
						_tmp27_ = child;
						_tmp28_ = info;
						_tmp29_ = g4_dir_cache_new (_tmp27_, _tmp28_);
						g_queue_push_head (stack, _tmp29_);
						_tmp30_ = info;
						g4_dir_cache_add_child (cache, _tmp30_, G4_CHILD_TYPE_FOLDER);
						_g_object_unref0 (child);
					} else {
						const gchar* _tmp31_ = NULL;
						GFileInfo* _tmp32_;
						const gchar* _tmp33_;
						const gchar* ctype = NULL;
						const gchar* name = NULL;
						GFileInfo* _tmp34_;
						const gchar* _tmp35_;
						const gchar* _tmp36_;
						_tmp32_ = info;
						_tmp33_ = g_file_info_get_content_type (_tmp32_);
						_tmp31_ = _tmp33_;
						if (_tmp31_ == NULL) {
							_tmp31_ = "";
						}
						ctype = (const gchar*) _tmp31_;
						_tmp34_ = info;
						_tmp35_ = g_file_info_get_name (_tmp34_);
						name = _tmp35_;
						_tmp36_ = ctype;
						if (g4_is_music_type (_tmp36_)) {
							GDateTime* _tmp37_ = NULL;
							GFileInfo* _tmp38_;
							GDateTime* _tmp39_;
							gint64* _tmp40_ = NULL;
							gint64* _tmp43_ = NULL;
							gint64* _tmp44_;
							gint64 time = 0LL;
							gint64* _tmp47_;
							gint64 _tmp48_;
							GFile* file = NULL;
							GFile* _tmp49_;
							const gchar* _tmp50_;
							GFile* _tmp51_;
							G4Music* music = NULL;
							GFile* _tmp52_;
							gchar* _tmp53_;
							gchar* _tmp54_;
							const gchar* _tmp55_;
							G4Music* _tmp56_;
							G4Music* _tmp57_;
							G4Music* _tmp58_;
							G4Music* _tmp59_;
							GFileInfo* _tmp60_;
							_tmp38_ = info;
							_tmp39_ = g_file_info_get_modification_date_time (_tmp38_);
							_tmp37_ = _tmp39_;
							_tmp40_ = NULL;
							if (_tmp37_ != NULL) {
								gint64 _tmp41_;
								gint64* _tmp42_;
								_tmp41_ = g_date_time_to_unix ((GDateTime*) _tmp37_);
								_tmp42_ = __int64_dup0 (&_tmp41_);
								_g_free0 (_tmp40_);
								_tmp40_ = _tmp42_;
							}
							_tmp44_ = _tmp40_;
							_tmp40_ = NULL;
							_tmp43_ = _tmp44_;
							if (_tmp43_ == NULL) {
								gint64 _tmp45_;
								gint64* _tmp46_;
								_tmp45_ = (gint64) 0;
								_tmp46_ = __int64_dup0 (&_tmp45_);
								_g_free0 (_tmp43_);
								_tmp43_ = _tmp46_;
							}
							_tmp47_ = _tmp43_;
							_tmp43_ = NULL;
							_tmp48_ = (gint64) (*_tmp47_);
							_g_free0 (_tmp47_);
							time = _tmp48_;
							_tmp49_ = dir;
							_tmp50_ = name;
							_tmp51_ = g_file_get_child (_tmp49_, _tmp50_);
							file = _tmp51_;
							_tmp52_ = file;
							_tmp53_ = g_file_get_uri (_tmp52_);
							_tmp54_ = _tmp53_;
							_tmp55_ = name;
							_tmp56_ = g4_music_new (_tmp54_, _tmp55_, time);
							_tmp57_ = _tmp56_;
							_g_free0 (_tmp54_);
							music = _tmp57_;
							_tmp58_ = music;
							_tmp59_ = _g_object_ref0 (_tmp58_);
							g_ptr_array_add (musics, _tmp59_);
							_tmp60_ = info;
							g4_dir_cache_add_child (cache, _tmp60_, G4_CHILD_TYPE_MUSIC);
							_g_object_unref0 (music);
							_g_object_unref0 (file);
							_g_free0 (_tmp43_);
							_g_free0 (_tmp40_);
							_g_date_time_unref0 (_tmp37_);
						} else {
							const gchar* _tmp61_;
							_tmp61_ = ctype;
							if (g4_is_playlist_file (_tmp61_)) {
								GFile* child = NULL;
								GFile* _tmp62_;
								GFileInfo* _tmp63_;
								const gchar* _tmp64_;
								GFile* _tmp65_;
								GFile* _tmp66_;
								GFile* _tmp67_;
								GFileInfo* _tmp68_;
								_tmp62_ = dir;
								_tmp63_ = info;
								_tmp64_ = g_file_info_get_name (_tmp63_);
								_tmp65_ = g_file_get_child (_tmp62_, _tmp64_);
								child = _tmp65_;
								_tmp66_ = child;
								_tmp67_ = _g_object_ref0 (_tmp66_);
								g_ptr_array_add (playlists, _tmp67_);
								_tmp68_ = info;
								g4_dir_cache_add_child (cache, _tmp68_, G4_CHILD_TYPE_PLAYLIST);
								_g_object_unref0 (child);
							} else {
								gboolean _tmp69_ = FALSE;
								const gchar* _tmp70_;
								_tmp70_ = cover_name;
								if (_tmp70_ == NULL) {
									const gchar* _tmp71_;
									const gchar* _tmp72_;
									_tmp71_ = ctype;
									_tmp72_ = name;
									_tmp69_ = g4_is_cover_file (_tmp71_, _tmp72_);
								} else {
									_tmp69_ = FALSE;
								}
								if (_tmp69_) {
									const gchar* _tmp73_;
									gchar* _tmp74_;
									GFileInfo* _tmp75_;
									_tmp73_ = name;
									_tmp74_ = g_strdup (_tmp73_);
									_g_free0 (cover_name);
									cover_name = _tmp74_;
									_tmp75_ = info;
									g4_dir_cache_add_child (cache, _tmp75_, G4_CHILD_TYPE_COVER);
								}
							}
						}
					}
				}
				_g_object_unref0 (info);
				_g_object_unref0 (_tmp14_);
			}
			_tmp77_ = cover_name;
			_tmp76_ = _tmp77_;
			if (_tmp76_ == NULL) {
				_tmp76_ = "";
			}
			_tmp78_ = self->priv->_cover_cache;
			_tmp79_ = dir;
			g4_cover_cache_put (_tmp78_, _tmp79_, (const gchar*) _tmp76_);
			_tmp81_ = g4_music_loader_get_save_dir_pool ();
			_tmp80_ = _tmp81_;
			if (_tmp80_ != NULL) {
				G4DirCache* _tmp82_;
				_tmp82_ = _g_object_ref0 (cache);
				g_thread_pool_push ((GThreadPool*) _tmp80_, _tmp82_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (enumerator);
					_g_object_unref0 (pi);
					goto __catch0_g_error;
				}
			}
			_g_object_unref0 (enumerator);
			_g_object_unref0 (pi);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp83_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp83_ = e;
			if (_tmp83_->code != G_IO_ERROR_NOT_FOUND) {
				GFile* _tmp84_;
				gchar* _tmp85_;
				gchar* _tmp86_;
				GError* _tmp87_;
				const gchar* _tmp88_;
				_tmp84_ = dir;
				_tmp85_ = g_file_get_parse_name (_tmp84_);
				_tmp86_ = _tmp85_;
				_tmp87_ = e;
				_tmp88_ = _tmp87_->message;
				g_print ("Enumerate %s: %s\n", _tmp86_, _tmp88_);
				_g_free0 (_tmp86_);
			}
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (cover_name);
			_g_object_unref0 (dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp90_ = cover_name;
	if (_tmp90_ != NULL) {
		const gchar* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		_tmp91_ = cover_name;
		_tmp92_ = strlen ((const gchar*) _tmp91_);
		_tmp93_ = _tmp92_;
		_tmp89_ = _tmp93_ > 0;
	} else {
		_tmp89_ = FALSE;
	}
	if (_tmp89_) {
		{
			gint i = 0;
			gint _tmp94_;
			gint _tmp95_;
			_tmp94_ = vala_g_ptr_array_get_length (musics);
			_tmp95_ = _tmp94_;
			i = _tmp95_ - 1;
			{
				gboolean _tmp96_ = FALSE;
				_tmp96_ = TRUE;
				while (TRUE) {
					G4Music* music = NULL;
					gconstpointer _tmp98_;
					G4Music* _tmp99_;
					G4Music* _tmp100_;
					if (!_tmp96_) {
						gint _tmp97_;
						_tmp97_ = i;
						i = _tmp97_ - 1;
					}
					_tmp96_ = FALSE;
					if (!(i >= start)) {
						break;
					}
					_tmp98_ = g_ptr_array_index (musics, (guint) i);
					_tmp99_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((G4Music*) _tmp98_, G4_TYPE_MUSIC, G4Music));
					music = _tmp99_;
					_tmp100_ = music;
					_tmp100_->has_cover = TRUE;
					_g_object_unref0 (music);
				}
			}
		}
	}
	_g_free0 (cover_name);
	_g_object_unref0 (dir);
}

static void
g4_music_loader_add_music_file (G4MusicLoader* self,
                                GFile* file,
                                GPtrArray* musics)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (musics != NULL);
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		const gchar* name = NULL;
		GDateTime* _tmp4_ = NULL;
		GDateTime* _tmp5_;
		gint64* _tmp6_ = NULL;
		gint64* _tmp9_ = NULL;
		gint64* _tmp10_;
		gint64 time = 0LL;
		gint64* _tmp13_;
		gint64 _tmp14_;
		G4Music* music = NULL;
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		G4Music* _tmp18_;
		G4Music* _tmp19_;
		G4Music* _tmp20_;
		G4Music* _tmp21_;
		_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = g_file_get_basename (file);
		_tmp1_ = _tmp2_;
		if (_tmp1_ == NULL) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("");
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp3_;
		}
		name = (const gchar*) _tmp1_;
		_tmp5_ = g_file_info_get_modification_date_time (info);
		_tmp4_ = _tmp5_;
		_tmp6_ = NULL;
		if (_tmp4_ != NULL) {
			gint64 _tmp7_;
			gint64* _tmp8_;
			_tmp7_ = g_date_time_to_unix ((GDateTime*) _tmp4_);
			_tmp8_ = __int64_dup0 (&_tmp7_);
			_g_free0 (_tmp6_);
			_tmp6_ = _tmp8_;
		}
		_tmp10_ = _tmp6_;
		_tmp6_ = NULL;
		_tmp9_ = _tmp10_;
		if (_tmp9_ == NULL) {
			gint64 _tmp11_;
			gint64* _tmp12_;
			_tmp11_ = (gint64) 0;
			_tmp12_ = __int64_dup0 (&_tmp11_);
			_g_free0 (_tmp9_);
			_tmp9_ = _tmp12_;
		}
		_tmp13_ = _tmp9_;
		_tmp9_ = NULL;
		_tmp14_ = (gint64) (*_tmp13_);
		_g_free0 (_tmp13_);
		time = _tmp14_;
		_tmp15_ = g_file_get_uri (file);
		_tmp16_ = _tmp15_;
		_tmp17_ = name;
		_tmp18_ = g4_music_new (_tmp16_, _tmp17_, time);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp16_);
		music = _tmp19_;
		_tmp20_ = music;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		g_ptr_array_add (musics, _tmp21_);
		_g_object_unref0 (music);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp6_);
		_g_date_time_unref0 (_tmp4_);
		_g_free0 (_tmp1_);
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = e;
		if (_tmp22_->code != G_IO_ERROR_NOT_FOUND) {
			gchar* _tmp23_;
			gchar* _tmp24_;
			GError* _tmp25_;
			const gchar* _tmp26_;
			_tmp23_ = g_file_get_parse_name (file);
			_tmp24_ = _tmp23_;
			_tmp25_ = e;
			_tmp26_ = _tmp25_->message;
			g_print ("Query %s: %s\n", _tmp24_, _tmp26_);
			_g_free0 (_tmp24_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
g_ptr_array_set (GPtrArray* self,
                 guint index,
                 gpointer data)
{
	gpointer _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = data;
	data = NULL;
	g_ptr_array_add (self, _tmp0_);
	g_ptr_array_remove_index_fast (self, index);
}

static void
g4_music_loader_add_musics_to_library (G4MusicLoader* self,
                                       GPtrArray* musics,
                                       GPtrArray* playlists,
                                       gboolean ignore_exists)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (musics != NULL);
	g_return_if_fail (playlists != NULL);
	{
		gint i = 0;
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = vala_g_ptr_array_get_length (musics);
		_tmp1_ = _tmp0_;
		i = _tmp1_ - 1;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				G4Music* music = NULL;
				gconstpointer _tmp4_;
				G4Music* _tmp5_;
				gboolean _tmp6_ = FALSE;
				G4MusicLibrary* _tmp7_;
				G4Music* _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ - 1;
				}
				_tmp2_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp4_ = g_ptr_array_index (musics, (guint) i);
				_tmp5_ = _g_object_ref0 ((G4Music*) _tmp4_);
				music = _tmp5_;
				_tmp7_ = self->priv->_library;
				_tmp8_ = music;
				if (!g4_music_library_add_music (_tmp7_, _tmp8_)) {
					_tmp6_ = ignore_exists;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					g_ptr_array_remove_index_fast (musics, (guint) i);
				}
				_g_object_unref0 (music);
			}
		}
	}
	{
		GPtrArray* playlist_collection = NULL;
		guint playlist_index = 0U;
		playlist_collection = playlists;
		for (playlist_index = 0; playlist_index < playlist_collection->len; playlist_index = playlist_index + 1) {
			G4Playlist* _tmp9_;
			G4Playlist* playlist = NULL;
			_tmp9_ = _g_object_ref0 ((G4Playlist*) g_ptr_array_index (playlist_collection, playlist_index));
			playlist = _tmp9_;
			{
				GPtrArray* items = NULL;
				G4Playlist* _tmp10_;
				GPtrArray* _tmp11_;
				G4Playlist* _tmp29_;
				G4MusicLibrary* _tmp30_;
				G4Playlist* _tmp31_;
				G4Playlist* _tmp32_;
				G4Playlist* _tmp33_;
				_tmp10_ = playlist;
				_tmp11_ = _tmp10_->items;
				items = _tmp11_;
				{
					gint i = 0;
					GPtrArray* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = items;
					_tmp13_ = vala_g_ptr_array_get_length (_tmp12_);
					_tmp14_ = _tmp13_;
					i = _tmp14_ - 1;
					{
						gboolean _tmp15_ = FALSE;
						_tmp15_ = TRUE;
						while (TRUE) {
							G4Music* music = NULL;
							GPtrArray* _tmp17_;
							gconstpointer _tmp18_;
							G4Music* _tmp19_;
							G4Music* _tmp20_ = NULL;
							G4TagCache* _tmp21_;
							G4Music* _tmp22_;
							const gchar* _tmp23_;
							G4Music* _tmp24_;
							GPtrArray* _tmp27_;
							G4Music* _tmp28_;
							if (!_tmp15_) {
								gint _tmp16_;
								_tmp16_ = i;
								i = _tmp16_ - 1;
							}
							_tmp15_ = FALSE;
							if (!(i >= 0)) {
								break;
							}
							_tmp17_ = items;
							_tmp18_ = g_ptr_array_index (_tmp17_, (guint) i);
							_tmp19_ = _g_object_ref0 ((G4Music*) _tmp18_);
							music = _tmp19_;
							_tmp21_ = self->priv->_tag_cache;
							_tmp22_ = music;
							_tmp23_ = _tmp22_->uri;
							_tmp24_ = g4_tag_cache_get (_tmp21_, _tmp23_);
							_tmp20_ = _tmp24_;
							if (_tmp20_ == NULL) {
								G4Music* _tmp25_;
								G4Music* _tmp26_;
								_tmp25_ = music;
								_tmp26_ = _g_object_ref0 (_tmp25_);
								_g_object_unref0 (_tmp20_);
								_tmp20_ = _tmp26_;
							}
							_tmp27_ = items;
							_tmp28_ = _tmp20_;
							_tmp20_ = NULL;
							g_ptr_array_set (_tmp27_, (guint) i, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, G4_TYPE_MUSIC, G4Music));
							_g_object_unref0 (_tmp20_);
							_g_object_unref0 (music);
						}
					}
				}
				_tmp29_ = playlist;
				g4_playlist_set_cover_uri (_tmp29_);
				_tmp30_ = self->priv->_library;
				_tmp31_ = playlist;
				_tmp32_ = g4_music_library_add_playlist (_tmp30_, _tmp31_);
				_tmp33_ = _tmp32_;
				_g_object_unref0 (_tmp33_);
				_g_object_unref0 (playlist);
			}
		}
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static Block63Data*
block63_data_ref (Block63Data* _data63_)
{
	g_atomic_int_inc (&_data63_->_ref_count_);
	return _data63_;
}

static void
block63_data_unref (void * _userdata_)
{
	Block63Data* _data63_;
	_data63_ = (Block63Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data63_->_ref_count_)) {
		G4MusicLoader* self;
		self = _data63_->self;
		_g_object_unref0 (_data63_->playlist);
		_g_object_unref0 (self);
		g_slice_free (Block63Data, _data63_);
	}
}

static void
______lambda29_ (Block63Data* _data63_,
                 const gchar* uri)
{
	G4MusicLoader* self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	G4Playlist* _tmp2_;
	GPtrArray* _tmp3_;
	self = _data63_->self;
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_file_new_for_uri (uri);
	_tmp1_ = _tmp0_;
	_tmp2_ = _data63_->playlist;
	_tmp3_ = _tmp2_->items;
	g4_music_loader_add_music_file (self, _tmp1_, _tmp3_);
	_g_object_unref0 (_tmp1_);
}

static void
_______lambda29__gfunc (gconstpointer data,
                        gpointer self)
{
	______lambda29_ (self, (const gchar*) data);
}

static G4Music*
_______lambda30_ (G4MusicLoader* self,
                  G4Music* src)
{
	G4Music* _tmp0_;
	G4Music* result;
	g_return_val_if_fail (src != NULL, NULL);
	_tmp0_ = _g_object_ref0 (src);
	result = _tmp0_;
	return result;
}

static gpointer
________lambda30__gcopy_func (gconstpointer src,
                              gpointer self)
{
	gpointer result;
	result = _______lambda30_ ((G4MusicLoader*) self, (G4Music*) src);
	return result;
}

static void
g4_music_loader_load_playlists (G4MusicLoader* self,
                                GPtrArray* musics,
                                GPtrArray* list_files,
                                GPtrArray* playlists,
                                gboolean merge_lists)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (musics != NULL);
	g_return_if_fail (list_files != NULL);
	g_return_if_fail (playlists != NULL);
	{
		GPtrArray* file_collection = NULL;
		guint file_index = 0U;
		file_collection = list_files;
		for (file_index = 0; file_index < file_collection->len; file_index = file_index + 1) {
			GFile* _tmp0_;
			GFile* file = NULL;
			_tmp0_ = _g_object_ref0 ((GFile*) g_ptr_array_index (file_collection, file_index));
			file = _tmp0_;
			{
				GFile* _tmp1_;
				_tmp1_ = file;
				if (g_file_is_native (_tmp1_)) {
					GPtrArray* uris = NULL;
					GPtrArray* _tmp2_;
					gchar* name = NULL;
					GFile* _tmp3_;
					GPtrArray* _tmp4_;
					gchar* _tmp5_;
					gboolean _tmp6_ = FALSE;
					const gchar* _tmp7_;
					_tmp2_ = g_ptr_array_new_full ((guint) 1024, _g_free0_);
					uris = _tmp2_;
					_tmp3_ = file;
					_tmp4_ = uris;
					_tmp5_ = g4_load_playlist_file (_tmp3_, _tmp4_);
					name = _tmp5_;
					_tmp7_ = name;
					if (_tmp7_ != NULL) {
						GPtrArray* _tmp8_;
						gint _tmp9_;
						gint _tmp10_;
						_tmp8_ = uris;
						_tmp9_ = vala_g_ptr_array_get_length (_tmp8_);
						_tmp10_ = _tmp9_;
						_tmp6_ = _tmp10_ > 0;
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						Block63Data* _data63_;
						const gchar* _tmp11_;
						GFile* _tmp12_;
						gchar* _tmp13_;
						gchar* _tmp14_;
						G4Playlist* _tmp15_;
						G4Playlist* _tmp16_;
						GPtrArray* _tmp17_;
						G4Playlist* _tmp18_;
						G4Playlist* _tmp19_;
						_data63_ = g_slice_new0 (Block63Data);
						_data63_->_ref_count_ = 1;
						_data63_->self = g_object_ref (self);
						_tmp11_ = name;
						_tmp12_ = file;
						_tmp13_ = g_file_get_uri (_tmp12_);
						_tmp14_ = _tmp13_;
						_tmp15_ = g4_playlist_new ((const gchar*) _tmp11_, _tmp14_);
						_tmp16_ = _tmp15_;
						_g_free0 (_tmp14_);
						_data63_->playlist = _tmp16_;
						_tmp17_ = uris;
						g_ptr_array_foreach (_tmp17_, _______lambda29__gfunc, _data63_);
						_tmp18_ = _data63_->playlist;
						_tmp19_ = _g_object_ref0 (_tmp18_);
						g_ptr_array_add (playlists, _tmp19_);
						if (merge_lists) {
							G4Playlist* _tmp20_;
							GPtrArray* _tmp21_;
							_tmp20_ = _data63_->playlist;
							_tmp21_ = _tmp20_->items;
							g_ptr_array_extend (musics, _tmp21_, ________lambda30__gcopy_func, self);
						}
						block63_data_unref (_data63_);
						_data63_ = NULL;
					}
					_g_free0 (name);
					_g_ptr_array_unref0 (uris);
				}
				_g_object_unref0 (file);
			}
		}
	}
}

static Block64Data*
block64_data_ref (Block64Data* _data64_)
{
	g_atomic_int_inc (&_data64_->_ref_count_);
	return _data64_;
}

static void
block64_data_unref (void * _userdata_)
{
	Block64Data* _data64_;
	_data64_ = (Block64Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data64_->_ref_count_)) {
		G4MusicLoader* self;
		self = _data64_->self;
		_g_async_queue_unref0 (_data64_->queue);
		_g_object_unref0 (self);
		g_slice_free (Block64Data, _data64_);
	}
}

static void
___lambda31_ (Block64Data* _data64_)
{
	G4MusicLoader* self;
	G4Music* music = NULL;
	self = _data64_->self;
	while (TRUE) {
		GAsyncQueue* _tmp0_;
		gpointer _tmp1_;
		G4Music* _tmp2_;
		G4Music* _tmp3_ = NULL;
		G4Music* _tmp4_;
		G4Progress* _tmp5_;
		_tmp0_ = _data64_->queue;
		_tmp1_ = g_async_queue_try_pop (_tmp0_);
		_g_object_unref0 (music);
		music = (G4Music*) _tmp1_;
		_tmp2_ = music;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp4_ = music;
		_tmp3_ = _tmp4_;
		if (_tmp3_ != NULL) {
			g4_music_parse_tags (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G4_TYPE_MUSIC, G4Music));
		}
		_tmp5_ = self->priv->_progress;
		g4_progress_step (_tmp5_);
	}
	_g_object_unref0 (music);
}

static gpointer
____lambda31__g4_music_loader_thread_func (gpointer self)
{
	gpointer result;
	___lambda31_ (self);
	result = NULL;
	return result;
}

static void
g4_music_loader_load_tags_in_threads (G4MusicLoader* self,
                                      GPtrArray* musics)
{
	Block64Data* _data64_;
	GAsyncQueue* _tmp0_;
	G4TagCache* _tmp1_;
	gint queue_count = 0;
	GAsyncQueue* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (musics != NULL);
	_data64_ = g_slice_new0 (Block64Data);
	_data64_->_ref_count_ = 1;
	_data64_->self = g_object_ref (self);
	_tmp0_ = g_async_queue_new_full (_g_object_unref0_);
	_data64_->queue = _tmp0_;
	_tmp1_ = self->priv->_tag_cache;
	g4_tag_cache_wait_loading (_tmp1_);
	{
		gint i = 0;
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = vala_g_ptr_array_get_length (musics);
		_tmp3_ = _tmp2_;
		i = _tmp3_ - 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				G4Music* music = NULL;
				gconstpointer _tmp6_;
				G4Music* cached_music = NULL;
				G4TagCache* _tmp7_;
				G4Music* _tmp8_;
				const gchar* _tmp9_;
				G4Music* _tmp10_;
				gboolean _tmp11_ = FALSE;
				G4Music* _tmp12_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp6_ = g_ptr_array_index (musics, (guint) i);
				music = (G4Music*) _tmp6_;
				_tmp7_ = self->priv->_tag_cache;
				_tmp8_ = music;
				_tmp9_ = _tmp8_->uri;
				_tmp10_ = g4_tag_cache_get (_tmp7_, _tmp9_);
				cached_music = _tmp10_;
				_tmp12_ = cached_music;
				if (_tmp12_ != NULL) {
					G4Music* _tmp13_;
					G4Music* _tmp14_;
					_tmp13_ = cached_music;
					_tmp14_ = music;
					_tmp11_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, G4_TYPE_MUSIC, G4Music)->modified_time == _tmp14_->modified_time;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					G4Music* _tmp15_;
					G4Music* _tmp16_;
					_tmp15_ = cached_music;
					_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, G4_TYPE_MUSIC, G4Music));
					g_ptr_array_set (musics, (guint) i, _tmp16_);
				} else {
					G4TagCache* _tmp17_;
					G4Music* _tmp18_;
					GAsyncQueue* _tmp19_;
					G4Music* _tmp20_;
					G4Music* _tmp21_;
					_tmp17_ = self->priv->_tag_cache;
					_tmp18_ = music;
					g4_tag_cache_add (_tmp17_, _tmp18_);
					_tmp19_ = _data64_->queue;
					_tmp20_ = music;
					_tmp21_ = _g_object_ref0 (_tmp20_);
					g_async_queue_push (_tmp19_, _tmp21_);
				}
				_g_object_unref0 (cached_music);
			}
		}
	}
	_tmp22_ = _data64_->queue;
	queue_count = g_async_queue_length (_tmp22_);
	if (queue_count > 0) {
		G4Progress* _tmp23_;
		guint num_tasks = 0U;
		_tmp23_ = self->priv->_progress;
		g4_progress_set_total (_tmp23_, queue_count);
		num_tasks = MIN ((guint) queue_count, g_get_num_processors ());
		g4_music_loader_run_in_threads (G_TYPE_NONE, NULL, NULL, ____lambda31__g4_music_loader_thread_func, block64_data_ref (_data64_), block64_data_unref, num_tasks);
	}
	block64_data_unref (_data64_);
	_data64_ = NULL;
}

static void
g4_music_loader_on_file_added_data_free (gpointer _data)
{
	G4MusicLoaderOnFileAddedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->self);
	g_slice_free (G4MusicLoaderOnFileAddedData, _data_);
}

void
g4_music_loader_on_file_added (G4MusicLoader* self,
                               GFile* file,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	G4MusicLoaderOnFileAddedData* _data_;
	G4MusicLoader* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (G4MusicLoaderOnFileAddedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, g4_music_loader_on_file_added_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	g4_music_loader_on_file_added_co (_data_);
}

void
g4_music_loader_on_file_added_finish (G4MusicLoader* self,
                                      GAsyncResult* _res_)
{
	G4MusicLoaderOnFileAddedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
g4_music_loader_on_file_added_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	G4MusicLoaderOnFileAddedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	g4_music_loader_on_file_added_co (_data_);
}

static gboolean
g4_music_loader_on_file_added_co (G4MusicLoaderOnFileAddedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->file, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, g4_music_loader_on_file_added_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = g_file_query_info_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
		_data_->info = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (g_file_info_get_is_hidden (_data_->info)) {
			_g_object_unref0 (_data_->info);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = g_ptr_array_new_full ((guint) 1024, _g_object_unref0_);
	_data_->arr = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->_library;
	_data_->_tmp3_ = g4_music_library_get_playlist_count (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->n_playlists = (gint) _data_->_tmp4_;
	_data_->_tmp5_ = _g_object_ref0 (_data_->file);
	_data_->_tmp6_ = g_new0 (GFile*, 1 + 1);
	_data_->_tmp6_[0] = _data_->_tmp5_;
	_data_->_tmp7_ = _data_->arr;
	_data_->_state_ = 2;
	g4_music_loader_load_files_async (_data_->self, _data_->_tmp6_, (gint) 1, _data_->_tmp7_, TRUE, FALSE, (guint) -1, g4_music_loader_on_file_added_ready, _data_);
	return FALSE;
	_state_2:
	g4_music_loader_load_files_finish (_data_->self, _data_->_res_);
	_data_->_tmp8_ = _data_->self->priv->_library;
	_data_->_tmp9_ = g4_music_library_get_playlist_count (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->n_playlists -= (gint) _data_->_tmp10_;
	_data_->_tmp12_ = _data_->arr;
	_data_->_tmp13_ = vala_g_ptr_array_get_length (_data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	if (_data_->_tmp14_ > 0) {
		_data_->_tmp11_ = TRUE;
	} else {
		_data_->_tmp11_ = _data_->n_playlists != 0;
	}
	if (_data_->_tmp11_) {
		_data_->_tmp15_ = _data_->arr;
		g_signal_emit (_data_->self, g4_music_loader_signals[G4_MUSIC_LOADER_MUSIC_FOUND_SIGNAL], 0, _data_->_tmp15_);
	}
	_g_ptr_array_unref0 (_data_->arr);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
g4_music_loader_on_file_removed_data_free (gpointer _data)
{
	G4MusicLoaderOnFileRemovedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (G4MusicLoaderOnFileRemovedData, _data_);
}

void
g4_music_loader_on_file_removed (G4MusicLoader* self,
                                 GFile* file,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	G4MusicLoaderOnFileRemovedData* _data_;
	G4MusicLoader* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (G4MusicLoaderOnFileRemovedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, g4_music_loader_on_file_removed_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	g4_music_loader_on_file_removed_co (_data_);
}

void
g4_music_loader_on_file_removed_finish (G4MusicLoader* self,
                                        GAsyncResult* _res_)
{
	G4MusicLoaderOnFileRemovedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block65Data*
block65_data_ref (Block65Data* _data65_)
{
	g_atomic_int_inc (&_data65_->_ref_count_);
	return _data65_;
}

static void
block65_data_unref (void * _userdata_)
{
	Block65Data* _data65_;
	_data65_ = (Block65Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data65_->_ref_count_)) {
		G4MusicLoader* self;
		self = _data65_->self;
		_g_hash_table_unref0 (_data65_->removed);
		_g_object_unref0 (_data65_->file);
		_g_object_unref0 (self);
		g_slice_free (Block65Data, _data65_);
	}
}

static void
__lambda35_ (Block65Data* _data65_)
{
	G4MusicLoader* self;
	gchar* uri = NULL;
	gchar* _tmp0_;
	G4Music* music = NULL;
	G4TagCache* _tmp1_;
	const gchar* _tmp2_;
	G4Music* _tmp3_;
	G4Music* _tmp4_;
	self = _data65_->self;
	_tmp0_ = g_file_get_uri (_data65_->file);
	uri = _tmp0_;
	_tmp1_ = self->priv->_tag_cache;
	_tmp2_ = uri;
	_tmp3_ = g4_tag_cache_remove (_tmp1_, _tmp2_);
	music = _tmp3_;
	_tmp4_ = music;
	if (_tmp4_ != NULL) {
		G4MusicLibrary* _tmp5_;
		G4Music* _tmp6_;
		GHashTable* _tmp7_;
		G4Music* _tmp8_;
		G4Music* _tmp9_;
		_tmp5_ = self->priv->_library;
		_tmp6_ = music;
		g4_music_library_remove_music (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, G4_TYPE_MUSIC, G4Music));
		_tmp7_ = _data65_->removed;
		_tmp8_ = music;
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, G4_TYPE_MUSIC, G4Music));
		g_hash_table_add (_tmp7_, _tmp9_);
	} else {
		G4MusicLibrary* _tmp10_;
		const gchar* _tmp11_;
		GHashTable* _tmp12_;
		G4DirCache* _tmp13_;
		G4DirCache* _tmp14_;
		_tmp10_ = self->priv->_library;
		_tmp11_ = uri;
		_tmp12_ = _data65_->removed;
		_data65_->_result_ = g4_music_library_remove_uri (_tmp10_, _tmp11_, _tmp12_);
		_tmp13_ = g4_dir_cache_new (_data65_->file, NULL);
		_tmp14_ = _tmp13_;
		g4_dir_cache_delete (_tmp14_);
		_g_object_unref0 (_tmp14_);
	}
	_g_object_unref0 (music);
	_g_free0 (uri);
}

static void
___lambda35__g4_void_func (gpointer self)
{
	__lambda35_ (self);
}

static void
g4_music_loader_on_file_removed_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	G4MusicLoaderOnFileRemovedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	g4_music_loader_on_file_removed_co (_data_);
}

static gboolean
g4_music_loader_on_file_removed_co (G4MusicLoaderOnFileRemovedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data65_ = g_slice_new0 (Block65Data);
	_data_->_data65_->_ref_count_ = 1;
	_data_->_data65_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data65_->file);
	_data_->_data65_->file = _data_->file;
	_data_->_data65_->_async_data_ = _data_;
	_data_->_data65_->_result_ = FALSE;
	_data_->_tmp0_ = g_direct_hash;
	_data_->_tmp1_ = g_direct_equal;
	_data_->_tmp2_ = g_hash_table_new_full (_data_->_tmp0_, _data_->_tmp1_, NULL, _g_object_unref0_);
	_data_->_data65_->removed = _data_->_tmp2_;
	_data_->_state_ = 1;
	g4_run_void_async (___lambda35__g4_void_func, _data_->_data65_, g4_music_loader_on_file_removed_ready, _data_);
	return FALSE;
	_state_1:
	g4_run_void_finish (_data_->_res_);
	_data_->_tmp4_ = _data_->_data65_->removed;
	_data_->_tmp5_ = g_hash_table_size (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	if (_data_->_tmp6_ > ((guint) 0)) {
		_data_->_tmp3_ = TRUE;
	} else {
		_data_->_tmp3_ = _data_->_data65_->_result_;
	}
	if (_data_->_tmp3_) {
		_data_->_tmp7_ = _data_->_data65_->removed;
		g_signal_emit (_data_->self, g4_music_loader_signals[G4_MUSIC_LOADER_MUSIC_LOST_SIGNAL], 0, _data_->_tmp7_);
	}
	block65_data_unref (_data_->_data65_);
	_data_->_data65_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gpointer
_g_thread_ref0 (gpointer self)
{
	return self ? g_thread_ref (self) : NULL;
}

static void
g4_music_loader_run_in_threads (GType g_type,
                                GBoxedCopyFunc g_dup_func,
                                GDestroyNotify g_destroy_func,
                                G4MusicLoaderThreadFunc func,
                                gpointer func_target,
                                GDestroyNotify func_target_destroy_notify,
                                guint num_tasks)
{
	GThread** threads = NULL;
	GThread** _tmp0_;
	gint threads_length1;
	gint _threads_size_;
	GThread** _tmp5_;
	gint _tmp5__length1;
	_tmp0_ = g_new0 (GThread*, num_tasks + 1);
	threads = _tmp0_;
	threads_length1 = num_tasks;
	_threads_size_ = threads_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint index = 0;
				GThread** _tmp3_;
				gint _tmp3__length1;
				GThread* _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((guint) i) < num_tasks)) {
					break;
				}
				index = i;
				_tmp3_ = threads;
				_tmp3__length1 = threads_length1;
				_tmp4_ = g_thread_new (NULL, func, func_target);
				_g_thread_unref0 (_tmp3_[index]);
				_tmp3_[index] = _tmp4_;
			}
		}
	}
	_tmp5_ = threads;
	_tmp5__length1 = threads_length1;
	{
		GThread** thread_collection = NULL;
		gint thread_collection_length1 = 0;
		gint _thread_collection_size_ = 0;
		gint thread_it = 0;
		thread_collection = _tmp5_;
		thread_collection_length1 = _tmp5__length1;
		for (thread_it = 0; thread_it < thread_collection_length1; thread_it = thread_it + 1) {
			GThread* _tmp6_;
			GThread* thread = NULL;
			_tmp6_ = _g_thread_ref0 (thread_collection[thread_it]);
			thread = _tmp6_;
			{
				GThread* _tmp7_;
				gpointer _tmp8_;
				gpointer _tmp9_;
				_tmp7_ = thread;
				thread = NULL;
				_tmp8_ = g_thread_join (_tmp7_);
				_tmp9_ = _tmp8_;
				((_tmp9_ == NULL) || (g_destroy_func == NULL)) ? NULL : (_tmp9_ = (g_destroy_func (_tmp9_), NULL));
				_g_thread_unref0 (thread);
			}
		}
	}
	threads = (_vala_array_free (threads, threads_length1, (GDestroyNotify) g_thread_unref), NULL);
	(func_target_destroy_notify == NULL) ? NULL : (func_target_destroy_notify (func_target), NULL);
	func = NULL;
	func_target = NULL;
	func_target_destroy_notify = NULL;
}

G4CoverCache*
g4_music_loader_get_cover_cache (G4MusicLoader* self)
{
	G4CoverCache* result;
	G4CoverCache* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cover_cache;
	result = _tmp0_;
	return result;
}

gboolean
g4_music_loader_get_monitor_changes (G4MusicLoader* self)
{
	gboolean result;
	G4DirMonitor* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_dir_monitor;
	_tmp1_ = g4_dir_monitor_get_enabled (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
g4_music_loader_set_monitor_changes (G4MusicLoader* self,
                                     gboolean value)
{
	G4DirMonitor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_dir_monitor;
	g4_dir_monitor_set_enabled (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, g4_music_loader_properties[G4_MUSIC_LOADER_MONITOR_CHANGES_PROPERTY]);
}

gdouble
g4_music_loader_get_loading_progress (G4MusicLoader* self)
{
	gdouble result;
	G4Progress* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_progress;
	_tmp1_ = g4_progress_get_fraction (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

G4MusicLibrary*
g4_music_loader_get_library (G4MusicLoader* self)
{
	G4MusicLibrary* result;
	G4MusicLibrary* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_library;
	result = _tmp0_;
	return result;
}

static void
g4_music_loader_class_init (G4MusicLoaderClass * klass,
                            gpointer klass_data)
{
	g4_music_loader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &G4MusicLoader_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_g4_music_loader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_g4_music_loader_set_property;
	G_OBJECT_CLASS (klass)->finalize = g4_music_loader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_MUSIC_LOADER_COVER_CACHE_PROPERTY, g4_music_loader_properties[G4_MUSIC_LOADER_COVER_CACHE_PROPERTY] = g_param_spec_object ("cover-cache", "cover-cache", "cover-cache", G4_TYPE_COVER_CACHE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_MUSIC_LOADER_MONITOR_CHANGES_PROPERTY, g4_music_loader_properties[G4_MUSIC_LOADER_MONITOR_CHANGES_PROPERTY] = g_param_spec_boolean ("monitor-changes", "monitor-changes", "monitor-changes", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_MUSIC_LOADER_LOADING_PROGRESS_PROPERTY, g4_music_loader_properties[G4_MUSIC_LOADER_LOADING_PROGRESS_PROPERTY] = g_param_spec_double ("loading-progress", "loading-progress", "loading-progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_MUSIC_LOADER_LIBRARY_PROPERTY, g4_music_loader_properties[G4_MUSIC_LOADER_LIBRARY_PROPERTY] = g_param_spec_object ("library", "library", "library", G4_TYPE_MUSIC_LIBRARY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g4_music_loader_signals[G4_MUSIC_LOADER_LOADING_CHANGED_SIGNAL] = g_signal_new ("loading-changed", G4_TYPE_MUSIC_LOADER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	g4_music_loader_signals[G4_MUSIC_LOADER_MUSIC_FOUND_SIGNAL] = g_signal_new ("music-found", G4_TYPE_MUSIC_LOADER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_PTR_ARRAY);
	g4_music_loader_signals[G4_MUSIC_LOADER_MUSIC_LOST_SIGNAL] = g_signal_new ("music-lost", G4_TYPE_MUSIC_LOADER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_HASH_TABLE);
}

static void
g4_music_loader_instance_init (G4MusicLoader * self,
                               gpointer klass)
{
	G4CoverCache* _tmp0_;
	G4DirMonitor* _tmp1_;
	G4MusicLibrary* _tmp2_;
	G4Progress* _tmp3_;
	G4TagCache* _tmp4_;
	self->priv = g4_music_loader_get_instance_private (self);
	_tmp0_ = g4_cover_cache_new ();
	self->priv->_cover_cache = _tmp0_;
	_tmp1_ = g4_dir_monitor_new ();
	self->priv->_dir_monitor = _tmp1_;
	_tmp2_ = g4_music_library_new ();
	self->priv->_library = _tmp2_;
	_tmp3_ = g4_progress_new (0);
	self->priv->_progress = _tmp3_;
	_tmp4_ = g4_tag_cache_new ("tag-cache");
	self->priv->_tag_cache = _tmp4_;
}

static void
g4_music_loader_finalize (GObject * obj)
{
	G4MusicLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_TYPE_MUSIC_LOADER, G4MusicLoader);
	_g_object_unref0 (self->priv->_cover_cache);
	_g_object_unref0 (self->priv->_dir_monitor);
	_g_object_unref0 (self->priv->_library);
	_g4_progress_unref0 (self->priv->_progress);
	_g4_tag_cache_unref0 (self->priv->_tag_cache);
	G_OBJECT_CLASS (g4_music_loader_parent_class)->finalize (obj);
}

static GType
g4_music_loader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (G4MusicLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_music_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (G4MusicLoader), 0, (GInstanceInitFunc) g4_music_loader_instance_init, NULL };
	GType g4_music_loader_type_id;
	g4_music_loader_type_id = g_type_register_static (G_TYPE_OBJECT, "G4MusicLoader", &g_define_type_info, 0);
	G4MusicLoader_private_offset = g_type_add_instance_private (g4_music_loader_type_id, sizeof (G4MusicLoaderPrivate));
	return g4_music_loader_type_id;
}

GType
g4_music_loader_get_type (void)
{
	static volatile gsize g4_music_loader_type_id__once = 0;
	if (g_once_init_enter (&g4_music_loader_type_id__once)) {
		GType g4_music_loader_type_id;
		g4_music_loader_type_id = g4_music_loader_get_type_once ();
		g_once_init_leave (&g4_music_loader_type_id__once, g4_music_loader_type_id);
	}
	return g4_music_loader_type_id__once;
}

static void
_vala_g4_music_loader_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	G4MusicLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_MUSIC_LOADER, G4MusicLoader);
	switch (property_id) {
		case G4_MUSIC_LOADER_COVER_CACHE_PROPERTY:
		g_value_set_object (value, g4_music_loader_get_cover_cache (self));
		break;
		case G4_MUSIC_LOADER_MONITOR_CHANGES_PROPERTY:
		g_value_set_boolean (value, g4_music_loader_get_monitor_changes (self));
		break;
		case G4_MUSIC_LOADER_LOADING_PROGRESS_PROPERTY:
		g_value_set_double (value, g4_music_loader_get_loading_progress (self));
		break;
		case G4_MUSIC_LOADER_LIBRARY_PROPERTY:
		g_value_set_object (value, g4_music_loader_get_library (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_g4_music_loader_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	G4MusicLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_MUSIC_LOADER, G4MusicLoader);
	switch (property_id) {
		case G4_MUSIC_LOADER_MONITOR_CHANGES_PROPERTY:
		g4_music_loader_set_monitor_changes (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

