/* play-bar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from play-bar.vala, do not modify */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gst/gst.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <adwaita.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#define G4_ACTION_APP "app."
#define G4_ACTION_PREV "prev"
#define G4_ACTION_PLAY_PAUSE "play-pause"
#define G4_ACTION_NEXT "next"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define G4_TYPE_PLAY_BAR (g4_play_bar_get_type ())
#define G4_PLAY_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_PLAY_BAR, G4PlayBar))
#define G4_PLAY_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_PLAY_BAR, G4PlayBarClass))
#define G4_IS_PLAY_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_PLAY_BAR))
#define G4_IS_PLAY_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_PLAY_BAR))
#define G4_PLAY_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_PLAY_BAR, G4PlayBarClass))

typedef struct _G4PlayBar G4PlayBar;
typedef struct _G4PlayBarClass G4PlayBarClass;
typedef struct _G4PlayBarPrivate G4PlayBarPrivate;

#define G4_TYPE_PEAK_BAR (g4_peak_bar_get_type ())
#define G4_PEAK_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_PEAK_BAR, G4PeakBar))
#define G4_PEAK_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_PEAK_BAR, G4PeakBarClass))
#define G4_IS_PEAK_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_PEAK_BAR))
#define G4_IS_PEAK_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_PEAK_BAR))
#define G4_PEAK_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_PEAK_BAR, G4PeakBarClass))

typedef struct _G4PeakBar G4PeakBar;
typedef struct _G4PeakBarClass G4PeakBarClass;

#define G4_TYPE_VOLUME_BUTTON (g4_volume_button_get_type ())
#define G4_VOLUME_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_VOLUME_BUTTON, G4VolumeButton))
#define G4_VOLUME_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_VOLUME_BUTTON, G4VolumeButtonClass))
#define G4_IS_VOLUME_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_VOLUME_BUTTON))
#define G4_IS_VOLUME_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_VOLUME_BUTTON))
#define G4_VOLUME_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_VOLUME_BUTTON, G4VolumeButtonClass))

typedef struct _G4VolumeButton G4VolumeButton;
typedef struct _G4VolumeButtonClass G4VolumeButtonClass;
enum  {
	G4_PLAY_BAR_0_PROPERTY,
	G4_PLAY_BAR_PEAK_PROPERTY,
	G4_PLAY_BAR_POSITION_PROPERTY,
	G4_PLAY_BAR_REMAIN_PROGRESS_PROPERTY,
	G4_PLAY_BAR_NUM_PROPERTIES
};
static GParamSpec* g4_play_bar_properties[G4_PLAY_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define G4_TYPE_GST_PLAYER (g4_gst_player_get_type ())
#define G4_GST_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_GST_PLAYER, G4GstPlayer))
#define G4_GST_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_GST_PLAYER, G4GstPlayerClass))
#define G4_IS_GST_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_GST_PLAYER))
#define G4_IS_GST_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_GST_PLAYER))
#define G4_GST_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_GST_PLAYER, G4GstPlayerClass))

typedef struct _G4GstPlayer G4GstPlayer;
typedef struct _G4GstPlayerClass G4GstPlayerClass;
typedef struct _Block29Data Block29Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define G4_TYPE_APPLICATION (g4_application_get_type ())
#define G4_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_APPLICATION, G4Application))
#define G4_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_APPLICATION, G4ApplicationClass))
#define G4_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_APPLICATION))
#define G4_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_APPLICATION))
#define G4_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_APPLICATION, G4ApplicationClass))

typedef struct _G4Application G4Application;
typedef struct _G4ApplicationClass G4ApplicationClass;
typedef struct _Block30Data Block30Data;
enum  {
	G4_PLAY_BAR_POSITION_SEEKED_SIGNAL,
	G4_PLAY_BAR_NUM_SIGNALS
};
static guint g4_play_bar_signals[G4_PLAY_BAR_NUM_SIGNALS] = {0};
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _G4PlayBar {
	GtkBox parent_instance;
	G4PlayBarPrivate * priv;
};

struct _G4PlayBarClass {
	GtkBoxClass parent_class;
};

struct _G4PlayBarPrivate {
	GtkScale* _seek;
	G4PeakBar* _peak;
	GtkLabel* _positive;
	GtkLabel* _negative;
	GtkToggleButton* _repeat;
	GtkButton* _prev;
	GtkButton* _play;
	GtkButton* _next;
	G4VolumeButton* _volume;
	gint _duration;
	gint _position;
	gboolean _remain_progress;
	gboolean _seeking;
};

struct _Block29Data {
	int _ref_count_;
	G4PlayBar* self;
	G4GstPlayer* player;
};

struct _Block30Data {
	int _ref_count_;
	G4PlayBar* self;
	G4Application* app;
};

static gint G4PlayBar_private_offset;
static gpointer g4_play_bar_parent_class = NULL;

VALA_EXTERN GType g4_play_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4PlayBar, g_object_unref)
VALA_EXTERN GType g4_peak_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4PeakBar, g_object_unref)
VALA_EXTERN GType g4_volume_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4VolumeButton, g_object_unref)
VALA_EXTERN G4PeakBar* g4_peak_bar_new (void);
VALA_EXTERN G4PeakBar* g4_peak_bar_construct (GType object_type);
VALA_EXTERN G4VolumeButton* g4_volume_button_new (void);
VALA_EXTERN G4VolumeButton* g4_volume_button_construct (GType object_type);
VALA_EXTERN void g4_play_bar_on_size_changed (G4PlayBar* self,
                                  gint bar_width,
                                  gint bar_spacing);
static void g4_play_bar_on_duration_changed (G4PlayBar* self,
                                      GstClockTime duration);
VALA_EXTERN gdouble g4_gst_player_to_second (GstClockTime time);
static void g4_play_bar_update_negative_label (G4PlayBar* self);
static void g4_play_bar_on_position_changed (G4PlayBar* self,
                                      GstClockTime position);
static void g4_play_bar_update_position (G4PlayBar* self,
                                  GstClockTime position);
static void g4_play_bar_on_state_changed (G4PlayBar* self,
                                   GstState state);
VALA_EXTERN GType g4_gst_player_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4GstPlayer, g_object_unref)
static void g4_play_bar_setup_seek_bar (G4PlayBar* self,
                                 G4GstPlayer* player);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static gboolean __lambda55_ (G4PlayBar* self,
                      GtkScrollType type,
                      gdouble value);
VALA_EXTERN GstClockTime g4_gst_player_from_second (gdouble time);
static gboolean ___lambda55__gtk_range_change_value (GtkRange* _sender,
                                              GtkScrollType scroll,
                                              gdouble new_value,
                                              gpointer self);
static void __lambda56_ (G4PlayBar* self);
static void ___lambda56__gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                             gint n_press,
                                             gdouble x,
                                             gdouble y,
                                             gpointer self);
static void __lambda57_ (Block29Data* _data29_);
VALA_EXTERN void g4_gst_player_seek (G4GstPlayer* self,
                         GstClockTime position);
static void ___lambda57__gtk_gesture_click_released (GtkGestureClick* _sender,
                                              gint n_press,
                                              gdouble x,
                                              gdouble y,
                                              gpointer self);
VALA_EXTERN gchar* g4_format_time (gint seconds);
VALA_EXTERN G4PlayBar* g4_play_bar_new (void);
VALA_EXTERN G4PlayBar* g4_play_bar_construct (GType object_type);
VALA_EXTERN void g4_play_bar_set_peak (G4PlayBar* self,
                           gdouble value);
VALA_EXTERN void g4_peak_bar_set_peak (G4PeakBar* self,
                           gdouble value);
VALA_EXTERN gdouble g4_play_bar_get_position (G4PlayBar* self);
VALA_EXTERN gboolean g4_play_bar_get_remain_progress (G4PlayBar* self);
VALA_EXTERN void g4_play_bar_set_remain_progress (G4PlayBar* self,
                                      gboolean value);
static GObject * g4_play_bar_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
VALA_EXTERN GType g4_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4Application, g_object_unref)
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
VALA_EXTERN G4GstPlayer* g4_application_get_player (G4Application* self);
VALA_EXTERN void g4_peak_bar_set_align (G4PeakBar* self,
                            PangoAlignment value);
VALA_EXTERN GtkGestureClick* g4_make_widget_clickable (GtkWidget* label);
static void _g4_play_bar___lambda58_ (G4PlayBar* self);
static void __g4_play_bar___lambda58__gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                          gint n_press,
                                                          gdouble x,
                                                          gdouble y,
                                                          gpointer self);
static void _g4_play_bar___lambda59_ (Block30Data* _data30_);
VALA_EXTERN gboolean g4_application_get_single_loop (G4Application* self);
VALA_EXTERN void g4_application_set_single_loop (G4Application* self,
                                     gboolean value);
static void __g4_play_bar___lambda59__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                          gpointer self);
static void _g4_play_bar_on_duration_changed_g4_gst_player_duration_changed (G4GstPlayer* _sender,
                                                                      GstClockTime duration,
                                                                      gpointer self);
static void _g4_play_bar_on_position_changed_g4_gst_player_position_updated (G4GstPlayer* _sender,
                                                                      GstClockTime position,
                                                                      gpointer self);
static void _g4_play_bar_on_state_changed_g4_gst_player_state_changed (G4GstPlayer* _sender,
                                                                GstState state,
                                                                gpointer self);
VALA_EXTERN GSettings* g4_application_get_settings (G4Application* self);
static void g4_play_bar_finalize (GObject * obj);
static GType g4_play_bar_get_type_once (void);
static void _vala_g4_play_bar_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_g4_play_bar_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
g4_play_bar_get_instance_private (G4PlayBar* self)
{
	return G_STRUCT_MEMBER_P (self, G4PlayBar_private_offset);
}

void
g4_play_bar_on_size_changed (G4PlayBar* self,
                             gint bar_width,
                             gint bar_spacing)
{
	gint text_width = 0;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	G4PeakBar* _tmp2_;
	GtkLabel* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkLabel* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GtkWidget* _tmp9_ = NULL;
	GtkWidget* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_positive;
	_tmp1_ = self->priv->_negative;
	text_width = MAX (gtk_widget_get_width ((GtkWidget*) _tmp0_), gtk_widget_get_width ((GtkWidget*) _tmp1_));
	_tmp2_ = self->priv->_peak;
	_tmp3_ = self->priv->_positive;
	_tmp4_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_negative;
	_tmp7_ = gtk_widget_get_margin_end ((GtkWidget*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_object_set ((GtkWidget*) _tmp2_, "width-request", bar_width - (((text_width + _tmp5_) + _tmp8_) * 2), NULL);
	_tmp10_ = gtk_widget_get_last_child ((GtkWidget*) self);
	_tmp9_ = _tmp10_;
	if (_tmp9_ != NULL) {
		gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), bar_spacing);
	}
}

static void
g4_play_bar_on_duration_changed (G4PlayBar* self,
                                 GstClockTime duration)
{
	gdouble value = 0.0;
	GtkScale* _tmp0_;
	g_return_if_fail (self != NULL);
	value = g4_gst_player_to_second (duration);
	self->priv->_duration = (gint) (value + 0.5);
	_tmp0_ = self->priv->_seek;
	gtk_range_set_range ((GtkRange*) _tmp0_, (gdouble) 0, (gdouble) self->priv->_duration);
	g4_play_bar_update_negative_label (self);
}

static void
g4_play_bar_on_position_changed (G4PlayBar* self,
                                 GstClockTime position)
{
	g_return_if_fail (self != NULL);
	if (!self->priv->_seeking) {
		g4_play_bar_update_position (self, position);
	}
}

static void
g4_play_bar_on_state_changed (G4PlayBar* self,
                              GstState state)
{
	gboolean playing = FALSE;
	const gchar* _tmp0_ = NULL;
	GtkButton* _tmp1_;
	g_return_if_fail (self != NULL);
	playing = state == GST_STATE_PLAYING;
	if (playing) {
		_tmp0_ = "media-playback-pause-symbolic";
	} else {
		_tmp0_ = "media-playback-start-symbolic";
	}
	_tmp1_ = self->priv->_play;
	gtk_button_set_icon_name (_tmp1_, _tmp0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		G4PlayBar* self;
		self = _data29_->self;
		_g_object_unref0 (_data29_->player);
		_g_object_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}

static gboolean
__lambda55_ (G4PlayBar* self,
             GtkScrollType type,
             gdouble value)
{
	gboolean result;
	if (self->priv->_seeking) {
		g_signal_emit (self, g4_play_bar_signals[G4_PLAY_BAR_POSITION_SEEKED_SIGNAL], 0, value);
		g4_play_bar_update_position (self, g4_gst_player_from_second (value));
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda55__gtk_range_change_value (GtkRange* _sender,
                                     GtkScrollType scroll,
                                     gdouble new_value,
                                     gpointer self)
{
	gboolean result;
	result = __lambda55_ ((G4PlayBar*) self, scroll, new_value);
	return result;
}

static void
__lambda56_ (G4PlayBar* self)
{
	self->priv->_seeking = TRUE;
}

static void
___lambda56__gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                        gint n_press,
                                        gdouble x,
                                        gdouble y,
                                        gpointer self)
{
	__lambda56_ ((G4PlayBar*) self);
}

static void
__lambda57_ (Block29Data* _data29_)
{
	G4PlayBar* self;
	GtkScale* _tmp0_;
	self = _data29_->self;
	self->priv->_seeking = FALSE;
	_tmp0_ = self->priv->_seek;
	g4_gst_player_seek (_data29_->player, g4_gst_player_from_second (gtk_range_get_value ((GtkRange*) _tmp0_)));
}

static void
___lambda57__gtk_gesture_click_released (GtkGestureClick* _sender,
                                         gint n_press,
                                         gdouble x,
                                         gdouble y,
                                         gpointer self)
{
	__lambda57_ (self);
}

static void
g4_play_bar_setup_seek_bar (G4PlayBar* self,
                            G4GstPlayer* player)
{
	Block29Data* _data29_;
	G4GstPlayer* _tmp0_;
	GtkScale* _tmp1_;
	GtkGestureClick* click_gesture = NULL;
	GListModel* controllers = NULL;
	GtkScale* _tmp2_;
	GListModel* _tmp3_;
	GtkGestureClick* _tmp12_;
	GtkGestureClick* gesture = NULL;
	GtkGestureClick* _tmp17_;
	GtkGestureClick* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (player);
	_g_object_unref0 (_data29_->player);
	_data29_->player = _tmp0_;
	_tmp1_ = self->priv->_seek;
	g_signal_connect_object ((GtkRange*) _tmp1_, "change-value", (GCallback) ___lambda55__gtk_range_change_value, self, 0);
	click_gesture = NULL;
	_tmp2_ = self->priv->_seek;
	_tmp3_ = gtk_widget_observe_controllers ((GtkWidget*) _tmp2_);
	controllers = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GListModel* _tmp6_;
				GObject* controller = NULL;
				GListModel* _tmp7_;
				GObject* _tmp8_;
				GObject* _tmp9_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = controllers;
				if (!(((guint) i) < g_list_model_get_n_items (_tmp6_))) {
					break;
				}
				_tmp7_ = controllers;
				_tmp8_ = g_list_model_get_item (_tmp7_, (guint) i);
				controller = _tmp8_;
				_tmp9_ = controller;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_gesture_click_get_type ())) {
					GObject* _tmp10_;
					GtkGestureClick* _tmp11_;
					_tmp10_ = controller;
					_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_gesture_click_get_type (), GtkGestureClick));
					_g_object_unref0 (click_gesture);
					click_gesture = _tmp11_;
					_g_object_unref0 (controller);
					break;
				}
				_g_object_unref0 (controller);
			}
		}
	}
	_tmp12_ = click_gesture;
	if (_tmp12_ == NULL) {
		GtkGestureClick* _tmp13_;
		GtkScale* _tmp14_;
		GtkGestureClick* _tmp15_;
		GtkEventController* _tmp16_;
		_tmp13_ = (GtkGestureClick*) gtk_gesture_click_new ();
		_g_object_unref0 (click_gesture);
		click_gesture = _tmp13_;
		_tmp14_ = self->priv->_seek;
		_tmp15_ = click_gesture;
		_tmp16_ = _g_object_ref0 ((GtkEventController*) G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_gesture_click_get_type (), GtkGestureClick));
		gtk_widget_add_controller ((GtkWidget*) _tmp14_, _tmp16_);
	}
	_tmp17_ = click_gesture;
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_gesture_click_get_type (), GtkGestureClick));
	gesture = _tmp18_;
	gtk_gesture_single_set_button ((GtkGestureSingle*) gesture, (guint) 0);
	g_signal_connect_object (gesture, "pressed", (GCallback) ___lambda56__gtk_gesture_click_pressed, self, 0);
	g_signal_connect_data (gesture, "released", (GCallback) ___lambda57__gtk_gesture_click_released, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
	_g_object_unref0 (gesture);
	_g_object_unref0 (controllers);
	_g_object_unref0 (click_gesture);
	block29_data_unref (_data29_);
	_data29_ = NULL;
}

static void
g4_play_bar_update_negative_label (G4PlayBar* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_remain_progress) {
		GtkLabel* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = self->priv->_negative;
		_tmp1_ = g4_format_time (self->priv->_duration - self->priv->_position);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat ("-", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		gtk_label_set_label (_tmp0_, _tmp4_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
	} else {
		GtkLabel* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = self->priv->_negative;
		_tmp6_ = g4_format_time (self->priv->_duration);
		_tmp7_ = _tmp6_;
		gtk_label_set_label (_tmp5_, _tmp7_);
		_g_free0 (_tmp7_);
	}
}

static void
g4_play_bar_update_position (G4PlayBar* self,
                             GstClockTime position)
{
	gdouble value = 0.0;
	GtkScale* _tmp8_;
	g_return_if_fail (self != NULL);
	value = g4_gst_player_to_second (position);
	if (self->priv->_position != ((gint) value)) {
		GtkLabel* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		self->priv->_position = (gint) value;
		_tmp0_ = self->priv->_positive;
		_tmp1_ = g4_format_time (self->priv->_position);
		_tmp2_ = _tmp1_;
		gtk_label_set_label (_tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		if (self->priv->_remain_progress) {
			GtkLabel* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp3_ = self->priv->_negative;
			_tmp4_ = g4_format_time (self->priv->_duration - self->priv->_position);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strconcat ("-", _tmp5_, NULL);
			_tmp7_ = _tmp6_;
			gtk_label_set_label (_tmp3_, _tmp7_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
		}
	}
	_tmp8_ = self->priv->_seek;
	gtk_range_set_value ((GtkRange*) _tmp8_, value);
}

G4PlayBar*
g4_play_bar_construct (GType object_type)
{
	G4PlayBar * self = NULL;
	self = (G4PlayBar*) g_object_new (object_type, NULL);
	return self;
}

G4PlayBar*
g4_play_bar_new (void)
{
	return g4_play_bar_construct (G4_TYPE_PLAY_BAR);
}

void
g4_play_bar_set_peak (G4PlayBar* self,
                      gdouble value)
{
	G4PeakBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_peak;
	g4_peak_bar_set_peak (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, g4_play_bar_properties[G4_PLAY_BAR_PEAK_PROPERTY]);
}

gdouble
g4_play_bar_get_position (G4PlayBar* self)
{
	gdouble result;
	GtkScale* _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_seek;
	result = gtk_range_get_value ((GtkRange*) _tmp0_);
	return result;
}

gboolean
g4_play_bar_get_remain_progress (G4PlayBar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_remain_progress;
	return result;
}

void
g4_play_bar_set_remain_progress (G4PlayBar* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_remain_progress = value;
	g4_play_bar_update_negative_label (self);
	g_object_notify_by_pspec ((GObject *) self, g4_play_bar_properties[G4_PLAY_BAR_REMAIN_PROGRESS_PROPERTY]);
}

static Block30Data*
block30_data_ref (Block30Data* _data30_)
{
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}

static void
block30_data_unref (void * _userdata_)
{
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		G4PlayBar* self;
		self = _data30_->self;
		_g_object_unref0 (_data30_->app);
		_g_object_unref0 (self);
		g_slice_free (Block30Data, _data30_);
	}
}

static void
_g4_play_bar___lambda58_ (G4PlayBar* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	_tmp0_ = g4_play_bar_get_remain_progress (self);
	_tmp1_ = _tmp0_;
	g4_play_bar_set_remain_progress (self, !_tmp1_);
}

static void
__g4_play_bar___lambda58__gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                     gint n_press,
                                                     gdouble x,
                                                     gdouble y,
                                                     gpointer self)
{
	_g4_play_bar___lambda58_ ((G4PlayBar*) self);
}

static void
_g4_play_bar___lambda59_ (Block30Data* _data30_)
{
	G4PlayBar* self;
	const gchar* _tmp0_ = NULL;
	GtkToggleButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkToggleButton* _tmp4_;
	G4Application* _tmp5_;
	G4Application* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	self = _data30_->self;
	_tmp1_ = self->priv->_repeat;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = "media-playlist-repeat-song-symbolic";
	} else {
		_tmp0_ = "media-playlist-repeat-symbolic";
	}
	_tmp4_ = self->priv->_repeat;
	gtk_button_set_icon_name ((GtkButton*) _tmp4_, _tmp0_);
	_tmp5_ = _data30_->app;
	_tmp6_ = _data30_->app;
	_tmp7_ = g4_application_get_single_loop (_tmp6_);
	_tmp8_ = _tmp7_;
	g4_application_set_single_loop (_tmp5_, !_tmp8_);
}

static void
__g4_play_bar___lambda59__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                     gpointer self)
{
	_g4_play_bar___lambda59_ (self);
}

static void
_g4_play_bar_on_duration_changed_g4_gst_player_duration_changed (G4GstPlayer* _sender,
                                                                 GstClockTime duration,
                                                                 gpointer self)
{
	g4_play_bar_on_duration_changed ((G4PlayBar*) self, duration);
}

static void
_g4_play_bar_on_position_changed_g4_gst_player_position_updated (G4GstPlayer* _sender,
                                                                 GstClockTime position,
                                                                 gpointer self)
{
	g4_play_bar_on_position_changed ((G4PlayBar*) self, position);
}

static void
_g4_play_bar_on_state_changed_g4_gst_player_state_changed (G4GstPlayer* _sender,
                                                           GstState state,
                                                           gpointer self)
{
	g4_play_bar_on_state_changed ((G4PlayBar*) self, state);
}

static GObject *
g4_play_bar_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	G4PlayBar * self;
	Block30Data* _data30_;
	GApplication* _tmp0_;
	G4Application* _tmp1_;
	G4GstPlayer* player = NULL;
	G4Application* _tmp2_;
	G4GstPlayer* _tmp3_;
	G4GstPlayer* _tmp4_;
	G4GstPlayer* _tmp5_;
	GtkScale* _tmp6_;
	GtkScale* _tmp7_;
	GtkScale* _tmp8_;
	G4GstPlayer* _tmp9_;
	GtkCenterBox* times = NULL;
	GtkCenterBox* _tmp10_;
	GtkCenterBox* _tmp11_;
	GtkCenterBox* _tmp12_;
	GtkCenterBox* _tmp13_;
	GtkLabel* _tmp14_;
	GtkCenterBox* _tmp15_;
	GtkLabel* _tmp16_;
	GtkOverlay* overlay = NULL;
	GtkOverlay* _tmp17_;
	GtkOverlay* _tmp18_;
	GtkCenterBox* _tmp19_;
	GtkOverlay* _tmp20_;
	G4PeakBar* _tmp21_;
	GtkOverlay* _tmp22_;
	G4PeakBar* _tmp23_;
	G4PeakBar* _tmp24_;
	G4PeakBar* _tmp25_;
	G4PeakBar* _tmp26_;
	GtkLabel* _tmp27_;
	GtkLabel* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	GtkLabel* _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* _tmp35_;
	GtkGestureClick* _tmp36_;
	GtkGestureClick* _tmp37_;
	GtkBox* buttons = NULL;
	GtkBox* _tmp38_;
	GtkBox* _tmp39_;
	GtkBox* _tmp40_;
	GtkBox* _tmp41_;
	GtkToggleButton* _tmp42_;
	GtkBox* _tmp43_;
	GtkButton* _tmp44_;
	GtkBox* _tmp45_;
	GtkButton* _tmp46_;
	GtkBox* _tmp47_;
	GtkButton* _tmp48_;
	GtkBox* _tmp49_;
	G4VolumeButton* _tmp50_;
	GtkBox* _tmp51_;
	GtkToggleButton* _tmp52_;
	GtkToggleButton* _tmp53_;
	GtkToggleButton* _tmp54_;
	GtkToggleButton* _tmp55_;
	GtkToggleButton* _tmp56_;
	GtkButton* _tmp57_;
	GtkButton* _tmp58_;
	GtkButton* _tmp59_;
	GtkButton* _tmp60_;
	GtkButton* _tmp61_;
	GtkButton* _tmp62_;
	GtkButton* _tmp63_;
	GtkButton* _tmp64_;
	GtkButton* _tmp65_;
	GtkButton* _tmp66_;
	GtkButton* _tmp67_;
	GtkButton* _tmp68_;
	GtkButton* _tmp69_;
	GtkButton* _tmp70_;
	GtkButton* _tmp71_;
	GtkButton* _tmp72_;
	G4VolumeButton* _tmp73_;
	G4GstPlayer* _tmp74_;
	G4VolumeButton* _tmp75_;
	G4GstPlayer* _tmp76_;
	G4GstPlayer* _tmp77_;
	G4GstPlayer* _tmp78_;
	GSettings* settings = NULL;
	G4Application* _tmp79_;
	GSettings* _tmp80_;
	GSettings* _tmp81_;
	GSettings* _tmp82_;
	GSettings* _tmp83_;
	G4PeakBar* _tmp84_;
	GSettings* _tmp85_;
	G4PeakBar* _tmp86_;
	GSettings* _tmp87_;
	parent_class = G_OBJECT_CLASS (g4_play_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_TYPE_PLAY_BAR, G4PlayBar);
	_data30_ = g_slice_new0 (Block30Data);
	_data30_->_ref_count_ = 1;
	_data30_->self = g_object_ref (self);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G4_TYPE_APPLICATION, G4Application));
	_data30_->app = _tmp1_;
	_tmp2_ = _data30_->app;
	_tmp3_ = g4_application_get_player (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	player = _tmp5_;
	_tmp6_ = self->priv->_seek;
	gtk_range_set_range ((GtkRange*) _tmp6_, (gdouble) 0, (gdouble) self->priv->_duration);
	_tmp7_ = self->priv->_seek;
	gtk_widget_set_halign ((GtkWidget*) _tmp7_, GTK_ALIGN_FILL);
	_tmp8_ = self->priv->_seek;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp8_);
	_tmp9_ = player;
	g4_play_bar_setup_seek_bar (self, _tmp9_);
	_tmp10_ = (GtkCenterBox*) gtk_center_box_new ();
	g_object_ref_sink (_tmp10_);
	times = _tmp10_;
	_tmp11_ = times;
	gtk_center_box_set_baseline_position (_tmp11_, GTK_BASELINE_POSITION_CENTER);
	_tmp12_ = times;
	gtk_widget_set_halign ((GtkWidget*) _tmp12_, GTK_ALIGN_FILL);
	_tmp13_ = times;
	_tmp14_ = self->priv->_positive;
	gtk_center_box_set_start_widget (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = times;
	_tmp16_ = self->priv->_negative;
	gtk_center_box_set_end_widget (_tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp17_);
	overlay = _tmp17_;
	_tmp18_ = overlay;
	_tmp19_ = times;
	gtk_overlay_set_child (_tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = overlay;
	_tmp21_ = self->priv->_peak;
	gtk_overlay_add_overlay (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = overlay;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->_peak;
	g4_peak_bar_set_align (_tmp23_, PANGO_ALIGN_CENTER);
	_tmp24_ = self->priv->_peak;
	gtk_widget_set_halign ((GtkWidget*) _tmp24_, GTK_ALIGN_CENTER);
	_tmp25_ = self->priv->_peak;
	g_object_set ((GtkWidget*) _tmp25_, "width-request", 168, NULL);
	_tmp26_ = self->priv->_peak;
	gtk_widget_add_css_class ((GtkWidget*) _tmp26_, "dim-label");
	_tmp27_ = self->priv->_positive;
	gtk_widget_set_halign ((GtkWidget*) _tmp27_, GTK_ALIGN_START);
	_tmp28_ = self->priv->_positive;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp28_, 12);
	_tmp29_ = self->priv->_positive;
	gtk_widget_add_css_class ((GtkWidget*) _tmp29_, "dim-label");
	_tmp30_ = self->priv->_positive;
	gtk_widget_add_css_class ((GtkWidget*) _tmp30_, "numeric");
	_tmp31_ = self->priv->_negative;
	gtk_widget_set_halign ((GtkWidget*) _tmp31_, GTK_ALIGN_END);
	_tmp32_ = self->priv->_negative;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp32_, 12);
	_tmp33_ = self->priv->_negative;
	gtk_widget_add_css_class ((GtkWidget*) _tmp33_, "dim-label");
	_tmp34_ = self->priv->_negative;
	gtk_widget_add_css_class ((GtkWidget*) _tmp34_, "numeric");
	_tmp35_ = self->priv->_negative;
	_tmp36_ = g4_make_widget_clickable ((GtkWidget*) _tmp35_);
	_tmp37_ = _tmp36_;
	g_signal_connect_object (_tmp37_, "pressed", (GCallback) __g4_play_bar___lambda58__gtk_gesture_click_pressed, self, 0);
	_g_object_unref0 (_tmp37_);
	_tmp38_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 16);
	g_object_ref_sink (_tmp38_);
	buttons = _tmp38_;
	_tmp39_ = buttons;
	gtk_widget_set_halign ((GtkWidget*) _tmp39_, GTK_ALIGN_CENTER);
	_tmp40_ = buttons;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp40_, 16);
	_tmp41_ = buttons;
	_tmp42_ = self->priv->_repeat;
	gtk_box_append (_tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = buttons;
	_tmp44_ = self->priv->_prev;
	gtk_box_append (_tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = buttons;
	_tmp46_ = self->priv->_play;
	gtk_box_append (_tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = buttons;
	_tmp48_ = self->priv->_next;
	gtk_box_append (_tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = buttons;
	_tmp50_ = self->priv->_volume;
	gtk_box_append (_tmp49_, (GtkWidget*) _tmp50_);
	_tmp51_ = buttons;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp51_);
	_tmp52_ = self->priv->_repeat;
	gtk_button_set_icon_name ((GtkButton*) _tmp52_, "media-playlist-repeat-symbolic");
	_tmp53_ = self->priv->_repeat;
	gtk_widget_set_valign ((GtkWidget*) _tmp53_, GTK_ALIGN_CENTER);
	_tmp54_ = self->priv->_repeat;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp54_, _ ("Single Loop"));
	_tmp55_ = self->priv->_repeat;
	gtk_widget_add_css_class ((GtkWidget*) _tmp55_, "flat");
	_tmp56_ = self->priv->_repeat;
	g_signal_connect_data (_tmp56_, "toggled", (GCallback) __g4_play_bar___lambda59__gtk_toggle_button_toggled, block30_data_ref (_data30_), (GClosureNotify) block30_data_unref, 0);
	_tmp57_ = self->priv->_prev;
	gtk_widget_set_valign ((GtkWidget*) _tmp57_, GTK_ALIGN_CENTER);
	_tmp58_ = self->priv->_prev;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp58_, G4_ACTION_APP G4_ACTION_PREV);
	_tmp59_ = self->priv->_prev;
	gtk_button_set_icon_name (_tmp59_, "media-skip-backward-symbolic");
	_tmp60_ = self->priv->_prev;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp60_, _ ("Play Previous"));
	_tmp61_ = self->priv->_prev;
	gtk_widget_add_css_class ((GtkWidget*) _tmp61_, "circular");
	_tmp62_ = self->priv->_play;
	gtk_widget_set_valign ((GtkWidget*) _tmp62_, GTK_ALIGN_CENTER);
	_tmp63_ = self->priv->_play;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp63_, G4_ACTION_APP G4_ACTION_PLAY_PAUSE);
	_tmp64_ = self->priv->_play;
	gtk_button_set_icon_name (_tmp64_, "media-playback-start-symbolic");
	_tmp65_ = self->priv->_play;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp65_, _ ("Play/Pause"));
	_tmp66_ = self->priv->_play;
	gtk_widget_add_css_class ((GtkWidget*) _tmp66_, "circular");
	_tmp67_ = self->priv->_play;
	gtk_widget_set_size_request ((GtkWidget*) _tmp67_, 48, 48);
	_tmp68_ = self->priv->_next;
	gtk_widget_set_valign ((GtkWidget*) _tmp68_, GTK_ALIGN_CENTER);
	_tmp69_ = self->priv->_next;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp69_, G4_ACTION_APP G4_ACTION_NEXT);
	_tmp70_ = self->priv->_next;
	gtk_button_set_icon_name (_tmp70_, "media-skip-forward-symbolic");
	_tmp71_ = self->priv->_next;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp71_, _ ("Play Next"));
	_tmp72_ = self->priv->_next;
	gtk_widget_add_css_class ((GtkWidget*) _tmp72_, "circular");
	_tmp73_ = self->priv->_volume;
	gtk_widget_set_valign ((GtkWidget*) _tmp73_, GTK_ALIGN_CENTER);
	_tmp74_ = player;
	_tmp75_ = self->priv->_volume;
	g_object_bind_property_with_closures ((GObject*) _tmp74_, "volume", (GObject*) _tmp75_, "value", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp76_ = player;
	g_signal_connect_object (_tmp76_, "duration-changed", (GCallback) _g4_play_bar_on_duration_changed_g4_gst_player_duration_changed, self, 0);
	_tmp77_ = player;
	g_signal_connect_object (_tmp77_, "position-updated", (GCallback) _g4_play_bar_on_position_changed_g4_gst_player_position_updated, self, 0);
	_tmp78_ = player;
	g_signal_connect_object (_tmp78_, "state-changed", (GCallback) _g4_play_bar_on_state_changed_g4_gst_player_state_changed, self, 0);
	_tmp79_ = _data30_->app;
	_tmp80_ = g4_application_get_settings (_tmp79_);
	_tmp81_ = _tmp80_;
	_tmp82_ = _g_object_ref0 (_tmp81_);
	settings = _tmp82_;
	_tmp83_ = settings;
	_tmp84_ = self->priv->_peak;
	g_settings_bind (_tmp83_, "show-peak", (GObject*) _tmp84_, "visible", G_SETTINGS_BIND_DEFAULT);
	_tmp85_ = settings;
	_tmp86_ = self->priv->_peak;
	g_settings_bind (_tmp85_, "peak-characters", (GObject*) _tmp86_, "characters", G_SETTINGS_BIND_DEFAULT);
	_tmp87_ = settings;
	g_settings_bind (_tmp87_, "remain-progress", (GObject*) self, "remain-progress", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (settings);
	_g_object_unref0 (buttons);
	_g_object_unref0 (overlay);
	_g_object_unref0 (times);
	_g_object_unref0 (player);
	block30_data_unref (_data30_);
	_data30_ = NULL;
	return obj;
}

static void
g4_play_bar_class_init (G4PlayBarClass * klass,
                        gpointer klass_data)
{
	g4_play_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &G4PlayBar_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_g4_play_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_g4_play_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = g4_play_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = g4_play_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_PLAY_BAR_PEAK_PROPERTY, g4_play_bar_properties[G4_PLAY_BAR_PEAK_PROPERTY] = g_param_spec_double ("peak", "peak", "peak", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_PLAY_BAR_POSITION_PROPERTY, g4_play_bar_properties[G4_PLAY_BAR_POSITION_PROPERTY] = g_param_spec_double ("position", "position", "position", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_PLAY_BAR_REMAIN_PROGRESS_PROPERTY, g4_play_bar_properties[G4_PLAY_BAR_REMAIN_PROGRESS_PROPERTY] = g_param_spec_boolean ("remain-progress", "remain-progress", "remain-progress", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g4_play_bar_signals[G4_PLAY_BAR_POSITION_SEEKED_SIGNAL] = g_signal_new ("position-seeked", G4_TYPE_PLAY_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
}

static void
g4_play_bar_instance_init (G4PlayBar * self,
                           gpointer klass)
{
	GtkScale* _tmp0_;
	G4PeakBar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkToggleButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	G4VolumeButton* _tmp8_;
	self->priv = g4_play_bar_get_instance_private (self);
	_tmp0_ = (GtkScale*) gtk_scale_new (GTK_ORIENTATION_HORIZONTAL, NULL);
	g_object_ref_sink (_tmp0_);
	self->priv->_seek = _tmp0_;
	_tmp1_ = g4_peak_bar_new ();
	g_object_ref_sink (_tmp1_);
	self->priv->_peak = _tmp1_;
	_tmp2_ = (GtkLabel*) gtk_label_new ("0:00");
	g_object_ref_sink (_tmp2_);
	self->priv->_positive = _tmp2_;
	_tmp3_ = (GtkLabel*) gtk_label_new ("0:00");
	g_object_ref_sink (_tmp3_);
	self->priv->_negative = _tmp3_;
	_tmp4_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp4_);
	self->priv->_repeat = _tmp4_;
	_tmp5_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp5_);
	self->priv->_prev = _tmp5_;
	_tmp6_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp6_);
	self->priv->_play = _tmp6_;
	_tmp7_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp7_);
	self->priv->_next = _tmp7_;
	_tmp8_ = g4_volume_button_new ();
	g_object_ref_sink (_tmp8_);
	self->priv->_volume = _tmp8_;
	self->priv->_duration = 0;
	self->priv->_position = 0;
	self->priv->_remain_progress = FALSE;
	self->priv->_seeking = FALSE;
}

static void
g4_play_bar_finalize (GObject * obj)
{
	G4PlayBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_TYPE_PLAY_BAR, G4PlayBar);
	_g_object_unref0 (self->priv->_seek);
	_g_object_unref0 (self->priv->_peak);
	_g_object_unref0 (self->priv->_positive);
	_g_object_unref0 (self->priv->_negative);
	_g_object_unref0 (self->priv->_repeat);
	_g_object_unref0 (self->priv->_prev);
	_g_object_unref0 (self->priv->_play);
	_g_object_unref0 (self->priv->_next);
	_g_object_unref0 (self->priv->_volume);
	G_OBJECT_CLASS (g4_play_bar_parent_class)->finalize (obj);
}

static GType
g4_play_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (G4PlayBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_play_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (G4PlayBar), 0, (GInstanceInitFunc) g4_play_bar_instance_init, NULL };
	GType g4_play_bar_type_id;
	g4_play_bar_type_id = g_type_register_static (gtk_box_get_type (), "G4PlayBar", &g_define_type_info, 0);
	G4PlayBar_private_offset = g_type_add_instance_private (g4_play_bar_type_id, sizeof (G4PlayBarPrivate));
	return g4_play_bar_type_id;
}

GType
g4_play_bar_get_type (void)
{
	static volatile gsize g4_play_bar_type_id__once = 0;
	if (g_once_init_enter (&g4_play_bar_type_id__once)) {
		GType g4_play_bar_type_id;
		g4_play_bar_type_id = g4_play_bar_get_type_once ();
		g_once_init_leave (&g4_play_bar_type_id__once, g4_play_bar_type_id);
	}
	return g4_play_bar_type_id__once;
}

static void
_vala_g4_play_bar_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	G4PlayBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_PLAY_BAR, G4PlayBar);
	switch (property_id) {
		case G4_PLAY_BAR_POSITION_PROPERTY:
		g_value_set_double (value, g4_play_bar_get_position (self));
		break;
		case G4_PLAY_BAR_REMAIN_PROGRESS_PROPERTY:
		g_value_set_boolean (value, g4_play_bar_get_remain_progress (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_g4_play_bar_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	G4PlayBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_PLAY_BAR, G4PlayBar);
	switch (property_id) {
		case G4_PLAY_BAR_PEAK_PROPERTY:
		g4_play_bar_set_peak (self, g_value_get_double (value));
		break;
		case G4_PLAY_BAR_REMAIN_PROGRESS_PROPERTY:
		g4_play_bar_set_remain_progress (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

gchar*
g4_format_time (gint seconds)
{
	GString* sb = NULL;
	GString* _tmp0_;
	gint hours = 0;
	gint minutes = 0;
	GString* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	_tmp0_ = g_string_new ("");
	sb = _tmp0_;
	hours = seconds / 3600;
	minutes = seconds / 60;
	seconds = seconds - (minutes * 60);
	if (hours > 0) {
		GString* _tmp1_;
		minutes -= hours * 60;
		_tmp1_ = sb;
		g_string_printf (_tmp1_, "%d:%02d:%02d", hours, minutes, seconds);
	} else {
		GString* _tmp2_;
		_tmp2_ = sb;
		g_string_printf (_tmp2_, "%d:%02d", minutes, seconds);
	}
	_tmp3_ = sb;
	_tmp4_ = _tmp3_->str;
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	_g_string_free0 (sb);
	return result;
}

GtkGestureClick*
g4_make_widget_clickable (GtkWidget* label)
{
	GtkGestureClick* controller = NULL;
	GtkGestureClick* _tmp0_;
	GtkEventController* _tmp1_;
	GtkGestureClick* result;
	g_return_val_if_fail (label != NULL, NULL);
	_tmp0_ = (GtkGestureClick*) gtk_gesture_click_new ();
	controller = _tmp0_;
	gtk_gesture_single_set_button ((GtkGestureSingle*) controller, (guint) GDK_BUTTON_PRIMARY);
	_tmp1_ = _g_object_ref0 ((GtkEventController*) controller);
	gtk_widget_add_controller (label, _tmp1_);
	gtk_widget_set_cursor_from_name (label, "pointer");
	result = controller;
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

