/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpvectorlayer_pdb.h
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#if !defined (__GIMP_H_INSIDE__) && !defined (GIMP_COMPILATION)
#error "Only <libgimp/gimp.h> can be included directly."
#endif

#ifndef __GIMP_VECTOR_LAYER_PDB_H__
#define __GIMP_VECTOR_LAYER_PDB_H__

G_BEGIN_DECLS

/* For information look into the C source or the html documentation */


GimpVectorLayer* gimp_vector_layer_new                     (GimpImage        *image,
                                                            GimpPath         *path);
gboolean         gimp_vector_layer_refresh                 (GimpVectorLayer  *layer);
gboolean         gimp_vector_layer_get_enable_fill         (GimpVectorLayer  *layer);
gboolean         gimp_vector_layer_get_enable_stroke       (GimpVectorLayer  *layer);
GeglColor*       gimp_vector_layer_get_fill_color          (GimpVectorLayer  *layer);
GimpPattern*     gimp_vector_layer_get_fill_pattern        (GimpVectorLayer  *layer);
GimpPath*        gimp_vector_layer_get_path                (GimpVectorLayer  *layer);
GimpCapStyle     gimp_vector_layer_get_stroke_cap_style    (GimpVectorLayer  *layer);
GeglColor*       gimp_vector_layer_get_stroke_color        (GimpVectorLayer  *layer);
GimpPattern*     gimp_vector_layer_get_stroke_pattern      (GimpVectorLayer  *layer);
gdouble          gimp_vector_layer_get_stroke_dash_offset  (GimpVectorLayer  *layer);
gboolean         gimp_vector_layer_get_stroke_dash_pattern (GimpVectorLayer  *layer,
                                                            gsize            *num_dashes,
                                                            gdouble         **dashes);
GimpJoinStyle    gimp_vector_layer_get_stroke_join_style   (GimpVectorLayer  *layer);
gdouble          gimp_vector_layer_get_stroke_miter_limit  (GimpVectorLayer  *layer);
gdouble          gimp_vector_layer_get_stroke_width        (GimpVectorLayer  *layer);
GimpUnit*        gimp_vector_layer_get_stroke_width_unit   (GimpVectorLayer  *layer);
gboolean         gimp_vector_layer_set_enable_fill         (GimpVectorLayer  *layer,
                                                            gboolean          enable_fill);
gboolean         gimp_vector_layer_set_enable_stroke       (GimpVectorLayer  *layer,
                                                            gboolean          enable_stroke);
gboolean         gimp_vector_layer_set_fill_color          (GimpVectorLayer  *layer,
                                                            GeglColor        *color);
gboolean         gimp_vector_layer_set_stroke_cap_style    (GimpVectorLayer  *layer,
                                                            GimpCapStyle      cap_style);
gboolean         gimp_vector_layer_set_stroke_color        (GimpVectorLayer  *layer,
                                                            GeglColor        *color);
gboolean         gimp_vector_layer_set_stroke_dash_offset  (GimpVectorLayer  *layer,
                                                            gdouble           dash_offset);
gboolean         gimp_vector_layer_set_stroke_dash_pattern (GimpVectorLayer  *layer,
                                                            gsize             num_dashes,
                                                            const gdouble    *dashes);
gboolean         gimp_vector_layer_set_stroke_join_style   (GimpVectorLayer  *layer,
                                                            GimpJoinStyle     join_style);
gboolean         gimp_vector_layer_set_stroke_miter_limit  (GimpVectorLayer  *layer,
                                                            gdouble           miter);
gboolean         gimp_vector_layer_set_stroke_width        (GimpVectorLayer  *layer,
                                                            gdouble           width);
gboolean         gimp_vector_layer_set_stroke_width_unit   (GimpVectorLayer  *layer,
                                                            GimpUnit         *unit);


G_END_DECLS

#endif /* __GIMP_VECTOR_LAYER_PDB_H__ */
