/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * gimplanguagestore-data.h
 * Copyright (C) 2024 Jehan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#pragma once

/* NOTE: this file is auto-generated by /build/gimp-git/src/build/tools/gen-languages */

#define GIMP_L10N_LANGS_SIZE 85
#define GIMP_ALL_LANGS_SIZE 189

typedef struct
{
  gchar *code;
  gchar *name;
} GimpLanguageDef;

static const GimpLanguageDef GimpL10nLanguages[GIMP_L10N_LANGS_SIZE] =
{
  { "kab", "Kabyle [kab]" },
  { "ckb", "Kurdish, Central [ckb]" },
  { "nds", "German, Low [nds]" },
  { "oc", "Occitan (post 1500) [oc]" },
  { "be", "Belarusian [be]" },
  { "ca@valencia", "Catalan [ca@valencia]" },
  { "mk", "Macedonian [mk]" },
  { "nb", "Norwegian Bokmål [nb]" },
  { "ml", "Malayalam [ml]" },
  { "lv", "Latvian [lv]" },
  { "sv", "Swedish [sv]" },
  { "cs", "Czech [cs]" },
  { "nn", "Norwegian Nynorsk [nn]" },
  { "fa", "Persian [fa]" },
  { "pt_BR", "Portuguese [pt_BR]" },
  { "ta", "Tamil [ta]" },
  { "sk", "Slovak [sk]" },
  { "ru", "Russian [ru]" },
  { "br", "Breton [br]" },
  { "yi", "Yiddish [yi]" },
  { "xh", "Xhosa [xh]" },
  { "he", "Hebrew [he]" },
  { "my", "Burmese [my]" },
  { "el", "Greek, Modern (1453-) [el]" },
  { "bg", "Bulgarian [bg]" },
  { "gd", "Gaelic, Scottish [gd]" },
  { "bs", "Bosnian [bs]" },
  { "is", "Icelandic [is]" },
  { "kk", "Kazakh [kk]" },
  { "ar", "Arabic [ar]" },
  { "hr", "Croatian [hr]" },
  { "rw", "Kinyarwanda [rw]" },
  { "ne", "Nepali (macrolanguage) [ne]" },
  { "it", "Italian [it]" },
  { "pt", "Portuguese [pt]" },
  { "en_CA", "English [en_CA]" },
  { "en_US", "English [en_US]" },
  { "sl", "Slovenian [sl]" },
  { "da", "Danish [da]" },
  { "ka", "Georgian [ka]" },
  { "sr@latin", "Serbian [sr@latin]" },
  { "km", "Khmer [km]" },
  { "zh_CN", "Chinese [zh_CN]" },
  { "eo", "Esperanto [eo]" },
  { "te", "Telugu [te]" },
  { "ky", "Kirghiz [ky]" },
  { "zh_HK", "Chinese [zh_HK]" },
  { "hi", "Hindi [hi]" },
  { "kn", "Kannada [kn]" },
  { "ca", "Catalan [ca]" },
  { "ja", "Japanese [ja]" },
  { "hu", "Hungarian [hu]" },
  { "dz", "Dzongkha [dz]" },
  { "fr", "French [fr]" },
  { "mr", "Marathi [mr]" },
  { "tr", "Turkish [tr]" },
  { "ko", "Korean [ko]" },
  { "ro", "Romanian [ro]" },
  { "pl", "Polish [pl]" },
  { "vi", "Vietnamese [vi]" },
  { "ms", "Malay (macrolanguage) [ms]" },
  { "pa", "Panjabi [pa]" },
  { "gu", "Gujarati [gu]" },
  { "th", "Thai [th]" },
  { "de", "German [de]" },
  { "sr", "Serbian [sr]" },
  { "ast", "Asturian [ast]" },
  { "tt", "Tatar [tt]" },
  { "fi", "Finnish [fi]" },
  { "es", "Spanish [es]" },
  { "bn", "Bengali [bn]" },
  { "zh_TW", "Chinese [zh_TW]" },
  { "uk", "Ukrainian [uk]" },
  { "csb", "Kashubian [csb]" },
  { "en_GB", "English [en_GB]" },
  { "am", "Amharic [am]" },
  { "et", "Estonian [et]" },
  { "lt", "Lithuanian [lt]" },
  { "gl", "Galician [gl]" },
  { "nl", "Dutch [nl]" },
  { "id", "Indonesian [id]" },
  { "si", "Sinhala [si]" },
  { "ga", "Irish [ga]" },
  { "eu", "Basque [eu]" },
  { "az", "Azerbaijani [az]" },
};


static const GimpLanguageDef GimpAllLanguages[GIMP_ALL_LANGS_SIZE] =
{
  { "mi", "Maori" },
  { "bg", "Bulgarian" },
  { "nv", "Navajo" },
  { "kg", "Kongo" },
  { "sq", "Albanian" },
  { "ho", "Hiri Motu" },
  { "lt", "Lithuanian" },
  { "ie", "Interlingue" },
  { "ar", "Arabic" },
  { "tg", "Tajik" },
  { "vi", "Vietnamese" },
  { "cu", "Slavic, Church" },
  { "om", "Oromo" },
  { "sr", "Serbian" },
  { "lu", "Luba-Katanga" },
  { "as", "Assamese" },
  { "mk", "Macedonian" },
  { "bi", "Bislama" },
  { "na", "Nauru" },
  { "gd", "Gaelic, Scottish" },
  { "ki", "Kikuyu" },
  { "cv", "Chuvash" },
  { "ss", "Swati" },
  { "th", "Thai" },
  { "lv", "Latvian" },
  { "ig", "Igbo" },
  { "ml", "Malayalam" },
  { "ti", "Tigrinya" },
  { "fo", "Faroese" },
  { "nb", "Norwegian Bokmål" },
  { "ny", "Nyanja" },
  { "kj", "Kuanyama" },
  { "st", "Sotho, Southern" },
  { "hr", "Croatian" },
  { "wa", "Walloon" },
  { "ca", "Catalan" },
  { "kk", "Kazakh" },
  { "la", "Latin" },
  { "su", "Sundanese" },
  { "tk", "Turkmen" },
  { "ii", "Yi, Sichuan" },
  { "av", "Avaric" },
  { "mn", "Mongolian" },
  { "nd", "Ndebele, North" },
  { "jv", "Javanese" },
  { "kl", "Kalaallisut" },
  { "cy", "Welsh" },
  { "lb", "Luxembourgish" },
  { "ht", "Haitian" },
  { "ee", "Ewe" },
  { "sv", "Swedish" },
  { "bm", "Bambara" },
  { "ne", "Nepali (macrolanguage)" },
  { "kab", "Kabyle" },
  { "tl", "Tagalog" },
  { "km", "Khmer" },
  { "or", "Oriya (macrolanguage)" },
  { "sw", "Swahili (macrolanguage)" },
  { "hu", "Hungarian" },
  { "aa", "Afar" },
  { "ik", "Inupiaq" },
  { "ja", "Japanese" },
  { "bn", "Bengali" },
  { "uz", "Uzbek" },
  { "qu", "Quechua" },
  { "kn", "Kannada" },
  { "fr", "French" },
  { "os", "Ossetian" },
  { "ab", "Abkhazian" },
  { "pi", "Pali" },
  { "ay", "Aymara" },
  { "sa", "Sanskrit" },
  { "bo", "Tibetan" },
  { "ng", "Ndonga" },
  { "ce", "Chechen" },
  { "tn", "Tswana" },
  { "ko", "Korean" },
  { "yi", "Yiddish" },
  { "to", "Tonga (Tonga Islands)" },
  { "az", "Azerbaijani" },
  { "mr", "Marathi" },
  { "rm", "Romansh" },
  { "zu", "Zulu" },
  { "sc", "Sardinian" },
  { "ha", "Hausa" },
  { "vo", "Volapük" },
  { "ms", "Malay (macrolanguage)" },
  { "rn", "Rundi" },
  { "gl", "Galician" },
  { "sd", "Sindhi" },
  { "za", "Zhuang" },
  { "lg", "Ganda" },
  { "ae", "Avestan" },
  { "hy", "Armenian" },
  { "io", "Ido" },
  { "mt", "Maltese" },
  { "br", "Breton" },
  { "ch", "Chamorro" },
  { "ro", "Romanian" },
  { "kr", "Kanuri" },
  { "csb", "Kashubian" },
  { "pl", "Polish" },
  { "hz", "Herero" },
  { "af", "Afrikaans" },
  { "tr", "Turkish" },
  { "fa", "Persian" },
  { "bs", "Bosnian" },
  { "nds", "German, Low" },
  { "gn", "Guarani" },
  { "ks", "Kashmiri" },
  { "li", "Limburgan" },
  { "dv", "Dhivehi" },
  { "el", "Greek, Modern (1453-)" },
  { "ts", "Tsonga" },
  { "fy", "Frisian, Western" },
  { "nl", "Dutch" },
  { "se", "Sami, Northern" },
  { "sg", "Sango" },
  { "he", "Hebrew" },
  { "tt", "Tatar" },
  { "yo", "Yoruba" },
  { "ug", "Uighur" },
  { "oc", "Occitan (post 1500)" },
  { "ku", "Kurdish" },
  { "da", "Danish" },
  { "sh", "Serbo-Croatian" },
  { "en", "English" },
  { "is", "Icelandic" },
  { "uk", "Ukrainian" },
  { "nn", "Norwegian Nynorsk" },
  { "kv", "Komi" },
  { "si", "Sinhala" },
  { "eo", "Esperanto" },
  { "it", "Italian" },
  { "my", "Burmese" },
  { "no", "Norwegian" },
  { "kw", "Cornish" },
  { "wo", "Wolof" },
  { "dz", "Dzongkha" },
  { "ak", "Akan" },
  { "tw", "Twi" },
  { "iu", "Inuktitut" },
  { "ff", "Fulah" },
  { "ba", "Bashkir" },
  { "ka", "Georgian" },
  { "ru", "Russian" },
  { "sk", "Slovak" },
  { "hi", "Hindi" },
  { "ln", "Lingala" },
  { "ps", "Pushto" },
  { "zh", "Chinese" },
  { "ta", "Tamil" },
  { "co", "Corsican" },
  { "ky", "Kirghiz" },
  { "de", "German" },
  { "lo", "Lao" },
  { "am", "Amharic" },
  { "pt", "Portuguese" },
  { "ty", "Tahitian" },
  { "sl", "Slovenian" },
  { "nr", "Ndebele, South" },
  { "rw", "Kinyarwanda" },
  { "gu", "Gujarati" },
  { "sm", "Samoan" },
  { "ast", "Asturian" },
  { "an", "Aragonese" },
  { "ia", "Interlingua (International Auxiliary Language Association)" },
  { "es", "Spanish" },
  { "fi", "Finnish" },
  { "ve", "Venda" },
  { "xh", "Xhosa" },
  { "gv", "Manx" },
  { "sn", "Shona" },
  { "mg", "Malagasy" },
  { "be", "Belarusian" },
  { "fj", "Fijian" },
  { "et", "Estonian" },
  { "cr", "Cree" },
  { "ckb", "Kurdish, Central" },
  { "oj", "Ojibwa" },
  { "so", "Somali" },
  { "te", "Telugu" },
  { "eu", "Basque" },
  { "mh", "Marshallese" },
  { "ur", "Urdu" },
  { "ga", "Irish" },
  { "cs", "Czech" },
  { "pa", "Panjabi" },
  { "id", "Indonesian" },
};
