/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.capfile.CAPFile;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPData;

public class DAPSigner {
    private static final Logger log = LoggerFactory.getLogger(DAPSigner.class);

    private DAPSigner() {
    }

    public static byte[] sign(CAPFile cap, PrivateKey key, GPData.LFDBH hash) throws GeneralSecurityException {
        byte[] dtbs = cap.getLoadFileDataHash(hash.algo);
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey rkey = (RSAPrivateKey)key;
            log.info("Signing DAP with {} RSA and {}", (Object)rkey.getModulus().bitLength(), (Object)hash);
            return GPCrypto.rsa_sign(rkey, dtbs);
        }
        if (key instanceof ECPrivateKey) {
            Signature signer = Signature.getInstance("SHA256withECDSA");
            signer.initSign(key);
            signer.update(cap.getLoadFileDataHash(hash.algo));
            byte[] dap = GPCrypto.der2rs(signer.sign(), 32);
            return dap;
        }
        throw new IllegalArgumentException("Unsupported DAP key: " + key.getAlgorithm());
    }
}

