/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.pcsc;

import apdu4j.pcsc.PCSCMonitor;
import apdu4j.pcsc.PCSCReader;
import apdu4j.pcsc.SCard;
import apdu4j.pcsc.TerminalManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HandyTerminalsMonitor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(HandyTerminalsMonitor.class);
    private static final long TICK_WAIT = 3000L;
    private static final long TICK_POLL = 1000L;
    private final PCSCMonitor listener;
    private TerminalManager manager;
    private CardTerminals monitor;
    private volatile boolean isSunPCSC = false;
    private final boolean isWindows = TerminalManager.isWindows();
    private final boolean isMacOS = TerminalManager.isMacOS();
    private final boolean isLinux = !this.isWindows && !this.isMacOS;
    private Set<PCSCReader> currentState = Collections.emptySet();
    private volatile boolean haveReportedNoReaders = false;

    public HandyTerminalsMonitor(TerminalManager whatToMonitor, PCSCMonitor whereToReport) {
        this.manager = whatToMonitor;
        this.listener = whereToReport;
    }

    private void establishFreshContext() {
        try {
            logger.debug("Getting new terminals object");
            this.monitor = this.manager.terminals(true);
            String monitorClass = this.monitor.getClass().getCanonicalName();
            if (monitorClass.equals("javax.smartcardio.TerminalFactory.NoneCardTerminals")) {
                this.fail("SunPCSC without a valid module? Please restart the application!", null);
            } else if (monitorClass.equals("sun.security.smartcardio.PCSCTerminals")) {
                this.isSunPCSC = true;
                logger.debug("SunPCSC mode");
            } else if (monitorClass.equals("jnasmartcardio.Smartcardio.JnaCardTerminals")) {
                logger.debug("jnasmartcardio mode");
            } else {
                logger.warn("Unknown CardTerminals class {} ", (Object)monitorClass);
            }
        }
        catch (Exception e) {
            logger.error("Failed to fetch terminals: " + e.getMessage(), e);
        }
    }

    private void fail(String message, Throwable t) {
        logger.error("Failing: {} {}", (Object)message, (Object)(t == null ? "" : SCard.getExceptionMessage(t)));
        IllegalStateException ex = t == null ? new IllegalStateException(message) : new IllegalStateException(message, t);
        this.listener.readerListErrored(ex);
        Thread.currentThread().interrupt();
    }

    private boolean shouldReport(List<PCSCReader> newStates) {
        HashSet<PCSCReader> news = new HashSet<PCSCReader>(newStates);
        logger.trace("current state: {}", (Object)this.currentState);
        logger.trace("new     state: {}", (Object)news);
        if (news.size() == 0 && !this.haveReportedNoReaders) {
            logger.trace("change: no readers");
            return true;
        }
        if (!this.currentState.equals(news)) {
            logger.trace("change");
            return true;
        }
        logger.trace("no change");
        return false;
    }

    private void reportChanges(List<PCSCReader> state) {
        logger.debug("Reporting state: {}", (Object)state);
        this.haveReportedNoReaders = state.size() == 0;
        this.listener.readerListChanged(state);
        this.currentState = new HashSet<PCSCReader>(state);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        logger.debug("PC/SC monitor thread starting");
        this.establishFreshContext();
        boolean changed = true;
        try {
            while (true) {
                String err;
                long start;
                if (Thread.currentThread().isInterrupted()) {
                    logger.debug("Thread interrupted cleanly, done");
                    return;
                }
                if (!Thread.currentThread().isInterrupted() && changed) {
                    try {
                        start = System.currentTimeMillis();
                        List<PCSCReader> readers = TerminalManager.listPCSC(this.monitor.list(), null, false);
                        logger.trace("list took {}ms, {} items", (Object)(System.currentTimeMillis() - start), (Object)readers.size());
                        if (this.shouldReport(readers)) {
                            this.reportChanges(readers);
                        }
                        if (this.isSunPCSC && readers.size() == 0) {
                            logger.debug("sunpcsc on macosx, waitForChange() will fail with IllegalStateException");
                            Thread.sleep(1000L);
                            continue;
                        }
                    }
                    catch (CardException e) {
                        err = SCard.getExceptionMessage(e);
                        if (err.equals("SCARD_E_NO_READERS_AVAILABLE")) {
                            if (this.isLinux) {
                                logger.debug("No readers, sleeping one tick");
                                TimeUnit.MILLISECONDS.sleep(1000L);
                                continue;
                            }
                            this.fail("list", e);
                        }
                        if (err.equals("SCARD_E_SERVICE_STOPPED")) {
                            if (this.isWindows) {
                                if (this.isSunPCSC) {
                                    this.fail("Can't recover from stopped PC/SC with SunPCSC", e);
                                } else {
                                    logger.info("Getting new context");
                                    this.establishFreshContext();
                                    TimeUnit.MILLISECONDS.sleep(1000L);
                                    continue;
                                }
                            }
                            this.fail("list", e);
                        }
                        if (err.equals("SCARD_E_NO_SERVICE")) {
                            logger.debug("list: {}", (Object)err);
                            TimeUnit.MILLISECONDS.sleep(1000L);
                            continue;
                        }
                        this.fail("list", e);
                    }
                }
                if (Thread.currentThread().isInterrupted()) continue;
                try {
                    start = System.currentTimeMillis();
                    changed = this.monitor.waitForChange(3000L);
                    logger.trace("wait took {}ms and was {}", (Object)(System.currentTimeMillis() - start), (Object)changed);
                }
                catch (CardException e) {
                    err = SCard.getExceptionMessage(e);
                    if (err.equals("SCARD_E_TIMEOUT")) {
                        logger.trace("wait: {}", (Object)err);
                        if (this.isLinux) {
                            logger.trace("Removed reader on Linux");
                            changed = true;
                            continue;
                        }
                        this.fail("wait", e);
                        continue;
                    }
                    if (err.equals("SCARD_E_SERVICE_STOPPED")) {
                        logger.trace("wait: {}", (Object)err);
                        TimeUnit.MILLISECONDS.sleep(1000L);
                        continue;
                    }
                    if (err.equals("SCARD_E_NO_READERS_AVAILABLE")) {
                        if (this.isLinux && this.isSunPCSC) {
                            logger.error("{} in wait cycle? Should not reach here");
                            TimeUnit.MILLISECONDS.sleep(1000L);
                            continue;
                        }
                        this.fail("list", e);
                        continue;
                    }
                    this.fail("wait", e);
                }
            }
        }
        catch (InterruptedException e) {
            logger.debug("Thread was interrupted, done");
        }
    }
}

