/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.pcsc.providers;

import apdu4j.pcsc.TerminalManager;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactorySpi;

public abstract class EmulatedSingleTerminalProvider
extends Provider {
    static final long serialVersionUID = -1813264769968105172L;

    public EmulatedSingleTerminalProvider(Class<? extends EmulatedTerminalFactorySpi> clazz) {
        super(String.format("Emulated %s", clazz.getSimpleName()), "0.1", "EmulatedTerminalProvider from apdu4j/" + TerminalManager.getVersion());
        this.put("TerminalFactory.PC/SC", clazz.getName());
    }

    static class EmulatedCardTerminals
    extends CardTerminals {
        final List<CardTerminal> terminals;

        EmulatedCardTerminals(List<CardTerminal> terminals) {
            this.terminals = terminals;
        }

        @Override
        public List<CardTerminal> list(CardTerminals.State state) {
            switch (state) {
                case ALL: 
                case CARD_PRESENT: 
                case CARD_INSERTION: {
                    return this.terminals;
                }
            }
            return Collections.emptyList();
        }

        @Override
        public boolean waitForChange(long l) throws CardException {
            try {
                Thread.sleep(l);
                return false;
            }
            catch (InterruptedException e) {
                throw new CardException("Interrupted", e);
            }
        }
    }

    public static class EmulatedTerminalFactorySpi
    extends TerminalFactorySpi {
        volatile transient CardTerminal instance;
        Object parameter;

        public EmulatedTerminalFactorySpi(Object parameter) {
            this.parameter = parameter;
        }

        @Override
        public CardTerminals engineTerminals() {
            if (this.instance == null) {
                this.instance = this.getTheTerminal();
            }
            return new EmulatedCardTerminals(Collections.unmodifiableList(Arrays.asList(this.instance)));
        }

        protected CardTerminal getTheTerminal() {
            throw new IllegalStateException("getTheTerminal() must be implemented!");
        }
    }
}

