#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 365
#define LARGE_STATE_COUNT 34
#define SYMBOL_COUNT 111
#define ALIAS_COUNT 9
#define TOKEN_COUNT 52
#define EXTERNAL_TOKEN_COUNT 41
#define FIELD_COUNT 3
#define MAX_ALIAS_SEQUENCE_LENGTH 4
#define PRODUCTION_ID_COUNT 27

enum ts_symbol_identifiers {
  aux_sym__classifiers_token1 = 1,
  aux_sym_target_token1 = 2,
  anon_sym_COLON_COLON = 3,
  anon_sym_SPACE = 4,
  anon_sym_TAB = 5,
  anon_sym_VTAB = 6,
  anon_sym_FF = 7,
  anon_sym_u00a0 = 8,
  sym___newline = 9,
  sym___whitespace = 10,
  sym__newline = 11,
  sym__blankline = 12,
  sym__indent = 13,
  sym__newline_indent = 14,
  sym__dedent = 15,
  sym__overline = 16,
  sym__underline = 17,
  sym_transition = 18,
  sym__char_bullet = 19,
  sym__numeric_bullet = 20,
  sym__field_mark = 21,
  sym__field_mark_end = 22,
  sym__literal_indented_block_mark = 23,
  sym__literal_quoted_block_mark = 24,
  sym__quoted_literal_block = 25,
  sym__line_block_mark = 26,
  sym__attribution_mark = 27,
  sym__doctest_block_mark = 28,
  sym__text = 29,
  sym_emphasis = 30,
  sym_strong = 31,
  sym__interpreted_text = 32,
  sym__interpreted_text_prefix = 33,
  sym__role_name_prefix = 34,
  sym__role_name_suffix = 35,
  sym_literal = 36,
  sym_substitution_reference = 37,
  sym_inline_target = 38,
  sym_footnote_reference = 39,
  sym_citation_reference = 40,
  sym_reference = 41,
  sym_standalone_hyperlink = 42,
  sym__explicit_markup_start = 43,
  sym__footnote_label = 44,
  sym__citation_label = 45,
  sym__target_name = 46,
  sym__anonymous_target_mark = 47,
  sym__directive_name = 48,
  sym__substitution_mark = 49,
  sym__empty_comment = 50,
  sym__invalid_token = 51,
  sym_document = 52,
  sym_section = 53,
  sym__overline_section = 54,
  sym__underline_section = 55,
  sym__transition_block = 56,
  sym__body_element_block = 57,
  sym_body = 58,
  sym__body_element = 59,
  sym_paragraph = 60,
  sym__paragraph_line = 61,
  sym__list = 62,
  sym_bullet_list = 63,
  sym__bullet_list_item = 64,
  sym_enumerated_list = 65,
  sym__numeric_list_item = 66,
  sym_definition_list = 67,
  sym__definition_list_item = 68,
  aux_sym__classifiers = 69,
  sym_field_list = 70,
  sym_field = 71,
  sym__literal_block = 72,
  sym__indented_text_block = 73,
  sym_line_block = 74,
  sym_line = 75,
  sym__block_quote_block = 76,
  sym_block_quote = 77,
  sym_attribution = 78,
  sym_doctest_block = 79,
  aux_sym__explicit_markup_block = 80,
  sym__markup_block = 81,
  sym_footnote = 82,
  sym_citation = 83,
  sym_target = 84,
  sym__anonymous_target = 85,
  sym_directive = 86,
  sym__directive_body = 87,
  sym_substitution_definition = 88,
  sym__embedded_directive = 89,
  sym_comment = 90,
  sym__line = 91,
  aux_sym__text_block = 92,
  sym__text_line = 93,
  sym__inline_markup = 94,
  sym_interpreted_text = 95,
  sym__default_role = 96,
  sym__prefix_role = 97,
  sym__suffix_role = 98,
  aux_sym_document_repeat1 = 99,
  aux_sym_body_repeat1 = 100,
  aux_sym_paragraph_repeat1 = 101,
  aux_sym__paragraph_line_repeat1 = 102,
  aux_sym_bullet_list_repeat1 = 103,
  aux_sym_enumerated_list_repeat1 = 104,
  aux_sym_definition_list_repeat1 = 105,
  aux_sym_field_list_repeat1 = 106,
  aux_sym__indented_text_block_repeat1 = 107,
  aux_sym_line_block_repeat1 = 108,
  aux_sym_line_repeat1 = 109,
  aux_sym__text_line_repeat1 = 110,
  alias_sym_arguments = 111,
  alias_sym_classifier = 112,
  alias_sym_content = 113,
  alias_sym_definition = 114,
  alias_sym_field_body = 115,
  alias_sym_field_name = 116,
  alias_sym_options = 117,
  alias_sym_term = 118,
  alias_sym_title = 119,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [aux_sym__classifiers_token1] = ":",
  [aux_sym_target_token1] = "link",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_SPACE] = " ",
  [anon_sym_TAB] = "\t",
  [anon_sym_VTAB] = "\v",
  [anon_sym_FF] = "\f",
  [anon_sym_u00a0] = "\u00a0",
  [sym___newline] = "__newline",
  [sym___whitespace] = "__whitespace",
  [sym__newline] = "_newline",
  [sym__blankline] = "_blankline",
  [sym__indent] = "_indent",
  [sym__newline_indent] = "_newline_indent",
  [sym__dedent] = "_dedent",
  [sym__overline] = "adornment",
  [sym__underline] = "adornment",
  [sym_transition] = "transition",
  [sym__char_bullet] = "bullet",
  [sym__numeric_bullet] = "bullet",
  [sym__field_mark] = ":",
  [sym__field_mark_end] = ":",
  [sym__literal_indented_block_mark] = "::",
  [sym__literal_quoted_block_mark] = "::",
  [sym__quoted_literal_block] = "literal_block",
  [sym__line_block_mark] = "|",
  [sym__attribution_mark] = "--",
  [sym__doctest_block_mark] = "_doctest_block_mark",
  [sym__text] = "text",
  [sym_emphasis] = "emphasis",
  [sym_strong] = "strong",
  [sym__interpreted_text] = "interpreted_text",
  [sym__interpreted_text_prefix] = "interpreted_text",
  [sym__role_name_prefix] = "role",
  [sym__role_name_suffix] = "role",
  [sym_literal] = "literal",
  [sym_substitution_reference] = "substitution_reference",
  [sym_inline_target] = "inline_target",
  [sym_footnote_reference] = "footnote_reference",
  [sym_citation_reference] = "citation_reference",
  [sym_reference] = "reference",
  [sym_standalone_hyperlink] = "standalone_hyperlink",
  [sym__explicit_markup_start] = "..",
  [sym__footnote_label] = "label",
  [sym__citation_label] = "label",
  [sym__target_name] = "name",
  [sym__anonymous_target_mark] = "__",
  [sym__directive_name] = "type",
  [sym__substitution_mark] = "substitution",
  [sym__empty_comment] = "comment",
  [sym__invalid_token] = "_invalid_token",
  [sym_document] = "document",
  [sym_section] = "section",
  [sym__overline_section] = "_overline_section",
  [sym__underline_section] = "_underline_section",
  [sym__transition_block] = "_transition_block",
  [sym__body_element_block] = "_body_element_block",
  [sym_body] = "body",
  [sym__body_element] = "_body_element",
  [sym_paragraph] = "paragraph",
  [sym__paragraph_line] = "_paragraph_line",
  [sym__list] = "_list",
  [sym_bullet_list] = "bullet_list",
  [sym__bullet_list_item] = "list_item",
  [sym_enumerated_list] = "enumerated_list",
  [sym__numeric_list_item] = "list_item",
  [sym_definition_list] = "definition_list",
  [sym__definition_list_item] = "list_item",
  [aux_sym__classifiers] = "_classifiers",
  [sym_field_list] = "field_list",
  [sym_field] = "field",
  [sym__literal_block] = "_literal_block",
  [sym__indented_text_block] = "_indented_text_block",
  [sym_line_block] = "line_block",
  [sym_line] = "line",
  [sym__block_quote_block] = "_block_quote_block",
  [sym_block_quote] = "block_quote",
  [sym_attribution] = "attribution",
  [sym_doctest_block] = "doctest_block",
  [aux_sym__explicit_markup_block] = "_explicit_markup_block",
  [sym__markup_block] = "_markup_block",
  [sym_footnote] = "footnote",
  [sym_citation] = "citation",
  [sym_target] = "target",
  [sym__anonymous_target] = "target",
  [sym_directive] = "directive",
  [sym__directive_body] = "body",
  [sym_substitution_definition] = "substitution_definition",
  [sym__embedded_directive] = "directive",
  [sym_comment] = "comment",
  [sym__line] = "_line",
  [aux_sym__text_block] = "_text_block",
  [sym__text_line] = "_text_line",
  [sym__inline_markup] = "_inline_markup",
  [sym_interpreted_text] = "interpreted_text",
  [sym__default_role] = "_default_role",
  [sym__prefix_role] = "_prefix_role",
  [sym__suffix_role] = "_suffix_role",
  [aux_sym_document_repeat1] = "document_repeat1",
  [aux_sym_body_repeat1] = "body_repeat1",
  [aux_sym_paragraph_repeat1] = "paragraph_repeat1",
  [aux_sym__paragraph_line_repeat1] = "_paragraph_line_repeat1",
  [aux_sym_bullet_list_repeat1] = "bullet_list_repeat1",
  [aux_sym_enumerated_list_repeat1] = "enumerated_list_repeat1",
  [aux_sym_definition_list_repeat1] = "definition_list_repeat1",
  [aux_sym_field_list_repeat1] = "field_list_repeat1",
  [aux_sym__indented_text_block_repeat1] = "_indented_text_block_repeat1",
  [aux_sym_line_block_repeat1] = "line_block_repeat1",
  [aux_sym_line_repeat1] = "line_repeat1",
  [aux_sym__text_line_repeat1] = "_text_line_repeat1",
  [alias_sym_arguments] = "arguments",
  [alias_sym_classifier] = "classifier",
  [alias_sym_content] = "content",
  [alias_sym_definition] = "definition",
  [alias_sym_field_body] = "field_body",
  [alias_sym_field_name] = "field_name",
  [alias_sym_options] = "options",
  [alias_sym_term] = "term",
  [alias_sym_title] = "title",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [aux_sym__classifiers_token1] = sym__field_mark,
  [aux_sym_target_token1] = aux_sym_target_token1,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_SPACE] = anon_sym_SPACE,
  [anon_sym_TAB] = anon_sym_TAB,
  [anon_sym_VTAB] = anon_sym_VTAB,
  [anon_sym_FF] = anon_sym_FF,
  [anon_sym_u00a0] = anon_sym_u00a0,
  [sym___newline] = sym___newline,
  [sym___whitespace] = sym___whitespace,
  [sym__newline] = sym__newline,
  [sym__blankline] = sym__blankline,
  [sym__indent] = sym__indent,
  [sym__newline_indent] = sym__newline_indent,
  [sym__dedent] = sym__dedent,
  [sym__overline] = sym__overline,
  [sym__underline] = sym__overline,
  [sym_transition] = sym_transition,
  [sym__char_bullet] = sym__char_bullet,
  [sym__numeric_bullet] = sym__char_bullet,
  [sym__field_mark] = sym__field_mark,
  [sym__field_mark_end] = sym__field_mark,
  [sym__literal_indented_block_mark] = anon_sym_COLON_COLON,
  [sym__literal_quoted_block_mark] = anon_sym_COLON_COLON,
  [sym__quoted_literal_block] = sym__quoted_literal_block,
  [sym__line_block_mark] = sym__line_block_mark,
  [sym__attribution_mark] = sym__attribution_mark,
  [sym__doctest_block_mark] = sym__doctest_block_mark,
  [sym__text] = sym__text,
  [sym_emphasis] = sym_emphasis,
  [sym_strong] = sym_strong,
  [sym__interpreted_text] = sym__interpreted_text,
  [sym__interpreted_text_prefix] = sym__interpreted_text,
  [sym__role_name_prefix] = sym__role_name_prefix,
  [sym__role_name_suffix] = sym__role_name_prefix,
  [sym_literal] = sym_literal,
  [sym_substitution_reference] = sym_substitution_reference,
  [sym_inline_target] = sym_inline_target,
  [sym_footnote_reference] = sym_footnote_reference,
  [sym_citation_reference] = sym_citation_reference,
  [sym_reference] = sym_reference,
  [sym_standalone_hyperlink] = sym_standalone_hyperlink,
  [sym__explicit_markup_start] = sym__explicit_markup_start,
  [sym__footnote_label] = sym__footnote_label,
  [sym__citation_label] = sym__footnote_label,
  [sym__target_name] = sym__target_name,
  [sym__anonymous_target_mark] = sym__anonymous_target_mark,
  [sym__directive_name] = sym__directive_name,
  [sym__substitution_mark] = sym__substitution_mark,
  [sym__empty_comment] = sym_comment,
  [sym__invalid_token] = sym__invalid_token,
  [sym_document] = sym_document,
  [sym_section] = sym_section,
  [sym__overline_section] = sym__overline_section,
  [sym__underline_section] = sym__underline_section,
  [sym__transition_block] = sym__transition_block,
  [sym__body_element_block] = sym__body_element_block,
  [sym_body] = sym_body,
  [sym__body_element] = sym__body_element,
  [sym_paragraph] = sym_paragraph,
  [sym__paragraph_line] = sym__paragraph_line,
  [sym__list] = sym__list,
  [sym_bullet_list] = sym_bullet_list,
  [sym__bullet_list_item] = sym__bullet_list_item,
  [sym_enumerated_list] = sym_enumerated_list,
  [sym__numeric_list_item] = sym__bullet_list_item,
  [sym_definition_list] = sym_definition_list,
  [sym__definition_list_item] = sym__bullet_list_item,
  [aux_sym__classifiers] = aux_sym__classifiers,
  [sym_field_list] = sym_field_list,
  [sym_field] = sym_field,
  [sym__literal_block] = sym__literal_block,
  [sym__indented_text_block] = sym__indented_text_block,
  [sym_line_block] = sym_line_block,
  [sym_line] = sym_line,
  [sym__block_quote_block] = sym__block_quote_block,
  [sym_block_quote] = sym_block_quote,
  [sym_attribution] = sym_attribution,
  [sym_doctest_block] = sym_doctest_block,
  [aux_sym__explicit_markup_block] = aux_sym__explicit_markup_block,
  [sym__markup_block] = sym__markup_block,
  [sym_footnote] = sym_footnote,
  [sym_citation] = sym_citation,
  [sym_target] = sym_target,
  [sym__anonymous_target] = sym_target,
  [sym_directive] = sym_directive,
  [sym__directive_body] = sym_body,
  [sym_substitution_definition] = sym_substitution_definition,
  [sym__embedded_directive] = sym_directive,
  [sym_comment] = sym_comment,
  [sym__line] = sym__line,
  [aux_sym__text_block] = aux_sym__text_block,
  [sym__text_line] = sym__text_line,
  [sym__inline_markup] = sym__inline_markup,
  [sym_interpreted_text] = sym_interpreted_text,
  [sym__default_role] = sym__default_role,
  [sym__prefix_role] = sym__prefix_role,
  [sym__suffix_role] = sym__suffix_role,
  [aux_sym_document_repeat1] = aux_sym_document_repeat1,
  [aux_sym_body_repeat1] = aux_sym_body_repeat1,
  [aux_sym_paragraph_repeat1] = aux_sym_paragraph_repeat1,
  [aux_sym__paragraph_line_repeat1] = aux_sym__paragraph_line_repeat1,
  [aux_sym_bullet_list_repeat1] = aux_sym_bullet_list_repeat1,
  [aux_sym_enumerated_list_repeat1] = aux_sym_enumerated_list_repeat1,
  [aux_sym_definition_list_repeat1] = aux_sym_definition_list_repeat1,
  [aux_sym_field_list_repeat1] = aux_sym_field_list_repeat1,
  [aux_sym__indented_text_block_repeat1] = aux_sym__indented_text_block_repeat1,
  [aux_sym_line_block_repeat1] = aux_sym_line_block_repeat1,
  [aux_sym_line_repeat1] = aux_sym_line_repeat1,
  [aux_sym__text_line_repeat1] = aux_sym__text_line_repeat1,
  [alias_sym_arguments] = alias_sym_arguments,
  [alias_sym_classifier] = alias_sym_classifier,
  [alias_sym_content] = alias_sym_content,
  [alias_sym_definition] = alias_sym_definition,
  [alias_sym_field_body] = alias_sym_field_body,
  [alias_sym_field_name] = alias_sym_field_name,
  [alias_sym_options] = alias_sym_options,
  [alias_sym_term] = alias_sym_term,
  [alias_sym_title] = alias_sym_title,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__classifiers_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_target_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SPACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TAB] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VTAB] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u00a0] = {
    .visible = true,
    .named = false,
  },
  [sym___newline] = {
    .visible = false,
    .named = true,
  },
  [sym___whitespace] = {
    .visible = false,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__blankline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__newline_indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym__overline] = {
    .visible = true,
    .named = false,
  },
  [sym__underline] = {
    .visible = true,
    .named = false,
  },
  [sym_transition] = {
    .visible = true,
    .named = true,
  },
  [sym__char_bullet] = {
    .visible = true,
    .named = false,
  },
  [sym__numeric_bullet] = {
    .visible = true,
    .named = false,
  },
  [sym__field_mark] = {
    .visible = true,
    .named = false,
  },
  [sym__field_mark_end] = {
    .visible = true,
    .named = false,
  },
  [sym__literal_indented_block_mark] = {
    .visible = true,
    .named = false,
  },
  [sym__literal_quoted_block_mark] = {
    .visible = true,
    .named = false,
  },
  [sym__quoted_literal_block] = {
    .visible = true,
    .named = true,
  },
  [sym__line_block_mark] = {
    .visible = true,
    .named = false,
  },
  [sym__attribution_mark] = {
    .visible = true,
    .named = false,
  },
  [sym__doctest_block_mark] = {
    .visible = false,
    .named = true,
  },
  [sym__text] = {
    .visible = true,
    .named = false,
  },
  [sym_emphasis] = {
    .visible = true,
    .named = true,
  },
  [sym_strong] = {
    .visible = true,
    .named = true,
  },
  [sym__interpreted_text] = {
    .visible = true,
    .named = false,
  },
  [sym__interpreted_text_prefix] = {
    .visible = true,
    .named = false,
  },
  [sym__role_name_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym__role_name_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_substitution_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_target] = {
    .visible = true,
    .named = true,
  },
  [sym_footnote_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_citation_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_standalone_hyperlink] = {
    .visible = true,
    .named = true,
  },
  [sym__explicit_markup_start] = {
    .visible = true,
    .named = false,
  },
  [sym__footnote_label] = {
    .visible = true,
    .named = true,
  },
  [sym__citation_label] = {
    .visible = true,
    .named = true,
  },
  [sym__target_name] = {
    .visible = true,
    .named = true,
  },
  [sym__anonymous_target_mark] = {
    .visible = true,
    .named = false,
  },
  [sym__directive_name] = {
    .visible = true,
    .named = true,
  },
  [sym__substitution_mark] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__invalid_token] = {
    .visible = false,
    .named = true,
  },
  [sym_document] = {
    .visible = true,
    .named = true,
  },
  [sym_section] = {
    .visible = true,
    .named = true,
  },
  [sym__overline_section] = {
    .visible = false,
    .named = true,
  },
  [sym__underline_section] = {
    .visible = false,
    .named = true,
  },
  [sym__transition_block] = {
    .visible = false,
    .named = true,
  },
  [sym__body_element_block] = {
    .visible = false,
    .named = true,
  },
  [sym_body] = {
    .visible = true,
    .named = true,
  },
  [sym__body_element] = {
    .visible = false,
    .named = true,
  },
  [sym_paragraph] = {
    .visible = true,
    .named = true,
  },
  [sym__paragraph_line] = {
    .visible = false,
    .named = true,
  },
  [sym__list] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_bullet_list] = {
    .visible = true,
    .named = true,
  },
  [sym__bullet_list_item] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerated_list] = {
    .visible = true,
    .named = true,
  },
  [sym__numeric_list_item] = {
    .visible = true,
    .named = true,
  },
  [sym_definition_list] = {
    .visible = true,
    .named = true,
  },
  [sym__definition_list_item] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__classifiers] = {
    .visible = false,
    .named = false,
  },
  [sym_field_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym__literal_block] = {
    .visible = false,
    .named = true,
  },
  [sym__indented_text_block] = {
    .visible = false,
    .named = true,
  },
  [sym_line_block] = {
    .visible = true,
    .named = true,
  },
  [sym_line] = {
    .visible = true,
    .named = true,
  },
  [sym__block_quote_block] = {
    .visible = false,
    .named = true,
  },
  [sym_block_quote] = {
    .visible = true,
    .named = true,
  },
  [sym_attribution] = {
    .visible = true,
    .named = true,
  },
  [sym_doctest_block] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__explicit_markup_block] = {
    .visible = false,
    .named = false,
  },
  [sym__markup_block] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_footnote] = {
    .visible = true,
    .named = true,
  },
  [sym_citation] = {
    .visible = true,
    .named = true,
  },
  [sym_target] = {
    .visible = true,
    .named = true,
  },
  [sym__anonymous_target] = {
    .visible = true,
    .named = true,
  },
  [sym_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__directive_body] = {
    .visible = true,
    .named = true,
  },
  [sym_substitution_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__embedded_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__line] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__text_block] = {
    .visible = false,
    .named = false,
  },
  [sym__text_line] = {
    .visible = false,
    .named = true,
  },
  [sym__inline_markup] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_interpreted_text] = {
    .visible = true,
    .named = true,
  },
  [sym__default_role] = {
    .visible = false,
    .named = true,
  },
  [sym__prefix_role] = {
    .visible = false,
    .named = true,
  },
  [sym__suffix_role] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_document_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_paragraph_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__paragraph_line_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bullet_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enumerated_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_definition_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__indented_text_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_line_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_line_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__text_line_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_classifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_content] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_definition] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_field_body] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_field_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_options] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_term] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_title] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_body = 1,
  field_link = 2,
  field_name = 3,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_body] = "body",
  [field_link] = "link",
  [field_name] = "name",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [5] = {.index = 1, .length = 2},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 4},
  [8] = {.index = 8, .length = 1},
  [13] = {.index = 9, .length = 2},
  [14] = {.index = 11, .length = 2},
  [24] = {.index = 13, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_link, 0, .inherited = true},
  [1] =
    {field_body, 2},
    {field_name, 1},
  [3] =
    {field_name, 1},
  [4] =
    {field_body, 2},
    {field_body, 2, .inherited = true},
    {field_name, 1},
    {field_name, 2, .inherited = true},
  [8] =
    {field_link, 1},
  [9] =
    {field_link, 2},
    {field_name, 1},
  [11] =
    {field_body, 3},
    {field_name, 1},
  [13] =
    {field_body, 3},
    {field_name, 0},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [1] = sym__quoted_literal_block,
  },
  [3] = {
    [0] = alias_sym_title,
  },
  [4] = {
    [1] = alias_sym_title,
  },
  [9] = {
    [0] = alias_sym_term,
    [2] = alias_sym_definition,
  },
  [10] = {
    [1] = alias_sym_classifier,
  },
  [11] = {
    [1] = alias_sym_field_name,
  },
  [12] = {
    [1] = alias_sym_field_name,
    [3] = alias_sym_field_body,
  },
  [15] = {
    [0] = alias_sym_term,
    [3] = alias_sym_definition,
  },
  [16] = {
    [1] = alias_sym_content,
  },
  [17] = {
    [0] = alias_sym_options,
  },
  [18] = {
    [0] = alias_sym_arguments,
  },
  [19] = {
    [0] = alias_sym_arguments,
    [1] = alias_sym_content,
  },
  [20] = {
    [1] = alias_sym_options,
  },
  [21] = {
    [0] = alias_sym_options,
    [2] = alias_sym_content,
  },
  [22] = {
    [0] = alias_sym_arguments,
    [2] = alias_sym_content,
  },
  [23] = {
    [0] = alias_sym_arguments,
    [1] = alias_sym_options,
  },
  [25] = {
    [1] = alias_sym_options,
    [3] = alias_sym_content,
  },
  [26] = {
    [0] = alias_sym_arguments,
    [1] = alias_sym_options,
    [3] = alias_sym_content,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_body, 3,
    sym_body,
    alias_sym_definition,
    alias_sym_field_body,
  sym_field_list, 2,
    sym_field_list,
    alias_sym_options,
  sym__indented_text_block, 3,
    sym__indented_text_block,
    alias_sym_content,
    sym__quoted_literal_block,
  sym__line, 2,
    sym__line,
    alias_sym_title,
  sym__text_line, 2,
    sym__text_line,
    alias_sym_arguments,
  aux_sym__paragraph_line_repeat1, 4,
    aux_sym__paragraph_line_repeat1,
    alias_sym_classifier,
    alias_sym_field_name,
    alias_sym_term,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 4,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 7,
  [13] = 6,
  [14] = 11,
  [15] = 9,
  [16] = 10,
  [17] = 8,
  [18] = 18,
  [19] = 19,
  [20] = 18,
  [21] = 21,
  [22] = 19,
  [23] = 23,
  [24] = 21,
  [25] = 23,
  [26] = 23,
  [27] = 23,
  [28] = 23,
  [29] = 23,
  [30] = 23,
  [31] = 23,
  [32] = 23,
  [33] = 23,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 39,
  [41] = 41,
  [42] = 42,
  [43] = 42,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 45,
  [49] = 49,
  [50] = 50,
  [51] = 49,
  [52] = 50,
  [53] = 44,
  [54] = 46,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 57,
  [59] = 47,
  [60] = 60,
  [61] = 55,
  [62] = 56,
  [63] = 63,
  [64] = 44,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 44,
  [69] = 44,
  [70] = 67,
  [71] = 71,
  [72] = 71,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 74,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 78,
  [83] = 80,
  [84] = 77,
  [85] = 81,
  [86] = 79,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 77,
  [91] = 80,
  [92] = 79,
  [93] = 81,
  [94] = 78,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 80,
  [100] = 77,
  [101] = 98,
  [102] = 88,
  [103] = 95,
  [104] = 96,
  [105] = 77,
  [106] = 106,
  [107] = 80,
  [108] = 79,
  [109] = 81,
  [110] = 78,
  [111] = 111,
  [112] = 97,
  [113] = 113,
  [114] = 87,
  [115] = 78,
  [116] = 81,
  [117] = 79,
  [118] = 106,
  [119] = 111,
  [120] = 120,
  [121] = 120,
  [122] = 122,
  [123] = 122,
  [124] = 124,
  [125] = 124,
  [126] = 126,
  [127] = 126,
  [128] = 128,
  [129] = 128,
  [130] = 130,
  [131] = 130,
  [132] = 130,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 137,
  [140] = 138,
  [141] = 137,
  [142] = 138,
  [143] = 137,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 138,
  [148] = 138,
  [149] = 134,
  [150] = 144,
  [151] = 136,
  [152] = 135,
  [153] = 133,
  [154] = 137,
  [155] = 146,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 145,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 95,
  [190] = 96,
  [191] = 191,
  [192] = 191,
  [193] = 193,
  [194] = 188,
  [195] = 188,
  [196] = 188,
  [197] = 188,
  [198] = 198,
  [199] = 199,
  [200] = 184,
  [201] = 165,
  [202] = 185,
  [203] = 169,
  [204] = 170,
  [205] = 171,
  [206] = 156,
  [207] = 166,
  [208] = 160,
  [209] = 209,
  [210] = 186,
  [211] = 172,
  [212] = 176,
  [213] = 161,
  [214] = 173,
  [215] = 157,
  [216] = 216,
  [217] = 174,
  [218] = 175,
  [219] = 199,
  [220] = 177,
  [221] = 216,
  [222] = 162,
  [223] = 178,
  [224] = 163,
  [225] = 179,
  [226] = 180,
  [227] = 164,
  [228] = 198,
  [229] = 181,
  [230] = 95,
  [231] = 182,
  [232] = 183,
  [233] = 96,
  [234] = 159,
  [235] = 168,
  [236] = 158,
  [237] = 237,
  [238] = 96,
  [239] = 95,
  [240] = 96,
  [241] = 241,
  [242] = 209,
  [243] = 243,
  [244] = 244,
  [245] = 95,
  [246] = 96,
  [247] = 237,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 237,
  [254] = 254,
  [255] = 241,
  [256] = 95,
  [257] = 257,
  [258] = 96,
  [259] = 95,
  [260] = 96,
  [261] = 261,
  [262] = 262,
  [263] = 252,
  [264] = 264,
  [265] = 261,
  [266] = 254,
  [267] = 267,
  [268] = 264,
  [269] = 269,
  [270] = 270,
  [271] = 96,
  [272] = 244,
  [273] = 273,
  [274] = 257,
  [275] = 248,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 279,
  [282] = 282,
  [283] = 95,
  [284] = 269,
  [285] = 285,
  [286] = 267,
  [287] = 249,
  [288] = 257,
  [289] = 267,
  [290] = 270,
  [291] = 257,
  [292] = 209,
  [293] = 267,
  [294] = 282,
  [295] = 257,
  [296] = 267,
  [297] = 257,
  [298] = 267,
  [299] = 257,
  [300] = 267,
  [301] = 257,
  [302] = 267,
  [303] = 257,
  [304] = 267,
  [305] = 273,
  [306] = 251,
  [307] = 267,
  [308] = 185,
  [309] = 309,
  [310] = 310,
  [311] = 186,
  [312] = 95,
  [313] = 257,
  [314] = 280,
  [315] = 315,
  [316] = 315,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 315,
  [322] = 322,
  [323] = 322,
  [324] = 324,
  [325] = 324,
  [326] = 326,
  [327] = 315,
  [328] = 322,
  [329] = 329,
  [330] = 185,
  [331] = 320,
  [332] = 186,
  [333] = 186,
  [334] = 326,
  [335] = 335,
  [336] = 336,
  [337] = 277,
  [338] = 338,
  [339] = 319,
  [340] = 185,
  [341] = 262,
  [342] = 276,
  [343] = 338,
  [344] = 329,
  [345] = 318,
  [346] = 346,
  [347] = 276,
  [348] = 317,
  [349] = 309,
  [350] = 277,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 113,
  [355] = 278,
  [356] = 356,
  [357] = 310,
  [358] = 322,
  [359] = 285,
  [360] = 338,
  [361] = 315,
  [362] = 322,
  [363] = 336,
  [364] = 364,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(8);
      ADVANCE_MAP(
        '\t', 14,
        '\n', 18,
        0x0b, 15,
        '\f', 16,
        '\r', 1,
        ' ', 13,
        ':', 4,
        0xa0, 17,
      );
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(18);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == 0xa0) ADVANCE(10);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(21);
      if (lookahead != 0) ADVANCE(11);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '\r') ADVANCE(1);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(20);
      END_STATE();
    case 4:
      if (lookahead == ':') ADVANCE(12);
      END_STATE();
    case 5:
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(9);
      END_STATE();
    case 6:
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(6);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(11);
      END_STATE();
    case 7:
      if (eof) ADVANCE(8);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == ':') ADVANCE(4);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(21);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 9:
      ACCEPT_TOKEN(aux_sym__classifiers_token1);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(9);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(aux_sym_target_token1);
      if (lookahead == '\r') ADVANCE(6);
      if (lookahead == 0xa0) ADVANCE(10);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') ADVANCE(19);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(11);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(aux_sym_target_token1);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(6);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(11);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(anon_sym_SPACE);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(21);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_TAB);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(21);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_VTAB);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(21);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_FF);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(21);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_u00a0);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(21);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(sym___newline);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(sym___whitespace);
      if (lookahead == '\r') ADVANCE(6);
      if (lookahead == 0xa0) ADVANCE(10);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') ADVANCE(19);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(11);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(sym___whitespace);
      if (lookahead == ':') ADVANCE(5);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(20);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(sym___whitespace);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(21);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 7, .external_lex_state = 2},
  [2] = {.lex_state = 7, .external_lex_state = 2},
  [3] = {.lex_state = 7, .external_lex_state = 2},
  [4] = {.lex_state = 7, .external_lex_state = 3},
  [5] = {.lex_state = 7, .external_lex_state = 3},
  [6] = {.lex_state = 7, .external_lex_state = 4},
  [7] = {.lex_state = 7, .external_lex_state = 4},
  [8] = {.lex_state = 7, .external_lex_state = 3},
  [9] = {.lex_state = 7, .external_lex_state = 4},
  [10] = {.lex_state = 7, .external_lex_state = 4},
  [11] = {.lex_state = 7, .external_lex_state = 4},
  [12] = {.lex_state = 7, .external_lex_state = 4},
  [13] = {.lex_state = 7, .external_lex_state = 4},
  [14] = {.lex_state = 7, .external_lex_state = 4},
  [15] = {.lex_state = 7, .external_lex_state = 4},
  [16] = {.lex_state = 7, .external_lex_state = 4},
  [17] = {.lex_state = 7, .external_lex_state = 3},
  [18] = {.lex_state = 7, .external_lex_state = 5},
  [19] = {.lex_state = 7, .external_lex_state = 5},
  [20] = {.lex_state = 7, .external_lex_state = 5},
  [21] = {.lex_state = 7, .external_lex_state = 3},
  [22] = {.lex_state = 7, .external_lex_state = 5},
  [23] = {.lex_state = 7, .external_lex_state = 5},
  [24] = {.lex_state = 7, .external_lex_state = 5},
  [25] = {.lex_state = 7, .external_lex_state = 5},
  [26] = {.lex_state = 7, .external_lex_state = 5},
  [27] = {.lex_state = 7, .external_lex_state = 5},
  [28] = {.lex_state = 7, .external_lex_state = 5},
  [29] = {.lex_state = 7, .external_lex_state = 5},
  [30] = {.lex_state = 7, .external_lex_state = 5},
  [31] = {.lex_state = 7, .external_lex_state = 5},
  [32] = {.lex_state = 7, .external_lex_state = 5},
  [33] = {.lex_state = 7, .external_lex_state = 5},
  [34] = {.lex_state = 7, .external_lex_state = 2},
  [35] = {.lex_state = 7, .external_lex_state = 2},
  [36] = {.lex_state = 7, .external_lex_state = 2},
  [37] = {.lex_state = 7, .external_lex_state = 2},
  [38] = {.lex_state = 7, .external_lex_state = 2},
  [39] = {.lex_state = 3, .external_lex_state = 6},
  [40] = {.lex_state = 3, .external_lex_state = 6},
  [41] = {.lex_state = 3, .external_lex_state = 6},
  [42] = {.lex_state = 7, .external_lex_state = 3},
  [43] = {.lex_state = 7, .external_lex_state = 5},
  [44] = {.lex_state = 3, .external_lex_state = 6},
  [45] = {.lex_state = 7, .external_lex_state = 7},
  [46] = {.lex_state = 7, .external_lex_state = 8},
  [47] = {.lex_state = 7, .external_lex_state = 8},
  [48] = {.lex_state = 7, .external_lex_state = 7},
  [49] = {.lex_state = 7, .external_lex_state = 8},
  [50] = {.lex_state = 7, .external_lex_state = 8},
  [51] = {.lex_state = 7, .external_lex_state = 9},
  [52] = {.lex_state = 7, .external_lex_state = 9},
  [53] = {.lex_state = 7, .external_lex_state = 7},
  [54] = {.lex_state = 7, .external_lex_state = 9},
  [55] = {.lex_state = 7, .external_lex_state = 10},
  [56] = {.lex_state = 7, .external_lex_state = 10},
  [57] = {.lex_state = 3, .external_lex_state = 11},
  [58] = {.lex_state = 3, .external_lex_state = 11},
  [59] = {.lex_state = 7, .external_lex_state = 9},
  [60] = {.lex_state = 7, .external_lex_state = 10},
  [61] = {.lex_state = 7, .external_lex_state = 10},
  [62] = {.lex_state = 7, .external_lex_state = 10},
  [63] = {.lex_state = 7, .external_lex_state = 10},
  [64] = {.lex_state = 3, .external_lex_state = 11},
  [65] = {.lex_state = 7, .external_lex_state = 12},
  [66] = {.lex_state = 3, .external_lex_state = 11},
  [67] = {.lex_state = 7, .external_lex_state = 13},
  [68] = {.lex_state = 7, .external_lex_state = 13},
  [69] = {.lex_state = 7, .external_lex_state = 14},
  [70] = {.lex_state = 7, .external_lex_state = 13},
  [71] = {.lex_state = 7, .external_lex_state = 14},
  [72] = {.lex_state = 7, .external_lex_state = 14},
  [73] = {.lex_state = 7, .external_lex_state = 12},
  [74] = {.lex_state = 7, .external_lex_state = 12},
  [75] = {.lex_state = 7, .external_lex_state = 12},
  [76] = {.lex_state = 7, .external_lex_state = 12},
  [77] = {.lex_state = 3, .external_lex_state = 6},
  [78] = {.lex_state = 3, .external_lex_state = 6},
  [79] = {.lex_state = 3, .external_lex_state = 6},
  [80] = {.lex_state = 3, .external_lex_state = 6},
  [81] = {.lex_state = 3, .external_lex_state = 6},
  [82] = {.lex_state = 7, .external_lex_state = 7},
  [83] = {.lex_state = 7, .external_lex_state = 7},
  [84] = {.lex_state = 7, .external_lex_state = 7},
  [85] = {.lex_state = 7, .external_lex_state = 7},
  [86] = {.lex_state = 7, .external_lex_state = 7},
  [87] = {.lex_state = 7, .external_lex_state = 8},
  [88] = {.lex_state = 7, .external_lex_state = 8},
  [89] = {.lex_state = 7, .external_lex_state = 15},
  [90] = {.lex_state = 3, .external_lex_state = 11},
  [91] = {.lex_state = 3, .external_lex_state = 11},
  [92] = {.lex_state = 3, .external_lex_state = 11},
  [93] = {.lex_state = 3, .external_lex_state = 11},
  [94] = {.lex_state = 3, .external_lex_state = 11},
  [95] = {.lex_state = 7, .external_lex_state = 8},
  [96] = {.lex_state = 7, .external_lex_state = 8},
  [97] = {.lex_state = 7, .external_lex_state = 8},
  [98] = {.lex_state = 7, .external_lex_state = 8},
  [99] = {.lex_state = 7, .external_lex_state = 14},
  [100] = {.lex_state = 7, .external_lex_state = 14},
  [101] = {.lex_state = 7, .external_lex_state = 9},
  [102] = {.lex_state = 7, .external_lex_state = 9},
  [103] = {.lex_state = 7, .external_lex_state = 9},
  [104] = {.lex_state = 7, .external_lex_state = 9},
  [105] = {.lex_state = 7, .external_lex_state = 13},
  [106] = {.lex_state = 7, .external_lex_state = 16},
  [107] = {.lex_state = 7, .external_lex_state = 13},
  [108] = {.lex_state = 7, .external_lex_state = 13},
  [109] = {.lex_state = 7, .external_lex_state = 13},
  [110] = {.lex_state = 7, .external_lex_state = 13},
  [111] = {.lex_state = 7, .external_lex_state = 16},
  [112] = {.lex_state = 7, .external_lex_state = 9},
  [113] = {.lex_state = 7, .external_lex_state = 10},
  [114] = {.lex_state = 7, .external_lex_state = 9},
  [115] = {.lex_state = 7, .external_lex_state = 14},
  [116] = {.lex_state = 7, .external_lex_state = 14},
  [117] = {.lex_state = 7, .external_lex_state = 14},
  [118] = {.lex_state = 7, .external_lex_state = 17},
  [119] = {.lex_state = 7, .external_lex_state = 17},
  [120] = {.lex_state = 7, .external_lex_state = 18},
  [121] = {.lex_state = 7, .external_lex_state = 18},
  [122] = {.lex_state = 7, .external_lex_state = 19},
  [123] = {.lex_state = 7, .external_lex_state = 19},
  [124] = {.lex_state = 7, .external_lex_state = 20},
  [125] = {.lex_state = 7, .external_lex_state = 20},
  [126] = {.lex_state = 7, .external_lex_state = 20},
  [127] = {.lex_state = 7, .external_lex_state = 20},
  [128] = {.lex_state = 7, .external_lex_state = 21},
  [129] = {.lex_state = 7, .external_lex_state = 21},
  [130] = {.lex_state = 7, .external_lex_state = 22},
  [131] = {.lex_state = 7, .external_lex_state = 22},
  [132] = {.lex_state = 7, .external_lex_state = 22},
  [133] = {.lex_state = 0, .external_lex_state = 23},
  [134] = {.lex_state = 7, .external_lex_state = 24},
  [135] = {.lex_state = 7, .external_lex_state = 24},
  [136] = {.lex_state = 7, .external_lex_state = 24},
  [137] = {.lex_state = 7, .external_lex_state = 25},
  [138] = {.lex_state = 7, .external_lex_state = 25},
  [139] = {.lex_state = 7, .external_lex_state = 25},
  [140] = {.lex_state = 7, .external_lex_state = 25},
  [141] = {.lex_state = 7, .external_lex_state = 25},
  [142] = {.lex_state = 7, .external_lex_state = 25},
  [143] = {.lex_state = 7, .external_lex_state = 25},
  [144] = {.lex_state = 7, .external_lex_state = 24},
  [145] = {.lex_state = 7, .external_lex_state = 25},
  [146] = {.lex_state = 7, .external_lex_state = 24},
  [147] = {.lex_state = 7, .external_lex_state = 25},
  [148] = {.lex_state = 7, .external_lex_state = 25},
  [149] = {.lex_state = 7, .external_lex_state = 24},
  [150] = {.lex_state = 7, .external_lex_state = 24},
  [151] = {.lex_state = 7, .external_lex_state = 24},
  [152] = {.lex_state = 7, .external_lex_state = 24},
  [153] = {.lex_state = 0, .external_lex_state = 23},
  [154] = {.lex_state = 7, .external_lex_state = 25},
  [155] = {.lex_state = 7, .external_lex_state = 24},
  [156] = {.lex_state = 7, .external_lex_state = 16},
  [157] = {.lex_state = 7, .external_lex_state = 26},
  [158] = {.lex_state = 7, .external_lex_state = 27},
  [159] = {.lex_state = 7, .external_lex_state = 28},
  [160] = {.lex_state = 7, .external_lex_state = 29},
  [161] = {.lex_state = 7, .external_lex_state = 16},
  [162] = {.lex_state = 7, .external_lex_state = 16},
  [163] = {.lex_state = 7, .external_lex_state = 26},
  [164] = {.lex_state = 7, .external_lex_state = 27},
  [165] = {.lex_state = 7, .external_lex_state = 28},
  [166] = {.lex_state = 7, .external_lex_state = 29},
  [167] = {.lex_state = 7, .external_lex_state = 30},
  [168] = {.lex_state = 7, .external_lex_state = 16},
  [169] = {.lex_state = 7, .external_lex_state = 16},
  [170] = {.lex_state = 7, .external_lex_state = 16},
  [171] = {.lex_state = 7, .external_lex_state = 16},
  [172] = {.lex_state = 7, .external_lex_state = 16},
  [173] = {.lex_state = 7, .external_lex_state = 16},
  [174] = {.lex_state = 7, .external_lex_state = 16},
  [175] = {.lex_state = 7, .external_lex_state = 16},
  [176] = {.lex_state = 7, .external_lex_state = 16},
  [177] = {.lex_state = 7, .external_lex_state = 16},
  [178] = {.lex_state = 7, .external_lex_state = 16},
  [179] = {.lex_state = 7, .external_lex_state = 16},
  [180] = {.lex_state = 7, .external_lex_state = 16},
  [181] = {.lex_state = 7, .external_lex_state = 16},
  [182] = {.lex_state = 7, .external_lex_state = 16},
  [183] = {.lex_state = 7, .external_lex_state = 16},
  [184] = {.lex_state = 7, .external_lex_state = 16},
  [185] = {.lex_state = 7, .external_lex_state = 16},
  [186] = {.lex_state = 7, .external_lex_state = 16},
  [187] = {.lex_state = 7, .external_lex_state = 24},
  [188] = {.lex_state = 7, .external_lex_state = 24},
  [189] = {.lex_state = 7, .external_lex_state = 16},
  [190] = {.lex_state = 7, .external_lex_state = 16},
  [191] = {.lex_state = 7, .external_lex_state = 30},
  [192] = {.lex_state = 7, .external_lex_state = 30},
  [193] = {.lex_state = 7, .external_lex_state = 30},
  [194] = {.lex_state = 7, .external_lex_state = 24},
  [195] = {.lex_state = 7, .external_lex_state = 24},
  [196] = {.lex_state = 7, .external_lex_state = 24},
  [197] = {.lex_state = 7, .external_lex_state = 24},
  [198] = {.lex_state = 7, .external_lex_state = 16},
  [199] = {.lex_state = 7, .external_lex_state = 16},
  [200] = {.lex_state = 7, .external_lex_state = 17},
  [201] = {.lex_state = 7, .external_lex_state = 31},
  [202] = {.lex_state = 7, .external_lex_state = 17},
  [203] = {.lex_state = 7, .external_lex_state = 17},
  [204] = {.lex_state = 7, .external_lex_state = 17},
  [205] = {.lex_state = 7, .external_lex_state = 17},
  [206] = {.lex_state = 7, .external_lex_state = 17},
  [207] = {.lex_state = 7, .external_lex_state = 32},
  [208] = {.lex_state = 7, .external_lex_state = 32},
  [209] = {.lex_state = 7, .external_lex_state = 18},
  [210] = {.lex_state = 7, .external_lex_state = 17},
  [211] = {.lex_state = 7, .external_lex_state = 17},
  [212] = {.lex_state = 7, .external_lex_state = 17},
  [213] = {.lex_state = 7, .external_lex_state = 17},
  [214] = {.lex_state = 7, .external_lex_state = 17},
  [215] = {.lex_state = 7, .external_lex_state = 33},
  [216] = {.lex_state = 7, .external_lex_state = 24},
  [217] = {.lex_state = 7, .external_lex_state = 17},
  [218] = {.lex_state = 7, .external_lex_state = 17},
  [219] = {.lex_state = 7, .external_lex_state = 17},
  [220] = {.lex_state = 7, .external_lex_state = 17},
  [221] = {.lex_state = 7, .external_lex_state = 24},
  [222] = {.lex_state = 7, .external_lex_state = 17},
  [223] = {.lex_state = 7, .external_lex_state = 17},
  [224] = {.lex_state = 7, .external_lex_state = 33},
  [225] = {.lex_state = 7, .external_lex_state = 17},
  [226] = {.lex_state = 7, .external_lex_state = 17},
  [227] = {.lex_state = 7, .external_lex_state = 34},
  [228] = {.lex_state = 7, .external_lex_state = 17},
  [229] = {.lex_state = 7, .external_lex_state = 17},
  [230] = {.lex_state = 7, .external_lex_state = 17},
  [231] = {.lex_state = 7, .external_lex_state = 17},
  [232] = {.lex_state = 7, .external_lex_state = 17},
  [233] = {.lex_state = 7, .external_lex_state = 17},
  [234] = {.lex_state = 7, .external_lex_state = 31},
  [235] = {.lex_state = 7, .external_lex_state = 17},
  [236] = {.lex_state = 7, .external_lex_state = 34},
  [237] = {.lex_state = 7, .external_lex_state = 35},
  [238] = {.lex_state = 7, .external_lex_state = 26},
  [239] = {.lex_state = 7, .external_lex_state = 27},
  [240] = {.lex_state = 7, .external_lex_state = 27},
  [241] = {.lex_state = 3, .external_lex_state = 36},
  [242] = {.lex_state = 7, .external_lex_state = 25},
  [243] = {.lex_state = 7, .external_lex_state = 35},
  [244] = {.lex_state = 7, .external_lex_state = 28},
  [245] = {.lex_state = 7, .external_lex_state = 28},
  [246] = {.lex_state = 7, .external_lex_state = 28},
  [247] = {.lex_state = 7, .external_lex_state = 35},
  [248] = {.lex_state = 7, .external_lex_state = 28},
  [249] = {.lex_state = 7, .external_lex_state = 26},
  [250] = {.lex_state = 3, .external_lex_state = 36},
  [251] = {.lex_state = 7, .external_lex_state = 27},
  [252] = {.lex_state = 7, .external_lex_state = 29},
  [253] = {.lex_state = 7, .external_lex_state = 35},
  [254] = {.lex_state = 7, .external_lex_state = 29},
  [255] = {.lex_state = 3, .external_lex_state = 36},
  [256] = {.lex_state = 7, .external_lex_state = 26},
  [257] = {.lex_state = 7, .external_lex_state = 37},
  [258] = {.lex_state = 7, .external_lex_state = 34},
  [259] = {.lex_state = 7, .external_lex_state = 31},
  [260] = {.lex_state = 7, .external_lex_state = 31},
  [261] = {.lex_state = 7, .external_lex_state = 37},
  [262] = {.lex_state = 7, .external_lex_state = 37},
  [263] = {.lex_state = 7, .external_lex_state = 32},
  [264] = {.lex_state = 2, .external_lex_state = 23},
  [265] = {.lex_state = 7, .external_lex_state = 37},
  [266] = {.lex_state = 7, .external_lex_state = 32},
  [267] = {.lex_state = 7, .external_lex_state = 37},
  [268] = {.lex_state = 2, .external_lex_state = 23},
  [269] = {.lex_state = 2, .external_lex_state = 38},
  [270] = {.lex_state = 7, .external_lex_state = 39},
  [271] = {.lex_state = 7, .external_lex_state = 33},
  [272] = {.lex_state = 7, .external_lex_state = 31},
  [273] = {.lex_state = 7, .external_lex_state = 37},
  [274] = {.lex_state = 7, .external_lex_state = 37},
  [275] = {.lex_state = 7, .external_lex_state = 31},
  [276] = {.lex_state = 7, .external_lex_state = 37},
  [277] = {.lex_state = 7, .external_lex_state = 37},
  [278] = {.lex_state = 7, .external_lex_state = 37},
  [279] = {.lex_state = 7, .external_lex_state = 37},
  [280] = {.lex_state = 7, .external_lex_state = 37},
  [281] = {.lex_state = 7, .external_lex_state = 37},
  [282] = {.lex_state = 7, .external_lex_state = 37},
  [283] = {.lex_state = 7, .external_lex_state = 34},
  [284] = {.lex_state = 2, .external_lex_state = 38},
  [285] = {.lex_state = 7, .external_lex_state = 37},
  [286] = {.lex_state = 7, .external_lex_state = 37},
  [287] = {.lex_state = 7, .external_lex_state = 33},
  [288] = {.lex_state = 7, .external_lex_state = 37},
  [289] = {.lex_state = 7, .external_lex_state = 37},
  [290] = {.lex_state = 7, .external_lex_state = 39},
  [291] = {.lex_state = 7, .external_lex_state = 37},
  [292] = {.lex_state = 7, .external_lex_state = 30},
  [293] = {.lex_state = 7, .external_lex_state = 37},
  [294] = {.lex_state = 7, .external_lex_state = 37},
  [295] = {.lex_state = 7, .external_lex_state = 37},
  [296] = {.lex_state = 7, .external_lex_state = 37},
  [297] = {.lex_state = 7, .external_lex_state = 37},
  [298] = {.lex_state = 7, .external_lex_state = 37},
  [299] = {.lex_state = 7, .external_lex_state = 37},
  [300] = {.lex_state = 7, .external_lex_state = 37},
  [301] = {.lex_state = 7, .external_lex_state = 37},
  [302] = {.lex_state = 7, .external_lex_state = 37},
  [303] = {.lex_state = 7, .external_lex_state = 37},
  [304] = {.lex_state = 7, .external_lex_state = 37},
  [305] = {.lex_state = 7, .external_lex_state = 37},
  [306] = {.lex_state = 7, .external_lex_state = 34},
  [307] = {.lex_state = 7, .external_lex_state = 37},
  [308] = {.lex_state = 7, .external_lex_state = 37},
  [309] = {.lex_state = 7, .external_lex_state = 37},
  [310] = {.lex_state = 7, .external_lex_state = 37},
  [311] = {.lex_state = 7, .external_lex_state = 37},
  [312] = {.lex_state = 7, .external_lex_state = 33},
  [313] = {.lex_state = 7, .external_lex_state = 37},
  [314] = {.lex_state = 7, .external_lex_state = 37},
  [315] = {.lex_state = 7, .external_lex_state = 40},
  [316] = {.lex_state = 7, .external_lex_state = 40},
  [317] = {.lex_state = 7},
  [318] = {.lex_state = 7, .external_lex_state = 23},
  [319] = {.lex_state = 7, .external_lex_state = 41},
  [320] = {.lex_state = 7, .external_lex_state = 38},
  [321] = {.lex_state = 7, .external_lex_state = 40},
  [322] = {.lex_state = 7, .external_lex_state = 42},
  [323] = {.lex_state = 7, .external_lex_state = 42},
  [324] = {.lex_state = 7, .external_lex_state = 23},
  [325] = {.lex_state = 7, .external_lex_state = 23},
  [326] = {.lex_state = 7, .external_lex_state = 38},
  [327] = {.lex_state = 7, .external_lex_state = 40},
  [328] = {.lex_state = 7, .external_lex_state = 42},
  [329] = {.lex_state = 7, .external_lex_state = 38},
  [330] = {.lex_state = 7, .external_lex_state = 41},
  [331] = {.lex_state = 7, .external_lex_state = 38},
  [332] = {.lex_state = 7, .external_lex_state = 23},
  [333] = {.lex_state = 7, .external_lex_state = 41},
  [334] = {.lex_state = 7, .external_lex_state = 38},
  [335] = {.lex_state = 7, .external_lex_state = 41},
  [336] = {.lex_state = 7},
  [337] = {.lex_state = 7, .external_lex_state = 41},
  [338] = {.lex_state = 7, .external_lex_state = 43},
  [339] = {.lex_state = 7, .external_lex_state = 41},
  [340] = {.lex_state = 7, .external_lex_state = 23},
  [341] = {.lex_state = 7, .external_lex_state = 41},
  [342] = {.lex_state = 7, .external_lex_state = 41},
  [343] = {.lex_state = 7, .external_lex_state = 43},
  [344] = {.lex_state = 7, .external_lex_state = 38},
  [345] = {.lex_state = 7, .external_lex_state = 23},
  [346] = {.lex_state = 7, .external_lex_state = 44},
  [347] = {.lex_state = 7, .external_lex_state = 23},
  [348] = {.lex_state = 7},
  [349] = {.lex_state = 7, .external_lex_state = 41},
  [350] = {.lex_state = 7, .external_lex_state = 23},
  [351] = {.lex_state = 7, .external_lex_state = 41},
  [352] = {.lex_state = 7, .external_lex_state = 24},
  [353] = {.lex_state = 7},
  [354] = {.lex_state = 7, .external_lex_state = 44},
  [355] = {.lex_state = 7, .external_lex_state = 41},
  [356] = {.lex_state = 7, .external_lex_state = 38},
  [357] = {.lex_state = 7, .external_lex_state = 41},
  [358] = {.lex_state = 7, .external_lex_state = 42},
  [359] = {.lex_state = 7, .external_lex_state = 41},
  [360] = {.lex_state = 7, .external_lex_state = 43},
  [361] = {.lex_state = 7, .external_lex_state = 40},
  [362] = {.lex_state = 7, .external_lex_state = 42},
  [363] = {.lex_state = 7},
  [364] = {.lex_state = 7, .external_lex_state = 44},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_SPACE] = ACTIONS(1),
    [anon_sym_TAB] = ACTIONS(1),
    [anon_sym_VTAB] = ACTIONS(1),
    [anon_sym_FF] = ACTIONS(1),
    [anon_sym_u00a0] = ACTIONS(1),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(5),
    [sym__newline] = ACTIONS(1),
    [sym__blankline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__newline_indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym__overline] = ACTIONS(1),
    [sym__underline] = ACTIONS(1),
    [sym_transition] = ACTIONS(1),
    [sym__char_bullet] = ACTIONS(1),
    [sym__numeric_bullet] = ACTIONS(1),
    [sym__field_mark] = ACTIONS(1),
    [sym__field_mark_end] = ACTIONS(1),
    [sym__literal_indented_block_mark] = ACTIONS(1),
    [sym__literal_quoted_block_mark] = ACTIONS(1),
    [sym__quoted_literal_block] = ACTIONS(1),
    [sym__line_block_mark] = ACTIONS(1),
    [sym__attribution_mark] = ACTIONS(1),
    [sym__doctest_block_mark] = ACTIONS(1),
    [sym__text] = ACTIONS(1),
    [sym_emphasis] = ACTIONS(1),
    [sym_strong] = ACTIONS(1),
    [sym__interpreted_text] = ACTIONS(1),
    [sym__interpreted_text_prefix] = ACTIONS(1),
    [sym__role_name_prefix] = ACTIONS(1),
    [sym__role_name_suffix] = ACTIONS(1),
    [sym_literal] = ACTIONS(1),
    [sym_substitution_reference] = ACTIONS(1),
    [sym_inline_target] = ACTIONS(1),
    [sym_footnote_reference] = ACTIONS(1),
    [sym_citation_reference] = ACTIONS(1),
    [sym_reference] = ACTIONS(1),
    [sym_standalone_hyperlink] = ACTIONS(1),
    [sym__explicit_markup_start] = ACTIONS(1),
    [sym__footnote_label] = ACTIONS(1),
    [sym__citation_label] = ACTIONS(1),
    [sym__target_name] = ACTIONS(1),
    [sym__anonymous_target_mark] = ACTIONS(1),
    [sym__directive_name] = ACTIONS(1),
    [sym__substitution_mark] = ACTIONS(1),
    [sym__empty_comment] = ACTIONS(1),
    [sym__invalid_token] = ACTIONS(1),
  },
  [1] = {
    [sym_document] = STATE(353),
    [sym_section] = STATE(2),
    [sym__overline_section] = STATE(34),
    [sym__underline_section] = STATE(34),
    [sym__transition_block] = STATE(2),
    [sym__body_element_block] = STATE(2),
    [sym__body_element] = STATE(351),
    [sym_paragraph] = STATE(351),
    [sym__paragraph_line] = STATE(51),
    [sym__list] = STATE(351),
    [sym_bullet_list] = STATE(359),
    [sym__bullet_list_item] = STATE(215),
    [sym_enumerated_list] = STATE(359),
    [sym__numeric_list_item] = STATE(236),
    [sym_definition_list] = STATE(359),
    [sym__definition_list_item] = STATE(52),
    [sym_field_list] = STATE(359),
    [sym_field] = STATE(234),
    [sym__literal_block] = STATE(351),
    [sym_line_block] = STATE(351),
    [sym_line] = STATE(208),
    [sym__block_quote_block] = STATE(351),
    [sym_doctest_block] = STATE(351),
    [aux_sym__explicit_markup_block] = STATE(118),
    [sym__markup_block] = STATE(118),
    [sym_footnote] = STATE(212),
    [sym_citation] = STATE(212),
    [sym_target] = STATE(212),
    [sym__anonymous_target] = STATE(228),
    [sym_directive] = STATE(212),
    [sym_substitution_definition] = STATE(212),
    [sym_comment] = STATE(212),
    [sym__line] = STATE(346),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_document_repeat1] = STATE(2),
    [aux_sym_paragraph_repeat1] = STATE(51),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(215),
    [aux_sym_enumerated_list_repeat1] = STATE(236),
    [aux_sym_definition_list_repeat1] = STATE(52),
    [aux_sym_field_list_repeat1] = STATE(234),
    [aux_sym_line_block_repeat1] = STATE(208),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(9),
    [sym__overline] = ACTIONS(11),
    [sym_transition] = ACTIONS(13),
    [sym__char_bullet] = ACTIONS(15),
    [sym__numeric_bullet] = ACTIONS(17),
    [sym__field_mark] = ACTIONS(19),
    [sym__literal_indented_block_mark] = ACTIONS(21),
    [sym__literal_quoted_block_mark] = ACTIONS(23),
    [sym__line_block_mark] = ACTIONS(25),
    [sym__doctest_block_mark] = ACTIONS(27),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(37),
    [sym__anonymous_target_mark] = ACTIONS(39),
    [sym__empty_comment] = ACTIONS(41),
  },
  [2] = {
    [sym_section] = STATE(3),
    [sym__overline_section] = STATE(34),
    [sym__underline_section] = STATE(34),
    [sym__transition_block] = STATE(3),
    [sym__body_element_block] = STATE(3),
    [sym__body_element] = STATE(351),
    [sym_paragraph] = STATE(351),
    [sym__paragraph_line] = STATE(51),
    [sym__list] = STATE(351),
    [sym_bullet_list] = STATE(359),
    [sym__bullet_list_item] = STATE(215),
    [sym_enumerated_list] = STATE(359),
    [sym__numeric_list_item] = STATE(236),
    [sym_definition_list] = STATE(359),
    [sym__definition_list_item] = STATE(52),
    [sym_field_list] = STATE(359),
    [sym_field] = STATE(234),
    [sym__literal_block] = STATE(351),
    [sym_line_block] = STATE(351),
    [sym_line] = STATE(208),
    [sym__block_quote_block] = STATE(351),
    [sym_doctest_block] = STATE(351),
    [aux_sym__explicit_markup_block] = STATE(118),
    [sym__markup_block] = STATE(118),
    [sym_footnote] = STATE(212),
    [sym_citation] = STATE(212),
    [sym_target] = STATE(212),
    [sym__anonymous_target] = STATE(228),
    [sym_directive] = STATE(212),
    [sym_substitution_definition] = STATE(212),
    [sym_comment] = STATE(212),
    [sym__line] = STATE(346),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_document_repeat1] = STATE(3),
    [aux_sym_paragraph_repeat1] = STATE(51),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(215),
    [aux_sym_enumerated_list_repeat1] = STATE(236),
    [aux_sym_definition_list_repeat1] = STATE(52),
    [aux_sym_field_list_repeat1] = STATE(234),
    [aux_sym_line_block_repeat1] = STATE(208),
    [ts_builtin_sym_end] = ACTIONS(43),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(9),
    [sym__overline] = ACTIONS(11),
    [sym_transition] = ACTIONS(13),
    [sym__char_bullet] = ACTIONS(15),
    [sym__numeric_bullet] = ACTIONS(17),
    [sym__field_mark] = ACTIONS(19),
    [sym__literal_indented_block_mark] = ACTIONS(21),
    [sym__literal_quoted_block_mark] = ACTIONS(23),
    [sym__line_block_mark] = ACTIONS(25),
    [sym__doctest_block_mark] = ACTIONS(27),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(37),
    [sym__anonymous_target_mark] = ACTIONS(39),
    [sym__empty_comment] = ACTIONS(41),
  },
  [3] = {
    [sym_section] = STATE(3),
    [sym__overline_section] = STATE(34),
    [sym__underline_section] = STATE(34),
    [sym__transition_block] = STATE(3),
    [sym__body_element_block] = STATE(3),
    [sym__body_element] = STATE(351),
    [sym_paragraph] = STATE(351),
    [sym__paragraph_line] = STATE(51),
    [sym__list] = STATE(351),
    [sym_bullet_list] = STATE(359),
    [sym__bullet_list_item] = STATE(215),
    [sym_enumerated_list] = STATE(359),
    [sym__numeric_list_item] = STATE(236),
    [sym_definition_list] = STATE(359),
    [sym__definition_list_item] = STATE(52),
    [sym_field_list] = STATE(359),
    [sym_field] = STATE(234),
    [sym__literal_block] = STATE(351),
    [sym_line_block] = STATE(351),
    [sym_line] = STATE(208),
    [sym__block_quote_block] = STATE(351),
    [sym_doctest_block] = STATE(351),
    [aux_sym__explicit_markup_block] = STATE(118),
    [sym__markup_block] = STATE(118),
    [sym_footnote] = STATE(212),
    [sym_citation] = STATE(212),
    [sym_target] = STATE(212),
    [sym__anonymous_target] = STATE(228),
    [sym_directive] = STATE(212),
    [sym_substitution_definition] = STATE(212),
    [sym_comment] = STATE(212),
    [sym__line] = STATE(346),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_document_repeat1] = STATE(3),
    [aux_sym_paragraph_repeat1] = STATE(51),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(215),
    [aux_sym_enumerated_list_repeat1] = STATE(236),
    [aux_sym_definition_list_repeat1] = STATE(52),
    [aux_sym_field_list_repeat1] = STATE(234),
    [aux_sym_line_block_repeat1] = STATE(208),
    [ts_builtin_sym_end] = ACTIONS(45),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(47),
    [sym__overline] = ACTIONS(50),
    [sym_transition] = ACTIONS(53),
    [sym__char_bullet] = ACTIONS(56),
    [sym__numeric_bullet] = ACTIONS(59),
    [sym__field_mark] = ACTIONS(62),
    [sym__literal_indented_block_mark] = ACTIONS(65),
    [sym__literal_quoted_block_mark] = ACTIONS(68),
    [sym__line_block_mark] = ACTIONS(71),
    [sym__doctest_block_mark] = ACTIONS(74),
    [sym__text] = ACTIONS(77),
    [sym_emphasis] = ACTIONS(77),
    [sym_strong] = ACTIONS(77),
    [sym__interpreted_text] = ACTIONS(80),
    [sym__interpreted_text_prefix] = ACTIONS(83),
    [sym__role_name_prefix] = ACTIONS(86),
    [sym_literal] = ACTIONS(77),
    [sym_substitution_reference] = ACTIONS(77),
    [sym_inline_target] = ACTIONS(77),
    [sym_footnote_reference] = ACTIONS(77),
    [sym_citation_reference] = ACTIONS(77),
    [sym_reference] = ACTIONS(77),
    [sym_standalone_hyperlink] = ACTIONS(77),
    [sym__explicit_markup_start] = ACTIONS(89),
    [sym__anonymous_target_mark] = ACTIONS(92),
    [sym__empty_comment] = ACTIONS(95),
  },
  [4] = {
    [sym__body_element] = STATE(265),
    [sym_paragraph] = STATE(265),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(265),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(265),
    [sym_line_block] = STATE(265),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(265),
    [sym_block_quote] = STATE(262),
    [sym_attribution] = STATE(331),
    [sym_doctest_block] = STATE(265),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(17),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__attribution_mark] = ACTIONS(112),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [5] = {
    [sym__body_element] = STATE(261),
    [sym_paragraph] = STATE(261),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(261),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(261),
    [sym_line_block] = STATE(261),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(261),
    [sym_block_quote] = STATE(341),
    [sym_attribution] = STATE(320),
    [sym_doctest_block] = STATE(261),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(8),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__attribution_mark] = ACTIONS(112),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [6] = {
    [sym_body] = STATE(287),
    [sym__body_element] = STATE(307),
    [sym_paragraph] = STATE(307),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(307),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(307),
    [sym_line_block] = STATE(307),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(307),
    [sym_doctest_block] = STATE(307),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(23),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(122),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [7] = {
    [sym_body] = STATE(306),
    [sym__body_element] = STATE(267),
    [sym_paragraph] = STATE(267),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(267),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(267),
    [sym_line_block] = STATE(267),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(267),
    [sym_doctest_block] = STATE(267),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(28),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(124),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [8] = {
    [sym__body_element] = STATE(305),
    [sym_paragraph] = STATE(305),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(305),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(305),
    [sym_line_block] = STATE(305),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(305),
    [sym_attribution] = STATE(344),
    [sym_doctest_block] = STATE(305),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(21),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__attribution_mark] = ACTIONS(112),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [9] = {
    [sym_body] = STATE(203),
    [sym__body_element] = STATE(293),
    [sym_paragraph] = STATE(293),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(293),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(293),
    [sym_line_block] = STATE(293),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(293),
    [sym_doctest_block] = STATE(293),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(31),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(126),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [10] = {
    [sym_body] = STATE(275),
    [sym__body_element] = STATE(302),
    [sym_paragraph] = STATE(302),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(302),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(302),
    [sym_line_block] = STATE(302),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(302),
    [sym_doctest_block] = STATE(302),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(27),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(128),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [11] = {
    [sym_body] = STATE(235),
    [sym__body_element] = STATE(293),
    [sym_paragraph] = STATE(293),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(293),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(293),
    [sym_line_block] = STATE(293),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(293),
    [sym_doctest_block] = STATE(293),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(31),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(130),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [12] = {
    [sym_body] = STATE(251),
    [sym__body_element] = STATE(289),
    [sym_paragraph] = STATE(289),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(289),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(289),
    [sym_line_block] = STATE(289),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(289),
    [sym_doctest_block] = STATE(289),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(30),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(132),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [13] = {
    [sym_body] = STATE(249),
    [sym__body_element] = STATE(286),
    [sym_paragraph] = STATE(286),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(286),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(286),
    [sym_line_block] = STATE(286),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(286),
    [sym_doctest_block] = STATE(286),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(134),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [14] = {
    [sym_body] = STATE(168),
    [sym__body_element] = STATE(298),
    [sym_paragraph] = STATE(298),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(298),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(298),
    [sym_line_block] = STATE(298),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(298),
    [sym_doctest_block] = STATE(298),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(32),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(136),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [15] = {
    [sym_body] = STATE(169),
    [sym__body_element] = STATE(298),
    [sym_paragraph] = STATE(298),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(298),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(298),
    [sym_line_block] = STATE(298),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(298),
    [sym_doctest_block] = STATE(298),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(32),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(138),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [16] = {
    [sym_body] = STATE(248),
    [sym__body_element] = STATE(304),
    [sym_paragraph] = STATE(304),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(304),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(304),
    [sym_line_block] = STATE(304),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(304),
    [sym_doctest_block] = STATE(304),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(26),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(140),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [17] = {
    [sym__body_element] = STATE(273),
    [sym_paragraph] = STATE(273),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(273),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(273),
    [sym_line_block] = STATE(273),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(273),
    [sym_attribution] = STATE(329),
    [sym_doctest_block] = STATE(273),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(21),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__attribution_mark] = ACTIONS(112),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [18] = {
    [sym_body] = STATE(88),
    [sym__body_element] = STATE(300),
    [sym_paragraph] = STATE(300),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(300),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(300),
    [sym_line_block] = STATE(300),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(300),
    [sym_doctest_block] = STATE(300),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(33),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [19] = {
    [sym_body] = STATE(114),
    [sym__body_element] = STATE(296),
    [sym_paragraph] = STATE(296),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(296),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(296),
    [sym_line_block] = STATE(296),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(296),
    [sym_doctest_block] = STATE(296),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(25),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [20] = {
    [sym_body] = STATE(102),
    [sym__body_element] = STATE(296),
    [sym_paragraph] = STATE(296),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(296),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(296),
    [sym_line_block] = STATE(296),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(296),
    [sym_doctest_block] = STATE(296),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(25),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [21] = {
    [sym__body_element] = STATE(319),
    [sym_paragraph] = STATE(319),
    [sym__paragraph_line] = STATE(51),
    [sym__list] = STATE(319),
    [sym_bullet_list] = STATE(359),
    [sym__bullet_list_item] = STATE(215),
    [sym_enumerated_list] = STATE(359),
    [sym__numeric_list_item] = STATE(236),
    [sym_definition_list] = STATE(359),
    [sym__definition_list_item] = STATE(52),
    [sym_field_list] = STATE(359),
    [sym_field] = STATE(234),
    [sym__literal_block] = STATE(319),
    [sym_line_block] = STATE(319),
    [sym_line] = STATE(208),
    [sym__block_quote_block] = STATE(319),
    [sym_doctest_block] = STATE(319),
    [aux_sym__explicit_markup_block] = STATE(118),
    [sym__markup_block] = STATE(118),
    [sym_footnote] = STATE(212),
    [sym_citation] = STATE(212),
    [sym_target] = STATE(212),
    [sym__anonymous_target] = STATE(228),
    [sym_directive] = STATE(212),
    [sym_substitution_definition] = STATE(212),
    [sym_comment] = STATE(212),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(21),
    [aux_sym_paragraph_repeat1] = STATE(51),
    [aux_sym__paragraph_line_repeat1] = STATE(39),
    [aux_sym_bullet_list_repeat1] = STATE(215),
    [aux_sym_enumerated_list_repeat1] = STATE(236),
    [aux_sym_definition_list_repeat1] = STATE(52),
    [aux_sym_field_list_repeat1] = STATE(234),
    [aux_sym_line_block_repeat1] = STATE(208),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(142),
    [sym__char_bullet] = ACTIONS(145),
    [sym__numeric_bullet] = ACTIONS(148),
    [sym__field_mark] = ACTIONS(151),
    [sym__literal_indented_block_mark] = ACTIONS(154),
    [sym__literal_quoted_block_mark] = ACTIONS(157),
    [sym__line_block_mark] = ACTIONS(160),
    [sym__attribution_mark] = ACTIONS(163),
    [sym__doctest_block_mark] = ACTIONS(165),
    [sym__text] = ACTIONS(168),
    [sym_emphasis] = ACTIONS(168),
    [sym_strong] = ACTIONS(168),
    [sym__interpreted_text] = ACTIONS(171),
    [sym__interpreted_text_prefix] = ACTIONS(174),
    [sym__role_name_prefix] = ACTIONS(177),
    [sym_literal] = ACTIONS(168),
    [sym_substitution_reference] = ACTIONS(168),
    [sym_inline_target] = ACTIONS(168),
    [sym_footnote_reference] = ACTIONS(168),
    [sym_citation_reference] = ACTIONS(168),
    [sym_reference] = ACTIONS(168),
    [sym_standalone_hyperlink] = ACTIONS(168),
    [sym__explicit_markup_start] = ACTIONS(180),
    [sym__anonymous_target_mark] = ACTIONS(183),
    [sym__empty_comment] = ACTIONS(186),
  },
  [22] = {
    [sym_body] = STATE(87),
    [sym__body_element] = STATE(300),
    [sym_paragraph] = STATE(300),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(300),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(300),
    [sym_line_block] = STATE(300),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(300),
    [sym_doctest_block] = STATE(300),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(33),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [23] = {
    [sym__body_element] = STATE(313),
    [sym_paragraph] = STATE(313),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(313),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(313),
    [sym_line_block] = STATE(313),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(313),
    [sym_doctest_block] = STATE(313),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(24),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [24] = {
    [sym__body_element] = STATE(339),
    [sym_paragraph] = STATE(339),
    [sym__paragraph_line] = STATE(51),
    [sym__list] = STATE(339),
    [sym_bullet_list] = STATE(359),
    [sym__bullet_list_item] = STATE(215),
    [sym_enumerated_list] = STATE(359),
    [sym__numeric_list_item] = STATE(236),
    [sym_definition_list] = STATE(359),
    [sym__definition_list_item] = STATE(52),
    [sym_field_list] = STATE(359),
    [sym_field] = STATE(234),
    [sym__literal_block] = STATE(339),
    [sym_line_block] = STATE(339),
    [sym_line] = STATE(208),
    [sym__block_quote_block] = STATE(339),
    [sym_doctest_block] = STATE(339),
    [aux_sym__explicit_markup_block] = STATE(118),
    [sym__markup_block] = STATE(118),
    [sym_footnote] = STATE(212),
    [sym_citation] = STATE(212),
    [sym_target] = STATE(212),
    [sym__anonymous_target] = STATE(228),
    [sym_directive] = STATE(212),
    [sym_substitution_definition] = STATE(212),
    [sym_comment] = STATE(212),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(24),
    [aux_sym_paragraph_repeat1] = STATE(51),
    [aux_sym__paragraph_line_repeat1] = STATE(39),
    [aux_sym_bullet_list_repeat1] = STATE(215),
    [aux_sym_enumerated_list_repeat1] = STATE(236),
    [aux_sym_definition_list_repeat1] = STATE(52),
    [aux_sym_field_list_repeat1] = STATE(234),
    [aux_sym_line_block_repeat1] = STATE(208),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(142),
    [sym__char_bullet] = ACTIONS(145),
    [sym__numeric_bullet] = ACTIONS(148),
    [sym__field_mark] = ACTIONS(151),
    [sym__literal_indented_block_mark] = ACTIONS(154),
    [sym__literal_quoted_block_mark] = ACTIONS(157),
    [sym__line_block_mark] = ACTIONS(160),
    [sym__doctest_block_mark] = ACTIONS(165),
    [sym__text] = ACTIONS(168),
    [sym_emphasis] = ACTIONS(168),
    [sym_strong] = ACTIONS(168),
    [sym__interpreted_text] = ACTIONS(171),
    [sym__interpreted_text_prefix] = ACTIONS(174),
    [sym__role_name_prefix] = ACTIONS(177),
    [sym_literal] = ACTIONS(168),
    [sym_substitution_reference] = ACTIONS(168),
    [sym_inline_target] = ACTIONS(168),
    [sym_footnote_reference] = ACTIONS(168),
    [sym_citation_reference] = ACTIONS(168),
    [sym_reference] = ACTIONS(168),
    [sym_standalone_hyperlink] = ACTIONS(168),
    [sym__explicit_markup_start] = ACTIONS(180),
    [sym__anonymous_target_mark] = ACTIONS(183),
    [sym__empty_comment] = ACTIONS(186),
  },
  [25] = {
    [sym__body_element] = STATE(297),
    [sym_paragraph] = STATE(297),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(297),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(297),
    [sym_line_block] = STATE(297),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(297),
    [sym_doctest_block] = STATE(297),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(24),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [26] = {
    [sym__body_element] = STATE(257),
    [sym_paragraph] = STATE(257),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(257),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(257),
    [sym_line_block] = STATE(257),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(257),
    [sym_doctest_block] = STATE(257),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(24),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [27] = {
    [sym__body_element] = STATE(303),
    [sym_paragraph] = STATE(303),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(303),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(303),
    [sym_line_block] = STATE(303),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(303),
    [sym_doctest_block] = STATE(303),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(24),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [28] = {
    [sym__body_element] = STATE(274),
    [sym_paragraph] = STATE(274),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(274),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(274),
    [sym_line_block] = STATE(274),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(274),
    [sym_doctest_block] = STATE(274),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(24),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [29] = {
    [sym__body_element] = STATE(288),
    [sym_paragraph] = STATE(288),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(288),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(288),
    [sym_line_block] = STATE(288),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(288),
    [sym_doctest_block] = STATE(288),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(24),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [30] = {
    [sym__body_element] = STATE(291),
    [sym_paragraph] = STATE(291),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(291),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(291),
    [sym_line_block] = STATE(291),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(291),
    [sym_doctest_block] = STATE(291),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(24),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [31] = {
    [sym__body_element] = STATE(295),
    [sym_paragraph] = STATE(295),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(295),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(295),
    [sym_line_block] = STATE(295),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(295),
    [sym_doctest_block] = STATE(295),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(24),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [32] = {
    [sym__body_element] = STATE(299),
    [sym_paragraph] = STATE(299),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(299),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(299),
    [sym_line_block] = STATE(299),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(299),
    [sym_doctest_block] = STATE(299),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(24),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [33] = {
    [sym__body_element] = STATE(301),
    [sym_paragraph] = STATE(301),
    [sym__paragraph_line] = STATE(49),
    [sym__list] = STATE(301),
    [sym_bullet_list] = STATE(285),
    [sym__bullet_list_item] = STATE(157),
    [sym_enumerated_list] = STATE(285),
    [sym__numeric_list_item] = STATE(158),
    [sym_definition_list] = STATE(285),
    [sym__definition_list_item] = STATE(50),
    [sym_field_list] = STATE(285),
    [sym_field] = STATE(159),
    [sym__literal_block] = STATE(301),
    [sym_line_block] = STATE(301),
    [sym_line] = STATE(160),
    [sym__block_quote_block] = STATE(301),
    [sym_doctest_block] = STATE(301),
    [aux_sym__explicit_markup_block] = STATE(106),
    [sym__markup_block] = STATE(106),
    [sym_footnote] = STATE(176),
    [sym_citation] = STATE(176),
    [sym_target] = STATE(176),
    [sym__anonymous_target] = STATE(198),
    [sym_directive] = STATE(176),
    [sym_substitution_definition] = STATE(176),
    [sym_comment] = STATE(176),
    [sym__inline_markup] = STATE(80),
    [sym_interpreted_text] = STATE(77),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(24),
    [aux_sym_paragraph_repeat1] = STATE(49),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(157),
    [aux_sym_enumerated_list_repeat1] = STATE(158),
    [aux_sym_definition_list_repeat1] = STATE(50),
    [aux_sym_field_list_repeat1] = STATE(159),
    [aux_sym_line_block_repeat1] = STATE(160),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(189), 27,
      sym__indent,
      sym__overline,
      sym_transition,
      sym__char_bullet,
      sym__numeric_bullet,
      sym__field_mark,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__line_block_mark,
      sym__doctest_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
      ts_builtin_sym_end,
  [34] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(191), 27,
      sym__indent,
      sym__overline,
      sym_transition,
      sym__char_bullet,
      sym__numeric_bullet,
      sym__field_mark,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__line_block_mark,
      sym__doctest_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
      ts_builtin_sym_end,
  [68] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(193), 27,
      sym__indent,
      sym__overline,
      sym_transition,
      sym__char_bullet,
      sym__numeric_bullet,
      sym__field_mark,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__line_block_mark,
      sym__doctest_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
      ts_builtin_sym_end,
  [102] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(195), 27,
      sym__indent,
      sym__overline,
      sym_transition,
      sym__char_bullet,
      sym__numeric_bullet,
      sym__field_mark,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__line_block_mark,
      sym__doctest_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
      ts_builtin_sym_end,
  [136] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(197), 27,
      sym__indent,
      sym__overline,
      sym_transition,
      sym__char_bullet,
      sym__numeric_bullet,
      sym__field_mark,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__line_block_mark,
      sym__doctest_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
      ts_builtin_sym_end,
  [170] = 17,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(31), 1,
      sym__interpreted_text,
    ACTIONS(33), 1,
      sym__interpreted_text_prefix,
    ACTIONS(35), 1,
      sym__role_name_prefix,
    ACTIONS(199), 1,
      aux_sym__classifiers_token1,
    ACTIONS(201), 1,
      sym__newline,
    ACTIONS(203), 1,
      sym__newline_indent,
    ACTIONS(205), 1,
      sym__literal_indented_block_mark,
    ACTIONS(207), 1,
      sym__literal_quoted_block_mark,
    STATE(44), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(77), 1,
      sym_interpreted_text,
    STATE(80), 1,
      sym__inline_markup,
    STATE(241), 1,
      aux_sym__classifiers,
    STATE(325), 1,
      sym__literal_block,
    STATE(79), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(29), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [233] = 17,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(31), 1,
      sym__interpreted_text,
    ACTIONS(33), 1,
      sym__interpreted_text_prefix,
    ACTIONS(35), 1,
      sym__role_name_prefix,
    ACTIONS(199), 1,
      aux_sym__classifiers_token1,
    ACTIONS(205), 1,
      sym__literal_indented_block_mark,
    ACTIONS(207), 1,
      sym__literal_quoted_block_mark,
    ACTIONS(209), 1,
      sym__newline,
    ACTIONS(211), 1,
      sym__newline_indent,
    STATE(44), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(77), 1,
      sym_interpreted_text,
    STATE(80), 1,
      sym__inline_markup,
    STATE(255), 1,
      aux_sym__classifiers,
    STATE(324), 1,
      sym__literal_block,
    STATE(79), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(29), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [296] = 17,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(31), 1,
      sym__interpreted_text,
    ACTIONS(33), 1,
      sym__interpreted_text_prefix,
    ACTIONS(35), 1,
      sym__role_name_prefix,
    ACTIONS(199), 1,
      aux_sym__classifiers_token1,
    ACTIONS(203), 1,
      sym__newline_indent,
    ACTIONS(205), 1,
      sym__literal_indented_block_mark,
    ACTIONS(207), 1,
      sym__literal_quoted_block_mark,
    ACTIONS(213), 1,
      sym__newline,
    STATE(44), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(77), 1,
      sym_interpreted_text,
    STATE(80), 1,
      sym__inline_markup,
    STATE(241), 1,
      aux_sym__classifiers,
    STATE(325), 1,
      sym__literal_block,
    STATE(79), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(29), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [359] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(163), 25,
      sym__indent,
      sym__char_bullet,
      sym__numeric_bullet,
      sym__field_mark,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__line_block_mark,
      sym__attribution_mark,
      sym__doctest_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [391] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(163), 24,
      sym__indent,
      sym__char_bullet,
      sym__numeric_bullet,
      sym__field_mark,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__line_block_mark,
      sym__doctest_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [422] = 11,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(220), 1,
      sym__interpreted_text,
    ACTIONS(223), 1,
      sym__interpreted_text_prefix,
    ACTIONS(226), 1,
      sym__role_name_prefix,
    STATE(44), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(77), 1,
      sym_interpreted_text,
    STATE(80), 1,
      sym__inline_markup,
    STATE(79), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(215), 5,
      sym__newline,
      sym__newline_indent,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      aux_sym__classifiers_token1,
    ACTIONS(217), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [471] = 13,
    ACTIONS(205), 1,
      sym__literal_indented_block_mark,
    ACTIONS(207), 1,
      sym__literal_quoted_block_mark,
    ACTIONS(209), 1,
      sym__newline,
    ACTIONS(231), 1,
      sym__interpreted_text,
    ACTIONS(233), 1,
      sym__interpreted_text_prefix,
    ACTIONS(235), 1,
      sym__role_name_prefix,
    STATE(53), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(83), 1,
      sym__inline_markup,
    STATE(84), 1,
      sym_interpreted_text,
    STATE(324), 1,
      sym__literal_block,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(86), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(229), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [523] = 11,
    ACTIONS(242), 1,
      sym__interpreted_text,
    ACTIONS(245), 1,
      sym__interpreted_text_prefix,
    ACTIONS(248), 1,
      sym__role_name_prefix,
    STATE(45), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(83), 1,
      sym__inline_markup,
    STATE(84), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(237), 2,
      sym__blankline,
      sym__dedent,
    STATE(46), 2,
      sym__paragraph_line,
      aux_sym_paragraph_repeat1,
    STATE(86), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(239), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [571] = 11,
    ACTIONS(256), 1,
      sym__interpreted_text,
    ACTIONS(259), 1,
      sym__interpreted_text_prefix,
    ACTIONS(262), 1,
      sym__role_name_prefix,
    STATE(58), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(90), 1,
      sym_interpreted_text,
    STATE(91), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(251), 2,
      sym__blankline,
      sym__dedent,
    STATE(47), 2,
      sym__definition_list_item,
      aux_sym_definition_list_repeat1,
    STATE(92), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(253), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [619] = 13,
    ACTIONS(201), 1,
      sym__newline,
    ACTIONS(205), 1,
      sym__literal_indented_block_mark,
    ACTIONS(207), 1,
      sym__literal_quoted_block_mark,
    ACTIONS(231), 1,
      sym__interpreted_text,
    ACTIONS(233), 1,
      sym__interpreted_text_prefix,
    ACTIONS(235), 1,
      sym__role_name_prefix,
    STATE(53), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(83), 1,
      sym__inline_markup,
    STATE(84), 1,
      sym_interpreted_text,
    STATE(325), 1,
      sym__literal_block,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(86), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(229), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [671] = 11,
    ACTIONS(231), 1,
      sym__interpreted_text,
    ACTIONS(233), 1,
      sym__interpreted_text_prefix,
    ACTIONS(235), 1,
      sym__role_name_prefix,
    STATE(45), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(83), 1,
      sym__inline_markup,
    STATE(84), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(265), 2,
      sym__blankline,
      sym__dedent,
    STATE(46), 2,
      sym__paragraph_line,
      aux_sym_paragraph_repeat1,
    STATE(86), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(229), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [719] = 11,
    ACTIONS(271), 1,
      sym__interpreted_text,
    ACTIONS(273), 1,
      sym__interpreted_text_prefix,
    ACTIONS(275), 1,
      sym__role_name_prefix,
    STATE(58), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(90), 1,
      sym_interpreted_text,
    STATE(91), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(267), 2,
      sym__blankline,
      sym__dedent,
    STATE(47), 2,
      sym__definition_list_item,
      aux_sym_definition_list_repeat1,
    STATE(92), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(269), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [767] = 11,
    ACTIONS(231), 1,
      sym__interpreted_text,
    ACTIONS(233), 1,
      sym__interpreted_text_prefix,
    ACTIONS(235), 1,
      sym__role_name_prefix,
    ACTIONS(265), 1,
      sym__blankline,
    STATE(48), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(83), 1,
      sym__inline_markup,
    STATE(84), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(54), 2,
      sym__paragraph_line,
      aux_sym_paragraph_repeat1,
    STATE(86), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(229), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [814] = 11,
    ACTIONS(267), 1,
      sym__blankline,
    ACTIONS(271), 1,
      sym__interpreted_text,
    ACTIONS(273), 1,
      sym__interpreted_text_prefix,
    ACTIONS(275), 1,
      sym__role_name_prefix,
    STATE(57), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(90), 1,
      sym_interpreted_text,
    STATE(91), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(59), 2,
      sym__definition_list_item,
      aux_sym_definition_list_repeat1,
    STATE(92), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(269), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [861] = 10,
    ACTIONS(280), 1,
      sym__interpreted_text,
    ACTIONS(283), 1,
      sym__interpreted_text_prefix,
    ACTIONS(286), 1,
      sym__role_name_prefix,
    STATE(53), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(83), 1,
      sym__inline_markup,
    STATE(84), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(215), 3,
      sym__newline,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
    STATE(86), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(277), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [906] = 11,
    ACTIONS(237), 1,
      sym__blankline,
    ACTIONS(242), 1,
      sym__interpreted_text,
    ACTIONS(245), 1,
      sym__interpreted_text_prefix,
    ACTIONS(248), 1,
      sym__role_name_prefix,
    STATE(48), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(83), 1,
      sym__inline_markup,
    STATE(84), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(54), 2,
      sym__paragraph_line,
      aux_sym_paragraph_repeat1,
    STATE(86), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(239), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [953] = 11,
    ACTIONS(289), 1,
      sym__dedent,
    ACTIONS(293), 1,
      sym__interpreted_text,
    ACTIONS(295), 1,
      sym__interpreted_text_prefix,
    ACTIONS(297), 1,
      sym__role_name_prefix,
    STATE(67), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(105), 1,
      sym_interpreted_text,
    STATE(107), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(56), 2,
      sym__line,
      aux_sym_line_repeat1,
    STATE(108), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(291), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1000] = 11,
    ACTIONS(293), 1,
      sym__interpreted_text,
    ACTIONS(295), 1,
      sym__interpreted_text_prefix,
    ACTIONS(297), 1,
      sym__role_name_prefix,
    ACTIONS(299), 1,
      sym__dedent,
    STATE(67), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(105), 1,
      sym_interpreted_text,
    STATE(107), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(63), 2,
      sym__line,
      aux_sym_line_repeat1,
    STATE(108), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(291), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1047] = 13,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(199), 1,
      aux_sym__classifiers_token1,
    ACTIONS(203), 1,
      sym__newline_indent,
    ACTIONS(271), 1,
      sym__interpreted_text,
    ACTIONS(273), 1,
      sym__interpreted_text_prefix,
    ACTIONS(275), 1,
      sym__role_name_prefix,
    STATE(64), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(90), 1,
      sym_interpreted_text,
    STATE(91), 1,
      sym__inline_markup,
    STATE(241), 1,
      aux_sym__classifiers,
    STATE(92), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(269), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1098] = 13,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(199), 1,
      aux_sym__classifiers_token1,
    ACTIONS(211), 1,
      sym__newline_indent,
    ACTIONS(271), 1,
      sym__interpreted_text,
    ACTIONS(273), 1,
      sym__interpreted_text_prefix,
    ACTIONS(275), 1,
      sym__role_name_prefix,
    STATE(64), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(90), 1,
      sym_interpreted_text,
    STATE(91), 1,
      sym__inline_markup,
    STATE(255), 1,
      aux_sym__classifiers,
    STATE(92), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(269), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1149] = 11,
    ACTIONS(251), 1,
      sym__blankline,
    ACTIONS(256), 1,
      sym__interpreted_text,
    ACTIONS(259), 1,
      sym__interpreted_text_prefix,
    ACTIONS(262), 1,
      sym__role_name_prefix,
    STATE(57), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(90), 1,
      sym_interpreted_text,
    STATE(91), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(59), 2,
      sym__definition_list_item,
      aux_sym_definition_list_repeat1,
    STATE(92), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(253), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1196] = 11,
    ACTIONS(293), 1,
      sym__interpreted_text,
    ACTIONS(295), 1,
      sym__interpreted_text_prefix,
    ACTIONS(297), 1,
      sym__role_name_prefix,
    ACTIONS(301), 1,
      sym__dedent,
    STATE(67), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(105), 1,
      sym_interpreted_text,
    STATE(107), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(63), 2,
      sym__line,
      aux_sym_line_repeat1,
    STATE(108), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(291), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1243] = 11,
    ACTIONS(293), 1,
      sym__interpreted_text,
    ACTIONS(295), 1,
      sym__interpreted_text_prefix,
    ACTIONS(297), 1,
      sym__role_name_prefix,
    ACTIONS(303), 1,
      sym__dedent,
    STATE(67), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(105), 1,
      sym_interpreted_text,
    STATE(107), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(62), 2,
      sym__line,
      aux_sym_line_repeat1,
    STATE(108), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(291), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1290] = 11,
    ACTIONS(293), 1,
      sym__interpreted_text,
    ACTIONS(295), 1,
      sym__interpreted_text_prefix,
    ACTIONS(297), 1,
      sym__role_name_prefix,
    ACTIONS(305), 1,
      sym__dedent,
    STATE(67), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(105), 1,
      sym_interpreted_text,
    STATE(107), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(63), 2,
      sym__line,
      aux_sym_line_repeat1,
    STATE(108), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(291), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1337] = 11,
    ACTIONS(307), 1,
      sym__dedent,
    ACTIONS(312), 1,
      sym__interpreted_text,
    ACTIONS(315), 1,
      sym__interpreted_text_prefix,
    ACTIONS(318), 1,
      sym__role_name_prefix,
    STATE(67), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(105), 1,
      sym_interpreted_text,
    STATE(107), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(63), 2,
      sym__line,
      aux_sym_line_repeat1,
    STATE(108), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(309), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1384] = 11,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(324), 1,
      sym__interpreted_text,
    ACTIONS(327), 1,
      sym__interpreted_text_prefix,
    ACTIONS(330), 1,
      sym__role_name_prefix,
    STATE(64), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(90), 1,
      sym_interpreted_text,
    STATE(91), 1,
      sym__inline_markup,
    ACTIONS(215), 2,
      sym__newline_indent,
      aux_sym__classifiers_token1,
    STATE(92), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(321), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1430] = 10,
    ACTIONS(293), 1,
      sym__interpreted_text,
    ACTIONS(295), 1,
      sym__interpreted_text_prefix,
    ACTIONS(297), 1,
      sym__role_name_prefix,
    STATE(67), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(105), 1,
      sym_interpreted_text,
    STATE(107), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(60), 2,
      sym__line,
      aux_sym_line_repeat1,
    STATE(108), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(291), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1474] = 11,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(271), 1,
      sym__interpreted_text,
    ACTIONS(273), 1,
      sym__interpreted_text_prefix,
    ACTIONS(275), 1,
      sym__role_name_prefix,
    STATE(64), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(90), 1,
      sym_interpreted_text,
    STATE(91), 1,
      sym__inline_markup,
    ACTIONS(333), 2,
      sym__newline_indent,
      aux_sym__classifiers_token1,
    STATE(92), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(269), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1520] = 10,
    ACTIONS(293), 1,
      sym__interpreted_text,
    ACTIONS(295), 1,
      sym__interpreted_text_prefix,
    ACTIONS(297), 1,
      sym__role_name_prefix,
    ACTIONS(335), 1,
      sym__newline,
    STATE(68), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(105), 1,
      sym_interpreted_text,
    STATE(107), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(108), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(291), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1563] = 10,
    ACTIONS(215), 1,
      sym__newline,
    ACTIONS(340), 1,
      sym__interpreted_text,
    ACTIONS(343), 1,
      sym__interpreted_text_prefix,
    ACTIONS(346), 1,
      sym__role_name_prefix,
    STATE(68), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(105), 1,
      sym_interpreted_text,
    STATE(107), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(108), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(337), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1606] = 10,
    ACTIONS(215), 1,
      sym__field_mark_end,
    ACTIONS(352), 1,
      sym__interpreted_text,
    ACTIONS(355), 1,
      sym__interpreted_text_prefix,
    ACTIONS(358), 1,
      sym__role_name_prefix,
    STATE(69), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(99), 1,
      sym__inline_markup,
    STATE(100), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(117), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(349), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1649] = 10,
    ACTIONS(293), 1,
      sym__interpreted_text,
    ACTIONS(295), 1,
      sym__interpreted_text_prefix,
    ACTIONS(297), 1,
      sym__role_name_prefix,
    ACTIONS(361), 1,
      sym__newline,
    STATE(68), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(105), 1,
      sym_interpreted_text,
    STATE(107), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(108), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(291), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1692] = 10,
    ACTIONS(363), 1,
      sym__field_mark_end,
    ACTIONS(367), 1,
      sym__interpreted_text,
    ACTIONS(369), 1,
      sym__interpreted_text_prefix,
    ACTIONS(371), 1,
      sym__role_name_prefix,
    STATE(69), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(99), 1,
      sym__inline_markup,
    STATE(100), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(117), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(365), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1735] = 10,
    ACTIONS(367), 1,
      sym__interpreted_text,
    ACTIONS(369), 1,
      sym__interpreted_text_prefix,
    ACTIONS(371), 1,
      sym__role_name_prefix,
    ACTIONS(373), 1,
      sym__field_mark_end,
    STATE(69), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(99), 1,
      sym__inline_markup,
    STATE(100), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(117), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(365), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1778] = 10,
    ACTIONS(293), 1,
      sym__interpreted_text,
    ACTIONS(295), 1,
      sym__interpreted_text_prefix,
    ACTIONS(297), 1,
      sym__role_name_prefix,
    STATE(70), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(105), 1,
      sym_interpreted_text,
    STATE(107), 1,
      sym__inline_markup,
    STATE(364), 1,
      sym__line,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(108), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(291), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1821] = 9,
    ACTIONS(367), 1,
      sym__interpreted_text,
    ACTIONS(369), 1,
      sym__interpreted_text_prefix,
    ACTIONS(371), 1,
      sym__role_name_prefix,
    STATE(72), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(99), 1,
      sym__inline_markup,
    STATE(100), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(117), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(365), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1861] = 9,
    ACTIONS(271), 1,
      sym__interpreted_text,
    ACTIONS(273), 1,
      sym__interpreted_text_prefix,
    ACTIONS(275), 1,
      sym__role_name_prefix,
    STATE(66), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(90), 1,
      sym_interpreted_text,
    STATE(91), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(92), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(269), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1901] = 9,
    ACTIONS(367), 1,
      sym__interpreted_text,
    ACTIONS(369), 1,
      sym__interpreted_text_prefix,
    ACTIONS(371), 1,
      sym__role_name_prefix,
    STATE(71), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(99), 1,
      sym__inline_markup,
    STATE(100), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(117), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(365), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1941] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(375), 18,
      sym__newline,
      sym__newline_indent,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [1968] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(377), 18,
      sym__newline,
      sym__newline_indent,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [1995] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(379), 18,
      sym__newline,
      sym__newline_indent,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [2022] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(381), 18,
      sym__newline,
      sym__newline_indent,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [2049] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(383), 18,
      sym__newline,
      sym__newline_indent,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [2076] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(377), 16,
      sym__newline,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2099] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(381), 16,
      sym__newline,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2122] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(375), 16,
      sym__newline,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2145] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(383), 16,
      sym__newline,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2168] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(379), 16,
      sym__newline,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2191] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(385), 15,
      sym__blankline,
      sym__dedent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2213] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(387), 15,
      sym__blankline,
      sym__dedent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2235] = 3,
    ACTIONS(391), 1,
      sym__underline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(389), 14,
      sym__blankline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2259] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(375), 15,
      sym__newline_indent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [2283] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(381), 15,
      sym__newline_indent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [2307] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(379), 15,
      sym__newline_indent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [2331] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(383), 15,
      sym__newline_indent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [2355] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(377), 15,
      sym__newline_indent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [2379] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(393), 15,
      sym__blankline,
      sym__dedent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2401] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 15,
      sym__blankline,
      sym__dedent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2423] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(389), 15,
      sym__blankline,
      sym__dedent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2445] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(397), 15,
      sym__blankline,
      sym__dedent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2467] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(381), 14,
      sym__field_mark_end,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2488] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(375), 14,
      sym__field_mark_end,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2509] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(397), 14,
      sym__blankline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2530] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(387), 14,
      sym__blankline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2551] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(393), 14,
      sym__blankline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2572] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 14,
      sym__blankline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2593] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(375), 14,
      sym__newline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2614] = 8,
    ACTIONS(116), 1,
      sym__explicit_markup_start,
    ACTIONS(118), 1,
      sym__anonymous_target_mark,
    ACTIONS(120), 1,
      sym__empty_comment,
    STATE(198), 1,
      sym__anonymous_target,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(399), 2,
      sym__blankline,
      sym__dedent,
    STATE(111), 2,
      aux_sym__explicit_markup_block,
      sym__markup_block,
    STATE(176), 6,
      sym_footnote,
      sym_citation,
      sym_target,
      sym_directive,
      sym_substitution_definition,
      sym_comment,
  [2647] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(381), 14,
      sym__newline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2668] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(379), 14,
      sym__newline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2689] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(383), 14,
      sym__newline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2710] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(377), 14,
      sym__newline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2731] = 8,
    ACTIONS(403), 1,
      sym__explicit_markup_start,
    ACTIONS(406), 1,
      sym__anonymous_target_mark,
    ACTIONS(409), 1,
      sym__empty_comment,
    STATE(198), 1,
      sym__anonymous_target,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(401), 2,
      sym__blankline,
      sym__dedent,
    STATE(111), 2,
      aux_sym__explicit_markup_block,
      sym__markup_block,
    STATE(176), 6,
      sym_footnote,
      sym_citation,
      sym_target,
      sym_directive,
      sym_substitution_definition,
      sym_comment,
  [2764] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(389), 14,
      sym__blankline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2785] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(391), 14,
      sym__dedent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2806] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(385), 14,
      sym__blankline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2827] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(377), 14,
      sym__field_mark_end,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2848] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(383), 14,
      sym__field_mark_end,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2869] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(379), 14,
      sym__field_mark_end,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2890] = 8,
    ACTIONS(37), 1,
      sym__explicit_markup_start,
    ACTIONS(39), 1,
      sym__anonymous_target_mark,
    ACTIONS(41), 1,
      sym__empty_comment,
    ACTIONS(399), 1,
      sym__blankline,
    STATE(228), 1,
      sym__anonymous_target,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(119), 2,
      aux_sym__explicit_markup_block,
      sym__markup_block,
    STATE(212), 6,
      sym_footnote,
      sym_citation,
      sym_target,
      sym_directive,
      sym_substitution_definition,
      sym_comment,
  [2922] = 8,
    ACTIONS(401), 1,
      sym__blankline,
    ACTIONS(412), 1,
      sym__explicit_markup_start,
    ACTIONS(415), 1,
      sym__anonymous_target_mark,
    ACTIONS(418), 1,
      sym__empty_comment,
    STATE(228), 1,
      sym__anonymous_target,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(119), 2,
      aux_sym__explicit_markup_block,
      sym__markup_block,
    STATE(212), 6,
      sym_footnote,
      sym_citation,
      sym_target,
      sym_directive,
      sym_substitution_definition,
      sym_comment,
  [2954] = 11,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(421), 1,
      sym__blankline,
    ACTIONS(423), 1,
      sym__dedent,
    ACTIONS(425), 1,
      sym__text,
    STATE(194), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(220), 1,
      sym__indented_text_block,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    STATE(294), 1,
      sym_field_list,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(154), 2,
      aux_sym__text_block,
      sym__text_line,
    STATE(159), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [2991] = 11,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(427), 1,
      sym__blankline,
    ACTIONS(429), 1,
      sym__dedent,
    STATE(177), 1,
      sym__indented_text_block,
    STATE(196), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    STATE(282), 1,
      sym_field_list,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(139), 2,
      aux_sym__text_block,
      sym__text_line,
    STATE(159), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [3028] = 12,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(431), 1,
      sym__dedent,
    ACTIONS(433), 1,
      sym__footnote_label,
    ACTIONS(435), 1,
      sym__citation_label,
    ACTIONS(437), 1,
      sym__target_name,
    ACTIONS(439), 1,
      sym__directive_name,
    ACTIONS(441), 1,
      sym__substitution_mark,
    STATE(194), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(213), 1,
      sym__indented_text_block,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(154), 2,
      aux_sym__text_block,
      sym__text_line,
  [3067] = 12,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(443), 1,
      sym__dedent,
    ACTIONS(445), 1,
      sym__footnote_label,
    ACTIONS(447), 1,
      sym__citation_label,
    ACTIONS(449), 1,
      sym__target_name,
    ACTIONS(451), 1,
      sym__directive_name,
    ACTIONS(453), 1,
      sym__substitution_mark,
    STATE(161), 1,
      sym__indented_text_block,
    STATE(196), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(139), 2,
      aux_sym__text_block,
      sym__text_line,
  [3106] = 11,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(455), 1,
      sym__newline,
    ACTIONS(457), 1,
      sym__blankline,
    ACTIONS(459), 1,
      sym__dedent,
    ACTIONS(461), 1,
      sym__text,
    STATE(121), 1,
      sym__text_line,
    STATE(182), 1,
      sym__directive_body,
    STATE(253), 1,
      aux_sym__text_line_repeat1,
    STATE(279), 1,
      sym_field_list,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(159), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [3142] = 11,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(461), 1,
      sym__text,
    ACTIONS(463), 1,
      sym__newline,
    ACTIONS(465), 1,
      sym__blankline,
    ACTIONS(467), 1,
      sym__dedent,
    STATE(120), 1,
      sym__text_line,
    STATE(231), 1,
      sym__directive_body,
    STATE(253), 1,
      aux_sym__text_line_repeat1,
    STATE(281), 1,
      sym_field_list,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(159), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [3178] = 11,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(455), 1,
      sym__newline,
    ACTIONS(457), 1,
      sym__blankline,
    ACTIONS(461), 1,
      sym__text,
    ACTIONS(469), 1,
      sym__dedent,
    STATE(121), 1,
      sym__text_line,
    STATE(173), 1,
      sym__directive_body,
    STATE(253), 1,
      aux_sym__text_line_repeat1,
    STATE(279), 1,
      sym_field_list,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(159), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [3214] = 11,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(461), 1,
      sym__text,
    ACTIONS(463), 1,
      sym__newline,
    ACTIONS(465), 1,
      sym__blankline,
    ACTIONS(471), 1,
      sym__dedent,
    STATE(120), 1,
      sym__text_line,
    STATE(214), 1,
      sym__directive_body,
    STATE(253), 1,
      aux_sym__text_line_repeat1,
    STATE(281), 1,
      sym_field_list,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(159), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [3250] = 9,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(425), 1,
      sym__text,
    STATE(174), 1,
      sym__indented_text_block,
    STATE(196), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    STATE(280), 1,
      sym_field_list,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(139), 2,
      aux_sym__text_block,
      sym__text_line,
    STATE(159), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [3281] = 9,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(425), 1,
      sym__text,
    STATE(194), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(217), 1,
      sym__indented_text_block,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    STATE(314), 1,
      sym_field_list,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(154), 2,
      aux_sym__text_block,
      sym__text_line,
    STATE(159), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [3312] = 7,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(473), 1,
      sym__dedent,
    STATE(188), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    STATE(337), 1,
      sym__indented_text_block,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(143), 2,
      aux_sym__text_block,
      sym__text_line,
  [3336] = 7,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(475), 1,
      sym__dedent,
    STATE(197), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    STATE(350), 1,
      sym__indented_text_block,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(141), 2,
      aux_sym__text_block,
      sym__text_line,
  [3360] = 7,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(477), 1,
      sym__dedent,
    STATE(195), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    STATE(277), 1,
      sym__indented_text_block,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(137), 2,
      aux_sym__text_block,
      sym__text_line,
  [3384] = 4,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(481), 1,
      sym__newline,
    ACTIONS(479), 5,
      anon_sym_SPACE,
      anon_sym_TAB,
      anon_sym_VTAB,
      anon_sym_FF,
      anon_sym_u00a0,
  [3401] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(183), 1,
      sym__indented_text_block,
    STATE(196), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(139), 2,
      aux_sym__text_block,
      sym__text_line,
  [3422] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(184), 1,
      sym__indented_text_block,
    STATE(196), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(139), 2,
      aux_sym__text_block,
      sym__text_line,
  [3443] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(194), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(226), 1,
      sym__indented_text_block,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(154), 2,
      aux_sym__text_block,
      sym__text_line,
  [3464] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(485), 1,
      sym__dedent,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(145), 2,
      aux_sym__text_block,
      sym__text_line,
  [3485] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(487), 1,
      sym__dedent,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(145), 2,
      aux_sym__text_block,
      sym__text_line,
  [3506] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(489), 1,
      sym__dedent,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(145), 2,
      aux_sym__text_block,
      sym__text_line,
  [3527] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(491), 1,
      sym__dedent,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(145), 2,
      aux_sym__text_block,
      sym__text_line,
  [3548] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(493), 1,
      sym__dedent,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(145), 2,
      aux_sym__text_block,
      sym__text_line,
  [3569] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(495), 1,
      sym__dedent,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(145), 2,
      aux_sym__text_block,
      sym__text_line,
  [3590] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(497), 1,
      sym__dedent,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(145), 2,
      aux_sym__text_block,
      sym__text_line,
  [3611] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(194), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(225), 1,
      sym__indented_text_block,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(154), 2,
      aux_sym__text_block,
      sym__text_line,
  [3632] = 5,
    ACTIONS(501), 1,
      sym__text,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(499), 2,
      sym__blankline,
      sym__dedent,
    STATE(145), 2,
      aux_sym__text_block,
      sym__text_line,
  [3651] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(174), 1,
      sym__indented_text_block,
    STATE(196), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(139), 2,
      aux_sym__text_block,
      sym__text_line,
  [3672] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(504), 1,
      sym__dedent,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(145), 2,
      aux_sym__text_block,
      sym__text_line,
  [3693] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(506), 1,
      sym__dedent,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(145), 2,
      aux_sym__text_block,
      sym__text_line,
  [3714] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(194), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(232), 1,
      sym__indented_text_block,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(154), 2,
      aux_sym__text_block,
      sym__text_line,
  [3735] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(179), 1,
      sym__indented_text_block,
    STATE(196), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(139), 2,
      aux_sym__text_block,
      sym__text_line,
  [3756] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(180), 1,
      sym__indented_text_block,
    STATE(196), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(139), 2,
      aux_sym__text_block,
      sym__text_line,
  [3777] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(194), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(200), 1,
      sym__indented_text_block,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(154), 2,
      aux_sym__text_block,
      sym__text_line,
  [3798] = 4,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(510), 1,
      sym__newline,
    ACTIONS(508), 5,
      anon_sym_SPACE,
      anon_sym_TAB,
      anon_sym_VTAB,
      anon_sym_FF,
      anon_sym_u00a0,
  [3815] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(512), 1,
      sym__dedent,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(145), 2,
      aux_sym__text_block,
      sym__text_line,
  [3836] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(194), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(217), 1,
      sym__indented_text_block,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(154), 2,
      aux_sym__text_block,
      sym__text_line,
  [3857] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(514), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [3869] = 4,
    ACTIONS(100), 1,
      sym__char_bullet,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(516), 2,
      sym__blankline,
      sym__dedent,
    STATE(163), 2,
      sym__bullet_list_item,
      aux_sym_bullet_list_repeat1,
  [3885] = 4,
    ACTIONS(102), 1,
      sym__numeric_bullet,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(518), 2,
      sym__blankline,
      sym__dedent,
    STATE(164), 2,
      sym__numeric_list_item,
      aux_sym_enumerated_list_repeat1,
  [3901] = 4,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(520), 2,
      sym__blankline,
      sym__dedent,
    STATE(165), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [3917] = 4,
    ACTIONS(110), 1,
      sym__line_block_mark,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(522), 2,
      sym__blankline,
      sym__dedent,
    STATE(166), 2,
      sym_line,
      aux_sym_line_block_repeat1,
  [3933] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(524), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [3945] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(526), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [3957] = 4,
    ACTIONS(530), 1,
      sym__char_bullet,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(528), 2,
      sym__blankline,
      sym__dedent,
    STATE(163), 2,
      sym__bullet_list_item,
      aux_sym_bullet_list_repeat1,
  [3973] = 4,
    ACTIONS(535), 1,
      sym__numeric_bullet,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(533), 2,
      sym__blankline,
      sym__dedent,
    STATE(164), 2,
      sym__numeric_list_item,
      aux_sym_enumerated_list_repeat1,
  [3989] = 4,
    ACTIONS(540), 1,
      sym__field_mark,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(538), 2,
      sym__blankline,
      sym__dedent,
    STATE(165), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [4005] = 4,
    ACTIONS(545), 1,
      sym__line_block_mark,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(543), 2,
      sym__blankline,
      sym__dedent,
    STATE(166), 2,
      sym_line,
      aux_sym_line_block_repeat1,
  [4021] = 5,
    ACTIONS(499), 1,
      sym__blankline,
    ACTIONS(548), 1,
      sym__text,
    STATE(237), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(167), 2,
      aux_sym__text_block,
      sym__text_line,
  [4039] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(551), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4051] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(553), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4063] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(555), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4075] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(557), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4087] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(559), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4099] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(561), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4111] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(563), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4123] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(565), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4135] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(567), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4147] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(569), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4159] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(571), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4171] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(573), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4183] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(575), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4195] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(577), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4207] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(579), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4219] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(581), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4231] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(583), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4243] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(585), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4255] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(587), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4267] = 5,
    ACTIONS(589), 1,
      sym__text,
    STATE(187), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(237), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(193), 2,
      aux_sym__text_block,
      sym__text_line,
  [4285] = 5,
    ACTIONS(425), 1,
      sym__text,
    STATE(187), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(147), 2,
      aux_sym__text_block,
      sym__text_line,
  [4303] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(393), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4315] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4327] = 5,
    ACTIONS(592), 1,
      sym__blankline,
    ACTIONS(594), 1,
      sym__text,
    STATE(237), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(167), 2,
      aux_sym__text_block,
      sym__text_line,
  [4345] = 5,
    ACTIONS(594), 1,
      sym__text,
    ACTIONS(596), 1,
      sym__blankline,
    STATE(237), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(167), 2,
      aux_sym__text_block,
      sym__text_line,
  [4363] = 5,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(594), 1,
      sym__text,
    STATE(237), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(167), 2,
      aux_sym__text_block,
      sym__text_line,
  [4381] = 5,
    ACTIONS(425), 1,
      sym__text,
    STATE(187), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(148), 2,
      aux_sym__text_block,
      sym__text_line,
  [4399] = 5,
    ACTIONS(425), 1,
      sym__text,
    STATE(187), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(138), 2,
      aux_sym__text_block,
      sym__text_line,
  [4417] = 5,
    ACTIONS(425), 1,
      sym__text,
    STATE(187), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(140), 2,
      aux_sym__text_block,
      sym__text_line,
  [4435] = 5,
    ACTIONS(425), 1,
      sym__text,
    STATE(187), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(142), 2,
      aux_sym__text_block,
      sym__text_line,
  [4453] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(598), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4465] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(600), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4477] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(583), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4488] = 4,
    ACTIONS(538), 1,
      sym__blankline,
    ACTIONS(602), 1,
      sym__field_mark,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(201), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [4503] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(585), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4514] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(553), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4525] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(555), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4536] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(557), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4547] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(514), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4558] = 4,
    ACTIONS(543), 1,
      sym__blankline,
    ACTIONS(605), 1,
      sym__line_block_mark,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(207), 2,
      sym_line,
      aux_sym_line_block_repeat1,
  [4573] = 4,
    ACTIONS(25), 1,
      sym__line_block_mark,
    ACTIONS(522), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(207), 2,
      sym_line,
      aux_sym_line_block_repeat1,
  [4588] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(608), 4,
      sym__blankline,
      sym__dedent,
      sym__field_mark,
      sym__text,
  [4599] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(587), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4610] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(559), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4621] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(567), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4632] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(524), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4643] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(561), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4654] = 4,
    ACTIONS(15), 1,
      sym__char_bullet,
    ACTIONS(516), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(224), 2,
      sym__bullet_list_item,
      aux_sym_bullet_list_repeat1,
  [4669] = 4,
    ACTIONS(594), 1,
      sym__text,
    STATE(237), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(191), 2,
      aux_sym__text_block,
      sym__text_line,
  [4684] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(563), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4695] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(565), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4706] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(600), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4717] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(569), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4728] = 4,
    ACTIONS(594), 1,
      sym__text,
    STATE(237), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(192), 2,
      aux_sym__text_block,
      sym__text_line,
  [4743] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(526), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4754] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(571), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4765] = 4,
    ACTIONS(528), 1,
      sym__blankline,
    ACTIONS(610), 1,
      sym__char_bullet,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(224), 2,
      sym__bullet_list_item,
      aux_sym_bullet_list_repeat1,
  [4780] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(573), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4791] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(575), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4802] = 4,
    ACTIONS(533), 1,
      sym__blankline,
    ACTIONS(613), 1,
      sym__numeric_bullet,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(227), 2,
      sym__numeric_list_item,
      aux_sym_enumerated_list_repeat1,
  [4817] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(598), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4828] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(577), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4839] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(393), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4850] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(579), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4861] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(581), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4872] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4883] = 4,
    ACTIONS(19), 1,
      sym__field_mark,
    ACTIONS(520), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(201), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [4898] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(551), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4909] = 4,
    ACTIONS(17), 1,
      sym__numeric_bullet,
    ACTIONS(518), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(227), 2,
      sym__numeric_list_item,
      aux_sym_enumerated_list_repeat1,
  [4924] = 4,
    ACTIONS(616), 1,
      sym__newline,
    ACTIONS(618), 1,
      sym__text,
    STATE(243), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [4938] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 3,
      sym__blankline,
      sym__dedent,
      sym__char_bullet,
  [4948] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(393), 3,
      sym__blankline,
      sym__dedent,
      sym__numeric_bullet,
  [4958] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 3,
      sym__blankline,
      sym__dedent,
      sym__numeric_bullet,
  [4968] = 5,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(199), 1,
      aux_sym__classifiers_token1,
    ACTIONS(620), 1,
      sym__newline_indent,
    STATE(250), 1,
      aux_sym__classifiers,
  [4984] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(608), 3,
      sym__blankline,
      sym__dedent,
      sym__text,
  [4994] = 4,
    ACTIONS(622), 1,
      sym__newline,
    ACTIONS(624), 1,
      sym__text,
    STATE(243), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5008] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(627), 3,
      sym__blankline,
      sym__dedent,
      sym__field_mark,
  [5018] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(393), 3,
      sym__blankline,
      sym__dedent,
      sym__field_mark,
  [5028] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 3,
      sym__blankline,
      sym__dedent,
      sym__field_mark,
  [5038] = 4,
    ACTIONS(618), 1,
      sym__text,
    ACTIONS(629), 1,
      sym__newline,
    STATE(243), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5052] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(631), 3,
      sym__blankline,
      sym__dedent,
      sym__field_mark,
  [5062] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(633), 3,
      sym__blankline,
      sym__dedent,
      sym__char_bullet,
  [5072] = 5,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(635), 1,
      aux_sym__classifiers_token1,
    ACTIONS(638), 1,
      sym__newline_indent,
    STATE(250), 1,
      aux_sym__classifiers,
  [5088] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(640), 3,
      sym__blankline,
      sym__dedent,
      sym__numeric_bullet,
  [5098] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(642), 3,
      sym__blankline,
      sym__dedent,
      sym__line_block_mark,
  [5108] = 4,
    ACTIONS(618), 1,
      sym__text,
    ACTIONS(644), 1,
      sym__newline,
    STATE(243), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5122] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(646), 3,
      sym__blankline,
      sym__dedent,
      sym__line_block_mark,
  [5132] = 5,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(199), 1,
      aux_sym__classifiers_token1,
    ACTIONS(648), 1,
      sym__newline_indent,
    STATE(250), 1,
      aux_sym__classifiers,
  [5148] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(393), 3,
      sym__blankline,
      sym__dedent,
      sym__char_bullet,
  [5158] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(652), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5169] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 2,
      sym__blankline,
      sym__numeric_bullet,
  [5178] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(393), 2,
      sym__blankline,
      sym__field_mark,
  [5187] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 2,
      sym__blankline,
      sym__field_mark,
  [5196] = 3,
    ACTIONS(654), 1,
      sym__blankline,
    ACTIONS(656), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5207] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(658), 2,
      sym__blankline,
      sym__dedent,
  [5216] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(642), 2,
      sym__blankline,
      sym__line_block_mark,
  [5225] = 4,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(660), 1,
      aux_sym_target_token1,
    ACTIONS(662), 1,
      sym__newline,
  [5238] = 3,
    ACTIONS(654), 1,
      sym__blankline,
    ACTIONS(664), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5249] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(646), 2,
      sym__blankline,
      sym__line_block_mark,
  [5258] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(666), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5269] = 4,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(668), 1,
      aux_sym_target_token1,
    ACTIONS(670), 1,
      sym__newline,
  [5282] = 4,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(672), 1,
      aux_sym_target_token1,
    ACTIONS(674), 1,
      sym__dedent,
  [5295] = 3,
    ACTIONS(676), 1,
      sym__directive_name,
    STATE(171), 1,
      sym__embedded_directive,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5306] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 2,
      sym__blankline,
      sym__char_bullet,
  [5315] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(627), 2,
      sym__blankline,
      sym__field_mark,
  [5324] = 3,
    ACTIONS(654), 1,
      sym__blankline,
    ACTIONS(678), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5335] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(680), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5346] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(631), 2,
      sym__blankline,
      sym__field_mark,
  [5355] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(682), 2,
      sym__blankline,
      sym__dedent,
  [5364] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(684), 2,
      sym__blankline,
      sym__dedent,
  [5373] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(686), 2,
      sym__blankline,
      sym__dedent,
  [5382] = 3,
    ACTIONS(688), 1,
      sym__blankline,
    ACTIONS(690), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5393] = 3,
    ACTIONS(692), 1,
      sym__blankline,
    ACTIONS(694), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5404] = 3,
    ACTIONS(696), 1,
      sym__blankline,
    ACTIONS(698), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5415] = 3,
    ACTIONS(700), 1,
      sym__blankline,
    ACTIONS(702), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5426] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(393), 2,
      sym__blankline,
      sym__numeric_bullet,
  [5435] = 4,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(704), 1,
      aux_sym_target_token1,
    ACTIONS(706), 1,
      sym__dedent,
  [5448] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(708), 2,
      sym__blankline,
      sym__dedent,
  [5457] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(710), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5468] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(633), 2,
      sym__blankline,
      sym__char_bullet,
  [5477] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(712), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5488] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(714), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5499] = 3,
    ACTIONS(716), 1,
      sym__directive_name,
    STATE(205), 1,
      sym__embedded_directive,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5510] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(718), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5521] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(608), 2,
      sym__blankline,
      sym__text,
  [5530] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(720), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5541] = 3,
    ACTIONS(722), 1,
      sym__blankline,
    ACTIONS(724), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5552] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(726), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5563] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(728), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5574] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(730), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5585] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(732), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5596] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(734), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5607] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(736), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5618] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(738), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5629] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(740), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5640] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(742), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5651] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(744), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5662] = 3,
    ACTIONS(654), 1,
      sym__blankline,
    ACTIONS(746), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5673] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(640), 2,
      sym__blankline,
      sym__numeric_bullet,
  [5682] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(748), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5693] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(585), 2,
      sym__blankline,
      sym__dedent,
  [5702] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(750), 2,
      sym__blankline,
      sym__dedent,
  [5711] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(752), 2,
      sym__blankline,
      sym__dedent,
  [5720] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(587), 2,
      sym__blankline,
      sym__dedent,
  [5729] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(393), 2,
      sym__blankline,
      sym__char_bullet,
  [5738] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(754), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5749] = 3,
    ACTIONS(756), 1,
      sym__blankline,
    ACTIONS(758), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5760] = 2,
    ACTIONS(760), 1,
      sym__role_name_suffix,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5768] = 2,
    ACTIONS(762), 1,
      sym__role_name_suffix,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5776] = 2,
    ACTIONS(764), 1,
      anon_sym_COLON_COLON,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5784] = 2,
    ACTIONS(766), 1,
      sym__newline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5792] = 2,
    ACTIONS(654), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5800] = 2,
    ACTIONS(656), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5808] = 2,
    ACTIONS(768), 1,
      sym__role_name_suffix,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5816] = 2,
    ACTIONS(770), 1,
      sym__interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5824] = 2,
    ACTIONS(772), 1,
      sym__interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5832] = 2,
    ACTIONS(774), 1,
      sym__newline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5840] = 2,
    ACTIONS(776), 1,
      sym__newline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5848] = 2,
    ACTIONS(778), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5856] = 2,
    ACTIONS(780), 1,
      sym__role_name_suffix,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5864] = 2,
    ACTIONS(782), 1,
      sym__interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5872] = 2,
    ACTIONS(678), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5880] = 2,
    ACTIONS(585), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5888] = 2,
    ACTIONS(664), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5896] = 2,
    ACTIONS(587), 1,
      sym__newline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5904] = 2,
    ACTIONS(587), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5912] = 2,
    ACTIONS(784), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5920] = 2,
    ACTIONS(786), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5928] = 2,
    ACTIONS(788), 1,
      anon_sym_COLON_COLON,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5936] = 2,
    ACTIONS(684), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5944] = 2,
    ACTIONS(790), 1,
      sym__quoted_literal_block,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5952] = 2,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5960] = 2,
    ACTIONS(585), 1,
      sym__newline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5968] = 2,
    ACTIONS(658), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5976] = 2,
    ACTIONS(682), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5984] = 2,
    ACTIONS(792), 1,
      sym__quoted_literal_block,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5992] = 2,
    ACTIONS(746), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6000] = 2,
    ACTIONS(794), 1,
      sym__newline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6008] = 2,
    ACTIONS(796), 1,
      sym__underline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6016] = 2,
    ACTIONS(682), 1,
      sym__newline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6024] = 2,
    ACTIONS(798), 1,
      anon_sym_COLON_COLON,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6032] = 2,
    ACTIONS(750), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6040] = 2,
    ACTIONS(684), 1,
      sym__newline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6048] = 2,
    ACTIONS(800), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6056] = 2,
    ACTIONS(802), 1,
      sym__text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6064] = 2,
    ACTIONS(804), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6072] = 2,
    ACTIONS(391), 1,
      sym__underline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6080] = 2,
    ACTIONS(686), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6088] = 2,
    ACTIONS(806), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6096] = 2,
    ACTIONS(752), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6104] = 2,
    ACTIONS(808), 1,
      sym__interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6112] = 2,
    ACTIONS(708), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6120] = 2,
    ACTIONS(810), 1,
      sym__quoted_literal_block,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6128] = 2,
    ACTIONS(812), 1,
      sym__role_name_suffix,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6136] = 2,
    ACTIONS(814), 1,
      sym__interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6144] = 2,
    ACTIONS(816), 1,
      anon_sym_COLON_COLON,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6152] = 2,
    ACTIONS(818), 1,
      sym__underline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(34)] = 0,
  [SMALL_STATE(35)] = 34,
  [SMALL_STATE(36)] = 68,
  [SMALL_STATE(37)] = 102,
  [SMALL_STATE(38)] = 136,
  [SMALL_STATE(39)] = 170,
  [SMALL_STATE(40)] = 233,
  [SMALL_STATE(41)] = 296,
  [SMALL_STATE(42)] = 359,
  [SMALL_STATE(43)] = 391,
  [SMALL_STATE(44)] = 422,
  [SMALL_STATE(45)] = 471,
  [SMALL_STATE(46)] = 523,
  [SMALL_STATE(47)] = 571,
  [SMALL_STATE(48)] = 619,
  [SMALL_STATE(49)] = 671,
  [SMALL_STATE(50)] = 719,
  [SMALL_STATE(51)] = 767,
  [SMALL_STATE(52)] = 814,
  [SMALL_STATE(53)] = 861,
  [SMALL_STATE(54)] = 906,
  [SMALL_STATE(55)] = 953,
  [SMALL_STATE(56)] = 1000,
  [SMALL_STATE(57)] = 1047,
  [SMALL_STATE(58)] = 1098,
  [SMALL_STATE(59)] = 1149,
  [SMALL_STATE(60)] = 1196,
  [SMALL_STATE(61)] = 1243,
  [SMALL_STATE(62)] = 1290,
  [SMALL_STATE(63)] = 1337,
  [SMALL_STATE(64)] = 1384,
  [SMALL_STATE(65)] = 1430,
  [SMALL_STATE(66)] = 1474,
  [SMALL_STATE(67)] = 1520,
  [SMALL_STATE(68)] = 1563,
  [SMALL_STATE(69)] = 1606,
  [SMALL_STATE(70)] = 1649,
  [SMALL_STATE(71)] = 1692,
  [SMALL_STATE(72)] = 1735,
  [SMALL_STATE(73)] = 1778,
  [SMALL_STATE(74)] = 1821,
  [SMALL_STATE(75)] = 1861,
  [SMALL_STATE(76)] = 1901,
  [SMALL_STATE(77)] = 1941,
  [SMALL_STATE(78)] = 1968,
  [SMALL_STATE(79)] = 1995,
  [SMALL_STATE(80)] = 2022,
  [SMALL_STATE(81)] = 2049,
  [SMALL_STATE(82)] = 2076,
  [SMALL_STATE(83)] = 2099,
  [SMALL_STATE(84)] = 2122,
  [SMALL_STATE(85)] = 2145,
  [SMALL_STATE(86)] = 2168,
  [SMALL_STATE(87)] = 2191,
  [SMALL_STATE(88)] = 2213,
  [SMALL_STATE(89)] = 2235,
  [SMALL_STATE(90)] = 2259,
  [SMALL_STATE(91)] = 2283,
  [SMALL_STATE(92)] = 2307,
  [SMALL_STATE(93)] = 2331,
  [SMALL_STATE(94)] = 2355,
  [SMALL_STATE(95)] = 2379,
  [SMALL_STATE(96)] = 2401,
  [SMALL_STATE(97)] = 2423,
  [SMALL_STATE(98)] = 2445,
  [SMALL_STATE(99)] = 2467,
  [SMALL_STATE(100)] = 2488,
  [SMALL_STATE(101)] = 2509,
  [SMALL_STATE(102)] = 2530,
  [SMALL_STATE(103)] = 2551,
  [SMALL_STATE(104)] = 2572,
  [SMALL_STATE(105)] = 2593,
  [SMALL_STATE(106)] = 2614,
  [SMALL_STATE(107)] = 2647,
  [SMALL_STATE(108)] = 2668,
  [SMALL_STATE(109)] = 2689,
  [SMALL_STATE(110)] = 2710,
  [SMALL_STATE(111)] = 2731,
  [SMALL_STATE(112)] = 2764,
  [SMALL_STATE(113)] = 2785,
  [SMALL_STATE(114)] = 2806,
  [SMALL_STATE(115)] = 2827,
  [SMALL_STATE(116)] = 2848,
  [SMALL_STATE(117)] = 2869,
  [SMALL_STATE(118)] = 2890,
  [SMALL_STATE(119)] = 2922,
  [SMALL_STATE(120)] = 2954,
  [SMALL_STATE(121)] = 2991,
  [SMALL_STATE(122)] = 3028,
  [SMALL_STATE(123)] = 3067,
  [SMALL_STATE(124)] = 3106,
  [SMALL_STATE(125)] = 3142,
  [SMALL_STATE(126)] = 3178,
  [SMALL_STATE(127)] = 3214,
  [SMALL_STATE(128)] = 3250,
  [SMALL_STATE(129)] = 3281,
  [SMALL_STATE(130)] = 3312,
  [SMALL_STATE(131)] = 3336,
  [SMALL_STATE(132)] = 3360,
  [SMALL_STATE(133)] = 3384,
  [SMALL_STATE(134)] = 3401,
  [SMALL_STATE(135)] = 3422,
  [SMALL_STATE(136)] = 3443,
  [SMALL_STATE(137)] = 3464,
  [SMALL_STATE(138)] = 3485,
  [SMALL_STATE(139)] = 3506,
  [SMALL_STATE(140)] = 3527,
  [SMALL_STATE(141)] = 3548,
  [SMALL_STATE(142)] = 3569,
  [SMALL_STATE(143)] = 3590,
  [SMALL_STATE(144)] = 3611,
  [SMALL_STATE(145)] = 3632,
  [SMALL_STATE(146)] = 3651,
  [SMALL_STATE(147)] = 3672,
  [SMALL_STATE(148)] = 3693,
  [SMALL_STATE(149)] = 3714,
  [SMALL_STATE(150)] = 3735,
  [SMALL_STATE(151)] = 3756,
  [SMALL_STATE(152)] = 3777,
  [SMALL_STATE(153)] = 3798,
  [SMALL_STATE(154)] = 3815,
  [SMALL_STATE(155)] = 3836,
  [SMALL_STATE(156)] = 3857,
  [SMALL_STATE(157)] = 3869,
  [SMALL_STATE(158)] = 3885,
  [SMALL_STATE(159)] = 3901,
  [SMALL_STATE(160)] = 3917,
  [SMALL_STATE(161)] = 3933,
  [SMALL_STATE(162)] = 3945,
  [SMALL_STATE(163)] = 3957,
  [SMALL_STATE(164)] = 3973,
  [SMALL_STATE(165)] = 3989,
  [SMALL_STATE(166)] = 4005,
  [SMALL_STATE(167)] = 4021,
  [SMALL_STATE(168)] = 4039,
  [SMALL_STATE(169)] = 4051,
  [SMALL_STATE(170)] = 4063,
  [SMALL_STATE(171)] = 4075,
  [SMALL_STATE(172)] = 4087,
  [SMALL_STATE(173)] = 4099,
  [SMALL_STATE(174)] = 4111,
  [SMALL_STATE(175)] = 4123,
  [SMALL_STATE(176)] = 4135,
  [SMALL_STATE(177)] = 4147,
  [SMALL_STATE(178)] = 4159,
  [SMALL_STATE(179)] = 4171,
  [SMALL_STATE(180)] = 4183,
  [SMALL_STATE(181)] = 4195,
  [SMALL_STATE(182)] = 4207,
  [SMALL_STATE(183)] = 4219,
  [SMALL_STATE(184)] = 4231,
  [SMALL_STATE(185)] = 4243,
  [SMALL_STATE(186)] = 4255,
  [SMALL_STATE(187)] = 4267,
  [SMALL_STATE(188)] = 4285,
  [SMALL_STATE(189)] = 4303,
  [SMALL_STATE(190)] = 4315,
  [SMALL_STATE(191)] = 4327,
  [SMALL_STATE(192)] = 4345,
  [SMALL_STATE(193)] = 4363,
  [SMALL_STATE(194)] = 4381,
  [SMALL_STATE(195)] = 4399,
  [SMALL_STATE(196)] = 4417,
  [SMALL_STATE(197)] = 4435,
  [SMALL_STATE(198)] = 4453,
  [SMALL_STATE(199)] = 4465,
  [SMALL_STATE(200)] = 4477,
  [SMALL_STATE(201)] = 4488,
  [SMALL_STATE(202)] = 4503,
  [SMALL_STATE(203)] = 4514,
  [SMALL_STATE(204)] = 4525,
  [SMALL_STATE(205)] = 4536,
  [SMALL_STATE(206)] = 4547,
  [SMALL_STATE(207)] = 4558,
  [SMALL_STATE(208)] = 4573,
  [SMALL_STATE(209)] = 4588,
  [SMALL_STATE(210)] = 4599,
  [SMALL_STATE(211)] = 4610,
  [SMALL_STATE(212)] = 4621,
  [SMALL_STATE(213)] = 4632,
  [SMALL_STATE(214)] = 4643,
  [SMALL_STATE(215)] = 4654,
  [SMALL_STATE(216)] = 4669,
  [SMALL_STATE(217)] = 4684,
  [SMALL_STATE(218)] = 4695,
  [SMALL_STATE(219)] = 4706,
  [SMALL_STATE(220)] = 4717,
  [SMALL_STATE(221)] = 4728,
  [SMALL_STATE(222)] = 4743,
  [SMALL_STATE(223)] = 4754,
  [SMALL_STATE(224)] = 4765,
  [SMALL_STATE(225)] = 4780,
  [SMALL_STATE(226)] = 4791,
  [SMALL_STATE(227)] = 4802,
  [SMALL_STATE(228)] = 4817,
  [SMALL_STATE(229)] = 4828,
  [SMALL_STATE(230)] = 4839,
  [SMALL_STATE(231)] = 4850,
  [SMALL_STATE(232)] = 4861,
  [SMALL_STATE(233)] = 4872,
  [SMALL_STATE(234)] = 4883,
  [SMALL_STATE(235)] = 4898,
  [SMALL_STATE(236)] = 4909,
  [SMALL_STATE(237)] = 4924,
  [SMALL_STATE(238)] = 4938,
  [SMALL_STATE(239)] = 4948,
  [SMALL_STATE(240)] = 4958,
  [SMALL_STATE(241)] = 4968,
  [SMALL_STATE(242)] = 4984,
  [SMALL_STATE(243)] = 4994,
  [SMALL_STATE(244)] = 5008,
  [SMALL_STATE(245)] = 5018,
  [SMALL_STATE(246)] = 5028,
  [SMALL_STATE(247)] = 5038,
  [SMALL_STATE(248)] = 5052,
  [SMALL_STATE(249)] = 5062,
  [SMALL_STATE(250)] = 5072,
  [SMALL_STATE(251)] = 5088,
  [SMALL_STATE(252)] = 5098,
  [SMALL_STATE(253)] = 5108,
  [SMALL_STATE(254)] = 5122,
  [SMALL_STATE(255)] = 5132,
  [SMALL_STATE(256)] = 5148,
  [SMALL_STATE(257)] = 5158,
  [SMALL_STATE(258)] = 5169,
  [SMALL_STATE(259)] = 5178,
  [SMALL_STATE(260)] = 5187,
  [SMALL_STATE(261)] = 5196,
  [SMALL_STATE(262)] = 5207,
  [SMALL_STATE(263)] = 5216,
  [SMALL_STATE(264)] = 5225,
  [SMALL_STATE(265)] = 5238,
  [SMALL_STATE(266)] = 5249,
  [SMALL_STATE(267)] = 5258,
  [SMALL_STATE(268)] = 5269,
  [SMALL_STATE(269)] = 5282,
  [SMALL_STATE(270)] = 5295,
  [SMALL_STATE(271)] = 5306,
  [SMALL_STATE(272)] = 5315,
  [SMALL_STATE(273)] = 5324,
  [SMALL_STATE(274)] = 5335,
  [SMALL_STATE(275)] = 5346,
  [SMALL_STATE(276)] = 5355,
  [SMALL_STATE(277)] = 5364,
  [SMALL_STATE(278)] = 5373,
  [SMALL_STATE(279)] = 5382,
  [SMALL_STATE(280)] = 5393,
  [SMALL_STATE(281)] = 5404,
  [SMALL_STATE(282)] = 5415,
  [SMALL_STATE(283)] = 5426,
  [SMALL_STATE(284)] = 5435,
  [SMALL_STATE(285)] = 5448,
  [SMALL_STATE(286)] = 5457,
  [SMALL_STATE(287)] = 5468,
  [SMALL_STATE(288)] = 5477,
  [SMALL_STATE(289)] = 5488,
  [SMALL_STATE(290)] = 5499,
  [SMALL_STATE(291)] = 5510,
  [SMALL_STATE(292)] = 5521,
  [SMALL_STATE(293)] = 5530,
  [SMALL_STATE(294)] = 5541,
  [SMALL_STATE(295)] = 5552,
  [SMALL_STATE(296)] = 5563,
  [SMALL_STATE(297)] = 5574,
  [SMALL_STATE(298)] = 5585,
  [SMALL_STATE(299)] = 5596,
  [SMALL_STATE(300)] = 5607,
  [SMALL_STATE(301)] = 5618,
  [SMALL_STATE(302)] = 5629,
  [SMALL_STATE(303)] = 5640,
  [SMALL_STATE(304)] = 5651,
  [SMALL_STATE(305)] = 5662,
  [SMALL_STATE(306)] = 5673,
  [SMALL_STATE(307)] = 5682,
  [SMALL_STATE(308)] = 5693,
  [SMALL_STATE(309)] = 5702,
  [SMALL_STATE(310)] = 5711,
  [SMALL_STATE(311)] = 5720,
  [SMALL_STATE(312)] = 5729,
  [SMALL_STATE(313)] = 5738,
  [SMALL_STATE(314)] = 5749,
  [SMALL_STATE(315)] = 5760,
  [SMALL_STATE(316)] = 5768,
  [SMALL_STATE(317)] = 5776,
  [SMALL_STATE(318)] = 5784,
  [SMALL_STATE(319)] = 5792,
  [SMALL_STATE(320)] = 5800,
  [SMALL_STATE(321)] = 5808,
  [SMALL_STATE(322)] = 5816,
  [SMALL_STATE(323)] = 5824,
  [SMALL_STATE(324)] = 5832,
  [SMALL_STATE(325)] = 5840,
  [SMALL_STATE(326)] = 5848,
  [SMALL_STATE(327)] = 5856,
  [SMALL_STATE(328)] = 5864,
  [SMALL_STATE(329)] = 5872,
  [SMALL_STATE(330)] = 5880,
  [SMALL_STATE(331)] = 5888,
  [SMALL_STATE(332)] = 5896,
  [SMALL_STATE(333)] = 5904,
  [SMALL_STATE(334)] = 5912,
  [SMALL_STATE(335)] = 5920,
  [SMALL_STATE(336)] = 5928,
  [SMALL_STATE(337)] = 5936,
  [SMALL_STATE(338)] = 5944,
  [SMALL_STATE(339)] = 5952,
  [SMALL_STATE(340)] = 5960,
  [SMALL_STATE(341)] = 5968,
  [SMALL_STATE(342)] = 5976,
  [SMALL_STATE(343)] = 5984,
  [SMALL_STATE(344)] = 5992,
  [SMALL_STATE(345)] = 6000,
  [SMALL_STATE(346)] = 6008,
  [SMALL_STATE(347)] = 6016,
  [SMALL_STATE(348)] = 6024,
  [SMALL_STATE(349)] = 6032,
  [SMALL_STATE(350)] = 6040,
  [SMALL_STATE(351)] = 6048,
  [SMALL_STATE(352)] = 6056,
  [SMALL_STATE(353)] = 6064,
  [SMALL_STATE(354)] = 6072,
  [SMALL_STATE(355)] = 6080,
  [SMALL_STATE(356)] = 6088,
  [SMALL_STATE(357)] = 6096,
  [SMALL_STATE(358)] = 6104,
  [SMALL_STATE(359)] = 6112,
  [SMALL_STATE(360)] = 6120,
  [SMALL_STATE(361)] = 6128,
  [SMALL_STATE(362)] = 6136,
  [SMALL_STATE(363)] = 6144,
  [SMALL_STATE(364)] = 6152,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 0, 0, 0),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [43] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 1, 0, 0),
  [45] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0),
  [47] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(5),
  [50] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(73),
  [53] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(335),
  [56] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(6),
  [59] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(7),
  [62] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(74),
  [65] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(130),
  [68] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(338),
  [71] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(61),
  [74] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(216),
  [77] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(77),
  [80] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(79),
  [83] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(315),
  [86] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(358),
  [89] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(122),
  [92] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(268),
  [95] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(212),
  [98] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [142] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2, 0, 0), SHIFT_REPEAT(5),
  [145] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2, 0, 0), SHIFT_REPEAT(6),
  [148] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2, 0, 0), SHIFT_REPEAT(7),
  [151] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2, 0, 0), SHIFT_REPEAT(74),
  [154] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2, 0, 0), SHIFT_REPEAT(130),
  [157] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2, 0, 0), SHIFT_REPEAT(338),
  [160] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2, 0, 0), SHIFT_REPEAT(61),
  [163] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2, 0, 0),
  [165] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2, 0, 0), SHIFT_REPEAT(216),
  [168] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2, 0, 0), SHIFT_REPEAT(77),
  [171] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2, 0, 0), SHIFT_REPEAT(79),
  [174] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2, 0, 0), SHIFT_REPEAT(315),
  [177] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2, 0, 0), SHIFT_REPEAT(358),
  [180] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2, 0, 0), SHIFT_REPEAT(122),
  [183] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2, 0, 0), SHIFT_REPEAT(268),
  [186] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2, 0, 0), SHIFT_REPEAT(212),
  [189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_section, 1, 0, 0),
  [191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__transition_block, 2, 0, 0),
  [193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__body_element_block, 2, 0, 0),
  [195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__underline_section, 2, 0, 3),
  [197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__overline_section, 3, 0, 4),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0),
  [217] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(77),
  [220] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(79),
  [223] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(315),
  [226] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(358),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2, 0, 0),
  [239] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2, 0, 0), SHIFT_REPEAT(84),
  [242] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2, 0, 0), SHIFT_REPEAT(86),
  [245] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2, 0, 0), SHIFT_REPEAT(321),
  [248] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2, 0, 0), SHIFT_REPEAT(322),
  [251] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_definition_list_repeat1, 2, 0, 0),
  [253] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_definition_list_repeat1, 2, 0, 0), SHIFT_REPEAT(90),
  [256] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_definition_list_repeat1, 2, 0, 0), SHIFT_REPEAT(92),
  [259] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_definition_list_repeat1, 2, 0, 0), SHIFT_REPEAT(327),
  [262] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_definition_list_repeat1, 2, 0, 0), SHIFT_REPEAT(328),
  [265] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paragraph, 1, 0, 0),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_definition_list, 1, 0, 0),
  [269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [277] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(84),
  [280] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(86),
  [283] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(321),
  [286] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(322),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2, 0, 0),
  [309] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2, 0, 0), SHIFT_REPEAT(105),
  [312] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2, 0, 0), SHIFT_REPEAT(108),
  [315] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2, 0, 0), SHIFT_REPEAT(316),
  [318] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2, 0, 0), SHIFT_REPEAT(323),
  [321] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(90),
  [324] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(92),
  [327] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(327),
  [330] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(328),
  [333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__classifiers, 2, 0, 10),
  [335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [337] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(105),
  [340] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(108),
  [343] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(316),
  [346] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(323),
  [349] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(100),
  [352] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(117),
  [355] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(361),
  [358] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2, 0, 0), SHIFT_REPEAT(362),
  [361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__inline_markup, 1, 0, 0),
  [377] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__prefix_role, 2, 0, 0),
  [379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpreted_text, 1, 0, 0),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 1, 0, 0),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__suffix_role, 2, 0, 0),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__definition_list_item, 3, 0, 9),
  [387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__definition_list_item, 4, 0, 15),
  [389] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paragraph_line, 2, 0, 0),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__line, 2, 0, 0),
  [393] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_body, 2, 0, 0),
  [395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_body, 3, 0, 0),
  [397] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paragraph_line, 3, 0, 0),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__body_element, 1, 0, 0),
  [401] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__explicit_markup_block, 2, 0, 0),
  [403] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__explicit_markup_block, 2, 0, 0), SHIFT_REPEAT(123),
  [406] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__explicit_markup_block, 2, 0, 0), SHIFT_REPEAT(264),
  [409] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__explicit_markup_block, 2, 0, 0), SHIFT_REPEAT(176),
  [412] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__explicit_markup_block, 2, 0, 0), SHIFT_REPEAT(122),
  [415] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__explicit_markup_block, 2, 0, 0), SHIFT_REPEAT(268),
  [418] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__explicit_markup_block, 2, 0, 0), SHIFT_REPEAT(212),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [479] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [499] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__text_block, 2, 0, 0),
  [501] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__text_block, 2, 0, 0), SHIFT_REPEAT(247),
  [504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [508] = {.entry = {.count = 1, .reusable = false}}, SHIFT(125),
  [510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [514] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__anonymous_target, 3, 0, 8),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bullet_list, 1, 0, 0),
  [518] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enumerated_list, 1, 0, 0),
  [520] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_list, 1, 0, 0),
  [522] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_line_block, 1, 0, 0),
  [524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2, 0, 0),
  [526] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__anonymous_target, 2, 0, 0),
  [528] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_bullet_list_repeat1, 2, 0, 0),
  [530] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_bullet_list_repeat1, 2, 0, 0), SHIFT_REPEAT(13),
  [533] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enumerated_list_repeat1, 2, 0, 0),
  [535] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enumerated_list_repeat1, 2, 0, 0), SHIFT_REPEAT(12),
  [538] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_field_list_repeat1, 2, 0, 0),
  [540] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_field_list_repeat1, 2, 0, 0), SHIFT_REPEAT(76),
  [543] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_line_block_repeat1, 2, 0, 0),
  [545] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_block_repeat1, 2, 0, 0), SHIFT_REPEAT(55),
  [548] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__text_block, 2, 0, 0), SHIFT_REPEAT(237),
  [551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_footnote, 3, 0, 5),
  [553] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_citation, 3, 0, 5),
  [555] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_target, 3, 0, 6),
  [557] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_substitution_definition, 3, 0, 7),
  [559] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_target, 4, 0, 13),
  [561] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive, 4, 0, 14),
  [563] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 2, 0, 16),
  [565] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 2, 0, 17),
  [567] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__markup_block, 1, 0, 0),
  [569] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 2, 0, 19),
  [571] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 3, 0, 20),
  [573] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 3, 0, 21),
  [575] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 3, 0, 22),
  [577] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 3, 0, 23),
  [579] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__embedded_directive, 4, 0, 24),
  [581] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 4, 0, 25),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 4, 0, 26),
  [585] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__indented_text_block, 2, 0, 0),
  [587] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__indented_text_block, 3, 0, 0),
  [589] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__indented_text_block_repeat1, 2, 0, 0), SHIFT_REPEAT(237),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [598] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__markup_block, 1, 0, 1),
  [600] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 2, 0, 18),
  [602] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_field_list_repeat1, 2, 0, 0), SHIFT_REPEAT(74),
  [605] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_block_repeat1, 2, 0, 0), SHIFT_REPEAT(61),
  [608] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__text_line, 2, 0, 0),
  [610] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_bullet_list_repeat1, 2, 0, 0), SHIFT_REPEAT(6),
  [613] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enumerated_list_repeat1, 2, 0, 0), SHIFT_REPEAT(7),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [622] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__text_line_repeat1, 2, 0, 0),
  [624] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__text_line_repeat1, 2, 0, 0), SHIFT_REPEAT(243),
  [627] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 4, 0, 11),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [631] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 4, 0, 12),
  [633] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bullet_list_item, 2, 0, 0),
  [635] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__classifiers, 2, 0, 0), SHIFT_REPEAT(75),
  [638] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__classifiers, 2, 0, 0),
  [640] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__numeric_list_item, 2, 0, 0),
  [642] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_line, 2, 0, 0),
  [644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [646] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_line, 3, 0, 0),
  [648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [652] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [658] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__block_quote_block, 2, 0, 0),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [682] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__literal_block, 2, 0, 0),
  [684] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__literal_block, 2, 0, 2),
  [686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_quote, 2, 0, 0),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [708] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__list, 1, 0, 0),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [750] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_doctest_block, 3, 0, 0),
  [752] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_quote, 3, 0, 0),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [778] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [792] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [802] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__indented_text_block_repeat1, 2, 0, 0),
  [804] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [806] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribution, 3, 0, 0),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [812] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token__newline = 0,
  ts_external_token__blankline = 1,
  ts_external_token__indent = 2,
  ts_external_token__newline_indent = 3,
  ts_external_token__dedent = 4,
  ts_external_token__overline = 5,
  ts_external_token__underline = 6,
  ts_external_token_transition = 7,
  ts_external_token__char_bullet = 8,
  ts_external_token__numeric_bullet = 9,
  ts_external_token__field_mark = 10,
  ts_external_token__field_mark_end = 11,
  ts_external_token__literal_indented_block_mark = 12,
  ts_external_token__literal_quoted_block_mark = 13,
  ts_external_token__quoted_literal_block = 14,
  ts_external_token__line_block_mark = 15,
  ts_external_token__attribution_mark = 16,
  ts_external_token__doctest_block_mark = 17,
  ts_external_token__text = 18,
  ts_external_token_emphasis = 19,
  ts_external_token_strong = 20,
  ts_external_token__interpreted_text = 21,
  ts_external_token__interpreted_text_prefix = 22,
  ts_external_token__role_name_prefix = 23,
  ts_external_token__role_name_suffix = 24,
  ts_external_token_literal = 25,
  ts_external_token_substitution_reference = 26,
  ts_external_token_inline_target = 27,
  ts_external_token_footnote_reference = 28,
  ts_external_token_citation_reference = 29,
  ts_external_token_reference = 30,
  ts_external_token_standalone_hyperlink = 31,
  ts_external_token__explicit_markup_start = 32,
  ts_external_token__footnote_label = 33,
  ts_external_token__citation_label = 34,
  ts_external_token__target_name = 35,
  ts_external_token__anonymous_target_mark = 36,
  ts_external_token__directive_name = 37,
  ts_external_token__substitution_mark = 38,
  ts_external_token__empty_comment = 39,
  ts_external_token__invalid_token = 40,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__newline] = sym__newline,
  [ts_external_token__blankline] = sym__blankline,
  [ts_external_token__indent] = sym__indent,
  [ts_external_token__newline_indent] = sym__newline_indent,
  [ts_external_token__dedent] = sym__dedent,
  [ts_external_token__overline] = sym__overline,
  [ts_external_token__underline] = sym__underline,
  [ts_external_token_transition] = sym_transition,
  [ts_external_token__char_bullet] = sym__char_bullet,
  [ts_external_token__numeric_bullet] = sym__numeric_bullet,
  [ts_external_token__field_mark] = sym__field_mark,
  [ts_external_token__field_mark_end] = sym__field_mark_end,
  [ts_external_token__literal_indented_block_mark] = sym__literal_indented_block_mark,
  [ts_external_token__literal_quoted_block_mark] = sym__literal_quoted_block_mark,
  [ts_external_token__quoted_literal_block] = sym__quoted_literal_block,
  [ts_external_token__line_block_mark] = sym__line_block_mark,
  [ts_external_token__attribution_mark] = sym__attribution_mark,
  [ts_external_token__doctest_block_mark] = sym__doctest_block_mark,
  [ts_external_token__text] = sym__text,
  [ts_external_token_emphasis] = sym_emphasis,
  [ts_external_token_strong] = sym_strong,
  [ts_external_token__interpreted_text] = sym__interpreted_text,
  [ts_external_token__interpreted_text_prefix] = sym__interpreted_text_prefix,
  [ts_external_token__role_name_prefix] = sym__role_name_prefix,
  [ts_external_token__role_name_suffix] = sym__role_name_suffix,
  [ts_external_token_literal] = sym_literal,
  [ts_external_token_substitution_reference] = sym_substitution_reference,
  [ts_external_token_inline_target] = sym_inline_target,
  [ts_external_token_footnote_reference] = sym_footnote_reference,
  [ts_external_token_citation_reference] = sym_citation_reference,
  [ts_external_token_reference] = sym_reference,
  [ts_external_token_standalone_hyperlink] = sym_standalone_hyperlink,
  [ts_external_token__explicit_markup_start] = sym__explicit_markup_start,
  [ts_external_token__footnote_label] = sym__footnote_label,
  [ts_external_token__citation_label] = sym__citation_label,
  [ts_external_token__target_name] = sym__target_name,
  [ts_external_token__anonymous_target_mark] = sym__anonymous_target_mark,
  [ts_external_token__directive_name] = sym__directive_name,
  [ts_external_token__substitution_mark] = sym__substitution_mark,
  [ts_external_token__empty_comment] = sym__empty_comment,
  [ts_external_token__invalid_token] = sym__invalid_token,
};

static const bool ts_external_scanner_states[45][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__newline] = true,
    [ts_external_token__blankline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token__newline_indent] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__overline] = true,
    [ts_external_token__underline] = true,
    [ts_external_token_transition] = true,
    [ts_external_token__char_bullet] = true,
    [ts_external_token__numeric_bullet] = true,
    [ts_external_token__field_mark] = true,
    [ts_external_token__field_mark_end] = true,
    [ts_external_token__literal_indented_block_mark] = true,
    [ts_external_token__literal_quoted_block_mark] = true,
    [ts_external_token__quoted_literal_block] = true,
    [ts_external_token__line_block_mark] = true,
    [ts_external_token__attribution_mark] = true,
    [ts_external_token__doctest_block_mark] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token__role_name_suffix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
    [ts_external_token__explicit_markup_start] = true,
    [ts_external_token__footnote_label] = true,
    [ts_external_token__citation_label] = true,
    [ts_external_token__target_name] = true,
    [ts_external_token__anonymous_target_mark] = true,
    [ts_external_token__directive_name] = true,
    [ts_external_token__substitution_mark] = true,
    [ts_external_token__empty_comment] = true,
    [ts_external_token__invalid_token] = true,
  },
  [2] = {
    [ts_external_token__indent] = true,
    [ts_external_token__overline] = true,
    [ts_external_token_transition] = true,
    [ts_external_token__char_bullet] = true,
    [ts_external_token__numeric_bullet] = true,
    [ts_external_token__field_mark] = true,
    [ts_external_token__literal_indented_block_mark] = true,
    [ts_external_token__literal_quoted_block_mark] = true,
    [ts_external_token__line_block_mark] = true,
    [ts_external_token__doctest_block_mark] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
    [ts_external_token__explicit_markup_start] = true,
    [ts_external_token__anonymous_target_mark] = true,
    [ts_external_token__empty_comment] = true,
  },
  [3] = {
    [ts_external_token__indent] = true,
    [ts_external_token__char_bullet] = true,
    [ts_external_token__numeric_bullet] = true,
    [ts_external_token__field_mark] = true,
    [ts_external_token__literal_indented_block_mark] = true,
    [ts_external_token__literal_quoted_block_mark] = true,
    [ts_external_token__line_block_mark] = true,
    [ts_external_token__attribution_mark] = true,
    [ts_external_token__doctest_block_mark] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
    [ts_external_token__explicit_markup_start] = true,
    [ts_external_token__anonymous_target_mark] = true,
    [ts_external_token__empty_comment] = true,
  },
  [4] = {
    [ts_external_token__indent] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__char_bullet] = true,
    [ts_external_token__numeric_bullet] = true,
    [ts_external_token__field_mark] = true,
    [ts_external_token__literal_indented_block_mark] = true,
    [ts_external_token__literal_quoted_block_mark] = true,
    [ts_external_token__line_block_mark] = true,
    [ts_external_token__doctest_block_mark] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
    [ts_external_token__explicit_markup_start] = true,
    [ts_external_token__anonymous_target_mark] = true,
    [ts_external_token__empty_comment] = true,
  },
  [5] = {
    [ts_external_token__indent] = true,
    [ts_external_token__char_bullet] = true,
    [ts_external_token__numeric_bullet] = true,
    [ts_external_token__field_mark] = true,
    [ts_external_token__literal_indented_block_mark] = true,
    [ts_external_token__literal_quoted_block_mark] = true,
    [ts_external_token__line_block_mark] = true,
    [ts_external_token__doctest_block_mark] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
    [ts_external_token__explicit_markup_start] = true,
    [ts_external_token__anonymous_target_mark] = true,
    [ts_external_token__empty_comment] = true,
  },
  [6] = {
    [ts_external_token__newline] = true,
    [ts_external_token__newline_indent] = true,
    [ts_external_token__literal_indented_block_mark] = true,
    [ts_external_token__literal_quoted_block_mark] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [7] = {
    [ts_external_token__newline] = true,
    [ts_external_token__literal_indented_block_mark] = true,
    [ts_external_token__literal_quoted_block_mark] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [8] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [9] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [10] = {
    [ts_external_token__dedent] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [11] = {
    [ts_external_token__newline_indent] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [12] = {
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [13] = {
    [ts_external_token__newline] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [14] = {
    [ts_external_token__field_mark_end] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [15] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__underline] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [16] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__explicit_markup_start] = true,
    [ts_external_token__anonymous_target_mark] = true,
    [ts_external_token__empty_comment] = true,
  },
  [17] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__explicit_markup_start] = true,
    [ts_external_token__anonymous_target_mark] = true,
    [ts_external_token__empty_comment] = true,
  },
  [18] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__field_mark] = true,
    [ts_external_token__text] = true,
  },
  [19] = {
    [ts_external_token__dedent] = true,
    [ts_external_token__text] = true,
    [ts_external_token__footnote_label] = true,
    [ts_external_token__citation_label] = true,
    [ts_external_token__target_name] = true,
    [ts_external_token__directive_name] = true,
    [ts_external_token__substitution_mark] = true,
  },
  [20] = {
    [ts_external_token__newline] = true,
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__field_mark] = true,
    [ts_external_token__text] = true,
  },
  [21] = {
    [ts_external_token__field_mark] = true,
    [ts_external_token__text] = true,
  },
  [22] = {
    [ts_external_token__dedent] = true,
    [ts_external_token__text] = true,
  },
  [23] = {
    [ts_external_token__newline] = true,
  },
  [24] = {
    [ts_external_token__text] = true,
  },
  [25] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__text] = true,
  },
  [26] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__char_bullet] = true,
  },
  [27] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__numeric_bullet] = true,
  },
  [28] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__field_mark] = true,
  },
  [29] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__line_block_mark] = true,
  },
  [30] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__text] = true,
  },
  [31] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__field_mark] = true,
  },
  [32] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__line_block_mark] = true,
  },
  [33] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__char_bullet] = true,
  },
  [34] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__numeric_bullet] = true,
  },
  [35] = {
    [ts_external_token__newline] = true,
    [ts_external_token__text] = true,
  },
  [36] = {
    [ts_external_token__newline_indent] = true,
  },
  [37] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
  },
  [38] = {
    [ts_external_token__dedent] = true,
  },
  [39] = {
    [ts_external_token__directive_name] = true,
  },
  [40] = {
    [ts_external_token__role_name_suffix] = true,
  },
  [41] = {
    [ts_external_token__blankline] = true,
  },
  [42] = {
    [ts_external_token__interpreted_text] = true,
  },
  [43] = {
    [ts_external_token__quoted_literal_block] = true,
  },
  [44] = {
    [ts_external_token__underline] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_rst_external_scanner_create(void);
void tree_sitter_rst_external_scanner_destroy(void *);
bool tree_sitter_rst_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_rst_external_scanner_serialize(void *, char *);
void tree_sitter_rst_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_rst(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_rst_external_scanner_create,
      tree_sitter_rst_external_scanner_destroy,
      tree_sitter_rst_external_scanner_scan,
      tree_sitter_rst_external_scanner_serialize,
      tree_sitter_rst_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
