#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 438
#define LARGE_STATE_COUNT 45
#define SYMBOL_COUNT 105
#define ALIAS_COUNT 0
#define TOKEN_COUNT 56
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 9
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 18

enum ts_symbol_identifiers {
  sym_word = 1,
  anon_sym_and = 2,
  anon_sym_or = 3,
  anon_sym_PIPE_PIPE = 4,
  anon_sym_AMP_AMP = 5,
  anon_sym_AMP_PIPE = 6,
  anon_sym_2_GT_PIPE = 7,
  anon_sym_PIPE = 8,
  anon_sym_SEMI = 9,
  anon_sym_AMP = 10,
  anon_sym_LF = 11,
  anon_sym_CR = 12,
  anon_sym_CR_LF = 13,
  anon_sym_BANG = 14,
  anon_sym_not = 15,
  anon_sym_DOLLAR = 16,
  anon_sym_LPAREN = 17,
  anon_sym_RPAREN = 18,
  anon_sym_function = 19,
  anon_sym_end = 20,
  sym_integer = 21,
  sym_float = 22,
  anon_sym_return = 23,
  anon_sym_switch = 24,
  anon_sym_case = 25,
  sym_break = 26,
  sym_continue = 27,
  anon_sym_for = 28,
  anon_sym_in = 29,
  anon_sym_while = 30,
  anon_sym_if = 31,
  anon_sym_else = 32,
  anon_sym_begin = 33,
  sym_comment = 34,
  sym_variable_name = 35,
  anon_sym_DOT_DOT = 36,
  anon_sym_LBRACK = 37,
  anon_sym_RBRACK = 38,
  anon_sym_LBRACE = 39,
  anon_sym_COMMA = 40,
  anon_sym_RBRACE = 41,
  anon_sym_DQUOTE = 42,
  aux_sym_double_quote_string_token1 = 43,
  anon_sym_SQUOTE = 44,
  aux_sym_single_quote_string_token1 = 45,
  sym_escape_sequence = 46,
  sym_stream_redirect = 47,
  sym_direction = 48,
  anon_sym_POUND = 49,
  sym_home_dir_expansion = 50,
  sym_glob = 51,
  sym_brace_word = 52,
  sym__concat = 53,
  sym__brace_concat = 54,
  sym__concat_list = 55,
  sym_program = 56,
  sym_conditional_execution = 57,
  sym_pipe = 58,
  sym_redirect_statement = 59,
  sym__terminated_statement = 60,
  sym__terminated_opt_statement = 61,
  sym_negated_statement = 62,
  sym_command_substitution = 63,
  sym_function_definition = 64,
  sym_return = 65,
  sym_switch_statement = 66,
  sym_case_clause = 67,
  sym_for_statement = 68,
  sym_while_statement = 69,
  sym_if_statement = 70,
  sym_else_if_clause = 71,
  sym_else_clause = 72,
  sym_begin_statement = 73,
  sym_variable_expansion = 74,
  sym_index = 75,
  sym_range = 76,
  sym_list_element_access = 77,
  sym_brace_expansion = 78,
  sym_double_quote_string = 79,
  sym_single_quote_string = 80,
  sym_command = 81,
  sym_file_redirect = 82,
  sym__special_character = 83,
  sym_concatenation = 84,
  sym__expression = 85,
  sym_brace_concatenation = 86,
  sym__brace_expression = 87,
  sym__base_brace_expression = 88,
  aux_sym_program_repeat1 = 89,
  aux_sym_function_definition_repeat1 = 90,
  aux_sym_function_definition_repeat2 = 91,
  aux_sym_switch_statement_repeat1 = 92,
  aux_sym_case_clause_repeat1 = 93,
  aux_sym_for_statement_repeat1 = 94,
  aux_sym_while_statement_repeat1 = 95,
  aux_sym_if_statement_repeat1 = 96,
  aux_sym_variable_expansion_repeat1 = 97,
  aux_sym_list_element_access_repeat1 = 98,
  aux_sym_brace_expansion_repeat1 = 99,
  aux_sym_double_quote_string_repeat1 = 100,
  aux_sym_single_quote_string_repeat1 = 101,
  aux_sym_command_repeat1 = 102,
  aux_sym_concatenation_repeat1 = 103,
  aux_sym_brace_concatenation_repeat1 = 104,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_word] = "word",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_AMP_PIPE] = "&|",
  [anon_sym_2_GT_PIPE] = "2>|",
  [anon_sym_PIPE] = "|",
  [anon_sym_SEMI] = ";",
  [anon_sym_AMP] = "&",
  [anon_sym_LF] = "\n",
  [anon_sym_CR] = "\r",
  [anon_sym_CR_LF] = "\r\n",
  [anon_sym_BANG] = "!",
  [anon_sym_not] = "not",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_function] = "function",
  [anon_sym_end] = "end",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_return] = "return",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [sym_break] = "break",
  [sym_continue] = "continue",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_begin] = "begin",
  [sym_comment] = "comment",
  [sym_variable_name] = "variable_name",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_double_quote_string_token1] = "double_quote_string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_single_quote_string_token1] = "single_quote_string_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_stream_redirect] = "stream_redirect",
  [sym_direction] = "direction",
  [anon_sym_POUND] = "#",
  [sym_home_dir_expansion] = "home_dir_expansion",
  [sym_glob] = "glob",
  [sym_brace_word] = "word",
  [sym__concat] = "_concat",
  [sym__brace_concat] = "_brace_concat",
  [sym__concat_list] = "_concat_list",
  [sym_program] = "program",
  [sym_conditional_execution] = "conditional_execution",
  [sym_pipe] = "pipe",
  [sym_redirect_statement] = "redirect_statement",
  [sym__terminated_statement] = "_terminated_statement",
  [sym__terminated_opt_statement] = "_terminated_opt_statement",
  [sym_negated_statement] = "negated_statement",
  [sym_command_substitution] = "command_substitution",
  [sym_function_definition] = "function_definition",
  [sym_return] = "return",
  [sym_switch_statement] = "switch_statement",
  [sym_case_clause] = "case_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_if_statement] = "if_statement",
  [sym_else_if_clause] = "else_if_clause",
  [sym_else_clause] = "else_clause",
  [sym_begin_statement] = "begin_statement",
  [sym_variable_expansion] = "variable_expansion",
  [sym_index] = "index",
  [sym_range] = "range",
  [sym_list_element_access] = "list_element_access",
  [sym_brace_expansion] = "brace_expansion",
  [sym_double_quote_string] = "double_quote_string",
  [sym_single_quote_string] = "single_quote_string",
  [sym_command] = "command",
  [sym_file_redirect] = "file_redirect",
  [sym__special_character] = "_special_character",
  [sym_concatenation] = "concatenation",
  [sym__expression] = "_expression",
  [sym_brace_concatenation] = "concatenation",
  [sym__brace_expression] = "_brace_expression",
  [sym__base_brace_expression] = "_base_brace_expression",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_function_definition_repeat2] = "function_definition_repeat2",
  [aux_sym_switch_statement_repeat1] = "switch_statement_repeat1",
  [aux_sym_case_clause_repeat1] = "case_clause_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_while_statement_repeat1] = "while_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_variable_expansion_repeat1] = "variable_expansion_repeat1",
  [aux_sym_list_element_access_repeat1] = "list_element_access_repeat1",
  [aux_sym_brace_expansion_repeat1] = "brace_expansion_repeat1",
  [aux_sym_double_quote_string_repeat1] = "double_quote_string_repeat1",
  [aux_sym_single_quote_string_repeat1] = "single_quote_string_repeat1",
  [aux_sym_command_repeat1] = "command_repeat1",
  [aux_sym_concatenation_repeat1] = "concatenation_repeat1",
  [aux_sym_brace_concatenation_repeat1] = "brace_concatenation_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_word] = sym_word,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_AMP_PIPE] = anon_sym_AMP_PIPE,
  [anon_sym_2_GT_PIPE] = anon_sym_2_GT_PIPE,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR] = anon_sym_CR,
  [anon_sym_CR_LF] = anon_sym_CR_LF,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_end] = anon_sym_end,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [sym_break] = sym_break,
  [sym_continue] = sym_continue,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_begin] = anon_sym_begin,
  [sym_comment] = sym_comment,
  [sym_variable_name] = sym_variable_name,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_double_quote_string_token1] = aux_sym_double_quote_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_single_quote_string_token1] = aux_sym_single_quote_string_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_stream_redirect] = sym_stream_redirect,
  [sym_direction] = sym_direction,
  [anon_sym_POUND] = anon_sym_POUND,
  [sym_home_dir_expansion] = sym_home_dir_expansion,
  [sym_glob] = sym_glob,
  [sym_brace_word] = sym_word,
  [sym__concat] = sym__concat,
  [sym__brace_concat] = sym__brace_concat,
  [sym__concat_list] = sym__concat_list,
  [sym_program] = sym_program,
  [sym_conditional_execution] = sym_conditional_execution,
  [sym_pipe] = sym_pipe,
  [sym_redirect_statement] = sym_redirect_statement,
  [sym__terminated_statement] = sym__terminated_statement,
  [sym__terminated_opt_statement] = sym__terminated_opt_statement,
  [sym_negated_statement] = sym_negated_statement,
  [sym_command_substitution] = sym_command_substitution,
  [sym_function_definition] = sym_function_definition,
  [sym_return] = sym_return,
  [sym_switch_statement] = sym_switch_statement,
  [sym_case_clause] = sym_case_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_else_if_clause] = sym_else_if_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_begin_statement] = sym_begin_statement,
  [sym_variable_expansion] = sym_variable_expansion,
  [sym_index] = sym_index,
  [sym_range] = sym_range,
  [sym_list_element_access] = sym_list_element_access,
  [sym_brace_expansion] = sym_brace_expansion,
  [sym_double_quote_string] = sym_double_quote_string,
  [sym_single_quote_string] = sym_single_quote_string,
  [sym_command] = sym_command,
  [sym_file_redirect] = sym_file_redirect,
  [sym__special_character] = sym__special_character,
  [sym_concatenation] = sym_concatenation,
  [sym__expression] = sym__expression,
  [sym_brace_concatenation] = sym_concatenation,
  [sym__brace_expression] = sym__brace_expression,
  [sym__base_brace_expression] = sym__base_brace_expression,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_function_definition_repeat2] = aux_sym_function_definition_repeat2,
  [aux_sym_switch_statement_repeat1] = aux_sym_switch_statement_repeat1,
  [aux_sym_case_clause_repeat1] = aux_sym_case_clause_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_while_statement_repeat1] = aux_sym_while_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_variable_expansion_repeat1] = aux_sym_variable_expansion_repeat1,
  [aux_sym_list_element_access_repeat1] = aux_sym_list_element_access_repeat1,
  [aux_sym_brace_expansion_repeat1] = aux_sym_brace_expansion_repeat1,
  [aux_sym_double_quote_string_repeat1] = aux_sym_double_quote_string_repeat1,
  [aux_sym_single_quote_string_repeat1] = aux_sym_single_quote_string_repeat1,
  [aux_sym_command_repeat1] = aux_sym_command_repeat1,
  [aux_sym_concatenation_repeat1] = aux_sym_concatenation_repeat1,
  [aux_sym_brace_concatenation_repeat1] = aux_sym_brace_concatenation_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_word] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_2_GT_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_continue] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_begin] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_name] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_double_quote_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_single_quote_string_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_stream_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_direction] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [sym_home_dir_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_glob] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_word] = {
    .visible = true,
    .named = true,
  },
  [sym__concat] = {
    .visible = false,
    .named = true,
  },
  [sym__brace_concat] = {
    .visible = false,
    .named = true,
  },
  [sym__concat_list] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_execution] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe] = {
    .visible = true,
    .named = true,
  },
  [sym_redirect_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__terminated_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__terminated_opt_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_negated_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_command_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_return] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_begin_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_index] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_list_element_access] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_double_quote_string] = {
    .visible = true,
    .named = true,
  },
  [sym_single_quote_string] = {
    .visible = true,
    .named = true,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym_file_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym__special_character] = {
    .visible = false,
    .named = true,
  },
  [sym_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_brace_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym__brace_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__base_brace_expression] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_while_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_expansion_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_element_access_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_brace_expansion_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_double_quote_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_single_quote_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_brace_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_argument = 1,
  field_condition = 2,
  field_destination = 3,
  field_name = 4,
  field_operator = 5,
  field_option = 6,
  field_redirect = 7,
  field_value = 8,
  field_variable = 9,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument] = "argument",
  [field_condition] = "condition",
  [field_destination] = "destination",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_option] = "option",
  [field_redirect] = "redirect",
  [field_value] = "value",
  [field_variable] = "variable",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 3},
  [6] = {.index = 6, .length = 1},
  [7] = {.index = 7, .length = 2},
  [8] = {.index = 9, .length = 1},
  [9] = {.index = 10, .length = 4},
  [10] = {.index = 14, .length = 1},
  [11] = {.index = 15, .length = 2},
  [12] = {.index = 17, .length = 1},
  [13] = {.index = 18, .length = 1},
  [14] = {.index = 19, .length = 2},
  [15] = {.index = 21, .length = 2},
  [16] = {.index = 23, .length = 1},
  [17] = {.index = 24, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_redirect, 0},
  [2] =
    {field_argument, 0},
  [3] =
    {field_argument, 1, .inherited = true},
    {field_name, 0},
    {field_redirect, 1, .inherited = true},
  [6] =
    {field_option, 0},
  [7] =
    {field_destination, 1},
    {field_operator, 0},
  [9] =
    {field_condition, 1},
  [10] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
    {field_redirect, 0, .inherited = true},
    {field_redirect, 1, .inherited = true},
  [14] =
    {field_name, 1},
  [15] =
    {field_option, 0, .inherited = true},
    {field_option, 1, .inherited = true},
  [17] =
    {field_value, 1},
  [18] =
    {field_value, 0},
  [19] =
    {field_name, 1},
    {field_option, 2, .inherited = true},
  [21] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [23] =
    {field_condition, 2},
  [24] =
    {field_value, 3, .inherited = true},
    {field_variable, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_word,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__special_character, 2,
    sym__special_character,
    sym_word,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 6,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 14,
  [17] = 14,
  [18] = 18,
  [19] = 14,
  [20] = 20,
  [21] = 15,
  [22] = 18,
  [23] = 14,
  [24] = 20,
  [25] = 18,
  [26] = 26,
  [27] = 20,
  [28] = 15,
  [29] = 18,
  [30] = 15,
  [31] = 20,
  [32] = 32,
  [33] = 14,
  [34] = 20,
  [35] = 18,
  [36] = 20,
  [37] = 32,
  [38] = 15,
  [39] = 18,
  [40] = 15,
  [41] = 15,
  [42] = 18,
  [43] = 14,
  [44] = 20,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 45,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 83,
  [85] = 82,
  [86] = 86,
  [87] = 86,
  [88] = 88,
  [89] = 88,
  [90] = 90,
  [91] = 90,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 83,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 83,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 127,
  [129] = 90,
  [130] = 90,
  [131] = 88,
  [132] = 127,
  [133] = 133,
  [134] = 88,
  [135] = 135,
  [136] = 127,
  [137] = 92,
  [138] = 135,
  [139] = 139,
  [140] = 127,
  [141] = 141,
  [142] = 93,
  [143] = 97,
  [144] = 98,
  [145] = 94,
  [146] = 100,
  [147] = 99,
  [148] = 96,
  [149] = 141,
  [150] = 141,
  [151] = 151,
  [152] = 141,
  [153] = 105,
  [154] = 113,
  [155] = 106,
  [156] = 118,
  [157] = 102,
  [158] = 111,
  [159] = 104,
  [160] = 108,
  [161] = 120,
  [162] = 119,
  [163] = 112,
  [164] = 110,
  [165] = 117,
  [166] = 166,
  [167] = 167,
  [168] = 92,
  [169] = 90,
  [170] = 170,
  [171] = 88,
  [172] = 90,
  [173] = 88,
  [174] = 93,
  [175] = 94,
  [176] = 98,
  [177] = 96,
  [178] = 99,
  [179] = 97,
  [180] = 100,
  [181] = 181,
  [182] = 182,
  [183] = 108,
  [184] = 110,
  [185] = 185,
  [186] = 117,
  [187] = 113,
  [188] = 188,
  [189] = 189,
  [190] = 182,
  [191] = 182,
  [192] = 192,
  [193] = 181,
  [194] = 188,
  [195] = 185,
  [196] = 181,
  [197] = 197,
  [198] = 185,
  [199] = 188,
  [200] = 111,
  [201] = 201,
  [202] = 202,
  [203] = 197,
  [204] = 181,
  [205] = 205,
  [206] = 181,
  [207] = 197,
  [208] = 105,
  [209] = 188,
  [210] = 185,
  [211] = 182,
  [212] = 188,
  [213] = 182,
  [214] = 185,
  [215] = 197,
  [216] = 181,
  [217] = 182,
  [218] = 182,
  [219] = 188,
  [220] = 185,
  [221] = 118,
  [222] = 188,
  [223] = 197,
  [224] = 104,
  [225] = 185,
  [226] = 197,
  [227] = 112,
  [228] = 119,
  [229] = 120,
  [230] = 102,
  [231] = 197,
  [232] = 106,
  [233] = 181,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 124,
  [242] = 242,
  [243] = 243,
  [244] = 243,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 245,
  [256] = 235,
  [257] = 245,
  [258] = 258,
  [259] = 259,
  [260] = 245,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 92,
  [280] = 88,
  [281] = 90,
  [282] = 88,
  [283] = 90,
  [284] = 284,
  [285] = 284,
  [286] = 286,
  [287] = 284,
  [288] = 286,
  [289] = 284,
  [290] = 286,
  [291] = 90,
  [292] = 286,
  [293] = 92,
  [294] = 294,
  [295] = 286,
  [296] = 88,
  [297] = 90,
  [298] = 88,
  [299] = 286,
  [300] = 94,
  [301] = 284,
  [302] = 97,
  [303] = 98,
  [304] = 284,
  [305] = 94,
  [306] = 119,
  [307] = 88,
  [308] = 105,
  [309] = 104,
  [310] = 102,
  [311] = 90,
  [312] = 113,
  [313] = 313,
  [314] = 314,
  [315] = 96,
  [316] = 99,
  [317] = 317,
  [318] = 100,
  [319] = 88,
  [320] = 90,
  [321] = 92,
  [322] = 93,
  [323] = 97,
  [324] = 117,
  [325] = 110,
  [326] = 98,
  [327] = 327,
  [328] = 120,
  [329] = 120,
  [330] = 104,
  [331] = 97,
  [332] = 118,
  [333] = 94,
  [334] = 112,
  [335] = 335,
  [336] = 105,
  [337] = 111,
  [338] = 113,
  [339] = 117,
  [340] = 110,
  [341] = 108,
  [342] = 119,
  [343] = 106,
  [344] = 98,
  [345] = 102,
  [346] = 346,
  [347] = 113,
  [348] = 92,
  [349] = 88,
  [350] = 350,
  [351] = 90,
  [352] = 352,
  [353] = 90,
  [354] = 88,
  [355] = 104,
  [356] = 105,
  [357] = 102,
  [358] = 94,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 365,
  [367] = 367,
  [368] = 365,
  [369] = 365,
  [370] = 370,
  [371] = 361,
  [372] = 367,
  [373] = 367,
  [374] = 367,
  [375] = 367,
  [376] = 361,
  [377] = 361,
  [378] = 378,
  [379] = 365,
  [380] = 380,
  [381] = 361,
  [382] = 361,
  [383] = 365,
  [384] = 367,
  [385] = 365,
  [386] = 97,
  [387] = 98,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 105,
  [392] = 111,
  [393] = 113,
  [394] = 394,
  [395] = 388,
  [396] = 388,
  [397] = 117,
  [398] = 110,
  [399] = 394,
  [400] = 400,
  [401] = 108,
  [402] = 402,
  [403] = 102,
  [404] = 120,
  [405] = 394,
  [406] = 402,
  [407] = 119,
  [408] = 112,
  [409] = 400,
  [410] = 394,
  [411] = 104,
  [412] = 402,
  [413] = 388,
  [414] = 388,
  [415] = 388,
  [416] = 402,
  [417] = 400,
  [418] = 388,
  [419] = 400,
  [420] = 400,
  [421] = 402,
  [422] = 394,
  [423] = 423,
  [424] = 424,
  [425] = 423,
  [426] = 423,
  [427] = 423,
  [428] = 423,
  [429] = 423,
  [430] = 423,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
};

static inline bool anon_sym_LF_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < 133
      ? (c < ' '
        ? (c >= '\t' && c <= '\f')
        : c <= ' ')
      : (c <= 133 || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8202 || (c < 8287
      ? (c < 8239
        ? (c >= 8232 && c <= 8233)
        : c <= 8239)
      : (c <= 8287 || c == 12288))));
}

static inline bool sym_word_character_set_1(int32_t c) {
  return (c < '&'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : c <= '\r')
      : (c <= ' ' || (c < '$'
        ? c == '"'
        : c <= '$')))
    : (c <= '*' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= '^' || (c >= '{' && c <= '~')))));
}

static inline bool sym_word_character_set_2(int32_t c) {
  return (c < '$'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : c <= '\r')
      : (c <= ' ' || c == '"'))
    : (c <= '$' || (c < '['
      ? (c < ';'
        ? (c >= '&' && c <= '*')
        : c <= ';')
      : (c <= '^' || (c >= '{' && c <= '~')))));
}

static inline bool sym_word_character_set_3(int32_t c) {
  return (c < '&'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : c <= '\f')
      : (c <= ' ' || (c >= '"' && c <= '$')))
    : (c <= '*' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= '^' || (c >= '{' && c <= '~')))));
}

static inline bool sym_word_character_set_4(int32_t c) {
  return (c < '&'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : c <= '\r')
      : (c <= ' ' || (c >= '"' && c <= '$')))
    : (c <= '*' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= '^' || (c >= '{' && c <= '~')))));
}

static inline bool sym_brace_word_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < 133
      ? (c < ' '
        ? (c >= '\t' && c <= '\r')
        : c <= ' ')
      : (c <= 133 || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8202 || (c < 8287
      ? (c < 8239
        ? (c >= 8232 && c <= 8233)
        : c <= 8239)
      : (c <= 8287 || c == 12288))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(33);
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '#') ADVANCE(114);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '&') ADVANCE(41);
      if (lookahead == '\'') ADVANCE(90);
      if (lookahead == '(') ADVANCE(56);
      if (lookahead == ')') ADVANCE(58);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == ',') ADVANCE(84);
      if (lookahead == '.') ADVANCE(129);
      if (lookahead == '2') ADVANCE(62);
      if (lookahead == ';') ADVANCE(39);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '>') ADVANCE(109);
      if (lookahead == '[') ADVANCE(80);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == ']') ADVANCE(81);
      if (lookahead == 'c') ADVANCE(130);
      if (lookahead == 'e') ADVANCE(136);
      if (lookahead == 'i') ADVANCE(134);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead == '|') ADVANCE(38);
      if (lookahead == '}') ADVANCE(85);
      if (lookahead == '~') ADVANCE(116);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(61);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(126);
      if (lookahead != 0 &&
          lookahead != '^') ADVANCE(142);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(43);
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '#') ADVANCE(76);
      if (lookahead == '&') ADVANCE(41);
      if (lookahead == ')') ADVANCE(58);
      if (lookahead == '2') ADVANCE(18);
      if (lookahead == ';') ADVANCE(39);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '>') ADVANCE(109);
      if (lookahead == '|') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(17);
      if (anon_sym_LF_character_set_1(lookahead)) SKIP(1)
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(43);
      if (lookahead == '\r') ADVANCE(49);
      if (lookahead == '#') ADVANCE(76);
      if (lookahead == '&') ADVANCE(40);
      if (lookahead == ';') ADVANCE(39);
      if (lookahead == 'i') ADVANCE(24);
      if (anon_sym_LF_character_set_1(lookahead)) SKIP(2)
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(44);
      if (lookahead == '\r') ADVANCE(50);
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '#') ADVANCE(76);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '&') ADVANCE(40);
      if (lookahead == '\'') ADVANCE(90);
      if (lookahead == '(') ADVANCE(56);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == ';') ADVANCE(39);
      if (lookahead == '[') ADVANCE(80);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == ']') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(136);
      if (lookahead == 'i') ADVANCE(135);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead == '~') ADVANCE(116);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(3)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(119);
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(142);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(45);
      if (lookahead == '\r') ADVANCE(51);
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '#') ADVANCE(76);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '&') ADVANCE(40);
      if (lookahead == '\'') ADVANCE(90);
      if (lookahead == '(') ADVANCE(56);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == ';') ADVANCE(39);
      if (lookahead == '[') ADVANCE(80);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == ']') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(137);
      if (lookahead == 'i') ADVANCE(135);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead == '~') ADVANCE(116);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(4)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(120);
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(142);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(46);
      if (lookahead == '\r') ADVANCE(52);
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '#') ADVANCE(76);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '&') ADVANCE(41);
      if (lookahead == '\'') ADVANCE(90);
      if (lookahead == '(') ADVANCE(56);
      if (lookahead == ')') ADVANCE(58);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == '2') ADVANCE(62);
      if (lookahead == ';') ADVANCE(39);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '>') ADVANCE(109);
      if (lookahead == '[') ADVANCE(80);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == ']') ADVANCE(81);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead == '|') ADVANCE(38);
      if (lookahead == '~') ADVANCE(116);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(5)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(61);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(121);
      if (lookahead != 0 &&
          lookahead != '^' &&
          lookahead != '}') ADVANCE(142);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(47);
      if (lookahead == '\r') ADVANCE(53);
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '#') ADVANCE(76);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '&') ADVANCE(40);
      if (lookahead == '\'') ADVANCE(90);
      if (lookahead == '(') ADVANCE(56);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == ';') ADVANCE(39);
      if (lookahead == '[') ADVANCE(80);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == ']') ADVANCE(81);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead == '~') ADVANCE(116);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(6)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(122);
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(142);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '#') ADVANCE(76);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '\'') ADVANCE(90);
      if (lookahead == '(') ADVANCE(56);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == '[') ADVANCE(80);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == ']') ADVANCE(81);
      if (lookahead == 'c') ADVANCE(130);
      if (lookahead == 'e') ADVANCE(137);
      if (lookahead == 'i') ADVANCE(135);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead == '~') ADVANCE(116);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(123);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(142);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '#') ADVANCE(76);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '\'') ADVANCE(90);
      if (lookahead == '(') ADVANCE(56);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == '[') ADVANCE(80);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == ']') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(137);
      if (lookahead == 'i') ADVANCE(135);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead == '~') ADVANCE(116);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(124);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(142);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '#') ADVANCE(76);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '\'') ADVANCE(90);
      if (lookahead == '(') ADVANCE(56);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == '[') ADVANCE(80);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == ']') ADVANCE(81);
      if (lookahead == 'i') ADVANCE(135);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead == '~') ADVANCE(116);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(9)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(125);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(142);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '#') ADVANCE(114);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '\'') ADVANCE(90);
      if (lookahead == '(') ADVANCE(56);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == '[') ADVANCE(80);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == ']') ADVANCE(81);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead == '~') ADVANCE(116);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(10)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(128);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(142);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '#') ADVANCE(76);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '\'') ADVANCE(90);
      if (lookahead == '(') ADVANCE(56);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == '[') ADVANCE(80);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == ']') ADVANCE(81);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead == '~') ADVANCE(116);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(127);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(142);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '#') ADVANCE(143);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '\'') ADVANCE(90);
      if (lookahead == '(') ADVANCE(56);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(145);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead == '}') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      if (sym_brace_word_character_set_1(lookahead)) ADVANCE(144);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(147);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '#') ADVANCE(87);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '(') ADVANCE(57);
      if (lookahead == '\\') ADVANCE(19);
      if (sym_brace_word_character_set_1(lookahead)) ADVANCE(88);
      if (lookahead != 0) ADVANCE(89);
      END_STATE();
    case 14:
      if (lookahead == '#') ADVANCE(76);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '(') ADVANCE(56);
      if (sym_brace_word_character_set_1(lookahead)) SKIP(14)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(77);
      END_STATE();
    case 15:
      if (lookahead == '#') ADVANCE(91);
      if (lookahead == '\'') ADVANCE(90);
      if (lookahead == '\\') ADVANCE(19);
      if (sym_brace_word_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead != 0) ADVANCE(93);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(78);
      END_STATE();
    case 17:
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '>') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(17);
      END_STATE();
    case 18:
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '>') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(17);
      END_STATE();
    case 19:
      if (lookahead == 'U') ADVANCE(104);
      if (lookahead == 'X') ADVANCE(98);
      if (lookahead == 'c') ADVANCE(105);
      if (lookahead == 'u') ADVANCE(100);
      if (lookahead == 'x') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(96);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(27);
      END_STATE();
    case 21:
      if (lookahead == 'd') ADVANCE(59);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(68);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 24:
      if (lookahead == 'f') ADVANCE(72);
      END_STATE();
    case 25:
      if (lookahead == 'f') ADVANCE(72);
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 26:
      if (lookahead == 'l') ADVANCE(28);
      if (lookahead == 'n') ADVANCE(21);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(22);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(23);
      END_STATE();
    case 29:
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '2')) ADVANCE(106);
      END_STATE();
    case 30:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 31:
      if (eof) ADVANCE(33);
      if (lookahead == '\n') ADVANCE(42);
      if (lookahead == '\r') ADVANCE(48);
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '#') ADVANCE(76);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '&') ADVANCE(40);
      if (lookahead == '\'') ADVANCE(90);
      if (lookahead == '(') ADVANCE(56);
      if (lookahead == ')') ADVANCE(58);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == ';') ADVANCE(39);
      if (lookahead == '[') ADVANCE(80);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == ']') ADVANCE(81);
      if (lookahead == 'i') ADVANCE(135);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead == '~') ADVANCE(116);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(31)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(118);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(142);
      END_STATE();
    case 32:
      if (eof) ADVANCE(33);
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '#') ADVANCE(76);
      if (lookahead == '$') ADVANCE(55);
      if (lookahead == '\'') ADVANCE(90);
      if (lookahead == '(') ADVANCE(56);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(30);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '[') ADVANCE(80);
      if (lookahead == ']') ADVANCE(81);
      if (lookahead == 'c') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(26);
      if (lookahead == 'i') ADVANCE(25);
      if (lookahead == '}') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      if (sym_brace_word_character_set_1(lookahead)) SKIP(32)
      END_STATE();
    case 33:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_AMP_PIPE);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_2_GT_PIPE);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(34);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(35);
      if (lookahead == '<') ADVANCE(107);
      if (lookahead == '>') ADVANCE(112);
      if (lookahead == '|') ADVANCE(36);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(42);
      if (lookahead == '\r') ADVANCE(48);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(118);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(43);
      if (lookahead == '\r') ADVANCE(49);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(44);
      if (lookahead == '\r') ADVANCE(50);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(119);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(45);
      if (lookahead == '\r') ADVANCE(51);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(120);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(46);
      if (lookahead == '\r') ADVANCE(52);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(121);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(47);
      if (lookahead == '\r') ADVANCE(53);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(122);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\n') ADVANCE(42);
      if (lookahead == '\r') ADVANCE(48);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(118);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\n') ADVANCE(43);
      if (lookahead == '\r') ADVANCE(49);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\n') ADVANCE(44);
      if (lookahead == '\r') ADVANCE(50);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(119);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\n') ADVANCE(45);
      if (lookahead == '\r') ADVANCE(51);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(120);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\n') ADVANCE(46);
      if (lookahead == '\r') ADVANCE(52);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(121);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\n') ADVANCE(47);
      if (lookahead == '\r') ADVANCE(53);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(122);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(89);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_end);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(141);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '>') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(61);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(142);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(141);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '>') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(61);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(142);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(146);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(147);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_integer);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(147);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_case);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_in);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_if);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_else);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(76);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_variable_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(77);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_COMMA);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(aux_sym_double_quote_string_token1);
      if (lookahead == '\n') ADVANCE(89);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(87);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(aux_sym_double_quote_string_token1);
      if (lookahead == '#') ADVANCE(87);
      if (lookahead == '(') ADVANCE(57);
      if (sym_brace_word_character_set_1(lookahead)) ADVANCE(88);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '\\') ADVANCE(89);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(aux_sym_double_quote_string_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(89);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym_single_quote_string_token1);
      if (lookahead == '\n') ADVANCE(93);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(91);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym_single_quote_string_token1);
      if (lookahead == '#') ADVANCE(91);
      if (sym_brace_word_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(93);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_single_quote_string_token1);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(93);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(94);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(95);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(94);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(97);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(98);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(99);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(100);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(101);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(102);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(103);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(94);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_stream_redirect);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_direction);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_direction);
      if (lookahead == '&') ADVANCE(29);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_direction);
      if (lookahead == '&') ADVANCE(29);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '?') ADVANCE(107);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_direction);
      if (lookahead == '&') ADVANCE(29);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '?') ADVANCE(107);
      if (lookahead == '|') ADVANCE(37);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_direction);
      if (lookahead == '&') ADVANCE(29);
      if (lookahead == '?') ADVANCE(107);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_direction);
      if (lookahead == '>') ADVANCE(113);
      if (lookahead == '?') ADVANCE(107);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_direction);
      if (lookahead == '?') ADVANCE(107);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_home_dir_expansion);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_glob);
      if (lookahead == '*') ADVANCE(117);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(42);
      if (lookahead == '\r') ADVANCE(48);
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == 'i') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(118);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\f' < lookahead) &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || '*' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(142);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(44);
      if (lookahead == '\r') ADVANCE(50);
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == 'e') ADVANCE(136);
      if (lookahead == 'i') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(119);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\f' < lookahead) &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || '*' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(142);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(45);
      if (lookahead == '\r') ADVANCE(51);
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == 'e') ADVANCE(137);
      if (lookahead == 'i') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(120);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\f' < lookahead) &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || '*' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(142);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(46);
      if (lookahead == '\r') ADVANCE(52);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == '2') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(61);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(121);
      if (!sym_word_character_set_3(lookahead)) ADVANCE(142);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(47);
      if (lookahead == '\r') ADVANCE(53);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(122);
      if (!sym_word_character_set_3(lookahead)) ADVANCE(142);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == 'c') ADVANCE(130);
      if (lookahead == 'e') ADVANCE(137);
      if (lookahead == 'i') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(123);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || '*' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(142);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == 'e') ADVANCE(137);
      if (lookahead == 'i') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(124);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || '*' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(142);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == 'i') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(125);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || '*' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(142);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '#') ADVANCE(115);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (lookahead == ',') ADVANCE(84);
      if (lookahead == '.') ADVANCE(129);
      if (lookahead == '2') ADVANCE(62);
      if (lookahead == 'c') ADVANCE(130);
      if (lookahead == 'e') ADVANCE(136);
      if (lookahead == 'i') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(61);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(126);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || '*' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(142);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(127);
      if (!sym_word_character_set_4(lookahead)) ADVANCE(142);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(115);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) ADVANCE(128);
      if (!sym_word_character_set_4(lookahead)) ADVANCE(142);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '.') ADVANCE(79);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(138);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'd') ADVANCE(60);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(69);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(75);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'f') ADVANCE(73);
      if (lookahead == 'n') ADVANCE(71);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'f') ADVANCE(73);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(139);
      if (lookahead == 'n') ADVANCE(131);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(131);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(132);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(133);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_word);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_word);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_word);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_brace_word);
      if (lookahead == '\n') ADVANCE(147);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(143);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_brace_word);
      if (lookahead == '#') ADVANCE(143);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      if (sym_brace_word_character_set_1(lookahead)) ADVANCE(144);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '\'' || ',' < lookahead) &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(147);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_brace_word);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(147);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_brace_word);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(147);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_brace_word);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '\'' || '*' < lookahead) &&
          lookahead != ',' &&
          lookahead != '\\' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(147);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'f') ADVANCE(4);
      if (lookahead == 'n') ADVANCE(5);
      if (lookahead == 'o') ADVANCE(6);
      if (lookahead == 'r') ADVANCE(7);
      if (lookahead == 's') ADVANCE(8);
      if (lookahead == 'w') ADVANCE(9);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 133 ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8202) ||
          lookahead == 8232 ||
          lookahead == 8233 ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 12288) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(10);
      END_STATE();
    case 2:
      if (lookahead == 'e') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      END_STATE();
    case 3:
      if (lookahead == 'o') ADVANCE(13);
      END_STATE();
    case 4:
      if (lookahead == 'o') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      END_STATE();
    case 5:
      if (lookahead == 'o') ADVANCE(16);
      END_STATE();
    case 6:
      if (lookahead == 'r') ADVANCE(17);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(18);
      END_STATE();
    case 8:
      if (lookahead == 'w') ADVANCE(19);
      END_STATE();
    case 9:
      if (lookahead == 'h') ADVANCE(20);
      END_STATE();
    case 10:
      if (lookahead == 'd') ADVANCE(21);
      END_STATE();
    case 11:
      if (lookahead == 'g') ADVANCE(22);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(23);
      END_STATE();
    case 13:
      if (lookahead == 'n') ADVANCE(24);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(25);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(26);
      END_STATE();
    case 16:
      if (lookahead == 't') ADVANCE(27);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 18:
      if (lookahead == 't') ADVANCE(28);
      END_STATE();
    case 19:
      if (lookahead == 'i') ADVANCE(29);
      END_STATE();
    case 20:
      if (lookahead == 'i') ADVANCE(30);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 22:
      if (lookahead == 'i') ADVANCE(31);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(32);
      END_STATE();
    case 24:
      if (lookahead == 't') ADVANCE(33);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 26:
      if (lookahead == 'c') ADVANCE(34);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 28:
      if (lookahead == 'u') ADVANCE(35);
      END_STATE();
    case 29:
      if (lookahead == 't') ADVANCE(36);
      END_STATE();
    case 30:
      if (lookahead == 'l') ADVANCE(37);
      END_STATE();
    case 31:
      if (lookahead == 'n') ADVANCE(38);
      END_STATE();
    case 32:
      if (lookahead == 'k') ADVANCE(39);
      END_STATE();
    case 33:
      if (lookahead == 'i') ADVANCE(40);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(41);
      END_STATE();
    case 35:
      if (lookahead == 'r') ADVANCE(42);
      END_STATE();
    case 36:
      if (lookahead == 'c') ADVANCE(43);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_begin);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_break);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(45);
      END_STATE();
    case 41:
      if (lookahead == 'i') ADVANCE(46);
      END_STATE();
    case 42:
      if (lookahead == 'n') ADVANCE(47);
      END_STATE();
    case 43:
      if (lookahead == 'h') ADVANCE(48);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 45:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 46:
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 50:
      if (lookahead == 'n') ADVANCE(52);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_continue);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 31},
  [2] = {.lex_state = 3},
  [3] = {.lex_state = 3},
  [4] = {.lex_state = 3},
  [5] = {.lex_state = 3},
  [6] = {.lex_state = 3},
  [7] = {.lex_state = 4},
  [8] = {.lex_state = 4},
  [9] = {.lex_state = 4},
  [10] = {.lex_state = 4},
  [11] = {.lex_state = 4},
  [12] = {.lex_state = 4},
  [13] = {.lex_state = 4},
  [14] = {.lex_state = 31},
  [15] = {.lex_state = 31},
  [16] = {.lex_state = 31},
  [17] = {.lex_state = 31},
  [18] = {.lex_state = 31},
  [19] = {.lex_state = 31},
  [20] = {.lex_state = 31},
  [21] = {.lex_state = 31},
  [22] = {.lex_state = 31},
  [23] = {.lex_state = 31},
  [24] = {.lex_state = 31},
  [25] = {.lex_state = 31},
  [26] = {.lex_state = 31},
  [27] = {.lex_state = 31},
  [28] = {.lex_state = 31},
  [29] = {.lex_state = 31},
  [30] = {.lex_state = 31},
  [31] = {.lex_state = 31},
  [32] = {.lex_state = 31},
  [33] = {.lex_state = 31},
  [34] = {.lex_state = 31},
  [35] = {.lex_state = 31},
  [36] = {.lex_state = 31},
  [37] = {.lex_state = 31},
  [38] = {.lex_state = 31},
  [39] = {.lex_state = 31},
  [40] = {.lex_state = 31},
  [41] = {.lex_state = 31},
  [42] = {.lex_state = 31},
  [43] = {.lex_state = 31},
  [44] = {.lex_state = 31},
  [45] = {.lex_state = 7},
  [46] = {.lex_state = 7},
  [47] = {.lex_state = 7},
  [48] = {.lex_state = 8},
  [49] = {.lex_state = 8},
  [50] = {.lex_state = 8},
  [51] = {.lex_state = 8},
  [52] = {.lex_state = 8},
  [53] = {.lex_state = 8},
  [54] = {.lex_state = 8},
  [55] = {.lex_state = 8},
  [56] = {.lex_state = 8},
  [57] = {.lex_state = 8},
  [58] = {.lex_state = 8},
  [59] = {.lex_state = 8},
  [60] = {.lex_state = 8},
  [61] = {.lex_state = 8},
  [62] = {.lex_state = 8},
  [63] = {.lex_state = 8},
  [64] = {.lex_state = 8},
  [65] = {.lex_state = 8},
  [66] = {.lex_state = 8},
  [67] = {.lex_state = 8},
  [68] = {.lex_state = 8},
  [69] = {.lex_state = 8},
  [70] = {.lex_state = 8},
  [71] = {.lex_state = 9},
  [72] = {.lex_state = 9},
  [73] = {.lex_state = 9},
  [74] = {.lex_state = 9},
  [75] = {.lex_state = 9},
  [76] = {.lex_state = 9},
  [77] = {.lex_state = 9},
  [78] = {.lex_state = 5},
  [79] = {.lex_state = 5},
  [80] = {.lex_state = 5},
  [81] = {.lex_state = 5},
  [82] = {.lex_state = 3},
  [83] = {.lex_state = 3},
  [84] = {.lex_state = 4},
  [85] = {.lex_state = 4},
  [86] = {.lex_state = 31},
  [87] = {.lex_state = 31},
  [88] = {.lex_state = 5, .external_lex_state = 2},
  [89] = {.lex_state = 5, .external_lex_state = 2},
  [90] = {.lex_state = 5, .external_lex_state = 2},
  [91] = {.lex_state = 5, .external_lex_state = 2},
  [92] = {.lex_state = 5, .external_lex_state = 2},
  [93] = {.lex_state = 5, .external_lex_state = 3},
  [94] = {.lex_state = 5, .external_lex_state = 2},
  [95] = {.lex_state = 7},
  [96] = {.lex_state = 5, .external_lex_state = 3},
  [97] = {.lex_state = 5, .external_lex_state = 2},
  [98] = {.lex_state = 5, .external_lex_state = 2},
  [99] = {.lex_state = 5, .external_lex_state = 3},
  [100] = {.lex_state = 5, .external_lex_state = 3},
  [101] = {.lex_state = 6},
  [102] = {.lex_state = 5, .external_lex_state = 3},
  [103] = {.lex_state = 6},
  [104] = {.lex_state = 5, .external_lex_state = 3},
  [105] = {.lex_state = 5, .external_lex_state = 3},
  [106] = {.lex_state = 5, .external_lex_state = 3},
  [107] = {.lex_state = 6},
  [108] = {.lex_state = 5, .external_lex_state = 3},
  [109] = {.lex_state = 6},
  [110] = {.lex_state = 5, .external_lex_state = 3},
  [111] = {.lex_state = 5, .external_lex_state = 3},
  [112] = {.lex_state = 5, .external_lex_state = 3},
  [113] = {.lex_state = 5, .external_lex_state = 3},
  [114] = {.lex_state = 6},
  [115] = {.lex_state = 6},
  [116] = {.lex_state = 6},
  [117] = {.lex_state = 5, .external_lex_state = 3},
  [118] = {.lex_state = 5, .external_lex_state = 3},
  [119] = {.lex_state = 5, .external_lex_state = 3},
  [120] = {.lex_state = 5, .external_lex_state = 3},
  [121] = {.lex_state = 8},
  [122] = {.lex_state = 5},
  [123] = {.lex_state = 5},
  [124] = {.lex_state = 5},
  [125] = {.lex_state = 11},
  [126] = {.lex_state = 11},
  [127] = {.lex_state = 12},
  [128] = {.lex_state = 12},
  [129] = {.lex_state = 6, .external_lex_state = 2},
  [130] = {.lex_state = 6, .external_lex_state = 2},
  [131] = {.lex_state = 6, .external_lex_state = 2},
  [132] = {.lex_state = 12},
  [133] = {.lex_state = 11},
  [134] = {.lex_state = 6, .external_lex_state = 2},
  [135] = {.lex_state = 11},
  [136] = {.lex_state = 12},
  [137] = {.lex_state = 6, .external_lex_state = 2},
  [138] = {.lex_state = 11},
  [139] = {.lex_state = 11},
  [140] = {.lex_state = 12},
  [141] = {.lex_state = 10},
  [142] = {.lex_state = 6, .external_lex_state = 3},
  [143] = {.lex_state = 6, .external_lex_state = 2},
  [144] = {.lex_state = 6, .external_lex_state = 2},
  [145] = {.lex_state = 6, .external_lex_state = 2},
  [146] = {.lex_state = 6, .external_lex_state = 3},
  [147] = {.lex_state = 6, .external_lex_state = 3},
  [148] = {.lex_state = 6, .external_lex_state = 3},
  [149] = {.lex_state = 10},
  [150] = {.lex_state = 10},
  [151] = {.lex_state = 12},
  [152] = {.lex_state = 10},
  [153] = {.lex_state = 6, .external_lex_state = 3},
  [154] = {.lex_state = 6, .external_lex_state = 3},
  [155] = {.lex_state = 6, .external_lex_state = 3},
  [156] = {.lex_state = 6, .external_lex_state = 3},
  [157] = {.lex_state = 6, .external_lex_state = 3},
  [158] = {.lex_state = 6, .external_lex_state = 3},
  [159] = {.lex_state = 6, .external_lex_state = 3},
  [160] = {.lex_state = 6, .external_lex_state = 3},
  [161] = {.lex_state = 6, .external_lex_state = 3},
  [162] = {.lex_state = 6, .external_lex_state = 3},
  [163] = {.lex_state = 6, .external_lex_state = 3},
  [164] = {.lex_state = 6, .external_lex_state = 3},
  [165] = {.lex_state = 6, .external_lex_state = 3},
  [166] = {.lex_state = 6},
  [167] = {.lex_state = 6},
  [168] = {.lex_state = 1, .external_lex_state = 2},
  [169] = {.lex_state = 1, .external_lex_state = 2},
  [170] = {.lex_state = 12},
  [171] = {.lex_state = 1, .external_lex_state = 2},
  [172] = {.lex_state = 1, .external_lex_state = 2},
  [173] = {.lex_state = 1, .external_lex_state = 2},
  [174] = {.lex_state = 1, .external_lex_state = 3},
  [175] = {.lex_state = 1, .external_lex_state = 2},
  [176] = {.lex_state = 1, .external_lex_state = 2},
  [177] = {.lex_state = 1, .external_lex_state = 3},
  [178] = {.lex_state = 1, .external_lex_state = 3},
  [179] = {.lex_state = 1, .external_lex_state = 2},
  [180] = {.lex_state = 1, .external_lex_state = 3},
  [181] = {.lex_state = 1},
  [182] = {.lex_state = 1},
  [183] = {.lex_state = 1, .external_lex_state = 3},
  [184] = {.lex_state = 1, .external_lex_state = 3},
  [185] = {.lex_state = 32},
  [186] = {.lex_state = 1, .external_lex_state = 3},
  [187] = {.lex_state = 1, .external_lex_state = 3},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 1},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 1},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 1},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 32},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 32},
  [198] = {.lex_state = 32},
  [199] = {.lex_state = 1},
  [200] = {.lex_state = 1, .external_lex_state = 3},
  [201] = {.lex_state = 32},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 32},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 32},
  [208] = {.lex_state = 1, .external_lex_state = 3},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 32},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 32},
  [215] = {.lex_state = 32},
  [216] = {.lex_state = 1},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 32},
  [221] = {.lex_state = 1, .external_lex_state = 3},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 32},
  [224] = {.lex_state = 1, .external_lex_state = 3},
  [225] = {.lex_state = 32},
  [226] = {.lex_state = 32},
  [227] = {.lex_state = 1, .external_lex_state = 3},
  [228] = {.lex_state = 1, .external_lex_state = 3},
  [229] = {.lex_state = 1, .external_lex_state = 3},
  [230] = {.lex_state = 1, .external_lex_state = 3},
  [231] = {.lex_state = 32},
  [232] = {.lex_state = 1, .external_lex_state = 3},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 1},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 1},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 1},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 1},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 1},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 1},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 1},
  [259] = {.lex_state = 1},
  [260] = {.lex_state = 1},
  [261] = {.lex_state = 1},
  [262] = {.lex_state = 1},
  [263] = {.lex_state = 1},
  [264] = {.lex_state = 1},
  [265] = {.lex_state = 1},
  [266] = {.lex_state = 1},
  [267] = {.lex_state = 1},
  [268] = {.lex_state = 1},
  [269] = {.lex_state = 1},
  [270] = {.lex_state = 1},
  [271] = {.lex_state = 1},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 1},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 1},
  [277] = {.lex_state = 32},
  [278] = {.lex_state = 32},
  [279] = {.lex_state = 32, .external_lex_state = 4},
  [280] = {.lex_state = 32, .external_lex_state = 4},
  [281] = {.lex_state = 32, .external_lex_state = 4},
  [282] = {.lex_state = 32, .external_lex_state = 4},
  [283] = {.lex_state = 32, .external_lex_state = 4},
  [284] = {.lex_state = 13},
  [285] = {.lex_state = 13},
  [286] = {.lex_state = 13},
  [287] = {.lex_state = 13},
  [288] = {.lex_state = 13},
  [289] = {.lex_state = 13},
  [290] = {.lex_state = 13},
  [291] = {.lex_state = 2, .external_lex_state = 2},
  [292] = {.lex_state = 13},
  [293] = {.lex_state = 2, .external_lex_state = 2},
  [294] = {.lex_state = 13},
  [295] = {.lex_state = 13},
  [296] = {.lex_state = 2, .external_lex_state = 2},
  [297] = {.lex_state = 2, .external_lex_state = 2},
  [298] = {.lex_state = 2, .external_lex_state = 2},
  [299] = {.lex_state = 13},
  [300] = {.lex_state = 32, .external_lex_state = 4},
  [301] = {.lex_state = 13},
  [302] = {.lex_state = 32, .external_lex_state = 4},
  [303] = {.lex_state = 32, .external_lex_state = 4},
  [304] = {.lex_state = 13},
  [305] = {.lex_state = 2, .external_lex_state = 2},
  [306] = {.lex_state = 32},
  [307] = {.lex_state = 13, .external_lex_state = 4},
  [308] = {.lex_state = 32},
  [309] = {.lex_state = 32},
  [310] = {.lex_state = 32},
  [311] = {.lex_state = 13, .external_lex_state = 4},
  [312] = {.lex_state = 32},
  [313] = {.lex_state = 32},
  [314] = {.lex_state = 32},
  [315] = {.lex_state = 2, .external_lex_state = 3},
  [316] = {.lex_state = 2, .external_lex_state = 3},
  [317] = {.lex_state = 32},
  [318] = {.lex_state = 2, .external_lex_state = 3},
  [319] = {.lex_state = 13, .external_lex_state = 4},
  [320] = {.lex_state = 13, .external_lex_state = 4},
  [321] = {.lex_state = 13, .external_lex_state = 4},
  [322] = {.lex_state = 2, .external_lex_state = 3},
  [323] = {.lex_state = 2, .external_lex_state = 2},
  [324] = {.lex_state = 32},
  [325] = {.lex_state = 32},
  [326] = {.lex_state = 2, .external_lex_state = 2},
  [327] = {.lex_state = 32},
  [328] = {.lex_state = 32},
  [329] = {.lex_state = 2, .external_lex_state = 3},
  [330] = {.lex_state = 2, .external_lex_state = 3},
  [331] = {.lex_state = 13, .external_lex_state = 4},
  [332] = {.lex_state = 2, .external_lex_state = 3},
  [333] = {.lex_state = 13, .external_lex_state = 4},
  [334] = {.lex_state = 2, .external_lex_state = 3},
  [335] = {.lex_state = 2},
  [336] = {.lex_state = 2, .external_lex_state = 3},
  [337] = {.lex_state = 2, .external_lex_state = 3},
  [338] = {.lex_state = 2, .external_lex_state = 3},
  [339] = {.lex_state = 2, .external_lex_state = 3},
  [340] = {.lex_state = 2, .external_lex_state = 3},
  [341] = {.lex_state = 2, .external_lex_state = 3},
  [342] = {.lex_state = 2, .external_lex_state = 3},
  [343] = {.lex_state = 2, .external_lex_state = 3},
  [344] = {.lex_state = 13, .external_lex_state = 4},
  [345] = {.lex_state = 2, .external_lex_state = 3},
  [346] = {.lex_state = 32},
  [347] = {.lex_state = 13},
  [348] = {.lex_state = 32, .external_lex_state = 5},
  [349] = {.lex_state = 32, .external_lex_state = 5},
  [350] = {.lex_state = 32},
  [351] = {.lex_state = 32, .external_lex_state = 5},
  [352] = {.lex_state = 2},
  [353] = {.lex_state = 32, .external_lex_state = 5},
  [354] = {.lex_state = 32, .external_lex_state = 5},
  [355] = {.lex_state = 13},
  [356] = {.lex_state = 13},
  [357] = {.lex_state = 13},
  [358] = {.lex_state = 32, .external_lex_state = 5},
  [359] = {.lex_state = 32},
  [360] = {.lex_state = 32},
  [361] = {.lex_state = 15},
  [362] = {.lex_state = 32},
  [363] = {.lex_state = 32},
  [364] = {.lex_state = 15},
  [365] = {.lex_state = 14},
  [366] = {.lex_state = 14},
  [367] = {.lex_state = 15},
  [368] = {.lex_state = 14},
  [369] = {.lex_state = 14},
  [370] = {.lex_state = 32, .external_lex_state = 6},
  [371] = {.lex_state = 15},
  [372] = {.lex_state = 15},
  [373] = {.lex_state = 15},
  [374] = {.lex_state = 15},
  [375] = {.lex_state = 15},
  [376] = {.lex_state = 15},
  [377] = {.lex_state = 15},
  [378] = {.lex_state = 32, .external_lex_state = 6},
  [379] = {.lex_state = 14},
  [380] = {.lex_state = 32, .external_lex_state = 6},
  [381] = {.lex_state = 15},
  [382] = {.lex_state = 15},
  [383] = {.lex_state = 14},
  [384] = {.lex_state = 15},
  [385] = {.lex_state = 14},
  [386] = {.lex_state = 32, .external_lex_state = 5},
  [387] = {.lex_state = 32, .external_lex_state = 5},
  [388] = {.lex_state = 14},
  [389] = {.lex_state = 32},
  [390] = {.lex_state = 32, .external_lex_state = 6},
  [391] = {.lex_state = 32, .external_lex_state = 6},
  [392] = {.lex_state = 32, .external_lex_state = 6},
  [393] = {.lex_state = 32, .external_lex_state = 6},
  [394] = {.lex_state = 32},
  [395] = {.lex_state = 14},
  [396] = {.lex_state = 14},
  [397] = {.lex_state = 32, .external_lex_state = 6},
  [398] = {.lex_state = 32, .external_lex_state = 6},
  [399] = {.lex_state = 32},
  [400] = {.lex_state = 32},
  [401] = {.lex_state = 32, .external_lex_state = 6},
  [402] = {.lex_state = 32},
  [403] = {.lex_state = 32, .external_lex_state = 6},
  [404] = {.lex_state = 32, .external_lex_state = 6},
  [405] = {.lex_state = 32},
  [406] = {.lex_state = 32},
  [407] = {.lex_state = 32, .external_lex_state = 6},
  [408] = {.lex_state = 32, .external_lex_state = 6},
  [409] = {.lex_state = 32},
  [410] = {.lex_state = 32},
  [411] = {.lex_state = 32, .external_lex_state = 6},
  [412] = {.lex_state = 32},
  [413] = {.lex_state = 14},
  [414] = {.lex_state = 14},
  [415] = {.lex_state = 14},
  [416] = {.lex_state = 32},
  [417] = {.lex_state = 32},
  [418] = {.lex_state = 14},
  [419] = {.lex_state = 32},
  [420] = {.lex_state = 32},
  [421] = {.lex_state = 32},
  [422] = {.lex_state = 32},
  [423] = {.lex_state = 32},
  [424] = {.lex_state = 32},
  [425] = {.lex_state = 32},
  [426] = {.lex_state = 32},
  [427] = {.lex_state = 32},
  [428] = {.lex_state = 32},
  [429] = {.lex_state = 32},
  [430] = {.lex_state = 32},
  [431] = {.lex_state = 32},
  [432] = {.lex_state = 14},
  [433] = {.lex_state = 32},
  [434] = {.lex_state = 32},
  [435] = {.lex_state = 32},
  [436] = {.lex_state = 32},
  [437] = {.lex_state = 32},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_word] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_AMP_PIPE] = ACTIONS(1),
    [anon_sym_2_GT_PIPE] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_continue] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_begin] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_stream_redirect] = ACTIONS(1),
    [sym_direction] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [sym_home_dir_expansion] = ACTIONS(1),
    [sym_glob] = ACTIONS(1),
    [sym__concat] = ACTIONS(1),
    [sym__brace_concat] = ACTIONS(1),
    [sym__concat_list] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(435),
    [sym_conditional_execution] = STATE(244),
    [sym_pipe] = STATE(244),
    [sym_redirect_statement] = STATE(244),
    [sym_negated_statement] = STATE(244),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(244),
    [sym_return] = STATE(244),
    [sym_switch_statement] = STATE(244),
    [sym_for_statement] = STATE(244),
    [sym_while_statement] = STATE(244),
    [sym_if_statement] = STATE(244),
    [sym_begin_statement] = STATE(244),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(244),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(26),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_LF] = ACTIONS(11),
    [anon_sym_CR] = ACTIONS(11),
    [anon_sym_CR_LF] = ACTIONS(11),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(25),
    [sym_continue] = ACTIONS(25),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [2] = {
    [sym_conditional_execution] = STATE(256),
    [sym_pipe] = STATE(256),
    [sym_redirect_statement] = STATE(256),
    [sym__terminated_opt_statement] = STATE(6),
    [sym_negated_statement] = STATE(256),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(256),
    [sym_return] = STATE(256),
    [sym_switch_statement] = STATE(256),
    [sym_for_statement] = STATE(256),
    [sym_while_statement] = STATE(256),
    [sym_if_statement] = STATE(256),
    [sym_else_if_clause] = STATE(346),
    [sym_else_clause] = STATE(437),
    [sym_begin_statement] = STATE(256),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(256),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_while_statement_repeat1] = STATE(6),
    [aux_sym_if_statement_repeat1] = STATE(346),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_AMP] = ACTIONS(43),
    [anon_sym_LF] = ACTIONS(43),
    [anon_sym_CR] = ACTIONS(43),
    [anon_sym_CR_LF] = ACTIONS(43),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_end] = ACTIONS(45),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(47),
    [sym_continue] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_else] = ACTIONS(49),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [3] = {
    [sym_conditional_execution] = STATE(256),
    [sym_pipe] = STATE(256),
    [sym_redirect_statement] = STATE(256),
    [sym__terminated_opt_statement] = STATE(2),
    [sym_negated_statement] = STATE(256),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(256),
    [sym_return] = STATE(256),
    [sym_switch_statement] = STATE(256),
    [sym_for_statement] = STATE(256),
    [sym_while_statement] = STATE(256),
    [sym_if_statement] = STATE(256),
    [sym_else_if_clause] = STATE(350),
    [sym_else_clause] = STATE(431),
    [sym_begin_statement] = STATE(256),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(256),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_while_statement_repeat1] = STATE(2),
    [aux_sym_if_statement_repeat1] = STATE(350),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_AMP] = ACTIONS(51),
    [anon_sym_LF] = ACTIONS(51),
    [anon_sym_CR] = ACTIONS(51),
    [anon_sym_CR_LF] = ACTIONS(51),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_end] = ACTIONS(53),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(47),
    [sym_continue] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_else] = ACTIONS(49),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [4] = {
    [sym_conditional_execution] = STATE(256),
    [sym_pipe] = STATE(256),
    [sym_redirect_statement] = STATE(256),
    [sym__terminated_opt_statement] = STATE(5),
    [sym_negated_statement] = STATE(256),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(256),
    [sym_return] = STATE(256),
    [sym_switch_statement] = STATE(256),
    [sym_for_statement] = STATE(256),
    [sym_while_statement] = STATE(256),
    [sym_if_statement] = STATE(256),
    [sym_begin_statement] = STATE(256),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(256),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_while_statement_repeat1] = STATE(5),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(55),
    [anon_sym_AMP] = ACTIONS(55),
    [anon_sym_LF] = ACTIONS(55),
    [anon_sym_CR] = ACTIONS(55),
    [anon_sym_CR_LF] = ACTIONS(55),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_end] = ACTIONS(57),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(47),
    [sym_continue] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_else] = ACTIONS(57),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [5] = {
    [sym_conditional_execution] = STATE(256),
    [sym_pipe] = STATE(256),
    [sym_redirect_statement] = STATE(256),
    [sym__terminated_opt_statement] = STATE(6),
    [sym_negated_statement] = STATE(256),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(256),
    [sym_return] = STATE(256),
    [sym_switch_statement] = STATE(256),
    [sym_for_statement] = STATE(256),
    [sym_while_statement] = STATE(256),
    [sym_if_statement] = STATE(256),
    [sym_begin_statement] = STATE(256),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(256),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_while_statement_repeat1] = STATE(6),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_AMP] = ACTIONS(43),
    [anon_sym_LF] = ACTIONS(43),
    [anon_sym_CR] = ACTIONS(43),
    [anon_sym_CR_LF] = ACTIONS(43),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_end] = ACTIONS(59),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(47),
    [sym_continue] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_else] = ACTIONS(59),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [6] = {
    [sym_conditional_execution] = STATE(256),
    [sym_pipe] = STATE(256),
    [sym_redirect_statement] = STATE(256),
    [sym__terminated_opt_statement] = STATE(6),
    [sym_negated_statement] = STATE(256),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(256),
    [sym_return] = STATE(256),
    [sym_switch_statement] = STATE(256),
    [sym_for_statement] = STATE(256),
    [sym_while_statement] = STATE(256),
    [sym_if_statement] = STATE(256),
    [sym_begin_statement] = STATE(256),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(256),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_while_statement_repeat1] = STATE(6),
    [sym_word] = ACTIONS(61),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_SEMI] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [anon_sym_LF] = ACTIONS(67),
    [anon_sym_CR] = ACTIONS(67),
    [anon_sym_CR_LF] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(70),
    [anon_sym_not] = ACTIONS(70),
    [anon_sym_DOLLAR] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(76),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_end] = ACTIONS(82),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(84),
    [anon_sym_switch] = ACTIONS(87),
    [sym_break] = ACTIONS(90),
    [sym_continue] = ACTIONS(90),
    [anon_sym_for] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(96),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_else] = ACTIONS(82),
    [anon_sym_begin] = ACTIONS(102),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_RBRACK] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(108),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [anon_sym_SQUOTE] = ACTIONS(114),
    [sym_escape_sequence] = ACTIONS(61),
    [sym_home_dir_expansion] = ACTIONS(61),
    [sym_glob] = ACTIONS(61),
  },
  [7] = {
    [sym_conditional_execution] = STATE(235),
    [sym_pipe] = STATE(235),
    [sym_redirect_statement] = STATE(235),
    [sym__terminated_opt_statement] = STATE(13),
    [sym_negated_statement] = STATE(235),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(235),
    [sym_return] = STATE(235),
    [sym_switch_statement] = STATE(235),
    [sym_for_statement] = STATE(235),
    [sym_while_statement] = STATE(235),
    [sym_if_statement] = STATE(235),
    [sym_begin_statement] = STATE(235),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(235),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_while_statement_repeat1] = STATE(13),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(117),
    [anon_sym_AMP] = ACTIONS(117),
    [anon_sym_LF] = ACTIONS(117),
    [anon_sym_CR] = ACTIONS(117),
    [anon_sym_CR_LF] = ACTIONS(117),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_end] = ACTIONS(119),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(121),
    [sym_continue] = ACTIONS(121),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [8] = {
    [sym_conditional_execution] = STATE(235),
    [sym_pipe] = STATE(235),
    [sym_redirect_statement] = STATE(235),
    [sym__terminated_opt_statement] = STATE(9),
    [sym_negated_statement] = STATE(235),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(235),
    [sym_return] = STATE(235),
    [sym_switch_statement] = STATE(235),
    [sym_for_statement] = STATE(235),
    [sym_while_statement] = STATE(235),
    [sym_if_statement] = STATE(235),
    [sym_begin_statement] = STATE(235),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(235),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_while_statement_repeat1] = STATE(9),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym_AMP] = ACTIONS(123),
    [anon_sym_LF] = ACTIONS(123),
    [anon_sym_CR] = ACTIONS(123),
    [anon_sym_CR_LF] = ACTIONS(123),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_end] = ACTIONS(125),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(121),
    [sym_continue] = ACTIONS(121),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [9] = {
    [sym_conditional_execution] = STATE(235),
    [sym_pipe] = STATE(235),
    [sym_redirect_statement] = STATE(235),
    [sym__terminated_opt_statement] = STATE(10),
    [sym_negated_statement] = STATE(235),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(235),
    [sym_return] = STATE(235),
    [sym_switch_statement] = STATE(235),
    [sym_for_statement] = STATE(235),
    [sym_while_statement] = STATE(235),
    [sym_if_statement] = STATE(235),
    [sym_begin_statement] = STATE(235),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(235),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_while_statement_repeat1] = STATE(10),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(127),
    [anon_sym_AMP] = ACTIONS(127),
    [anon_sym_LF] = ACTIONS(127),
    [anon_sym_CR] = ACTIONS(127),
    [anon_sym_CR_LF] = ACTIONS(127),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_end] = ACTIONS(129),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(121),
    [sym_continue] = ACTIONS(121),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [10] = {
    [sym_conditional_execution] = STATE(235),
    [sym_pipe] = STATE(235),
    [sym_redirect_statement] = STATE(235),
    [sym__terminated_opt_statement] = STATE(10),
    [sym_negated_statement] = STATE(235),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(235),
    [sym_return] = STATE(235),
    [sym_switch_statement] = STATE(235),
    [sym_for_statement] = STATE(235),
    [sym_while_statement] = STATE(235),
    [sym_if_statement] = STATE(235),
    [sym_begin_statement] = STATE(235),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(235),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_while_statement_repeat1] = STATE(10),
    [sym_word] = ACTIONS(61),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_SEMI] = ACTIONS(131),
    [anon_sym_AMP] = ACTIONS(131),
    [anon_sym_LF] = ACTIONS(131),
    [anon_sym_CR] = ACTIONS(131),
    [anon_sym_CR_LF] = ACTIONS(131),
    [anon_sym_BANG] = ACTIONS(70),
    [anon_sym_not] = ACTIONS(70),
    [anon_sym_DOLLAR] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(76),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_end] = ACTIONS(82),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(84),
    [anon_sym_switch] = ACTIONS(87),
    [sym_break] = ACTIONS(134),
    [sym_continue] = ACTIONS(134),
    [anon_sym_for] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(96),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_begin] = ACTIONS(102),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_RBRACK] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(108),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [anon_sym_SQUOTE] = ACTIONS(114),
    [sym_escape_sequence] = ACTIONS(61),
    [sym_home_dir_expansion] = ACTIONS(61),
    [sym_glob] = ACTIONS(61),
  },
  [11] = {
    [sym_conditional_execution] = STATE(235),
    [sym_pipe] = STATE(235),
    [sym_redirect_statement] = STATE(235),
    [sym__terminated_opt_statement] = STATE(10),
    [sym_negated_statement] = STATE(235),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(235),
    [sym_return] = STATE(235),
    [sym_switch_statement] = STATE(235),
    [sym_for_statement] = STATE(235),
    [sym_while_statement] = STATE(235),
    [sym_if_statement] = STATE(235),
    [sym_begin_statement] = STATE(235),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(235),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_while_statement_repeat1] = STATE(10),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(127),
    [anon_sym_AMP] = ACTIONS(127),
    [anon_sym_LF] = ACTIONS(127),
    [anon_sym_CR] = ACTIONS(127),
    [anon_sym_CR_LF] = ACTIONS(127),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_end] = ACTIONS(137),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(121),
    [sym_continue] = ACTIONS(121),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [12] = {
    [sym_conditional_execution] = STATE(235),
    [sym_pipe] = STATE(235),
    [sym_redirect_statement] = STATE(235),
    [sym__terminated_opt_statement] = STATE(11),
    [sym_negated_statement] = STATE(235),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(235),
    [sym_return] = STATE(235),
    [sym_switch_statement] = STATE(235),
    [sym_for_statement] = STATE(235),
    [sym_while_statement] = STATE(235),
    [sym_if_statement] = STATE(235),
    [sym_begin_statement] = STATE(235),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(235),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_while_statement_repeat1] = STATE(11),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(139),
    [anon_sym_AMP] = ACTIONS(139),
    [anon_sym_LF] = ACTIONS(139),
    [anon_sym_CR] = ACTIONS(139),
    [anon_sym_CR_LF] = ACTIONS(139),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_end] = ACTIONS(141),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(121),
    [sym_continue] = ACTIONS(121),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [13] = {
    [sym_conditional_execution] = STATE(235),
    [sym_pipe] = STATE(235),
    [sym_redirect_statement] = STATE(235),
    [sym__terminated_opt_statement] = STATE(10),
    [sym_negated_statement] = STATE(235),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(235),
    [sym_return] = STATE(235),
    [sym_switch_statement] = STATE(235),
    [sym_for_statement] = STATE(235),
    [sym_while_statement] = STATE(235),
    [sym_if_statement] = STATE(235),
    [sym_begin_statement] = STATE(235),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(235),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_while_statement_repeat1] = STATE(10),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(127),
    [anon_sym_AMP] = ACTIONS(127),
    [anon_sym_LF] = ACTIONS(127),
    [anon_sym_CR] = ACTIONS(127),
    [anon_sym_CR_LF] = ACTIONS(127),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_end] = ACTIONS(143),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(121),
    [sym_continue] = ACTIONS(121),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [14] = {
    [sym_conditional_execution] = STATE(209),
    [sym_pipe] = STATE(209),
    [sym_redirect_statement] = STATE(209),
    [sym_negated_statement] = STATE(209),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(209),
    [sym_return] = STATE(209),
    [sym_switch_statement] = STATE(209),
    [sym_for_statement] = STATE(209),
    [sym_while_statement] = STATE(209),
    [sym_if_statement] = STATE(209),
    [sym_begin_statement] = STATE(209),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(209),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(32),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_CR] = ACTIONS(145),
    [anon_sym_CR_LF] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(149),
    [sym_continue] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [15] = {
    [sym_conditional_execution] = STATE(213),
    [sym_pipe] = STATE(213),
    [sym_redirect_statement] = STATE(213),
    [sym_negated_statement] = STATE(213),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(213),
    [sym_return] = STATE(213),
    [sym_switch_statement] = STATE(213),
    [sym_for_statement] = STATE(213),
    [sym_while_statement] = STATE(213),
    [sym_if_statement] = STATE(213),
    [sym_begin_statement] = STATE(213),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(213),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(17),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(151),
    [anon_sym_AMP] = ACTIONS(151),
    [anon_sym_LF] = ACTIONS(151),
    [anon_sym_CR] = ACTIONS(151),
    [anon_sym_CR_LF] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(153),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(155),
    [sym_continue] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [16] = {
    [sym_conditional_execution] = STATE(194),
    [sym_pipe] = STATE(194),
    [sym_redirect_statement] = STATE(194),
    [sym_negated_statement] = STATE(194),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(194),
    [sym_return] = STATE(194),
    [sym_switch_statement] = STATE(194),
    [sym_for_statement] = STATE(194),
    [sym_while_statement] = STATE(194),
    [sym_if_statement] = STATE(194),
    [sym_begin_statement] = STATE(194),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(194),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(32),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_CR] = ACTIONS(145),
    [anon_sym_CR_LF] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(157),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(159),
    [sym_continue] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [17] = {
    [sym_conditional_execution] = STATE(219),
    [sym_pipe] = STATE(219),
    [sym_redirect_statement] = STATE(219),
    [sym_negated_statement] = STATE(219),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(219),
    [sym_return] = STATE(219),
    [sym_switch_statement] = STATE(219),
    [sym_for_statement] = STATE(219),
    [sym_while_statement] = STATE(219),
    [sym_if_statement] = STATE(219),
    [sym_begin_statement] = STATE(219),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(219),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(32),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_CR] = ACTIONS(145),
    [anon_sym_CR_LF] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(161),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(163),
    [sym_continue] = ACTIONS(163),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [18] = {
    [sym_conditional_execution] = STATE(196),
    [sym_pipe] = STATE(196),
    [sym_redirect_statement] = STATE(196),
    [sym_negated_statement] = STATE(196),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(196),
    [sym_return] = STATE(196),
    [sym_switch_statement] = STATE(196),
    [sym_for_statement] = STATE(196),
    [sym_while_statement] = STATE(196),
    [sym_if_statement] = STATE(196),
    [sym_begin_statement] = STATE(196),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(196),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(34),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(165),
    [anon_sym_LF] = ACTIONS(165),
    [anon_sym_CR] = ACTIONS(165),
    [anon_sym_CR_LF] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(167),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(169),
    [sym_continue] = ACTIONS(169),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [19] = {
    [sym_conditional_execution] = STATE(212),
    [sym_pipe] = STATE(212),
    [sym_redirect_statement] = STATE(212),
    [sym_negated_statement] = STATE(212),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(212),
    [sym_return] = STATE(212),
    [sym_switch_statement] = STATE(212),
    [sym_for_statement] = STATE(212),
    [sym_while_statement] = STATE(212),
    [sym_if_statement] = STATE(212),
    [sym_begin_statement] = STATE(212),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(212),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(32),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_CR] = ACTIONS(145),
    [anon_sym_CR_LF] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(171),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(173),
    [sym_continue] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [20] = {
    [sym_conditional_execution] = STATE(190),
    [sym_pipe] = STATE(190),
    [sym_redirect_statement] = STATE(190),
    [sym_negated_statement] = STATE(190),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(190),
    [sym_return] = STATE(190),
    [sym_switch_statement] = STATE(190),
    [sym_for_statement] = STATE(190),
    [sym_while_statement] = STATE(190),
    [sym_if_statement] = STATE(190),
    [sym_begin_statement] = STATE(190),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(190),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(32),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_CR] = ACTIONS(145),
    [anon_sym_CR_LF] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(175),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(177),
    [sym_continue] = ACTIONS(177),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [21] = {
    [sym_conditional_execution] = STATE(190),
    [sym_pipe] = STATE(190),
    [sym_redirect_statement] = STATE(190),
    [sym_negated_statement] = STATE(190),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(190),
    [sym_return] = STATE(190),
    [sym_switch_statement] = STATE(190),
    [sym_for_statement] = STATE(190),
    [sym_while_statement] = STATE(190),
    [sym_if_statement] = STATE(190),
    [sym_begin_statement] = STATE(190),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(190),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(16),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(179),
    [anon_sym_AMP] = ACTIONS(179),
    [anon_sym_LF] = ACTIONS(179),
    [anon_sym_CR] = ACTIONS(179),
    [anon_sym_CR_LF] = ACTIONS(179),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(175),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(177),
    [sym_continue] = ACTIONS(177),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [22] = {
    [sym_conditional_execution] = STATE(206),
    [sym_pipe] = STATE(206),
    [sym_redirect_statement] = STATE(206),
    [sym_negated_statement] = STATE(206),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(206),
    [sym_return] = STATE(206),
    [sym_switch_statement] = STATE(206),
    [sym_for_statement] = STATE(206),
    [sym_while_statement] = STATE(206),
    [sym_if_statement] = STATE(206),
    [sym_begin_statement] = STATE(206),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(206),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(20),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(181),
    [anon_sym_AMP] = ACTIONS(181),
    [anon_sym_LF] = ACTIONS(181),
    [anon_sym_CR] = ACTIONS(181),
    [anon_sym_CR_LF] = ACTIONS(181),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(183),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(185),
    [sym_continue] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [23] = {
    [sym_conditional_execution] = STATE(188),
    [sym_pipe] = STATE(188),
    [sym_redirect_statement] = STATE(188),
    [sym_negated_statement] = STATE(188),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(188),
    [sym_return] = STATE(188),
    [sym_switch_statement] = STATE(188),
    [sym_for_statement] = STATE(188),
    [sym_while_statement] = STATE(188),
    [sym_if_statement] = STATE(188),
    [sym_begin_statement] = STATE(188),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(188),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(32),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_CR] = ACTIONS(145),
    [anon_sym_CR_LF] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(187),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(189),
    [sym_continue] = ACTIONS(189),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [24] = {
    [sym_conditional_execution] = STATE(213),
    [sym_pipe] = STATE(213),
    [sym_redirect_statement] = STATE(213),
    [sym_negated_statement] = STATE(213),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(213),
    [sym_return] = STATE(213),
    [sym_switch_statement] = STATE(213),
    [sym_for_statement] = STATE(213),
    [sym_while_statement] = STATE(213),
    [sym_if_statement] = STATE(213),
    [sym_begin_statement] = STATE(213),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(213),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(32),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_CR] = ACTIONS(145),
    [anon_sym_CR_LF] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(153),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(155),
    [sym_continue] = ACTIONS(155),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [25] = {
    [sym_conditional_execution] = STATE(216),
    [sym_pipe] = STATE(216),
    [sym_redirect_statement] = STATE(216),
    [sym_negated_statement] = STATE(216),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(216),
    [sym_return] = STATE(216),
    [sym_switch_statement] = STATE(216),
    [sym_for_statement] = STATE(216),
    [sym_while_statement] = STATE(216),
    [sym_if_statement] = STATE(216),
    [sym_begin_statement] = STATE(216),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(216),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(44),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(191),
    [anon_sym_AMP] = ACTIONS(191),
    [anon_sym_LF] = ACTIONS(191),
    [anon_sym_CR] = ACTIONS(191),
    [anon_sym_CR_LF] = ACTIONS(191),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(195),
    [sym_continue] = ACTIONS(195),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [26] = {
    [sym_conditional_execution] = STATE(244),
    [sym_pipe] = STATE(244),
    [sym_redirect_statement] = STATE(244),
    [sym_negated_statement] = STATE(244),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(244),
    [sym_return] = STATE(244),
    [sym_switch_statement] = STATE(244),
    [sym_for_statement] = STATE(244),
    [sym_while_statement] = STATE(244),
    [sym_if_statement] = STATE(244),
    [sym_begin_statement] = STATE(244),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(244),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(37),
    [ts_builtin_sym_end] = ACTIONS(197),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(199),
    [anon_sym_AMP] = ACTIONS(199),
    [anon_sym_LF] = ACTIONS(199),
    [anon_sym_CR] = ACTIONS(199),
    [anon_sym_CR_LF] = ACTIONS(199),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(25),
    [sym_continue] = ACTIONS(25),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [27] = {
    [sym_conditional_execution] = STATE(191),
    [sym_pipe] = STATE(191),
    [sym_redirect_statement] = STATE(191),
    [sym_negated_statement] = STATE(191),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(191),
    [sym_return] = STATE(191),
    [sym_switch_statement] = STATE(191),
    [sym_for_statement] = STATE(191),
    [sym_while_statement] = STATE(191),
    [sym_if_statement] = STATE(191),
    [sym_begin_statement] = STATE(191),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(191),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(32),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_CR] = ACTIONS(145),
    [anon_sym_CR_LF] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(201),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(203),
    [sym_continue] = ACTIONS(203),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [28] = {
    [sym_conditional_execution] = STATE(191),
    [sym_pipe] = STATE(191),
    [sym_redirect_statement] = STATE(191),
    [sym_negated_statement] = STATE(191),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(191),
    [sym_return] = STATE(191),
    [sym_switch_statement] = STATE(191),
    [sym_for_statement] = STATE(191),
    [sym_while_statement] = STATE(191),
    [sym_if_statement] = STATE(191),
    [sym_begin_statement] = STATE(191),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(191),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(23),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(205),
    [anon_sym_AMP] = ACTIONS(205),
    [anon_sym_LF] = ACTIONS(205),
    [anon_sym_CR] = ACTIONS(205),
    [anon_sym_CR_LF] = ACTIONS(205),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(201),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(203),
    [sym_continue] = ACTIONS(203),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [29] = {
    [sym_conditional_execution] = STATE(193),
    [sym_pipe] = STATE(193),
    [sym_redirect_statement] = STATE(193),
    [sym_negated_statement] = STATE(193),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(193),
    [sym_return] = STATE(193),
    [sym_switch_statement] = STATE(193),
    [sym_for_statement] = STATE(193),
    [sym_while_statement] = STATE(193),
    [sym_if_statement] = STATE(193),
    [sym_begin_statement] = STATE(193),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(193),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(27),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(207),
    [anon_sym_AMP] = ACTIONS(207),
    [anon_sym_LF] = ACTIONS(207),
    [anon_sym_CR] = ACTIONS(207),
    [anon_sym_CR_LF] = ACTIONS(207),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(209),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(211),
    [sym_continue] = ACTIONS(211),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [30] = {
    [sym_conditional_execution] = STATE(218),
    [sym_pipe] = STATE(218),
    [sym_redirect_statement] = STATE(218),
    [sym_negated_statement] = STATE(218),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(218),
    [sym_return] = STATE(218),
    [sym_switch_statement] = STATE(218),
    [sym_for_statement] = STATE(218),
    [sym_while_statement] = STATE(218),
    [sym_if_statement] = STATE(218),
    [sym_begin_statement] = STATE(218),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(218),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(14),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(213),
    [anon_sym_AMP] = ACTIONS(213),
    [anon_sym_LF] = ACTIONS(213),
    [anon_sym_CR] = ACTIONS(213),
    [anon_sym_CR_LF] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(215),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(217),
    [sym_continue] = ACTIONS(217),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [31] = {
    [sym_conditional_execution] = STATE(211),
    [sym_pipe] = STATE(211),
    [sym_redirect_statement] = STATE(211),
    [sym_negated_statement] = STATE(211),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(211),
    [sym_return] = STATE(211),
    [sym_switch_statement] = STATE(211),
    [sym_for_statement] = STATE(211),
    [sym_while_statement] = STATE(211),
    [sym_if_statement] = STATE(211),
    [sym_begin_statement] = STATE(211),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(211),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(32),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_CR] = ACTIONS(145),
    [anon_sym_CR_LF] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(219),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(221),
    [sym_continue] = ACTIONS(221),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [32] = {
    [sym_conditional_execution] = STATE(243),
    [sym_pipe] = STATE(243),
    [sym_redirect_statement] = STATE(243),
    [sym_negated_statement] = STATE(243),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(243),
    [sym_return] = STATE(243),
    [sym_switch_statement] = STATE(243),
    [sym_for_statement] = STATE(243),
    [sym_while_statement] = STATE(243),
    [sym_if_statement] = STATE(243),
    [sym_begin_statement] = STATE(243),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(243),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(32),
    [sym_word] = ACTIONS(223),
    [anon_sym_and] = ACTIONS(226),
    [anon_sym_or] = ACTIONS(226),
    [anon_sym_SEMI] = ACTIONS(229),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_LF] = ACTIONS(229),
    [anon_sym_CR] = ACTIONS(229),
    [anon_sym_CR_LF] = ACTIONS(229),
    [anon_sym_BANG] = ACTIONS(232),
    [anon_sym_not] = ACTIONS(232),
    [anon_sym_DOLLAR] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(238),
    [anon_sym_RPAREN] = ACTIONS(241),
    [anon_sym_function] = ACTIONS(243),
    [sym_integer] = ACTIONS(223),
    [sym_float] = ACTIONS(223),
    [anon_sym_return] = ACTIONS(246),
    [anon_sym_switch] = ACTIONS(249),
    [sym_break] = ACTIONS(252),
    [sym_continue] = ACTIONS(252),
    [anon_sym_for] = ACTIONS(255),
    [anon_sym_while] = ACTIONS(258),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_begin] = ACTIONS(264),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(267),
    [anon_sym_RBRACK] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(270),
    [anon_sym_DQUOTE] = ACTIONS(273),
    [anon_sym_SQUOTE] = ACTIONS(276),
    [sym_escape_sequence] = ACTIONS(223),
    [sym_home_dir_expansion] = ACTIONS(223),
    [sym_glob] = ACTIONS(223),
  },
  [33] = {
    [sym_conditional_execution] = STATE(199),
    [sym_pipe] = STATE(199),
    [sym_redirect_statement] = STATE(199),
    [sym_negated_statement] = STATE(199),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(199),
    [sym_return] = STATE(199),
    [sym_switch_statement] = STATE(199),
    [sym_for_statement] = STATE(199),
    [sym_while_statement] = STATE(199),
    [sym_if_statement] = STATE(199),
    [sym_begin_statement] = STATE(199),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(199),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(32),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_CR] = ACTIONS(145),
    [anon_sym_CR_LF] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(279),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(281),
    [sym_continue] = ACTIONS(281),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [34] = {
    [sym_conditional_execution] = STATE(218),
    [sym_pipe] = STATE(218),
    [sym_redirect_statement] = STATE(218),
    [sym_negated_statement] = STATE(218),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(218),
    [sym_return] = STATE(218),
    [sym_switch_statement] = STATE(218),
    [sym_for_statement] = STATE(218),
    [sym_while_statement] = STATE(218),
    [sym_if_statement] = STATE(218),
    [sym_begin_statement] = STATE(218),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(218),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(32),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_CR] = ACTIONS(145),
    [anon_sym_CR_LF] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(215),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(217),
    [sym_continue] = ACTIONS(217),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [35] = {
    [sym_conditional_execution] = STATE(181),
    [sym_pipe] = STATE(181),
    [sym_redirect_statement] = STATE(181),
    [sym_negated_statement] = STATE(181),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(181),
    [sym_return] = STATE(181),
    [sym_switch_statement] = STATE(181),
    [sym_for_statement] = STATE(181),
    [sym_while_statement] = STATE(181),
    [sym_if_statement] = STATE(181),
    [sym_begin_statement] = STATE(181),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(181),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(24),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(283),
    [anon_sym_LF] = ACTIONS(283),
    [anon_sym_CR] = ACTIONS(283),
    [anon_sym_CR_LF] = ACTIONS(283),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(285),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(287),
    [sym_continue] = ACTIONS(287),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [36] = {
    [sym_conditional_execution] = STATE(182),
    [sym_pipe] = STATE(182),
    [sym_redirect_statement] = STATE(182),
    [sym_negated_statement] = STATE(182),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(182),
    [sym_return] = STATE(182),
    [sym_switch_statement] = STATE(182),
    [sym_for_statement] = STATE(182),
    [sym_while_statement] = STATE(182),
    [sym_if_statement] = STATE(182),
    [sym_begin_statement] = STATE(182),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(182),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(32),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_CR] = ACTIONS(145),
    [anon_sym_CR_LF] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(289),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(291),
    [sym_continue] = ACTIONS(291),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [37] = {
    [sym_conditional_execution] = STATE(244),
    [sym_pipe] = STATE(244),
    [sym_redirect_statement] = STATE(244),
    [sym_negated_statement] = STATE(244),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(244),
    [sym_return] = STATE(244),
    [sym_switch_statement] = STATE(244),
    [sym_for_statement] = STATE(244),
    [sym_while_statement] = STATE(244),
    [sym_if_statement] = STATE(244),
    [sym_begin_statement] = STATE(244),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(244),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(37),
    [ts_builtin_sym_end] = ACTIONS(293),
    [sym_word] = ACTIONS(223),
    [anon_sym_and] = ACTIONS(226),
    [anon_sym_or] = ACTIONS(226),
    [anon_sym_SEMI] = ACTIONS(295),
    [anon_sym_AMP] = ACTIONS(295),
    [anon_sym_LF] = ACTIONS(295),
    [anon_sym_CR] = ACTIONS(295),
    [anon_sym_CR_LF] = ACTIONS(295),
    [anon_sym_BANG] = ACTIONS(232),
    [anon_sym_not] = ACTIONS(232),
    [anon_sym_DOLLAR] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(238),
    [anon_sym_function] = ACTIONS(243),
    [sym_integer] = ACTIONS(223),
    [sym_float] = ACTIONS(223),
    [anon_sym_return] = ACTIONS(246),
    [anon_sym_switch] = ACTIONS(249),
    [sym_break] = ACTIONS(298),
    [sym_continue] = ACTIONS(298),
    [anon_sym_for] = ACTIONS(255),
    [anon_sym_while] = ACTIONS(258),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_begin] = ACTIONS(264),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(267),
    [anon_sym_RBRACK] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(270),
    [anon_sym_DQUOTE] = ACTIONS(273),
    [anon_sym_SQUOTE] = ACTIONS(276),
    [sym_escape_sequence] = ACTIONS(223),
    [sym_home_dir_expansion] = ACTIONS(223),
    [sym_glob] = ACTIONS(223),
  },
  [38] = {
    [sym_conditional_execution] = STATE(182),
    [sym_pipe] = STATE(182),
    [sym_redirect_statement] = STATE(182),
    [sym_negated_statement] = STATE(182),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(182),
    [sym_return] = STATE(182),
    [sym_switch_statement] = STATE(182),
    [sym_for_statement] = STATE(182),
    [sym_while_statement] = STATE(182),
    [sym_if_statement] = STATE(182),
    [sym_begin_statement] = STATE(182),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(182),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(33),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(301),
    [anon_sym_AMP] = ACTIONS(301),
    [anon_sym_LF] = ACTIONS(301),
    [anon_sym_CR] = ACTIONS(301),
    [anon_sym_CR_LF] = ACTIONS(301),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(289),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(291),
    [sym_continue] = ACTIONS(291),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [39] = {
    [sym_conditional_execution] = STATE(233),
    [sym_pipe] = STATE(233),
    [sym_redirect_statement] = STATE(233),
    [sym_negated_statement] = STATE(233),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(233),
    [sym_return] = STATE(233),
    [sym_switch_statement] = STATE(233),
    [sym_for_statement] = STATE(233),
    [sym_while_statement] = STATE(233),
    [sym_if_statement] = STATE(233),
    [sym_begin_statement] = STATE(233),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(233),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(36),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(303),
    [anon_sym_AMP] = ACTIONS(303),
    [anon_sym_LF] = ACTIONS(303),
    [anon_sym_CR] = ACTIONS(303),
    [anon_sym_CR_LF] = ACTIONS(303),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(305),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(307),
    [sym_continue] = ACTIONS(307),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [40] = {
    [sym_conditional_execution] = STATE(211),
    [sym_pipe] = STATE(211),
    [sym_redirect_statement] = STATE(211),
    [sym_negated_statement] = STATE(211),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(211),
    [sym_return] = STATE(211),
    [sym_switch_statement] = STATE(211),
    [sym_for_statement] = STATE(211),
    [sym_while_statement] = STATE(211),
    [sym_if_statement] = STATE(211),
    [sym_begin_statement] = STATE(211),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(211),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(19),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(309),
    [anon_sym_AMP] = ACTIONS(309),
    [anon_sym_LF] = ACTIONS(309),
    [anon_sym_CR] = ACTIONS(309),
    [anon_sym_CR_LF] = ACTIONS(309),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(219),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(221),
    [sym_continue] = ACTIONS(221),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [41] = {
    [sym_conditional_execution] = STATE(217),
    [sym_pipe] = STATE(217),
    [sym_redirect_statement] = STATE(217),
    [sym_negated_statement] = STATE(217),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(217),
    [sym_return] = STATE(217),
    [sym_switch_statement] = STATE(217),
    [sym_for_statement] = STATE(217),
    [sym_while_statement] = STATE(217),
    [sym_if_statement] = STATE(217),
    [sym_begin_statement] = STATE(217),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(217),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(43),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(311),
    [anon_sym_AMP] = ACTIONS(311),
    [anon_sym_LF] = ACTIONS(311),
    [anon_sym_CR] = ACTIONS(311),
    [anon_sym_CR_LF] = ACTIONS(311),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(313),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(315),
    [sym_continue] = ACTIONS(315),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [42] = {
    [sym_conditional_execution] = STATE(204),
    [sym_pipe] = STATE(204),
    [sym_redirect_statement] = STATE(204),
    [sym_negated_statement] = STATE(204),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(204),
    [sym_return] = STATE(204),
    [sym_switch_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_begin_statement] = STATE(204),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(204),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(31),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(317),
    [anon_sym_AMP] = ACTIONS(317),
    [anon_sym_LF] = ACTIONS(317),
    [anon_sym_CR] = ACTIONS(317),
    [anon_sym_CR_LF] = ACTIONS(317),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(319),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(321),
    [sym_continue] = ACTIONS(321),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [43] = {
    [sym_conditional_execution] = STATE(222),
    [sym_pipe] = STATE(222),
    [sym_redirect_statement] = STATE(222),
    [sym_negated_statement] = STATE(222),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(222),
    [sym_return] = STATE(222),
    [sym_switch_statement] = STATE(222),
    [sym_for_statement] = STATE(222),
    [sym_while_statement] = STATE(222),
    [sym_if_statement] = STATE(222),
    [sym_begin_statement] = STATE(222),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(222),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(32),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_CR] = ACTIONS(145),
    [anon_sym_CR_LF] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(323),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(325),
    [sym_continue] = ACTIONS(325),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
  [44] = {
    [sym_conditional_execution] = STATE(217),
    [sym_pipe] = STATE(217),
    [sym_redirect_statement] = STATE(217),
    [sym_negated_statement] = STATE(217),
    [sym_command_substitution] = STATE(96),
    [sym_function_definition] = STATE(217),
    [sym_return] = STATE(217),
    [sym_switch_statement] = STATE(217),
    [sym_for_statement] = STATE(217),
    [sym_while_statement] = STATE(217),
    [sym_if_statement] = STATE(217),
    [sym_begin_statement] = STATE(217),
    [sym_variable_expansion] = STATE(96),
    [sym_brace_expansion] = STATE(96),
    [sym_double_quote_string] = STATE(96),
    [sym_single_quote_string] = STATE(96),
    [sym_command] = STATE(217),
    [sym__special_character] = STATE(99),
    [sym_concatenation] = STATE(78),
    [sym__expression] = STATE(78),
    [aux_sym_program_repeat1] = STATE(32),
    [sym_word] = ACTIONS(7),
    [anon_sym_and] = ACTIONS(9),
    [anon_sym_or] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_CR] = ACTIONS(145),
    [anon_sym_CR_LF] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(13),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(313),
    [anon_sym_function] = ACTIONS(19),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(7),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [sym_break] = ACTIONS(315),
    [sym_continue] = ACTIONS(315),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_while] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_begin] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_RBRACK] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_escape_sequence] = ACTIONS(7),
    [sym_home_dir_expansion] = ACTIONS(7),
    [sym_glob] = ACTIONS(7),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_DOLLAR,
    ACTIONS(339), 1,
      anon_sym_LPAREN,
    ACTIONS(342), 1,
      anon_sym_function,
    ACTIONS(347), 1,
      anon_sym_return,
    ACTIONS(350), 1,
      anon_sym_switch,
    ACTIONS(356), 1,
      anon_sym_for,
    ACTIONS(359), 1,
      anon_sym_while,
    ACTIONS(362), 1,
      anon_sym_if,
    ACTIONS(365), 1,
      anon_sym_begin,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      anon_sym_SQUOTE,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(330), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(333), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(345), 2,
      anon_sym_end,
      anon_sym_case,
    ACTIONS(353), 2,
      sym_break,
      sym_continue,
    ACTIONS(368), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(45), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(327), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(245), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [100] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(380), 2,
      anon_sym_end,
      anon_sym_case,
    ACTIONS(382), 2,
      sym_break,
      sym_continue,
    STATE(45), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(245), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [200] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(382), 2,
      sym_break,
      sym_continue,
    ACTIONS(384), 2,
      anon_sym_end,
      anon_sym_case,
    STATE(46), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(245), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [300] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(51), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [399] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(390), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(63), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [498] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(392), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(51), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [597] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_DOLLAR,
    ACTIONS(339), 1,
      anon_sym_LPAREN,
    ACTIONS(342), 1,
      anon_sym_function,
    ACTIONS(345), 1,
      anon_sym_end,
    ACTIONS(347), 1,
      anon_sym_return,
    ACTIONS(350), 1,
      anon_sym_switch,
    ACTIONS(356), 1,
      anon_sym_for,
    ACTIONS(359), 1,
      anon_sym_while,
    ACTIONS(362), 1,
      anon_sym_if,
    ACTIONS(365), 1,
      anon_sym_begin,
    ACTIONS(371), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      anon_sym_SQUOTE,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(330), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(333), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(368), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(394), 2,
      sym_break,
      sym_continue,
    STATE(51), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(327), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [696] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(397), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(51), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [795] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(399), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(51), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [894] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(401), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(51), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [993] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(403), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(51), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [1092] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(405), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(51), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [1191] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(407), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(51), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [1290] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(409), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(51), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [1389] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(411), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(58), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [1488] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(413), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(50), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [1587] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(415), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(48), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [1686] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(417), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(57), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [1785] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(419), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(51), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [1884] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(56), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [1983] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(423), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(55), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [2082] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(425), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(70), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [2181] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(427), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(54), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [2280] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(429), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(53), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [2379] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(431), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(52), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [2478] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(433), 1,
      anon_sym_end,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(388), 2,
      sym_break,
      sym_continue,
    STATE(51), 2,
      sym__terminated_statement,
      aux_sym_function_definition_repeat2,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(257), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [2577] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    STATE(12), 1,
      sym__terminated_statement,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(435), 2,
      sym_break,
      sym_continue,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(260), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [2672] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    STATE(3), 1,
      sym__terminated_statement,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(437), 2,
      sym_break,
      sym_continue,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(255), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [2767] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    STATE(4), 1,
      sym__terminated_statement,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(437), 2,
      sym_break,
      sym_continue,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(255), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [2862] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(439), 2,
      sym_break,
      sym_continue,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(189), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [2954] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(441), 2,
      sym_break,
      sym_continue,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(192), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [3046] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(443), 2,
      sym_break,
      sym_continue,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(205), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [3138] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_function,
    ACTIONS(21), 1,
      anon_sym_return,
    ACTIONS(23), 1,
      anon_sym_switch,
    ACTIONS(27), 1,
      anon_sym_for,
    ACTIONS(29), 1,
      anon_sym_while,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_begin,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(9), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(13), 2,
      anon_sym_BANG,
      anon_sym_not,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(445), 2,
      sym_break,
      sym_continue,
    STATE(78), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    STATE(202), 12,
      sym_conditional_execution,
      sym_pipe,
      sym_redirect_statement,
      sym_negated_statement,
      sym_function_definition,
      sym_return,
      sym_switch_statement,
      sym_for_statement,
      sym_while_statement,
      sym_if_statement,
      sym_begin_statement,
      sym_command,
  [3230] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(449), 1,
      sym_stream_redirect,
    ACTIONS(451), 1,
      sym_direction,
    STATE(80), 1,
      aux_sym_command_repeat1,
    STATE(99), 1,
      sym__special_character,
    STATE(122), 1,
      sym_file_redirect,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(123), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    ACTIONS(447), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [3300] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(458), 1,
      anon_sym_DOLLAR,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_LBRACE,
    ACTIONS(470), 1,
      anon_sym_DQUOTE,
    ACTIONS(473), 1,
      anon_sym_SQUOTE,
    ACTIONS(476), 1,
      sym_stream_redirect,
    ACTIONS(479), 1,
      sym_direction,
    STATE(79), 1,
      aux_sym_command_repeat1,
    STATE(99), 1,
      sym__special_character,
    STATE(122), 1,
      sym_file_redirect,
    ACTIONS(464), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(123), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(453), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    ACTIONS(456), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [3370] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(449), 1,
      sym_stream_redirect,
    ACTIONS(451), 1,
      sym_direction,
    STATE(79), 1,
      aux_sym_command_repeat1,
    STATE(99), 1,
      sym__special_character,
    STATE(122), 1,
      sym_file_redirect,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(123), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    ACTIONS(482), 11,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [3440] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(488), 1,
      anon_sym_DOLLAR,
    ACTIONS(490), 1,
      anon_sym_LPAREN,
    ACTIONS(494), 1,
      anon_sym_LBRACE,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_SQUOTE,
    STATE(178), 1,
      sym__special_character,
    ACTIONS(492), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(246), 2,
      sym_concatenation,
      sym__expression,
    STATE(177), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(484), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
    ACTIONS(486), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [3500] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 33,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_else,
      anon_sym_begin,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [3539] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 33,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_else,
      anon_sym_begin,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [3578] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 32,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [3616] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 32,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [3654] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 1,
      ts_builtin_sym_end,
    ACTIONS(241), 31,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [3694] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(241), 32,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_function,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [3732] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(91), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(506), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(504), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [3771] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(506), 1,
      sym__concat,
    ACTIONS(508), 1,
      sym__concat_list,
    STATE(90), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(504), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [3812] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(508), 1,
      sym__concat_list,
    ACTIONS(512), 1,
      sym__concat,
    STATE(92), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(510), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [3853] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(92), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(512), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(510), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [3892] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(516), 1,
      sym__concat,
    ACTIONS(518), 1,
      sym__concat_list,
    STATE(92), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(514), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [3933] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 1,
      sym__concat,
    STATE(93), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(521), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [3971] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(516), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(514), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4007] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 28,
      anon_sym_and,
      anon_sym_or,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_case,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4041] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(528), 1,
      sym__concat,
    STATE(100), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(526), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4079] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(532), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(530), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4115] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(534), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4151] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(528), 1,
      sym__concat,
    STATE(100), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(538), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4189] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(528), 1,
      sym__concat,
    STATE(93), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(540), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4227] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(547), 1,
      anon_sym_DOLLAR,
    ACTIONS(550), 1,
      anon_sym_LPAREN,
    ACTIONS(556), 1,
      anon_sym_LBRACE,
    ACTIONS(559), 1,
      anon_sym_DQUOTE,
    ACTIONS(562), 1,
      anon_sym_SQUOTE,
    STATE(101), 1,
      aux_sym_function_definition_repeat1,
    STATE(147), 1,
      sym__special_character,
    ACTIONS(553), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(167), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(545), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(148), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(542), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4282] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(567), 1,
      sym__concat,
    ACTIONS(565), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4317] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    ACTIONS(575), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_LBRACE,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_SQUOTE,
    STATE(107), 1,
      aux_sym_function_definition_repeat1,
    STATE(147), 1,
      sym__special_character,
    ACTIONS(577), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(167), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(571), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(148), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(569), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4372] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 1,
      sym__concat,
    ACTIONS(585), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4407] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(591), 1,
      sym__concat,
    ACTIONS(589), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4442] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(593), 1,
      sym__concat,
    ACTIONS(521), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4477] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    ACTIONS(575), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_LBRACE,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_SQUOTE,
    ACTIONS(595), 1,
      anon_sym_SEMI,
    ACTIONS(597), 1,
      anon_sym_AMP,
    ACTIONS(599), 1,
      anon_sym_LF,
    ACTIONS(601), 1,
      anon_sym_CR,
    ACTIONS(603), 1,
      anon_sym_CR_LF,
    STATE(101), 1,
      aux_sym_function_definition_repeat1,
    STATE(147), 1,
      sym__special_character,
    ACTIONS(577), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(167), 2,
      sym_concatenation,
      sym__expression,
    STATE(148), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(569), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4540] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      sym__concat,
    ACTIONS(605), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4575] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(614), 1,
      anon_sym_DOLLAR,
    ACTIONS(617), 1,
      anon_sym_LPAREN,
    ACTIONS(623), 1,
      anon_sym_LBRACE,
    ACTIONS(626), 1,
      anon_sym_DQUOTE,
    ACTIONS(629), 1,
      anon_sym_SQUOTE,
    STATE(147), 1,
      sym__special_character,
    ACTIONS(620), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(109), 3,
      sym_concatenation,
      sym__expression,
      aux_sym_case_clause_repeat1,
    ACTIONS(612), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(148), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(609), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4628] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(634), 1,
      sym__concat,
    ACTIONS(632), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4663] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 1,
      sym__concat,
    ACTIONS(636), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4698] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 1,
      sym__concat,
    ACTIONS(640), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4733] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(646), 1,
      sym__concat,
    ACTIONS(644), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4768] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(653), 1,
      anon_sym_DOLLAR,
    ACTIONS(656), 1,
      anon_sym_LPAREN,
    ACTIONS(662), 1,
      anon_sym_LBRACE,
    ACTIONS(665), 1,
      anon_sym_DQUOTE,
    ACTIONS(668), 1,
      anon_sym_SQUOTE,
    STATE(114), 1,
      aux_sym_for_statement_repeat1,
    STATE(147), 1,
      sym__special_character,
    ACTIONS(659), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(166), 2,
      sym_concatenation,
      sym__expression,
    ACTIONS(651), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(148), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(648), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4823] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    ACTIONS(575), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_LBRACE,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_SQUOTE,
    ACTIONS(671), 1,
      anon_sym_SEMI,
    ACTIONS(673), 1,
      anon_sym_AMP,
    ACTIONS(675), 1,
      anon_sym_LF,
    ACTIONS(677), 1,
      anon_sym_CR,
    ACTIONS(679), 1,
      anon_sym_CR_LF,
    STATE(114), 1,
      aux_sym_for_statement_repeat1,
    STATE(147), 1,
      sym__special_character,
    ACTIONS(577), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(166), 2,
      sym_concatenation,
      sym__expression,
    STATE(148), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(569), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4886] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    ACTIONS(575), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_LBRACE,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_SQUOTE,
    STATE(147), 1,
      sym__special_character,
    ACTIONS(577), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(109), 3,
      sym_concatenation,
      sym__expression,
      aux_sym_case_clause_repeat1,
    ACTIONS(681), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
    STATE(148), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(569), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4939] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(685), 1,
      sym__concat,
    ACTIONS(683), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [4974] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(689), 1,
      sym__concat,
    ACTIONS(687), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5009] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(693), 1,
      sym__concat,
    ACTIONS(691), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5044] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 1,
      sym__concat,
    ACTIONS(695), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5079] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 27,
      anon_sym_and,
      anon_sym_or,
      anon_sym_BANG,
      anon_sym_not,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_function,
      anon_sym_end,
      sym_integer,
      sym_float,
      anon_sym_return,
      anon_sym_switch,
      sym_break,
      sym_continue,
      anon_sym_for,
      anon_sym_while,
      anon_sym_if,
      anon_sym_begin,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5112] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(699), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5144] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(701), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5176] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(703), 26,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_stream_redirect,
      sym_direction,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5208] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    ACTIONS(575), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_LBRACE,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_SQUOTE,
    STATE(147), 1,
      sym__special_character,
    ACTIONS(577), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(116), 3,
      sym_concatenation,
      sym__expression,
      aux_sym_case_clause_repeat1,
    STATE(148), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(569), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5254] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    ACTIONS(575), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_LBRACE,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_SQUOTE,
    STATE(115), 1,
      aux_sym_for_statement_repeat1,
    STATE(147), 1,
      sym__special_character,
    ACTIONS(577), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(166), 2,
      sym_concatenation,
      sym__expression,
    STATE(148), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(569), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5302] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(705), 1,
      anon_sym_DOLLAR,
    ACTIONS(707), 1,
      anon_sym_LPAREN,
    ACTIONS(711), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_COMMA,
    ACTIONS(715), 1,
      anon_sym_RBRACE,
    ACTIONS(717), 1,
      anon_sym_DQUOTE,
    ACTIONS(719), 1,
      anon_sym_SQUOTE,
    STATE(419), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(422), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(709), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(378), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [5349] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(705), 1,
      anon_sym_DOLLAR,
    ACTIONS(707), 1,
      anon_sym_LPAREN,
    ACTIONS(711), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_COMMA,
    ACTIONS(717), 1,
      anon_sym_DQUOTE,
    ACTIONS(719), 1,
      anon_sym_SQUOTE,
    ACTIONS(721), 1,
      anon_sym_RBRACE,
    STATE(420), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(405), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(709), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(378), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [5396] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(137), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(512), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(510), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5427] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      sym__concat,
    ACTIONS(723), 1,
      sym__concat_list,
    STATE(137), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(510), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5460] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(129), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(506), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(504), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5491] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(705), 1,
      anon_sym_DOLLAR,
    ACTIONS(707), 1,
      anon_sym_LPAREN,
    ACTIONS(711), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_COMMA,
    ACTIONS(717), 1,
      anon_sym_DQUOTE,
    ACTIONS(719), 1,
      anon_sym_SQUOTE,
    ACTIONS(725), 1,
      anon_sym_RBRACE,
    STATE(409), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(410), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(709), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(378), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [5538] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(729), 1,
      anon_sym_DOLLAR,
    ACTIONS(731), 1,
      anon_sym_LPAREN,
    ACTIONS(735), 1,
      anon_sym_LBRACE,
    ACTIONS(737), 1,
      anon_sym_DQUOTE,
    ACTIONS(739), 1,
      anon_sym_SQUOTE,
    STATE(316), 1,
      sym__special_character,
    ACTIONS(733), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(352), 2,
      sym_concatenation,
      sym__expression,
    STATE(315), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(727), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5583] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(506), 1,
      sym__concat,
    ACTIONS(723), 1,
      sym__concat_list,
    STATE(130), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(504), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5616] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    STATE(99), 1,
      sym__special_character,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(124), 2,
      sym_concatenation,
      sym__expression,
    STATE(96), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(7), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5661] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(705), 1,
      anon_sym_DOLLAR,
    ACTIONS(707), 1,
      anon_sym_LPAREN,
    ACTIONS(711), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_COMMA,
    ACTIONS(717), 1,
      anon_sym_DQUOTE,
    ACTIONS(719), 1,
      anon_sym_SQUOTE,
    ACTIONS(741), 1,
      anon_sym_RBRACE,
    STATE(400), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(399), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(709), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(378), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [5708] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(516), 1,
      sym__concat,
    ACTIONS(743), 1,
      sym__concat_list,
    STATE(137), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(514), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5741] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(488), 1,
      anon_sym_DOLLAR,
    ACTIONS(490), 1,
      anon_sym_LPAREN,
    ACTIONS(494), 1,
      anon_sym_LBRACE,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_SQUOTE,
    STATE(178), 1,
      sym__special_character,
    ACTIONS(492), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(241), 2,
      sym_concatenation,
      sym__expression,
    STATE(177), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(484), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5786] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    ACTIONS(575), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_LBRACE,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_SQUOTE,
    STATE(147), 1,
      sym__special_character,
    ACTIONS(577), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(103), 2,
      sym_concatenation,
      sym__expression,
    STATE(148), 5,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
    ACTIONS(569), 6,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5831] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(705), 1,
      anon_sym_DOLLAR,
    ACTIONS(707), 1,
      anon_sym_LPAREN,
    ACTIONS(711), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_COMMA,
    ACTIONS(717), 1,
      anon_sym_DQUOTE,
    ACTIONS(719), 1,
      anon_sym_SQUOTE,
    ACTIONS(746), 1,
      anon_sym_RBRACE,
    STATE(417), 1,
      aux_sym_brace_expansion_repeat1,
    STATE(394), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(709), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(378), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [5878] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    ACTIONS(575), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_LBRACE,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      anon_sym_SQUOTE,
    ACTIONS(577), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(155), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__special_character,
    ACTIONS(748), 7,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      anon_sym_POUND,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5918] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      sym__concat,
    STATE(142), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(521), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5948] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(532), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(530), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [5976] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(534), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6004] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(516), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(514), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6032] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(753), 1,
      sym__concat,
    STATE(142), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(540), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6062] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(753), 1,
      sym__concat,
    STATE(146), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(538), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6092] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(753), 1,
      sym__concat,
    STATE(146), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(526), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6122] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(488), 1,
      anon_sym_DOLLAR,
    ACTIONS(490), 1,
      anon_sym_LPAREN,
    ACTIONS(494), 1,
      anon_sym_LBRACE,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_SQUOTE,
    ACTIONS(492), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(232), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__special_character,
    ACTIONS(755), 7,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      anon_sym_POUND,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6162] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_DOLLAR,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(35), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(106), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__special_character,
    ACTIONS(757), 7,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      anon_sym_POUND,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6202] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(705), 1,
      anon_sym_DOLLAR,
    ACTIONS(707), 1,
      anon_sym_LPAREN,
    ACTIONS(711), 1,
      anon_sym_LBRACE,
    ACTIONS(717), 1,
      anon_sym_DQUOTE,
    ACTIONS(719), 1,
      anon_sym_SQUOTE,
    ACTIONS(759), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    STATE(424), 2,
      sym_brace_concatenation,
      sym__brace_expression,
    ACTIONS(709), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(378), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [6244] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(729), 1,
      anon_sym_DOLLAR,
    ACTIONS(731), 1,
      anon_sym_LPAREN,
    ACTIONS(735), 1,
      anon_sym_LBRACE,
    ACTIONS(737), 1,
      anon_sym_DQUOTE,
    ACTIONS(739), 1,
      anon_sym_SQUOTE,
    ACTIONS(733), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    STATE(343), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__special_character,
    ACTIONS(761), 7,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      anon_sym_POUND,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6284] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(591), 1,
      sym__concat,
    ACTIONS(589), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6311] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(646), 1,
      sym__concat,
    ACTIONS(644), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6338] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(593), 1,
      sym__concat,
    ACTIONS(521), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6365] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(689), 1,
      sym__concat,
    ACTIONS(687), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6392] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(567), 1,
      sym__concat,
    ACTIONS(565), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6419] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 1,
      sym__concat,
    ACTIONS(636), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6446] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 1,
      sym__concat,
    ACTIONS(585), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      sym__concat,
    ACTIONS(605), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6500] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 1,
      sym__concat,
    ACTIONS(695), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6527] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(693), 1,
      sym__concat,
    ACTIONS(691), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6554] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 1,
      sym__concat,
    ACTIONS(640), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6581] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(634), 1,
      sym__concat,
    ACTIONS(632), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6608] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(685), 1,
      sym__concat,
    ACTIONS(683), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6635] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(763), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6659] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(765), 18,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      sym_float,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_escape_sequence,
      sym_home_dir_expansion,
      sym_glob,
      sym_word,
  [6683] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(516), 1,
      sym__concat,
    ACTIONS(767), 1,
      sym__concat_list,
    STATE(168), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(514), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [6711] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(168), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(512), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(510), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [6737] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(705), 1,
      anon_sym_DOLLAR,
    ACTIONS(707), 1,
      anon_sym_LPAREN,
    ACTIONS(711), 1,
      anon_sym_LBRACE,
    ACTIONS(717), 1,
      anon_sym_DQUOTE,
    ACTIONS(719), 1,
      anon_sym_SQUOTE,
    ACTIONS(770), 5,
      sym_integer,
      sym_float,
      sym_escape_sequence,
      sym_glob,
      sym_brace_word,
    STATE(390), 6,
      sym_command_substitution,
      sym_variable_expansion,
      sym_brace_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
      sym__base_brace_expression,
  [6771] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(169), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(506), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(504), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [6797] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      sym__concat,
    ACTIONS(772), 1,
      sym__concat_list,
    STATE(168), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(510), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [6825] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(506), 1,
      sym__concat,
    ACTIONS(772), 1,
      sym__concat_list,
    STATE(172), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(504), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [6853] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      sym__concat,
    STATE(174), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(521), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [6878] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(516), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(514), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [6901] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(534), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [6924] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(777), 1,
      sym__concat,
    STATE(180), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(526), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [6949] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(777), 1,
      sym__concat,
    STATE(180), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(538), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [6974] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(532), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(530), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [6997] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(777), 1,
      sym__concat,
    STATE(174), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(540), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [7022] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(153), 1,
      anon_sym_RPAREN,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [7054] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_RPAREN,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [7086] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      sym__concat,
    ACTIONS(605), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [7108] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(634), 1,
      sym__concat,
    ACTIONS(632), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [7130] = 11,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      sym_integer,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_DOT_DOT,
    ACTIONS(799), 1,
      anon_sym_RBRACK,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(803), 1,
      anon_sym_SQUOTE,
    STATE(313), 1,
      sym_index,
    STATE(207), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [7168] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(685), 1,
      sym__concat,
    ACTIONS(683), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [7190] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(646), 1,
      sym__concat,
    ACTIONS(644), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [7212] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    ACTIONS(805), 1,
      anon_sym_RPAREN,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [7244] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(807), 6,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [7274] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(157), 1,
      anon_sym_RPAREN,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [7306] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      anon_sym_RPAREN,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [7338] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(809), 8,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [7366] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(201), 1,
      anon_sym_RPAREN,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [7398] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    ACTIONS(811), 1,
      anon_sym_RPAREN,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [7430] = 11,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      sym_integer,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_DOT_DOT,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(803), 1,
      anon_sym_SQUOTE,
    ACTIONS(813), 1,
      anon_sym_RBRACK,
    STATE(313), 1,
      sym_index,
    STATE(203), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [7468] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 1,
      anon_sym_RPAREN,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [7500] = 11,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      sym_integer,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_DOT_DOT,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(803), 1,
      anon_sym_SQUOTE,
    ACTIONS(815), 1,
      anon_sym_RBRACK,
    STATE(313), 1,
      sym_index,
    STATE(201), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [7538] = 11,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      sym_integer,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_DOT_DOT,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(803), 1,
      anon_sym_SQUOTE,
    ACTIONS(817), 1,
      anon_sym_RBRACK,
    STATE(313), 1,
      sym_index,
    STATE(197), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [7576] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    ACTIONS(819), 1,
      anon_sym_RPAREN,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [7608] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 1,
      sym__concat,
    ACTIONS(636), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [7630] = 11,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(821), 1,
      anon_sym_DOLLAR,
    ACTIONS(824), 1,
      anon_sym_LPAREN,
    ACTIONS(827), 1,
      sym_integer,
    ACTIONS(830), 1,
      anon_sym_DOT_DOT,
    ACTIONS(833), 1,
      anon_sym_RBRACK,
    ACTIONS(835), 1,
      anon_sym_DQUOTE,
    ACTIONS(838), 1,
      anon_sym_SQUOTE,
    STATE(313), 1,
      sym_index,
    STATE(201), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [7668] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(841), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [7690] = 11,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      sym_integer,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_DOT_DOT,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(803), 1,
      anon_sym_SQUOTE,
    ACTIONS(843), 1,
      anon_sym_RBRACK,
    STATE(313), 1,
      sym_index,
    STATE(201), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [7728] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      anon_sym_RPAREN,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [7760] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(845), 6,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
  [7790] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 1,
      anon_sym_RPAREN,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [7822] = 11,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      sym_integer,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_DOT_DOT,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(803), 1,
      anon_sym_SQUOTE,
    ACTIONS(847), 1,
      anon_sym_RBRACK,
    STATE(313), 1,
      sym_index,
    STATE(201), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [7860] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(591), 1,
      sym__concat,
    ACTIONS(589), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [7882] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    ACTIONS(849), 1,
      anon_sym_RPAREN,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [7914] = 11,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      sym_integer,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_DOT_DOT,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(803), 1,
      anon_sym_SQUOTE,
    ACTIONS(851), 1,
      anon_sym_RBRACK,
    STATE(313), 1,
      sym_index,
    STATE(231), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [7952] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 1,
      anon_sym_RPAREN,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [7984] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    ACTIONS(853), 1,
      anon_sym_RPAREN,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [8016] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      anon_sym_RPAREN,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [8048] = 11,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      sym_integer,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_DOT_DOT,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(803), 1,
      anon_sym_SQUOTE,
    ACTIONS(855), 1,
      anon_sym_RBRACK,
    STATE(313), 1,
      sym_index,
    STATE(215), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [8086] = 11,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      sym_integer,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_DOT_DOT,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(803), 1,
      anon_sym_SQUOTE,
    ACTIONS(857), 1,
      anon_sym_RBRACK,
    STATE(313), 1,
      sym_index,
    STATE(201), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [8124] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(313), 1,
      anon_sym_RPAREN,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [8156] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(323), 1,
      anon_sym_RPAREN,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [8188] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(147), 1,
      anon_sym_RPAREN,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [8220] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    ACTIONS(859), 1,
      anon_sym_RPAREN,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [8252] = 11,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      sym_integer,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_DOT_DOT,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(803), 1,
      anon_sym_SQUOTE,
    ACTIONS(861), 1,
      anon_sym_RBRACK,
    STATE(313), 1,
      sym_index,
    STATE(223), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [8290] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(689), 1,
      sym__concat,
    ACTIONS(687), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8312] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    ACTIONS(863), 1,
      anon_sym_RPAREN,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [8344] = 11,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      sym_integer,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_DOT_DOT,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(803), 1,
      anon_sym_SQUOTE,
    ACTIONS(865), 1,
      anon_sym_RBRACK,
    STATE(313), 1,
      sym_index,
    STATE(201), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [8382] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 1,
      sym__concat,
    ACTIONS(585), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8404] = 11,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      sym_integer,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_DOT_DOT,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(803), 1,
      anon_sym_SQUOTE,
    ACTIONS(867), 1,
      anon_sym_RBRACK,
    STATE(313), 1,
      sym_index,
    STATE(226), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [8442] = 11,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      sym_integer,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_DOT_DOT,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(803), 1,
      anon_sym_SQUOTE,
    ACTIONS(869), 1,
      anon_sym_RBRACK,
    STATE(313), 1,
      sym_index,
    STATE(201), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [8480] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 1,
      sym__concat,
    ACTIONS(640), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8502] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(693), 1,
      sym__concat,
    ACTIONS(691), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8524] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 1,
      sym__concat,
    ACTIONS(695), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8546] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(567), 1,
      sym__concat,
    ACTIONS(565), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8568] = 11,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      sym_integer,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_DOT_DOT,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(803), 1,
      anon_sym_SQUOTE,
    ACTIONS(871), 1,
      anon_sym_RBRACK,
    STATE(313), 1,
      sym_index,
    STATE(201), 2,
      sym_range,
      aux_sym_list_element_access_repeat1,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [8606] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(593), 1,
      sym__concat,
    ACTIONS(521), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8628] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 1,
      anon_sym_RPAREN,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [8660] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(873), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8679] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(875), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [8708] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(873), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8727] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(873), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8746] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(873), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8765] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(877), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8784] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(879), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8803] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(703), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8822] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8841] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(783), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [8870] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(883), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [8899] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(885), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [8928] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(887), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8947] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8966] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(891), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [8985] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(893), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9004] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(895), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9023] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9042] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9061] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9080] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9099] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(899), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [9128] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(901), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [9157] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(903), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [9186] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9205] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9224] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_stream_redirect,
    ACTIONS(787), 1,
      sym_direction,
    STATE(249), 1,
      sym_file_redirect,
    ACTIONS(779), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(781), 3,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
    ACTIONS(905), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [9253] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9272] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(907), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9291] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(909), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9310] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(873), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9329] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9348] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(911), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9367] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9386] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9405] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9424] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9443] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9462] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9481] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9500] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9519] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9538] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 13,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_AMP_PIPE,
      anon_sym_2_GT_PIPE,
      anon_sym_PIPE,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
      anon_sym_RPAREN,
      sym_stream_redirect,
      sym_direction,
  [9557] = 9,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      sym_integer,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(803), 1,
      anon_sym_SQUOTE,
    STATE(314), 1,
      sym_index,
    ACTIONS(923), 2,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [9589] = 9,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      sym_integer,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(801), 1,
      anon_sym_DQUOTE,
    ACTIONS(803), 1,
      anon_sym_SQUOTE,
    STATE(317), 1,
      sym_index,
    ACTIONS(925), 2,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
    STATE(327), 4,
      sym_command_substitution,
      sym_variable_expansion,
      sym_double_quote_string,
      sym_single_quote_string,
  [9621] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(927), 1,
      sym__concat_list,
    STATE(279), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(516), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [9640] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(930), 1,
      sym__concat_list,
    STATE(281), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(506), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [9659] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(930), 1,
      sym__concat_list,
    STATE(279), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(512), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [9678] = 3,
    ACTIONS(795), 1,
      sym_comment,
    STATE(283), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(506), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [9695] = 3,
    ACTIONS(795), 1,
      sym_comment,
    STATE(279), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(512), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [9712] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 1,
      anon_sym_DOLLAR,
    ACTIONS(934), 1,
      anon_sym_LPAREN,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    ACTIONS(938), 2,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
    STATE(295), 3,
      sym_command_substitution,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [9734] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 1,
      anon_sym_DOLLAR,
    ACTIONS(934), 1,
      anon_sym_LPAREN,
    ACTIONS(940), 1,
      anon_sym_DQUOTE,
    ACTIONS(942), 2,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
    STATE(288), 3,
      sym_command_substitution,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [9756] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 1,
      anon_sym_DOLLAR,
    ACTIONS(934), 1,
      anon_sym_LPAREN,
    ACTIONS(944), 1,
      anon_sym_DQUOTE,
    ACTIONS(946), 2,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
    STATE(294), 3,
      sym_command_substitution,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [9778] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 1,
      anon_sym_DOLLAR,
    ACTIONS(934), 1,
      anon_sym_LPAREN,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 2,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
    STATE(286), 3,
      sym_command_substitution,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [9800] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 1,
      anon_sym_DOLLAR,
    ACTIONS(934), 1,
      anon_sym_LPAREN,
    ACTIONS(952), 1,
      anon_sym_DQUOTE,
    ACTIONS(946), 2,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
    STATE(294), 3,
      sym_command_substitution,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [9822] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 1,
      anon_sym_DOLLAR,
    ACTIONS(934), 1,
      anon_sym_LPAREN,
    ACTIONS(954), 1,
      anon_sym_DQUOTE,
    ACTIONS(956), 2,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
    STATE(290), 3,
      sym_command_substitution,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [9844] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 1,
      anon_sym_DOLLAR,
    ACTIONS(934), 1,
      anon_sym_LPAREN,
    ACTIONS(958), 1,
      anon_sym_DQUOTE,
    ACTIONS(946), 2,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
    STATE(294), 3,
      sym_command_substitution,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [9866] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      sym__concat,
    ACTIONS(960), 1,
      sym__concat_list,
    STATE(293), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(510), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [9886] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 1,
      anon_sym_DOLLAR,
    ACTIONS(934), 1,
      anon_sym_LPAREN,
    ACTIONS(962), 1,
      anon_sym_DQUOTE,
    ACTIONS(946), 2,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
    STATE(294), 3,
      sym_command_substitution,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [9908] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(516), 1,
      sym__concat,
    ACTIONS(964), 1,
      sym__concat_list,
    STATE(293), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(514), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [9928] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(967), 1,
      anon_sym_DOLLAR,
    ACTIONS(970), 1,
      anon_sym_LPAREN,
    ACTIONS(973), 1,
      anon_sym_DQUOTE,
    ACTIONS(975), 2,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
    STATE(294), 3,
      sym_command_substitution,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [9950] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 1,
      anon_sym_DOLLAR,
    ACTIONS(934), 1,
      anon_sym_LPAREN,
    ACTIONS(978), 1,
      anon_sym_DQUOTE,
    ACTIONS(946), 2,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
    STATE(294), 3,
      sym_command_substitution,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [9972] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(506), 1,
      sym__concat,
    ACTIONS(960), 1,
      sym__concat_list,
    STATE(291), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(504), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [9992] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(293), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(512), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(510), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10010] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(297), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(506), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(504), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10028] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 1,
      anon_sym_DOLLAR,
    ACTIONS(934), 1,
      anon_sym_LPAREN,
    ACTIONS(980), 1,
      anon_sym_DQUOTE,
    ACTIONS(946), 2,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
    STATE(294), 3,
      sym_command_substitution,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [10050] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(516), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [10064] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 1,
      anon_sym_DOLLAR,
    ACTIONS(934), 1,
      anon_sym_LPAREN,
    ACTIONS(982), 1,
      anon_sym_DQUOTE,
    ACTIONS(984), 2,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
    STATE(292), 3,
      sym_command_substitution,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [10086] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(532), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [10100] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(536), 8,
      sym__concat_list,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [10114] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 1,
      anon_sym_DOLLAR,
    ACTIONS(934), 1,
      anon_sym_LPAREN,
    ACTIONS(986), 1,
      anon_sym_DQUOTE,
    ACTIONS(988), 2,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
    STATE(299), 3,
      sym_command_substitution,
      sym_variable_expansion,
      aux_sym_double_quote_string_repeat1,
  [10136] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(516), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(514), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10151] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(693), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [10164] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(990), 1,
      sym__concat_list,
    STATE(311), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(504), 5,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
  [10181] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(591), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [10194] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(587), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [10207] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(567), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [10220] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(990), 1,
      sym__concat_list,
    STATE(321), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(510), 5,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
  [10237] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(646), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [10250] = 3,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(994), 1,
      anon_sym_DOT_DOT,
    ACTIONS(992), 6,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [10265] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(925), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [10278] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 1,
      sym__concat,
    STATE(318), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(526), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10295] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 1,
      sym__concat,
    STATE(318), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(538), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10312] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(998), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [10325] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 1,
      sym__concat,
    STATE(322), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(540), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10342] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(506), 1,
      sym__concat_list,
    STATE(320), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(504), 5,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
  [10359] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      sym__concat_list,
    STATE(321), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(510), 5,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
  [10376] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 1,
      sym__concat_list,
    STATE(321), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(514), 5,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
  [10393] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1003), 1,
      sym__concat,
    STATE(322), 1,
      aux_sym_concatenation_repeat1,
    ACTIONS(521), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10410] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(532), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(530), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10425] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(685), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [10438] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(634), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [10451] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 2,
      sym__concat,
      sym__concat_list,
    ACTIONS(534), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10466] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1006), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [10479] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(697), 7,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      sym_integer,
      anon_sym_DOT_DOT,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [10492] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 1,
      sym__concat,
    ACTIONS(695), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10506] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 1,
      sym__concat,
    ACTIONS(585), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10520] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(532), 1,
      sym__concat_list,
    ACTIONS(530), 5,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
  [10534] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(689), 1,
      sym__concat,
    ACTIONS(687), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10548] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(516), 1,
      sym__concat_list,
    ACTIONS(514), 5,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
  [10562] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 1,
      sym__concat,
    ACTIONS(640), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10576] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_if,
    ACTIONS(1008), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10590] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(591), 1,
      sym__concat,
    ACTIONS(589), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10604] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 1,
      sym__concat,
    ACTIONS(636), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10618] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(646), 1,
      sym__concat,
    ACTIONS(644), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10632] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(685), 1,
      sym__concat,
    ACTIONS(683), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10646] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(634), 1,
      sym__concat,
    ACTIONS(632), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10660] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      sym__concat,
    ACTIONS(605), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10674] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(693), 1,
      sym__concat,
    ACTIONS(691), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10688] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(593), 1,
      sym__concat,
    ACTIONS(521), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10702] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      sym__concat_list,
    ACTIONS(534), 5,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
  [10716] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(567), 1,
      sym__concat,
    ACTIONS(565), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10730] = 5,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1012), 1,
      anon_sym_end,
    ACTIONS(1014), 1,
      anon_sym_else,
    STATE(433), 1,
      sym_else_clause,
    STATE(360), 2,
      sym_else_if_clause,
      aux_sym_if_statement_repeat1,
  [10747] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(644), 5,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
  [10758] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1016), 1,
      sym__concat_list,
    STATE(348), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(516), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [10773] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1019), 1,
      sym__concat_list,
    STATE(351), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(506), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [10788] = 5,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_else,
    ACTIONS(1021), 1,
      anon_sym_end,
    STATE(437), 1,
      sym_else_clause,
    STATE(360), 2,
      sym_else_if_clause,
      aux_sym_if_statement_repeat1,
  [10805] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1019), 1,
      sym__concat_list,
    STATE(348), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(512), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [10820] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1023), 5,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_LF,
      anon_sym_CR,
      anon_sym_CR_LF,
  [10831] = 3,
    ACTIONS(795), 1,
      sym_comment,
    STATE(348), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(512), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [10844] = 3,
    ACTIONS(795), 1,
      sym_comment,
    STATE(353), 1,
      aux_sym_variable_expansion_repeat1,
    ACTIONS(506), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [10857] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(585), 5,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
  [10868] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(589), 5,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
  [10879] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(565), 5,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      aux_sym_double_quote_string_token1,
      sym_escape_sequence,
  [10890] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(516), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [10900] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1025), 1,
      anon_sym_end,
    ACTIONS(1027), 1,
      anon_sym_case,
    STATE(363), 2,
      sym_case_clause,
      aux_sym_switch_statement_repeat1,
  [10914] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1029), 1,
      anon_sym_end,
    ACTIONS(1031), 1,
      anon_sym_else,
    STATE(360), 2,
      sym_else_if_clause,
      aux_sym_if_statement_repeat1,
  [10928] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1034), 1,
      anon_sym_SQUOTE,
    ACTIONS(1036), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1038), 1,
      sym_escape_sequence,
    STATE(364), 1,
      aux_sym_single_quote_string_repeat1,
  [10944] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1040), 1,
      anon_sym_end,
    ACTIONS(1042), 1,
      anon_sym_case,
    STATE(362), 2,
      sym_case_clause,
      aux_sym_switch_statement_repeat1,
  [10958] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1027), 1,
      anon_sym_case,
    ACTIONS(1045), 1,
      anon_sym_end,
    STATE(362), 2,
      sym_case_clause,
      aux_sym_switch_statement_repeat1,
  [10972] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_SQUOTE,
    ACTIONS(1049), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1052), 1,
      sym_escape_sequence,
    STATE(364), 1,
      aux_sym_single_quote_string_repeat1,
  [10988] = 5,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1055), 1,
      anon_sym_DOLLAR,
    ACTIONS(1057), 1,
      anon_sym_LPAREN,
    ACTIONS(1059), 1,
      sym_variable_name,
    STATE(280), 1,
      sym_variable_expansion,
  [11004] = 5,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1061), 1,
      anon_sym_DOLLAR,
    ACTIONS(1063), 1,
      anon_sym_LPAREN,
    ACTIONS(1065), 1,
      sym_variable_name,
    STATE(89), 1,
      sym_variable_expansion,
  [11020] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1067), 1,
      anon_sym_SQUOTE,
    ACTIONS(1069), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1071), 1,
      sym_escape_sequence,
    STATE(377), 1,
      aux_sym_single_quote_string_repeat1,
  [11036] = 5,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1073), 1,
      anon_sym_DOLLAR,
    ACTIONS(1075), 1,
      anon_sym_LPAREN,
    ACTIONS(1077), 1,
      sym_variable_name,
    STATE(173), 1,
      sym_variable_expansion,
  [11052] = 5,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1079), 1,
      anon_sym_DOLLAR,
    ACTIONS(1081), 1,
      anon_sym_LPAREN,
    ACTIONS(1083), 1,
      sym_variable_name,
    STATE(296), 1,
      sym_variable_expansion,
  [11068] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1087), 1,
      sym__brace_concat,
    STATE(380), 1,
      aux_sym_brace_concatenation_repeat1,
    ACTIONS(1085), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11082] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1038), 1,
      sym_escape_sequence,
    ACTIONS(1089), 1,
      anon_sym_SQUOTE,
    STATE(364), 1,
      aux_sym_single_quote_string_repeat1,
  [11098] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1091), 1,
      anon_sym_SQUOTE,
    ACTIONS(1093), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1095), 1,
      sym_escape_sequence,
    STATE(376), 1,
      aux_sym_single_quote_string_repeat1,
  [11114] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1097), 1,
      anon_sym_SQUOTE,
    ACTIONS(1099), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1101), 1,
      sym_escape_sequence,
    STATE(382), 1,
      aux_sym_single_quote_string_repeat1,
  [11130] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      anon_sym_SQUOTE,
    ACTIONS(1105), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1107), 1,
      sym_escape_sequence,
    STATE(371), 1,
      aux_sym_single_quote_string_repeat1,
  [11146] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1109), 1,
      anon_sym_SQUOTE,
    ACTIONS(1111), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1113), 1,
      sym_escape_sequence,
    STATE(361), 1,
      aux_sym_single_quote_string_repeat1,
  [11162] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1038), 1,
      sym_escape_sequence,
    ACTIONS(1115), 1,
      anon_sym_SQUOTE,
    STATE(364), 1,
      aux_sym_single_quote_string_repeat1,
  [11178] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1038), 1,
      sym_escape_sequence,
    ACTIONS(1117), 1,
      anon_sym_SQUOTE,
    STATE(364), 1,
      aux_sym_single_quote_string_repeat1,
  [11194] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1087), 1,
      sym__brace_concat,
    STATE(370), 1,
      aux_sym_brace_concatenation_repeat1,
    ACTIONS(1119), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11208] = 5,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1121), 1,
      anon_sym_DOLLAR,
    ACTIONS(1123), 1,
      anon_sym_LPAREN,
    ACTIONS(1125), 1,
      sym_variable_name,
    STATE(307), 1,
      sym_variable_expansion,
  [11224] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1129), 1,
      sym__brace_concat,
    STATE(380), 1,
      aux_sym_brace_concatenation_repeat1,
    ACTIONS(1127), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11238] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1038), 1,
      sym_escape_sequence,
    ACTIONS(1132), 1,
      anon_sym_SQUOTE,
    STATE(364), 1,
      aux_sym_single_quote_string_repeat1,
  [11254] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1038), 1,
      sym_escape_sequence,
    ACTIONS(1134), 1,
      anon_sym_SQUOTE,
    STATE(364), 1,
      aux_sym_single_quote_string_repeat1,
  [11270] = 5,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    ACTIONS(1138), 1,
      anon_sym_LPAREN,
    ACTIONS(1140), 1,
      sym_variable_name,
    STATE(134), 1,
      sym_variable_expansion,
  [11286] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1142), 1,
      anon_sym_SQUOTE,
    ACTIONS(1144), 1,
      aux_sym_single_quote_string_token1,
    ACTIONS(1146), 1,
      sym_escape_sequence,
    STATE(381), 1,
      aux_sym_single_quote_string_repeat1,
  [11302] = 5,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1148), 1,
      anon_sym_DOLLAR,
    ACTIONS(1150), 1,
      anon_sym_LPAREN,
    ACTIONS(1152), 1,
      sym_variable_name,
    STATE(349), 1,
      sym_variable_expansion,
  [11318] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(532), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11328] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(536), 4,
      sym__brace_concat,
      sym__concat_list,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11338] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1079), 1,
      anon_sym_DOLLAR,
    ACTIONS(1154), 1,
      sym_variable_name,
    STATE(298), 1,
      sym_variable_expansion,
  [11351] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1156), 1,
      anon_sym_COMMA,
    ACTIONS(1159), 1,
      anon_sym_RBRACE,
    STATE(389), 1,
      aux_sym_brace_expansion_repeat1,
  [11364] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1127), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11373] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(591), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11382] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(638), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11391] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(646), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11400] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    ACTIONS(1163), 1,
      anon_sym_RBRACE,
    STATE(416), 1,
      aux_sym_brace_expansion_repeat1,
  [11413] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1148), 1,
      anon_sym_DOLLAR,
    ACTIONS(1165), 1,
      sym_variable_name,
    STATE(354), 1,
      sym_variable_expansion,
  [11426] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1061), 1,
      anon_sym_DOLLAR,
    ACTIONS(1167), 1,
      sym_variable_name,
    STATE(88), 1,
      sym_variable_expansion,
  [11439] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(685), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11448] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(634), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11457] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    ACTIONS(1169), 1,
      anon_sym_RBRACE,
    STATE(406), 1,
      aux_sym_brace_expansion_repeat1,
  [11470] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    ACTIONS(1169), 1,
      anon_sym_RBRACE,
    STATE(389), 1,
      aux_sym_brace_expansion_repeat1,
  [11483] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(607), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11492] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    ACTIONS(1171), 1,
      anon_sym_RBRACE,
    STATE(389), 1,
      aux_sym_brace_expansion_repeat1,
  [11505] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(567), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11514] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(697), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11523] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    ACTIONS(1173), 1,
      anon_sym_RBRACE,
    STATE(421), 1,
      aux_sym_brace_expansion_repeat1,
  [11536] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    ACTIONS(1175), 1,
      anon_sym_RBRACE,
    STATE(389), 1,
      aux_sym_brace_expansion_repeat1,
  [11549] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(693), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11558] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(642), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11567] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    ACTIONS(1177), 1,
      anon_sym_RBRACE,
    STATE(389), 1,
      aux_sym_brace_expansion_repeat1,
  [11580] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    ACTIONS(1177), 1,
      anon_sym_RBRACE,
    STATE(412), 1,
      aux_sym_brace_expansion_repeat1,
  [11593] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(587), 3,
      sym__brace_concat,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11602] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    ACTIONS(1179), 1,
      anon_sym_RBRACE,
    STATE(389), 1,
      aux_sym_brace_expansion_repeat1,
  [11615] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1055), 1,
      anon_sym_DOLLAR,
    ACTIONS(1181), 1,
      sym_variable_name,
    STATE(282), 1,
      sym_variable_expansion,
  [11628] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1121), 1,
      anon_sym_DOLLAR,
    ACTIONS(1183), 1,
      sym_variable_name,
    STATE(319), 1,
      sym_variable_expansion,
  [11641] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    ACTIONS(1185), 1,
      sym_variable_name,
    STATE(131), 1,
      sym_variable_expansion,
  [11654] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    ACTIONS(1187), 1,
      anon_sym_RBRACE,
    STATE(389), 1,
      aux_sym_brace_expansion_repeat1,
  [11667] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    ACTIONS(1163), 1,
      anon_sym_RBRACE,
    STATE(389), 1,
      aux_sym_brace_expansion_repeat1,
  [11680] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1073), 1,
      anon_sym_DOLLAR,
    ACTIONS(1189), 1,
      sym_variable_name,
    STATE(171), 1,
      sym_variable_expansion,
  [11693] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    ACTIONS(1191), 1,
      anon_sym_RBRACE,
    STATE(389), 1,
      aux_sym_brace_expansion_repeat1,
  [11706] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    ACTIONS(1173), 1,
      anon_sym_RBRACE,
    STATE(389), 1,
      aux_sym_brace_expansion_repeat1,
  [11719] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    ACTIONS(1193), 1,
      anon_sym_RBRACE,
    STATE(389), 1,
      aux_sym_brace_expansion_repeat1,
  [11732] = 4,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    ACTIONS(1191), 1,
      anon_sym_RBRACE,
    STATE(402), 1,
      aux_sym_brace_expansion_repeat1,
  [11745] = 3,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_LBRACK,
    STATE(333), 1,
      sym_list_element_access,
  [11755] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1159), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11763] = 3,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1197), 1,
      anon_sym_LBRACK,
    STATE(94), 1,
      sym_list_element_access,
  [11773] = 3,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1199), 1,
      anon_sym_LBRACK,
    STATE(175), 1,
      sym_list_element_access,
  [11783] = 3,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1201), 1,
      anon_sym_LBRACK,
    STATE(358), 1,
      sym_list_element_access,
  [11793] = 3,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1203), 1,
      anon_sym_LBRACK,
    STATE(300), 1,
      sym_list_element_access,
  [11803] = 3,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1205), 1,
      anon_sym_LBRACK,
    STATE(145), 1,
      sym_list_element_access,
  [11813] = 3,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1207), 1,
      anon_sym_LBRACK,
    STATE(305), 1,
      sym_list_element_access,
  [11823] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1021), 1,
      anon_sym_end,
  [11830] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1209), 1,
      sym_variable_name,
  [11837] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1211), 1,
      anon_sym_end,
  [11844] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1213), 1,
      anon_sym_if,
  [11851] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1215), 1,
      ts_builtin_sym_end,
  [11858] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1217), 1,
      anon_sym_in,
  [11865] = 2,
    ACTIONS(795), 1,
      sym_comment,
    ACTIONS(1012), 1,
      anon_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(45)] = 0,
  [SMALL_STATE(46)] = 100,
  [SMALL_STATE(47)] = 200,
  [SMALL_STATE(48)] = 300,
  [SMALL_STATE(49)] = 399,
  [SMALL_STATE(50)] = 498,
  [SMALL_STATE(51)] = 597,
  [SMALL_STATE(52)] = 696,
  [SMALL_STATE(53)] = 795,
  [SMALL_STATE(54)] = 894,
  [SMALL_STATE(55)] = 993,
  [SMALL_STATE(56)] = 1092,
  [SMALL_STATE(57)] = 1191,
  [SMALL_STATE(58)] = 1290,
  [SMALL_STATE(59)] = 1389,
  [SMALL_STATE(60)] = 1488,
  [SMALL_STATE(61)] = 1587,
  [SMALL_STATE(62)] = 1686,
  [SMALL_STATE(63)] = 1785,
  [SMALL_STATE(64)] = 1884,
  [SMALL_STATE(65)] = 1983,
  [SMALL_STATE(66)] = 2082,
  [SMALL_STATE(67)] = 2181,
  [SMALL_STATE(68)] = 2280,
  [SMALL_STATE(69)] = 2379,
  [SMALL_STATE(70)] = 2478,
  [SMALL_STATE(71)] = 2577,
  [SMALL_STATE(72)] = 2672,
  [SMALL_STATE(73)] = 2767,
  [SMALL_STATE(74)] = 2862,
  [SMALL_STATE(75)] = 2954,
  [SMALL_STATE(76)] = 3046,
  [SMALL_STATE(77)] = 3138,
  [SMALL_STATE(78)] = 3230,
  [SMALL_STATE(79)] = 3300,
  [SMALL_STATE(80)] = 3370,
  [SMALL_STATE(81)] = 3440,
  [SMALL_STATE(82)] = 3500,
  [SMALL_STATE(83)] = 3539,
  [SMALL_STATE(84)] = 3578,
  [SMALL_STATE(85)] = 3616,
  [SMALL_STATE(86)] = 3654,
  [SMALL_STATE(87)] = 3694,
  [SMALL_STATE(88)] = 3732,
  [SMALL_STATE(89)] = 3771,
  [SMALL_STATE(90)] = 3812,
  [SMALL_STATE(91)] = 3853,
  [SMALL_STATE(92)] = 3892,
  [SMALL_STATE(93)] = 3933,
  [SMALL_STATE(94)] = 3971,
  [SMALL_STATE(95)] = 4007,
  [SMALL_STATE(96)] = 4041,
  [SMALL_STATE(97)] = 4079,
  [SMALL_STATE(98)] = 4115,
  [SMALL_STATE(99)] = 4151,
  [SMALL_STATE(100)] = 4189,
  [SMALL_STATE(101)] = 4227,
  [SMALL_STATE(102)] = 4282,
  [SMALL_STATE(103)] = 4317,
  [SMALL_STATE(104)] = 4372,
  [SMALL_STATE(105)] = 4407,
  [SMALL_STATE(106)] = 4442,
  [SMALL_STATE(107)] = 4477,
  [SMALL_STATE(108)] = 4540,
  [SMALL_STATE(109)] = 4575,
  [SMALL_STATE(110)] = 4628,
  [SMALL_STATE(111)] = 4663,
  [SMALL_STATE(112)] = 4698,
  [SMALL_STATE(113)] = 4733,
  [SMALL_STATE(114)] = 4768,
  [SMALL_STATE(115)] = 4823,
  [SMALL_STATE(116)] = 4886,
  [SMALL_STATE(117)] = 4939,
  [SMALL_STATE(118)] = 4974,
  [SMALL_STATE(119)] = 5009,
  [SMALL_STATE(120)] = 5044,
  [SMALL_STATE(121)] = 5079,
  [SMALL_STATE(122)] = 5112,
  [SMALL_STATE(123)] = 5144,
  [SMALL_STATE(124)] = 5176,
  [SMALL_STATE(125)] = 5208,
  [SMALL_STATE(126)] = 5254,
  [SMALL_STATE(127)] = 5302,
  [SMALL_STATE(128)] = 5349,
  [SMALL_STATE(129)] = 5396,
  [SMALL_STATE(130)] = 5427,
  [SMALL_STATE(131)] = 5460,
  [SMALL_STATE(132)] = 5491,
  [SMALL_STATE(133)] = 5538,
  [SMALL_STATE(134)] = 5583,
  [SMALL_STATE(135)] = 5616,
  [SMALL_STATE(136)] = 5661,
  [SMALL_STATE(137)] = 5708,
  [SMALL_STATE(138)] = 5741,
  [SMALL_STATE(139)] = 5786,
  [SMALL_STATE(140)] = 5831,
  [SMALL_STATE(141)] = 5878,
  [SMALL_STATE(142)] = 5918,
  [SMALL_STATE(143)] = 5948,
  [SMALL_STATE(144)] = 5976,
  [SMALL_STATE(145)] = 6004,
  [SMALL_STATE(146)] = 6032,
  [SMALL_STATE(147)] = 6062,
  [SMALL_STATE(148)] = 6092,
  [SMALL_STATE(149)] = 6122,
  [SMALL_STATE(150)] = 6162,
  [SMALL_STATE(151)] = 6202,
  [SMALL_STATE(152)] = 6244,
  [SMALL_STATE(153)] = 6284,
  [SMALL_STATE(154)] = 6311,
  [SMALL_STATE(155)] = 6338,
  [SMALL_STATE(156)] = 6365,
  [SMALL_STATE(157)] = 6392,
  [SMALL_STATE(158)] = 6419,
  [SMALL_STATE(159)] = 6446,
  [SMALL_STATE(160)] = 6473,
  [SMALL_STATE(161)] = 6500,
  [SMALL_STATE(162)] = 6527,
  [SMALL_STATE(163)] = 6554,
  [SMALL_STATE(164)] = 6581,
  [SMALL_STATE(165)] = 6608,
  [SMALL_STATE(166)] = 6635,
  [SMALL_STATE(167)] = 6659,
  [SMALL_STATE(168)] = 6683,
  [SMALL_STATE(169)] = 6711,
  [SMALL_STATE(170)] = 6737,
  [SMALL_STATE(171)] = 6771,
  [SMALL_STATE(172)] = 6797,
  [SMALL_STATE(173)] = 6825,
  [SMALL_STATE(174)] = 6853,
  [SMALL_STATE(175)] = 6878,
  [SMALL_STATE(176)] = 6901,
  [SMALL_STATE(177)] = 6924,
  [SMALL_STATE(178)] = 6949,
  [SMALL_STATE(179)] = 6974,
  [SMALL_STATE(180)] = 6997,
  [SMALL_STATE(181)] = 7022,
  [SMALL_STATE(182)] = 7054,
  [SMALL_STATE(183)] = 7086,
  [SMALL_STATE(184)] = 7108,
  [SMALL_STATE(185)] = 7130,
  [SMALL_STATE(186)] = 7168,
  [SMALL_STATE(187)] = 7190,
  [SMALL_STATE(188)] = 7212,
  [SMALL_STATE(189)] = 7244,
  [SMALL_STATE(190)] = 7274,
  [SMALL_STATE(191)] = 7306,
  [SMALL_STATE(192)] = 7338,
  [SMALL_STATE(193)] = 7366,
  [SMALL_STATE(194)] = 7398,
  [SMALL_STATE(195)] = 7430,
  [SMALL_STATE(196)] = 7468,
  [SMALL_STATE(197)] = 7500,
  [SMALL_STATE(198)] = 7538,
  [SMALL_STATE(199)] = 7576,
  [SMALL_STATE(200)] = 7608,
  [SMALL_STATE(201)] = 7630,
  [SMALL_STATE(202)] = 7668,
  [SMALL_STATE(203)] = 7690,
  [SMALL_STATE(204)] = 7728,
  [SMALL_STATE(205)] = 7760,
  [SMALL_STATE(206)] = 7790,
  [SMALL_STATE(207)] = 7822,
  [SMALL_STATE(208)] = 7860,
  [SMALL_STATE(209)] = 7882,
  [SMALL_STATE(210)] = 7914,
  [SMALL_STATE(211)] = 7952,
  [SMALL_STATE(212)] = 7984,
  [SMALL_STATE(213)] = 8016,
  [SMALL_STATE(214)] = 8048,
  [SMALL_STATE(215)] = 8086,
  [SMALL_STATE(216)] = 8124,
  [SMALL_STATE(217)] = 8156,
  [SMALL_STATE(218)] = 8188,
  [SMALL_STATE(219)] = 8220,
  [SMALL_STATE(220)] = 8252,
  [SMALL_STATE(221)] = 8290,
  [SMALL_STATE(222)] = 8312,
  [SMALL_STATE(223)] = 8344,
  [SMALL_STATE(224)] = 8382,
  [SMALL_STATE(225)] = 8404,
  [SMALL_STATE(226)] = 8442,
  [SMALL_STATE(227)] = 8480,
  [SMALL_STATE(228)] = 8502,
  [SMALL_STATE(229)] = 8524,
  [SMALL_STATE(230)] = 8546,
  [SMALL_STATE(231)] = 8568,
  [SMALL_STATE(232)] = 8606,
  [SMALL_STATE(233)] = 8628,
  [SMALL_STATE(234)] = 8660,
  [SMALL_STATE(235)] = 8679,
  [SMALL_STATE(236)] = 8708,
  [SMALL_STATE(237)] = 8727,
  [SMALL_STATE(238)] = 8746,
  [SMALL_STATE(239)] = 8765,
  [SMALL_STATE(240)] = 8784,
  [SMALL_STATE(241)] = 8803,
  [SMALL_STATE(242)] = 8822,
  [SMALL_STATE(243)] = 8841,
  [SMALL_STATE(244)] = 8870,
  [SMALL_STATE(245)] = 8899,
  [SMALL_STATE(246)] = 8928,
  [SMALL_STATE(247)] = 8947,
  [SMALL_STATE(248)] = 8966,
  [SMALL_STATE(249)] = 8985,
  [SMALL_STATE(250)] = 9004,
  [SMALL_STATE(251)] = 9023,
  [SMALL_STATE(252)] = 9042,
  [SMALL_STATE(253)] = 9061,
  [SMALL_STATE(254)] = 9080,
  [SMALL_STATE(255)] = 9099,
  [SMALL_STATE(256)] = 9128,
  [SMALL_STATE(257)] = 9157,
  [SMALL_STATE(258)] = 9186,
  [SMALL_STATE(259)] = 9205,
  [SMALL_STATE(260)] = 9224,
  [SMALL_STATE(261)] = 9253,
  [SMALL_STATE(262)] = 9272,
  [SMALL_STATE(263)] = 9291,
  [SMALL_STATE(264)] = 9310,
  [SMALL_STATE(265)] = 9329,
  [SMALL_STATE(266)] = 9348,
  [SMALL_STATE(267)] = 9367,
  [SMALL_STATE(268)] = 9386,
  [SMALL_STATE(269)] = 9405,
  [SMALL_STATE(270)] = 9424,
  [SMALL_STATE(271)] = 9443,
  [SMALL_STATE(272)] = 9462,
  [SMALL_STATE(273)] = 9481,
  [SMALL_STATE(274)] = 9500,
  [SMALL_STATE(275)] = 9519,
  [SMALL_STATE(276)] = 9538,
  [SMALL_STATE(277)] = 9557,
  [SMALL_STATE(278)] = 9589,
  [SMALL_STATE(279)] = 9621,
  [SMALL_STATE(280)] = 9640,
  [SMALL_STATE(281)] = 9659,
  [SMALL_STATE(282)] = 9678,
  [SMALL_STATE(283)] = 9695,
  [SMALL_STATE(284)] = 9712,
  [SMALL_STATE(285)] = 9734,
  [SMALL_STATE(286)] = 9756,
  [SMALL_STATE(287)] = 9778,
  [SMALL_STATE(288)] = 9800,
  [SMALL_STATE(289)] = 9822,
  [SMALL_STATE(290)] = 9844,
  [SMALL_STATE(291)] = 9866,
  [SMALL_STATE(292)] = 9886,
  [SMALL_STATE(293)] = 9908,
  [SMALL_STATE(294)] = 9928,
  [SMALL_STATE(295)] = 9950,
  [SMALL_STATE(296)] = 9972,
  [SMALL_STATE(297)] = 9992,
  [SMALL_STATE(298)] = 10010,
  [SMALL_STATE(299)] = 10028,
  [SMALL_STATE(300)] = 10050,
  [SMALL_STATE(301)] = 10064,
  [SMALL_STATE(302)] = 10086,
  [SMALL_STATE(303)] = 10100,
  [SMALL_STATE(304)] = 10114,
  [SMALL_STATE(305)] = 10136,
  [SMALL_STATE(306)] = 10151,
  [SMALL_STATE(307)] = 10164,
  [SMALL_STATE(308)] = 10181,
  [SMALL_STATE(309)] = 10194,
  [SMALL_STATE(310)] = 10207,
  [SMALL_STATE(311)] = 10220,
  [SMALL_STATE(312)] = 10237,
  [SMALL_STATE(313)] = 10250,
  [SMALL_STATE(314)] = 10265,
  [SMALL_STATE(315)] = 10278,
  [SMALL_STATE(316)] = 10295,
  [SMALL_STATE(317)] = 10312,
  [SMALL_STATE(318)] = 10325,
  [SMALL_STATE(319)] = 10342,
  [SMALL_STATE(320)] = 10359,
  [SMALL_STATE(321)] = 10376,
  [SMALL_STATE(322)] = 10393,
  [SMALL_STATE(323)] = 10410,
  [SMALL_STATE(324)] = 10425,
  [SMALL_STATE(325)] = 10438,
  [SMALL_STATE(326)] = 10451,
  [SMALL_STATE(327)] = 10466,
  [SMALL_STATE(328)] = 10479,
  [SMALL_STATE(329)] = 10492,
  [SMALL_STATE(330)] = 10506,
  [SMALL_STATE(331)] = 10520,
  [SMALL_STATE(332)] = 10534,
  [SMALL_STATE(333)] = 10548,
  [SMALL_STATE(334)] = 10562,
  [SMALL_STATE(335)] = 10576,
  [SMALL_STATE(336)] = 10590,
  [SMALL_STATE(337)] = 10604,
  [SMALL_STATE(338)] = 10618,
  [SMALL_STATE(339)] = 10632,
  [SMALL_STATE(340)] = 10646,
  [SMALL_STATE(341)] = 10660,
  [SMALL_STATE(342)] = 10674,
  [SMALL_STATE(343)] = 10688,
  [SMALL_STATE(344)] = 10702,
  [SMALL_STATE(345)] = 10716,
  [SMALL_STATE(346)] = 10730,
  [SMALL_STATE(347)] = 10747,
  [SMALL_STATE(348)] = 10758,
  [SMALL_STATE(349)] = 10773,
  [SMALL_STATE(350)] = 10788,
  [SMALL_STATE(351)] = 10805,
  [SMALL_STATE(352)] = 10820,
  [SMALL_STATE(353)] = 10831,
  [SMALL_STATE(354)] = 10844,
  [SMALL_STATE(355)] = 10857,
  [SMALL_STATE(356)] = 10868,
  [SMALL_STATE(357)] = 10879,
  [SMALL_STATE(358)] = 10890,
  [SMALL_STATE(359)] = 10900,
  [SMALL_STATE(360)] = 10914,
  [SMALL_STATE(361)] = 10928,
  [SMALL_STATE(362)] = 10944,
  [SMALL_STATE(363)] = 10958,
  [SMALL_STATE(364)] = 10972,
  [SMALL_STATE(365)] = 10988,
  [SMALL_STATE(366)] = 11004,
  [SMALL_STATE(367)] = 11020,
  [SMALL_STATE(368)] = 11036,
  [SMALL_STATE(369)] = 11052,
  [SMALL_STATE(370)] = 11068,
  [SMALL_STATE(371)] = 11082,
  [SMALL_STATE(372)] = 11098,
  [SMALL_STATE(373)] = 11114,
  [SMALL_STATE(374)] = 11130,
  [SMALL_STATE(375)] = 11146,
  [SMALL_STATE(376)] = 11162,
  [SMALL_STATE(377)] = 11178,
  [SMALL_STATE(378)] = 11194,
  [SMALL_STATE(379)] = 11208,
  [SMALL_STATE(380)] = 11224,
  [SMALL_STATE(381)] = 11238,
  [SMALL_STATE(382)] = 11254,
  [SMALL_STATE(383)] = 11270,
  [SMALL_STATE(384)] = 11286,
  [SMALL_STATE(385)] = 11302,
  [SMALL_STATE(386)] = 11318,
  [SMALL_STATE(387)] = 11328,
  [SMALL_STATE(388)] = 11338,
  [SMALL_STATE(389)] = 11351,
  [SMALL_STATE(390)] = 11364,
  [SMALL_STATE(391)] = 11373,
  [SMALL_STATE(392)] = 11382,
  [SMALL_STATE(393)] = 11391,
  [SMALL_STATE(394)] = 11400,
  [SMALL_STATE(395)] = 11413,
  [SMALL_STATE(396)] = 11426,
  [SMALL_STATE(397)] = 11439,
  [SMALL_STATE(398)] = 11448,
  [SMALL_STATE(399)] = 11457,
  [SMALL_STATE(400)] = 11470,
  [SMALL_STATE(401)] = 11483,
  [SMALL_STATE(402)] = 11492,
  [SMALL_STATE(403)] = 11505,
  [SMALL_STATE(404)] = 11514,
  [SMALL_STATE(405)] = 11523,
  [SMALL_STATE(406)] = 11536,
  [SMALL_STATE(407)] = 11549,
  [SMALL_STATE(408)] = 11558,
  [SMALL_STATE(409)] = 11567,
  [SMALL_STATE(410)] = 11580,
  [SMALL_STATE(411)] = 11593,
  [SMALL_STATE(412)] = 11602,
  [SMALL_STATE(413)] = 11615,
  [SMALL_STATE(414)] = 11628,
  [SMALL_STATE(415)] = 11641,
  [SMALL_STATE(416)] = 11654,
  [SMALL_STATE(417)] = 11667,
  [SMALL_STATE(418)] = 11680,
  [SMALL_STATE(419)] = 11693,
  [SMALL_STATE(420)] = 11706,
  [SMALL_STATE(421)] = 11719,
  [SMALL_STATE(422)] = 11732,
  [SMALL_STATE(423)] = 11745,
  [SMALL_STATE(424)] = 11755,
  [SMALL_STATE(425)] = 11763,
  [SMALL_STATE(426)] = 11773,
  [SMALL_STATE(427)] = 11783,
  [SMALL_STATE(428)] = 11793,
  [SMALL_STATE(429)] = 11803,
  [SMALL_STATE(430)] = 11813,
  [SMALL_STATE(431)] = 11823,
  [SMALL_STATE(432)] = 11830,
  [SMALL_STATE(433)] = 11837,
  [SMALL_STATE(434)] = 11844,
  [SMALL_STATE(435)] = 11851,
  [SMALL_STATE(436)] = 11858,
  [SMALL_STATE(437)] = 11865,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(366),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(18),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(244),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(432),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(71),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(7),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(287),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(372),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(6),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(262),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(256),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(335),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(2),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(239),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [57] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_clause, 3, .production_id = 16),
  [59] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_clause, 4, .production_id = 16),
  [61] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(96),
  [64] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(74),
  [67] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(6),
  [70] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(75),
  [73] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(366),
  [76] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(18),
  [79] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(139),
  [82] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2),
  [84] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(81),
  [87] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(133),
  [90] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(256),
  [93] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(432),
  [96] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(71),
  [99] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(72),
  [102] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(7),
  [105] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(118),
  [108] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(128),
  [111] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(287),
  [114] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(372),
  [117] = {.entry = {.count = 1, .reusable = false}}, SHIFT(13),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(263),
  [121] = {.entry = {.count = 1, .reusable = false}}, SHIFT(235),
  [123] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [125] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_clause, 2),
  [127] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [129] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_clause, 3),
  [131] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(10),
  [134] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_while_statement_repeat1, 2), SHIFT_REPEAT(235),
  [137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(267),
  [139] = {.entry = {.count = 1, .reusable = false}}, SHIFT(11),
  [141] = {.entry = {.count = 1, .reusable = false}}, SHIFT(240),
  [143] = {.entry = {.count = 1, .reusable = false}}, SHIFT(273),
  [145] = {.entry = {.count = 1, .reusable = false}}, SHIFT(32),
  [147] = {.entry = {.count = 1, .reusable = false}}, SHIFT(113),
  [149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(209),
  [151] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(310),
  [155] = {.entry = {.count = 1, .reusable = false}}, SHIFT(213),
  [157] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [159] = {.entry = {.count = 1, .reusable = false}}, SHIFT(194),
  [161] = {.entry = {.count = 1, .reusable = false}}, SHIFT(312),
  [163] = {.entry = {.count = 1, .reusable = false}}, SHIFT(219),
  [165] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [167] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(196),
  [171] = {.entry = {.count = 1, .reusable = false}}, SHIFT(154),
  [173] = {.entry = {.count = 1, .reusable = false}}, SHIFT(212),
  [175] = {.entry = {.count = 1, .reusable = false}}, SHIFT(357),
  [177] = {.entry = {.count = 1, .reusable = false}}, SHIFT(190),
  [179] = {.entry = {.count = 1, .reusable = false}}, SHIFT(16),
  [181] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(355),
  [185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(206),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(393),
  [189] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [193] = {.entry = {.count = 1, .reusable = false}}, SHIFT(224),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(216),
  [197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 1),
  [199] = {.entry = {.count = 1, .reusable = false}}, SHIFT(37),
  [201] = {.entry = {.count = 1, .reusable = false}}, SHIFT(403),
  [203] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [205] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [207] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [209] = {.entry = {.count = 1, .reusable = false}}, SHIFT(411),
  [211] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [213] = {.entry = {.count = 1, .reusable = false}}, SHIFT(14),
  [215] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [217] = {.entry = {.count = 1, .reusable = false}}, SHIFT(218),
  [219] = {.entry = {.count = 1, .reusable = false}}, SHIFT(157),
  [221] = {.entry = {.count = 1, .reusable = false}}, SHIFT(211),
  [223] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(96),
  [226] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(74),
  [229] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(32),
  [232] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(75),
  [235] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(366),
  [238] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(18),
  [241] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2),
  [243] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(139),
  [246] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(81),
  [249] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(133),
  [252] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(243),
  [255] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(432),
  [258] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(71),
  [261] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(72),
  [264] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(7),
  [267] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(118),
  [270] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(128),
  [273] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(287),
  [276] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(372),
  [279] = {.entry = {.count = 1, .reusable = false}}, SHIFT(338),
  [281] = {.entry = {.count = 1, .reusable = false}}, SHIFT(199),
  [283] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [285] = {.entry = {.count = 1, .reusable = false}}, SHIFT(309),
  [287] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [289] = {.entry = {.count = 1, .reusable = false}}, SHIFT(345),
  [291] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2),
  [295] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(37),
  [298] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(244),
  [301] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [303] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [305] = {.entry = {.count = 1, .reusable = false}}, SHIFT(330),
  [307] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [309] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [311] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [313] = {.entry = {.count = 1, .reusable = false}}, SHIFT(230),
  [315] = {.entry = {.count = 1, .reusable = false}}, SHIFT(217),
  [317] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [319] = {.entry = {.count = 1, .reusable = false}}, SHIFT(159),
  [321] = {.entry = {.count = 1, .reusable = false}}, SHIFT(204),
  [323] = {.entry = {.count = 1, .reusable = false}}, SHIFT(187),
  [325] = {.entry = {.count = 1, .reusable = false}}, SHIFT(222),
  [327] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(96),
  [330] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(74),
  [333] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(75),
  [336] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(366),
  [339] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(18),
  [342] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(139),
  [345] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2),
  [347] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(81),
  [350] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(133),
  [353] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(245),
  [356] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(432),
  [359] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(71),
  [362] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(72),
  [365] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(7),
  [368] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(118),
  [371] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(128),
  [374] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(287),
  [377] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(372),
  [380] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case_clause, 4),
  [382] = {.entry = {.count = 1, .reusable = false}}, SHIFT(245),
  [384] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case_clause, 3),
  [386] = {.entry = {.count = 1, .reusable = false}}, SHIFT(236),
  [388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(257),
  [390] = {.entry = {.count = 1, .reusable = false}}, SHIFT(276),
  [392] = {.entry = {.count = 1, .reusable = false}}, SHIFT(238),
  [394] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat2, 2), SHIFT_REPEAT(257),
  [397] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [399] = {.entry = {.count = 1, .reusable = false}}, SHIFT(259),
  [401] = {.entry = {.count = 1, .reusable = false}}, SHIFT(261),
  [403] = {.entry = {.count = 1, .reusable = false}}, SHIFT(265),
  [405] = {.entry = {.count = 1, .reusable = false}}, SHIFT(269),
  [407] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [409] = {.entry = {.count = 1, .reusable = false}}, SHIFT(264),
  [411] = {.entry = {.count = 1, .reusable = false}}, SHIFT(271),
  [413] = {.entry = {.count = 1, .reusable = false}}, SHIFT(272),
  [415] = {.entry = {.count = 1, .reusable = false}}, SHIFT(275),
  [417] = {.entry = {.count = 1, .reusable = false}}, SHIFT(274),
  [419] = {.entry = {.count = 1, .reusable = false}}, SHIFT(234),
  [421] = {.entry = {.count = 1, .reusable = false}}, SHIFT(258),
  [423] = {.entry = {.count = 1, .reusable = false}}, SHIFT(254),
  [425] = {.entry = {.count = 1, .reusable = false}}, SHIFT(270),
  [427] = {.entry = {.count = 1, .reusable = false}}, SHIFT(253),
  [429] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [431] = {.entry = {.count = 1, .reusable = false}}, SHIFT(251),
  [433] = {.entry = {.count = 1, .reusable = false}}, SHIFT(247),
  [435] = {.entry = {.count = 1, .reusable = false}}, SHIFT(260),
  [437] = {.entry = {.count = 1, .reusable = false}}, SHIFT(255),
  [439] = {.entry = {.count = 1, .reusable = false}}, SHIFT(189),
  [441] = {.entry = {.count = 1, .reusable = false}}, SHIFT(192),
  [443] = {.entry = {.count = 1, .reusable = false}}, SHIFT(205),
  [445] = {.entry = {.count = 1, .reusable = false}}, SHIFT(202),
  [447] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command, 1, .production_id = 2),
  [449] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [451] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [453] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(96),
  [456] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9),
  [458] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(366),
  [461] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(18),
  [464] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(118),
  [467] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(128),
  [470] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(287),
  [473] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(372),
  [476] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(122),
  [479] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 2, .production_id = 9), SHIFT_REPEAT(135),
  [482] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command, 2, .production_id = 5),
  [484] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [486] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return, 1),
  [488] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [490] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [492] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [494] = {.entry = {.count = 1, .reusable = false}}, SHIFT(140),
  [496] = {.entry = {.count = 1, .reusable = false}}, SHIFT(285),
  [498] = {.entry = {.count = 1, .reusable = false}}, SHIFT(375),
  [500] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__terminated_opt_statement, 2),
  [502] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__terminated_statement, 2),
  [504] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_expansion, 2),
  [506] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_expansion, 2),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [510] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_expansion, 3),
  [512] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_expansion, 3),
  [514] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_variable_expansion_repeat1, 2),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2),
  [518] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(425),
  [521] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_concatenation_repeat1, 2),
  [523] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(150),
  [526] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [530] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_element_access, 2),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_element_access, 2),
  [534] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_element_access, 3),
  [536] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_element_access, 3),
  [538] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1, .production_id = 1),
  [540] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_concatenation, 2),
  [542] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 11), SHIFT_REPEAT(148),
  [545] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 11),
  [547] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 11), SHIFT_REPEAT(383),
  [550] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 11), SHIFT_REPEAT(42),
  [553] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 11), SHIFT_REPEAT(156),
  [556] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 11), SHIFT_REPEAT(127),
  [559] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 11), SHIFT_REPEAT(284),
  [562] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 2, .production_id = 11), SHIFT_REPEAT(367),
  [565] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution, 3),
  [567] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution, 3),
  [569] = {.entry = {.count = 1, .reusable = false}}, SHIFT(148),
  [571] = {.entry = {.count = 1, .reusable = false}}, SHIFT(66),
  [573] = {.entry = {.count = 1, .reusable = false}}, SHIFT(383),
  [575] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [577] = {.entry = {.count = 1, .reusable = false}}, SHIFT(156),
  [579] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [581] = {.entry = {.count = 1, .reusable = false}}, SHIFT(284),
  [583] = {.entry = {.count = 1, .reusable = false}}, SHIFT(367),
  [585] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution, 2),
  [587] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution, 2),
  [589] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution, 5),
  [591] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution, 5),
  [593] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2),
  [595] = {.entry = {.count = 1, .reusable = false}}, SHIFT(69),
  [597] = {.entry = {.count = 1, .reusable = false}}, SHIFT(68),
  [599] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [601] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [603] = {.entry = {.count = 1, .reusable = false}}, SHIFT(64),
  [605] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_brace_expansion, 3),
  [607] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_brace_expansion, 3),
  [609] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(148),
  [612] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2),
  [614] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(383),
  [617] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(42),
  [620] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(156),
  [623] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(127),
  [626] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(284),
  [629] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_clause_repeat1, 2), SHIFT_REPEAT(367),
  [632] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_double_quote_string, 3),
  [634] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_double_quote_string, 3),
  [636] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_brace_expansion, 4),
  [638] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_brace_expansion, 4),
  [640] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_brace_expansion, 2),
  [642] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_brace_expansion, 2),
  [644] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution, 4),
  [646] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution, 4),
  [648] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 15), SHIFT_REPEAT(148),
  [651] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 15),
  [653] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 15), SHIFT_REPEAT(383),
  [656] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 15), SHIFT_REPEAT(42),
  [659] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 15), SHIFT_REPEAT(156),
  [662] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 15), SHIFT_REPEAT(127),
  [665] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 15), SHIFT_REPEAT(284),
  [668] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 2, .production_id = 15), SHIFT_REPEAT(367),
  [671] = {.entry = {.count = 1, .reusable = false}}, SHIFT(59),
  [673] = {.entry = {.count = 1, .reusable = false}}, SHIFT(61),
  [675] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [677] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [679] = {.entry = {.count = 1, .reusable = false}}, SHIFT(60),
  [681] = {.entry = {.count = 1, .reusable = false}}, SHIFT(47),
  [683] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_single_quote_string, 3),
  [685] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_single_quote_string, 3),
  [687] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__special_character, 1),
  [689] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__special_character, 1),
  [691] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_double_quote_string, 2),
  [693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_double_quote_string, 2),
  [695] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_single_quote_string, 2),
  [697] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_single_quote_string, 2),
  [699] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 1, .production_id = 3),
  [701] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_command_repeat1, 1, .production_id = 4),
  [703] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_file_redirect, 2, .production_id = 7),
  [705] = {.entry = {.count = 1, .reusable = false}}, SHIFT(385),
  [707] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [709] = {.entry = {.count = 1, .reusable = false}}, SHIFT(378),
  [711] = {.entry = {.count = 1, .reusable = false}}, SHIFT(136),
  [713] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [715] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [717] = {.entry = {.count = 1, .reusable = false}}, SHIFT(301),
  [719] = {.entry = {.count = 1, .reusable = false}}, SHIFT(384),
  [721] = {.entry = {.count = 1, .reusable = false}}, SHIFT(112),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [725] = {.entry = {.count = 1, .reusable = false}}, SHIFT(334),
  [727] = {.entry = {.count = 1, .reusable = false}}, SHIFT(315),
  [729] = {.entry = {.count = 1, .reusable = false}}, SHIFT(369),
  [731] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [733] = {.entry = {.count = 1, .reusable = false}}, SHIFT(332),
  [735] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [737] = {.entry = {.count = 1, .reusable = false}}, SHIFT(289),
  [739] = {.entry = {.count = 1, .reusable = false}}, SHIFT(373),
  [741] = {.entry = {.count = 1, .reusable = false}}, SHIFT(408),
  [743] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(429),
  [746] = {.entry = {.count = 1, .reusable = false}}, SHIFT(227),
  [748] = {.entry = {.count = 1, .reusable = false}}, SHIFT(155),
  [750] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(141),
  [753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [755] = {.entry = {.count = 1, .reusable = false}}, SHIFT(232),
  [757] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [759] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_brace_expansion_repeat1, 1),
  [761] = {.entry = {.count = 1, .reusable = false}}, SHIFT(343),
  [763] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_for_statement_repeat1, 1, .production_id = 13),
  [765] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_definition_repeat1, 1, .production_id = 6),
  [767] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(426),
  [770] = {.entry = {.count = 1, .reusable = false}}, SHIFT(390),
  [772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [774] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(149),
  [777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [779] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [781] = {.entry = {.count = 1, .reusable = false}}, SHIFT(77),
  [783] = {.entry = {.count = 1, .reusable = false}}, SHIFT(87),
  [785] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [787] = {.entry = {.count = 1, .reusable = false}}, SHIFT(138),
  [789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [805] = {.entry = {.count = 1, .reusable = false}}, SHIFT(391),
  [807] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional_execution, 2),
  [809] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_negated_statement, 2),
  [811] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [815] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [819] = {.entry = {.count = 1, .reusable = false}}, SHIFT(336),
  [821] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(365),
  [824] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(35),
  [827] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(327),
  [830] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(277),
  [833] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2),
  [835] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(304),
  [838] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 2), SHIFT_REPEAT(374),
  [841] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pipe, 3),
  [843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [845] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional_execution, 3),
  [847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [849] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [853] = {.entry = {.count = 1, .reusable = false}}, SHIFT(153),
  [855] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [859] = {.entry = {.count = 1, .reusable = false}}, SHIFT(308),
  [861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [863] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [873] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 7, .production_id = 17),
  [875] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [877] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 3, .production_id = 8),
  [879] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 3, .production_id = 8),
  [881] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 6, .production_id = 14),
  [883] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [885] = {.entry = {.count = 1, .reusable = false}}, SHIFT(95),
  [887] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return, 2),
  [889] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 5, .production_id = 10),
  [891] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 8),
  [893] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_redirect_statement, 2),
  [895] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 8),
  [897] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 5, .production_id = 14),
  [899] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [901] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [903] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [905] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [907] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 4, .production_id = 8),
  [909] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_begin_statement, 2),
  [911] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch_statement, 5, .production_id = 12),
  [913] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 4, .production_id = 8),
  [915] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch_statement, 4, .production_id = 12),
  [917] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 4, .production_id = 10),
  [919] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 6, .production_id = 17),
  [921] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_begin_statement, 3),
  [923] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 1),
  [925] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 2),
  [927] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(428),
  [930] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [932] = {.entry = {.count = 1, .reusable = false}}, SHIFT(379),
  [934] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [936] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [938] = {.entry = {.count = 1, .reusable = false}}, SHIFT(295),
  [940] = {.entry = {.count = 1, .reusable = false}}, SHIFT(228),
  [942] = {.entry = {.count = 1, .reusable = false}}, SHIFT(288),
  [944] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [946] = {.entry = {.count = 1, .reusable = false}}, SHIFT(294),
  [948] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [950] = {.entry = {.count = 1, .reusable = false}}, SHIFT(286),
  [952] = {.entry = {.count = 1, .reusable = false}}, SHIFT(184),
  [954] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [956] = {.entry = {.count = 1, .reusable = false}}, SHIFT(290),
  [958] = {.entry = {.count = 1, .reusable = false}}, SHIFT(340),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [962] = {.entry = {.count = 1, .reusable = false}}, SHIFT(398),
  [964] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(430),
  [967] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_double_quote_string_repeat1, 2), SHIFT_REPEAT(379),
  [970] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_double_quote_string_repeat1, 2), SHIFT_REPEAT(22),
  [973] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_double_quote_string_repeat1, 2),
  [975] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_double_quote_string_repeat1, 2), SHIFT_REPEAT(294),
  [978] = {.entry = {.count = 1, .reusable = false}}, SHIFT(164),
  [980] = {.entry = {.count = 1, .reusable = false}}, SHIFT(325),
  [982] = {.entry = {.count = 1, .reusable = false}}, SHIFT(407),
  [984] = {.entry = {.count = 1, .reusable = false}}, SHIFT(292),
  [986] = {.entry = {.count = 1, .reusable = false}}, SHIFT(306),
  [988] = {.entry = {.count = 1, .reusable = false}}, SHIFT(299),
  [990] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [992] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_element_access_repeat1, 1),
  [994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [998] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 3),
  [1000] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(423),
  [1003] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenation_repeat1, 2), SHIFT_REPEAT(152),
  [1006] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_index, 1),
  [1008] = {.entry = {.count = 1, .reusable = false}}, SHIFT(8),
  [1010] = {.entry = {.count = 1, .reusable = false}}, SHIFT(73),
  [1012] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [1014] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [1016] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_expansion_repeat1, 2), SHIFT_REPEAT(427),
  [1019] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [1021] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [1023] = {.entry = {.count = 1, .reusable = false}}, SHIFT(359),
  [1025] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [1027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [1029] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2),
  [1031] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2), SHIFT_REPEAT(434),
  [1034] = {.entry = {.count = 1, .reusable = false}}, SHIFT(186),
  [1036] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [1038] = {.entry = {.count = 1, .reusable = false}}, SHIFT(364),
  [1040] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2),
  [1042] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2), SHIFT_REPEAT(125),
  [1045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [1047] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_single_quote_string_repeat1, 2),
  [1049] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_single_quote_string_repeat1, 2), SHIFT_REPEAT(364),
  [1052] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_single_quote_string_repeat1, 2), SHIFT_REPEAT(364),
  [1055] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [1057] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1061] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [1067] = {.entry = {.count = 1, .reusable = false}}, SHIFT(161),
  [1069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [1071] = {.entry = {.count = 1, .reusable = false}}, SHIFT(377),
  [1073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [1075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [1085] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_brace_concatenation, 2),
  [1087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [1089] = {.entry = {.count = 1, .reusable = false}}, SHIFT(324),
  [1091] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [1093] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [1095] = {.entry = {.count = 1, .reusable = false}}, SHIFT(376),
  [1097] = {.entry = {.count = 1, .reusable = false}}, SHIFT(329),
  [1099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [1101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(382),
  [1103] = {.entry = {.count = 1, .reusable = false}}, SHIFT(328),
  [1105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [1107] = {.entry = {.count = 1, .reusable = false}}, SHIFT(371),
  [1109] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [1113] = {.entry = {.count = 1, .reusable = false}}, SHIFT(361),
  [1115] = {.entry = {.count = 1, .reusable = false}}, SHIFT(117),
  [1117] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [1119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__brace_expression, 1),
  [1121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [1123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [1127] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_brace_concatenation_repeat1, 2),
  [1129] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_brace_concatenation_repeat1, 2), SHIFT_REPEAT(170),
  [1132] = {.entry = {.count = 1, .reusable = false}}, SHIFT(397),
  [1134] = {.entry = {.count = 1, .reusable = false}}, SHIFT(339),
  [1136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [1138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [1142] = {.entry = {.count = 1, .reusable = false}}, SHIFT(404),
  [1144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [1146] = {.entry = {.count = 1, .reusable = false}}, SHIFT(381),
  [1148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [1150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [1152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [1154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [1156] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_brace_expansion_repeat1, 2), SHIFT_REPEAT(151),
  [1159] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_brace_expansion_repeat1, 2),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [1167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [1177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [1181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [1183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [1185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [1191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [1195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [1203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [1205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1215] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token__concat = 0,
  ts_external_token__brace_concat = 1,
  ts_external_token__concat_list = 2,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__concat] = sym__concat,
  [ts_external_token__brace_concat] = sym__brace_concat,
  [ts_external_token__concat_list] = sym__concat_list,
};

static const bool ts_external_scanner_states[7][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__concat] = true,
    [ts_external_token__brace_concat] = true,
    [ts_external_token__concat_list] = true,
  },
  [2] = {
    [ts_external_token__concat] = true,
    [ts_external_token__concat_list] = true,
  },
  [3] = {
    [ts_external_token__concat] = true,
  },
  [4] = {
    [ts_external_token__concat_list] = true,
  },
  [5] = {
    [ts_external_token__brace_concat] = true,
    [ts_external_token__concat_list] = true,
  },
  [6] = {
    [ts_external_token__brace_concat] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_fish_external_scanner_create(void);
void tree_sitter_fish_external_scanner_destroy(void *);
bool tree_sitter_fish_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_fish_external_scanner_serialize(void *, char *);
void tree_sitter_fish_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_fish() {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_word,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_fish_external_scanner_create,
      tree_sitter_fish_external_scanner_destroy,
      tree_sitter_fish_external_scanner_scan,
      tree_sitter_fish_external_scanner_serialize,
      tree_sitter_fish_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
