#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 383
#define LARGE_STATE_COUNT 10
#define SYMBOL_COUNT 103
#define ALIAS_COUNT 0
#define TOKEN_COUNT 64
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 5
#define MAX_ALIAS_SEQUENCE_LENGTH 5
#define PRODUCTION_ID_COUNT 9

enum ts_symbol_identifiers {
  sym_symbol = 1,
  anon_sym_mainmenu = 2,
  anon_sym_config = 3,
  anon_sym_configdefault = 4,
  anon_sym_menuconfig = 5,
  anon_sym_choice = 6,
  anon_sym_endchoice = 7,
  anon_sym_comment = 8,
  anon_sym_menu = 9,
  anon_sym_endmenu = 10,
  anon_sym_if = 11,
  anon_sym_endif = 12,
  anon_sym_source = 13,
  anon_sym_rsource = 14,
  anon_sym_osource = 15,
  anon_sym_orsource = 16,
  anon_sym_EQ = 17,
  anon_sym_COLON_EQ = 18,
  anon_sym_PLUS_EQ = 19,
  anon_sym_QMARK_EQ = 20,
  anon_sym_COMMA = 21,
  aux_sym_variable_token1 = 22,
  anon_sym_bool = 23,
  anon_sym_tristate = 24,
  anon_sym_int = 25,
  anon_sym_hex = 26,
  anon_sym_string = 27,
  aux_sym_type_definition_token1 = 28,
  anon_sym_prompt = 29,
  anon_sym_default = 30,
  anon_sym_def_bool = 31,
  anon_sym_def_tristate = 32,
  anon_sym_def_int = 33,
  anon_sym_def_hex = 34,
  anon_sym_def_string = 35,
  anon_sym_dependson = 36,
  anon_sym_select = 37,
  anon_sym_imply = 38,
  anon_sym_visibleif = 39,
  anon_sym_range = 40,
  anon_sym_help = 41,
  sym_optional = 42,
  sym_modules = 43,
  anon_sym_BANG = 44,
  anon_sym_PIPE_PIPE = 45,
  anon_sym_AMP_AMP = 46,
  anon_sym_BANG_EQ = 47,
  anon_sym_LT = 48,
  anon_sym_GT = 49,
  anon_sym_LT_EQ = 50,
  anon_sym_GT_EQ = 51,
  anon_sym_LPAREN = 52,
  anon_sym_RPAREN = 53,
  anon_sym_DOLLAR_LPAREN = 54,
  sym_macro_content = 55,
  anon_sym_DQUOTE = 56,
  aux_sym_string_token1 = 57,
  aux_sym_string_token2 = 58,
  anon_sym_SQUOTE = 59,
  aux_sym_string_token3 = 60,
  sym_text = 61,
  sym_comment = 62,
  sym__help_text = 63,
  sym_configuration = 64,
  sym__entry = 65,
  sym_mainmenu = 66,
  sym_config = 67,
  sym_configdefault = 68,
  sym_menuconfig = 69,
  sym_choice = 70,
  sym_comment_entry = 71,
  sym_menu = 72,
  sym_if = 73,
  sym_source = 74,
  sym_variable = 75,
  sym__config_option = 76,
  sym_type_definition = 77,
  sym_input_prompt = 78,
  sym_default_value = 79,
  sym_type_definition_default = 80,
  sym_dependencies = 81,
  sym_reverse_dependencies = 82,
  sym_weak_reverse_dependencies = 83,
  sym_limiting_menu_display = 84,
  sym_numerical_ranges = 85,
  sym_help_text = 86,
  sym_conditional_clause = 87,
  sym_expression = 88,
  sym_unary_expression = 89,
  sym_binary_expression = 90,
  sym_parenthesized_expression = 91,
  sym_macro_variable = 92,
  sym_string = 93,
  sym_name = 94,
  aux_sym_configuration_repeat1 = 95,
  aux_sym_config_repeat1 = 96,
  aux_sym_configdefault_repeat1 = 97,
  aux_sym_variable_repeat1 = 98,
  aux_sym_macro_variable_repeat1 = 99,
  aux_sym_string_repeat1 = 100,
  aux_sym_string_repeat2 = 101,
  aux_sym_name_repeat1 = 102,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_symbol] = "symbol",
  [anon_sym_mainmenu] = "mainmenu",
  [anon_sym_config] = "config",
  [anon_sym_configdefault] = "configdefault",
  [anon_sym_menuconfig] = "menuconfig",
  [anon_sym_choice] = "choice",
  [anon_sym_endchoice] = "endchoice",
  [anon_sym_comment] = "comment",
  [anon_sym_menu] = "menu",
  [anon_sym_endmenu] = "endmenu",
  [anon_sym_if] = "if",
  [anon_sym_endif] = "endif",
  [anon_sym_source] = "source",
  [anon_sym_rsource] = "rsource",
  [anon_sym_osource] = "osource",
  [anon_sym_orsource] = "orsource",
  [anon_sym_EQ] = "=",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_QMARK_EQ] = "\?=",
  [anon_sym_COMMA] = ",",
  [aux_sym_variable_token1] = "variable_token1",
  [anon_sym_bool] = "bool",
  [anon_sym_tristate] = "tristate",
  [anon_sym_int] = "int",
  [anon_sym_hex] = "hex",
  [anon_sym_string] = "string",
  [aux_sym_type_definition_token1] = "type_definition_token1",
  [anon_sym_prompt] = "prompt",
  [anon_sym_default] = "default",
  [anon_sym_def_bool] = "def_bool",
  [anon_sym_def_tristate] = "def_tristate",
  [anon_sym_def_int] = "def_int",
  [anon_sym_def_hex] = "def_hex",
  [anon_sym_def_string] = "def_string",
  [anon_sym_dependson] = "depends on",
  [anon_sym_select] = "select",
  [anon_sym_imply] = "imply",
  [anon_sym_visibleif] = "visible if",
  [anon_sym_range] = "range",
  [anon_sym_help] = "help",
  [sym_optional] = "optional",
  [sym_modules] = "modules",
  [anon_sym_BANG] = "!",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DOLLAR_LPAREN] = "$(",
  [sym_macro_content] = "macro_content",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_content",
  [aux_sym_string_token2] = "string_token2",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token3] = "string_content",
  [sym_text] = "text",
  [sym_comment] = "comment",
  [sym__help_text] = "text",
  [sym_configuration] = "configuration",
  [sym__entry] = "_entry",
  [sym_mainmenu] = "mainmenu",
  [sym_config] = "config",
  [sym_configdefault] = "configdefault",
  [sym_menuconfig] = "menuconfig",
  [sym_choice] = "choice",
  [sym_comment_entry] = "comment_entry",
  [sym_menu] = "menu",
  [sym_if] = "if",
  [sym_source] = "source",
  [sym_variable] = "variable",
  [sym__config_option] = "_config_option",
  [sym_type_definition] = "type_definition",
  [sym_input_prompt] = "input_prompt",
  [sym_default_value] = "default_value",
  [sym_type_definition_default] = "type_definition_default",
  [sym_dependencies] = "dependencies",
  [sym_reverse_dependencies] = "reverse_dependencies",
  [sym_weak_reverse_dependencies] = "weak_reverse_dependencies",
  [sym_limiting_menu_display] = "limiting_menu_display",
  [sym_numerical_ranges] = "numerical_ranges",
  [sym_help_text] = "help_text",
  [sym_conditional_clause] = "conditional_clause",
  [sym_expression] = "expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_macro_variable] = "macro_variable",
  [sym_string] = "string",
  [sym_name] = "name",
  [aux_sym_configuration_repeat1] = "configuration_repeat1",
  [aux_sym_config_repeat1] = "config_repeat1",
  [aux_sym_configdefault_repeat1] = "configdefault_repeat1",
  [aux_sym_variable_repeat1] = "variable_repeat1",
  [aux_sym_macro_variable_repeat1] = "macro_variable_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_name_repeat1] = "name_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_symbol] = sym_symbol,
  [anon_sym_mainmenu] = anon_sym_mainmenu,
  [anon_sym_config] = anon_sym_config,
  [anon_sym_configdefault] = anon_sym_configdefault,
  [anon_sym_menuconfig] = anon_sym_menuconfig,
  [anon_sym_choice] = anon_sym_choice,
  [anon_sym_endchoice] = anon_sym_endchoice,
  [anon_sym_comment] = anon_sym_comment,
  [anon_sym_menu] = anon_sym_menu,
  [anon_sym_endmenu] = anon_sym_endmenu,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_endif] = anon_sym_endif,
  [anon_sym_source] = anon_sym_source,
  [anon_sym_rsource] = anon_sym_rsource,
  [anon_sym_osource] = anon_sym_osource,
  [anon_sym_orsource] = anon_sym_orsource,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_QMARK_EQ] = anon_sym_QMARK_EQ,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [aux_sym_variable_token1] = aux_sym_variable_token1,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_tristate] = anon_sym_tristate,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_hex] = anon_sym_hex,
  [anon_sym_string] = anon_sym_string,
  [aux_sym_type_definition_token1] = aux_sym_type_definition_token1,
  [anon_sym_prompt] = anon_sym_prompt,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_def_bool] = anon_sym_def_bool,
  [anon_sym_def_tristate] = anon_sym_def_tristate,
  [anon_sym_def_int] = anon_sym_def_int,
  [anon_sym_def_hex] = anon_sym_def_hex,
  [anon_sym_def_string] = anon_sym_def_string,
  [anon_sym_dependson] = anon_sym_dependson,
  [anon_sym_select] = anon_sym_select,
  [anon_sym_imply] = anon_sym_imply,
  [anon_sym_visibleif] = anon_sym_visibleif,
  [anon_sym_range] = anon_sym_range,
  [anon_sym_help] = anon_sym_help,
  [sym_optional] = sym_optional,
  [sym_modules] = sym_modules,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DOLLAR_LPAREN] = anon_sym_DOLLAR_LPAREN,
  [sym_macro_content] = sym_macro_content,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token3] = aux_sym_string_token1,
  [sym_text] = sym_text,
  [sym_comment] = sym_comment,
  [sym__help_text] = sym_text,
  [sym_configuration] = sym_configuration,
  [sym__entry] = sym__entry,
  [sym_mainmenu] = sym_mainmenu,
  [sym_config] = sym_config,
  [sym_configdefault] = sym_configdefault,
  [sym_menuconfig] = sym_menuconfig,
  [sym_choice] = sym_choice,
  [sym_comment_entry] = sym_comment_entry,
  [sym_menu] = sym_menu,
  [sym_if] = sym_if,
  [sym_source] = sym_source,
  [sym_variable] = sym_variable,
  [sym__config_option] = sym__config_option,
  [sym_type_definition] = sym_type_definition,
  [sym_input_prompt] = sym_input_prompt,
  [sym_default_value] = sym_default_value,
  [sym_type_definition_default] = sym_type_definition_default,
  [sym_dependencies] = sym_dependencies,
  [sym_reverse_dependencies] = sym_reverse_dependencies,
  [sym_weak_reverse_dependencies] = sym_weak_reverse_dependencies,
  [sym_limiting_menu_display] = sym_limiting_menu_display,
  [sym_numerical_ranges] = sym_numerical_ranges,
  [sym_help_text] = sym_help_text,
  [sym_conditional_clause] = sym_conditional_clause,
  [sym_expression] = sym_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_macro_variable] = sym_macro_variable,
  [sym_string] = sym_string,
  [sym_name] = sym_name,
  [aux_sym_configuration_repeat1] = aux_sym_configuration_repeat1,
  [aux_sym_config_repeat1] = aux_sym_config_repeat1,
  [aux_sym_configdefault_repeat1] = aux_sym_configdefault_repeat1,
  [aux_sym_variable_repeat1] = aux_sym_variable_repeat1,
  [aux_sym_macro_variable_repeat1] = aux_sym_macro_variable_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_name_repeat1] = aux_sym_name_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_symbol] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_mainmenu] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_config] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_configdefault] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_menuconfig] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_choice] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endchoice] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_comment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_menu] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endmenu] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_source] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rsource] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_osource] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_orsource] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_variable_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tristate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hex] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_definition_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_prompt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def_tristate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def_hex] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dependson] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_select] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_imply] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_visibleif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_range] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_help] = {
    .visible = true,
    .named = false,
  },
  [sym_optional] = {
    .visible = true,
    .named = true,
  },
  [sym_modules] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_macro_content] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token3] = {
    .visible = true,
    .named = true,
  },
  [sym_text] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__help_text] = {
    .visible = true,
    .named = true,
  },
  [sym_configuration] = {
    .visible = true,
    .named = true,
  },
  [sym__entry] = {
    .visible = false,
    .named = true,
  },
  [sym_mainmenu] = {
    .visible = true,
    .named = true,
  },
  [sym_config] = {
    .visible = true,
    .named = true,
  },
  [sym_configdefault] = {
    .visible = true,
    .named = true,
  },
  [sym_menuconfig] = {
    .visible = true,
    .named = true,
  },
  [sym_choice] = {
    .visible = true,
    .named = true,
  },
  [sym_comment_entry] = {
    .visible = true,
    .named = true,
  },
  [sym_menu] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_source] = {
    .visible = true,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym__config_option] = {
    .visible = false,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_input_prompt] = {
    .visible = true,
    .named = true,
  },
  [sym_default_value] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition_default] = {
    .visible = true,
    .named = true,
  },
  [sym_dependencies] = {
    .visible = true,
    .named = true,
  },
  [sym_reverse_dependencies] = {
    .visible = true,
    .named = true,
  },
  [sym_weak_reverse_dependencies] = {
    .visible = true,
    .named = true,
  },
  [sym_limiting_menu_display] = {
    .visible = true,
    .named = true,
  },
  [sym_numerical_ranges] = {
    .visible = true,
    .named = true,
  },
  [sym_help_text] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_configuration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_config_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_configdefault_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_macro_variable_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_name_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_condition = 1,
  field_left = 2,
  field_name = 3,
  field_operator = 4,
  field_right = 5,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_condition] = "condition",
  [field_left] = "left",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_right] = "right",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 3},
  [7] = {.index = 7, .length = 2},
  [8] = {.index = 9, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1},
  [1] =
    {field_condition, 1},
  [2] =
    {field_left, 0},
  [3] =
    {field_right, 0},
  [4] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [7] =
    {field_left, 0},
    {field_right, 2, .inherited = true},
  [9] =
    {field_right, 0, .inherited = true},
    {field_right, 1, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [0] = sym_text,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_string, 2,
    sym_string,
    sym_text,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 2,
  [7] = 3,
  [8] = 4,
  [9] = 5,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 11,
  [17] = 17,
  [18] = 10,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 12,
  [25] = 14,
  [26] = 15,
  [27] = 17,
  [28] = 13,
  [29] = 22,
  [30] = 19,
  [31] = 21,
  [32] = 23,
  [33] = 20,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 38,
  [43] = 41,
  [44] = 37,
  [45] = 34,
  [46] = 40,
  [47] = 35,
  [48] = 36,
  [49] = 39,
  [50] = 50,
  [51] = 50,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 67,
  [70] = 61,
  [71] = 57,
  [72] = 65,
  [73] = 66,
  [74] = 53,
  [75] = 64,
  [76] = 58,
  [77] = 62,
  [78] = 55,
  [79] = 56,
  [80] = 59,
  [81] = 52,
  [82] = 68,
  [83] = 54,
  [84] = 63,
  [85] = 85,
  [86] = 85,
  [87] = 60,
  [88] = 88,
  [89] = 88,
  [90] = 90,
  [91] = 90,
  [92] = 92,
  [93] = 92,
  [94] = 11,
  [95] = 10,
  [96] = 19,
  [97] = 22,
  [98] = 98,
  [99] = 20,
  [100] = 23,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 101,
  [106] = 98,
  [107] = 107,
  [108] = 102,
  [109] = 109,
  [110] = 103,
  [111] = 109,
  [112] = 107,
  [113] = 21,
  [114] = 35,
  [115] = 34,
  [116] = 38,
  [117] = 37,
  [118] = 40,
  [119] = 36,
  [120] = 39,
  [121] = 121,
  [122] = 122,
  [123] = 11,
  [124] = 10,
  [125] = 125,
  [126] = 125,
  [127] = 122,
  [128] = 121,
  [129] = 67,
  [130] = 11,
  [131] = 57,
  [132] = 132,
  [133] = 10,
  [134] = 132,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 19,
  [152] = 22,
  [153] = 37,
  [154] = 34,
  [155] = 38,
  [156] = 35,
  [157] = 21,
  [158] = 40,
  [159] = 36,
  [160] = 39,
  [161] = 23,
  [162] = 20,
  [163] = 57,
  [164] = 67,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 142,
  [171] = 171,
  [172] = 19,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 168,
  [177] = 169,
  [178] = 171,
  [179] = 173,
  [180] = 166,
  [181] = 140,
  [182] = 182,
  [183] = 139,
  [184] = 168,
  [185] = 169,
  [186] = 171,
  [187] = 173,
  [188] = 141,
  [189] = 168,
  [190] = 143,
  [191] = 169,
  [192] = 144,
  [193] = 145,
  [194] = 168,
  [195] = 169,
  [196] = 171,
  [197] = 173,
  [198] = 22,
  [199] = 171,
  [200] = 173,
  [201] = 201,
  [202] = 22,
  [203] = 23,
  [204] = 168,
  [205] = 171,
  [206] = 173,
  [207] = 19,
  [208] = 20,
  [209] = 137,
  [210] = 146,
  [211] = 138,
  [212] = 147,
  [213] = 148,
  [214] = 182,
  [215] = 175,
  [216] = 216,
  [217] = 136,
  [218] = 150,
  [219] = 175,
  [220] = 175,
  [221] = 175,
  [222] = 175,
  [223] = 174,
  [224] = 201,
  [225] = 167,
  [226] = 165,
  [227] = 21,
  [228] = 166,
  [229] = 201,
  [230] = 166,
  [231] = 201,
  [232] = 166,
  [233] = 169,
  [234] = 21,
  [235] = 235,
  [236] = 235,
  [237] = 237,
  [238] = 237,
  [239] = 235,
  [240] = 235,
  [241] = 36,
  [242] = 39,
  [243] = 40,
  [244] = 34,
  [245] = 38,
  [246] = 37,
  [247] = 35,
  [248] = 248,
  [249] = 40,
  [250] = 248,
  [251] = 248,
  [252] = 248,
  [253] = 39,
  [254] = 36,
  [255] = 255,
  [256] = 255,
  [257] = 257,
  [258] = 248,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 259,
  [264] = 262,
  [265] = 260,
  [266] = 266,
  [267] = 267,
  [268] = 259,
  [269] = 269,
  [270] = 262,
  [271] = 259,
  [272] = 262,
  [273] = 259,
  [274] = 262,
  [275] = 259,
  [276] = 262,
  [277] = 259,
  [278] = 262,
  [279] = 259,
  [280] = 262,
  [281] = 281,
  [282] = 266,
  [283] = 267,
  [284] = 269,
  [285] = 281,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 288,
  [291] = 291,
  [292] = 287,
  [293] = 291,
  [294] = 289,
  [295] = 288,
  [296] = 291,
  [297] = 291,
  [298] = 287,
  [299] = 289,
  [300] = 288,
  [301] = 291,
  [302] = 287,
  [303] = 291,
  [304] = 289,
  [305] = 288,
  [306] = 287,
  [307] = 287,
  [308] = 289,
  [309] = 289,
  [310] = 288,
  [311] = 288,
  [312] = 289,
  [313] = 287,
  [314] = 314,
  [315] = 291,
  [316] = 23,
  [317] = 19,
  [318] = 20,
  [319] = 319,
  [320] = 22,
  [321] = 321,
  [322] = 321,
  [323] = 23,
  [324] = 20,
  [325] = 23,
  [326] = 20,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 329,
  [335] = 335,
  [336] = 333,
  [337] = 337,
  [338] = 332,
  [339] = 327,
  [340] = 330,
  [341] = 341,
  [342] = 328,
  [343] = 331,
  [344] = 344,
  [345] = 345,
  [346] = 345,
  [347] = 335,
  [348] = 330,
  [349] = 349,
  [350] = 349,
  [351] = 345,
  [352] = 341,
  [353] = 344,
  [354] = 337,
  [355] = 56,
  [356] = 66,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 359,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 358,
  [367] = 367,
  [368] = 363,
  [369] = 357,
  [370] = 370,
  [371] = 364,
  [372] = 372,
  [373] = 358,
  [374] = 372,
  [375] = 365,
  [376] = 376,
  [377] = 364,
  [378] = 376,
  [379] = 358,
  [380] = 362,
  [381] = 360,
  [382] = 370,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(33);
      ADVANCE_MAP(
        '!', 45,
        '"', 76,
        '#', 117,
        '$', 14,
        '&', 13,
        '\'', 87,
        '(', 54,
        ')', 56,
        '+', 19,
        ',', 38,
        '-', 109,
        ':', 20,
        '<', 50,
        '=', 34,
        '>', 51,
        '?', 21,
      );
      if (lookahead == '\\') SKIP(29);
      if (lookahead == 'd') ADVANCE(99);
      if (lookahead == 'v') ADVANCE(102);
      if (lookahead == '|') ADVANCE(26);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(3);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(3);
      if (lookahead == '\r') SKIP(1);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '\n', 40,
        '\r', 3,
        '!', 45,
        '"', 76,
        '#', 117,
        '$', 14,
        '&', 13,
        '\'', 87,
        '(', 54,
        ',', 38,
        '-', 109,
        '<', 50,
        '=', 34,
        '>', 51,
      );
      if (lookahead == '\\') SKIP(2);
      if (lookahead == '|') ADVANCE(26);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(3);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '\n', 41,
        '\r', 4,
        '!', 46,
        '"', 77,
        '#', 113,
        '$', 112,
        '\'', 88,
        '(', 55,
        ',', 39,
        '-', 110,
        '\\', 111,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      if (lookahead != 0) ADVANCE(113);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(7);
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(7);
      if (lookahead == '\r') SKIP(5);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '\n', 42,
        '!', 18,
        '"', 76,
        '#', 117,
        '$', 14,
        '&', 13,
        '\'', 87,
        '-', 109,
        '<', 50,
        '=', 34,
        '>', 51,
      );
      if (lookahead == '\\') SKIP(6);
      if (lookahead == '|') ADVANCE(26);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(85);
      if (lookahead == '\r') ADVANCE(84);
      if (lookahead != 0) ADVANCE(84);
      END_STATE();
    case 9:
      if (lookahead == '\n') ADVANCE(86);
      if (lookahead == '\r') ADVANCE(84);
      if (lookahead != 0) ADVANCE(84);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(76);
      if (lookahead == '#') ADVANCE(66);
      if (lookahead == '$') ADVANCE(15);
      if (lookahead == '\'') ADVANCE(87);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(56);
      if (lookahead == '\\') ADVANCE(64);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(69);
      if (lookahead != 0) ADVANCE(73);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(76);
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '$') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(80);
      if (lookahead != 0) ADVANCE(82);
      END_STATE();
    case 12:
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(92);
      if (lookahead == '\'') ADVANCE(87);
      if (lookahead == '\\') ADVANCE(9);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(91);
      if (lookahead != 0) ADVANCE(93);
      END_STATE();
    case 13:
      if (lookahead == '&') ADVANCE(48);
      END_STATE();
    case 14:
      if (lookahead == '(') ADVANCE(57);
      END_STATE();
    case 15:
      if (lookahead == '(') ADVANCE(57);
      if (lookahead != 0) ADVANCE(73);
      END_STATE();
    case 16:
      if (lookahead == '(') ADVANCE(17);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 17:
      if (lookahead == ')') ADVANCE(73);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 18:
      if (lookahead == '=') ADVANCE(49);
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(36);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(35);
      END_STATE();
    case 21:
      if (lookahead == '=') ADVANCE(37);
      END_STATE();
    case 22:
      if (lookahead == 'f') ADVANCE(44);
      END_STATE();
    case 23:
      if (lookahead == 'i') ADVANCE(22);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(43);
      END_STATE();
    case 25:
      if (lookahead == 'o') ADVANCE(24);
      END_STATE();
    case 26:
      if (lookahead == '|') ADVANCE(47);
      END_STATE();
    case 27:
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(73);
      END_STATE();
    case 28:
      if (eof) ADVANCE(33);
      if (lookahead == '\n') SKIP(0);
      END_STATE();
    case 29:
      if (eof) ADVANCE(33);
      if (lookahead == '\n') SKIP(0);
      if (lookahead == '\r') SKIP(28);
      END_STATE();
    case 30:
      if (eof) ADVANCE(33);
      if (lookahead == '\n') SKIP(32);
      END_STATE();
    case 31:
      if (eof) ADVANCE(33);
      if (lookahead == '\n') SKIP(32);
      if (lookahead == '\r') SKIP(30);
      END_STATE();
    case 32:
      if (eof) ADVANCE(33);
      ADVANCE_MAP(
        '!', 45,
        '"', 76,
        '#', 117,
        '$', 14,
        '&', 13,
        '\'', 87,
        '(', 54,
        ')', 56,
        '-', 109,
        '<', 50,
        '=', 34,
        '>', 51,
      );
      if (lookahead == '\\') SKIP(31);
      if (lookahead == '|') ADVANCE(26);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_QMARK_EQ);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_COMMA);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(113);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == '\n') ADVANCE(40);
      if (lookahead == '\r') ADVANCE(3);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == '\n') ADVANCE(41);
      if (lookahead == '\r') ADVANCE(4);
      if (lookahead == '\\') ADVANCE(111);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(aux_sym_type_definition_token1);
      if (lookahead == '\n') ADVANCE(42);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_dependson);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_visibleif);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(49);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(113);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(52);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(53);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(113);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      if (lookahead == '$') ADVANCE(83);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(82);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      if (lookahead == '$') ADVANCE(94);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(93);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(113);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_macro_content);
      if (lookahead == '\n') ADVANCE(70);
      if (lookahead == '$') ADVANCE(114);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '\\') ADVANCE(62);
      if (lookahead == '"' ||
          lookahead == '\'') ADVANCE(116);
      if (lookahead != 0) ADVANCE(61);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_macro_content);
      if (lookahead == '\n') ADVANCE(70);
      if (lookahead == '$') ADVANCE(63);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '\\') ADVANCE(62);
      if (lookahead == '"' ||
          lookahead == '\'') ADVANCE(116);
      if (lookahead != 0) ADVANCE(61);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_macro_content);
      if (lookahead == '\n') ADVANCE(70);
      if (lookahead == '$') ADVANCE(63);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '\\') ADVANCE(62);
      if (lookahead != 0) ADVANCE(61);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_macro_content);
      if (lookahead == '\n') ADVANCE(69);
      if (lookahead == '\r') ADVANCE(65);
      if (lookahead == '$') ADVANCE(72);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(73);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_macro_content);
      if (lookahead == '\n') ADVANCE(69);
      if (lookahead == '$') ADVANCE(27);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(73);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_macro_content);
      if (lookahead == '\n') ADVANCE(73);
      if (lookahead == '$') ADVANCE(115);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == '\\') ADVANCE(67);
      if (lookahead == '"' ||
          ('\'' <= lookahead && lookahead <= ')')) ADVANCE(117);
      if (lookahead != 0) ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_macro_content);
      if (lookahead == '\n') ADVANCE(73);
      if (lookahead == '$') ADVANCE(68);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == '\\') ADVANCE(67);
      if (lookahead == '"' ||
          ('\'' <= lookahead && lookahead <= ')')) ADVANCE(117);
      if (lookahead != 0) ADVANCE(66);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_macro_content);
      if (lookahead == '\n') ADVANCE(73);
      if (lookahead == '$') ADVANCE(68);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == '\\') ADVANCE(67);
      if (lookahead != 0) ADVANCE(66);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_macro_content);
      if (lookahead == '#') ADVANCE(66);
      if (lookahead == '$') ADVANCE(15);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == '\\') ADVANCE(64);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(69);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(73);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_macro_content);
      if (lookahead == '$') ADVANCE(16);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(74);
      if (lookahead == '"' ||
          lookahead == '\'') ADVANCE(17);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_macro_content);
      if (lookahead == '$') ADVANCE(72);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(73);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_macro_content);
      if (lookahead == '$') ADVANCE(72);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead != 0) ADVANCE(73);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_macro_content);
      if (lookahead == '$') ADVANCE(27);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(73);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_macro_content);
      if (lookahead == '$') ADVANCE(75);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(74);
      if (lookahead == '"' ||
          lookahead == '\'') ADVANCE(17);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_macro_content);
      if (lookahead == '$') ADVANCE(75);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(74);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(113);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\n') ADVANCE(82);
      if (lookahead == '$') ADVANCE(79);
      if (lookahead == '"' ||
          lookahead == '\\') ADVANCE(117);
      if (lookahead != 0) ADVANCE(78);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\n') ADVANCE(82);
      if (lookahead == '$') ADVANCE(79);
      if (lookahead != 0) ADVANCE(78);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '$') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(80);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead)) ADVANCE(82);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '$') ADVANCE(83);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead != 0) ADVANCE(82);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '$') ADVANCE(83);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(82);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '$') ADVANCE(83);
      if (lookahead != 0) ADVANCE(82);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(aux_sym_string_token2);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '\\') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(80);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '\\') ADVANCE(9);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(91);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(113);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(aux_sym_string_token3);
      if (lookahead == '\n') ADVANCE(93);
      if (lookahead == '$') ADVANCE(90);
      if (lookahead == '\'' ||
          lookahead == '\\') ADVANCE(117);
      if (lookahead != 0) ADVANCE(89);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(aux_sym_string_token3);
      if (lookahead == '\n') ADVANCE(93);
      if (lookahead == '$') ADVANCE(90);
      if (lookahead != 0) ADVANCE(89);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym_string_token3);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(92);
      if (lookahead == '\\') ADVANCE(9);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(91);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(93);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym_string_token3);
      if (lookahead == '$') ADVANCE(94);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead != 0) ADVANCE(93);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_string_token3);
      if (lookahead == '$') ADVANCE(94);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(93);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym_string_token3);
      if (lookahead == '$') ADVANCE(94);
      if (lookahead != 0) ADVANCE(93);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == ' ') ADVANCE(25);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == ' ') ADVANCE(23);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'b') ADVANCE(104);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'd') ADVANCE(107);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'e') ADVANCE(106);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'e') ADVANCE(105);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'e') ADVANCE(96);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'i') ADVANCE(108);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'i') ADVANCE(97);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'l') ADVANCE(101);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'n') ADVANCE(98);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'p') ADVANCE(100);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 's') ADVANCE(95);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 's') ADVANCE(103);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(113);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_text);
      if (lookahead == '\r') ADVANCE(113);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(113);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_text);
      if (lookahead == '(') ADVANCE(60);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(113);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_text);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(113);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(70);
      if (lookahead == '(') ADVANCE(116);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead != 0) ADVANCE(61);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(73);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead != 0) ADVANCE(66);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(17);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead != 0) ADVANCE(116);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(117);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\\') SKIP(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'h') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'm') ADVANCE(8);
      if (lookahead == 'o') ADVANCE(9);
      if (lookahead == 'p') ADVANCE(10);
      if (lookahead == 'r') ADVANCE(11);
      if (lookahead == 's') ADVANCE(12);
      if (lookahead == 't') ADVANCE(13);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(0);
      if (lookahead == '\r') SKIP(14);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(15);
      END_STATE();
    case 3:
      if (lookahead == 'h') ADVANCE(16);
      if (lookahead == 'o') ADVANCE(17);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(18);
      END_STATE();
    case 5:
      if (lookahead == 'n') ADVANCE(19);
      END_STATE();
    case 6:
      if (lookahead == 'e') ADVANCE(20);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(21);
      if (lookahead == 'm') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(23);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(24);
      if (lookahead == 'e') ADVANCE(25);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 9:
      if (lookahead == 'p') ADVANCE(27);
      if (lookahead == 'r') ADVANCE(28);
      if (lookahead == 's') ADVANCE(29);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(30);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(31);
      if (lookahead == 's') ADVANCE(32);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(33);
      if (lookahead == 'o') ADVANCE(34);
      if (lookahead == 't') ADVANCE(35);
      END_STATE();
    case 13:
      if (lookahead == 'r') ADVANCE(36);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(0);
      END_STATE();
    case 15:
      if (lookahead == 'o') ADVANCE(37);
      END_STATE();
    case 16:
      if (lookahead == 'o') ADVANCE(38);
      END_STATE();
    case 17:
      if (lookahead == 'm') ADVANCE(39);
      if (lookahead == 'n') ADVANCE(40);
      END_STATE();
    case 18:
      if (lookahead == 'f') ADVANCE(41);
      END_STATE();
    case 19:
      if (lookahead == 'd') ADVANCE(42);
      END_STATE();
    case 20:
      if (lookahead == 'l') ADVANCE(43);
      if (lookahead == 'x') ADVANCE(44);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 22:
      if (lookahead == 'p') ADVANCE(45);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(46);
      END_STATE();
    case 24:
      if (lookahead == 'i') ADVANCE(47);
      END_STATE();
    case 25:
      if (lookahead == 'n') ADVANCE(48);
      END_STATE();
    case 26:
      if (lookahead == 'd') ADVANCE(49);
      END_STATE();
    case 27:
      if (lookahead == 't') ADVANCE(50);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(51);
      END_STATE();
    case 29:
      if (lookahead == 'o') ADVANCE(52);
      END_STATE();
    case 30:
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 31:
      if (lookahead == 'n') ADVANCE(54);
      END_STATE();
    case 32:
      if (lookahead == 'o') ADVANCE(55);
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(56);
      END_STATE();
    case 34:
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 35:
      if (lookahead == 'r') ADVANCE(58);
      END_STATE();
    case 36:
      if (lookahead == 'i') ADVANCE(59);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(60);
      END_STATE();
    case 38:
      if (lookahead == 'i') ADVANCE(61);
      END_STATE();
    case 39:
      if (lookahead == 'm') ADVANCE(62);
      END_STATE();
    case 40:
      if (lookahead == 'f') ADVANCE(63);
      END_STATE();
    case 41:
      if (lookahead == '_') ADVANCE(64);
      if (lookahead == 'a') ADVANCE(65);
      END_STATE();
    case 42:
      if (lookahead == 'c') ADVANCE(66);
      if (lookahead == 'i') ADVANCE(67);
      if (lookahead == 'm') ADVANCE(68);
      END_STATE();
    case 43:
      if (lookahead == 'p') ADVANCE(69);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_hex);
      END_STATE();
    case 45:
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 47:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 48:
      if (lookahead == 'u') ADVANCE(72);
      END_STATE();
    case 49:
      if (lookahead == 'u') ADVANCE(73);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(74);
      END_STATE();
    case 51:
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 52:
      if (lookahead == 'u') ADVANCE(76);
      END_STATE();
    case 53:
      if (lookahead == 'm') ADVANCE(77);
      END_STATE();
    case 54:
      if (lookahead == 'g') ADVANCE(78);
      END_STATE();
    case 55:
      if (lookahead == 'u') ADVANCE(79);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 57:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(82);
      END_STATE();
    case 59:
      if (lookahead == 's') ADVANCE(83);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 61:
      if (lookahead == 'c') ADVANCE(84);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(85);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(86);
      END_STATE();
    case 64:
      if (lookahead == 'b') ADVANCE(87);
      if (lookahead == 'h') ADVANCE(88);
      if (lookahead == 'i') ADVANCE(89);
      if (lookahead == 's') ADVANCE(90);
      if (lookahead == 't') ADVANCE(91);
      END_STATE();
    case 65:
      if (lookahead == 'u') ADVANCE(92);
      END_STATE();
    case 66:
      if (lookahead == 'h') ADVANCE(93);
      END_STATE();
    case 67:
      if (lookahead == 'f') ADVANCE(94);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_help);
      END_STATE();
    case 70:
      if (lookahead == 'y') ADVANCE(96);
      END_STATE();
    case 71:
      if (lookahead == 'm') ADVANCE(97);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_menu);
      if (lookahead == 'c') ADVANCE(98);
      END_STATE();
    case 73:
      if (lookahead == 'l') ADVANCE(99);
      END_STATE();
    case 74:
      if (lookahead == 'o') ADVANCE(100);
      END_STATE();
    case 75:
      if (lookahead == 'u') ADVANCE(101);
      END_STATE();
    case 76:
      if (lookahead == 'r') ADVANCE(102);
      END_STATE();
    case 77:
      if (lookahead == 'p') ADVANCE(103);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(104);
      END_STATE();
    case 79:
      if (lookahead == 'r') ADVANCE(105);
      END_STATE();
    case 80:
      if (lookahead == 'c') ADVANCE(106);
      END_STATE();
    case 81:
      if (lookahead == 'c') ADVANCE(107);
      END_STATE();
    case 82:
      if (lookahead == 'n') ADVANCE(108);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(109);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(110);
      END_STATE();
    case 85:
      if (lookahead == 'n') ADVANCE(111);
      END_STATE();
    case 86:
      if (lookahead == 'g') ADVANCE(112);
      END_STATE();
    case 87:
      if (lookahead == 'o') ADVANCE(113);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(114);
      END_STATE();
    case 89:
      if (lookahead == 'n') ADVANCE(115);
      END_STATE();
    case 90:
      if (lookahead == 't') ADVANCE(116);
      END_STATE();
    case 91:
      if (lookahead == 'r') ADVANCE(117);
      END_STATE();
    case 92:
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 93:
      if (lookahead == 'o') ADVANCE(119);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_endif);
      END_STATE();
    case 95:
      if (lookahead == 'n') ADVANCE(120);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_imply);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 98:
      if (lookahead == 'o') ADVANCE(122);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(123);
      END_STATE();
    case 100:
      if (lookahead == 'n') ADVANCE(124);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(125);
      END_STATE();
    case 102:
      if (lookahead == 'c') ADVANCE(126);
      END_STATE();
    case 103:
      if (lookahead == 't') ADVANCE(127);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_range);
      END_STATE();
    case 105:
      if (lookahead == 'c') ADVANCE(128);
      END_STATE();
    case 106:
      if (lookahead == 't') ADVANCE(129);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 108:
      if (lookahead == 'g') ADVANCE(131);
      END_STATE();
    case 109:
      if (lookahead == 'a') ADVANCE(132);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_choice);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(133);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_config);
      if (lookahead == 'd') ADVANCE(134);
      END_STATE();
    case 113:
      if (lookahead == 'o') ADVANCE(135);
      END_STATE();
    case 114:
      if (lookahead == 'x') ADVANCE(136);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(137);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(138);
      END_STATE();
    case 117:
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 118:
      if (lookahead == 't') ADVANCE(140);
      END_STATE();
    case 119:
      if (lookahead == 'i') ADVANCE(141);
      END_STATE();
    case 120:
      if (lookahead == 'u') ADVANCE(142);
      END_STATE();
    case 121:
      if (lookahead == 'n') ADVANCE(143);
      END_STATE();
    case 122:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 123:
      if (lookahead == 's') ADVANCE(145);
      END_STATE();
    case 124:
      if (lookahead == 'a') ADVANCE(146);
      END_STATE();
    case 125:
      if (lookahead == 'c') ADVANCE(147);
      END_STATE();
    case 126:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_prompt);
      END_STATE();
    case 128:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_select);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_source);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 132:
      if (lookahead == 't') ADVANCE(150);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_comment);
      END_STATE();
    case 134:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 135:
      if (lookahead == 'l') ADVANCE(152);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_def_hex);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_def_int);
      END_STATE();
    case 138:
      if (lookahead == 'i') ADVANCE(153);
      END_STATE();
    case 139:
      if (lookahead == 's') ADVANCE(154);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 141:
      if (lookahead == 'c') ADVANCE(155);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_endmenu);
      END_STATE();
    case 143:
      if (lookahead == 'u') ADVANCE(156);
      END_STATE();
    case 144:
      if (lookahead == 'f') ADVANCE(157);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_modules);
      END_STATE();
    case 146:
      if (lookahead == 'l') ADVANCE(158);
      END_STATE();
    case 147:
      if (lookahead == 'e') ADVANCE(159);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_osource);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_rsource);
      END_STATE();
    case 150:
      if (lookahead == 'e') ADVANCE(160);
      END_STATE();
    case 151:
      if (lookahead == 'f') ADVANCE(161);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_def_bool);
      END_STATE();
    case 153:
      if (lookahead == 'n') ADVANCE(162);
      END_STATE();
    case 154:
      if (lookahead == 't') ADVANCE(163);
      END_STATE();
    case 155:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_mainmenu);
      END_STATE();
    case 157:
      if (lookahead == 'i') ADVANCE(165);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_optional);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_orsource);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_tristate);
      END_STATE();
    case 161:
      if (lookahead == 'a') ADVANCE(166);
      END_STATE();
    case 162:
      if (lookahead == 'g') ADVANCE(167);
      END_STATE();
    case 163:
      if (lookahead == 'a') ADVANCE(168);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_endchoice);
      END_STATE();
    case 165:
      if (lookahead == 'g') ADVANCE(169);
      END_STATE();
    case 166:
      if (lookahead == 'u') ADVANCE(170);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_def_string);
      END_STATE();
    case 168:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_menuconfig);
      END_STATE();
    case 170:
      if (lookahead == 'l') ADVANCE(172);
      END_STATE();
    case 171:
      if (lookahead == 'e') ADVANCE(173);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(174);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_def_tristate);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_configdefault);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 32},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 0},
  [7] = {.lex_state = 0},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 0},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 0},
  [17] = {.lex_state = 0},
  [18] = {.lex_state = 0},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 0},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 0},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 0},
  [37] = {.lex_state = 0},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 0},
  [46] = {.lex_state = 0},
  [47] = {.lex_state = 0},
  [48] = {.lex_state = 0},
  [49] = {.lex_state = 0},
  [50] = {.lex_state = 0},
  [51] = {.lex_state = 0},
  [52] = {.lex_state = 0},
  [53] = {.lex_state = 0},
  [54] = {.lex_state = 0},
  [55] = {.lex_state = 0},
  [56] = {.lex_state = 0},
  [57] = {.lex_state = 0},
  [58] = {.lex_state = 0},
  [59] = {.lex_state = 0},
  [60] = {.lex_state = 0},
  [61] = {.lex_state = 0},
  [62] = {.lex_state = 0},
  [63] = {.lex_state = 0},
  [64] = {.lex_state = 0},
  [65] = {.lex_state = 0},
  [66] = {.lex_state = 0},
  [67] = {.lex_state = 0},
  [68] = {.lex_state = 0},
  [69] = {.lex_state = 0},
  [70] = {.lex_state = 0},
  [71] = {.lex_state = 0},
  [72] = {.lex_state = 0},
  [73] = {.lex_state = 0},
  [74] = {.lex_state = 0},
  [75] = {.lex_state = 0},
  [76] = {.lex_state = 0},
  [77] = {.lex_state = 0},
  [78] = {.lex_state = 0},
  [79] = {.lex_state = 0},
  [80] = {.lex_state = 0},
  [81] = {.lex_state = 0},
  [82] = {.lex_state = 0},
  [83] = {.lex_state = 0},
  [84] = {.lex_state = 0},
  [85] = {.lex_state = 32},
  [86] = {.lex_state = 32},
  [87] = {.lex_state = 0},
  [88] = {.lex_state = 0},
  [89] = {.lex_state = 0},
  [90] = {.lex_state = 0},
  [91] = {.lex_state = 0},
  [92] = {.lex_state = 0},
  [93] = {.lex_state = 0},
  [94] = {.lex_state = 32},
  [95] = {.lex_state = 32},
  [96] = {.lex_state = 32},
  [97] = {.lex_state = 32},
  [98] = {.lex_state = 32},
  [99] = {.lex_state = 32},
  [100] = {.lex_state = 32},
  [101] = {.lex_state = 32},
  [102] = {.lex_state = 32},
  [103] = {.lex_state = 32},
  [104] = {.lex_state = 32},
  [105] = {.lex_state = 32},
  [106] = {.lex_state = 32},
  [107] = {.lex_state = 32},
  [108] = {.lex_state = 32},
  [109] = {.lex_state = 32},
  [110] = {.lex_state = 32},
  [111] = {.lex_state = 32},
  [112] = {.lex_state = 32},
  [113] = {.lex_state = 32},
  [114] = {.lex_state = 32},
  [115] = {.lex_state = 32},
  [116] = {.lex_state = 32},
  [117] = {.lex_state = 32},
  [118] = {.lex_state = 32},
  [119] = {.lex_state = 32},
  [120] = {.lex_state = 32},
  [121] = {.lex_state = 32},
  [122] = {.lex_state = 32},
  [123] = {.lex_state = 3},
  [124] = {.lex_state = 3},
  [125] = {.lex_state = 4},
  [126] = {.lex_state = 4},
  [127] = {.lex_state = 32},
  [128] = {.lex_state = 32},
  [129] = {.lex_state = 32},
  [130] = {.lex_state = 7},
  [131] = {.lex_state = 32},
  [132] = {.lex_state = 3},
  [133] = {.lex_state = 7},
  [134] = {.lex_state = 3},
  [135] = {.lex_state = 3},
  [136] = {.lex_state = 32},
  [137] = {.lex_state = 32},
  [138] = {.lex_state = 32},
  [139] = {.lex_state = 32},
  [140] = {.lex_state = 32},
  [141] = {.lex_state = 32},
  [142] = {.lex_state = 32},
  [143] = {.lex_state = 32},
  [144] = {.lex_state = 32},
  [145] = {.lex_state = 32},
  [146] = {.lex_state = 32},
  [147] = {.lex_state = 32},
  [148] = {.lex_state = 32},
  [149] = {.lex_state = 3},
  [150] = {.lex_state = 32},
  [151] = {.lex_state = 3},
  [152] = {.lex_state = 3},
  [153] = {.lex_state = 3},
  [154] = {.lex_state = 3},
  [155] = {.lex_state = 3},
  [156] = {.lex_state = 3},
  [157] = {.lex_state = 3},
  [158] = {.lex_state = 3},
  [159] = {.lex_state = 3},
  [160] = {.lex_state = 3},
  [161] = {.lex_state = 3},
  [162] = {.lex_state = 3},
  [163] = {.lex_state = 32},
  [164] = {.lex_state = 32},
  [165] = {.lex_state = 32},
  [166] = {.lex_state = 32},
  [167] = {.lex_state = 32},
  [168] = {.lex_state = 32},
  [169] = {.lex_state = 32},
  [170] = {.lex_state = 32},
  [171] = {.lex_state = 32},
  [172] = {.lex_state = 32},
  [173] = {.lex_state = 32},
  [174] = {.lex_state = 32},
  [175] = {.lex_state = 32},
  [176] = {.lex_state = 32},
  [177] = {.lex_state = 32},
  [178] = {.lex_state = 32},
  [179] = {.lex_state = 32},
  [180] = {.lex_state = 32},
  [181] = {.lex_state = 32},
  [182] = {.lex_state = 32},
  [183] = {.lex_state = 32},
  [184] = {.lex_state = 32},
  [185] = {.lex_state = 32},
  [186] = {.lex_state = 32},
  [187] = {.lex_state = 32},
  [188] = {.lex_state = 32},
  [189] = {.lex_state = 32},
  [190] = {.lex_state = 32},
  [191] = {.lex_state = 32},
  [192] = {.lex_state = 32},
  [193] = {.lex_state = 32},
  [194] = {.lex_state = 32},
  [195] = {.lex_state = 32},
  [196] = {.lex_state = 32},
  [197] = {.lex_state = 32},
  [198] = {.lex_state = 32},
  [199] = {.lex_state = 32},
  [200] = {.lex_state = 32},
  [201] = {.lex_state = 32},
  [202] = {.lex_state = 7},
  [203] = {.lex_state = 7},
  [204] = {.lex_state = 32},
  [205] = {.lex_state = 32},
  [206] = {.lex_state = 32},
  [207] = {.lex_state = 7},
  [208] = {.lex_state = 7},
  [209] = {.lex_state = 32},
  [210] = {.lex_state = 32},
  [211] = {.lex_state = 32},
  [212] = {.lex_state = 32},
  [213] = {.lex_state = 32},
  [214] = {.lex_state = 32},
  [215] = {.lex_state = 32},
  [216] = {.lex_state = 32},
  [217] = {.lex_state = 32},
  [218] = {.lex_state = 32},
  [219] = {.lex_state = 32},
  [220] = {.lex_state = 32},
  [221] = {.lex_state = 32},
  [222] = {.lex_state = 32},
  [223] = {.lex_state = 32},
  [224] = {.lex_state = 32},
  [225] = {.lex_state = 32},
  [226] = {.lex_state = 32},
  [227] = {.lex_state = 7},
  [228] = {.lex_state = 32},
  [229] = {.lex_state = 32},
  [230] = {.lex_state = 32},
  [231] = {.lex_state = 32},
  [232] = {.lex_state = 32},
  [233] = {.lex_state = 32},
  [234] = {.lex_state = 32},
  [235] = {.lex_state = 7},
  [236] = {.lex_state = 7},
  [237] = {.lex_state = 7},
  [238] = {.lex_state = 7},
  [239] = {.lex_state = 7},
  [240] = {.lex_state = 7},
  [241] = {.lex_state = 7},
  [242] = {.lex_state = 7},
  [243] = {.lex_state = 7},
  [244] = {.lex_state = 7},
  [245] = {.lex_state = 7},
  [246] = {.lex_state = 7},
  [247] = {.lex_state = 7},
  [248] = {.lex_state = 0},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 0},
  [251] = {.lex_state = 0},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 7},
  [256] = {.lex_state = 7},
  [257] = {.lex_state = 7},
  [258] = {.lex_state = 0},
  [259] = {.lex_state = 10},
  [260] = {.lex_state = 7},
  [261] = {.lex_state = 10},
  [262] = {.lex_state = 10},
  [263] = {.lex_state = 10},
  [264] = {.lex_state = 10},
  [265] = {.lex_state = 7},
  [266] = {.lex_state = 32},
  [267] = {.lex_state = 32},
  [268] = {.lex_state = 10},
  [269] = {.lex_state = 32},
  [270] = {.lex_state = 10},
  [271] = {.lex_state = 10},
  [272] = {.lex_state = 10},
  [273] = {.lex_state = 10},
  [274] = {.lex_state = 10},
  [275] = {.lex_state = 10},
  [276] = {.lex_state = 10},
  [277] = {.lex_state = 10},
  [278] = {.lex_state = 10},
  [279] = {.lex_state = 10},
  [280] = {.lex_state = 10},
  [281] = {.lex_state = 32},
  [282] = {.lex_state = 32},
  [283] = {.lex_state = 32},
  [284] = {.lex_state = 32},
  [285] = {.lex_state = 32},
  [286] = {.lex_state = 11},
  [287] = {.lex_state = 12},
  [288] = {.lex_state = 12},
  [289] = {.lex_state = 11},
  [290] = {.lex_state = 12},
  [291] = {.lex_state = 11},
  [292] = {.lex_state = 12},
  [293] = {.lex_state = 11},
  [294] = {.lex_state = 11},
  [295] = {.lex_state = 12},
  [296] = {.lex_state = 11},
  [297] = {.lex_state = 11},
  [298] = {.lex_state = 12},
  [299] = {.lex_state = 11},
  [300] = {.lex_state = 12},
  [301] = {.lex_state = 11},
  [302] = {.lex_state = 12},
  [303] = {.lex_state = 11},
  [304] = {.lex_state = 11},
  [305] = {.lex_state = 12},
  [306] = {.lex_state = 12},
  [307] = {.lex_state = 12},
  [308] = {.lex_state = 11},
  [309] = {.lex_state = 11},
  [310] = {.lex_state = 12},
  [311] = {.lex_state = 12},
  [312] = {.lex_state = 11},
  [313] = {.lex_state = 12},
  [314] = {.lex_state = 12},
  [315] = {.lex_state = 11},
  [316] = {.lex_state = 10},
  [317] = {.lex_state = 10},
  [318] = {.lex_state = 10},
  [319] = {.lex_state = 10},
  [320] = {.lex_state = 10},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 11},
  [324] = {.lex_state = 12},
  [325] = {.lex_state = 12},
  [326] = {.lex_state = 11},
  [327] = {.lex_state = 7},
  [328] = {.lex_state = 32},
  [329] = {.lex_state = 7},
  [330] = {.lex_state = 7},
  [331] = {.lex_state = 32},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 7},
  [335] = {.lex_state = 7},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 7},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 7},
  [340] = {.lex_state = 7},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 32},
  [343] = {.lex_state = 32},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 7},
  [348] = {.lex_state = 7},
  [349] = {.lex_state = 32},
  [350] = {.lex_state = 32},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 7},
  [355] = {.lex_state = 7},
  [356] = {.lex_state = 7},
  [357] = {.lex_state = 7},
  [358] = {.lex_state = 7},
  [359] = {.lex_state = 7},
  [360] = {.lex_state = 0, .external_lex_state = 1},
  [361] = {.lex_state = 7},
  [362] = {.lex_state = 7},
  [363] = {.lex_state = 3},
  [364] = {.lex_state = 7},
  [365] = {.lex_state = 7},
  [366] = {.lex_state = 7},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 3},
  [369] = {.lex_state = 7},
  [370] = {.lex_state = 7},
  [371] = {.lex_state = 7},
  [372] = {.lex_state = 32},
  [373] = {.lex_state = 7},
  [374] = {.lex_state = 32},
  [375] = {.lex_state = 7},
  [376] = {.lex_state = 7},
  [377] = {.lex_state = 7},
  [378] = {.lex_state = 7},
  [379] = {.lex_state = 7},
  [380] = {.lex_state = 7},
  [381] = {.lex_state = 0, .external_lex_state = 1},
  [382] = {.lex_state = 7},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_symbol] = ACTIONS(1),
    [anon_sym_mainmenu] = ACTIONS(1),
    [anon_sym_config] = ACTIONS(1),
    [anon_sym_configdefault] = ACTIONS(1),
    [anon_sym_menuconfig] = ACTIONS(1),
    [anon_sym_choice] = ACTIONS(1),
    [anon_sym_endchoice] = ACTIONS(1),
    [anon_sym_comment] = ACTIONS(1),
    [anon_sym_menu] = ACTIONS(1),
    [anon_sym_endmenu] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_endif] = ACTIONS(1),
    [anon_sym_source] = ACTIONS(1),
    [anon_sym_rsource] = ACTIONS(1),
    [anon_sym_osource] = ACTIONS(1),
    [anon_sym_orsource] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_QMARK_EQ] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_tristate] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_hex] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_prompt] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_def_bool] = ACTIONS(1),
    [anon_sym_def_tristate] = ACTIONS(1),
    [anon_sym_def_int] = ACTIONS(1),
    [anon_sym_def_hex] = ACTIONS(1),
    [anon_sym_def_string] = ACTIONS(1),
    [anon_sym_dependson] = ACTIONS(1),
    [anon_sym_select] = ACTIONS(1),
    [anon_sym_imply] = ACTIONS(1),
    [anon_sym_visibleif] = ACTIONS(1),
    [anon_sym_range] = ACTIONS(1),
    [anon_sym_help] = ACTIONS(1),
    [sym_optional] = ACTIONS(1),
    [sym_modules] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym__help_text] = ACTIONS(1),
  },
  [1] = {
    [sym_configuration] = STATE(367),
    [sym__entry] = STATE(104),
    [sym_mainmenu] = STATE(104),
    [sym_config] = STATE(104),
    [sym_configdefault] = STATE(104),
    [sym_menuconfig] = STATE(104),
    [sym_choice] = STATE(104),
    [sym_comment_entry] = STATE(104),
    [sym_menu] = STATE(104),
    [sym_if] = STATE(104),
    [sym_source] = STATE(104),
    [sym_variable] = STATE(104),
    [aux_sym_configuration_repeat1] = STATE(104),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [anon_sym_mainmenu] = ACTIONS(9),
    [anon_sym_config] = ACTIONS(11),
    [anon_sym_configdefault] = ACTIONS(13),
    [anon_sym_menuconfig] = ACTIONS(15),
    [anon_sym_choice] = ACTIONS(17),
    [anon_sym_comment] = ACTIONS(19),
    [anon_sym_menu] = ACTIONS(21),
    [anon_sym_if] = ACTIONS(23),
    [anon_sym_source] = ACTIONS(25),
    [anon_sym_rsource] = ACTIONS(25),
    [anon_sym_osource] = ACTIONS(25),
    [anon_sym_orsource] = ACTIONS(25),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__entry] = STATE(102),
    [sym_mainmenu] = STATE(102),
    [sym_config] = STATE(102),
    [sym_configdefault] = STATE(102),
    [sym_menuconfig] = STATE(102),
    [sym_choice] = STATE(102),
    [sym_comment_entry] = STATE(102),
    [sym_menu] = STATE(102),
    [sym_if] = STATE(102),
    [sym_source] = STATE(102),
    [sym_variable] = STATE(102),
    [sym__config_option] = STATE(5),
    [sym_type_definition] = STATE(5),
    [sym_input_prompt] = STATE(5),
    [sym_default_value] = STATE(5),
    [sym_type_definition_default] = STATE(5),
    [sym_dependencies] = STATE(5),
    [sym_reverse_dependencies] = STATE(5),
    [sym_weak_reverse_dependencies] = STATE(5),
    [sym_limiting_menu_display] = STATE(5),
    [sym_numerical_ranges] = STATE(5),
    [sym_help_text] = STATE(5),
    [aux_sym_configuration_repeat1] = STATE(102),
    [aux_sym_config_repeat1] = STATE(5),
    [sym_symbol] = ACTIONS(27),
    [anon_sym_mainmenu] = ACTIONS(29),
    [anon_sym_config] = ACTIONS(31),
    [anon_sym_configdefault] = ACTIONS(33),
    [anon_sym_menuconfig] = ACTIONS(35),
    [anon_sym_choice] = ACTIONS(37),
    [anon_sym_comment] = ACTIONS(39),
    [anon_sym_menu] = ACTIONS(41),
    [anon_sym_endmenu] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(45),
    [anon_sym_source] = ACTIONS(47),
    [anon_sym_rsource] = ACTIONS(47),
    [anon_sym_osource] = ACTIONS(47),
    [anon_sym_orsource] = ACTIONS(47),
    [anon_sym_bool] = ACTIONS(49),
    [anon_sym_tristate] = ACTIONS(49),
    [anon_sym_int] = ACTIONS(49),
    [anon_sym_hex] = ACTIONS(49),
    [anon_sym_string] = ACTIONS(49),
    [anon_sym_prompt] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_def_bool] = ACTIONS(55),
    [anon_sym_def_tristate] = ACTIONS(55),
    [anon_sym_def_int] = ACTIONS(55),
    [anon_sym_def_hex] = ACTIONS(55),
    [anon_sym_def_string] = ACTIONS(55),
    [anon_sym_dependson] = ACTIONS(57),
    [anon_sym_select] = ACTIONS(59),
    [anon_sym_imply] = ACTIONS(61),
    [anon_sym_visibleif] = ACTIONS(63),
    [anon_sym_range] = ACTIONS(65),
    [anon_sym_help] = ACTIONS(67),
    [sym_optional] = ACTIONS(69),
    [sym_modules] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__entry] = STATE(112),
    [sym_mainmenu] = STATE(112),
    [sym_config] = STATE(112),
    [sym_configdefault] = STATE(112),
    [sym_menuconfig] = STATE(112),
    [sym_choice] = STATE(112),
    [sym_comment_entry] = STATE(112),
    [sym_menu] = STATE(112),
    [sym_if] = STATE(112),
    [sym_source] = STATE(112),
    [sym_variable] = STATE(112),
    [sym__config_option] = STATE(12),
    [sym_type_definition] = STATE(12),
    [sym_input_prompt] = STATE(12),
    [sym_default_value] = STATE(12),
    [sym_type_definition_default] = STATE(12),
    [sym_dependencies] = STATE(12),
    [sym_reverse_dependencies] = STATE(12),
    [sym_weak_reverse_dependencies] = STATE(12),
    [sym_limiting_menu_display] = STATE(12),
    [sym_numerical_ranges] = STATE(12),
    [sym_help_text] = STATE(12),
    [aux_sym_configuration_repeat1] = STATE(112),
    [aux_sym_config_repeat1] = STATE(12),
    [sym_symbol] = ACTIONS(27),
    [anon_sym_mainmenu] = ACTIONS(29),
    [anon_sym_config] = ACTIONS(31),
    [anon_sym_configdefault] = ACTIONS(33),
    [anon_sym_menuconfig] = ACTIONS(35),
    [anon_sym_choice] = ACTIONS(37),
    [anon_sym_endchoice] = ACTIONS(71),
    [anon_sym_comment] = ACTIONS(39),
    [anon_sym_menu] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(45),
    [anon_sym_source] = ACTIONS(47),
    [anon_sym_rsource] = ACTIONS(47),
    [anon_sym_osource] = ACTIONS(47),
    [anon_sym_orsource] = ACTIONS(47),
    [anon_sym_bool] = ACTIONS(49),
    [anon_sym_tristate] = ACTIONS(49),
    [anon_sym_int] = ACTIONS(49),
    [anon_sym_hex] = ACTIONS(49),
    [anon_sym_string] = ACTIONS(49),
    [anon_sym_prompt] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_def_bool] = ACTIONS(55),
    [anon_sym_def_tristate] = ACTIONS(55),
    [anon_sym_def_int] = ACTIONS(55),
    [anon_sym_def_hex] = ACTIONS(55),
    [anon_sym_def_string] = ACTIONS(55),
    [anon_sym_dependson] = ACTIONS(57),
    [anon_sym_select] = ACTIONS(59),
    [anon_sym_imply] = ACTIONS(61),
    [anon_sym_visibleif] = ACTIONS(63),
    [anon_sym_range] = ACTIONS(65),
    [anon_sym_help] = ACTIONS(67),
    [sym_optional] = ACTIONS(73),
    [sym_modules] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__entry] = STATE(109),
    [sym_mainmenu] = STATE(109),
    [sym_config] = STATE(109),
    [sym_configdefault] = STATE(109),
    [sym_menuconfig] = STATE(109),
    [sym_choice] = STATE(109),
    [sym_comment_entry] = STATE(109),
    [sym_menu] = STATE(109),
    [sym_if] = STATE(109),
    [sym_source] = STATE(109),
    [sym_variable] = STATE(109),
    [sym__config_option] = STATE(12),
    [sym_type_definition] = STATE(12),
    [sym_input_prompt] = STATE(12),
    [sym_default_value] = STATE(12),
    [sym_type_definition_default] = STATE(12),
    [sym_dependencies] = STATE(12),
    [sym_reverse_dependencies] = STATE(12),
    [sym_weak_reverse_dependencies] = STATE(12),
    [sym_limiting_menu_display] = STATE(12),
    [sym_numerical_ranges] = STATE(12),
    [sym_help_text] = STATE(12),
    [aux_sym_configuration_repeat1] = STATE(109),
    [aux_sym_config_repeat1] = STATE(12),
    [sym_symbol] = ACTIONS(27),
    [anon_sym_mainmenu] = ACTIONS(29),
    [anon_sym_config] = ACTIONS(31),
    [anon_sym_configdefault] = ACTIONS(33),
    [anon_sym_menuconfig] = ACTIONS(35),
    [anon_sym_choice] = ACTIONS(37),
    [anon_sym_endchoice] = ACTIONS(75),
    [anon_sym_comment] = ACTIONS(39),
    [anon_sym_menu] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(45),
    [anon_sym_source] = ACTIONS(47),
    [anon_sym_rsource] = ACTIONS(47),
    [anon_sym_osource] = ACTIONS(47),
    [anon_sym_orsource] = ACTIONS(47),
    [anon_sym_bool] = ACTIONS(49),
    [anon_sym_tristate] = ACTIONS(49),
    [anon_sym_int] = ACTIONS(49),
    [anon_sym_hex] = ACTIONS(49),
    [anon_sym_string] = ACTIONS(49),
    [anon_sym_prompt] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_def_bool] = ACTIONS(55),
    [anon_sym_def_tristate] = ACTIONS(55),
    [anon_sym_def_int] = ACTIONS(55),
    [anon_sym_def_hex] = ACTIONS(55),
    [anon_sym_def_string] = ACTIONS(55),
    [anon_sym_dependson] = ACTIONS(57),
    [anon_sym_select] = ACTIONS(59),
    [anon_sym_imply] = ACTIONS(61),
    [anon_sym_visibleif] = ACTIONS(63),
    [anon_sym_range] = ACTIONS(65),
    [anon_sym_help] = ACTIONS(67),
    [sym_optional] = ACTIONS(73),
    [sym_modules] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__entry] = STATE(105),
    [sym_mainmenu] = STATE(105),
    [sym_config] = STATE(105),
    [sym_configdefault] = STATE(105),
    [sym_menuconfig] = STATE(105),
    [sym_choice] = STATE(105),
    [sym_comment_entry] = STATE(105),
    [sym_menu] = STATE(105),
    [sym_if] = STATE(105),
    [sym_source] = STATE(105),
    [sym_variable] = STATE(105),
    [sym__config_option] = STATE(12),
    [sym_type_definition] = STATE(12),
    [sym_input_prompt] = STATE(12),
    [sym_default_value] = STATE(12),
    [sym_type_definition_default] = STATE(12),
    [sym_dependencies] = STATE(12),
    [sym_reverse_dependencies] = STATE(12),
    [sym_weak_reverse_dependencies] = STATE(12),
    [sym_limiting_menu_display] = STATE(12),
    [sym_numerical_ranges] = STATE(12),
    [sym_help_text] = STATE(12),
    [aux_sym_configuration_repeat1] = STATE(105),
    [aux_sym_config_repeat1] = STATE(12),
    [sym_symbol] = ACTIONS(27),
    [anon_sym_mainmenu] = ACTIONS(29),
    [anon_sym_config] = ACTIONS(31),
    [anon_sym_configdefault] = ACTIONS(33),
    [anon_sym_menuconfig] = ACTIONS(35),
    [anon_sym_choice] = ACTIONS(37),
    [anon_sym_comment] = ACTIONS(39),
    [anon_sym_menu] = ACTIONS(41),
    [anon_sym_endmenu] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(45),
    [anon_sym_source] = ACTIONS(47),
    [anon_sym_rsource] = ACTIONS(47),
    [anon_sym_osource] = ACTIONS(47),
    [anon_sym_orsource] = ACTIONS(47),
    [anon_sym_bool] = ACTIONS(49),
    [anon_sym_tristate] = ACTIONS(49),
    [anon_sym_int] = ACTIONS(49),
    [anon_sym_hex] = ACTIONS(49),
    [anon_sym_string] = ACTIONS(49),
    [anon_sym_prompt] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_def_bool] = ACTIONS(55),
    [anon_sym_def_tristate] = ACTIONS(55),
    [anon_sym_def_int] = ACTIONS(55),
    [anon_sym_def_hex] = ACTIONS(55),
    [anon_sym_def_string] = ACTIONS(55),
    [anon_sym_dependson] = ACTIONS(57),
    [anon_sym_select] = ACTIONS(59),
    [anon_sym_imply] = ACTIONS(61),
    [anon_sym_visibleif] = ACTIONS(63),
    [anon_sym_range] = ACTIONS(65),
    [anon_sym_help] = ACTIONS(67),
    [sym_optional] = ACTIONS(73),
    [sym_modules] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__entry] = STATE(108),
    [sym_mainmenu] = STATE(108),
    [sym_config] = STATE(108),
    [sym_configdefault] = STATE(108),
    [sym_menuconfig] = STATE(108),
    [sym_choice] = STATE(108),
    [sym_comment_entry] = STATE(108),
    [sym_menu] = STATE(108),
    [sym_if] = STATE(108),
    [sym_source] = STATE(108),
    [sym_variable] = STATE(108),
    [sym__config_option] = STATE(9),
    [sym_type_definition] = STATE(9),
    [sym_input_prompt] = STATE(9),
    [sym_default_value] = STATE(9),
    [sym_type_definition_default] = STATE(9),
    [sym_dependencies] = STATE(9),
    [sym_reverse_dependencies] = STATE(9),
    [sym_weak_reverse_dependencies] = STATE(9),
    [sym_limiting_menu_display] = STATE(9),
    [sym_numerical_ranges] = STATE(9),
    [sym_help_text] = STATE(9),
    [aux_sym_configuration_repeat1] = STATE(108),
    [aux_sym_config_repeat1] = STATE(9),
    [sym_symbol] = ACTIONS(27),
    [anon_sym_mainmenu] = ACTIONS(29),
    [anon_sym_config] = ACTIONS(31),
    [anon_sym_configdefault] = ACTIONS(33),
    [anon_sym_menuconfig] = ACTIONS(35),
    [anon_sym_choice] = ACTIONS(37),
    [anon_sym_comment] = ACTIONS(39),
    [anon_sym_menu] = ACTIONS(41),
    [anon_sym_endmenu] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(45),
    [anon_sym_source] = ACTIONS(47),
    [anon_sym_rsource] = ACTIONS(47),
    [anon_sym_osource] = ACTIONS(47),
    [anon_sym_orsource] = ACTIONS(47),
    [anon_sym_bool] = ACTIONS(49),
    [anon_sym_tristate] = ACTIONS(49),
    [anon_sym_int] = ACTIONS(49),
    [anon_sym_hex] = ACTIONS(49),
    [anon_sym_string] = ACTIONS(49),
    [anon_sym_prompt] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_def_bool] = ACTIONS(55),
    [anon_sym_def_tristate] = ACTIONS(55),
    [anon_sym_def_int] = ACTIONS(55),
    [anon_sym_def_hex] = ACTIONS(55),
    [anon_sym_def_string] = ACTIONS(55),
    [anon_sym_dependson] = ACTIONS(57),
    [anon_sym_select] = ACTIONS(59),
    [anon_sym_imply] = ACTIONS(61),
    [anon_sym_visibleif] = ACTIONS(63),
    [anon_sym_range] = ACTIONS(65),
    [anon_sym_help] = ACTIONS(67),
    [sym_optional] = ACTIONS(81),
    [sym_modules] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__entry] = STATE(107),
    [sym_mainmenu] = STATE(107),
    [sym_config] = STATE(107),
    [sym_configdefault] = STATE(107),
    [sym_menuconfig] = STATE(107),
    [sym_choice] = STATE(107),
    [sym_comment_entry] = STATE(107),
    [sym_menu] = STATE(107),
    [sym_if] = STATE(107),
    [sym_source] = STATE(107),
    [sym_variable] = STATE(107),
    [sym__config_option] = STATE(12),
    [sym_type_definition] = STATE(12),
    [sym_input_prompt] = STATE(12),
    [sym_default_value] = STATE(12),
    [sym_type_definition_default] = STATE(12),
    [sym_dependencies] = STATE(12),
    [sym_reverse_dependencies] = STATE(12),
    [sym_weak_reverse_dependencies] = STATE(12),
    [sym_limiting_menu_display] = STATE(12),
    [sym_numerical_ranges] = STATE(12),
    [sym_help_text] = STATE(12),
    [aux_sym_configuration_repeat1] = STATE(107),
    [aux_sym_config_repeat1] = STATE(12),
    [sym_symbol] = ACTIONS(27),
    [anon_sym_mainmenu] = ACTIONS(29),
    [anon_sym_config] = ACTIONS(31),
    [anon_sym_configdefault] = ACTIONS(33),
    [anon_sym_menuconfig] = ACTIONS(35),
    [anon_sym_choice] = ACTIONS(37),
    [anon_sym_endchoice] = ACTIONS(83),
    [anon_sym_comment] = ACTIONS(39),
    [anon_sym_menu] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(45),
    [anon_sym_source] = ACTIONS(47),
    [anon_sym_rsource] = ACTIONS(47),
    [anon_sym_osource] = ACTIONS(47),
    [anon_sym_orsource] = ACTIONS(47),
    [anon_sym_bool] = ACTIONS(49),
    [anon_sym_tristate] = ACTIONS(49),
    [anon_sym_int] = ACTIONS(49),
    [anon_sym_hex] = ACTIONS(49),
    [anon_sym_string] = ACTIONS(49),
    [anon_sym_prompt] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_def_bool] = ACTIONS(55),
    [anon_sym_def_tristate] = ACTIONS(55),
    [anon_sym_def_int] = ACTIONS(55),
    [anon_sym_def_hex] = ACTIONS(55),
    [anon_sym_def_string] = ACTIONS(55),
    [anon_sym_dependson] = ACTIONS(57),
    [anon_sym_select] = ACTIONS(59),
    [anon_sym_imply] = ACTIONS(61),
    [anon_sym_visibleif] = ACTIONS(63),
    [anon_sym_range] = ACTIONS(65),
    [anon_sym_help] = ACTIONS(67),
    [sym_optional] = ACTIONS(73),
    [sym_modules] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__entry] = STATE(111),
    [sym_mainmenu] = STATE(111),
    [sym_config] = STATE(111),
    [sym_configdefault] = STATE(111),
    [sym_menuconfig] = STATE(111),
    [sym_choice] = STATE(111),
    [sym_comment_entry] = STATE(111),
    [sym_menu] = STATE(111),
    [sym_if] = STATE(111),
    [sym_source] = STATE(111),
    [sym_variable] = STATE(111),
    [sym__config_option] = STATE(12),
    [sym_type_definition] = STATE(12),
    [sym_input_prompt] = STATE(12),
    [sym_default_value] = STATE(12),
    [sym_type_definition_default] = STATE(12),
    [sym_dependencies] = STATE(12),
    [sym_reverse_dependencies] = STATE(12),
    [sym_weak_reverse_dependencies] = STATE(12),
    [sym_limiting_menu_display] = STATE(12),
    [sym_numerical_ranges] = STATE(12),
    [sym_help_text] = STATE(12),
    [aux_sym_configuration_repeat1] = STATE(111),
    [aux_sym_config_repeat1] = STATE(12),
    [sym_symbol] = ACTIONS(27),
    [anon_sym_mainmenu] = ACTIONS(29),
    [anon_sym_config] = ACTIONS(31),
    [anon_sym_configdefault] = ACTIONS(33),
    [anon_sym_menuconfig] = ACTIONS(35),
    [anon_sym_choice] = ACTIONS(37),
    [anon_sym_endchoice] = ACTIONS(85),
    [anon_sym_comment] = ACTIONS(39),
    [anon_sym_menu] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(45),
    [anon_sym_source] = ACTIONS(47),
    [anon_sym_rsource] = ACTIONS(47),
    [anon_sym_osource] = ACTIONS(47),
    [anon_sym_orsource] = ACTIONS(47),
    [anon_sym_bool] = ACTIONS(49),
    [anon_sym_tristate] = ACTIONS(49),
    [anon_sym_int] = ACTIONS(49),
    [anon_sym_hex] = ACTIONS(49),
    [anon_sym_string] = ACTIONS(49),
    [anon_sym_prompt] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_def_bool] = ACTIONS(55),
    [anon_sym_def_tristate] = ACTIONS(55),
    [anon_sym_def_int] = ACTIONS(55),
    [anon_sym_def_hex] = ACTIONS(55),
    [anon_sym_def_string] = ACTIONS(55),
    [anon_sym_dependson] = ACTIONS(57),
    [anon_sym_select] = ACTIONS(59),
    [anon_sym_imply] = ACTIONS(61),
    [anon_sym_visibleif] = ACTIONS(63),
    [anon_sym_range] = ACTIONS(65),
    [anon_sym_help] = ACTIONS(67),
    [sym_optional] = ACTIONS(73),
    [sym_modules] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__entry] = STATE(101),
    [sym_mainmenu] = STATE(101),
    [sym_config] = STATE(101),
    [sym_configdefault] = STATE(101),
    [sym_menuconfig] = STATE(101),
    [sym_choice] = STATE(101),
    [sym_comment_entry] = STATE(101),
    [sym_menu] = STATE(101),
    [sym_if] = STATE(101),
    [sym_source] = STATE(101),
    [sym_variable] = STATE(101),
    [sym__config_option] = STATE(12),
    [sym_type_definition] = STATE(12),
    [sym_input_prompt] = STATE(12),
    [sym_default_value] = STATE(12),
    [sym_type_definition_default] = STATE(12),
    [sym_dependencies] = STATE(12),
    [sym_reverse_dependencies] = STATE(12),
    [sym_weak_reverse_dependencies] = STATE(12),
    [sym_limiting_menu_display] = STATE(12),
    [sym_numerical_ranges] = STATE(12),
    [sym_help_text] = STATE(12),
    [aux_sym_configuration_repeat1] = STATE(101),
    [aux_sym_config_repeat1] = STATE(12),
    [sym_symbol] = ACTIONS(27),
    [anon_sym_mainmenu] = ACTIONS(29),
    [anon_sym_config] = ACTIONS(31),
    [anon_sym_configdefault] = ACTIONS(33),
    [anon_sym_menuconfig] = ACTIONS(35),
    [anon_sym_choice] = ACTIONS(37),
    [anon_sym_comment] = ACTIONS(39),
    [anon_sym_menu] = ACTIONS(41),
    [anon_sym_endmenu] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(45),
    [anon_sym_source] = ACTIONS(47),
    [anon_sym_rsource] = ACTIONS(47),
    [anon_sym_osource] = ACTIONS(47),
    [anon_sym_orsource] = ACTIONS(47),
    [anon_sym_bool] = ACTIONS(49),
    [anon_sym_tristate] = ACTIONS(49),
    [anon_sym_int] = ACTIONS(49),
    [anon_sym_hex] = ACTIONS(49),
    [anon_sym_string] = ACTIONS(49),
    [anon_sym_prompt] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_def_bool] = ACTIONS(55),
    [anon_sym_def_tristate] = ACTIONS(55),
    [anon_sym_def_int] = ACTIONS(55),
    [anon_sym_def_hex] = ACTIONS(55),
    [anon_sym_def_string] = ACTIONS(55),
    [anon_sym_dependson] = ACTIONS(57),
    [anon_sym_select] = ACTIONS(59),
    [anon_sym_imply] = ACTIONS(61),
    [anon_sym_visibleif] = ACTIONS(63),
    [anon_sym_range] = ACTIONS(65),
    [anon_sym_help] = ACTIONS(67),
    [sym_optional] = ACTIONS(73),
    [sym_modules] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      sym_symbol,
    ACTIONS(95), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(97), 1,
      anon_sym_DQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE,
    STATE(11), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
    ACTIONS(93), 8,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(91), 35,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
  [68] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(101), 1,
      sym_symbol,
    ACTIONS(108), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(114), 1,
      anon_sym_SQUOTE,
    STATE(11), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
    ACTIONS(106), 8,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(104), 35,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
  [136] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(122), 1,
      anon_sym_prompt,
    ACTIONS(125), 1,
      anon_sym_default,
    ACTIONS(131), 1,
      anon_sym_dependson,
    ACTIONS(134), 1,
      anon_sym_select,
    ACTIONS(137), 1,
      anon_sym_imply,
    ACTIONS(140), 1,
      anon_sym_visibleif,
    ACTIONS(143), 1,
      anon_sym_range,
    ACTIONS(146), 1,
      anon_sym_help,
    ACTIONS(149), 2,
      sym_optional,
      sym_modules,
    ACTIONS(119), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(128), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(12), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
    ACTIONS(117), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [214] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      anon_sym_prompt,
    ACTIONS(53), 1,
      anon_sym_default,
    ACTIONS(57), 1,
      anon_sym_dependson,
    ACTIONS(59), 1,
      anon_sym_select,
    ACTIONS(61), 1,
      anon_sym_imply,
    ACTIONS(63), 1,
      anon_sym_visibleif,
    ACTIONS(65), 1,
      anon_sym_range,
    ACTIONS(67), 1,
      anon_sym_help,
    ACTIONS(154), 2,
      sym_optional,
      sym_modules,
    ACTIONS(49), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(55), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(17), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
    ACTIONS(152), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [292] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      anon_sym_prompt,
    ACTIONS(53), 1,
      anon_sym_default,
    ACTIONS(57), 1,
      anon_sym_dependson,
    ACTIONS(59), 1,
      anon_sym_select,
    ACTIONS(61), 1,
      anon_sym_imply,
    ACTIONS(63), 1,
      anon_sym_visibleif,
    ACTIONS(65), 1,
      anon_sym_range,
    ACTIONS(67), 1,
      anon_sym_help,
    ACTIONS(73), 2,
      sym_optional,
      sym_modules,
    ACTIONS(49), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(55), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(12), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
    ACTIONS(156), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [370] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      anon_sym_prompt,
    ACTIONS(53), 1,
      anon_sym_default,
    ACTIONS(57), 1,
      anon_sym_dependson,
    ACTIONS(59), 1,
      anon_sym_select,
    ACTIONS(61), 1,
      anon_sym_imply,
    ACTIONS(63), 1,
      anon_sym_visibleif,
    ACTIONS(65), 1,
      anon_sym_range,
    ACTIONS(67), 1,
      anon_sym_help,
    ACTIONS(73), 2,
      sym_optional,
      sym_modules,
    ACTIONS(49), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(55), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(12), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
    ACTIONS(158), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [448] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(166), 1,
      anon_sym_DQUOTE,
    ACTIONS(169), 1,
      anon_sym_SQUOTE,
    STATE(16), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
    ACTIONS(106), 9,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(104), 32,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
  [514] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      anon_sym_prompt,
    ACTIONS(53), 1,
      anon_sym_default,
    ACTIONS(57), 1,
      anon_sym_dependson,
    ACTIONS(59), 1,
      anon_sym_select,
    ACTIONS(61), 1,
      anon_sym_imply,
    ACTIONS(63), 1,
      anon_sym_visibleif,
    ACTIONS(65), 1,
      anon_sym_range,
    ACTIONS(67), 1,
      anon_sym_help,
    ACTIONS(73), 2,
      sym_optional,
      sym_modules,
    ACTIONS(49), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(55), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(12), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
    ACTIONS(172), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [592] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      sym_symbol,
    ACTIONS(176), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(178), 1,
      anon_sym_DQUOTE,
    ACTIONS(180), 1,
      anon_sym_SQUOTE,
    STATE(16), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
    ACTIONS(93), 9,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(91), 32,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
  [658] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(184), 11,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(182), 36,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [713] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(188), 11,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(186), 36,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [768] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(196), 3,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(193), 8,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(190), 36,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [825] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(200), 11,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(198), 36,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [880] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 11,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(202), 36,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [935] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(206), 1,
      ts_builtin_sym_end,
    ACTIONS(211), 1,
      anon_sym_prompt,
    ACTIONS(214), 1,
      anon_sym_default,
    ACTIONS(220), 1,
      anon_sym_dependson,
    ACTIONS(223), 1,
      anon_sym_select,
    ACTIONS(226), 1,
      anon_sym_imply,
    ACTIONS(229), 1,
      anon_sym_visibleif,
    ACTIONS(232), 1,
      anon_sym_range,
    ACTIONS(235), 1,
      anon_sym_help,
    ACTIONS(238), 2,
      sym_optional,
      sym_modules,
    ACTIONS(208), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(217), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(24), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
    ACTIONS(117), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [1013] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(241), 1,
      ts_builtin_sym_end,
    ACTIONS(245), 1,
      anon_sym_prompt,
    ACTIONS(247), 1,
      anon_sym_default,
    ACTIONS(251), 1,
      anon_sym_dependson,
    ACTIONS(253), 1,
      anon_sym_select,
    ACTIONS(255), 1,
      anon_sym_imply,
    ACTIONS(257), 1,
      anon_sym_visibleif,
    ACTIONS(259), 1,
      anon_sym_range,
    ACTIONS(261), 1,
      anon_sym_help,
    ACTIONS(263), 2,
      sym_optional,
      sym_modules,
    ACTIONS(243), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(249), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(24), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
    ACTIONS(156), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [1091] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(245), 1,
      anon_sym_prompt,
    ACTIONS(247), 1,
      anon_sym_default,
    ACTIONS(251), 1,
      anon_sym_dependson,
    ACTIONS(253), 1,
      anon_sym_select,
    ACTIONS(255), 1,
      anon_sym_imply,
    ACTIONS(257), 1,
      anon_sym_visibleif,
    ACTIONS(259), 1,
      anon_sym_range,
    ACTIONS(261), 1,
      anon_sym_help,
    ACTIONS(265), 1,
      ts_builtin_sym_end,
    ACTIONS(263), 2,
      sym_optional,
      sym_modules,
    ACTIONS(243), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(249), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(24), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
    ACTIONS(158), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [1169] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(245), 1,
      anon_sym_prompt,
    ACTIONS(247), 1,
      anon_sym_default,
    ACTIONS(251), 1,
      anon_sym_dependson,
    ACTIONS(253), 1,
      anon_sym_select,
    ACTIONS(255), 1,
      anon_sym_imply,
    ACTIONS(257), 1,
      anon_sym_visibleif,
    ACTIONS(259), 1,
      anon_sym_range,
    ACTIONS(261), 1,
      anon_sym_help,
    ACTIONS(267), 1,
      ts_builtin_sym_end,
    ACTIONS(263), 2,
      sym_optional,
      sym_modules,
    ACTIONS(243), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(249), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(24), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
    ACTIONS(172), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [1247] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(245), 1,
      anon_sym_prompt,
    ACTIONS(247), 1,
      anon_sym_default,
    ACTIONS(251), 1,
      anon_sym_dependson,
    ACTIONS(253), 1,
      anon_sym_select,
    ACTIONS(255), 1,
      anon_sym_imply,
    ACTIONS(257), 1,
      anon_sym_visibleif,
    ACTIONS(259), 1,
      anon_sym_range,
    ACTIONS(261), 1,
      anon_sym_help,
    ACTIONS(269), 1,
      ts_builtin_sym_end,
    ACTIONS(271), 2,
      sym_optional,
      sym_modules,
    ACTIONS(243), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(249), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(27), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
    ACTIONS(152), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [1325] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(200), 12,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(198), 33,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [1378] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(184), 12,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(182), 33,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [1431] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(196), 3,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(193), 9,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(190), 33,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [1486] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 12,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(202), 33,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [1539] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(188), 12,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(186), 33,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [1592] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 8,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(273), 36,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [1644] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 8,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(277), 36,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [1696] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 1,
      anon_sym_EQ,
    ACTIONS(285), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(283), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(279), 4,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(277), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [1754] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 8,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(287), 36,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [1806] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 8,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(291), 36,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [1858] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 1,
      anon_sym_EQ,
    ACTIONS(279), 7,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(277), 36,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [1912] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 1,
      anon_sym_EQ,
    ACTIONS(295), 1,
      anon_sym_AMP_AMP,
    ACTIONS(285), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(279), 3,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
    ACTIONS(283), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(277), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [1972] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 1,
      anon_sym_EQ,
    ACTIONS(295), 1,
      anon_sym_AMP_AMP,
    ACTIONS(301), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(285), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(299), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(283), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(297), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [2034] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 9,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(291), 33,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [2084] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      anon_sym_EQ,
    ACTIONS(305), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(307), 1,
      anon_sym_AMP_AMP,
    ACTIONS(311), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(299), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(309), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(297), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [2144] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 9,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(287), 33,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [2194] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 9,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(273), 33,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [2244] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      anon_sym_EQ,
    ACTIONS(307), 1,
      anon_sym_AMP_AMP,
    ACTIONS(311), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(309), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(279), 4,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
    ACTIONS(277), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [2302] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 9,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(277), 33,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [2352] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      anon_sym_EQ,
    ACTIONS(311), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(309), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(279), 5,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(277), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [2408] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      anon_sym_EQ,
    ACTIONS(279), 8,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(277), 33,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [2460] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      anon_sym_prompt,
    ACTIONS(53), 1,
      anon_sym_default,
    ACTIONS(57), 1,
      anon_sym_dependson,
    ACTIONS(59), 1,
      anon_sym_select,
    ACTIONS(61), 1,
      anon_sym_imply,
    ACTIONS(63), 1,
      anon_sym_visibleif,
    ACTIONS(65), 1,
      anon_sym_range,
    ACTIONS(67), 1,
      anon_sym_help,
    ACTIONS(95), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(97), 1,
      anon_sym_DQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE,
    ACTIONS(313), 1,
      sym_symbol,
    STATE(89), 1,
      sym_name,
    ACTIONS(315), 2,
      sym_optional,
      sym_modules,
    STATE(10), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
    ACTIONS(49), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(55), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(3), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
  [2540] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      anon_sym_prompt,
    ACTIONS(53), 1,
      anon_sym_default,
    ACTIONS(57), 1,
      anon_sym_dependson,
    ACTIONS(59), 1,
      anon_sym_select,
    ACTIONS(61), 1,
      anon_sym_imply,
    ACTIONS(63), 1,
      anon_sym_visibleif,
    ACTIONS(65), 1,
      anon_sym_range,
    ACTIONS(67), 1,
      anon_sym_help,
    ACTIONS(95), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(97), 1,
      anon_sym_DQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE,
    ACTIONS(313), 1,
      sym_symbol,
    STATE(88), 1,
      sym_name,
    ACTIONS(317), 2,
      sym_optional,
      sym_modules,
    STATE(10), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
    ACTIONS(49), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(55), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(7), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
  [2620] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(321), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(319), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [2664] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(325), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(323), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [2708] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(329), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(327), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [2752] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(331), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [2796] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(337), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(335), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [2840] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(341), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(339), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [2884] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(345), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(343), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [2928] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(349), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(347), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [2972] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(351), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3016] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(355), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3060] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(361), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(359), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3104] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(365), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(363), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3148] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(367), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3192] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(371), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3236] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(375), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3280] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(379), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3324] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 2,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(383), 34,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3368] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(379), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3410] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(355), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3452] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(341), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(339), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3494] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(371), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3536] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(375), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3578] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(325), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(323), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3620] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(367), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3662] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(345), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(343), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3704] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(361), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(359), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3746] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(331), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3788] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(337), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(335), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3830] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(349), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(347), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3872] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(321), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(319), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3914] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(383), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3956] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(329), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(327), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [3998] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(365), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(363), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [4040] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_symbol,
    ACTIONS(29), 1,
      anon_sym_mainmenu,
    ACTIONS(31), 1,
      anon_sym_config,
    ACTIONS(33), 1,
      anon_sym_configdefault,
    ACTIONS(35), 1,
      anon_sym_menuconfig,
    ACTIONS(37), 1,
      anon_sym_choice,
    ACTIONS(39), 1,
      anon_sym_comment,
    ACTIONS(41), 1,
      anon_sym_menu,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(387), 1,
      anon_sym_endif,
    ACTIONS(389), 1,
      anon_sym_EQ,
    ACTIONS(391), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(393), 1,
      anon_sym_AMP_AMP,
    ACTIONS(397), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(395), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(47), 4,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
    STATE(110), 12,
      sym__entry,
      sym_mainmenu,
      sym_config,
      sym_configdefault,
      sym_menuconfig,
      sym_choice,
      sym_comment_entry,
      sym_menu,
      sym_if,
      sym_source,
      sym_variable,
      aux_sym_configuration_repeat1,
  [4112] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_symbol,
    ACTIONS(29), 1,
      anon_sym_mainmenu,
    ACTIONS(31), 1,
      anon_sym_config,
    ACTIONS(33), 1,
      anon_sym_configdefault,
    ACTIONS(35), 1,
      anon_sym_menuconfig,
    ACTIONS(37), 1,
      anon_sym_choice,
    ACTIONS(39), 1,
      anon_sym_comment,
    ACTIONS(41), 1,
      anon_sym_menu,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(389), 1,
      anon_sym_EQ,
    ACTIONS(391), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(393), 1,
      anon_sym_AMP_AMP,
    ACTIONS(399), 1,
      anon_sym_endif,
    ACTIONS(397), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(395), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(47), 4,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
    STATE(103), 12,
      sym__entry,
      sym_mainmenu,
      sym_config,
      sym_configdefault,
      sym_menuconfig,
      sym_choice,
      sym_comment_entry,
      sym_menu,
      sym_if,
      sym_source,
      sym_variable,
      aux_sym_configuration_repeat1,
  [4184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 3,
      ts_builtin_sym_end,
      anon_sym_dependson,
      anon_sym_visibleif,
    ACTIONS(351), 31,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
      anon_sym_prompt,
      anon_sym_default,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
      anon_sym_select,
      anon_sym_imply,
      anon_sym_range,
      anon_sym_help,
      sym_optional,
      sym_modules,
      sym_symbol,
  [4226] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      anon_sym_dependson,
    ACTIONS(63), 1,
      anon_sym_visibleif,
    ACTIONS(403), 1,
      anon_sym_prompt,
    ACTIONS(405), 1,
      anon_sym_default,
    ACTIONS(409), 1,
      anon_sym_select,
    ACTIONS(411), 1,
      anon_sym_imply,
    ACTIONS(413), 1,
      anon_sym_range,
    ACTIONS(415), 1,
      anon_sym_help,
    ACTIONS(417), 2,
      sym_optional,
      sym_modules,
    ACTIONS(401), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(407), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(8), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
  [4286] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      anon_sym_dependson,
    ACTIONS(63), 1,
      anon_sym_visibleif,
    ACTIONS(403), 1,
      anon_sym_prompt,
    ACTIONS(405), 1,
      anon_sym_default,
    ACTIONS(409), 1,
      anon_sym_select,
    ACTIONS(411), 1,
      anon_sym_imply,
    ACTIONS(413), 1,
      anon_sym_range,
    ACTIONS(415), 1,
      anon_sym_help,
    ACTIONS(419), 2,
      sym_optional,
      sym_modules,
    ACTIONS(401), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(407), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(4), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
  [4346] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      anon_sym_dependson,
    ACTIONS(63), 1,
      anon_sym_visibleif,
    ACTIONS(403), 1,
      anon_sym_prompt,
    ACTIONS(405), 1,
      anon_sym_default,
    ACTIONS(409), 1,
      anon_sym_select,
    ACTIONS(411), 1,
      anon_sym_imply,
    ACTIONS(413), 1,
      anon_sym_range,
    ACTIONS(415), 1,
      anon_sym_help,
    ACTIONS(421), 2,
      sym_optional,
      sym_modules,
    ACTIONS(401), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(407), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(14), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
  [4406] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 1,
      anon_sym_dependson,
    ACTIONS(257), 1,
      anon_sym_visibleif,
    ACTIONS(425), 1,
      anon_sym_prompt,
    ACTIONS(427), 1,
      anon_sym_default,
    ACTIONS(431), 1,
      anon_sym_select,
    ACTIONS(433), 1,
      anon_sym_imply,
    ACTIONS(435), 1,
      anon_sym_range,
    ACTIONS(437), 1,
      anon_sym_help,
    ACTIONS(439), 2,
      sym_optional,
      sym_modules,
    ACTIONS(423), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(429), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(25), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
  [4466] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      anon_sym_dependson,
    ACTIONS(63), 1,
      anon_sym_visibleif,
    ACTIONS(403), 1,
      anon_sym_prompt,
    ACTIONS(405), 1,
      anon_sym_default,
    ACTIONS(409), 1,
      anon_sym_select,
    ACTIONS(411), 1,
      anon_sym_imply,
    ACTIONS(413), 1,
      anon_sym_range,
    ACTIONS(415), 1,
      anon_sym_help,
    ACTIONS(441), 2,
      sym_optional,
      sym_modules,
    ACTIONS(401), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(407), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(15), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
  [4526] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 1,
      anon_sym_dependson,
    ACTIONS(257), 1,
      anon_sym_visibleif,
    ACTIONS(425), 1,
      anon_sym_prompt,
    ACTIONS(427), 1,
      anon_sym_default,
    ACTIONS(431), 1,
      anon_sym_select,
    ACTIONS(433), 1,
      anon_sym_imply,
    ACTIONS(435), 1,
      anon_sym_range,
    ACTIONS(437), 1,
      anon_sym_help,
    ACTIONS(443), 2,
      sym_optional,
      sym_modules,
    ACTIONS(423), 5,
      anon_sym_bool,
      anon_sym_tristate,
      anon_sym_int,
      anon_sym_hex,
      anon_sym_string,
    ACTIONS(429), 5,
      anon_sym_def_bool,
      anon_sym_def_tristate,
      anon_sym_def_int,
      anon_sym_def_hex,
      anon_sym_def_string,
    STATE(26), 12,
      sym__config_option,
      sym_type_definition,
      sym_input_prompt,
      sym_default_value,
      sym_type_definition_default,
      sym_dependencies,
      sym_reverse_dependencies,
      sym_weak_reverse_dependencies,
      sym_limiting_menu_display,
      sym_numerical_ranges,
      sym_help_text,
      aux_sym_config_repeat1,
  [4586] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      sym_symbol,
    ACTIONS(448), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(451), 1,
      anon_sym_DQUOTE,
    ACTIONS(454), 1,
      anon_sym_SQUOTE,
    STATE(94), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
    ACTIONS(106), 7,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_RPAREN,
    ACTIONS(104), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_default,
      anon_sym_LT,
      anon_sym_GT,
  [4634] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_symbol,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    STATE(94), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
    ACTIONS(93), 7,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_RPAREN,
    ACTIONS(91), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_default,
      anon_sym_LT,
      anon_sym_GT,
  [4682] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(184), 10,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(182), 19,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_default,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [4719] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(200), 10,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(198), 19,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_default,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [4756] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 1,
      sym_symbol,
    ACTIONS(468), 1,
      anon_sym_mainmenu,
    ACTIONS(471), 1,
      anon_sym_config,
    ACTIONS(474), 1,
      anon_sym_configdefault,
    ACTIONS(477), 1,
      anon_sym_menuconfig,
    ACTIONS(480), 1,
      anon_sym_choice,
    ACTIONS(485), 1,
      anon_sym_comment,
    ACTIONS(488), 1,
      anon_sym_menu,
    ACTIONS(491), 1,
      anon_sym_if,
    ACTIONS(483), 3,
      anon_sym_endchoice,
      anon_sym_endmenu,
      anon_sym_endif,
    ACTIONS(494), 4,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
    STATE(98), 12,
      sym__entry,
      sym_mainmenu,
      sym_config,
      sym_configdefault,
      sym_menuconfig,
      sym_choice,
      sym_comment_entry,
      sym_menu,
      sym_if,
      sym_source,
      sym_variable,
      aux_sym_configuration_repeat1,
  [4812] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(188), 10,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(186), 17,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_default,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [4847] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 10,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(202), 17,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_default,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [4882] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_symbol,
    ACTIONS(29), 1,
      anon_sym_mainmenu,
    ACTIONS(31), 1,
      anon_sym_config,
    ACTIONS(33), 1,
      anon_sym_configdefault,
    ACTIONS(35), 1,
      anon_sym_menuconfig,
    ACTIONS(37), 1,
      anon_sym_choice,
    ACTIONS(39), 1,
      anon_sym_comment,
    ACTIONS(41), 1,
      anon_sym_menu,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(497), 1,
      anon_sym_endmenu,
    ACTIONS(47), 4,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
    STATE(98), 12,
      sym__entry,
      sym_mainmenu,
      sym_config,
      sym_configdefault,
      sym_menuconfig,
      sym_choice,
      sym_comment_entry,
      sym_menu,
      sym_if,
      sym_source,
      sym_variable,
      aux_sym_configuration_repeat1,
  [4936] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_symbol,
    ACTIONS(29), 1,
      anon_sym_mainmenu,
    ACTIONS(31), 1,
      anon_sym_config,
    ACTIONS(33), 1,
      anon_sym_configdefault,
    ACTIONS(35), 1,
      anon_sym_menuconfig,
    ACTIONS(37), 1,
      anon_sym_choice,
    ACTIONS(39), 1,
      anon_sym_comment,
    ACTIONS(41), 1,
      anon_sym_menu,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_endmenu,
    ACTIONS(47), 4,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
    STATE(98), 12,
      sym__entry,
      sym_mainmenu,
      sym_config,
      sym_configdefault,
      sym_menuconfig,
      sym_choice,
      sym_comment_entry,
      sym_menu,
      sym_if,
      sym_source,
      sym_variable,
      aux_sym_configuration_repeat1,
  [4990] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_symbol,
    ACTIONS(29), 1,
      anon_sym_mainmenu,
    ACTIONS(31), 1,
      anon_sym_config,
    ACTIONS(33), 1,
      anon_sym_configdefault,
    ACTIONS(35), 1,
      anon_sym_menuconfig,
    ACTIONS(37), 1,
      anon_sym_choice,
    ACTIONS(39), 1,
      anon_sym_comment,
    ACTIONS(41), 1,
      anon_sym_menu,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(499), 1,
      anon_sym_endif,
    ACTIONS(47), 4,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
    STATE(98), 12,
      sym__entry,
      sym_mainmenu,
      sym_config,
      sym_configdefault,
      sym_menuconfig,
      sym_choice,
      sym_comment_entry,
      sym_menu,
      sym_if,
      sym_source,
      sym_variable,
      aux_sym_configuration_repeat1,
  [5044] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_symbol,
    ACTIONS(9), 1,
      anon_sym_mainmenu,
    ACTIONS(11), 1,
      anon_sym_config,
    ACTIONS(13), 1,
      anon_sym_configdefault,
    ACTIONS(15), 1,
      anon_sym_menuconfig,
    ACTIONS(17), 1,
      anon_sym_choice,
    ACTIONS(19), 1,
      anon_sym_comment,
    ACTIONS(21), 1,
      anon_sym_menu,
    ACTIONS(23), 1,
      anon_sym_if,
    ACTIONS(501), 1,
      ts_builtin_sym_end,
    ACTIONS(25), 4,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
    STATE(106), 12,
      sym__entry,
      sym_mainmenu,
      sym_config,
      sym_configdefault,
      sym_menuconfig,
      sym_choice,
      sym_comment_entry,
      sym_menu,
      sym_if,
      sym_source,
      sym_variable,
      aux_sym_configuration_repeat1,
  [5098] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_symbol,
    ACTIONS(29), 1,
      anon_sym_mainmenu,
    ACTIONS(31), 1,
      anon_sym_config,
    ACTIONS(33), 1,
      anon_sym_configdefault,
    ACTIONS(35), 1,
      anon_sym_menuconfig,
    ACTIONS(37), 1,
      anon_sym_choice,
    ACTIONS(39), 1,
      anon_sym_comment,
    ACTIONS(41), 1,
      anon_sym_menu,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(503), 1,
      anon_sym_endmenu,
    ACTIONS(47), 4,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
    STATE(98), 12,
      sym__entry,
      sym_mainmenu,
      sym_config,
      sym_configdefault,
      sym_menuconfig,
      sym_choice,
      sym_comment_entry,
      sym_menu,
      sym_if,
      sym_source,
      sym_variable,
      aux_sym_configuration_repeat1,
  [5152] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(505), 1,
      ts_builtin_sym_end,
    ACTIONS(507), 1,
      sym_symbol,
    ACTIONS(510), 1,
      anon_sym_mainmenu,
    ACTIONS(513), 1,
      anon_sym_config,
    ACTIONS(516), 1,
      anon_sym_configdefault,
    ACTIONS(519), 1,
      anon_sym_menuconfig,
    ACTIONS(522), 1,
      anon_sym_choice,
    ACTIONS(525), 1,
      anon_sym_comment,
    ACTIONS(528), 1,
      anon_sym_menu,
    ACTIONS(531), 1,
      anon_sym_if,
    ACTIONS(534), 4,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
    STATE(106), 12,
      sym__entry,
      sym_mainmenu,
      sym_config,
      sym_configdefault,
      sym_menuconfig,
      sym_choice,
      sym_comment_entry,
      sym_menu,
      sym_if,
      sym_source,
      sym_variable,
      aux_sym_configuration_repeat1,
  [5206] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_symbol,
    ACTIONS(29), 1,
      anon_sym_mainmenu,
    ACTIONS(31), 1,
      anon_sym_config,
    ACTIONS(33), 1,
      anon_sym_configdefault,
    ACTIONS(35), 1,
      anon_sym_menuconfig,
    ACTIONS(37), 1,
      anon_sym_choice,
    ACTIONS(39), 1,
      anon_sym_comment,
    ACTIONS(41), 1,
      anon_sym_menu,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(537), 1,
      anon_sym_endchoice,
    ACTIONS(47), 4,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
    STATE(98), 12,
      sym__entry,
      sym_mainmenu,
      sym_config,
      sym_configdefault,
      sym_menuconfig,
      sym_choice,
      sym_comment_entry,
      sym_menu,
      sym_if,
      sym_source,
      sym_variable,
      aux_sym_configuration_repeat1,
  [5260] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_symbol,
    ACTIONS(29), 1,
      anon_sym_mainmenu,
    ACTIONS(31), 1,
      anon_sym_config,
    ACTIONS(33), 1,
      anon_sym_configdefault,
    ACTIONS(35), 1,
      anon_sym_menuconfig,
    ACTIONS(37), 1,
      anon_sym_choice,
    ACTIONS(39), 1,
      anon_sym_comment,
    ACTIONS(41), 1,
      anon_sym_menu,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(87), 1,
      anon_sym_endmenu,
    ACTIONS(47), 4,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
    STATE(98), 12,
      sym__entry,
      sym_mainmenu,
      sym_config,
      sym_configdefault,
      sym_menuconfig,
      sym_choice,
      sym_comment_entry,
      sym_menu,
      sym_if,
      sym_source,
      sym_variable,
      aux_sym_configuration_repeat1,
  [5314] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_symbol,
    ACTIONS(29), 1,
      anon_sym_mainmenu,
    ACTIONS(31), 1,
      anon_sym_config,
    ACTIONS(33), 1,
      anon_sym_configdefault,
    ACTIONS(35), 1,
      anon_sym_menuconfig,
    ACTIONS(37), 1,
      anon_sym_choice,
    ACTIONS(39), 1,
      anon_sym_comment,
    ACTIONS(41), 1,
      anon_sym_menu,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(539), 1,
      anon_sym_endchoice,
    ACTIONS(47), 4,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
    STATE(98), 12,
      sym__entry,
      sym_mainmenu,
      sym_config,
      sym_configdefault,
      sym_menuconfig,
      sym_choice,
      sym_comment_entry,
      sym_menu,
      sym_if,
      sym_source,
      sym_variable,
      aux_sym_configuration_repeat1,
  [5368] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_symbol,
    ACTIONS(29), 1,
      anon_sym_mainmenu,
    ACTIONS(31), 1,
      anon_sym_config,
    ACTIONS(33), 1,
      anon_sym_configdefault,
    ACTIONS(35), 1,
      anon_sym_menuconfig,
    ACTIONS(37), 1,
      anon_sym_choice,
    ACTIONS(39), 1,
      anon_sym_comment,
    ACTIONS(41), 1,
      anon_sym_menu,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(541), 1,
      anon_sym_endif,
    ACTIONS(47), 4,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
    STATE(98), 12,
      sym__entry,
      sym_mainmenu,
      sym_config,
      sym_configdefault,
      sym_menuconfig,
      sym_choice,
      sym_comment_entry,
      sym_menu,
      sym_if,
      sym_source,
      sym_variable,
      aux_sym_configuration_repeat1,
  [5422] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_symbol,
    ACTIONS(29), 1,
      anon_sym_mainmenu,
    ACTIONS(31), 1,
      anon_sym_config,
    ACTIONS(33), 1,
      anon_sym_configdefault,
    ACTIONS(35), 1,
      anon_sym_menuconfig,
    ACTIONS(37), 1,
      anon_sym_choice,
    ACTIONS(39), 1,
      anon_sym_comment,
    ACTIONS(41), 1,
      anon_sym_menu,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(543), 1,
      anon_sym_endchoice,
    ACTIONS(47), 4,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
    STATE(98), 12,
      sym__entry,
      sym_mainmenu,
      sym_config,
      sym_configdefault,
      sym_menuconfig,
      sym_choice,
      sym_comment_entry,
      sym_menu,
      sym_if,
      sym_source,
      sym_variable,
      aux_sym_configuration_repeat1,
  [5476] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_symbol,
    ACTIONS(29), 1,
      anon_sym_mainmenu,
    ACTIONS(31), 1,
      anon_sym_config,
    ACTIONS(33), 1,
      anon_sym_configdefault,
    ACTIONS(35), 1,
      anon_sym_menuconfig,
    ACTIONS(37), 1,
      anon_sym_choice,
    ACTIONS(39), 1,
      anon_sym_comment,
    ACTIONS(41), 1,
      anon_sym_menu,
    ACTIONS(45), 1,
      anon_sym_if,
    ACTIONS(545), 1,
      anon_sym_endchoice,
    ACTIONS(47), 4,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
    STATE(98), 12,
      sym__entry,
      sym_mainmenu,
      sym_config,
      sym_configdefault,
      sym_menuconfig,
      sym_choice,
      sym_comment_entry,
      sym_menu,
      sym_if,
      sym_source,
      sym_variable,
      aux_sym_configuration_repeat1,
  [5530] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(196), 3,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(193), 6,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(190), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [5565] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 7,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_RPAREN,
    ACTIONS(277), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [5596] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 7,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_RPAREN,
    ACTIONS(273), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [5627] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 7,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_RPAREN,
    ACTIONS(291), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [5658] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 7,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_RPAREN,
    ACTIONS(287), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [5689] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(389), 1,
      anon_sym_EQ,
    ACTIONS(393), 1,
      anon_sym_AMP_AMP,
    ACTIONS(397), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(395), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(277), 14,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [5727] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 1,
      anon_sym_EQ,
    ACTIONS(279), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(397), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(395), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(277), 14,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [5763] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 1,
      anon_sym_EQ,
    ACTIONS(279), 5,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(277), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_LT,
      anon_sym_GT,
      sym_symbol,
  [5795] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 1,
      anon_sym_default,
    STATE(122), 2,
      sym_default_value,
      aux_sym_configdefault_repeat1,
    ACTIONS(547), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [5824] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 1,
      anon_sym_default,
    STATE(122), 2,
      sym_default_value,
      aux_sym_configdefault_repeat1,
    ACTIONS(551), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [5853] = 8,
    ACTIONS(106), 1,
      aux_sym_variable_token1,
    ACTIONS(556), 1,
      sym_symbol,
    ACTIONS(559), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(565), 1,
      anon_sym_SQUOTE,
    ACTIONS(568), 1,
      sym_comment,
    STATE(123), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
    ACTIONS(104), 11,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_BANG,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
  [5890] = 8,
    ACTIONS(93), 1,
      aux_sym_variable_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(570), 1,
      sym_symbol,
    ACTIONS(572), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(574), 1,
      anon_sym_DQUOTE,
    ACTIONS(576), 1,
      anon_sym_SQUOTE,
    STATE(123), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
    ACTIONS(91), 11,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_BANG,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
  [5927] = 15,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(574), 1,
      anon_sym_DQUOTE,
    ACTIONS(576), 1,
      anon_sym_SQUOTE,
    ACTIONS(578), 1,
      sym_symbol,
    ACTIONS(580), 1,
      anon_sym_COMMA,
    ACTIONS(582), 1,
      aux_sym_variable_token1,
    ACTIONS(584), 1,
      anon_sym_BANG,
    ACTIONS(586), 1,
      anon_sym_LPAREN,
    ACTIONS(588), 1,
      sym_text,
    STATE(124), 1,
      aux_sym_name_repeat1,
    STATE(134), 1,
      aux_sym_variable_repeat1,
    STATE(149), 1,
      sym_expression,
    STATE(157), 2,
      sym_macro_variable,
      sym_string,
    STATE(153), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [5977] = 15,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(574), 1,
      anon_sym_DQUOTE,
    ACTIONS(576), 1,
      anon_sym_SQUOTE,
    ACTIONS(578), 1,
      sym_symbol,
    ACTIONS(584), 1,
      anon_sym_BANG,
    ACTIONS(586), 1,
      anon_sym_LPAREN,
    ACTIONS(590), 1,
      anon_sym_COMMA,
    ACTIONS(592), 1,
      aux_sym_variable_token1,
    ACTIONS(594), 1,
      sym_text,
    STATE(124), 1,
      aux_sym_name_repeat1,
    STATE(132), 1,
      aux_sym_variable_repeat1,
    STATE(149), 1,
      sym_expression,
    STATE(157), 2,
      sym_macro_variable,
      sym_string,
    STATE(153), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [6027] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(596), 1,
      ts_builtin_sym_end,
    ACTIONS(598), 1,
      anon_sym_default,
    STATE(127), 2,
      sym_default_value,
      aux_sym_configdefault_repeat1,
    ACTIONS(551), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [6056] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      ts_builtin_sym_end,
    ACTIONS(603), 1,
      anon_sym_default,
    STATE(127), 2,
      sym_default_value,
      aux_sym_configdefault_repeat1,
    ACTIONS(547), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [6085] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 17,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_default,
      sym_symbol,
  [6108] = 8,
    ACTIONS(106), 1,
      aux_sym_type_definition_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(605), 1,
      sym_symbol,
    ACTIONS(608), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(611), 1,
      anon_sym_DQUOTE,
    ACTIONS(614), 1,
      anon_sym_SQUOTE,
    STATE(130), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
    ACTIONS(104), 9,
      anon_sym_if,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [6143] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(339), 17,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_default,
      sym_symbol,
  [6166] = 14,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(574), 1,
      anon_sym_DQUOTE,
    ACTIONS(576), 1,
      anon_sym_SQUOTE,
    ACTIONS(578), 1,
      sym_symbol,
    ACTIONS(584), 1,
      anon_sym_BANG,
    ACTIONS(586), 1,
      anon_sym_LPAREN,
    ACTIONS(617), 1,
      anon_sym_COMMA,
    ACTIONS(619), 1,
      aux_sym_variable_token1,
    STATE(124), 1,
      aux_sym_name_repeat1,
    STATE(135), 1,
      aux_sym_variable_repeat1,
    STATE(149), 1,
      sym_expression,
    STATE(157), 2,
      sym_macro_variable,
      sym_string,
    STATE(153), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [6213] = 8,
    ACTIONS(93), 1,
      aux_sym_type_definition_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(621), 1,
      sym_symbol,
    ACTIONS(623), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(625), 1,
      anon_sym_DQUOTE,
    ACTIONS(627), 1,
      anon_sym_SQUOTE,
    STATE(130), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
    ACTIONS(91), 9,
      anon_sym_if,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [6248] = 14,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(574), 1,
      anon_sym_DQUOTE,
    ACTIONS(576), 1,
      anon_sym_SQUOTE,
    ACTIONS(578), 1,
      sym_symbol,
    ACTIONS(584), 1,
      anon_sym_BANG,
    ACTIONS(586), 1,
      anon_sym_LPAREN,
    ACTIONS(617), 1,
      anon_sym_COMMA,
    ACTIONS(629), 1,
      aux_sym_variable_token1,
    STATE(124), 1,
      aux_sym_name_repeat1,
    STATE(135), 1,
      aux_sym_variable_repeat1,
    STATE(149), 1,
      sym_expression,
    STATE(157), 2,
      sym_macro_variable,
      sym_string,
    STATE(153), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [6295] = 14,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(631), 1,
      sym_symbol,
    ACTIONS(634), 1,
      anon_sym_COMMA,
    ACTIONS(637), 1,
      aux_sym_variable_token1,
    ACTIONS(639), 1,
      anon_sym_BANG,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(648), 1,
      anon_sym_DQUOTE,
    ACTIONS(651), 1,
      anon_sym_SQUOTE,
    STATE(124), 1,
      aux_sym_name_repeat1,
    STATE(135), 1,
      aux_sym_variable_repeat1,
    STATE(149), 1,
      sym_expression,
    STATE(157), 2,
      sym_macro_variable,
      sym_string,
    STATE(153), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [6342] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [6364] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(656), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [6386] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [6408] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(660), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [6430] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(662), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [6452] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(664), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [6474] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(666), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [6496] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(668), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [6518] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [6540] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [6562] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [6584] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(676), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [6606] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [6628] = 7,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(682), 1,
      anon_sym_EQ,
    ACTIONS(684), 1,
      aux_sym_variable_token1,
    ACTIONS(686), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(688), 1,
      anon_sym_AMP_AMP,
    ACTIONS(690), 5,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(680), 7,
      anon_sym_COMMA,
      anon_sym_BANG,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [6660] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(692), 16,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_endchoice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_endmenu,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [6682] = 3,
    ACTIONS(184), 1,
      aux_sym_variable_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(182), 15,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_BANG,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [6706] = 3,
    ACTIONS(200), 1,
      aux_sym_variable_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(198), 15,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_BANG,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [6730] = 3,
    ACTIONS(289), 1,
      aux_sym_variable_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(287), 15,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_BANG,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [6754] = 3,
    ACTIONS(275), 1,
      aux_sym_variable_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(273), 15,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_BANG,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [6778] = 3,
    ACTIONS(293), 1,
      aux_sym_variable_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(291), 15,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_BANG,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [6802] = 3,
    ACTIONS(279), 1,
      aux_sym_variable_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(277), 15,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_BANG,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [6826] = 3,
    ACTIONS(193), 1,
      aux_sym_variable_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(190), 15,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_BANG,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [6850] = 6,
    ACTIONS(279), 1,
      aux_sym_variable_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(682), 1,
      anon_sym_EQ,
    ACTIONS(688), 1,
      anon_sym_AMP_AMP,
    ACTIONS(690), 5,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(277), 8,
      anon_sym_COMMA,
      anon_sym_BANG,
      anon_sym_PIPE_PIPE,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [6880] = 5,
    ACTIONS(279), 1,
      aux_sym_variable_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(682), 1,
      anon_sym_EQ,
    ACTIONS(690), 5,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(277), 9,
      anon_sym_COMMA,
      anon_sym_BANG,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [6908] = 4,
    ACTIONS(279), 1,
      aux_sym_variable_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(682), 1,
      anon_sym_EQ,
    ACTIONS(277), 14,
      anon_sym_COMMA,
      anon_sym_BANG,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [6934] = 3,
    ACTIONS(204), 1,
      aux_sym_variable_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(202), 15,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_BANG,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [6958] = 3,
    ACTIONS(188), 1,
      aux_sym_variable_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(186), 15,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_BANG,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [6982] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(341), 1,
      ts_builtin_sym_end,
    ACTIONS(339), 14,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_default,
      sym_symbol,
  [7005] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 1,
      ts_builtin_sym_end,
    ACTIONS(379), 14,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      anon_sym_default,
      sym_symbol,
  [7028] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      sym_symbol,
    ACTIONS(696), 1,
      anon_sym_BANG,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(133), 1,
      aux_sym_name_repeat1,
    STATE(255), 1,
      sym_expression,
    STATE(227), 2,
      sym_macro_variable,
      sym_string,
    STATE(246), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7066] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(706), 1,
      sym_symbol,
    ACTIONS(708), 1,
      anon_sym_BANG,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(252), 1,
      sym_expression,
    STATE(234), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7104] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      sym_symbol,
    ACTIONS(696), 1,
      anon_sym_BANG,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(133), 1,
      aux_sym_name_repeat1,
    STATE(237), 1,
      sym_expression,
    STATE(227), 2,
      sym_macro_variable,
      sym_string,
    STATE(246), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7142] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      sym_symbol,
    ACTIONS(696), 1,
      anon_sym_BANG,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(133), 1,
      aux_sym_name_repeat1,
    STATE(247), 1,
      sym_expression,
    STATE(227), 2,
      sym_macro_variable,
      sym_string,
    STATE(246), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7180] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      sym_symbol,
    ACTIONS(696), 1,
      anon_sym_BANG,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(133), 1,
      aux_sym_name_repeat1,
    STATE(243), 1,
      sym_expression,
    STATE(227), 2,
      sym_macro_variable,
      sym_string,
    STATE(246), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7218] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 1,
      ts_builtin_sym_end,
    ACTIONS(666), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [7240] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      sym_symbol,
    ACTIONS(696), 1,
      anon_sym_BANG,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(133), 1,
      aux_sym_name_repeat1,
    STATE(241), 1,
      sym_expression,
    STATE(227), 2,
      sym_macro_variable,
      sym_string,
    STATE(246), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7278] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(184), 1,
      ts_builtin_sym_end,
    ACTIONS(182), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [7300] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      sym_symbol,
    ACTIONS(696), 1,
      anon_sym_BANG,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(133), 1,
      aux_sym_name_repeat1,
    STATE(242), 1,
      sym_expression,
    STATE(227), 2,
      sym_macro_variable,
      sym_string,
    STATE(246), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7338] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    ACTIONS(714), 1,
      sym_symbol,
    ACTIONS(716), 1,
      anon_sym_BANG,
    STATE(86), 1,
      sym_expression,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(113), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7376] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    ACTIONS(714), 1,
      sym_symbol,
    ACTIONS(716), 1,
      anon_sym_BANG,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(115), 1,
      sym_expression,
    STATE(113), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7414] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(97), 1,
      anon_sym_DQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE,
    ACTIONS(718), 1,
      sym_symbol,
    ACTIONS(720), 1,
      anon_sym_BANG,
    ACTIONS(722), 1,
      anon_sym_LPAREN,
    STATE(10), 1,
      aux_sym_name_repeat1,
    STATE(35), 1,
      sym_expression,
    STATE(21), 2,
      sym_macro_variable,
      sym_string,
    STATE(37), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7452] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(97), 1,
      anon_sym_DQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE,
    ACTIONS(718), 1,
      sym_symbol,
    ACTIONS(720), 1,
      anon_sym_BANG,
    ACTIONS(722), 1,
      anon_sym_LPAREN,
    STATE(10), 1,
      aux_sym_name_repeat1,
    STATE(40), 1,
      sym_expression,
    STATE(21), 2,
      sym_macro_variable,
      sym_string,
    STATE(37), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7490] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(97), 1,
      anon_sym_DQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE,
    ACTIONS(718), 1,
      sym_symbol,
    ACTIONS(720), 1,
      anon_sym_BANG,
    ACTIONS(722), 1,
      anon_sym_LPAREN,
    STATE(10), 1,
      aux_sym_name_repeat1,
    STATE(36), 1,
      sym_expression,
    STATE(21), 2,
      sym_macro_variable,
      sym_string,
    STATE(37), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7528] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(97), 1,
      anon_sym_DQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE,
    ACTIONS(718), 1,
      sym_symbol,
    ACTIONS(720), 1,
      anon_sym_BANG,
    ACTIONS(722), 1,
      anon_sym_LPAREN,
    STATE(10), 1,
      aux_sym_name_repeat1,
    STATE(39), 1,
      sym_expression,
    STATE(21), 2,
      sym_macro_variable,
      sym_string,
    STATE(37), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7566] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(706), 1,
      sym_symbol,
    ACTIONS(708), 1,
      anon_sym_BANG,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(250), 1,
      sym_expression,
    STATE(234), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7604] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      ts_builtin_sym_end,
    ACTIONS(662), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [7626] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(97), 1,
      anon_sym_DQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE,
    ACTIONS(718), 1,
      sym_symbol,
    ACTIONS(720), 1,
      anon_sym_BANG,
    ACTIONS(722), 1,
      anon_sym_LPAREN,
    STATE(10), 1,
      aux_sym_name_repeat1,
    STATE(41), 1,
      sym_expression,
    STATE(21), 2,
      sym_macro_variable,
      sym_string,
    STATE(37), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7664] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      ts_builtin_sym_end,
    ACTIONS(660), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [7686] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(706), 1,
      sym_symbol,
    ACTIONS(708), 1,
      anon_sym_BANG,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(114), 1,
      sym_expression,
    STATE(234), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7724] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(706), 1,
      sym_symbol,
    ACTIONS(708), 1,
      anon_sym_BANG,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(249), 1,
      sym_expression,
    STATE(234), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7762] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(706), 1,
      sym_symbol,
    ACTIONS(708), 1,
      anon_sym_BANG,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(254), 1,
      sym_expression,
    STATE(234), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7800] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(706), 1,
      sym_symbol,
    ACTIONS(708), 1,
      anon_sym_BANG,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(253), 1,
      sym_expression,
    STATE(234), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7838] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(728), 1,
      ts_builtin_sym_end,
    ACTIONS(664), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [7860] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    ACTIONS(714), 1,
      sym_symbol,
    ACTIONS(716), 1,
      anon_sym_BANG,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(114), 1,
      sym_expression,
    STATE(113), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7898] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      ts_builtin_sym_end,
    ACTIONS(668), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [7920] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    ACTIONS(714), 1,
      sym_symbol,
    ACTIONS(716), 1,
      anon_sym_BANG,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(118), 1,
      sym_expression,
    STATE(113), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [7958] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 1,
      ts_builtin_sym_end,
    ACTIONS(670), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [7980] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 1,
      ts_builtin_sym_end,
    ACTIONS(672), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [8002] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 1,
      sym_symbol,
    ACTIONS(738), 1,
      anon_sym_BANG,
    ACTIONS(740), 1,
      anon_sym_LPAREN,
    ACTIONS(742), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(744), 1,
      anon_sym_DQUOTE,
    ACTIONS(746), 1,
      anon_sym_SQUOTE,
    STATE(124), 1,
      aux_sym_name_repeat1,
    STATE(156), 1,
      sym_expression,
    STATE(157), 2,
      sym_macro_variable,
      sym_string,
    STATE(153), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8040] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 1,
      sym_symbol,
    ACTIONS(738), 1,
      anon_sym_BANG,
    ACTIONS(740), 1,
      anon_sym_LPAREN,
    ACTIONS(742), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(744), 1,
      anon_sym_DQUOTE,
    ACTIONS(746), 1,
      anon_sym_SQUOTE,
    STATE(124), 1,
      aux_sym_name_repeat1,
    STATE(158), 1,
      sym_expression,
    STATE(157), 2,
      sym_macro_variable,
      sym_string,
    STATE(153), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8078] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 1,
      sym_symbol,
    ACTIONS(738), 1,
      anon_sym_BANG,
    ACTIONS(740), 1,
      anon_sym_LPAREN,
    ACTIONS(742), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(744), 1,
      anon_sym_DQUOTE,
    ACTIONS(746), 1,
      anon_sym_SQUOTE,
    STATE(124), 1,
      aux_sym_name_repeat1,
    STATE(159), 1,
      sym_expression,
    STATE(157), 2,
      sym_macro_variable,
      sym_string,
    STATE(153), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8116] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 1,
      sym_symbol,
    ACTIONS(738), 1,
      anon_sym_BANG,
    ACTIONS(740), 1,
      anon_sym_LPAREN,
    ACTIONS(742), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(744), 1,
      anon_sym_DQUOTE,
    ACTIONS(746), 1,
      anon_sym_SQUOTE,
    STATE(124), 1,
      aux_sym_name_repeat1,
    STATE(160), 1,
      sym_expression,
    STATE(157), 2,
      sym_macro_variable,
      sym_string,
    STATE(153), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8154] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(200), 1,
      ts_builtin_sym_end,
    ACTIONS(198), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [8176] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    ACTIONS(714), 1,
      sym_symbol,
    ACTIONS(716), 1,
      anon_sym_BANG,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(119), 1,
      sym_expression,
    STATE(113), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8214] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    ACTIONS(714), 1,
      sym_symbol,
    ACTIONS(716), 1,
      anon_sym_BANG,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(120), 1,
      sym_expression,
    STATE(113), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8252] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      sym_symbol,
    ACTIONS(696), 1,
      anon_sym_BANG,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(133), 1,
      aux_sym_name_repeat1,
    STATE(239), 1,
      sym_expression,
    STATE(227), 2,
      sym_macro_variable,
      sym_string,
    STATE(246), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8290] = 3,
    ACTIONS(200), 1,
      aux_sym_type_definition_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(198), 13,
      anon_sym_if,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [8312] = 3,
    ACTIONS(204), 1,
      aux_sym_type_definition_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(202), 13,
      anon_sym_if,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [8334] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(176), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(178), 1,
      anon_sym_DQUOTE,
    ACTIONS(180), 1,
      anon_sym_SQUOTE,
    ACTIONS(748), 1,
      sym_symbol,
    ACTIONS(750), 1,
      anon_sym_BANG,
    ACTIONS(752), 1,
      anon_sym_LPAREN,
    STATE(18), 1,
      aux_sym_name_repeat1,
    STATE(47), 1,
      sym_expression,
    STATE(31), 2,
      sym_macro_variable,
      sym_string,
    STATE(44), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8372] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(176), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(178), 1,
      anon_sym_DQUOTE,
    ACTIONS(180), 1,
      anon_sym_SQUOTE,
    ACTIONS(748), 1,
      sym_symbol,
    ACTIONS(750), 1,
      anon_sym_BANG,
    ACTIONS(752), 1,
      anon_sym_LPAREN,
    STATE(18), 1,
      aux_sym_name_repeat1,
    STATE(48), 1,
      sym_expression,
    STATE(31), 2,
      sym_macro_variable,
      sym_string,
    STATE(44), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8410] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(176), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(178), 1,
      anon_sym_DQUOTE,
    ACTIONS(180), 1,
      anon_sym_SQUOTE,
    ACTIONS(748), 1,
      sym_symbol,
    ACTIONS(750), 1,
      anon_sym_BANG,
    ACTIONS(752), 1,
      anon_sym_LPAREN,
    STATE(18), 1,
      aux_sym_name_repeat1,
    STATE(49), 1,
      sym_expression,
    STATE(31), 2,
      sym_macro_variable,
      sym_string,
    STATE(44), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8448] = 3,
    ACTIONS(184), 1,
      aux_sym_type_definition_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(182), 13,
      anon_sym_if,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [8470] = 3,
    ACTIONS(188), 1,
      aux_sym_type_definition_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(186), 13,
      anon_sym_if,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
  [8492] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 1,
      ts_builtin_sym_end,
    ACTIONS(656), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [8514] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 1,
      ts_builtin_sym_end,
    ACTIONS(674), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [8536] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 1,
      ts_builtin_sym_end,
    ACTIONS(658), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [8558] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(760), 1,
      ts_builtin_sym_end,
    ACTIONS(676), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [8580] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 1,
      ts_builtin_sym_end,
    ACTIONS(678), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [8602] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(176), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(178), 1,
      anon_sym_DQUOTE,
    ACTIONS(180), 1,
      anon_sym_SQUOTE,
    ACTIONS(748), 1,
      sym_symbol,
    ACTIONS(750), 1,
      anon_sym_BANG,
    ACTIONS(752), 1,
      anon_sym_LPAREN,
    STATE(18), 1,
      aux_sym_name_repeat1,
    STATE(43), 1,
      sym_expression,
    STATE(31), 2,
      sym_macro_variable,
      sym_string,
    STATE(44), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8640] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      sym_symbol,
    ACTIONS(696), 1,
      anon_sym_BANG,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(133), 1,
      aux_sym_name_repeat1,
    STATE(244), 1,
      sym_expression,
    STATE(227), 2,
      sym_macro_variable,
      sym_string,
    STATE(246), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8678] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      sym_symbol,
    ACTIONS(696), 1,
      anon_sym_BANG,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(133), 1,
      aux_sym_name_repeat1,
    STATE(257), 1,
      sym_expression,
    STATE(227), 2,
      sym_macro_variable,
      sym_string,
    STATE(246), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8716] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 1,
      ts_builtin_sym_end,
    ACTIONS(654), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [8738] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      ts_builtin_sym_end,
    ACTIONS(692), 13,
      anon_sym_mainmenu,
      anon_sym_config,
      anon_sym_configdefault,
      anon_sym_menuconfig,
      anon_sym_choice,
      anon_sym_comment,
      anon_sym_menu,
      anon_sym_if,
      anon_sym_source,
      anon_sym_rsource,
      anon_sym_osource,
      anon_sym_orsource,
      sym_symbol,
  [8760] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(97), 1,
      anon_sym_DQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE,
    ACTIONS(718), 1,
      sym_symbol,
    ACTIONS(720), 1,
      anon_sym_BANG,
    ACTIONS(722), 1,
      anon_sym_LPAREN,
    STATE(10), 1,
      aux_sym_name_repeat1,
    STATE(34), 1,
      sym_expression,
    STATE(21), 2,
      sym_macro_variable,
      sym_string,
    STATE(37), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8798] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(706), 1,
      sym_symbol,
    ACTIONS(708), 1,
      anon_sym_BANG,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(115), 1,
      sym_expression,
    STATE(234), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8836] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 1,
      sym_symbol,
    ACTIONS(738), 1,
      anon_sym_BANG,
    ACTIONS(740), 1,
      anon_sym_LPAREN,
    ACTIONS(742), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(744), 1,
      anon_sym_DQUOTE,
    ACTIONS(746), 1,
      anon_sym_SQUOTE,
    STATE(124), 1,
      aux_sym_name_repeat1,
    STATE(154), 1,
      sym_expression,
    STATE(157), 2,
      sym_macro_variable,
      sym_string,
    STATE(153), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8874] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(176), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(178), 1,
      anon_sym_DQUOTE,
    ACTIONS(180), 1,
      anon_sym_SQUOTE,
    ACTIONS(748), 1,
      sym_symbol,
    ACTIONS(750), 1,
      anon_sym_BANG,
    ACTIONS(752), 1,
      anon_sym_LPAREN,
    STATE(18), 1,
      aux_sym_name_repeat1,
    STATE(45), 1,
      sym_expression,
    STATE(31), 2,
      sym_macro_variable,
      sym_string,
    STATE(44), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8912] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    ACTIONS(714), 1,
      sym_symbol,
    ACTIONS(716), 1,
      anon_sym_BANG,
    STATE(85), 1,
      sym_expression,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(113), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8950] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      sym_symbol,
    ACTIONS(696), 1,
      anon_sym_BANG,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(133), 1,
      aux_sym_name_repeat1,
    STATE(240), 1,
      sym_expression,
    STATE(227), 2,
      sym_macro_variable,
      sym_string,
    STATE(246), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [8988] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      sym_symbol,
    ACTIONS(696), 1,
      anon_sym_BANG,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(133), 1,
      aux_sym_name_repeat1,
    STATE(238), 1,
      sym_expression,
    STATE(227), 2,
      sym_macro_variable,
      sym_string,
    STATE(246), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [9026] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      sym_symbol,
    ACTIONS(696), 1,
      anon_sym_BANG,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(133), 1,
      aux_sym_name_repeat1,
    STATE(256), 1,
      sym_expression,
    STATE(227), 2,
      sym_macro_variable,
      sym_string,
    STATE(246), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [9064] = 4,
    ACTIONS(193), 1,
      aux_sym_type_definition_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(768), 4,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
    ACTIONS(190), 9,
      anon_sym_if,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9088] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(706), 1,
      sym_symbol,
    ACTIONS(708), 1,
      anon_sym_BANG,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(258), 1,
      sym_expression,
    STATE(234), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [9126] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      sym_symbol,
    ACTIONS(696), 1,
      anon_sym_BANG,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(133), 1,
      aux_sym_name_repeat1,
    STATE(235), 1,
      sym_expression,
    STATE(227), 2,
      sym_macro_variable,
      sym_string,
    STATE(246), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [9164] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(706), 1,
      sym_symbol,
    ACTIONS(708), 1,
      anon_sym_BANG,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(248), 1,
      sym_expression,
    STATE(234), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [9202] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 1,
      sym_symbol,
    ACTIONS(696), 1,
      anon_sym_BANG,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(133), 1,
      aux_sym_name_repeat1,
    STATE(236), 1,
      sym_expression,
    STATE(227), 2,
      sym_macro_variable,
      sym_string,
    STATE(246), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [9240] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(706), 1,
      sym_symbol,
    ACTIONS(708), 1,
      anon_sym_BANG,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    STATE(95), 1,
      aux_sym_name_repeat1,
    STATE(251), 1,
      sym_expression,
    STATE(234), 2,
      sym_macro_variable,
      sym_string,
    STATE(117), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [9278] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(176), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(178), 1,
      anon_sym_DQUOTE,
    ACTIONS(180), 1,
      anon_sym_SQUOTE,
    ACTIONS(748), 1,
      sym_symbol,
    ACTIONS(750), 1,
      anon_sym_BANG,
    ACTIONS(752), 1,
      anon_sym_LPAREN,
    STATE(18), 1,
      aux_sym_name_repeat1,
    STATE(46), 1,
      sym_expression,
    STATE(31), 2,
      sym_macro_variable,
      sym_string,
    STATE(44), 4,
      sym_unary_expression,
      sym_binary_expression,
      sym_parenthesized_expression,
      sym_name,
  [9316] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(190), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(196), 4,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_symbol,
    ACTIONS(193), 7,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_RPAREN,
  [9339] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(772), 1,
      anon_sym_EQ,
    ACTIONS(774), 1,
      aux_sym_type_definition_token1,
    ACTIONS(776), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(778), 1,
      anon_sym_AMP_AMP,
    STATE(379), 1,
      sym_conditional_clause,
    ACTIONS(780), 5,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9368] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(772), 1,
      anon_sym_EQ,
    ACTIONS(776), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(778), 1,
      anon_sym_AMP_AMP,
    ACTIONS(782), 1,
      aux_sym_type_definition_token1,
    STATE(366), 1,
      sym_conditional_clause,
    ACTIONS(780), 5,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9397] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(772), 1,
      anon_sym_EQ,
    ACTIONS(776), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(778), 1,
      anon_sym_AMP_AMP,
    ACTIONS(784), 1,
      aux_sym_type_definition_token1,
    STATE(365), 1,
      sym_conditional_clause,
    ACTIONS(780), 5,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9426] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(772), 1,
      anon_sym_EQ,
    ACTIONS(776), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(778), 1,
      anon_sym_AMP_AMP,
    ACTIONS(786), 1,
      aux_sym_type_definition_token1,
    STATE(375), 1,
      sym_conditional_clause,
    ACTIONS(780), 5,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9455] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(772), 1,
      anon_sym_EQ,
    ACTIONS(776), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(778), 1,
      anon_sym_AMP_AMP,
    ACTIONS(788), 1,
      aux_sym_type_definition_token1,
    STATE(358), 1,
      sym_conditional_clause,
    ACTIONS(780), 5,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9484] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(772), 1,
      anon_sym_EQ,
    ACTIONS(776), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(778), 1,
      anon_sym_AMP_AMP,
    ACTIONS(790), 1,
      aux_sym_type_definition_token1,
    STATE(373), 1,
      sym_conditional_clause,
    ACTIONS(780), 5,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9513] = 5,
    ACTIONS(279), 1,
      aux_sym_type_definition_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(772), 1,
      anon_sym_EQ,
    ACTIONS(277), 3,
      anon_sym_if,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(780), 5,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9535] = 4,
    ACTIONS(279), 1,
      aux_sym_type_definition_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(772), 1,
      anon_sym_EQ,
    ACTIONS(277), 8,
      anon_sym_if,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9555] = 6,
    ACTIONS(279), 1,
      aux_sym_type_definition_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(772), 1,
      anon_sym_EQ,
    ACTIONS(778), 1,
      anon_sym_AMP_AMP,
    ACTIONS(277), 2,
      anon_sym_if,
      anon_sym_PIPE_PIPE,
    ACTIONS(780), 5,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9579] = 3,
    ACTIONS(275), 1,
      aux_sym_type_definition_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(273), 9,
      anon_sym_if,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9597] = 3,
    ACTIONS(293), 1,
      aux_sym_type_definition_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(291), 9,
      anon_sym_if,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9615] = 3,
    ACTIONS(289), 1,
      aux_sym_type_definition_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(287), 9,
      anon_sym_if,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9633] = 3,
    ACTIONS(279), 1,
      aux_sym_type_definition_token1,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(277), 9,
      anon_sym_if,
      anon_sym_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9651] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 1,
      anon_sym_EQ,
    ACTIONS(794), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(796), 1,
      anon_sym_AMP_AMP,
    ACTIONS(802), 1,
      anon_sym_RPAREN,
    ACTIONS(800), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(798), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9676] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 1,
      anon_sym_EQ,
    ACTIONS(796), 1,
      anon_sym_AMP_AMP,
    ACTIONS(279), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_RPAREN,
    ACTIONS(800), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(798), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9699] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 1,
      anon_sym_EQ,
    ACTIONS(794), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(796), 1,
      anon_sym_AMP_AMP,
    ACTIONS(804), 1,
      anon_sym_RPAREN,
    ACTIONS(800), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(798), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9724] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 1,
      anon_sym_EQ,
    ACTIONS(794), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(796), 1,
      anon_sym_AMP_AMP,
    ACTIONS(806), 1,
      anon_sym_RPAREN,
    ACTIONS(800), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(798), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9749] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 1,
      anon_sym_EQ,
    ACTIONS(794), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(796), 1,
      anon_sym_AMP_AMP,
    ACTIONS(808), 1,
      anon_sym_RPAREN,
    ACTIONS(800), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(798), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9774] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 1,
      anon_sym_EQ,
    ACTIONS(277), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(279), 6,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_RPAREN,
  [9793] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 1,
      anon_sym_EQ,
    ACTIONS(800), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(279), 3,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_RPAREN,
    ACTIONS(798), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9814] = 6,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(772), 1,
      anon_sym_EQ,
    ACTIONS(776), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(778), 1,
      anon_sym_AMP_AMP,
    ACTIONS(810), 1,
      aux_sym_type_definition_token1,
    ACTIONS(780), 5,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9837] = 6,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(772), 1,
      anon_sym_EQ,
    ACTIONS(776), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(778), 1,
      anon_sym_AMP_AMP,
    ACTIONS(812), 1,
      aux_sym_type_definition_token1,
    ACTIONS(780), 5,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9860] = 6,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(772), 1,
      anon_sym_EQ,
    ACTIONS(776), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(778), 1,
      anon_sym_AMP_AMP,
    ACTIONS(814), 1,
      aux_sym_type_definition_token1,
    ACTIONS(780), 5,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9883] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 1,
      anon_sym_EQ,
    ACTIONS(794), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(796), 1,
      anon_sym_AMP_AMP,
    ACTIONS(816), 1,
      anon_sym_RPAREN,
    ACTIONS(800), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(798), 3,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9908] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_RPAREN,
    ACTIONS(820), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(822), 1,
      sym_macro_content,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      anon_sym_SQUOTE,
    STATE(319), 1,
      sym_string,
    STATE(261), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [9934] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_DQUOTE,
    ACTIONS(627), 1,
      anon_sym_SQUOTE,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(828), 1,
      aux_sym_type_definition_token1,
    ACTIONS(830), 1,
      anon_sym_prompt,
    STATE(369), 1,
      sym_conditional_clause,
    STATE(337), 2,
      sym_input_prompt,
      sym_string,
  [9960] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_RPAREN,
    ACTIONS(834), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(837), 1,
      sym_macro_content,
    ACTIONS(840), 1,
      anon_sym_DQUOTE,
    ACTIONS(843), 1,
      anon_sym_SQUOTE,
    STATE(319), 1,
      sym_string,
    STATE(261), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [9986] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      anon_sym_SQUOTE,
    ACTIONS(846), 1,
      anon_sym_RPAREN,
    ACTIONS(848), 1,
      sym_macro_content,
    STATE(319), 1,
      sym_string,
    STATE(268), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [10012] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(822), 1,
      sym_macro_content,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      anon_sym_SQUOTE,
    ACTIONS(850), 1,
      anon_sym_RPAREN,
    STATE(319), 1,
      sym_string,
    STATE(261), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [10038] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      anon_sym_SQUOTE,
    ACTIONS(852), 1,
      anon_sym_RPAREN,
    ACTIONS(854), 1,
      sym_macro_content,
    STATE(319), 1,
      sym_string,
    STATE(263), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [10064] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_DQUOTE,
    ACTIONS(627), 1,
      anon_sym_SQUOTE,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(830), 1,
      anon_sym_prompt,
    ACTIONS(856), 1,
      aux_sym_type_definition_token1,
    STATE(357), 1,
      sym_conditional_clause,
    STATE(354), 2,
      sym_input_prompt,
      sym_string,
  [10090] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(858), 1,
      sym_symbol,
    STATE(343), 1,
      sym_name,
    STATE(95), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
  [10114] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(97), 1,
      anon_sym_DQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE,
    ACTIONS(860), 1,
      sym_symbol,
    STATE(93), 1,
      sym_name,
    STATE(10), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
  [10138] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(822), 1,
      sym_macro_content,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      anon_sym_SQUOTE,
    ACTIONS(862), 1,
      anon_sym_RPAREN,
    STATE(319), 1,
      sym_string,
    STATE(261), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [10164] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    ACTIONS(864), 1,
      sym_symbol,
    STATE(329), 1,
      sym_name,
    STATE(133), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
  [10188] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      anon_sym_SQUOTE,
    ACTIONS(866), 1,
      anon_sym_RPAREN,
    ACTIONS(868), 1,
      sym_macro_content,
    STATE(319), 1,
      sym_string,
    STATE(271), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [10214] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(822), 1,
      sym_macro_content,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      anon_sym_SQUOTE,
    ACTIONS(870), 1,
      anon_sym_RPAREN,
    STATE(319), 1,
      sym_string,
    STATE(261), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [10240] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      anon_sym_SQUOTE,
    ACTIONS(872), 1,
      anon_sym_RPAREN,
    ACTIONS(874), 1,
      sym_macro_content,
    STATE(319), 1,
      sym_string,
    STATE(273), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [10266] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(822), 1,
      sym_macro_content,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      anon_sym_SQUOTE,
    ACTIONS(876), 1,
      anon_sym_RPAREN,
    STATE(319), 1,
      sym_string,
    STATE(261), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [10292] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      anon_sym_SQUOTE,
    ACTIONS(878), 1,
      anon_sym_RPAREN,
    ACTIONS(880), 1,
      sym_macro_content,
    STATE(319), 1,
      sym_string,
    STATE(275), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [10318] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(822), 1,
      sym_macro_content,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      anon_sym_SQUOTE,
    ACTIONS(882), 1,
      anon_sym_RPAREN,
    STATE(319), 1,
      sym_string,
    STATE(261), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [10344] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      anon_sym_SQUOTE,
    ACTIONS(884), 1,
      anon_sym_RPAREN,
    ACTIONS(886), 1,
      sym_macro_content,
    STATE(319), 1,
      sym_string,
    STATE(277), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [10370] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(822), 1,
      sym_macro_content,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      anon_sym_SQUOTE,
    ACTIONS(888), 1,
      anon_sym_RPAREN,
    STATE(319), 1,
      sym_string,
    STATE(261), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [10396] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      anon_sym_SQUOTE,
    ACTIONS(890), 1,
      anon_sym_RPAREN,
    ACTIONS(892), 1,
      sym_macro_content,
    STATE(319), 1,
      sym_string,
    STATE(279), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [10422] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(822), 1,
      sym_macro_content,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      anon_sym_SQUOTE,
    ACTIONS(894), 1,
      anon_sym_RPAREN,
    STATE(319), 1,
      sym_string,
    STATE(261), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [10448] = 8,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      anon_sym_SQUOTE,
    ACTIONS(896), 1,
      anon_sym_RPAREN,
    ACTIONS(898), 1,
      sym_macro_content,
    STATE(319), 1,
      sym_string,
    STATE(259), 2,
      sym_macro_variable,
      aux_sym_macro_variable_repeat1,
  [10474] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(97), 1,
      anon_sym_DQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE,
    ACTIONS(860), 1,
      sym_symbol,
    STATE(90), 1,
      sym_name,
    STATE(10), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
  [10498] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(858), 1,
      sym_symbol,
    STATE(331), 1,
      sym_name,
    STATE(95), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
  [10522] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(97), 1,
      anon_sym_DQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE,
    ACTIONS(860), 1,
      sym_symbol,
    STATE(92), 1,
      sym_name,
    STATE(10), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
  [10546] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    ACTIONS(864), 1,
      sym_symbol,
    STATE(334), 1,
      sym_name,
    STATE(133), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
  [10570] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(97), 1,
      anon_sym_DQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE,
    ACTIONS(860), 1,
      sym_symbol,
    STATE(91), 1,
      sym_name,
    STATE(10), 3,
      sym_macro_variable,
      sym_string,
      aux_sym_name_repeat1,
  [10594] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(900), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(903), 1,
      anon_sym_DQUOTE,
    ACTIONS(905), 2,
      aux_sym_string_token1,
      aux_sym_string_token2,
    STATE(286), 2,
      sym_macro_variable,
      aux_sym_string_repeat1,
  [10612] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(908), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(912), 1,
      anon_sym_SQUOTE,
    ACTIONS(910), 2,
      aux_sym_string_token2,
      aux_sym_string_token3,
    STATE(290), 2,
      sym_macro_variable,
      aux_sym_string_repeat2,
  [10630] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(908), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(916), 1,
      anon_sym_SQUOTE,
    ACTIONS(914), 2,
      aux_sym_string_token2,
      aux_sym_string_token3,
    STATE(314), 2,
      sym_macro_variable,
      aux_sym_string_repeat2,
  [10648] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(920), 1,
      anon_sym_DQUOTE,
    ACTIONS(922), 2,
      aux_sym_string_token1,
      aux_sym_string_token2,
    STATE(286), 2,
      sym_macro_variable,
      aux_sym_string_repeat1,
  [10666] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(908), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(920), 1,
      anon_sym_SQUOTE,
    ACTIONS(914), 2,
      aux_sym_string_token2,
      aux_sym_string_token3,
    STATE(314), 2,
      sym_macro_variable,
      aux_sym_string_repeat2,
  [10684] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(924), 1,
      anon_sym_DQUOTE,
    ACTIONS(926), 2,
      aux_sym_string_token1,
      aux_sym_string_token2,
    STATE(294), 2,
      sym_macro_variable,
      aux_sym_string_repeat1,
  [10702] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(908), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(924), 1,
      anon_sym_SQUOTE,
    ACTIONS(928), 2,
      aux_sym_string_token2,
      aux_sym_string_token3,
    STATE(295), 2,
      sym_macro_variable,
      aux_sym_string_repeat2,
  [10720] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(930), 1,
      anon_sym_DQUOTE,
    ACTIONS(932), 2,
      aux_sym_string_token1,
      aux_sym_string_token2,
    STATE(312), 2,
      sym_macro_variable,
      aux_sym_string_repeat1,
  [10738] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(934), 1,
      anon_sym_DQUOTE,
    ACTIONS(922), 2,
      aux_sym_string_token1,
      aux_sym_string_token2,
    STATE(286), 2,
      sym_macro_variable,
      aux_sym_string_repeat1,
  [10756] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(908), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(934), 1,
      anon_sym_SQUOTE,
    ACTIONS(914), 2,
      aux_sym_string_token2,
      aux_sym_string_token3,
    STATE(314), 2,
      sym_macro_variable,
      aux_sym_string_repeat2,
  [10774] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    ACTIONS(938), 2,
      aux_sym_string_token1,
      aux_sym_string_token2,
    STATE(308), 2,
      sym_macro_variable,
      aux_sym_string_repeat1,
  [10792] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(940), 1,
      anon_sym_DQUOTE,
    ACTIONS(942), 2,
      aux_sym_string_token1,
      aux_sym_string_token2,
    STATE(299), 2,
      sym_macro_variable,
      aux_sym_string_repeat1,
  [10810] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(908), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(940), 1,
      anon_sym_SQUOTE,
    ACTIONS(944), 2,
      aux_sym_string_token2,
      aux_sym_string_token3,
    STATE(300), 2,
      sym_macro_variable,
      aux_sym_string_repeat2,
  [10828] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(946), 1,
      anon_sym_DQUOTE,
    ACTIONS(922), 2,
      aux_sym_string_token1,
      aux_sym_string_token2,
    STATE(286), 2,
      sym_macro_variable,
      aux_sym_string_repeat1,
  [10846] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(908), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(946), 1,
      anon_sym_SQUOTE,
    ACTIONS(914), 2,
      aux_sym_string_token2,
      aux_sym_string_token3,
    STATE(314), 2,
      sym_macro_variable,
      aux_sym_string_repeat2,
  [10864] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(948), 1,
      anon_sym_DQUOTE,
    ACTIONS(950), 2,
      aux_sym_string_token1,
      aux_sym_string_token2,
    STATE(304), 2,
      sym_macro_variable,
      aux_sym_string_repeat1,
  [10882] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(908), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(948), 1,
      anon_sym_SQUOTE,
    ACTIONS(952), 2,
      aux_sym_string_token2,
      aux_sym_string_token3,
    STATE(305), 2,
      sym_macro_variable,
      aux_sym_string_repeat2,
  [10900] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(954), 1,
      anon_sym_DQUOTE,
    ACTIONS(956), 2,
      aux_sym_string_token1,
      aux_sym_string_token2,
    STATE(309), 2,
      sym_macro_variable,
      aux_sym_string_repeat1,
  [10918] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(958), 1,
      anon_sym_DQUOTE,
    ACTIONS(922), 2,
      aux_sym_string_token1,
      aux_sym_string_token2,
    STATE(286), 2,
      sym_macro_variable,
      aux_sym_string_repeat1,
  [10936] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(908), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(958), 1,
      anon_sym_SQUOTE,
    ACTIONS(914), 2,
      aux_sym_string_token2,
      aux_sym_string_token3,
    STATE(314), 2,
      sym_macro_variable,
      aux_sym_string_repeat2,
  [10954] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(908), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(954), 1,
      anon_sym_SQUOTE,
    ACTIONS(960), 2,
      aux_sym_string_token2,
      aux_sym_string_token3,
    STATE(310), 2,
      sym_macro_variable,
      aux_sym_string_repeat2,
  [10972] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(908), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(930), 1,
      anon_sym_SQUOTE,
    ACTIONS(962), 2,
      aux_sym_string_token2,
      aux_sym_string_token3,
    STATE(288), 2,
      sym_macro_variable,
      aux_sym_string_repeat2,
  [10990] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(964), 1,
      anon_sym_DQUOTE,
    ACTIONS(922), 2,
      aux_sym_string_token1,
      aux_sym_string_token2,
    STATE(286), 2,
      sym_macro_variable,
      aux_sym_string_repeat1,
  [11008] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(918), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(966), 1,
      anon_sym_DQUOTE,
    ACTIONS(922), 2,
      aux_sym_string_token1,
      aux_sym_string_token2,
    STATE(286), 2,
      sym_macro_variable,
      aux_sym_string_repeat1,
  [11026] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(908), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(966), 1,
      anon_sym_SQUOTE,
    ACTIONS(914), 2,
      aux_sym_string_token2,
      aux_sym_string_token3,
    STATE(314), 2,
      sym_macro_variable,
      aux_sym_string_repeat2,
  [11044] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(908), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(964), 1,
      anon_sym_SQUOTE,
    ACTIONS(914), 2,
      aux_sym_string_token2,
      aux_sym_string_token3,
    STATE(314), 2,
      sym_macro_variable,
      aux_sym_string_repeat2,
  [11062] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(916), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(922), 2,
      aux_sym_string_token1,
      aux_sym_string_token2,
    STATE(286), 2,
      sym_macro_variable,
      aux_sym_string_repeat1,
  [11080] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(908), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(936), 1,
      anon_sym_SQUOTE,
    ACTIONS(968), 2,
      aux_sym_string_token2,
      aux_sym_string_token3,
    STATE(311), 2,
      sym_macro_variable,
      aux_sym_string_repeat2,
  [11098] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(970), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(976), 1,
      anon_sym_SQUOTE,
    ACTIONS(973), 2,
      aux_sym_string_token2,
      aux_sym_string_token3,
    STATE(314), 2,
      sym_macro_variable,
      aux_sym_string_repeat2,
  [11116] = 5,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(978), 2,
      aux_sym_string_token1,
      aux_sym_string_token2,
    STATE(289), 2,
      sym_macro_variable,
      aux_sym_string_repeat1,
  [11134] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(202), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_LPAREN,
      sym_macro_content,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [11145] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(182), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_LPAREN,
      sym_macro_content,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [11156] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(186), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_LPAREN,
      sym_macro_content,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [11167] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(980), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_LPAREN,
      sym_macro_content,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [11178] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(198), 5,
      anon_sym_RPAREN,
      anon_sym_DOLLAR_LPAREN,
      sym_macro_content,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [11189] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 4,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_QMARK_EQ,
  [11199] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 4,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_QMARK_EQ,
  [11209] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(202), 4,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      aux_sym_string_token1,
      aux_sym_string_token2,
  [11219] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(186), 4,
      anon_sym_DOLLAR_LPAREN,
      aux_sym_string_token2,
      anon_sym_SQUOTE,
      aux_sym_string_token3,
  [11229] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(202), 4,
      anon_sym_DOLLAR_LPAREN,
      aux_sym_string_token2,
      anon_sym_SQUOTE,
      aux_sym_string_token3,
  [11239] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(186), 4,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_DQUOTE,
      aux_sym_string_token1,
      aux_sym_string_token2,
  [11249] = 4,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(986), 1,
      aux_sym_type_definition_token1,
    STATE(361), 1,
      sym_conditional_clause,
  [11262] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(988), 1,
      sym_symbol,
    STATE(350), 1,
      sym_macro_variable,
  [11275] = 4,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(990), 1,
      aux_sym_type_definition_token1,
    STATE(378), 1,
      sym_conditional_clause,
  [11288] = 4,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(992), 1,
      aux_sym_type_definition_token1,
    STATE(371), 1,
      sym_conditional_clause,
  [11301] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(994), 1,
      anon_sym_default,
    STATE(121), 2,
      sym_default_value,
      aux_sym_configdefault_repeat1,
  [11312] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(178), 1,
      anon_sym_DQUOTE,
    ACTIONS(180), 1,
      anon_sym_SQUOTE,
    STATE(28), 1,
      sym_string,
  [11325] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    STATE(137), 1,
      sym_string,
  [11338] = 4,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(996), 1,
      aux_sym_type_definition_token1,
    STATE(376), 1,
      sym_conditional_clause,
  [11351] = 4,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(998), 1,
      aux_sym_type_definition_token1,
    STATE(380), 1,
      sym_conditional_clause,
  [11364] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 1,
      anon_sym_DQUOTE,
    ACTIONS(1002), 1,
      anon_sym_SQUOTE,
    STATE(209), 1,
      sym_string,
  [11377] = 4,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(1004), 1,
      aux_sym_type_definition_token1,
    STATE(382), 1,
      sym_conditional_clause,
  [11390] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      anon_sym_DQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE,
    STATE(13), 1,
      sym_string,
  [11403] = 4,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(1006), 1,
      aux_sym_type_definition_token1,
    STATE(359), 1,
      sym_conditional_clause,
  [11416] = 4,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(1008), 1,
      aux_sym_type_definition_token1,
    STATE(364), 1,
      sym_conditional_clause,
  [11429] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    STATE(139), 1,
      sym_string,
  [11442] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1010), 1,
      sym_symbol,
    STATE(349), 1,
      sym_macro_variable,
  [11455] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 1,
      anon_sym_default,
    STATE(128), 2,
      sym_default_value,
      aux_sym_configdefault_repeat1,
  [11466] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      anon_sym_DQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE,
    STATE(6), 1,
      sym_string,
  [11479] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(340), 1,
      sym_string,
  [11492] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(330), 1,
      sym_string,
  [11505] = 4,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(1014), 1,
      aux_sym_type_definition_token1,
    STATE(362), 1,
      sym_conditional_clause,
  [11518] = 4,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(1016), 1,
      aux_sym_type_definition_token1,
    STATE(377), 1,
      sym_conditional_clause,
  [11531] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1018), 1,
      sym_symbol,
    STATE(327), 1,
      sym_macro_variable,
  [11544] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1020), 1,
      sym_symbol,
    STATE(339), 1,
      sym_macro_variable,
  [11557] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_SQUOTE,
    STATE(348), 1,
      sym_string,
  [11570] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 1,
      anon_sym_DQUOTE,
    ACTIONS(1002), 1,
      anon_sym_SQUOTE,
    STATE(183), 1,
      sym_string,
  [11583] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      anon_sym_DQUOTE,
    ACTIONS(99), 1,
      anon_sym_SQUOTE,
    STATE(2), 1,
      sym_string,
  [11596] = 4,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_if,
    ACTIONS(1022), 1,
      aux_sym_type_definition_token1,
    STATE(370), 1,
      sym_conditional_clause,
  [11609] = 3,
    ACTIONS(335), 1,
      anon_sym_if,
    ACTIONS(337), 1,
      aux_sym_type_definition_token1,
    ACTIONS(568), 1,
      sym_comment,
  [11619] = 3,
    ACTIONS(375), 1,
      anon_sym_if,
    ACTIONS(377), 1,
      aux_sym_type_definition_token1,
    ACTIONS(568), 1,
      sym_comment,
  [11629] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1022), 1,
      aux_sym_type_definition_token1,
  [11636] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1024), 1,
      aux_sym_type_definition_token1,
  [11643] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1026), 1,
      aux_sym_type_definition_token1,
  [11650] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      sym__help_text,
  [11657] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1030), 1,
      aux_sym_type_definition_token1,
  [11664] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1032), 1,
      aux_sym_type_definition_token1,
  [11671] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1034), 1,
      aux_sym_variable_token1,
  [11678] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1036), 1,
      aux_sym_type_definition_token1,
  [11685] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1038), 1,
      aux_sym_type_definition_token1,
  [11692] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1040), 1,
      aux_sym_type_definition_token1,
  [11699] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1042), 1,
      ts_builtin_sym_end,
  [11706] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1044), 1,
      aux_sym_variable_token1,
  [11713] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1004), 1,
      aux_sym_type_definition_token1,
  [11720] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1046), 1,
      aux_sym_type_definition_token1,
  [11727] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1048), 1,
      aux_sym_type_definition_token1,
  [11734] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1050), 1,
      sym_symbol,
  [11741] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1052), 1,
      aux_sym_type_definition_token1,
  [11748] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1054), 1,
      sym_symbol,
  [11755] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1056), 1,
      aux_sym_type_definition_token1,
  [11762] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1058), 1,
      aux_sym_type_definition_token1,
  [11769] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1060), 1,
      aux_sym_type_definition_token1,
  [11776] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1062), 1,
      aux_sym_type_definition_token1,
  [11783] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1064), 1,
      aux_sym_type_definition_token1,
  [11790] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1066), 1,
      aux_sym_type_definition_token1,
  [11797] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1068), 1,
      sym__help_text,
  [11804] = 2,
    ACTIONS(568), 1,
      sym_comment,
    ACTIONS(1070), 1,
      aux_sym_type_definition_token1,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(10)] = 0,
  [SMALL_STATE(11)] = 68,
  [SMALL_STATE(12)] = 136,
  [SMALL_STATE(13)] = 214,
  [SMALL_STATE(14)] = 292,
  [SMALL_STATE(15)] = 370,
  [SMALL_STATE(16)] = 448,
  [SMALL_STATE(17)] = 514,
  [SMALL_STATE(18)] = 592,
  [SMALL_STATE(19)] = 658,
  [SMALL_STATE(20)] = 713,
  [SMALL_STATE(21)] = 768,
  [SMALL_STATE(22)] = 825,
  [SMALL_STATE(23)] = 880,
  [SMALL_STATE(24)] = 935,
  [SMALL_STATE(25)] = 1013,
  [SMALL_STATE(26)] = 1091,
  [SMALL_STATE(27)] = 1169,
  [SMALL_STATE(28)] = 1247,
  [SMALL_STATE(29)] = 1325,
  [SMALL_STATE(30)] = 1378,
  [SMALL_STATE(31)] = 1431,
  [SMALL_STATE(32)] = 1486,
  [SMALL_STATE(33)] = 1539,
  [SMALL_STATE(34)] = 1592,
  [SMALL_STATE(35)] = 1644,
  [SMALL_STATE(36)] = 1696,
  [SMALL_STATE(37)] = 1754,
  [SMALL_STATE(38)] = 1806,
  [SMALL_STATE(39)] = 1858,
  [SMALL_STATE(40)] = 1912,
  [SMALL_STATE(41)] = 1972,
  [SMALL_STATE(42)] = 2034,
  [SMALL_STATE(43)] = 2084,
  [SMALL_STATE(44)] = 2144,
  [SMALL_STATE(45)] = 2194,
  [SMALL_STATE(46)] = 2244,
  [SMALL_STATE(47)] = 2302,
  [SMALL_STATE(48)] = 2352,
  [SMALL_STATE(49)] = 2408,
  [SMALL_STATE(50)] = 2460,
  [SMALL_STATE(51)] = 2540,
  [SMALL_STATE(52)] = 2620,
  [SMALL_STATE(53)] = 2664,
  [SMALL_STATE(54)] = 2708,
  [SMALL_STATE(55)] = 2752,
  [SMALL_STATE(56)] = 2796,
  [SMALL_STATE(57)] = 2840,
  [SMALL_STATE(58)] = 2884,
  [SMALL_STATE(59)] = 2928,
  [SMALL_STATE(60)] = 2972,
  [SMALL_STATE(61)] = 3016,
  [SMALL_STATE(62)] = 3060,
  [SMALL_STATE(63)] = 3104,
  [SMALL_STATE(64)] = 3148,
  [SMALL_STATE(65)] = 3192,
  [SMALL_STATE(66)] = 3236,
  [SMALL_STATE(67)] = 3280,
  [SMALL_STATE(68)] = 3324,
  [SMALL_STATE(69)] = 3368,
  [SMALL_STATE(70)] = 3410,
  [SMALL_STATE(71)] = 3452,
  [SMALL_STATE(72)] = 3494,
  [SMALL_STATE(73)] = 3536,
  [SMALL_STATE(74)] = 3578,
  [SMALL_STATE(75)] = 3620,
  [SMALL_STATE(76)] = 3662,
  [SMALL_STATE(77)] = 3704,
  [SMALL_STATE(78)] = 3746,
  [SMALL_STATE(79)] = 3788,
  [SMALL_STATE(80)] = 3830,
  [SMALL_STATE(81)] = 3872,
  [SMALL_STATE(82)] = 3914,
  [SMALL_STATE(83)] = 3956,
  [SMALL_STATE(84)] = 3998,
  [SMALL_STATE(85)] = 4040,
  [SMALL_STATE(86)] = 4112,
  [SMALL_STATE(87)] = 4184,
  [SMALL_STATE(88)] = 4226,
  [SMALL_STATE(89)] = 4286,
  [SMALL_STATE(90)] = 4346,
  [SMALL_STATE(91)] = 4406,
  [SMALL_STATE(92)] = 4466,
  [SMALL_STATE(93)] = 4526,
  [SMALL_STATE(94)] = 4586,
  [SMALL_STATE(95)] = 4634,
  [SMALL_STATE(96)] = 4682,
  [SMALL_STATE(97)] = 4719,
  [SMALL_STATE(98)] = 4756,
  [SMALL_STATE(99)] = 4812,
  [SMALL_STATE(100)] = 4847,
  [SMALL_STATE(101)] = 4882,
  [SMALL_STATE(102)] = 4936,
  [SMALL_STATE(103)] = 4990,
  [SMALL_STATE(104)] = 5044,
  [SMALL_STATE(105)] = 5098,
  [SMALL_STATE(106)] = 5152,
  [SMALL_STATE(107)] = 5206,
  [SMALL_STATE(108)] = 5260,
  [SMALL_STATE(109)] = 5314,
  [SMALL_STATE(110)] = 5368,
  [SMALL_STATE(111)] = 5422,
  [SMALL_STATE(112)] = 5476,
  [SMALL_STATE(113)] = 5530,
  [SMALL_STATE(114)] = 5565,
  [SMALL_STATE(115)] = 5596,
  [SMALL_STATE(116)] = 5627,
  [SMALL_STATE(117)] = 5658,
  [SMALL_STATE(118)] = 5689,
  [SMALL_STATE(119)] = 5727,
  [SMALL_STATE(120)] = 5763,
  [SMALL_STATE(121)] = 5795,
  [SMALL_STATE(122)] = 5824,
  [SMALL_STATE(123)] = 5853,
  [SMALL_STATE(124)] = 5890,
  [SMALL_STATE(125)] = 5927,
  [SMALL_STATE(126)] = 5977,
  [SMALL_STATE(127)] = 6027,
  [SMALL_STATE(128)] = 6056,
  [SMALL_STATE(129)] = 6085,
  [SMALL_STATE(130)] = 6108,
  [SMALL_STATE(131)] = 6143,
  [SMALL_STATE(132)] = 6166,
  [SMALL_STATE(133)] = 6213,
  [SMALL_STATE(134)] = 6248,
  [SMALL_STATE(135)] = 6295,
  [SMALL_STATE(136)] = 6342,
  [SMALL_STATE(137)] = 6364,
  [SMALL_STATE(138)] = 6386,
  [SMALL_STATE(139)] = 6408,
  [SMALL_STATE(140)] = 6430,
  [SMALL_STATE(141)] = 6452,
  [SMALL_STATE(142)] = 6474,
  [SMALL_STATE(143)] = 6496,
  [SMALL_STATE(144)] = 6518,
  [SMALL_STATE(145)] = 6540,
  [SMALL_STATE(146)] = 6562,
  [SMALL_STATE(147)] = 6584,
  [SMALL_STATE(148)] = 6606,
  [SMALL_STATE(149)] = 6628,
  [SMALL_STATE(150)] = 6660,
  [SMALL_STATE(151)] = 6682,
  [SMALL_STATE(152)] = 6706,
  [SMALL_STATE(153)] = 6730,
  [SMALL_STATE(154)] = 6754,
  [SMALL_STATE(155)] = 6778,
  [SMALL_STATE(156)] = 6802,
  [SMALL_STATE(157)] = 6826,
  [SMALL_STATE(158)] = 6850,
  [SMALL_STATE(159)] = 6880,
  [SMALL_STATE(160)] = 6908,
  [SMALL_STATE(161)] = 6934,
  [SMALL_STATE(162)] = 6958,
  [SMALL_STATE(163)] = 6982,
  [SMALL_STATE(164)] = 7005,
  [SMALL_STATE(165)] = 7028,
  [SMALL_STATE(166)] = 7066,
  [SMALL_STATE(167)] = 7104,
  [SMALL_STATE(168)] = 7142,
  [SMALL_STATE(169)] = 7180,
  [SMALL_STATE(170)] = 7218,
  [SMALL_STATE(171)] = 7240,
  [SMALL_STATE(172)] = 7278,
  [SMALL_STATE(173)] = 7300,
  [SMALL_STATE(174)] = 7338,
  [SMALL_STATE(175)] = 7376,
  [SMALL_STATE(176)] = 7414,
  [SMALL_STATE(177)] = 7452,
  [SMALL_STATE(178)] = 7490,
  [SMALL_STATE(179)] = 7528,
  [SMALL_STATE(180)] = 7566,
  [SMALL_STATE(181)] = 7604,
  [SMALL_STATE(182)] = 7626,
  [SMALL_STATE(183)] = 7664,
  [SMALL_STATE(184)] = 7686,
  [SMALL_STATE(185)] = 7724,
  [SMALL_STATE(186)] = 7762,
  [SMALL_STATE(187)] = 7800,
  [SMALL_STATE(188)] = 7838,
  [SMALL_STATE(189)] = 7860,
  [SMALL_STATE(190)] = 7898,
  [SMALL_STATE(191)] = 7920,
  [SMALL_STATE(192)] = 7958,
  [SMALL_STATE(193)] = 7980,
  [SMALL_STATE(194)] = 8002,
  [SMALL_STATE(195)] = 8040,
  [SMALL_STATE(196)] = 8078,
  [SMALL_STATE(197)] = 8116,
  [SMALL_STATE(198)] = 8154,
  [SMALL_STATE(199)] = 8176,
  [SMALL_STATE(200)] = 8214,
  [SMALL_STATE(201)] = 8252,
  [SMALL_STATE(202)] = 8290,
  [SMALL_STATE(203)] = 8312,
  [SMALL_STATE(204)] = 8334,
  [SMALL_STATE(205)] = 8372,
  [SMALL_STATE(206)] = 8410,
  [SMALL_STATE(207)] = 8448,
  [SMALL_STATE(208)] = 8470,
  [SMALL_STATE(209)] = 8492,
  [SMALL_STATE(210)] = 8514,
  [SMALL_STATE(211)] = 8536,
  [SMALL_STATE(212)] = 8558,
  [SMALL_STATE(213)] = 8580,
  [SMALL_STATE(214)] = 8602,
  [SMALL_STATE(215)] = 8640,
  [SMALL_STATE(216)] = 8678,
  [SMALL_STATE(217)] = 8716,
  [SMALL_STATE(218)] = 8738,
  [SMALL_STATE(219)] = 8760,
  [SMALL_STATE(220)] = 8798,
  [SMALL_STATE(221)] = 8836,
  [SMALL_STATE(222)] = 8874,
  [SMALL_STATE(223)] = 8912,
  [SMALL_STATE(224)] = 8950,
  [SMALL_STATE(225)] = 8988,
  [SMALL_STATE(226)] = 9026,
  [SMALL_STATE(227)] = 9064,
  [SMALL_STATE(228)] = 9088,
  [SMALL_STATE(229)] = 9126,
  [SMALL_STATE(230)] = 9164,
  [SMALL_STATE(231)] = 9202,
  [SMALL_STATE(232)] = 9240,
  [SMALL_STATE(233)] = 9278,
  [SMALL_STATE(234)] = 9316,
  [SMALL_STATE(235)] = 9339,
  [SMALL_STATE(236)] = 9368,
  [SMALL_STATE(237)] = 9397,
  [SMALL_STATE(238)] = 9426,
  [SMALL_STATE(239)] = 9455,
  [SMALL_STATE(240)] = 9484,
  [SMALL_STATE(241)] = 9513,
  [SMALL_STATE(242)] = 9535,
  [SMALL_STATE(243)] = 9555,
  [SMALL_STATE(244)] = 9579,
  [SMALL_STATE(245)] = 9597,
  [SMALL_STATE(246)] = 9615,
  [SMALL_STATE(247)] = 9633,
  [SMALL_STATE(248)] = 9651,
  [SMALL_STATE(249)] = 9676,
  [SMALL_STATE(250)] = 9699,
  [SMALL_STATE(251)] = 9724,
  [SMALL_STATE(252)] = 9749,
  [SMALL_STATE(253)] = 9774,
  [SMALL_STATE(254)] = 9793,
  [SMALL_STATE(255)] = 9814,
  [SMALL_STATE(256)] = 9837,
  [SMALL_STATE(257)] = 9860,
  [SMALL_STATE(258)] = 9883,
  [SMALL_STATE(259)] = 9908,
  [SMALL_STATE(260)] = 9934,
  [SMALL_STATE(261)] = 9960,
  [SMALL_STATE(262)] = 9986,
  [SMALL_STATE(263)] = 10012,
  [SMALL_STATE(264)] = 10038,
  [SMALL_STATE(265)] = 10064,
  [SMALL_STATE(266)] = 10090,
  [SMALL_STATE(267)] = 10114,
  [SMALL_STATE(268)] = 10138,
  [SMALL_STATE(269)] = 10164,
  [SMALL_STATE(270)] = 10188,
  [SMALL_STATE(271)] = 10214,
  [SMALL_STATE(272)] = 10240,
  [SMALL_STATE(273)] = 10266,
  [SMALL_STATE(274)] = 10292,
  [SMALL_STATE(275)] = 10318,
  [SMALL_STATE(276)] = 10344,
  [SMALL_STATE(277)] = 10370,
  [SMALL_STATE(278)] = 10396,
  [SMALL_STATE(279)] = 10422,
  [SMALL_STATE(280)] = 10448,
  [SMALL_STATE(281)] = 10474,
  [SMALL_STATE(282)] = 10498,
  [SMALL_STATE(283)] = 10522,
  [SMALL_STATE(284)] = 10546,
  [SMALL_STATE(285)] = 10570,
  [SMALL_STATE(286)] = 10594,
  [SMALL_STATE(287)] = 10612,
  [SMALL_STATE(288)] = 10630,
  [SMALL_STATE(289)] = 10648,
  [SMALL_STATE(290)] = 10666,
  [SMALL_STATE(291)] = 10684,
  [SMALL_STATE(292)] = 10702,
  [SMALL_STATE(293)] = 10720,
  [SMALL_STATE(294)] = 10738,
  [SMALL_STATE(295)] = 10756,
  [SMALL_STATE(296)] = 10774,
  [SMALL_STATE(297)] = 10792,
  [SMALL_STATE(298)] = 10810,
  [SMALL_STATE(299)] = 10828,
  [SMALL_STATE(300)] = 10846,
  [SMALL_STATE(301)] = 10864,
  [SMALL_STATE(302)] = 10882,
  [SMALL_STATE(303)] = 10900,
  [SMALL_STATE(304)] = 10918,
  [SMALL_STATE(305)] = 10936,
  [SMALL_STATE(306)] = 10954,
  [SMALL_STATE(307)] = 10972,
  [SMALL_STATE(308)] = 10990,
  [SMALL_STATE(309)] = 11008,
  [SMALL_STATE(310)] = 11026,
  [SMALL_STATE(311)] = 11044,
  [SMALL_STATE(312)] = 11062,
  [SMALL_STATE(313)] = 11080,
  [SMALL_STATE(314)] = 11098,
  [SMALL_STATE(315)] = 11116,
  [SMALL_STATE(316)] = 11134,
  [SMALL_STATE(317)] = 11145,
  [SMALL_STATE(318)] = 11156,
  [SMALL_STATE(319)] = 11167,
  [SMALL_STATE(320)] = 11178,
  [SMALL_STATE(321)] = 11189,
  [SMALL_STATE(322)] = 11199,
  [SMALL_STATE(323)] = 11209,
  [SMALL_STATE(324)] = 11219,
  [SMALL_STATE(325)] = 11229,
  [SMALL_STATE(326)] = 11239,
  [SMALL_STATE(327)] = 11249,
  [SMALL_STATE(328)] = 11262,
  [SMALL_STATE(329)] = 11275,
  [SMALL_STATE(330)] = 11288,
  [SMALL_STATE(331)] = 11301,
  [SMALL_STATE(332)] = 11312,
  [SMALL_STATE(333)] = 11325,
  [SMALL_STATE(334)] = 11338,
  [SMALL_STATE(335)] = 11351,
  [SMALL_STATE(336)] = 11364,
  [SMALL_STATE(337)] = 11377,
  [SMALL_STATE(338)] = 11390,
  [SMALL_STATE(339)] = 11403,
  [SMALL_STATE(340)] = 11416,
  [SMALL_STATE(341)] = 11429,
  [SMALL_STATE(342)] = 11442,
  [SMALL_STATE(343)] = 11455,
  [SMALL_STATE(344)] = 11466,
  [SMALL_STATE(345)] = 11479,
  [SMALL_STATE(346)] = 11492,
  [SMALL_STATE(347)] = 11505,
  [SMALL_STATE(348)] = 11518,
  [SMALL_STATE(349)] = 11531,
  [SMALL_STATE(350)] = 11544,
  [SMALL_STATE(351)] = 11557,
  [SMALL_STATE(352)] = 11570,
  [SMALL_STATE(353)] = 11583,
  [SMALL_STATE(354)] = 11596,
  [SMALL_STATE(355)] = 11609,
  [SMALL_STATE(356)] = 11619,
  [SMALL_STATE(357)] = 11629,
  [SMALL_STATE(358)] = 11636,
  [SMALL_STATE(359)] = 11643,
  [SMALL_STATE(360)] = 11650,
  [SMALL_STATE(361)] = 11657,
  [SMALL_STATE(362)] = 11664,
  [SMALL_STATE(363)] = 11671,
  [SMALL_STATE(364)] = 11678,
  [SMALL_STATE(365)] = 11685,
  [SMALL_STATE(366)] = 11692,
  [SMALL_STATE(367)] = 11699,
  [SMALL_STATE(368)] = 11706,
  [SMALL_STATE(369)] = 11713,
  [SMALL_STATE(370)] = 11720,
  [SMALL_STATE(371)] = 11727,
  [SMALL_STATE(372)] = 11734,
  [SMALL_STATE(373)] = 11741,
  [SMALL_STATE(374)] = 11748,
  [SMALL_STATE(375)] = 11755,
  [SMALL_STATE(376)] = 11762,
  [SMALL_STATE(377)] = 11769,
  [SMALL_STATE(378)] = 11776,
  [SMALL_STATE(379)] = 11783,
  [SMALL_STATE(380)] = 11790,
  [SMALL_STATE(381)] = 11797,
  [SMALL_STATE(382)] = 11804,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_configuration, 0, 0, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(322),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(336),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(285),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(266),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(267),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(50),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(332),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(353),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(352),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(321),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(333),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(281),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(282),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(283),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(338),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(344),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(223),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(341),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(260),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(345),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(269),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(374),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(381),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(211),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(12),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(190),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(140),
  [81] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [83] = {.entry = {.count = 1, .reusable = false}}, SHIFT(138),
  [85] = {.entry = {.count = 1, .reusable = false}}, SHIFT(143),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [89] = {.entry = {.count = 1, .reusable = false}}, SHIFT(11),
  [91] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_name, 1, -1, 0),
  [93] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_name, 1, -1, 0),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [101] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(11),
  [104] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0),
  [106] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0),
  [108] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(264),
  [111] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(293),
  [114] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(307),
  [117] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0),
  [119] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(260),
  [122] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(345),
  [125] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(201),
  [128] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(167),
  [131] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(165),
  [134] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(269),
  [137] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(374),
  [140] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(182),
  [143] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(342),
  [146] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(381),
  [149] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(12),
  [152] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comment_entry, 2, 0, 1),
  [154] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [156] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_config, 3, 0, 1),
  [158] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_menuconfig, 3, 0, 1),
  [160] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(16),
  [163] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(280),
  [166] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(315),
  [169] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(287),
  [172] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comment_entry, 3, 0, 1),
  [174] = {.entry = {.count = 1, .reusable = false}}, SHIFT(16),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [182] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, 0, 0),
  [184] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, 0, 0),
  [186] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_variable, 3, 0, 0),
  [188] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_variable, 3, 0, 0),
  [190] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_expression, 1, 0, 0), REDUCE(aux_sym_name_repeat1, 1, 0, 0),
  [193] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_expression, 1, 0, 0), REDUCE(aux_sym_name_repeat1, 1, 0, 0),
  [196] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_name_repeat1, 1, 0, 0),
  [198] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, 0, 0),
  [200] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 0),
  [202] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_variable, 2, 0, 0),
  [204] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_variable, 2, 0, 0),
  [206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0),
  [208] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(265),
  [211] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(346),
  [214] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(224),
  [217] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(225),
  [220] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(226),
  [223] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(284),
  [226] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(372),
  [229] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(214),
  [232] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(328),
  [235] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(360),
  [238] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_config_repeat1, 2, 0, 0), SHIFT_REPEAT(24),
  [241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_config, 3, 0, 1),
  [243] = {.entry = {.count = 1, .reusable = false}}, SHIFT(265),
  [245] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [247] = {.entry = {.count = 1, .reusable = false}}, SHIFT(224),
  [249] = {.entry = {.count = 1, .reusable = false}}, SHIFT(225),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [253] = {.entry = {.count = 1, .reusable = false}}, SHIFT(284),
  [255] = {.entry = {.count = 1, .reusable = false}}, SHIFT(372),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [259] = {.entry = {.count = 1, .reusable = false}}, SHIFT(328),
  [261] = {.entry = {.count = 1, .reusable = false}}, SHIFT(360),
  [263] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [265] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_menuconfig, 3, 0, 1),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment_entry, 3, 0, 1),
  [269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment_entry, 2, 0, 1),
  [271] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [273] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, 0, 0),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, 0, 0),
  [277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, 0, 6),
  [279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, 0, 6),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [285] = {.entry = {.count = 1, .reusable = false}}, SHIFT(179),
  [287] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 1, 0, 0),
  [289] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 1, 0, 0),
  [291] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3, 0, 0),
  [293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3, 0, 0),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [297] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_limiting_menu_display, 2, 0, 0),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_limiting_menu_display, 2, 0, 0),
  [301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [311] = {.entry = {.count = 1, .reusable = false}}, SHIFT(206),
  [313] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [315] = {.entry = {.count = 1, .reusable = false}}, SHIFT(3),
  [317] = {.entry = {.count = 1, .reusable = false}}, SHIFT(7),
  [319] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_weak_reverse_dependencies, 4, 0, 0),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_weak_reverse_dependencies, 4, 0, 0),
  [323] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_definition_default, 3, 0, 0),
  [325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_definition_default, 3, 0, 0),
  [327] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_numerical_ranges, 5, 0, 0),
  [329] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_numerical_ranges, 5, 0, 0),
  [331] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_definition, 4, 0, 0),
  [333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_definition, 4, 0, 0),
  [335] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_input_prompt, 4, 0, 0),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_input_prompt, 4, 0, 0),
  [339] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_default_value, 4, 0, 0),
  [341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_default_value, 4, 0, 0),
  [343] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_reverse_dependencies, 3, 0, 0),
  [345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reverse_dependencies, 3, 0, 0),
  [347] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_definition_default, 4, 0, 0),
  [349] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_definition_default, 4, 0, 0),
  [351] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_help_text, 2, 0, 0),
  [353] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_help_text, 2, 0, 0),
  [355] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_reverse_dependencies, 4, 0, 0),
  [357] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reverse_dependencies, 4, 0, 0),
  [359] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_weak_reverse_dependencies, 3, 0, 0),
  [361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_weak_reverse_dependencies, 3, 0, 0),
  [363] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_definition, 2, 0, 0),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_definition, 2, 0, 0),
  [367] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dependencies, 3, 0, 0),
  [369] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dependencies, 3, 0, 0),
  [371] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_definition, 3, 0, 0),
  [373] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_definition, 3, 0, 0),
  [375] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_input_prompt, 3, 0, 0),
  [377] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_input_prompt, 3, 0, 0),
  [379] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_default_value, 3, 0, 0),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_default_value, 3, 0, 0),
  [383] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_numerical_ranges, 4, 0, 0),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_numerical_ranges, 4, 0, 0),
  [387] = {.entry = {.count = 1, .reusable = false}}, SHIFT(141),
  [389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [397] = {.entry = {.count = 1, .reusable = false}}, SHIFT(200),
  [399] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [445] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(94),
  [448] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(262),
  [451] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(303),
  [454] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(306),
  [457] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [465] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(321),
  [468] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(333),
  [471] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(281),
  [474] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(282),
  [477] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(283),
  [480] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(51),
  [483] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0),
  [485] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(338),
  [488] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(344),
  [491] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(223),
  [494] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(341),
  [497] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [499] = {.entry = {.count = 1, .reusable = false}}, SHIFT(210),
  [501] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_configuration, 1, 0, 0),
  [503] = {.entry = {.count = 1, .reusable = false}}, SHIFT(218),
  [505] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0),
  [507] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(322),
  [510] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(336),
  [513] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(285),
  [516] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(266),
  [519] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(267),
  [522] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(50),
  [525] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(332),
  [528] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(353),
  [531] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(174),
  [534] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configuration_repeat1, 2, 0, 0), SHIFT_REPEAT(352),
  [537] = {.entry = {.count = 1, .reusable = false}}, SHIFT(144),
  [539] = {.entry = {.count = 1, .reusable = false}}, SHIFT(217),
  [541] = {.entry = {.count = 1, .reusable = false}}, SHIFT(146),
  [543] = {.entry = {.count = 1, .reusable = false}}, SHIFT(136),
  [545] = {.entry = {.count = 1, .reusable = false}}, SHIFT(192),
  [547] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_configdefault, 3, 0, 1),
  [549] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [551] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_configdefault_repeat1, 2, 0, 0),
  [553] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configdefault_repeat1, 2, 0, 0), SHIFT_REPEAT(231),
  [556] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(123),
  [559] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(278),
  [562] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(301),
  [565] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(302),
  [568] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [570] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [572] = {.entry = {.count = 1, .reusable = false}}, SHIFT(278),
  [574] = {.entry = {.count = 1, .reusable = false}}, SHIFT(301),
  [576] = {.entry = {.count = 1, .reusable = false}}, SHIFT(302),
  [578] = {.entry = {.count = 1, .reusable = false}}, SHIFT(157),
  [580] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [582] = {.entry = {.count = 1, .reusable = false}}, SHIFT(142),
  [584] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [586] = {.entry = {.count = 1, .reusable = false}}, SHIFT(232),
  [588] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [590] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [592] = {.entry = {.count = 1, .reusable = false}}, SHIFT(170),
  [594] = {.entry = {.count = 1, .reusable = false}}, SHIFT(363),
  [596] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_configdefault_repeat1, 2, 0, 0),
  [598] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_configdefault_repeat1, 2, 0, 0), SHIFT_REPEAT(229),
  [601] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_configdefault, 3, 0, 1),
  [603] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [605] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(130),
  [608] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(276),
  [611] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(297),
  [614] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_name_repeat1, 2, 0, 0), SHIFT_REPEAT(298),
  [617] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [621] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [623] = {.entry = {.count = 1, .reusable = false}}, SHIFT(276),
  [625] = {.entry = {.count = 1, .reusable = false}}, SHIFT(297),
  [627] = {.entry = {.count = 1, .reusable = false}}, SHIFT(298),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [631] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_variable_repeat1, 2, 0, 8), SHIFT_REPEAT(157),
  [634] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_variable_repeat1, 2, 0, 8), SHIFT_REPEAT(135),
  [637] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2, 0, 8),
  [639] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_variable_repeat1, 2, 0, 8), SHIFT_REPEAT(221),
  [642] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_variable_repeat1, 2, 0, 8), SHIFT_REPEAT(232),
  [645] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_variable_repeat1, 2, 0, 8), SHIFT_REPEAT(278),
  [648] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_variable_repeat1, 2, 0, 8), SHIFT_REPEAT(301),
  [651] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_variable_repeat1, 2, 0, 8), SHIFT_REPEAT(302),
  [654] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_choice, 5, 0, 1),
  [656] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mainmenu, 2, 0, 1),
  [658] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_choice, 3, 0, 0),
  [660] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_source, 2, 0, 0),
  [662] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_menu, 3, 0, 1),
  [664] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if, 3, 0, 3),
  [666] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable, 3, 0, 4),
  [668] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_choice, 4, 0, 1),
  [670] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_choice, 4, 0, 0),
  [672] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_menu, 4, 0, 1),
  [674] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if, 4, 0, 3),
  [676] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable, 4, 0, 4),
  [678] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable, 4, 0, 7),
  [680] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_variable_repeat1, 1, 0, 5),
  [682] = {.entry = {.count = 1, .reusable = false}}, SHIFT(194),
  [684] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 1, 0, 5),
  [686] = {.entry = {.count = 1, .reusable = false}}, SHIFT(195),
  [688] = {.entry = {.count = 1, .reusable = false}}, SHIFT(196),
  [690] = {.entry = {.count = 1, .reusable = false}}, SHIFT(197),
  [692] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_menu, 5, 0, 1),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [712] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 3, 0, 4),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [724] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_menu, 3, 0, 1),
  [726] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source, 2, 0, 0),
  [728] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if, 3, 0, 3),
  [730] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_choice, 4, 0, 1),
  [732] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_choice, 4, 0, 0),
  [734] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_menu, 4, 0, 1),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [754] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mainmenu, 2, 0, 1),
  [756] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if, 4, 0, 3),
  [758] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_choice, 3, 0, 0),
  [760] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 4, 0, 4),
  [762] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 4, 0, 7),
  [764] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_choice, 5, 0, 1),
  [766] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_menu, 5, 0, 1),
  [768] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_name_repeat1, 1, 0, 0),
  [770] = {.entry = {.count = 1, .reusable = false}}, SHIFT(216),
  [772] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [776] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [778] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [780] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [792] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [800] = {.entry = {.count = 1, .reusable = false}}, SHIFT(187),
  [802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [812] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [814] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional_clause, 2, 0, 0),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [818] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [820] = {.entry = {.count = 1, .reusable = false}}, SHIFT(274),
  [822] = {.entry = {.count = 1, .reusable = false}}, SHIFT(261),
  [824] = {.entry = {.count = 1, .reusable = false}}, SHIFT(291),
  [826] = {.entry = {.count = 1, .reusable = false}}, SHIFT(292),
  [828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [830] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [832] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_macro_variable_repeat1, 2, 0, 0),
  [834] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_macro_variable_repeat1, 2, 0, 0), SHIFT_REPEAT(274),
  [837] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_macro_variable_repeat1, 2, 0, 0), SHIFT_REPEAT(261),
  [840] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_macro_variable_repeat1, 2, 0, 0), SHIFT_REPEAT(291),
  [843] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_macro_variable_repeat1, 2, 0, 0), SHIFT_REPEAT(292),
  [846] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [848] = {.entry = {.count = 1, .reusable = false}}, SHIFT(268),
  [850] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [852] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [854] = {.entry = {.count = 1, .reusable = false}}, SHIFT(263),
  [856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [860] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [862] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [864] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [866] = {.entry = {.count = 1, .reusable = false}}, SHIFT(323),
  [868] = {.entry = {.count = 1, .reusable = false}}, SHIFT(271),
  [870] = {.entry = {.count = 1, .reusable = false}}, SHIFT(326),
  [872] = {.entry = {.count = 1, .reusable = false}}, SHIFT(325),
  [874] = {.entry = {.count = 1, .reusable = false}}, SHIFT(273),
  [876] = {.entry = {.count = 1, .reusable = false}}, SHIFT(324),
  [878] = {.entry = {.count = 1, .reusable = false}}, SHIFT(316),
  [880] = {.entry = {.count = 1, .reusable = false}}, SHIFT(275),
  [882] = {.entry = {.count = 1, .reusable = false}}, SHIFT(318),
  [884] = {.entry = {.count = 1, .reusable = false}}, SHIFT(203),
  [886] = {.entry = {.count = 1, .reusable = false}}, SHIFT(277),
  [888] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [890] = {.entry = {.count = 1, .reusable = false}}, SHIFT(161),
  [892] = {.entry = {.count = 1, .reusable = false}}, SHIFT(279),
  [894] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [896] = {.entry = {.count = 1, .reusable = false}}, SHIFT(32),
  [898] = {.entry = {.count = 1, .reusable = false}}, SHIFT(259),
  [900] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0), SHIFT_REPEAT(270),
  [903] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0),
  [905] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0), SHIFT_REPEAT(286),
  [908] = {.entry = {.count = 1, .reusable = false}}, SHIFT(272),
  [910] = {.entry = {.count = 1, .reusable = false}}, SHIFT(290),
  [912] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [914] = {.entry = {.count = 1, .reusable = false}}, SHIFT(314),
  [916] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [918] = {.entry = {.count = 1, .reusable = false}}, SHIFT(270),
  [920] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [922] = {.entry = {.count = 1, .reusable = false}}, SHIFT(286),
  [924] = {.entry = {.count = 1, .reusable = false}}, SHIFT(320),
  [926] = {.entry = {.count = 1, .reusable = false}}, SHIFT(294),
  [928] = {.entry = {.count = 1, .reusable = false}}, SHIFT(295),
  [930] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [932] = {.entry = {.count = 1, .reusable = false}}, SHIFT(312),
  [934] = {.entry = {.count = 1, .reusable = false}}, SHIFT(317),
  [936] = {.entry = {.count = 1, .reusable = false}}, SHIFT(198),
  [938] = {.entry = {.count = 1, .reusable = false}}, SHIFT(308),
  [940] = {.entry = {.count = 1, .reusable = false}}, SHIFT(202),
  [942] = {.entry = {.count = 1, .reusable = false}}, SHIFT(299),
  [944] = {.entry = {.count = 1, .reusable = false}}, SHIFT(300),
  [946] = {.entry = {.count = 1, .reusable = false}}, SHIFT(207),
  [948] = {.entry = {.count = 1, .reusable = false}}, SHIFT(152),
  [950] = {.entry = {.count = 1, .reusable = false}}, SHIFT(304),
  [952] = {.entry = {.count = 1, .reusable = false}}, SHIFT(305),
  [954] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [956] = {.entry = {.count = 1, .reusable = false}}, SHIFT(309),
  [958] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [960] = {.entry = {.count = 1, .reusable = false}}, SHIFT(310),
  [962] = {.entry = {.count = 1, .reusable = false}}, SHIFT(288),
  [964] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [966] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [968] = {.entry = {.count = 1, .reusable = false}}, SHIFT(311),
  [970] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 2, 0, 0), SHIFT_REPEAT(272),
  [973] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 2, 0, 0), SHIFT_REPEAT(314),
  [976] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 2, 0, 0),
  [978] = {.entry = {.count = 1, .reusable = false}}, SHIFT(289),
  [980] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_macro_variable_repeat1, 1, 0, 2),
  [982] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [984] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [986] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [988] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [990] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [992] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [998] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [1000] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [1002] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1004] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [1006] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [1008] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1010] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [1012] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [1014] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [1016] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [1018] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [1022] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [1024] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1026] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [1034] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1036] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [1040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [1042] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [1058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [1062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [1066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1070] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token__help_text = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__help_text] = sym__help_text,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__help_text] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_kconfig_external_scanner_create(void);
void tree_sitter_kconfig_external_scanner_destroy(void *);
bool tree_sitter_kconfig_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_kconfig_external_scanner_serialize(void *, char *);
void tree_sitter_kconfig_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_kconfig(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_symbol,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_kconfig_external_scanner_create,
      tree_sitter_kconfig_external_scanner_destroy,
      tree_sitter_kconfig_external_scanner_scan,
      tree_sitter_kconfig_external_scanner_serialize,
      tree_sitter_kconfig_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
