#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 345
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 118
#define ALIAS_COUNT 0
#define TOKEN_COUNT 52
#define EXTERNAL_TOKEN_COUNT 16
#define FIELD_COUNT 4
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 8

enum ts_symbol_identifiers {
  anon_sym_LT_BANG = 1,
  aux_sym_doctype_token1 = 2,
  anon_sym_GT = 3,
  sym__doctype = 4,
  anon_sym_LT = 5,
  anon_sym_SLASH_GT = 6,
  anon_sym_LT_SLASH = 7,
  anon_sym_EQ = 8,
  sym_attribute_name = 9,
  sym_attribute_value = 10,
  sym_entity = 11,
  anon_sym_SQUOTE = 12,
  anon_sym_DQUOTE = 13,
  sym_text = 14,
  aux_sym__single_quoted_attribute_value_token1 = 15,
  aux_sym__double_quoted_attribute_value_token1 = 16,
  anon_sym_POUND = 17,
  anon_sym_if = 18,
  anon_sym_LBRACE = 19,
  anon_sym_RBRACE = 20,
  anon_sym_COLON = 21,
  anon_sym_elseif = 22,
  anon_sym_else = 23,
  anon_sym_SLASH = 24,
  anon_sym_each = 25,
  anon_sym_as = 26,
  anon_sym_await = 27,
  anon_sym_then = 28,
  anon_sym_catch = 29,
  anon_sym_key = 30,
  anon_sym_snippet = 31,
  aux_sym_snippet_start_token1 = 32,
  anon_sym_LPAREN = 33,
  anon_sym_RPAREN = 34,
  aux_sym__tag_value_token1 = 35,
  anon_sym_AT = 36,
  anon_sym_html = 37,
  anon_sym_const = 38,
  anon_sym_debug = 39,
  anon_sym_render = 40,
  sym__start_tag_name = 41,
  sym__script_start_tag_name = 42,
  sym__style_start_tag_name = 43,
  sym__end_tag_name = 44,
  sym_erroneous_end_tag_name = 45,
  sym__implicit_end_tag = 46,
  sym_raw_text = 47,
  sym_comment = 48,
  sym_svelte_raw_text = 49,
  sym_svelte_raw_text_each = 50,
  sym_svelte_raw_text_snippet_arguments = 51,
  sym_document = 52,
  sym_doctype = 53,
  sym__node = 54,
  sym_element = 55,
  sym_script_element = 56,
  sym_style_element = 57,
  sym_start_tag = 58,
  sym_script_start_tag = 59,
  sym_style_start_tag = 60,
  sym_self_closing_tag = 61,
  sym_end_tag = 62,
  sym_erroneous_end_tag = 63,
  sym_attribute = 64,
  sym_quoted_attribute_value = 65,
  aux_sym__single_quoted_attribute_value = 66,
  aux_sym__double_quoted_attribute_value = 67,
  sym_if_statement = 68,
  sym__if_start_tag = 69,
  sym_if_start = 70,
  sym__else_if_tag = 71,
  sym_else_if_start = 72,
  sym_else_if_block = 73,
  sym__else_tag = 74,
  sym_else_start = 75,
  sym_else_block = 76,
  sym__if_end_tag = 77,
  sym_if_end = 78,
  sym_each_statement = 79,
  sym__each_start_tag = 80,
  sym_each_start = 81,
  sym__each_end_tag = 82,
  sym_each_end = 83,
  sym_await_statement = 84,
  sym__await_start_tag = 85,
  sym_await_start = 86,
  sym__then_tag = 87,
  sym_then_start = 88,
  sym_then_block = 89,
  sym__catch_tag = 90,
  sym_catch_start = 91,
  sym_catch_block = 92,
  sym__await_end_tag = 93,
  sym_await_end = 94,
  sym_key_statement = 95,
  sym__key_start_tag = 96,
  sym_key_start = 97,
  sym__key_end_tag = 98,
  sym_key_end = 99,
  sym_snippet_statement = 100,
  sym__snippet_start_tag = 101,
  sym_snippet_start = 102,
  sym__snippet_end_tag = 103,
  sym_snippet_end = 104,
  sym_expression = 105,
  sym__tag_value = 106,
  sym__html_tag = 107,
  sym_html_tag = 108,
  sym__const_tag = 109,
  sym_const_tag = 110,
  sym__debug_tag = 111,
  sym_debug_tag = 112,
  sym__render_tag = 113,
  sym_render_tag = 114,
  aux_sym_document_repeat1 = 115,
  aux_sym_start_tag_repeat1 = 116,
  aux_sym_if_statement_repeat1 = 117,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LT_BANG] = "<!",
  [aux_sym_doctype_token1] = "doctype_token1",
  [anon_sym_GT] = ">",
  [sym__doctype] = "doctype",
  [anon_sym_LT] = "<",
  [anon_sym_SLASH_GT] = "/>",
  [anon_sym_LT_SLASH] = "</",
  [anon_sym_EQ] = "=",
  [sym_attribute_name] = "attribute_name",
  [sym_attribute_value] = "attribute_value",
  [sym_entity] = "entity",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DQUOTE] = "\"",
  [sym_text] = "text",
  [aux_sym__single_quoted_attribute_value_token1] = "_single_quoted_attribute_value_token1",
  [aux_sym__double_quoted_attribute_value_token1] = "_double_quoted_attribute_value_token1",
  [anon_sym_POUND] = "#",
  [anon_sym_if] = "if",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_COLON] = ":",
  [anon_sym_elseif] = "else if",
  [anon_sym_else] = "else",
  [anon_sym_SLASH] = "/",
  [anon_sym_each] = "each",
  [anon_sym_as] = "as",
  [anon_sym_await] = "await",
  [anon_sym_then] = "then",
  [anon_sym_catch] = "catch",
  [anon_sym_key] = "key",
  [anon_sym_snippet] = "snippet",
  [aux_sym_snippet_start_token1] = "snippet_name",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [aux_sym__tag_value_token1] = "_tag_value_token1",
  [anon_sym_AT] = "@",
  [anon_sym_html] = "html",
  [anon_sym_const] = "const",
  [anon_sym_debug] = "debug",
  [anon_sym_render] = "render",
  [sym__start_tag_name] = "tag_name",
  [sym__script_start_tag_name] = "tag_name",
  [sym__style_start_tag_name] = "tag_name",
  [sym__end_tag_name] = "tag_name",
  [sym_erroneous_end_tag_name] = "erroneous_end_tag_name",
  [sym__implicit_end_tag] = "_implicit_end_tag",
  [sym_raw_text] = "raw_text",
  [sym_comment] = "comment",
  [sym_svelte_raw_text] = "svelte_raw_text",
  [sym_svelte_raw_text_each] = "svelte_raw_text",
  [sym_svelte_raw_text_snippet_arguments] = "svelte_raw_text",
  [sym_document] = "document",
  [sym_doctype] = "doctype",
  [sym__node] = "_node",
  [sym_element] = "element",
  [sym_script_element] = "script_element",
  [sym_style_element] = "style_element",
  [sym_start_tag] = "start_tag",
  [sym_script_start_tag] = "start_tag",
  [sym_style_start_tag] = "start_tag",
  [sym_self_closing_tag] = "self_closing_tag",
  [sym_end_tag] = "end_tag",
  [sym_erroneous_end_tag] = "erroneous_end_tag",
  [sym_attribute] = "attribute",
  [sym_quoted_attribute_value] = "quoted_attribute_value",
  [aux_sym__single_quoted_attribute_value] = "_single_quoted_attribute_value",
  [aux_sym__double_quoted_attribute_value] = "_double_quoted_attribute_value",
  [sym_if_statement] = "if_statement",
  [sym__if_start_tag] = "block_start_tag",
  [sym_if_start] = "if_start",
  [sym__else_if_tag] = "block_tag",
  [sym_else_if_start] = "else_if_start",
  [sym_else_if_block] = "else_if_block",
  [sym__else_tag] = "block_tag",
  [sym_else_start] = "else_start",
  [sym_else_block] = "else_block",
  [sym__if_end_tag] = "block_end_tag",
  [sym_if_end] = "if_end",
  [sym_each_statement] = "each_statement",
  [sym__each_start_tag] = "block_start_tag",
  [sym_each_start] = "each_start",
  [sym__each_end_tag] = "block_end_tag",
  [sym_each_end] = "each_end",
  [sym_await_statement] = "await_statement",
  [sym__await_start_tag] = "block_start_tag",
  [sym_await_start] = "await_start",
  [sym__then_tag] = "block_tag",
  [sym_then_start] = "then_start",
  [sym_then_block] = "then_block",
  [sym__catch_tag] = "block_tag",
  [sym_catch_start] = "catch_start",
  [sym_catch_block] = "catch_block",
  [sym__await_end_tag] = "block_end_tag",
  [sym_await_end] = "await_end",
  [sym_key_statement] = "key_statement",
  [sym__key_start_tag] = "block_start_tag",
  [sym_key_start] = "key_start",
  [sym__key_end_tag] = "block_end_tag",
  [sym_key_end] = "key_end",
  [sym_snippet_statement] = "snippet_statement",
  [sym__snippet_start_tag] = "block_start_tag",
  [sym_snippet_start] = "snippet_start",
  [sym__snippet_end_tag] = "block_end_tag",
  [sym_snippet_end] = "snippet_end",
  [sym_expression] = "expression",
  [sym__tag_value] = "_tag_value",
  [sym__html_tag] = "expression_tag",
  [sym_html_tag] = "html_tag",
  [sym__const_tag] = "expression_tag",
  [sym_const_tag] = "const_tag",
  [sym__debug_tag] = "expression_tag",
  [sym_debug_tag] = "debug_tag",
  [sym__render_tag] = "expression_tag",
  [sym_render_tag] = "render_tag",
  [aux_sym_document_repeat1] = "document_repeat1",
  [aux_sym_start_tag_repeat1] = "start_tag_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LT_BANG] = anon_sym_LT_BANG,
  [aux_sym_doctype_token1] = aux_sym_doctype_token1,
  [anon_sym_GT] = anon_sym_GT,
  [sym__doctype] = sym__doctype,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_SLASH_GT] = anon_sym_SLASH_GT,
  [anon_sym_LT_SLASH] = anon_sym_LT_SLASH,
  [anon_sym_EQ] = anon_sym_EQ,
  [sym_attribute_name] = sym_attribute_name,
  [sym_attribute_value] = sym_attribute_value,
  [sym_entity] = sym_entity,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_text] = sym_text,
  [aux_sym__single_quoted_attribute_value_token1] = aux_sym__single_quoted_attribute_value_token1,
  [aux_sym__double_quoted_attribute_value_token1] = aux_sym__double_quoted_attribute_value_token1,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_each] = anon_sym_each,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_key] = anon_sym_key,
  [anon_sym_snippet] = anon_sym_snippet,
  [aux_sym_snippet_start_token1] = aux_sym_snippet_start_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym__tag_value_token1] = aux_sym__tag_value_token1,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_html] = anon_sym_html,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_debug] = anon_sym_debug,
  [anon_sym_render] = anon_sym_render,
  [sym__start_tag_name] = sym__start_tag_name,
  [sym__script_start_tag_name] = sym__start_tag_name,
  [sym__style_start_tag_name] = sym__start_tag_name,
  [sym__end_tag_name] = sym__start_tag_name,
  [sym_erroneous_end_tag_name] = sym_erroneous_end_tag_name,
  [sym__implicit_end_tag] = sym__implicit_end_tag,
  [sym_raw_text] = sym_raw_text,
  [sym_comment] = sym_comment,
  [sym_svelte_raw_text] = sym_svelte_raw_text,
  [sym_svelte_raw_text_each] = sym_svelte_raw_text,
  [sym_svelte_raw_text_snippet_arguments] = sym_svelte_raw_text,
  [sym_document] = sym_document,
  [sym_doctype] = sym_doctype,
  [sym__node] = sym__node,
  [sym_element] = sym_element,
  [sym_script_element] = sym_script_element,
  [sym_style_element] = sym_style_element,
  [sym_start_tag] = sym_start_tag,
  [sym_script_start_tag] = sym_start_tag,
  [sym_style_start_tag] = sym_start_tag,
  [sym_self_closing_tag] = sym_self_closing_tag,
  [sym_end_tag] = sym_end_tag,
  [sym_erroneous_end_tag] = sym_erroneous_end_tag,
  [sym_attribute] = sym_attribute,
  [sym_quoted_attribute_value] = sym_quoted_attribute_value,
  [aux_sym__single_quoted_attribute_value] = aux_sym__single_quoted_attribute_value,
  [aux_sym__double_quoted_attribute_value] = aux_sym__double_quoted_attribute_value,
  [sym_if_statement] = sym_if_statement,
  [sym__if_start_tag] = sym__if_start_tag,
  [sym_if_start] = sym_if_start,
  [sym__else_if_tag] = sym__else_if_tag,
  [sym_else_if_start] = sym_else_if_start,
  [sym_else_if_block] = sym_else_if_block,
  [sym__else_tag] = sym__else_if_tag,
  [sym_else_start] = sym_else_start,
  [sym_else_block] = sym_else_block,
  [sym__if_end_tag] = sym__if_end_tag,
  [sym_if_end] = sym_if_end,
  [sym_each_statement] = sym_each_statement,
  [sym__each_start_tag] = sym__if_start_tag,
  [sym_each_start] = sym_each_start,
  [sym__each_end_tag] = sym__if_end_tag,
  [sym_each_end] = sym_each_end,
  [sym_await_statement] = sym_await_statement,
  [sym__await_start_tag] = sym__if_start_tag,
  [sym_await_start] = sym_await_start,
  [sym__then_tag] = sym__else_if_tag,
  [sym_then_start] = sym_then_start,
  [sym_then_block] = sym_then_block,
  [sym__catch_tag] = sym__else_if_tag,
  [sym_catch_start] = sym_catch_start,
  [sym_catch_block] = sym_catch_block,
  [sym__await_end_tag] = sym__if_end_tag,
  [sym_await_end] = sym_await_end,
  [sym_key_statement] = sym_key_statement,
  [sym__key_start_tag] = sym__if_start_tag,
  [sym_key_start] = sym_key_start,
  [sym__key_end_tag] = sym__if_end_tag,
  [sym_key_end] = sym_key_end,
  [sym_snippet_statement] = sym_snippet_statement,
  [sym__snippet_start_tag] = sym__if_start_tag,
  [sym_snippet_start] = sym_snippet_start,
  [sym__snippet_end_tag] = sym__if_end_tag,
  [sym_snippet_end] = sym_snippet_end,
  [sym_expression] = sym_expression,
  [sym__tag_value] = sym__tag_value,
  [sym__html_tag] = sym__html_tag,
  [sym_html_tag] = sym_html_tag,
  [sym__const_tag] = sym__html_tag,
  [sym_const_tag] = sym_const_tag,
  [sym__debug_tag] = sym__html_tag,
  [sym_debug_tag] = sym_debug_tag,
  [sym__render_tag] = sym__html_tag,
  [sym_render_tag] = sym_render_tag,
  [aux_sym_document_repeat1] = aux_sym_document_repeat1,
  [aux_sym_start_tag_repeat1] = aux_sym_start_tag_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LT_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_doctype_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [sym__doctype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_attribute_name] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_entity] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_text] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__single_quoted_attribute_value_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__double_quoted_attribute_value_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_each] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_key] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_snippet] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_snippet_start_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__tag_value_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_html] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debug] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_render] = {
    .visible = true,
    .named = false,
  },
  [sym__start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__script_start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__style_start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__end_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym_erroneous_end_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__implicit_end_tag] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_text] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_svelte_raw_text] = {
    .visible = true,
    .named = true,
  },
  [sym_svelte_raw_text_each] = {
    .visible = true,
    .named = true,
  },
  [sym_svelte_raw_text_snippet_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_document] = {
    .visible = true,
    .named = true,
  },
  [sym_doctype] = {
    .visible = true,
    .named = true,
  },
  [sym__node] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_element] = {
    .visible = true,
    .named = true,
  },
  [sym_script_element] = {
    .visible = true,
    .named = true,
  },
  [sym_style_element] = {
    .visible = true,
    .named = true,
  },
  [sym_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_script_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_style_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_self_closing_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_end_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_erroneous_end_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__single_quoted_attribute_value] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__double_quoted_attribute_value] = {
    .visible = false,
    .named = false,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__if_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_if_start] = {
    .visible = true,
    .named = true,
  },
  [sym__else_if_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if_start] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if_block] = {
    .visible = true,
    .named = true,
  },
  [sym__else_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_else_start] = {
    .visible = true,
    .named = true,
  },
  [sym_else_block] = {
    .visible = true,
    .named = true,
  },
  [sym__if_end_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_if_end] = {
    .visible = true,
    .named = true,
  },
  [sym_each_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__each_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_each_start] = {
    .visible = true,
    .named = true,
  },
  [sym__each_end_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_each_end] = {
    .visible = true,
    .named = true,
  },
  [sym_await_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__await_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_await_start] = {
    .visible = true,
    .named = true,
  },
  [sym__then_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_then_start] = {
    .visible = true,
    .named = true,
  },
  [sym_then_block] = {
    .visible = true,
    .named = true,
  },
  [sym__catch_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_start] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_block] = {
    .visible = true,
    .named = true,
  },
  [sym__await_end_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_await_end] = {
    .visible = true,
    .named = true,
  },
  [sym_key_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__key_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_key_start] = {
    .visible = true,
    .named = true,
  },
  [sym__key_end_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_key_end] = {
    .visible = true,
    .named = true,
  },
  [sym_snippet_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__snippet_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_snippet_start] = {
    .visible = true,
    .named = true,
  },
  [sym__snippet_end_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_snippet_end] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__tag_value] = {
    .visible = false,
    .named = true,
  },
  [sym__html_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_html_tag] = {
    .visible = true,
    .named = true,
  },
  [sym__const_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_const_tag] = {
    .visible = true,
    .named = true,
  },
  [sym__debug_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_debug_tag] = {
    .visible = true,
    .named = true,
  },
  [sym__render_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_render_tag] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_document_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_start_tag_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_condition = 1,
  field_identifier = 2,
  field_parameter = 3,
  field_tag = 4,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_condition] = "condition",
  [field_identifier] = "identifier",
  [field_parameter] = "parameter",
  [field_tag] = "tag",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 2},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 6, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_tag, 1},
  [1] =
    {field_condition, 2},
    {field_tag, 1, .inherited = true},
  [3] =
    {field_identifier, 2},
    {field_tag, 1, .inherited = true},
  [5] =
    {field_tag, 1, .inherited = true},
  [6] =
    {field_identifier, 2},
    {field_parameter, 4},
    {field_tag, 1, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_attribute_name,
  },
  [7] = {
    [1] = sym_attribute_value,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__single_quoted_attribute_value, 2,
    aux_sym__single_quoted_attribute_value,
    sym_attribute_value,
  aux_sym__double_quoted_attribute_value, 2,
    aux_sym__double_quoted_attribute_value,
    sym_attribute_value,
  sym_expression, 2,
    sym_expression,
    sym_attribute_name,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 3,
  [5] = 2,
  [6] = 6,
  [7] = 7,
  [8] = 6,
  [9] = 7,
  [10] = 10,
  [11] = 11,
  [12] = 11,
  [13] = 10,
  [14] = 14,
  [15] = 15,
  [16] = 14,
  [17] = 15,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 18,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 19,
  [27] = 23,
  [28] = 28,
  [29] = 29,
  [30] = 20,
  [31] = 31,
  [32] = 31,
  [33] = 29,
  [34] = 22,
  [35] = 24,
  [36] = 25,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 40,
  [45] = 45,
  [46] = 45,
  [47] = 47,
  [48] = 48,
  [49] = 48,
  [50] = 47,
  [51] = 51,
  [52] = 51,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 53,
  [57] = 55,
  [58] = 54,
  [59] = 59,
  [60] = 59,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 61,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 66,
  [107] = 62,
  [108] = 99,
  [109] = 105,
  [110] = 67,
  [111] = 68,
  [112] = 69,
  [113] = 70,
  [114] = 71,
  [115] = 72,
  [116] = 74,
  [117] = 75,
  [118] = 76,
  [119] = 77,
  [120] = 78,
  [121] = 80,
  [122] = 82,
  [123] = 83,
  [124] = 84,
  [125] = 85,
  [126] = 86,
  [127] = 87,
  [128] = 88,
  [129] = 89,
  [130] = 90,
  [131] = 91,
  [132] = 92,
  [133] = 93,
  [134] = 94,
  [135] = 95,
  [136] = 96,
  [137] = 97,
  [138] = 101,
  [139] = 102,
  [140] = 98,
  [141] = 141,
  [142] = 142,
  [143] = 103,
  [144] = 142,
  [145] = 65,
  [146] = 73,
  [147] = 104,
  [148] = 141,
  [149] = 64,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 81,
  [164] = 164,
  [165] = 165,
  [166] = 164,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 176,
  [179] = 179,
  [180] = 177,
  [181] = 179,
  [182] = 171,
  [183] = 172,
  [184] = 68,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 190,
  [193] = 189,
  [194] = 175,
  [195] = 185,
  [196] = 196,
  [197] = 197,
  [198] = 196,
  [199] = 188,
  [200] = 197,
  [201] = 186,
  [202] = 202,
  [203] = 68,
  [204] = 68,
  [205] = 68,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 206,
  [211] = 207,
  [212] = 209,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 216,
  [218] = 218,
  [219] = 219,
  [220] = 214,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 219,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 225,
  [231] = 231,
  [232] = 218,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 223,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 231,
  [244] = 240,
  [245] = 245,
  [246] = 213,
  [247] = 215,
  [248] = 235,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 249,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 259,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 252,
  [292] = 270,
  [293] = 275,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 258,
  [308] = 268,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 299,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 249,
  [318] = 249,
  [319] = 249,
  [320] = 249,
  [321] = 321,
  [322] = 269,
  [323] = 289,
  [324] = 301,
  [325] = 315,
  [326] = 321,
  [327] = 327,
  [328] = 253,
  [329] = 329,
  [330] = 263,
  [331] = 331,
  [332] = 290,
  [333] = 303,
  [334] = 272,
  [335] = 327,
  [336] = 277,
  [337] = 277,
  [338] = 277,
  [339] = 274,
  [340] = 286,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
};

static TSCharacterRange sym_attribute_name_character_set_1[] = {
  {0, 0x08}, {0x0e, 0x1f}, {'!', '!'}, {'#', '&'}, {'(', '.'}, {'0', ';'}, {'?', 'z'}, {'|', '|'},
  {'~', 0x10ffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(65);
      ADVANCE_MAP(
        '"', 118,
        '#', 124,
        '&', 4,
        '\'', 117,
        '(', 142,
        ')', 143,
        '/', 133,
        ':', 128,
        '<', 71,
        '=', 74,
        '>', 69,
        '@', 145,
        'D', 56,
        'a', 43,
        'c', 9,
        'd', 15,
        'e', 8,
        'h', 47,
        'i', 24,
        'k', 16,
        'r', 21,
        's', 36,
        't', 29,
        '{', 126,
        '}', 127,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(144);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(118);
      if (lookahead == '\'') ADVANCE(117);
      if (lookahead == '{') ADVANCE(126);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(144);
      if (lookahead != 0 &&
          (lookahead < '<' || '>' < lookahead) &&
          lookahead != '}') ADVANCE(76);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(118);
      if (lookahead == '{') ADVANCE(126);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(122);
      if (lookahead != 0) ADVANCE(123);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(124);
      if (lookahead == '/') ADVANCE(132);
      if (lookahead == ':') ADVANCE(128);
      if (lookahead == '@') ADVANCE(145);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(144);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(141);
      END_STATE();
    case 4:
      if (lookahead == '#') ADVANCE(59);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 5:
      if (lookahead == '\'') ADVANCE(117);
      if (lookahead == '{') ADVANCE(126);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(120);
      if (lookahead != 0) ADVANCE(121);
      END_STATE();
    case 6:
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(69);
      if (lookahead == '{') ADVANCE(126);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(144);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '<' || '>' < lookahead) &&
          lookahead != '}') ADVANCE(75);
      END_STATE();
    case 7:
      if (lookahead == '>') ADVANCE(72);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(12);
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(51);
      if (lookahead == 'o') ADVANCE(39);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(32);
      END_STATE();
    case 11:
      if (lookahead == 'b') ADVANCE(52);
      END_STATE();
    case 12:
      if (lookahead == 'c') ADVANCE(27);
      END_STATE();
    case 13:
      if (lookahead == 'c') ADVANCE(28);
      END_STATE();
    case 14:
      if (lookahead == 'd') ADVANCE(18);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(11);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(54);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(131);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 20:
      if (lookahead == 'e') ADVANCE(34);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(144);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(37);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 24:
      if (lookahead == 'f') ADVANCE(125);
      END_STATE();
    case 25:
      if (lookahead == 'f') ADVANCE(129);
      END_STATE();
    case 26:
      if (lookahead == 'g') ADVANCE(148);
      END_STATE();
    case 27:
      if (lookahead == 'h') ADVANCE(134);
      END_STATE();
    case 28:
      if (lookahead == 'h') ADVANCE(138);
      END_STATE();
    case 29:
      if (lookahead == 'h') ADVANCE(22);
      END_STATE();
    case 30:
      if (lookahead == 'i') ADVANCE(40);
      END_STATE();
    case 31:
      if (lookahead == 'i') ADVANCE(25);
      END_STATE();
    case 32:
      if (lookahead == 'i') ADVANCE(48);
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(146);
      END_STATE();
    case 34:
      if (lookahead == 'l') ADVANCE(46);
      END_STATE();
    case 35:
      if (lookahead == 'm') ADVANCE(33);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(30);
      END_STATE();
    case 37:
      if (lookahead == 'n') ADVANCE(14);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(137);
      END_STATE();
    case 39:
      if (lookahead == 'n') ADVANCE(45);
      END_STATE();
    case 40:
      if (lookahead == 'p') ADVANCE(41);
      END_STATE();
    case 41:
      if (lookahead == 'p') ADVANCE(23);
      END_STATE();
    case 42:
      if (lookahead == 'r') ADVANCE(149);
      END_STATE();
    case 43:
      if (lookahead == 's') ADVANCE(135);
      if (lookahead == 'w') ADVANCE(10);
      END_STATE();
    case 44:
      if (lookahead == 's') ADVANCE(17);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(49);
      END_STATE();
    case 46:
      if (lookahead == 's') ADVANCE(19);
      END_STATE();
    case 47:
      if (lookahead == 't') ADVANCE(35);
      END_STATE();
    case 48:
      if (lookahead == 't') ADVANCE(136);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 50:
      if (lookahead == 't') ADVANCE(140);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(13);
      END_STATE();
    case 52:
      if (lookahead == 'u') ADVANCE(26);
      END_STATE();
    case 53:
      if (lookahead == 'y') ADVANCE(139);
      END_STATE();
    case 54:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(58);
      END_STATE();
    case 55:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 56:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(54);
      END_STATE();
    case 57:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(55);
      END_STATE();
    case 58:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(60);
      END_STATE();
    case 59:
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      END_STATE();
    case 60:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(57);
      END_STATE();
    case 61:
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(61);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(119);
      END_STATE();
    case 62:
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(67);
      if (lookahead != 0 &&
          lookahead != '>') ADVANCE(68);
      END_STATE();
    case 63:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(87);
      END_STATE();
    case 64:
      if (eof) ADVANCE(65);
      if (lookahead == '&') ADVANCE(4);
      if (lookahead == '<') ADVANCE(71);
      if (lookahead == '{') ADVANCE(126);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(144);
      if (lookahead != 0 &&
          lookahead != '>' &&
          lookahead != '}') ADVANCE(119);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_LT_BANG);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(aux_sym_doctype_token1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(67);
      if (lookahead != 0 &&
          lookahead != '>') ADVANCE(68);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(aux_sym_doctype_token1);
      if (lookahead != 0 &&
          lookahead != '>') ADVANCE(68);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym__doctype);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '!') ADVANCE(66);
      if (lookahead == '/') ADVANCE(73);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_SLASH_GT);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LT_SLASH);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_attribute_name);
      if ((!eof && set_contains(sym_attribute_name_character_set_1, 9, lookahead))) ADVANCE(75);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_attribute_value);
      if ((!eof && set_contains(sym_attribute_name_character_set_1, 9, lookahead)) ||
          lookahead == '/') ADVANCE(76);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_entity);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(79);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(81);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(78);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(83);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(84);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(85);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(86);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(78);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(89);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(90);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(91);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(93);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(94);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(95);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(96);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(97);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(98);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(99);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(100);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(101);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(102);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(103);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(104);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(105);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(106);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(107);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(108);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(111);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(112);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(113);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_entity);
      if (lookahead == ';') ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(115);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_text);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(61);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(119);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym__single_quoted_attribute_value_token1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(120);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '{') ADVANCE(121);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym__single_quoted_attribute_value_token1);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '{') ADVANCE(121);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym__double_quoted_attribute_value_token1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(122);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '{') ADVANCE(123);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym__double_quoted_attribute_value_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '{') ADVANCE(123);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == ' ') ADVANCE(31);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '>') ADVANCE(72);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_each);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_key);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_snippet);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym_snippet_start_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(141);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym__tag_value_token1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(144);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_html);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_debug);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_render);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 64, .external_lex_state = 2},
  [2] = {.lex_state = 64, .external_lex_state = 2},
  [3] = {.lex_state = 64, .external_lex_state = 2},
  [4] = {.lex_state = 64, .external_lex_state = 2},
  [5] = {.lex_state = 64, .external_lex_state = 2},
  [6] = {.lex_state = 64, .external_lex_state = 2},
  [7] = {.lex_state = 64, .external_lex_state = 2},
  [8] = {.lex_state = 64, .external_lex_state = 2},
  [9] = {.lex_state = 64, .external_lex_state = 2},
  [10] = {.lex_state = 64, .external_lex_state = 2},
  [11] = {.lex_state = 64, .external_lex_state = 2},
  [12] = {.lex_state = 64, .external_lex_state = 2},
  [13] = {.lex_state = 64, .external_lex_state = 2},
  [14] = {.lex_state = 64, .external_lex_state = 3},
  [15] = {.lex_state = 64, .external_lex_state = 3},
  [16] = {.lex_state = 64, .external_lex_state = 3},
  [17] = {.lex_state = 64, .external_lex_state = 3},
  [18] = {.lex_state = 64, .external_lex_state = 2},
  [19] = {.lex_state = 64, .external_lex_state = 2},
  [20] = {.lex_state = 64, .external_lex_state = 2},
  [21] = {.lex_state = 64, .external_lex_state = 2},
  [22] = {.lex_state = 64, .external_lex_state = 2},
  [23] = {.lex_state = 64, .external_lex_state = 2},
  [24] = {.lex_state = 64, .external_lex_state = 2},
  [25] = {.lex_state = 64, .external_lex_state = 2},
  [26] = {.lex_state = 64, .external_lex_state = 2},
  [27] = {.lex_state = 64, .external_lex_state = 3},
  [28] = {.lex_state = 64, .external_lex_state = 2},
  [29] = {.lex_state = 64, .external_lex_state = 2},
  [30] = {.lex_state = 64, .external_lex_state = 2},
  [31] = {.lex_state = 64, .external_lex_state = 2},
  [32] = {.lex_state = 64, .external_lex_state = 2},
  [33] = {.lex_state = 64, .external_lex_state = 2},
  [34] = {.lex_state = 64, .external_lex_state = 2},
  [35] = {.lex_state = 64, .external_lex_state = 2},
  [36] = {.lex_state = 64, .external_lex_state = 2},
  [37] = {.lex_state = 64, .external_lex_state = 2},
  [38] = {.lex_state = 64, .external_lex_state = 2},
  [39] = {.lex_state = 64, .external_lex_state = 2},
  [40] = {.lex_state = 64, .external_lex_state = 2},
  [41] = {.lex_state = 64, .external_lex_state = 2},
  [42] = {.lex_state = 64, .external_lex_state = 2},
  [43] = {.lex_state = 64, .external_lex_state = 2},
  [44] = {.lex_state = 64, .external_lex_state = 2},
  [45] = {.lex_state = 64, .external_lex_state = 2},
  [46] = {.lex_state = 64, .external_lex_state = 2},
  [47] = {.lex_state = 3, .external_lex_state = 4},
  [48] = {.lex_state = 3, .external_lex_state = 4},
  [49] = {.lex_state = 3, .external_lex_state = 4},
  [50] = {.lex_state = 3, .external_lex_state = 4},
  [51] = {.lex_state = 3, .external_lex_state = 4},
  [52] = {.lex_state = 3, .external_lex_state = 4},
  [53] = {.lex_state = 3, .external_lex_state = 5},
  [54] = {.lex_state = 3, .external_lex_state = 5},
  [55] = {.lex_state = 3, .external_lex_state = 5},
  [56] = {.lex_state = 3, .external_lex_state = 5},
  [57] = {.lex_state = 3, .external_lex_state = 5},
  [58] = {.lex_state = 3, .external_lex_state = 5},
  [59] = {.lex_state = 0, .external_lex_state = 6},
  [60] = {.lex_state = 0, .external_lex_state = 6},
  [61] = {.lex_state = 64, .external_lex_state = 2},
  [62] = {.lex_state = 64, .external_lex_state = 2},
  [63] = {.lex_state = 64, .external_lex_state = 3},
  [64] = {.lex_state = 64, .external_lex_state = 2},
  [65] = {.lex_state = 6, .external_lex_state = 7},
  [66] = {.lex_state = 64, .external_lex_state = 2},
  [67] = {.lex_state = 64, .external_lex_state = 2},
  [68] = {.lex_state = 64, .external_lex_state = 2},
  [69] = {.lex_state = 64, .external_lex_state = 2},
  [70] = {.lex_state = 64, .external_lex_state = 2},
  [71] = {.lex_state = 64, .external_lex_state = 2},
  [72] = {.lex_state = 64, .external_lex_state = 2},
  [73] = {.lex_state = 0, .external_lex_state = 2},
  [74] = {.lex_state = 64, .external_lex_state = 2},
  [75] = {.lex_state = 64, .external_lex_state = 2},
  [76] = {.lex_state = 64, .external_lex_state = 2},
  [77] = {.lex_state = 64, .external_lex_state = 2},
  [78] = {.lex_state = 64, .external_lex_state = 2},
  [79] = {.lex_state = 64, .external_lex_state = 3},
  [80] = {.lex_state = 64, .external_lex_state = 2},
  [81] = {.lex_state = 6, .external_lex_state = 7},
  [82] = {.lex_state = 64, .external_lex_state = 2},
  [83] = {.lex_state = 64, .external_lex_state = 2},
  [84] = {.lex_state = 64, .external_lex_state = 2},
  [85] = {.lex_state = 64, .external_lex_state = 2},
  [86] = {.lex_state = 64, .external_lex_state = 2},
  [87] = {.lex_state = 64, .external_lex_state = 2},
  [88] = {.lex_state = 64, .external_lex_state = 2},
  [89] = {.lex_state = 64, .external_lex_state = 2},
  [90] = {.lex_state = 64, .external_lex_state = 2},
  [91] = {.lex_state = 64, .external_lex_state = 2},
  [92] = {.lex_state = 64, .external_lex_state = 2},
  [93] = {.lex_state = 64, .external_lex_state = 2},
  [94] = {.lex_state = 64, .external_lex_state = 2},
  [95] = {.lex_state = 64, .external_lex_state = 2},
  [96] = {.lex_state = 64, .external_lex_state = 2},
  [97] = {.lex_state = 64, .external_lex_state = 2},
  [98] = {.lex_state = 64, .external_lex_state = 3},
  [99] = {.lex_state = 64, .external_lex_state = 3},
  [100] = {.lex_state = 64, .external_lex_state = 3},
  [101] = {.lex_state = 64, .external_lex_state = 3},
  [102] = {.lex_state = 64, .external_lex_state = 3},
  [103] = {.lex_state = 64, .external_lex_state = 3},
  [104] = {.lex_state = 64, .external_lex_state = 3},
  [105] = {.lex_state = 64, .external_lex_state = 3},
  [106] = {.lex_state = 64, .external_lex_state = 3},
  [107] = {.lex_state = 64, .external_lex_state = 3},
  [108] = {.lex_state = 64, .external_lex_state = 2},
  [109] = {.lex_state = 64, .external_lex_state = 2},
  [110] = {.lex_state = 64, .external_lex_state = 3},
  [111] = {.lex_state = 64, .external_lex_state = 3},
  [112] = {.lex_state = 64, .external_lex_state = 3},
  [113] = {.lex_state = 64, .external_lex_state = 3},
  [114] = {.lex_state = 64, .external_lex_state = 3},
  [115] = {.lex_state = 64, .external_lex_state = 3},
  [116] = {.lex_state = 64, .external_lex_state = 3},
  [117] = {.lex_state = 64, .external_lex_state = 3},
  [118] = {.lex_state = 64, .external_lex_state = 3},
  [119] = {.lex_state = 64, .external_lex_state = 3},
  [120] = {.lex_state = 64, .external_lex_state = 3},
  [121] = {.lex_state = 64, .external_lex_state = 3},
  [122] = {.lex_state = 64, .external_lex_state = 3},
  [123] = {.lex_state = 64, .external_lex_state = 3},
  [124] = {.lex_state = 64, .external_lex_state = 3},
  [125] = {.lex_state = 64, .external_lex_state = 3},
  [126] = {.lex_state = 64, .external_lex_state = 3},
  [127] = {.lex_state = 64, .external_lex_state = 3},
  [128] = {.lex_state = 64, .external_lex_state = 3},
  [129] = {.lex_state = 64, .external_lex_state = 3},
  [130] = {.lex_state = 64, .external_lex_state = 3},
  [131] = {.lex_state = 64, .external_lex_state = 3},
  [132] = {.lex_state = 64, .external_lex_state = 3},
  [133] = {.lex_state = 64, .external_lex_state = 3},
  [134] = {.lex_state = 64, .external_lex_state = 3},
  [135] = {.lex_state = 64, .external_lex_state = 3},
  [136] = {.lex_state = 64, .external_lex_state = 3},
  [137] = {.lex_state = 64, .external_lex_state = 3},
  [138] = {.lex_state = 64, .external_lex_state = 2},
  [139] = {.lex_state = 64, .external_lex_state = 2},
  [140] = {.lex_state = 64, .external_lex_state = 2},
  [141] = {.lex_state = 6, .external_lex_state = 7},
  [142] = {.lex_state = 0, .external_lex_state = 2},
  [143] = {.lex_state = 64, .external_lex_state = 2},
  [144] = {.lex_state = 0, .external_lex_state = 2},
  [145] = {.lex_state = 6, .external_lex_state = 7},
  [146] = {.lex_state = 0, .external_lex_state = 2},
  [147] = {.lex_state = 64, .external_lex_state = 2},
  [148] = {.lex_state = 6, .external_lex_state = 7},
  [149] = {.lex_state = 64, .external_lex_state = 3},
  [150] = {.lex_state = 6, .external_lex_state = 2},
  [151] = {.lex_state = 64, .external_lex_state = 2},
  [152] = {.lex_state = 64, .external_lex_state = 2},
  [153] = {.lex_state = 64, .external_lex_state = 2},
  [154] = {.lex_state = 64, .external_lex_state = 2},
  [155] = {.lex_state = 64, .external_lex_state = 2},
  [156] = {.lex_state = 64, .external_lex_state = 2},
  [157] = {.lex_state = 64, .external_lex_state = 2},
  [158] = {.lex_state = 64, .external_lex_state = 2},
  [159] = {.lex_state = 64, .external_lex_state = 2},
  [160] = {.lex_state = 64, .external_lex_state = 2},
  [161] = {.lex_state = 64, .external_lex_state = 2},
  [162] = {.lex_state = 6, .external_lex_state = 2},
  [163] = {.lex_state = 6, .external_lex_state = 2},
  [164] = {.lex_state = 1, .external_lex_state = 2},
  [165] = {.lex_state = 64, .external_lex_state = 2},
  [166] = {.lex_state = 1, .external_lex_state = 2},
  [167] = {.lex_state = 6, .external_lex_state = 2},
  [168] = {.lex_state = 6, .external_lex_state = 2},
  [169] = {.lex_state = 64, .external_lex_state = 2},
  [170] = {.lex_state = 0, .external_lex_state = 2},
  [171] = {.lex_state = 5, .external_lex_state = 2},
  [172] = {.lex_state = 2, .external_lex_state = 2},
  [173] = {.lex_state = 5, .external_lex_state = 2},
  [174] = {.lex_state = 2, .external_lex_state = 2},
  [175] = {.lex_state = 6, .external_lex_state = 7},
  [176] = {.lex_state = 3, .external_lex_state = 8},
  [177] = {.lex_state = 5, .external_lex_state = 2},
  [178] = {.lex_state = 3, .external_lex_state = 8},
  [179] = {.lex_state = 2, .external_lex_state = 2},
  [180] = {.lex_state = 5, .external_lex_state = 2},
  [181] = {.lex_state = 2, .external_lex_state = 2},
  [182] = {.lex_state = 5, .external_lex_state = 2},
  [183] = {.lex_state = 2, .external_lex_state = 2},
  [184] = {.lex_state = 6, .external_lex_state = 7},
  [185] = {.lex_state = 3, .external_lex_state = 8},
  [186] = {.lex_state = 6, .external_lex_state = 7},
  [187] = {.lex_state = 0, .external_lex_state = 2},
  [188] = {.lex_state = 6, .external_lex_state = 7},
  [189] = {.lex_state = 0, .external_lex_state = 2},
  [190] = {.lex_state = 0, .external_lex_state = 2},
  [191] = {.lex_state = 0, .external_lex_state = 2},
  [192] = {.lex_state = 0, .external_lex_state = 2},
  [193] = {.lex_state = 0, .external_lex_state = 2},
  [194] = {.lex_state = 6, .external_lex_state = 2},
  [195] = {.lex_state = 3, .external_lex_state = 8},
  [196] = {.lex_state = 6, .external_lex_state = 7},
  [197] = {.lex_state = 6, .external_lex_state = 7},
  [198] = {.lex_state = 6, .external_lex_state = 2},
  [199] = {.lex_state = 6, .external_lex_state = 2},
  [200] = {.lex_state = 6, .external_lex_state = 2},
  [201] = {.lex_state = 6, .external_lex_state = 2},
  [202] = {.lex_state = 5, .external_lex_state = 2},
  [203] = {.lex_state = 6, .external_lex_state = 2},
  [204] = {.lex_state = 5, .external_lex_state = 2},
  [205] = {.lex_state = 2, .external_lex_state = 2},
  [206] = {.lex_state = 0, .external_lex_state = 9},
  [207] = {.lex_state = 0, .external_lex_state = 10},
  [208] = {.lex_state = 2, .external_lex_state = 2},
  [209] = {.lex_state = 0, .external_lex_state = 9},
  [210] = {.lex_state = 0, .external_lex_state = 9},
  [211] = {.lex_state = 0, .external_lex_state = 10},
  [212] = {.lex_state = 0, .external_lex_state = 9},
  [213] = {.lex_state = 0, .external_lex_state = 2},
  [214] = {.lex_state = 0, .external_lex_state = 2},
  [215] = {.lex_state = 0, .external_lex_state = 2},
  [216] = {.lex_state = 0, .external_lex_state = 2},
  [217] = {.lex_state = 0, .external_lex_state = 2},
  [218] = {.lex_state = 3, .external_lex_state = 11},
  [219] = {.lex_state = 3, .external_lex_state = 11},
  [220] = {.lex_state = 0, .external_lex_state = 2},
  [221] = {.lex_state = 0, .external_lex_state = 12},
  [222] = {.lex_state = 0, .external_lex_state = 12},
  [223] = {.lex_state = 0, .external_lex_state = 2},
  [224] = {.lex_state = 3, .external_lex_state = 11},
  [225] = {.lex_state = 0, .external_lex_state = 2},
  [226] = {.lex_state = 0, .external_lex_state = 9},
  [227] = {.lex_state = 0, .external_lex_state = 13},
  [228] = {.lex_state = 0, .external_lex_state = 9},
  [229] = {.lex_state = 0, .external_lex_state = 9},
  [230] = {.lex_state = 0, .external_lex_state = 2},
  [231] = {.lex_state = 0, .external_lex_state = 2},
  [232] = {.lex_state = 3, .external_lex_state = 11},
  [233] = {.lex_state = 0, .external_lex_state = 2},
  [234] = {.lex_state = 0, .external_lex_state = 14},
  [235] = {.lex_state = 0, .external_lex_state = 2},
  [236] = {.lex_state = 0, .external_lex_state = 13},
  [237] = {.lex_state = 0, .external_lex_state = 2},
  [238] = {.lex_state = 0, .external_lex_state = 15},
  [239] = {.lex_state = 0, .external_lex_state = 13},
  [240] = {.lex_state = 0, .external_lex_state = 16},
  [241] = {.lex_state = 0, .external_lex_state = 2},
  [242] = {.lex_state = 0, .external_lex_state = 9},
  [243] = {.lex_state = 0, .external_lex_state = 2},
  [244] = {.lex_state = 0, .external_lex_state = 16},
  [245] = {.lex_state = 0, .external_lex_state = 13},
  [246] = {.lex_state = 0, .external_lex_state = 2},
  [247] = {.lex_state = 0, .external_lex_state = 2},
  [248] = {.lex_state = 0, .external_lex_state = 2},
  [249] = {.lex_state = 0, .external_lex_state = 2},
  [250] = {.lex_state = 0, .external_lex_state = 13},
  [251] = {.lex_state = 3, .external_lex_state = 2},
  [252] = {.lex_state = 0, .external_lex_state = 2},
  [253] = {.lex_state = 0, .external_lex_state = 2},
  [254] = {.lex_state = 0, .external_lex_state = 2},
  [255] = {.lex_state = 0, .external_lex_state = 2},
  [256] = {.lex_state = 0, .external_lex_state = 2},
  [257] = {.lex_state = 0, .external_lex_state = 2},
  [258] = {.lex_state = 0, .external_lex_state = 2},
  [259] = {.lex_state = 0, .external_lex_state = 2},
  [260] = {.lex_state = 0, .external_lex_state = 2},
  [261] = {.lex_state = 0, .external_lex_state = 2},
  [262] = {.lex_state = 0, .external_lex_state = 2},
  [263] = {.lex_state = 0, .external_lex_state = 17},
  [264] = {.lex_state = 0, .external_lex_state = 13},
  [265] = {.lex_state = 0, .external_lex_state = 2},
  [266] = {.lex_state = 0, .external_lex_state = 2},
  [267] = {.lex_state = 0, .external_lex_state = 2},
  [268] = {.lex_state = 0, .external_lex_state = 2},
  [269] = {.lex_state = 0, .external_lex_state = 18},
  [270] = {.lex_state = 0, .external_lex_state = 2},
  [271] = {.lex_state = 0, .external_lex_state = 13},
  [272] = {.lex_state = 0, .external_lex_state = 2},
  [273] = {.lex_state = 0, .external_lex_state = 2},
  [274] = {.lex_state = 0, .external_lex_state = 2},
  [275] = {.lex_state = 0, .external_lex_state = 2},
  [276] = {.lex_state = 0, .external_lex_state = 2},
  [277] = {.lex_state = 0, .external_lex_state = 13},
  [278] = {.lex_state = 0, .external_lex_state = 2},
  [279] = {.lex_state = 0, .external_lex_state = 2},
  [280] = {.lex_state = 0, .external_lex_state = 13},
  [281] = {.lex_state = 0, .external_lex_state = 2},
  [282] = {.lex_state = 0, .external_lex_state = 2},
  [283] = {.lex_state = 0, .external_lex_state = 2},
  [284] = {.lex_state = 0, .external_lex_state = 13},
  [285] = {.lex_state = 0, .external_lex_state = 2},
  [286] = {.lex_state = 0, .external_lex_state = 2},
  [287] = {.lex_state = 0, .external_lex_state = 2},
  [288] = {.lex_state = 0, .external_lex_state = 13},
  [289] = {.lex_state = 0, .external_lex_state = 2},
  [290] = {.lex_state = 0, .external_lex_state = 2},
  [291] = {.lex_state = 0, .external_lex_state = 2},
  [292] = {.lex_state = 0, .external_lex_state = 2},
  [293] = {.lex_state = 0, .external_lex_state = 2},
  [294] = {.lex_state = 0, .external_lex_state = 13},
  [295] = {.lex_state = 0, .external_lex_state = 13},
  [296] = {.lex_state = 0, .external_lex_state = 13},
  [297] = {.lex_state = 0, .external_lex_state = 2},
  [298] = {.lex_state = 0, .external_lex_state = 2},
  [299] = {.lex_state = 0, .external_lex_state = 2},
  [300] = {.lex_state = 0, .external_lex_state = 2},
  [301] = {.lex_state = 62, .external_lex_state = 2},
  [302] = {.lex_state = 0, .external_lex_state = 13},
  [303] = {.lex_state = 0, .external_lex_state = 2},
  [304] = {.lex_state = 0, .external_lex_state = 2},
  [305] = {.lex_state = 0, .external_lex_state = 2},
  [306] = {.lex_state = 0, .external_lex_state = 2},
  [307] = {.lex_state = 0, .external_lex_state = 2},
  [308] = {.lex_state = 0, .external_lex_state = 2},
  [309] = {.lex_state = 0, .external_lex_state = 2},
  [310] = {.lex_state = 20, .external_lex_state = 2},
  [311] = {.lex_state = 0, .external_lex_state = 2},
  [312] = {.lex_state = 0, .external_lex_state = 2},
  [313] = {.lex_state = 3, .external_lex_state = 2},
  [314] = {.lex_state = 0, .external_lex_state = 2},
  [315] = {.lex_state = 0, .external_lex_state = 2},
  [316] = {.lex_state = 0, .external_lex_state = 2},
  [317] = {.lex_state = 0, .external_lex_state = 2},
  [318] = {.lex_state = 0, .external_lex_state = 2},
  [319] = {.lex_state = 0, .external_lex_state = 2},
  [320] = {.lex_state = 0, .external_lex_state = 2},
  [321] = {.lex_state = 0, .external_lex_state = 2},
  [322] = {.lex_state = 0, .external_lex_state = 18},
  [323] = {.lex_state = 0, .external_lex_state = 2},
  [324] = {.lex_state = 62, .external_lex_state = 2},
  [325] = {.lex_state = 0, .external_lex_state = 2},
  [326] = {.lex_state = 0, .external_lex_state = 2},
  [327] = {.lex_state = 0, .external_lex_state = 2},
  [328] = {.lex_state = 0, .external_lex_state = 2},
  [329] = {.lex_state = 0, .external_lex_state = 2},
  [330] = {.lex_state = 0, .external_lex_state = 17},
  [331] = {.lex_state = 0, .external_lex_state = 2},
  [332] = {.lex_state = 0, .external_lex_state = 2},
  [333] = {.lex_state = 0, .external_lex_state = 2},
  [334] = {.lex_state = 0, .external_lex_state = 2},
  [335] = {.lex_state = 0, .external_lex_state = 2},
  [336] = {.lex_state = 0, .external_lex_state = 13},
  [337] = {.lex_state = 0, .external_lex_state = 13},
  [338] = {.lex_state = 0, .external_lex_state = 13},
  [339] = {.lex_state = 0, .external_lex_state = 2},
  [340] = {.lex_state = 0, .external_lex_state = 2},
  [341] = {.lex_state = 0, .external_lex_state = 2},
  [342] = {.lex_state = 0, .external_lex_state = 2},
  [343] = {.lex_state = 0, .external_lex_state = 2},
  [344] = {.lex_state = 0, .external_lex_state = 2},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_LT_BANG] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [sym__doctype] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_SLASH_GT] = ACTIONS(1),
    [anon_sym_LT_SLASH] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [sym_entity] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_each] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_key] = ACTIONS(1),
    [anon_sym_snippet] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [aux_sym__tag_value_token1] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_html] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_debug] = ACTIONS(1),
    [anon_sym_render] = ACTIONS(1),
    [sym__start_tag_name] = ACTIONS(1),
    [sym__script_start_tag_name] = ACTIONS(1),
    [sym__style_start_tag_name] = ACTIONS(1),
    [sym__end_tag_name] = ACTIONS(1),
    [sym_erroneous_end_tag_name] = ACTIONS(1),
    [sym__implicit_end_tag] = ACTIONS(1),
    [sym_raw_text] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_svelte_raw_text] = ACTIONS(1),
    [sym_svelte_raw_text_each] = ACTIONS(1),
    [sym_svelte_raw_text_snippet_arguments] = ACTIONS(1),
  },
  [1] = {
    [sym_document] = STATE(281),
    [sym_doctype] = STATE(140),
    [sym__node] = STATE(28),
    [sym_element] = STATE(140),
    [sym_script_element] = STATE(140),
    [sym_style_element] = STATE(140),
    [sym_start_tag] = STATE(15),
    [sym_script_start_tag] = STATE(210),
    [sym_style_start_tag] = STATE(209),
    [sym_self_closing_tag] = STATE(108),
    [sym_erroneous_end_tag] = STATE(140),
    [sym_if_statement] = STATE(140),
    [sym_if_start] = STATE(3),
    [sym_each_statement] = STATE(140),
    [sym_each_start] = STATE(10),
    [sym_await_statement] = STATE(140),
    [sym_await_start] = STATE(6),
    [sym_key_statement] = STATE(140),
    [sym_key_start] = STATE(33),
    [sym_snippet_statement] = STATE(140),
    [sym_snippet_start] = STATE(20),
    [sym_expression] = STATE(140),
    [sym_html_tag] = STATE(140),
    [sym_const_tag] = STATE(140),
    [sym_debug_tag] = STATE(140),
    [sym_render_tag] = STATE(140),
    [aux_sym_document_repeat1] = STATE(28),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_LT_BANG] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(9),
    [anon_sym_LT_SLASH] = ACTIONS(11),
    [sym_entity] = ACTIONS(13),
    [sym_text] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [aux_sym__tag_value_token1] = ACTIONS(3),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 22,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(37), 1,
      sym_else_if_start,
    STATE(40), 1,
      sym_else_start,
    STATE(72), 1,
      sym_if_end,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    STATE(230), 1,
      sym_else_block,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(73), 2,
      sym_else_if_block,
      aux_sym_if_statement_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [85] = 22,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(37), 1,
      sym_else_if_start,
    STATE(40), 1,
      sym_else_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(143), 1,
      sym_if_end,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    STATE(217), 1,
      sym_else_block,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(2), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(144), 2,
      sym_else_if_block,
      aux_sym_if_statement_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [170] = 22,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(37), 1,
      sym_else_if_start,
    STATE(40), 1,
      sym_else_start,
    STATE(103), 1,
      sym_if_end,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    STATE(216), 1,
      sym_else_block,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(5), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(142), 2,
      sym_else_if_block,
      aux_sym_if_statement_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [255] = 22,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(37), 1,
      sym_else_if_start,
    STATE(40), 1,
      sym_else_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(115), 1,
      sym_if_end,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    STATE(225), 1,
      sym_else_block,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(146), 2,
      sym_else_if_block,
      aux_sym_if_statement_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [340] = 22,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(38), 1,
      sym_catch_start,
    STATE(43), 1,
      sym_then_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(109), 1,
      sym_await_end,
    STATE(190), 1,
      sym_then_block,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    STATE(246), 1,
      sym_catch_block,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(7), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [424] = 22,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(38), 1,
      sym_catch_start,
    STATE(43), 1,
      sym_then_start,
    STATE(75), 1,
      sym_await_end,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(189), 1,
      sym_then_block,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    STATE(243), 1,
      sym_catch_block,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [508] = 22,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(23), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(38), 1,
      sym_catch_start,
    STATE(43), 1,
      sym_then_start,
    STATE(105), 1,
      sym_await_end,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(192), 1,
      sym_then_block,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    STATE(213), 1,
      sym_catch_block,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(9), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [592] = 22,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(23), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(38), 1,
      sym_catch_start,
    STATE(43), 1,
      sym_then_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(117), 1,
      sym_await_end,
    STATE(193), 1,
      sym_then_block,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    STATE(231), 1,
      sym_catch_block,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [676] = 20,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(31), 1,
      sym_else_block,
    STATE(33), 1,
      sym_key_start,
    STATE(44), 1,
      sym_else_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(147), 1,
      sym_each_end,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(11), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [754] = 20,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(25), 1,
      sym_else_block,
    STATE(33), 1,
      sym_key_start,
    STATE(44), 1,
      sym_else_start,
    STATE(74), 1,
      sym_each_end,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [832] = 20,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(36), 1,
      sym_else_block,
    STATE(44), 1,
      sym_else_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(116), 1,
      sym_each_end,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [910] = 20,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(32), 1,
      sym_else_block,
    STATE(33), 1,
      sym_key_start,
    STATE(44), 1,
      sym_else_start,
    STATE(104), 1,
      sym_each_end,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(12), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [988] = 19,
    ACTIONS(29), 1,
      anon_sym_LT_BANG,
    ACTIONS(31), 1,
      anon_sym_LT,
    ACTIONS(33), 1,
      anon_sym_LT_SLASH,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      sym__implicit_end_tag,
    STATE(4), 1,
      sym_if_start,
    STATE(8), 1,
      sym_await_start,
    STATE(13), 1,
      sym_each_start,
    STATE(17), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start,
    STATE(30), 1,
      sym_snippet_start,
    STATE(69), 1,
      sym_end_tag,
    STATE(99), 1,
      sym_self_closing_tag,
    STATE(206), 1,
      sym_script_start_tag,
    STATE(212), 1,
      sym_style_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(35), 2,
      sym_entity,
      sym_text,
    STATE(27), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(98), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [1063] = 19,
    ACTIONS(29), 1,
      anon_sym_LT_BANG,
    ACTIONS(31), 1,
      anon_sym_LT,
    ACTIONS(33), 1,
      anon_sym_LT_SLASH,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(41), 1,
      sym__implicit_end_tag,
    STATE(4), 1,
      sym_if_start,
    STATE(8), 1,
      sym_await_start,
    STATE(13), 1,
      sym_each_start,
    STATE(17), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start,
    STATE(30), 1,
      sym_snippet_start,
    STATE(61), 1,
      sym_end_tag,
    STATE(99), 1,
      sym_self_closing_tag,
    STATE(206), 1,
      sym_script_start_tag,
    STATE(212), 1,
      sym_style_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(35), 2,
      sym_entity,
      sym_text,
    STATE(14), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(98), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [1138] = 19,
    ACTIONS(29), 1,
      anon_sym_LT_BANG,
    ACTIONS(31), 1,
      anon_sym_LT,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_LT_SLASH,
    ACTIONS(45), 1,
      sym__implicit_end_tag,
    STATE(4), 1,
      sym_if_start,
    STATE(8), 1,
      sym_await_start,
    STATE(13), 1,
      sym_each_start,
    STATE(17), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start,
    STATE(30), 1,
      sym_snippet_start,
    STATE(99), 1,
      sym_self_closing_tag,
    STATE(112), 1,
      sym_end_tag,
    STATE(206), 1,
      sym_script_start_tag,
    STATE(212), 1,
      sym_style_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(35), 2,
      sym_entity,
      sym_text,
    STATE(27), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(98), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [1213] = 19,
    ACTIONS(29), 1,
      anon_sym_LT_BANG,
    ACTIONS(31), 1,
      anon_sym_LT,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_LT_SLASH,
    ACTIONS(47), 1,
      sym__implicit_end_tag,
    STATE(4), 1,
      sym_if_start,
    STATE(8), 1,
      sym_await_start,
    STATE(13), 1,
      sym_each_start,
    STATE(17), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start,
    STATE(30), 1,
      sym_snippet_start,
    STATE(99), 1,
      sym_self_closing_tag,
    STATE(100), 1,
      sym_end_tag,
    STATE(206), 1,
      sym_script_start_tag,
    STATE(212), 1,
      sym_style_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(35), 2,
      sym_entity,
      sym_text,
    STATE(16), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(98), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [1288] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(118), 1,
      sym_key_end,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [1360] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(51), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(136), 1,
      sym_each_end,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [1432] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(62), 1,
      sym_snippet_end,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(22), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [1504] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(76), 1,
      sym_key_end,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [1576] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(77), 1,
      sym_snippet_end,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [1648] = 18,
    ACTIONS(57), 1,
      ts_builtin_sym_end,
    ACTIONS(59), 1,
      anon_sym_LT_BANG,
    ACTIONS(62), 1,
      anon_sym_LT,
    ACTIONS(65), 1,
      anon_sym_LT_SLASH,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(68), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [1720] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(74), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(90), 1,
      sym_each_end,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [1792] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(74), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(90), 1,
      sym_each_end,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(26), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [1864] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(74), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(96), 1,
      sym_each_end,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [1936] = 18,
    ACTIONS(57), 1,
      sym__implicit_end_tag,
    ACTIONS(76), 1,
      anon_sym_LT_BANG,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(82), 1,
      anon_sym_LT_SLASH,
    ACTIONS(88), 1,
      anon_sym_LBRACE,
    STATE(4), 1,
      sym_if_start,
    STATE(8), 1,
      sym_await_start,
    STATE(13), 1,
      sym_each_start,
    STATE(17), 1,
      sym_start_tag,
    STATE(29), 1,
      sym_key_start,
    STATE(30), 1,
      sym_snippet_start,
    STATE(99), 1,
      sym_self_closing_tag,
    STATE(206), 1,
      sym_script_start_tag,
    STATE(212), 1,
      sym_style_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(85), 2,
      sym_entity,
      sym_text,
    STATE(27), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(98), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [2008] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(91), 1,
      ts_builtin_sym_end,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [2080] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(49), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(106), 1,
      sym_key_end,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(18), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [2152] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(107), 1,
      sym_snippet_end,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(34), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [2224] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(74), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(74), 1,
      sym_each_end,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(24), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [2296] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(51), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(116), 1,
      sym_each_end,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(35), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [2368] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(66), 1,
      sym_key_end,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(21), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [2440] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(119), 1,
      sym_snippet_end,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [2512] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(51), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(130), 1,
      sym_each_end,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [2584] = 18,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(51), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(130), 1,
      sym_each_end,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(19), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [2656] = 17,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(95), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(42), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [2725] = 17,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(98), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(41), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [2794] = 17,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(101), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [2863] = 17,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(104), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(46), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [2932] = 17,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(107), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [3001] = 17,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(110), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [3070] = 17,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(113), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(39), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [3139] = 17,
    ACTIONS(104), 1,
      anon_sym_LBRACE,
    ACTIONS(116), 1,
      anon_sym_LT_BANG,
    ACTIONS(119), 1,
      anon_sym_LT,
    ACTIONS(122), 1,
      anon_sym_LT_SLASH,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(125), 2,
      sym_entity,
      sym_text,
    STATE(45), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [3208] = 17,
    ACTIONS(128), 1,
      anon_sym_LT_BANG,
    ACTIONS(131), 1,
      anon_sym_LT,
    ACTIONS(134), 1,
      anon_sym_LT_SLASH,
    ACTIONS(140), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(137), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [3277] = 17,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(140), 1,
      anon_sym_LBRACE,
    STATE(3), 1,
      sym_if_start,
    STATE(6), 1,
      sym_await_start,
    STATE(10), 1,
      sym_each_start,
    STATE(15), 1,
      sym_start_tag,
    STATE(20), 1,
      sym_snippet_start,
    STATE(33), 1,
      sym_key_start,
    STATE(108), 1,
      sym_self_closing_tag,
    STATE(209), 1,
      sym_style_start_tag,
    STATE(210), 1,
      sym_script_start_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(13), 2,
      sym_entity,
      sym_text,
    STATE(23), 2,
      sym__node,
      aux_sym_document_repeat1,
    STATE(140), 15,
      sym_doctype,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_if_statement,
      sym_each_statement,
      sym_await_statement,
      sym_key_statement,
      sym_snippet_statement,
      sym_expression,
      sym_html_tag,
      sym_const_tag,
      sym_debug_tag,
      sym_render_tag,
  [3346] = 18,
    ACTIONS(143), 1,
      anon_sym_POUND,
    ACTIONS(145), 1,
      anon_sym_COLON,
    ACTIONS(147), 1,
      anon_sym_SLASH,
    ACTIONS(149), 1,
      anon_sym_AT,
    ACTIONS(151), 1,
      sym_svelte_raw_text,
    STATE(222), 1,
      sym__each_start_tag,
    STATE(236), 1,
      sym__then_tag,
    STATE(239), 1,
      sym__catch_tag,
    STATE(253), 1,
      sym__render_tag,
    STATE(271), 1,
      sym__if_start_tag,
    STATE(295), 1,
      sym__await_start_tag,
    STATE(296), 1,
      sym__key_start_tag,
    STATE(313), 1,
      sym__snippet_start_tag,
    STATE(315), 1,
      sym__html_tag,
    STATE(321), 1,
      sym__const_tag,
    STATE(333), 1,
      sym__await_end_tag,
    STATE(335), 1,
      sym__debug_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [3402] = 18,
    ACTIONS(143), 1,
      anon_sym_POUND,
    ACTIONS(149), 1,
      anon_sym_AT,
    ACTIONS(151), 1,
      sym_svelte_raw_text,
    ACTIONS(153), 1,
      anon_sym_COLON,
    ACTIONS(155), 1,
      anon_sym_SLASH,
    STATE(222), 1,
      sym__each_start_tag,
    STATE(253), 1,
      sym__render_tag,
    STATE(271), 1,
      sym__if_start_tag,
    STATE(284), 1,
      sym__else_if_tag,
    STATE(285), 1,
      sym__else_tag,
    STATE(286), 1,
      sym__if_end_tag,
    STATE(295), 1,
      sym__await_start_tag,
    STATE(296), 1,
      sym__key_start_tag,
    STATE(313), 1,
      sym__snippet_start_tag,
    STATE(315), 1,
      sym__html_tag,
    STATE(321), 1,
      sym__const_tag,
    STATE(335), 1,
      sym__debug_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [3458] = 18,
    ACTIONS(143), 1,
      anon_sym_POUND,
    ACTIONS(149), 1,
      anon_sym_AT,
    ACTIONS(151), 1,
      sym_svelte_raw_text,
    ACTIONS(153), 1,
      anon_sym_COLON,
    ACTIONS(155), 1,
      anon_sym_SLASH,
    STATE(222), 1,
      sym__each_start_tag,
    STATE(253), 1,
      sym__render_tag,
    STATE(271), 1,
      sym__if_start_tag,
    STATE(284), 1,
      sym__else_if_tag,
    STATE(285), 1,
      sym__else_tag,
    STATE(295), 1,
      sym__await_start_tag,
    STATE(296), 1,
      sym__key_start_tag,
    STATE(313), 1,
      sym__snippet_start_tag,
    STATE(315), 1,
      sym__html_tag,
    STATE(321), 1,
      sym__const_tag,
    STATE(335), 1,
      sym__debug_tag,
    STATE(340), 1,
      sym__if_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [3514] = 18,
    ACTIONS(143), 1,
      anon_sym_POUND,
    ACTIONS(145), 1,
      anon_sym_COLON,
    ACTIONS(147), 1,
      anon_sym_SLASH,
    ACTIONS(149), 1,
      anon_sym_AT,
    ACTIONS(151), 1,
      sym_svelte_raw_text,
    STATE(222), 1,
      sym__each_start_tag,
    STATE(236), 1,
      sym__then_tag,
    STATE(239), 1,
      sym__catch_tag,
    STATE(253), 1,
      sym__render_tag,
    STATE(271), 1,
      sym__if_start_tag,
    STATE(295), 1,
      sym__await_start_tag,
    STATE(296), 1,
      sym__key_start_tag,
    STATE(303), 1,
      sym__await_end_tag,
    STATE(313), 1,
      sym__snippet_start_tag,
    STATE(315), 1,
      sym__html_tag,
    STATE(321), 1,
      sym__const_tag,
    STATE(335), 1,
      sym__debug_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [3570] = 17,
    ACTIONS(143), 1,
      anon_sym_POUND,
    ACTIONS(149), 1,
      anon_sym_AT,
    ACTIONS(151), 1,
      sym_svelte_raw_text,
    ACTIONS(157), 1,
      anon_sym_COLON,
    ACTIONS(159), 1,
      anon_sym_SLASH,
    STATE(222), 1,
      sym__each_start_tag,
    STATE(253), 1,
      sym__render_tag,
    STATE(271), 1,
      sym__if_start_tag,
    STATE(285), 1,
      sym__else_tag,
    STATE(295), 1,
      sym__await_start_tag,
    STATE(296), 1,
      sym__key_start_tag,
    STATE(312), 1,
      sym__each_end_tag,
    STATE(313), 1,
      sym__snippet_start_tag,
    STATE(315), 1,
      sym__html_tag,
    STATE(321), 1,
      sym__const_tag,
    STATE(335), 1,
      sym__debug_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [3623] = 17,
    ACTIONS(143), 1,
      anon_sym_POUND,
    ACTIONS(149), 1,
      anon_sym_AT,
    ACTIONS(151), 1,
      sym_svelte_raw_text,
    ACTIONS(157), 1,
      anon_sym_COLON,
    ACTIONS(159), 1,
      anon_sym_SLASH,
    STATE(222), 1,
      sym__each_start_tag,
    STATE(253), 1,
      sym__render_tag,
    STATE(271), 1,
      sym__if_start_tag,
    STATE(285), 1,
      sym__else_tag,
    STATE(295), 1,
      sym__await_start_tag,
    STATE(296), 1,
      sym__key_start_tag,
    STATE(299), 1,
      sym__each_end_tag,
    STATE(313), 1,
      sym__snippet_start_tag,
    STATE(315), 1,
      sym__html_tag,
    STATE(321), 1,
      sym__const_tag,
    STATE(335), 1,
      sym__debug_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [3676] = 15,
    ACTIONS(143), 1,
      anon_sym_POUND,
    ACTIONS(149), 1,
      anon_sym_AT,
    ACTIONS(151), 1,
      sym_svelte_raw_text,
    ACTIONS(159), 1,
      anon_sym_SLASH,
    STATE(222), 1,
      sym__each_start_tag,
    STATE(253), 1,
      sym__render_tag,
    STATE(271), 1,
      sym__if_start_tag,
    STATE(295), 1,
      sym__await_start_tag,
    STATE(296), 1,
      sym__key_start_tag,
    STATE(312), 1,
      sym__each_end_tag,
    STATE(313), 1,
      sym__snippet_start_tag,
    STATE(315), 1,
      sym__html_tag,
    STATE(321), 1,
      sym__const_tag,
    STATE(335), 1,
      sym__debug_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [3723] = 15,
    ACTIONS(143), 1,
      anon_sym_POUND,
    ACTIONS(149), 1,
      anon_sym_AT,
    ACTIONS(151), 1,
      sym_svelte_raw_text,
    ACTIONS(161), 1,
      anon_sym_SLASH,
    STATE(222), 1,
      sym__each_start_tag,
    STATE(253), 1,
      sym__render_tag,
    STATE(268), 1,
      sym__snippet_end_tag,
    STATE(271), 1,
      sym__if_start_tag,
    STATE(295), 1,
      sym__await_start_tag,
    STATE(296), 1,
      sym__key_start_tag,
    STATE(313), 1,
      sym__snippet_start_tag,
    STATE(315), 1,
      sym__html_tag,
    STATE(321), 1,
      sym__const_tag,
    STATE(335), 1,
      sym__debug_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [3770] = 15,
    ACTIONS(143), 1,
      anon_sym_POUND,
    ACTIONS(149), 1,
      anon_sym_AT,
    ACTIONS(151), 1,
      sym_svelte_raw_text,
    ACTIONS(163), 1,
      anon_sym_SLASH,
    STATE(222), 1,
      sym__each_start_tag,
    STATE(253), 1,
      sym__render_tag,
    STATE(258), 1,
      sym__key_end_tag,
    STATE(271), 1,
      sym__if_start_tag,
    STATE(295), 1,
      sym__await_start_tag,
    STATE(296), 1,
      sym__key_start_tag,
    STATE(313), 1,
      sym__snippet_start_tag,
    STATE(315), 1,
      sym__html_tag,
    STATE(321), 1,
      sym__const_tag,
    STATE(335), 1,
      sym__debug_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [3817] = 15,
    ACTIONS(143), 1,
      anon_sym_POUND,
    ACTIONS(149), 1,
      anon_sym_AT,
    ACTIONS(151), 1,
      sym_svelte_raw_text,
    ACTIONS(159), 1,
      anon_sym_SLASH,
    STATE(222), 1,
      sym__each_start_tag,
    STATE(253), 1,
      sym__render_tag,
    STATE(271), 1,
      sym__if_start_tag,
    STATE(295), 1,
      sym__await_start_tag,
    STATE(296), 1,
      sym__key_start_tag,
    STATE(299), 1,
      sym__each_end_tag,
    STATE(313), 1,
      sym__snippet_start_tag,
    STATE(315), 1,
      sym__html_tag,
    STATE(321), 1,
      sym__const_tag,
    STATE(335), 1,
      sym__debug_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [3864] = 15,
    ACTIONS(143), 1,
      anon_sym_POUND,
    ACTIONS(149), 1,
      anon_sym_AT,
    ACTIONS(151), 1,
      sym_svelte_raw_text,
    ACTIONS(163), 1,
      anon_sym_SLASH,
    STATE(222), 1,
      sym__each_start_tag,
    STATE(253), 1,
      sym__render_tag,
    STATE(271), 1,
      sym__if_start_tag,
    STATE(295), 1,
      sym__await_start_tag,
    STATE(296), 1,
      sym__key_start_tag,
    STATE(307), 1,
      sym__key_end_tag,
    STATE(313), 1,
      sym__snippet_start_tag,
    STATE(315), 1,
      sym__html_tag,
    STATE(321), 1,
      sym__const_tag,
    STATE(335), 1,
      sym__debug_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [3911] = 15,
    ACTIONS(143), 1,
      anon_sym_POUND,
    ACTIONS(149), 1,
      anon_sym_AT,
    ACTIONS(151), 1,
      sym_svelte_raw_text,
    ACTIONS(161), 1,
      anon_sym_SLASH,
    STATE(222), 1,
      sym__each_start_tag,
    STATE(253), 1,
      sym__render_tag,
    STATE(271), 1,
      sym__if_start_tag,
    STATE(295), 1,
      sym__await_start_tag,
    STATE(296), 1,
      sym__key_start_tag,
    STATE(308), 1,
      sym__snippet_end_tag,
    STATE(313), 1,
      sym__snippet_start_tag,
    STATE(315), 1,
      sym__html_tag,
    STATE(321), 1,
      sym__const_tag,
    STATE(335), 1,
      sym__debug_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [3958] = 13,
    ACTIONS(143), 1,
      anon_sym_POUND,
    ACTIONS(149), 1,
      anon_sym_AT,
    ACTIONS(151), 1,
      sym_svelte_raw_text,
    STATE(222), 1,
      sym__each_start_tag,
    STATE(253), 1,
      sym__render_tag,
    STATE(271), 1,
      sym__if_start_tag,
    STATE(295), 1,
      sym__await_start_tag,
    STATE(296), 1,
      sym__key_start_tag,
    STATE(313), 1,
      sym__snippet_start_tag,
    STATE(315), 1,
      sym__html_tag,
    STATE(321), 1,
      sym__const_tag,
    STATE(335), 1,
      sym__debug_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [3999] = 13,
    ACTIONS(143), 1,
      anon_sym_POUND,
    ACTIONS(149), 1,
      anon_sym_AT,
    ACTIONS(165), 1,
      sym_svelte_raw_text,
    STATE(222), 1,
      sym__each_start_tag,
    STATE(271), 1,
      sym__if_start_tag,
    STATE(295), 1,
      sym__await_start_tag,
    STATE(296), 1,
      sym__key_start_tag,
    STATE(313), 1,
      sym__snippet_start_tag,
    STATE(325), 1,
      sym__html_tag,
    STATE(326), 1,
      sym__const_tag,
    STATE(327), 1,
      sym__debug_tag,
    STATE(328), 1,
      sym__render_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [4040] = 3,
    ACTIONS(169), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(167), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4056] = 3,
    ACTIONS(173), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(171), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4072] = 3,
    ACTIONS(177), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(175), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4088] = 3,
    ACTIONS(181), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(179), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4104] = 7,
    ACTIONS(183), 1,
      anon_sym_GT,
    ACTIONS(185), 1,
      anon_sym_SLASH_GT,
    ACTIONS(187), 1,
      sym_attribute_name,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    STATE(196), 1,
      sym_expression,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    STATE(81), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [4128] = 3,
    ACTIONS(193), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(191), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4144] = 3,
    ACTIONS(197), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(195), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4160] = 3,
    ACTIONS(201), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(199), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4176] = 3,
    ACTIONS(205), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(203), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4192] = 3,
    ACTIONS(209), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(207), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4208] = 3,
    ACTIONS(213), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(211), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4224] = 3,
    ACTIONS(217), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(215), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4240] = 7,
    ACTIONS(219), 1,
      anon_sym_LBRACE,
    STATE(37), 1,
      sym_else_if_start,
    STATE(40), 1,
      sym_else_start,
    STATE(88), 1,
      sym_if_end,
    STATE(248), 1,
      sym_else_block,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    STATE(187), 2,
      sym_else_if_block,
      aux_sym_if_statement_repeat1,
  [4264] = 3,
    ACTIONS(223), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(221), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4280] = 3,
    ACTIONS(227), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(225), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4296] = 3,
    ACTIONS(231), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(229), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4312] = 3,
    ACTIONS(235), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(233), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4328] = 3,
    ACTIONS(239), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(237), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4344] = 3,
    ACTIONS(243), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(241), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4360] = 3,
    ACTIONS(247), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(245), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4376] = 6,
    ACTIONS(251), 1,
      sym_attribute_name,
    ACTIONS(254), 1,
      anon_sym_LBRACE,
    STATE(196), 1,
      sym_expression,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(249), 2,
      anon_sym_GT,
      anon_sym_SLASH_GT,
    STATE(81), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [4398] = 3,
    ACTIONS(259), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(257), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4414] = 3,
    ACTIONS(263), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(261), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4430] = 3,
    ACTIONS(267), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(265), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4446] = 3,
    ACTIONS(271), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(269), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4462] = 3,
    ACTIONS(275), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(273), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4478] = 3,
    ACTIONS(279), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(277), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4494] = 3,
    ACTIONS(283), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(281), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4510] = 3,
    ACTIONS(287), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(285), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4526] = 3,
    ACTIONS(291), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(289), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4542] = 3,
    ACTIONS(295), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(293), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4558] = 3,
    ACTIONS(299), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(297), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4574] = 3,
    ACTIONS(303), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(301), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4590] = 3,
    ACTIONS(307), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(305), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4606] = 3,
    ACTIONS(311), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(309), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4622] = 3,
    ACTIONS(315), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(313), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4638] = 3,
    ACTIONS(319), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(317), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4654] = 3,
    ACTIONS(323), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(321), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4670] = 3,
    ACTIONS(327), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(325), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4686] = 3,
    ACTIONS(169), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(167), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4702] = 3,
    ACTIONS(331), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(329), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4718] = 3,
    ACTIONS(335), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(333), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4734] = 3,
    ACTIONS(339), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(337), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4750] = 3,
    ACTIONS(343), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(341), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4766] = 3,
    ACTIONS(347), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(345), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4782] = 3,
    ACTIONS(193), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(191), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4798] = 3,
    ACTIONS(173), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(171), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4814] = 3,
    ACTIONS(327), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(325), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4830] = 3,
    ACTIONS(347), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(345), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4846] = 3,
    ACTIONS(197), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(195), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4862] = 3,
    ACTIONS(201), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(199), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4878] = 3,
    ACTIONS(205), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(203), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4894] = 3,
    ACTIONS(209), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(207), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4910] = 3,
    ACTIONS(213), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(211), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4926] = 3,
    ACTIONS(217), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(215), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4942] = 3,
    ACTIONS(223), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(221), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4958] = 3,
    ACTIONS(227), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(225), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4974] = 3,
    ACTIONS(231), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(229), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [4990] = 3,
    ACTIONS(235), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(233), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5006] = 3,
    ACTIONS(239), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(237), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5022] = 3,
    ACTIONS(247), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(245), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5038] = 3,
    ACTIONS(259), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(257), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5054] = 3,
    ACTIONS(263), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(261), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5070] = 3,
    ACTIONS(267), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(265), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5086] = 3,
    ACTIONS(271), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(269), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5102] = 3,
    ACTIONS(275), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(273), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5118] = 3,
    ACTIONS(279), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(277), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5134] = 3,
    ACTIONS(283), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(281), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5150] = 3,
    ACTIONS(287), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(285), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5166] = 3,
    ACTIONS(291), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(289), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5182] = 3,
    ACTIONS(295), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(293), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5198] = 3,
    ACTIONS(299), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(297), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5214] = 3,
    ACTIONS(303), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(301), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5230] = 3,
    ACTIONS(307), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(305), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5246] = 3,
    ACTIONS(311), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(309), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5262] = 3,
    ACTIONS(315), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(313), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5278] = 3,
    ACTIONS(319), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(317), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5294] = 3,
    ACTIONS(331), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(329), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5310] = 3,
    ACTIONS(335), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(333), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5326] = 3,
    ACTIONS(323), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(321), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5342] = 7,
    ACTIONS(187), 1,
      sym_attribute_name,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      anon_sym_GT,
    ACTIONS(351), 1,
      anon_sym_SLASH_GT,
    STATE(196), 1,
      sym_expression,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    STATE(145), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [5366] = 7,
    ACTIONS(353), 1,
      anon_sym_LBRACE,
    STATE(37), 1,
      sym_else_if_start,
    STATE(40), 1,
      sym_else_start,
    STATE(115), 1,
      sym_if_end,
    STATE(225), 1,
      sym_else_block,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    STATE(187), 2,
      sym_else_if_block,
      aux_sym_if_statement_repeat1,
  [5390] = 3,
    ACTIONS(339), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(337), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5406] = 7,
    ACTIONS(219), 1,
      anon_sym_LBRACE,
    STATE(37), 1,
      sym_else_if_start,
    STATE(40), 1,
      sym_else_start,
    STATE(72), 1,
      sym_if_end,
    STATE(230), 1,
      sym_else_block,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    STATE(187), 2,
      sym_else_if_block,
      aux_sym_if_statement_repeat1,
  [5430] = 7,
    ACTIONS(183), 1,
      anon_sym_GT,
    ACTIONS(187), 1,
      sym_attribute_name,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(355), 1,
      anon_sym_SLASH_GT,
    STATE(196), 1,
      sym_expression,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    STATE(81), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [5454] = 7,
    ACTIONS(353), 1,
      anon_sym_LBRACE,
    STATE(37), 1,
      sym_else_if_start,
    STATE(40), 1,
      sym_else_start,
    STATE(128), 1,
      sym_if_end,
    STATE(235), 1,
      sym_else_block,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    STATE(187), 2,
      sym_else_if_block,
      aux_sym_if_statement_repeat1,
  [5478] = 3,
    ACTIONS(343), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(341), 6,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5494] = 7,
    ACTIONS(187), 1,
      sym_attribute_name,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      anon_sym_GT,
    ACTIONS(357), 1,
      anon_sym_SLASH_GT,
    STATE(196), 1,
      sym_expression,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    STATE(65), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [5518] = 3,
    ACTIONS(181), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(179), 6,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5534] = 6,
    ACTIONS(359), 1,
      anon_sym_GT,
    ACTIONS(361), 1,
      sym_attribute_name,
    ACTIONS(363), 1,
      anon_sym_LBRACE,
    STATE(198), 1,
      sym_expression,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    STATE(163), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [5555] = 3,
    ACTIONS(367), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(365), 5,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5570] = 3,
    ACTIONS(371), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(369), 5,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5585] = 3,
    ACTIONS(375), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(373), 5,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5600] = 3,
    ACTIONS(379), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(377), 5,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5615] = 3,
    ACTIONS(383), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(381), 5,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5630] = 3,
    ACTIONS(387), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(385), 5,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5645] = 3,
    ACTIONS(391), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(389), 5,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5660] = 3,
    ACTIONS(395), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(393), 5,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5675] = 3,
    ACTIONS(399), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(397), 5,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5690] = 3,
    ACTIONS(403), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(401), 5,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5705] = 3,
    ACTIONS(407), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(405), 5,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5720] = 6,
    ACTIONS(361), 1,
      sym_attribute_name,
    ACTIONS(363), 1,
      anon_sym_LBRACE,
    ACTIONS(409), 1,
      anon_sym_GT,
    STATE(198), 1,
      sym_expression,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    STATE(163), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [5741] = 6,
    ACTIONS(249), 1,
      anon_sym_GT,
    ACTIONS(411), 1,
      sym_attribute_name,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
    STATE(198), 1,
      sym_expression,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    STATE(163), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [5762] = 6,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(417), 1,
      sym_attribute_value,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    STATE(188), 2,
      sym_quoted_attribute_value,
      sym_expression,
  [5783] = 3,
    ACTIONS(425), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(423), 5,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5798] = 6,
    ACTIONS(363), 1,
      anon_sym_LBRACE,
    ACTIONS(427), 1,
      sym_attribute_value,
    ACTIONS(429), 1,
      anon_sym_SQUOTE,
    ACTIONS(431), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    STATE(199), 2,
      sym_quoted_attribute_value,
      sym_expression,
  [5819] = 6,
    ACTIONS(361), 1,
      sym_attribute_name,
    ACTIONS(363), 1,
      anon_sym_LBRACE,
    ACTIONS(433), 1,
      anon_sym_GT,
    STATE(198), 1,
      sym_expression,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    STATE(162), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [5840] = 6,
    ACTIONS(361), 1,
      sym_attribute_name,
    ACTIONS(363), 1,
      anon_sym_LBRACE,
    ACTIONS(435), 1,
      anon_sym_GT,
    STATE(198), 1,
      sym_expression,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    STATE(150), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [5861] = 3,
    ACTIONS(439), 1,
      anon_sym_LT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(437), 5,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_entity,
      sym_text,
      anon_sym_LBRACE,
  [5876] = 6,
    ACTIONS(441), 1,
      anon_sym_if,
    ACTIONS(443), 1,
      anon_sym_each,
    ACTIONS(445), 1,
      anon_sym_await,
    ACTIONS(447), 1,
      anon_sym_key,
    ACTIONS(449), 1,
      anon_sym_snippet,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [5896] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_SQUOTE,
    ACTIONS(453), 1,
      aux_sym__single_quoted_attribute_value_token1,
    ACTIONS(455), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      aux_sym__tag_value_token1,
    STATE(173), 1,
      aux_sym__single_quoted_attribute_value,
    STATE(202), 1,
      sym_expression,
  [5918] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_DQUOTE,
    ACTIONS(457), 1,
      aux_sym__tag_value_token1,
    ACTIONS(459), 1,
      aux_sym__double_quoted_attribute_value_token1,
    ACTIONS(461), 1,
      anon_sym_LBRACE,
    STATE(174), 1,
      aux_sym__double_quoted_attribute_value,
    STATE(208), 1,
      sym_expression,
  [5940] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      aux_sym__tag_value_token1,
    ACTIONS(463), 1,
      anon_sym_SQUOTE,
    ACTIONS(465), 1,
      aux_sym__single_quoted_attribute_value_token1,
    ACTIONS(468), 1,
      anon_sym_LBRACE,
    STATE(173), 1,
      aux_sym__single_quoted_attribute_value,
    STATE(202), 1,
      sym_expression,
  [5962] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      aux_sym__tag_value_token1,
    ACTIONS(471), 1,
      anon_sym_DQUOTE,
    ACTIONS(473), 1,
      aux_sym__double_quoted_attribute_value_token1,
    ACTIONS(476), 1,
      anon_sym_LBRACE,
    STATE(174), 1,
      aux_sym__double_quoted_attribute_value,
    STATE(208), 1,
      sym_expression,
  [5984] = 3,
    ACTIONS(481), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(479), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_attribute_name,
      anon_sym_LBRACE,
  [5998] = 6,
    ACTIONS(153), 1,
      anon_sym_COLON,
    ACTIONS(155), 1,
      anon_sym_SLASH,
    STATE(284), 1,
      sym__else_if_tag,
    STATE(285), 1,
      sym__else_tag,
    STATE(286), 1,
      sym__if_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6018] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      aux_sym__single_quoted_attribute_value_token1,
    ACTIONS(455), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      aux_sym__tag_value_token1,
    ACTIONS(483), 1,
      anon_sym_SQUOTE,
    STATE(171), 1,
      aux_sym__single_quoted_attribute_value,
    STATE(202), 1,
      sym_expression,
  [6040] = 6,
    ACTIONS(153), 1,
      anon_sym_COLON,
    ACTIONS(155), 1,
      anon_sym_SLASH,
    STATE(284), 1,
      sym__else_if_tag,
    STATE(285), 1,
      sym__else_tag,
    STATE(340), 1,
      sym__if_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6060] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      aux_sym__tag_value_token1,
    ACTIONS(459), 1,
      aux_sym__double_quoted_attribute_value_token1,
    ACTIONS(461), 1,
      anon_sym_LBRACE,
    ACTIONS(483), 1,
      anon_sym_DQUOTE,
    STATE(172), 1,
      aux_sym__double_quoted_attribute_value,
    STATE(208), 1,
      sym_expression,
  [6082] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      aux_sym__single_quoted_attribute_value_token1,
    ACTIONS(455), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      aux_sym__tag_value_token1,
    ACTIONS(485), 1,
      anon_sym_SQUOTE,
    STATE(182), 1,
      aux_sym__single_quoted_attribute_value,
    STATE(202), 1,
      sym_expression,
  [6104] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      aux_sym__tag_value_token1,
    ACTIONS(459), 1,
      aux_sym__double_quoted_attribute_value_token1,
    ACTIONS(461), 1,
      anon_sym_LBRACE,
    ACTIONS(485), 1,
      anon_sym_DQUOTE,
    STATE(183), 1,
      aux_sym__double_quoted_attribute_value,
    STATE(208), 1,
      sym_expression,
  [6126] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      aux_sym__single_quoted_attribute_value_token1,
    ACTIONS(455), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      aux_sym__tag_value_token1,
    ACTIONS(487), 1,
      anon_sym_SQUOTE,
    STATE(173), 1,
      aux_sym__single_quoted_attribute_value,
    STATE(202), 1,
      sym_expression,
  [6148] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      aux_sym__tag_value_token1,
    ACTIONS(459), 1,
      aux_sym__double_quoted_attribute_value_token1,
    ACTIONS(461), 1,
      anon_sym_LBRACE,
    ACTIONS(487), 1,
      anon_sym_DQUOTE,
    STATE(174), 1,
      aux_sym__double_quoted_attribute_value,
    STATE(208), 1,
      sym_expression,
  [6170] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(199), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_attribute_name,
      anon_sym_LBRACE,
  [6181] = 5,
    ACTIONS(147), 1,
      anon_sym_SLASH,
    ACTIONS(489), 1,
      anon_sym_COLON,
    STATE(239), 1,
      sym__catch_tag,
    STATE(333), 1,
      sym__await_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6198] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(491), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_attribute_name,
      anon_sym_LBRACE,
  [6209] = 4,
    ACTIONS(493), 1,
      anon_sym_LBRACE,
    STATE(37), 1,
      sym_else_if_start,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    STATE(187), 2,
      sym_else_if_block,
      aux_sym_if_statement_repeat1,
  [6224] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(496), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_attribute_name,
      anon_sym_LBRACE,
  [6235] = 5,
    ACTIONS(498), 1,
      anon_sym_LBRACE,
    STATE(38), 1,
      sym_catch_start,
    STATE(92), 1,
      sym_await_end,
    STATE(223), 1,
      sym_catch_block,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6252] = 5,
    ACTIONS(498), 1,
      anon_sym_LBRACE,
    STATE(38), 1,
      sym_catch_start,
    STATE(75), 1,
      sym_await_end,
    STATE(243), 1,
      sym_catch_block,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6269] = 5,
    ACTIONS(500), 1,
      anon_sym_html,
    ACTIONS(502), 1,
      anon_sym_const,
    ACTIONS(504), 1,
      anon_sym_debug,
    ACTIONS(506), 1,
      anon_sym_render,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6286] = 5,
    ACTIONS(508), 1,
      anon_sym_LBRACE,
    STATE(38), 1,
      sym_catch_start,
    STATE(117), 1,
      sym_await_end,
    STATE(231), 1,
      sym_catch_block,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6303] = 5,
    ACTIONS(508), 1,
      anon_sym_LBRACE,
    STATE(38), 1,
      sym_catch_start,
    STATE(132), 1,
      sym_await_end,
    STATE(237), 1,
      sym_catch_block,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6320] = 3,
    ACTIONS(510), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(479), 3,
      anon_sym_GT,
      sym_attribute_name,
      anon_sym_LBRACE,
  [6333] = 5,
    ACTIONS(147), 1,
      anon_sym_SLASH,
    ACTIONS(489), 1,
      anon_sym_COLON,
    STATE(239), 1,
      sym__catch_tag,
    STATE(303), 1,
      sym__await_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6350] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(512), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_attribute_name,
      anon_sym_LBRACE,
  [6361] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(514), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_attribute_name,
      anon_sym_LBRACE,
  [6372] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(512), 3,
      anon_sym_GT,
      sym_attribute_name,
      anon_sym_LBRACE,
  [6382] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(496), 3,
      anon_sym_GT,
      sym_attribute_name,
      anon_sym_LBRACE,
  [6392] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(514), 3,
      anon_sym_GT,
      sym_attribute_name,
      anon_sym_LBRACE,
  [6402] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(491), 3,
      anon_sym_GT,
      sym_attribute_name,
      anon_sym_LBRACE,
  [6412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      aux_sym__tag_value_token1,
    ACTIONS(516), 3,
      anon_sym_SQUOTE,
      aux_sym__single_quoted_attribute_value_token1,
      anon_sym_LBRACE,
  [6424] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(199), 3,
      anon_sym_GT,
      sym_attribute_name,
      anon_sym_LBRACE,
  [6434] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      aux_sym__tag_value_token1,
    ACTIONS(199), 3,
      anon_sym_SQUOTE,
      aux_sym__single_quoted_attribute_value_token1,
      anon_sym_LBRACE,
  [6446] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      aux_sym__tag_value_token1,
    ACTIONS(199), 3,
      anon_sym_DQUOTE,
      aux_sym__double_quoted_attribute_value_token1,
      anon_sym_LBRACE,
  [6458] = 4,
    ACTIONS(518), 1,
      anon_sym_LT_SLASH,
    ACTIONS(520), 1,
      sym_raw_text,
    STATE(101), 1,
      sym_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6472] = 4,
    ACTIONS(522), 1,
      sym__start_tag_name,
    ACTIONS(524), 1,
      sym__script_start_tag_name,
    ACTIONS(526), 1,
      sym__style_start_tag_name,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6486] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      aux_sym__tag_value_token1,
    ACTIONS(528), 3,
      anon_sym_DQUOTE,
      aux_sym__double_quoted_attribute_value_token1,
      anon_sym_LBRACE,
  [6498] = 4,
    ACTIONS(530), 1,
      anon_sym_LT_SLASH,
    ACTIONS(532), 1,
      sym_raw_text,
    STATE(139), 1,
      sym_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6512] = 4,
    ACTIONS(530), 1,
      anon_sym_LT_SLASH,
    ACTIONS(534), 1,
      sym_raw_text,
    STATE(138), 1,
      sym_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6526] = 4,
    ACTIONS(524), 1,
      sym__script_start_tag_name,
    ACTIONS(526), 1,
      sym__style_start_tag_name,
    ACTIONS(536), 1,
      sym__start_tag_name,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6540] = 4,
    ACTIONS(518), 1,
      anon_sym_LT_SLASH,
    ACTIONS(538), 1,
      sym_raw_text,
    STATE(102), 1,
      sym_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6554] = 3,
    ACTIONS(540), 1,
      anon_sym_LBRACE,
    STATE(117), 1,
      sym_await_end,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6565] = 3,
    ACTIONS(518), 1,
      anon_sym_LT_SLASH,
    STATE(113), 1,
      sym_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6576] = 3,
    ACTIONS(518), 1,
      anon_sym_LT_SLASH,
    STATE(114), 1,
      sym_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6587] = 3,
    ACTIONS(542), 1,
      anon_sym_LBRACE,
    STATE(115), 1,
      sym_if_end,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6598] = 3,
    ACTIONS(544), 1,
      anon_sym_LBRACE,
    STATE(72), 1,
      sym_if_end,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6609] = 3,
    ACTIONS(147), 1,
      anon_sym_SLASH,
    STATE(333), 1,
      sym__await_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6620] = 3,
    ACTIONS(155), 1,
      anon_sym_SLASH,
    STATE(286), 1,
      sym__if_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6631] = 3,
    ACTIONS(530), 1,
      anon_sym_LT_SLASH,
    STATE(70), 1,
      sym_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6642] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(546), 2,
      sym_svelte_raw_text,
      sym_svelte_raw_text_each,
  [6651] = 3,
    ACTIONS(548), 1,
      sym_svelte_raw_text,
    ACTIONS(550), 1,
      sym_svelte_raw_text_each,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6662] = 3,
    ACTIONS(552), 1,
      anon_sym_LBRACE,
    STATE(97), 1,
      sym_await_end,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6673] = 3,
    ACTIONS(155), 1,
      anon_sym_SLASH,
    STATE(340), 1,
      sym__if_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6684] = 3,
    ACTIONS(542), 1,
      anon_sym_LBRACE,
    STATE(128), 1,
      sym_if_end,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6695] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(554), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [6704] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(556), 2,
      sym_svelte_raw_text,
      anon_sym_RBRACE,
  [6713] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(558), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [6722] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(560), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [6731] = 3,
    ACTIONS(544), 1,
      anon_sym_LBRACE,
    STATE(88), 1,
      sym_if_end,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6742] = 3,
    ACTIONS(540), 1,
      anon_sym_LBRACE,
    STATE(132), 1,
      sym_await_end,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6753] = 3,
    ACTIONS(147), 1,
      anon_sym_SLASH,
    STATE(303), 1,
      sym__await_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6764] = 3,
    ACTIONS(562), 1,
      anon_sym_then,
    ACTIONS(564), 1,
      anon_sym_catch,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6775] = 3,
    ACTIONS(566), 1,
      anon_sym_COLON,
    STATE(284), 1,
      sym__else_if_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6786] = 3,
    ACTIONS(542), 1,
      anon_sym_LBRACE,
    STATE(135), 1,
      sym_if_end,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6797] = 3,
    ACTIONS(568), 1,
      anon_sym_RBRACE,
    ACTIONS(570), 1,
      sym_svelte_raw_text,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6808] = 3,
    ACTIONS(540), 1,
      anon_sym_LBRACE,
    STATE(137), 1,
      sym_await_end,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6819] = 3,
    ACTIONS(572), 1,
      anon_sym_RPAREN,
    ACTIONS(574), 1,
      sym_svelte_raw_text_snippet_arguments,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6830] = 3,
    ACTIONS(576), 1,
      anon_sym_RBRACE,
    ACTIONS(578), 1,
      sym_svelte_raw_text,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6841] = 3,
    ACTIONS(580), 1,
      sym__end_tag_name,
    ACTIONS(582), 1,
      sym_erroneous_end_tag_name,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6852] = 3,
    ACTIONS(584), 1,
      anon_sym_elseif,
    ACTIONS(586), 1,
      anon_sym_else,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6863] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(588), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [6872] = 3,
    ACTIONS(552), 1,
      anon_sym_LBRACE,
    STATE(92), 1,
      sym_await_end,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6883] = 3,
    ACTIONS(582), 1,
      sym_erroneous_end_tag_name,
    ACTIONS(590), 1,
      sym__end_tag_name,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6894] = 2,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
    ACTIONS(592), 2,
      sym_svelte_raw_text,
      anon_sym_RBRACE,
  [6903] = 3,
    ACTIONS(552), 1,
      anon_sym_LBRACE,
    STATE(75), 1,
      sym_await_end,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6914] = 3,
    ACTIONS(530), 1,
      anon_sym_LT_SLASH,
    STATE(71), 1,
      sym_end_tag,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6925] = 3,
    ACTIONS(544), 1,
      anon_sym_LBRACE,
    STATE(95), 1,
      sym_if_end,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6936] = 2,
    ACTIONS(594), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6944] = 2,
    ACTIONS(596), 1,
      sym_svelte_raw_text,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6952] = 2,
    ACTIONS(598), 1,
      aux_sym_snippet_start_token1,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6960] = 2,
    ACTIONS(600), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6968] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 1,
      aux_sym__tag_value_token1,
    STATE(270), 1,
      sym__tag_value,
  [6978] = 2,
    ACTIONS(604), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6986] = 2,
    ACTIONS(606), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [6994] = 2,
    ACTIONS(608), 1,
      anon_sym_as,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7002] = 2,
    ACTIONS(610), 1,
      anon_sym_key,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7010] = 2,
    ACTIONS(612), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7018] = 2,
    ACTIONS(614), 1,
      anon_sym_GT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7026] = 2,
    ACTIONS(616), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7034] = 2,
    ACTIONS(618), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7042] = 2,
    ACTIONS(620), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7050] = 2,
    ACTIONS(580), 1,
      sym__end_tag_name,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7058] = 2,
    ACTIONS(622), 1,
      sym_svelte_raw_text,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7066] = 2,
    ACTIONS(624), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7074] = 2,
    ACTIONS(626), 1,
      anon_sym_snippet,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7082] = 2,
    ACTIONS(628), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7090] = 2,
    ACTIONS(630), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7098] = 2,
    ACTIONS(632), 1,
      sym_erroneous_end_tag_name,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7106] = 2,
    ACTIONS(634), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7114] = 2,
    ACTIONS(636), 1,
      sym_svelte_raw_text,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7122] = 2,
    ACTIONS(638), 1,
      anon_sym_GT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7130] = 2,
    ACTIONS(640), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7138] = 2,
    ACTIONS(642), 1,
      sym__doctype,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7146] = 2,
    ACTIONS(644), 1,
      anon_sym_GT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7154] = 2,
    ACTIONS(646), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7162] = 2,
    ACTIONS(648), 1,
      sym_svelte_raw_text,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7170] = 2,
    ACTIONS(564), 1,
      anon_sym_catch,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7178] = 2,
    ACTIONS(650), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7186] = 2,
    ACTIONS(652), 1,
      sym_svelte_raw_text,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7194] = 2,
    ACTIONS(654), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7202] = 2,
    ACTIONS(656), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7210] = 2,
    ACTIONS(658), 1,
      anon_sym_if,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7218] = 2,
    ACTIONS(660), 1,
      sym_svelte_raw_text,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7226] = 2,
    ACTIONS(662), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7234] = 2,
    ACTIONS(664), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7242] = 2,
    ACTIONS(666), 1,
      anon_sym_GT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7250] = 2,
    ACTIONS(668), 1,
      sym_svelte_raw_text,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7258] = 2,
    ACTIONS(670), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7266] = 2,
    ACTIONS(672), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7274] = 2,
    ACTIONS(674), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7282] = 2,
    ACTIONS(676), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7290] = 2,
    ACTIONS(678), 1,
      anon_sym_GT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7298] = 2,
    ACTIONS(680), 1,
      sym_svelte_raw_text,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7306] = 2,
    ACTIONS(682), 1,
      sym_svelte_raw_text,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7314] = 2,
    ACTIONS(684), 1,
      sym_svelte_raw_text,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7322] = 2,
    ACTIONS(686), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7330] = 2,
    ACTIONS(688), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7338] = 2,
    ACTIONS(690), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7346] = 2,
    ACTIONS(692), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7354] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      aux_sym__tag_value_token1,
    ACTIONS(694), 1,
      aux_sym_doctype_token1,
  [7364] = 2,
    ACTIONS(696), 1,
      sym_svelte_raw_text,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7372] = 2,
    ACTIONS(698), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7380] = 2,
    ACTIONS(700), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7388] = 2,
    ACTIONS(702), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7396] = 2,
    ACTIONS(704), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7404] = 2,
    ACTIONS(706), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7412] = 2,
    ACTIONS(708), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7420] = 2,
    ACTIONS(710), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7428] = 2,
    ACTIONS(712), 1,
      anon_sym_else,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7436] = 2,
    ACTIONS(714), 1,
      anon_sym_each,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7444] = 2,
    ACTIONS(716), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7452] = 2,
    ACTIONS(718), 1,
      aux_sym_snippet_start_token1,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7460] = 2,
    ACTIONS(720), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7468] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 1,
      aux_sym__tag_value_token1,
    STATE(323), 1,
      sym__tag_value,
  [7478] = 2,
    ACTIONS(722), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7486] = 2,
    ACTIONS(724), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7494] = 2,
    ACTIONS(726), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7502] = 2,
    ACTIONS(728), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7510] = 2,
    ACTIONS(730), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7518] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 1,
      aux_sym__tag_value_token1,
    STATE(332), 1,
      sym__tag_value,
  [7528] = 2,
    ACTIONS(582), 1,
      sym_erroneous_end_tag_name,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7536] = 2,
    ACTIONS(732), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7544] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      aux_sym__tag_value_token1,
    ACTIONS(734), 1,
      aux_sym_doctype_token1,
  [7554] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 1,
      aux_sym__tag_value_token1,
    STATE(289), 1,
      sym__tag_value,
  [7564] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 1,
      aux_sym__tag_value_token1,
    STATE(290), 1,
      sym__tag_value,
  [7574] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 1,
      aux_sym__tag_value_token1,
    STATE(291), 1,
      sym__tag_value,
  [7584] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 1,
      aux_sym__tag_value_token1,
    STATE(292), 1,
      sym__tag_value,
  [7594] = 2,
    ACTIONS(736), 1,
      anon_sym_await,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7602] = 2,
    ACTIONS(590), 1,
      sym__end_tag_name,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7610] = 2,
    ACTIONS(584), 1,
      anon_sym_elseif,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7618] = 2,
    ACTIONS(738), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7626] = 2,
    ACTIONS(740), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7634] = 2,
    ACTIONS(742), 1,
      anon_sym_GT,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7642] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 1,
      aux_sym__tag_value_token1,
    STATE(252), 1,
      sym__tag_value,
  [7652] = 2,
    ACTIONS(744), 1,
      sym_svelte_raw_text,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7660] = 2,
    ACTIONS(746), 1,
      sym_svelte_raw_text,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7668] = 2,
    ACTIONS(748), 1,
      sym_svelte_raw_text,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7676] = 2,
    ACTIONS(750), 1,
      sym__doctype,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7684] = 2,
    ACTIONS(752), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      aux_sym__tag_value_token1,
  [7692] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 1,
      aux_sym__tag_value_token1,
  [7699] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 1,
      aux_sym__tag_value_token1,
  [7706] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 1,
      aux_sym__tag_value_token1,
  [7713] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(760), 1,
      aux_sym__tag_value_token1,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 85,
  [SMALL_STATE(4)] = 170,
  [SMALL_STATE(5)] = 255,
  [SMALL_STATE(6)] = 340,
  [SMALL_STATE(7)] = 424,
  [SMALL_STATE(8)] = 508,
  [SMALL_STATE(9)] = 592,
  [SMALL_STATE(10)] = 676,
  [SMALL_STATE(11)] = 754,
  [SMALL_STATE(12)] = 832,
  [SMALL_STATE(13)] = 910,
  [SMALL_STATE(14)] = 988,
  [SMALL_STATE(15)] = 1063,
  [SMALL_STATE(16)] = 1138,
  [SMALL_STATE(17)] = 1213,
  [SMALL_STATE(18)] = 1288,
  [SMALL_STATE(19)] = 1360,
  [SMALL_STATE(20)] = 1432,
  [SMALL_STATE(21)] = 1504,
  [SMALL_STATE(22)] = 1576,
  [SMALL_STATE(23)] = 1648,
  [SMALL_STATE(24)] = 1720,
  [SMALL_STATE(25)] = 1792,
  [SMALL_STATE(26)] = 1864,
  [SMALL_STATE(27)] = 1936,
  [SMALL_STATE(28)] = 2008,
  [SMALL_STATE(29)] = 2080,
  [SMALL_STATE(30)] = 2152,
  [SMALL_STATE(31)] = 2224,
  [SMALL_STATE(32)] = 2296,
  [SMALL_STATE(33)] = 2368,
  [SMALL_STATE(34)] = 2440,
  [SMALL_STATE(35)] = 2512,
  [SMALL_STATE(36)] = 2584,
  [SMALL_STATE(37)] = 2656,
  [SMALL_STATE(38)] = 2725,
  [SMALL_STATE(39)] = 2794,
  [SMALL_STATE(40)] = 2863,
  [SMALL_STATE(41)] = 2932,
  [SMALL_STATE(42)] = 3001,
  [SMALL_STATE(43)] = 3070,
  [SMALL_STATE(44)] = 3139,
  [SMALL_STATE(45)] = 3208,
  [SMALL_STATE(46)] = 3277,
  [SMALL_STATE(47)] = 3346,
  [SMALL_STATE(48)] = 3402,
  [SMALL_STATE(49)] = 3458,
  [SMALL_STATE(50)] = 3514,
  [SMALL_STATE(51)] = 3570,
  [SMALL_STATE(52)] = 3623,
  [SMALL_STATE(53)] = 3676,
  [SMALL_STATE(54)] = 3723,
  [SMALL_STATE(55)] = 3770,
  [SMALL_STATE(56)] = 3817,
  [SMALL_STATE(57)] = 3864,
  [SMALL_STATE(58)] = 3911,
  [SMALL_STATE(59)] = 3958,
  [SMALL_STATE(60)] = 3999,
  [SMALL_STATE(61)] = 4040,
  [SMALL_STATE(62)] = 4056,
  [SMALL_STATE(63)] = 4072,
  [SMALL_STATE(64)] = 4088,
  [SMALL_STATE(65)] = 4104,
  [SMALL_STATE(66)] = 4128,
  [SMALL_STATE(67)] = 4144,
  [SMALL_STATE(68)] = 4160,
  [SMALL_STATE(69)] = 4176,
  [SMALL_STATE(70)] = 4192,
  [SMALL_STATE(71)] = 4208,
  [SMALL_STATE(72)] = 4224,
  [SMALL_STATE(73)] = 4240,
  [SMALL_STATE(74)] = 4264,
  [SMALL_STATE(75)] = 4280,
  [SMALL_STATE(76)] = 4296,
  [SMALL_STATE(77)] = 4312,
  [SMALL_STATE(78)] = 4328,
  [SMALL_STATE(79)] = 4344,
  [SMALL_STATE(80)] = 4360,
  [SMALL_STATE(81)] = 4376,
  [SMALL_STATE(82)] = 4398,
  [SMALL_STATE(83)] = 4414,
  [SMALL_STATE(84)] = 4430,
  [SMALL_STATE(85)] = 4446,
  [SMALL_STATE(86)] = 4462,
  [SMALL_STATE(87)] = 4478,
  [SMALL_STATE(88)] = 4494,
  [SMALL_STATE(89)] = 4510,
  [SMALL_STATE(90)] = 4526,
  [SMALL_STATE(91)] = 4542,
  [SMALL_STATE(92)] = 4558,
  [SMALL_STATE(93)] = 4574,
  [SMALL_STATE(94)] = 4590,
  [SMALL_STATE(95)] = 4606,
  [SMALL_STATE(96)] = 4622,
  [SMALL_STATE(97)] = 4638,
  [SMALL_STATE(98)] = 4654,
  [SMALL_STATE(99)] = 4670,
  [SMALL_STATE(100)] = 4686,
  [SMALL_STATE(101)] = 4702,
  [SMALL_STATE(102)] = 4718,
  [SMALL_STATE(103)] = 4734,
  [SMALL_STATE(104)] = 4750,
  [SMALL_STATE(105)] = 4766,
  [SMALL_STATE(106)] = 4782,
  [SMALL_STATE(107)] = 4798,
  [SMALL_STATE(108)] = 4814,
  [SMALL_STATE(109)] = 4830,
  [SMALL_STATE(110)] = 4846,
  [SMALL_STATE(111)] = 4862,
  [SMALL_STATE(112)] = 4878,
  [SMALL_STATE(113)] = 4894,
  [SMALL_STATE(114)] = 4910,
  [SMALL_STATE(115)] = 4926,
  [SMALL_STATE(116)] = 4942,
  [SMALL_STATE(117)] = 4958,
  [SMALL_STATE(118)] = 4974,
  [SMALL_STATE(119)] = 4990,
  [SMALL_STATE(120)] = 5006,
  [SMALL_STATE(121)] = 5022,
  [SMALL_STATE(122)] = 5038,
  [SMALL_STATE(123)] = 5054,
  [SMALL_STATE(124)] = 5070,
  [SMALL_STATE(125)] = 5086,
  [SMALL_STATE(126)] = 5102,
  [SMALL_STATE(127)] = 5118,
  [SMALL_STATE(128)] = 5134,
  [SMALL_STATE(129)] = 5150,
  [SMALL_STATE(130)] = 5166,
  [SMALL_STATE(131)] = 5182,
  [SMALL_STATE(132)] = 5198,
  [SMALL_STATE(133)] = 5214,
  [SMALL_STATE(134)] = 5230,
  [SMALL_STATE(135)] = 5246,
  [SMALL_STATE(136)] = 5262,
  [SMALL_STATE(137)] = 5278,
  [SMALL_STATE(138)] = 5294,
  [SMALL_STATE(139)] = 5310,
  [SMALL_STATE(140)] = 5326,
  [SMALL_STATE(141)] = 5342,
  [SMALL_STATE(142)] = 5366,
  [SMALL_STATE(143)] = 5390,
  [SMALL_STATE(144)] = 5406,
  [SMALL_STATE(145)] = 5430,
  [SMALL_STATE(146)] = 5454,
  [SMALL_STATE(147)] = 5478,
  [SMALL_STATE(148)] = 5494,
  [SMALL_STATE(149)] = 5518,
  [SMALL_STATE(150)] = 5534,
  [SMALL_STATE(151)] = 5555,
  [SMALL_STATE(152)] = 5570,
  [SMALL_STATE(153)] = 5585,
  [SMALL_STATE(154)] = 5600,
  [SMALL_STATE(155)] = 5615,
  [SMALL_STATE(156)] = 5630,
  [SMALL_STATE(157)] = 5645,
  [SMALL_STATE(158)] = 5660,
  [SMALL_STATE(159)] = 5675,
  [SMALL_STATE(160)] = 5690,
  [SMALL_STATE(161)] = 5705,
  [SMALL_STATE(162)] = 5720,
  [SMALL_STATE(163)] = 5741,
  [SMALL_STATE(164)] = 5762,
  [SMALL_STATE(165)] = 5783,
  [SMALL_STATE(166)] = 5798,
  [SMALL_STATE(167)] = 5819,
  [SMALL_STATE(168)] = 5840,
  [SMALL_STATE(169)] = 5861,
  [SMALL_STATE(170)] = 5876,
  [SMALL_STATE(171)] = 5896,
  [SMALL_STATE(172)] = 5918,
  [SMALL_STATE(173)] = 5940,
  [SMALL_STATE(174)] = 5962,
  [SMALL_STATE(175)] = 5984,
  [SMALL_STATE(176)] = 5998,
  [SMALL_STATE(177)] = 6018,
  [SMALL_STATE(178)] = 6040,
  [SMALL_STATE(179)] = 6060,
  [SMALL_STATE(180)] = 6082,
  [SMALL_STATE(181)] = 6104,
  [SMALL_STATE(182)] = 6126,
  [SMALL_STATE(183)] = 6148,
  [SMALL_STATE(184)] = 6170,
  [SMALL_STATE(185)] = 6181,
  [SMALL_STATE(186)] = 6198,
  [SMALL_STATE(187)] = 6209,
  [SMALL_STATE(188)] = 6224,
  [SMALL_STATE(189)] = 6235,
  [SMALL_STATE(190)] = 6252,
  [SMALL_STATE(191)] = 6269,
  [SMALL_STATE(192)] = 6286,
  [SMALL_STATE(193)] = 6303,
  [SMALL_STATE(194)] = 6320,
  [SMALL_STATE(195)] = 6333,
  [SMALL_STATE(196)] = 6350,
  [SMALL_STATE(197)] = 6361,
  [SMALL_STATE(198)] = 6372,
  [SMALL_STATE(199)] = 6382,
  [SMALL_STATE(200)] = 6392,
  [SMALL_STATE(201)] = 6402,
  [SMALL_STATE(202)] = 6412,
  [SMALL_STATE(203)] = 6424,
  [SMALL_STATE(204)] = 6434,
  [SMALL_STATE(205)] = 6446,
  [SMALL_STATE(206)] = 6458,
  [SMALL_STATE(207)] = 6472,
  [SMALL_STATE(208)] = 6486,
  [SMALL_STATE(209)] = 6498,
  [SMALL_STATE(210)] = 6512,
  [SMALL_STATE(211)] = 6526,
  [SMALL_STATE(212)] = 6540,
  [SMALL_STATE(213)] = 6554,
  [SMALL_STATE(214)] = 6565,
  [SMALL_STATE(215)] = 6576,
  [SMALL_STATE(216)] = 6587,
  [SMALL_STATE(217)] = 6598,
  [SMALL_STATE(218)] = 6609,
  [SMALL_STATE(219)] = 6620,
  [SMALL_STATE(220)] = 6631,
  [SMALL_STATE(221)] = 6642,
  [SMALL_STATE(222)] = 6651,
  [SMALL_STATE(223)] = 6662,
  [SMALL_STATE(224)] = 6673,
  [SMALL_STATE(225)] = 6684,
  [SMALL_STATE(226)] = 6695,
  [SMALL_STATE(227)] = 6704,
  [SMALL_STATE(228)] = 6713,
  [SMALL_STATE(229)] = 6722,
  [SMALL_STATE(230)] = 6731,
  [SMALL_STATE(231)] = 6742,
  [SMALL_STATE(232)] = 6753,
  [SMALL_STATE(233)] = 6764,
  [SMALL_STATE(234)] = 6775,
  [SMALL_STATE(235)] = 6786,
  [SMALL_STATE(236)] = 6797,
  [SMALL_STATE(237)] = 6808,
  [SMALL_STATE(238)] = 6819,
  [SMALL_STATE(239)] = 6830,
  [SMALL_STATE(240)] = 6841,
  [SMALL_STATE(241)] = 6852,
  [SMALL_STATE(242)] = 6863,
  [SMALL_STATE(243)] = 6872,
  [SMALL_STATE(244)] = 6883,
  [SMALL_STATE(245)] = 6894,
  [SMALL_STATE(246)] = 6903,
  [SMALL_STATE(247)] = 6914,
  [SMALL_STATE(248)] = 6925,
  [SMALL_STATE(249)] = 6936,
  [SMALL_STATE(250)] = 6944,
  [SMALL_STATE(251)] = 6952,
  [SMALL_STATE(252)] = 6960,
  [SMALL_STATE(253)] = 6968,
  [SMALL_STATE(254)] = 6978,
  [SMALL_STATE(255)] = 6986,
  [SMALL_STATE(256)] = 6994,
  [SMALL_STATE(257)] = 7002,
  [SMALL_STATE(258)] = 7010,
  [SMALL_STATE(259)] = 7018,
  [SMALL_STATE(260)] = 7026,
  [SMALL_STATE(261)] = 7034,
  [SMALL_STATE(262)] = 7042,
  [SMALL_STATE(263)] = 7050,
  [SMALL_STATE(264)] = 7058,
  [SMALL_STATE(265)] = 7066,
  [SMALL_STATE(266)] = 7074,
  [SMALL_STATE(267)] = 7082,
  [SMALL_STATE(268)] = 7090,
  [SMALL_STATE(269)] = 7098,
  [SMALL_STATE(270)] = 7106,
  [SMALL_STATE(271)] = 7114,
  [SMALL_STATE(272)] = 7122,
  [SMALL_STATE(273)] = 7130,
  [SMALL_STATE(274)] = 7138,
  [SMALL_STATE(275)] = 7146,
  [SMALL_STATE(276)] = 7154,
  [SMALL_STATE(277)] = 7162,
  [SMALL_STATE(278)] = 7170,
  [SMALL_STATE(279)] = 7178,
  [SMALL_STATE(280)] = 7186,
  [SMALL_STATE(281)] = 7194,
  [SMALL_STATE(282)] = 7202,
  [SMALL_STATE(283)] = 7210,
  [SMALL_STATE(284)] = 7218,
  [SMALL_STATE(285)] = 7226,
  [SMALL_STATE(286)] = 7234,
  [SMALL_STATE(287)] = 7242,
  [SMALL_STATE(288)] = 7250,
  [SMALL_STATE(289)] = 7258,
  [SMALL_STATE(290)] = 7266,
  [SMALL_STATE(291)] = 7274,
  [SMALL_STATE(292)] = 7282,
  [SMALL_STATE(293)] = 7290,
  [SMALL_STATE(294)] = 7298,
  [SMALL_STATE(295)] = 7306,
  [SMALL_STATE(296)] = 7314,
  [SMALL_STATE(297)] = 7322,
  [SMALL_STATE(298)] = 7330,
  [SMALL_STATE(299)] = 7338,
  [SMALL_STATE(300)] = 7346,
  [SMALL_STATE(301)] = 7354,
  [SMALL_STATE(302)] = 7364,
  [SMALL_STATE(303)] = 7372,
  [SMALL_STATE(304)] = 7380,
  [SMALL_STATE(305)] = 7388,
  [SMALL_STATE(306)] = 7396,
  [SMALL_STATE(307)] = 7404,
  [SMALL_STATE(308)] = 7412,
  [SMALL_STATE(309)] = 7420,
  [SMALL_STATE(310)] = 7428,
  [SMALL_STATE(311)] = 7436,
  [SMALL_STATE(312)] = 7444,
  [SMALL_STATE(313)] = 7452,
  [SMALL_STATE(314)] = 7460,
  [SMALL_STATE(315)] = 7468,
  [SMALL_STATE(316)] = 7478,
  [SMALL_STATE(317)] = 7486,
  [SMALL_STATE(318)] = 7494,
  [SMALL_STATE(319)] = 7502,
  [SMALL_STATE(320)] = 7510,
  [SMALL_STATE(321)] = 7518,
  [SMALL_STATE(322)] = 7528,
  [SMALL_STATE(323)] = 7536,
  [SMALL_STATE(324)] = 7544,
  [SMALL_STATE(325)] = 7554,
  [SMALL_STATE(326)] = 7564,
  [SMALL_STATE(327)] = 7574,
  [SMALL_STATE(328)] = 7584,
  [SMALL_STATE(329)] = 7594,
  [SMALL_STATE(330)] = 7602,
  [SMALL_STATE(331)] = 7610,
  [SMALL_STATE(332)] = 7618,
  [SMALL_STATE(333)] = 7626,
  [SMALL_STATE(334)] = 7634,
  [SMALL_STATE(335)] = 7642,
  [SMALL_STATE(336)] = 7652,
  [SMALL_STATE(337)] = 7660,
  [SMALL_STATE(338)] = 7668,
  [SMALL_STATE(339)] = 7676,
  [SMALL_STATE(340)] = 7684,
  [SMALL_STATE(341)] = 7692,
  [SMALL_STATE(342)] = 7699,
  [SMALL_STATE(343)] = 7706,
  [SMALL_STATE(344)] = 7713,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 0, 0, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(207),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(211),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [57] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0),
  [59] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(274),
  [62] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(207),
  [65] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(269),
  [68] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(140),
  [71] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(59),
  [74] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [76] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(339),
  [79] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(211),
  [82] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(322),
  [85] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(98),
  [88] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2, 0, 0), SHIFT_REPEAT(60),
  [91] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 1, 0, 0),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [95] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_else_if_block, 1, 0, 0), SHIFT(59),
  [98] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_catch_block, 1, 0, 0), SHIFT(59),
  [101] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_then_block, 2, 0, 0), SHIFT(59),
  [104] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_else_block, 1, 0, 0), SHIFT(59),
  [107] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_catch_block, 2, 0, 0), SHIFT(59),
  [110] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_else_if_block, 2, 0, 0), SHIFT(59),
  [113] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_then_block, 1, 0, 0), SHIFT(59),
  [116] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_else_block, 1, 0, 0), SHIFT(274),
  [119] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_else_block, 1, 0, 0), SHIFT(207),
  [122] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_else_block, 1, 0, 0), SHIFT(269),
  [125] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_else_block, 1, 0, 0), SHIFT(140),
  [128] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_else_block, 2, 0, 0), SHIFT(274),
  [131] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_else_block, 2, 0, 0), SHIFT(207),
  [134] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_else_block, 2, 0, 0), SHIFT(269),
  [137] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_else_block, 2, 0, 0), SHIFT(140),
  [140] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_else_block, 2, 0, 0), SHIFT(59),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [167] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 2, 0, 0),
  [169] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 2, 0, 0),
  [171] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_snippet_statement, 2, 0, 0),
  [173] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_snippet_statement, 2, 0, 0),
  [175] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_start_tag, 3, 0, 0),
  [177] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_start_tag, 3, 0, 0),
  [179] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_self_closing_tag, 3, 0, 0),
  [181] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_self_closing_tag, 3, 0, 0),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_statement, 2, 0, 0),
  [193] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key_statement, 2, 0, 0),
  [195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_erroneous_end_tag, 3, 0, 0),
  [197] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_erroneous_end_tag, 3, 0, 0),
  [199] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 3, 0, 0),
  [201] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 3, 0, 0),
  [203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 3, 0, 0),
  [205] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 3, 0, 0),
  [207] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_element, 3, 0, 0),
  [209] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_script_element, 3, 0, 0),
  [211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_element, 3, 0, 0),
  [213] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_style_element, 3, 0, 0),
  [215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 3, 0, 0),
  [217] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 3, 0, 0),
  [219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_statement, 3, 0, 0),
  [223] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_statement, 3, 0, 0),
  [225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_await_statement, 3, 0, 0),
  [227] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_await_statement, 3, 0, 0),
  [229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_statement, 3, 0, 0),
  [231] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key_statement, 3, 0, 0),
  [233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_snippet_statement, 3, 0, 0),
  [235] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_snippet_statement, 3, 0, 0),
  [237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_doctype, 4, 0, 0),
  [239] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_doctype, 4, 0, 0),
  [241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_start_tag, 4, 0, 0),
  [243] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_start_tag, 4, 0, 0),
  [245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_self_closing_tag, 4, 0, 0),
  [247] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_self_closing_tag, 4, 0, 0),
  [249] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2, 0, 0),
  [251] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(175),
  [254] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(277),
  [257] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_html_tag, 4, 0, 5),
  [259] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_html_tag, 4, 0, 5),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_tag, 4, 0, 5),
  [263] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_const_tag, 4, 0, 5),
  [265] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_debug_tag, 4, 0, 5),
  [267] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_debug_tag, 4, 0, 5),
  [269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_render_tag, 4, 0, 5),
  [271] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_render_tag, 4, 0, 5),
  [273] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_end_tag, 3, 0, 0),
  [275] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_end_tag, 3, 0, 0),
  [277] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_end, 3, 0, 5),
  [279] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_end, 3, 0, 5),
  [281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 4, 0, 0),
  [283] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 4, 0, 0),
  [285] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_end, 3, 0, 5),
  [287] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_end, 3, 0, 5),
  [289] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_statement, 4, 0, 0),
  [291] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_statement, 4, 0, 0),
  [293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_await_end, 3, 0, 5),
  [295] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_await_end, 3, 0, 5),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_await_statement, 4, 0, 0),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_await_statement, 4, 0, 0),
  [301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_end, 3, 0, 5),
  [303] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key_end, 3, 0, 5),
  [305] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_snippet_end, 3, 0, 5),
  [307] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_snippet_end, 3, 0, 5),
  [309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, 0, 0),
  [311] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, 0, 0),
  [313] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_statement, 5, 0, 0),
  [315] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_statement, 5, 0, 0),
  [317] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_await_statement, 5, 0, 0),
  [319] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_await_statement, 5, 0, 0),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__node, 1, 0, 0),
  [323] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__node, 1, 0, 0),
  [325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 1, 0, 0),
  [327] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 1, 0, 0),
  [329] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_element, 2, 0, 0),
  [331] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_script_element, 2, 0, 0),
  [333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_element, 2, 0, 0),
  [335] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_style_element, 2, 0, 0),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 2, 0, 0),
  [339] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 2, 0, 0),
  [341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_statement, 2, 0, 0),
  [343] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_statement, 2, 0, 0),
  [345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_await_statement, 2, 0, 0),
  [347] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_await_statement, 2, 0, 0),
  [349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_await_start, 4, 0, 5),
  [367] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_await_start, 4, 0, 5),
  [369] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_start, 4, 0, 5),
  [371] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key_start, 4, 0, 5),
  [373] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_start, 3, 0, 5),
  [375] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_start, 3, 0, 5),
  [377] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_then_start, 3, 0, 5),
  [379] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_then_start, 3, 0, 5),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_catch_start, 3, 0, 5),
  [383] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_catch_start, 3, 0, 5),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_if_start, 4, 0, 3),
  [387] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_start, 4, 0, 3),
  [389] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_then_start, 4, 0, 5),
  [391] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_then_start, 4, 0, 5),
  [393] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_catch_start, 4, 0, 5),
  [395] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_catch_start, 4, 0, 5),
  [397] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_start, 6, 0, 6),
  [399] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_start, 6, 0, 6),
  [401] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_snippet_start, 6, 0, 5),
  [403] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_snippet_start, 6, 0, 5),
  [405] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_snippet_start, 7, 0, 5),
  [407] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_snippet_start, 7, 0, 5),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [411] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(194),
  [414] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(336),
  [417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_start, 4, 0, 3),
  [425] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_start, 4, 0, 3),
  [427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [437] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_start, 4, 0, 4),
  [439] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_start, 4, 0, 4),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [457] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [463] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__single_quoted_attribute_value, 2, 0, 0),
  [465] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__single_quoted_attribute_value, 2, 0, 0), SHIFT_REPEAT(202),
  [468] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__single_quoted_attribute_value, 2, 0, 0), SHIFT_REPEAT(337),
  [471] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__double_quoted_attribute_value, 2, 0, 0),
  [473] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__double_quoted_attribute_value, 2, 0, 0), SHIFT_REPEAT(208),
  [476] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__double_quoted_attribute_value, 2, 0, 0), SHIFT_REPEAT(338),
  [479] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 1, 0, 0),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [491] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_attribute_value, 3, 0, 7),
  [493] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(234),
  [496] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 3, 0, 0),
  [498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [512] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 1, 0, 1),
  [514] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_attribute_value, 2, 0, 0),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__single_quoted_attribute_value, 1, 0, 0),
  [518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [528] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__double_quoted_attribute_value, 1, 0, 0),
  [530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [546] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__each_start_tag, 2, 0, 2),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [554] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_start_tag, 4, 0, 0),
  [556] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__catch_tag, 2, 0, 2),
  [558] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_start_tag, 4, 0, 0),
  [560] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_start_tag, 3, 0, 0),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [586] = {.entry = {.count = 1, .reusable = false}}, SHIFT(267),
  [588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_start_tag, 3, 0, 0),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [592] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__then_tag, 2, 0, 2),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [596] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__key_start_tag, 2, 0, 2),
  [598] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__snippet_start_tag, 2, 0, 2),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [604] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__each_end_tag, 2, 0, 2),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [618] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__await_end_tag, 2, 0, 2),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [622] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__else_if_tag, 2, 0, 2),
  [624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [628] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__else_tag, 2, 0, 2),
  [630] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [632] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [638] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [642] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [652] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_start_tag, 2, 0, 2),
  [654] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [656] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_end_tag, 2, 0, 2),
  [658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [668] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__await_start_tag, 2, 0, 2),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__key_end_tag, 2, 0, 2),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [692] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__snippet_end_tag, 2, 0, 2),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [702] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__tag_value, 2, 0, 0),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [754] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__html_tag, 2, 0, 2),
  [756] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__render_tag, 2, 0, 2),
  [758] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__const_tag, 2, 0, 2),
  [760] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__debug_tag, 2, 0, 2),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token__start_tag_name = 0,
  ts_external_token__script_start_tag_name = 1,
  ts_external_token__style_start_tag_name = 2,
  ts_external_token__end_tag_name = 3,
  ts_external_token_erroneous_end_tag_name = 4,
  ts_external_token_SLASH_GT = 5,
  ts_external_token__implicit_end_tag = 6,
  ts_external_token_raw_text = 7,
  ts_external_token_comment = 8,
  ts_external_token_svelte_raw_text = 9,
  ts_external_token_svelte_raw_text_each = 10,
  ts_external_token_svelte_raw_text_snippet_arguments = 11,
  ts_external_token_AT = 12,
  ts_external_token_POUND = 13,
  ts_external_token_SLASH = 14,
  ts_external_token_COLON = 15,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__start_tag_name] = sym__start_tag_name,
  [ts_external_token__script_start_tag_name] = sym__script_start_tag_name,
  [ts_external_token__style_start_tag_name] = sym__style_start_tag_name,
  [ts_external_token__end_tag_name] = sym__end_tag_name,
  [ts_external_token_erroneous_end_tag_name] = sym_erroneous_end_tag_name,
  [ts_external_token_SLASH_GT] = anon_sym_SLASH_GT,
  [ts_external_token__implicit_end_tag] = sym__implicit_end_tag,
  [ts_external_token_raw_text] = sym_raw_text,
  [ts_external_token_comment] = sym_comment,
  [ts_external_token_svelte_raw_text] = sym_svelte_raw_text,
  [ts_external_token_svelte_raw_text_each] = sym_svelte_raw_text_each,
  [ts_external_token_svelte_raw_text_snippet_arguments] = sym_svelte_raw_text_snippet_arguments,
  [ts_external_token_AT] = anon_sym_AT,
  [ts_external_token_POUND] = anon_sym_POUND,
  [ts_external_token_SLASH] = anon_sym_SLASH,
  [ts_external_token_COLON] = anon_sym_COLON,
};

static const bool ts_external_scanner_states[19][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__start_tag_name] = true,
    [ts_external_token__script_start_tag_name] = true,
    [ts_external_token__style_start_tag_name] = true,
    [ts_external_token__end_tag_name] = true,
    [ts_external_token_erroneous_end_tag_name] = true,
    [ts_external_token_SLASH_GT] = true,
    [ts_external_token__implicit_end_tag] = true,
    [ts_external_token_raw_text] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_svelte_raw_text] = true,
    [ts_external_token_svelte_raw_text_each] = true,
    [ts_external_token_svelte_raw_text_snippet_arguments] = true,
    [ts_external_token_AT] = true,
    [ts_external_token_POUND] = true,
    [ts_external_token_SLASH] = true,
    [ts_external_token_COLON] = true,
  },
  [2] = {
    [ts_external_token_comment] = true,
  },
  [3] = {
    [ts_external_token__implicit_end_tag] = true,
    [ts_external_token_comment] = true,
  },
  [4] = {
    [ts_external_token_comment] = true,
    [ts_external_token_svelte_raw_text] = true,
    [ts_external_token_AT] = true,
    [ts_external_token_POUND] = true,
    [ts_external_token_SLASH] = true,
    [ts_external_token_COLON] = true,
  },
  [5] = {
    [ts_external_token_comment] = true,
    [ts_external_token_svelte_raw_text] = true,
    [ts_external_token_AT] = true,
    [ts_external_token_POUND] = true,
    [ts_external_token_SLASH] = true,
  },
  [6] = {
    [ts_external_token_comment] = true,
    [ts_external_token_svelte_raw_text] = true,
    [ts_external_token_AT] = true,
    [ts_external_token_POUND] = true,
  },
  [7] = {
    [ts_external_token_SLASH_GT] = true,
    [ts_external_token_comment] = true,
  },
  [8] = {
    [ts_external_token_comment] = true,
    [ts_external_token_SLASH] = true,
    [ts_external_token_COLON] = true,
  },
  [9] = {
    [ts_external_token_raw_text] = true,
    [ts_external_token_comment] = true,
  },
  [10] = {
    [ts_external_token__start_tag_name] = true,
    [ts_external_token__script_start_tag_name] = true,
    [ts_external_token__style_start_tag_name] = true,
    [ts_external_token_comment] = true,
  },
  [11] = {
    [ts_external_token_comment] = true,
    [ts_external_token_SLASH] = true,
  },
  [12] = {
    [ts_external_token_comment] = true,
    [ts_external_token_svelte_raw_text] = true,
    [ts_external_token_svelte_raw_text_each] = true,
  },
  [13] = {
    [ts_external_token_comment] = true,
    [ts_external_token_svelte_raw_text] = true,
  },
  [14] = {
    [ts_external_token_comment] = true,
    [ts_external_token_COLON] = true,
  },
  [15] = {
    [ts_external_token_comment] = true,
    [ts_external_token_svelte_raw_text_snippet_arguments] = true,
  },
  [16] = {
    [ts_external_token__end_tag_name] = true,
    [ts_external_token_erroneous_end_tag_name] = true,
    [ts_external_token_comment] = true,
  },
  [17] = {
    [ts_external_token__end_tag_name] = true,
    [ts_external_token_comment] = true,
  },
  [18] = {
    [ts_external_token_erroneous_end_tag_name] = true,
    [ts_external_token_comment] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_svelte_external_scanner_create(void);
void tree_sitter_svelte_external_scanner_destroy(void *);
bool tree_sitter_svelte_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_svelte_external_scanner_serialize(void *, char *);
void tree_sitter_svelte_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_svelte(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_svelte_external_scanner_create,
      tree_sitter_svelte_external_scanner_destroy,
      tree_sitter_svelte_external_scanner_scan,
      tree_sitter_svelte_external_scanner_serialize,
      tree_sitter_svelte_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
