#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2019
#define LARGE_STATE_COUNT 359
#define SYMBOL_COUNT 188
#define ALIAS_COUNT 0
#define TOKEN_COUNT 84
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 28
#define MAX_ALIAS_SEQUENCE_LENGTH 12
#define PRODUCTION_ID_COUNT 71

enum ts_symbol_identifiers {
  sym__lower_id = 1,
  anon_sym_module = 2,
  anon_sym_LT = 3,
  anon_sym_COMMA = 4,
  anon_sym_GT = 5,
  anon_sym_implements = 6,
  anon_sym_LBRACE = 7,
  anon_sym_RBRACE = 8,
  anon_sym_import = 9,
  anon_sym_as = 10,
  anon_sym_EQ = 11,
  anon_sym_SEMI = 12,
  anon_sym_or = 13,
  anon_sym_LPAREN = 14,
  anon_sym_RPAREN = 15,
  anon_sym_newtype = 16,
  anon_sym_from = 17,
  anon_sym_where = 18,
  anon_sym_select = 19,
  anon_sym_class = 20,
  anon_sym_extends = 21,
  anon_sym_instanceof = 22,
  anon_sym_in = 23,
  anon_sym_not = 24,
  anon_sym_if = 25,
  anon_sym_then = 26,
  anon_sym_else = 27,
  anon_sym_and = 28,
  anon_sym_implies = 29,
  anon_sym_PIPE = 30,
  sym_specialId = 31,
  anon_sym_exists = 32,
  anon_sym_forall = 33,
  anon_sym_forex = 34,
  sym_underscore = 35,
  anon_sym_DOT = 36,
  anon_sym_LBRACK = 37,
  anon_sym_RBRACK = 38,
  anon_sym_DOT_DOT = 39,
  anon_sym_BANG_EQ = 40,
  anon_sym_LT_EQ = 41,
  anon_sym_GT_EQ = 42,
  anon_sym_PLUS = 43,
  anon_sym_DASH = 44,
  anon_sym_STAR = 45,
  anon_sym_SLASH = 46,
  anon_sym_PERCENT = 47,
  anon_sym_asc = 48,
  anon_sym_desc = 49,
  anon_sym_order = 50,
  anon_sym_by = 51,
  sym_qldoc = 52,
  anon_sym_COLON_COLON = 53,
  anon_sym_boolean = 54,
  anon_sym_date = 55,
  anon_sym_float = 56,
  anon_sym_int = 57,
  anon_sym_string = 58,
  sym_dbtype = 59,
  anon_sym_avg = 60,
  anon_sym_concat = 61,
  anon_sym_strictconcat = 62,
  anon_sym_count = 63,
  anon_sym_max = 64,
  anon_sym_min = 65,
  anon_sym_rank = 66,
  anon_sym_strictcount = 67,
  anon_sym_strictsum = 68,
  anon_sym_sum = 69,
  anon_sym_any = 70,
  anon_sym_unique = 71,
  sym__upper_id = 72,
  sym_integer = 73,
  sym_float = 74,
  sym_string = 75,
  sym_line_comment = 76,
  sym_block_comment = 77,
  sym_false = 78,
  sym_predicate = 79,
  sym_result = 80,
  sym_super = 81,
  sym_this = 82,
  sym_true = 83,
  sym_ql = 84,
  sym_module = 85,
  sym_moduleMember = 86,
  sym_importDirective = 87,
  sym_moduleAliasBody = 88,
  sym_predicateAliasBody = 89,
  sym_typeAliasBody = 90,
  sym_typeUnionBody = 91,
  sym_classlessPredicate = 92,
  sym_datatype = 93,
  sym_datatypeBranches = 94,
  sym_datatypeBranch = 95,
  sym_select = 96,
  sym_dataclass = 97,
  sym_classMember = 98,
  sym_charpred = 99,
  sym_memberPredicate = 100,
  sym_field = 101,
  sym__optbody = 102,
  sym_empty = 103,
  sym_body = 104,
  sym_higherOrderTerm = 105,
  sym_special_call = 106,
  sym_prefix_cast = 107,
  sym_unary_expr = 108,
  sym_mul_expr = 109,
  sym_add_expr = 110,
  sym_in_expr = 111,
  sym_comp_term = 112,
  sym_instance_of = 113,
  sym_negation = 114,
  sym_if_term = 115,
  sym_conjunction = 116,
  sym_disjunction = 117,
  sym_implication = 118,
  sym_quantified = 119,
  sym_quantifier = 120,
  sym__call_arg = 121,
  sym_qualifiedRhs = 122,
  sym_call_body = 123,
  sym_unqual_agg_body = 124,
  sym__call_or_unqual_agg_body = 125,
  sym_call_or_unqual_agg_expr = 126,
  sym_qualified_expr = 127,
  sym_super_ref = 128,
  sym_full_aggregate_body = 129,
  sym_expr_aggregate_body = 130,
  sym_aggregate = 131,
  sym_range = 132,
  sym_set_literal = 133,
  sym_par_expr = 134,
  sym_expr_annotation = 135,
  sym__exprOrTerm = 136,
  sym__primary = 137,
  sym_literal = 138,
  sym_bool = 139,
  sym_variable = 140,
  sym_compop = 141,
  sym_unop = 142,
  sym_mulop = 143,
  sym_addop = 144,
  sym_closure = 145,
  sym_direction = 146,
  sym_varDecl = 147,
  sym_moduleParam = 148,
  sym_asExprs = 149,
  sym_asExpr = 150,
  sym_orderBys = 151,
  sym_orderBy = 152,
  sym_literalId = 153,
  sym_annotation = 154,
  sym_annotName = 155,
  sym_annotArg = 156,
  sym_moduleName = 157,
  sym_importModuleExpr = 158,
  sym_moduleExpr = 159,
  sym_moduleInstantiation = 160,
  sym_primitiveType = 161,
  sym_simpleId = 162,
  sym_className = 163,
  sym_typeExpr = 164,
  sym_signatureExpr = 165,
  sym_predicateName = 166,
  sym_aritylessPredicateExpr = 167,
  sym_predicateExpr = 168,
  sym_varName = 169,
  sym_aggId = 170,
  aux_sym_ql_repeat1 = 171,
  aux_sym_module_repeat1 = 172,
  aux_sym_module_repeat2 = 173,
  aux_sym_moduleMember_repeat1 = 174,
  aux_sym_typeUnionBody_repeat1 = 175,
  aux_sym_classlessPredicate_repeat1 = 176,
  aux_sym_datatypeBranches_repeat1 = 177,
  aux_sym_dataclass_repeat1 = 178,
  aux_sym_dataclass_repeat2 = 179,
  aux_sym_higherOrderTerm_repeat1 = 180,
  aux_sym_higherOrderTerm_repeat2 = 181,
  aux_sym_aggregate_repeat1 = 182,
  aux_sym_asExprs_repeat1 = 183,
  aux_sym_orderBys_repeat1 = 184,
  aux_sym_annotation_repeat1 = 185,
  aux_sym_importModuleExpr_repeat1 = 186,
  aux_sym_moduleInstantiation_repeat1 = 187,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__lower_id] = "_lower_id",
  [anon_sym_module] = "module",
  [anon_sym_LT] = "<",
  [anon_sym_COMMA] = ",",
  [anon_sym_GT] = ">",
  [anon_sym_implements] = "implements",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_import] = "import",
  [anon_sym_as] = "as",
  [anon_sym_EQ] = "=",
  [anon_sym_SEMI] = ";",
  [anon_sym_or] = "or",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_newtype] = "newtype",
  [anon_sym_from] = "from",
  [anon_sym_where] = "where",
  [anon_sym_select] = "select",
  [anon_sym_class] = "class",
  [anon_sym_extends] = "extends",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_in] = "in",
  [anon_sym_not] = "not",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_else] = "else",
  [anon_sym_and] = "and",
  [anon_sym_implies] = "implies",
  [anon_sym_PIPE] = "|",
  [sym_specialId] = "specialId",
  [anon_sym_exists] = "exists",
  [anon_sym_forall] = "forall",
  [anon_sym_forex] = "forex",
  [sym_underscore] = "underscore",
  [anon_sym_DOT] = ".",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_asc] = "asc",
  [anon_sym_desc] = "desc",
  [anon_sym_order] = "order",
  [anon_sym_by] = "by",
  [sym_qldoc] = "qldoc",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_boolean] = "boolean",
  [anon_sym_date] = "date",
  [anon_sym_float] = "float",
  [anon_sym_int] = "int",
  [anon_sym_string] = "string",
  [sym_dbtype] = "dbtype",
  [anon_sym_avg] = "avg",
  [anon_sym_concat] = "concat",
  [anon_sym_strictconcat] = "strictconcat",
  [anon_sym_count] = "count",
  [anon_sym_max] = "max",
  [anon_sym_min] = "min",
  [anon_sym_rank] = "rank",
  [anon_sym_strictcount] = "strictcount",
  [anon_sym_strictsum] = "strictsum",
  [anon_sym_sum] = "sum",
  [anon_sym_any] = "any",
  [anon_sym_unique] = "unique",
  [sym__upper_id] = "_upper_id",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [sym_string] = "string",
  [sym_line_comment] = "line_comment",
  [sym_block_comment] = "block_comment",
  [sym_false] = "false",
  [sym_predicate] = "predicate",
  [sym_result] = "result",
  [sym_super] = "super",
  [sym_this] = "this",
  [sym_true] = "true",
  [sym_ql] = "ql",
  [sym_module] = "module",
  [sym_moduleMember] = "moduleMember",
  [sym_importDirective] = "importDirective",
  [sym_moduleAliasBody] = "moduleAliasBody",
  [sym_predicateAliasBody] = "predicateAliasBody",
  [sym_typeAliasBody] = "typeAliasBody",
  [sym_typeUnionBody] = "typeUnionBody",
  [sym_classlessPredicate] = "classlessPredicate",
  [sym_datatype] = "datatype",
  [sym_datatypeBranches] = "datatypeBranches",
  [sym_datatypeBranch] = "datatypeBranch",
  [sym_select] = "select",
  [sym_dataclass] = "dataclass",
  [sym_classMember] = "classMember",
  [sym_charpred] = "charpred",
  [sym_memberPredicate] = "memberPredicate",
  [sym_field] = "field",
  [sym__optbody] = "_optbody",
  [sym_empty] = "empty",
  [sym_body] = "body",
  [sym_higherOrderTerm] = "higherOrderTerm",
  [sym_special_call] = "special_call",
  [sym_prefix_cast] = "prefix_cast",
  [sym_unary_expr] = "unary_expr",
  [sym_mul_expr] = "mul_expr",
  [sym_add_expr] = "add_expr",
  [sym_in_expr] = "in_expr",
  [sym_comp_term] = "comp_term",
  [sym_instance_of] = "instance_of",
  [sym_negation] = "negation",
  [sym_if_term] = "if_term",
  [sym_conjunction] = "conjunction",
  [sym_disjunction] = "disjunction",
  [sym_implication] = "implication",
  [sym_quantified] = "quantified",
  [sym_quantifier] = "quantifier",
  [sym__call_arg] = "_call_arg",
  [sym_qualifiedRhs] = "qualifiedRhs",
  [sym_call_body] = "call_body",
  [sym_unqual_agg_body] = "unqual_agg_body",
  [sym__call_or_unqual_agg_body] = "_call_or_unqual_agg_body",
  [sym_call_or_unqual_agg_expr] = "call_or_unqual_agg_expr",
  [sym_qualified_expr] = "qualified_expr",
  [sym_super_ref] = "super_ref",
  [sym_full_aggregate_body] = "full_aggregate_body",
  [sym_expr_aggregate_body] = "expr_aggregate_body",
  [sym_aggregate] = "aggregate",
  [sym_range] = "range",
  [sym_set_literal] = "set_literal",
  [sym_par_expr] = "par_expr",
  [sym_expr_annotation] = "expr_annotation",
  [sym__exprOrTerm] = "_exprOrTerm",
  [sym__primary] = "_primary",
  [sym_literal] = "literal",
  [sym_bool] = "bool",
  [sym_variable] = "variable",
  [sym_compop] = "compop",
  [sym_unop] = "unop",
  [sym_mulop] = "mulop",
  [sym_addop] = "addop",
  [sym_closure] = "closure",
  [sym_direction] = "direction",
  [sym_varDecl] = "varDecl",
  [sym_moduleParam] = "moduleParam",
  [sym_asExprs] = "asExprs",
  [sym_asExpr] = "asExpr",
  [sym_orderBys] = "orderBys",
  [sym_orderBy] = "orderBy",
  [sym_literalId] = "literalId",
  [sym_annotation] = "annotation",
  [sym_annotName] = "annotName",
  [sym_annotArg] = "annotArg",
  [sym_moduleName] = "moduleName",
  [sym_importModuleExpr] = "importModuleExpr",
  [sym_moduleExpr] = "moduleExpr",
  [sym_moduleInstantiation] = "moduleInstantiation",
  [sym_primitiveType] = "primitiveType",
  [sym_simpleId] = "simpleId",
  [sym_className] = "className",
  [sym_typeExpr] = "typeExpr",
  [sym_signatureExpr] = "signatureExpr",
  [sym_predicateName] = "predicateName",
  [sym_aritylessPredicateExpr] = "aritylessPredicateExpr",
  [sym_predicateExpr] = "predicateExpr",
  [sym_varName] = "varName",
  [sym_aggId] = "aggId",
  [aux_sym_ql_repeat1] = "ql_repeat1",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym_module_repeat2] = "module_repeat2",
  [aux_sym_moduleMember_repeat1] = "moduleMember_repeat1",
  [aux_sym_typeUnionBody_repeat1] = "typeUnionBody_repeat1",
  [aux_sym_classlessPredicate_repeat1] = "classlessPredicate_repeat1",
  [aux_sym_datatypeBranches_repeat1] = "datatypeBranches_repeat1",
  [aux_sym_dataclass_repeat1] = "dataclass_repeat1",
  [aux_sym_dataclass_repeat2] = "dataclass_repeat2",
  [aux_sym_higherOrderTerm_repeat1] = "higherOrderTerm_repeat1",
  [aux_sym_higherOrderTerm_repeat2] = "higherOrderTerm_repeat2",
  [aux_sym_aggregate_repeat1] = "aggregate_repeat1",
  [aux_sym_asExprs_repeat1] = "asExprs_repeat1",
  [aux_sym_orderBys_repeat1] = "orderBys_repeat1",
  [aux_sym_annotation_repeat1] = "annotation_repeat1",
  [aux_sym_importModuleExpr_repeat1] = "importModuleExpr_repeat1",
  [aux_sym_moduleInstantiation_repeat1] = "moduleInstantiation_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__lower_id] = sym__lower_id,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_newtype] = anon_sym_newtype,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_where] = anon_sym_where,
  [anon_sym_select] = anon_sym_select,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_implies] = anon_sym_implies,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [sym_specialId] = sym_specialId,
  [anon_sym_exists] = anon_sym_exists,
  [anon_sym_forall] = anon_sym_forall,
  [anon_sym_forex] = anon_sym_forex,
  [sym_underscore] = sym_underscore,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_asc] = anon_sym_asc,
  [anon_sym_desc] = anon_sym_desc,
  [anon_sym_order] = anon_sym_order,
  [anon_sym_by] = anon_sym_by,
  [sym_qldoc] = sym_qldoc,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_date] = anon_sym_date,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_string] = anon_sym_string,
  [sym_dbtype] = sym_dbtype,
  [anon_sym_avg] = anon_sym_avg,
  [anon_sym_concat] = anon_sym_concat,
  [anon_sym_strictconcat] = anon_sym_strictconcat,
  [anon_sym_count] = anon_sym_count,
  [anon_sym_max] = anon_sym_max,
  [anon_sym_min] = anon_sym_min,
  [anon_sym_rank] = anon_sym_rank,
  [anon_sym_strictcount] = anon_sym_strictcount,
  [anon_sym_strictsum] = anon_sym_strictsum,
  [anon_sym_sum] = anon_sym_sum,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_unique] = anon_sym_unique,
  [sym__upper_id] = sym__upper_id,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [sym_string] = sym_string,
  [sym_line_comment] = sym_line_comment,
  [sym_block_comment] = sym_block_comment,
  [sym_false] = sym_false,
  [sym_predicate] = sym_predicate,
  [sym_result] = sym_result,
  [sym_super] = sym_super,
  [sym_this] = sym_this,
  [sym_true] = sym_true,
  [sym_ql] = sym_ql,
  [sym_module] = sym_module,
  [sym_moduleMember] = sym_moduleMember,
  [sym_importDirective] = sym_importDirective,
  [sym_moduleAliasBody] = sym_moduleAliasBody,
  [sym_predicateAliasBody] = sym_predicateAliasBody,
  [sym_typeAliasBody] = sym_typeAliasBody,
  [sym_typeUnionBody] = sym_typeUnionBody,
  [sym_classlessPredicate] = sym_classlessPredicate,
  [sym_datatype] = sym_datatype,
  [sym_datatypeBranches] = sym_datatypeBranches,
  [sym_datatypeBranch] = sym_datatypeBranch,
  [sym_select] = sym_select,
  [sym_dataclass] = sym_dataclass,
  [sym_classMember] = sym_classMember,
  [sym_charpred] = sym_charpred,
  [sym_memberPredicate] = sym_memberPredicate,
  [sym_field] = sym_field,
  [sym__optbody] = sym__optbody,
  [sym_empty] = sym_empty,
  [sym_body] = sym_body,
  [sym_higherOrderTerm] = sym_higherOrderTerm,
  [sym_special_call] = sym_special_call,
  [sym_prefix_cast] = sym_prefix_cast,
  [sym_unary_expr] = sym_unary_expr,
  [sym_mul_expr] = sym_mul_expr,
  [sym_add_expr] = sym_add_expr,
  [sym_in_expr] = sym_in_expr,
  [sym_comp_term] = sym_comp_term,
  [sym_instance_of] = sym_instance_of,
  [sym_negation] = sym_negation,
  [sym_if_term] = sym_if_term,
  [sym_conjunction] = sym_conjunction,
  [sym_disjunction] = sym_disjunction,
  [sym_implication] = sym_implication,
  [sym_quantified] = sym_quantified,
  [sym_quantifier] = sym_quantifier,
  [sym__call_arg] = sym__call_arg,
  [sym_qualifiedRhs] = sym_qualifiedRhs,
  [sym_call_body] = sym_call_body,
  [sym_unqual_agg_body] = sym_unqual_agg_body,
  [sym__call_or_unqual_agg_body] = sym__call_or_unqual_agg_body,
  [sym_call_or_unqual_agg_expr] = sym_call_or_unqual_agg_expr,
  [sym_qualified_expr] = sym_qualified_expr,
  [sym_super_ref] = sym_super_ref,
  [sym_full_aggregate_body] = sym_full_aggregate_body,
  [sym_expr_aggregate_body] = sym_expr_aggregate_body,
  [sym_aggregate] = sym_aggregate,
  [sym_range] = sym_range,
  [sym_set_literal] = sym_set_literal,
  [sym_par_expr] = sym_par_expr,
  [sym_expr_annotation] = sym_expr_annotation,
  [sym__exprOrTerm] = sym__exprOrTerm,
  [sym__primary] = sym__primary,
  [sym_literal] = sym_literal,
  [sym_bool] = sym_bool,
  [sym_variable] = sym_variable,
  [sym_compop] = sym_compop,
  [sym_unop] = sym_unop,
  [sym_mulop] = sym_mulop,
  [sym_addop] = sym_addop,
  [sym_closure] = sym_closure,
  [sym_direction] = sym_direction,
  [sym_varDecl] = sym_varDecl,
  [sym_moduleParam] = sym_moduleParam,
  [sym_asExprs] = sym_asExprs,
  [sym_asExpr] = sym_asExpr,
  [sym_orderBys] = sym_orderBys,
  [sym_orderBy] = sym_orderBy,
  [sym_literalId] = sym_literalId,
  [sym_annotation] = sym_annotation,
  [sym_annotName] = sym_annotName,
  [sym_annotArg] = sym_annotArg,
  [sym_moduleName] = sym_moduleName,
  [sym_importModuleExpr] = sym_importModuleExpr,
  [sym_moduleExpr] = sym_moduleExpr,
  [sym_moduleInstantiation] = sym_moduleInstantiation,
  [sym_primitiveType] = sym_primitiveType,
  [sym_simpleId] = sym_simpleId,
  [sym_className] = sym_className,
  [sym_typeExpr] = sym_typeExpr,
  [sym_signatureExpr] = sym_signatureExpr,
  [sym_predicateName] = sym_predicateName,
  [sym_aritylessPredicateExpr] = sym_aritylessPredicateExpr,
  [sym_predicateExpr] = sym_predicateExpr,
  [sym_varName] = sym_varName,
  [sym_aggId] = sym_aggId,
  [aux_sym_ql_repeat1] = aux_sym_ql_repeat1,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym_module_repeat2] = aux_sym_module_repeat2,
  [aux_sym_moduleMember_repeat1] = aux_sym_moduleMember_repeat1,
  [aux_sym_typeUnionBody_repeat1] = aux_sym_typeUnionBody_repeat1,
  [aux_sym_classlessPredicate_repeat1] = aux_sym_classlessPredicate_repeat1,
  [aux_sym_datatypeBranches_repeat1] = aux_sym_datatypeBranches_repeat1,
  [aux_sym_dataclass_repeat1] = aux_sym_dataclass_repeat1,
  [aux_sym_dataclass_repeat2] = aux_sym_dataclass_repeat2,
  [aux_sym_higherOrderTerm_repeat1] = aux_sym_higherOrderTerm_repeat1,
  [aux_sym_higherOrderTerm_repeat2] = aux_sym_higherOrderTerm_repeat2,
  [aux_sym_aggregate_repeat1] = aux_sym_aggregate_repeat1,
  [aux_sym_asExprs_repeat1] = aux_sym_asExprs_repeat1,
  [aux_sym_orderBys_repeat1] = aux_sym_orderBys_repeat1,
  [aux_sym_annotation_repeat1] = aux_sym_annotation_repeat1,
  [aux_sym_importModuleExpr_repeat1] = aux_sym_importModuleExpr_repeat1,
  [aux_sym_moduleInstantiation_repeat1] = aux_sym_moduleInstantiation_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__lower_id] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_newtype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_where] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_select] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implies] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [sym_specialId] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_exists] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_forall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_forex] = {
    .visible = true,
    .named = false,
  },
  [sym_underscore] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_desc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_order] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_by] = {
    .visible = true,
    .named = false,
  },
  [sym_qldoc] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_date] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [sym_dbtype] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_avg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_concat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictconcat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_count] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_max] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_min] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rank] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictcount] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictsum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unique] = {
    .visible = true,
    .named = false,
  },
  [sym__upper_id] = {
    .visible = false,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_result] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_ql] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_moduleMember] = {
    .visible = true,
    .named = true,
  },
  [sym_importDirective] = {
    .visible = true,
    .named = true,
  },
  [sym_moduleAliasBody] = {
    .visible = true,
    .named = true,
  },
  [sym_predicateAliasBody] = {
    .visible = true,
    .named = true,
  },
  [sym_typeAliasBody] = {
    .visible = true,
    .named = true,
  },
  [sym_typeUnionBody] = {
    .visible = true,
    .named = true,
  },
  [sym_classlessPredicate] = {
    .visible = true,
    .named = true,
  },
  [sym_datatype] = {
    .visible = true,
    .named = true,
  },
  [sym_datatypeBranches] = {
    .visible = true,
    .named = true,
  },
  [sym_datatypeBranch] = {
    .visible = true,
    .named = true,
  },
  [sym_select] = {
    .visible = true,
    .named = true,
  },
  [sym_dataclass] = {
    .visible = true,
    .named = true,
  },
  [sym_classMember] = {
    .visible = true,
    .named = true,
  },
  [sym_charpred] = {
    .visible = true,
    .named = true,
  },
  [sym_memberPredicate] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym__optbody] = {
    .visible = false,
    .named = true,
  },
  [sym_empty] = {
    .visible = true,
    .named = true,
  },
  [sym_body] = {
    .visible = true,
    .named = true,
  },
  [sym_higherOrderTerm] = {
    .visible = true,
    .named = true,
  },
  [sym_special_call] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_mul_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_add_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_in_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_comp_term] = {
    .visible = true,
    .named = true,
  },
  [sym_instance_of] = {
    .visible = true,
    .named = true,
  },
  [sym_negation] = {
    .visible = true,
    .named = true,
  },
  [sym_if_term] = {
    .visible = true,
    .named = true,
  },
  [sym_conjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_implication] = {
    .visible = true,
    .named = true,
  },
  [sym_quantified] = {
    .visible = true,
    .named = true,
  },
  [sym_quantifier] = {
    .visible = true,
    .named = true,
  },
  [sym__call_arg] = {
    .visible = false,
    .named = true,
  },
  [sym_qualifiedRhs] = {
    .visible = true,
    .named = true,
  },
  [sym_call_body] = {
    .visible = true,
    .named = true,
  },
  [sym_unqual_agg_body] = {
    .visible = true,
    .named = true,
  },
  [sym__call_or_unqual_agg_body] = {
    .visible = false,
    .named = true,
  },
  [sym_call_or_unqual_agg_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_super_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_full_aggregate_body] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_aggregate_body] = {
    .visible = true,
    .named = true,
  },
  [sym_aggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_set_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_par_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__exprOrTerm] = {
    .visible = false,
    .named = true,
  },
  [sym__primary] = {
    .visible = false,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_bool] = {
    .visible = true,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_compop] = {
    .visible = true,
    .named = true,
  },
  [sym_unop] = {
    .visible = true,
    .named = true,
  },
  [sym_mulop] = {
    .visible = true,
    .named = true,
  },
  [sym_addop] = {
    .visible = true,
    .named = true,
  },
  [sym_closure] = {
    .visible = true,
    .named = true,
  },
  [sym_direction] = {
    .visible = true,
    .named = true,
  },
  [sym_varDecl] = {
    .visible = true,
    .named = true,
  },
  [sym_moduleParam] = {
    .visible = true,
    .named = true,
  },
  [sym_asExprs] = {
    .visible = true,
    .named = true,
  },
  [sym_asExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_orderBys] = {
    .visible = true,
    .named = true,
  },
  [sym_orderBy] = {
    .visible = true,
    .named = true,
  },
  [sym_literalId] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotName] = {
    .visible = true,
    .named = true,
  },
  [sym_annotArg] = {
    .visible = true,
    .named = true,
  },
  [sym_moduleName] = {
    .visible = true,
    .named = true,
  },
  [sym_importModuleExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_moduleExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_moduleInstantiation] = {
    .visible = true,
    .named = true,
  },
  [sym_primitiveType] = {
    .visible = true,
    .named = true,
  },
  [sym_simpleId] = {
    .visible = true,
    .named = true,
  },
  [sym_className] = {
    .visible = true,
    .named = true,
  },
  [sym_typeExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_signatureExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_predicateName] = {
    .visible = true,
    .named = true,
  },
  [sym_aritylessPredicateExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_predicateExpr] = {
    .visible = true,
    .named = true,
  },
  [sym_varName] = {
    .visible = true,
    .named = true,
  },
  [sym_aggId] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_ql_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_moduleMember_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_typeUnionBody_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_classlessPredicate_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_datatypeBranches_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dataclass_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dataclass_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_higherOrderTerm_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_higherOrderTerm_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_aggregate_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_asExprs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_orderBys_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_importModuleExpr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_moduleInstantiation_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_annot_arg = 1,
  field_args = 2,
  field_asExprs = 3,
  field_body = 4,
  field_cond = 5,
  field_expr = 6,
  field_extends = 7,
  field_first = 8,
  field_formula = 9,
  field_guard = 10,
  field_implements = 11,
  field_instanceof = 12,
  field_left = 13,
  field_lower = 14,
  field_mod_expr = 15,
  field_name = 16,
  field_orderBys = 17,
  field_parameter = 18,
  field_predicate = 19,
  field_qualName = 20,
  field_qualifier = 21,
  field_range = 22,
  field_returnType = 23,
  field_right = 24,
  field_second = 25,
  field_signature = 26,
  field_type_expr = 27,
  field_upper = 28,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_annot_arg] = "annot_arg",
  [field_args] = "args",
  [field_asExprs] = "asExprs",
  [field_body] = "body",
  [field_cond] = "cond",
  [field_expr] = "expr",
  [field_extends] = "extends",
  [field_first] = "first",
  [field_formula] = "formula",
  [field_guard] = "guard",
  [field_implements] = "implements",
  [field_instanceof] = "instanceof",
  [field_left] = "left",
  [field_lower] = "lower",
  [field_mod_expr] = "mod_expr",
  [field_name] = "name",
  [field_orderBys] = "orderBys",
  [field_parameter] = "parameter",
  [field_predicate] = "predicate",
  [field_qualName] = "qualName",
  [field_qualifier] = "qualifier",
  [field_range] = "range",
  [field_returnType] = "returnType",
  [field_right] = "right",
  [field_second] = "second",
  [field_signature] = "signature",
  [field_type_expr] = "type_expr",
  [field_upper] = "upper",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 2},
  [6] = {.index = 6, .length = 2},
  [7] = {.index = 8, .length = 1},
  [8] = {.index = 9, .length = 1},
  [9] = {.index = 10, .length = 1},
  [10] = {.index = 11, .length = 1},
  [11] = {.index = 12, .length = 2},
  [12] = {.index = 14, .length = 2},
  [13] = {.index = 16, .length = 1},
  [14] = {.index = 17, .length = 2},
  [15] = {.index = 19, .length = 2},
  [16] = {.index = 21, .length = 2},
  [17] = {.index = 23, .length = 1},
  [18] = {.index = 24, .length = 1},
  [19] = {.index = 25, .length = 2},
  [20] = {.index = 27, .length = 3},
  [21] = {.index = 30, .length = 3},
  [22] = {.index = 33, .length = 3},
  [23] = {.index = 36, .length = 1},
  [24] = {.index = 37, .length = 2},
  [25] = {.index = 39, .length = 2},
  [26] = {.index = 41, .length = 1},
  [27] = {.index = 42, .length = 3},
  [28] = {.index = 45, .length = 2},
  [29] = {.index = 47, .length = 2},
  [30] = {.index = 49, .length = 1},
  [31] = {.index = 50, .length = 1},
  [32] = {.index = 51, .length = 1},
  [33] = {.index = 52, .length = 4},
  [34] = {.index = 56, .length = 4},
  [35] = {.index = 60, .length = 3},
  [36] = {.index = 63, .length = 3},
  [37] = {.index = 66, .length = 1},
  [38] = {.index = 67, .length = 2},
  [39] = {.index = 69, .length = 1},
  [40] = {.index = 70, .length = 2},
  [41] = {.index = 72, .length = 2},
  [42] = {.index = 74, .length = 1},
  [43] = {.index = 75, .length = 5},
  [44] = {.index = 80, .length = 3},
  [45] = {.index = 83, .length = 2},
  [46] = {.index = 85, .length = 1},
  [47] = {.index = 86, .length = 2},
  [48] = {.index = 88, .length = 3},
  [49] = {.index = 91, .length = 2},
  [50] = {.index = 93, .length = 1},
  [51] = {.index = 94, .length = 3},
  [52] = {.index = 97, .length = 2},
  [53] = {.index = 99, .length = 2},
  [54] = {.index = 101, .length = 1},
  [55] = {.index = 102, .length = 6},
  [56] = {.index = 108, .length = 6},
  [57] = {.index = 114, .length = 4},
  [58] = {.index = 118, .length = 4},
  [59] = {.index = 122, .length = 2},
  [60] = {.index = 124, .length = 3},
  [61] = {.index = 127, .length = 2},
  [62] = {.index = 129, .length = 3},
  [63] = {.index = 132, .length = 2},
  [64] = {.index = 134, .length = 2},
  [65] = {.index = 136, .length = 1},
  [66] = {.index = 137, .length = 7},
  [67] = {.index = 144, .length = 5},
  [68] = {.index = 149, .length = 2},
  [69] = {.index = 151, .length = 3},
  [70] = {.index = 154, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_name, 1},
  [2] =
    {field_qualName, 0},
  [3] =
    {field_qualName, 0, .inherited = true},
  [4] =
    {field_qualName, 0, .inherited = true},
    {field_qualName, 1, .inherited = true},
  [6] =
    {field_name, 1},
    {field_returnType, 0},
  [8] =
    {field_mod_expr, 0},
  [9] =
    {field_type_expr, 0},
  [10] =
    {field_predicate, 0},
  [11] =
    {field_name, 2},
  [12] =
    {field_name, 2},
    {field_qualifier, 0},
  [14] =
    {field_left, 0},
    {field_right, 2},
  [16] =
    {field_asExprs, 0},
  [17] =
    {field_args, 2},
    {field_name, 0},
  [19] =
    {field_parameter, 1},
    {field_signature, 0},
  [21] =
    {field_implements, 3},
    {field_name, 1},
  [23] =
    {field_expr, 2},
  [24] =
    {field_guard, 1},
  [25] =
    {field_asExprs, 0},
    {field_orderBys, 1},
  [27] =
    {field_extends, 2},
    {field_extends, 3},
    {field_name, 1},
  [30] =
    {field_instanceof, 2},
    {field_instanceof, 3},
    {field_name, 1},
  [33] =
    {field_args, 2},
    {field_args, 3},
    {field_name, 0},
  [36] =
    {field_parameter, 1},
  [37] =
    {field_name, 1},
    {field_parameter, 3},
  [39] =
    {field_parameter, 0, .inherited = true},
    {field_parameter, 1, .inherited = true},
  [41] =
    {field_implements, 1},
  [42] =
    {field_implements, 3},
    {field_implements, 4, .inherited = true},
    {field_name, 1},
  [45] =
    {field_implements, 0, .inherited = true},
    {field_implements, 1, .inherited = true},
  [47] =
    {field_lower, 1},
    {field_upper, 3},
  [49] =
    {field_range, 3},
  [50] =
    {field_guard, 2},
  [51] =
    {field_asExprs, 2},
  [52] =
    {field_extends, 2},
    {field_extends, 3},
    {field_extends, 4},
    {field_name, 1},
  [56] =
    {field_instanceof, 2},
    {field_instanceof, 3},
    {field_instanceof, 4},
    {field_name, 1},
  [60] =
    {field_name, 1},
    {field_parameter, 3},
    {field_parameter, 4, .inherited = true},
  [63] =
    {field_cond, 1},
    {field_first, 3},
    {field_second, 5},
  [66] =
    {field_range, 4},
  [67] =
    {field_asExprs, 2},
    {field_asExprs, 3},
  [69] =
    {field_guard, 3},
  [70] =
    {field_asExprs, 2},
    {field_orderBys, 3},
  [72] =
    {field_asExprs, 3},
    {field_guard, 1},
  [74] =
    {field_asExprs, 3},
  [75] =
    {field_extends, 2},
    {field_extends, 3},
    {field_instanceof, 4},
    {field_instanceof, 5},
    {field_name, 1},
  [80] =
    {field_implements, 6},
    {field_name, 1},
    {field_parameter, 3},
  [83] =
    {field_formula, 5},
    {field_range, 3},
  [85] =
    {field_range, 5},
  [86] =
    {field_annot_arg, 2},
    {field_name, 0},
  [88] =
    {field_asExprs, 3},
    {field_asExprs, 4},
    {field_guard, 2},
  [91] =
    {field_asExprs, 3},
    {field_asExprs, 4},
  [93] =
    {field_guard, 4},
  [94] =
    {field_asExprs, 3},
    {field_guard, 1},
    {field_orderBys, 4},
  [97] =
    {field_asExprs, 3},
    {field_orderBys, 4},
  [99] =
    {field_asExprs, 4},
    {field_guard, 2},
  [101] =
    {field_asExprs, 4},
  [102] =
    {field_extends, 2},
    {field_extends, 3},
    {field_instanceof, 4},
    {field_instanceof, 5},
    {field_instanceof, 6},
    {field_name, 1},
  [108] =
    {field_extends, 2},
    {field_extends, 3},
    {field_extends, 4},
    {field_instanceof, 5},
    {field_instanceof, 6},
    {field_name, 1},
  [114] =
    {field_implements, 6},
    {field_implements, 7, .inherited = true},
    {field_name, 1},
    {field_parameter, 3},
  [118] =
    {field_implements, 7},
    {field_name, 1},
    {field_parameter, 3},
    {field_parameter, 4, .inherited = true},
  [122] =
    {field_formula, 6},
    {field_range, 4},
  [124] =
    {field_asExprs, 4},
    {field_asExprs, 5},
    {field_guard, 3},
  [127] =
    {field_asExprs, 4},
    {field_asExprs, 5},
  [129] =
    {field_asExprs, 4},
    {field_guard, 2},
    {field_orderBys, 5},
  [132] =
    {field_asExprs, 4},
    {field_orderBys, 5},
  [134] =
    {field_asExprs, 5},
    {field_guard, 3},
  [136] =
    {field_body, 4},
  [137] =
    {field_extends, 2},
    {field_extends, 3},
    {field_extends, 4},
    {field_instanceof, 5},
    {field_instanceof, 6},
    {field_instanceof, 7},
    {field_name, 1},
  [144] =
    {field_implements, 7},
    {field_implements, 8, .inherited = true},
    {field_name, 1},
    {field_parameter, 3},
    {field_parameter, 4, .inherited = true},
  [149] =
    {field_formula, 7},
    {field_range, 5},
  [151] =
    {field_asExprs, 5},
    {field_asExprs, 6},
    {field_guard, 4},
  [154] =
    {field_asExprs, 5},
    {field_guard, 3},
    {field_orderBys, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 2,
  [6] = 6,
  [7] = 4,
  [8] = 6,
  [9] = 4,
  [10] = 2,
  [11] = 6,
  [12] = 6,
  [13] = 6,
  [14] = 4,
  [15] = 2,
  [16] = 6,
  [17] = 2,
  [18] = 4,
  [19] = 4,
  [20] = 6,
  [21] = 2,
  [22] = 4,
  [23] = 23,
  [24] = 23,
  [25] = 23,
  [26] = 23,
  [27] = 23,
  [28] = 23,
  [29] = 23,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 31,
  [34] = 30,
  [35] = 30,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 32,
  [40] = 31,
  [41] = 30,
  [42] = 37,
  [43] = 37,
  [44] = 37,
  [45] = 36,
  [46] = 31,
  [47] = 31,
  [48] = 30,
  [49] = 37,
  [50] = 38,
  [51] = 37,
  [52] = 31,
  [53] = 37,
  [54] = 31,
  [55] = 30,
  [56] = 30,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 66,
  [68] = 68,
  [69] = 58,
  [70] = 65,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 57,
  [75] = 75,
  [76] = 76,
  [77] = 68,
  [78] = 58,
  [79] = 71,
  [80] = 72,
  [81] = 57,
  [82] = 76,
  [83] = 58,
  [84] = 72,
  [85] = 72,
  [86] = 86,
  [87] = 57,
  [88] = 76,
  [89] = 73,
  [90] = 58,
  [91] = 91,
  [92] = 72,
  [93] = 93,
  [94] = 57,
  [95] = 76,
  [96] = 96,
  [97] = 97,
  [98] = 58,
  [99] = 72,
  [100] = 75,
  [101] = 57,
  [102] = 76,
  [103] = 58,
  [104] = 104,
  [105] = 72,
  [106] = 106,
  [107] = 57,
  [108] = 76,
  [109] = 76,
  [110] = 110,
  [111] = 111,
  [112] = 91,
  [113] = 104,
  [114] = 106,
  [115] = 59,
  [116] = 60,
  [117] = 63,
  [118] = 91,
  [119] = 104,
  [120] = 106,
  [121] = 59,
  [122] = 60,
  [123] = 63,
  [124] = 91,
  [125] = 104,
  [126] = 106,
  [127] = 59,
  [128] = 60,
  [129] = 63,
  [130] = 91,
  [131] = 104,
  [132] = 106,
  [133] = 59,
  [134] = 60,
  [135] = 63,
  [136] = 91,
  [137] = 104,
  [138] = 106,
  [139] = 59,
  [140] = 60,
  [141] = 63,
  [142] = 91,
  [143] = 104,
  [144] = 106,
  [145] = 59,
  [146] = 60,
  [147] = 63,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 149,
  [154] = 150,
  [155] = 152,
  [156] = 150,
  [157] = 149,
  [158] = 151,
  [159] = 152,
  [160] = 150,
  [161] = 150,
  [162] = 152,
  [163] = 163,
  [164] = 152,
  [165] = 163,
  [166] = 163,
  [167] = 151,
  [168] = 152,
  [169] = 152,
  [170] = 150,
  [171] = 149,
  [172] = 150,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 174,
  [184] = 175,
  [185] = 176,
  [186] = 177,
  [187] = 178,
  [188] = 179,
  [189] = 180,
  [190] = 181,
  [191] = 182,
  [192] = 174,
  [193] = 193,
  [194] = 173,
  [195] = 195,
  [196] = 175,
  [197] = 176,
  [198] = 174,
  [199] = 199,
  [200] = 175,
  [201] = 177,
  [202] = 176,
  [203] = 177,
  [204] = 178,
  [205] = 178,
  [206] = 179,
  [207] = 179,
  [208] = 180,
  [209] = 209,
  [210] = 180,
  [211] = 211,
  [212] = 193,
  [213] = 213,
  [214] = 181,
  [215] = 215,
  [216] = 199,
  [217] = 181,
  [218] = 218,
  [219] = 182,
  [220] = 220,
  [221] = 193,
  [222] = 174,
  [223] = 223,
  [224] = 199,
  [225] = 175,
  [226] = 199,
  [227] = 176,
  [228] = 177,
  [229] = 178,
  [230] = 179,
  [231] = 180,
  [232] = 181,
  [233] = 193,
  [234] = 182,
  [235] = 235,
  [236] = 236,
  [237] = 174,
  [238] = 199,
  [239] = 175,
  [240] = 193,
  [241] = 176,
  [242] = 177,
  [243] = 178,
  [244] = 193,
  [245] = 179,
  [246] = 246,
  [247] = 247,
  [248] = 180,
  [249] = 199,
  [250] = 181,
  [251] = 182,
  [252] = 182,
  [253] = 253,
  [254] = 254,
  [255] = 193,
  [256] = 256,
  [257] = 257,
  [258] = 174,
  [259] = 199,
  [260] = 175,
  [261] = 176,
  [262] = 177,
  [263] = 178,
  [264] = 179,
  [265] = 193,
  [266] = 236,
  [267] = 218,
  [268] = 220,
  [269] = 235,
  [270] = 180,
  [271] = 247,
  [272] = 253,
  [273] = 254,
  [274] = 257,
  [275] = 181,
  [276] = 276,
  [277] = 213,
  [278] = 236,
  [279] = 218,
  [280] = 220,
  [281] = 223,
  [282] = 235,
  [283] = 253,
  [284] = 254,
  [285] = 257,
  [286] = 276,
  [287] = 182,
  [288] = 213,
  [289] = 236,
  [290] = 218,
  [291] = 220,
  [292] = 223,
  [293] = 235,
  [294] = 253,
  [295] = 254,
  [296] = 257,
  [297] = 174,
  [298] = 276,
  [299] = 213,
  [300] = 175,
  [301] = 236,
  [302] = 218,
  [303] = 220,
  [304] = 223,
  [305] = 235,
  [306] = 253,
  [307] = 254,
  [308] = 257,
  [309] = 176,
  [310] = 177,
  [311] = 276,
  [312] = 178,
  [313] = 179,
  [314] = 213,
  [315] = 180,
  [316] = 236,
  [317] = 218,
  [318] = 220,
  [319] = 223,
  [320] = 235,
  [321] = 253,
  [322] = 254,
  [323] = 257,
  [324] = 181,
  [325] = 276,
  [326] = 213,
  [327] = 236,
  [328] = 218,
  [329] = 220,
  [330] = 223,
  [331] = 235,
  [332] = 253,
  [333] = 254,
  [334] = 257,
  [335] = 276,
  [336] = 276,
  [337] = 182,
  [338] = 213,
  [339] = 236,
  [340] = 218,
  [341] = 341,
  [342] = 209,
  [343] = 341,
  [344] = 215,
  [345] = 256,
  [346] = 211,
  [347] = 256,
  [348] = 211,
  [349] = 256,
  [350] = 211,
  [351] = 256,
  [352] = 211,
  [353] = 256,
  [354] = 211,
  [355] = 256,
  [356] = 211,
  [357] = 256,
  [358] = 223,
  [359] = 359,
  [360] = 359,
  [361] = 359,
  [362] = 359,
  [363] = 359,
  [364] = 359,
  [365] = 359,
  [366] = 359,
  [367] = 367,
  [368] = 368,
  [369] = 368,
  [370] = 368,
  [371] = 367,
  [372] = 368,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 374,
  [382] = 380,
  [383] = 375,
  [384] = 378,
  [385] = 385,
  [386] = 386,
  [387] = 376,
  [388] = 386,
  [389] = 373,
  [390] = 390,
  [391] = 373,
  [392] = 390,
  [393] = 390,
  [394] = 374,
  [395] = 395,
  [396] = 373,
  [397] = 377,
  [398] = 375,
  [399] = 377,
  [400] = 395,
  [401] = 395,
  [402] = 376,
  [403] = 379,
  [404] = 380,
  [405] = 377,
  [406] = 378,
  [407] = 380,
  [408] = 395,
  [409] = 374,
  [410] = 376,
  [411] = 386,
  [412] = 379,
  [413] = 379,
  [414] = 375,
  [415] = 385,
  [416] = 378,
  [417] = 386,
  [418] = 390,
  [419] = 419,
  [420] = 419,
  [421] = 419,
  [422] = 419,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 423,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 424,
  [471] = 425,
  [472] = 426,
  [473] = 427,
  [474] = 428,
  [475] = 429,
  [476] = 430,
  [477] = 431,
  [478] = 432,
  [479] = 433,
  [480] = 434,
  [481] = 435,
  [482] = 423,
  [483] = 437,
  [484] = 438,
  [485] = 439,
  [486] = 440,
  [487] = 441,
  [488] = 442,
  [489] = 443,
  [490] = 444,
  [491] = 445,
  [492] = 446,
  [493] = 447,
  [494] = 448,
  [495] = 449,
  [496] = 450,
  [497] = 451,
  [498] = 452,
  [499] = 453,
  [500] = 454,
  [501] = 455,
  [502] = 456,
  [503] = 457,
  [504] = 458,
  [505] = 459,
  [506] = 460,
  [507] = 461,
  [508] = 462,
  [509] = 463,
  [510] = 464,
  [511] = 465,
  [512] = 466,
  [513] = 424,
  [514] = 425,
  [515] = 515,
  [516] = 427,
  [517] = 428,
  [518] = 429,
  [519] = 430,
  [520] = 431,
  [521] = 432,
  [522] = 433,
  [523] = 434,
  [524] = 435,
  [525] = 423,
  [526] = 437,
  [527] = 438,
  [528] = 439,
  [529] = 440,
  [530] = 441,
  [531] = 442,
  [532] = 443,
  [533] = 444,
  [534] = 445,
  [535] = 446,
  [536] = 447,
  [537] = 448,
  [538] = 449,
  [539] = 450,
  [540] = 451,
  [541] = 452,
  [542] = 453,
  [543] = 454,
  [544] = 455,
  [545] = 456,
  [546] = 457,
  [547] = 458,
  [548] = 459,
  [549] = 460,
  [550] = 461,
  [551] = 462,
  [552] = 463,
  [553] = 464,
  [554] = 465,
  [555] = 466,
  [556] = 424,
  [557] = 425,
  [558] = 426,
  [559] = 427,
  [560] = 428,
  [561] = 429,
  [562] = 430,
  [563] = 431,
  [564] = 432,
  [565] = 433,
  [566] = 434,
  [567] = 435,
  [568] = 437,
  [569] = 438,
  [570] = 439,
  [571] = 440,
  [572] = 441,
  [573] = 442,
  [574] = 443,
  [575] = 444,
  [576] = 445,
  [577] = 446,
  [578] = 447,
  [579] = 448,
  [580] = 449,
  [581] = 450,
  [582] = 451,
  [583] = 452,
  [584] = 453,
  [585] = 454,
  [586] = 455,
  [587] = 456,
  [588] = 457,
  [589] = 458,
  [590] = 459,
  [591] = 460,
  [592] = 461,
  [593] = 462,
  [594] = 463,
  [595] = 464,
  [596] = 465,
  [597] = 466,
  [598] = 426,
  [599] = 599,
  [600] = 600,
  [601] = 601,
  [602] = 600,
  [603] = 603,
  [604] = 604,
  [605] = 605,
  [606] = 603,
  [607] = 607,
  [608] = 604,
  [609] = 605,
  [610] = 610,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 600,
  [616] = 616,
  [617] = 612,
  [618] = 610,
  [619] = 611,
  [620] = 616,
  [621] = 610,
  [622] = 611,
  [623] = 613,
  [624] = 607,
  [625] = 613,
  [626] = 614,
  [627] = 599,
  [628] = 603,
  [629] = 607,
  [630] = 604,
  [631] = 614,
  [632] = 599,
  [633] = 633,
  [634] = 634,
  [635] = 605,
  [636] = 603,
  [637] = 607,
  [638] = 638,
  [639] = 601,
  [640] = 614,
  [641] = 599,
  [642] = 633,
  [643] = 634,
  [644] = 600,
  [645] = 633,
  [646] = 634,
  [647] = 612,
  [648] = 633,
  [649] = 604,
  [650] = 605,
  [651] = 634,
  [652] = 638,
  [653] = 612,
  [654] = 638,
  [655] = 601,
  [656] = 601,
  [657] = 616,
  [658] = 616,
  [659] = 638,
  [660] = 610,
  [661] = 611,
  [662] = 613,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 669,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 664,
  [675] = 675,
  [676] = 670,
  [677] = 668,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 669,
  [685] = 680,
  [686] = 672,
  [687] = 667,
  [688] = 671,
  [689] = 679,
  [690] = 665,
  [691] = 666,
  [692] = 673,
  [693] = 675,
  [694] = 678,
  [695] = 695,
  [696] = 696,
  [697] = 663,
  [698] = 681,
  [699] = 682,
  [700] = 683,
  [701] = 696,
  [702] = 702,
  [703] = 702,
  [704] = 368,
  [705] = 419,
  [706] = 464,
  [707] = 707,
  [708] = 708,
  [709] = 709,
  [710] = 710,
  [711] = 465,
  [712] = 430,
  [713] = 713,
  [714] = 453,
  [715] = 466,
  [716] = 431,
  [717] = 429,
  [718] = 432,
  [719] = 455,
  [720] = 456,
  [721] = 457,
  [722] = 458,
  [723] = 459,
  [724] = 460,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 454,
  [729] = 729,
  [730] = 461,
  [731] = 433,
  [732] = 434,
  [733] = 435,
  [734] = 423,
  [735] = 437,
  [736] = 438,
  [737] = 452,
  [738] = 738,
  [739] = 739,
  [740] = 450,
  [741] = 741,
  [742] = 739,
  [743] = 743,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 729,
  [748] = 709,
  [749] = 710,
  [750] = 462,
  [751] = 463,
  [752] = 725,
  [753] = 726,
  [754] = 727,
  [755] = 738,
  [756] = 756,
  [757] = 707,
  [758] = 708,
  [759] = 713,
  [760] = 451,
  [761] = 439,
  [762] = 440,
  [763] = 441,
  [764] = 756,
  [765] = 442,
  [766] = 380,
  [767] = 424,
  [768] = 768,
  [769] = 769,
  [770] = 741,
  [771] = 425,
  [772] = 426,
  [773] = 427,
  [774] = 443,
  [775] = 444,
  [776] = 445,
  [777] = 446,
  [778] = 428,
  [779] = 447,
  [780] = 448,
  [781] = 449,
  [782] = 743,
  [783] = 744,
  [784] = 745,
  [785] = 746,
  [786] = 769,
  [787] = 377,
  [788] = 613,
  [789] = 633,
  [790] = 634,
  [791] = 376,
  [792] = 616,
  [793] = 607,
  [794] = 604,
  [795] = 612,
  [796] = 379,
  [797] = 614,
  [798] = 605,
  [799] = 374,
  [800] = 638,
  [801] = 601,
  [802] = 599,
  [803] = 610,
  [804] = 611,
  [805] = 375,
  [806] = 378,
  [807] = 386,
  [808] = 390,
  [809] = 373,
  [810] = 603,
  [811] = 395,
  [812] = 600,
  [813] = 380,
  [814] = 380,
  [815] = 368,
  [816] = 816,
  [817] = 816,
  [818] = 368,
  [819] = 367,
  [820] = 379,
  [821] = 376,
  [822] = 374,
  [823] = 375,
  [824] = 378,
  [825] = 386,
  [826] = 390,
  [827] = 373,
  [828] = 377,
  [829] = 395,
  [830] = 380,
  [831] = 831,
  [832] = 376,
  [833] = 390,
  [834] = 373,
  [835] = 835,
  [836] = 395,
  [837] = 831,
  [838] = 374,
  [839] = 379,
  [840] = 379,
  [841] = 378,
  [842] = 386,
  [843] = 376,
  [844] = 377,
  [845] = 831,
  [846] = 831,
  [847] = 385,
  [848] = 831,
  [849] = 831,
  [850] = 831,
  [851] = 395,
  [852] = 374,
  [853] = 375,
  [854] = 377,
  [855] = 378,
  [856] = 386,
  [857] = 390,
  [858] = 373,
  [859] = 375,
  [860] = 419,
  [861] = 861,
  [862] = 862,
  [863] = 862,
  [864] = 385,
  [865] = 861,
  [866] = 861,
  [867] = 861,
  [868] = 861,
  [869] = 861,
  [870] = 861,
  [871] = 419,
  [872] = 458,
  [873] = 442,
  [874] = 430,
  [875] = 443,
  [876] = 444,
  [877] = 445,
  [878] = 446,
  [879] = 447,
  [880] = 880,
  [881] = 431,
  [882] = 448,
  [883] = 424,
  [884] = 884,
  [885] = 425,
  [886] = 886,
  [887] = 432,
  [888] = 441,
  [889] = 434,
  [890] = 449,
  [891] = 426,
  [892] = 892,
  [893] = 435,
  [894] = 423,
  [895] = 895,
  [896] = 427,
  [897] = 897,
  [898] = 898,
  [899] = 437,
  [900] = 438,
  [901] = 901,
  [902] = 428,
  [903] = 433,
  [904] = 439,
  [905] = 440,
  [906] = 906,
  [907] = 907,
  [908] = 441,
  [909] = 450,
  [910] = 910,
  [911] = 451,
  [912] = 912,
  [913] = 442,
  [914] = 429,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 443,
  [919] = 444,
  [920] = 452,
  [921] = 445,
  [922] = 453,
  [923] = 454,
  [924] = 455,
  [925] = 446,
  [926] = 926,
  [927] = 456,
  [928] = 447,
  [929] = 884,
  [930] = 886,
  [931] = 430,
  [932] = 926,
  [933] = 933,
  [934] = 910,
  [935] = 457,
  [936] = 448,
  [937] = 897,
  [938] = 431,
  [939] = 898,
  [940] = 906,
  [941] = 907,
  [942] = 915,
  [943] = 916,
  [944] = 449,
  [945] = 434,
  [946] = 897,
  [947] = 459,
  [948] = 898,
  [949] = 949,
  [950] = 906,
  [951] = 907,
  [952] = 915,
  [953] = 916,
  [954] = 897,
  [955] = 440,
  [956] = 439,
  [957] = 450,
  [958] = 916,
  [959] = 897,
  [960] = 898,
  [961] = 898,
  [962] = 906,
  [963] = 907,
  [964] = 461,
  [965] = 915,
  [966] = 916,
  [967] = 933,
  [968] = 451,
  [969] = 969,
  [970] = 970,
  [971] = 971,
  [972] = 432,
  [973] = 897,
  [974] = 898,
  [975] = 462,
  [976] = 906,
  [977] = 907,
  [978] = 915,
  [979] = 916,
  [980] = 452,
  [981] = 463,
  [982] = 453,
  [983] = 897,
  [984] = 898,
  [985] = 906,
  [986] = 464,
  [987] = 907,
  [988] = 915,
  [989] = 916,
  [990] = 990,
  [991] = 454,
  [992] = 433,
  [993] = 455,
  [994] = 917,
  [995] = 465,
  [996] = 996,
  [997] = 435,
  [998] = 970,
  [999] = 423,
  [1000] = 906,
  [1001] = 971,
  [1002] = 466,
  [1003] = 437,
  [1004] = 438,
  [1005] = 892,
  [1006] = 456,
  [1007] = 424,
  [1008] = 907,
  [1009] = 457,
  [1010] = 1010,
  [1011] = 425,
  [1012] = 426,
  [1013] = 427,
  [1014] = 428,
  [1015] = 458,
  [1016] = 459,
  [1017] = 460,
  [1018] = 895,
  [1019] = 901,
  [1020] = 461,
  [1021] = 462,
  [1022] = 463,
  [1023] = 464,
  [1024] = 465,
  [1025] = 466,
  [1026] = 912,
  [1027] = 996,
  [1028] = 915,
  [1029] = 429,
  [1030] = 460,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 1036,
  [1037] = 1037,
  [1038] = 1038,
  [1039] = 1039,
  [1040] = 610,
  [1041] = 611,
  [1042] = 613,
  [1043] = 1043,
  [1044] = 1044,
  [1045] = 603,
  [1046] = 607,
  [1047] = 614,
  [1048] = 599,
  [1049] = 1049,
  [1050] = 633,
  [1051] = 634,
  [1052] = 1052,
  [1053] = 638,
  [1054] = 601,
  [1055] = 1055,
  [1056] = 607,
  [1057] = 600,
  [1058] = 614,
  [1059] = 599,
  [1060] = 604,
  [1061] = 605,
  [1062] = 612,
  [1063] = 1063,
  [1064] = 616,
  [1065] = 1065,
  [1066] = 610,
  [1067] = 611,
  [1068] = 613,
  [1069] = 1069,
  [1070] = 633,
  [1071] = 634,
  [1072] = 603,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 638,
  [1076] = 1076,
  [1077] = 601,
  [1078] = 1043,
  [1079] = 1063,
  [1080] = 1065,
  [1081] = 1044,
  [1082] = 1082,
  [1083] = 600,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 1039,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1088,
  [1090] = 604,
  [1091] = 605,
  [1092] = 1031,
  [1093] = 612,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 616,
  [1098] = 1087,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1049,
  [1102] = 1035,
  [1103] = 1099,
  [1104] = 1076,
  [1105] = 1105,
  [1106] = 1044,
  [1107] = 1084,
  [1108] = 1085,
  [1109] = 1100,
  [1110] = 1094,
  [1111] = 1096,
  [1112] = 1087,
  [1113] = 1035,
  [1114] = 1114,
  [1115] = 1076,
  [1116] = 1116,
  [1117] = 1044,
  [1118] = 1118,
  [1119] = 1084,
  [1120] = 1085,
  [1121] = 1084,
  [1122] = 1085,
  [1123] = 1094,
  [1124] = 1096,
  [1125] = 1087,
  [1126] = 1035,
  [1127] = 1052,
  [1128] = 1076,
  [1129] = 1044,
  [1130] = 1084,
  [1131] = 1085,
  [1132] = 1036,
  [1133] = 1094,
  [1134] = 1038,
  [1135] = 1096,
  [1136] = 1087,
  [1137] = 1035,
  [1138] = 1076,
  [1139] = 1044,
  [1140] = 1084,
  [1141] = 1085,
  [1142] = 1073,
  [1143] = 1076,
  [1144] = 1094,
  [1145] = 1096,
  [1146] = 1087,
  [1147] = 1035,
  [1148] = 1076,
  [1149] = 1149,
  [1150] = 1044,
  [1151] = 1084,
  [1152] = 1085,
  [1153] = 1153,
  [1154] = 1094,
  [1155] = 1096,
  [1156] = 1087,
  [1157] = 1035,
  [1158] = 1084,
  [1159] = 1069,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 1037,
  [1163] = 1118,
  [1164] = 1034,
  [1165] = 1114,
  [1166] = 1032,
  [1167] = 1116,
  [1168] = 1160,
  [1169] = 1082,
  [1170] = 1074,
  [1171] = 1055,
  [1172] = 1149,
  [1173] = 1149,
  [1174] = 1149,
  [1175] = 1149,
  [1176] = 1149,
  [1177] = 1149,
  [1178] = 1149,
  [1179] = 1033,
  [1180] = 1094,
  [1181] = 1095,
  [1182] = 1096,
  [1183] = 1161,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1190,
  [1191] = 1190,
  [1192] = 1192,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 1196,
  [1197] = 1197,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1198,
  [1201] = 1193,
  [1202] = 1202,
  [1203] = 1203,
  [1204] = 1204,
  [1205] = 1187,
  [1206] = 1206,
  [1207] = 1192,
  [1208] = 1184,
  [1209] = 1206,
  [1210] = 1194,
  [1211] = 1211,
  [1212] = 1199,
  [1213] = 1202,
  [1214] = 1214,
  [1215] = 1215,
  [1216] = 1203,
  [1217] = 1215,
  [1218] = 1214,
  [1219] = 1204,
  [1220] = 1189,
  [1221] = 1196,
  [1222] = 1195,
  [1223] = 1197,
  [1224] = 1188,
  [1225] = 1193,
  [1226] = 1226,
  [1227] = 1227,
  [1228] = 1228,
  [1229] = 1229,
  [1230] = 1230,
  [1231] = 1231,
  [1232] = 1232,
  [1233] = 1233,
  [1234] = 1234,
  [1235] = 1235,
  [1236] = 1236,
  [1237] = 1237,
  [1238] = 1238,
  [1239] = 1239,
  [1240] = 1240,
  [1241] = 1241,
  [1242] = 1242,
  [1243] = 1243,
  [1244] = 1244,
  [1245] = 1245,
  [1246] = 1246,
  [1247] = 1247,
  [1248] = 1248,
  [1249] = 1249,
  [1250] = 1250,
  [1251] = 1246,
  [1252] = 1247,
  [1253] = 1253,
  [1254] = 1249,
  [1255] = 1255,
  [1256] = 1256,
  [1257] = 1257,
  [1258] = 1250,
  [1259] = 1259,
  [1260] = 1260,
  [1261] = 1261,
  [1262] = 1262,
  [1263] = 1263,
  [1264] = 1264,
  [1265] = 1255,
  [1266] = 1266,
  [1267] = 1267,
  [1268] = 1268,
  [1269] = 1269,
  [1270] = 1270,
  [1271] = 1271,
  [1272] = 1272,
  [1273] = 1273,
  [1274] = 1274,
  [1275] = 1275,
  [1276] = 1276,
  [1277] = 1242,
  [1278] = 1278,
  [1279] = 1279,
  [1280] = 1280,
  [1281] = 1281,
  [1282] = 1282,
  [1283] = 1283,
  [1284] = 1284,
  [1285] = 1285,
  [1286] = 1286,
  [1287] = 1287,
  [1288] = 1256,
  [1289] = 1259,
  [1290] = 1290,
  [1291] = 1291,
  [1292] = 1241,
  [1293] = 1243,
  [1294] = 1260,
  [1295] = 1295,
  [1296] = 1296,
  [1297] = 1287,
  [1298] = 1298,
  [1299] = 1299,
  [1300] = 1228,
  [1301] = 1237,
  [1302] = 1302,
  [1303] = 1303,
  [1304] = 1261,
  [1305] = 1305,
  [1306] = 1257,
  [1307] = 1227,
  [1308] = 1253,
  [1309] = 1309,
  [1310] = 1309,
  [1311] = 1311,
  [1312] = 1236,
  [1313] = 1267,
  [1314] = 1268,
  [1315] = 1315,
  [1316] = 1316,
  [1317] = 1269,
  [1318] = 1303,
  [1319] = 1305,
  [1320] = 1320,
  [1321] = 1231,
  [1322] = 1322,
  [1323] = 1323,
  [1324] = 1270,
  [1325] = 1238,
  [1326] = 1248,
  [1327] = 1263,
  [1328] = 1328,
  [1329] = 1329,
  [1330] = 1296,
  [1331] = 1295,
  [1332] = 1271,
  [1333] = 1272,
  [1334] = 1239,
  [1335] = 1335,
  [1336] = 1336,
  [1337] = 1274,
  [1338] = 1338,
  [1339] = 1278,
  [1340] = 1279,
  [1341] = 1273,
  [1342] = 1342,
  [1343] = 1343,
  [1344] = 1344,
  [1345] = 1275,
  [1346] = 1276,
  [1347] = 1347,
  [1348] = 1281,
  [1349] = 1298,
  [1350] = 1280,
  [1351] = 1240,
  [1352] = 1283,
  [1353] = 1232,
  [1354] = 1311,
  [1355] = 1299,
  [1356] = 1234,
  [1357] = 1235,
  [1358] = 1315,
  [1359] = 1316,
  [1360] = 1320,
  [1361] = 1322,
  [1362] = 1328,
  [1363] = 1363,
  [1364] = 1284,
  [1365] = 1302,
  [1366] = 1363,
  [1367] = 1367,
  [1368] = 1335,
  [1369] = 1336,
  [1370] = 1370,
  [1371] = 1229,
  [1372] = 1233,
  [1373] = 1230,
  [1374] = 1244,
  [1375] = 1245,
  [1376] = 1342,
  [1377] = 1344,
  [1378] = 1262,
  [1379] = 1264,
  [1380] = 1266,
  [1381] = 1290,
  [1382] = 1323,
  [1383] = 1285,
  [1384] = 1347,
  [1385] = 1286,
  [1386] = 1329,
  [1387] = 1291,
  [1388] = 1367,
  [1389] = 1282,
  [1390] = 1370,
  [1391] = 1338,
  [1392] = 1392,
  [1393] = 1393,
  [1394] = 1394,
  [1395] = 1394,
  [1396] = 1396,
  [1397] = 1397,
  [1398] = 1396,
  [1399] = 1399,
  [1400] = 1399,
  [1401] = 1397,
  [1402] = 1402,
  [1403] = 1402,
  [1404] = 1404,
  [1405] = 1405,
  [1406] = 1406,
  [1407] = 1407,
  [1408] = 1408,
  [1409] = 1409,
  [1410] = 1409,
  [1411] = 1407,
  [1412] = 1407,
  [1413] = 1413,
  [1414] = 1407,
  [1415] = 1408,
  [1416] = 1416,
  [1417] = 1407,
  [1418] = 1408,
  [1419] = 1408,
  [1420] = 1407,
  [1421] = 1421,
  [1422] = 1408,
  [1423] = 1423,
  [1424] = 1413,
  [1425] = 1408,
  [1426] = 1407,
  [1427] = 1421,
  [1428] = 1428,
  [1429] = 1429,
  [1430] = 1423,
  [1431] = 1408,
  [1432] = 1428,
  [1433] = 816,
  [1434] = 380,
  [1435] = 1435,
  [1436] = 1436,
  [1437] = 611,
  [1438] = 1438,
  [1439] = 466,
  [1440] = 1440,
  [1441] = 610,
  [1442] = 603,
  [1443] = 613,
  [1444] = 1444,
  [1445] = 1445,
  [1446] = 1446,
  [1447] = 1447,
  [1448] = 1448,
  [1449] = 1448,
  [1450] = 1450,
  [1451] = 1451,
  [1452] = 1452,
  [1453] = 1452,
  [1454] = 933,
  [1455] = 1455,
  [1456] = 1074,
  [1457] = 1069,
  [1458] = 1052,
  [1459] = 1459,
  [1460] = 1459,
  [1461] = 1043,
  [1462] = 1455,
  [1463] = 380,
  [1464] = 1464,
  [1465] = 1465,
  [1466] = 1466,
  [1467] = 1467,
  [1468] = 1468,
  [1469] = 1469,
  [1470] = 1470,
  [1471] = 1471,
  [1472] = 1472,
  [1473] = 1473,
  [1474] = 1474,
  [1475] = 1472,
  [1476] = 1467,
  [1477] = 1472,
  [1478] = 1049,
  [1479] = 1469,
  [1480] = 1470,
  [1481] = 1472,
  [1482] = 1472,
  [1483] = 1483,
  [1484] = 1472,
  [1485] = 1474,
  [1486] = 1472,
  [1487] = 1487,
  [1488] = 1487,
  [1489] = 1473,
  [1490] = 1465,
  [1491] = 1491,
  [1492] = 1492,
  [1493] = 1491,
  [1494] = 1491,
  [1495] = 1495,
  [1496] = 1491,
  [1497] = 1491,
  [1498] = 1498,
  [1499] = 1499,
  [1500] = 1500,
  [1501] = 1501,
  [1502] = 1491,
  [1503] = 1491,
  [1504] = 1492,
  [1505] = 1505,
  [1506] = 1506,
  [1507] = 1491,
  [1508] = 1508,
  [1509] = 1509,
  [1510] = 1510,
  [1511] = 1511,
  [1512] = 1512,
  [1513] = 1513,
  [1514] = 1514,
  [1515] = 1512,
  [1516] = 1509,
  [1517] = 1517,
  [1518] = 1518,
  [1519] = 1511,
  [1520] = 1520,
  [1521] = 1510,
  [1522] = 1522,
  [1523] = 1523,
  [1524] = 1518,
  [1525] = 1522,
  [1526] = 1526,
  [1527] = 1527,
  [1528] = 1526,
  [1529] = 1529,
  [1530] = 1514,
  [1531] = 1523,
  [1532] = 1532,
  [1533] = 1532,
  [1534] = 1512,
  [1535] = 1527,
  [1536] = 1513,
  [1537] = 1537,
  [1538] = 1538,
  [1539] = 1538,
  [1540] = 1540,
  [1541] = 926,
  [1542] = 1542,
  [1543] = 1537,
  [1544] = 1544,
  [1545] = 1545,
  [1546] = 1540,
  [1547] = 1547,
  [1548] = 1548,
  [1549] = 1549,
  [1550] = 1550,
  [1551] = 1540,
  [1552] = 1552,
  [1553] = 1553,
  [1554] = 1554,
  [1555] = 1545,
  [1556] = 1547,
  [1557] = 1557,
  [1558] = 1549,
  [1559] = 1540,
  [1560] = 1560,
  [1561] = 1561,
  [1562] = 912,
  [1563] = 1545,
  [1564] = 1547,
  [1565] = 1565,
  [1566] = 1566,
  [1567] = 1549,
  [1568] = 1560,
  [1569] = 1540,
  [1570] = 1549,
  [1571] = 1544,
  [1572] = 892,
  [1573] = 1573,
  [1574] = 1574,
  [1575] = 1575,
  [1576] = 1561,
  [1577] = 1540,
  [1578] = 1545,
  [1579] = 1574,
  [1580] = 1545,
  [1581] = 1581,
  [1582] = 1537,
  [1583] = 1241,
  [1584] = 1547,
  [1585] = 1550,
  [1586] = 1537,
  [1587] = 1538,
  [1588] = 1588,
  [1589] = 1589,
  [1590] = 1545,
  [1591] = 1547,
  [1592] = 1537,
  [1593] = 1549,
  [1594] = 1594,
  [1595] = 1565,
  [1596] = 1596,
  [1597] = 1537,
  [1598] = 1540,
  [1599] = 1599,
  [1600] = 1549,
  [1601] = 1554,
  [1602] = 1566,
  [1603] = 1547,
  [1604] = 1537,
  [1605] = 1552,
  [1606] = 1545,
  [1607] = 1547,
  [1608] = 1575,
  [1609] = 1594,
  [1610] = 1549,
  [1611] = 1553,
  [1612] = 1612,
  [1613] = 1613,
  [1614] = 892,
  [1615] = 1615,
  [1616] = 1616,
  [1617] = 1617,
  [1618] = 1618,
  [1619] = 1616,
  [1620] = 1620,
  [1621] = 1621,
  [1622] = 1622,
  [1623] = 1623,
  [1624] = 1624,
  [1625] = 1625,
  [1626] = 1613,
  [1627] = 1627,
  [1628] = 1628,
  [1629] = 1082,
  [1630] = 1630,
  [1631] = 1631,
  [1632] = 1625,
  [1633] = 1633,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 1636,
  [1637] = 1612,
  [1638] = 1638,
  [1639] = 1615,
  [1640] = 1620,
  [1641] = 1616,
  [1642] = 1615,
  [1643] = 1620,
  [1644] = 1616,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 1613,
  [1648] = 1648,
  [1649] = 1628,
  [1650] = 1650,
  [1651] = 1645,
  [1652] = 1652,
  [1653] = 1625,
  [1654] = 1638,
  [1655] = 1634,
  [1656] = 1063,
  [1657] = 1065,
  [1658] = 1616,
  [1659] = 1634,
  [1660] = 1615,
  [1661] = 1620,
  [1662] = 1662,
  [1663] = 1616,
  [1664] = 1664,
  [1665] = 1665,
  [1666] = 1666,
  [1667] = 1667,
  [1668] = 1668,
  [1669] = 1633,
  [1670] = 912,
  [1671] = 1671,
  [1672] = 1635,
  [1673] = 1673,
  [1674] = 1674,
  [1675] = 1675,
  [1676] = 1676,
  [1677] = 1668,
  [1678] = 1617,
  [1679] = 1679,
  [1680] = 1680,
  [1681] = 1681,
  [1682] = 1622,
  [1683] = 1683,
  [1684] = 1631,
  [1685] = 1685,
  [1686] = 1613,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1674,
  [1691] = 1691,
  [1692] = 1617,
  [1693] = 1628,
  [1694] = 1694,
  [1695] = 1695,
  [1696] = 1665,
  [1697] = 1665,
  [1698] = 1698,
  [1699] = 1613,
  [1700] = 1088,
  [1701] = 1674,
  [1702] = 1617,
  [1703] = 1703,
  [1704] = 1675,
  [1705] = 1628,
  [1706] = 1634,
  [1707] = 1625,
  [1708] = 1073,
  [1709] = 1709,
  [1710] = 1695,
  [1711] = 1674,
  [1712] = 1617,
  [1713] = 1713,
  [1714] = 1676,
  [1715] = 1613,
  [1716] = 1625,
  [1717] = 1666,
  [1718] = 1674,
  [1719] = 1634,
  [1720] = 1617,
  [1721] = 1618,
  [1722] = 1625,
  [1723] = 1694,
  [1724] = 1628,
  [1725] = 1679,
  [1726] = 1634,
  [1727] = 1727,
  [1728] = 1615,
  [1729] = 1620,
  [1730] = 1674,
  [1731] = 1617,
  [1732] = 1628,
  [1733] = 1616,
  [1734] = 1636,
  [1735] = 1634,
  [1736] = 1630,
  [1737] = 1662,
  [1738] = 1727,
  [1739] = 1630,
  [1740] = 1673,
  [1741] = 1630,
  [1742] = 1695,
  [1743] = 1630,
  [1744] = 1625,
  [1745] = 1630,
  [1746] = 1674,
  [1747] = 1613,
  [1748] = 1630,
  [1749] = 1749,
  [1750] = 926,
  [1751] = 1615,
  [1752] = 1652,
  [1753] = 1753,
  [1754] = 1628,
  [1755] = 1680,
  [1756] = 1615,
  [1757] = 1620,
  [1758] = 1650,
  [1759] = 1671,
  [1760] = 1620,
  [1761] = 1761,
  [1762] = 1762,
  [1763] = 1763,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 1766,
  [1767] = 1767,
  [1768] = 1768,
  [1769] = 1761,
  [1770] = 1770,
  [1771] = 1770,
  [1772] = 1206,
  [1773] = 1761,
  [1774] = 1774,
  [1775] = 1775,
  [1776] = 1776,
  [1777] = 1777,
  [1778] = 1761,
  [1779] = 1779,
  [1780] = 1780,
  [1781] = 1196,
  [1782] = 1775,
  [1783] = 1761,
  [1784] = 1764,
  [1785] = 1770,
  [1786] = 1770,
  [1787] = 1770,
  [1788] = 1788,
  [1789] = 1761,
  [1790] = 1790,
  [1791] = 1776,
  [1792] = 1792,
  [1793] = 1793,
  [1794] = 1763,
  [1795] = 1770,
  [1796] = 1788,
  [1797] = 1184,
  [1798] = 1770,
  [1799] = 1793,
  [1800] = 1770,
  [1801] = 1801,
  [1802] = 1792,
  [1803] = 1801,
  [1804] = 1804,
  [1805] = 1761,
  [1806] = 1764,
  [1807] = 1764,
  [1808] = 1764,
  [1809] = 1764,
  [1810] = 1764,
  [1811] = 1811,
  [1812] = 1812,
  [1813] = 1813,
  [1814] = 1812,
  [1815] = 1815,
  [1816] = 1816,
  [1817] = 1817,
  [1818] = 1812,
  [1819] = 1816,
  [1820] = 1817,
  [1821] = 1821,
  [1822] = 1821,
  [1823] = 1823,
  [1824] = 1824,
  [1825] = 1825,
  [1826] = 1826,
  [1827] = 1827,
  [1828] = 1828,
  [1829] = 1829,
  [1830] = 1830,
  [1831] = 1823,
  [1832] = 1832,
  [1833] = 1823,
  [1834] = 1834,
  [1835] = 1835,
  [1836] = 1829,
  [1837] = 1837,
  [1838] = 1838,
  [1839] = 1839,
  [1840] = 1813,
  [1841] = 1841,
  [1842] = 1816,
  [1843] = 1843,
  [1844] = 1844,
  [1845] = 1845,
  [1846] = 1812,
  [1847] = 1847,
  [1848] = 1821,
  [1849] = 1838,
  [1850] = 1850,
  [1851] = 1824,
  [1852] = 1852,
  [1853] = 1852,
  [1854] = 1813,
  [1855] = 1815,
  [1856] = 1850,
  [1857] = 1830,
  [1858] = 1828,
  [1859] = 1828,
  [1860] = 1828,
  [1861] = 1861,
  [1862] = 1862,
  [1863] = 1847,
  [1864] = 1837,
  [1865] = 1838,
  [1866] = 1839,
  [1867] = 1823,
  [1868] = 1868,
  [1869] = 1834,
  [1870] = 1870,
  [1871] = 1871,
  [1872] = 1872,
  [1873] = 1873,
  [1874] = 1817,
  [1875] = 1821,
  [1876] = 1876,
  [1877] = 1852,
  [1878] = 1824,
  [1879] = 1821,
  [1880] = 1880,
  [1881] = 1847,
  [1882] = 1882,
  [1883] = 1839,
  [1884] = 1830,
  [1885] = 1824,
  [1886] = 1886,
  [1887] = 1852,
  [1888] = 1830,
  [1889] = 1847,
  [1890] = 1829,
  [1891] = 1837,
  [1892] = 1838,
  [1893] = 1839,
  [1894] = 1823,
  [1895] = 1824,
  [1896] = 1896,
  [1897] = 1897,
  [1898] = 1898,
  [1899] = 1812,
  [1900] = 1900,
  [1901] = 1901,
  [1902] = 1821,
  [1903] = 1847,
  [1904] = 1829,
  [1905] = 1824,
  [1906] = 1861,
  [1907] = 1815,
  [1908] = 1816,
  [1909] = 1861,
  [1910] = 1843,
  [1911] = 1830,
  [1912] = 1815,
  [1913] = 1913,
  [1914] = 1850,
  [1915] = 1915,
  [1916] = 1916,
  [1917] = 1817,
  [1918] = 1837,
  [1919] = 1838,
  [1920] = 1839,
  [1921] = 1827,
  [1922] = 1841,
  [1923] = 1834,
  [1924] = 1850,
  [1925] = 1925,
  [1926] = 1861,
  [1927] = 1841,
  [1928] = 1928,
  [1929] = 1821,
  [1930] = 1930,
  [1931] = 1812,
  [1932] = 1824,
  [1933] = 1841,
  [1934] = 1812,
  [1935] = 1843,
  [1936] = 1823,
  [1937] = 1868,
  [1938] = 1830,
  [1939] = 1828,
  [1940] = 1823,
  [1941] = 1815,
  [1942] = 1834,
  [1943] = 1843,
  [1944] = 1834,
  [1945] = 1850,
  [1946] = 1843,
  [1947] = 1852,
  [1948] = 1897,
  [1949] = 1816,
  [1950] = 1829,
  [1951] = 1828,
  [1952] = 1952,
  [1953] = 1815,
  [1954] = 1850,
  [1955] = 1830,
  [1956] = 1816,
  [1957] = 1852,
  [1958] = 1825,
  [1959] = 1861,
  [1960] = 1817,
  [1961] = 1815,
  [1962] = 1834,
  [1963] = 1897,
  [1964] = 1826,
  [1965] = 1852,
  [1966] = 1825,
  [1967] = 1843,
  [1968] = 1829,
  [1969] = 1861,
  [1970] = 1825,
  [1971] = 1850,
  [1972] = 1829,
  [1973] = 1852,
  [1974] = 1825,
  [1975] = 1817,
  [1976] = 1847,
  [1977] = 1861,
  [1978] = 1825,
  [1979] = 1834,
  [1980] = 1980,
  [1981] = 1816,
  [1982] = 1825,
  [1983] = 1837,
  [1984] = 1841,
  [1985] = 1845,
  [1986] = 1896,
  [1987] = 1900,
  [1988] = 1930,
  [1989] = 1817,
  [1990] = 1886,
  [1991] = 1900,
  [1992] = 1992,
  [1993] = 1837,
  [1994] = 1900,
  [1995] = 1838,
  [1996] = 1828,
  [1997] = 1900,
  [1998] = 1998,
  [1999] = 1880,
  [2000] = 1900,
  [2001] = 1839,
  [2002] = 2002,
  [2003] = 1900,
  [2004] = 1873,
  [2005] = 1847,
  [2006] = 1841,
  [2007] = 1837,
  [2008] = 1838,
  [2009] = 1839,
  [2010] = 1843,
  [2011] = 1915,
  [2012] = 1876,
  [2013] = 1876,
  [2014] = 1876,
  [2015] = 1876,
  [2016] = 1876,
  [2017] = 1876,
  [2018] = 1841,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(17);
      ADVANCE_MAP(
        '!', 12,
        '"', 1,
        '%', 44,
        '(', 27,
        ')', 28,
        '*', 41,
        '+', 39,
        ',', 20,
        '-', 40,
        '.', 32,
        '/', 42,
        ':', 11,
        ';', 26,
        '<', 19,
        '=', 25,
        '>', 22,
        '@', 15,
        '[', 33,
        ']', 34,
        '_', 30,
        '{', 23,
        '|', 29,
        '}', 24,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(48);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(49);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(53);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(1);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '(', 27,
        ')', 28,
        '*', 41,
        '+', 39,
        ',', 20,
        '.', 31,
        '/', 43,
        ':', 11,
        ';', 26,
        '<', 18,
        '=', 25,
        '>', 21,
        ']', 34,
        '{', 23,
        '|', 29,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(51);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(48);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(49);
      END_STATE();
    case 3:
      if (lookahead == '*') ADVANCE(5);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 4:
      if (lookahead == '*') ADVANCE(10);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 5:
      if (lookahead == '*') ADVANCE(6);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 6:
      if (lookahead == '*') ADVANCE(6);
      if (lookahead == '/') ADVANCE(45);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 7:
      if (lookahead == '*') ADVANCE(6);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(8);
      if (lookahead == '/') ADVANCE(55);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(8);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 10:
      if (lookahead == '/') ADVANCE(55);
      END_STATE();
    case 11:
      if (lookahead == ':') ADVANCE(46);
      END_STATE();
    case 12:
      if (lookahead == '=') ADVANCE(36);
      END_STATE();
    case 13:
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(1);
      END_STATE();
    case 14:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(52);
      END_STATE();
    case 15:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(47);
      END_STATE();
    case 16:
      if (eof) ADVANCE(17);
      ADVANCE_MAP(
        '!', 12,
        '"', 1,
        '%', 44,
        '(', 27,
        ')', 28,
        '*', 41,
        '+', 39,
        ',', 20,
        '-', 40,
        '.', 32,
        '/', 43,
        ':', 11,
        ';', 26,
        '<', 19,
        '=', 25,
        '>', 22,
        '@', 15,
        '[', 33,
        ']', 34,
        '_', 30,
        '{', 23,
        '|', 29,
        '}', 24,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(48);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(49);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(37);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(38);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(sym_underscore);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(35);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(3);
      if (lookahead == '/') ADVANCE(54);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(4);
      if (lookahead == '/') ADVANCE(54);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_qldoc);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_dbtype);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(47);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym__upper_id);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(48);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym__lower_id);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(49);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_integer);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(51);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(52);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(54);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_block_comment);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_block_comment);
      if (lookahead == '*') ADVANCE(6);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'i', 7,
        'm', 8,
        'n', 9,
        'o', 10,
        'p', 11,
        'r', 12,
        's', 13,
        't', 14,
        'u', 15,
        'w', 16,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(17);
      if (lookahead == 's') ADVANCE(18);
      if (lookahead == 'v') ADVANCE(19);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      END_STATE();
    case 3:
      if (lookahead == 'l') ADVANCE(22);
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(24);
      if (lookahead == 'e') ADVANCE(25);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(26);
      if (lookahead == 'x') ADVANCE(27);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(28);
      if (lookahead == 'l') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      if (lookahead == 'r') ADVANCE(31);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(32);
      if (lookahead == 'm') ADVANCE(33);
      if (lookahead == 'n') ADVANCE(34);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(36);
      if (lookahead == 'o') ADVANCE(37);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(38);
      if (lookahead == 'o') ADVANCE(39);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(41);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(42);
      if (lookahead == 'e') ADVANCE(43);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 't') ADVANCE(45);
      if (lookahead == 'u') ADVANCE(46);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(47);
      if (lookahead == 'r') ADVANCE(48);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(49);
      END_STATE();
    case 16:
      if (lookahead == 'h') ADVANCE(50);
      END_STATE();
    case 17:
      if (lookahead == 'd') ADVANCE(51);
      if (lookahead == 'y') ADVANCE(52);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'c') ADVANCE(53);
      END_STATE();
    case 19:
      if (lookahead == 'g') ADVANCE(54);
      END_STATE();
    case 20:
      if (lookahead == 'o') ADVANCE(55);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_by);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(56);
      END_STATE();
    case 23:
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead == 'u') ADVANCE(58);
      END_STATE();
    case 24:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(60);
      END_STATE();
    case 26:
      if (lookahead == 's') ADVANCE(61);
      END_STATE();
    case 27:
      if (lookahead == 'i') ADVANCE(62);
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 28:
      if (lookahead == 'l') ADVANCE(64);
      END_STATE();
    case 29:
      if (lookahead == 'o') ADVANCE(65);
      END_STATE();
    case 30:
      if (lookahead == 'r') ADVANCE(66);
      END_STATE();
    case 31:
      if (lookahead == 'o') ADVANCE(67);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 33:
      if (lookahead == 'p') ADVANCE(68);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 's') ADVANCE(69);
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 35:
      if (lookahead == 'x') ADVANCE(71);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(72);
      END_STATE();
    case 37:
      if (lookahead == 'd') ADVANCE(73);
      END_STATE();
    case 38:
      if (lookahead == 'w') ADVANCE(74);
      END_STATE();
    case 39:
      if (lookahead == 'n') ADVANCE(75);
      if (lookahead == 't') ADVANCE(76);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == 'd') ADVANCE(77);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(78);
      END_STATE();
    case 42:
      if (lookahead == 'n') ADVANCE(79);
      END_STATE();
    case 43:
      if (lookahead == 's') ADVANCE(80);
      END_STATE();
    case 44:
      if (lookahead == 'l') ADVANCE(81);
      END_STATE();
    case 45:
      if (lookahead == 'r') ADVANCE(82);
      END_STATE();
    case 46:
      if (lookahead == 'm') ADVANCE(83);
      if (lookahead == 'p') ADVANCE(84);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(85);
      if (lookahead == 'i') ADVANCE(86);
      END_STATE();
    case 48:
      if (lookahead == 'u') ADVANCE(87);
      END_STATE();
    case 49:
      if (lookahead == 'i') ADVANCE(88);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(89);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_asc);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_avg);
      END_STATE();
    case 55:
      if (lookahead == 'l') ADVANCE(90);
      END_STATE();
    case 56:
      if (lookahead == 's') ADVANCE(91);
      END_STATE();
    case 57:
      if (lookahead == 'c') ADVANCE(92);
      END_STATE();
    case 58:
      if (lookahead == 'n') ADVANCE(93);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 60:
      if (lookahead == 'c') ADVANCE(95);
      END_STATE();
    case 61:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 62:
      if (lookahead == 's') ADVANCE(97);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 64:
      if (lookahead == 's') ADVANCE(99);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 66:
      if (lookahead == 'a') ADVANCE(101);
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 67:
      if (lookahead == 'm') ADVANCE(103);
      END_STATE();
    case 68:
      if (lookahead == 'l') ADVANCE(104);
      if (lookahead == 'o') ADVANCE(105);
      END_STATE();
    case 69:
      if (lookahead == 't') ADVANCE(106);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_max);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_min);
      END_STATE();
    case 73:
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 74:
      if (lookahead == 't') ADVANCE(108);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(110);
      END_STATE();
    case 78:
      if (lookahead == 'd') ADVANCE(111);
      END_STATE();
    case 79:
      if (lookahead == 'k') ADVANCE(112);
      END_STATE();
    case 80:
      if (lookahead == 'u') ADVANCE(113);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(114);
      END_STATE();
    case 82:
      if (lookahead == 'i') ADVANCE(115);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_sum);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 85:
      if (lookahead == 'n') ADVANCE(117);
      END_STATE();
    case 86:
      if (lookahead == 's') ADVANCE(118);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(119);
      END_STATE();
    case 88:
      if (lookahead == 'q') ADVANCE(120);
      END_STATE();
    case 89:
      if (lookahead == 'r') ADVANCE(121);
      END_STATE();
    case 90:
      if (lookahead == 'e') ADVANCE(122);
      END_STATE();
    case 91:
      if (lookahead == 's') ADVANCE(123);
      END_STATE();
    case 92:
      if (lookahead == 'a') ADVANCE(124);
      END_STATE();
    case 93:
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_date);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_desc);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 97:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 98:
      if (lookahead == 'n') ADVANCE(127);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 100:
      if (lookahead == 't') ADVANCE(129);
      END_STATE();
    case 101:
      if (lookahead == 'l') ADVANCE(130);
      END_STATE();
    case 102:
      if (lookahead == 'x') ADVANCE(131);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(132);
      if (lookahead == 'i') ADVANCE(133);
      END_STATE();
    case 105:
      if (lookahead == 'r') ADVANCE(134);
      END_STATE();
    case 106:
      if (lookahead == 'a') ADVANCE(135);
      END_STATE();
    case 107:
      if (lookahead == 'l') ADVANCE(136);
      END_STATE();
    case 108:
      if (lookahead == 'y') ADVANCE(137);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_specialId);
      END_STATE();
    case 110:
      if (lookahead == 'r') ADVANCE(138);
      END_STATE();
    case 111:
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_rank);
      END_STATE();
    case 113:
      if (lookahead == 'l') ADVANCE(140);
      END_STATE();
    case 114:
      if (lookahead == 'c') ADVANCE(141);
      END_STATE();
    case 115:
      if (lookahead == 'c') ADVANCE(142);
      if (lookahead == 'n') ADVANCE(143);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(144);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 120:
      if (lookahead == 'u') ADVANCE(145);
      END_STATE();
    case 121:
      if (lookahead == 'e') ADVANCE(146);
      END_STATE();
    case 122:
      if (lookahead == 'a') ADVANCE(147);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 124:
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_count);
      END_STATE();
    case 126:
      if (lookahead == 's') ADVANCE(149);
      END_STATE();
    case 127:
      if (lookahead == 'd') ADVANCE(150);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(151);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_forex);
      END_STATE();
    case 132:
      if (lookahead == 'm') ADVANCE(152);
      END_STATE();
    case 133:
      if (lookahead == 'e') ADVANCE(153);
      END_STATE();
    case 134:
      if (lookahead == 't') ADVANCE(154);
      END_STATE();
    case 135:
      if (lookahead == 'n') ADVANCE(155);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(156);
      END_STATE();
    case 137:
      if (lookahead == 'p') ADVANCE(157);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_order);
      END_STATE();
    case 139:
      if (lookahead == 'c') ADVANCE(158);
      END_STATE();
    case 140:
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 141:
      if (lookahead == 't') ADVANCE(160);
      END_STATE();
    case 142:
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 143:
      if (lookahead == 'g') ADVANCE(162);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 145:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_where);
      END_STATE();
    case 147:
      if (lookahead == 'n') ADVANCE(164);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_concat);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_exists);
      END_STATE();
    case 150:
      if (lookahead == 's') ADVANCE(165);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_forall);
      END_STATE();
    case 152:
      if (lookahead == 'e') ADVANCE(166);
      END_STATE();
    case 153:
      if (lookahead == 's') ADVANCE(167);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 155:
      if (lookahead == 'c') ADVANCE(168);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 157:
      if (lookahead == 'e') ADVANCE(169);
      END_STATE();
    case 158:
      if (lookahead == 'a') ADVANCE(170);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_result);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_select);
      END_STATE();
    case 161:
      if (lookahead == 'c') ADVANCE(171);
      if (lookahead == 's') ADVANCE(172);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_unique);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 166:
      if (lookahead == 'n') ADVANCE(173);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_implies);
      END_STATE();
    case 168:
      if (lookahead == 'e') ADVANCE(174);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_newtype);
      END_STATE();
    case 170:
      if (lookahead == 't') ADVANCE(175);
      END_STATE();
    case 171:
      if (lookahead == 'o') ADVANCE(176);
      END_STATE();
    case 172:
      if (lookahead == 'u') ADVANCE(177);
      END_STATE();
    case 173:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 174:
      if (lookahead == 'o') ADVANCE(179);
      END_STATE();
    case 175:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 176:
      if (lookahead == 'n') ADVANCE(181);
      if (lookahead == 'u') ADVANCE(182);
      END_STATE();
    case 177:
      if (lookahead == 'm') ADVANCE(183);
      END_STATE();
    case 178:
      if (lookahead == 's') ADVANCE(184);
      END_STATE();
    case 179:
      if (lookahead == 'f') ADVANCE(185);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_predicate);
      END_STATE();
    case 181:
      if (lookahead == 'c') ADVANCE(186);
      END_STATE();
    case 182:
      if (lookahead == 'n') ADVANCE(187);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_strictsum);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    case 186:
      if (lookahead == 'a') ADVANCE(188);
      END_STATE();
    case 187:
      if (lookahead == 't') ADVANCE(189);
      END_STATE();
    case 188:
      if (lookahead == 't') ADVANCE(190);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_strictcount);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_strictconcat);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 16},
  [3] = {.lex_state = 16},
  [4] = {.lex_state = 16},
  [5] = {.lex_state = 16},
  [6] = {.lex_state = 16},
  [7] = {.lex_state = 16},
  [8] = {.lex_state = 16},
  [9] = {.lex_state = 16},
  [10] = {.lex_state = 16},
  [11] = {.lex_state = 16},
  [12] = {.lex_state = 16},
  [13] = {.lex_state = 16},
  [14] = {.lex_state = 16},
  [15] = {.lex_state = 16},
  [16] = {.lex_state = 16},
  [17] = {.lex_state = 16},
  [18] = {.lex_state = 16},
  [19] = {.lex_state = 16},
  [20] = {.lex_state = 16},
  [21] = {.lex_state = 16},
  [22] = {.lex_state = 16},
  [23] = {.lex_state = 16},
  [24] = {.lex_state = 16},
  [25] = {.lex_state = 16},
  [26] = {.lex_state = 16},
  [27] = {.lex_state = 16},
  [28] = {.lex_state = 16},
  [29] = {.lex_state = 16},
  [30] = {.lex_state = 16},
  [31] = {.lex_state = 16},
  [32] = {.lex_state = 16},
  [33] = {.lex_state = 16},
  [34] = {.lex_state = 16},
  [35] = {.lex_state = 16},
  [36] = {.lex_state = 16},
  [37] = {.lex_state = 16},
  [38] = {.lex_state = 16},
  [39] = {.lex_state = 16},
  [40] = {.lex_state = 16},
  [41] = {.lex_state = 16},
  [42] = {.lex_state = 16},
  [43] = {.lex_state = 16},
  [44] = {.lex_state = 16},
  [45] = {.lex_state = 16},
  [46] = {.lex_state = 16},
  [47] = {.lex_state = 16},
  [48] = {.lex_state = 16},
  [49] = {.lex_state = 16},
  [50] = {.lex_state = 16},
  [51] = {.lex_state = 16},
  [52] = {.lex_state = 16},
  [53] = {.lex_state = 16},
  [54] = {.lex_state = 16},
  [55] = {.lex_state = 16},
  [56] = {.lex_state = 16},
  [57] = {.lex_state = 16},
  [58] = {.lex_state = 16},
  [59] = {.lex_state = 16},
  [60] = {.lex_state = 16},
  [61] = {.lex_state = 16},
  [62] = {.lex_state = 16},
  [63] = {.lex_state = 16},
  [64] = {.lex_state = 16},
  [65] = {.lex_state = 16},
  [66] = {.lex_state = 16},
  [67] = {.lex_state = 16},
  [68] = {.lex_state = 16},
  [69] = {.lex_state = 16},
  [70] = {.lex_state = 16},
  [71] = {.lex_state = 16},
  [72] = {.lex_state = 16},
  [73] = {.lex_state = 16},
  [74] = {.lex_state = 16},
  [75] = {.lex_state = 16},
  [76] = {.lex_state = 16},
  [77] = {.lex_state = 16},
  [78] = {.lex_state = 16},
  [79] = {.lex_state = 16},
  [80] = {.lex_state = 16},
  [81] = {.lex_state = 16},
  [82] = {.lex_state = 16},
  [83] = {.lex_state = 16},
  [84] = {.lex_state = 16},
  [85] = {.lex_state = 16},
  [86] = {.lex_state = 16},
  [87] = {.lex_state = 16},
  [88] = {.lex_state = 16},
  [89] = {.lex_state = 16},
  [90] = {.lex_state = 16},
  [91] = {.lex_state = 16},
  [92] = {.lex_state = 16},
  [93] = {.lex_state = 16},
  [94] = {.lex_state = 16},
  [95] = {.lex_state = 16},
  [96] = {.lex_state = 16},
  [97] = {.lex_state = 16},
  [98] = {.lex_state = 16},
  [99] = {.lex_state = 16},
  [100] = {.lex_state = 16},
  [101] = {.lex_state = 16},
  [102] = {.lex_state = 16},
  [103] = {.lex_state = 16},
  [104] = {.lex_state = 16},
  [105] = {.lex_state = 16},
  [106] = {.lex_state = 16},
  [107] = {.lex_state = 16},
  [108] = {.lex_state = 16},
  [109] = {.lex_state = 16},
  [110] = {.lex_state = 16},
  [111] = {.lex_state = 16},
  [112] = {.lex_state = 16},
  [113] = {.lex_state = 16},
  [114] = {.lex_state = 16},
  [115] = {.lex_state = 16},
  [116] = {.lex_state = 16},
  [117] = {.lex_state = 16},
  [118] = {.lex_state = 16},
  [119] = {.lex_state = 16},
  [120] = {.lex_state = 16},
  [121] = {.lex_state = 16},
  [122] = {.lex_state = 16},
  [123] = {.lex_state = 16},
  [124] = {.lex_state = 16},
  [125] = {.lex_state = 16},
  [126] = {.lex_state = 16},
  [127] = {.lex_state = 16},
  [128] = {.lex_state = 16},
  [129] = {.lex_state = 16},
  [130] = {.lex_state = 16},
  [131] = {.lex_state = 16},
  [132] = {.lex_state = 16},
  [133] = {.lex_state = 16},
  [134] = {.lex_state = 16},
  [135] = {.lex_state = 16},
  [136] = {.lex_state = 16},
  [137] = {.lex_state = 16},
  [138] = {.lex_state = 16},
  [139] = {.lex_state = 16},
  [140] = {.lex_state = 16},
  [141] = {.lex_state = 16},
  [142] = {.lex_state = 16},
  [143] = {.lex_state = 16},
  [144] = {.lex_state = 16},
  [145] = {.lex_state = 16},
  [146] = {.lex_state = 16},
  [147] = {.lex_state = 16},
  [148] = {.lex_state = 16},
  [149] = {.lex_state = 16},
  [150] = {.lex_state = 16},
  [151] = {.lex_state = 16},
  [152] = {.lex_state = 16},
  [153] = {.lex_state = 16},
  [154] = {.lex_state = 16},
  [155] = {.lex_state = 16},
  [156] = {.lex_state = 16},
  [157] = {.lex_state = 16},
  [158] = {.lex_state = 16},
  [159] = {.lex_state = 16},
  [160] = {.lex_state = 16},
  [161] = {.lex_state = 16},
  [162] = {.lex_state = 16},
  [163] = {.lex_state = 16},
  [164] = {.lex_state = 16},
  [165] = {.lex_state = 16},
  [166] = {.lex_state = 16},
  [167] = {.lex_state = 16},
  [168] = {.lex_state = 16},
  [169] = {.lex_state = 16},
  [170] = {.lex_state = 16},
  [171] = {.lex_state = 16},
  [172] = {.lex_state = 16},
  [173] = {.lex_state = 16},
  [174] = {.lex_state = 16},
  [175] = {.lex_state = 16},
  [176] = {.lex_state = 16},
  [177] = {.lex_state = 16},
  [178] = {.lex_state = 16},
  [179] = {.lex_state = 16},
  [180] = {.lex_state = 16},
  [181] = {.lex_state = 16},
  [182] = {.lex_state = 16},
  [183] = {.lex_state = 16},
  [184] = {.lex_state = 16},
  [185] = {.lex_state = 16},
  [186] = {.lex_state = 16},
  [187] = {.lex_state = 16},
  [188] = {.lex_state = 16},
  [189] = {.lex_state = 16},
  [190] = {.lex_state = 16},
  [191] = {.lex_state = 16},
  [192] = {.lex_state = 16},
  [193] = {.lex_state = 16},
  [194] = {.lex_state = 16},
  [195] = {.lex_state = 16},
  [196] = {.lex_state = 16},
  [197] = {.lex_state = 16},
  [198] = {.lex_state = 16},
  [199] = {.lex_state = 16},
  [200] = {.lex_state = 16},
  [201] = {.lex_state = 16},
  [202] = {.lex_state = 16},
  [203] = {.lex_state = 16},
  [204] = {.lex_state = 16},
  [205] = {.lex_state = 16},
  [206] = {.lex_state = 16},
  [207] = {.lex_state = 16},
  [208] = {.lex_state = 16},
  [209] = {.lex_state = 16},
  [210] = {.lex_state = 16},
  [211] = {.lex_state = 16},
  [212] = {.lex_state = 16},
  [213] = {.lex_state = 16},
  [214] = {.lex_state = 16},
  [215] = {.lex_state = 16},
  [216] = {.lex_state = 16},
  [217] = {.lex_state = 16},
  [218] = {.lex_state = 16},
  [219] = {.lex_state = 16},
  [220] = {.lex_state = 16},
  [221] = {.lex_state = 16},
  [222] = {.lex_state = 16},
  [223] = {.lex_state = 16},
  [224] = {.lex_state = 16},
  [225] = {.lex_state = 16},
  [226] = {.lex_state = 16},
  [227] = {.lex_state = 16},
  [228] = {.lex_state = 16},
  [229] = {.lex_state = 16},
  [230] = {.lex_state = 16},
  [231] = {.lex_state = 16},
  [232] = {.lex_state = 16},
  [233] = {.lex_state = 16},
  [234] = {.lex_state = 16},
  [235] = {.lex_state = 16},
  [236] = {.lex_state = 16},
  [237] = {.lex_state = 16},
  [238] = {.lex_state = 16},
  [239] = {.lex_state = 16},
  [240] = {.lex_state = 16},
  [241] = {.lex_state = 16},
  [242] = {.lex_state = 16},
  [243] = {.lex_state = 16},
  [244] = {.lex_state = 16},
  [245] = {.lex_state = 16},
  [246] = {.lex_state = 16},
  [247] = {.lex_state = 16},
  [248] = {.lex_state = 16},
  [249] = {.lex_state = 16},
  [250] = {.lex_state = 16},
  [251] = {.lex_state = 16},
  [252] = {.lex_state = 16},
  [253] = {.lex_state = 16},
  [254] = {.lex_state = 16},
  [255] = {.lex_state = 16},
  [256] = {.lex_state = 16},
  [257] = {.lex_state = 16},
  [258] = {.lex_state = 16},
  [259] = {.lex_state = 16},
  [260] = {.lex_state = 16},
  [261] = {.lex_state = 16},
  [262] = {.lex_state = 16},
  [263] = {.lex_state = 16},
  [264] = {.lex_state = 16},
  [265] = {.lex_state = 16},
  [266] = {.lex_state = 16},
  [267] = {.lex_state = 16},
  [268] = {.lex_state = 16},
  [269] = {.lex_state = 16},
  [270] = {.lex_state = 16},
  [271] = {.lex_state = 16},
  [272] = {.lex_state = 16},
  [273] = {.lex_state = 16},
  [274] = {.lex_state = 16},
  [275] = {.lex_state = 16},
  [276] = {.lex_state = 16},
  [277] = {.lex_state = 16},
  [278] = {.lex_state = 16},
  [279] = {.lex_state = 16},
  [280] = {.lex_state = 16},
  [281] = {.lex_state = 16},
  [282] = {.lex_state = 16},
  [283] = {.lex_state = 16},
  [284] = {.lex_state = 16},
  [285] = {.lex_state = 16},
  [286] = {.lex_state = 16},
  [287] = {.lex_state = 16},
  [288] = {.lex_state = 16},
  [289] = {.lex_state = 16},
  [290] = {.lex_state = 16},
  [291] = {.lex_state = 16},
  [292] = {.lex_state = 16},
  [293] = {.lex_state = 16},
  [294] = {.lex_state = 16},
  [295] = {.lex_state = 16},
  [296] = {.lex_state = 16},
  [297] = {.lex_state = 16},
  [298] = {.lex_state = 16},
  [299] = {.lex_state = 16},
  [300] = {.lex_state = 16},
  [301] = {.lex_state = 16},
  [302] = {.lex_state = 16},
  [303] = {.lex_state = 16},
  [304] = {.lex_state = 16},
  [305] = {.lex_state = 16},
  [306] = {.lex_state = 16},
  [307] = {.lex_state = 16},
  [308] = {.lex_state = 16},
  [309] = {.lex_state = 16},
  [310] = {.lex_state = 16},
  [311] = {.lex_state = 16},
  [312] = {.lex_state = 16},
  [313] = {.lex_state = 16},
  [314] = {.lex_state = 16},
  [315] = {.lex_state = 16},
  [316] = {.lex_state = 16},
  [317] = {.lex_state = 16},
  [318] = {.lex_state = 16},
  [319] = {.lex_state = 16},
  [320] = {.lex_state = 16},
  [321] = {.lex_state = 16},
  [322] = {.lex_state = 16},
  [323] = {.lex_state = 16},
  [324] = {.lex_state = 16},
  [325] = {.lex_state = 16},
  [326] = {.lex_state = 16},
  [327] = {.lex_state = 16},
  [328] = {.lex_state = 16},
  [329] = {.lex_state = 16},
  [330] = {.lex_state = 16},
  [331] = {.lex_state = 16},
  [332] = {.lex_state = 16},
  [333] = {.lex_state = 16},
  [334] = {.lex_state = 16},
  [335] = {.lex_state = 16},
  [336] = {.lex_state = 16},
  [337] = {.lex_state = 16},
  [338] = {.lex_state = 16},
  [339] = {.lex_state = 16},
  [340] = {.lex_state = 16},
  [341] = {.lex_state = 16},
  [342] = {.lex_state = 16},
  [343] = {.lex_state = 16},
  [344] = {.lex_state = 16},
  [345] = {.lex_state = 16},
  [346] = {.lex_state = 16},
  [347] = {.lex_state = 16},
  [348] = {.lex_state = 16},
  [349] = {.lex_state = 16},
  [350] = {.lex_state = 16},
  [351] = {.lex_state = 16},
  [352] = {.lex_state = 16},
  [353] = {.lex_state = 16},
  [354] = {.lex_state = 16},
  [355] = {.lex_state = 16},
  [356] = {.lex_state = 16},
  [357] = {.lex_state = 16},
  [358] = {.lex_state = 16},
  [359] = {.lex_state = 16},
  [360] = {.lex_state = 16},
  [361] = {.lex_state = 16},
  [362] = {.lex_state = 16},
  [363] = {.lex_state = 16},
  [364] = {.lex_state = 16},
  [365] = {.lex_state = 16},
  [366] = {.lex_state = 16},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 0},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 0},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 0},
  [402] = {.lex_state = 0},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 0},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 0},
  [410] = {.lex_state = 0},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 0},
  [413] = {.lex_state = 0},
  [414] = {.lex_state = 0},
  [415] = {.lex_state = 0},
  [416] = {.lex_state = 0},
  [417] = {.lex_state = 0},
  [418] = {.lex_state = 0},
  [419] = {.lex_state = 0},
  [420] = {.lex_state = 0},
  [421] = {.lex_state = 0},
  [422] = {.lex_state = 0},
  [423] = {.lex_state = 0},
  [424] = {.lex_state = 0},
  [425] = {.lex_state = 0},
  [426] = {.lex_state = 0},
  [427] = {.lex_state = 0},
  [428] = {.lex_state = 0},
  [429] = {.lex_state = 0},
  [430] = {.lex_state = 0},
  [431] = {.lex_state = 0},
  [432] = {.lex_state = 0},
  [433] = {.lex_state = 0},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 0},
  [436] = {.lex_state = 0},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 0},
  [441] = {.lex_state = 0},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 0},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 0},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 0},
  [454] = {.lex_state = 0},
  [455] = {.lex_state = 0},
  [456] = {.lex_state = 0},
  [457] = {.lex_state = 0},
  [458] = {.lex_state = 0},
  [459] = {.lex_state = 0},
  [460] = {.lex_state = 0},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 0},
  [464] = {.lex_state = 0},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 0},
  [467] = {.lex_state = 16},
  [468] = {.lex_state = 16},
  [469] = {.lex_state = 16},
  [470] = {.lex_state = 0},
  [471] = {.lex_state = 0},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 0},
  [474] = {.lex_state = 0},
  [475] = {.lex_state = 0},
  [476] = {.lex_state = 0},
  [477] = {.lex_state = 0},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 0},
  [480] = {.lex_state = 0},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 0},
  [484] = {.lex_state = 0},
  [485] = {.lex_state = 0},
  [486] = {.lex_state = 0},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 0},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 0},
  [492] = {.lex_state = 0},
  [493] = {.lex_state = 0},
  [494] = {.lex_state = 0},
  [495] = {.lex_state = 0},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 0},
  [498] = {.lex_state = 0},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 0},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 0},
  [503] = {.lex_state = 0},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 0},
  [509] = {.lex_state = 0},
  [510] = {.lex_state = 0},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 0},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 16},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 0},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 0},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 0},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 0},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 0},
  [548] = {.lex_state = 0},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 0},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 0},
  [617] = {.lex_state = 0},
  [618] = {.lex_state = 0},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 0},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 0},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 16},
  [703] = {.lex_state = 16},
  [704] = {.lex_state = 16},
  [705] = {.lex_state = 16},
  [706] = {.lex_state = 16},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 16},
  [712] = {.lex_state = 16},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 16},
  [715] = {.lex_state = 16},
  [716] = {.lex_state = 16},
  [717] = {.lex_state = 16},
  [718] = {.lex_state = 16},
  [719] = {.lex_state = 16},
  [720] = {.lex_state = 16},
  [721] = {.lex_state = 16},
  [722] = {.lex_state = 16},
  [723] = {.lex_state = 16},
  [724] = {.lex_state = 16},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 16},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 16},
  [731] = {.lex_state = 16},
  [732] = {.lex_state = 16},
  [733] = {.lex_state = 16},
  [734] = {.lex_state = 16},
  [735] = {.lex_state = 16},
  [736] = {.lex_state = 16},
  [737] = {.lex_state = 16},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 16},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 16},
  [751] = {.lex_state = 16},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 16},
  [761] = {.lex_state = 16},
  [762] = {.lex_state = 16},
  [763] = {.lex_state = 16},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 16},
  [766] = {.lex_state = 16},
  [767] = {.lex_state = 16},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 16},
  [772] = {.lex_state = 16},
  [773] = {.lex_state = 16},
  [774] = {.lex_state = 16},
  [775] = {.lex_state = 16},
  [776] = {.lex_state = 16},
  [777] = {.lex_state = 16},
  [778] = {.lex_state = 16},
  [779] = {.lex_state = 16},
  [780] = {.lex_state = 16},
  [781] = {.lex_state = 16},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 16},
  [788] = {.lex_state = 16},
  [789] = {.lex_state = 16},
  [790] = {.lex_state = 16},
  [791] = {.lex_state = 16},
  [792] = {.lex_state = 16},
  [793] = {.lex_state = 16},
  [794] = {.lex_state = 16},
  [795] = {.lex_state = 16},
  [796] = {.lex_state = 16},
  [797] = {.lex_state = 16},
  [798] = {.lex_state = 16},
  [799] = {.lex_state = 16},
  [800] = {.lex_state = 16},
  [801] = {.lex_state = 16},
  [802] = {.lex_state = 16},
  [803] = {.lex_state = 16},
  [804] = {.lex_state = 16},
  [805] = {.lex_state = 16},
  [806] = {.lex_state = 16},
  [807] = {.lex_state = 16},
  [808] = {.lex_state = 16},
  [809] = {.lex_state = 16},
  [810] = {.lex_state = 16},
  [811] = {.lex_state = 16},
  [812] = {.lex_state = 16},
  [813] = {.lex_state = 16},
  [814] = {.lex_state = 16},
  [815] = {.lex_state = 16},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 16},
  [819] = {.lex_state = 16},
  [820] = {.lex_state = 16},
  [821] = {.lex_state = 16},
  [822] = {.lex_state = 16},
  [823] = {.lex_state = 16},
  [824] = {.lex_state = 16},
  [825] = {.lex_state = 16},
  [826] = {.lex_state = 16},
  [827] = {.lex_state = 16},
  [828] = {.lex_state = 16},
  [829] = {.lex_state = 16},
  [830] = {.lex_state = 16},
  [831] = {.lex_state = 16},
  [832] = {.lex_state = 16},
  [833] = {.lex_state = 16},
  [834] = {.lex_state = 16},
  [835] = {.lex_state = 16},
  [836] = {.lex_state = 16},
  [837] = {.lex_state = 16},
  [838] = {.lex_state = 16},
  [839] = {.lex_state = 16},
  [840] = {.lex_state = 16},
  [841] = {.lex_state = 16},
  [842] = {.lex_state = 16},
  [843] = {.lex_state = 16},
  [844] = {.lex_state = 16},
  [845] = {.lex_state = 16},
  [846] = {.lex_state = 16},
  [847] = {.lex_state = 16},
  [848] = {.lex_state = 16},
  [849] = {.lex_state = 16},
  [850] = {.lex_state = 16},
  [851] = {.lex_state = 16},
  [852] = {.lex_state = 16},
  [853] = {.lex_state = 16},
  [854] = {.lex_state = 16},
  [855] = {.lex_state = 16},
  [856] = {.lex_state = 16},
  [857] = {.lex_state = 16},
  [858] = {.lex_state = 16},
  [859] = {.lex_state = 16},
  [860] = {.lex_state = 16},
  [861] = {.lex_state = 16},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 16},
  [865] = {.lex_state = 16},
  [866] = {.lex_state = 16},
  [867] = {.lex_state = 16},
  [868] = {.lex_state = 16},
  [869] = {.lex_state = 16},
  [870] = {.lex_state = 16},
  [871] = {.lex_state = 16},
  [872] = {.lex_state = 16},
  [873] = {.lex_state = 16},
  [874] = {.lex_state = 16},
  [875] = {.lex_state = 16},
  [876] = {.lex_state = 16},
  [877] = {.lex_state = 16},
  [878] = {.lex_state = 16},
  [879] = {.lex_state = 16},
  [880] = {.lex_state = 16},
  [881] = {.lex_state = 16},
  [882] = {.lex_state = 16},
  [883] = {.lex_state = 16},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 16},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 16},
  [888] = {.lex_state = 16},
  [889] = {.lex_state = 16},
  [890] = {.lex_state = 16},
  [891] = {.lex_state = 16},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 16},
  [894] = {.lex_state = 16},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 16},
  [897] = {.lex_state = 16},
  [898] = {.lex_state = 16},
  [899] = {.lex_state = 16},
  [900] = {.lex_state = 16},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 16},
  [903] = {.lex_state = 16},
  [904] = {.lex_state = 16},
  [905] = {.lex_state = 16},
  [906] = {.lex_state = 16},
  [907] = {.lex_state = 16},
  [908] = {.lex_state = 16},
  [909] = {.lex_state = 16},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 16},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 16},
  [914] = {.lex_state = 16},
  [915] = {.lex_state = 16},
  [916] = {.lex_state = 16},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 16},
  [919] = {.lex_state = 16},
  [920] = {.lex_state = 16},
  [921] = {.lex_state = 16},
  [922] = {.lex_state = 16},
  [923] = {.lex_state = 16},
  [924] = {.lex_state = 16},
  [925] = {.lex_state = 16},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 16},
  [928] = {.lex_state = 16},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 16},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 16},
  [936] = {.lex_state = 16},
  [937] = {.lex_state = 16},
  [938] = {.lex_state = 16},
  [939] = {.lex_state = 16},
  [940] = {.lex_state = 16},
  [941] = {.lex_state = 16},
  [942] = {.lex_state = 16},
  [943] = {.lex_state = 16},
  [944] = {.lex_state = 16},
  [945] = {.lex_state = 16},
  [946] = {.lex_state = 16},
  [947] = {.lex_state = 16},
  [948] = {.lex_state = 16},
  [949] = {.lex_state = 16},
  [950] = {.lex_state = 16},
  [951] = {.lex_state = 16},
  [952] = {.lex_state = 16},
  [953] = {.lex_state = 16},
  [954] = {.lex_state = 16},
  [955] = {.lex_state = 16},
  [956] = {.lex_state = 16},
  [957] = {.lex_state = 16},
  [958] = {.lex_state = 16},
  [959] = {.lex_state = 16},
  [960] = {.lex_state = 16},
  [961] = {.lex_state = 16},
  [962] = {.lex_state = 16},
  [963] = {.lex_state = 16},
  [964] = {.lex_state = 16},
  [965] = {.lex_state = 16},
  [966] = {.lex_state = 16},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 16},
  [969] = {.lex_state = 16},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 16},
  [973] = {.lex_state = 16},
  [974] = {.lex_state = 16},
  [975] = {.lex_state = 16},
  [976] = {.lex_state = 16},
  [977] = {.lex_state = 16},
  [978] = {.lex_state = 16},
  [979] = {.lex_state = 16},
  [980] = {.lex_state = 16},
  [981] = {.lex_state = 16},
  [982] = {.lex_state = 16},
  [983] = {.lex_state = 16},
  [984] = {.lex_state = 16},
  [985] = {.lex_state = 16},
  [986] = {.lex_state = 16},
  [987] = {.lex_state = 16},
  [988] = {.lex_state = 16},
  [989] = {.lex_state = 16},
  [990] = {.lex_state = 16},
  [991] = {.lex_state = 16},
  [992] = {.lex_state = 16},
  [993] = {.lex_state = 16},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 16},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 16},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 16},
  [1000] = {.lex_state = 16},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 16},
  [1003] = {.lex_state = 16},
  [1004] = {.lex_state = 16},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 16},
  [1007] = {.lex_state = 16},
  [1008] = {.lex_state = 16},
  [1009] = {.lex_state = 16},
  [1010] = {.lex_state = 16},
  [1011] = {.lex_state = 16},
  [1012] = {.lex_state = 16},
  [1013] = {.lex_state = 16},
  [1014] = {.lex_state = 16},
  [1015] = {.lex_state = 16},
  [1016] = {.lex_state = 16},
  [1017] = {.lex_state = 16},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 16},
  [1021] = {.lex_state = 16},
  [1022] = {.lex_state = 16},
  [1023] = {.lex_state = 16},
  [1024] = {.lex_state = 16},
  [1025] = {.lex_state = 16},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 16},
  [1029] = {.lex_state = 16},
  [1030] = {.lex_state = 16},
  [1031] = {.lex_state = 16},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 16},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 16},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 16},
  [1041] = {.lex_state = 16},
  [1042] = {.lex_state = 16},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 16},
  [1045] = {.lex_state = 16},
  [1046] = {.lex_state = 16},
  [1047] = {.lex_state = 16},
  [1048] = {.lex_state = 16},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 16},
  [1051] = {.lex_state = 16},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 16},
  [1054] = {.lex_state = 16},
  [1055] = {.lex_state = 16},
  [1056] = {.lex_state = 16},
  [1057] = {.lex_state = 16},
  [1058] = {.lex_state = 16},
  [1059] = {.lex_state = 16},
  [1060] = {.lex_state = 16},
  [1061] = {.lex_state = 16},
  [1062] = {.lex_state = 16},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 16},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 16},
  [1067] = {.lex_state = 16},
  [1068] = {.lex_state = 16},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 16},
  [1071] = {.lex_state = 16},
  [1072] = {.lex_state = 16},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 16},
  [1076] = {.lex_state = 16},
  [1077] = {.lex_state = 16},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 16},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 16},
  [1084] = {.lex_state = 16},
  [1085] = {.lex_state = 16},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 16},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 16},
  [1091] = {.lex_state = 16},
  [1092] = {.lex_state = 16},
  [1093] = {.lex_state = 16},
  [1094] = {.lex_state = 16},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 16},
  [1097] = {.lex_state = 16},
  [1098] = {.lex_state = 16},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 16},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 16},
  [1105] = {.lex_state = 16},
  [1106] = {.lex_state = 16},
  [1107] = {.lex_state = 16},
  [1108] = {.lex_state = 16},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 16},
  [1111] = {.lex_state = 16},
  [1112] = {.lex_state = 16},
  [1113] = {.lex_state = 16},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 16},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 16},
  [1118] = {.lex_state = 16},
  [1119] = {.lex_state = 16},
  [1120] = {.lex_state = 16},
  [1121] = {.lex_state = 16},
  [1122] = {.lex_state = 16},
  [1123] = {.lex_state = 16},
  [1124] = {.lex_state = 16},
  [1125] = {.lex_state = 16},
  [1126] = {.lex_state = 16},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 16},
  [1129] = {.lex_state = 16},
  [1130] = {.lex_state = 16},
  [1131] = {.lex_state = 16},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 16},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 16},
  [1136] = {.lex_state = 16},
  [1137] = {.lex_state = 16},
  [1138] = {.lex_state = 16},
  [1139] = {.lex_state = 16},
  [1140] = {.lex_state = 16},
  [1141] = {.lex_state = 16},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 16},
  [1144] = {.lex_state = 16},
  [1145] = {.lex_state = 16},
  [1146] = {.lex_state = 16},
  [1147] = {.lex_state = 16},
  [1148] = {.lex_state = 16},
  [1149] = {.lex_state = 16},
  [1150] = {.lex_state = 16},
  [1151] = {.lex_state = 16},
  [1152] = {.lex_state = 16},
  [1153] = {.lex_state = 16},
  [1154] = {.lex_state = 16},
  [1155] = {.lex_state = 16},
  [1156] = {.lex_state = 16},
  [1157] = {.lex_state = 16},
  [1158] = {.lex_state = 16},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 16},
  [1161] = {.lex_state = 16},
  [1162] = {.lex_state = 16},
  [1163] = {.lex_state = 16},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 0},
  [1168] = {.lex_state = 16},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 16},
  [1172] = {.lex_state = 16},
  [1173] = {.lex_state = 16},
  [1174] = {.lex_state = 16},
  [1175] = {.lex_state = 16},
  [1176] = {.lex_state = 16},
  [1177] = {.lex_state = 16},
  [1178] = {.lex_state = 16},
  [1179] = {.lex_state = 0},
  [1180] = {.lex_state = 16},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 16},
  [1183] = {.lex_state = 16},
  [1184] = {.lex_state = 0},
  [1185] = {.lex_state = 16},
  [1186] = {.lex_state = 16},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 0},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 0},
  [1191] = {.lex_state = 0},
  [1192] = {.lex_state = 0},
  [1193] = {.lex_state = 16},
  [1194] = {.lex_state = 16},
  [1195] = {.lex_state = 0},
  [1196] = {.lex_state = 0},
  [1197] = {.lex_state = 0},
  [1198] = {.lex_state = 16},
  [1199] = {.lex_state = 16},
  [1200] = {.lex_state = 16},
  [1201] = {.lex_state = 16},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 0},
  [1204] = {.lex_state = 0},
  [1205] = {.lex_state = 0},
  [1206] = {.lex_state = 0},
  [1207] = {.lex_state = 0},
  [1208] = {.lex_state = 0},
  [1209] = {.lex_state = 0},
  [1210] = {.lex_state = 16},
  [1211] = {.lex_state = 16},
  [1212] = {.lex_state = 16},
  [1213] = {.lex_state = 0},
  [1214] = {.lex_state = 0},
  [1215] = {.lex_state = 0},
  [1216] = {.lex_state = 0},
  [1217] = {.lex_state = 0},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 0},
  [1220] = {.lex_state = 0},
  [1221] = {.lex_state = 0},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 0},
  [1224] = {.lex_state = 0},
  [1225] = {.lex_state = 16},
  [1226] = {.lex_state = 16},
  [1227] = {.lex_state = 0},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 0},
  [1230] = {.lex_state = 0},
  [1231] = {.lex_state = 0},
  [1232] = {.lex_state = 0},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 0},
  [1235] = {.lex_state = 0},
  [1236] = {.lex_state = 0},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 0},
  [1240] = {.lex_state = 0},
  [1241] = {.lex_state = 0},
  [1242] = {.lex_state = 0},
  [1243] = {.lex_state = 0},
  [1244] = {.lex_state = 0},
  [1245] = {.lex_state = 0},
  [1246] = {.lex_state = 0},
  [1247] = {.lex_state = 0},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 0},
  [1250] = {.lex_state = 0},
  [1251] = {.lex_state = 0},
  [1252] = {.lex_state = 0},
  [1253] = {.lex_state = 0},
  [1254] = {.lex_state = 0},
  [1255] = {.lex_state = 0},
  [1256] = {.lex_state = 0},
  [1257] = {.lex_state = 0},
  [1258] = {.lex_state = 0},
  [1259] = {.lex_state = 0},
  [1260] = {.lex_state = 0},
  [1261] = {.lex_state = 0},
  [1262] = {.lex_state = 0},
  [1263] = {.lex_state = 0},
  [1264] = {.lex_state = 0},
  [1265] = {.lex_state = 0},
  [1266] = {.lex_state = 0},
  [1267] = {.lex_state = 0},
  [1268] = {.lex_state = 0},
  [1269] = {.lex_state = 0},
  [1270] = {.lex_state = 0},
  [1271] = {.lex_state = 0},
  [1272] = {.lex_state = 0},
  [1273] = {.lex_state = 0},
  [1274] = {.lex_state = 0},
  [1275] = {.lex_state = 0},
  [1276] = {.lex_state = 0},
  [1277] = {.lex_state = 0},
  [1278] = {.lex_state = 0},
  [1279] = {.lex_state = 0},
  [1280] = {.lex_state = 0},
  [1281] = {.lex_state = 0},
  [1282] = {.lex_state = 0},
  [1283] = {.lex_state = 0},
  [1284] = {.lex_state = 0},
  [1285] = {.lex_state = 0},
  [1286] = {.lex_state = 0},
  [1287] = {.lex_state = 0},
  [1288] = {.lex_state = 0},
  [1289] = {.lex_state = 0},
  [1290] = {.lex_state = 0},
  [1291] = {.lex_state = 0},
  [1292] = {.lex_state = 0},
  [1293] = {.lex_state = 0},
  [1294] = {.lex_state = 0},
  [1295] = {.lex_state = 0},
  [1296] = {.lex_state = 0},
  [1297] = {.lex_state = 0},
  [1298] = {.lex_state = 0},
  [1299] = {.lex_state = 0},
  [1300] = {.lex_state = 0},
  [1301] = {.lex_state = 0},
  [1302] = {.lex_state = 0},
  [1303] = {.lex_state = 0},
  [1304] = {.lex_state = 0},
  [1305] = {.lex_state = 0},
  [1306] = {.lex_state = 0},
  [1307] = {.lex_state = 0},
  [1308] = {.lex_state = 0},
  [1309] = {.lex_state = 0},
  [1310] = {.lex_state = 0},
  [1311] = {.lex_state = 0},
  [1312] = {.lex_state = 0},
  [1313] = {.lex_state = 0},
  [1314] = {.lex_state = 0},
  [1315] = {.lex_state = 0},
  [1316] = {.lex_state = 0},
  [1317] = {.lex_state = 0},
  [1318] = {.lex_state = 0},
  [1319] = {.lex_state = 0},
  [1320] = {.lex_state = 0},
  [1321] = {.lex_state = 0},
  [1322] = {.lex_state = 0},
  [1323] = {.lex_state = 0},
  [1324] = {.lex_state = 0},
  [1325] = {.lex_state = 0},
  [1326] = {.lex_state = 0},
  [1327] = {.lex_state = 0},
  [1328] = {.lex_state = 0},
  [1329] = {.lex_state = 16},
  [1330] = {.lex_state = 0},
  [1331] = {.lex_state = 0},
  [1332] = {.lex_state = 0},
  [1333] = {.lex_state = 0},
  [1334] = {.lex_state = 0},
  [1335] = {.lex_state = 0},
  [1336] = {.lex_state = 0},
  [1337] = {.lex_state = 0},
  [1338] = {.lex_state = 0},
  [1339] = {.lex_state = 0},
  [1340] = {.lex_state = 0},
  [1341] = {.lex_state = 0},
  [1342] = {.lex_state = 0},
  [1343] = {.lex_state = 16},
  [1344] = {.lex_state = 0},
  [1345] = {.lex_state = 0},
  [1346] = {.lex_state = 0},
  [1347] = {.lex_state = 0},
  [1348] = {.lex_state = 0},
  [1349] = {.lex_state = 0},
  [1350] = {.lex_state = 0},
  [1351] = {.lex_state = 0},
  [1352] = {.lex_state = 0},
  [1353] = {.lex_state = 0},
  [1354] = {.lex_state = 0},
  [1355] = {.lex_state = 0},
  [1356] = {.lex_state = 0},
  [1357] = {.lex_state = 0},
  [1358] = {.lex_state = 0},
  [1359] = {.lex_state = 0},
  [1360] = {.lex_state = 0},
  [1361] = {.lex_state = 0},
  [1362] = {.lex_state = 0},
  [1363] = {.lex_state = 0},
  [1364] = {.lex_state = 0},
  [1365] = {.lex_state = 0},
  [1366] = {.lex_state = 0},
  [1367] = {.lex_state = 0},
  [1368] = {.lex_state = 0},
  [1369] = {.lex_state = 0},
  [1370] = {.lex_state = 0},
  [1371] = {.lex_state = 0},
  [1372] = {.lex_state = 0},
  [1373] = {.lex_state = 0},
  [1374] = {.lex_state = 0},
  [1375] = {.lex_state = 0},
  [1376] = {.lex_state = 0},
  [1377] = {.lex_state = 0},
  [1378] = {.lex_state = 0},
  [1379] = {.lex_state = 0},
  [1380] = {.lex_state = 0},
  [1381] = {.lex_state = 0},
  [1382] = {.lex_state = 0},
  [1383] = {.lex_state = 0},
  [1384] = {.lex_state = 0},
  [1385] = {.lex_state = 0},
  [1386] = {.lex_state = 16},
  [1387] = {.lex_state = 0},
  [1388] = {.lex_state = 0},
  [1389] = {.lex_state = 0},
  [1390] = {.lex_state = 0},
  [1391] = {.lex_state = 0},
  [1392] = {.lex_state = 16},
  [1393] = {.lex_state = 16},
  [1394] = {.lex_state = 16},
  [1395] = {.lex_state = 16},
  [1396] = {.lex_state = 16},
  [1397] = {.lex_state = 16},
  [1398] = {.lex_state = 16},
  [1399] = {.lex_state = 16},
  [1400] = {.lex_state = 16},
  [1401] = {.lex_state = 16},
  [1402] = {.lex_state = 16},
  [1403] = {.lex_state = 16},
  [1404] = {.lex_state = 16},
  [1405] = {.lex_state = 16},
  [1406] = {.lex_state = 16},
  [1407] = {.lex_state = 16},
  [1408] = {.lex_state = 16},
  [1409] = {.lex_state = 16},
  [1410] = {.lex_state = 16},
  [1411] = {.lex_state = 16},
  [1412] = {.lex_state = 16},
  [1413] = {.lex_state = 16},
  [1414] = {.lex_state = 16},
  [1415] = {.lex_state = 16},
  [1416] = {.lex_state = 16},
  [1417] = {.lex_state = 16},
  [1418] = {.lex_state = 16},
  [1419] = {.lex_state = 16},
  [1420] = {.lex_state = 16},
  [1421] = {.lex_state = 16},
  [1422] = {.lex_state = 16},
  [1423] = {.lex_state = 16},
  [1424] = {.lex_state = 16},
  [1425] = {.lex_state = 16},
  [1426] = {.lex_state = 16},
  [1427] = {.lex_state = 16},
  [1428] = {.lex_state = 16},
  [1429] = {.lex_state = 16},
  [1430] = {.lex_state = 16},
  [1431] = {.lex_state = 16},
  [1432] = {.lex_state = 16},
  [1433] = {.lex_state = 2},
  [1434] = {.lex_state = 2},
  [1435] = {.lex_state = 2},
  [1436] = {.lex_state = 0},
  [1437] = {.lex_state = 2},
  [1438] = {.lex_state = 0},
  [1439] = {.lex_state = 16},
  [1440] = {.lex_state = 0},
  [1441] = {.lex_state = 2},
  [1442] = {.lex_state = 2},
  [1443] = {.lex_state = 2},
  [1444] = {.lex_state = 0},
  [1445] = {.lex_state = 0},
  [1446] = {.lex_state = 0},
  [1447] = {.lex_state = 0},
  [1448] = {.lex_state = 16},
  [1449] = {.lex_state = 16},
  [1450] = {.lex_state = 16},
  [1451] = {.lex_state = 2},
  [1452] = {.lex_state = 16},
  [1453] = {.lex_state = 16},
  [1454] = {.lex_state = 2},
  [1455] = {.lex_state = 16},
  [1456] = {.lex_state = 2},
  [1457] = {.lex_state = 2},
  [1458] = {.lex_state = 2},
  [1459] = {.lex_state = 0},
  [1460] = {.lex_state = 0},
  [1461] = {.lex_state = 2},
  [1462] = {.lex_state = 16},
  [1463] = {.lex_state = 16},
  [1464] = {.lex_state = 2},
  [1465] = {.lex_state = 16},
  [1466] = {.lex_state = 2},
  [1467] = {.lex_state = 16},
  [1468] = {.lex_state = 16},
  [1469] = {.lex_state = 16},
  [1470] = {.lex_state = 16},
  [1471] = {.lex_state = 16},
  [1472] = {.lex_state = 16},
  [1473] = {.lex_state = 16},
  [1474] = {.lex_state = 16},
  [1475] = {.lex_state = 16},
  [1476] = {.lex_state = 16},
  [1477] = {.lex_state = 16},
  [1478] = {.lex_state = 16},
  [1479] = {.lex_state = 16},
  [1480] = {.lex_state = 16},
  [1481] = {.lex_state = 16},
  [1482] = {.lex_state = 16},
  [1483] = {.lex_state = 16},
  [1484] = {.lex_state = 16},
  [1485] = {.lex_state = 16},
  [1486] = {.lex_state = 16},
  [1487] = {.lex_state = 0},
  [1488] = {.lex_state = 0},
  [1489] = {.lex_state = 16},
  [1490] = {.lex_state = 16},
  [1491] = {.lex_state = 16},
  [1492] = {.lex_state = 16},
  [1493] = {.lex_state = 16},
  [1494] = {.lex_state = 16},
  [1495] = {.lex_state = 2},
  [1496] = {.lex_state = 16},
  [1497] = {.lex_state = 16},
  [1498] = {.lex_state = 16},
  [1499] = {.lex_state = 16},
  [1500] = {.lex_state = 16},
  [1501] = {.lex_state = 16},
  [1502] = {.lex_state = 16},
  [1503] = {.lex_state = 16},
  [1504] = {.lex_state = 16},
  [1505] = {.lex_state = 16},
  [1506] = {.lex_state = 2},
  [1507] = {.lex_state = 16},
  [1508] = {.lex_state = 16},
  [1509] = {.lex_state = 16},
  [1510] = {.lex_state = 16},
  [1511] = {.lex_state = 16},
  [1512] = {.lex_state = 16},
  [1513] = {.lex_state = 16},
  [1514] = {.lex_state = 16},
  [1515] = {.lex_state = 16},
  [1516] = {.lex_state = 16},
  [1517] = {.lex_state = 16},
  [1518] = {.lex_state = 16},
  [1519] = {.lex_state = 16},
  [1520] = {.lex_state = 16},
  [1521] = {.lex_state = 16},
  [1522] = {.lex_state = 16},
  [1523] = {.lex_state = 16},
  [1524] = {.lex_state = 16},
  [1525] = {.lex_state = 16},
  [1526] = {.lex_state = 16},
  [1527] = {.lex_state = 16},
  [1528] = {.lex_state = 16},
  [1529] = {.lex_state = 16},
  [1530] = {.lex_state = 16},
  [1531] = {.lex_state = 16},
  [1532] = {.lex_state = 16},
  [1533] = {.lex_state = 16},
  [1534] = {.lex_state = 16},
  [1535] = {.lex_state = 16},
  [1536] = {.lex_state = 16},
  [1537] = {.lex_state = 16},
  [1538] = {.lex_state = 16},
  [1539] = {.lex_state = 16},
  [1540] = {.lex_state = 16},
  [1541] = {.lex_state = 16},
  [1542] = {.lex_state = 16},
  [1543] = {.lex_state = 16},
  [1544] = {.lex_state = 16},
  [1545] = {.lex_state = 16},
  [1546] = {.lex_state = 16},
  [1547] = {.lex_state = 16},
  [1548] = {.lex_state = 16},
  [1549] = {.lex_state = 16},
  [1550] = {.lex_state = 16},
  [1551] = {.lex_state = 16},
  [1552] = {.lex_state = 16},
  [1553] = {.lex_state = 16},
  [1554] = {.lex_state = 16},
  [1555] = {.lex_state = 16},
  [1556] = {.lex_state = 16},
  [1557] = {.lex_state = 16},
  [1558] = {.lex_state = 16},
  [1559] = {.lex_state = 16},
  [1560] = {.lex_state = 16},
  [1561] = {.lex_state = 16},
  [1562] = {.lex_state = 16},
  [1563] = {.lex_state = 16},
  [1564] = {.lex_state = 16},
  [1565] = {.lex_state = 16},
  [1566] = {.lex_state = 16},
  [1567] = {.lex_state = 16},
  [1568] = {.lex_state = 16},
  [1569] = {.lex_state = 16},
  [1570] = {.lex_state = 16},
  [1571] = {.lex_state = 16},
  [1572] = {.lex_state = 16},
  [1573] = {.lex_state = 16},
  [1574] = {.lex_state = 16},
  [1575] = {.lex_state = 16},
  [1576] = {.lex_state = 16},
  [1577] = {.lex_state = 16},
  [1578] = {.lex_state = 16},
  [1579] = {.lex_state = 16},
  [1580] = {.lex_state = 16},
  [1581] = {.lex_state = 16},
  [1582] = {.lex_state = 16},
  [1583] = {.lex_state = 16},
  [1584] = {.lex_state = 16},
  [1585] = {.lex_state = 16},
  [1586] = {.lex_state = 16},
  [1587] = {.lex_state = 16},
  [1588] = {.lex_state = 16},
  [1589] = {.lex_state = 16},
  [1590] = {.lex_state = 16},
  [1591] = {.lex_state = 16},
  [1592] = {.lex_state = 16},
  [1593] = {.lex_state = 16},
  [1594] = {.lex_state = 16},
  [1595] = {.lex_state = 16},
  [1596] = {.lex_state = 16},
  [1597] = {.lex_state = 16},
  [1598] = {.lex_state = 16},
  [1599] = {.lex_state = 16},
  [1600] = {.lex_state = 16},
  [1601] = {.lex_state = 16},
  [1602] = {.lex_state = 16},
  [1603] = {.lex_state = 16},
  [1604] = {.lex_state = 16},
  [1605] = {.lex_state = 16},
  [1606] = {.lex_state = 16},
  [1607] = {.lex_state = 16},
  [1608] = {.lex_state = 16},
  [1609] = {.lex_state = 16},
  [1610] = {.lex_state = 16},
  [1611] = {.lex_state = 16},
  [1612] = {.lex_state = 16},
  [1613] = {.lex_state = 16},
  [1614] = {.lex_state = 16},
  [1615] = {.lex_state = 16},
  [1616] = {.lex_state = 16},
  [1617] = {.lex_state = 16},
  [1618] = {.lex_state = 16},
  [1619] = {.lex_state = 16},
  [1620] = {.lex_state = 16},
  [1621] = {.lex_state = 16},
  [1622] = {.lex_state = 16},
  [1623] = {.lex_state = 16},
  [1624] = {.lex_state = 16},
  [1625] = {.lex_state = 16},
  [1626] = {.lex_state = 16},
  [1627] = {.lex_state = 16},
  [1628] = {.lex_state = 16},
  [1629] = {.lex_state = 16},
  [1630] = {.lex_state = 16},
  [1631] = {.lex_state = 16},
  [1632] = {.lex_state = 16},
  [1633] = {.lex_state = 2},
  [1634] = {.lex_state = 16},
  [1635] = {.lex_state = 16},
  [1636] = {.lex_state = 16},
  [1637] = {.lex_state = 16},
  [1638] = {.lex_state = 16},
  [1639] = {.lex_state = 16},
  [1640] = {.lex_state = 16},
  [1641] = {.lex_state = 16},
  [1642] = {.lex_state = 16},
  [1643] = {.lex_state = 16},
  [1644] = {.lex_state = 16},
  [1645] = {.lex_state = 16},
  [1646] = {.lex_state = 16},
  [1647] = {.lex_state = 16},
  [1648] = {.lex_state = 16},
  [1649] = {.lex_state = 16},
  [1650] = {.lex_state = 16},
  [1651] = {.lex_state = 16},
  [1652] = {.lex_state = 16},
  [1653] = {.lex_state = 16},
  [1654] = {.lex_state = 16},
  [1655] = {.lex_state = 16},
  [1656] = {.lex_state = 16},
  [1657] = {.lex_state = 16},
  [1658] = {.lex_state = 16},
  [1659] = {.lex_state = 16},
  [1660] = {.lex_state = 16},
  [1661] = {.lex_state = 16},
  [1662] = {.lex_state = 16},
  [1663] = {.lex_state = 16},
  [1664] = {.lex_state = 16},
  [1665] = {.lex_state = 2},
  [1666] = {.lex_state = 16},
  [1667] = {.lex_state = 16},
  [1668] = {.lex_state = 16},
  [1669] = {.lex_state = 2},
  [1670] = {.lex_state = 16},
  [1671] = {.lex_state = 16},
  [1672] = {.lex_state = 16},
  [1673] = {.lex_state = 16},
  [1674] = {.lex_state = 16},
  [1675] = {.lex_state = 2},
  [1676] = {.lex_state = 16},
  [1677] = {.lex_state = 16},
  [1678] = {.lex_state = 16},
  [1679] = {.lex_state = 16},
  [1680] = {.lex_state = 16},
  [1681] = {.lex_state = 16},
  [1682] = {.lex_state = 16},
  [1683] = {.lex_state = 2},
  [1684] = {.lex_state = 16},
  [1685] = {.lex_state = 16},
  [1686] = {.lex_state = 16},
  [1687] = {.lex_state = 2},
  [1688] = {.lex_state = 16},
  [1689] = {.lex_state = 16},
  [1690] = {.lex_state = 16},
  [1691] = {.lex_state = 16},
  [1692] = {.lex_state = 16},
  [1693] = {.lex_state = 16},
  [1694] = {.lex_state = 16},
  [1695] = {.lex_state = 2},
  [1696] = {.lex_state = 2},
  [1697] = {.lex_state = 2},
  [1698] = {.lex_state = 16},
  [1699] = {.lex_state = 16},
  [1700] = {.lex_state = 16},
  [1701] = {.lex_state = 16},
  [1702] = {.lex_state = 16},
  [1703] = {.lex_state = 16},
  [1704] = {.lex_state = 2},
  [1705] = {.lex_state = 16},
  [1706] = {.lex_state = 16},
  [1707] = {.lex_state = 16},
  [1708] = {.lex_state = 16},
  [1709] = {.lex_state = 16},
  [1710] = {.lex_state = 2},
  [1711] = {.lex_state = 16},
  [1712] = {.lex_state = 16},
  [1713] = {.lex_state = 16},
  [1714] = {.lex_state = 16},
  [1715] = {.lex_state = 16},
  [1716] = {.lex_state = 16},
  [1717] = {.lex_state = 16},
  [1718] = {.lex_state = 16},
  [1719] = {.lex_state = 16},
  [1720] = {.lex_state = 16},
  [1721] = {.lex_state = 16},
  [1722] = {.lex_state = 16},
  [1723] = {.lex_state = 16},
  [1724] = {.lex_state = 16},
  [1725] = {.lex_state = 16},
  [1726] = {.lex_state = 16},
  [1727] = {.lex_state = 16},
  [1728] = {.lex_state = 16},
  [1729] = {.lex_state = 16},
  [1730] = {.lex_state = 16},
  [1731] = {.lex_state = 16},
  [1732] = {.lex_state = 16},
  [1733] = {.lex_state = 16},
  [1734] = {.lex_state = 16},
  [1735] = {.lex_state = 16},
  [1736] = {.lex_state = 16},
  [1737] = {.lex_state = 16},
  [1738] = {.lex_state = 16},
  [1739] = {.lex_state = 16},
  [1740] = {.lex_state = 16},
  [1741] = {.lex_state = 16},
  [1742] = {.lex_state = 2},
  [1743] = {.lex_state = 16},
  [1744] = {.lex_state = 16},
  [1745] = {.lex_state = 16},
  [1746] = {.lex_state = 16},
  [1747] = {.lex_state = 16},
  [1748] = {.lex_state = 16},
  [1749] = {.lex_state = 16},
  [1750] = {.lex_state = 16},
  [1751] = {.lex_state = 16},
  [1752] = {.lex_state = 16},
  [1753] = {.lex_state = 16},
  [1754] = {.lex_state = 16},
  [1755] = {.lex_state = 16},
  [1756] = {.lex_state = 16},
  [1757] = {.lex_state = 16},
  [1758] = {.lex_state = 16},
  [1759] = {.lex_state = 16},
  [1760] = {.lex_state = 16},
  [1761] = {.lex_state = 16},
  [1762] = {.lex_state = 16},
  [1763] = {.lex_state = 16},
  [1764] = {.lex_state = 16},
  [1765] = {.lex_state = 16},
  [1766] = {.lex_state = 2},
  [1767] = {.lex_state = 2},
  [1768] = {.lex_state = 16},
  [1769] = {.lex_state = 16},
  [1770] = {.lex_state = 16},
  [1771] = {.lex_state = 16},
  [1772] = {.lex_state = 16},
  [1773] = {.lex_state = 16},
  [1774] = {.lex_state = 16},
  [1775] = {.lex_state = 16},
  [1776] = {.lex_state = 16},
  [1777] = {.lex_state = 16},
  [1778] = {.lex_state = 16},
  [1779] = {.lex_state = 16},
  [1780] = {.lex_state = 2},
  [1781] = {.lex_state = 16},
  [1782] = {.lex_state = 16},
  [1783] = {.lex_state = 16},
  [1784] = {.lex_state = 16},
  [1785] = {.lex_state = 16},
  [1786] = {.lex_state = 16},
  [1787] = {.lex_state = 16},
  [1788] = {.lex_state = 16},
  [1789] = {.lex_state = 16},
  [1790] = {.lex_state = 16},
  [1791] = {.lex_state = 16},
  [1792] = {.lex_state = 16},
  [1793] = {.lex_state = 16},
  [1794] = {.lex_state = 16},
  [1795] = {.lex_state = 16},
  [1796] = {.lex_state = 16},
  [1797] = {.lex_state = 16},
  [1798] = {.lex_state = 16},
  [1799] = {.lex_state = 16},
  [1800] = {.lex_state = 16},
  [1801] = {.lex_state = 16},
  [1802] = {.lex_state = 16},
  [1803] = {.lex_state = 16},
  [1804] = {.lex_state = 16},
  [1805] = {.lex_state = 16},
  [1806] = {.lex_state = 16},
  [1807] = {.lex_state = 16},
  [1808] = {.lex_state = 16},
  [1809] = {.lex_state = 16},
  [1810] = {.lex_state = 16},
  [1811] = {.lex_state = 16},
  [1812] = {.lex_state = 16},
  [1813] = {.lex_state = 16},
  [1814] = {.lex_state = 16},
  [1815] = {.lex_state = 16},
  [1816] = {.lex_state = 16},
  [1817] = {.lex_state = 16},
  [1818] = {.lex_state = 16},
  [1819] = {.lex_state = 16},
  [1820] = {.lex_state = 16},
  [1821] = {.lex_state = 16},
  [1822] = {.lex_state = 16},
  [1823] = {.lex_state = 16},
  [1824] = {.lex_state = 16},
  [1825] = {.lex_state = 16},
  [1826] = {.lex_state = 16},
  [1827] = {.lex_state = 16},
  [1828] = {.lex_state = 16},
  [1829] = {.lex_state = 16},
  [1830] = {.lex_state = 16},
  [1831] = {.lex_state = 16},
  [1832] = {.lex_state = 16},
  [1833] = {.lex_state = 16},
  [1834] = {.lex_state = 16},
  [1835] = {.lex_state = 2},
  [1836] = {.lex_state = 16},
  [1837] = {.lex_state = 16},
  [1838] = {.lex_state = 16},
  [1839] = {.lex_state = 16},
  [1840] = {.lex_state = 16},
  [1841] = {.lex_state = 16},
  [1842] = {.lex_state = 16},
  [1843] = {.lex_state = 16},
  [1844] = {.lex_state = 16},
  [1845] = {.lex_state = 16},
  [1846] = {.lex_state = 16},
  [1847] = {.lex_state = 16},
  [1848] = {.lex_state = 16},
  [1849] = {.lex_state = 16},
  [1850] = {.lex_state = 16},
  [1851] = {.lex_state = 16},
  [1852] = {.lex_state = 16},
  [1853] = {.lex_state = 16},
  [1854] = {.lex_state = 16},
  [1855] = {.lex_state = 16},
  [1856] = {.lex_state = 16},
  [1857] = {.lex_state = 16},
  [1858] = {.lex_state = 16},
  [1859] = {.lex_state = 16},
  [1860] = {.lex_state = 16},
  [1861] = {.lex_state = 16},
  [1862] = {.lex_state = 16},
  [1863] = {.lex_state = 16},
  [1864] = {.lex_state = 16},
  [1865] = {.lex_state = 16},
  [1866] = {.lex_state = 16},
  [1867] = {.lex_state = 16},
  [1868] = {.lex_state = 16},
  [1869] = {.lex_state = 16},
  [1870] = {.lex_state = 16},
  [1871] = {.lex_state = 16},
  [1872] = {.lex_state = 16},
  [1873] = {.lex_state = 16},
  [1874] = {.lex_state = 16},
  [1875] = {.lex_state = 16},
  [1876] = {.lex_state = 16},
  [1877] = {.lex_state = 16},
  [1878] = {.lex_state = 16},
  [1879] = {.lex_state = 16},
  [1880] = {.lex_state = 16},
  [1881] = {.lex_state = 16},
  [1882] = {.lex_state = 16},
  [1883] = {.lex_state = 16},
  [1884] = {.lex_state = 16},
  [1885] = {.lex_state = 16},
  [1886] = {.lex_state = 16},
  [1887] = {.lex_state = 16},
  [1888] = {.lex_state = 16},
  [1889] = {.lex_state = 16},
  [1890] = {.lex_state = 16},
  [1891] = {.lex_state = 16},
  [1892] = {.lex_state = 16},
  [1893] = {.lex_state = 16},
  [1894] = {.lex_state = 16},
  [1895] = {.lex_state = 16},
  [1896] = {.lex_state = 16},
  [1897] = {.lex_state = 16},
  [1898] = {.lex_state = 16},
  [1899] = {.lex_state = 16},
  [1900] = {.lex_state = 16},
  [1901] = {.lex_state = 16},
  [1902] = {.lex_state = 16},
  [1903] = {.lex_state = 16},
  [1904] = {.lex_state = 16},
  [1905] = {.lex_state = 16},
  [1906] = {.lex_state = 16},
  [1907] = {.lex_state = 16},
  [1908] = {.lex_state = 16},
  [1909] = {.lex_state = 16},
  [1910] = {.lex_state = 16},
  [1911] = {.lex_state = 16},
  [1912] = {.lex_state = 16},
  [1913] = {.lex_state = 16},
  [1914] = {.lex_state = 16},
  [1915] = {.lex_state = 16},
  [1916] = {.lex_state = 16},
  [1917] = {.lex_state = 16},
  [1918] = {.lex_state = 16},
  [1919] = {.lex_state = 16},
  [1920] = {.lex_state = 16},
  [1921] = {.lex_state = 16},
  [1922] = {.lex_state = 16},
  [1923] = {.lex_state = 16},
  [1924] = {.lex_state = 16},
  [1925] = {.lex_state = 16},
  [1926] = {.lex_state = 16},
  [1927] = {.lex_state = 16},
  [1928] = {.lex_state = 16},
  [1929] = {.lex_state = 16},
  [1930] = {.lex_state = 16},
  [1931] = {.lex_state = 16},
  [1932] = {.lex_state = 16},
  [1933] = {.lex_state = 16},
  [1934] = {.lex_state = 16},
  [1935] = {.lex_state = 16},
  [1936] = {.lex_state = 16},
  [1937] = {.lex_state = 16},
  [1938] = {.lex_state = 16},
  [1939] = {.lex_state = 16},
  [1940] = {.lex_state = 16},
  [1941] = {.lex_state = 16},
  [1942] = {.lex_state = 16},
  [1943] = {.lex_state = 16},
  [1944] = {.lex_state = 16},
  [1945] = {.lex_state = 16},
  [1946] = {.lex_state = 16},
  [1947] = {.lex_state = 16},
  [1948] = {.lex_state = 16},
  [1949] = {.lex_state = 16},
  [1950] = {.lex_state = 16},
  [1951] = {.lex_state = 16},
  [1952] = {.lex_state = 16},
  [1953] = {.lex_state = 16},
  [1954] = {.lex_state = 16},
  [1955] = {.lex_state = 16},
  [1956] = {.lex_state = 16},
  [1957] = {.lex_state = 16},
  [1958] = {.lex_state = 16},
  [1959] = {.lex_state = 16},
  [1960] = {.lex_state = 16},
  [1961] = {.lex_state = 16},
  [1962] = {.lex_state = 16},
  [1963] = {.lex_state = 16},
  [1964] = {.lex_state = 16},
  [1965] = {.lex_state = 16},
  [1966] = {.lex_state = 16},
  [1967] = {.lex_state = 16},
  [1968] = {.lex_state = 16},
  [1969] = {.lex_state = 16},
  [1970] = {.lex_state = 16},
  [1971] = {.lex_state = 16},
  [1972] = {.lex_state = 16},
  [1973] = {.lex_state = 16},
  [1974] = {.lex_state = 16},
  [1975] = {.lex_state = 16},
  [1976] = {.lex_state = 16},
  [1977] = {.lex_state = 16},
  [1978] = {.lex_state = 16},
  [1979] = {.lex_state = 16},
  [1980] = {.lex_state = 16},
  [1981] = {.lex_state = 16},
  [1982] = {.lex_state = 16},
  [1983] = {.lex_state = 16},
  [1984] = {.lex_state = 16},
  [1985] = {.lex_state = 16},
  [1986] = {.lex_state = 16},
  [1987] = {.lex_state = 16},
  [1988] = {.lex_state = 16},
  [1989] = {.lex_state = 16},
  [1990] = {.lex_state = 16},
  [1991] = {.lex_state = 16},
  [1992] = {.lex_state = 16},
  [1993] = {.lex_state = 16},
  [1994] = {.lex_state = 16},
  [1995] = {.lex_state = 16},
  [1996] = {.lex_state = 16},
  [1997] = {.lex_state = 16},
  [1998] = {.lex_state = 16},
  [1999] = {.lex_state = 16},
  [2000] = {.lex_state = 16},
  [2001] = {.lex_state = 16},
  [2002] = {.lex_state = 16},
  [2003] = {.lex_state = 16},
  [2004] = {.lex_state = 16},
  [2005] = {.lex_state = 16},
  [2006] = {.lex_state = 16},
  [2007] = {.lex_state = 16},
  [2008] = {.lex_state = 16},
  [2009] = {.lex_state = 16},
  [2010] = {.lex_state = 16},
  [2011] = {.lex_state = 16},
  [2012] = {.lex_state = 16},
  [2013] = {.lex_state = 16},
  [2014] = {.lex_state = 16},
  [2015] = {.lex_state = 16},
  [2016] = {.lex_state = 16},
  [2017] = {.lex_state = 16},
  [2018] = {.lex_state = 16},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__lower_id] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_newtype] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_where] = ACTIONS(1),
    [anon_sym_select] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_implies] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [sym_specialId] = ACTIONS(1),
    [anon_sym_exists] = ACTIONS(1),
    [anon_sym_forall] = ACTIONS(1),
    [anon_sym_forex] = ACTIONS(1),
    [sym_underscore] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_asc] = ACTIONS(1),
    [anon_sym_desc] = ACTIONS(1),
    [anon_sym_order] = ACTIONS(1),
    [anon_sym_by] = ACTIONS(1),
    [sym_qldoc] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_date] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [sym_dbtype] = ACTIONS(1),
    [anon_sym_avg] = ACTIONS(1),
    [anon_sym_concat] = ACTIONS(1),
    [anon_sym_strictconcat] = ACTIONS(1),
    [anon_sym_count] = ACTIONS(1),
    [anon_sym_max] = ACTIONS(1),
    [anon_sym_min] = ACTIONS(1),
    [anon_sym_rank] = ACTIONS(1),
    [anon_sym_strictcount] = ACTIONS(1),
    [anon_sym_strictsum] = ACTIONS(1),
    [anon_sym_sum] = ACTIONS(1),
    [anon_sym_any] = ACTIONS(1),
    [anon_sym_unique] = ACTIONS(1),
    [sym__upper_id] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(5),
    [sym_false] = ACTIONS(1),
    [sym_predicate] = ACTIONS(1),
    [sym_result] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
  },
  [1] = {
    [sym_ql] = STATE(1913),
    [sym_module] = STATE(1300),
    [sym_moduleMember] = STATE(695),
    [sym_importDirective] = STATE(1300),
    [sym_classlessPredicate] = STATE(1300),
    [sym_datatype] = STATE(1300),
    [sym_select] = STATE(1300),
    [sym_dataclass] = STATE(1300),
    [sym_annotation] = STATE(702),
    [sym_annotName] = STATE(1392),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1853),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(1451),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1792),
    [aux_sym_ql_repeat1] = STATE(695),
    [aux_sym_moduleMember_repeat1] = STATE(702),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym__lower_id] = ACTIONS(9),
    [anon_sym_module] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
    [anon_sym_newtype] = ACTIONS(15),
    [anon_sym_from] = ACTIONS(17),
    [anon_sym_where] = ACTIONS(19),
    [anon_sym_select] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [sym_qldoc] = ACTIONS(25),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [sym__upper_id] = ACTIONS(31),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(5),
    [sym_predicate] = ACTIONS(33),
  },
  [2] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1936),
    [sym_expr_aggregate_body] = STATE(1936),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(39),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [3] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1940),
    [sym_expr_aggregate_body] = STATE(1940),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [4] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1860),
    [sym_expr_aggregate_body] = STATE(1860),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(71),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [5] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1831),
    [sym_expr_aggregate_body] = STATE(1831),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(73),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [6] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1910),
    [sym_expr_aggregate_body] = STATE(1910),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [7] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1951),
    [sym_expr_aggregate_body] = STATE(1951),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [8] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1967),
    [sym_expr_aggregate_body] = STATE(1967),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(79),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [9] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1939),
    [sym_expr_aggregate_body] = STATE(1939),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(81),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [10] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1823),
    [sym_expr_aggregate_body] = STATE(1823),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(83),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [11] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1935),
    [sym_expr_aggregate_body] = STATE(1935),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(85),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [12] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1943),
    [sym_expr_aggregate_body] = STATE(1943),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(87),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [13] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1946),
    [sym_expr_aggregate_body] = STATE(1946),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(89),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [14] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1996),
    [sym_expr_aggregate_body] = STATE(1996),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(91),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [15] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1833),
    [sym_expr_aggregate_body] = STATE(1833),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(93),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [16] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1843),
    [sym_expr_aggregate_body] = STATE(1843),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(95),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [17] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1894),
    [sym_expr_aggregate_body] = STATE(1894),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(97),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [18] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1828),
    [sym_expr_aggregate_body] = STATE(1828),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(99),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [19] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1858),
    [sym_expr_aggregate_body] = STATE(1858),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(101),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [20] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(2010),
    [sym_expr_aggregate_body] = STATE(2010),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(103),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [21] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1867),
    [sym_expr_aggregate_body] = STATE(1867),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(105),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [22] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_full_aggregate_body] = STATE(1859),
    [sym_expr_aggregate_body] = STATE(1859),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_varDecl] = STATE(1573),
    [sym_asExprs] = STATE(1667),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1510),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(107),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(45),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [23] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1705),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_varDecl] = STATE(1690),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1521),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(113),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(123),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [24] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1724),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_varDecl] = STATE(1746),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1521),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(139),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(141),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(143),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [25] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1732),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_varDecl] = STATE(1674),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1521),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(145),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(147),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [26] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1754),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_varDecl] = STATE(1701),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1521),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(151),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(153),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(155),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [27] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1628),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_varDecl] = STATE(1718),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1521),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(157),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(159),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [28] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1693),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_varDecl] = STATE(1711),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1521),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(163),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(165),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(167),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [29] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1649),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_varDecl] = STATE(1730),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1521),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(169),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(171),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(173),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [30] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1729),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(175),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(177),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [31] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1706),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(179),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(181),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [32] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1622),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(183),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(185),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [33] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1659),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(187),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [34] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1620),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(191),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(193),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [35] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1757),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(195),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [36] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1672),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(199),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(201),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [37] = {
    [sym_special_call] = STATE(1129),
    [sym_prefix_cast] = STATE(1129),
    [sym_unary_expr] = STATE(1129),
    [sym_mul_expr] = STATE(1129),
    [sym_add_expr] = STATE(1129),
    [sym_in_expr] = STATE(1129),
    [sym_comp_term] = STATE(1129),
    [sym_instance_of] = STATE(1129),
    [sym_negation] = STATE(1129),
    [sym_if_term] = STATE(1129),
    [sym_conjunction] = STATE(1129),
    [sym_disjunction] = STATE(1129),
    [sym_implication] = STATE(1129),
    [sym_quantified] = STATE(1129),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1129),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_varDecl] = STATE(1549),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1521),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(203),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(205),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [38] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1679),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(207),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [39] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1682),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(211),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(213),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [40] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1726),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(215),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(217),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [41] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1760),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(219),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(221),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [42] = {
    [sym_special_call] = STATE(1106),
    [sym_prefix_cast] = STATE(1106),
    [sym_unary_expr] = STATE(1106),
    [sym_mul_expr] = STATE(1106),
    [sym_add_expr] = STATE(1106),
    [sym_in_expr] = STATE(1106),
    [sym_comp_term] = STATE(1106),
    [sym_instance_of] = STATE(1106),
    [sym_negation] = STATE(1106),
    [sym_if_term] = STATE(1106),
    [sym_conjunction] = STATE(1106),
    [sym_disjunction] = STATE(1106),
    [sym_implication] = STATE(1106),
    [sym_quantified] = STATE(1106),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1106),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_varDecl] = STATE(1593),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1521),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(223),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(225),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [43] = {
    [sym_special_call] = STATE(1081),
    [sym_prefix_cast] = STATE(1081),
    [sym_unary_expr] = STATE(1081),
    [sym_mul_expr] = STATE(1081),
    [sym_add_expr] = STATE(1081),
    [sym_in_expr] = STATE(1081),
    [sym_comp_term] = STATE(1081),
    [sym_instance_of] = STATE(1081),
    [sym_negation] = STATE(1081),
    [sym_if_term] = STATE(1081),
    [sym_conjunction] = STATE(1081),
    [sym_disjunction] = STATE(1081),
    [sym_implication] = STATE(1081),
    [sym_quantified] = STATE(1081),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1081),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_varDecl] = STATE(1600),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1521),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(227),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(229),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [44] = {
    [sym_special_call] = STATE(1139),
    [sym_prefix_cast] = STATE(1139),
    [sym_unary_expr] = STATE(1139),
    [sym_mul_expr] = STATE(1139),
    [sym_add_expr] = STATE(1139),
    [sym_in_expr] = STATE(1139),
    [sym_comp_term] = STATE(1139),
    [sym_instance_of] = STATE(1139),
    [sym_negation] = STATE(1139),
    [sym_if_term] = STATE(1139),
    [sym_conjunction] = STATE(1139),
    [sym_disjunction] = STATE(1139),
    [sym_implication] = STATE(1139),
    [sym_quantified] = STATE(1139),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1139),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_varDecl] = STATE(1558),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1521),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(231),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(233),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [45] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1635),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(235),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(237),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [46] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1719),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(239),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(241),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [47] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1634),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(243),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [48] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1640),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(247),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(249),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [49] = {
    [sym_special_call] = STATE(1044),
    [sym_prefix_cast] = STATE(1044),
    [sym_unary_expr] = STATE(1044),
    [sym_mul_expr] = STATE(1044),
    [sym_add_expr] = STATE(1044),
    [sym_in_expr] = STATE(1044),
    [sym_comp_term] = STATE(1044),
    [sym_instance_of] = STATE(1044),
    [sym_negation] = STATE(1044),
    [sym_if_term] = STATE(1044),
    [sym_conjunction] = STATE(1044),
    [sym_disjunction] = STATE(1044),
    [sym_implication] = STATE(1044),
    [sym_quantified] = STATE(1044),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1044),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_varDecl] = STATE(1570),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1521),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(251),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(253),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [50] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1725),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(255),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(257),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [51] = {
    [sym_special_call] = STATE(1150),
    [sym_prefix_cast] = STATE(1150),
    [sym_unary_expr] = STATE(1150),
    [sym_mul_expr] = STATE(1150),
    [sym_add_expr] = STATE(1150),
    [sym_in_expr] = STATE(1150),
    [sym_comp_term] = STATE(1150),
    [sym_instance_of] = STATE(1150),
    [sym_negation] = STATE(1150),
    [sym_if_term] = STATE(1150),
    [sym_conjunction] = STATE(1150),
    [sym_disjunction] = STATE(1150),
    [sym_implication] = STATE(1150),
    [sym_quantified] = STATE(1150),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1150),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_varDecl] = STATE(1567),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1521),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(259),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(261),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [52] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1735),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(263),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(265),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [53] = {
    [sym_special_call] = STATE(1117),
    [sym_prefix_cast] = STATE(1117),
    [sym_unary_expr] = STATE(1117),
    [sym_mul_expr] = STATE(1117),
    [sym_add_expr] = STATE(1117),
    [sym_in_expr] = STATE(1117),
    [sym_comp_term] = STATE(1117),
    [sym_instance_of] = STATE(1117),
    [sym_negation] = STATE(1117),
    [sym_if_term] = STATE(1117),
    [sym_conjunction] = STATE(1117),
    [sym_disjunction] = STATE(1117),
    [sym_implication] = STATE(1117),
    [sym_quantified] = STATE(1117),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1117),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_varDecl] = STATE(1610),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1999),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1521),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(267),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(269),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [54] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1655),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(271),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [55] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1661),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(275),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(277),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [56] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1643),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(279),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(281),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [57] = {
    [sym_special_call] = STATE(1008),
    [sym_prefix_cast] = STATE(1008),
    [sym_unary_expr] = STATE(1008),
    [sym_mul_expr] = STATE(1008),
    [sym_add_expr] = STATE(1008),
    [sym_in_expr] = STATE(1008),
    [sym_comp_term] = STATE(1008),
    [sym_instance_of] = STATE(1008),
    [sym_negation] = STATE(1008),
    [sym_if_term] = STATE(1008),
    [sym_conjunction] = STATE(1008),
    [sym_disjunction] = STATE(1008),
    [sym_implication] = STATE(1008),
    [sym_quantified] = STATE(1008),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1008),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(283),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(285),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [58] = {
    [sym_special_call] = STATE(837),
    [sym_prefix_cast] = STATE(837),
    [sym_unary_expr] = STATE(837),
    [sym_mul_expr] = STATE(837),
    [sym_add_expr] = STATE(837),
    [sym_in_expr] = STATE(837),
    [sym_comp_term] = STATE(837),
    [sym_instance_of] = STATE(837),
    [sym_negation] = STATE(837),
    [sym_if_term] = STATE(837),
    [sym_conjunction] = STATE(837),
    [sym_disjunction] = STATE(837),
    [sym_implication] = STATE(837),
    [sym_quantified] = STATE(837),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(837),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_COMMA] = ACTIONS(287),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(295),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [59] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1855),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [60] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1869),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [61] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_asExprs] = STATE(1621),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [62] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_asExprs] = STATE(1623),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [63] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1914),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [64] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_asExprs] = STATE(1749),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [65] = {
    [sym_special_call] = STATE(415),
    [sym_prefix_cast] = STATE(415),
    [sym_unary_expr] = STATE(415),
    [sym_mul_expr] = STATE(415),
    [sym_add_expr] = STATE(415),
    [sym_in_expr] = STATE(415),
    [sym_comp_term] = STATE(415),
    [sym_instance_of] = STATE(415),
    [sym_negation] = STATE(415),
    [sym_if_term] = STATE(415),
    [sym_conjunction] = STATE(415),
    [sym_disjunction] = STATE(415),
    [sym_implication] = STATE(415),
    [sym_quantified] = STATE(415),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(415),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_asExprs] = STATE(1038),
    [sym_asExpr] = STATE(1026),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [66] = {
    [sym_special_call] = STATE(415),
    [sym_prefix_cast] = STATE(415),
    [sym_unary_expr] = STATE(415),
    [sym_mul_expr] = STATE(415),
    [sym_add_expr] = STATE(415),
    [sym_in_expr] = STATE(415),
    [sym_comp_term] = STATE(415),
    [sym_instance_of] = STATE(415),
    [sym_negation] = STATE(415),
    [sym_if_term] = STATE(415),
    [sym_conjunction] = STATE(415),
    [sym_disjunction] = STATE(415),
    [sym_implication] = STATE(415),
    [sym_quantified] = STATE(415),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(415),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_asExprs] = STATE(1181),
    [sym_asExpr] = STATE(1026),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [67] = {
    [sym_special_call] = STATE(385),
    [sym_prefix_cast] = STATE(385),
    [sym_unary_expr] = STATE(385),
    [sym_mul_expr] = STATE(385),
    [sym_add_expr] = STATE(385),
    [sym_in_expr] = STATE(385),
    [sym_comp_term] = STATE(385),
    [sym_instance_of] = STATE(385),
    [sym_negation] = STATE(385),
    [sym_if_term] = STATE(385),
    [sym_conjunction] = STATE(385),
    [sym_disjunction] = STATE(385),
    [sym_implication] = STATE(385),
    [sym_quantified] = STATE(385),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(385),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_asExprs] = STATE(1095),
    [sym_asExpr] = STATE(912),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(335),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(341),
    [sym_result] = ACTIONS(343),
    [sym_super] = ACTIONS(345),
    [sym_this] = ACTIONS(343),
    [sym_true] = ACTIONS(341),
  },
  [68] = {
    [sym_special_call] = STATE(385),
    [sym_prefix_cast] = STATE(385),
    [sym_unary_expr] = STATE(385),
    [sym_mul_expr] = STATE(385),
    [sym_add_expr] = STATE(385),
    [sym_in_expr] = STATE(385),
    [sym_comp_term] = STATE(385),
    [sym_instance_of] = STATE(385),
    [sym_negation] = STATE(385),
    [sym_if_term] = STATE(385),
    [sym_conjunction] = STATE(385),
    [sym_disjunction] = STATE(385),
    [sym_implication] = STATE(385),
    [sym_quantified] = STATE(385),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(385),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_asExprs] = STATE(1100),
    [sym_asExpr] = STATE(912),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(335),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(341),
    [sym_result] = ACTIONS(343),
    [sym_super] = ACTIONS(345),
    [sym_this] = ACTIONS(343),
    [sym_true] = ACTIONS(341),
  },
  [69] = {
    [sym_special_call] = STATE(831),
    [sym_prefix_cast] = STATE(831),
    [sym_unary_expr] = STATE(831),
    [sym_mul_expr] = STATE(831),
    [sym_add_expr] = STATE(831),
    [sym_in_expr] = STATE(831),
    [sym_comp_term] = STATE(831),
    [sym_instance_of] = STATE(831),
    [sym_negation] = STATE(831),
    [sym_if_term] = STATE(831),
    [sym_conjunction] = STATE(831),
    [sym_disjunction] = STATE(831),
    [sym_implication] = STATE(831),
    [sym_quantified] = STATE(831),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(831),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_COMMA] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(349),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [70] = {
    [sym_special_call] = STATE(385),
    [sym_prefix_cast] = STATE(385),
    [sym_unary_expr] = STATE(385),
    [sym_mul_expr] = STATE(385),
    [sym_add_expr] = STATE(385),
    [sym_in_expr] = STATE(385),
    [sym_comp_term] = STATE(385),
    [sym_instance_of] = STATE(385),
    [sym_negation] = STATE(385),
    [sym_if_term] = STATE(385),
    [sym_conjunction] = STATE(385),
    [sym_disjunction] = STATE(385),
    [sym_implication] = STATE(385),
    [sym_quantified] = STATE(385),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(385),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_asExprs] = STATE(1134),
    [sym_asExpr] = STATE(912),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(335),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(341),
    [sym_result] = ACTIONS(343),
    [sym_super] = ACTIONS(345),
    [sym_this] = ACTIONS(343),
    [sym_true] = ACTIONS(341),
  },
  [71] = {
    [sym_special_call] = STATE(385),
    [sym_prefix_cast] = STATE(385),
    [sym_unary_expr] = STATE(385),
    [sym_mul_expr] = STATE(385),
    [sym_add_expr] = STATE(385),
    [sym_in_expr] = STATE(385),
    [sym_comp_term] = STATE(385),
    [sym_instance_of] = STATE(385),
    [sym_negation] = STATE(385),
    [sym_if_term] = STATE(385),
    [sym_conjunction] = STATE(385),
    [sym_disjunction] = STATE(385),
    [sym_implication] = STATE(385),
    [sym_quantified] = STATE(385),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(385),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_asExprs] = STATE(1167),
    [sym_asExpr] = STATE(912),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(335),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(341),
    [sym_result] = ACTIONS(343),
    [sym_super] = ACTIONS(345),
    [sym_this] = ACTIONS(343),
    [sym_true] = ACTIONS(341),
  },
  [72] = {
    [sym_special_call] = STATE(898),
    [sym_prefix_cast] = STATE(898),
    [sym_unary_expr] = STATE(898),
    [sym_mul_expr] = STATE(898),
    [sym_add_expr] = STATE(898),
    [sym_in_expr] = STATE(898),
    [sym_comp_term] = STATE(898),
    [sym_instance_of] = STATE(898),
    [sym_negation] = STATE(898),
    [sym_if_term] = STATE(898),
    [sym_conjunction] = STATE(898),
    [sym_disjunction] = STATE(898),
    [sym_implication] = STATE(898),
    [sym_quantified] = STATE(898),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(898),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(351),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(353),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [73] = {
    [sym_special_call] = STATE(385),
    [sym_prefix_cast] = STATE(385),
    [sym_unary_expr] = STATE(385),
    [sym_mul_expr] = STATE(385),
    [sym_add_expr] = STATE(385),
    [sym_in_expr] = STATE(385),
    [sym_comp_term] = STATE(385),
    [sym_instance_of] = STATE(385),
    [sym_negation] = STATE(385),
    [sym_if_term] = STATE(385),
    [sym_conjunction] = STATE(385),
    [sym_disjunction] = STATE(385),
    [sym_implication] = STATE(385),
    [sym_quantified] = STATE(385),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(385),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_asExprs] = STATE(1032),
    [sym_asExpr] = STATE(912),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(335),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(341),
    [sym_result] = ACTIONS(343),
    [sym_super] = ACTIONS(345),
    [sym_this] = ACTIONS(343),
    [sym_true] = ACTIONS(341),
  },
  [74] = {
    [sym_special_call] = STATE(907),
    [sym_prefix_cast] = STATE(907),
    [sym_unary_expr] = STATE(907),
    [sym_mul_expr] = STATE(907),
    [sym_add_expr] = STATE(907),
    [sym_in_expr] = STATE(907),
    [sym_comp_term] = STATE(907),
    [sym_instance_of] = STATE(907),
    [sym_negation] = STATE(907),
    [sym_if_term] = STATE(907),
    [sym_conjunction] = STATE(907),
    [sym_disjunction] = STATE(907),
    [sym_implication] = STATE(907),
    [sym_quantified] = STATE(907),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(907),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(355),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(357),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [75] = {
    [sym_special_call] = STATE(385),
    [sym_prefix_cast] = STATE(385),
    [sym_unary_expr] = STATE(385),
    [sym_mul_expr] = STATE(385),
    [sym_add_expr] = STATE(385),
    [sym_in_expr] = STATE(385),
    [sym_comp_term] = STATE(385),
    [sym_instance_of] = STATE(385),
    [sym_negation] = STATE(385),
    [sym_if_term] = STATE(385),
    [sym_conjunction] = STATE(385),
    [sym_disjunction] = STATE(385),
    [sym_implication] = STATE(385),
    [sym_quantified] = STATE(385),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(385),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_asExprs] = STATE(1033),
    [sym_asExpr] = STATE(912),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(335),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(341),
    [sym_result] = ACTIONS(343),
    [sym_super] = ACTIONS(345),
    [sym_this] = ACTIONS(343),
    [sym_true] = ACTIONS(341),
  },
  [76] = {
    [sym_special_call] = STATE(916),
    [sym_prefix_cast] = STATE(916),
    [sym_unary_expr] = STATE(916),
    [sym_mul_expr] = STATE(916),
    [sym_add_expr] = STATE(916),
    [sym_in_expr] = STATE(916),
    [sym_comp_term] = STATE(916),
    [sym_instance_of] = STATE(916),
    [sym_negation] = STATE(916),
    [sym_if_term] = STATE(916),
    [sym_conjunction] = STATE(916),
    [sym_disjunction] = STATE(916),
    [sym_implication] = STATE(916),
    [sym_quantified] = STATE(916),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(916),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(359),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(361),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [77] = {
    [sym_special_call] = STATE(415),
    [sym_prefix_cast] = STATE(415),
    [sym_unary_expr] = STATE(415),
    [sym_mul_expr] = STATE(415),
    [sym_add_expr] = STATE(415),
    [sym_in_expr] = STATE(415),
    [sym_comp_term] = STATE(415),
    [sym_instance_of] = STATE(415),
    [sym_negation] = STATE(415),
    [sym_if_term] = STATE(415),
    [sym_conjunction] = STATE(415),
    [sym_disjunction] = STATE(415),
    [sym_implication] = STATE(415),
    [sym_quantified] = STATE(415),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(415),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_asExprs] = STATE(1109),
    [sym_asExpr] = STATE(1026),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [78] = {
    [sym_special_call] = STATE(845),
    [sym_prefix_cast] = STATE(845),
    [sym_unary_expr] = STATE(845),
    [sym_mul_expr] = STATE(845),
    [sym_add_expr] = STATE(845),
    [sym_in_expr] = STATE(845),
    [sym_comp_term] = STATE(845),
    [sym_instance_of] = STATE(845),
    [sym_negation] = STATE(845),
    [sym_if_term] = STATE(845),
    [sym_conjunction] = STATE(845),
    [sym_disjunction] = STATE(845),
    [sym_implication] = STATE(845),
    [sym_quantified] = STATE(845),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(845),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_COMMA] = ACTIONS(363),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [79] = {
    [sym_special_call] = STATE(415),
    [sym_prefix_cast] = STATE(415),
    [sym_unary_expr] = STATE(415),
    [sym_mul_expr] = STATE(415),
    [sym_add_expr] = STATE(415),
    [sym_in_expr] = STATE(415),
    [sym_comp_term] = STATE(415),
    [sym_instance_of] = STATE(415),
    [sym_negation] = STATE(415),
    [sym_if_term] = STATE(415),
    [sym_conjunction] = STATE(415),
    [sym_disjunction] = STATE(415),
    [sym_implication] = STATE(415),
    [sym_quantified] = STATE(415),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(415),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_asExprs] = STATE(1116),
    [sym_asExpr] = STATE(1026),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [80] = {
    [sym_special_call] = STATE(939),
    [sym_prefix_cast] = STATE(939),
    [sym_unary_expr] = STATE(939),
    [sym_mul_expr] = STATE(939),
    [sym_add_expr] = STATE(939),
    [sym_in_expr] = STATE(939),
    [sym_comp_term] = STATE(939),
    [sym_instance_of] = STATE(939),
    [sym_negation] = STATE(939),
    [sym_if_term] = STATE(939),
    [sym_conjunction] = STATE(939),
    [sym_disjunction] = STATE(939),
    [sym_implication] = STATE(939),
    [sym_quantified] = STATE(939),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(939),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(367),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(369),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [81] = {
    [sym_special_call] = STATE(941),
    [sym_prefix_cast] = STATE(941),
    [sym_unary_expr] = STATE(941),
    [sym_mul_expr] = STATE(941),
    [sym_add_expr] = STATE(941),
    [sym_in_expr] = STATE(941),
    [sym_comp_term] = STATE(941),
    [sym_instance_of] = STATE(941),
    [sym_negation] = STATE(941),
    [sym_if_term] = STATE(941),
    [sym_conjunction] = STATE(941),
    [sym_disjunction] = STATE(941),
    [sym_implication] = STATE(941),
    [sym_quantified] = STATE(941),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(941),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(371),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(373),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [82] = {
    [sym_special_call] = STATE(943),
    [sym_prefix_cast] = STATE(943),
    [sym_unary_expr] = STATE(943),
    [sym_mul_expr] = STATE(943),
    [sym_add_expr] = STATE(943),
    [sym_in_expr] = STATE(943),
    [sym_comp_term] = STATE(943),
    [sym_instance_of] = STATE(943),
    [sym_negation] = STATE(943),
    [sym_if_term] = STATE(943),
    [sym_conjunction] = STATE(943),
    [sym_disjunction] = STATE(943),
    [sym_implication] = STATE(943),
    [sym_quantified] = STATE(943),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(943),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(375),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(377),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [83] = {
    [sym_special_call] = STATE(846),
    [sym_prefix_cast] = STATE(846),
    [sym_unary_expr] = STATE(846),
    [sym_mul_expr] = STATE(846),
    [sym_add_expr] = STATE(846),
    [sym_in_expr] = STATE(846),
    [sym_comp_term] = STATE(846),
    [sym_instance_of] = STATE(846),
    [sym_negation] = STATE(846),
    [sym_if_term] = STATE(846),
    [sym_conjunction] = STATE(846),
    [sym_disjunction] = STATE(846),
    [sym_implication] = STATE(846),
    [sym_quantified] = STATE(846),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(846),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_COMMA] = ACTIONS(379),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [84] = {
    [sym_special_call] = STATE(961),
    [sym_prefix_cast] = STATE(961),
    [sym_unary_expr] = STATE(961),
    [sym_mul_expr] = STATE(961),
    [sym_add_expr] = STATE(961),
    [sym_in_expr] = STATE(961),
    [sym_comp_term] = STATE(961),
    [sym_instance_of] = STATE(961),
    [sym_negation] = STATE(961),
    [sym_if_term] = STATE(961),
    [sym_conjunction] = STATE(961),
    [sym_disjunction] = STATE(961),
    [sym_implication] = STATE(961),
    [sym_quantified] = STATE(961),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(961),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(383),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(385),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [85] = {
    [sym_special_call] = STATE(948),
    [sym_prefix_cast] = STATE(948),
    [sym_unary_expr] = STATE(948),
    [sym_mul_expr] = STATE(948),
    [sym_add_expr] = STATE(948),
    [sym_in_expr] = STATE(948),
    [sym_comp_term] = STATE(948),
    [sym_instance_of] = STATE(948),
    [sym_negation] = STATE(948),
    [sym_if_term] = STATE(948),
    [sym_conjunction] = STATE(948),
    [sym_disjunction] = STATE(948),
    [sym_implication] = STATE(948),
    [sym_quantified] = STATE(948),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(948),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(387),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(389),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [86] = {
    [sym_special_call] = STATE(969),
    [sym_prefix_cast] = STATE(969),
    [sym_unary_expr] = STATE(969),
    [sym_mul_expr] = STATE(969),
    [sym_add_expr] = STATE(969),
    [sym_in_expr] = STATE(969),
    [sym_comp_term] = STATE(969),
    [sym_instance_of] = STATE(969),
    [sym_negation] = STATE(969),
    [sym_if_term] = STATE(969),
    [sym_conjunction] = STATE(969),
    [sym_disjunction] = STATE(969),
    [sym_implication] = STATE(969),
    [sym_quantified] = STATE(969),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(969),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(391),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(393),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [87] = {
    [sym_special_call] = STATE(951),
    [sym_prefix_cast] = STATE(951),
    [sym_unary_expr] = STATE(951),
    [sym_mul_expr] = STATE(951),
    [sym_add_expr] = STATE(951),
    [sym_in_expr] = STATE(951),
    [sym_comp_term] = STATE(951),
    [sym_instance_of] = STATE(951),
    [sym_negation] = STATE(951),
    [sym_if_term] = STATE(951),
    [sym_conjunction] = STATE(951),
    [sym_disjunction] = STATE(951),
    [sym_implication] = STATE(951),
    [sym_quantified] = STATE(951),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(951),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(395),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(397),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [88] = {
    [sym_special_call] = STATE(953),
    [sym_prefix_cast] = STATE(953),
    [sym_unary_expr] = STATE(953),
    [sym_mul_expr] = STATE(953),
    [sym_add_expr] = STATE(953),
    [sym_in_expr] = STATE(953),
    [sym_comp_term] = STATE(953),
    [sym_instance_of] = STATE(953),
    [sym_negation] = STATE(953),
    [sym_if_term] = STATE(953),
    [sym_conjunction] = STATE(953),
    [sym_disjunction] = STATE(953),
    [sym_implication] = STATE(953),
    [sym_quantified] = STATE(953),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(953),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(399),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(401),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [89] = {
    [sym_special_call] = STATE(415),
    [sym_prefix_cast] = STATE(415),
    [sym_unary_expr] = STATE(415),
    [sym_mul_expr] = STATE(415),
    [sym_add_expr] = STATE(415),
    [sym_in_expr] = STATE(415),
    [sym_comp_term] = STATE(415),
    [sym_instance_of] = STATE(415),
    [sym_negation] = STATE(415),
    [sym_if_term] = STATE(415),
    [sym_conjunction] = STATE(415),
    [sym_disjunction] = STATE(415),
    [sym_implication] = STATE(415),
    [sym_quantified] = STATE(415),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(415),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_asExprs] = STATE(1166),
    [sym_asExpr] = STATE(1026),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [90] = {
    [sym_special_call] = STATE(848),
    [sym_prefix_cast] = STATE(848),
    [sym_unary_expr] = STATE(848),
    [sym_mul_expr] = STATE(848),
    [sym_add_expr] = STATE(848),
    [sym_in_expr] = STATE(848),
    [sym_comp_term] = STATE(848),
    [sym_instance_of] = STATE(848),
    [sym_negation] = STATE(848),
    [sym_if_term] = STATE(848),
    [sym_conjunction] = STATE(848),
    [sym_disjunction] = STATE(848),
    [sym_implication] = STATE(848),
    [sym_quantified] = STATE(848),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(848),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_COMMA] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(405),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [91] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1861),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [92] = {
    [sym_special_call] = STATE(960),
    [sym_prefix_cast] = STATE(960),
    [sym_unary_expr] = STATE(960),
    [sym_mul_expr] = STATE(960),
    [sym_add_expr] = STATE(960),
    [sym_in_expr] = STATE(960),
    [sym_comp_term] = STATE(960),
    [sym_instance_of] = STATE(960),
    [sym_negation] = STATE(960),
    [sym_if_term] = STATE(960),
    [sym_conjunction] = STATE(960),
    [sym_disjunction] = STATE(960),
    [sym_implication] = STATE(960),
    [sym_quantified] = STATE(960),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(960),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(407),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(409),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [93] = {
    [sym_special_call] = STATE(880),
    [sym_prefix_cast] = STATE(880),
    [sym_unary_expr] = STATE(880),
    [sym_mul_expr] = STATE(880),
    [sym_add_expr] = STATE(880),
    [sym_in_expr] = STATE(880),
    [sym_comp_term] = STATE(880),
    [sym_instance_of] = STATE(880),
    [sym_negation] = STATE(880),
    [sym_if_term] = STATE(880),
    [sym_conjunction] = STATE(880),
    [sym_disjunction] = STATE(880),
    [sym_implication] = STATE(880),
    [sym_quantified] = STATE(880),
    [sym_quantifier] = STATE(1849),
    [sym__call_arg] = STATE(1779),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(880),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [sym_underscore] = ACTIONS(411),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [94] = {
    [sym_special_call] = STATE(963),
    [sym_prefix_cast] = STATE(963),
    [sym_unary_expr] = STATE(963),
    [sym_mul_expr] = STATE(963),
    [sym_add_expr] = STATE(963),
    [sym_in_expr] = STATE(963),
    [sym_comp_term] = STATE(963),
    [sym_instance_of] = STATE(963),
    [sym_negation] = STATE(963),
    [sym_if_term] = STATE(963),
    [sym_conjunction] = STATE(963),
    [sym_disjunction] = STATE(963),
    [sym_implication] = STATE(963),
    [sym_quantified] = STATE(963),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(963),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(413),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(415),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [95] = {
    [sym_special_call] = STATE(966),
    [sym_prefix_cast] = STATE(966),
    [sym_unary_expr] = STATE(966),
    [sym_mul_expr] = STATE(966),
    [sym_add_expr] = STATE(966),
    [sym_in_expr] = STATE(966),
    [sym_comp_term] = STATE(966),
    [sym_instance_of] = STATE(966),
    [sym_negation] = STATE(966),
    [sym_if_term] = STATE(966),
    [sym_conjunction] = STATE(966),
    [sym_disjunction] = STATE(966),
    [sym_implication] = STATE(966),
    [sym_quantified] = STATE(966),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(966),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(417),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(419),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [96] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_asExprs] = STATE(1713),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [97] = {
    [sym_special_call] = STATE(990),
    [sym_prefix_cast] = STATE(990),
    [sym_unary_expr] = STATE(990),
    [sym_mul_expr] = STATE(990),
    [sym_add_expr] = STATE(990),
    [sym_in_expr] = STATE(990),
    [sym_comp_term] = STATE(990),
    [sym_instance_of] = STATE(990),
    [sym_negation] = STATE(990),
    [sym_if_term] = STATE(990),
    [sym_conjunction] = STATE(990),
    [sym_disjunction] = STATE(990),
    [sym_implication] = STATE(990),
    [sym_quantified] = STATE(990),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(990),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(421),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(423),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [98] = {
    [sym_special_call] = STATE(849),
    [sym_prefix_cast] = STATE(849),
    [sym_unary_expr] = STATE(849),
    [sym_mul_expr] = STATE(849),
    [sym_add_expr] = STATE(849),
    [sym_in_expr] = STATE(849),
    [sym_comp_term] = STATE(849),
    [sym_instance_of] = STATE(849),
    [sym_negation] = STATE(849),
    [sym_if_term] = STATE(849),
    [sym_conjunction] = STATE(849),
    [sym_disjunction] = STATE(849),
    [sym_implication] = STATE(849),
    [sym_quantified] = STATE(849),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(849),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_COMMA] = ACTIONS(425),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(427),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [99] = {
    [sym_special_call] = STATE(974),
    [sym_prefix_cast] = STATE(974),
    [sym_unary_expr] = STATE(974),
    [sym_mul_expr] = STATE(974),
    [sym_add_expr] = STATE(974),
    [sym_in_expr] = STATE(974),
    [sym_comp_term] = STATE(974),
    [sym_instance_of] = STATE(974),
    [sym_negation] = STATE(974),
    [sym_if_term] = STATE(974),
    [sym_conjunction] = STATE(974),
    [sym_disjunction] = STATE(974),
    [sym_implication] = STATE(974),
    [sym_quantified] = STATE(974),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(974),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(429),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(431),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [100] = {
    [sym_special_call] = STATE(415),
    [sym_prefix_cast] = STATE(415),
    [sym_unary_expr] = STATE(415),
    [sym_mul_expr] = STATE(415),
    [sym_add_expr] = STATE(415),
    [sym_in_expr] = STATE(415),
    [sym_comp_term] = STATE(415),
    [sym_instance_of] = STATE(415),
    [sym_negation] = STATE(415),
    [sym_if_term] = STATE(415),
    [sym_conjunction] = STATE(415),
    [sym_disjunction] = STATE(415),
    [sym_implication] = STATE(415),
    [sym_quantified] = STATE(415),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(415),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_asExprs] = STATE(1179),
    [sym_asExpr] = STATE(1026),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [101] = {
    [sym_special_call] = STATE(977),
    [sym_prefix_cast] = STATE(977),
    [sym_unary_expr] = STATE(977),
    [sym_mul_expr] = STATE(977),
    [sym_add_expr] = STATE(977),
    [sym_in_expr] = STATE(977),
    [sym_comp_term] = STATE(977),
    [sym_instance_of] = STATE(977),
    [sym_negation] = STATE(977),
    [sym_if_term] = STATE(977),
    [sym_conjunction] = STATE(977),
    [sym_disjunction] = STATE(977),
    [sym_implication] = STATE(977),
    [sym_quantified] = STATE(977),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(977),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(433),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(435),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [102] = {
    [sym_special_call] = STATE(979),
    [sym_prefix_cast] = STATE(979),
    [sym_unary_expr] = STATE(979),
    [sym_mul_expr] = STATE(979),
    [sym_add_expr] = STATE(979),
    [sym_in_expr] = STATE(979),
    [sym_comp_term] = STATE(979),
    [sym_instance_of] = STATE(979),
    [sym_negation] = STATE(979),
    [sym_if_term] = STATE(979),
    [sym_conjunction] = STATE(979),
    [sym_disjunction] = STATE(979),
    [sym_implication] = STATE(979),
    [sym_quantified] = STATE(979),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(979),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(437),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(439),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [103] = {
    [sym_special_call] = STATE(850),
    [sym_prefix_cast] = STATE(850),
    [sym_unary_expr] = STATE(850),
    [sym_mul_expr] = STATE(850),
    [sym_add_expr] = STATE(850),
    [sym_in_expr] = STATE(850),
    [sym_comp_term] = STATE(850),
    [sym_instance_of] = STATE(850),
    [sym_negation] = STATE(850),
    [sym_if_term] = STATE(850),
    [sym_conjunction] = STATE(850),
    [sym_disjunction] = STATE(850),
    [sym_implication] = STATE(850),
    [sym_quantified] = STATE(850),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(850),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_COMMA] = ACTIONS(441),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(443),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [104] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(2018),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [105] = {
    [sym_special_call] = STATE(984),
    [sym_prefix_cast] = STATE(984),
    [sym_unary_expr] = STATE(984),
    [sym_mul_expr] = STATE(984),
    [sym_add_expr] = STATE(984),
    [sym_in_expr] = STATE(984),
    [sym_comp_term] = STATE(984),
    [sym_instance_of] = STATE(984),
    [sym_negation] = STATE(984),
    [sym_if_term] = STATE(984),
    [sym_conjunction] = STATE(984),
    [sym_disjunction] = STATE(984),
    [sym_implication] = STATE(984),
    [sym_quantified] = STATE(984),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(984),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(445),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(447),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [106] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1899),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [107] = {
    [sym_special_call] = STATE(987),
    [sym_prefix_cast] = STATE(987),
    [sym_unary_expr] = STATE(987),
    [sym_mul_expr] = STATE(987),
    [sym_add_expr] = STATE(987),
    [sym_in_expr] = STATE(987),
    [sym_comp_term] = STATE(987),
    [sym_instance_of] = STATE(987),
    [sym_negation] = STATE(987),
    [sym_if_term] = STATE(987),
    [sym_conjunction] = STATE(987),
    [sym_disjunction] = STATE(987),
    [sym_implication] = STATE(987),
    [sym_quantified] = STATE(987),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(987),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(449),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(451),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [108] = {
    [sym_special_call] = STATE(958),
    [sym_prefix_cast] = STATE(958),
    [sym_unary_expr] = STATE(958),
    [sym_mul_expr] = STATE(958),
    [sym_add_expr] = STATE(958),
    [sym_in_expr] = STATE(958),
    [sym_comp_term] = STATE(958),
    [sym_instance_of] = STATE(958),
    [sym_negation] = STATE(958),
    [sym_if_term] = STATE(958),
    [sym_conjunction] = STATE(958),
    [sym_disjunction] = STATE(958),
    [sym_implication] = STATE(958),
    [sym_quantified] = STATE(958),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(958),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(453),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(455),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [109] = {
    [sym_special_call] = STATE(989),
    [sym_prefix_cast] = STATE(989),
    [sym_unary_expr] = STATE(989),
    [sym_mul_expr] = STATE(989),
    [sym_add_expr] = STATE(989),
    [sym_in_expr] = STATE(989),
    [sym_comp_term] = STATE(989),
    [sym_instance_of] = STATE(989),
    [sym_negation] = STATE(989),
    [sym_if_term] = STATE(989),
    [sym_conjunction] = STATE(989),
    [sym_disjunction] = STATE(989),
    [sym_implication] = STATE(989),
    [sym_quantified] = STATE(989),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(989),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(457),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(459),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [110] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_asExprs] = STATE(1703),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [111] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_asExprs] = STATE(1691),
    [sym_asExpr] = STATE(1562),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [112] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1977),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [113] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1984),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [114] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1814),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [115] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1912),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [116] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1923),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [117] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1924),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [118] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1909),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [119] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1933),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [120] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1934),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [121] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1941),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [122] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1942),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [123] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1945),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [124] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1969),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [125] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(2006),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [126] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1818),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [127] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1815),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [128] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1834),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [129] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1850),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [130] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1926),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [131] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1922),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [132] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1812),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [133] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1953),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [134] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1979),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [135] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1856),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [136] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1959),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [137] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1841),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [138] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1846),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [139] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1907),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [140] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1944),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [141] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1954),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [142] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1906),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [143] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1927),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [144] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1931),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [145] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1961),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [146] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1962),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [147] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExprs] = STATE(1971),
    [sym_asExpr] = STATE(1670),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [148] = {
    [sym_special_call] = STATE(1010),
    [sym_prefix_cast] = STATE(1010),
    [sym_unary_expr] = STATE(1010),
    [sym_mul_expr] = STATE(1010),
    [sym_add_expr] = STATE(1010),
    [sym_in_expr] = STATE(1010),
    [sym_comp_term] = STATE(1010),
    [sym_instance_of] = STATE(1010),
    [sym_negation] = STATE(1010),
    [sym_if_term] = STATE(1010),
    [sym_conjunction] = STATE(1010),
    [sym_disjunction] = STATE(1010),
    [sym_implication] = STATE(1010),
    [sym_quantified] = STATE(1010),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1010),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_RPAREN] = ACTIONS(461),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(463),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [149] = {
    [sym_special_call] = STATE(415),
    [sym_prefix_cast] = STATE(415),
    [sym_unary_expr] = STATE(415),
    [sym_mul_expr] = STATE(415),
    [sym_add_expr] = STATE(415),
    [sym_in_expr] = STATE(415),
    [sym_comp_term] = STATE(415),
    [sym_instance_of] = STATE(415),
    [sym_negation] = STATE(415),
    [sym_if_term] = STATE(415),
    [sym_conjunction] = STATE(415),
    [sym_disjunction] = STATE(415),
    [sym_implication] = STATE(415),
    [sym_quantified] = STATE(415),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(415),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_asExpr] = STATE(1080),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [150] = {
    [sym_special_call] = STATE(949),
    [sym_prefix_cast] = STATE(949),
    [sym_unary_expr] = STATE(949),
    [sym_mul_expr] = STATE(949),
    [sym_add_expr] = STATE(949),
    [sym_in_expr] = STATE(949),
    [sym_comp_term] = STATE(949),
    [sym_instance_of] = STATE(949),
    [sym_negation] = STATE(949),
    [sym_if_term] = STATE(949),
    [sym_conjunction] = STATE(949),
    [sym_disjunction] = STATE(949),
    [sym_implication] = STATE(949),
    [sym_quantified] = STATE(949),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(949),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(465),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [151] = {
    [sym_special_call] = STATE(367),
    [sym_prefix_cast] = STATE(367),
    [sym_unary_expr] = STATE(367),
    [sym_mul_expr] = STATE(367),
    [sym_add_expr] = STATE(367),
    [sym_in_expr] = STATE(367),
    [sym_comp_term] = STATE(367),
    [sym_instance_of] = STATE(367),
    [sym_negation] = STATE(367),
    [sym_if_term] = STATE(367),
    [sym_conjunction] = STATE(367),
    [sym_disjunction] = STATE(367),
    [sym_implication] = STATE(367),
    [sym_quantified] = STATE(367),
    [sym_quantifier] = STATE(1865),
    [sym_call_or_unqual_agg_expr] = STATE(517),
    [sym_qualified_expr] = STATE(517),
    [sym_super_ref] = STATE(517),
    [sym_aggregate] = STATE(517),
    [sym_range] = STATE(517),
    [sym_set_literal] = STATE(517),
    [sym_par_expr] = STATE(517),
    [sym_expr_annotation] = STATE(517),
    [sym__exprOrTerm] = STATE(367),
    [sym__primary] = STATE(517),
    [sym_literal] = STATE(517),
    [sym_bool] = STATE(513),
    [sym_variable] = STATE(517),
    [sym_unop] = STATE(297),
    [sym_orderBy] = STATE(1142),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2015),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(421),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1866),
    [sym_aritylessPredicateExpr] = STATE(1477),
    [sym_varName] = STATE(598),
    [sym_aggId] = STATE(1778),
    [sym__lower_id] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [sym_specialId] = ACTIONS(475),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(479),
    [sym_integer] = ACTIONS(481),
    [sym_float] = ACTIONS(483),
    [sym_string] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(485),
    [sym_result] = ACTIONS(487),
    [sym_super] = ACTIONS(489),
    [sym_this] = ACTIONS(487),
    [sym_true] = ACTIONS(485),
  },
  [152] = {
    [sym_special_call] = STATE(949),
    [sym_prefix_cast] = STATE(949),
    [sym_unary_expr] = STATE(949),
    [sym_mul_expr] = STATE(949),
    [sym_add_expr] = STATE(949),
    [sym_in_expr] = STATE(949),
    [sym_comp_term] = STATE(949),
    [sym_instance_of] = STATE(949),
    [sym_negation] = STATE(949),
    [sym_if_term] = STATE(949),
    [sym_conjunction] = STATE(949),
    [sym_disjunction] = STATE(949),
    [sym_implication] = STATE(949),
    [sym_quantified] = STATE(949),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(949),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(491),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [153] = {
    [sym_special_call] = STATE(385),
    [sym_prefix_cast] = STATE(385),
    [sym_unary_expr] = STATE(385),
    [sym_mul_expr] = STATE(385),
    [sym_add_expr] = STATE(385),
    [sym_in_expr] = STATE(385),
    [sym_comp_term] = STATE(385),
    [sym_instance_of] = STATE(385),
    [sym_negation] = STATE(385),
    [sym_if_term] = STATE(385),
    [sym_conjunction] = STATE(385),
    [sym_disjunction] = STATE(385),
    [sym_implication] = STATE(385),
    [sym_quantified] = STATE(385),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(385),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_asExpr] = STATE(1065),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(335),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(341),
    [sym_result] = ACTIONS(343),
    [sym_super] = ACTIONS(345),
    [sym_this] = ACTIONS(343),
    [sym_true] = ACTIONS(341),
  },
  [154] = {
    [sym_special_call] = STATE(949),
    [sym_prefix_cast] = STATE(949),
    [sym_unary_expr] = STATE(949),
    [sym_mul_expr] = STATE(949),
    [sym_add_expr] = STATE(949),
    [sym_in_expr] = STATE(949),
    [sym_comp_term] = STATE(949),
    [sym_instance_of] = STATE(949),
    [sym_negation] = STATE(949),
    [sym_if_term] = STATE(949),
    [sym_conjunction] = STATE(949),
    [sym_disjunction] = STATE(949),
    [sym_implication] = STATE(949),
    [sym_quantified] = STATE(949),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(949),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [155] = {
    [sym_special_call] = STATE(949),
    [sym_prefix_cast] = STATE(949),
    [sym_unary_expr] = STATE(949),
    [sym_mul_expr] = STATE(949),
    [sym_add_expr] = STATE(949),
    [sym_in_expr] = STATE(949),
    [sym_comp_term] = STATE(949),
    [sym_instance_of] = STATE(949),
    [sym_negation] = STATE(949),
    [sym_if_term] = STATE(949),
    [sym_conjunction] = STATE(949),
    [sym_disjunction] = STATE(949),
    [sym_implication] = STATE(949),
    [sym_quantified] = STATE(949),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(949),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(495),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [156] = {
    [sym_special_call] = STATE(949),
    [sym_prefix_cast] = STATE(949),
    [sym_unary_expr] = STATE(949),
    [sym_mul_expr] = STATE(949),
    [sym_add_expr] = STATE(949),
    [sym_in_expr] = STATE(949),
    [sym_comp_term] = STATE(949),
    [sym_instance_of] = STATE(949),
    [sym_negation] = STATE(949),
    [sym_if_term] = STATE(949),
    [sym_conjunction] = STATE(949),
    [sym_disjunction] = STATE(949),
    [sym_implication] = STATE(949),
    [sym_quantified] = STATE(949),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(949),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(497),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [157] = {
    [sym_special_call] = STATE(864),
    [sym_prefix_cast] = STATE(864),
    [sym_unary_expr] = STATE(864),
    [sym_mul_expr] = STATE(864),
    [sym_add_expr] = STATE(864),
    [sym_in_expr] = STATE(864),
    [sym_comp_term] = STATE(864),
    [sym_instance_of] = STATE(864),
    [sym_negation] = STATE(864),
    [sym_if_term] = STATE(864),
    [sym_conjunction] = STATE(864),
    [sym_disjunction] = STATE(864),
    [sym_implication] = STATE(864),
    [sym_quantified] = STATE(864),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(864),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_asExpr] = STATE(1657),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [158] = {
    [sym_special_call] = STATE(371),
    [sym_prefix_cast] = STATE(371),
    [sym_unary_expr] = STATE(371),
    [sym_mul_expr] = STATE(371),
    [sym_add_expr] = STATE(371),
    [sym_in_expr] = STATE(371),
    [sym_comp_term] = STATE(371),
    [sym_instance_of] = STATE(371),
    [sym_negation] = STATE(371),
    [sym_if_term] = STATE(371),
    [sym_conjunction] = STATE(371),
    [sym_disjunction] = STATE(371),
    [sym_implication] = STATE(371),
    [sym_quantified] = STATE(371),
    [sym_quantifier] = STATE(1919),
    [sym_call_or_unqual_agg_expr] = STATE(560),
    [sym_qualified_expr] = STATE(560),
    [sym_super_ref] = STATE(560),
    [sym_aggregate] = STATE(560),
    [sym_range] = STATE(560),
    [sym_set_literal] = STATE(560),
    [sym_par_expr] = STATE(560),
    [sym_expr_annotation] = STATE(560),
    [sym__exprOrTerm] = STATE(371),
    [sym__primary] = STATE(560),
    [sym_literal] = STATE(560),
    [sym_bool] = STATE(556),
    [sym_variable] = STATE(560),
    [sym_unop] = STATE(183),
    [sym_orderBy] = STATE(1073),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2017),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(420),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1920),
    [sym_aritylessPredicateExpr] = STATE(1484),
    [sym_varName] = STATE(558),
    [sym_aggId] = STATE(1789),
    [sym__lower_id] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(501),
    [anon_sym_not] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(505),
    [sym_specialId] = ACTIONS(507),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(511),
    [sym_integer] = ACTIONS(513),
    [sym_float] = ACTIONS(515),
    [sym_string] = ACTIONS(515),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(517),
    [sym_result] = ACTIONS(519),
    [sym_super] = ACTIONS(521),
    [sym_this] = ACTIONS(519),
    [sym_true] = ACTIONS(517),
  },
  [159] = {
    [sym_special_call] = STATE(949),
    [sym_prefix_cast] = STATE(949),
    [sym_unary_expr] = STATE(949),
    [sym_mul_expr] = STATE(949),
    [sym_add_expr] = STATE(949),
    [sym_in_expr] = STATE(949),
    [sym_comp_term] = STATE(949),
    [sym_instance_of] = STATE(949),
    [sym_negation] = STATE(949),
    [sym_if_term] = STATE(949),
    [sym_conjunction] = STATE(949),
    [sym_disjunction] = STATE(949),
    [sym_implication] = STATE(949),
    [sym_quantified] = STATE(949),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(949),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(523),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [160] = {
    [sym_special_call] = STATE(949),
    [sym_prefix_cast] = STATE(949),
    [sym_unary_expr] = STATE(949),
    [sym_mul_expr] = STATE(949),
    [sym_add_expr] = STATE(949),
    [sym_in_expr] = STATE(949),
    [sym_comp_term] = STATE(949),
    [sym_instance_of] = STATE(949),
    [sym_negation] = STATE(949),
    [sym_if_term] = STATE(949),
    [sym_conjunction] = STATE(949),
    [sym_disjunction] = STATE(949),
    [sym_implication] = STATE(949),
    [sym_quantified] = STATE(949),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(949),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(525),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [161] = {
    [sym_special_call] = STATE(949),
    [sym_prefix_cast] = STATE(949),
    [sym_unary_expr] = STATE(949),
    [sym_mul_expr] = STATE(949),
    [sym_add_expr] = STATE(949),
    [sym_in_expr] = STATE(949),
    [sym_comp_term] = STATE(949),
    [sym_instance_of] = STATE(949),
    [sym_negation] = STATE(949),
    [sym_if_term] = STATE(949),
    [sym_conjunction] = STATE(949),
    [sym_disjunction] = STATE(949),
    [sym_implication] = STATE(949),
    [sym_quantified] = STATE(949),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(949),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(527),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [162] = {
    [sym_special_call] = STATE(949),
    [sym_prefix_cast] = STATE(949),
    [sym_unary_expr] = STATE(949),
    [sym_mul_expr] = STATE(949),
    [sym_add_expr] = STATE(949),
    [sym_in_expr] = STATE(949),
    [sym_comp_term] = STATE(949),
    [sym_instance_of] = STATE(949),
    [sym_negation] = STATE(949),
    [sym_if_term] = STATE(949),
    [sym_conjunction] = STATE(949),
    [sym_disjunction] = STATE(949),
    [sym_implication] = STATE(949),
    [sym_quantified] = STATE(949),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(949),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(529),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [163] = {
    [sym_special_call] = STATE(367),
    [sym_prefix_cast] = STATE(367),
    [sym_unary_expr] = STATE(367),
    [sym_mul_expr] = STATE(367),
    [sym_add_expr] = STATE(367),
    [sym_in_expr] = STATE(367),
    [sym_comp_term] = STATE(367),
    [sym_instance_of] = STATE(367),
    [sym_negation] = STATE(367),
    [sym_if_term] = STATE(367),
    [sym_conjunction] = STATE(367),
    [sym_disjunction] = STATE(367),
    [sym_implication] = STATE(367),
    [sym_quantified] = STATE(367),
    [sym_quantifier] = STATE(1865),
    [sym_call_or_unqual_agg_expr] = STATE(517),
    [sym_qualified_expr] = STATE(517),
    [sym_super_ref] = STATE(517),
    [sym_aggregate] = STATE(517),
    [sym_range] = STATE(517),
    [sym_set_literal] = STATE(517),
    [sym_par_expr] = STATE(517),
    [sym_expr_annotation] = STATE(517),
    [sym__exprOrTerm] = STATE(367),
    [sym__primary] = STATE(517),
    [sym_literal] = STATE(517),
    [sym_bool] = STATE(513),
    [sym_variable] = STATE(517),
    [sym_unop] = STATE(297),
    [sym_orderBy] = STATE(1196),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2015),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(421),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1866),
    [sym_aritylessPredicateExpr] = STATE(1477),
    [sym_varName] = STATE(598),
    [sym_aggId] = STATE(1778),
    [sym__lower_id] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [sym_specialId] = ACTIONS(475),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(479),
    [sym_integer] = ACTIONS(481),
    [sym_float] = ACTIONS(483),
    [sym_string] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(485),
    [sym_result] = ACTIONS(487),
    [sym_super] = ACTIONS(489),
    [sym_this] = ACTIONS(487),
    [sym_true] = ACTIONS(485),
  },
  [164] = {
    [sym_special_call] = STATE(949),
    [sym_prefix_cast] = STATE(949),
    [sym_unary_expr] = STATE(949),
    [sym_mul_expr] = STATE(949),
    [sym_add_expr] = STATE(949),
    [sym_in_expr] = STATE(949),
    [sym_comp_term] = STATE(949),
    [sym_instance_of] = STATE(949),
    [sym_negation] = STATE(949),
    [sym_if_term] = STATE(949),
    [sym_conjunction] = STATE(949),
    [sym_disjunction] = STATE(949),
    [sym_implication] = STATE(949),
    [sym_quantified] = STATE(949),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(949),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(531),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [165] = {
    [sym_special_call] = STATE(371),
    [sym_prefix_cast] = STATE(371),
    [sym_unary_expr] = STATE(371),
    [sym_mul_expr] = STATE(371),
    [sym_add_expr] = STATE(371),
    [sym_in_expr] = STATE(371),
    [sym_comp_term] = STATE(371),
    [sym_instance_of] = STATE(371),
    [sym_negation] = STATE(371),
    [sym_if_term] = STATE(371),
    [sym_conjunction] = STATE(371),
    [sym_disjunction] = STATE(371),
    [sym_implication] = STATE(371),
    [sym_quantified] = STATE(371),
    [sym_quantifier] = STATE(1919),
    [sym_call_or_unqual_agg_expr] = STATE(560),
    [sym_qualified_expr] = STATE(560),
    [sym_super_ref] = STATE(560),
    [sym_aggregate] = STATE(560),
    [sym_range] = STATE(560),
    [sym_set_literal] = STATE(560),
    [sym_par_expr] = STATE(560),
    [sym_expr_annotation] = STATE(560),
    [sym__exprOrTerm] = STATE(371),
    [sym__primary] = STATE(560),
    [sym_literal] = STATE(560),
    [sym_bool] = STATE(556),
    [sym_variable] = STATE(560),
    [sym_unop] = STATE(183),
    [sym_orderBy] = STATE(1221),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2017),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(420),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1920),
    [sym_aritylessPredicateExpr] = STATE(1484),
    [sym_varName] = STATE(558),
    [sym_aggId] = STATE(1789),
    [sym__lower_id] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(501),
    [anon_sym_not] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(505),
    [sym_specialId] = ACTIONS(507),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(511),
    [sym_integer] = ACTIONS(513),
    [sym_float] = ACTIONS(515),
    [sym_string] = ACTIONS(515),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(517),
    [sym_result] = ACTIONS(519),
    [sym_super] = ACTIONS(521),
    [sym_this] = ACTIONS(519),
    [sym_true] = ACTIONS(517),
  },
  [166] = {
    [sym_special_call] = STATE(819),
    [sym_prefix_cast] = STATE(819),
    [sym_unary_expr] = STATE(819),
    [sym_mul_expr] = STATE(819),
    [sym_add_expr] = STATE(819),
    [sym_in_expr] = STATE(819),
    [sym_comp_term] = STATE(819),
    [sym_instance_of] = STATE(819),
    [sym_negation] = STATE(819),
    [sym_if_term] = STATE(819),
    [sym_conjunction] = STATE(819),
    [sym_disjunction] = STATE(819),
    [sym_implication] = STATE(819),
    [sym_quantified] = STATE(819),
    [sym_quantifier] = STATE(1892),
    [sym_call_or_unqual_agg_expr] = STATE(1014),
    [sym_qualified_expr] = STATE(1014),
    [sym_super_ref] = STATE(1014),
    [sym_aggregate] = STATE(1014),
    [sym_range] = STATE(1014),
    [sym_set_literal] = STATE(1014),
    [sym_par_expr] = STATE(1014),
    [sym_expr_annotation] = STATE(1014),
    [sym__exprOrTerm] = STATE(819),
    [sym__primary] = STATE(1014),
    [sym_literal] = STATE(1014),
    [sym_bool] = STATE(1007),
    [sym_variable] = STATE(1014),
    [sym_unop] = STATE(174),
    [sym_orderBy] = STATE(1781),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2016),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(871),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1893),
    [sym_aritylessPredicateExpr] = STATE(1475),
    [sym_varName] = STATE(1012),
    [sym_aggId] = STATE(1761),
    [sym__lower_id] = ACTIONS(533),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_not] = ACTIONS(537),
    [anon_sym_if] = ACTIONS(539),
    [sym_specialId] = ACTIONS(541),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(545),
    [sym_integer] = ACTIONS(547),
    [sym_float] = ACTIONS(549),
    [sym_string] = ACTIONS(549),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(551),
    [sym_result] = ACTIONS(553),
    [sym_super] = ACTIONS(555),
    [sym_this] = ACTIONS(553),
    [sym_true] = ACTIONS(551),
  },
  [167] = {
    [sym_special_call] = STATE(819),
    [sym_prefix_cast] = STATE(819),
    [sym_unary_expr] = STATE(819),
    [sym_mul_expr] = STATE(819),
    [sym_add_expr] = STATE(819),
    [sym_in_expr] = STATE(819),
    [sym_comp_term] = STATE(819),
    [sym_instance_of] = STATE(819),
    [sym_negation] = STATE(819),
    [sym_if_term] = STATE(819),
    [sym_conjunction] = STATE(819),
    [sym_disjunction] = STATE(819),
    [sym_implication] = STATE(819),
    [sym_quantified] = STATE(819),
    [sym_quantifier] = STATE(1892),
    [sym_call_or_unqual_agg_expr] = STATE(1014),
    [sym_qualified_expr] = STATE(1014),
    [sym_super_ref] = STATE(1014),
    [sym_aggregate] = STATE(1014),
    [sym_range] = STATE(1014),
    [sym_set_literal] = STATE(1014),
    [sym_par_expr] = STATE(1014),
    [sym_expr_annotation] = STATE(1014),
    [sym__exprOrTerm] = STATE(819),
    [sym__primary] = STATE(1014),
    [sym_literal] = STATE(1014),
    [sym_bool] = STATE(1007),
    [sym_variable] = STATE(1014),
    [sym_unop] = STATE(174),
    [sym_orderBy] = STATE(1708),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2016),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(871),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1893),
    [sym_aritylessPredicateExpr] = STATE(1475),
    [sym_varName] = STATE(1012),
    [sym_aggId] = STATE(1761),
    [sym__lower_id] = ACTIONS(533),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_not] = ACTIONS(537),
    [anon_sym_if] = ACTIONS(539),
    [sym_specialId] = ACTIONS(541),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(545),
    [sym_integer] = ACTIONS(547),
    [sym_float] = ACTIONS(549),
    [sym_string] = ACTIONS(549),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(551),
    [sym_result] = ACTIONS(553),
    [sym_super] = ACTIONS(555),
    [sym_this] = ACTIONS(553),
    [sym_true] = ACTIONS(551),
  },
  [168] = {
    [sym_special_call] = STATE(949),
    [sym_prefix_cast] = STATE(949),
    [sym_unary_expr] = STATE(949),
    [sym_mul_expr] = STATE(949),
    [sym_add_expr] = STATE(949),
    [sym_in_expr] = STATE(949),
    [sym_comp_term] = STATE(949),
    [sym_instance_of] = STATE(949),
    [sym_negation] = STATE(949),
    [sym_if_term] = STATE(949),
    [sym_conjunction] = STATE(949),
    [sym_disjunction] = STATE(949),
    [sym_implication] = STATE(949),
    [sym_quantified] = STATE(949),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(949),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(557),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [169] = {
    [sym_special_call] = STATE(949),
    [sym_prefix_cast] = STATE(949),
    [sym_unary_expr] = STATE(949),
    [sym_mul_expr] = STATE(949),
    [sym_add_expr] = STATE(949),
    [sym_in_expr] = STATE(949),
    [sym_comp_term] = STATE(949),
    [sym_instance_of] = STATE(949),
    [sym_negation] = STATE(949),
    [sym_if_term] = STATE(949),
    [sym_conjunction] = STATE(949),
    [sym_disjunction] = STATE(949),
    [sym_implication] = STATE(949),
    [sym_quantified] = STATE(949),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(949),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(559),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [170] = {
    [sym_special_call] = STATE(949),
    [sym_prefix_cast] = STATE(949),
    [sym_unary_expr] = STATE(949),
    [sym_mul_expr] = STATE(949),
    [sym_add_expr] = STATE(949),
    [sym_in_expr] = STATE(949),
    [sym_comp_term] = STATE(949),
    [sym_instance_of] = STATE(949),
    [sym_negation] = STATE(949),
    [sym_if_term] = STATE(949),
    [sym_conjunction] = STATE(949),
    [sym_disjunction] = STATE(949),
    [sym_implication] = STATE(949),
    [sym_quantified] = STATE(949),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(949),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(561),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [171] = {
    [sym_special_call] = STATE(847),
    [sym_prefix_cast] = STATE(847),
    [sym_unary_expr] = STATE(847),
    [sym_mul_expr] = STATE(847),
    [sym_add_expr] = STATE(847),
    [sym_in_expr] = STATE(847),
    [sym_comp_term] = STATE(847),
    [sym_instance_of] = STATE(847),
    [sym_negation] = STATE(847),
    [sym_if_term] = STATE(847),
    [sym_conjunction] = STATE(847),
    [sym_disjunction] = STATE(847),
    [sym_implication] = STATE(847),
    [sym_quantified] = STATE(847),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(847),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_asExpr] = STATE(1657),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [172] = {
    [sym_special_call] = STATE(949),
    [sym_prefix_cast] = STATE(949),
    [sym_unary_expr] = STATE(949),
    [sym_mul_expr] = STATE(949),
    [sym_add_expr] = STATE(949),
    [sym_in_expr] = STATE(949),
    [sym_comp_term] = STATE(949),
    [sym_instance_of] = STATE(949),
    [sym_negation] = STATE(949),
    [sym_if_term] = STATE(949),
    [sym_conjunction] = STATE(949),
    [sym_disjunction] = STATE(949),
    [sym_implication] = STATE(949),
    [sym_quantified] = STATE(949),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(949),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_RBRACK] = ACTIONS(563),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [173] = {
    [sym_special_call] = STATE(1162),
    [sym_prefix_cast] = STATE(1162),
    [sym_unary_expr] = STATE(1162),
    [sym_mul_expr] = STATE(1162),
    [sym_add_expr] = STATE(1162),
    [sym_in_expr] = STATE(1162),
    [sym_comp_term] = STATE(1162),
    [sym_instance_of] = STATE(1162),
    [sym_negation] = STATE(1162),
    [sym_if_term] = STATE(1162),
    [sym_conjunction] = STATE(1162),
    [sym_disjunction] = STATE(1162),
    [sym_implication] = STATE(1162),
    [sym_quantified] = STATE(1162),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1162),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [174] = {
    [sym_special_call] = STATE(821),
    [sym_prefix_cast] = STATE(821),
    [sym_unary_expr] = STATE(821),
    [sym_mul_expr] = STATE(821),
    [sym_add_expr] = STATE(821),
    [sym_in_expr] = STATE(821),
    [sym_comp_term] = STATE(821),
    [sym_instance_of] = STATE(821),
    [sym_negation] = STATE(821),
    [sym_if_term] = STATE(821),
    [sym_conjunction] = STATE(821),
    [sym_disjunction] = STATE(821),
    [sym_implication] = STATE(821),
    [sym_quantified] = STATE(821),
    [sym_quantifier] = STATE(1892),
    [sym_call_or_unqual_agg_expr] = STATE(1014),
    [sym_qualified_expr] = STATE(1014),
    [sym_super_ref] = STATE(1014),
    [sym_aggregate] = STATE(1014),
    [sym_range] = STATE(1014),
    [sym_set_literal] = STATE(1014),
    [sym_par_expr] = STATE(1014),
    [sym_expr_annotation] = STATE(1014),
    [sym__exprOrTerm] = STATE(821),
    [sym__primary] = STATE(1014),
    [sym_literal] = STATE(1014),
    [sym_bool] = STATE(1007),
    [sym_variable] = STATE(1014),
    [sym_unop] = STATE(174),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2016),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(871),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1893),
    [sym_aritylessPredicateExpr] = STATE(1475),
    [sym_varName] = STATE(1012),
    [sym_aggId] = STATE(1761),
    [sym__lower_id] = ACTIONS(533),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_not] = ACTIONS(537),
    [anon_sym_if] = ACTIONS(539),
    [sym_specialId] = ACTIONS(541),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(545),
    [sym_integer] = ACTIONS(547),
    [sym_float] = ACTIONS(549),
    [sym_string] = ACTIONS(549),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(551),
    [sym_result] = ACTIONS(553),
    [sym_super] = ACTIONS(555),
    [sym_this] = ACTIONS(553),
    [sym_true] = ACTIONS(551),
  },
  [175] = {
    [sym_special_call] = STATE(822),
    [sym_prefix_cast] = STATE(822),
    [sym_unary_expr] = STATE(822),
    [sym_mul_expr] = STATE(822),
    [sym_add_expr] = STATE(822),
    [sym_in_expr] = STATE(822),
    [sym_comp_term] = STATE(822),
    [sym_instance_of] = STATE(822),
    [sym_negation] = STATE(822),
    [sym_if_term] = STATE(822),
    [sym_conjunction] = STATE(822),
    [sym_disjunction] = STATE(822),
    [sym_implication] = STATE(822),
    [sym_quantified] = STATE(822),
    [sym_quantifier] = STATE(1892),
    [sym_call_or_unqual_agg_expr] = STATE(1014),
    [sym_qualified_expr] = STATE(1014),
    [sym_super_ref] = STATE(1014),
    [sym_aggregate] = STATE(1014),
    [sym_range] = STATE(1014),
    [sym_set_literal] = STATE(1014),
    [sym_par_expr] = STATE(1014),
    [sym_expr_annotation] = STATE(1014),
    [sym__exprOrTerm] = STATE(822),
    [sym__primary] = STATE(1014),
    [sym_literal] = STATE(1014),
    [sym_bool] = STATE(1007),
    [sym_variable] = STATE(1014),
    [sym_unop] = STATE(174),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2016),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(871),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1893),
    [sym_aritylessPredicateExpr] = STATE(1475),
    [sym_varName] = STATE(1012),
    [sym_aggId] = STATE(1761),
    [sym__lower_id] = ACTIONS(533),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_not] = ACTIONS(537),
    [anon_sym_if] = ACTIONS(539),
    [sym_specialId] = ACTIONS(541),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(545),
    [sym_integer] = ACTIONS(547),
    [sym_float] = ACTIONS(549),
    [sym_string] = ACTIONS(549),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(551),
    [sym_result] = ACTIONS(553),
    [sym_super] = ACTIONS(555),
    [sym_this] = ACTIONS(553),
    [sym_true] = ACTIONS(551),
  },
  [176] = {
    [sym_special_call] = STATE(823),
    [sym_prefix_cast] = STATE(823),
    [sym_unary_expr] = STATE(823),
    [sym_mul_expr] = STATE(823),
    [sym_add_expr] = STATE(823),
    [sym_in_expr] = STATE(823),
    [sym_comp_term] = STATE(823),
    [sym_instance_of] = STATE(823),
    [sym_negation] = STATE(823),
    [sym_if_term] = STATE(823),
    [sym_conjunction] = STATE(823),
    [sym_disjunction] = STATE(823),
    [sym_implication] = STATE(823),
    [sym_quantified] = STATE(823),
    [sym_quantifier] = STATE(1892),
    [sym_call_or_unqual_agg_expr] = STATE(1014),
    [sym_qualified_expr] = STATE(1014),
    [sym_super_ref] = STATE(1014),
    [sym_aggregate] = STATE(1014),
    [sym_range] = STATE(1014),
    [sym_set_literal] = STATE(1014),
    [sym_par_expr] = STATE(1014),
    [sym_expr_annotation] = STATE(1014),
    [sym__exprOrTerm] = STATE(823),
    [sym__primary] = STATE(1014),
    [sym_literal] = STATE(1014),
    [sym_bool] = STATE(1007),
    [sym_variable] = STATE(1014),
    [sym_unop] = STATE(174),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2016),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(871),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1893),
    [sym_aritylessPredicateExpr] = STATE(1475),
    [sym_varName] = STATE(1012),
    [sym_aggId] = STATE(1761),
    [sym__lower_id] = ACTIONS(533),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_not] = ACTIONS(537),
    [anon_sym_if] = ACTIONS(539),
    [sym_specialId] = ACTIONS(541),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(545),
    [sym_integer] = ACTIONS(547),
    [sym_float] = ACTIONS(549),
    [sym_string] = ACTIONS(549),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(551),
    [sym_result] = ACTIONS(553),
    [sym_super] = ACTIONS(555),
    [sym_this] = ACTIONS(553),
    [sym_true] = ACTIONS(551),
  },
  [177] = {
    [sym_special_call] = STATE(824),
    [sym_prefix_cast] = STATE(824),
    [sym_unary_expr] = STATE(824),
    [sym_mul_expr] = STATE(824),
    [sym_add_expr] = STATE(824),
    [sym_in_expr] = STATE(824),
    [sym_comp_term] = STATE(824),
    [sym_instance_of] = STATE(824),
    [sym_negation] = STATE(824),
    [sym_if_term] = STATE(824),
    [sym_conjunction] = STATE(824),
    [sym_disjunction] = STATE(824),
    [sym_implication] = STATE(824),
    [sym_quantified] = STATE(824),
    [sym_quantifier] = STATE(1892),
    [sym_call_or_unqual_agg_expr] = STATE(1014),
    [sym_qualified_expr] = STATE(1014),
    [sym_super_ref] = STATE(1014),
    [sym_aggregate] = STATE(1014),
    [sym_range] = STATE(1014),
    [sym_set_literal] = STATE(1014),
    [sym_par_expr] = STATE(1014),
    [sym_expr_annotation] = STATE(1014),
    [sym__exprOrTerm] = STATE(824),
    [sym__primary] = STATE(1014),
    [sym_literal] = STATE(1014),
    [sym_bool] = STATE(1007),
    [sym_variable] = STATE(1014),
    [sym_unop] = STATE(174),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2016),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(871),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1893),
    [sym_aritylessPredicateExpr] = STATE(1475),
    [sym_varName] = STATE(1012),
    [sym_aggId] = STATE(1761),
    [sym__lower_id] = ACTIONS(533),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_not] = ACTIONS(537),
    [anon_sym_if] = ACTIONS(539),
    [sym_specialId] = ACTIONS(541),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(545),
    [sym_integer] = ACTIONS(547),
    [sym_float] = ACTIONS(549),
    [sym_string] = ACTIONS(549),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(551),
    [sym_result] = ACTIONS(553),
    [sym_super] = ACTIONS(555),
    [sym_this] = ACTIONS(553),
    [sym_true] = ACTIONS(551),
  },
  [178] = {
    [sym_special_call] = STATE(825),
    [sym_prefix_cast] = STATE(825),
    [sym_unary_expr] = STATE(825),
    [sym_mul_expr] = STATE(825),
    [sym_add_expr] = STATE(825),
    [sym_in_expr] = STATE(825),
    [sym_comp_term] = STATE(825),
    [sym_instance_of] = STATE(825),
    [sym_negation] = STATE(825),
    [sym_if_term] = STATE(825),
    [sym_conjunction] = STATE(825),
    [sym_disjunction] = STATE(825),
    [sym_implication] = STATE(825),
    [sym_quantified] = STATE(825),
    [sym_quantifier] = STATE(1892),
    [sym_call_or_unqual_agg_expr] = STATE(1014),
    [sym_qualified_expr] = STATE(1014),
    [sym_super_ref] = STATE(1014),
    [sym_aggregate] = STATE(1014),
    [sym_range] = STATE(1014),
    [sym_set_literal] = STATE(1014),
    [sym_par_expr] = STATE(1014),
    [sym_expr_annotation] = STATE(1014),
    [sym__exprOrTerm] = STATE(825),
    [sym__primary] = STATE(1014),
    [sym_literal] = STATE(1014),
    [sym_bool] = STATE(1007),
    [sym_variable] = STATE(1014),
    [sym_unop] = STATE(174),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2016),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(871),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1893),
    [sym_aritylessPredicateExpr] = STATE(1475),
    [sym_varName] = STATE(1012),
    [sym_aggId] = STATE(1761),
    [sym__lower_id] = ACTIONS(533),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_not] = ACTIONS(537),
    [anon_sym_if] = ACTIONS(539),
    [sym_specialId] = ACTIONS(541),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(545),
    [sym_integer] = ACTIONS(547),
    [sym_float] = ACTIONS(549),
    [sym_string] = ACTIONS(549),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(551),
    [sym_result] = ACTIONS(553),
    [sym_super] = ACTIONS(555),
    [sym_this] = ACTIONS(553),
    [sym_true] = ACTIONS(551),
  },
  [179] = {
    [sym_special_call] = STATE(826),
    [sym_prefix_cast] = STATE(826),
    [sym_unary_expr] = STATE(826),
    [sym_mul_expr] = STATE(826),
    [sym_add_expr] = STATE(826),
    [sym_in_expr] = STATE(826),
    [sym_comp_term] = STATE(826),
    [sym_instance_of] = STATE(826),
    [sym_negation] = STATE(826),
    [sym_if_term] = STATE(826),
    [sym_conjunction] = STATE(826),
    [sym_disjunction] = STATE(826),
    [sym_implication] = STATE(826),
    [sym_quantified] = STATE(826),
    [sym_quantifier] = STATE(1892),
    [sym_call_or_unqual_agg_expr] = STATE(1014),
    [sym_qualified_expr] = STATE(1014),
    [sym_super_ref] = STATE(1014),
    [sym_aggregate] = STATE(1014),
    [sym_range] = STATE(1014),
    [sym_set_literal] = STATE(1014),
    [sym_par_expr] = STATE(1014),
    [sym_expr_annotation] = STATE(1014),
    [sym__exprOrTerm] = STATE(826),
    [sym__primary] = STATE(1014),
    [sym_literal] = STATE(1014),
    [sym_bool] = STATE(1007),
    [sym_variable] = STATE(1014),
    [sym_unop] = STATE(174),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2016),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(871),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1893),
    [sym_aritylessPredicateExpr] = STATE(1475),
    [sym_varName] = STATE(1012),
    [sym_aggId] = STATE(1761),
    [sym__lower_id] = ACTIONS(533),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_not] = ACTIONS(537),
    [anon_sym_if] = ACTIONS(539),
    [sym_specialId] = ACTIONS(541),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(545),
    [sym_integer] = ACTIONS(547),
    [sym_float] = ACTIONS(549),
    [sym_string] = ACTIONS(549),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(551),
    [sym_result] = ACTIONS(553),
    [sym_super] = ACTIONS(555),
    [sym_this] = ACTIONS(553),
    [sym_true] = ACTIONS(551),
  },
  [180] = {
    [sym_special_call] = STATE(827),
    [sym_prefix_cast] = STATE(827),
    [sym_unary_expr] = STATE(827),
    [sym_mul_expr] = STATE(827),
    [sym_add_expr] = STATE(827),
    [sym_in_expr] = STATE(827),
    [sym_comp_term] = STATE(827),
    [sym_instance_of] = STATE(827),
    [sym_negation] = STATE(827),
    [sym_if_term] = STATE(827),
    [sym_conjunction] = STATE(827),
    [sym_disjunction] = STATE(827),
    [sym_implication] = STATE(827),
    [sym_quantified] = STATE(827),
    [sym_quantifier] = STATE(1892),
    [sym_call_or_unqual_agg_expr] = STATE(1014),
    [sym_qualified_expr] = STATE(1014),
    [sym_super_ref] = STATE(1014),
    [sym_aggregate] = STATE(1014),
    [sym_range] = STATE(1014),
    [sym_set_literal] = STATE(1014),
    [sym_par_expr] = STATE(1014),
    [sym_expr_annotation] = STATE(1014),
    [sym__exprOrTerm] = STATE(827),
    [sym__primary] = STATE(1014),
    [sym_literal] = STATE(1014),
    [sym_bool] = STATE(1007),
    [sym_variable] = STATE(1014),
    [sym_unop] = STATE(174),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2016),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(871),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1893),
    [sym_aritylessPredicateExpr] = STATE(1475),
    [sym_varName] = STATE(1012),
    [sym_aggId] = STATE(1761),
    [sym__lower_id] = ACTIONS(533),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_not] = ACTIONS(537),
    [anon_sym_if] = ACTIONS(539),
    [sym_specialId] = ACTIONS(541),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(545),
    [sym_integer] = ACTIONS(547),
    [sym_float] = ACTIONS(549),
    [sym_string] = ACTIONS(549),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(551),
    [sym_result] = ACTIONS(553),
    [sym_super] = ACTIONS(555),
    [sym_this] = ACTIONS(553),
    [sym_true] = ACTIONS(551),
  },
  [181] = {
    [sym_special_call] = STATE(828),
    [sym_prefix_cast] = STATE(828),
    [sym_unary_expr] = STATE(828),
    [sym_mul_expr] = STATE(828),
    [sym_add_expr] = STATE(828),
    [sym_in_expr] = STATE(828),
    [sym_comp_term] = STATE(828),
    [sym_instance_of] = STATE(828),
    [sym_negation] = STATE(828),
    [sym_if_term] = STATE(828),
    [sym_conjunction] = STATE(828),
    [sym_disjunction] = STATE(828),
    [sym_implication] = STATE(828),
    [sym_quantified] = STATE(828),
    [sym_quantifier] = STATE(1892),
    [sym_call_or_unqual_agg_expr] = STATE(1014),
    [sym_qualified_expr] = STATE(1014),
    [sym_super_ref] = STATE(1014),
    [sym_aggregate] = STATE(1014),
    [sym_range] = STATE(1014),
    [sym_set_literal] = STATE(1014),
    [sym_par_expr] = STATE(1014),
    [sym_expr_annotation] = STATE(1014),
    [sym__exprOrTerm] = STATE(828),
    [sym__primary] = STATE(1014),
    [sym_literal] = STATE(1014),
    [sym_bool] = STATE(1007),
    [sym_variable] = STATE(1014),
    [sym_unop] = STATE(174),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2016),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(871),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1893),
    [sym_aritylessPredicateExpr] = STATE(1475),
    [sym_varName] = STATE(1012),
    [sym_aggId] = STATE(1761),
    [sym__lower_id] = ACTIONS(533),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_not] = ACTIONS(537),
    [anon_sym_if] = ACTIONS(539),
    [sym_specialId] = ACTIONS(541),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(545),
    [sym_integer] = ACTIONS(547),
    [sym_float] = ACTIONS(549),
    [sym_string] = ACTIONS(549),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(551),
    [sym_result] = ACTIONS(553),
    [sym_super] = ACTIONS(555),
    [sym_this] = ACTIONS(553),
    [sym_true] = ACTIONS(551),
  },
  [182] = {
    [sym_special_call] = STATE(829),
    [sym_prefix_cast] = STATE(829),
    [sym_unary_expr] = STATE(829),
    [sym_mul_expr] = STATE(829),
    [sym_add_expr] = STATE(829),
    [sym_in_expr] = STATE(829),
    [sym_comp_term] = STATE(829),
    [sym_instance_of] = STATE(829),
    [sym_negation] = STATE(829),
    [sym_if_term] = STATE(829),
    [sym_conjunction] = STATE(829),
    [sym_disjunction] = STATE(829),
    [sym_implication] = STATE(829),
    [sym_quantified] = STATE(829),
    [sym_quantifier] = STATE(1892),
    [sym_call_or_unqual_agg_expr] = STATE(1014),
    [sym_qualified_expr] = STATE(1014),
    [sym_super_ref] = STATE(1014),
    [sym_aggregate] = STATE(1014),
    [sym_range] = STATE(1014),
    [sym_set_literal] = STATE(1014),
    [sym_par_expr] = STATE(1014),
    [sym_expr_annotation] = STATE(1014),
    [sym__exprOrTerm] = STATE(829),
    [sym__primary] = STATE(1014),
    [sym_literal] = STATE(1014),
    [sym_bool] = STATE(1007),
    [sym_variable] = STATE(1014),
    [sym_unop] = STATE(174),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2016),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(871),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1893),
    [sym_aritylessPredicateExpr] = STATE(1475),
    [sym_varName] = STATE(1012),
    [sym_aggId] = STATE(1761),
    [sym__lower_id] = ACTIONS(533),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_not] = ACTIONS(537),
    [anon_sym_if] = ACTIONS(539),
    [sym_specialId] = ACTIONS(541),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(545),
    [sym_integer] = ACTIONS(547),
    [sym_float] = ACTIONS(549),
    [sym_string] = ACTIONS(549),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(551),
    [sym_result] = ACTIONS(553),
    [sym_super] = ACTIONS(555),
    [sym_this] = ACTIONS(553),
    [sym_true] = ACTIONS(551),
  },
  [183] = {
    [sym_special_call] = STATE(376),
    [sym_prefix_cast] = STATE(376),
    [sym_unary_expr] = STATE(376),
    [sym_mul_expr] = STATE(376),
    [sym_add_expr] = STATE(376),
    [sym_in_expr] = STATE(376),
    [sym_comp_term] = STATE(376),
    [sym_instance_of] = STATE(376),
    [sym_negation] = STATE(376),
    [sym_if_term] = STATE(376),
    [sym_conjunction] = STATE(376),
    [sym_disjunction] = STATE(376),
    [sym_implication] = STATE(376),
    [sym_quantified] = STATE(376),
    [sym_quantifier] = STATE(1919),
    [sym_call_or_unqual_agg_expr] = STATE(560),
    [sym_qualified_expr] = STATE(560),
    [sym_super_ref] = STATE(560),
    [sym_aggregate] = STATE(560),
    [sym_range] = STATE(560),
    [sym_set_literal] = STATE(560),
    [sym_par_expr] = STATE(560),
    [sym_expr_annotation] = STATE(560),
    [sym__exprOrTerm] = STATE(376),
    [sym__primary] = STATE(560),
    [sym_literal] = STATE(560),
    [sym_bool] = STATE(556),
    [sym_variable] = STATE(560),
    [sym_unop] = STATE(183),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2017),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(420),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1920),
    [sym_aritylessPredicateExpr] = STATE(1484),
    [sym_varName] = STATE(558),
    [sym_aggId] = STATE(1789),
    [sym__lower_id] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(501),
    [anon_sym_not] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(505),
    [sym_specialId] = ACTIONS(507),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(511),
    [sym_integer] = ACTIONS(513),
    [sym_float] = ACTIONS(515),
    [sym_string] = ACTIONS(515),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(517),
    [sym_result] = ACTIONS(519),
    [sym_super] = ACTIONS(521),
    [sym_this] = ACTIONS(519),
    [sym_true] = ACTIONS(517),
  },
  [184] = {
    [sym_special_call] = STATE(394),
    [sym_prefix_cast] = STATE(394),
    [sym_unary_expr] = STATE(394),
    [sym_mul_expr] = STATE(394),
    [sym_add_expr] = STATE(394),
    [sym_in_expr] = STATE(394),
    [sym_comp_term] = STATE(394),
    [sym_instance_of] = STATE(394),
    [sym_negation] = STATE(394),
    [sym_if_term] = STATE(394),
    [sym_conjunction] = STATE(394),
    [sym_disjunction] = STATE(394),
    [sym_implication] = STATE(394),
    [sym_quantified] = STATE(394),
    [sym_quantifier] = STATE(1919),
    [sym_call_or_unqual_agg_expr] = STATE(560),
    [sym_qualified_expr] = STATE(560),
    [sym_super_ref] = STATE(560),
    [sym_aggregate] = STATE(560),
    [sym_range] = STATE(560),
    [sym_set_literal] = STATE(560),
    [sym_par_expr] = STATE(560),
    [sym_expr_annotation] = STATE(560),
    [sym__exprOrTerm] = STATE(394),
    [sym__primary] = STATE(560),
    [sym_literal] = STATE(560),
    [sym_bool] = STATE(556),
    [sym_variable] = STATE(560),
    [sym_unop] = STATE(183),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2017),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(420),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1920),
    [sym_aritylessPredicateExpr] = STATE(1484),
    [sym_varName] = STATE(558),
    [sym_aggId] = STATE(1789),
    [sym__lower_id] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(501),
    [anon_sym_not] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(505),
    [sym_specialId] = ACTIONS(507),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(511),
    [sym_integer] = ACTIONS(513),
    [sym_float] = ACTIONS(515),
    [sym_string] = ACTIONS(515),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(517),
    [sym_result] = ACTIONS(519),
    [sym_super] = ACTIONS(521),
    [sym_this] = ACTIONS(519),
    [sym_true] = ACTIONS(517),
  },
  [185] = {
    [sym_special_call] = STATE(398),
    [sym_prefix_cast] = STATE(398),
    [sym_unary_expr] = STATE(398),
    [sym_mul_expr] = STATE(398),
    [sym_add_expr] = STATE(398),
    [sym_in_expr] = STATE(398),
    [sym_comp_term] = STATE(398),
    [sym_instance_of] = STATE(398),
    [sym_negation] = STATE(398),
    [sym_if_term] = STATE(398),
    [sym_conjunction] = STATE(398),
    [sym_disjunction] = STATE(398),
    [sym_implication] = STATE(398),
    [sym_quantified] = STATE(398),
    [sym_quantifier] = STATE(1919),
    [sym_call_or_unqual_agg_expr] = STATE(560),
    [sym_qualified_expr] = STATE(560),
    [sym_super_ref] = STATE(560),
    [sym_aggregate] = STATE(560),
    [sym_range] = STATE(560),
    [sym_set_literal] = STATE(560),
    [sym_par_expr] = STATE(560),
    [sym_expr_annotation] = STATE(560),
    [sym__exprOrTerm] = STATE(398),
    [sym__primary] = STATE(560),
    [sym_literal] = STATE(560),
    [sym_bool] = STATE(556),
    [sym_variable] = STATE(560),
    [sym_unop] = STATE(183),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2017),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(420),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1920),
    [sym_aritylessPredicateExpr] = STATE(1484),
    [sym_varName] = STATE(558),
    [sym_aggId] = STATE(1789),
    [sym__lower_id] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(501),
    [anon_sym_not] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(505),
    [sym_specialId] = ACTIONS(507),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(511),
    [sym_integer] = ACTIONS(513),
    [sym_float] = ACTIONS(515),
    [sym_string] = ACTIONS(515),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(517),
    [sym_result] = ACTIONS(519),
    [sym_super] = ACTIONS(521),
    [sym_this] = ACTIONS(519),
    [sym_true] = ACTIONS(517),
  },
  [186] = {
    [sym_special_call] = STATE(406),
    [sym_prefix_cast] = STATE(406),
    [sym_unary_expr] = STATE(406),
    [sym_mul_expr] = STATE(406),
    [sym_add_expr] = STATE(406),
    [sym_in_expr] = STATE(406),
    [sym_comp_term] = STATE(406),
    [sym_instance_of] = STATE(406),
    [sym_negation] = STATE(406),
    [sym_if_term] = STATE(406),
    [sym_conjunction] = STATE(406),
    [sym_disjunction] = STATE(406),
    [sym_implication] = STATE(406),
    [sym_quantified] = STATE(406),
    [sym_quantifier] = STATE(1919),
    [sym_call_or_unqual_agg_expr] = STATE(560),
    [sym_qualified_expr] = STATE(560),
    [sym_super_ref] = STATE(560),
    [sym_aggregate] = STATE(560),
    [sym_range] = STATE(560),
    [sym_set_literal] = STATE(560),
    [sym_par_expr] = STATE(560),
    [sym_expr_annotation] = STATE(560),
    [sym__exprOrTerm] = STATE(406),
    [sym__primary] = STATE(560),
    [sym_literal] = STATE(560),
    [sym_bool] = STATE(556),
    [sym_variable] = STATE(560),
    [sym_unop] = STATE(183),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2017),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(420),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1920),
    [sym_aritylessPredicateExpr] = STATE(1484),
    [sym_varName] = STATE(558),
    [sym_aggId] = STATE(1789),
    [sym__lower_id] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(501),
    [anon_sym_not] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(505),
    [sym_specialId] = ACTIONS(507),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(511),
    [sym_integer] = ACTIONS(513),
    [sym_float] = ACTIONS(515),
    [sym_string] = ACTIONS(515),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(517),
    [sym_result] = ACTIONS(519),
    [sym_super] = ACTIONS(521),
    [sym_this] = ACTIONS(519),
    [sym_true] = ACTIONS(517),
  },
  [187] = {
    [sym_special_call] = STATE(411),
    [sym_prefix_cast] = STATE(411),
    [sym_unary_expr] = STATE(411),
    [sym_mul_expr] = STATE(411),
    [sym_add_expr] = STATE(411),
    [sym_in_expr] = STATE(411),
    [sym_comp_term] = STATE(411),
    [sym_instance_of] = STATE(411),
    [sym_negation] = STATE(411),
    [sym_if_term] = STATE(411),
    [sym_conjunction] = STATE(411),
    [sym_disjunction] = STATE(411),
    [sym_implication] = STATE(411),
    [sym_quantified] = STATE(411),
    [sym_quantifier] = STATE(1919),
    [sym_call_or_unqual_agg_expr] = STATE(560),
    [sym_qualified_expr] = STATE(560),
    [sym_super_ref] = STATE(560),
    [sym_aggregate] = STATE(560),
    [sym_range] = STATE(560),
    [sym_set_literal] = STATE(560),
    [sym_par_expr] = STATE(560),
    [sym_expr_annotation] = STATE(560),
    [sym__exprOrTerm] = STATE(411),
    [sym__primary] = STATE(560),
    [sym_literal] = STATE(560),
    [sym_bool] = STATE(556),
    [sym_variable] = STATE(560),
    [sym_unop] = STATE(183),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2017),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(420),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1920),
    [sym_aritylessPredicateExpr] = STATE(1484),
    [sym_varName] = STATE(558),
    [sym_aggId] = STATE(1789),
    [sym__lower_id] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(501),
    [anon_sym_not] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(505),
    [sym_specialId] = ACTIONS(507),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(511),
    [sym_integer] = ACTIONS(513),
    [sym_float] = ACTIONS(515),
    [sym_string] = ACTIONS(515),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(517),
    [sym_result] = ACTIONS(519),
    [sym_super] = ACTIONS(521),
    [sym_this] = ACTIONS(519),
    [sym_true] = ACTIONS(517),
  },
  [188] = {
    [sym_special_call] = STATE(392),
    [sym_prefix_cast] = STATE(392),
    [sym_unary_expr] = STATE(392),
    [sym_mul_expr] = STATE(392),
    [sym_add_expr] = STATE(392),
    [sym_in_expr] = STATE(392),
    [sym_comp_term] = STATE(392),
    [sym_instance_of] = STATE(392),
    [sym_negation] = STATE(392),
    [sym_if_term] = STATE(392),
    [sym_conjunction] = STATE(392),
    [sym_disjunction] = STATE(392),
    [sym_implication] = STATE(392),
    [sym_quantified] = STATE(392),
    [sym_quantifier] = STATE(1919),
    [sym_call_or_unqual_agg_expr] = STATE(560),
    [sym_qualified_expr] = STATE(560),
    [sym_super_ref] = STATE(560),
    [sym_aggregate] = STATE(560),
    [sym_range] = STATE(560),
    [sym_set_literal] = STATE(560),
    [sym_par_expr] = STATE(560),
    [sym_expr_annotation] = STATE(560),
    [sym__exprOrTerm] = STATE(392),
    [sym__primary] = STATE(560),
    [sym_literal] = STATE(560),
    [sym_bool] = STATE(556),
    [sym_variable] = STATE(560),
    [sym_unop] = STATE(183),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2017),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(420),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1920),
    [sym_aritylessPredicateExpr] = STATE(1484),
    [sym_varName] = STATE(558),
    [sym_aggId] = STATE(1789),
    [sym__lower_id] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(501),
    [anon_sym_not] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(505),
    [sym_specialId] = ACTIONS(507),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(511),
    [sym_integer] = ACTIONS(513),
    [sym_float] = ACTIONS(515),
    [sym_string] = ACTIONS(515),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(517),
    [sym_result] = ACTIONS(519),
    [sym_super] = ACTIONS(521),
    [sym_this] = ACTIONS(519),
    [sym_true] = ACTIONS(517),
  },
  [189] = {
    [sym_special_call] = STATE(396),
    [sym_prefix_cast] = STATE(396),
    [sym_unary_expr] = STATE(396),
    [sym_mul_expr] = STATE(396),
    [sym_add_expr] = STATE(396),
    [sym_in_expr] = STATE(396),
    [sym_comp_term] = STATE(396),
    [sym_instance_of] = STATE(396),
    [sym_negation] = STATE(396),
    [sym_if_term] = STATE(396),
    [sym_conjunction] = STATE(396),
    [sym_disjunction] = STATE(396),
    [sym_implication] = STATE(396),
    [sym_quantified] = STATE(396),
    [sym_quantifier] = STATE(1919),
    [sym_call_or_unqual_agg_expr] = STATE(560),
    [sym_qualified_expr] = STATE(560),
    [sym_super_ref] = STATE(560),
    [sym_aggregate] = STATE(560),
    [sym_range] = STATE(560),
    [sym_set_literal] = STATE(560),
    [sym_par_expr] = STATE(560),
    [sym_expr_annotation] = STATE(560),
    [sym__exprOrTerm] = STATE(396),
    [sym__primary] = STATE(560),
    [sym_literal] = STATE(560),
    [sym_bool] = STATE(556),
    [sym_variable] = STATE(560),
    [sym_unop] = STATE(183),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2017),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(420),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1920),
    [sym_aritylessPredicateExpr] = STATE(1484),
    [sym_varName] = STATE(558),
    [sym_aggId] = STATE(1789),
    [sym__lower_id] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(501),
    [anon_sym_not] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(505),
    [sym_specialId] = ACTIONS(507),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(511),
    [sym_integer] = ACTIONS(513),
    [sym_float] = ACTIONS(515),
    [sym_string] = ACTIONS(515),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(517),
    [sym_result] = ACTIONS(519),
    [sym_super] = ACTIONS(521),
    [sym_this] = ACTIONS(519),
    [sym_true] = ACTIONS(517),
  },
  [190] = {
    [sym_special_call] = STATE(377),
    [sym_prefix_cast] = STATE(377),
    [sym_unary_expr] = STATE(377),
    [sym_mul_expr] = STATE(377),
    [sym_add_expr] = STATE(377),
    [sym_in_expr] = STATE(377),
    [sym_comp_term] = STATE(377),
    [sym_instance_of] = STATE(377),
    [sym_negation] = STATE(377),
    [sym_if_term] = STATE(377),
    [sym_conjunction] = STATE(377),
    [sym_disjunction] = STATE(377),
    [sym_implication] = STATE(377),
    [sym_quantified] = STATE(377),
    [sym_quantifier] = STATE(1919),
    [sym_call_or_unqual_agg_expr] = STATE(560),
    [sym_qualified_expr] = STATE(560),
    [sym_super_ref] = STATE(560),
    [sym_aggregate] = STATE(560),
    [sym_range] = STATE(560),
    [sym_set_literal] = STATE(560),
    [sym_par_expr] = STATE(560),
    [sym_expr_annotation] = STATE(560),
    [sym__exprOrTerm] = STATE(377),
    [sym__primary] = STATE(560),
    [sym_literal] = STATE(560),
    [sym_bool] = STATE(556),
    [sym_variable] = STATE(560),
    [sym_unop] = STATE(183),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2017),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(420),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1920),
    [sym_aritylessPredicateExpr] = STATE(1484),
    [sym_varName] = STATE(558),
    [sym_aggId] = STATE(1789),
    [sym__lower_id] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(501),
    [anon_sym_not] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(505),
    [sym_specialId] = ACTIONS(507),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(511),
    [sym_integer] = ACTIONS(513),
    [sym_float] = ACTIONS(515),
    [sym_string] = ACTIONS(515),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(517),
    [sym_result] = ACTIONS(519),
    [sym_super] = ACTIONS(521),
    [sym_this] = ACTIONS(519),
    [sym_true] = ACTIONS(517),
  },
  [191] = {
    [sym_special_call] = STATE(395),
    [sym_prefix_cast] = STATE(395),
    [sym_unary_expr] = STATE(395),
    [sym_mul_expr] = STATE(395),
    [sym_add_expr] = STATE(395),
    [sym_in_expr] = STATE(395),
    [sym_comp_term] = STATE(395),
    [sym_instance_of] = STATE(395),
    [sym_negation] = STATE(395),
    [sym_if_term] = STATE(395),
    [sym_conjunction] = STATE(395),
    [sym_disjunction] = STATE(395),
    [sym_implication] = STATE(395),
    [sym_quantified] = STATE(395),
    [sym_quantifier] = STATE(1919),
    [sym_call_or_unqual_agg_expr] = STATE(560),
    [sym_qualified_expr] = STATE(560),
    [sym_super_ref] = STATE(560),
    [sym_aggregate] = STATE(560),
    [sym_range] = STATE(560),
    [sym_set_literal] = STATE(560),
    [sym_par_expr] = STATE(560),
    [sym_expr_annotation] = STATE(560),
    [sym__exprOrTerm] = STATE(395),
    [sym__primary] = STATE(560),
    [sym_literal] = STATE(560),
    [sym_bool] = STATE(556),
    [sym_variable] = STATE(560),
    [sym_unop] = STATE(183),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2017),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(420),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1920),
    [sym_aritylessPredicateExpr] = STATE(1484),
    [sym_varName] = STATE(558),
    [sym_aggId] = STATE(1789),
    [sym__lower_id] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(501),
    [anon_sym_not] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(505),
    [sym_specialId] = ACTIONS(507),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(511),
    [sym_integer] = ACTIONS(513),
    [sym_float] = ACTIONS(515),
    [sym_string] = ACTIONS(515),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(517),
    [sym_result] = ACTIONS(519),
    [sym_super] = ACTIONS(521),
    [sym_this] = ACTIONS(519),
    [sym_true] = ACTIONS(517),
  },
  [192] = {
    [sym_special_call] = STATE(791),
    [sym_prefix_cast] = STATE(791),
    [sym_unary_expr] = STATE(791),
    [sym_mul_expr] = STATE(791),
    [sym_add_expr] = STATE(791),
    [sym_in_expr] = STATE(791),
    [sym_comp_term] = STATE(791),
    [sym_instance_of] = STATE(791),
    [sym_negation] = STATE(791),
    [sym_if_term] = STATE(791),
    [sym_conjunction] = STATE(791),
    [sym_disjunction] = STATE(791),
    [sym_implication] = STATE(791),
    [sym_quantified] = STATE(791),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(791),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [193] = {
    [sym_special_call] = STATE(403),
    [sym_prefix_cast] = STATE(403),
    [sym_unary_expr] = STATE(403),
    [sym_mul_expr] = STATE(403),
    [sym_add_expr] = STATE(403),
    [sym_in_expr] = STATE(403),
    [sym_comp_term] = STATE(403),
    [sym_instance_of] = STATE(403),
    [sym_negation] = STATE(403),
    [sym_if_term] = STATE(403),
    [sym_conjunction] = STATE(403),
    [sym_disjunction] = STATE(403),
    [sym_implication] = STATE(403),
    [sym_quantified] = STATE(403),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(403),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [194] = {
    [sym_special_call] = STATE(1037),
    [sym_prefix_cast] = STATE(1037),
    [sym_unary_expr] = STATE(1037),
    [sym_mul_expr] = STATE(1037),
    [sym_add_expr] = STATE(1037),
    [sym_in_expr] = STATE(1037),
    [sym_comp_term] = STATE(1037),
    [sym_instance_of] = STATE(1037),
    [sym_negation] = STATE(1037),
    [sym_if_term] = STATE(1037),
    [sym_conjunction] = STATE(1037),
    [sym_disjunction] = STATE(1037),
    [sym_implication] = STATE(1037),
    [sym_quantified] = STATE(1037),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1037),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [195] = {
    [sym_special_call] = STATE(1153),
    [sym_prefix_cast] = STATE(1153),
    [sym_unary_expr] = STATE(1153),
    [sym_mul_expr] = STATE(1153),
    [sym_add_expr] = STATE(1153),
    [sym_in_expr] = STATE(1153),
    [sym_comp_term] = STATE(1153),
    [sym_instance_of] = STATE(1153),
    [sym_negation] = STATE(1153),
    [sym_if_term] = STATE(1153),
    [sym_conjunction] = STATE(1153),
    [sym_disjunction] = STATE(1153),
    [sym_implication] = STATE(1153),
    [sym_quantified] = STATE(1153),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1153),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [196] = {
    [sym_special_call] = STATE(799),
    [sym_prefix_cast] = STATE(799),
    [sym_unary_expr] = STATE(799),
    [sym_mul_expr] = STATE(799),
    [sym_add_expr] = STATE(799),
    [sym_in_expr] = STATE(799),
    [sym_comp_term] = STATE(799),
    [sym_instance_of] = STATE(799),
    [sym_negation] = STATE(799),
    [sym_if_term] = STATE(799),
    [sym_conjunction] = STATE(799),
    [sym_disjunction] = STATE(799),
    [sym_implication] = STATE(799),
    [sym_quantified] = STATE(799),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(799),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [197] = {
    [sym_special_call] = STATE(805),
    [sym_prefix_cast] = STATE(805),
    [sym_unary_expr] = STATE(805),
    [sym_mul_expr] = STATE(805),
    [sym_add_expr] = STATE(805),
    [sym_in_expr] = STATE(805),
    [sym_comp_term] = STATE(805),
    [sym_instance_of] = STATE(805),
    [sym_negation] = STATE(805),
    [sym_if_term] = STATE(805),
    [sym_conjunction] = STATE(805),
    [sym_disjunction] = STATE(805),
    [sym_implication] = STATE(805),
    [sym_quantified] = STATE(805),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(805),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [198] = {
    [sym_special_call] = STATE(402),
    [sym_prefix_cast] = STATE(402),
    [sym_unary_expr] = STATE(402),
    [sym_mul_expr] = STATE(402),
    [sym_add_expr] = STATE(402),
    [sym_in_expr] = STATE(402),
    [sym_comp_term] = STATE(402),
    [sym_instance_of] = STATE(402),
    [sym_negation] = STATE(402),
    [sym_if_term] = STATE(402),
    [sym_conjunction] = STATE(402),
    [sym_disjunction] = STATE(402),
    [sym_implication] = STATE(402),
    [sym_quantified] = STATE(402),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(402),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [199] = {
    [sym_special_call] = STATE(1076),
    [sym_prefix_cast] = STATE(1076),
    [sym_unary_expr] = STATE(1076),
    [sym_mul_expr] = STATE(1076),
    [sym_add_expr] = STATE(1076),
    [sym_in_expr] = STATE(1076),
    [sym_comp_term] = STATE(1076),
    [sym_instance_of] = STATE(1076),
    [sym_negation] = STATE(1076),
    [sym_if_term] = STATE(1076),
    [sym_conjunction] = STATE(1076),
    [sym_disjunction] = STATE(1076),
    [sym_implication] = STATE(1076),
    [sym_quantified] = STATE(1076),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1076),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [200] = {
    [sym_special_call] = STATE(409),
    [sym_prefix_cast] = STATE(409),
    [sym_unary_expr] = STATE(409),
    [sym_mul_expr] = STATE(409),
    [sym_add_expr] = STATE(409),
    [sym_in_expr] = STATE(409),
    [sym_comp_term] = STATE(409),
    [sym_instance_of] = STATE(409),
    [sym_negation] = STATE(409),
    [sym_if_term] = STATE(409),
    [sym_conjunction] = STATE(409),
    [sym_disjunction] = STATE(409),
    [sym_implication] = STATE(409),
    [sym_quantified] = STATE(409),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(409),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [201] = {
    [sym_special_call] = STATE(806),
    [sym_prefix_cast] = STATE(806),
    [sym_unary_expr] = STATE(806),
    [sym_mul_expr] = STATE(806),
    [sym_add_expr] = STATE(806),
    [sym_in_expr] = STATE(806),
    [sym_comp_term] = STATE(806),
    [sym_instance_of] = STATE(806),
    [sym_negation] = STATE(806),
    [sym_if_term] = STATE(806),
    [sym_conjunction] = STATE(806),
    [sym_disjunction] = STATE(806),
    [sym_implication] = STATE(806),
    [sym_quantified] = STATE(806),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(806),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [202] = {
    [sym_special_call] = STATE(414),
    [sym_prefix_cast] = STATE(414),
    [sym_unary_expr] = STATE(414),
    [sym_mul_expr] = STATE(414),
    [sym_add_expr] = STATE(414),
    [sym_in_expr] = STATE(414),
    [sym_comp_term] = STATE(414),
    [sym_instance_of] = STATE(414),
    [sym_negation] = STATE(414),
    [sym_if_term] = STATE(414),
    [sym_conjunction] = STATE(414),
    [sym_disjunction] = STATE(414),
    [sym_implication] = STATE(414),
    [sym_quantified] = STATE(414),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(414),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [203] = {
    [sym_special_call] = STATE(416),
    [sym_prefix_cast] = STATE(416),
    [sym_unary_expr] = STATE(416),
    [sym_mul_expr] = STATE(416),
    [sym_add_expr] = STATE(416),
    [sym_in_expr] = STATE(416),
    [sym_comp_term] = STATE(416),
    [sym_instance_of] = STATE(416),
    [sym_negation] = STATE(416),
    [sym_if_term] = STATE(416),
    [sym_conjunction] = STATE(416),
    [sym_disjunction] = STATE(416),
    [sym_implication] = STATE(416),
    [sym_quantified] = STATE(416),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(416),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [204] = {
    [sym_special_call] = STATE(807),
    [sym_prefix_cast] = STATE(807),
    [sym_unary_expr] = STATE(807),
    [sym_mul_expr] = STATE(807),
    [sym_add_expr] = STATE(807),
    [sym_in_expr] = STATE(807),
    [sym_comp_term] = STATE(807),
    [sym_instance_of] = STATE(807),
    [sym_negation] = STATE(807),
    [sym_if_term] = STATE(807),
    [sym_conjunction] = STATE(807),
    [sym_disjunction] = STATE(807),
    [sym_implication] = STATE(807),
    [sym_quantified] = STATE(807),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(807),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [205] = {
    [sym_special_call] = STATE(417),
    [sym_prefix_cast] = STATE(417),
    [sym_unary_expr] = STATE(417),
    [sym_mul_expr] = STATE(417),
    [sym_add_expr] = STATE(417),
    [sym_in_expr] = STATE(417),
    [sym_comp_term] = STATE(417),
    [sym_instance_of] = STATE(417),
    [sym_negation] = STATE(417),
    [sym_if_term] = STATE(417),
    [sym_conjunction] = STATE(417),
    [sym_disjunction] = STATE(417),
    [sym_implication] = STATE(417),
    [sym_quantified] = STATE(417),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(417),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [206] = {
    [sym_special_call] = STATE(808),
    [sym_prefix_cast] = STATE(808),
    [sym_unary_expr] = STATE(808),
    [sym_mul_expr] = STATE(808),
    [sym_add_expr] = STATE(808),
    [sym_in_expr] = STATE(808),
    [sym_comp_term] = STATE(808),
    [sym_instance_of] = STATE(808),
    [sym_negation] = STATE(808),
    [sym_if_term] = STATE(808),
    [sym_conjunction] = STATE(808),
    [sym_disjunction] = STATE(808),
    [sym_implication] = STATE(808),
    [sym_quantified] = STATE(808),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(808),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [207] = {
    [sym_special_call] = STATE(418),
    [sym_prefix_cast] = STATE(418),
    [sym_unary_expr] = STATE(418),
    [sym_mul_expr] = STATE(418),
    [sym_add_expr] = STATE(418),
    [sym_in_expr] = STATE(418),
    [sym_comp_term] = STATE(418),
    [sym_instance_of] = STATE(418),
    [sym_negation] = STATE(418),
    [sym_if_term] = STATE(418),
    [sym_conjunction] = STATE(418),
    [sym_disjunction] = STATE(418),
    [sym_implication] = STATE(418),
    [sym_quantified] = STATE(418),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(418),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [208] = {
    [sym_special_call] = STATE(809),
    [sym_prefix_cast] = STATE(809),
    [sym_unary_expr] = STATE(809),
    [sym_mul_expr] = STATE(809),
    [sym_add_expr] = STATE(809),
    [sym_in_expr] = STATE(809),
    [sym_comp_term] = STATE(809),
    [sym_instance_of] = STATE(809),
    [sym_negation] = STATE(809),
    [sym_if_term] = STATE(809),
    [sym_conjunction] = STATE(809),
    [sym_disjunction] = STATE(809),
    [sym_implication] = STATE(809),
    [sym_quantified] = STATE(809),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(809),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [209] = {
    [sym_special_call] = STATE(1183),
    [sym_prefix_cast] = STATE(1183),
    [sym_unary_expr] = STATE(1183),
    [sym_mul_expr] = STATE(1183),
    [sym_add_expr] = STATE(1183),
    [sym_in_expr] = STATE(1183),
    [sym_comp_term] = STATE(1183),
    [sym_instance_of] = STATE(1183),
    [sym_negation] = STATE(1183),
    [sym_if_term] = STATE(1183),
    [sym_conjunction] = STATE(1183),
    [sym_disjunction] = STATE(1183),
    [sym_implication] = STATE(1183),
    [sym_quantified] = STATE(1183),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1183),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [210] = {
    [sym_special_call] = STATE(389),
    [sym_prefix_cast] = STATE(389),
    [sym_unary_expr] = STATE(389),
    [sym_mul_expr] = STATE(389),
    [sym_add_expr] = STATE(389),
    [sym_in_expr] = STATE(389),
    [sym_comp_term] = STATE(389),
    [sym_instance_of] = STATE(389),
    [sym_negation] = STATE(389),
    [sym_if_term] = STATE(389),
    [sym_conjunction] = STATE(389),
    [sym_disjunction] = STATE(389),
    [sym_implication] = STATE(389),
    [sym_quantified] = STATE(389),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(389),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [211] = {
    [sym_special_call] = STATE(861),
    [sym_prefix_cast] = STATE(861),
    [sym_unary_expr] = STATE(861),
    [sym_mul_expr] = STATE(861),
    [sym_add_expr] = STATE(861),
    [sym_in_expr] = STATE(861),
    [sym_comp_term] = STATE(861),
    [sym_instance_of] = STATE(861),
    [sym_negation] = STATE(861),
    [sym_if_term] = STATE(861),
    [sym_conjunction] = STATE(861),
    [sym_disjunction] = STATE(861),
    [sym_implication] = STATE(861),
    [sym_quantified] = STATE(861),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(861),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [212] = {
    [sym_special_call] = STATE(820),
    [sym_prefix_cast] = STATE(820),
    [sym_unary_expr] = STATE(820),
    [sym_mul_expr] = STATE(820),
    [sym_add_expr] = STATE(820),
    [sym_in_expr] = STATE(820),
    [sym_comp_term] = STATE(820),
    [sym_instance_of] = STATE(820),
    [sym_negation] = STATE(820),
    [sym_if_term] = STATE(820),
    [sym_conjunction] = STATE(820),
    [sym_disjunction] = STATE(820),
    [sym_implication] = STATE(820),
    [sym_quantified] = STATE(820),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(820),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [213] = {
    [sym_special_call] = STATE(1035),
    [sym_prefix_cast] = STATE(1035),
    [sym_unary_expr] = STATE(1035),
    [sym_mul_expr] = STATE(1035),
    [sym_add_expr] = STATE(1035),
    [sym_in_expr] = STATE(1035),
    [sym_comp_term] = STATE(1035),
    [sym_instance_of] = STATE(1035),
    [sym_negation] = STATE(1035),
    [sym_if_term] = STATE(1035),
    [sym_conjunction] = STATE(1035),
    [sym_disjunction] = STATE(1035),
    [sym_implication] = STATE(1035),
    [sym_quantified] = STATE(1035),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1035),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [214] = {
    [sym_special_call] = STATE(405),
    [sym_prefix_cast] = STATE(405),
    [sym_unary_expr] = STATE(405),
    [sym_mul_expr] = STATE(405),
    [sym_add_expr] = STATE(405),
    [sym_in_expr] = STATE(405),
    [sym_comp_term] = STATE(405),
    [sym_instance_of] = STATE(405),
    [sym_negation] = STATE(405),
    [sym_if_term] = STATE(405),
    [sym_conjunction] = STATE(405),
    [sym_disjunction] = STATE(405),
    [sym_implication] = STATE(405),
    [sym_quantified] = STATE(405),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(405),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [215] = {
    [sym_special_call] = STATE(1118),
    [sym_prefix_cast] = STATE(1118),
    [sym_unary_expr] = STATE(1118),
    [sym_mul_expr] = STATE(1118),
    [sym_add_expr] = STATE(1118),
    [sym_in_expr] = STATE(1118),
    [sym_comp_term] = STATE(1118),
    [sym_instance_of] = STATE(1118),
    [sym_negation] = STATE(1118),
    [sym_if_term] = STATE(1118),
    [sym_conjunction] = STATE(1118),
    [sym_disjunction] = STATE(1118),
    [sym_implication] = STATE(1118),
    [sym_quantified] = STATE(1118),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1118),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [216] = {
    [sym_special_call] = STATE(1104),
    [sym_prefix_cast] = STATE(1104),
    [sym_unary_expr] = STATE(1104),
    [sym_mul_expr] = STATE(1104),
    [sym_add_expr] = STATE(1104),
    [sym_in_expr] = STATE(1104),
    [sym_comp_term] = STATE(1104),
    [sym_instance_of] = STATE(1104),
    [sym_negation] = STATE(1104),
    [sym_if_term] = STATE(1104),
    [sym_conjunction] = STATE(1104),
    [sym_disjunction] = STATE(1104),
    [sym_implication] = STATE(1104),
    [sym_quantified] = STATE(1104),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1104),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [217] = {
    [sym_special_call] = STATE(787),
    [sym_prefix_cast] = STATE(787),
    [sym_unary_expr] = STATE(787),
    [sym_mul_expr] = STATE(787),
    [sym_add_expr] = STATE(787),
    [sym_in_expr] = STATE(787),
    [sym_comp_term] = STATE(787),
    [sym_instance_of] = STATE(787),
    [sym_negation] = STATE(787),
    [sym_if_term] = STATE(787),
    [sym_conjunction] = STATE(787),
    [sym_disjunction] = STATE(787),
    [sym_implication] = STATE(787),
    [sym_quantified] = STATE(787),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(787),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [218] = {
    [sym_special_call] = STATE(1121),
    [sym_prefix_cast] = STATE(1121),
    [sym_unary_expr] = STATE(1121),
    [sym_mul_expr] = STATE(1121),
    [sym_add_expr] = STATE(1121),
    [sym_in_expr] = STATE(1121),
    [sym_comp_term] = STATE(1121),
    [sym_instance_of] = STATE(1121),
    [sym_negation] = STATE(1121),
    [sym_if_term] = STATE(1121),
    [sym_conjunction] = STATE(1121),
    [sym_disjunction] = STATE(1121),
    [sym_implication] = STATE(1121),
    [sym_quantified] = STATE(1121),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1121),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [219] = {
    [sym_special_call] = STATE(408),
    [sym_prefix_cast] = STATE(408),
    [sym_unary_expr] = STATE(408),
    [sym_mul_expr] = STATE(408),
    [sym_add_expr] = STATE(408),
    [sym_in_expr] = STATE(408),
    [sym_comp_term] = STATE(408),
    [sym_instance_of] = STATE(408),
    [sym_negation] = STATE(408),
    [sym_if_term] = STATE(408),
    [sym_conjunction] = STATE(408),
    [sym_disjunction] = STATE(408),
    [sym_implication] = STATE(408),
    [sym_quantified] = STATE(408),
    [sym_quantifier] = STATE(1995),
    [sym_call_or_unqual_agg_expr] = STATE(428),
    [sym_qualified_expr] = STATE(428),
    [sym_super_ref] = STATE(428),
    [sym_aggregate] = STATE(428),
    [sym_range] = STATE(428),
    [sym_set_literal] = STATE(428),
    [sym_par_expr] = STATE(428),
    [sym_expr_annotation] = STATE(428),
    [sym__exprOrTerm] = STATE(408),
    [sym__primary] = STATE(428),
    [sym_literal] = STATE(428),
    [sym_bool] = STATE(424),
    [sym_variable] = STATE(428),
    [sym_unop] = STATE(198),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2012),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(422),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2001),
    [sym_aritylessPredicateExpr] = STATE(1481),
    [sym_varName] = STATE(426),
    [sym_aggId] = STATE(1805),
    [sym__lower_id] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_not] = ACTIONS(303),
    [anon_sym_if] = ACTIONS(305),
    [sym_specialId] = ACTIONS(307),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [sym_float] = ACTIONS(315),
    [sym_string] = ACTIONS(315),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(317),
    [sym_result] = ACTIONS(319),
    [sym_super] = ACTIONS(321),
    [sym_this] = ACTIONS(319),
    [sym_true] = ACTIONS(317),
  },
  [220] = {
    [sym_special_call] = STATE(1122),
    [sym_prefix_cast] = STATE(1122),
    [sym_unary_expr] = STATE(1122),
    [sym_mul_expr] = STATE(1122),
    [sym_add_expr] = STATE(1122),
    [sym_in_expr] = STATE(1122),
    [sym_comp_term] = STATE(1122),
    [sym_instance_of] = STATE(1122),
    [sym_negation] = STATE(1122),
    [sym_if_term] = STATE(1122),
    [sym_conjunction] = STATE(1122),
    [sym_disjunction] = STATE(1122),
    [sym_implication] = STATE(1122),
    [sym_quantified] = STATE(1122),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1122),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [221] = {
    [sym_special_call] = STATE(839),
    [sym_prefix_cast] = STATE(839),
    [sym_unary_expr] = STATE(839),
    [sym_mul_expr] = STATE(839),
    [sym_add_expr] = STATE(839),
    [sym_in_expr] = STATE(839),
    [sym_comp_term] = STATE(839),
    [sym_instance_of] = STATE(839),
    [sym_negation] = STATE(839),
    [sym_if_term] = STATE(839),
    [sym_conjunction] = STATE(839),
    [sym_disjunction] = STATE(839),
    [sym_implication] = STATE(839),
    [sym_quantified] = STATE(839),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(839),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [222] = {
    [sym_special_call] = STATE(832),
    [sym_prefix_cast] = STATE(832),
    [sym_unary_expr] = STATE(832),
    [sym_mul_expr] = STATE(832),
    [sym_add_expr] = STATE(832),
    [sym_in_expr] = STATE(832),
    [sym_comp_term] = STATE(832),
    [sym_instance_of] = STATE(832),
    [sym_negation] = STATE(832),
    [sym_if_term] = STATE(832),
    [sym_conjunction] = STATE(832),
    [sym_disjunction] = STATE(832),
    [sym_implication] = STATE(832),
    [sym_quantified] = STATE(832),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(832),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [223] = {
    [sym_special_call] = STATE(954),
    [sym_prefix_cast] = STATE(954),
    [sym_unary_expr] = STATE(954),
    [sym_mul_expr] = STATE(954),
    [sym_add_expr] = STATE(954),
    [sym_in_expr] = STATE(954),
    [sym_comp_term] = STATE(954),
    [sym_instance_of] = STATE(954),
    [sym_negation] = STATE(954),
    [sym_if_term] = STATE(954),
    [sym_conjunction] = STATE(954),
    [sym_disjunction] = STATE(954),
    [sym_implication] = STATE(954),
    [sym_quantified] = STATE(954),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(954),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [224] = {
    [sym_special_call] = STATE(1143),
    [sym_prefix_cast] = STATE(1143),
    [sym_unary_expr] = STATE(1143),
    [sym_mul_expr] = STATE(1143),
    [sym_add_expr] = STATE(1143),
    [sym_in_expr] = STATE(1143),
    [sym_comp_term] = STATE(1143),
    [sym_instance_of] = STATE(1143),
    [sym_negation] = STATE(1143),
    [sym_if_term] = STATE(1143),
    [sym_conjunction] = STATE(1143),
    [sym_disjunction] = STATE(1143),
    [sym_implication] = STATE(1143),
    [sym_quantified] = STATE(1143),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1143),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [225] = {
    [sym_special_call] = STATE(852),
    [sym_prefix_cast] = STATE(852),
    [sym_unary_expr] = STATE(852),
    [sym_mul_expr] = STATE(852),
    [sym_add_expr] = STATE(852),
    [sym_in_expr] = STATE(852),
    [sym_comp_term] = STATE(852),
    [sym_instance_of] = STATE(852),
    [sym_negation] = STATE(852),
    [sym_if_term] = STATE(852),
    [sym_conjunction] = STATE(852),
    [sym_disjunction] = STATE(852),
    [sym_implication] = STATE(852),
    [sym_quantified] = STATE(852),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(852),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [226] = {
    [sym_special_call] = STATE(1115),
    [sym_prefix_cast] = STATE(1115),
    [sym_unary_expr] = STATE(1115),
    [sym_mul_expr] = STATE(1115),
    [sym_add_expr] = STATE(1115),
    [sym_in_expr] = STATE(1115),
    [sym_comp_term] = STATE(1115),
    [sym_instance_of] = STATE(1115),
    [sym_negation] = STATE(1115),
    [sym_if_term] = STATE(1115),
    [sym_conjunction] = STATE(1115),
    [sym_disjunction] = STATE(1115),
    [sym_implication] = STATE(1115),
    [sym_quantified] = STATE(1115),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1115),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [227] = {
    [sym_special_call] = STATE(853),
    [sym_prefix_cast] = STATE(853),
    [sym_unary_expr] = STATE(853),
    [sym_mul_expr] = STATE(853),
    [sym_add_expr] = STATE(853),
    [sym_in_expr] = STATE(853),
    [sym_comp_term] = STATE(853),
    [sym_instance_of] = STATE(853),
    [sym_negation] = STATE(853),
    [sym_if_term] = STATE(853),
    [sym_conjunction] = STATE(853),
    [sym_disjunction] = STATE(853),
    [sym_implication] = STATE(853),
    [sym_quantified] = STATE(853),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(853),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [228] = {
    [sym_special_call] = STATE(855),
    [sym_prefix_cast] = STATE(855),
    [sym_unary_expr] = STATE(855),
    [sym_mul_expr] = STATE(855),
    [sym_add_expr] = STATE(855),
    [sym_in_expr] = STATE(855),
    [sym_comp_term] = STATE(855),
    [sym_instance_of] = STATE(855),
    [sym_negation] = STATE(855),
    [sym_if_term] = STATE(855),
    [sym_conjunction] = STATE(855),
    [sym_disjunction] = STATE(855),
    [sym_implication] = STATE(855),
    [sym_quantified] = STATE(855),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(855),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [229] = {
    [sym_special_call] = STATE(856),
    [sym_prefix_cast] = STATE(856),
    [sym_unary_expr] = STATE(856),
    [sym_mul_expr] = STATE(856),
    [sym_add_expr] = STATE(856),
    [sym_in_expr] = STATE(856),
    [sym_comp_term] = STATE(856),
    [sym_instance_of] = STATE(856),
    [sym_negation] = STATE(856),
    [sym_if_term] = STATE(856),
    [sym_conjunction] = STATE(856),
    [sym_disjunction] = STATE(856),
    [sym_implication] = STATE(856),
    [sym_quantified] = STATE(856),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(856),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [230] = {
    [sym_special_call] = STATE(833),
    [sym_prefix_cast] = STATE(833),
    [sym_unary_expr] = STATE(833),
    [sym_mul_expr] = STATE(833),
    [sym_add_expr] = STATE(833),
    [sym_in_expr] = STATE(833),
    [sym_comp_term] = STATE(833),
    [sym_instance_of] = STATE(833),
    [sym_negation] = STATE(833),
    [sym_if_term] = STATE(833),
    [sym_conjunction] = STATE(833),
    [sym_disjunction] = STATE(833),
    [sym_implication] = STATE(833),
    [sym_quantified] = STATE(833),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(833),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [231] = {
    [sym_special_call] = STATE(834),
    [sym_prefix_cast] = STATE(834),
    [sym_unary_expr] = STATE(834),
    [sym_mul_expr] = STATE(834),
    [sym_add_expr] = STATE(834),
    [sym_in_expr] = STATE(834),
    [sym_comp_term] = STATE(834),
    [sym_instance_of] = STATE(834),
    [sym_negation] = STATE(834),
    [sym_if_term] = STATE(834),
    [sym_conjunction] = STATE(834),
    [sym_disjunction] = STATE(834),
    [sym_implication] = STATE(834),
    [sym_quantified] = STATE(834),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(834),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [232] = {
    [sym_special_call] = STATE(854),
    [sym_prefix_cast] = STATE(854),
    [sym_unary_expr] = STATE(854),
    [sym_mul_expr] = STATE(854),
    [sym_add_expr] = STATE(854),
    [sym_in_expr] = STATE(854),
    [sym_comp_term] = STATE(854),
    [sym_instance_of] = STATE(854),
    [sym_negation] = STATE(854),
    [sym_if_term] = STATE(854),
    [sym_conjunction] = STATE(854),
    [sym_disjunction] = STATE(854),
    [sym_implication] = STATE(854),
    [sym_quantified] = STATE(854),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(854),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [233] = {
    [sym_special_call] = STATE(379),
    [sym_prefix_cast] = STATE(379),
    [sym_unary_expr] = STATE(379),
    [sym_mul_expr] = STATE(379),
    [sym_add_expr] = STATE(379),
    [sym_in_expr] = STATE(379),
    [sym_comp_term] = STATE(379),
    [sym_instance_of] = STATE(379),
    [sym_negation] = STATE(379),
    [sym_if_term] = STATE(379),
    [sym_conjunction] = STATE(379),
    [sym_disjunction] = STATE(379),
    [sym_implication] = STATE(379),
    [sym_quantified] = STATE(379),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(379),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(335),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(341),
    [sym_result] = ACTIONS(343),
    [sym_super] = ACTIONS(345),
    [sym_this] = ACTIONS(343),
    [sym_true] = ACTIONS(341),
  },
  [234] = {
    [sym_special_call] = STATE(836),
    [sym_prefix_cast] = STATE(836),
    [sym_unary_expr] = STATE(836),
    [sym_mul_expr] = STATE(836),
    [sym_add_expr] = STATE(836),
    [sym_in_expr] = STATE(836),
    [sym_comp_term] = STATE(836),
    [sym_instance_of] = STATE(836),
    [sym_negation] = STATE(836),
    [sym_if_term] = STATE(836),
    [sym_conjunction] = STATE(836),
    [sym_disjunction] = STATE(836),
    [sym_implication] = STATE(836),
    [sym_quantified] = STATE(836),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(836),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [235] = {
    [sym_special_call] = STATE(1000),
    [sym_prefix_cast] = STATE(1000),
    [sym_unary_expr] = STATE(1000),
    [sym_mul_expr] = STATE(1000),
    [sym_add_expr] = STATE(1000),
    [sym_in_expr] = STATE(1000),
    [sym_comp_term] = STATE(1000),
    [sym_instance_of] = STATE(1000),
    [sym_negation] = STATE(1000),
    [sym_if_term] = STATE(1000),
    [sym_conjunction] = STATE(1000),
    [sym_disjunction] = STATE(1000),
    [sym_implication] = STATE(1000),
    [sym_quantified] = STATE(1000),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1000),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [236] = {
    [sym_special_call] = STATE(1143),
    [sym_prefix_cast] = STATE(1143),
    [sym_unary_expr] = STATE(1143),
    [sym_mul_expr] = STATE(1143),
    [sym_add_expr] = STATE(1143),
    [sym_in_expr] = STATE(1143),
    [sym_comp_term] = STATE(1143),
    [sym_instance_of] = STATE(1143),
    [sym_negation] = STATE(1143),
    [sym_if_term] = STATE(1143),
    [sym_conjunction] = STATE(1143),
    [sym_disjunction] = STATE(1143),
    [sym_implication] = STATE(1143),
    [sym_quantified] = STATE(1143),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1143),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1785),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [237] = {
    [sym_special_call] = STATE(843),
    [sym_prefix_cast] = STATE(843),
    [sym_unary_expr] = STATE(843),
    [sym_mul_expr] = STATE(843),
    [sym_add_expr] = STATE(843),
    [sym_in_expr] = STATE(843),
    [sym_comp_term] = STATE(843),
    [sym_instance_of] = STATE(843),
    [sym_negation] = STATE(843),
    [sym_if_term] = STATE(843),
    [sym_conjunction] = STATE(843),
    [sym_disjunction] = STATE(843),
    [sym_implication] = STATE(843),
    [sym_quantified] = STATE(843),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(843),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [238] = {
    [sym_special_call] = STATE(1128),
    [sym_prefix_cast] = STATE(1128),
    [sym_unary_expr] = STATE(1128),
    [sym_mul_expr] = STATE(1128),
    [sym_add_expr] = STATE(1128),
    [sym_in_expr] = STATE(1128),
    [sym_comp_term] = STATE(1128),
    [sym_instance_of] = STATE(1128),
    [sym_negation] = STATE(1128),
    [sym_if_term] = STATE(1128),
    [sym_conjunction] = STATE(1128),
    [sym_disjunction] = STATE(1128),
    [sym_implication] = STATE(1128),
    [sym_quantified] = STATE(1128),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1128),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [239] = {
    [sym_special_call] = STATE(838),
    [sym_prefix_cast] = STATE(838),
    [sym_unary_expr] = STATE(838),
    [sym_mul_expr] = STATE(838),
    [sym_add_expr] = STATE(838),
    [sym_in_expr] = STATE(838),
    [sym_comp_term] = STATE(838),
    [sym_instance_of] = STATE(838),
    [sym_negation] = STATE(838),
    [sym_if_term] = STATE(838),
    [sym_conjunction] = STATE(838),
    [sym_disjunction] = STATE(838),
    [sym_implication] = STATE(838),
    [sym_quantified] = STATE(838),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(838),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [240] = {
    [sym_special_call] = STATE(796),
    [sym_prefix_cast] = STATE(796),
    [sym_unary_expr] = STATE(796),
    [sym_mul_expr] = STATE(796),
    [sym_add_expr] = STATE(796),
    [sym_in_expr] = STATE(796),
    [sym_comp_term] = STATE(796),
    [sym_instance_of] = STATE(796),
    [sym_negation] = STATE(796),
    [sym_if_term] = STATE(796),
    [sym_conjunction] = STATE(796),
    [sym_disjunction] = STATE(796),
    [sym_implication] = STATE(796),
    [sym_quantified] = STATE(796),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(796),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [241] = {
    [sym_special_call] = STATE(859),
    [sym_prefix_cast] = STATE(859),
    [sym_unary_expr] = STATE(859),
    [sym_mul_expr] = STATE(859),
    [sym_add_expr] = STATE(859),
    [sym_in_expr] = STATE(859),
    [sym_comp_term] = STATE(859),
    [sym_instance_of] = STATE(859),
    [sym_negation] = STATE(859),
    [sym_if_term] = STATE(859),
    [sym_conjunction] = STATE(859),
    [sym_disjunction] = STATE(859),
    [sym_implication] = STATE(859),
    [sym_quantified] = STATE(859),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(859),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [242] = {
    [sym_special_call] = STATE(841),
    [sym_prefix_cast] = STATE(841),
    [sym_unary_expr] = STATE(841),
    [sym_mul_expr] = STATE(841),
    [sym_add_expr] = STATE(841),
    [sym_in_expr] = STATE(841),
    [sym_comp_term] = STATE(841),
    [sym_instance_of] = STATE(841),
    [sym_negation] = STATE(841),
    [sym_if_term] = STATE(841),
    [sym_conjunction] = STATE(841),
    [sym_disjunction] = STATE(841),
    [sym_implication] = STATE(841),
    [sym_quantified] = STATE(841),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(841),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [243] = {
    [sym_special_call] = STATE(842),
    [sym_prefix_cast] = STATE(842),
    [sym_unary_expr] = STATE(842),
    [sym_mul_expr] = STATE(842),
    [sym_add_expr] = STATE(842),
    [sym_in_expr] = STATE(842),
    [sym_comp_term] = STATE(842),
    [sym_instance_of] = STATE(842),
    [sym_negation] = STATE(842),
    [sym_if_term] = STATE(842),
    [sym_conjunction] = STATE(842),
    [sym_disjunction] = STATE(842),
    [sym_implication] = STATE(842),
    [sym_quantified] = STATE(842),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(842),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [244] = {
    [sym_special_call] = STATE(412),
    [sym_prefix_cast] = STATE(412),
    [sym_unary_expr] = STATE(412),
    [sym_mul_expr] = STATE(412),
    [sym_add_expr] = STATE(412),
    [sym_in_expr] = STATE(412),
    [sym_comp_term] = STATE(412),
    [sym_instance_of] = STATE(412),
    [sym_negation] = STATE(412),
    [sym_if_term] = STATE(412),
    [sym_conjunction] = STATE(412),
    [sym_disjunction] = STATE(412),
    [sym_implication] = STATE(412),
    [sym_quantified] = STATE(412),
    [sym_quantifier] = STATE(1865),
    [sym_call_or_unqual_agg_expr] = STATE(517),
    [sym_qualified_expr] = STATE(517),
    [sym_super_ref] = STATE(517),
    [sym_aggregate] = STATE(517),
    [sym_range] = STATE(517),
    [sym_set_literal] = STATE(517),
    [sym_par_expr] = STATE(517),
    [sym_expr_annotation] = STATE(517),
    [sym__exprOrTerm] = STATE(412),
    [sym__primary] = STATE(517),
    [sym_literal] = STATE(517),
    [sym_bool] = STATE(513),
    [sym_variable] = STATE(517),
    [sym_unop] = STATE(297),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2015),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(421),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1866),
    [sym_aritylessPredicateExpr] = STATE(1477),
    [sym_varName] = STATE(598),
    [sym_aggId] = STATE(1778),
    [sym__lower_id] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_not] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [sym_specialId] = ACTIONS(475),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(479),
    [sym_integer] = ACTIONS(481),
    [sym_float] = ACTIONS(483),
    [sym_string] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(485),
    [sym_result] = ACTIONS(487),
    [sym_super] = ACTIONS(489),
    [sym_this] = ACTIONS(487),
    [sym_true] = ACTIONS(485),
  },
  [245] = {
    [sym_special_call] = STATE(857),
    [sym_prefix_cast] = STATE(857),
    [sym_unary_expr] = STATE(857),
    [sym_mul_expr] = STATE(857),
    [sym_add_expr] = STATE(857),
    [sym_in_expr] = STATE(857),
    [sym_comp_term] = STATE(857),
    [sym_instance_of] = STATE(857),
    [sym_negation] = STATE(857),
    [sym_if_term] = STATE(857),
    [sym_conjunction] = STATE(857),
    [sym_disjunction] = STATE(857),
    [sym_implication] = STATE(857),
    [sym_quantified] = STATE(857),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(857),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [246] = {
    [sym_special_call] = STATE(949),
    [sym_prefix_cast] = STATE(949),
    [sym_unary_expr] = STATE(949),
    [sym_mul_expr] = STATE(949),
    [sym_add_expr] = STATE(949),
    [sym_in_expr] = STATE(949),
    [sym_comp_term] = STATE(949),
    [sym_instance_of] = STATE(949),
    [sym_negation] = STATE(949),
    [sym_if_term] = STATE(949),
    [sym_conjunction] = STATE(949),
    [sym_disjunction] = STATE(949),
    [sym_implication] = STATE(949),
    [sym_quantified] = STATE(949),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(949),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [247] = {
    [sym_special_call] = STATE(1031),
    [sym_prefix_cast] = STATE(1031),
    [sym_unary_expr] = STATE(1031),
    [sym_mul_expr] = STATE(1031),
    [sym_add_expr] = STATE(1031),
    [sym_in_expr] = STATE(1031),
    [sym_comp_term] = STATE(1031),
    [sym_instance_of] = STATE(1031),
    [sym_negation] = STATE(1031),
    [sym_if_term] = STATE(1031),
    [sym_conjunction] = STATE(1031),
    [sym_disjunction] = STATE(1031),
    [sym_implication] = STATE(1031),
    [sym_quantified] = STATE(1031),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1031),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [248] = {
    [sym_special_call] = STATE(858),
    [sym_prefix_cast] = STATE(858),
    [sym_unary_expr] = STATE(858),
    [sym_mul_expr] = STATE(858),
    [sym_add_expr] = STATE(858),
    [sym_in_expr] = STATE(858),
    [sym_comp_term] = STATE(858),
    [sym_instance_of] = STATE(858),
    [sym_negation] = STATE(858),
    [sym_if_term] = STATE(858),
    [sym_conjunction] = STATE(858),
    [sym_disjunction] = STATE(858),
    [sym_implication] = STATE(858),
    [sym_quantified] = STATE(858),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(858),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [249] = {
    [sym_special_call] = STATE(1138),
    [sym_prefix_cast] = STATE(1138),
    [sym_unary_expr] = STATE(1138),
    [sym_mul_expr] = STATE(1138),
    [sym_add_expr] = STATE(1138),
    [sym_in_expr] = STATE(1138),
    [sym_comp_term] = STATE(1138),
    [sym_instance_of] = STATE(1138),
    [sym_negation] = STATE(1138),
    [sym_if_term] = STATE(1138),
    [sym_conjunction] = STATE(1138),
    [sym_disjunction] = STATE(1138),
    [sym_implication] = STATE(1138),
    [sym_quantified] = STATE(1138),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1138),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [250] = {
    [sym_special_call] = STATE(844),
    [sym_prefix_cast] = STATE(844),
    [sym_unary_expr] = STATE(844),
    [sym_mul_expr] = STATE(844),
    [sym_add_expr] = STATE(844),
    [sym_in_expr] = STATE(844),
    [sym_comp_term] = STATE(844),
    [sym_instance_of] = STATE(844),
    [sym_negation] = STATE(844),
    [sym_if_term] = STATE(844),
    [sym_conjunction] = STATE(844),
    [sym_disjunction] = STATE(844),
    [sym_implication] = STATE(844),
    [sym_quantified] = STATE(844),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(844),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [251] = {
    [sym_special_call] = STATE(811),
    [sym_prefix_cast] = STATE(811),
    [sym_unary_expr] = STATE(811),
    [sym_mul_expr] = STATE(811),
    [sym_add_expr] = STATE(811),
    [sym_in_expr] = STATE(811),
    [sym_comp_term] = STATE(811),
    [sym_instance_of] = STATE(811),
    [sym_negation] = STATE(811),
    [sym_if_term] = STATE(811),
    [sym_conjunction] = STATE(811),
    [sym_disjunction] = STATE(811),
    [sym_implication] = STATE(811),
    [sym_quantified] = STATE(811),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(811),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [252] = {
    [sym_special_call] = STATE(851),
    [sym_prefix_cast] = STATE(851),
    [sym_unary_expr] = STATE(851),
    [sym_mul_expr] = STATE(851),
    [sym_add_expr] = STATE(851),
    [sym_in_expr] = STATE(851),
    [sym_comp_term] = STATE(851),
    [sym_instance_of] = STATE(851),
    [sym_negation] = STATE(851),
    [sym_if_term] = STATE(851),
    [sym_conjunction] = STATE(851),
    [sym_disjunction] = STATE(851),
    [sym_implication] = STATE(851),
    [sym_quantified] = STATE(851),
    [sym_quantifier] = STATE(2008),
    [sym_call_or_unqual_agg_expr] = STATE(902),
    [sym_qualified_expr] = STATE(902),
    [sym_super_ref] = STATE(902),
    [sym_aggregate] = STATE(902),
    [sym_range] = STATE(902),
    [sym_set_literal] = STATE(902),
    [sym_par_expr] = STATE(902),
    [sym_expr_annotation] = STATE(902),
    [sym__exprOrTerm] = STATE(851),
    [sym__primary] = STATE(902),
    [sym_literal] = STATE(902),
    [sym_bool] = STATE(883),
    [sym_variable] = STATE(902),
    [sym_unop] = STATE(237),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2013),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(860),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1839),
    [sym_aritylessPredicateExpr] = STATE(1482),
    [sym_varName] = STATE(891),
    [sym_aggId] = STATE(1769),
    [sym__lower_id] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [sym_specialId] = ACTIONS(47),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(57),
    [sym_integer] = ACTIONS(59),
    [sym_float] = ACTIONS(61),
    [sym_string] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(63),
    [sym_result] = ACTIONS(65),
    [sym_super] = ACTIONS(67),
    [sym_this] = ACTIONS(65),
    [sym_true] = ACTIONS(63),
  },
  [253] = {
    [sym_special_call] = STATE(1180),
    [sym_prefix_cast] = STATE(1180),
    [sym_unary_expr] = STATE(1180),
    [sym_mul_expr] = STATE(1180),
    [sym_add_expr] = STATE(1180),
    [sym_in_expr] = STATE(1180),
    [sym_comp_term] = STATE(1180),
    [sym_instance_of] = STATE(1180),
    [sym_negation] = STATE(1180),
    [sym_if_term] = STATE(1180),
    [sym_conjunction] = STATE(1180),
    [sym_disjunction] = STATE(1180),
    [sym_implication] = STATE(1180),
    [sym_quantified] = STATE(1180),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1180),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [254] = {
    [sym_special_call] = STATE(1028),
    [sym_prefix_cast] = STATE(1028),
    [sym_unary_expr] = STATE(1028),
    [sym_mul_expr] = STATE(1028),
    [sym_add_expr] = STATE(1028),
    [sym_in_expr] = STATE(1028),
    [sym_comp_term] = STATE(1028),
    [sym_instance_of] = STATE(1028),
    [sym_negation] = STATE(1028),
    [sym_if_term] = STATE(1028),
    [sym_conjunction] = STATE(1028),
    [sym_disjunction] = STATE(1028),
    [sym_implication] = STATE(1028),
    [sym_quantified] = STATE(1028),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1028),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [255] = {
    [sym_special_call] = STATE(840),
    [sym_prefix_cast] = STATE(840),
    [sym_unary_expr] = STATE(840),
    [sym_mul_expr] = STATE(840),
    [sym_add_expr] = STATE(840),
    [sym_in_expr] = STATE(840),
    [sym_comp_term] = STATE(840),
    [sym_instance_of] = STATE(840),
    [sym_negation] = STATE(840),
    [sym_if_term] = STATE(840),
    [sym_conjunction] = STATE(840),
    [sym_disjunction] = STATE(840),
    [sym_implication] = STATE(840),
    [sym_quantified] = STATE(840),
    [sym_quantifier] = STATE(1892),
    [sym_call_or_unqual_agg_expr] = STATE(1014),
    [sym_qualified_expr] = STATE(1014),
    [sym_super_ref] = STATE(1014),
    [sym_aggregate] = STATE(1014),
    [sym_range] = STATE(1014),
    [sym_set_literal] = STATE(1014),
    [sym_par_expr] = STATE(1014),
    [sym_expr_annotation] = STATE(1014),
    [sym__exprOrTerm] = STATE(840),
    [sym__primary] = STATE(1014),
    [sym_literal] = STATE(1014),
    [sym_bool] = STATE(1007),
    [sym_variable] = STATE(1014),
    [sym_unop] = STATE(174),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2016),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(871),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1893),
    [sym_aritylessPredicateExpr] = STATE(1475),
    [sym_varName] = STATE(1012),
    [sym_aggId] = STATE(1761),
    [sym__lower_id] = ACTIONS(533),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_not] = ACTIONS(537),
    [anon_sym_if] = ACTIONS(539),
    [sym_specialId] = ACTIONS(541),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(545),
    [sym_integer] = ACTIONS(547),
    [sym_float] = ACTIONS(549),
    [sym_string] = ACTIONS(549),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(551),
    [sym_result] = ACTIONS(553),
    [sym_super] = ACTIONS(555),
    [sym_this] = ACTIONS(553),
    [sym_true] = ACTIONS(551),
  },
  [256] = {
    [sym_special_call] = STATE(1149),
    [sym_prefix_cast] = STATE(1149),
    [sym_unary_expr] = STATE(1149),
    [sym_mul_expr] = STATE(1149),
    [sym_add_expr] = STATE(1149),
    [sym_in_expr] = STATE(1149),
    [sym_comp_term] = STATE(1149),
    [sym_instance_of] = STATE(1149),
    [sym_negation] = STATE(1149),
    [sym_if_term] = STATE(1149),
    [sym_conjunction] = STATE(1149),
    [sym_disjunction] = STATE(1149),
    [sym_implication] = STATE(1149),
    [sym_quantified] = STATE(1149),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1149),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [257] = {
    [sym_special_call] = STATE(1182),
    [sym_prefix_cast] = STATE(1182),
    [sym_unary_expr] = STATE(1182),
    [sym_mul_expr] = STATE(1182),
    [sym_add_expr] = STATE(1182),
    [sym_in_expr] = STATE(1182),
    [sym_comp_term] = STATE(1182),
    [sym_instance_of] = STATE(1182),
    [sym_negation] = STATE(1182),
    [sym_if_term] = STATE(1182),
    [sym_conjunction] = STATE(1182),
    [sym_disjunction] = STATE(1182),
    [sym_implication] = STATE(1182),
    [sym_quantified] = STATE(1182),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1182),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [258] = {
    [sym_special_call] = STATE(387),
    [sym_prefix_cast] = STATE(387),
    [sym_unary_expr] = STATE(387),
    [sym_mul_expr] = STATE(387),
    [sym_add_expr] = STATE(387),
    [sym_in_expr] = STATE(387),
    [sym_comp_term] = STATE(387),
    [sym_instance_of] = STATE(387),
    [sym_negation] = STATE(387),
    [sym_if_term] = STATE(387),
    [sym_conjunction] = STATE(387),
    [sym_disjunction] = STATE(387),
    [sym_implication] = STATE(387),
    [sym_quantified] = STATE(387),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(387),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(335),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(341),
    [sym_result] = ACTIONS(343),
    [sym_super] = ACTIONS(345),
    [sym_this] = ACTIONS(343),
    [sym_true] = ACTIONS(341),
  },
  [259] = {
    [sym_special_call] = STATE(1148),
    [sym_prefix_cast] = STATE(1148),
    [sym_unary_expr] = STATE(1148),
    [sym_mul_expr] = STATE(1148),
    [sym_add_expr] = STATE(1148),
    [sym_in_expr] = STATE(1148),
    [sym_comp_term] = STATE(1148),
    [sym_instance_of] = STATE(1148),
    [sym_negation] = STATE(1148),
    [sym_if_term] = STATE(1148),
    [sym_conjunction] = STATE(1148),
    [sym_disjunction] = STATE(1148),
    [sym_implication] = STATE(1148),
    [sym_quantified] = STATE(1148),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1148),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [260] = {
    [sym_special_call] = STATE(374),
    [sym_prefix_cast] = STATE(374),
    [sym_unary_expr] = STATE(374),
    [sym_mul_expr] = STATE(374),
    [sym_add_expr] = STATE(374),
    [sym_in_expr] = STATE(374),
    [sym_comp_term] = STATE(374),
    [sym_instance_of] = STATE(374),
    [sym_negation] = STATE(374),
    [sym_if_term] = STATE(374),
    [sym_conjunction] = STATE(374),
    [sym_disjunction] = STATE(374),
    [sym_implication] = STATE(374),
    [sym_quantified] = STATE(374),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(374),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(335),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(341),
    [sym_result] = ACTIONS(343),
    [sym_super] = ACTIONS(345),
    [sym_this] = ACTIONS(343),
    [sym_true] = ACTIONS(341),
  },
  [261] = {
    [sym_special_call] = STATE(375),
    [sym_prefix_cast] = STATE(375),
    [sym_unary_expr] = STATE(375),
    [sym_mul_expr] = STATE(375),
    [sym_add_expr] = STATE(375),
    [sym_in_expr] = STATE(375),
    [sym_comp_term] = STATE(375),
    [sym_instance_of] = STATE(375),
    [sym_negation] = STATE(375),
    [sym_if_term] = STATE(375),
    [sym_conjunction] = STATE(375),
    [sym_disjunction] = STATE(375),
    [sym_implication] = STATE(375),
    [sym_quantified] = STATE(375),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(375),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(335),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(341),
    [sym_result] = ACTIONS(343),
    [sym_super] = ACTIONS(345),
    [sym_this] = ACTIONS(343),
    [sym_true] = ACTIONS(341),
  },
  [262] = {
    [sym_special_call] = STATE(378),
    [sym_prefix_cast] = STATE(378),
    [sym_unary_expr] = STATE(378),
    [sym_mul_expr] = STATE(378),
    [sym_add_expr] = STATE(378),
    [sym_in_expr] = STATE(378),
    [sym_comp_term] = STATE(378),
    [sym_instance_of] = STATE(378),
    [sym_negation] = STATE(378),
    [sym_if_term] = STATE(378),
    [sym_conjunction] = STATE(378),
    [sym_disjunction] = STATE(378),
    [sym_implication] = STATE(378),
    [sym_quantified] = STATE(378),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(378),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(335),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(341),
    [sym_result] = ACTIONS(343),
    [sym_super] = ACTIONS(345),
    [sym_this] = ACTIONS(343),
    [sym_true] = ACTIONS(341),
  },
  [263] = {
    [sym_special_call] = STATE(388),
    [sym_prefix_cast] = STATE(388),
    [sym_unary_expr] = STATE(388),
    [sym_mul_expr] = STATE(388),
    [sym_add_expr] = STATE(388),
    [sym_in_expr] = STATE(388),
    [sym_comp_term] = STATE(388),
    [sym_instance_of] = STATE(388),
    [sym_negation] = STATE(388),
    [sym_if_term] = STATE(388),
    [sym_conjunction] = STATE(388),
    [sym_disjunction] = STATE(388),
    [sym_implication] = STATE(388),
    [sym_quantified] = STATE(388),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(388),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(335),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(341),
    [sym_result] = ACTIONS(343),
    [sym_super] = ACTIONS(345),
    [sym_this] = ACTIONS(343),
    [sym_true] = ACTIONS(341),
  },
  [264] = {
    [sym_special_call] = STATE(390),
    [sym_prefix_cast] = STATE(390),
    [sym_unary_expr] = STATE(390),
    [sym_mul_expr] = STATE(390),
    [sym_add_expr] = STATE(390),
    [sym_in_expr] = STATE(390),
    [sym_comp_term] = STATE(390),
    [sym_instance_of] = STATE(390),
    [sym_negation] = STATE(390),
    [sym_if_term] = STATE(390),
    [sym_conjunction] = STATE(390),
    [sym_disjunction] = STATE(390),
    [sym_implication] = STATE(390),
    [sym_quantified] = STATE(390),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(390),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(335),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(341),
    [sym_result] = ACTIONS(343),
    [sym_super] = ACTIONS(345),
    [sym_this] = ACTIONS(343),
    [sym_true] = ACTIONS(341),
  },
  [265] = {
    [sym_special_call] = STATE(413),
    [sym_prefix_cast] = STATE(413),
    [sym_unary_expr] = STATE(413),
    [sym_mul_expr] = STATE(413),
    [sym_add_expr] = STATE(413),
    [sym_in_expr] = STATE(413),
    [sym_comp_term] = STATE(413),
    [sym_instance_of] = STATE(413),
    [sym_negation] = STATE(413),
    [sym_if_term] = STATE(413),
    [sym_conjunction] = STATE(413),
    [sym_disjunction] = STATE(413),
    [sym_implication] = STATE(413),
    [sym_quantified] = STATE(413),
    [sym_quantifier] = STATE(1919),
    [sym_call_or_unqual_agg_expr] = STATE(560),
    [sym_qualified_expr] = STATE(560),
    [sym_super_ref] = STATE(560),
    [sym_aggregate] = STATE(560),
    [sym_range] = STATE(560),
    [sym_set_literal] = STATE(560),
    [sym_par_expr] = STATE(560),
    [sym_expr_annotation] = STATE(560),
    [sym__exprOrTerm] = STATE(413),
    [sym__primary] = STATE(560),
    [sym_literal] = STATE(560),
    [sym_bool] = STATE(556),
    [sym_variable] = STATE(560),
    [sym_unop] = STATE(183),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2017),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(420),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1920),
    [sym_aritylessPredicateExpr] = STATE(1484),
    [sym_varName] = STATE(558),
    [sym_aggId] = STATE(1789),
    [sym__lower_id] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(501),
    [anon_sym_not] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(505),
    [sym_specialId] = ACTIONS(507),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(511),
    [sym_integer] = ACTIONS(513),
    [sym_float] = ACTIONS(515),
    [sym_string] = ACTIONS(515),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(517),
    [sym_result] = ACTIONS(519),
    [sym_super] = ACTIONS(521),
    [sym_this] = ACTIONS(519),
    [sym_true] = ACTIONS(517),
  },
  [266] = {
    [sym_special_call] = STATE(1076),
    [sym_prefix_cast] = STATE(1076),
    [sym_unary_expr] = STATE(1076),
    [sym_mul_expr] = STATE(1076),
    [sym_add_expr] = STATE(1076),
    [sym_in_expr] = STATE(1076),
    [sym_comp_term] = STATE(1076),
    [sym_instance_of] = STATE(1076),
    [sym_negation] = STATE(1076),
    [sym_if_term] = STATE(1076),
    [sym_conjunction] = STATE(1076),
    [sym_disjunction] = STATE(1076),
    [sym_implication] = STATE(1076),
    [sym_quantified] = STATE(1076),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1076),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1798),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [267] = {
    [sym_special_call] = STATE(1084),
    [sym_prefix_cast] = STATE(1084),
    [sym_unary_expr] = STATE(1084),
    [sym_mul_expr] = STATE(1084),
    [sym_add_expr] = STATE(1084),
    [sym_in_expr] = STATE(1084),
    [sym_comp_term] = STATE(1084),
    [sym_instance_of] = STATE(1084),
    [sym_negation] = STATE(1084),
    [sym_if_term] = STATE(1084),
    [sym_conjunction] = STATE(1084),
    [sym_disjunction] = STATE(1084),
    [sym_implication] = STATE(1084),
    [sym_quantified] = STATE(1084),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1084),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [268] = {
    [sym_special_call] = STATE(1085),
    [sym_prefix_cast] = STATE(1085),
    [sym_unary_expr] = STATE(1085),
    [sym_mul_expr] = STATE(1085),
    [sym_add_expr] = STATE(1085),
    [sym_in_expr] = STATE(1085),
    [sym_comp_term] = STATE(1085),
    [sym_instance_of] = STATE(1085),
    [sym_negation] = STATE(1085),
    [sym_if_term] = STATE(1085),
    [sym_conjunction] = STATE(1085),
    [sym_disjunction] = STATE(1085),
    [sym_implication] = STATE(1085),
    [sym_quantified] = STATE(1085),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1085),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [269] = {
    [sym_special_call] = STATE(906),
    [sym_prefix_cast] = STATE(906),
    [sym_unary_expr] = STATE(906),
    [sym_mul_expr] = STATE(906),
    [sym_add_expr] = STATE(906),
    [sym_in_expr] = STATE(906),
    [sym_comp_term] = STATE(906),
    [sym_instance_of] = STATE(906),
    [sym_negation] = STATE(906),
    [sym_if_term] = STATE(906),
    [sym_conjunction] = STATE(906),
    [sym_disjunction] = STATE(906),
    [sym_implication] = STATE(906),
    [sym_quantified] = STATE(906),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(906),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [270] = {
    [sym_special_call] = STATE(391),
    [sym_prefix_cast] = STATE(391),
    [sym_unary_expr] = STATE(391),
    [sym_mul_expr] = STATE(391),
    [sym_add_expr] = STATE(391),
    [sym_in_expr] = STATE(391),
    [sym_comp_term] = STATE(391),
    [sym_instance_of] = STATE(391),
    [sym_negation] = STATE(391),
    [sym_if_term] = STATE(391),
    [sym_conjunction] = STATE(391),
    [sym_disjunction] = STATE(391),
    [sym_implication] = STATE(391),
    [sym_quantified] = STATE(391),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(391),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(335),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(341),
    [sym_result] = ACTIONS(343),
    [sym_super] = ACTIONS(345),
    [sym_this] = ACTIONS(343),
    [sym_true] = ACTIONS(341),
  },
  [271] = {
    [sym_special_call] = STATE(1092),
    [sym_prefix_cast] = STATE(1092),
    [sym_unary_expr] = STATE(1092),
    [sym_mul_expr] = STATE(1092),
    [sym_add_expr] = STATE(1092),
    [sym_in_expr] = STATE(1092),
    [sym_comp_term] = STATE(1092),
    [sym_instance_of] = STATE(1092),
    [sym_negation] = STATE(1092),
    [sym_if_term] = STATE(1092),
    [sym_conjunction] = STATE(1092),
    [sym_disjunction] = STATE(1092),
    [sym_implication] = STATE(1092),
    [sym_quantified] = STATE(1092),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1092),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [272] = {
    [sym_special_call] = STATE(1094),
    [sym_prefix_cast] = STATE(1094),
    [sym_unary_expr] = STATE(1094),
    [sym_mul_expr] = STATE(1094),
    [sym_add_expr] = STATE(1094),
    [sym_in_expr] = STATE(1094),
    [sym_comp_term] = STATE(1094),
    [sym_instance_of] = STATE(1094),
    [sym_negation] = STATE(1094),
    [sym_if_term] = STATE(1094),
    [sym_conjunction] = STATE(1094),
    [sym_disjunction] = STATE(1094),
    [sym_implication] = STATE(1094),
    [sym_quantified] = STATE(1094),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1094),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [273] = {
    [sym_special_call] = STATE(915),
    [sym_prefix_cast] = STATE(915),
    [sym_unary_expr] = STATE(915),
    [sym_mul_expr] = STATE(915),
    [sym_add_expr] = STATE(915),
    [sym_in_expr] = STATE(915),
    [sym_comp_term] = STATE(915),
    [sym_instance_of] = STATE(915),
    [sym_negation] = STATE(915),
    [sym_if_term] = STATE(915),
    [sym_conjunction] = STATE(915),
    [sym_disjunction] = STATE(915),
    [sym_implication] = STATE(915),
    [sym_quantified] = STATE(915),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(915),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [274] = {
    [sym_special_call] = STATE(1096),
    [sym_prefix_cast] = STATE(1096),
    [sym_unary_expr] = STATE(1096),
    [sym_mul_expr] = STATE(1096),
    [sym_add_expr] = STATE(1096),
    [sym_in_expr] = STATE(1096),
    [sym_comp_term] = STATE(1096),
    [sym_instance_of] = STATE(1096),
    [sym_negation] = STATE(1096),
    [sym_if_term] = STATE(1096),
    [sym_conjunction] = STATE(1096),
    [sym_disjunction] = STATE(1096),
    [sym_implication] = STATE(1096),
    [sym_quantified] = STATE(1096),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1096),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [275] = {
    [sym_special_call] = STATE(397),
    [sym_prefix_cast] = STATE(397),
    [sym_unary_expr] = STATE(397),
    [sym_mul_expr] = STATE(397),
    [sym_add_expr] = STATE(397),
    [sym_in_expr] = STATE(397),
    [sym_comp_term] = STATE(397),
    [sym_instance_of] = STATE(397),
    [sym_negation] = STATE(397),
    [sym_if_term] = STATE(397),
    [sym_conjunction] = STATE(397),
    [sym_disjunction] = STATE(397),
    [sym_implication] = STATE(397),
    [sym_quantified] = STATE(397),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(397),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(335),
    [sym_integer] = ACTIONS(337),
    [sym_float] = ACTIONS(339),
    [sym_string] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(341),
    [sym_result] = ACTIONS(343),
    [sym_super] = ACTIONS(345),
    [sym_this] = ACTIONS(343),
    [sym_true] = ACTIONS(341),
  },
  [276] = {
    [sym_special_call] = STATE(1098),
    [sym_prefix_cast] = STATE(1098),
    [sym_unary_expr] = STATE(1098),
    [sym_mul_expr] = STATE(1098),
    [sym_add_expr] = STATE(1098),
    [sym_in_expr] = STATE(1098),
    [sym_comp_term] = STATE(1098),
    [sym_instance_of] = STATE(1098),
    [sym_negation] = STATE(1098),
    [sym_if_term] = STATE(1098),
    [sym_conjunction] = STATE(1098),
    [sym_disjunction] = STATE(1098),
    [sym_implication] = STATE(1098),
    [sym_quantified] = STATE(1098),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1098),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [277] = {
    [sym_special_call] = STATE(1102),
    [sym_prefix_cast] = STATE(1102),
    [sym_unary_expr] = STATE(1102),
    [sym_mul_expr] = STATE(1102),
    [sym_add_expr] = STATE(1102),
    [sym_in_expr] = STATE(1102),
    [sym_comp_term] = STATE(1102),
    [sym_instance_of] = STATE(1102),
    [sym_negation] = STATE(1102),
    [sym_if_term] = STATE(1102),
    [sym_conjunction] = STATE(1102),
    [sym_disjunction] = STATE(1102),
    [sym_implication] = STATE(1102),
    [sym_quantified] = STATE(1102),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1102),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [278] = {
    [sym_special_call] = STATE(1143),
    [sym_prefix_cast] = STATE(1143),
    [sym_unary_expr] = STATE(1143),
    [sym_mul_expr] = STATE(1143),
    [sym_add_expr] = STATE(1143),
    [sym_in_expr] = STATE(1143),
    [sym_comp_term] = STATE(1143),
    [sym_instance_of] = STATE(1143),
    [sym_negation] = STATE(1143),
    [sym_if_term] = STATE(1143),
    [sym_conjunction] = STATE(1143),
    [sym_disjunction] = STATE(1143),
    [sym_implication] = STATE(1143),
    [sym_quantified] = STATE(1143),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1143),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1770),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [279] = {
    [sym_special_call] = STATE(1107),
    [sym_prefix_cast] = STATE(1107),
    [sym_unary_expr] = STATE(1107),
    [sym_mul_expr] = STATE(1107),
    [sym_add_expr] = STATE(1107),
    [sym_in_expr] = STATE(1107),
    [sym_comp_term] = STATE(1107),
    [sym_instance_of] = STATE(1107),
    [sym_negation] = STATE(1107),
    [sym_if_term] = STATE(1107),
    [sym_conjunction] = STATE(1107),
    [sym_disjunction] = STATE(1107),
    [sym_implication] = STATE(1107),
    [sym_quantified] = STATE(1107),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1107),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [280] = {
    [sym_special_call] = STATE(1108),
    [sym_prefix_cast] = STATE(1108),
    [sym_unary_expr] = STATE(1108),
    [sym_mul_expr] = STATE(1108),
    [sym_add_expr] = STATE(1108),
    [sym_in_expr] = STATE(1108),
    [sym_comp_term] = STATE(1108),
    [sym_instance_of] = STATE(1108),
    [sym_negation] = STATE(1108),
    [sym_if_term] = STATE(1108),
    [sym_conjunction] = STATE(1108),
    [sym_disjunction] = STATE(1108),
    [sym_implication] = STATE(1108),
    [sym_quantified] = STATE(1108),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1108),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(192),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_not] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(293),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(297),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [281] = {
    [sym_special_call] = STATE(937),
    [sym_prefix_cast] = STATE(937),
    [sym_unary_expr] = STATE(937),
    [sym_mul_expr] = STATE(937),
    [sym_add_expr] = STATE(937),
    [sym_in_expr] = STATE(937),
    [sym_comp_term] = STATE(937),
    [sym_instance_of] = STATE(937),
    [sym_negation] = STATE(937),
    [sym_if_term] = STATE(937),
    [sym_conjunction] = STATE(937),
    [sym_disjunction] = STATE(937),
    [sym_implication] = STATE(937),
    [sym_quantified] = STATE(937),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(937),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [282] = {
    [sym_special_call] = STATE(940),
    [sym_prefix_cast] = STATE(940),
    [sym_unary_expr] = STATE(940),
    [sym_mul_expr] = STATE(940),
    [sym_add_expr] = STATE(940),
    [sym_in_expr] = STATE(940),
    [sym_comp_term] = STATE(940),
    [sym_instance_of] = STATE(940),
    [sym_negation] = STATE(940),
    [sym_if_term] = STATE(940),
    [sym_conjunction] = STATE(940),
    [sym_disjunction] = STATE(940),
    [sym_implication] = STATE(940),
    [sym_quantified] = STATE(940),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(940),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [283] = {
    [sym_special_call] = STATE(1110),
    [sym_prefix_cast] = STATE(1110),
    [sym_unary_expr] = STATE(1110),
    [sym_mul_expr] = STATE(1110),
    [sym_add_expr] = STATE(1110),
    [sym_in_expr] = STATE(1110),
    [sym_comp_term] = STATE(1110),
    [sym_instance_of] = STATE(1110),
    [sym_negation] = STATE(1110),
    [sym_if_term] = STATE(1110),
    [sym_conjunction] = STATE(1110),
    [sym_disjunction] = STATE(1110),
    [sym_implication] = STATE(1110),
    [sym_quantified] = STATE(1110),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1110),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [284] = {
    [sym_special_call] = STATE(942),
    [sym_prefix_cast] = STATE(942),
    [sym_unary_expr] = STATE(942),
    [sym_mul_expr] = STATE(942),
    [sym_add_expr] = STATE(942),
    [sym_in_expr] = STATE(942),
    [sym_comp_term] = STATE(942),
    [sym_instance_of] = STATE(942),
    [sym_negation] = STATE(942),
    [sym_if_term] = STATE(942),
    [sym_conjunction] = STATE(942),
    [sym_disjunction] = STATE(942),
    [sym_implication] = STATE(942),
    [sym_quantified] = STATE(942),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(942),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [285] = {
    [sym_special_call] = STATE(1111),
    [sym_prefix_cast] = STATE(1111),
    [sym_unary_expr] = STATE(1111),
    [sym_mul_expr] = STATE(1111),
    [sym_add_expr] = STATE(1111),
    [sym_in_expr] = STATE(1111),
    [sym_comp_term] = STATE(1111),
    [sym_instance_of] = STATE(1111),
    [sym_negation] = STATE(1111),
    [sym_if_term] = STATE(1111),
    [sym_conjunction] = STATE(1111),
    [sym_disjunction] = STATE(1111),
    [sym_implication] = STATE(1111),
    [sym_quantified] = STATE(1111),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1111),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [286] = {
    [sym_special_call] = STATE(1112),
    [sym_prefix_cast] = STATE(1112),
    [sym_unary_expr] = STATE(1112),
    [sym_mul_expr] = STATE(1112),
    [sym_add_expr] = STATE(1112),
    [sym_in_expr] = STATE(1112),
    [sym_comp_term] = STATE(1112),
    [sym_instance_of] = STATE(1112),
    [sym_negation] = STATE(1112),
    [sym_if_term] = STATE(1112),
    [sym_conjunction] = STATE(1112),
    [sym_disjunction] = STATE(1112),
    [sym_implication] = STATE(1112),
    [sym_quantified] = STATE(1112),
    [sym_quantifier] = STATE(1849),
    [sym_call_or_unqual_agg_expr] = STATE(778),
    [sym_qualified_expr] = STATE(778),
    [sym_super_ref] = STATE(778),
    [sym_aggregate] = STATE(778),
    [sym_range] = STATE(778),
    [sym_set_literal] = STATE(778),
    [sym_par_expr] = STATE(778),
    [sym_expr_annotation] = STATE(778),
    [sym__exprOrTerm] = STATE(1112),
    [sym__primary] = STATE(778),
    [sym_literal] = STATE(778),
    [sym_bool] = STATE(767),
    [sym_variable] = STATE(778),
    [sym_unop] = STATE(222),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(1876),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(705),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(1883),
    [sym_aritylessPredicateExpr] = STATE(1486),
    [sym_varName] = STATE(772),
    [sym_aggId] = STATE(1783),
    [sym__lower_id] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_not] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(117),
    [sym_specialId] = ACTIONS(121),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [anon_sym_forex] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_boolean] = ACTIONS(27),
    [anon_sym_date] = ACTIONS(27),
    [anon_sym_float] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [sym_dbtype] = ACTIONS(29),
    [anon_sym_avg] = ACTIONS(55),
    [anon_sym_concat] = ACTIONS(55),
    [anon_sym_strictconcat] = ACTIONS(55),
    [anon_sym_count] = ACTIONS(55),
    [anon_sym_max] = ACTIONS(55),
    [anon_sym_min] = ACTIONS(55),
    [anon_sym_rank] = ACTIONS(55),
    [anon_sym_strictcount] = ACTIONS(55),
    [anon_sym_strictsum] = ACTIONS(55),
    [anon_sym_sum] = ACTIONS(55),
    [anon_sym_any] = ACTIONS(55),
    [anon_sym_unique] = ACTIONS(55),
    [sym__upper_id] = ACTIONS(127),
    [sym_integer] = ACTIONS(129),
    [sym_float] = ACTIONS(131),
    [sym_string] = ACTIONS(131),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym_false] = ACTIONS(133),
    [sym_result] = ACTIONS(135),
    [sym_super] = ACTIONS(137),
    [sym_this] = ACTIONS(135),
    [sym_true] = ACTIONS(133),
  },
  [287] = {
    [sym_special_call] = STATE(400),
    [sym_prefix_cast] = STATE(400),
    [sym_unary_expr] = STATE(400),
    [sym_mul_expr] = STATE(400),
    [sym_add_expr] = STATE(400),
    [sym_in_expr] = STATE(400),
    [sym_comp_term] = STATE(400),
    [sym_instance_of] = STATE(400),
    [sym_negation] = STATE(400),
    [sym_if_term] = STATE(400),
    [sym_conjunction] = STATE(400),
    [sym_disjunction] = STATE(400),
    [sym_implication] = STATE(400),
    [sym_quantified] = STATE(400),
    [sym_quantifier] = STATE(1838),
    [sym_call_or_unqual_agg_expr] = STATE(474),
    [sym_qualified_expr] = STATE(474),
    [sym_super_ref] = STATE(474),
    [sym_aggregate] = STATE(474),
    [sym_range] = STATE(474),
    [sym_set_literal] = STATE(474),
    [sym_par_expr] = STATE(474),
    [sym_expr_annotation] = STATE(474),
    [sym__exprOrTerm] = STATE(400),
    [sym__primary] = STATE(474),
    [sym_literal] = STATE(474),
    [sym_bool] = STATE(470),
    [sym_variable] = STATE(474),
    [sym_unop] = STATE(258),
    [sym_literalId] = STATE(1596),
    [sym_annotName] = STATE(2014),
    [sym_moduleName] = STATE(1897),
    [sym_moduleExpr] = STATE(1880),
    [sym_moduleInstantiation] = STATE(1461),
    [sym_primitiveType] = STATE(1437),
    [sym_simpleId] = STATE(419),
    [sym_className] = STATE(1443),
    [sym_typeExpr] = STATE(2009),
    [sym_aritylessPredicateExpr] = STATE(1472),
    [sym_varName] = STATE(472),
    [sym_aggId] = STATE(1773),
    [sym__lower_id] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_not] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(329),
    [sym_specialId] = ACTIONS(331),
    [anon_sym_exists] = ACTIONS(49),
    [anon_sym_forall] = ACTIONS(49),
    [an