#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1238
#define LARGE_STATE_COUNT 73
#define SYMBOL_COUNT 137
#define ALIAS_COUNT 0
#define TOKEN_COUNT 85
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 3
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 8

enum ts_symbol_identifiers {
  anon_sym_SEMI = 1,
  anon_sym_LBRACE = 2,
  anon_sym_RBRACE = 3,
  anon_sym_COLON = 4,
  anon_sym_main = 5,
  anon_sym_LPAREN = 6,
  anon_sym_RPAREN = 7,
  anon_sym_cd = 8,
  anon_sym_echo = 9,
  anon_sym_exit = 10,
  anon_sym_mv = 11,
  anon_sym_COMMA = 12,
  sym_reference = 13,
  anon_sym_EQ = 14,
  sym_preprocessor_directive = 15,
  sym_shebang = 16,
  anon_sym_pub = 17,
  anon_sym_fun = 18,
  anon_sym_return = 19,
  anon_sym_fail = 20,
  anon_sym_as = 21,
  anon_sym_import = 22,
  anon_sym_from = 23,
  anon_sym_STAR = 24,
  anon_sym_LBRACK = 25,
  anon_sym_RBRACK = 26,
  anon_sym_const = 27,
  anon_sym_let = 28,
  anon_sym_PLUS_EQ = 29,
  anon_sym_DASH_EQ = 30,
  anon_sym_STAR_EQ = 31,
  anon_sym_SLASH_EQ = 32,
  anon_sym_PERCENT_EQ = 33,
  anon_sym_if = 34,
  anon_sym_else = 35,
  anon_sym_then = 36,
  anon_sym_loop = 37,
  anon_sym_for = 38,
  anon_sym_in = 39,
  anon_sym_while = 40,
  anon_sym_break = 41,
  anon_sym_continue = 42,
  sym_boolean = 43,
  sym_null = 44,
  sym_number = 45,
  anon_sym_Text = 46,
  anon_sym_Num = 47,
  anon_sym_Int = 48,
  anon_sym_Bool = 49,
  anon_sym_Null = 50,
  sym_status = 51,
  anon_sym_len = 52,
  anon_sym_lines = 53,
  anon_sym_DASH = 54,
  anon_sym_not = 55,
  anon_sym_unsafe = 56,
  anon_sym_trust = 57,
  anon_sym_silent = 58,
  anon_sym_sudo = 59,
  anon_sym_nameof = 60,
  anon_sym_SLASH = 61,
  anon_sym_PLUS = 62,
  anon_sym_PERCENT = 63,
  anon_sym_GT = 64,
  anon_sym_LT = 65,
  anon_sym_GT_EQ = 66,
  anon_sym_LT_EQ = 67,
  anon_sym_EQ_EQ = 68,
  anon_sym_BANG_EQ = 69,
  anon_sym_and = 70,
  anon_sym_or = 71,
  anon_sym_is = 72,
  sym_variable = 73,
  sym_string_content = 74,
  anon_sym_DQUOTE = 75,
  anon_sym_failed = 76,
  anon_sym_succeeded = 77,
  anon_sym_exited = 78,
  sym_handler_propagation = 79,
  sym_escape_sequence = 80,
  sym_command_content = 81,
  anon_sym_DOLLAR = 82,
  sym_command_option = 83,
  sym_comment = 84,
  sym_source_file = 85,
  sym__global_statement = 86,
  sym__statement = 87,
  sym_block = 88,
  sym_main_block = 89,
  sym_builtin_stmt = 90,
  sym_mv_stmt = 91,
  sym_function_parameter_list_item = 92,
  sym_function_parameter_list = 93,
  sym_function_definition = 94,
  sym_function_control_flow = 95,
  sym_import_item = 96,
  sym_import_statement = 97,
  sym_parameter_list = 98,
  sym_subscript = 99,
  sym_subscript_expression = 100,
  sym_variable_init = 101,
  sym_variable_assignment = 102,
  sym_parentheses = 103,
  sym_if_cond = 104,
  sym_if_chain = 105,
  sym_if_ternary = 106,
  sym_loop_infinite = 107,
  sym_for_loop = 108,
  sym_while_loop = 109,
  sym_loop_control_flow = 110,
  sym_type_name_symbol = 111,
  sym_type_name = 112,
  sym_array = 113,
  sym_function_call = 114,
  sym_builtin_expr = 115,
  sym_unop = 116,
  sym_binop = 117,
  sym_keyword_binop = 118,
  sym_string = 119,
  sym_handler_failed = 120,
  sym_handler_succeeded = 121,
  sym_handler_exited = 122,
  sym_handler = 123,
  sym_interpolation = 124,
  sym_command = 125,
  sym_command_modifier_block = 126,
  sym__expression = 127,
  aux_sym_source_file_repeat1 = 128,
  aux_sym_block_repeat1 = 129,
  aux_sym_function_parameter_list_repeat1 = 130,
  aux_sym_import_statement_repeat1 = 131,
  aux_sym_parameter_list_repeat1 = 132,
  aux_sym_if_chain_repeat1 = 133,
  aux_sym_string_repeat1 = 134,
  aux_sym_command_repeat1 = 135,
  aux_sym_command_modifier_block_repeat1 = 136,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_SEMI] = ";",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_COLON] = ":",
  [anon_sym_main] = "main",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_cd] = "cd",
  [anon_sym_echo] = "echo",
  [anon_sym_exit] = "exit",
  [anon_sym_mv] = "mv",
  [anon_sym_COMMA] = ",",
  [sym_reference] = "reference",
  [anon_sym_EQ] = "=",
  [sym_preprocessor_directive] = "preprocessor_directive",
  [sym_shebang] = "shebang",
  [anon_sym_pub] = "pub",
  [anon_sym_fun] = "fun",
  [anon_sym_return] = "return",
  [anon_sym_fail] = "fail",
  [anon_sym_as] = "as",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_STAR] = "*",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_const] = "const",
  [anon_sym_let] = "let",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_then] = "then",
  [anon_sym_loop] = "loop",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [sym_boolean] = "boolean",
  [sym_null] = "null",
  [sym_number] = "number",
  [anon_sym_Text] = "Text",
  [anon_sym_Num] = "Num",
  [anon_sym_Int] = "Int",
  [anon_sym_Bool] = "Bool",
  [anon_sym_Null] = "Null",
  [sym_status] = "status",
  [anon_sym_len] = "len",
  [anon_sym_lines] = "lines",
  [anon_sym_DASH] = "-",
  [anon_sym_not] = "not",
  [anon_sym_unsafe] = "unsafe",
  [anon_sym_trust] = "trust",
  [anon_sym_silent] = "silent",
  [anon_sym_sudo] = "sudo",
  [anon_sym_nameof] = "nameof",
  [anon_sym_SLASH] = "/",
  [anon_sym_PLUS] = "+",
  [anon_sym_PERCENT] = "%",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_is] = "is",
  [sym_variable] = "variable",
  [sym_string_content] = "string_content",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_failed] = "failed",
  [anon_sym_succeeded] = "succeeded",
  [anon_sym_exited] = "exited",
  [sym_handler_propagation] = "handler_propagation",
  [sym_escape_sequence] = "escape_sequence",
  [sym_command_content] = "command_content",
  [anon_sym_DOLLAR] = "$",
  [sym_command_option] = "command_option",
  [sym_comment] = "comment",
  [sym_source_file] = "source_file",
  [sym__global_statement] = "_global_statement",
  [sym__statement] = "_statement",
  [sym_block] = "block",
  [sym_main_block] = "main_block",
  [sym_builtin_stmt] = "builtin_stmt",
  [sym_mv_stmt] = "mv_stmt",
  [sym_function_parameter_list_item] = "function_parameter_list_item",
  [sym_function_parameter_list] = "function_parameter_list",
  [sym_function_definition] = "function_definition",
  [sym_function_control_flow] = "function_control_flow",
  [sym_import_item] = "import_item",
  [sym_import_statement] = "import_statement",
  [sym_parameter_list] = "parameter_list",
  [sym_subscript] = "subscript",
  [sym_subscript_expression] = "subscript_expression",
  [sym_variable_init] = "variable_init",
  [sym_variable_assignment] = "variable_assignment",
  [sym_parentheses] = "parentheses",
  [sym_if_cond] = "if_cond",
  [sym_if_chain] = "if_chain",
  [sym_if_ternary] = "if_ternary",
  [sym_loop_infinite] = "loop_infinite",
  [sym_for_loop] = "for_loop",
  [sym_while_loop] = "while_loop",
  [sym_loop_control_flow] = "loop_control_flow",
  [sym_type_name_symbol] = "type_name_symbol",
  [sym_type_name] = "type_name",
  [sym_array] = "array",
  [sym_function_call] = "function_call",
  [sym_builtin_expr] = "builtin_expr",
  [sym_unop] = "unop",
  [sym_binop] = "binop",
  [sym_keyword_binop] = "keyword_binop",
  [sym_string] = "string",
  [sym_handler_failed] = "handler_failed",
  [sym_handler_succeeded] = "handler_succeeded",
  [sym_handler_exited] = "handler_exited",
  [sym_handler] = "handler",
  [sym_interpolation] = "interpolation",
  [sym_command] = "command",
  [sym_command_modifier_block] = "command_modifier_block",
  [sym__expression] = "_expression",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_function_parameter_list_repeat1] = "function_parameter_list_repeat1",
  [aux_sym_import_statement_repeat1] = "import_statement_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_if_chain_repeat1] = "if_chain_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_command_repeat1] = "command_repeat1",
  [aux_sym_command_modifier_block_repeat1] = "command_modifier_block_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_main] = anon_sym_main,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_cd] = anon_sym_cd,
  [anon_sym_echo] = anon_sym_echo,
  [anon_sym_exit] = anon_sym_exit,
  [anon_sym_mv] = anon_sym_mv,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [sym_reference] = sym_reference,
  [anon_sym_EQ] = anon_sym_EQ,
  [sym_preprocessor_directive] = sym_preprocessor_directive,
  [sym_shebang] = sym_shebang,
  [anon_sym_pub] = anon_sym_pub,
  [anon_sym_fun] = anon_sym_fun,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_fail] = anon_sym_fail,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_loop] = anon_sym_loop,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [sym_boolean] = sym_boolean,
  [sym_null] = sym_null,
  [sym_number] = sym_number,
  [anon_sym_Text] = anon_sym_Text,
  [anon_sym_Num] = anon_sym_Num,
  [anon_sym_Int] = anon_sym_Int,
  [anon_sym_Bool] = anon_sym_Bool,
  [anon_sym_Null] = anon_sym_Null,
  [sym_status] = sym_status,
  [anon_sym_len] = anon_sym_len,
  [anon_sym_lines] = anon_sym_lines,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_unsafe] = anon_sym_unsafe,
  [anon_sym_trust] = anon_sym_trust,
  [anon_sym_silent] = anon_sym_silent,
  [anon_sym_sudo] = anon_sym_sudo,
  [anon_sym_nameof] = anon_sym_nameof,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_is] = anon_sym_is,
  [sym_variable] = sym_variable,
  [sym_string_content] = sym_string_content,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_failed] = anon_sym_failed,
  [anon_sym_succeeded] = anon_sym_succeeded,
  [anon_sym_exited] = anon_sym_exited,
  [sym_handler_propagation] = sym_handler_propagation,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_command_content] = sym_command_content,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [sym_command_option] = sym_command_option,
  [sym_comment] = sym_comment,
  [sym_source_file] = sym_source_file,
  [sym__global_statement] = sym__global_statement,
  [sym__statement] = sym__statement,
  [sym_block] = sym_block,
  [sym_main_block] = sym_main_block,
  [sym_builtin_stmt] = sym_builtin_stmt,
  [sym_mv_stmt] = sym_mv_stmt,
  [sym_function_parameter_list_item] = sym_function_parameter_list_item,
  [sym_function_parameter_list] = sym_function_parameter_list,
  [sym_function_definition] = sym_function_definition,
  [sym_function_control_flow] = sym_function_control_flow,
  [sym_import_item] = sym_import_item,
  [sym_import_statement] = sym_import_statement,
  [sym_parameter_list] = sym_parameter_list,
  [sym_subscript] = sym_subscript,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_variable_init] = sym_variable_init,
  [sym_variable_assignment] = sym_variable_assignment,
  [sym_parentheses] = sym_parentheses,
  [sym_if_cond] = sym_if_cond,
  [sym_if_chain] = sym_if_chain,
  [sym_if_ternary] = sym_if_ternary,
  [sym_loop_infinite] = sym_loop_infinite,
  [sym_for_loop] = sym_for_loop,
  [sym_while_loop] = sym_while_loop,
  [sym_loop_control_flow] = sym_loop_control_flow,
  [sym_type_name_symbol] = sym_type_name_symbol,
  [sym_type_name] = sym_type_name,
  [sym_array] = sym_array,
  [sym_function_call] = sym_function_call,
  [sym_builtin_expr] = sym_builtin_expr,
  [sym_unop] = sym_unop,
  [sym_binop] = sym_binop,
  [sym_keyword_binop] = sym_keyword_binop,
  [sym_string] = sym_string,
  [sym_handler_failed] = sym_handler_failed,
  [sym_handler_succeeded] = sym_handler_succeeded,
  [sym_handler_exited] = sym_handler_exited,
  [sym_handler] = sym_handler,
  [sym_interpolation] = sym_interpolation,
  [sym_command] = sym_command,
  [sym_command_modifier_block] = sym_command_modifier_block,
  [sym__expression] = sym__expression,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_function_parameter_list_repeat1] = aux_sym_function_parameter_list_repeat1,
  [aux_sym_import_statement_repeat1] = aux_sym_import_statement_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_if_chain_repeat1] = aux_sym_if_chain_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_command_repeat1] = aux_sym_command_repeat1,
  [aux_sym_command_modifier_block_repeat1] = aux_sym_command_modifier_block_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_main] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cd] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_echo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [sym_reference] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_preprocessor_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_shebang] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_pub] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fun] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fail] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_loop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_Text] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Num] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Null] = {
    .visible = true,
    .named = false,
  },
  [sym_status] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_len] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lines] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsafe] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_trust] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_silent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sudo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nameof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_failed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_succeeded] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exited] = {
    .visible = true,
    .named = false,
  },
  [sym_handler_propagation] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_command_content] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym_command_option] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__global_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_main_block] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_mv_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter_list_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_control_flow] = {
    .visible = true,
    .named = true,
  },
  [sym_import_item] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_init] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_parentheses] = {
    .visible = true,
    .named = true,
  },
  [sym_if_cond] = {
    .visible = true,
    .named = true,
  },
  [sym_if_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_if_ternary] = {
    .visible = true,
    .named = true,
  },
  [sym_loop_infinite] = {
    .visible = true,
    .named = true,
  },
  [sym_for_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_while_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_loop_control_flow] = {
    .visible = true,
    .named = true,
  },
  [sym_type_name_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_unop] = {
    .visible = true,
    .named = true,
  },
  [sym_binop] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_binop] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_handler_failed] = {
    .visible = true,
    .named = true,
  },
  [sym_handler_succeeded] = {
    .visible = true,
    .named = true,
  },
  [sym_handler_exited] = {
    .visible = true,
    .named = true,
  },
  [sym_handler] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command_modifier_block] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_chain_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_modifier_block_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_body = 1,
  field_name = 2,
  field_parameters = 3,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_body] = "body",
  [field_name] = "name",
  [field_parameters] = "parameters",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 3},
  [3] = {.index = 4, .length = 3},
  [4] = {.index = 7, .length = 3},
  [5] = {.index = 10, .length = 3},
  [6] = {.index = 13, .length = 3},
  [7] = {.index = 16, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [4] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [7] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4},
  [10] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
  [13] =
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
  [16] =
    {field_body, 7},
    {field_name, 3},
    {field_parameters, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 7,
  [9] = 9,
  [10] = 4,
  [11] = 9,
  [12] = 12,
  [13] = 9,
  [14] = 12,
  [15] = 9,
  [16] = 12,
  [17] = 9,
  [18] = 12,
  [19] = 19,
  [20] = 12,
  [21] = 12,
  [22] = 9,
  [23] = 7,
  [24] = 12,
  [25] = 9,
  [26] = 12,
  [27] = 9,
  [28] = 5,
  [29] = 6,
  [30] = 12,
  [31] = 9,
  [32] = 7,
  [33] = 9,
  [34] = 12,
  [35] = 9,
  [36] = 12,
  [37] = 37,
  [38] = 37,
  [39] = 37,
  [40] = 37,
  [41] = 37,
  [42] = 37,
  [43] = 37,
  [44] = 37,
  [45] = 37,
  [46] = 37,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 37,
  [51] = 37,
  [52] = 52,
  [53] = 37,
  [54] = 54,
  [55] = 37,
  [56] = 37,
  [57] = 37,
  [58] = 37,
  [59] = 37,
  [60] = 60,
  [61] = 47,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 65,
  [67] = 7,
  [68] = 4,
  [69] = 7,
  [70] = 6,
  [71] = 5,
  [72] = 63,
  [73] = 4,
  [74] = 74,
  [75] = 6,
  [76] = 5,
  [77] = 7,
  [78] = 78,
  [79] = 7,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 81,
  [86] = 86,
  [87] = 87,
  [88] = 65,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 63,
  [93] = 93,
  [94] = 86,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 48,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 95,
  [105] = 90,
  [106] = 96,
  [107] = 107,
  [108] = 86,
  [109] = 81,
  [110] = 110,
  [111] = 63,
  [112] = 62,
  [113] = 86,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 97,
  [121] = 121,
  [122] = 91,
  [123] = 123,
  [124] = 107,
  [125] = 125,
  [126] = 82,
  [127] = 83,
  [128] = 128,
  [129] = 84,
  [130] = 87,
  [131] = 131,
  [132] = 132,
  [133] = 89,
  [134] = 134,
  [135] = 52,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 65,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 93,
  [146] = 146,
  [147] = 81,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 146,
  [152] = 144,
  [153] = 121,
  [154] = 123,
  [155] = 119,
  [156] = 150,
  [157] = 47,
  [158] = 132,
  [159] = 65,
  [160] = 103,
  [161] = 118,
  [162] = 136,
  [163] = 115,
  [164] = 137,
  [165] = 131,
  [166] = 125,
  [167] = 148,
  [168] = 138,
  [169] = 141,
  [170] = 102,
  [171] = 101,
  [172] = 117,
  [173] = 114,
  [174] = 116,
  [175] = 128,
  [176] = 140,
  [177] = 134,
  [178] = 100,
  [179] = 63,
  [180] = 149,
  [181] = 142,
  [182] = 110,
  [183] = 143,
  [184] = 98,
  [185] = 47,
  [186] = 65,
  [187] = 63,
  [188] = 89,
  [189] = 87,
  [190] = 84,
  [191] = 83,
  [192] = 82,
  [193] = 91,
  [194] = 81,
  [195] = 95,
  [196] = 93,
  [197] = 86,
  [198] = 97,
  [199] = 81,
  [200] = 86,
  [201] = 96,
  [202] = 90,
  [203] = 52,
  [204] = 82,
  [205] = 100,
  [206] = 110,
  [207] = 137,
  [208] = 81,
  [209] = 146,
  [210] = 62,
  [211] = 150,
  [212] = 149,
  [213] = 144,
  [214] = 142,
  [215] = 138,
  [216] = 134,
  [217] = 140,
  [218] = 132,
  [219] = 101,
  [220] = 91,
  [221] = 102,
  [222] = 131,
  [223] = 103,
  [224] = 141,
  [225] = 63,
  [226] = 65,
  [227] = 87,
  [228] = 84,
  [229] = 83,
  [230] = 136,
  [231] = 98,
  [232] = 123,
  [233] = 121,
  [234] = 86,
  [235] = 143,
  [236] = 93,
  [237] = 128,
  [238] = 148,
  [239] = 95,
  [240] = 107,
  [241] = 90,
  [242] = 125,
  [243] = 119,
  [244] = 97,
  [245] = 93,
  [246] = 118,
  [247] = 96,
  [248] = 107,
  [249] = 117,
  [250] = 116,
  [251] = 115,
  [252] = 81,
  [253] = 89,
  [254] = 48,
  [255] = 86,
  [256] = 114,
  [257] = 62,
  [258] = 138,
  [259] = 103,
  [260] = 136,
  [261] = 52,
  [262] = 98,
  [263] = 143,
  [264] = 148,
  [265] = 132,
  [266] = 123,
  [267] = 115,
  [268] = 102,
  [269] = 101,
  [270] = 121,
  [271] = 114,
  [272] = 140,
  [273] = 100,
  [274] = 131,
  [275] = 110,
  [276] = 141,
  [277] = 119,
  [278] = 137,
  [279] = 118,
  [280] = 146,
  [281] = 117,
  [282] = 116,
  [283] = 48,
  [284] = 150,
  [285] = 149,
  [286] = 144,
  [287] = 63,
  [288] = 142,
  [289] = 134,
  [290] = 65,
  [291] = 128,
  [292] = 125,
  [293] = 7,
  [294] = 4,
  [295] = 5,
  [296] = 6,
  [297] = 7,
  [298] = 100,
  [299] = 110,
  [300] = 146,
  [301] = 107,
  [302] = 100,
  [303] = 150,
  [304] = 128,
  [305] = 103,
  [306] = 110,
  [307] = 125,
  [308] = 102,
  [309] = 142,
  [310] = 101,
  [311] = 103,
  [312] = 144,
  [313] = 134,
  [314] = 107,
  [315] = 101,
  [316] = 316,
  [317] = 146,
  [318] = 150,
  [319] = 149,
  [320] = 149,
  [321] = 144,
  [322] = 142,
  [323] = 134,
  [324] = 102,
  [325] = 128,
  [326] = 125,
  [327] = 327,
  [328] = 328,
  [329] = 47,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 63,
  [336] = 143,
  [337] = 337,
  [338] = 338,
  [339] = 148,
  [340] = 65,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 81,
  [349] = 349,
  [350] = 97,
  [351] = 347,
  [352] = 90,
  [353] = 349,
  [354] = 95,
  [355] = 96,
  [356] = 347,
  [357] = 349,
  [358] = 349,
  [359] = 349,
  [360] = 347,
  [361] = 349,
  [362] = 347,
  [363] = 347,
  [364] = 93,
  [365] = 347,
  [366] = 82,
  [367] = 91,
  [368] = 86,
  [369] = 349,
  [370] = 349,
  [371] = 347,
  [372] = 349,
  [373] = 347,
  [374] = 347,
  [375] = 83,
  [376] = 86,
  [377] = 84,
  [378] = 93,
  [379] = 81,
  [380] = 349,
  [381] = 381,
  [382] = 87,
  [383] = 347,
  [384] = 89,
  [385] = 349,
  [386] = 128,
  [387] = 123,
  [388] = 142,
  [389] = 389,
  [390] = 144,
  [391] = 389,
  [392] = 149,
  [393] = 150,
  [394] = 389,
  [395] = 146,
  [396] = 110,
  [397] = 100,
  [398] = 101,
  [399] = 102,
  [400] = 103,
  [401] = 141,
  [402] = 107,
  [403] = 125,
  [404] = 128,
  [405] = 63,
  [406] = 140,
  [407] = 134,
  [408] = 142,
  [409] = 144,
  [410] = 149,
  [411] = 389,
  [412] = 150,
  [413] = 107,
  [414] = 138,
  [415] = 65,
  [416] = 389,
  [417] = 146,
  [418] = 125,
  [419] = 110,
  [420] = 100,
  [421] = 101,
  [422] = 102,
  [423] = 137,
  [424] = 103,
  [425] = 136,
  [426] = 52,
  [427] = 107,
  [428] = 132,
  [429] = 131,
  [430] = 98,
  [431] = 134,
  [432] = 121,
  [433] = 119,
  [434] = 118,
  [435] = 117,
  [436] = 116,
  [437] = 143,
  [438] = 115,
  [439] = 389,
  [440] = 48,
  [441] = 389,
  [442] = 148,
  [443] = 389,
  [444] = 114,
  [445] = 62,
  [446] = 389,
  [447] = 447,
  [448] = 144,
  [449] = 449,
  [450] = 450,
  [451] = 447,
  [452] = 149,
  [453] = 450,
  [454] = 454,
  [455] = 454,
  [456] = 447,
  [457] = 447,
  [458] = 447,
  [459] = 459,
  [460] = 447,
  [461] = 449,
  [462] = 450,
  [463] = 454,
  [464] = 103,
  [465] = 100,
  [466] = 466,
  [467] = 449,
  [468] = 447,
  [469] = 447,
  [470] = 447,
  [471] = 102,
  [472] = 447,
  [473] = 447,
  [474] = 459,
  [475] = 316,
  [476] = 447,
  [477] = 459,
  [478] = 101,
  [479] = 454,
  [480] = 459,
  [481] = 449,
  [482] = 150,
  [483] = 454,
  [484] = 454,
  [485] = 447,
  [486] = 142,
  [487] = 459,
  [488] = 134,
  [489] = 459,
  [490] = 449,
  [491] = 450,
  [492] = 128,
  [493] = 447,
  [494] = 450,
  [495] = 146,
  [496] = 450,
  [497] = 125,
  [498] = 449,
  [499] = 450,
  [500] = 449,
  [501] = 110,
  [502] = 450,
  [503] = 450,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 504,
  [512] = 505,
  [513] = 513,
  [514] = 514,
  [515] = 513,
  [516] = 516,
  [517] = 517,
  [518] = 514,
  [519] = 516,
  [520] = 516,
  [521] = 506,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 522,
  [527] = 527,
  [528] = 517,
  [529] = 525,
  [530] = 527,
  [531] = 524,
  [532] = 523,
  [533] = 517,
  [534] = 505,
  [535] = 506,
  [536] = 510,
  [537] = 522,
  [538] = 525,
  [539] = 524,
  [540] = 523,
  [541] = 504,
  [542] = 517,
  [543] = 527,
  [544] = 509,
  [545] = 509,
  [546] = 523,
  [547] = 524,
  [548] = 504,
  [549] = 525,
  [550] = 508,
  [551] = 510,
  [552] = 516,
  [553] = 522,
  [554] = 506,
  [555] = 505,
  [556] = 513,
  [557] = 506,
  [558] = 517,
  [559] = 522,
  [560] = 514,
  [561] = 525,
  [562] = 524,
  [563] = 516,
  [564] = 504,
  [565] = 527,
  [566] = 506,
  [567] = 517,
  [568] = 523,
  [569] = 516,
  [570] = 510,
  [571] = 504,
  [572] = 510,
  [573] = 517,
  [574] = 505,
  [575] = 516,
  [576] = 514,
  [577] = 513,
  [578] = 516,
  [579] = 505,
  [580] = 509,
  [581] = 504,
  [582] = 527,
  [583] = 517,
  [584] = 505,
  [585] = 513,
  [586] = 523,
  [587] = 510,
  [588] = 516,
  [589] = 504,
  [590] = 504,
  [591] = 591,
  [592] = 505,
  [593] = 593,
  [594] = 514,
  [595] = 510,
  [596] = 517,
  [597] = 516,
  [598] = 509,
  [599] = 505,
  [600] = 516,
  [601] = 509,
  [602] = 510,
  [603] = 506,
  [604] = 510,
  [605] = 509,
  [606] = 504,
  [607] = 513,
  [608] = 510,
  [609] = 514,
  [610] = 610,
  [611] = 504,
  [612] = 612,
  [613] = 516,
  [614] = 508,
  [615] = 517,
  [616] = 508,
  [617] = 617,
  [618] = 510,
  [619] = 522,
  [620] = 507,
  [621] = 525,
  [622] = 593,
  [623] = 508,
  [624] = 617,
  [625] = 527,
  [626] = 517,
  [627] = 524,
  [628] = 507,
  [629] = 523,
  [630] = 522,
  [631] = 525,
  [632] = 593,
  [633] = 508,
  [634] = 508,
  [635] = 617,
  [636] = 522,
  [637] = 516,
  [638] = 505,
  [639] = 524,
  [640] = 507,
  [641] = 523,
  [642] = 593,
  [643] = 516,
  [644] = 508,
  [645] = 617,
  [646] = 525,
  [647] = 509,
  [648] = 507,
  [649] = 593,
  [650] = 527,
  [651] = 517,
  [652] = 652,
  [653] = 507,
  [654] = 617,
  [655] = 517,
  [656] = 504,
  [657] = 506,
  [658] = 658,
  [659] = 505,
  [660] = 524,
  [661] = 506,
  [662] = 662,
  [663] = 522,
  [664] = 525,
  [665] = 524,
  [666] = 523,
  [667] = 504,
  [668] = 510,
  [669] = 509,
  [670] = 508,
  [671] = 514,
  [672] = 513,
  [673] = 652,
  [674] = 617,
  [675] = 505,
  [676] = 507,
  [677] = 593,
  [678] = 510,
  [679] = 504,
  [680] = 505,
  [681] = 510,
  [682] = 517,
  [683] = 505,
  [684] = 7,
  [685] = 7,
  [686] = 6,
  [687] = 5,
  [688] = 4,
  [689] = 6,
  [690] = 5,
  [691] = 4,
  [692] = 4,
  [693] = 5,
  [694] = 6,
  [695] = 47,
  [696] = 63,
  [697] = 65,
  [698] = 7,
  [699] = 7,
  [700] = 96,
  [701] = 100,
  [702] = 102,
  [703] = 93,
  [704] = 89,
  [705] = 90,
  [706] = 95,
  [707] = 4,
  [708] = 5,
  [709] = 6,
  [710] = 91,
  [711] = 87,
  [712] = 84,
  [713] = 82,
  [714] = 103,
  [715] = 316,
  [716] = 97,
  [717] = 101,
  [718] = 81,
  [719] = 110,
  [720] = 107,
  [721] = 146,
  [722] = 150,
  [723] = 149,
  [724] = 83,
  [725] = 144,
  [726] = 142,
  [727] = 466,
  [728] = 134,
  [729] = 128,
  [730] = 125,
  [731] = 96,
  [732] = 86,
  [733] = 733,
  [734] = 138,
  [735] = 148,
  [736] = 123,
  [737] = 107,
  [738] = 121,
  [739] = 149,
  [740] = 110,
  [741] = 98,
  [742] = 143,
  [743] = 48,
  [744] = 62,
  [745] = 140,
  [746] = 93,
  [747] = 96,
  [748] = 114,
  [749] = 93,
  [750] = 116,
  [751] = 89,
  [752] = 118,
  [753] = 95,
  [754] = 117,
  [755] = 101,
  [756] = 102,
  [757] = 107,
  [758] = 146,
  [759] = 134,
  [760] = 90,
  [761] = 316,
  [762] = 115,
  [763] = 131,
  [764] = 132,
  [765] = 137,
  [766] = 144,
  [767] = 142,
  [768] = 466,
  [769] = 100,
  [770] = 141,
  [771] = 136,
  [772] = 150,
  [773] = 128,
  [774] = 119,
  [775] = 125,
  [776] = 52,
  [777] = 103,
  [778] = 91,
  [779] = 84,
  [780] = 82,
  [781] = 91,
  [782] = 84,
  [783] = 82,
  [784] = 784,
  [785] = 784,
  [786] = 786,
  [787] = 787,
  [788] = 786,
  [789] = 784,
  [790] = 784,
  [791] = 791,
  [792] = 784,
  [793] = 787,
  [794] = 794,
  [795] = 794,
  [796] = 796,
  [797] = 787,
  [798] = 786,
  [799] = 791,
  [800] = 787,
  [801] = 796,
  [802] = 802,
  [803] = 784,
  [804] = 786,
  [805] = 791,
  [806] = 784,
  [807] = 787,
  [808] = 786,
  [809] = 791,
  [810] = 791,
  [811] = 787,
  [812] = 791,
  [813] = 786,
  [814] = 787,
  [815] = 802,
  [816] = 796,
  [817] = 791,
  [818] = 802,
  [819] = 791,
  [820] = 784,
  [821] = 791,
  [822] = 787,
  [823] = 787,
  [824] = 791,
  [825] = 786,
  [826] = 802,
  [827] = 786,
  [828] = 787,
  [829] = 784,
  [830] = 81,
  [831] = 86,
  [832] = 791,
  [833] = 786,
  [834] = 787,
  [835] = 784,
  [836] = 836,
  [837] = 784,
  [838] = 786,
  [839] = 794,
  [840] = 796,
  [841] = 786,
  [842] = 784,
  [843] = 786,
  [844] = 791,
  [845] = 802,
  [846] = 787,
  [847] = 784,
  [848] = 787,
  [849] = 791,
  [850] = 786,
  [851] = 787,
  [852] = 796,
  [853] = 794,
  [854] = 784,
  [855] = 791,
  [856] = 786,
  [857] = 857,
  [858] = 796,
  [859] = 794,
  [860] = 794,
  [861] = 802,
  [862] = 796,
  [863] = 86,
  [864] = 96,
  [865] = 865,
  [866] = 866,
  [867] = 93,
  [868] = 868,
  [869] = 869,
  [870] = 93,
  [871] = 81,
  [872] = 872,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 876,
  [878] = 874,
  [879] = 872,
  [880] = 873,
  [881] = 875,
  [882] = 875,
  [883] = 872,
  [884] = 874,
  [885] = 876,
  [886] = 875,
  [887] = 875,
  [888] = 875,
  [889] = 874,
  [890] = 872,
  [891] = 891,
  [892] = 872,
  [893] = 876,
  [894] = 876,
  [895] = 875,
  [896] = 876,
  [897] = 875,
  [898] = 82,
  [899] = 84,
  [900] = 874,
  [901] = 872,
  [902] = 875,
  [903] = 876,
  [904] = 874,
  [905] = 91,
  [906] = 906,
  [907] = 906,
  [908] = 906,
  [909] = 909,
  [910] = 906,
  [911] = 911,
  [912] = 906,
  [913] = 906,
  [914] = 906,
  [915] = 906,
  [916] = 906,
  [917] = 906,
  [918] = 906,
  [919] = 906,
  [920] = 906,
  [921] = 906,
  [922] = 922,
  [923] = 923,
  [924] = 923,
  [925] = 923,
  [926] = 922,
  [927] = 922,
  [928] = 928,
  [929] = 929,
  [930] = 922,
  [931] = 923,
  [932] = 929,
  [933] = 922,
  [934] = 923,
  [935] = 922,
  [936] = 923,
  [937] = 923,
  [938] = 922,
  [939] = 929,
  [940] = 923,
  [941] = 929,
  [942] = 929,
  [943] = 929,
  [944] = 923,
  [945] = 929,
  [946] = 929,
  [947] = 929,
  [948] = 922,
  [949] = 922,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 951,
  [954] = 952,
  [955] = 955,
  [956] = 952,
  [957] = 950,
  [958] = 950,
  [959] = 950,
  [960] = 960,
  [961] = 952,
  [962] = 952,
  [963] = 951,
  [964] = 952,
  [965] = 952,
  [966] = 966,
  [967] = 951,
  [968] = 952,
  [969] = 952,
  [970] = 952,
  [971] = 950,
  [972] = 952,
  [973] = 950,
  [974] = 950,
  [975] = 952,
  [976] = 951,
  [977] = 952,
  [978] = 952,
  [979] = 951,
  [980] = 951,
  [981] = 981,
  [982] = 981,
  [983] = 981,
  [984] = 981,
  [985] = 981,
  [986] = 986,
  [987] = 981,
  [988] = 981,
  [989] = 981,
  [990] = 981,
  [991] = 991,
  [992] = 986,
  [993] = 993,
  [994] = 994,
  [995] = 995,
  [996] = 996,
  [997] = 997,
  [998] = 998,
  [999] = 999,
  [1000] = 1000,
  [1001] = 1001,
  [1002] = 1002,
  [1003] = 1000,
  [1004] = 1000,
  [1005] = 1001,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1000,
  [1009] = 1001,
  [1010] = 1006,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1000,
  [1014] = 1000,
  [1015] = 998,
  [1016] = 1007,
  [1017] = 997,
  [1018] = 1000,
  [1019] = 1001,
  [1020] = 998,
  [1021] = 1001,
  [1022] = 1001,
  [1023] = 1002,
  [1024] = 1007,
  [1025] = 1012,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 1029,
  [1030] = 1001,
  [1031] = 1011,
  [1032] = 1011,
  [1033] = 1011,
  [1034] = 1012,
  [1035] = 1035,
  [1036] = 1036,
  [1037] = 1001,
  [1038] = 1011,
  [1039] = 107,
  [1040] = 1007,
  [1041] = 1012,
  [1042] = 1000,
  [1043] = 1007,
  [1044] = 1006,
  [1045] = 1012,
  [1046] = 1000,
  [1047] = 1011,
  [1048] = 1001,
  [1049] = 1006,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1000,
  [1053] = 1002,
  [1054] = 997,
  [1055] = 1012,
  [1056] = 998,
  [1057] = 1002,
  [1058] = 1002,
  [1059] = 1059,
  [1060] = 1007,
  [1061] = 1000,
  [1062] = 997,
  [1063] = 1012,
  [1064] = 997,
  [1065] = 1011,
  [1066] = 998,
  [1067] = 1006,
  [1068] = 1068,
  [1069] = 1000,
  [1070] = 1000,
  [1071] = 1006,
  [1072] = 1002,
  [1073] = 1000,
  [1074] = 997,
  [1075] = 1075,
  [1076] = 998,
  [1077] = 1001,
  [1078] = 1011,
  [1079] = 1079,
  [1080] = 1012,
  [1081] = 1011,
  [1082] = 1082,
  [1083] = 997,
  [1084] = 1006,
  [1085] = 998,
  [1086] = 1012,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 997,
  [1091] = 1006,
  [1092] = 998,
  [1093] = 1006,
  [1094] = 998,
  [1095] = 997,
  [1096] = 997,
  [1097] = 998,
  [1098] = 998,
  [1099] = 1001,
  [1100] = 1100,
  [1101] = 997,
  [1102] = 1102,
  [1103] = 1102,
  [1104] = 1102,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1106,
  [1108] = 1102,
  [1109] = 1106,
  [1110] = 1102,
  [1111] = 1102,
  [1112] = 1106,
  [1113] = 1102,
  [1114] = 1106,
  [1115] = 1106,
  [1116] = 1102,
  [1117] = 1106,
  [1118] = 1102,
  [1119] = 1102,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1102,
  [1124] = 1106,
  [1125] = 1125,
  [1126] = 1121,
  [1127] = 1106,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1106,
  [1131] = 1131,
  [1132] = 1121,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1102,
  [1137] = 1106,
  [1138] = 1138,
  [1139] = 1121,
  [1140] = 466,
  [1141] = 1121,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1106,
  [1145] = 1145,
  [1146] = 1146,
  [1147] = 1147,
  [1148] = 1121,
  [1149] = 1149,
  [1150] = 1102,
  [1151] = 1106,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 1102,
  [1155] = 1106,
  [1156] = 1121,
  [1157] = 1121,
  [1158] = 1121,
  [1159] = 1159,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 1162,
  [1163] = 1161,
  [1164] = 1162,
  [1165] = 1165,
  [1166] = 1159,
  [1167] = 1167,
  [1168] = 1159,
  [1169] = 1167,
  [1170] = 1167,
  [1171] = 1159,
  [1172] = 1167,
  [1173] = 1159,
  [1174] = 1167,
  [1175] = 1159,
  [1176] = 1167,
  [1177] = 1159,
  [1178] = 1167,
  [1179] = 1159,
  [1180] = 1167,
  [1181] = 1159,
  [1182] = 1167,
  [1183] = 1159,
  [1184] = 1167,
  [1185] = 1159,
  [1186] = 1167,
  [1187] = 1165,
  [1188] = 1167,
  [1189] = 1189,
  [1190] = 1165,
  [1191] = 1191,
  [1192] = 1192,
  [1193] = 1162,
  [1194] = 1161,
  [1195] = 1165,
  [1196] = 1196,
  [1197] = 1161,
  [1198] = 1162,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1161,
  [1202] = 1165,
  [1203] = 1161,
  [1204] = 1204,
  [1205] = 1205,
  [1206] = 1161,
  [1207] = 1207,
  [1208] = 1165,
  [1209] = 1209,
  [1210] = 1162,
  [1211] = 1162,
  [1212] = 1165,
  [1213] = 1213,
  [1214] = 1162,
  [1215] = 1167,
  [1216] = 1161,
  [1217] = 1162,
  [1218] = 1161,
  [1219] = 1162,
  [1220] = 1220,
  [1221] = 1159,
  [1222] = 1165,
  [1223] = 1162,
  [1224] = 1159,
  [1225] = 1165,
  [1226] = 1165,
  [1227] = 1161,
  [1228] = 1165,
  [1229] = 1229,
  [1230] = 1161,
  [1231] = 1162,
  [1232] = 1232,
  [1233] = 1165,
  [1234] = 1165,
  [1235] = 1159,
  [1236] = 1167,
  [1237] = 1165,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(149);
      ADVANCE_MAP(
        '!', 19,
        '"', 416,
        '#', 9,
        '$', 430,
        '%', 261,
        '(', 156,
        ')', 157,
        '*', 188,
        '+', 258,
        ',', 167,
        '-', 241,
        '/', 256,
        ':', 153,
        ';', 150,
        '<', 263,
        '=', 170,
        '>', 262,
        '?', 423,
        'B', 102,
        'I', 88,
        'N', 132,
        'T', 40,
        '[', 189,
        '\\', 425,
        ']', 190,
        'a', 89,
        'b', 112,
        'c', 34,
        'e', 32,
        'f', 22,
        'i', 59,
        'l', 41,
        'm', 26,
        'n', 23,
        'o', 110,
        'p', 133,
        'r', 42,
        's', 67,
        't', 65,
        'u', 96,
        'w', 63,
        '{', 151,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(221);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 19,
        '"', 416,
        '#', 8,
        '$', 430,
        '%', 261,
        '(', 156,
        '*', 188,
        '+', 258,
        '-', 241,
        '/', 256,
        ';', 150,
        '<', 263,
        '=', 170,
        '>', 262,
        'B', 371,
        'I', 356,
        'N', 403,
        'T', 299,
        '[', 189,
        'a', 365,
        'b', 381,
        'c', 292,
        'e', 289,
        'f', 275,
        'i', 322,
        'l', 300,
        'm', 409,
        'n', 276,
        'o', 379,
        'r', 308,
        's', 330,
        't', 329,
        'u', 357,
        'w', 327,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 19,
        '"', 416,
        '#', 8,
        '$', 430,
        '%', 261,
        '(', 156,
        '*', 188,
        '+', 258,
        '-', 241,
        '/', 256,
        ';', 150,
        '<', 263,
        '=', 170,
        '>', 262,
        'B', 371,
        'I', 356,
        'N', 403,
        'T', 299,
        '[', 189,
        'a', 365,
        'b', 381,
        'c', 292,
        'e', 287,
        'f', 275,
        'i', 322,
        'l', 300,
        'm', 409,
        'n', 276,
        'o', 379,
        'r', 308,
        's', 330,
        't', 329,
        'u', 357,
        'w', 327,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 19,
        '"', 416,
        '#', 8,
        '$', 430,
        '%', 260,
        '(', 156,
        '*', 187,
        '+', 259,
        '-', 242,
        '/', 255,
        ';', 150,
        '<', 263,
        '=', 20,
        '>', 262,
        '?', 423,
        'B', 371,
        'I', 356,
        'N', 403,
        'T', 299,
        '[', 189,
        'a', 365,
        'b', 381,
        'c', 292,
        'e', 288,
        'f', 281,
        'i', 322,
        'l', 300,
        'm', 409,
        'n', 276,
        'o', 379,
        'r', 308,
        's', 331,
        't', 329,
        'u', 357,
        'w', 327,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 19,
        '"', 416,
        '#', 8,
        '$', 430,
        '%', 260,
        '(', 156,
        '*', 187,
        '+', 259,
        '-', 242,
        '/', 255,
        ';', 150,
        '<', 263,
        '=', 20,
        '>', 262,
        '?', 423,
        'B', 371,
        'I', 356,
        'N', 403,
        'T', 299,
        '[', 189,
        'a', 365,
        'b', 381,
        'c', 292,
        'e', 290,
        'f', 281,
        'i', 322,
        'l', 300,
        'm', 409,
        'n', 276,
        'o', 379,
        'r', 308,
        's', 331,
        't', 329,
        'u', 357,
        'w', 327,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 19,
        '"', 416,
        '$', 430,
        '%', 261,
        '(', 156,
        '*', 188,
        '+', 258,
        '-', 241,
        '/', 256,
        ';', 150,
        '<', 263,
        '=', 170,
        '>', 262,
        'B', 371,
        'I', 356,
        'N', 403,
        'T', 299,
        '[', 189,
        'a', 365,
        'e', 354,
        'f', 283,
        'i', 386,
        'l', 317,
        'n', 276,
        'o', 379,
        's', 330,
        't', 329,
        'u', 357,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 19,
        '"', 416,
        '$', 430,
        '%', 260,
        '(', 156,
        '*', 187,
        '+', 259,
        '-', 242,
        '/', 255,
        ';', 150,
        '<', 263,
        '=', 20,
        '>', 262,
        '?', 423,
        'B', 371,
        'I', 356,
        'N', 403,
        'T', 299,
        '[', 189,
        'a', 365,
        'e', 353,
        'f', 284,
        'i', 386,
        'l', 317,
        'n', 276,
        'o', 379,
        's', 331,
        't', 329,
        'u', 357,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 19,
        '%', 261,
        '(', 156,
        ')', 157,
        '*', 188,
        '+', 257,
        ',', 167,
        '-', 240,
        '/', 256,
        ':', 153,
        ';', 150,
        '<', 263,
        '=', 170,
        '>', 262,
        '?', 423,
        '[', 189,
        ']', 190,
        'a', 89,
        'e', 76,
        'f', 28,
        'i', 115,
        'o', 110,
        's', 135,
        't', 64,
        '{', 151,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(172);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(172);
      if (lookahead == '[') ADVANCE(142);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '"', 416,
        '#', 8,
        '$', 430,
        '(', 156,
        '+', 140,
        '-', 242,
        '/', 17,
        ';', 150,
        'B', 371,
        'I', 356,
        'N', 403,
        'T', 299,
        '[', 189,
        'b', 381,
        'c', 292,
        'e', 289,
        'f', 275,
        'i', 323,
        'l', 300,
        'm', 409,
        'n', 276,
        'r', 308,
        's', 330,
        't', 380,
        'u', 357,
        'w', 327,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(10);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '"', 416,
        '#', 8,
        '$', 430,
        '(', 156,
        '+', 140,
        '-', 242,
        '/', 17,
        ';', 150,
        'B', 371,
        'I', 356,
        'N', 403,
        'T', 299,
        '[', 189,
        'b', 381,
        'c', 292,
        'e', 287,
        'f', 275,
        'i', 323,
        'l', 300,
        'm', 409,
        'n', 276,
        'r', 308,
        's', 330,
        't', 380,
        'u', 357,
        'w', 327,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '"', 416,
        '$', 430,
        '(', 156,
        ')', 157,
        '+', 140,
        '-', 242,
        '/', 17,
        ':', 153,
        'B', 371,
        'I', 356,
        'N', 403,
        'T', 299,
        '[', 189,
        ']', 190,
        'f', 283,
        'l', 317,
        'n', 276,
        's', 330,
        't', 380,
        'u', 357,
        '{', 151,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '"', 416,
        '$', 430,
        '(', 156,
        '+', 140,
        '-', 242,
        '/', 17,
        ';', 150,
        'B', 371,
        'I', 356,
        'N', 403,
        'T', 299,
        '[', 189,
        'e', 354,
        'f', 283,
        'l', 317,
        'n', 276,
        's', 330,
        't', 380,
        'u', 357,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(416);
      if (lookahead == '/') ADVANCE(414);
      if (lookahead == '\\') ADVANCE(425);
      if (lookahead == '{') ADVANCE(151);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(413);
      if (lookahead != 0) ADVANCE(415);
      END_STATE();
    case 15:
      if (lookahead == '$') ADVANCE(430);
      if (lookahead == '-') ADVANCE(431);
      if (lookahead == '/') ADVANCE(428);
      if (lookahead == '\\') ADVANCE(425);
      if (lookahead == '{') ADVANCE(151);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(427);
      if (lookahead != 0) ADVANCE(429);
      END_STATE();
    case 16:
      if (lookahead == ')') ADVANCE(157);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == 'r') ADVANCE(312);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 17:
      if (lookahead == '/') ADVANCE(433);
      END_STATE();
    case 18:
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '}') ADVANCE(152);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(18);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(267);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(266);
      END_STATE();
    case 21:
      if (lookahead == ']') ADVANCE(171);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(21);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(69);
      if (lookahead == 'o') ADVANCE(111);
      if (lookahead == 'r') ADVANCE(104);
      if (lookahead == 'u') ADVANCE(91);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(87);
      if (lookahead == 'o') ADVANCE(123);
      if (lookahead == 'u') ADVANCE(82);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(75);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(70);
      if (lookahead == 'v') ADVANCE(165);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(74);
      END_STATE();
    case 29:
      if (lookahead == 'b') ADVANCE(173);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(33);
      END_STATE();
    case 31:
      if (lookahead == 'c') ADVANCE(33);
      if (lookahead == 'd') ADVANCE(101);
      END_STATE();
    case 32:
      if (lookahead == 'c') ADVANCE(66);
      if (lookahead == 'l') ADVANCE(119);
      if (lookahead == 'x') ADVANCE(68);
      END_STATE();
    case 33:
      if (lookahead == 'c') ADVANCE(57);
      END_STATE();
    case 34:
      if (lookahead == 'd') ADVANCE(158);
      if (lookahead == 'o') ADVANCE(90);
      END_STATE();
    case 35:
      if (lookahead == 'd') ADVANCE(268);
      END_STATE();
    case 36:
      if (lookahead == 'd') ADVANCE(421);
      END_STATE();
    case 37:
      if (lookahead == 'd') ADVANCE(417);
      END_STATE();
    case 38:
      if (lookahead == 'd') ADVANCE(419);
      END_STATE();
    case 39:
      if (lookahead == 'd') ADVANCE(54);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(92);
      if (lookahead == 'i') ADVANCE(98);
      if (lookahead == 'o') ADVANCE(103);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(217);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(217);
      if (lookahead == 's') ADVANCE(127);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(211);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(245);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(37);
      END_STATE();
    case 52:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(105);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 59:
      if (lookahead == 'f') ADVANCE(200);
      if (lookahead == 'm') ADVANCE(109);
      if (lookahead == 'n') ADVANCE(210);
      if (lookahead == 's') ADVANCE(272);
      END_STATE();
    case 60:
      if (lookahead == 'f') ADVANCE(168);
      if (lookahead == 't') ADVANCE(137);
      END_STATE();
    case 61:
      if (lookahead == 'f') ADVANCE(253);
      END_STATE();
    case 62:
      if (lookahead == 'f') ADVANCE(47);
      END_STATE();
    case 63:
      if (lookahead == 'h') ADVANCE(73);
      END_STATE();
    case 64:
      if (lookahead == 'h') ADVANCE(55);
      END_STATE();
    case 65:
      if (lookahead == 'h') ADVANCE(55);
      if (lookahead == 'r') ADVANCE(134);
      END_STATE();
    case 66:
      if (lookahead == 'h') ADVANCE(100);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(83);
      if (lookahead == 't') ADVANCE(27);
      if (lookahead == 'u') ADVANCE(31);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(125);
      END_STATE();
    case 69:
      if (lookahead == 'i') ADVANCE(79);
      if (lookahead == 'l') ADVANCE(121);
      END_STATE();
    case 70:
      if (lookahead == 'i') ADVANCE(93);
      END_STATE();
    case 71:
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(131);
      END_STATE();
    case 73:
      if (lookahead == 'i') ADVANCE(84);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 75:
      if (lookahead == 'k') ADVANCE(213);
      END_STATE();
    case 76:
      if (lookahead == 'l') ADVANCE(119);
      if (lookahead == 'x') ADVANCE(72);
      END_STATE();
    case 77:
      if (lookahead == 'l') ADVANCE(230);
      END_STATE();
    case 78:
      if (lookahead == 'l') ADVANCE(232);
      END_STATE();
    case 79:
      if (lookahead == 'l') ADVANCE(179);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(219);
      END_STATE();
    case 81:
      if (lookahead == 'l') ADVANCE(78);
      if (lookahead == 'm') ADVANCE(226);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(80);
      END_STATE();
    case 83:
      if (lookahead == 'l') ADVANCE(58);
      END_STATE();
    case 84:
      if (lookahead == 'l') ADVANCE(46);
      END_STATE();
    case 85:
      if (lookahead == 'l') ADVANCE(51);
      END_STATE();
    case 86:
      if (lookahead == 'm') ADVANCE(186);
      END_STATE();
    case 87:
      if (lookahead == 'm') ADVANCE(56);
      END_STATE();
    case 88:
      if (lookahead == 'n') ADVANCE(122);
      END_STATE();
    case 89:
      if (lookahead == 'n') ADVANCE(35);
      if (lookahead == 's') ADVANCE(182);
      END_STATE();
    case 90:
      if (lookahead == 'n') ADVANCE(120);
      END_STATE();
    case 91:
      if (lookahead == 'n') ADVANCE(175);
      END_STATE();
    case 92:
      if (lookahead == 'n') ADVANCE(236);
      if (lookahead == 't') ADVANCE(193);
      END_STATE();
    case 93:
      if (lookahead == 'n') ADVANCE(154);
      END_STATE();
    case 94:
      if (lookahead == 'n') ADVANCE(204);
      END_STATE();
    case 95:
      if (lookahead == 'n') ADVANCE(177);
      END_STATE();
    case 96:
      if (lookahead == 'n') ADVANCE(118);
      END_STATE();
    case 97:
      if (lookahead == 'n') ADVANCE(138);
      END_STATE();
    case 98:
      if (lookahead == 'n') ADVANCE(52);
      END_STATE();
    case 99:
      if (lookahead == 'n') ADVANCE(129);
      END_STATE();
    case 100:
      if (lookahead == 'o') ADVANCE(160);
      END_STATE();
    case 101:
      if (lookahead == 'o') ADVANCE(251);
      END_STATE();
    case 102:
      if (lookahead == 'o') ADVANCE(106);
      END_STATE();
    case 103:
      if (lookahead == 'o') ADVANCE(108);
      END_STATE();
    case 104:
      if (lookahead == 'o') ADVANCE(86);
      END_STATE();
    case 105:
      if (lookahead == 'o') ADVANCE(61);
      END_STATE();
    case 106:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 107:
      if (lookahead == 'o') ADVANCE(113);
      END_STATE();
    case 108:
      if (lookahead == 'p') ADVANCE(206);
      END_STATE();
    case 109:
      if (lookahead == 'p') ADVANCE(107);
      END_STATE();
    case 110:
      if (lookahead == 'r') ADVANCE(270);
      END_STATE();
    case 111:
      if (lookahead == 'r') ADVANCE(208);
      END_STATE();
    case 112:
      if (lookahead == 'r') ADVANCE(50);
      END_STATE();
    case 113:
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 114:
      if (lookahead == 'r') ADVANCE(95);
      END_STATE();
    case 115:
      if (lookahead == 's') ADVANCE(272);
      END_STATE();
    case 116:
      if (lookahead == 's') ADVANCE(238);
      END_STATE();
    case 117:
      if (lookahead == 's') ADVANCE(234);
      END_STATE();
    case 118:
      if (lookahead == 's') ADVANCE(25);
      END_STATE();
    case 119:
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 120:
      if (lookahead == 's') ADVANCE(126);
      if (lookahead == 't') ADVANCE(71);
      END_STATE();
    case 121:
      if (lookahead == 's') ADVANCE(44);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(228);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(243);
      END_STATE();
    case 124:
      if (lookahead == 't') ADVANCE(224);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(162);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(191);
      END_STATE();
    case 127:
      if (lookahead == 't') ADVANCE(247);
      END_STATE();
    case 128:
      if (lookahead == 't') ADVANCE(184);
      END_STATE();
    case 129:
      if (lookahead == 't') ADVANCE(249);
      END_STATE();
    case 130:
      if (lookahead == 't') ADVANCE(136);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(49);
      END_STATE();
    case 132:
      if (lookahead == 'u') ADVANCE(81);
      END_STATE();
    case 133:
      if (lookahead == 'u') ADVANCE(29);
      END_STATE();
    case 134:
      if (lookahead == 'u') ADVANCE(45);
      END_STATE();
    case 135:
      if (lookahead == 'u') ADVANCE(30);
      END_STATE();
    case 136:
      if (lookahead == 'u') ADVANCE(117);
      END_STATE();
    case 137:
      if (lookahead == 'u') ADVANCE(114);
      END_STATE();
    case 138:
      if (lookahead == 'u') ADVANCE(48);
      END_STATE();
    case 139:
      if (lookahead == 'x') ADVANCE(124);
      END_STATE();
    case 140:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(221);
      END_STATE();
    case 141:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(223);
      END_STATE();
    case 142:
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != ']') ADVANCE(21);
      END_STATE();
    case 143:
      if (eof) ADVANCE(149);
      ADVANCE_MAP(
        '!', 19,
        '"', 416,
        '#', 9,
        '$', 430,
        '%', 261,
        '(', 156,
        ')', 157,
        '*', 188,
        '+', 258,
        ',', 167,
        '-', 241,
        '/', 256,
        ':', 153,
        ';', 150,
        '<', 263,
        '=', 170,
        '>', 262,
        'B', 371,
        'I', 356,
        'N', 403,
        'T', 299,
        '[', 189,
        ']', 190,
        'a', 365,
        'b', 381,
        'c', 292,
        'e', 289,
        'f', 274,
        'i', 320,
        'l', 300,
        'm', 279,
        'n', 276,
        'o', 379,
        'p', 404,
        'r', 308,
        's', 330,
        't', 329,
        'u', 357,
        'w', 327,
        '{', 151,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(143);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 144:
      if (eof) ADVANCE(149);
      ADVANCE_MAP(
        '!', 19,
        '"', 416,
        '#', 9,
        '$', 430,
        '%', 261,
        '(', 156,
        '*', 188,
        '+', 258,
        '-', 241,
        '/', 256,
        ';', 150,
        '<', 263,
        '=', 170,
        '>', 262,
        'B', 371,
        'I', 356,
        'N', 403,
        'T', 299,
        '[', 189,
        'a', 365,
        'b', 381,
        'c', 292,
        'e', 287,
        'f', 274,
        'i', 320,
        'l', 300,
        'm', 279,
        'n', 276,
        'o', 379,
        'p', 404,
        'r', 308,
        's', 330,
        't', 329,
        'u', 357,
        'w', 327,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(144);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 145:
      if (eof) ADVANCE(149);
      ADVANCE_MAP(
        '!', 19,
        '"', 416,
        '#', 9,
        '$', 430,
        '%', 260,
        '(', 156,
        '*', 187,
        '+', 259,
        '-', 242,
        '/', 255,
        ':', 153,
        ';', 150,
        '<', 263,
        '=', 20,
        '>', 262,
        '?', 423,
        'B', 371,
        'I', 356,
        'N', 403,
        'T', 299,
        '[', 189,
        'a', 365,
        'b', 381,
        'c', 292,
        'e', 290,
        'f', 280,
        'i', 320,
        'l', 300,
        'm', 279,
        'n', 276,
        'o', 379,
        'p', 404,
        'r', 308,
        's', 331,
        't', 329,
        'u', 357,
        'w', 327,
        '{', 151,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(145);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 146:
      if (eof) ADVANCE(149);
      ADVANCE_MAP(
        '!', 19,
        '"', 416,
        '#', 9,
        '$', 430,
        '%', 260,
        '(', 156,
        '*', 187,
        '+', 259,
        '-', 242,
        '/', 255,
        ';', 150,
        '<', 263,
        '=', 20,
        '>', 262,
        '?', 423,
        'B', 371,
        'I', 356,
        'N', 403,
        'T', 299,
        '[', 189,
        'a', 365,
        'b', 381,
        'c', 292,
        'e', 288,
        'f', 280,
        'i', 320,
        'l', 300,
        'm', 279,
        'n', 276,
        'o', 379,
        'p', 404,
        'r', 308,
        's', 331,
        't', 329,
        'u', 357,
        'w', 327,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(146);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 147:
      if (eof) ADVANCE(149);
      ADVANCE_MAP(
        '"', 416,
        '#', 9,
        '$', 430,
        '(', 156,
        '+', 140,
        '-', 242,
        '/', 17,
        ';', 150,
        'B', 371,
        'I', 356,
        'N', 403,
        'T', 299,
        '[', 189,
        'b', 381,
        'c', 292,
        'e', 289,
        'f', 274,
        'i', 321,
        'l', 300,
        'm', 279,
        'n', 276,
        'p', 404,
        'r', 308,
        's', 330,
        't', 380,
        'u', 357,
        'w', 327,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(147);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 148:
      if (eof) ADVANCE(149);
      ADVANCE_MAP(
        '"', 416,
        '#', 9,
        '$', 430,
        '(', 156,
        '+', 140,
        '-', 242,
        '/', 17,
        ';', 150,
        'B', 371,
        'I', 356,
        'N', 403,
        'T', 299,
        '[', 189,
        'b', 381,
        'c', 292,
        'e', 287,
        'f', 274,
        'i', 321,
        'l', 300,
        'm', 279,
        'n', 276,
        'p', 404,
        'r', 308,
        's', 330,
        't', 380,
        'u', 357,
        'w', 327,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(148);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_main);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_main);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_cd);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_cd);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_echo);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_echo);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_exit);
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_exit);
      if (lookahead == 'e') ADVANCE(294);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_exit);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_mv);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_mv);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_reference);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_reference);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(266);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_preprocessor_directive);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_shebang);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_pub);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_pub);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_fun);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_fun);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_return);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_fail);
      if (lookahead == 'e') ADVANCE(37);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_fail);
      if (lookahead == 'e') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_fail);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_as);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_import);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(197);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_const);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_let);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_then);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_loop);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_loop);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_for);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_while);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_break);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_continue);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_boolean);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_boolean);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_null);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(221);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(222);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(223);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_Text);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_Text);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_Num);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_Num);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_Int);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_Int);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_Bool);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_Bool);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_Null);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_Null);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_status);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_status);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_len);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_len);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_lines);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_lines);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(196);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(221);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(221);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_not);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_unsafe);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_unsafe);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_trust);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_trust);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_silent);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_silent);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_sudo);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_sudo);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_nameof);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_nameof);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(433);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(433);
      if (lookahead == '=') ADVANCE(198);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(195);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(195);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(221);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(221);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(199);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(264);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(265);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_and);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_or);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_is);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(333);
      if (lookahead == 'o') ADVANCE(378);
      if (lookahead == 'u') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(333);
      if (lookahead == 'o') ADVANCE(378);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(355);
      if (lookahead == 'o') ADVANCE(392);
      if (lookahead == 'u') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(326);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(334);
      if (lookahead == 'v') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(336);
      if (lookahead == 'o') ADVANCE(378);
      if (lookahead == 'u') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(336);
      if (lookahead == 'o') ADVANCE(378);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(401);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(347);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(340);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'b') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'c') ADVANCE(291);
      if (lookahead == 'd') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'c') ADVANCE(328);
      if (lookahead == 'l') ADVANCE(390);
      if (lookahead == 'x') ADVANCE(332);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'c') ADVANCE(328);
      if (lookahead == 'l') ADVANCE(390);
      if (lookahead == 'x') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'c') ADVANCE(328);
      if (lookahead == 'x') ADVANCE(332);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'c') ADVANCE(328);
      if (lookahead == 'x') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'c') ADVANCE(318);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'd') ADVANCE(159);
      if (lookahead == 'o') ADVANCE(358);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'd') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'd') ADVANCE(422);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'd') ADVANCE(418);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'd') ADVANCE(420);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'd') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'd') ADVANCE(314);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(410);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(360);
      if (lookahead == 'i') ADVANCE(366);
      if (lookahead == 'o') ADVANCE(372);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(218);
      if (lookahead == 's') ADVANCE(396);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(277);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(400);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(294);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(384);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(325);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(296);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(373);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(364);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(361);
      if (lookahead == 'i') ADVANCE(366);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(313);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(368);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'f') ADVANCE(201);
      if (lookahead == 'm') ADVANCE(377);
      if (lookahead == 's') ADVANCE(273);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'f') ADVANCE(201);
      if (lookahead == 'm') ADVANCE(377);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'f') ADVANCE(201);
      if (lookahead == 's') ADVANCE(273);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'f') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'f') ADVANCE(254);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'f') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'f') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'h') ADVANCE(339);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'h') ADVANCE(369);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'h') ADVANCE(316);
      if (lookahead == 'r') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(349);
      if (lookahead == 't') ADVANCE(282);
      if (lookahead == 'u') ADVANCE(297);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(349);
      if (lookahead == 't') ADVANCE(282);
      if (lookahead == 'u') ADVANCE(286);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(394);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(344);
      if (lookahead == 'l') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(362);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(367);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(346);
      if (lookahead == 'l') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(399);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(402);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(351);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(352);
      if (lookahead == 'l') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'k') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(231);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(233);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(181);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(343);
      if (lookahead == 'm') ADVANCE(227);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(319);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(345);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(303);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(311);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(390);
      if (lookahead == 'x') ADVANCE(338);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(390);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'm') ADVANCE(315);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(391);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(388);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(237);
      if (lookahead == 't') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(237);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(293);
      if (lookahead == 's') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(310);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(408);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(398);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'o') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'o') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'o') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'o') ADVANCE(376);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'o') ADVANCE(324);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'o') ADVANCE(342);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'o') ADVANCE(383);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'p') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'p') ADVANCE(375);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'r') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'r') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'r') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'r') ADVANCE(307);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'r') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'r') ADVANCE(397);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 's') ADVANCE(239);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 's') ADVANCE(235);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 's') ADVANCE(273);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 's') ADVANCE(278);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 's') ADVANCE(395);
      if (lookahead == 't') ADVANCE(335);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 's') ADVANCE(302);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 's') ADVANCE(306);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(192);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(248);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(407);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(406);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'u') ADVANCE(348);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'u') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'u') ADVANCE(301);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'u') ADVANCE(385);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'u') ADVANCE(382);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'u') ADVANCE(305);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'v') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'x') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_variable);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_string_content);
      if (lookahead == '\n') ADVANCE(415);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(412);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym_string_content);
      if (lookahead == '/') ADVANCE(414);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(413);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(415);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym_string_content);
      if (lookahead == '/') ADVANCE(412);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(415);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym_string_content);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(415);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(anon_sym_failed);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_failed);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(anon_sym_succeeded);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym_succeeded);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_exited);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym_exited);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(411);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym_handler_propagation);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(424);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym_command_content);
      if (lookahead == '\n') ADVANCE(429);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '-' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(426);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym_command_content);
      if (lookahead == '/') ADVANCE(428);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(427);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '-' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(429);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym_command_content);
      if (lookahead == '/') ADVANCE(426);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '-' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(429);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(sym_command_content);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '-' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(429);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(sym_command_option);
      if (lookahead == '-') ADVANCE(432);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(432);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(sym_command_option);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(432);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(433);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 147},
  [2] = {.lex_state = 147},
  [3] = {.lex_state = 147},
  [4] = {.lex_state = 146},
  [5] = {.lex_state = 146},
  [6] = {.lex_state = 146},
  [7] = {.lex_state = 144},
  [8] = {.lex_state = 144},
  [9] = {.lex_state = 10},
  [10] = {.lex_state = 145},
  [11] = {.lex_state = 10},
  [12] = {.lex_state = 10},
  [13] = {.lex_state = 10},
  [14] = {.lex_state = 10},
  [15] = {.lex_state = 10},
  [16] = {.lex_state = 10},
  [17] = {.lex_state = 10},
  [18] = {.lex_state = 10},
  [19] = {.lex_state = 10},
  [20] = {.lex_state = 10},
  [21] = {.lex_state = 10},
  [22] = {.lex_state = 10},
  [23] = {.lex_state = 143},
  [24] = {.lex_state = 10},
  [25] = {.lex_state = 10},
  [26] = {.lex_state = 10},
  [27] = {.lex_state = 10},
  [28] = {.lex_state = 145},
  [29] = {.lex_state = 145},
  [30] = {.lex_state = 10},
  [31] = {.lex_state = 10},
  [32] = {.lex_state = 143},
  [33] = {.lex_state = 10},
  [34] = {.lex_state = 10},
  [35] = {.lex_state = 10},
  [36] = {.lex_state = 10},
  [37] = {.lex_state = 10},
  [38] = {.lex_state = 10},
  [39] = {.lex_state = 10},
  [40] = {.lex_state = 10},
  [41] = {.lex_state = 10},
  [42] = {.lex_state = 10},
  [43] = {.lex_state = 10},
  [44] = {.lex_state = 10},
  [45] = {.lex_state = 10},
  [46] = {.lex_state = 10},
  [47] = {.lex_state = 145},
  [48] = {.lex_state = 143},
  [49] = {.lex_state = 10},
  [50] = {.lex_state = 10},
  [51] = {.lex_state = 10},
  [52] = {.lex_state = 143},
  [53] = {.lex_state = 10},
  [54] = {.lex_state = 10},
  [55] = {.lex_state = 10},
  [56] = {.lex_state = 10},
  [57] = {.lex_state = 10},
  [58] = {.lex_state = 10},
  [59] = {.lex_state = 10},
  [60] = {.lex_state = 10},
  [61] = {.lex_state = 146},
  [62] = {.lex_state = 143},
  [63] = {.lex_state = 146},
  [64] = {.lex_state = 143},
  [65] = {.lex_state = 146},
  [66] = {.lex_state = 145},
  [67] = {.lex_state = 2},
  [68] = {.lex_state = 3},
  [69] = {.lex_state = 2},
  [70] = {.lex_state = 3},
  [71] = {.lex_state = 3},
  [72] = {.lex_state = 145},
  [73] = {.lex_state = 4},
  [74] = {.lex_state = 143},
  [75] = {.lex_state = 4},
  [76] = {.lex_state = 4},
  [77] = {.lex_state = 1},
  [78] = {.lex_state = 143},
  [79] = {.lex_state = 1},
  [80] = {.lex_state = 143},
  [81] = {.lex_state = 144},
  [82] = {.lex_state = 144},
  [83] = {.lex_state = 144},
  [84] = {.lex_state = 144},
  [85] = {.lex_state = 144},
  [86] = {.lex_state = 144},
  [87] = {.lex_state = 144},
  [88] = {.lex_state = 143},
  [89] = {.lex_state = 144},
  [90] = {.lex_state = 144},
  [91] = {.lex_state = 144},
  [92] = {.lex_state = 143},
  [93] = {.lex_state = 144},
  [94] = {.lex_state = 144},
  [95] = {.lex_state = 144},
  [96] = {.lex_state = 144},
  [97] = {.lex_state = 144},
  [98] = {.lex_state = 144},
  [99] = {.lex_state = 144},
  [100] = {.lex_state = 144},
  [101] = {.lex_state = 144},
  [102] = {.lex_state = 144},
  [103] = {.lex_state = 144},
  [104] = {.lex_state = 143},
  [105] = {.lex_state = 143},
  [106] = {.lex_state = 143},
  [107] = {.lex_state = 144},
  [108] = {.lex_state = 143},
  [109] = {.lex_state = 143},
  [110] = {.lex_state = 144},
  [111] = {.lex_state = 144},
  [112] = {.lex_state = 144},
  [113] = {.lex_state = 143},
  [114] = {.lex_state = 144},
  [115] = {.lex_state = 144},
  [116] = {.lex_state = 144},
  [117] = {.lex_state = 144},
  [118] = {.lex_state = 144},
  [119] = {.lex_state = 144},
  [120] = {.lex_state = 143},
  [121] = {.lex_state = 144},
  [122] = {.lex_state = 143},
  [123] = {.lex_state = 144},
  [124] = {.lex_state = 144},
  [125] = {.lex_state = 144},
  [126] = {.lex_state = 143},
  [127] = {.lex_state = 143},
  [128] = {.lex_state = 144},
  [129] = {.lex_state = 143},
  [130] = {.lex_state = 143},
  [131] = {.lex_state = 144},
  [132] = {.lex_state = 144},
  [133] = {.lex_state = 143},
  [134] = {.lex_state = 144},
  [135] = {.lex_state = 144},
  [136] = {.lex_state = 144},
  [137] = {.lex_state = 144},
  [138] = {.lex_state = 144},
  [139] = {.lex_state = 144},
  [140] = {.lex_state = 144},
  [141] = {.lex_state = 144},
  [142] = {.lex_state = 144},
  [143] = {.lex_state = 144},
  [144] = {.lex_state = 144},
  [145] = {.lex_state = 143},
  [146] = {.lex_state = 144},
  [147] = {.lex_state = 143},
  [148] = {.lex_state = 144},
  [149] = {.lex_state = 144},
  [150] = {.lex_state = 144},
  [151] = {.lex_state = 143},
  [152] = {.lex_state = 143},
  [153] = {.lex_state = 143},
  [154] = {.lex_state = 143},
  [155] = {.lex_state = 143},
  [156] = {.lex_state = 143},
  [157] = {.lex_state = 3},
  [158] = {.lex_state = 143},
  [159] = {.lex_state = 3},
  [160] = {.lex_state = 143},
  [161] = {.lex_state = 143},
  [162] = {.lex_state = 143},
  [163] = {.lex_state = 143},
  [164] = {.lex_state = 143},
  [165] = {.lex_state = 143},
  [166] = {.lex_state = 143},
  [167] = {.lex_state = 143},
  [168] = {.lex_state = 143},
  [169] = {.lex_state = 143},
  [170] = {.lex_state = 143},
  [171] = {.lex_state = 143},
  [172] = {.lex_state = 143},
  [173] = {.lex_state = 143},
  [174] = {.lex_state = 143},
  [175] = {.lex_state = 143},
  [176] = {.lex_state = 143},
  [177] = {.lex_state = 143},
  [178] = {.lex_state = 143},
  [179] = {.lex_state = 3},
  [180] = {.lex_state = 143},
  [181] = {.lex_state = 143},
  [182] = {.lex_state = 143},
  [183] = {.lex_state = 143},
  [184] = {.lex_state = 143},
  [185] = {.lex_state = 4},
  [186] = {.lex_state = 4},
  [187] = {.lex_state = 4},
  [188] = {.lex_state = 2},
  [189] = {.lex_state = 2},
  [190] = {.lex_state = 2},
  [191] = {.lex_state = 2},
  [192] = {.lex_state = 2},
  [193] = {.lex_state = 2},
  [194] = {.lex_state = 2},
  [195] = {.lex_state = 2},
  [196] = {.lex_state = 2},
  [197] = {.lex_state = 2},
  [198] = {.lex_state = 2},
  [199] = {.lex_state = 2},
  [200] = {.lex_state = 2},
  [201] = {.lex_state = 2},
  [202] = {.lex_state = 2},
  [203] = {.lex_state = 2},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 2},
  [206] = {.lex_state = 2},
  [207] = {.lex_state = 2},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 2},
  [210] = {.lex_state = 2},
  [211] = {.lex_state = 2},
  [212] = {.lex_state = 2},
  [213] = {.lex_state = 2},
  [214] = {.lex_state = 2},
  [215] = {.lex_state = 2},
  [216] = {.lex_state = 2},
  [217] = {.lex_state = 2},
  [218] = {.lex_state = 2},
  [219] = {.lex_state = 2},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 2},
  [222] = {.lex_state = 2},
  [223] = {.lex_state = 2},
  [224] = {.lex_state = 2},
  [225] = {.lex_state = 2},
  [226] = {.lex_state = 2},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 2},
  [231] = {.lex_state = 2},
  [232] = {.lex_state = 2},
  [233] = {.lex_state = 2},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 2},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 2},
  [238] = {.lex_state = 2},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 2},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 2},
  [243] = {.lex_state = 2},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 2},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 2},
  [249] = {.lex_state = 2},
  [250] = {.lex_state = 2},
  [251] = {.lex_state = 2},
  [252] = {.lex_state = 1},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 2},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 2},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 1},
  [259] = {.lex_state = 1},
  [260] = {.lex_state = 1},
  [261] = {.lex_state = 1},
  [262] = {.lex_state = 1},
  [263] = {.lex_state = 1},
  [264] = {.lex_state = 1},
  [265] = {.lex_state = 1},
  [266] = {.lex_state = 1},
  [267] = {.lex_state = 1},
  [268] = {.lex_state = 1},
  [269] = {.lex_state = 1},
  [270] = {.lex_state = 1},
  [271] = {.lex_state = 1},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 1},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 1},
  [277] = {.lex_state = 1},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 1},
  [280] = {.lex_state = 1},
  [281] = {.lex_state = 1},
  [282] = {.lex_state = 1},
  [283] = {.lex_state = 1},
  [284] = {.lex_state = 1},
  [285] = {.lex_state = 1},
  [286] = {.lex_state = 1},
  [287] = {.lex_state = 1},
  [288] = {.lex_state = 1},
  [289] = {.lex_state = 1},
  [290] = {.lex_state = 1},
  [291] = {.lex_state = 1},
  [292] = {.lex_state = 1},
  [293] = {.lex_state = 5},
  [294] = {.lex_state = 6},
  [295] = {.lex_state = 6},
  [296] = {.lex_state = 6},
  [297] = {.lex_state = 5},
  [298] = {.lex_state = 148},
  [299] = {.lex_state = 148},
  [300] = {.lex_state = 147},
  [301] = {.lex_state = 148},
  [302] = {.lex_state = 147},
  [303] = {.lex_state = 147},
  [304] = {.lex_state = 147},
  [305] = {.lex_state = 148},
  [306] = {.lex_state = 147},
  [307] = {.lex_state = 147},
  [308] = {.lex_state = 148},
  [309] = {.lex_state = 147},
  [310] = {.lex_state = 148},
  [311] = {.lex_state = 147},
  [312] = {.lex_state = 147},
  [313] = {.lex_state = 147},
  [314] = {.lex_state = 148},
  [315] = {.lex_state = 147},
  [316] = {.lex_state = 147},
  [317] = {.lex_state = 148},
  [318] = {.lex_state = 148},
  [319] = {.lex_state = 148},
  [320] = {.lex_state = 147},
  [321] = {.lex_state = 148},
  [322] = {.lex_state = 148},
  [323] = {.lex_state = 148},
  [324] = {.lex_state = 147},
  [325] = {.lex_state = 148},
  [326] = {.lex_state = 148},
  [327] = {.lex_state = 147},
  [328] = {.lex_state = 147},
  [329] = {.lex_state = 6},
  [330] = {.lex_state = 147},
  [331] = {.lex_state = 147},
  [332] = {.lex_state = 147},
  [333] = {.lex_state = 147},
  [334] = {.lex_state = 147},
  [335] = {.lex_state = 6},
  [336] = {.lex_state = 147},
  [337] = {.lex_state = 147},
  [338] = {.lex_state = 147},
  [339] = {.lex_state = 147},
  [340] = {.lex_state = 6},
  [341] = {.lex_state = 147},
  [342] = {.lex_state = 147},
  [343] = {.lex_state = 147},
  [344] = {.lex_state = 147},
  [345] = {.lex_state = 147},
  [346] = {.lex_state = 147},
  [347] = {.lex_state = 13},
  [348] = {.lex_state = 5},
  [349] = {.lex_state = 13},
  [350] = {.lex_state = 5},
  [351] = {.lex_state = 13},
  [352] = {.lex_state = 5},
  [353] = {.lex_state = 13},
  [354] = {.lex_state = 5},
  [355] = {.lex_state = 5},
  [356] = {.lex_state = 13},
  [357] = {.lex_state = 13},
  [358] = {.lex_state = 13},
  [359] = {.lex_state = 13},
  [360] = {.lex_state = 13},
  [361] = {.lex_state = 13},
  [362] = {.lex_state = 13},
  [363] = {.lex_state = 13},
  [364] = {.lex_state = 5},
  [365] = {.lex_state = 13},
  [366] = {.lex_state = 5},
  [367] = {.lex_state = 5},
  [368] = {.lex_state = 5},
  [369] = {.lex_state = 13},
  [370] = {.lex_state = 13},
  [371] = {.lex_state = 13},
  [372] = {.lex_state = 13},
  [373] = {.lex_state = 13},
  [374] = {.lex_state = 13},
  [375] = {.lex_state = 5},
  [376] = {.lex_state = 5},
  [377] = {.lex_state = 5},
  [378] = {.lex_state = 5},
  [379] = {.lex_state = 5},
  [380] = {.lex_state = 13},
  [381] = {.lex_state = 13},
  [382] = {.lex_state = 5},
  [383] = {.lex_state = 13},
  [384] = {.lex_state = 5},
  [385] = {.lex_state = 13},
  [386] = {.lex_state = 5},
  [387] = {.lex_state = 5},
  [388] = {.lex_state = 5},
  [389] = {.lex_state = 12},
  [390] = {.lex_state = 5},
  [391] = {.lex_state = 12},
  [392] = {.lex_state = 5},
  [393] = {.lex_state = 5},
  [394] = {.lex_state = 12},
  [395] = {.lex_state = 5},
  [396] = {.lex_state = 5},
  [397] = {.lex_state = 5},
  [398] = {.lex_state = 5},
  [399] = {.lex_state = 5},
  [400] = {.lex_state = 5},
  [401] = {.lex_state = 5},
  [402] = {.lex_state = 11},
  [403] = {.lex_state = 11},
  [404] = {.lex_state = 11},
  [405] = {.lex_state = 5},
  [406] = {.lex_state = 5},
  [407] = {.lex_state = 11},
  [408] = {.lex_state = 11},
  [409] = {.lex_state = 11},
  [410] = {.lex_state = 11},
  [411] = {.lex_state = 12},
  [412] = {.lex_state = 11},
  [413] = {.lex_state = 11},
  [414] = {.lex_state = 5},
  [415] = {.lex_state = 5},
  [416] = {.lex_state = 12},
  [417] = {.lex_state = 11},
  [418] = {.lex_state = 5},
  [419] = {.lex_state = 11},
  [420] = {.lex_state = 11},
  [421] = {.lex_state = 11},
  [422] = {.lex_state = 11},
  [423] = {.lex_state = 5},
  [424] = {.lex_state = 11},
  [425] = {.lex_state = 5},
  [426] = {.lex_state = 5},
  [427] = {.lex_state = 5},
  [428] = {.lex_state = 5},
  [429] = {.lex_state = 5},
  [430] = {.lex_state = 5},
  [431] = {.lex_state = 5},
  [432] = {.lex_state = 5},
  [433] = {.lex_state = 5},
  [434] = {.lex_state = 5},
  [435] = {.lex_state = 5},
  [436] = {.lex_state = 5},
  [437] = {.lex_state = 5},
  [438] = {.lex_state = 5},
  [439] = {.lex_state = 12},
  [440] = {.lex_state = 5},
  [441] = {.lex_state = 12},
  [442] = {.lex_state = 5},
  [443] = {.lex_state = 12},
  [444] = {.lex_state = 5},
  [445] = {.lex_state = 5},
  [446] = {.lex_state = 12},
  [447] = {.lex_state = 12},
  [448] = {.lex_state = 10},
  [449] = {.lex_state = 12},
  [450] = {.lex_state = 12},
  [451] = {.lex_state = 12},
  [452] = {.lex_state = 10},
  [453] = {.lex_state = 12},
  [454] = {.lex_state = 12},
  [455] = {.lex_state = 12},
  [456] = {.lex_state = 12},
  [457] = {.lex_state = 12},
  [458] = {.lex_state = 12},
  [459] = {.lex_state = 12},
  [460] = {.lex_state = 12},
  [461] = {.lex_state = 12},
  [462] = {.lex_state = 12},
  [463] = {.lex_state = 12},
  [464] = {.lex_state = 10},
  [465] = {.lex_state = 10},
  [466] = {.lex_state = 10},
  [467] = {.lex_state = 12},
  [468] = {.lex_state = 12},
  [469] = {.lex_state = 12},
  [470] = {.lex_state = 12},
  [471] = {.lex_state = 10},
  [472] = {.lex_state = 12},
  [473] = {.lex_state = 12},
  [474] = {.lex_state = 12},
  [475] = {.lex_state = 10},
  [476] = {.lex_state = 12},
  [477] = {.lex_state = 12},
  [478] = {.lex_state = 10},
  [479] = {.lex_state = 12},
  [480] = {.lex_state = 12},
  [481] = {.lex_state = 12},
  [482] = {.lex_state = 10},
  [483] = {.lex_state = 12},
  [484] = {.lex_state = 12},
  [485] = {.lex_state = 12},
  [486] = {.lex_state = 10},
  [487] = {.lex_state = 12},
  [488] = {.lex_state = 10},
  [489] = {.lex_state = 12},
  [490] = {.lex_state = 12},
  [491] = {.lex_state = 12},
  [492] = {.lex_state = 10},
  [493] = {.lex_state = 12},
  [494] = {.lex_state = 12},
  [495] = {.lex_state = 10},
  [496] = {.lex_state = 12},
  [497] = {.lex_state = 10},
  [498] = {.lex_state = 12},
  [499] = {.lex_state = 12},
  [500] = {.lex_state = 12},
  [501] = {.lex_state = 10},
  [502] = {.lex_state = 12},
  [503] = {.lex_state = 12},
  [504] = {.lex_state = 12},
  [505] = {.lex_state = 12},
  [506] = {.lex_state = 12},
  [507] = {.lex_state = 12},
  [508] = {.lex_state = 12},
  [509] = {.lex_state = 12},
  [510] = {.lex_state = 12},
  [511] = {.lex_state = 12},
  [512] = {.lex_state = 12},
  [513] = {.lex_state = 12},
  [514] = {.lex_state = 12},
  [515] = {.lex_state = 12},
  [516] = {.lex_state = 12},
  [517] = {.lex_state = 12},
  [518] = {.lex_state = 12},
  [519] = {.lex_state = 12},
  [520] = {.lex_state = 12},
  [521] = {.lex_state = 12},
  [522] = {.lex_state = 12},
  [523] = {.lex_state = 12},
  [524] = {.lex_state = 12},
  [525] = {.lex_state = 12},
  [526] = {.lex_state = 12},
  [527] = {.lex_state = 12},
  [528] = {.lex_state = 12},
  [529] = {.lex_state = 12},
  [530] = {.lex_state = 12},
  [531] = {.lex_state = 12},
  [532] = {.lex_state = 12},
  [533] = {.lex_state = 12},
  [534] = {.lex_state = 12},
  [535] = {.lex_state = 12},
  [536] = {.lex_state = 12},
  [537] = {.lex_state = 12},
  [538] = {.lex_state = 12},
  [539] = {.lex_state = 12},
  [540] = {.lex_state = 12},
  [541] = {.lex_state = 12},
  [542] = {.lex_state = 12},
  [543] = {.lex_state = 12},
  [544] = {.lex_state = 12},
  [545] = {.lex_state = 12},
  [546] = {.lex_state = 12},
  [547] = {.lex_state = 12},
  [548] = {.lex_state = 12},
  [549] = {.lex_state = 12},
  [550] = {.lex_state = 12},
  [551] = {.lex_state = 12},
  [552] = {.lex_state = 12},
  [553] = {.lex_state = 12},
  [554] = {.lex_state = 12},
  [555] = {.lex_state = 12},
  [556] = {.lex_state = 12},
  [557] = {.lex_state = 12},
  [558] = {.lex_state = 12},
  [559] = {.lex_state = 12},
  [560] = {.lex_state = 12},
  [561] = {.lex_state = 12},
  [562] = {.lex_state = 12},
  [563] = {.lex_state = 12},
  [564] = {.lex_state = 12},
  [565] = {.lex_state = 12},
  [566] = {.lex_state = 12},
  [567] = {.lex_state = 12},
  [568] = {.lex_state = 12},
  [569] = {.lex_state = 12},
  [570] = {.lex_state = 12},
  [571] = {.lex_state = 12},
  [572] = {.lex_state = 12},
  [573] = {.lex_state = 12},
  [574] = {.lex_state = 12},
  [575] = {.lex_state = 12},
  [576] = {.lex_state = 12},
  [577] = {.lex_state = 12},
  [578] = {.lex_state = 12},
  [579] = {.lex_state = 12},
  [580] = {.lex_state = 12},
  [581] = {.lex_state = 12},
  [582] = {.lex_state = 12},
  [583] = {.lex_state = 12},
  [584] = {.lex_state = 12},
  [585] = {.lex_state = 12},
  [586] = {.lex_state = 12},
  [587] = {.lex_state = 12},
  [588] = {.lex_state = 12},
  [589] = {.lex_state = 12},
  [590] = {.lex_state = 12},
  [591] = {.lex_state = 12},
  [592] = {.lex_state = 12},
  [593] = {.lex_state = 12},
  [594] = {.lex_state = 12},
  [595] = {.lex_state = 12},
  [596] = {.lex_state = 12},
  [597] = {.lex_state = 12},
  [598] = {.lex_state = 12},
  [599] = {.lex_state = 12},
  [600] = {.lex_state = 12},
  [601] = {.lex_state = 12},
  [602] = {.lex_state = 12},
  [603] = {.lex_state = 12},
  [604] = {.lex_state = 12},
  [605] = {.lex_state = 12},
  [606] = {.lex_state = 12},
  [607] = {.lex_state = 12},
  [608] = {.lex_state = 12},
  [609] = {.lex_state = 12},
  [610] = {.lex_state = 12},
  [611] = {.lex_state = 12},
  [612] = {.lex_state = 12},
  [613] = {.lex_state = 12},
  [614] = {.lex_state = 12},
  [615] = {.lex_state = 12},
  [616] = {.lex_state = 12},
  [617] = {.lex_state = 12},
  [618] = {.lex_state = 12},
  [619] = {.lex_state = 12},
  [620] = {.lex_state = 12},
  [621] = {.lex_state = 12},
  [622] = {.lex_state = 12},
  [623] = {.lex_state = 12},
  [624] = {.lex_state = 12},
  [625] = {.lex_state = 12},
  [626] = {.lex_state = 12},
  [627] = {.lex_state = 12},
  [628] = {.lex_state = 12},
  [629] = {.lex_state = 12},
  [630] = {.lex_state = 12},
  [631] = {.lex_state = 12},
  [632] = {.lex_state = 12},
  [633] = {.lex_state = 12},
  [634] = {.lex_state = 12},
  [635] = {.lex_state = 12},
  [636] = {.lex_state = 12},
  [637] = {.lex_state = 12},
  [638] = {.lex_state = 12},
  [639] = {.lex_state = 12},
  [640] = {.lex_state = 12},
  [641] = {.lex_state = 12},
  [642] = {.lex_state = 12},
  [643] = {.lex_state = 12},
  [644] = {.lex_state = 12},
  [645] = {.lex_state = 12},
  [646] = {.lex_state = 12},
  [647] = {.lex_state = 12},
  [648] = {.lex_state = 12},
  [649] = {.lex_state = 12},
  [650] = {.lex_state = 12},
  [651] = {.lex_state = 12},
  [652] = {.lex_state = 12},
  [653] = {.lex_state = 12},
  [654] = {.lex_state = 12},
  [655] = {.lex_state = 12},
  [656] = {.lex_state = 12},
  [657] = {.lex_state = 12},
  [658] = {.lex_state = 12},
  [659] = {.lex_state = 12},
  [660] = {.lex_state = 12},
  [661] = {.lex_state = 12},
  [662] = {.lex_state = 12},
  [663] = {.lex_state = 12},
  [664] = {.lex_state = 12},
  [665] = {.lex_state = 12},
  [666] = {.lex_state = 12},
  [667] = {.lex_state = 12},
  [668] = {.lex_state = 12},
  [669] = {.lex_state = 12},
  [670] = {.lex_state = 12},
  [671] = {.lex_state = 12},
  [672] = {.lex_state = 12},
  [673] = {.lex_state = 12},
  [674] = {.lex_state = 12},
  [675] = {.lex_state = 12},
  [676] = {.lex_state = 12},
  [677] = {.lex_state = 12},
  [678] = {.lex_state = 12},
  [679] = {.lex_state = 12},
  [680] = {.lex_state = 12},
  [681] = {.lex_state = 12},
  [682] = {.lex_state = 12},
  [683] = {.lex_state = 12},
  [684] = {.lex_state = 7},
  [685] = {.lex_state = 7},
  [686] = {.lex_state = 7},
  [687] = {.lex_state = 7},
  [688] = {.lex_state = 7},
  [689] = {.lex_state = 7},
  [690] = {.lex_state = 7},
  [691] = {.lex_state = 7},
  [692] = {.lex_state = 7},
  [693] = {.lex_state = 7},
  [694] = {.lex_state = 7},
  [695] = {.lex_state = 7},
  [696] = {.lex_state = 7},
  [697] = {.lex_state = 7},
  [698] = {.lex_state = 7},
  [699] = {.lex_state = 7},
  [700] = {.lex_state = 7},
  [701] = {.lex_state = 13},
  [702] = {.lex_state = 13},
  [703] = {.lex_state = 7},
  [704] = {.lex_state = 7},
  [705] = {.lex_state = 7},
  [706] = {.lex_state = 7},
  [707] = {.lex_state = 7},
  [708] = {.lex_state = 7},
  [709] = {.lex_state = 7},
  [710] = {.lex_state = 7},
  [711] = {.lex_state = 7},
  [712] = {.lex_state = 7},
  [713] = {.lex_state = 7},
  [714] = {.lex_state = 13},
  [715] = {.lex_state = 13},
  [716] = {.lex_state = 7},
  [717] = {.lex_state = 13},
  [718] = {.lex_state = 7},
  [719] = {.lex_state = 13},
  [720] = {.lex_state = 13},
  [721] = {.lex_state = 13},
  [722] = {.lex_state = 13},
  [723] = {.lex_state = 13},
  [724] = {.lex_state = 7},
  [725] = {.lex_state = 13},
  [726] = {.lex_state = 13},
  [727] = {.lex_state = 13},
  [728] = {.lex_state = 13},
  [729] = {.lex_state = 13},
  [730] = {.lex_state = 13},
  [731] = {.lex_state = 7},
  [732] = {.lex_state = 7},
  [733] = {.lex_state = 13},
  [734] = {.lex_state = 7},
  [735] = {.lex_state = 7},
  [736] = {.lex_state = 7},
  [737] = {.lex_state = 7},
  [738] = {.lex_state = 7},
  [739] = {.lex_state = 7},
  [740] = {.lex_state = 7},
  [741] = {.lex_state = 7},
  [742] = {.lex_state = 7},
  [743] = {.lex_state = 7},
  [744] = {.lex_state = 7},
  [745] = {.lex_state = 7},
  [746] = {.lex_state = 7},
  [747] = {.lex_state = 7},
  [748] = {.lex_state = 7},
  [749] = {.lex_state = 7},
  [750] = {.lex_state = 7},
  [751] = {.lex_state = 7},
  [752] = {.lex_state = 7},
  [753] = {.lex_state = 7},
  [754] = {.lex_state = 7},
  [755] = {.lex_state = 7},
  [756] = {.lex_state = 7},
  [757] = {.lex_state = 7},
  [758] = {.lex_state = 7},
  [759] = {.lex_state = 7},
  [760] = {.lex_state = 7},
  [761] = {.lex_state = 7},
  [762] = {.lex_state = 7},
  [763] = {.lex_state = 7},
  [764] = {.lex_state = 7},
  [765] = {.lex_state = 7},
  [766] = {.lex_state = 7},
  [767] = {.lex_state = 7},
  [768] = {.lex_state = 7},
  [769] = {.lex_state = 7},
  [770] = {.lex_state = 7},
  [771] = {.lex_state = 7},
  [772] = {.lex_state = 7},
  [773] = {.lex_state = 7},
  [774] = {.lex_state = 7},
  [775] = {.lex_state = 7},
  [776] = {.lex_state = 7},
  [777] = {.lex_state = 7},
  [778] = {.lex_state = 7},
  [779] = {.lex_state = 7},
  [780] = {.lex_state = 7},
  [781] = {.lex_state = 7},
  [782] = {.lex_state = 7},
  [783] = {.lex_state = 7},
  [784] = {.lex_state = 7},
  [785] = {.lex_state = 7},
  [786] = {.lex_state = 7},
  [787] = {.lex_state = 7},
  [788] = {.lex_state = 7},
  [789] = {.lex_state = 7},
  [790] = {.lex_state = 7},
  [791] = {.lex_state = 7},
  [792] = {.lex_state = 7},
  [793] = {.lex_state = 7},
  [794] = {.lex_state = 7},
  [795] = {.lex_state = 7},
  [796] = {.lex_state = 7},
  [797] = {.lex_state = 7},
  [798] = {.lex_state = 7},
  [799] = {.lex_state = 7},
  [800] = {.lex_state = 7},
  [801] = {.lex_state = 7},
  [802] = {.lex_state = 7},
  [803] = {.lex_state = 7},
  [804] = {.lex_state = 7},
  [805] = {.lex_state = 7},
  [806] = {.lex_state = 7},
  [807] = {.lex_state = 7},
  [808] = {.lex_state = 7},
  [809] = {.lex_state = 7},
  [810] = {.lex_state = 7},
  [811] = {.lex_state = 7},
  [812] = {.lex_state = 7},
  [813] = {.lex_state = 7},
  [814] = {.lex_state = 7},
  [815] = {.lex_state = 7},
  [816] = {.lex_state = 7},
  [817] = {.lex_state = 7},
  [818] = {.lex_state = 7},
  [819] = {.lex_state = 7},
  [820] = {.lex_state = 7},
  [821] = {.lex_state = 7},
  [822] = {.lex_state = 7},
  [823] = {.lex_state = 7},
  [824] = {.lex_state = 7},
  [825] = {.lex_state = 7},
  [826] = {.lex_state = 7},
  [827] = {.lex_state = 7},
  [828] = {.lex_state = 7},
  [829] = {.lex_state = 7},
  [830] = {.lex_state = 7},
  [831] = {.lex_state = 7},
  [832] = {.lex_state = 7},
  [833] = {.lex_state = 7},
  [834] = {.lex_state = 7},
  [835] = {.lex_state = 7},
  [836] = {.lex_state = 7},
  [837] = {.lex_state = 7},
  [838] = {.lex_state = 7},
  [839] = {.lex_state = 7},
  [840] = {.lex_state = 7},
  [841] = {.lex_state = 7},
  [842] = {.lex_state = 7},
  [843] = {.lex_state = 7},
  [844] = {.lex_state = 7},
  [845] = {.lex_state = 7},
  [846] = {.lex_state = 7},
  [847] = {.lex_state = 7},
  [848] = {.lex_state = 7},
  [849] = {.lex_state = 7},
  [850] = {.lex_state = 7},
  [851] = {.lex_state = 7},
  [852] = {.lex_state = 7},
  [853] = {.lex_state = 7},
  [854] = {.lex_state = 7},
  [855] = {.lex_state = 7},
  [856] = {.lex_state = 7},
  [857] = {.lex_state = 7},
  [858] = {.lex_state = 7},
  [859] = {.lex_state = 7},
  [860] = {.lex_state = 7},
  [861] = {.lex_state = 7},
  [862] = {.lex_state = 7},
  [863] = {.lex_state = 7},
  [864] = {.lex_state = 7},
  [865] = {.lex_state = 7},
  [866] = {.lex_state = 7},
  [867] = {.lex_state = 7},
  [868] = {.lex_state = 7},
  [869] = {.lex_state = 7},
  [870] = {.lex_state = 7},
  [871] = {.lex_state = 7},
  [872] = {.lex_state = 7},
  [873] = {.lex_state = 7},
  [874] = {.lex_state = 7},
  [875] = {.lex_state = 7},
  [876] = {.lex_state = 7},
  [877] = {.lex_state = 7},
  [878] = {.lex_state = 7},
  [879] = {.lex_state = 7},
  [880] = {.lex_state = 7},
  [881] = {.lex_state = 7},
  [882] = {.lex_state = 7},
  [883] = {.lex_state = 7},
  [884] = {.lex_state = 7},
  [885] = {.lex_state = 7},
  [886] = {.lex_state = 7},
  [887] = {.lex_state = 7},
  [888] = {.lex_state = 7},
  [889] = {.lex_state = 7},
  [890] = {.lex_state = 7},
  [891] = {.lex_state = 7},
  [892] = {.lex_state = 7},
  [893] = {.lex_state = 7},
  [894] = {.lex_state = 7},
  [895] = {.lex_state = 7},
  [896] = {.lex_state = 7},
  [897] = {.lex_state = 7},
  [898] = {.lex_state = 7},
  [899] = {.lex_state = 7},
  [900] = {.lex_state = 7},
  [901] = {.lex_state = 7},
  [902] = {.lex_state = 7},
  [903] = {.lex_state = 7},
  [904] = {.lex_state = 7},
  [905] = {.lex_state = 7},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 15},
  [923] = {.lex_state = 15},
  [924] = {.lex_state = 15},
  [925] = {.lex_state = 15},
  [926] = {.lex_state = 15},
  [927] = {.lex_state = 15},
  [928] = {.lex_state = 15},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 15},
  [931] = {.lex_state = 15},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 15},
  [934] = {.lex_state = 15},
  [935] = {.lex_state = 15},
  [936] = {.lex_state = 15},
  [937] = {.lex_state = 15},
  [938] = {.lex_state = 15},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 15},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 15},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 15},
  [949] = {.lex_state = 15},
  [950] = {.lex_state = 14},
  [951] = {.lex_state = 14},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 14},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 14},
  [958] = {.lex_state = 14},
  [959] = {.lex_state = 14},
  [960] = {.lex_state = 14},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 14},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 14},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 14},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 14},
  [974] = {.lex_state = 14},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 14},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 14},
  [980] = {.lex_state = 14},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 15},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 14},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 16},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 18},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 16},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 18},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 18},
  [1103] = {.lex_state = 18},
  [1104] = {.lex_state = 18},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 18},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 18},
  [1111] = {.lex_state = 18},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 18},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 18},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 18},
  [1119] = {.lex_state = 18},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 18},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 18},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 18},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 18},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 18},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 18},
  [1160] = {.lex_state = 18},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 0},
  [1163] = {.lex_state = 0},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 18},
  [1167] = {.lex_state = 18},
  [1168] = {.lex_state = 18},
  [1169] = {.lex_state = 18},
  [1170] = {.lex_state = 18},
  [1171] = {.lex_state = 18},
  [1172] = {.lex_state = 18},
  [1173] = {.lex_state = 18},
  [1174] = {.lex_state = 18},
  [1175] = {.lex_state = 18},
  [1176] = {.lex_state = 18},
  [1177] = {.lex_state = 18},
  [1178] = {.lex_state = 18},
  [1179] = {.lex_state = 18},
  [1180] = {.lex_state = 18},
  [1181] = {.lex_state = 18},
  [1182] = {.lex_state = 18},
  [1183] = {.lex_state = 18},
  [1184] = {.lex_state = 18},
  [1185] = {.lex_state = 18},
  [1186] = {.lex_state = 18},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 18},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 0},
  [1191] = {.lex_state = 0},
  [1192] = {.lex_state = 0},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 0},
  [1196] = {.lex_state = 0},
  [1197] = {.lex_state = 0},
  [1198] = {.lex_state = 0},
  [1199] = {.lex_state = 18},
  [1200] = {.lex_state = 0},
  [1201] = {.lex_state = 0},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 0},
  [1204] = {.lex_state = 0},
  [1205] = {.lex_state = 18},
  [1206] = {.lex_state = 0},
  [1207] = {.lex_state = 18},
  [1208] = {.lex_state = 0},
  [1209] = {.lex_state = 18},
  [1210] = {.lex_state = 0},
  [1211] = {.lex_state = 0},
  [1212] = {.lex_state = 0},
  [1213] = {.lex_state = 0},
  [1214] = {.lex_state = 0},
  [1215] = {.lex_state = 18},
  [1216] = {.lex_state = 0},
  [1217] = {.lex_state = 0},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 0},
  [1220] = {.lex_state = 0},
  [1221] = {.lex_state = 18},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 0},
  [1224] = {.lex_state = 18},
  [1225] = {.lex_state = 0},
  [1226] = {.lex_state = 0},
  [1227] = {.lex_state = 0},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 18},
  [1230] = {.lex_state = 0},
  [1231] = {.lex_state = 0},
  [1232] = {.lex_state = 0},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 0},
  [1235] = {.lex_state = 18},
  [1236] = {.lex_state = 18},
  [1237] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_main] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_cd] = ACTIONS(1),
    [anon_sym_echo] = ACTIONS(1),
    [anon_sym_exit] = ACTIONS(1),
    [anon_sym_mv] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [sym_reference] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [sym_preprocessor_directive] = ACTIONS(1),
    [sym_shebang] = ACTIONS(1),
    [anon_sym_pub] = ACTIONS(1),
    [anon_sym_fun] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_fail] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_loop] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [sym_boolean] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_Text] = ACTIONS(1),
    [anon_sym_Num] = ACTIONS(1),
    [anon_sym_Int] = ACTIONS(1),
    [anon_sym_Bool] = ACTIONS(1),
    [anon_sym_Null] = ACTIONS(1),
    [sym_status] = ACTIONS(1),
    [anon_sym_len] = ACTIONS(1),
    [anon_sym_lines] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_unsafe] = ACTIONS(1),
    [anon_sym_trust] = ACTIONS(1),
    [anon_sym_silent] = ACTIONS(1),
    [anon_sym_sudo] = ACTIONS(1),
    [anon_sym_nameof] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_failed] = ACTIONS(1),
    [anon_sym_succeeded] = ACTIONS(1),
    [anon_sym_exited] = ACTIONS(1),
    [sym_handler_propagation] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(1213),
    [sym__global_statement] = STATE(2),
    [sym__statement] = STATE(330),
    [sym_main_block] = STATE(330),
    [sym_builtin_stmt] = STATE(330),
    [sym_mv_stmt] = STATE(330),
    [sym_function_definition] = STATE(330),
    [sym_function_control_flow] = STATE(330),
    [sym_import_statement] = STATE(330),
    [sym_subscript_expression] = STATE(145),
    [sym_variable_init] = STATE(330),
    [sym_variable_assignment] = STATE(330),
    [sym_parentheses] = STATE(145),
    [sym_if_cond] = STATE(330),
    [sym_if_chain] = STATE(330),
    [sym_if_ternary] = STATE(145),
    [sym_loop_infinite] = STATE(330),
    [sym_for_loop] = STATE(330),
    [sym_while_loop] = STATE(330),
    [sym_loop_control_flow] = STATE(330),
    [sym_type_name_symbol] = STATE(62),
    [sym_type_name] = STATE(145),
    [sym_array] = STATE(145),
    [sym_function_call] = STATE(145),
    [sym_builtin_expr] = STATE(145),
    [sym_unop] = STATE(145),
    [sym_binop] = STATE(145),
    [sym_keyword_binop] = STATE(145),
    [sym_string] = STATE(145),
    [sym_command] = STATE(145),
    [sym_command_modifier_block] = STATE(145),
    [sym__expression] = STATE(145),
    [aux_sym_source_file_repeat1] = STATE(2),
    [aux_sym_command_modifier_block_repeat1] = STATE(945),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_main] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_cd] = ACTIONS(11),
    [anon_sym_echo] = ACTIONS(11),
    [anon_sym_exit] = ACTIONS(11),
    [anon_sym_mv] = ACTIONS(13),
    [sym_preprocessor_directive] = ACTIONS(15),
    [sym_shebang] = ACTIONS(17),
    [anon_sym_pub] = ACTIONS(19),
    [anon_sym_fun] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_fail] = ACTIONS(23),
    [anon_sym_import] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_const] = ACTIONS(29),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_loop] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(39),
    [sym_boolean] = ACTIONS(41),
    [sym_null] = ACTIONS(41),
    [sym_number] = ACTIONS(41),
    [anon_sym_Text] = ACTIONS(43),
    [anon_sym_Num] = ACTIONS(43),
    [anon_sym_Int] = ACTIONS(43),
    [anon_sym_Bool] = ACTIONS(43),
    [anon_sym_Null] = ACTIONS(43),
    [sym_status] = ACTIONS(41),
    [anon_sym_len] = ACTIONS(45),
    [anon_sym_lines] = ACTIONS(45),
    [anon_sym_DASH] = ACTIONS(47),
    [anon_sym_not] = ACTIONS(47),
    [anon_sym_unsafe] = ACTIONS(47),
    [anon_sym_trust] = ACTIONS(49),
    [anon_sym_silent] = ACTIONS(49),
    [anon_sym_sudo] = ACTIONS(49),
    [anon_sym_nameof] = ACTIONS(47),
    [sym_variable] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [anon_sym_DOLLAR] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__global_statement] = STATE(3),
    [sym__statement] = STATE(330),
    [sym_main_block] = STATE(330),
    [sym_builtin_stmt] = STATE(330),
    [sym_mv_stmt] = STATE(330),
    [sym_function_definition] = STATE(330),
    [sym_function_control_flow] = STATE(330),
    [sym_import_statement] = STATE(330),
    [sym_subscript_expression] = STATE(145),
    [sym_variable_init] = STATE(330),
    [sym_variable_assignment] = STATE(330),
    [sym_parentheses] = STATE(145),
    [sym_if_cond] = STATE(330),
    [sym_if_chain] = STATE(330),
    [sym_if_ternary] = STATE(145),
    [sym_loop_infinite] = STATE(330),
    [sym_for_loop] = STATE(330),
    [sym_while_loop] = STATE(330),
    [sym_loop_control_flow] = STATE(330),
    [sym_type_name_symbol] = STATE(62),
    [sym_type_name] = STATE(145),
    [sym_array] = STATE(145),
    [sym_function_call] = STATE(145),
    [sym_builtin_expr] = STATE(145),
    [sym_unop] = STATE(145),
    [sym_binop] = STATE(145),
    [sym_keyword_binop] = STATE(145),
    [sym_string] = STATE(145),
    [sym_command] = STATE(145),
    [sym_command_modifier_block] = STATE(145),
    [sym__expression] = STATE(145),
    [aux_sym_source_file_repeat1] = STATE(3),
    [aux_sym_command_modifier_block_repeat1] = STATE(945),
    [ts_builtin_sym_end] = ACTIONS(57),
    [anon_sym_main] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_cd] = ACTIONS(11),
    [anon_sym_echo] = ACTIONS(11),
    [anon_sym_exit] = ACTIONS(11),
    [anon_sym_mv] = ACTIONS(13),
    [sym_preprocessor_directive] = ACTIONS(15),
    [sym_shebang] = ACTIONS(17),
    [anon_sym_pub] = ACTIONS(19),
    [anon_sym_fun] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_fail] = ACTIONS(23),
    [anon_sym_import] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_const] = ACTIONS(29),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_loop] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(39),
    [sym_boolean] = ACTIONS(41),
    [sym_null] = ACTIONS(41),
    [sym_number] = ACTIONS(41),
    [anon_sym_Text] = ACTIONS(43),
    [anon_sym_Num] = ACTIONS(43),
    [anon_sym_Int] = ACTIONS(43),
    [anon_sym_Bool] = ACTIONS(43),
    [anon_sym_Null] = ACTIONS(43),
    [sym_status] = ACTIONS(41),
    [anon_sym_len] = ACTIONS(45),
    [anon_sym_lines] = ACTIONS(45),
    [anon_sym_DASH] = ACTIONS(47),
    [anon_sym_not] = ACTIONS(47),
    [anon_sym_unsafe] = ACTIONS(47),
    [anon_sym_trust] = ACTIONS(49),
    [anon_sym_silent] = ACTIONS(49),
    [anon_sym_sudo] = ACTIONS(49),
    [anon_sym_nameof] = ACTIONS(47),
    [sym_variable] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [anon_sym_DOLLAR] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__global_statement] = STATE(3),
    [sym__statement] = STATE(330),
    [sym_main_block] = STATE(330),
    [sym_builtin_stmt] = STATE(330),
    [sym_mv_stmt] = STATE(330),
    [sym_function_definition] = STATE(330),
    [sym_function_control_flow] = STATE(330),
    [sym_import_statement] = STATE(330),
    [sym_subscript_expression] = STATE(145),
    [sym_variable_init] = STATE(330),
    [sym_variable_assignment] = STATE(330),
    [sym_parentheses] = STATE(145),
    [sym_if_cond] = STATE(330),
    [sym_if_chain] = STATE(330),
    [sym_if_ternary] = STATE(145),
    [sym_loop_infinite] = STATE(330),
    [sym_for_loop] = STATE(330),
    [sym_while_loop] = STATE(330),
    [sym_loop_control_flow] = STATE(330),
    [sym_type_name_symbol] = STATE(62),
    [sym_type_name] = STATE(145),
    [sym_array] = STATE(145),
    [sym_function_call] = STATE(145),
    [sym_builtin_expr] = STATE(145),
    [sym_unop] = STATE(145),
    [sym_binop] = STATE(145),
    [sym_keyword_binop] = STATE(145),
    [sym_string] = STATE(145),
    [sym_command] = STATE(145),
    [sym_command_modifier_block] = STATE(145),
    [sym__expression] = STATE(145),
    [aux_sym_source_file_repeat1] = STATE(3),
    [aux_sym_command_modifier_block_repeat1] = STATE(945),
    [ts_builtin_sym_end] = ACTIONS(59),
    [anon_sym_main] = ACTIONS(61),
    [anon_sym_LPAREN] = ACTIONS(64),
    [anon_sym_cd] = ACTIONS(67),
    [anon_sym_echo] = ACTIONS(67),
    [anon_sym_exit] = ACTIONS(67),
    [anon_sym_mv] = ACTIONS(70),
    [sym_preprocessor_directive] = ACTIONS(73),
    [sym_shebang] = ACTIONS(76),
    [anon_sym_pub] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(82),
    [anon_sym_return] = ACTIONS(85),
    [anon_sym_fail] = ACTIONS(85),
    [anon_sym_import] = ACTIONS(88),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_const] = ACTIONS(94),
    [anon_sym_let] = ACTIONS(94),
    [anon_sym_if] = ACTIONS(97),
    [anon_sym_loop] = ACTIONS(100),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(106),
    [anon_sym_break] = ACTIONS(109),
    [anon_sym_continue] = ACTIONS(109),
    [sym_boolean] = ACTIONS(112),
    [sym_null] = ACTIONS(112),
    [sym_number] = ACTIONS(112),
    [anon_sym_Text] = ACTIONS(115),
    [anon_sym_Num] = ACTIONS(115),
    [anon_sym_Int] = ACTIONS(115),
    [anon_sym_Bool] = ACTIONS(115),
    [anon_sym_Null] = ACTIONS(115),
    [sym_status] = ACTIONS(112),
    [anon_sym_len] = ACTIONS(118),
    [anon_sym_lines] = ACTIONS(118),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_not] = ACTIONS(121),
    [anon_sym_unsafe] = ACTIONS(121),
    [anon_sym_trust] = ACTIONS(124),
    [anon_sym_silent] = ACTIONS(124),
    [anon_sym_sudo] = ACTIONS(124),
    [anon_sym_nameof] = ACTIONS(121),
    [sym_variable] = ACTIONS(127),
    [anon_sym_DQUOTE] = ACTIONS(130),
    [anon_sym_DOLLAR] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym_handler_failed] = STATE(121),
    [sym_handler_succeeded] = STATE(121),
    [sym_handler_exited] = STATE(121),
    [sym_handler] = STATE(138),
    [ts_builtin_sym_end] = ACTIONS(136),
    [anon_sym_SEMI] = ACTIONS(136),
    [anon_sym_main] = ACTIONS(138),
    [anon_sym_LPAREN] = ACTIONS(136),
    [anon_sym_cd] = ACTIONS(138),
    [anon_sym_echo] = ACTIONS(138),
    [anon_sym_exit] = ACTIONS(138),
    [anon_sym_mv] = ACTIONS(138),
    [sym_preprocessor_directive] = ACTIONS(136),
    [sym_shebang] = ACTIONS(136),
    [anon_sym_pub] = ACTIONS(138),
    [anon_sym_fun] = ACTIONS(138),
    [anon_sym_return] = ACTIONS(138),
    [anon_sym_fail] = ACTIONS(138),
    [anon_sym_as] = ACTIONS(138),
    [anon_sym_import] = ACTIONS(138),
    [anon_sym_STAR] = ACTIONS(136),
    [anon_sym_LBRACK] = ACTIONS(136),
    [anon_sym_const] = ACTIONS(138),
    [anon_sym_let] = ACTIONS(138),
    [anon_sym_if] = ACTIONS(138),
    [anon_sym_else] = ACTIONS(138),
    [anon_sym_then] = ACTIONS(138),
    [anon_sym_loop] = ACTIONS(138),
    [anon_sym_for] = ACTIONS(138),
    [anon_sym_while] = ACTIONS(138),
    [anon_sym_break] = ACTIONS(138),
    [anon_sym_continue] = ACTIONS(138),
    [sym_boolean] = ACTIONS(138),
    [sym_null] = ACTIONS(138),
    [sym_number] = ACTIONS(138),
    [anon_sym_Text] = ACTIONS(138),
    [anon_sym_Num] = ACTIONS(138),
    [anon_sym_Int] = ACTIONS(138),
    [anon_sym_Bool] = ACTIONS(138),
    [anon_sym_Null] = ACTIONS(138),
    [sym_status] = ACTIONS(138),
    [anon_sym_len] = ACTIONS(138),
    [anon_sym_lines] = ACTIONS(138),
    [anon_sym_DASH] = ACTIONS(138),
    [anon_sym_not] = ACTIONS(138),
    [anon_sym_unsafe] = ACTIONS(138),
    [anon_sym_trust] = ACTIONS(138),
    [anon_sym_silent] = ACTIONS(138),
    [anon_sym_sudo] = ACTIONS(138),
    [anon_sym_nameof] = ACTIONS(138),
    [anon_sym_SLASH] = ACTIONS(138),
    [anon_sym_PLUS] = ACTIONS(138),
    [anon_sym_PERCENT] = ACTIONS(136),
    [anon_sym_GT] = ACTIONS(138),
    [anon_sym_LT] = ACTIONS(138),
    [anon_sym_GT_EQ] = ACTIONS(136),
    [anon_sym_LT_EQ] = ACTIONS(136),
    [anon_sym_EQ_EQ] = ACTIONS(136),
    [anon_sym_BANG_EQ] = ACTIONS(136),
    [anon_sym_and] = ACTIONS(138),
    [anon_sym_or] = ACTIONS(138),
    [anon_sym_is] = ACTIONS(138),
    [sym_variable] = ACTIONS(138),
    [anon_sym_DQUOTE] = ACTIONS(136),
    [anon_sym_failed] = ACTIONS(140),
    [anon_sym_succeeded] = ACTIONS(142),
    [anon_sym_exited] = ACTIONS(144),
    [sym_handler_propagation] = ACTIONS(146),
    [anon_sym_DOLLAR] = ACTIONS(136),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym_handler_failed] = STATE(121),
    [sym_handler_succeeded] = STATE(121),
    [sym_handler_exited] = STATE(121),
    [sym_handler] = STATE(98),
    [ts_builtin_sym_end] = ACTIONS(148),
    [anon_sym_SEMI] = ACTIONS(148),
    [anon_sym_main] = ACTIONS(150),
    [anon_sym_LPAREN] = ACTIONS(148),
    [anon_sym_cd] = ACTIONS(150),
    [anon_sym_echo] = ACTIONS(150),
    [anon_sym_exit] = ACTIONS(150),
    [anon_sym_mv] = ACTIONS(150),
    [sym_preprocessor_directive] = ACTIONS(148),
    [sym_shebang] = ACTIONS(148),
    [anon_sym_pub] = ACTIONS(150),
    [anon_sym_fun] = ACTIONS(150),
    [anon_sym_return] = ACTIONS(150),
    [anon_sym_fail] = ACTIONS(150),
    [anon_sym_as] = ACTIONS(150),
    [anon_sym_import] = ACTIONS(150),
    [anon_sym_STAR] = ACTIONS(148),
    [anon_sym_LBRACK] = ACTIONS(148),
    [anon_sym_const] = ACTIONS(150),
    [anon_sym_let] = ACTIONS(150),
    [anon_sym_if] = ACTIONS(150),
    [anon_sym_else] = ACTIONS(150),
    [anon_sym_then] = ACTIONS(150),
    [anon_sym_loop] = ACTIONS(150),
    [anon_sym_for] = ACTIONS(150),
    [anon_sym_while] = ACTIONS(150),
    [anon_sym_break] = ACTIONS(150),
    [anon_sym_continue] = ACTIONS(150),
    [sym_boolean] = ACTIONS(150),
    [sym_null] = ACTIONS(150),
    [sym_number] = ACTIONS(150),
    [anon_sym_Text] = ACTIONS(150),
    [anon_sym_Num] = ACTIONS(150),
    [anon_sym_Int] = ACTIONS(150),
    [anon_sym_Bool] = ACTIONS(150),
    [anon_sym_Null] = ACTIONS(150),
    [sym_status] = ACTIONS(150),
    [anon_sym_len] = ACTIONS(150),
    [anon_sym_lines] = ACTIONS(150),
    [anon_sym_DASH] = ACTIONS(150),
    [anon_sym_not] = ACTIONS(150),
    [anon_sym_unsafe] = ACTIONS(150),
    [anon_sym_trust] = ACTIONS(150),
    [anon_sym_silent] = ACTIONS(150),
    [anon_sym_sudo] = ACTIONS(150),
    [anon_sym_nameof] = ACTIONS(150),
    [anon_sym_SLASH] = ACTIONS(150),
    [anon_sym_PLUS] = ACTIONS(150),
    [anon_sym_PERCENT] = ACTIONS(148),
    [anon_sym_GT] = ACTIONS(150),
    [anon_sym_LT] = ACTIONS(150),
    [anon_sym_GT_EQ] = ACTIONS(148),
    [anon_sym_LT_EQ] = ACTIONS(148),
    [anon_sym_EQ_EQ] = ACTIONS(148),
    [anon_sym_BANG_EQ] = ACTIONS(148),
    [anon_sym_and] = ACTIONS(150),
    [anon_sym_or] = ACTIONS(150),
    [anon_sym_is] = ACTIONS(150),
    [sym_variable] = ACTIONS(150),
    [anon_sym_DQUOTE] = ACTIONS(148),
    [anon_sym_failed] = ACTIONS(140),
    [anon_sym_succeeded] = ACTIONS(142),
    [anon_sym_exited] = ACTIONS(144),
    [sym_handler_propagation] = ACTIONS(146),
    [anon_sym_DOLLAR] = ACTIONS(148),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym_handler_failed] = STATE(121),
    [sym_handler_succeeded] = STATE(121),
    [sym_handler_exited] = STATE(121),
    [sym_handler] = STATE(123),
    [ts_builtin_sym_end] = ACTIONS(152),
    [anon_sym_SEMI] = ACTIONS(152),
    [anon_sym_main] = ACTIONS(154),
    [anon_sym_LPAREN] = ACTIONS(152),
    [anon_sym_cd] = ACTIONS(154),
    [anon_sym_echo] = ACTIONS(154),
    [anon_sym_exit] = ACTIONS(154),
    [anon_sym_mv] = ACTIONS(154),
    [sym_preprocessor_directive] = ACTIONS(152),
    [sym_shebang] = ACTIONS(152),
    [anon_sym_pub] = ACTIONS(154),
    [anon_sym_fun] = ACTIONS(154),
    [anon_sym_return] = ACTIONS(154),
    [anon_sym_fail] = ACTIONS(154),
    [anon_sym_as] = ACTIONS(154),
    [anon_sym_import] = ACTIONS(154),
    [anon_sym_STAR] = ACTIONS(152),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_const] = ACTIONS(154),
    [anon_sym_let] = ACTIONS(154),
    [anon_sym_if] = ACTIONS(154),
    [anon_sym_else] = ACTIONS(154),
    [anon_sym_then] = ACTIONS(154),
    [anon_sym_loop] = ACTIONS(154),
    [anon_sym_for] = ACTIONS(154),
    [anon_sym_while] = ACTIONS(154),
    [anon_sym_break] = ACTIONS(154),
    [anon_sym_continue] = ACTIONS(154),
    [sym_boolean] = ACTIONS(154),
    [sym_null] = ACTIONS(154),
    [sym_number] = ACTIONS(154),
    [anon_sym_Text] = ACTIONS(154),
    [anon_sym_Num] = ACTIONS(154),
    [anon_sym_Int] = ACTIONS(154),
    [anon_sym_Bool] = ACTIONS(154),
    [anon_sym_Null] = ACTIONS(154),
    [sym_status] = ACTIONS(154),
    [anon_sym_len] = ACTIONS(154),
    [anon_sym_lines] = ACTIONS(154),
    [anon_sym_DASH] = ACTIONS(154),
    [anon_sym_not] = ACTIONS(154),
    [anon_sym_unsafe] = ACTIONS(154),
    [anon_sym_trust] = ACTIONS(154),
    [anon_sym_silent] = ACTIONS(154),
    [anon_sym_sudo] = ACTIONS(154),
    [anon_sym_nameof] = ACTIONS(154),
    [anon_sym_SLASH] = ACTIONS(154),
    [anon_sym_PLUS] = ACTIONS(154),
    [anon_sym_PERCENT] = ACTIONS(152),
    [anon_sym_GT] = ACTIONS(154),
    [anon_sym_LT] = ACTIONS(154),
    [anon_sym_GT_EQ] = ACTIONS(152),
    [anon_sym_LT_EQ] = ACTIONS(152),
    [anon_sym_EQ_EQ] = ACTIONS(152),
    [anon_sym_BANG_EQ] = ACTIONS(152),
    [anon_sym_and] = ACTIONS(154),
    [anon_sym_or] = ACTIONS(154),
    [anon_sym_is] = ACTIONS(154),
    [sym_variable] = ACTIONS(154),
    [anon_sym_DQUOTE] = ACTIONS(152),
    [anon_sym_failed] = ACTIONS(140),
    [anon_sym_succeeded] = ACTIONS(142),
    [anon_sym_exited] = ACTIONS(144),
    [sym_handler_propagation] = ACTIONS(146),
    [anon_sym_DOLLAR] = ACTIONS(152),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym_parameter_list] = STATE(6),
    [sym_subscript] = STATE(954),
    [ts_builtin_sym_end] = ACTIONS(156),
    [anon_sym_SEMI] = ACTIONS(156),
    [anon_sym_main] = ACTIONS(158),
    [anon_sym_LPAREN] = ACTIONS(160),
    [anon_sym_cd] = ACTIONS(158),
    [anon_sym_echo] = ACTIONS(158),
    [anon_sym_exit] = ACTIONS(158),
    [anon_sym_mv] = ACTIONS(158),
    [anon_sym_EQ] = ACTIONS(162),
    [sym_preprocessor_directive] = ACTIONS(156),
    [sym_shebang] = ACTIONS(156),
    [anon_sym_pub] = ACTIONS(158),
    [anon_sym_fun] = ACTIONS(158),
    [anon_sym_return] = ACTIONS(158),
    [anon_sym_fail] = ACTIONS(158),
    [anon_sym_as] = ACTIONS(158),
    [anon_sym_import] = ACTIONS(158),
    [anon_sym_STAR] = ACTIONS(158),
    [anon_sym_LBRACK] = ACTIONS(164),
    [anon_sym_const] = ACTIONS(158),
    [anon_sym_let] = ACTIONS(158),
    [anon_sym_PLUS_EQ] = ACTIONS(166),
    [anon_sym_DASH_EQ] = ACTIONS(166),
    [anon_sym_STAR_EQ] = ACTIONS(166),
    [anon_sym_SLASH_EQ] = ACTIONS(166),
    [anon_sym_PERCENT_EQ] = ACTIONS(166),
    [anon_sym_if] = ACTIONS(158),
    [anon_sym_else] = ACTIONS(158),
    [anon_sym_then] = ACTIONS(158),
    [anon_sym_loop] = ACTIONS(158),
    [anon_sym_for] = ACTIONS(158),
    [anon_sym_while] = ACTIONS(158),
    [anon_sym_break] = ACTIONS(158),
    [anon_sym_continue] = ACTIONS(158),
    [sym_boolean] = ACTIONS(158),
    [sym_null] = ACTIONS(158),
    [sym_number] = ACTIONS(158),
    [anon_sym_Text] = ACTIONS(158),
    [anon_sym_Num] = ACTIONS(158),
    [anon_sym_Int] = ACTIONS(158),
    [anon_sym_Bool] = ACTIONS(158),
    [anon_sym_Null] = ACTIONS(158),
    [sym_status] = ACTIONS(158),
    [anon_sym_len] = ACTIONS(158),
    [anon_sym_lines] = ACTIONS(158),
    [anon_sym_DASH] = ACTIONS(158),
    [anon_sym_not] = ACTIONS(158),
    [anon_sym_unsafe] = ACTIONS(158),
    [anon_sym_trust] = ACTIONS(158),
    [anon_sym_silent] = ACTIONS(158),
    [anon_sym_sudo] = ACTIONS(158),
    [anon_sym_nameof] = ACTIONS(158),
    [anon_sym_SLASH] = ACTIONS(158),
    [anon_sym_PLUS] = ACTIONS(158),
    [anon_sym_PERCENT] = ACTIONS(158),
    [anon_sym_GT] = ACTIONS(158),
    [anon_sym_LT] = ACTIONS(158),
    [anon_sym_GT_EQ] = ACTIONS(156),
    [anon_sym_LT_EQ] = ACTIONS(156),
    [anon_sym_EQ_EQ] = ACTIONS(156),
    [anon_sym_BANG_EQ] = ACTIONS(156),
    [anon_sym_and] = ACTIONS(158),
    [anon_sym_or] = ACTIONS(158),
    [anon_sym_is] = ACTIONS(158),
    [sym_variable] = ACTIONS(158),
    [anon_sym_DQUOTE] = ACTIONS(156),
    [anon_sym_DOLLAR] = ACTIONS(156),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym_parameter_list] = STATE(6),
    [sym_subscript] = STATE(978),
    [ts_builtin_sym_end] = ACTIONS(156),
    [anon_sym_SEMI] = ACTIONS(156),
    [anon_sym_main] = ACTIONS(158),
    [anon_sym_LPAREN] = ACTIONS(160),
    [anon_sym_cd] = ACTIONS(158),
    [anon_sym_echo] = ACTIONS(158),
    [anon_sym_exit] = ACTIONS(158),
    [anon_sym_mv] = ACTIONS(158),
    [anon_sym_EQ] = ACTIONS(168),
    [sym_preprocessor_directive] = ACTIONS(156),
    [sym_shebang] = ACTIONS(156),
    [anon_sym_pub] = ACTIONS(158),
    [anon_sym_fun] = ACTIONS(158),
    [anon_sym_return] = ACTIONS(158),
    [anon_sym_fail] = ACTIONS(158),
    [anon_sym_as] = ACTIONS(158),
    [anon_sym_import] = ACTIONS(158),
    [anon_sym_STAR] = ACTIONS(158),
    [anon_sym_LBRACK] = ACTIONS(164),
    [anon_sym_const] = ACTIONS(158),
    [anon_sym_let] = ACTIONS(158),
    [anon_sym_PLUS_EQ] = ACTIONS(170),
    [anon_sym_DASH_EQ] = ACTIONS(170),
    [anon_sym_STAR_EQ] = ACTIONS(170),
    [anon_sym_SLASH_EQ] = ACTIONS(170),
    [anon_sym_PERCENT_EQ] = ACTIONS(170),
    [anon_sym_if] = ACTIONS(158),
    [anon_sym_else] = ACTIONS(158),
    [anon_sym_then] = ACTIONS(158),
    [anon_sym_loop] = ACTIONS(158),
    [anon_sym_for] = ACTIONS(158),
    [anon_sym_while] = ACTIONS(158),
    [anon_sym_break] = ACTIONS(158),
    [anon_sym_continue] = ACTIONS(158),
    [sym_boolean] = ACTIONS(158),
    [sym_null] = ACTIONS(158),
    [sym_number] = ACTIONS(158),
    [anon_sym_Text] = ACTIONS(158),
    [anon_sym_Num] = ACTIONS(158),
    [anon_sym_Int] = ACTIONS(158),
    [anon_sym_Bool] = ACTIONS(158),
    [anon_sym_Null] = ACTIONS(158),
    [sym_status] = ACTIONS(158),
    [anon_sym_len] = ACTIONS(158),
    [anon_sym_lines] = ACTIONS(158),
    [anon_sym_DASH] = ACTIONS(158),
    [anon_sym_not] = ACTIONS(158),
    [anon_sym_unsafe] = ACTIONS(158),
    [anon_sym_trust] = ACTIONS(158),
    [anon_sym_silent] = ACTIONS(158),
    [anon_sym_sudo] = ACTIONS(158),
    [anon_sym_nameof] = ACTIONS(158),
    [anon_sym_SLASH] = ACTIONS(158),
    [anon_sym_PLUS] = ACTIONS(158),
    [anon_sym_PERCENT] = ACTIONS(158),
    [anon_sym_GT] = ACTIONS(158),
    [anon_sym_LT] = ACTIONS(158),
    [anon_sym_GT_EQ] = ACTIONS(156),
    [anon_sym_LT_EQ] = ACTIONS(156),
    [anon_sym_EQ_EQ] = ACTIONS(156),
    [anon_sym_BANG_EQ] = ACTIONS(156),
    [anon_sym_and] = ACTIONS(158),
    [anon_sym_or] = ACTIONS(158),
    [anon_sym_is] = ACTIONS(158),
    [sym_variable] = ACTIONS(158),
    [anon_sym_DQUOTE] = ACTIONS(156),
    [anon_sym_DOLLAR] = ACTIONS(156),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__statement] = STATE(18),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(18),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(172),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym_handler_failed] = STATE(153),
    [sym_handler_succeeded] = STATE(153),
    [sym_handler_exited] = STATE(153),
    [sym_handler] = STATE(168),
    [ts_builtin_sym_end] = ACTIONS(136),
    [anon_sym_SEMI] = ACTIONS(136),
    [anon_sym_main] = ACTIONS(138),
    [anon_sym_LPAREN] = ACTIONS(136),
    [anon_sym_cd] = ACTIONS(138),
    [anon_sym_echo] = ACTIONS(138),
    [anon_sym_exit] = ACTIONS(138),
    [anon_sym_mv] = ACTIONS(138),
    [sym_preprocessor_directive] = ACTIONS(136),
    [sym_shebang] = ACTIONS(136),
    [anon_sym_pub] = ACTIONS(138),
    [anon_sym_fun] = ACTIONS(138),
    [anon_sym_return] = ACTIONS(138),
    [anon_sym_fail] = ACTIONS(138),
    [anon_sym_as] = ACTIONS(138),
    [anon_sym_import] = ACTIONS(138),
    [anon_sym_STAR] = ACTIONS(136),
    [anon_sym_LBRACK] = ACTIONS(136),
    [anon_sym_const] = ACTIONS(138),
    [anon_sym_let] = ACTIONS(138),
    [anon_sym_if] = ACTIONS(138),
    [anon_sym_then] = ACTIONS(138),
    [anon_sym_loop] = ACTIONS(138),
    [anon_sym_for] = ACTIONS(138),
    [anon_sym_while] = ACTIONS(138),
    [anon_sym_break] = ACTIONS(138),
    [anon_sym_continue] = ACTIONS(138),
    [sym_boolean] = ACTIONS(138),
    [sym_null] = ACTIONS(138),
    [sym_number] = ACTIONS(138),
    [anon_sym_Text] = ACTIONS(138),
    [anon_sym_Num] = ACTIONS(138),
    [anon_sym_Int] = ACTIONS(138),
    [anon_sym_Bool] = ACTIONS(138),
    [anon_sym_Null] = ACTIONS(138),
    [sym_status] = ACTIONS(138),
    [anon_sym_len] = ACTIONS(138),
    [anon_sym_lines] = ACTIONS(138),
    [anon_sym_DASH] = ACTIONS(138),
    [anon_sym_not] = ACTIONS(138),
    [anon_sym_unsafe] = ACTIONS(138),
    [anon_sym_trust] = ACTIONS(138),
    [anon_sym_silent] = ACTIONS(138),
    [anon_sym_sudo] = ACTIONS(138),
    [anon_sym_nameof] = ACTIONS(138),
    [anon_sym_SLASH] = ACTIONS(138),
    [anon_sym_PLUS] = ACTIONS(138),
    [anon_sym_PERCENT] = ACTIONS(136),
    [anon_sym_GT] = ACTIONS(138),
    [anon_sym_LT] = ACTIONS(138),
    [anon_sym_GT_EQ] = ACTIONS(136),
    [anon_sym_LT_EQ] = ACTIONS(136),
    [anon_sym_EQ_EQ] = ACTIONS(136),
    [anon_sym_BANG_EQ] = ACTIONS(136),
    [anon_sym_and] = ACTIONS(138),
    [anon_sym_or] = ACTIONS(138),
    [anon_sym_is] = ACTIONS(138),
    [sym_variable] = ACTIONS(138),
    [anon_sym_DQUOTE] = ACTIONS(136),
    [anon_sym_failed] = ACTIONS(214),
    [anon_sym_succeeded] = ACTIONS(216),
    [anon_sym_exited] = ACTIONS(218),
    [sym_handler_propagation] = ACTIONS(220),
    [anon_sym_DOLLAR] = ACTIONS(136),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__statement] = STATE(36),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(36),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(222),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__statement] = STATE(19),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(19),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(224),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__statement] = STATE(12),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(12),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(226),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__statement] = STATE(19),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(19),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(228),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__statement] = STATE(14),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(14),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(230),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__statement] = STATE(19),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(19),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(232),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__statement] = STATE(16),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(16),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(234),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__statement] = STATE(19),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(19),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(236),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__statement] = STATE(19),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(19),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(240),
    [anon_sym_cd] = ACTIONS(243),
    [anon_sym_echo] = ACTIONS(243),
    [anon_sym_exit] = ACTIONS(243),
    [anon_sym_mv] = ACTIONS(246),
    [sym_shebang] = ACTIONS(249),
    [anon_sym_return] = ACTIONS(252),
    [anon_sym_fail] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(255),
    [anon_sym_const] = ACTIONS(258),
    [anon_sym_let] = ACTIONS(258),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_loop] = ACTIONS(264),
    [anon_sym_for] = ACTIONS(267),
    [anon_sym_while] = ACTIONS(270),
    [anon_sym_break] = ACTIONS(273),
    [anon_sym_continue] = ACTIONS(273),
    [sym_boolean] = ACTIONS(276),
    [sym_null] = ACTIONS(276),
    [sym_number] = ACTIONS(276),
    [anon_sym_Text] = ACTIONS(279),
    [anon_sym_Num] = ACTIONS(279),
    [anon_sym_Int] = ACTIONS(279),
    [anon_sym_Bool] = ACTIONS(279),
    [anon_sym_Null] = ACTIONS(279),
    [sym_status] = ACTIONS(276),
    [anon_sym_len] = ACTIONS(282),
    [anon_sym_lines] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(285),
    [anon_sym_not] = ACTIONS(285),
    [anon_sym_unsafe] = ACTIONS(285),
    [anon_sym_trust] = ACTIONS(288),
    [anon_sym_silent] = ACTIONS(288),
    [anon_sym_sudo] = ACTIONS(288),
    [anon_sym_nameof] = ACTIONS(285),
    [sym_variable] = ACTIONS(291),
    [anon_sym_DQUOTE] = ACTIONS(294),
    [anon_sym_DOLLAR] = ACTIONS(297),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__statement] = STATE(19),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(19),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(300),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym__statement] = STATE(19),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(19),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(302),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym__statement] = STATE(21),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(21),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(304),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym_parameter_list] = STATE(29),
    [sym_subscript] = STATE(969),
    [ts_builtin_sym_end] = ACTIONS(156),
    [anon_sym_SEMI] = ACTIONS(156),
    [anon_sym_main] = ACTIONS(158),
    [anon_sym_LPAREN] = ACTIONS(306),
    [anon_sym_cd] = ACTIONS(158),
    [anon_sym_echo] = ACTIONS(158),
    [anon_sym_exit] = ACTIONS(158),
    [anon_sym_mv] = ACTIONS(158),
    [anon_sym_EQ] = ACTIONS(308),
    [sym_preprocessor_directive] = ACTIONS(156),
    [sym_shebang] = ACTIONS(156),
    [anon_sym_pub] = ACTIONS(158),
    [anon_sym_fun] = ACTIONS(158),
    [anon_sym_return] = ACTIONS(158),
    [anon_sym_fail] = ACTIONS(158),
    [anon_sym_as] = ACTIONS(158),
    [anon_sym_import] = ACTIONS(158),
    [anon_sym_STAR] = ACTIONS(158),
    [anon_sym_LBRACK] = ACTIONS(164),
    [anon_sym_const] = ACTIONS(158),
    [anon_sym_let] = ACTIONS(158),
    [anon_sym_PLUS_EQ] = ACTIONS(310),
    [anon_sym_DASH_EQ] = ACTIONS(310),
    [anon_sym_STAR_EQ] = ACTIONS(310),
    [anon_sym_SLASH_EQ] = ACTIONS(310),
    [anon_sym_PERCENT_EQ] = ACTIONS(310),
    [anon_sym_if] = ACTIONS(158),
    [anon_sym_then] = ACTIONS(158),
    [anon_sym_loop] = ACTIONS(158),
    [anon_sym_for] = ACTIONS(158),
    [anon_sym_while] = ACTIONS(158),
    [anon_sym_break] = ACTIONS(158),
    [anon_sym_continue] = ACTIONS(158),
    [sym_boolean] = ACTIONS(158),
    [sym_null] = ACTIONS(158),
    [sym_number] = ACTIONS(158),
    [anon_sym_Text] = ACTIONS(158),
    [anon_sym_Num] = ACTIONS(158),
    [anon_sym_Int] = ACTIONS(158),
    [anon_sym_Bool] = ACTIONS(158),
    [anon_sym_Null] = ACTIONS(158),
    [sym_status] = ACTIONS(158),
    [anon_sym_len] = ACTIONS(158),
    [anon_sym_lines] = ACTIONS(158),
    [anon_sym_DASH] = ACTIONS(158),
    [anon_sym_not] = ACTIONS(158),
    [anon_sym_unsafe] = ACTIONS(158),
    [anon_sym_trust] = ACTIONS(158),
    [anon_sym_silent] = ACTIONS(158),
    [anon_sym_sudo] = ACTIONS(158),
    [anon_sym_nameof] = ACTIONS(158),
    [anon_sym_SLASH] = ACTIONS(158),
    [anon_sym_PLUS] = ACTIONS(158),
    [anon_sym_PERCENT] = ACTIONS(158),
    [anon_sym_GT] = ACTIONS(158),
    [anon_sym_LT] = ACTIONS(158),
    [anon_sym_GT_EQ] = ACTIONS(156),
    [anon_sym_LT_EQ] = ACTIONS(156),
    [anon_sym_EQ_EQ] = ACTIONS(156),
    [anon_sym_BANG_EQ] = ACTIONS(156),
    [anon_sym_and] = ACTIONS(158),
    [anon_sym_or] = ACTIONS(158),
    [anon_sym_is] = ACTIONS(158),
    [sym_variable] = ACTIONS(158),
    [anon_sym_DQUOTE] = ACTIONS(156),
    [anon_sym_DOLLAR] = ACTIONS(156),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym__statement] = STATE(19),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(19),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(312),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym__statement] = STATE(24),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(24),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(314),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym__statement] = STATE(19),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(19),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(316),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym__statement] = STATE(26),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(26),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(318),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym_handler_failed] = STATE(153),
    [sym_handler_succeeded] = STATE(153),
    [sym_handler_exited] = STATE(153),
    [sym_handler] = STATE(184),
    [ts_builtin_sym_end] = ACTIONS(148),
    [anon_sym_SEMI] = ACTIONS(148),
    [anon_sym_main] = ACTIONS(150),
    [anon_sym_LPAREN] = ACTIONS(148),
    [anon_sym_cd] = ACTIONS(150),
    [anon_sym_echo] = ACTIONS(150),
    [anon_sym_exit] = ACTIONS(150),
    [anon_sym_mv] = ACTIONS(150),
    [sym_preprocessor_directive] = ACTIONS(148),
    [sym_shebang] = ACTIONS(148),
    [anon_sym_pub] = ACTIONS(150),
    [anon_sym_fun] = ACTIONS(150),
    [anon_sym_return] = ACTIONS(150),
    [anon_sym_fail] = ACTIONS(150),
    [anon_sym_as] = ACTIONS(150),
    [anon_sym_import] = ACTIONS(150),
    [anon_sym_STAR] = ACTIONS(148),
    [anon_sym_LBRACK] = ACTIONS(148),
    [anon_sym_const] = ACTIONS(150),
    [anon_sym_let] = ACTIONS(150),
    [anon_sym_if] = ACTIONS(150),
    [anon_sym_then] = ACTIONS(150),
    [anon_sym_loop] = ACTIONS(150),
    [anon_sym_for] = ACTIONS(150),
    [anon_sym_while] = ACTIONS(150),
    [anon_sym_break] = ACTIONS(150),
    [anon_sym_continue] = ACTIONS(150),
    [sym_boolean] = ACTIONS(150),
    [sym_null] = ACTIONS(150),
    [sym_number] = ACTIONS(150),
    [anon_sym_Text] = ACTIONS(150),
    [anon_sym_Num] = ACTIONS(150),
    [anon_sym_Int] = ACTIONS(150),
    [anon_sym_Bool] = ACTIONS(150),
    [anon_sym_Null] = ACTIONS(150),
    [sym_status] = ACTIONS(150),
    [anon_sym_len] = ACTIONS(150),
    [anon_sym_lines] = ACTIONS(150),
    [anon_sym_DASH] = ACTIONS(150),
    [anon_sym_not] = ACTIONS(150),
    [anon_sym_unsafe] = ACTIONS(150),
    [anon_sym_trust] = ACTIONS(150),
    [anon_sym_silent] = ACTIONS(150),
    [anon_sym_sudo] = ACTIONS(150),
    [anon_sym_nameof] = ACTIONS(150),
    [anon_sym_SLASH] = ACTIONS(150),
    [anon_sym_PLUS] = ACTIONS(150),
    [anon_sym_PERCENT] = ACTIONS(148),
    [anon_sym_GT] = ACTIONS(150),
    [anon_sym_LT] = ACTIONS(150),
    [anon_sym_GT_EQ] = ACTIONS(148),
    [anon_sym_LT_EQ] = ACTIONS(148),
    [anon_sym_EQ_EQ] = ACTIONS(148),
    [anon_sym_BANG_EQ] = ACTIONS(148),
    [anon_sym_and] = ACTIONS(150),
    [anon_sym_or] = ACTIONS(150),
    [anon_sym_is] = ACTIONS(150),
    [sym_variable] = ACTIONS(150),
    [anon_sym_DQUOTE] = ACTIONS(148),
    [anon_sym_failed] = ACTIONS(214),
    [anon_sym_succeeded] = ACTIONS(216),
    [anon_sym_exited] = ACTIONS(218),
    [sym_handler_propagation] = ACTIONS(220),
    [anon_sym_DOLLAR] = ACTIONS(148),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym_handler_failed] = STATE(153),
    [sym_handler_succeeded] = STATE(153),
    [sym_handler_exited] = STATE(153),
    [sym_handler] = STATE(154),
    [ts_builtin_sym_end] = ACTIONS(152),
    [anon_sym_SEMI] = ACTIONS(152),
    [anon_sym_main] = ACTIONS(154),
    [anon_sym_LPAREN] = ACTIONS(152),
    [anon_sym_cd] = ACTIONS(154),
    [anon_sym_echo] = ACTIONS(154),
    [anon_sym_exit] = ACTIONS(154),
    [anon_sym_mv] = ACTIONS(154),
    [sym_preprocessor_directive] = ACTIONS(152),
    [sym_shebang] = ACTIONS(152),
    [anon_sym_pub] = ACTIONS(154),
    [anon_sym_fun] = ACTIONS(154),
    [anon_sym_return] = ACTIONS(154),
    [anon_sym_fail] = ACTIONS(154),
    [anon_sym_as] = ACTIONS(154),
    [anon_sym_import] = ACTIONS(154),
    [anon_sym_STAR] = ACTIONS(152),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_const] = ACTIONS(154),
    [anon_sym_let] = ACTIONS(154),
    [anon_sym_if] = ACTIONS(154),
    [anon_sym_then] = ACTIONS(154),
    [anon_sym_loop] = ACTIONS(154),
    [anon_sym_for] = ACTIONS(154),
    [anon_sym_while] = ACTIONS(154),
    [anon_sym_break] = ACTIONS(154),
    [anon_sym_continue] = ACTIONS(154),
    [sym_boolean] = ACTIONS(154),
    [sym_null] = ACTIONS(154),
    [sym_number] = ACTIONS(154),
    [anon_sym_Text] = ACTIONS(154),
    [anon_sym_Num] = ACTIONS(154),
    [anon_sym_Int] = ACTIONS(154),
    [anon_sym_Bool] = ACTIONS(154),
    [anon_sym_Null] = ACTIONS(154),
    [sym_status] = ACTIONS(154),
    [anon_sym_len] = ACTIONS(154),
    [anon_sym_lines] = ACTIONS(154),
    [anon_sym_DASH] = ACTIONS(154),
    [anon_sym_not] = ACTIONS(154),
    [anon_sym_unsafe] = ACTIONS(154),
    [anon_sym_trust] = ACTIONS(154),
    [anon_sym_silent] = ACTIONS(154),
    [anon_sym_sudo] = ACTIONS(154),
    [anon_sym_nameof] = ACTIONS(154),
    [anon_sym_SLASH] = ACTIONS(154),
    [anon_sym_PLUS] = ACTIONS(154),
    [anon_sym_PERCENT] = ACTIONS(152),
    [anon_sym_GT] = ACTIONS(154),
    [anon_sym_LT] = ACTIONS(154),
    [anon_sym_GT_EQ] = ACTIONS(152),
    [anon_sym_LT_EQ] = ACTIONS(152),
    [anon_sym_EQ_EQ] = ACTIONS(152),
    [anon_sym_BANG_EQ] = ACTIONS(152),
    [anon_sym_and] = ACTIONS(154),
    [anon_sym_or] = ACTIONS(154),
    [anon_sym_is] = ACTIONS(154),
    [sym_variable] = ACTIONS(154),
    [anon_sym_DQUOTE] = ACTIONS(152),
    [anon_sym_failed] = ACTIONS(214),
    [anon_sym_succeeded] = ACTIONS(216),
    [anon_sym_exited] = ACTIONS(218),
    [sym_handler_propagation] = ACTIONS(220),
    [anon_sym_DOLLAR] = ACTIONS(152),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym__statement] = STATE(19),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(19),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym__statement] = STATE(20),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(20),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(322),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym_parameter_list] = STATE(29),
    [sym_subscript] = STATE(952),
    [ts_builtin_sym_end] = ACTIONS(156),
    [anon_sym_SEMI] = ACTIONS(156),
    [anon_sym_main] = ACTIONS(158),
    [anon_sym_LPAREN] = ACTIONS(306),
    [anon_sym_cd] = ACTIONS(158),
    [anon_sym_echo] = ACTIONS(158),
    [anon_sym_exit] = ACTIONS(158),
    [anon_sym_mv] = ACTIONS(158),
    [anon_sym_EQ] = ACTIONS(324),
    [sym_preprocessor_directive] = ACTIONS(156),
    [sym_shebang] = ACTIONS(156),
    [anon_sym_pub] = ACTIONS(158),
    [anon_sym_fun] = ACTIONS(158),
    [anon_sym_return] = ACTIONS(158),
    [anon_sym_fail] = ACTIONS(158),
    [anon_sym_as] = ACTIONS(158),
    [anon_sym_import] = ACTIONS(158),
    [anon_sym_STAR] = ACTIONS(158),
    [anon_sym_LBRACK] = ACTIONS(164),
    [anon_sym_const] = ACTIONS(158),
    [anon_sym_let] = ACTIONS(158),
    [anon_sym_PLUS_EQ] = ACTIONS(326),
    [anon_sym_DASH_EQ] = ACTIONS(326),
    [anon_sym_STAR_EQ] = ACTIONS(326),
    [anon_sym_SLASH_EQ] = ACTIONS(326),
    [anon_sym_PERCENT_EQ] = ACTIONS(326),
    [anon_sym_if] = ACTIONS(158),
    [anon_sym_then] = ACTIONS(158),
    [anon_sym_loop] = ACTIONS(158),
    [anon_sym_for] = ACTIONS(158),
    [anon_sym_while] = ACTIONS(158),
    [anon_sym_break] = ACTIONS(158),
    [anon_sym_continue] = ACTIONS(158),
    [sym_boolean] = ACTIONS(158),
    [sym_null] = ACTIONS(158),
    [sym_number] = ACTIONS(158),
    [anon_sym_Text] = ACTIONS(158),
    [anon_sym_Num] = ACTIONS(158),
    [anon_sym_Int] = ACTIONS(158),
    [anon_sym_Bool] = ACTIONS(158),
    [anon_sym_Null] = ACTIONS(158),
    [sym_status] = ACTIONS(158),
    [anon_sym_len] = ACTIONS(158),
    [anon_sym_lines] = ACTIONS(158),
    [anon_sym_DASH] = ACTIONS(158),
    [anon_sym_not] = ACTIONS(158),
    [anon_sym_unsafe] = ACTIONS(158),
    [anon_sym_trust] = ACTIONS(158),
    [anon_sym_silent] = ACTIONS(158),
    [anon_sym_sudo] = ACTIONS(158),
    [anon_sym_nameof] = ACTIONS(158),
    [anon_sym_SLASH] = ACTIONS(158),
    [anon_sym_PLUS] = ACTIONS(158),
    [anon_sym_PERCENT] = ACTIONS(158),
    [anon_sym_GT] = ACTIONS(158),
    [anon_sym_LT] = ACTIONS(158),
    [anon_sym_GT_EQ] = ACTIONS(156),
    [anon_sym_LT_EQ] = ACTIONS(156),
    [anon_sym_EQ_EQ] = ACTIONS(156),
    [anon_sym_BANG_EQ] = ACTIONS(156),
    [anon_sym_and] = ACTIONS(158),
    [anon_sym_or] = ACTIONS(158),
    [anon_sym_is] = ACTIONS(158),
    [sym_variable] = ACTIONS(158),
    [anon_sym_DQUOTE] = ACTIONS(156),
    [anon_sym_DOLLAR] = ACTIONS(156),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__statement] = STATE(30),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(30),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(328),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__statement] = STATE(19),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(19),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(330),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__statement] = STATE(34),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(34),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(332),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__statement] = STATE(19),
    [sym_builtin_stmt] = STATE(466),
    [sym_mv_stmt] = STATE(466),
    [sym_function_control_flow] = STATE(466),
    [sym_subscript_expression] = STATE(236),
    [sym_variable_init] = STATE(466),
    [sym_variable_assignment] = STATE(466),
    [sym_parentheses] = STATE(236),
    [sym_if_cond] = STATE(466),
    [sym_if_chain] = STATE(466),
    [sym_if_ternary] = STATE(236),
    [sym_loop_infinite] = STATE(466),
    [sym_for_loop] = STATE(466),
    [sym_while_loop] = STATE(466),
    [sym_loop_control_flow] = STATE(466),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(236),
    [sym_array] = STATE(236),
    [sym_function_call] = STATE(236),
    [sym_builtin_expr] = STATE(236),
    [sym_unop] = STATE(236),
    [sym_binop] = STATE(236),
    [sym_keyword_binop] = STATE(236),
    [sym_string] = STATE(236),
    [sym_command] = STATE(236),
    [sym_command_modifier_block] = STATE(236),
    [sym__expression] = STATE(236),
    [aux_sym_block_repeat1] = STATE(19),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_RBRACE] = ACTIONS(334),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_number] = ACTIONS(198),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(198),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__statement] = STATE(769),
    [sym_builtin_stmt] = STATE(769),
    [sym_mv_stmt] = STATE(769),
    [sym_function_control_flow] = STATE(769),
    [sym_subscript_expression] = STATE(703),
    [sym_variable_init] = STATE(769),
    [sym_variable_assignment] = STATE(769),
    [sym_parentheses] = STATE(703),
    [sym_if_cond] = STATE(769),
    [sym_if_chain] = STATE(769),
    [sym_if_ternary] = STATE(703),
    [sym_loop_infinite] = STATE(769),
    [sym_for_loop] = STATE(769),
    [sym_while_loop] = STATE(769),
    [sym_loop_control_flow] = STATE(769),
    [sym_type_name_symbol] = STATE(744),
    [sym_type_name] = STATE(703),
    [sym_array] = STATE(703),
    [sym_function_call] = STATE(703),
    [sym_builtin_expr] = STATE(703),
    [sym_unop] = STATE(703),
    [sym_binop] = STATE(703),
    [sym_keyword_binop] = STATE(703),
    [sym_string] = STATE(703),
    [sym_command] = STATE(703),
    [sym_command_modifier_block] = STATE(703),
    [sym__expression] = STATE(703),
    [aux_sym_command_modifier_block_repeat1] = STATE(943),
    [anon_sym_LPAREN] = ACTIONS(336),
    [anon_sym_cd] = ACTIONS(338),
    [anon_sym_echo] = ACTIONS(338),
    [anon_sym_exit] = ACTIONS(338),
    [anon_sym_mv] = ACTIONS(340),
    [sym_shebang] = ACTIONS(328),
    [anon_sym_return] = ACTIONS(342),
    [anon_sym_fail] = ACTIONS(342),
    [anon_sym_LBRACK] = ACTIONS(344),
    [anon_sym_const] = ACTIONS(346),
    [anon_sym_let] = ACTIONS(346),
    [anon_sym_if] = ACTIONS(348),
    [anon_sym_loop] = ACTIONS(350),
    [anon_sym_for] = ACTIONS(352),
    [anon_sym_while] = ACTIONS(354),
    [anon_sym_break] = ACTIONS(356),
    [anon_sym_continue] = ACTIONS(356),
    [sym_boolean] = ACTIONS(358),
    [sym_null] = ACTIONS(358),
    [sym_number] = ACTIONS(358),
    [anon_sym_Text] = ACTIONS(360),
    [anon_sym_Num] = ACTIONS(360),
    [anon_sym_Int] = ACTIONS(360),
    [anon_sym_Bool] = ACTIONS(360),
    [anon_sym_Null] = ACTIONS(360),
    [sym_status] = ACTIONS(358),
    [anon_sym_len] = ACTIONS(362),
    [anon_sym_lines] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_not] = ACTIONS(364),
    [anon_sym_unsafe] = ACTIONS(364),
    [anon_sym_trust] = ACTIONS(366),
    [anon_sym_silent] = ACTIONS(366),
    [anon_sym_sudo] = ACTIONS(366),
    [anon_sym_nameof] = ACTIONS(364),
    [sym_variable] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_DOLLAR] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__statement] = STATE(769),
    [sym_builtin_stmt] = STATE(768),
    [sym_mv_stmt] = STATE(768),
    [sym_function_control_flow] = STATE(768),
    [sym_subscript_expression] = STATE(867),
    [sym_variable_init] = STATE(768),
    [sym_variable_assignment] = STATE(768),
    [sym_parentheses] = STATE(867),
    [sym_if_cond] = STATE(768),
    [sym_if_chain] = STATE(768),
    [sym_if_ternary] = STATE(867),
    [sym_loop_infinite] = STATE(768),
    [sym_for_loop] = STATE(768),
    [sym_while_loop] = STATE(768),
    [sym_loop_control_flow] = STATE(768),
    [sym_type_name_symbol] = STATE(744),
    [sym_type_name] = STATE(867),
    [sym_array] = STATE(867),
    [sym_function_call] = STATE(867),
    [sym_builtin_expr] = STATE(867),
    [sym_unop] = STATE(867),
    [sym_binop] = STATE(867),
    [sym_keyword_binop] = STATE(867),
    [sym_string] = STATE(867),
    [sym_command] = STATE(867),
    [sym_command_modifier_block] = STATE(867),
    [sym__expression] = STATE(867),
    [aux_sym_command_modifier_block_repeat1] = STATE(943),
    [anon_sym_LPAREN] = ACTIONS(336),
    [anon_sym_cd] = ACTIONS(338),
    [anon_sym_echo] = ACTIONS(338),
    [anon_sym_exit] = ACTIONS(338),
    [anon_sym_mv] = ACTIONS(340),
    [sym_shebang] = ACTIONS(374),
    [anon_sym_return] = ACTIONS(342),
    [anon_sym_fail] = ACTIONS(342),
    [anon_sym_LBRACK] = ACTIONS(344),
    [anon_sym_const] = ACTIONS(346),
    [anon_sym_let] = ACTIONS(346),
    [anon_sym_if] = ACTIONS(348),
    [anon_sym_loop] = ACTIONS(350),
    [anon_sym_for] = ACTIONS(352),
    [anon_sym_while] = ACTIONS(354),
    [anon_sym_break] = ACTIONS(356),
    [anon_sym_continue] = ACTIONS(356),
    [sym_boolean] = ACTIONS(376),
    [sym_null] = ACTIONS(376),
    [sym_number] = ACTIONS(376),
    [anon_sym_Text] = ACTIONS(360),
    [anon_sym_Num] = ACTIONS(360),
    [anon_sym_Int] = ACTIONS(360),
    [anon_sym_Bool] = ACTIONS(360),
    [anon_sym_Null] = ACTIONS(360),
    [sym_status] = ACTIONS(376),
    [anon_sym_len] = ACTIONS(362),
    [anon_sym_lines] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_not] = ACTIONS(364),
    [anon_sym_unsafe] = ACTIONS(364),
    [anon_sym_trust] = ACTIONS(366),
    [anon_sym_silent] = ACTIONS(366),
    [anon_sym_sudo] = ACTIONS(366),
    [anon_sym_nameof] = ACTIONS(364),
    [sym_variable] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_DOLLAR] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__statement] = STATE(100),
    [sym_builtin_stmt] = STATE(100),
    [sym_mv_stmt] = STATE(100),
    [sym_function_control_flow] = STATE(100),
    [sym_subscript_expression] = STATE(93),
    [sym_variable_init] = STATE(100),
    [sym_variable_assignment] = STATE(100),
    [sym_parentheses] = STATE(93),
    [sym_if_cond] = STATE(100),
    [sym_if_chain] = STATE(100),
    [sym_if_ternary] = STATE(93),
    [sym_loop_infinite] = STATE(100),
    [sym_for_loop] = STATE(100),
    [sym_while_loop] = STATE(100),
    [sym_loop_control_flow] = STATE(100),
    [sym_type_name_symbol] = STATE(112),
    [sym_type_name] = STATE(93),
    [sym_array] = STATE(93),
    [sym_function_call] = STATE(93),
    [sym_builtin_expr] = STATE(93),
    [sym_unop] = STATE(93),
    [sym_binop] = STATE(93),
    [sym_keyword_binop] = STATE(93),
    [sym_string] = STATE(93),
    [sym_command] = STATE(93),
    [sym_command_modifier_block] = STATE(93),
    [sym__expression] = STATE(93),
    [aux_sym_command_modifier_block_repeat1] = STATE(932),
    [anon_sym_LPAREN] = ACTIONS(378),
    [anon_sym_cd] = ACTIONS(380),
    [anon_sym_echo] = ACTIONS(380),
    [anon_sym_exit] = ACTIONS(380),
    [anon_sym_mv] = ACTIONS(382),
    [sym_shebang] = ACTIONS(230),
    [anon_sym_return] = ACTIONS(384),
    [anon_sym_fail] = ACTIONS(384),
    [anon_sym_LBRACK] = ACTIONS(386),
    [anon_sym_const] = ACTIONS(388),
    [anon_sym_let] = ACTIONS(388),
    [anon_sym_if] = ACTIONS(390),
    [anon_sym_loop] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_while] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(398),
    [sym_boolean] = ACTIONS(400),
    [sym_null] = ACTIONS(400),
    [sym_number] = ACTIONS(400),
    [anon_sym_Text] = ACTIONS(402),
    [anon_sym_Num] = ACTIONS(402),
    [anon_sym_Int] = ACTIONS(402),
    [anon_sym_Bool] = ACTIONS(402),
    [anon_sym_Null] = ACTIONS(402),
    [sym_status] = ACTIONS(400),
    [anon_sym_len] = ACTIONS(404),
    [anon_sym_lines] = ACTIONS(404),
    [anon_sym_DASH] = ACTIONS(406),
    [anon_sym_not] = ACTIONS(406),
    [anon_sym_unsafe] = ACTIONS(406),
    [anon_sym_trust] = ACTIONS(408),
    [anon_sym_silent] = ACTIONS(408),
    [anon_sym_sudo] = ACTIONS(408),
    [anon_sym_nameof] = ACTIONS(406),
    [sym_variable] = ACTIONS(410),
    [anon_sym_DQUOTE] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(414),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__statement] = STATE(769),
    [sym_builtin_stmt] = STATE(769),
    [sym_mv_stmt] = STATE(769),
    [sym_function_control_flow] = STATE(769),
    [sym_subscript_expression] = STATE(749),
    [sym_variable_init] = STATE(769),
    [sym_variable_assignment] = STATE(769),
    [sym_parentheses] = STATE(749),
    [sym_if_cond] = STATE(769),
    [sym_if_chain] = STATE(769),
    [sym_if_ternary] = STATE(749),
    [sym_loop_infinite] = STATE(769),
    [sym_for_loop] = STATE(769),
    [sym_while_loop] = STATE(769),
    [sym_loop_control_flow] = STATE(769),
    [sym_type_name_symbol] = STATE(744),
    [sym_type_name] = STATE(749),
    [sym_array] = STATE(749),
    [sym_function_call] = STATE(749),
    [sym_builtin_expr] = STATE(749),
    [sym_unop] = STATE(749),
    [sym_binop] = STATE(749),
    [sym_keyword_binop] = STATE(749),
    [sym_string] = STATE(749),
    [sym_command] = STATE(749),
    [sym_command_modifier_block] = STATE(749),
    [sym__expression] = STATE(749),
    [aux_sym_command_modifier_block_repeat1] = STATE(946),
    [anon_sym_LPAREN] = ACTIONS(336),
    [anon_sym_cd] = ACTIONS(416),
    [anon_sym_echo] = ACTIONS(416),
    [anon_sym_exit] = ACTIONS(416),
    [anon_sym_mv] = ACTIONS(418),
    [sym_shebang] = ACTIONS(328),
    [anon_sym_return] = ACTIONS(420),
    [anon_sym_fail] = ACTIONS(420),
    [anon_sym_LBRACK] = ACTIONS(344),
    [anon_sym_const] = ACTIONS(422),
    [anon_sym_let] = ACTIONS(422),
    [anon_sym_if] = ACTIONS(424),
    [anon_sym_loop] = ACTIONS(426),
    [anon_sym_for] = ACTIONS(428),
    [anon_sym_while] = ACTIONS(430),
    [anon_sym_break] = ACTIONS(356),
    [anon_sym_continue] = ACTIONS(356),
    [sym_boolean] = ACTIONS(432),
    [sym_null] = ACTIONS(432),
    [sym_number] = ACTIONS(432),
    [anon_sym_Text] = ACTIONS(360),
    [anon_sym_Num] = ACTIONS(360),
    [anon_sym_Int] = ACTIONS(360),
    [anon_sym_Bool] = ACTIONS(360),
    [anon_sym_Null] = ACTIONS(360),
    [sym_status] = ACTIONS(432),
    [anon_sym_len] = ACTIONS(434),
    [anon_sym_lines] = ACTIONS(434),
    [anon_sym_DASH] = ACTIONS(436),
    [anon_sym_not] = ACTIONS(436),
    [anon_sym_unsafe] = ACTIONS(436),
    [anon_sym_trust] = ACTIONS(438),
    [anon_sym_silent] = ACTIONS(438),
    [anon_sym_sudo] = ACTIONS(438),
    [anon_sym_nameof] = ACTIONS(436),
    [sym_variable] = ACTIONS(440),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_DOLLAR] = ACTIONS(442),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__statement] = STATE(302),
    [sym_builtin_stmt] = STATE(1140),
    [sym_mv_stmt] = STATE(1140),
    [sym_function_control_flow] = STATE(1140),
    [sym_subscript_expression] = STATE(870),
    [sym_variable_init] = STATE(1140),
    [sym_variable_assignment] = STATE(1140),
    [sym_parentheses] = STATE(870),
    [sym_if_cond] = STATE(1140),
    [sym_if_chain] = STATE(1140),
    [sym_if_ternary] = STATE(870),
    [sym_loop_infinite] = STATE(1140),
    [sym_for_loop] = STATE(1140),
    [sym_while_loop] = STATE(1140),
    [sym_loop_control_flow] = STATE(1140),
    [sym_type_name_symbol] = STATE(744),
    [sym_type_name] = STATE(870),
    [sym_array] = STATE(870),
    [sym_function_call] = STATE(870),
    [sym_builtin_expr] = STATE(870),
    [sym_unop] = STATE(870),
    [sym_binop] = STATE(870),
    [sym_keyword_binop] = STATE(870),
    [sym_string] = STATE(870),
    [sym_command] = STATE(870),
    [sym_command_modifier_block] = STATE(870),
    [sym__expression] = STATE(870),
    [aux_sym_command_modifier_block_repeat1] = STATE(946),
    [anon_sym_LPAREN] = ACTIONS(336),
    [anon_sym_cd] = ACTIONS(416),
    [anon_sym_echo] = ACTIONS(416),
    [anon_sym_exit] = ACTIONS(416),
    [anon_sym_mv] = ACTIONS(418),
    [sym_shebang] = ACTIONS(444),
    [anon_sym_return] = ACTIONS(420),
    [anon_sym_fail] = ACTIONS(420),
    [anon_sym_LBRACK] = ACTIONS(344),
    [anon_sym_const] = ACTIONS(446),
    [anon_sym_let] = ACTIONS(446),
    [anon_sym_if] = ACTIONS(448),
    [anon_sym_loop] = ACTIONS(450),
    [anon_sym_for] = ACTIONS(452),
    [anon_sym_while] = ACTIONS(454),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(39),
    [sym_boolean] = ACTIONS(456),
    [sym_null] = ACTIONS(456),
    [sym_number] = ACTIONS(456),
    [anon_sym_Text] = ACTIONS(360),
    [anon_sym_Num] = ACTIONS(360),
    [anon_sym_Int] = ACTIONS(360),
    [anon_sym_Bool] = ACTIONS(360),
    [anon_sym_Null] = ACTIONS(360),
    [sym_status] = ACTIONS(456),
    [anon_sym_len] = ACTIONS(434),
    [anon_sym_lines] = ACTIONS(434),
    [anon_sym_DASH] = ACTIONS(436),
    [anon_sym_not] = ACTIONS(436),
    [anon_sym_unsafe] = ACTIONS(436),
    [anon_sym_trust] = ACTIONS(438),
    [anon_sym_silent] = ACTIONS(438),
    [anon_sym_sudo] = ACTIONS(438),
    [anon_sym_nameof] = ACTIONS(436),
    [sym_variable] = ACTIONS(458),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_DOLLAR] = ACTIONS(442),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__statement] = STATE(769),
    [sym_builtin_stmt] = STATE(768),
    [sym_mv_stmt] = STATE(768),
    [sym_function_control_flow] = STATE(768),
    [sym_subscript_expression] = STATE(746),
    [sym_variable_init] = STATE(768),
    [sym_variable_assignment] = STATE(768),
    [sym_parentheses] = STATE(746),
    [sym_if_cond] = STATE(768),
    [sym_if_chain] = STATE(768),
    [sym_if_ternary] = STATE(746),
    [sym_loop_infinite] = STATE(768),
    [sym_for_loop] = STATE(768),
    [sym_while_loop] = STATE(768),
    [sym_loop_control_flow] = STATE(768),
    [sym_type_name_symbol] = STATE(744),
    [sym_type_name] = STATE(746),
    [sym_array] = STATE(746),
    [sym_function_call] = STATE(746),
    [sym_builtin_expr] = STATE(746),
    [sym_unop] = STATE(746),
    [sym_binop] = STATE(746),
    [sym_keyword_binop] = STATE(746),
    [sym_string] = STATE(746),
    [sym_command] = STATE(746),
    [sym_command_modifier_block] = STATE(746),
    [sym__expression] = STATE(746),
    [aux_sym_command_modifier_block_repeat1] = STATE(946),
    [anon_sym_LPAREN] = ACTIONS(336),
    [anon_sym_cd] = ACTIONS(416),
    [anon_sym_echo] = ACTIONS(416),
    [anon_sym_exit] = ACTIONS(416),
    [anon_sym_mv] = ACTIONS(418),
    [sym_shebang] = ACTIONS(374),
    [anon_sym_return] = ACTIONS(420),
    [anon_sym_fail] = ACTIONS(420),
    [anon_sym_LBRACK] = ACTIONS(344),
    [anon_sym_const] = ACTIONS(422),
    [anon_sym_let] = ACTIONS(422),
    [anon_sym_if] = ACTIONS(424),
    [anon_sym_loop] = ACTIONS(426),
    [anon_sym_for] = ACTIONS(428),
    [anon_sym_while] = ACTIONS(430),
    [anon_sym_break] = ACTIONS(356),
    [anon_sym_continue] = ACTIONS(356),
    [sym_boolean] = ACTIONS(460),
    [sym_null] = ACTIONS(460),
    [sym_number] = ACTIONS(460),
    [anon_sym_Text] = ACTIONS(360),
    [anon_sym_Num] = ACTIONS(360),
    [anon_sym_Int] = ACTIONS(360),
    [anon_sym_Bool] = ACTIONS(360),
    [anon_sym_Null] = ACTIONS(360),
    [sym_status] = ACTIONS(460),
    [anon_sym_len] = ACTIONS(434),
    [anon_sym_lines] = ACTIONS(434),
    [anon_sym_DASH] = ACTIONS(436),
    [anon_sym_not] = ACTIONS(436),
    [anon_sym_unsafe] = ACTIONS(436),
    [anon_sym_trust] = ACTIONS(438),
    [anon_sym_silent] = ACTIONS(438),
    [anon_sym_sudo] = ACTIONS(438),
    [anon_sym_nameof] = ACTIONS(436),
    [sym_variable] = ACTIONS(440),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_DOLLAR] = ACTIONS(442),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__statement] = STATE(205),
    [sym_builtin_stmt] = STATE(205),
    [sym_mv_stmt] = STATE(205),
    [sym_function_control_flow] = STATE(205),
    [sym_subscript_expression] = STATE(196),
    [sym_variable_init] = STATE(205),
    [sym_variable_assignment] = STATE(205),
    [sym_parentheses] = STATE(196),
    [sym_if_cond] = STATE(205),
    [sym_if_chain] = STATE(205),
    [sym_if_ternary] = STATE(196),
    [sym_loop_infinite] = STATE(205),
    [sym_for_loop] = STATE(205),
    [sym_while_loop] = STATE(205),
    [sym_loop_control_flow] = STATE(205),
    [sym_type_name_symbol] = STATE(210),
    [sym_type_name] = STATE(196),
    [sym_array] = STATE(196),
    [sym_function_call] = STATE(196),
    [sym_builtin_expr] = STATE(196),
    [sym_unop] = STATE(196),
    [sym_binop] = STATE(196),
    [sym_keyword_binop] = STATE(196),
    [sym_string] = STATE(196),
    [sym_command] = STATE(196),
    [sym_command_modifier_block] = STATE(196),
    [sym__expression] = STATE(196),
    [aux_sym_command_modifier_block_repeat1] = STATE(947),
    [anon_sym_LPAREN] = ACTIONS(462),
    [anon_sym_cd] = ACTIONS(464),
    [anon_sym_echo] = ACTIONS(464),
    [anon_sym_exit] = ACTIONS(464),
    [anon_sym_mv] = ACTIONS(466),
    [sym_shebang] = ACTIONS(222),
    [anon_sym_return] = ACTIONS(468),
    [anon_sym_fail] = ACTIONS(468),
    [anon_sym_LBRACK] = ACTIONS(470),
    [anon_sym_const] = ACTIONS(472),
    [anon_sym_let] = ACTIONS(472),
    [anon_sym_if] = ACTIONS(474),
    [anon_sym_loop] = ACTIONS(476),
    [anon_sym_for] = ACTIONS(478),
    [anon_sym_while] = ACTIONS(480),
    [anon_sym_break] = ACTIONS(482),
    [anon_sym_continue] = ACTIONS(482),
    [sym_boolean] = ACTIONS(484),
    [sym_null] = ACTIONS(484),
    [sym_number] = ACTIONS(484),
    [anon_sym_Text] = ACTIONS(486),
    [anon_sym_Num] = ACTIONS(486),
    [anon_sym_Int] = ACTIONS(486),
    [anon_sym_Bool] = ACTIONS(486),
    [anon_sym_Null] = ACTIONS(486),
    [sym_status] = ACTIONS(484),
    [anon_sym_len] = ACTIONS(488),
    [anon_sym_lines] = ACTIONS(488),
    [anon_sym_DASH] = ACTIONS(490),
    [anon_sym_not] = ACTIONS(490),
    [anon_sym_unsafe] = ACTIONS(490),
    [anon_sym_trust] = ACTIONS(492),
    [anon_sym_silent] = ACTIONS(492),
    [anon_sym_sudo] = ACTIONS(492),
    [anon_sym_nameof] = ACTIONS(490),
    [sym_variable] = ACTIONS(494),
    [anon_sym_DQUOTE] = ACTIONS(496),
    [anon_sym_DOLLAR] = ACTIONS(498),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__statement] = STATE(701),
    [sym_builtin_stmt] = STATE(727),
    [sym_mv_stmt] = STATE(727),
    [sym_function_control_flow] = STATE(727),
    [sym_subscript_expression] = STATE(364),
    [sym_variable_init] = STATE(727),
    [sym_variable_assignment] = STATE(727),
    [sym_parentheses] = STATE(364),
    [sym_if_cond] = STATE(727),
    [sym_if_chain] = STATE(727),
    [sym_if_ternary] = STATE(364),
    [sym_loop_infinite] = STATE(727),
    [sym_for_loop] = STATE(727),
    [sym_while_loop] = STATE(727),
    [sym_loop_control_flow] = STATE(727),
    [sym_type_name_symbol] = STATE(445),
    [sym_type_name] = STATE(364),
    [sym_array] = STATE(364),
    [sym_function_call] = STATE(364),
    [sym_builtin_expr] = STATE(364),
    [sym_unop] = STATE(364),
    [sym_binop] = STATE(364),
    [sym_keyword_binop] = STATE(364),
    [sym_string] = STATE(364),
    [sym_command] = STATE(364),
    [sym_command_modifier_block] = STATE(364),
    [sym__expression] = STATE(364),
    [aux_sym_command_modifier_block_repeat1] = STATE(929),
    [anon_sym_LPAREN] = ACTIONS(500),
    [anon_sym_cd] = ACTIONS(502),
    [anon_sym_echo] = ACTIONS(502),
    [anon_sym_exit] = ACTIONS(502),
    [anon_sym_mv] = ACTIONS(504),
    [sym_shebang] = ACTIONS(506),
    [anon_sym_return] = ACTIONS(508),
    [anon_sym_fail] = ACTIONS(508),
    [anon_sym_LBRACK] = ACTIONS(510),
    [anon_sym_const] = ACTIONS(512),
    [anon_sym_let] = ACTIONS(512),
    [anon_sym_if] = ACTIONS(514),
    [anon_sym_loop] = ACTIONS(516),
    [anon_sym_for] = ACTIONS(518),
    [anon_sym_while] = ACTIONS(520),
    [anon_sym_break] = ACTIONS(522),
    [anon_sym_continue] = ACTIONS(522),
    [sym_boolean] = ACTIONS(524),
    [sym_null] = ACTIONS(524),
    [sym_number] = ACTIONS(524),
    [anon_sym_Text] = ACTIONS(526),
    [anon_sym_Num] = ACTIONS(526),
    [anon_sym_Int] = ACTIONS(526),
    [anon_sym_Bool] = ACTIONS(526),
    [anon_sym_Null] = ACTIONS(526),
    [sym_status] = ACTIONS(524),
    [anon_sym_len] = ACTIONS(528),
    [anon_sym_lines] = ACTIONS(528),
    [anon_sym_DASH] = ACTIONS(530),
    [anon_sym_not] = ACTIONS(530),
    [anon_sym_unsafe] = ACTIONS(530),
    [anon_sym_trust] = ACTIONS(532),
    [anon_sym_silent] = ACTIONS(532),
    [anon_sym_sudo] = ACTIONS(532),
    [anon_sym_nameof] = ACTIONS(530),
    [sym_variable] = ACTIONS(534),
    [anon_sym_DQUOTE] = ACTIONS(536),
    [anon_sym_DOLLAR] = ACTIONS(538),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym__statement] = STATE(178),
    [sym_builtin_stmt] = STATE(178),
    [sym_mv_stmt] = STATE(178),
    [sym_function_control_flow] = STATE(178),
    [sym_subscript_expression] = STATE(145),
    [sym_variable_init] = STATE(178),
    [sym_variable_assignment] = STATE(178),
    [sym_parentheses] = STATE(145),
    [sym_if_cond] = STATE(178),
    [sym_if_chain] = STATE(178),
    [sym_if_ternary] = STATE(145),
    [sym_loop_infinite] = STATE(178),
    [sym_for_loop] = STATE(178),
    [sym_while_loop] = STATE(178),
    [sym_loop_control_flow] = STATE(178),
    [sym_type_name_symbol] = STATE(62),
    [sym_type_name] = STATE(145),
    [sym_array] = STATE(145),
    [sym_function_call] = STATE(145),
    [sym_builtin_expr] = STATE(145),
    [sym_unop] = STATE(145),
    [sym_binop] = STATE(145),
    [sym_keyword_binop] = STATE(145),
    [sym_string] = STATE(145),
    [sym_command] = STATE(145),
    [sym_command_modifier_block] = STATE(145),
    [sym__expression] = STATE(145),
    [aux_sym_command_modifier_block_repeat1] = STATE(945),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_cd] = ACTIONS(11),
    [anon_sym_echo] = ACTIONS(11),
    [anon_sym_exit] = ACTIONS(11),
    [anon_sym_mv] = ACTIONS(13),
    [sym_shebang] = ACTIONS(332),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_fail] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_const] = ACTIONS(540),
    [anon_sym_let] = ACTIONS(540),
    [anon_sym_if] = ACTIONS(542),
    [anon_sym_loop] = ACTIONS(544),
    [anon_sym_for] = ACTIONS(546),
    [anon_sym_while] = ACTIONS(548),
    [anon_sym_break] = ACTIONS(550),
    [anon_sym_continue] = ACTIONS(550),
    [sym_boolean] = ACTIONS(41),
    [sym_null] = ACTIONS(41),
    [sym_number] = ACTIONS(41),
    [anon_sym_Text] = ACTIONS(43),
    [anon_sym_Num] = ACTIONS(43),
    [anon_sym_Int] = ACTIONS(43),
    [anon_sym_Bool] = ACTIONS(43),
    [anon_sym_Null] = ACTIONS(43),
    [sym_status] = ACTIONS(41),
    [anon_sym_len] = ACTIONS(45),
    [anon_sym_lines] = ACTIONS(45),
    [anon_sym_DASH] = ACTIONS(47),
    [anon_sym_not] = ACTIONS(47),
    [anon_sym_unsafe] = ACTIONS(47),
    [anon_sym_trust] = ACTIONS(49),
    [anon_sym_silent] = ACTIONS(49),
    [anon_sym_sudo] = ACTIONS(49),
    [anon_sym_nameof] = ACTIONS(47),
    [sym_variable] = ACTIONS(552),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [anon_sym_DOLLAR] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [sym__statement] = STATE(273),
    [sym_builtin_stmt] = STATE(273),
    [sym_mv_stmt] = STATE(273),
    [sym_function_control_flow] = STATE(273),
    [sym_subscript_expression] = STATE(245),
    [sym_variable_init] = STATE(273),
    [sym_variable_assignment] = STATE(273),
    [sym_parentheses] = STATE(245),
    [sym_if_cond] = STATE(273),
    [sym_if_chain] = STATE(273),
    [sym_if_ternary] = STATE(245),
    [sym_loop_infinite] = STATE(273),
    [sym_for_loop] = STATE(273),
    [sym_while_loop] = STATE(273),
    [sym_loop_control_flow] = STATE(273),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(245),
    [sym_array] = STATE(245),
    [sym_function_call] = STATE(245),
    [sym_builtin_expr] = STATE(245),
    [sym_unop] = STATE(245),
    [sym_binop] = STATE(245),
    [sym_keyword_binop] = STATE(245),
    [sym_string] = STATE(245),
    [sym_command] = STATE(245),
    [sym_command_modifier_block] = STATE(245),
    [sym__expression] = STATE(245),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(304),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(554),
    [anon_sym_let] = ACTIONS(554),
    [anon_sym_if] = ACTIONS(556),
    [anon_sym_loop] = ACTIONS(558),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_break] = ACTIONS(564),
    [anon_sym_continue] = ACTIONS(564),
    [sym_boolean] = ACTIONS(566),
    [sym_null] = ACTIONS(566),
    [sym_number] = ACTIONS(566),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(566),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(568),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [ts_builtin_sym_end] = ACTIONS(570),
    [anon_sym_SEMI] = ACTIONS(570),
    [anon_sym_LBRACE] = ACTIONS(570),
    [anon_sym_COLON] = ACTIONS(570),
    [anon_sym_main] = ACTIONS(572),
    [anon_sym_LPAREN] = ACTIONS(570),
    [anon_sym_cd] = ACTIONS(572),
    [anon_sym_echo] = ACTIONS(572),
    [anon_sym_exit] = ACTIONS(572),
    [anon_sym_mv] = ACTIONS(572),
    [sym_preprocessor_directive] = ACTIONS(570),
    [sym_shebang] = ACTIONS(570),
    [anon_sym_pub] = ACTIONS(572),
    [anon_sym_fun] = ACTIONS(572),
    [anon_sym_return] = ACTIONS(572),
    [anon_sym_fail] = ACTIONS(572),
    [anon_sym_as] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(572),
    [anon_sym_STAR] = ACTIONS(570),
    [anon_sym_LBRACK] = ACTIONS(570),
    [anon_sym_const] = ACTIONS(572),
    [anon_sym_let] = ACTIONS(572),
    [anon_sym_if] = ACTIONS(572),
    [anon_sym_then] = ACTIONS(572),
    [anon_sym_loop] = ACTIONS(572),
    [anon_sym_for] = ACTIONS(572),
    [anon_sym_while] = ACTIONS(572),
    [anon_sym_break] = ACTIONS(572),
    [anon_sym_continue] = ACTIONS(572),
    [sym_boolean] = ACTIONS(572),
    [sym_null] = ACTIONS(572),
    [sym_number] = ACTIONS(572),
    [anon_sym_Text] = ACTIONS(572),
    [anon_sym_Num] = ACTIONS(572),
    [anon_sym_Int] = ACTIONS(572),
    [anon_sym_Bool] = ACTIONS(572),
    [anon_sym_Null] = ACTIONS(572),
    [sym_status] = ACTIONS(572),
    [anon_sym_len] = ACTIONS(572),
    [anon_sym_lines] = ACTIONS(572),
    [anon_sym_DASH] = ACTIONS(572),
    [anon_sym_not] = ACTIONS(572),
    [anon_sym_unsafe] = ACTIONS(572),
    [anon_sym_trust] = ACTIONS(572),
    [anon_sym_silent] = ACTIONS(572),
    [anon_sym_sudo] = ACTIONS(572),
    [anon_sym_nameof] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(572),
    [anon_sym_PERCENT] = ACTIONS(570),
    [anon_sym_GT] = ACTIONS(572),
    [anon_sym_LT] = ACTIONS(572),
    [anon_sym_GT_EQ] = ACTIONS(570),
    [anon_sym_LT_EQ] = ACTIONS(570),
    [anon_sym_EQ_EQ] = ACTIONS(570),
    [anon_sym_BANG_EQ] = ACTIONS(570),
    [anon_sym_and] = ACTIONS(572),
    [anon_sym_or] = ACTIONS(572),
    [anon_sym_is] = ACTIONS(572),
    [sym_variable] = ACTIONS(572),
    [anon_sym_DQUOTE] = ACTIONS(570),
    [anon_sym_failed] = ACTIONS(572),
    [anon_sym_succeeded] = ACTIONS(572),
    [anon_sym_exited] = ACTIONS(572),
    [sym_handler_propagation] = ACTIONS(570),
    [anon_sym_DOLLAR] = ACTIONS(570),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [ts_builtin_sym_end] = ACTIONS(574),
    [anon_sym_SEMI] = ACTIONS(574),
    [anon_sym_LBRACE] = ACTIONS(574),
    [anon_sym_COLON] = ACTIONS(574),
    [anon_sym_main] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(574),
    [anon_sym_RPAREN] = ACTIONS(574),
    [anon_sym_cd] = ACTIONS(576),
    [anon_sym_echo] = ACTIONS(576),
    [anon_sym_exit] = ACTIONS(576),
    [anon_sym_mv] = ACTIONS(576),
    [anon_sym_COMMA] = ACTIONS(574),
    [anon_sym_EQ] = ACTIONS(576),
    [sym_preprocessor_directive] = ACTIONS(574),
    [sym_shebang] = ACTIONS(574),
    [anon_sym_pub] = ACTIONS(576),
    [anon_sym_fun] = ACTIONS(576),
    [anon_sym_return] = ACTIONS(576),
    [anon_sym_fail] = ACTIONS(576),
    [anon_sym_as] = ACTIONS(576),
    [anon_sym_import] = ACTIONS(576),
    [anon_sym_STAR] = ACTIONS(574),
    [anon_sym_LBRACK] = ACTIONS(574),
    [anon_sym_RBRACK] = ACTIONS(574),
    [anon_sym_const] = ACTIONS(576),
    [anon_sym_let] = ACTIONS(576),
    [anon_sym_if] = ACTIONS(576),
    [anon_sym_then] = ACTIONS(576),
    [anon_sym_loop] = ACTIONS(576),
    [anon_sym_for] = ACTIONS(576),
    [anon_sym_while] = ACTIONS(576),
    [anon_sym_break] = ACTIONS(576),
    [anon_sym_continue] = ACTIONS(576),
    [sym_boolean] = ACTIONS(576),
    [sym_null] = ACTIONS(576),
    [sym_number] = ACTIONS(576),
    [anon_sym_Text] = ACTIONS(576),
    [anon_sym_Num] = ACTIONS(576),
    [anon_sym_Int] = ACTIONS(576),
    [anon_sym_Bool] = ACTIONS(576),
    [anon_sym_Null] = ACTIONS(576),
    [sym_status] = ACTIONS(576),
    [anon_sym_len] = ACTIONS(576),
    [anon_sym_lines] = ACTIONS(576),
    [anon_sym_DASH] = ACTIONS(576),
    [anon_sym_not] = ACTIONS(576),
    [anon_sym_unsafe] = ACTIONS(576),
    [anon_sym_trust] = ACTIONS(576),
    [anon_sym_silent] = ACTIONS(576),
    [anon_sym_sudo] = ACTIONS(576),
    [anon_sym_nameof] = ACTIONS(576),
    [anon_sym_SLASH] = ACTIONS(576),
    [anon_sym_PLUS] = ACTIONS(576),
    [anon_sym_PERCENT] = ACTIONS(574),
    [anon_sym_GT] = ACTIONS(576),
    [anon_sym_LT] = ACTIONS(576),
    [anon_sym_GT_EQ] = ACTIONS(574),
    [anon_sym_LT_EQ] = ACTIONS(574),
    [anon_sym_EQ_EQ] = ACTIONS(574),
    [anon_sym_BANG_EQ] = ACTIONS(574),
    [anon_sym_and] = ACTIONS(576),
    [anon_sym_or] = ACTIONS(576),
    [anon_sym_is] = ACTIONS(576),
    [sym_variable] = ACTIONS(576),
    [anon_sym_DQUOTE] = ACTIONS(574),
    [anon_sym_DOLLAR] = ACTIONS(574),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [sym__statement] = STATE(302),
    [sym_builtin_stmt] = STATE(302),
    [sym_mv_stmt] = STATE(302),
    [sym_function_control_flow] = STATE(302),
    [sym_subscript_expression] = STATE(145),
    [sym_variable_init] = STATE(302),
    [sym_variable_assignment] = STATE(302),
    [sym_parentheses] = STATE(145),
    [sym_if_cond] = STATE(302),
    [sym_if_chain] = STATE(302),
    [sym_if_ternary] = STATE(145),
    [sym_loop_infinite] = STATE(302),
    [sym_for_loop] = STATE(302),
    [sym_while_loop] = STATE(302),
    [sym_loop_control_flow] = STATE(302),
    [sym_type_name_symbol] = STATE(62),
    [sym_type_name] = STATE(80),
    [sym_array] = STATE(145),
    [sym_function_call] = STATE(145),
    [sym_builtin_expr] = STATE(145),
    [sym_unop] = STATE(145),
    [sym_binop] = STATE(145),
    [sym_keyword_binop] = STATE(145),
    [sym_string] = STATE(145),
    [sym_command] = STATE(145),
    [sym_command_modifier_block] = STATE(145),
    [sym__expression] = STATE(145),
    [aux_sym_command_modifier_block_repeat1] = STATE(945),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_cd] = ACTIONS(11),
    [anon_sym_echo] = ACTIONS(11),
    [anon_sym_exit] = ACTIONS(11),
    [anon_sym_mv] = ACTIONS(13),
    [sym_shebang] = ACTIONS(322),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_fail] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_const] = ACTIONS(29),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_loop] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(39),
    [sym_boolean] = ACTIONS(41),
    [sym_null] = ACTIONS(41),
    [sym_number] = ACTIONS(41),
    [anon_sym_Text] = ACTIONS(43),
    [anon_sym_Num] = ACTIONS(43),
    [anon_sym_Int] = ACTIONS(43),
    [anon_sym_Bool] = ACTIONS(43),
    [anon_sym_Null] = ACTIONS(43),
    [sym_status] = ACTIONS(41),
    [anon_sym_len] = ACTIONS(45),
    [anon_sym_lines] = ACTIONS(45),
    [anon_sym_DASH] = ACTIONS(47),
    [anon_sym_not] = ACTIONS(47),
    [anon_sym_unsafe] = ACTIONS(47),
    [anon_sym_trust] = ACTIONS(49),
    [anon_sym_silent] = ACTIONS(49),
    [anon_sym_sudo] = ACTIONS(49),
    [anon_sym_nameof] = ACTIONS(47),
    [sym_variable] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [anon_sym_DOLLAR] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym__statement] = STATE(420),
    [sym_builtin_stmt] = STATE(420),
    [sym_mv_stmt] = STATE(420),
    [sym_function_control_flow] = STATE(420),
    [sym_subscript_expression] = STATE(196),
    [sym_variable_init] = STATE(420),
    [sym_variable_assignment] = STATE(420),
    [sym_parentheses] = STATE(196),
    [sym_if_cond] = STATE(420),
    [sym_if_chain] = STATE(420),
    [sym_if_ternary] = STATE(196),
    [sym_loop_infinite] = STATE(420),
    [sym_for_loop] = STATE(420),
    [sym_while_loop] = STATE(420),
    [sym_loop_control_flow] = STATE(420),
    [sym_type_name_symbol] = STATE(210),
    [sym_type_name] = STATE(196),
    [sym_array] = STATE(196),
    [sym_function_call] = STATE(196),
    [sym_builtin_expr] = STATE(196),
    [sym_unop] = STATE(196),
    [sym_binop] = STATE(196),
    [sym_keyword_binop] = STATE(196),
    [sym_string] = STATE(196),
    [sym_command] = STATE(196),
    [sym_command_modifier_block] = STATE(196),
    [sym__expression] = STATE(196),
    [aux_sym_command_modifier_block_repeat1] = STATE(947),
    [anon_sym_LPAREN] = ACTIONS(462),
    [anon_sym_cd] = ACTIONS(464),
    [anon_sym_echo] = ACTIONS(464),
    [anon_sym_exit] = ACTIONS(464),
    [anon_sym_mv] = ACTIONS(466),
    [sym_shebang] = ACTIONS(234),
    [anon_sym_return] = ACTIONS(468),
    [anon_sym_fail] = ACTIONS(468),
    [anon_sym_LBRACK] = ACTIONS(470),
    [anon_sym_const] = ACTIONS(578),
    [anon_sym_let] = ACTIONS(578),
    [anon_sym_if] = ACTIONS(580),
    [anon_sym_loop] = ACTIONS(582),
    [anon_sym_for] = ACTIONS(584),
    [anon_sym_while] = ACTIONS(586),
    [anon_sym_break] = ACTIONS(588),
    [anon_sym_continue] = ACTIONS(588),
    [sym_boolean] = ACTIONS(484),
    [sym_null] = ACTIONS(484),
    [sym_number] = ACTIONS(484),
    [anon_sym_Text] = ACTIONS(486),
    [anon_sym_Num] = ACTIONS(486),
    [anon_sym_Int] = ACTIONS(486),
    [anon_sym_Bool] = ACTIONS(486),
    [anon_sym_Null] = ACTIONS(486),
    [sym_status] = ACTIONS(484),
    [anon_sym_len] = ACTIONS(488),
    [anon_sym_lines] = ACTIONS(488),
    [anon_sym_DASH] = ACTIONS(490),
    [anon_sym_not] = ACTIONS(490),
    [anon_sym_unsafe] = ACTIONS(490),
    [anon_sym_trust] = ACTIONS(492),
    [anon_sym_silent] = ACTIONS(492),
    [anon_sym_sudo] = ACTIONS(492),
    [anon_sym_nameof] = ACTIONS(490),
    [sym_variable] = ACTIONS(590),
    [anon_sym_DQUOTE] = ACTIONS(496),
    [anon_sym_DOLLAR] = ACTIONS(498),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [sym__statement] = STATE(298),
    [sym_builtin_stmt] = STATE(298),
    [sym_mv_stmt] = STATE(298),
    [sym_function_control_flow] = STATE(298),
    [sym_subscript_expression] = STATE(93),
    [sym_variable_init] = STATE(298),
    [sym_variable_assignment] = STATE(298),
    [sym_parentheses] = STATE(93),
    [sym_if_cond] = STATE(298),
    [sym_if_chain] = STATE(298),
    [sym_if_ternary] = STATE(93),
    [sym_loop_infinite] = STATE(298),
    [sym_for_loop] = STATE(298),
    [sym_while_loop] = STATE(298),
    [sym_loop_control_flow] = STATE(298),
    [sym_type_name_symbol] = STATE(112),
    [sym_type_name] = STATE(93),
    [sym_array] = STATE(93),
    [sym_function_call] = STATE(93),
    [sym_builtin_expr] = STATE(93),
    [sym_unop] = STATE(93),
    [sym_binop] = STATE(93),
    [sym_keyword_binop] = STATE(93),
    [sym_string] = STATE(93),
    [sym_command] = STATE(93),
    [sym_command_modifier_block] = STATE(93),
    [sym__expression] = STATE(93),
    [aux_sym_command_modifier_block_repeat1] = STATE(932),
    [anon_sym_LPAREN] = ACTIONS(378),
    [anon_sym_cd] = ACTIONS(380),
    [anon_sym_echo] = ACTIONS(380),
    [anon_sym_exit] = ACTIONS(380),
    [anon_sym_mv] = ACTIONS(382),
    [sym_shebang] = ACTIONS(318),
    [anon_sym_return] = ACTIONS(384),
    [anon_sym_fail] = ACTIONS(384),
    [anon_sym_LBRACK] = ACTIONS(386),
    [anon_sym_const] = ACTIONS(592),
    [anon_sym_let] = ACTIONS(592),
    [anon_sym_if] = ACTIONS(594),
    [anon_sym_loop] = ACTIONS(596),
    [anon_sym_for] = ACTIONS(598),
    [anon_sym_while] = ACTIONS(600),
    [anon_sym_break] = ACTIONS(602),
    [anon_sym_continue] = ACTIONS(602),
    [sym_boolean] = ACTIONS(400),
    [sym_null] = ACTIONS(400),
    [sym_number] = ACTIONS(400),
    [anon_sym_Text] = ACTIONS(402),
    [anon_sym_Num] = ACTIONS(402),
    [anon_sym_Int] = ACTIONS(402),
    [anon_sym_Bool] = ACTIONS(402),
    [anon_sym_Null] = ACTIONS(402),
    [sym_status] = ACTIONS(400),
    [anon_sym_len] = ACTIONS(404),
    [anon_sym_lines] = ACTIONS(404),
    [anon_sym_DASH] = ACTIONS(406),
    [anon_sym_not] = ACTIONS(406),
    [anon_sym_unsafe] = ACTIONS(406),
    [anon_sym_trust] = ACTIONS(408),
    [anon_sym_silent] = ACTIONS(408),
    [anon_sym_sudo] = ACTIONS(408),
    [anon_sym_nameof] = ACTIONS(406),
    [sym_variable] = ACTIONS(604),
    [anon_sym_DQUOTE] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(414),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [ts_builtin_sym_end] = ACTIONS(606),
    [anon_sym_SEMI] = ACTIONS(606),
    [anon_sym_main] = ACTIONS(608),
    [anon_sym_LPAREN] = ACTIONS(606),
    [anon_sym_cd] = ACTIONS(608),
    [anon_sym_echo] = ACTIONS(608),
    [anon_sym_exit] = ACTIONS(608),
    [anon_sym_mv] = ACTIONS(608),
    [anon_sym_EQ] = ACTIONS(608),
    [sym_preprocessor_directive] = ACTIONS(606),
    [sym_shebang] = ACTIONS(606),
    [anon_sym_pub] = ACTIONS(608),
    [anon_sym_fun] = ACTIONS(608),
    [anon_sym_return] = ACTIONS(608),
    [anon_sym_fail] = ACTIONS(608),
    [anon_sym_as] = ACTIONS(608),
    [anon_sym_import] = ACTIONS(608),
    [anon_sym_STAR] = ACTIONS(608),
    [anon_sym_LBRACK] = ACTIONS(606),
    [anon_sym_const] = ACTIONS(608),
    [anon_sym_let] = ACTIONS(608),
    [anon_sym_PLUS_EQ] = ACTIONS(606),
    [anon_sym_DASH_EQ] = ACTIONS(606),
    [anon_sym_STAR_EQ] = ACTIONS(606),
    [anon_sym_SLASH_EQ] = ACTIONS(606),
    [anon_sym_PERCENT_EQ] = ACTIONS(606),
    [anon_sym_if] = ACTIONS(608),
    [anon_sym_then] = ACTIONS(608),
    [anon_sym_loop] = ACTIONS(608),
    [anon_sym_for] = ACTIONS(608),
    [anon_sym_while] = ACTIONS(608),
    [anon_sym_break] = ACTIONS(608),
    [anon_sym_continue] = ACTIONS(608),
    [sym_boolean] = ACTIONS(608),
    [sym_null] = ACTIONS(608),
    [sym_number] = ACTIONS(608),
    [anon_sym_Text] = ACTIONS(608),
    [anon_sym_Num] = ACTIONS(608),
    [anon_sym_Int] = ACTIONS(608),
    [anon_sym_Bool] = ACTIONS(608),
    [anon_sym_Null] = ACTIONS(608),
    [sym_status] = ACTIONS(608),
    [anon_sym_len] = ACTIONS(608),
    [anon_sym_lines] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_not] = ACTIONS(608),
    [anon_sym_unsafe] = ACTIONS(608),
    [anon_sym_trust] = ACTIONS(608),
    [anon_sym_silent] = ACTIONS(608),
    [anon_sym_sudo] = ACTIONS(608),
    [anon_sym_nameof] = ACTIONS(608),
    [anon_sym_SLASH] = ACTIONS(608),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_PERCENT] = ACTIONS(608),
    [anon_sym_GT] = ACTIONS(608),
    [anon_sym_LT] = ACTIONS(608),
    [anon_sym_GT_EQ] = ACTIONS(606),
    [anon_sym_LT_EQ] = ACTIONS(606),
    [anon_sym_EQ_EQ] = ACTIONS(606),
    [anon_sym_BANG_EQ] = ACTIONS(606),
    [anon_sym_and] = ACTIONS(608),
    [anon_sym_or] = ACTIONS(608),
    [anon_sym_is] = ACTIONS(608),
    [sym_variable] = ACTIONS(608),
    [anon_sym_DQUOTE] = ACTIONS(606),
    [anon_sym_DOLLAR] = ACTIONS(606),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [sym__statement] = STATE(465),
    [sym_builtin_stmt] = STATE(465),
    [sym_mv_stmt] = STATE(465),
    [sym_function_control_flow] = STATE(465),
    [sym_subscript_expression] = STATE(245),
    [sym_variable_init] = STATE(465),
    [sym_variable_assignment] = STATE(465),
    [sym_parentheses] = STATE(245),
    [sym_if_cond] = STATE(465),
    [sym_if_chain] = STATE(465),
    [sym_if_ternary] = STATE(245),
    [sym_loop_infinite] = STATE(465),
    [sym_for_loop] = STATE(465),
    [sym_while_loop] = STATE(465),
    [sym_loop_control_flow] = STATE(465),
    [sym_type_name_symbol] = STATE(257),
    [sym_type_name] = STATE(245),
    [sym_array] = STATE(245),
    [sym_function_call] = STATE(245),
    [sym_builtin_expr] = STATE(245),
    [sym_unop] = STATE(245),
    [sym_binop] = STATE(245),
    [sym_keyword_binop] = STATE(245),
    [sym_string] = STATE(245),
    [sym_command] = STATE(245),
    [sym_command_modifier_block] = STATE(245),
    [sym__expression] = STATE(245),
    [aux_sym_command_modifier_block_repeat1] = STATE(941),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_cd] = ACTIONS(176),
    [anon_sym_echo] = ACTIONS(176),
    [anon_sym_exit] = ACTIONS(176),
    [anon_sym_mv] = ACTIONS(178),
    [sym_shebang] = ACTIONS(314),
    [anon_sym_return] = ACTIONS(182),
    [anon_sym_fail] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(184),
    [anon_sym_const] = ACTIONS(186),
    [anon_sym_let] = ACTIONS(186),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_loop] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(194),
    [anon_sym_break] = ACTIONS(196),
    [anon_sym_continue] = ACTIONS(196),
    [sym_boolean] = ACTIONS(566),
    [sym_null] = ACTIONS(566),
    [sym_number] = ACTIONS(566),
    [anon_sym_Text] = ACTIONS(200),
    [anon_sym_Num] = ACTIONS(200),
    [anon_sym_Int] = ACTIONS(200),
    [anon_sym_Bool] = ACTIONS(200),
    [anon_sym_Null] = ACTIONS(200),
    [sym_status] = ACTIONS(566),
    [anon_sym_len] = ACTIONS(202),
    [anon_sym_lines] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_not] = ACTIONS(204),
    [anon_sym_unsafe] = ACTIONS(204),
    [anon_sym_trust] = ACTIONS(206),
    [anon_sym_silent] = ACTIONS(206),
    [anon_sym_sudo] = ACTIONS(206),
    [anon_sym_nameof] = ACTIONS(204),
    [sym_variable] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DOLLAR] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [sym__statement] = STATE(302),
    [sym_builtin_stmt] = STATE(302),
    [sym_mv_stmt] = STATE(302),
    [sym_function_control_flow] = STATE(302),
    [sym_subscript_expression] = STATE(145),
    [sym_variable_init] = STATE(302),
    [sym_variable_assignment] = STATE(302),
    [sym_parentheses] = STATE(145),
    [sym_if_cond] = STATE(302),
    [sym_if_chain] = STATE(302),
    [sym_if_ternary] = STATE(145),
    [sym_loop_infinite] = STATE(302),
    [sym_for_loop] = STATE(302),
    [sym_while_loop] = STATE(302),
    [sym_loop_control_flow] = STATE(302),
    [sym_type_name_symbol] = STATE(62),
    [sym_type_name] = STATE(78),
    [sym_array] = STATE(145),
    [sym_function_call] = STATE(145),
    [sym_builtin_expr] = STATE(145),
    [sym_unop] = STATE(145),
    [sym_binop] = STATE(145),
    [sym_keyword_binop] = STATE(145),
    [sym_string] = STATE(145),
    [sym_command] = STATE(145),
    [sym_command_modifier_block] = STATE(145),
    [sym__expression] = STATE(145),
    [aux_sym_command_modifier_block_repeat1] = STATE(945),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_cd] = ACTIONS(11),
    [anon_sym_echo] = ACTIONS(11),
    [anon_sym_exit] = ACTIONS(11),
    [anon_sym_mv] = ACTIONS(13),
    [sym_shebang] = ACTIONS(322),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_fail] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_const] = ACTIONS(29),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_loop] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(39),
    [sym_boolean] = ACTIONS(41),
    [sym_null] = ACTIONS(41),
    [sym_number] = ACTIONS(41),
    [anon_sym_Text] = ACTIONS(43),
    [anon_sym_Num] = ACTIONS(43),
    [anon_sym_Int] = ACTIONS(43),
    [anon_sym_Bool] = ACTIONS(43),
    [anon_sym_Null] = ACTIONS(43),
    [sym_status] = ACTIONS(41),
    [anon_sym_len] = ACTIONS(45),
    [anon_sym_lines] = ACTIONS(45),
    [anon_sym_DASH] = ACTIONS(47),
    [anon_sym_not] = ACTIONS(47),
    [anon_sym_unsafe] = ACTIONS(47),
    [anon_sym_trust] = ACTIONS(49),
    [anon_sym_silent] = ACTIONS(49),
    [anon_sym_sudo] = ACTIONS(49),
    [anon_sym_nameof] = ACTIONS(47),
    [sym_variable] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [anon_sym_DOLLAR] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym__statement] = STATE(769),
    [sym_builtin_stmt] = STATE(769),
    [sym_mv_stmt] = STATE(769),
    [sym_function_control_flow] = STATE(769),
    [sym_subscript_expression] = STATE(703),
    [sym_variable_init] = STATE(769),
    [sym_variable_assignment] = STATE(769),
    [sym_parentheses] = STATE(703),
    [sym_if_cond] = STATE(769),
    [sym_if_chain] = STATE(769),
    [sym_if_ternary] = STATE(703),
    [sym_loop_infinite] = STATE(769),
    [sym_for_loop] = STATE(769),
    [sym_while_loop] = STATE(769),
    [sym_loop_control_flow] = STATE(769),
    [sym_type_name_symbol] = STATE(744),
    [sym_type_name] = STATE(703),
    [sym_array] = STATE(703),
    [sym_function_call] = STATE(703),
    [sym_builtin_expr] = STATE(703),
    [sym_unop] = STATE(703),
    [sym_binop] = STATE(703),
    [sym_keyword_binop] = STATE(703),
    [sym_string] = STATE(703),
    [sym_command] = STATE(703),
    [sym_command_modifier_block] = STATE(703),
    [sym__expression] = STATE(703),
    [aux_sym_command_modifier_block_repeat1] = STATE(943),
    [anon_sym_LPAREN] = ACTIONS(336),
    [anon_sym_cd] = ACTIONS(338),
    [anon_sym_echo] = ACTIONS(338),
    [anon_sym_exit] = ACTIONS(338),
    [anon_sym_mv] = ACTIONS(340),
    [sym_shebang] = ACTIONS(328),
    [anon_sym_return] = ACTIONS(342),
    [anon_sym_fail] = ACTIONS(342),
    [anon_sym_LBRACK] = ACTIONS(344),
    [anon_sym_const] = ACTIONS(610),
    [anon_sym_let] = ACTIONS(610),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_loop] = ACTIONS(614),
    [anon_sym_for] = ACTIONS(616),
    [anon_sym_while] = ACTIONS(618),
    [anon_sym_break] = ACTIONS(356),
    [anon_sym_continue] = ACTIONS(356),
    [sym_boolean] = ACTIONS(358),
    [sym_null] = ACTIONS(358),
    [sym_number] = ACTIONS(358),
    [anon_sym_Text] = ACTIONS(360),
    [anon_sym_Num] = ACTIONS(360),
    [anon_sym_Int] = ACTIONS(360),
    [anon_sym_Bool] = ACTIONS(360),
    [anon_sym_Null] = ACTIONS(360),
    [sym_status] = ACTIONS(358),
    [anon_sym_len] = ACTIONS(362),
    [anon_sym_lines] = ACTIONS(362),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_not] = ACTIONS(364),
    [anon_sym_unsafe] = ACTIONS(364),
    [anon_sym_trust] = ACTIONS(366),
    [anon_sym_silent] = ACTIONS(366),
    [anon_sym_sudo] = ACTIONS(366),
    [anon_sym_nameof] = ACTIONS(364),
    [sym_variable] = ACTIONS(620),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_DOLLAR] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [sym__statement] = STATE(397),
    [sym_builtin_stmt] = STATE(397),
    [sym_mv_stmt] = STATE(397),
    [sym_function_control_flow] = STATE(397),
    [sym_subscript_expression] = STATE(378),
    [sym_variable_init] = STATE(397),
    [sym_variable_assignment] = STATE(397),
    [sym_parentheses] = STATE(378),
    [sym_if_cond] = STATE(397),
    [sym_if_chain] = STATE(397),
    [sym_if_ternary] = STATE(378),
    [sym_loop_infinite] = STATE(397),
    [sym_for_loop] = STATE(397),
    [sym_while_loop] = STATE(397),
    [sym_loop_control_flow] = STATE(397),
    [sym_type_name_symbol] = STATE(445),
    [sym_type_name] = STATE(378),
    [sym_array] = STATE(378),
    [sym_function_call] = STATE(378),
    [sym_builtin_expr] = STATE(378),
    [sym_unop] = STATE(378),
    [sym_binop] = STATE(378),
    [sym_keyword_binop] = STATE(378),
    [sym_string] = STATE(378),
    [sym_command] = STATE(378),
    [sym_command_modifier_block] = STATE(378),
    [sym__expression] = STATE(378),
    [aux_sym_command_modifier_block_repeat1] = STATE(929),
    [anon_sym_LPAREN] = ACTIONS(500),
    [anon_sym_cd] = ACTIONS(502),
    [anon_sym_echo] = ACTIONS(502),
    [anon_sym_exit] = ACTIONS(502),
    [anon_sym_mv] = ACTIONS(504),
    [sym_shebang] = ACTIONS(226),
    [anon_sym_return] = ACTIONS(508),
    [anon_sym_fail] = ACTIONS(508),
    [anon_sym_LBRACK] = ACTIONS(510),
    [anon_sym_const] = ACTIONS(622),
    [anon_sym_let] = ACTIONS(622),
    [anon_sym_if] = ACTIONS(624),
    [anon_sym_loop] = ACTIONS(626),
    [anon_sym_for] = ACTIONS(628),
    [anon_sym_while] = ACTIONS(630),
    [anon_sym_break] = ACTIONS(632),
    [anon_sym_continue] = ACTIONS(632),
    [sym_boolean] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_number] = ACTIONS(634),
    [anon_sym_Text] = ACTIONS(526),
    [anon_sym_Num] = ACTIONS(526),
    [anon_sym_Int] = ACTIONS(526),
    [anon_sym_Bool] = ACTIONS(526),
    [anon_sym_Null] = ACTIONS(526),
    [sym_status] = ACTIONS(634),
    [anon_sym_len] = ACTIONS(528),
    [anon_sym_lines] = ACTIONS(528),
    [anon_sym_DASH] = ACTIONS(530),
    [anon_sym_not] = ACTIONS(530),
    [anon_sym_unsafe] = ACTIONS(530),
    [anon_sym_trust] = ACTIONS(532),
    [anon_sym_silent] = ACTIONS(532),
    [anon_sym_sudo] = ACTIONS(532),
    [anon_sym_nameof] = ACTIONS(530),
    [sym_variable] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(536),
    [anon_sym_DOLLAR] = ACTIONS(538),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [sym__statement] = STATE(302),
    [sym_builtin_stmt] = STATE(302),
    [sym_mv_stmt] = STATE(302),
    [sym_function_control_flow] = STATE(302),
    [sym_subscript_expression] = STATE(145),
    [sym_variable_init] = STATE(302),
    [sym_variable_assignment] = STATE(302),
    [sym_parentheses] = STATE(145),
    [sym_if_cond] = STATE(302),
    [sym_if_chain] = STATE(302),
    [sym_if_ternary] = STATE(145),
    [sym_loop_infinite] = STATE(302),
    [sym_for_loop] = STATE(302),
    [sym_while_loop] = STATE(302),
    [sym_loop_control_flow] = STATE(302),
    [sym_type_name_symbol] = STATE(62),
    [sym_type_name] = STATE(145),
    [sym_array] = STATE(145),
    [sym_function_call] = STATE(145),
    [sym_builtin_expr] = STATE(145),
    [sym_unop] = STATE(145),
    [sym_binop] = STATE(145),
    [sym_keyword_binop] = STATE(145),
    [sym_string] = STATE(145),
    [sym_command] = STATE(145),
    [sym_command_modifier_block] = STATE(145),
    [sym__expression] = STATE(145),
    [aux_sym_command_modifier_block_repeat1] = STATE(945),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_cd] = ACTIONS(11),
    [anon_sym_echo] = ACTIONS(11),
    [anon_sym_exit] = ACTIONS(11),
    [anon_sym_mv] = ACTIONS(13),
    [sym_shebang] = ACTIONS(322),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_fail] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_const] = ACTIONS(29),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_loop] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(39),
    [sym_boolean] = ACTIONS(41),
    [sym_null] = ACTIONS(41),
    [sym_number] = ACTIONS(41),
    [anon_sym_Text] = ACTIONS(43),
    [anon_sym_Num] = ACTIONS(43),
    [anon_sym_Int] = ACTIONS(43),
    [anon_sym_Bool] = ACTIONS(43),
    [anon_sym_Null] = ACTIONS(43),
    [sym_status] = ACTIONS(41),
    [anon_sym_len] = ACTIONS(45),
    [anon_sym_lines] = ACTIONS(45),
    [anon_sym_DASH] = ACTIONS(47),
    [anon_sym_not] = ACTIONS(47),
    [anon_sym_unsafe] = ACTIONS(47),
    [anon_sym_trust] = ACTIONS(49),
    [anon_sym_silent] = ACTIONS(49),
    [anon_sym_sudo] = ACTIONS(49),
    [anon_sym_nameof] = ACTIONS(47),
    [sym_variable] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [anon_sym_DOLLAR] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym__statement] = STATE(701),
    [sym_builtin_stmt] = STATE(701),
    [sym_mv_stmt] = STATE(701),
    [sym_function_control_flow] = STATE(701),
    [sym_subscript_expression] = STATE(378),
    [sym_variable_init] = STATE(701),
    [sym_variable_assignment] = STATE(701),
    [sym_parentheses] = STATE(378),
    [sym_if_cond] = STATE(701),
    [sym_if_chain] = STATE(701),
    [sym_if_ternary] = STATE(378),
    [sym_loop_infinite] = STATE(701),
    [sym_for_loop] = STATE(701),
    [sym_while_loop] = STATE(701),
    [sym_loop_control_flow] = STATE(701),
    [sym_type_name_symbol] = STATE(445),
    [sym_type_name] = STATE(378),
    [sym_array] = STATE(378),
    [sym_function_call] = STATE(378),
    [sym_builtin_expr] = STATE(378),
    [sym_unop] = STATE(378),
    [sym_binop] = STATE(378),
    [sym_keyword_binop] = STATE(378),
    [sym_string] = STATE(378),
    [sym_command] = STATE(378),
    [sym_command_modifier_block] = STATE(378),
    [sym__expression] = STATE(378),
    [aux_sym_command_modifier_block_repeat1] = STATE(929),
    [anon_sym_LPAREN] = ACTIONS(500),
    [anon_sym_cd] = ACTIONS(502),
    [anon_sym_echo] = ACTIONS(502),
    [anon_sym_exit] = ACTIONS(502),
    [anon_sym_mv] = ACTIONS(504),
    [sym_shebang] = ACTIONS(172),
    [anon_sym_return] = ACTIONS(508),
    [anon_sym_fail] = ACTIONS(508),
    [anon_sym_LBRACK] = ACTIONS(510),
    [anon_sym_const] = ACTIONS(512),
    [anon_sym_let] = ACTIONS(512),
    [anon_sym_if] = ACTIONS(514),
    [anon_sym_loop] = ACTIONS(516),
    [anon_sym_for] = ACTIONS(518),
    [anon_sym_while] = ACTIONS(520),
    [anon_sym_break] = ACTIONS(522),
    [anon_sym_continue] = ACTIONS(522),
    [sym_boolean] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_number] = ACTIONS(634),
    [anon_sym_Text] = ACTIONS(526),
    [anon_sym_Num] = ACTIONS(526),
    [anon_sym_Int] = ACTIONS(526),
    [anon_sym_Bool] = ACTIONS(526),
    [anon_sym_Null] = ACTIONS(526),
    [sym_status] = ACTIONS(634),
    [anon_sym_len] = ACTIONS(528),
    [anon_sym_lines] = ACTIONS(528),
    [anon_sym_DASH] = ACTIONS(530),
    [anon_sym_not] = ACTIONS(530),
    [anon_sym_unsafe] = ACTIONS(530),
    [anon_sym_trust] = ACTIONS(532),
    [anon_sym_silent] = ACTIONS(532),
    [anon_sym_sudo] = ACTIONS(532),
    [anon_sym_nameof] = ACTIONS(530),
    [sym_variable] = ACTIONS(534),
    [anon_sym_DQUOTE] = ACTIONS(536),
    [anon_sym_DOLLAR] = ACTIONS(538),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [sym__statement] = STATE(302),
    [sym_builtin_stmt] = STATE(302),
    [sym_mv_stmt] = STATE(302),
    [sym_function_control_flow] = STATE(302),
    [sym_subscript_expression] = STATE(749),
    [sym_variable_init] = STATE(302),
    [sym_variable_assignment] = STATE(302),
    [sym_parentheses] = STATE(749),
    [sym_if_cond] = STATE(302),
    [sym_if_chain] = STATE(302),
    [sym_if_ternary] = STATE(749),
    [sym_loop_infinite] = STATE(302),
    [sym_for_loop] = STATE(302),
    [sym_while_loop] = STATE(302),
    [sym_loop_control_flow] = STATE(302),
    [sym_type_name_symbol] = STATE(744),
    [sym_type_name] = STATE(749),
    [sym_array] = STATE(749),
    [sym_function_call] = STATE(749),
    [sym_builtin_expr] = STATE(749),
    [sym_unop] = STATE(749),
    [sym_binop] = STATE(749),
    [sym_keyword_binop] = STATE(749),
    [sym_string] = STATE(749),
    [sym_command] = STATE(749),
    [sym_command_modifier_block] = STATE(749),
    [sym__expression] = STATE(749),
    [aux_sym_command_modifier_block_repeat1] = STATE(946),
    [anon_sym_LPAREN] = ACTIONS(336),
    [anon_sym_cd] = ACTIONS(416),
    [anon_sym_echo] = ACTIONS(416),
    [anon_sym_exit] = ACTIONS(416),
    [anon_sym_mv] = ACTIONS(418),
    [sym_shebang] = ACTIONS(322),
    [anon_sym_return] = ACTIONS(420),
    [anon_sym_fail] = ACTIONS(420),
    [anon_sym_LBRACK] = ACTIONS(344),
    [anon_sym_const] = ACTIONS(446),
    [anon_sym_let] = ACTIONS(446),
    [anon_sym_if] = ACTIONS(448),
    [anon_sym_loop] = ACTIONS(450),
    [anon_sym_for] = ACTIONS(452),
    [anon_sym_while] = ACTIONS(454),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(39),
    [sym_boolean] = ACTIONS(432),
    [sym_null] = ACTIONS(432),
    [sym_number] = ACTIONS(432),
    [anon_sym_Text] = ACTIONS(360),
    [anon_sym_Num] = ACTIONS(360),
    [anon_sym_Int] = ACTIONS(360),
    [anon_sym_Bool] = ACTIONS(360),
    [anon_sym_Null] = ACTIONS(360),
    [sym_status] = ACTIONS(432),
    [anon_sym_len] = ACTIONS(434),
    [anon_sym_lines] = ACTIONS(434),
    [anon_sym_DASH] = ACTIONS(436),
    [anon_sym_not] = ACTIONS(436),
    [anon_sym_unsafe] = ACTIONS(436),
    [anon_sym_trust] = ACTIONS(438),
    [anon_sym_silent] = ACTIONS(438),
    [anon_sym_sudo] = ACTIONS(438),
    [anon_sym_nameof] = ACTIONS(436),
    [sym_variable] = ACTIONS(458),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_DOLLAR] = ACTIONS(442),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [sym__statement] = STATE(302),
    [sym_builtin_stmt] = STATE(302),
    [sym_mv_stmt] = STATE(302),
    [sym_function_control_flow] = STATE(302),
    [sym_subscript_expression] = STATE(145),
    [sym_variable_init] = STATE(302),
    [sym_variable_assignment] = STATE(302),
    [sym_parentheses] = STATE(145),
    [sym_if_cond] = STATE(302),
    [sym_if_chain] = STATE(302),
    [sym_if_ternary] = STATE(145),
    [sym_loop_infinite] = STATE(302),
    [sym_for_loop] = STATE(302),
    [sym_while_loop] = STATE(302),
    [sym_loop_control_flow] = STATE(302),
    [sym_type_name_symbol] = STATE(62),
    [sym_type_name] = STATE(74),
    [sym_array] = STATE(145),
    [sym_function_call] = STATE(145),
    [sym_builtin_expr] = STATE(145),
    [sym_unop] = STATE(145),
    [sym_binop] = STATE(145),
    [sym_keyword_binop] = STATE(145),
    [sym_string] = STATE(145),
    [sym_command] = STATE(145),
    [sym_command_modifier_block] = STATE(145),
    [sym__expression] = STATE(145),
    [aux_sym_command_modifier_block_repeat1] = STATE(945),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_cd] = ACTIONS(11),
    [anon_sym_echo] = ACTIONS(11),
    [anon_sym_exit] = ACTIONS(11),
    [anon_sym_mv] = ACTIONS(13),
    [sym_shebang] = ACTIONS(322),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_fail] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_const] = ACTIONS(29),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_loop] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(39),
    [sym_boolean] = ACTIONS(41),
    [sym_null] = ACTIONS(41),
    [sym_number] = ACTIONS(41),
    [anon_sym_Text] = ACTIONS(43),
    [anon_sym_Num] = ACTIONS(43),
    [anon_sym_Int] = ACTIONS(43),
    [anon_sym_Bool] = ACTIONS(43),
    [anon_sym_Null] = ACTIONS(43),
    [sym_status] = ACTIONS(41),
    [anon_sym_len] = ACTIONS(45),
    [anon_sym_lines] = ACTIONS(45),
    [anon_sym_DASH] = ACTIONS(47),
    [anon_sym_not] = ACTIONS(47),
    [anon_sym_unsafe] = ACTIONS(47),
    [anon_sym_trust] = ACTIONS(49),
    [anon_sym_silent] = ACTIONS(49),
    [anon_sym_sudo] = ACTIONS(49),
    [anon_sym_nameof] = ACTIONS(47),
    [sym_variable] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [anon_sym_DOLLAR] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [ts_builtin_sym_end] = ACTIONS(570),
    [anon_sym_SEMI] = ACTIONS(570),
    [anon_sym_main] = ACTIONS(572),
    [anon_sym_LPAREN] = ACTIONS(570),
    [anon_sym_cd] = ACTIONS(572),
    [anon_sym_echo] = ACTIONS(572),
    [anon_sym_exit] = ACTIONS(572),
    [anon_sym_mv] = ACTIONS(572),
    [sym_preprocessor_directive] = ACTIONS(570),
    [sym_shebang] = ACTIONS(570),
    [anon_sym_pub] = ACTIONS(572),
    [anon_sym_fun] = ACTIONS(572),
    [anon_sym_return] = ACTIONS(572),
    [anon_sym_fail] = ACTIONS(572),
    [anon_sym_as] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(572),
    [anon_sym_STAR] = ACTIONS(570),
    [anon_sym_LBRACK] = ACTIONS(570),
    [anon_sym_const] = ACTIONS(572),
    [anon_sym_let] = ACTIONS(572),
    [anon_sym_if] = ACTIONS(572),
    [anon_sym_else] = ACTIONS(572),
    [anon_sym_then] = ACTIONS(572),
    [anon_sym_loop] = ACTIONS(572),
    [anon_sym_for] = ACTIONS(572),
    [anon_sym_while] = ACTIONS(572),
    [anon_sym_break] = ACTIONS(572),
    [anon_sym_continue] = ACTIONS(572),
    [sym_boolean] = ACTIONS(572),
    [sym_null] = ACTIONS(572),
    [sym_number] = ACTIONS(572),
    [anon_sym_Text] = ACTIONS(572),
    [anon_sym_Num] = ACTIONS(572),
    [anon_sym_Int] = ACTIONS(572),
    [anon_sym_Bool] = ACTIONS(572),
    [anon_sym_Null] = ACTIONS(572),
    [sym_status] = ACTIONS(572),
    [anon_sym_len] = ACTIONS(572),
    [anon_sym_lines] = ACTIONS(572),
    [anon_sym_DASH] = ACTIONS(572),
    [anon_sym_not] = ACTIONS(572),
    [anon_sym_unsafe] = ACTIONS(572),
    [anon_sym_trust] = ACTIONS(572),
    [anon_sym_silent] = ACTIONS(572),
    [anon_sym_sudo] = ACTIONS(572),
    [anon_sym_nameof] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(572),
    [anon_sym_PERCENT] = ACTIONS(570),
    [anon_sym_GT] = ACTIONS(572),
    [anon_sym_LT] = ACTIONS(572),
    [anon_sym_GT_EQ] = ACTIONS(570),
    [anon_sym_LT_EQ] = ACTIONS(570),
    [anon_sym_EQ_EQ] = ACTIONS(570),
    [anon_sym_BANG_EQ] = ACTIONS(570),
    [anon_sym_and] = ACTIONS(572),
    [anon_sym_or] = ACTIONS(572),
    [anon_sym_is] = ACTIONS(572),
    [sym_variable] = ACTIONS(572),
    [anon_sym_DQUOTE] = ACTIONS(570),
    [anon_sym_failed] = ACTIONS(572),
    [anon_sym_succeeded] = ACTIONS(572),
    [anon_sym_exited] = ACTIONS(572),
    [sym_handler_propagation] = ACTIONS(570),
    [anon_sym_DOLLAR] = ACTIONS(570),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [ts_builtin_sym_end] = ACTIONS(638),
    [anon_sym_SEMI] = ACTIONS(638),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_COLON] = ACTIONS(638),
    [anon_sym_main] = ACTIONS(640),
    [anon_sym_LPAREN] = ACTIONS(638),
    [anon_sym_RPAREN] = ACTIONS(638),
    [anon_sym_cd] = ACTIONS(640),
    [anon_sym_echo] = ACTIONS(640),
    [anon_sym_exit] = ACTIONS(640),
    [anon_sym_mv] = ACTIONS(640),
    [anon_sym_COMMA] = ACTIONS(638),
    [anon_sym_EQ] = ACTIONS(640),
    [sym_preprocessor_directive] = ACTIONS(638),
    [sym_shebang] = ACTIONS(638),
    [anon_sym_pub] = ACTIONS(640),
    [anon_sym_fun] = ACTIONS(640),
    [anon_sym_return] = ACTIONS(640),
    [anon_sym_fail] = ACTIONS(640),
    [anon_sym_as] = ACTIONS(640),
    [anon_sym_import] = ACTIONS(640),
    [anon_sym_STAR] = ACTIONS(638),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_const] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(640),
    [anon_sym_if] = ACTIONS(640),
    [anon_sym_then] = ACTIONS(640),
    [anon_sym_loop] = ACTIONS(640),
    [anon_sym_for] = ACTIONS(640),
    [anon_sym_while] = ACTIONS(640),
    [anon_sym_break] = ACTIONS(640),
    [anon_sym_continue] = ACTIONS(640),
    [sym_boolean] = ACTIONS(640),
    [sym_null] = ACTIONS(640),
    [sym_number] = ACTIONS(640),
    [anon_sym_Text] = ACTIONS(640),
    [anon_sym_Num] = ACTIONS(640),
    [anon_sym_Int] = ACTIONS(640),
    [anon_sym_Bool] = ACTIONS(640),
    [anon_sym_Null] = ACTIONS(640),
    [sym_status] = ACTIONS(640),
    [anon_sym_len] = ACTIONS(640),
    [anon_sym_lines] = ACTIONS(640),
    [anon_sym_DASH] = ACTIONS(640),
    [anon_sym_not] = ACTIONS(640),
    [anon_sym_unsafe] = ACTIONS(640),
    [anon_sym_trust] = ACTIONS(640),
    [anon_sym_silent] = ACTIONS(640),
    [anon_sym_sudo] = ACTIONS(640),
    [anon_sym_nameof] = ACTIONS(640),
    [anon_sym_SLASH] = ACTIONS(640),
    [anon_sym_PLUS] = ACTIONS(640),
    [anon_sym_PERCENT] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(640),
    [anon_sym_LT] = ACTIONS(640),
    [anon_sym_GT_EQ] = ACTIONS(638),
    [anon_sym_LT_EQ] = ACTIONS(638),
    [anon_sym_EQ_EQ] = ACTIONS(638),
    [anon_sym_BANG_EQ] = ACTIONS(638),
    [anon_sym_and] = ACTIONS(640),
    [anon_sym_or] = ACTIONS(640),
    [anon_sym_is] = ACTIONS(640),
    [sym_variable] = ACTIONS(640),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_DOLLAR] = ACTIONS(638),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [ts_builtin_sym_end] = ACTIONS(642),
    [anon_sym_SEMI] = ACTIONS(642),
    [anon_sym_main] = ACTIONS(644),
    [anon_sym_LPAREN] = ACTIONS(642),
    [anon_sym_cd] = ACTIONS(644),
    [anon_sym_echo] = ACTIONS(644),
    [anon_sym_exit] = ACTIONS(644),
    [anon_sym_mv] = ACTIONS(644),
    [sym_preprocessor_directive] = ACTIONS(642),
    [sym_shebang] = ACTIONS(642),
    [anon_sym_pub] = ACTIONS(644),
    [anon_sym_fun] = ACTIONS(644),
    [anon_sym_return] = ACTIONS(644),
    [anon_sym_fail] = ACTIONS(644),
    [anon_sym_as] = ACTIONS(644),
    [anon_sym_import] = ACTIONS(644),
    [anon_sym_STAR] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(644),
    [anon_sym_let] = ACTIONS(644),
    [anon_sym_if] = ACTIONS(644),
    [anon_sym_else] = ACTIONS(644),
    [anon_sym_then] = ACTIONS(644),
    [anon_sym_loop] = ACTIONS(644),
    [anon_sym_for] = ACTIONS(644),
    [anon_sym_while] = ACTIONS(644),
    [anon_sym_break] = ACTIONS(644),
    [anon_sym_continue] = ACTIONS(644),
    [sym_boolean] = ACTIONS(644),
    [sym_null] = ACTIONS(644),
    [sym_number] = ACTIONS(644),
    [anon_sym_Text] = ACTIONS(644),
    [anon_sym_Num] = ACTIONS(644),
    [anon_sym_Int] = ACTIONS(644),
    [anon_sym_Bool] = ACTIONS(644),
    [anon_sym_Null] = ACTIONS(644),
    [sym_status] = ACTIONS(644),
    [anon_sym_len] = ACTIONS(644),
    [anon_sym_lines] = ACTIONS(644),
    [anon_sym_DASH] = ACTIONS(644),
    [anon_sym_not] = ACTIONS(644),
    [anon_sym_unsafe] = ACTIONS(644),
    [anon_sym_trust] = ACTIONS(644),
    [anon_sym_silent] = ACTIONS(644),
    [anon_sym_sudo] = ACTIONS(644),
    [anon_sym_nameof] = ACTIONS(644),
    [anon_sym_SLASH] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(644),
    [anon_sym_PERCENT] = ACTIONS(642),
    [anon_sym_GT] = ACTIONS(644),
    [anon_sym_LT] = ACTIONS(644),
    [anon_sym_GT_EQ] = ACTIONS(642),
    [anon_sym_LT_EQ] = ACTIONS(642),
    [anon_sym_EQ_EQ] = ACTIONS(642),
    [anon_sym_BANG_EQ] = ACTIONS(642),
    [anon_sym_and] = ACTIONS(644),
    [anon_sym_or] = ACTIONS(644),
    [anon_sym_is] = ACTIONS(644),
    [sym_variable] = ACTIONS(644),
    [anon_sym_DQUOTE] = ACTIONS(642),
    [anon_sym_failed] = ACTIONS(644),
    [anon_sym_succeeded] = ACTIONS(644),
    [anon_sym_exited] = ACTIONS(644),
    [sym_handler_propagation] = ACTIONS(642),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [ts_builtin_sym_end] = ACTIONS(646),
    [anon_sym_SEMI] = ACTIONS(646),
    [anon_sym_LBRACE] = ACTIONS(646),
    [anon_sym_COLON] = ACTIONS(646),
    [anon_sym_main] = ACTIONS(648),
    [anon_sym_LPAREN] = ACTIONS(646),
    [anon_sym_RPAREN] = ACTIONS(646),
    [anon_sym_cd] = ACTIONS(648),
    [anon_sym_echo] = ACTIONS(648),
    [anon_sym_exit] = ACTIONS(648),
    [anon_sym_mv] = ACTIONS(648),
    [anon_sym_COMMA] = ACTIONS(646),
    [anon_sym_EQ] = ACTIONS(648),
    [sym_preprocessor_directive] = ACTIONS(646),
    [sym_shebang] = ACTIONS(646),
    [anon_sym_pub] = ACTIONS(648),
    [anon_sym_fun] = ACTIONS(648),
    [anon_sym_return] = ACTIONS(648),
    [anon_sym_fail] = ACTIONS(648),
    [anon_sym_as] = ACTIONS(648),
    [anon_sym_import] = ACTIONS(648),
    [anon_sym_STAR] = ACTIONS(646),
    [anon_sym_LBRACK] = ACTIONS(646),
    [anon_sym_const] = ACTIONS(648),
    [anon_sym_let] = ACTIONS(648),
    [anon_sym_if] = ACTIONS(648),
    [anon_sym_then] = ACTIONS(648),
    [anon_sym_loop] = ACTIONS(648),
    [anon_sym_for] = ACTIONS(648),
    [anon_sym_while] = ACTIONS(648),
    [anon_sym_break] = ACTIONS(648),
    [anon_sym_continue] = ACTIONS(648),
    [sym_boolean] = ACTIONS(648),
    [sym_null] = ACTIONS(648),
    [sym_number] = ACTIONS(648),
    [anon_sym_Text] = ACTIONS(648),
    [anon_sym_Num] = ACTIONS(648),
    [anon_sym_Int] = ACTIONS(648),
    [anon_sym_Bool] = ACTIONS(648),
    [anon_sym_Null] = ACTIONS(648),
    [sym_status] = ACTIONS(648),
    [anon_sym_len] = ACTIONS(648),
    [anon_sym_lines] = ACTIONS(648),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_not] = ACTIONS(648),
    [anon_sym_unsafe] = ACTIONS(648),
    [anon_sym_trust] = ACTIONS(648),
    [anon_sym_silent] = ACTIONS(648),
    [anon_sym_sudo] = ACTIONS(648),
    [anon_sym_nameof] = ACTIONS(648),
    [anon_sym_SLASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(648),
    [anon_sym_PERCENT] = ACTIONS(646),
    [anon_sym_GT] = ACTIONS(648),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT_EQ] = ACTIONS(646),
    [anon_sym_LT_EQ] = ACTIONS(646),
    [anon_sym_EQ_EQ] = ACTIONS(646),
    [anon_sym_BANG_EQ] = ACTIONS(646),
    [anon_sym_and] = ACTIONS(648),
    [anon_sym_or] = ACTIONS(648),
    [anon_sym_is] = ACTIONS(648),
    [sym_variable] = ACTIONS(648),
    [anon_sym_DQUOTE] = ACTIONS(646),
    [anon_sym_DOLLAR] = ACTIONS(646),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [ts_builtin_sym_end] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_main] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_cd] = ACTIONS(652),
    [anon_sym_echo] = ACTIONS(652),
    [anon_sym_exit] = ACTIONS(652),
    [anon_sym_mv] = ACTIONS(652),
    [sym_preprocessor_directive] = ACTIONS(650),
    [sym_shebang] = ACTIONS(650),
    [anon_sym_pub] = ACTIONS(652),
    [anon_sym_fun] = ACTIONS(652),
    [anon_sym_return] = ACTIONS(652),
    [anon_sym_fail] = ACTIONS(652),
    [anon_sym_as] = ACTIONS(652),
    [anon_sym_import] = ACTIONS(652),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(650),
    [anon_sym_const] = ACTIONS(652),
    [anon_sym_let] = ACTIONS(652),
    [anon_sym_if] = ACTIONS(652),
    [anon_sym_else] = ACTIONS(652),
    [anon_sym_then] = ACTIONS(652),
    [anon_sym_loop] = ACTIONS(652),
    [anon_sym_for] = ACTIONS(652),
    [anon_sym_while] = ACTIONS(652),
    [anon_sym_break] = ACTIONS(652),
    [anon_sym_continue] = ACTIONS(652),
    [sym_boolean] = ACTIONS(652),
    [sym_null] = ACTIONS(652),
    [sym_number] = ACTIONS(652),
    [anon_sym_Text] = ACTIONS(652),
    [anon_sym_Num] = ACTIONS(652),
    [anon_sym_Int] = ACTIONS(652),
    [anon_sym_Bool] = ACTIONS(652),
    [anon_sym_Null] = ACTIONS(652),
    [sym_status] = ACTIONS(652),
    [anon_sym_len] = ACTIONS(652),
    [anon_sym_lines] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_not] = ACTIONS(652),
    [anon_sym_unsafe] = ACTIONS(652),
    [anon_sym_trust] = ACTIONS(652),
    [anon_sym_silent] = ACTIONS(652),
    [anon_sym_sudo] = ACTIONS(652),
    [anon_sym_nameof] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT_EQ] = ACTIONS(650),
    [anon_sym_LT_EQ] = ACTIONS(650),
    [anon_sym_EQ_EQ] = ACTIONS(650),
    [anon_sym_BANG_EQ] = ACTIONS(650),
    [anon_sym_and] = ACTIONS(652),
    [anon_sym_or] = ACTIONS(652),
    [anon_sym_is] = ACTIONS(652),
    [sym_variable] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_failed] = ACTIONS(652),
    [anon_sym_succeeded] = ACTIONS(652),
    [anon_sym_exited] = ACTIONS(652),
    [sym_handler_propagation] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [ts_builtin_sym_end] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_main] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_cd] = ACTIONS(652),
    [anon_sym_echo] = ACTIONS(652),
    [anon_sym_exit] = ACTIONS(652),
    [anon_sym_mv] = ACTIONS(652),
    [sym_preprocessor_directive] = ACTIONS(650),
    [sym_shebang] = ACTIONS(650),
    [anon_sym_pub] = ACTIONS(652),
    [anon_sym_fun] = ACTIONS(652),
    [anon_sym_return] = ACTIONS(652),
    [anon_sym_fail] = ACTIONS(652),
    [anon_sym_as] = ACTIONS(652),
    [anon_sym_import] = ACTIONS(652),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(650),
    [anon_sym_const] = ACTIONS(652),
    [anon_sym_let] = ACTIONS(652),
    [anon_sym_if] = ACTIONS(652),
    [anon_sym_then] = ACTIONS(652),
    [anon_sym_loop] = ACTIONS(652),
    [anon_sym_for] = ACTIONS(652),
    [anon_sym_while] = ACTIONS(652),
    [anon_sym_break] = ACTIONS(652),
    [anon_sym_continue] = ACTIONS(652),
    [sym_boolean] = ACTIONS(652),
    [sym_null] = ACTIONS(652),
    [sym_number] = ACTIONS(652),
    [anon_sym_Text] = ACTIONS(652),
    [anon_sym_Num] = ACTIONS(652),
    [anon_sym_Int] = ACTIONS(652),
    [anon_sym_Bool] = ACTIONS(652),
    [anon_sym_Null] = ACTIONS(652),
    [sym_status] = ACTIONS(652),
    [anon_sym_len] = ACTIONS(652),
    [anon_sym_lines] = ACTIONS(652),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_not] = ACTIONS(652),
    [anon_sym_unsafe] = ACTIONS(652),
    [anon_sym_trust] = ACTIONS(652),
    [anon_sym_silent] = ACTIONS(652),
    [anon_sym_sudo] = ACTIONS(652),
    [anon_sym_nameof] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT_EQ] = ACTIONS(650),
    [anon_sym_LT_EQ] = ACTIONS(650),
    [anon_sym_EQ_EQ] = ACTIONS(650),
    [anon_sym_BANG_EQ] = ACTIONS(650),
    [anon_sym_and] = ACTIONS(652),
    [anon_sym_or] = ACTIONS(652),
    [anon_sym_is] = ACTIONS(652),
    [sym_variable] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_failed] = ACTIONS(652),
    [anon_sym_succeeded] = ACTIONS(652),
    [anon_sym_exited] = ACTIONS(652),
    [sym_handler_propagation] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [sym_parameter_list] = STATE(70),
    [sym_subscript] = STATE(968),
    [anon_sym_SEMI] = ACTIONS(156),
    [anon_sym_RBRACE] = ACTIONS(156),
    [anon_sym_LPAREN] = ACTIONS(654),
    [anon_sym_cd] = ACTIONS(158),
    [anon_sym_echo] = ACTIONS(158),
    [anon_sym_exit] = ACTIONS(158),
    [anon_sym_mv] = ACTIONS(158),
    [anon_sym_EQ] = ACTIONS(656),
    [sym_shebang] = ACTIONS(156),
    [anon_sym_return] = ACTIONS(158),
    [anon_sym_fail] = ACTIONS(158),
    [anon_sym_as] = ACTIONS(158),
    [anon_sym_STAR] = ACTIONS(158),
    [anon_sym_LBRACK] = ACTIONS(164),
    [anon_sym_const] = ACTIONS(158),
    [anon_sym_let] = ACTIONS(158),
    [anon_sym_PLUS_EQ] = ACTIONS(658),
    [anon_sym_DASH_EQ] = ACTIONS(658),
    [anon_sym_STAR_EQ] = ACTIONS(658),
    [anon_sym_SLASH_EQ] = ACTIONS(658),
    [anon_sym_PERCENT_EQ] = ACTIONS(658),
    [anon_sym_if] = ACTIONS(158),
    [anon_sym_else] = ACTIONS(158),
    [anon_sym_then] = ACTIONS(158),
    [anon_sym_loop] = ACTIONS(158),
    [anon_sym_for] = ACTIONS(158),
    [anon_sym_while] = ACTIONS(158),
    [anon_sym_break] = ACTIONS(158),
    [anon_sym_continue] = ACTIONS(158),
    [sym_boolean] = ACTIONS(158),
    [sym_null] = ACTIONS(158),
    [sym_number] = ACTIONS(158),
    [anon_sym_Text] = ACTIONS(158),
    [anon_sym_Num] = ACTIONS(158),
    [anon_sym_Int] = ACTIONS(158),
    [anon_sym_Bool] = ACTIONS(158),
    [anon_sym_Null] = ACTIONS(158),
    [sym_status] = ACTIONS(158),
    [anon_sym_len] = ACTIONS(158),
    [anon_sym_lines] = ACTIONS(158),
    [anon_sym_DASH] = ACTIONS(158),
    [anon_sym_not] = ACTIONS(158),
    [anon_sym_unsafe] = ACTIONS(158),
    [anon_sym_trust] = ACTIONS(158),
    [anon_sym_silent] = ACTIONS(158),
    [anon_sym_sudo] = ACTIONS(158),
    [anon_sym_nameof] = ACTIONS(158),
    [anon_sym_SLASH] = ACTIONS(158),
    [anon_sym_PLUS] = ACTIONS(158),
    [anon_sym_PERCENT] = ACTIONS(158),
    [anon_sym_GT] = ACTIONS(158),
    [anon_sym_LT] = ACTIONS(158),
    [anon_sym_GT_EQ] = ACTIONS(156),
    [anon_sym_LT_EQ] = ACTIONS(156),
    [anon_sym_EQ_EQ] = ACTIONS(156),
    [anon_sym_BANG_EQ] = ACTIONS(156),
    [anon_sym_and] = ACTIONS(158),
    [anon_sym_or] = ACTIONS(158),
    [anon_sym_is] = ACTIONS(158),
    [sym_variable] = ACTIONS(158),
    [anon_sym_DQUOTE] = ACTIONS(156),
    [anon_sym_DOLLAR] = ACTIONS(156),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [sym_handler_failed] = STATE(233),
    [sym_handler_succeeded] = STATE(233),
    [sym_handler_exited] = STATE(233),
    [sym_handler] = STATE(215),
    [anon_sym_SEMI] = ACTIONS(136),
    [anon_sym_RBRACE] = ACTIONS(136),
    [anon_sym_LPAREN] = ACTIONS(136),
    [anon_sym_cd] = ACTIONS(138),
    [anon_sym_echo] = ACTIONS(138),
    [anon_sym_exit] = ACTIONS(138),
    [anon_sym_mv] = ACTIONS(138),
    [sym_shebang] = ACTIONS(136),
    [anon_sym_return] = ACTIONS(138),
    [anon_sym_fail] = ACTIONS(138),
    [anon_sym_as] = ACTIONS(138),
    [anon_sym_STAR] = ACTIONS(136),
    [anon_sym_LBRACK] = ACTIONS(136),
    [anon_sym_const] = ACTIONS(138),
    [anon_sym_let] = ACTIONS(138),
    [anon_sym_if] = ACTIONS(138),
    [anon_sym_else] = ACTIONS(138),
    [anon_sym_then] = ACTIONS(138),
    [anon_sym_loop] = ACTIONS(138),
    [anon_sym_for] = ACTIONS(138),
    [anon_sym_while] = ACTIONS(138),
    [anon_sym_break] = ACTIONS(138),
    [anon_sym_continue] = ACTIONS(138),
    [sym_boolean] = ACTIONS(138),
    [sym_null] = ACTIONS(138),
    [sym_number] = ACTIONS(138),
    [anon_sym_Text] = ACTIONS(138),
    [anon_sym_Num] = ACTIONS(138),
    [anon_sym_Int] = ACTIONS(138),
    [anon_sym_Bool] = ACTIONS(138),
    [anon_sym_Null] = ACTIONS(138),
    [sym_status] = ACTIONS(138),
    [anon_sym_len] = ACTIONS(138),
    [anon_sym_lines] = ACTIONS(138),
    [anon_sym_DASH] = ACTIONS(138),
    [anon_sym_not] = ACTIONS(138),
    [anon_sym_unsafe] = ACTIONS(138),
    [anon_sym_trust] = ACTIONS(138),
    [anon_sym_silent] = ACTIONS(138),
    [anon_sym_sudo] = ACTIONS(138),
    [anon_sym_nameof] = ACTIONS(138),
    [anon_sym_SLASH] = ACTIONS(138),
    [anon_sym_PLUS] = ACTIONS(138),
    [anon_sym_PERCENT] = ACTIONS(136),
    [anon_sym_GT] = ACTIONS(138),
    [anon_sym_LT] = ACTIONS(138),
    [anon_sym_GT_EQ] = ACTIONS(136),
    [anon_sym_LT_EQ] = ACTIONS(136),
    [anon_sym_EQ_EQ] = ACTIONS(136),
    [anon_sym_BANG_EQ] = ACTIONS(136),
    [anon_sym_and] = ACTIONS(138),
    [anon_sym_or] = ACTIONS(138),
    [anon_sym_is] = ACTIONS(138),
    [sym_variable] = ACTIONS(138),
    [anon_sym_DQUOTE] = ACTIONS(136),
    [anon_sym_failed] = ACTIONS(660),
    [anon_sym_succeeded] = ACTIONS(662),
    [anon_sym_exited] = ACTIONS(664),
    [sym_handler_propagation] = ACTIONS(666),
    [anon_sym_DOLLAR] = ACTIONS(136),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [sym_parameter_list] = STATE(70),
    [sym_subscript] = STATE(964),
    [anon_sym_SEMI] = ACTIONS(156),
    [anon_sym_RBRACE] = ACTIONS(156),
    [anon_sym_LPAREN] = ACTIONS(654),
    [anon_sym_cd] = ACTIONS(158),
    [anon_sym_echo] = ACTIONS(158),
    [anon_sym_exit] = ACTIONS(158),
    [anon_sym_mv] = ACTIONS(158),
    [anon_sym_EQ] = ACTIONS(668),
    [sym_shebang] = ACTIONS(156),
    [anon_sym_return] = ACTIONS(158),
    [anon_sym_fail] = ACTIONS(158),
    [anon_sym_as] = ACTIONS(158),
    [anon_sym_STAR] = ACTIONS(158),
    [anon_sym_LBRACK] = ACTIONS(164),
    [anon_sym_const] = ACTIONS(158),
    [anon_sym_let] = ACTIONS(158),
    [anon_sym_PLUS_EQ] = ACTIONS(670),
    [anon_sym_DASH_EQ] = ACTIONS(670),
    [anon_sym_STAR_EQ] = ACTIONS(670),
    [anon_sym_SLASH_EQ] = ACTIONS(670),
    [anon_sym_PERCENT_EQ] = ACTIONS(670),
    [anon_sym_if] = ACTIONS(158),
    [anon_sym_else] = ACTIONS(158),
    [anon_sym_then] = ACTIONS(158),
    [anon_sym_loop] = ACTIONS(158),
    [anon_sym_for] = ACTIONS(158),
    [anon_sym_while] = ACTIONS(158),
    [anon_sym_break] = ACTIONS(158),
    [anon_sym_continue] = ACTIONS(158),
    [sym_boolean] = ACTIONS(158),
    [sym_null] = ACTIONS(158),
    [sym_number] = ACTIONS(158),
    [anon_sym_Text] = ACTIONS(158),
    [anon_sym_Num] = ACTIONS(158),
    [anon_sym_Int] = ACTIONS(158),
    [anon_sym_Bool] = ACTIONS(158),
    [anon_sym_Null] = ACTIONS(158),
    [sym_status] = ACTIONS(158),
    [anon_sym_len] = ACTIONS(158),
    [anon_sym_lines] = ACTIONS(158),
    [anon_sym_DASH] = ACTIONS(158),
    [anon_sym_not] = ACTIONS(158),
    [anon_sym_unsafe] = ACTIONS(158),
    [anon_sym_trust] = ACTIONS(158),
    [anon_sym_silent] = ACTIONS(158),
    [anon_sym_sudo] = ACTIONS(158),
    [anon_sym_nameof] = ACTIONS(158),
    [anon_sym_SLASH] = ACTIONS(158),
    [anon_sym_PLUS] = ACTIONS(158),
    [anon_sym_PERCENT] = ACTIONS(158),
    [anon_sym_GT] = ACTIONS(158),
    [anon_sym_LT] = ACTIONS(158),
    [anon_sym_GT_EQ] = ACTIONS(156),
    [anon_sym_LT_EQ] = ACTIONS(156),
    [anon_sym_EQ_EQ] = ACTIONS(156),
    [anon_sym_BANG_EQ] = ACTIONS(156),
    [anon_sym_and] = ACTIONS(158),
    [anon_sym_or] = ACTIONS(158),
    [anon_sym_is] = ACTIONS(158),
    [sym_variable] = ACTIONS(158),
    [anon_sym_DQUOTE] = ACTIONS(156),
    [anon_sym_DOLLAR] = ACTIONS(156),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [sym_handler_failed] = STATE(233),
    [sym_handler_succeeded] = STATE(233),
    [sym_handler_exited] = STATE(233),
    [sym_handler] = STATE(232),
    [anon_sym_SEMI] = ACTIONS(152),
    [anon_sym_RBRACE] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(152),
    [anon_sym_cd] = ACTIONS(154),
    [anon_sym_echo] = ACTIONS(154),
    [anon_sym_exit] = ACTIONS(154),
    [anon_sym_mv] = ACTIONS(154),
    [sym_shebang] = ACTIONS(152),
    [anon_sym_return] = ACTIONS(154),
    [anon_sym_fail] = ACTIONS(154),
    [anon_sym_as] = ACTIONS(154),
    [anon_sym_STAR] = ACTIONS(152),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_const] = ACTIONS(154),
    [anon_sym_let] = ACTIONS(154),
    [anon_sym_if] = ACTIONS(154),
    [anon_sym_else] = ACTIONS(154),
    [anon_sym_then] = ACTIONS(154),
    [anon_sym_loop] = ACTIONS(154),
    [anon_sym_for] = ACTIONS(154),
    [anon_sym_while] = ACTIONS(154),
    [anon_sym_break] = ACTIONS(154),
    [anon_sym_continue] = ACTIONS(154),
    [sym_boolean] = ACTIONS(154),
    [sym_null] = ACTIONS(154),
    [sym_number] = ACTIONS(154),
    [anon_sym_Text] = ACTIONS(154),
    [anon_sym_Num] = ACTIONS(154),
    [anon_sym_Int] = ACTIONS(154),
    [anon_sym_Bool] = ACTIONS(154),
    [anon_sym_Null] = ACTIONS(154),
    [sym_status] = ACTIONS(154),
    [anon_sym_len] = ACTIONS(154),
    [anon_sym_lines] = ACTIONS(154),
    [anon_sym_DASH] = ACTIONS(154),
    [anon_sym_not] = ACTIONS(154),
    [anon_sym_unsafe] = ACTIONS(154),
    [anon_sym_trust] = ACTIONS(154),
    [anon_sym_silent] = ACTIONS(154),
    [anon_sym_sudo] = ACTIONS(154),
    [anon_sym_nameof] = ACTIONS(154),
    [anon_sym_SLASH] = ACTIONS(154),
    [anon_sym_PLUS] = ACTIONS(154),
    [anon_sym_PERCENT] = ACTIONS(152),
    [anon_sym_GT] = ACTIONS(154),
    [anon_sym_LT] = ACTIONS(154),
    [anon_sym_GT_EQ] = ACTIONS(152),
    [anon_sym_LT_EQ] = ACTIONS(152),
    [anon_sym_EQ_EQ] = ACTIONS(152),
    [anon_sym_BANG_EQ] = ACTIONS(152),
    [anon_sym_and] = ACTIONS(154),
    [anon_sym_or] = ACTIONS(154),
    [anon_sym_is] = ACTIONS(154),
    [sym_variable] = ACTIONS(154),
    [anon_sym_DQUOTE] = ACTIONS(152),
    [anon_sym_failed] = ACTIONS(660),
    [anon_sym_succeeded] = ACTIONS(662),
    [anon_sym_exited] = ACTIONS(664),
    [sym_handler_propagation] = ACTIONS(666),
    [anon_sym_DOLLAR] = ACTIONS(152),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [sym_handler_failed] = STATE(233),
    [sym_handler_succeeded] = STATE(233),
    [sym_handler_exited] = STATE(233),
    [sym_handler] = STATE(231),
    [anon_sym_SEMI] = ACTIONS(148),
    [anon_sym_RBRACE] = ACTIONS(148),
    [anon_sym_LPAREN] = ACTIONS(148),
    [anon_sym_cd] = ACTIONS(150),
    [anon_sym_echo] = ACTIONS(150),
    [anon_sym_exit] = ACTIONS(150),
    [anon_sym_mv] = ACTIONS(150),
    [sym_shebang] = ACTIONS(148),
    [anon_sym_return] = ACTIONS(150),
    [anon_sym_fail] = ACTIONS(150),
    [anon_sym_as] = ACTIONS(150),
    [anon_sym_STAR] = ACTIONS(148),
    [anon_sym_LBRACK] = ACTIONS(148),
    [anon_sym_const] = ACTIONS(150),
    [anon_sym_let] = ACTIONS(150),
    [anon_sym_if] = ACTIONS(150),
    [anon_sym_else] = ACTIONS(150),
    [anon_sym_then] = ACTIONS(150),
    [anon_sym_loop] = ACTIONS(150),
    [anon_sym_for] = ACTIONS(150),
    [anon_sym_while] = ACTIONS(150),
    [anon_sym_break] = ACTIONS(150),
    [anon_sym_continue] = ACTIONS(150),
    [sym_boolean] = ACTIONS(150),
    [sym_null] = ACTIONS(150),
    [sym_number] = ACTIONS(150),
    [anon_sym_Text] = ACTIONS(150),
    [anon_sym_Num] = ACTIONS(150),
    [anon_sym_Int] = ACTIONS(150),
    [anon_sym_Bool] = ACTIONS(150),
    [anon_sym_Null] = ACTIONS(150),
    [sym_status] = ACTIONS(150),
    [anon_sym_len] = ACTIONS(150),
    [anon_sym_lines] = ACTIONS(150),
    [anon_sym_DASH] = ACTIONS(150),
    [anon_sym_not] = ACTIONS(150),
    [anon_sym_unsafe] = ACTIONS(150),
    [anon_sym_trust] = ACTIONS(150),
    [anon_sym_silent] = ACTIONS(150),
    [anon_sym_sudo] = ACTIONS(150),
    [anon_sym_nameof] = ACTIONS(150),
    [anon_sym_SLASH] = ACTIONS(150),
    [anon_sym_PLUS] = ACTIONS(150),
    [anon_sym_PERCENT] = ACTIONS(148),
    [anon_sym_GT] = ACTIONS(150),
    [anon_sym_LT] = ACTIONS(150),
    [anon_sym_GT_EQ] = ACTIONS(148),
    [anon_sym_LT_EQ] = ACTIONS(148),
    [anon_sym_EQ_EQ] = ACTIONS(148),
    [anon_sym_BANG_EQ] = ACTIONS(148),
    [anon_sym_and] = ACTIONS(150),
    [anon_sym_or] = ACTIONS(150),
    [anon_sym_is] = ACTIONS(150),
    [sym_variable] = ACTIONS(150),
    [anon_sym_DQUOTE] = ACTIONS(148),
    [anon_sym_failed] = ACTIONS(660),
    [anon_sym_succeeded] = ACTIONS(662),
    [anon_sym_exited] = ACTIONS(664),
    [sym_handler_propagation] = ACTIONS(666),
    [anon_sym_DOLLAR] = ACTIONS(148),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [ts_builtin_sym_end] = ACTIONS(642),
    [anon_sym_SEMI] = ACTIONS(642),
    [anon_sym_main] = ACTIONS(644),
    [anon_sym_LPAREN] = ACTIONS(642),
    [anon_sym_cd] = ACTIONS(644),
    [anon_sym_echo] = ACTIONS(644),
    [anon_sym_exit] = ACTIONS(644),
    [anon_sym_mv] = ACTIONS(644),
    [sym_preprocessor_directive] = ACTIONS(642),
    [sym_shebang] = ACTIONS(642),
    [anon_sym_pub] = ACTIONS(644),
    [anon_sym_fun] = ACTIONS(644),
    [anon_sym_return] = ACTIONS(644),
    [anon_sym_fail] = ACTIONS(644),
    [anon_sym_as] = ACTIONS(644),
    [anon_sym_import] = ACTIONS(644),
    [anon_sym_STAR] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(644),
    [anon_sym_let] = ACTIONS(644),
    [anon_sym_if] = ACTIONS(644),
    [anon_sym_then] = ACTIONS(644),
    [anon_sym_loop] = ACTIONS(644),
    [anon_sym_for] = ACTIONS(644),
    [anon_sym_while] = ACTIONS(644),
    [anon_sym_break] = ACTIONS(644),
    [anon_sym_continue] = ACTIONS(644),
    [sym_boolean] = ACTIONS(644),
    [sym_null] = ACTIONS(644),
    [sym_number] = ACTIONS(644),
    [anon_sym_Text] = ACTIONS(644),
    [anon_sym_Num] = ACTIONS(644),
    [anon_sym_Int] = ACTIONS(644),
    [anon_sym_Bool] = ACTIONS(644),
    [anon_sym_Null] = ACTIONS(644),
    [sym_status] = ACTIONS(644),
    [anon_sym_len] = ACTIONS(644),
    [anon_sym_lines] = ACTIONS(644),
    [anon_sym_DASH] = ACTIONS(644),
    [anon_sym_not] = ACTIONS(644),
    [anon_sym_unsafe] = ACTIONS(644),
    [anon_sym_trust] = ACTIONS(644),
    [anon_sym_silent] = ACTIONS(644),
    [anon_sym_sudo] = ACTIONS(644),
    [anon_sym_nameof] = ACTIONS(644),
    [anon_sym_SLASH] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(644),
    [anon_sym_PERCENT] = ACTIONS(642),
    [anon_sym_GT] = ACTIONS(644),
    [anon_sym_LT] = ACTIONS(644),
    [anon_sym_GT_EQ] = ACTIONS(642),
    [anon_sym_LT_EQ] = ACTIONS(642),
    [anon_sym_EQ_EQ] = ACTIONS(642),
    [anon_sym_BANG_EQ] = ACTIONS(642),
    [anon_sym_and] = ACTIONS(644),
    [anon_sym_or] = ACTIONS(644),
    [anon_sym_is] = ACTIONS(644),
    [sym_variable] = ACTIONS(644),
    [anon_sym_DQUOTE] = ACTIONS(642),
    [anon_sym_failed] = ACTIONS(644),
    [anon_sym_succeeded] = ACTIONS(644),
    [anon_sym_exited] = ACTIONS(644),
    [sym_handler_propagation] = ACTIONS(642),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_failed,
    ACTIONS(674), 1,
      anon_sym_succeeded,
    ACTIONS(676), 1,
      anon_sym_exited,
    ACTIONS(678), 1,
      sym_handler_propagation,
    STATE(258), 1,
      sym_handler,
    STATE(270), 3,
      sym_handler_failed,
      sym_handler_succeeded,
      sym_handler_exited,
    ACTIONS(136), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(138), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [83] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 1,
      anon_sym_LBRACE,
    ACTIONS(682), 1,
      anon_sym_COLON,
    STATE(327), 1,
      sym_block,
    ACTIONS(156), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(158), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [160] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_failed,
    ACTIONS(674), 1,
      anon_sym_succeeded,
    ACTIONS(676), 1,
      anon_sym_exited,
    ACTIONS(678), 1,
      sym_handler_propagation,
    STATE(266), 1,
      sym_handler,
    STATE(270), 3,
      sym_handler_failed,
      sym_handler_succeeded,
      sym_handler_exited,
    ACTIONS(152), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(154), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [243] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 1,
      anon_sym_failed,
    ACTIONS(674), 1,
      anon_sym_succeeded,
    ACTIONS(676), 1,
      anon_sym_exited,
    ACTIONS(678), 1,
      sym_handler_propagation,
    STATE(262), 1,
      sym_handler,
    STATE(270), 3,
      sym_handler_failed,
      sym_handler_succeeded,
      sym_handler_exited,
    ACTIONS(148), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(150), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [326] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    ACTIONS(684), 1,
      anon_sym_LPAREN,
    ACTIONS(686), 1,
      anon_sym_EQ,
    STATE(75), 1,
      sym_parameter_list,
    STATE(977), 1,
      sym_subscript,
    ACTIONS(688), 5,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(156), 9,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_shebang,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(158), 44,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [409] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 1,
      anon_sym_LBRACE,
    ACTIONS(682), 1,
      anon_sym_COLON,
    STATE(328), 1,
      sym_block,
    ACTIONS(156), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(158), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [486] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    ACTIONS(684), 1,
      anon_sym_LPAREN,
    ACTIONS(690), 1,
      anon_sym_EQ,
    STATE(75), 1,
      sym_parameter_list,
    STATE(965), 1,
      sym_subscript,
    ACTIONS(692), 5,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(156), 9,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_shebang,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(158), 44,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [569] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 1,
      anon_sym_LBRACE,
    ACTIONS(682), 1,
      anon_sym_COLON,
    STATE(334), 1,
      sym_block,
    ACTIONS(156), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(158), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [646] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_STAR,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_then,
    ACTIONS(706), 1,
      anon_sym_SLASH,
    STATE(116), 1,
      sym_subscript,
    ACTIONS(698), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(712), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(708), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(710), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(694), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(696), 38,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [734] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_STAR,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(706), 1,
      anon_sym_SLASH,
    STATE(116), 1,
      sym_subscript,
    ACTIONS(712), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(714), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(716), 44,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [814] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    STATE(116), 1,
      sym_subscript,
    ACTIONS(718), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(720), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [888] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_STAR,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(706), 1,
      anon_sym_SLASH,
    STATE(116), 1,
      sym_subscript,
    ACTIONS(712), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(718), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(720), 44,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [968] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    STATE(116), 1,
      sym_subscript,
    ACTIONS(694), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(696), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [1042] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    STATE(116), 1,
      sym_subscript,
    ACTIONS(722), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(724), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [1116] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    STATE(116), 1,
      sym_subscript,
    ACTIONS(714), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(716), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [1190] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(650), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(652), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [1260] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_STAR,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_then,
    ACTIONS(706), 1,
      anon_sym_SLASH,
    STATE(116), 1,
      sym_subscript,
    ACTIONS(698), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(712), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(708), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(710), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(726), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(728), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [1348] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_STAR,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_then,
    ACTIONS(706), 1,
      anon_sym_SLASH,
    STATE(116), 1,
      sym_subscript,
    ACTIONS(698), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(712), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(708), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(710), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(730), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(732), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [1436] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_STAR,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(706), 1,
      anon_sym_SLASH,
    STATE(116), 1,
      sym_subscript,
    ACTIONS(712), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(734), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(736), 44,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [1516] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(644), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [1586] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_STAR,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_then,
    ACTIONS(706), 1,
      anon_sym_SLASH,
    STATE(116), 1,
      sym_subscript,
    ACTIONS(698), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(712), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(708), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(710), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(738), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(740), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [1674] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_STAR,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_then,
    ACTIONS(706), 1,
      anon_sym_SLASH,
    STATE(116), 1,
      sym_subscript,
    ACTIONS(698), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(712), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(708), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(710), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(722), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(724), 38,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [1762] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_STAR,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_then,
    ACTIONS(706), 1,
      anon_sym_SLASH,
    STATE(116), 1,
      sym_subscript,
    ACTIONS(698), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(712), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(708), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(710), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(742), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(744), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [1850] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 1,
      anon_sym_LPAREN,
    STATE(6), 1,
      sym_parameter_list,
    ACTIONS(156), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(158), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [1924] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    STATE(116), 1,
      sym_subscript,
    ACTIONS(746), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(748), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [1998] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(136), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(138), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [2067] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(574), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(576), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [2136] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(752), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [2205] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(756), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [2274] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(760), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [2343] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(764), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [2412] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_STAR,
    ACTIONS(770), 1,
      anon_sym_then,
    ACTIONS(774), 1,
      anon_sym_SLASH,
    STATE(174), 1,
      sym_subscript,
    ACTIONS(766), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(778), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(772), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(776), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(742), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(744), 36,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [2499] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_STAR,
    ACTIONS(770), 1,
      anon_sym_then,
    ACTIONS(774), 1,
      anon_sym_SLASH,
    STATE(174), 1,
      sym_subscript,
    ACTIONS(766), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(778), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(772), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(776), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(730), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(732), 36,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [2586] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(306), 1,
      anon_sym_LPAREN,
    STATE(29), 1,
      sym_parameter_list,
    ACTIONS(156), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(158), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [2659] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(784), 1,
      anon_sym_else,
    ACTIONS(780), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(782), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [2730] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    STATE(174), 1,
      sym_subscript,
    ACTIONS(722), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(724), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [2803] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    STATE(174), 1,
      sym_subscript,
    ACTIONS(694), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(696), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [2876] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(788), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [2945] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(644), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3014] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(640), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3083] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_STAR,
    ACTIONS(770), 1,
      anon_sym_then,
    ACTIONS(774), 1,
      anon_sym_SLASH,
    STATE(174), 1,
      sym_subscript,
    ACTIONS(766), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(778), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(772), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(776), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(722), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(724), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [3170] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(792), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3239] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(796), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3308] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(800), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3377] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(804), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3446] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(808), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3515] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(812), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3584] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    STATE(174), 1,
      sym_subscript,
    ACTIONS(746), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(748), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3657] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(816), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3726] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_STAR,
    ACTIONS(774), 1,
      anon_sym_SLASH,
    STATE(174), 1,
      sym_subscript,
    ACTIONS(778), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(734), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(736), 43,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [3805] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(820), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3874] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(782), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3943] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(824), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4012] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_STAR,
    ACTIONS(774), 1,
      anon_sym_SLASH,
    STATE(174), 1,
      sym_subscript,
    ACTIONS(778), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(714), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(716), 43,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [4091] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    STATE(174), 1,
      sym_subscript,
    ACTIONS(718), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(720), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4164] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(826), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(828), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4233] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_STAR,
    ACTIONS(774), 1,
      anon_sym_SLASH,
    STATE(174), 1,
      sym_subscript,
    ACTIONS(778), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(718), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(720), 43,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [4312] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    STATE(174), 1,
      sym_subscript,
    ACTIONS(714), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(716), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4385] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(830), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(832), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4454] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(808), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4523] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_STAR,
    ACTIONS(770), 1,
      anon_sym_then,
    ACTIONS(774), 1,
      anon_sym_SLASH,
    STATE(174), 1,
      sym_subscript,
    ACTIONS(766), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(778), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(772), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(776), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(726), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(728), 36,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [4610] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(836), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4679] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(608), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4748] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(840), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4817] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(844), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4886] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(848), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4955] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(650), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(652), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5024] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(850), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(852), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5093] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(854), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(856), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5162] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(858), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(860), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5231] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(864), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5300] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(868), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5369] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_STAR,
    ACTIONS(770), 1,
      anon_sym_then,
    ACTIONS(774), 1,
      anon_sym_SLASH,
    STATE(174), 1,
      sym_subscript,
    ACTIONS(766), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(778), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(772), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(776), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(738), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(740), 36,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [5456] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(872), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5525] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_STAR,
    ACTIONS(770), 1,
      anon_sym_then,
    ACTIONS(774), 1,
      anon_sym_SLASH,
    STATE(174), 1,
      sym_subscript,
    ACTIONS(766), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(778), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(772), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(776), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(694), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(696), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [5612] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(874), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(876), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5681] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(878), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(880), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5750] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(884), 47,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5819] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(872), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5887] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(868), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5955] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(816), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6023] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(820), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6091] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(812), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6159] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(884), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6227] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(570), 14,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_handler_propagation,
      anon_sym_DOLLAR,
    ACTIONS(572), 46,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
      anon_sym_failed,
      anon_sym_succeeded,
      anon_sym_exited,
  [6295] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(808), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6363] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(650), 14,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_handler_propagation,
      anon_sym_DOLLAR,
    ACTIONS(652), 46,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
      anon_sym_failed,
      anon_sym_succeeded,
      anon_sym_exited,
  [6431] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(764), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6499] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(808), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6567] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(840), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6635] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(796), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6703] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(844), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6771] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(830), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(832), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6839] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(824), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6907] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(874), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(876), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6975] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(848), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7043] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(854), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(856), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7111] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(760), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7179] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(756), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7247] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(804), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7315] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(792), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7383] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(800), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7451] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(826), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(828), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(850), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(852), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7587] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(836), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7655] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(752), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7723] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 14,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_handler_propagation,
      anon_sym_DOLLAR,
    ACTIONS(644), 46,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
      anon_sym_failed,
      anon_sym_succeeded,
      anon_sym_exited,
  [7791] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(878), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(880), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7859] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(858), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(860), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7927] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(788), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7995] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(864), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [8063] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(136), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(138), 46,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [8131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(570), 14,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_handler_propagation,
      anon_sym_DOLLAR,
    ACTIONS(572), 45,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
      anon_sym_failed,
      anon_sym_succeeded,
      anon_sym_exited,
  [8198] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(650), 14,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_handler_propagation,
      anon_sym_DOLLAR,
    ACTIONS(652), 45,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
      anon_sym_failed,
      anon_sym_succeeded,
      anon_sym_exited,
  [8265] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 14,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_handler_propagation,
      anon_sym_DOLLAR,
    ACTIONS(644), 45,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
      anon_sym_failed,
      anon_sym_succeeded,
      anon_sym_exited,
  [8332] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      anon_sym_STAR,
    ACTIONS(890), 1,
      anon_sym_LBRACK,
    ACTIONS(892), 1,
      anon_sym_then,
    ACTIONS(896), 1,
      anon_sym_SLASH,
    STATE(250), 1,
      sym_subscript,
    ACTIONS(886), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(900), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(894), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(898), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(726), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(728), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [8415] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACK,
    STATE(250), 1,
      sym_subscript,
    ACTIONS(714), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(716), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [8484] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      anon_sym_STAR,
    ACTIONS(890), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_SLASH,
    STATE(250), 1,
      sym_subscript,
    ACTIONS(900), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(718), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(720), 40,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [8559] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACK,
    STATE(250), 1,
      sym_subscript,
    ACTIONS(718), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(720), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [8628] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      anon_sym_STAR,
    ACTIONS(890), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_SLASH,
    STATE(250), 1,
      sym_subscript,
    ACTIONS(900), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(714), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(716), 40,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [8703] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      anon_sym_STAR,
    ACTIONS(890), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_SLASH,
    STATE(250), 1,
      sym_subscript,
    ACTIONS(900), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(734), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(736), 40,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [8778] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      anon_sym_STAR,
    ACTIONS(890), 1,
      anon_sym_LBRACK,
    ACTIONS(892), 1,
      anon_sym_then,
    ACTIONS(896), 1,
      anon_sym_SLASH,
    STATE(250), 1,
      sym_subscript,
    ACTIONS(886), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(900), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(894), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(898), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(694), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(696), 34,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [8861] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      anon_sym_STAR,
    ACTIONS(890), 1,
      anon_sym_LBRACK,
    ACTIONS(892), 1,
      anon_sym_then,
    ACTIONS(896), 1,
      anon_sym_SLASH,
    STATE(250), 1,
      sym_subscript,
    ACTIONS(886), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(900), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(894), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(898), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(742), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(744), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [8944] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      anon_sym_STAR,
    ACTIONS(890), 1,
      anon_sym_LBRACK,
    ACTIONS(892), 1,
      anon_sym_then,
    ACTIONS(896), 1,
      anon_sym_SLASH,
    STATE(250), 1,
      sym_subscript,
    ACTIONS(886), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(900), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(894), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(898), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(738), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(740), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [9027] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACK,
    STATE(250), 1,
      sym_subscript,
    ACTIONS(722), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(724), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9096] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACK,
    STATE(250), 1,
      sym_subscript,
    ACTIONS(746), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(748), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9165] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACK,
    STATE(250), 1,
      sym_subscript,
    ACTIONS(694), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(696), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9234] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      anon_sym_STAR,
    ACTIONS(890), 1,
      anon_sym_LBRACK,
    ACTIONS(892), 1,
      anon_sym_then,
    ACTIONS(896), 1,
      anon_sym_SLASH,
    STATE(250), 1,
      sym_subscript,
    ACTIONS(886), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(900), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(894), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(898), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(722), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(724), 34,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [9317] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 1,
      anon_sym_LPAREN,
    STATE(70), 1,
      sym_parameter_list,
    ACTIONS(156), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(158), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9386] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      anon_sym_STAR,
    ACTIONS(890), 1,
      anon_sym_LBRACK,
    ACTIONS(892), 1,
      anon_sym_then,
    ACTIONS(896), 1,
      anon_sym_SLASH,
    STATE(250), 1,
      sym_subscript,
    ACTIONS(886), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(900), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(894), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(898), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(730), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(732), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [9469] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(608), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9533] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      anon_sym_STAR,
    ACTIONS(904), 1,
      anon_sym_LBRACK,
    ACTIONS(906), 1,
      anon_sym_SLASH,
    STATE(282), 1,
      sym_subscript,
    ACTIONS(908), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(714), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(716), 39,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [9607] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(752), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9671] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(788), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9735] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(844), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9799] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 1,
      anon_sym_LBRACK,
    STATE(282), 1,
      sym_subscript,
    ACTIONS(694), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(696), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(872), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9931] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(640), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9995] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(884), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10059] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(878), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(880), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10123] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(868), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10187] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(858), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(860), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10251] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(848), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10315] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(836), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10379] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(850), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(852), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10443] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(808), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10507] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(756), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10571] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      anon_sym_STAR,
    ACTIONS(904), 1,
      anon_sym_LBRACK,
    ACTIONS(906), 1,
      anon_sym_SLASH,
    STATE(282), 1,
      sym_subscript,
    ACTIONS(908), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(734), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(736), 39,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [10645] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(760), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10709] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(830), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(832), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10773] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(764), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10837] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(854), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(856), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10901] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(644), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10965] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(650), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(652), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11029] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 1,
      anon_sym_LBRACK,
    STATE(282), 1,
      sym_subscript,
    ACTIONS(714), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(716), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11097] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      anon_sym_STAR,
    ACTIONS(904), 1,
      anon_sym_LBRACK,
    ACTIONS(906), 1,
      anon_sym_SLASH,
    STATE(282), 1,
      sym_subscript,
    ACTIONS(908), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(718), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(720), 39,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [11171] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 1,
      anon_sym_LBRACK,
    STATE(282), 1,
      sym_subscript,
    ACTIONS(718), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(720), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11239] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(840), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11303] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(136), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(138), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11367] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(820), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11431] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(816), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11495] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 1,
      anon_sym_LBRACK,
    STATE(282), 1,
      sym_subscript,
    ACTIONS(722), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(724), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11563] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(864), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11627] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      anon_sym_STAR,
    ACTIONS(904), 1,
      anon_sym_LBRACK,
    ACTIONS(906), 1,
      anon_sym_SLASH,
    ACTIONS(910), 1,
      anon_sym_SEMI,
    ACTIONS(914), 1,
      anon_sym_then,
    STATE(282), 1,
      sym_subscript,
    ACTIONS(908), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(912), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(916), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(738), 5,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(918), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(740), 32,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [11711] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(826), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(828), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11775] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(874), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(876), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11839] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      anon_sym_STAR,
    ACTIONS(904), 1,
      anon_sym_LBRACK,
    ACTIONS(906), 1,
      anon_sym_SLASH,
    ACTIONS(914), 1,
      anon_sym_then,
    STATE(282), 1,
      sym_subscript,
    ACTIONS(908), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(912), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(916), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(918), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(742), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(744), 32,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [11921] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 1,
      anon_sym_else,
    ACTIONS(780), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(782), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11987] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      anon_sym_STAR,
    ACTIONS(904), 1,
      anon_sym_LBRACK,
    ACTIONS(906), 1,
      anon_sym_SLASH,
    ACTIONS(914), 1,
      anon_sym_then,
    STATE(282), 1,
      sym_subscript,
    ACTIONS(908), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(912), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(916), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(918), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(730), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(732), 32,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [12069] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(824), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12133] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(812), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12197] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 1,
      anon_sym_LBRACK,
    STATE(282), 1,
      sym_subscript,
    ACTIONS(746), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(748), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12265] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      anon_sym_STAR,
    ACTIONS(904), 1,
      anon_sym_LBRACK,
    ACTIONS(906), 1,
      anon_sym_SLASH,
    ACTIONS(914), 1,
      anon_sym_then,
    STATE(282), 1,
      sym_subscript,
    ACTIONS(908), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(912), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(916), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(918), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(738), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(740), 32,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [12347] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(808), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12411] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(684), 1,
      anon_sym_LPAREN,
    STATE(75), 1,
      sym_parameter_list,
    ACTIONS(156), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(158), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12479] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(782), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12543] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(804), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12607] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(800), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12671] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(796), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12735] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      anon_sym_STAR,
    ACTIONS(904), 1,
      anon_sym_LBRACK,
    ACTIONS(906), 1,
      anon_sym_SLASH,
    ACTIONS(914), 1,
      anon_sym_then,
    STATE(282), 1,
      sym_subscript,
    ACTIONS(908), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(912), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(916), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(918), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(694), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(696), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [12817] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      anon_sym_STAR,
    ACTIONS(904), 1,
      anon_sym_LBRACK,
    ACTIONS(906), 1,
      anon_sym_SLASH,
    ACTIONS(914), 1,
      anon_sym_then,
    STATE(282), 1,
      sym_subscript,
    ACTIONS(908), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(912), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(916), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(918), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(726), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(728), 32,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [12899] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(574), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(576), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12963] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      anon_sym_STAR,
    ACTIONS(904), 1,
      anon_sym_LBRACK,
    ACTIONS(906), 1,
      anon_sym_SLASH,
    ACTIONS(914), 1,
      anon_sym_then,
    STATE(282), 1,
      sym_subscript,
    ACTIONS(908), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(912), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(916), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(918), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(722), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(724), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [13045] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(792), 43,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13109] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(640), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13172] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(848), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13235] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(764), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13298] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(840), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13361] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(608), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13424] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(136), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(138), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13487] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(864), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13550] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(874), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(876), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13613] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(808), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13676] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(820), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13739] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(796), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13802] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(760), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13865] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(756), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13928] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(816), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13991] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(792), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14054] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(850), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(852), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14117] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(752), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14180] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(830), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(832), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14243] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(788), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14306] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(854), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(856), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14369] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(812), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14432] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(844), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14495] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(808), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14558] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(872), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14621] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(804), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14684] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(800), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14747] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(574), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(576), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14810] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(884), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14873] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(878), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(880), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14936] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(868), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14999] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(644), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15062] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(858), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(860), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15125] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(836), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15188] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(650), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(652), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15251] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(826), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(828), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15314] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(824), 42,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15377] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    ACTIONS(922), 1,
      anon_sym_LPAREN,
    ACTIONS(924), 1,
      anon_sym_EQ,
    STATE(296), 1,
      sym_parameter_list,
    STATE(975), 1,
      sym_subscript,
    ACTIONS(926), 5,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(156), 8,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(158), 31,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15446] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 1,
      anon_sym_failed,
    ACTIONS(930), 1,
      anon_sym_succeeded,
    ACTIONS(932), 1,
      anon_sym_exited,
    ACTIONS(934), 1,
      sym_handler_propagation,
    STATE(414), 1,
      sym_handler,
    STATE(432), 3,
      sym_handler_failed,
      sym_handler_succeeded,
      sym_handler_exited,
    ACTIONS(136), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(138), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15515] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 1,
      anon_sym_failed,
    ACTIONS(930), 1,
      anon_sym_succeeded,
    ACTIONS(932), 1,
      anon_sym_exited,
    ACTIONS(934), 1,
      sym_handler_propagation,
    STATE(430), 1,
      sym_handler,
    STATE(432), 3,
      sym_handler_failed,
      sym_handler_succeeded,
      sym_handler_exited,
    ACTIONS(148), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(150), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15584] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 1,
      anon_sym_failed,
    ACTIONS(930), 1,
      anon_sym_succeeded,
    ACTIONS(932), 1,
      anon_sym_exited,
    ACTIONS(934), 1,
      sym_handler_propagation,
    STATE(387), 1,
      sym_handler,
    STATE(432), 3,
      sym_handler_failed,
      sym_handler_succeeded,
      sym_handler_exited,
    ACTIONS(152), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(154), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15653] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_LBRACK,
    ACTIONS(922), 1,
      anon_sym_LPAREN,
    ACTIONS(936), 1,
      anon_sym_EQ,
    STATE(296), 1,
      sym_parameter_list,
    STATE(972), 1,
      sym_subscript,
    ACTIONS(938), 5,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(156), 8,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(158), 31,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15722] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(752), 38,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [15776] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(788), 38,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [15830] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(872), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [15884] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 1,
      anon_sym_else,
    ACTIONS(780), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(782), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [15940] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(752), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [15994] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(884), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16048] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(826), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(828), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16102] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(764), 38,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16156] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(788), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16210] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(824), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16264] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(760), 38,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16318] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(858), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(860), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16372] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(756), 38,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16426] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(764), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16480] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(868), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16534] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(836), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(782), 38,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16642] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(756), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16696] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(942), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(944), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16750] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(872), 38,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16804] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(884), 38,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16858] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(878), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(880), 38,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16912] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(878), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(880), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [16966] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(868), 38,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17020] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(858), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(860), 38,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17074] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(836), 38,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17128] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(760), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17182] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(826), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(828), 38,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17236] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(824), 38,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17290] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(946), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(948), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17343] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(950), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(952), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17396] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(570), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_handler_propagation,
      anon_sym_DOLLAR,
    ACTIONS(572), 32,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
      anon_sym_failed,
      anon_sym_succeeded,
      anon_sym_exited,
  [17449] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 1,
      anon_sym_SEMI,
    ACTIONS(954), 7,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(958), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17504] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(962), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17557] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(964), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(966), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17610] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(970), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17663] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(974), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17716] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_handler_propagation,
      anon_sym_DOLLAR,
    ACTIONS(644), 32,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
      anon_sym_failed,
      anon_sym_succeeded,
      anon_sym_exited,
  [17769] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(864), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17822] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(978), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17875] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(982), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17928] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(874), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(876), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [17981] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(650), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_handler_propagation,
      anon_sym_DOLLAR,
    ACTIONS(652), 32,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
      anon_sym_failed,
      anon_sym_succeeded,
      anon_sym_exited,
  [18034] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(986), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [18087] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(990), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [18140] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(994), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [18193] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(998), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [18246] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(1002), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [18299] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 7,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(1006), 37,
      anon_sym_main,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [18351] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1008), 1,
      anon_sym_RBRACE,
    ACTIONS(1010), 1,
      anon_sym_else,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(357), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [18429] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_LBRACK,
    STATE(436), 1,
      sym_subscript,
    ACTIONS(694), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(696), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [18483] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1026), 1,
      anon_sym_RBRACE,
    ACTIONS(1028), 1,
      anon_sym_else,
    STATE(381), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [18561] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_LBRACK,
    STATE(436), 1,
      sym_subscript,
    ACTIONS(746), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(748), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [18615] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1030), 1,
      anon_sym_RBRACE,
    ACTIONS(1032), 1,
      anon_sym_else,
    STATE(349), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [18693] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_LBRACK,
    ACTIONS(1036), 1,
      anon_sym_STAR,
    ACTIONS(1038), 1,
      anon_sym_then,
    ACTIONS(1042), 1,
      anon_sym_SLASH,
    STATE(436), 1,
      sym_subscript,
    ACTIONS(1034), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1046), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1040), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(730), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(1044), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(732), 19,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [18761] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1048), 1,
      anon_sym_RBRACE,
    ACTIONS(1050), 1,
      anon_sym_else,
    STATE(381), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [18839] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_LBRACK,
    ACTIONS(1036), 1,
      anon_sym_STAR,
    ACTIONS(1038), 1,
      anon_sym_then,
    ACTIONS(1042), 1,
      anon_sym_SLASH,
    STATE(436), 1,
      sym_subscript,
    ACTIONS(1034), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1046), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1040), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(742), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(1044), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(744), 19,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [18907] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 1,
      anon_sym_LPAREN,
    STATE(296), 1,
      sym_parameter_list,
    ACTIONS(156), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(158), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [18961] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1052), 1,
      anon_sym_RBRACE,
    ACTIONS(1054), 1,
      anon_sym_else,
    STATE(353), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [19039] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1056), 1,
      anon_sym_RBRACE,
    ACTIONS(1058), 1,
      anon_sym_else,
    STATE(381), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [19117] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1060), 1,
      anon_sym_RBRACE,
    ACTIONS(1062), 1,
      anon_sym_else,
    STATE(381), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [19195] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1064), 1,
      anon_sym_RBRACE,
    ACTIONS(1066), 1,
      anon_sym_else,
    STATE(381), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [19273] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1068), 1,
      anon_sym_RBRACE,
    ACTIONS(1070), 1,
      anon_sym_else,
    STATE(358), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [19351] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1072), 1,
      anon_sym_RBRACE,
    ACTIONS(1074), 1,
      anon_sym_else,
    STATE(381), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [19429] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1076), 1,
      anon_sym_RBRACE,
    ACTIONS(1078), 1,
      anon_sym_else,
    STATE(361), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [19507] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1080), 1,
      anon_sym_RBRACE,
    ACTIONS(1082), 1,
      anon_sym_else,
    STATE(359), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [19585] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_LBRACK,
    ACTIONS(1036), 1,
      anon_sym_STAR,
    ACTIONS(1038), 1,
      anon_sym_then,
    ACTIONS(1042), 1,
      anon_sym_SLASH,
    ACTIONS(1084), 1,
      anon_sym_SEMI,
    STATE(436), 1,
      sym_subscript,
    ACTIONS(1034), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1046), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(738), 4,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(1040), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1044), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(740), 19,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [19655] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1086), 1,
      anon_sym_RBRACE,
    ACTIONS(1088), 1,
      anon_sym_else,
    STATE(369), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [19733] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_LBRACK,
    ACTIONS(1036), 1,
      anon_sym_STAR,
    ACTIONS(1042), 1,
      anon_sym_SLASH,
    STATE(436), 1,
      sym_subscript,
    ACTIONS(1046), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(714), 10,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(716), 26,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [19793] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_LBRACK,
    ACTIONS(1036), 1,
      anon_sym_STAR,
    ACTIONS(1042), 1,
      anon_sym_SLASH,
    STATE(436), 1,
      sym_subscript,
    ACTIONS(1046), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(734), 10,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(736), 26,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [19853] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_LBRACK,
    STATE(436), 1,
      sym_subscript,
    ACTIONS(722), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(724), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [19907] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1090), 1,
      anon_sym_RBRACE,
    ACTIONS(1092), 1,
      anon_sym_else,
    STATE(381), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [19985] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1094), 1,
      anon_sym_RBRACE,
    ACTIONS(1096), 1,
      anon_sym_else,
    STATE(381), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [20063] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1098), 1,
      anon_sym_RBRACE,
    ACTIONS(1100), 1,
      anon_sym_else,
    STATE(370), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [20141] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1102), 1,
      anon_sym_RBRACE,
    ACTIONS(1104), 1,
      anon_sym_else,
    STATE(381), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [20219] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1106), 1,
      anon_sym_RBRACE,
    ACTIONS(1108), 1,
      anon_sym_else,
    STATE(372), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [20297] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1110), 1,
      anon_sym_RBRACE,
    ACTIONS(1112), 1,
      anon_sym_else,
    STATE(380), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [20375] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_LBRACK,
    STATE(436), 1,
      sym_subscript,
    ACTIONS(718), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(720), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20429] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_LBRACK,
    ACTIONS(1036), 1,
      anon_sym_STAR,
    ACTIONS(1038), 1,
      anon_sym_then,
    ACTIONS(1042), 1,
      anon_sym_SLASH,
    STATE(436), 1,
      sym_subscript,
    ACTIONS(1034), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1046), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1040), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(722), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(1044), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(724), 20,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [20497] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_LBRACK,
    ACTIONS(1036), 1,
      anon_sym_STAR,
    ACTIONS(1042), 1,
      anon_sym_SLASH,
    STATE(436), 1,
      sym_subscript,
    ACTIONS(1046), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(718), 10,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(720), 26,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [20557] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_LBRACK,
    ACTIONS(1036), 1,
      anon_sym_STAR,
    ACTIONS(1038), 1,
      anon_sym_then,
    ACTIONS(1042), 1,
      anon_sym_SLASH,
    STATE(436), 1,
      sym_subscript,
    ACTIONS(1034), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1046), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1040), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(738), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(1044), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(740), 19,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [20625] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_LBRACK,
    ACTIONS(1036), 1,
      anon_sym_STAR,
    ACTIONS(1038), 1,
      anon_sym_then,
    ACTIONS(1042), 1,
      anon_sym_SLASH,
    STATE(436), 1,
      sym_subscript,
    ACTIONS(1034), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1046), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1040), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(694), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(1044), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 20,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [20693] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1114), 1,
      anon_sym_RBRACE,
    ACTIONS(1116), 1,
      anon_sym_else,
    STATE(381), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [20771] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1118), 1,
      anon_sym_RBRACE,
    ACTIONS(1120), 1,
      anon_sym_LPAREN,
    ACTIONS(1123), 1,
      anon_sym_LBRACK,
    ACTIONS(1126), 1,
      anon_sym_else,
    ACTIONS(1143), 1,
      sym_variable,
    ACTIONS(1146), 1,
      anon_sym_DQUOTE,
    ACTIONS(1149), 1,
      anon_sym_DOLLAR,
    STATE(381), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1134), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1140), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1128), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1137), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1131), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [20849] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_LBRACK,
    STATE(436), 1,
      sym_subscript,
    ACTIONS(714), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(716), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20903] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1152), 1,
      anon_sym_RBRACE,
    ACTIONS(1154), 1,
      anon_sym_else,
    STATE(385), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [20981] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_LBRACK,
    ACTIONS(1036), 1,
      anon_sym_STAR,
    ACTIONS(1038), 1,
      anon_sym_then,
    ACTIONS(1042), 1,
      anon_sym_SLASH,
    STATE(436), 1,
      sym_subscript,
    ACTIONS(1034), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1046), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1040), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(726), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(1044), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(728), 19,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [21049] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1156), 1,
      anon_sym_RBRACE,
    ACTIONS(1158), 1,
      anon_sym_else,
    STATE(381), 1,
      aux_sym_if_chain_repeat1,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1012), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(857), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [21127] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(826), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(828), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21176] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(820), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21225] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(858), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(860), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21274] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(372), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(943), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(362), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1160), 2,
      anon_sym_LBRACE,
      anon_sym_COLON,
    ACTIONS(366), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(364), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1162), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(716), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [21347] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(868), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21396] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(378), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_DQUOTE,
    ACTIONS(414), 1,
      anon_sym_DOLLAR,
    ACTIONS(1168), 1,
      sym_variable,
    STATE(112), 1,
      sym_type_name_symbol,
    STATE(932), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(404), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1160), 2,
      anon_sym_LBRACE,
      anon_sym_COLON,
    ACTIONS(408), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(406), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1166), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(402), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(97), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [21469] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(878), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(880), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21518] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(884), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21567] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1176), 1,
      sym_variable,
    ACTIONS(1178), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(939), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1160), 2,
      anon_sym_LBRACE,
      anon_sym_COLON,
    ACTIONS(1170), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1174), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1162), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1172), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(716), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [21640] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(872), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21689] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(788), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21738] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(752), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21787] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(756), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21836] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(760), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21885] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(764), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21934] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(854), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(856), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21983] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(782), 34,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [22032] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(824), 34,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [22081] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(826), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(828), 34,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [22130] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(644), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [22179] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(850), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(852), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [22228] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(836), 34,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [22277] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(858), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(860), 34,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [22326] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(868), 34,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [22375] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(878), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(880), 34,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [22424] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    ACTIONS(1182), 1,
      sym_variable,
    STATE(210), 1,
      sym_type_name_symbol,
    STATE(947), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(488), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1160), 2,
      anon_sym_LBRACE,
      anon_sym_COLON,
    ACTIONS(492), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(490), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1180), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(198), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [22497] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(884), 34,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [22546] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1184), 1,
      anon_sym_else,
    ACTIONS(780), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(782), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [22597] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(848), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [22646] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(650), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(652), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [22695] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      anon_sym_LPAREN,
    ACTIONS(184), 1,
      anon_sym_LBRACK,
    ACTIONS(210), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      anon_sym_DOLLAR,
    ACTIONS(1188), 1,
      sym_variable,
    STATE(257), 1,
      sym_type_name_symbol,
    STATE(941), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(202), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1160), 2,
      anon_sym_LBRACE,
      anon_sym_COLON,
    ACTIONS(206), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(204), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1186), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(200), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(244), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [22768] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(872), 34,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [22817] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(824), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [22866] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(788), 34,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [22915] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(752), 34,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [22964] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(756), 34,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [23013] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(760), 34,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [23062] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(844), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [23111] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(764), 34,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [23160] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(840), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [23209] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(608), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [23258] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(782), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [23307] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(808), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [23356] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(830), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(832), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [23405] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(136), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(138), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [23454] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(836), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [23503] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(816), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [23552] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(812), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [23601] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(808), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [23650] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(804), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [23699] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(800), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [23748] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(864), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [23797] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(796), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [23846] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1160), 2,
      anon_sym_LBRACE,
      anon_sym_COLON,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1162), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(716), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [23919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(574), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(576), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [23968] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(442), 1,
      anon_sym_DOLLAR,
    ACTIONS(1190), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(946), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(434), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1160), 2,
      anon_sym_LBRACE,
      anon_sym_COLON,
    ACTIONS(438), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(436), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1162), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(716), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [24041] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(874), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(876), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [24090] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    ACTIONS(510), 1,
      anon_sym_LBRACK,
    ACTIONS(536), 1,
      anon_sym_DQUOTE,
    ACTIONS(538), 1,
      anon_sym_DOLLAR,
    ACTIONS(1194), 1,
      sym_variable,
    STATE(445), 1,
      sym_type_name_symbol,
    STATE(929), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(528), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1160), 2,
      anon_sym_LBRACE,
      anon_sym_COLON,
    ACTIONS(532), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(530), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1192), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(526), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(350), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [24163] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(792), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [24212] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(640), 29,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [24261] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_DOLLAR,
    ACTIONS(1198), 1,
      sym_variable,
    STATE(62), 1,
      sym_type_name_symbol,
    STATE(945), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(45), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1160), 2,
      anon_sym_LBRACE,
      anon_sym_COLON,
    ACTIONS(49), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(47), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1196), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(43), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(120), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [24334] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1200), 1,
      anon_sym_LBRACE,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1202), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(790), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [24406] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(868), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [24454] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1204), 1,
      anon_sym_RPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1206), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(862), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [24526] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(442), 1,
      anon_sym_DOLLAR,
    ACTIONS(1190), 1,
      sym_variable,
    ACTIONS(1208), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(762), 1,
      sym_parameter_list,
    STATE(946), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(434), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(438), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(436), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1162), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(716), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [24598] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1210), 1,
      anon_sym_LBRACE,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1212), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(789), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [24670] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(878), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(880), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [24718] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(510), 1,
      anon_sym_LBRACK,
    ACTIONS(536), 1,
      anon_sym_DQUOTE,
    ACTIONS(538), 1,
      anon_sym_DOLLAR,
    ACTIONS(1194), 1,
      sym_variable,
    ACTIONS(1214), 1,
      anon_sym_LPAREN,
    STATE(438), 1,
      sym_parameter_list,
    STATE(445), 1,
      sym_type_name_symbol,
    STATE(929), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(528), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(532), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(530), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1192), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(526), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(350), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [24790] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1216), 1,
      anon_sym_RBRACK,
    STATE(891), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1218), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(845), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [24862] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1220), 1,
      anon_sym_RBRACK,
    STATE(891), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1222), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(815), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [24934] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1224), 1,
      anon_sym_LBRACE,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1226), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(854), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [25006] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1228), 1,
      anon_sym_LBRACE,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1230), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(847), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [25078] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1232), 1,
      anon_sym_LBRACE,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1234), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(829), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [25150] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1236), 1,
      anon_sym_RPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1238), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(795), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [25222] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1240), 1,
      anon_sym_LBRACE,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1242), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(784), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [25294] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1244), 1,
      anon_sym_RPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1246), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(816), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [25366] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1208), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(762), 1,
      sym_parameter_list,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1162), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(716), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [25438] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1248), 1,
      anon_sym_RBRACK,
    STATE(891), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1250), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(818), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [25510] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(764), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [25558] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(752), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [25606] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(910), 1,
      anon_sym_SEMI,
    ACTIONS(738), 6,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(740), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [25656] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1252), 1,
      anon_sym_RPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1254), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(801), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [25728] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1256), 1,
      anon_sym_LBRACE,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1258), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(835), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [25800] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1260), 1,
      anon_sym_LBRACE,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1262), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(842), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [25872] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1228), 1,
      anon_sym_LBRACE,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1264), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(785), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [25944] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(760), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [25992] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1266), 1,
      anon_sym_LBRACE,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1268), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(806), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [26064] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1256), 1,
      anon_sym_LBRACE,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1270), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(820), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [26136] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1252), 1,
      anon_sym_RPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1272), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(794), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [26208] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(942), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(944), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [26256] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1274), 1,
      anon_sym_LBRACE,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1276), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(792), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [26328] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1278), 1,
      anon_sym_RPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1280), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(859), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [26400] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(756), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [26448] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1282), 1,
      anon_sym_RBRACK,
    STATE(891), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1284), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(826), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [26520] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1286), 1,
      anon_sym_RPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1288), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(839), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [26592] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1290), 1,
      anon_sym_RPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1292), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(796), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [26664] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(884), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [26712] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1294), 1,
      anon_sym_RBRACK,
    STATE(891), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1296), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(861), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [26784] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1298), 1,
      anon_sym_RBRACK,
    STATE(891), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1300), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(802), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [26856] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1302), 1,
      anon_sym_LBRACE,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1304), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(803), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [26928] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(858), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(860), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [26976] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1306), 1,
      anon_sym_RPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1308), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(853), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [27048] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(836), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [27096] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1244), 1,
      anon_sym_RPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1310), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(860), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [27168] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1312), 1,
      anon_sym_RPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1314), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(858), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [27240] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    ACTIONS(1182), 1,
      sym_variable,
    ACTIONS(1316), 1,
      anon_sym_LPAREN,
    STATE(210), 1,
      sym_type_name_symbol,
    STATE(251), 1,
      sym_parameter_list,
    STATE(947), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(488), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(492), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(490), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1180), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(198), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [27312] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(826), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(828), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [27360] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1228), 1,
      anon_sym_LBRACE,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1318), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(837), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [27432] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(372), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      sym_variable,
    ACTIONS(1208), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(762), 1,
      sym_parameter_list,
    STATE(943), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(362), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(366), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(364), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1162), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(716), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [27504] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(872), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [27552] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_DOLLAR,
    ACTIONS(1198), 1,
      sym_variable,
    ACTIONS(1320), 1,
      anon_sym_LPAREN,
    STATE(62), 1,
      sym_type_name_symbol,
    STATE(163), 1,
      sym_parameter_list,
    STATE(945), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(45), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(49), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(47), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1196), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(43), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(120), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [27624] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(824), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [27672] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1322), 1,
      anon_sym_RPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1324), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(852), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [27744] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(184), 1,
      anon_sym_LBRACK,
    ACTIONS(210), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      anon_sym_DOLLAR,
    ACTIONS(1188), 1,
      sym_variable,
    ACTIONS(1326), 1,
      anon_sym_LPAREN,
    STATE(257), 1,
      sym_type_name_symbol,
    STATE(267), 1,
      sym_parameter_list,
    STATE(941), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(202), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(206), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(204), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1186), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(200), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(244), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [27816] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    ACTIONS(1328), 1,
      anon_sym_RPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1330), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(840), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [27888] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(788), 33,
      anon_sym_cd,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_mv,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_const,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
      anon_sym_nameof,
      sym_variable,
  [27936] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(386), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_DQUOTE,
    ACTIONS(414), 1,
      anon_sym_DOLLAR,
    ACTIONS(1168), 1,
      sym_variable,
    ACTIONS(1332), 1,
      anon_sym_LPAREN,
    STATE(112), 1,
      sym_type_name_symbol,
    STATE(115), 1,
      sym_parameter_list,
    STATE(932), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(404), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(408), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(406), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1166), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(402), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(97), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [28008] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1176), 1,
      sym_variable,
    ACTIONS(1178), 1,
      anon_sym_DOLLAR,
    ACTIONS(1208), 1,
      anon_sym_LPAREN,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(762), 1,
      sym_parameter_list,
    STATE(939), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1170), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1174), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1162), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1172), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(716), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [28080] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1334), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(799), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [28149] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1336), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(828), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [28218] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    ACTIONS(510), 1,
      anon_sym_LBRACK,
    ACTIONS(536), 1,
      anon_sym_DQUOTE,
    ACTIONS(538), 1,
      anon_sym_DOLLAR,
    ACTIONS(1194), 1,
      sym_variable,
    STATE(445), 1,
      sym_type_name_symbol,
    STATE(929), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(528), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(532), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(530), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1338), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(526), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(367), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [28287] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1340), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(877), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [28356] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1176), 1,
      sym_variable,
    ACTIONS(1178), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(939), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1170), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1174), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1172), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1342), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(886), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [28425] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    ACTIONS(1182), 1,
      sym_variable,
    STATE(210), 1,
      sym_type_name_symbol,
    STATE(947), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(488), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(492), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(490), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1180), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(198), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [28494] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1344), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(804), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [28563] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1346), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(805), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [28632] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1348), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(811), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [28701] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(372), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(943), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(362), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(366), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(364), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1350), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(705), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [28770] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(372), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(943), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(362), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(366), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(364), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1352), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(706), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [28839] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    ACTIONS(510), 1,
      anon_sym_LBRACK,
    ACTIONS(536), 1,
      anon_sym_DQUOTE,
    ACTIONS(538), 1,
      anon_sym_DOLLAR,
    ACTIONS(1194), 1,
      sym_variable,
    STATE(445), 1,
      sym_type_name_symbol,
    STATE(929), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(528), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(532), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(530), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1354), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(526), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(352), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [28908] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(372), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(943), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(362), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(366), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(364), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1356), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(830), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [28977] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(372), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(943), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(362), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(366), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(364), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1358), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(831), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [29046] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    ACTIONS(510), 1,
      anon_sym_LBRACK,
    ACTIONS(536), 1,
      anon_sym_DQUOTE,
    ACTIONS(538), 1,
      anon_sym_DOLLAR,
    ACTIONS(1194), 1,
      sym_variable,
    STATE(445), 1,
      sym_type_name_symbol,
    STATE(929), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(528), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(532), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(530), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1360), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(526), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(354), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [29115] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    ACTIONS(510), 1,
      anon_sym_LBRACK,
    ACTIONS(536), 1,
      anon_sym_DQUOTE,
    ACTIONS(538), 1,
      anon_sym_DOLLAR,
    ACTIONS(1194), 1,
      sym_variable,
    STATE(445), 1,
      sym_type_name_symbol,
    STATE(929), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(528), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(532), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(530), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1362), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(526), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(379), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [29184] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(372), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(943), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(362), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(366), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(364), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1364), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(718), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [29253] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_DOLLAR,
    ACTIONS(1198), 1,
      sym_variable,
    STATE(62), 1,
      sym_type_name_symbol,
    STATE(945), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(45), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(49), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(47), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1366), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(43), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(122), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [29322] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    ACTIONS(510), 1,
      anon_sym_LBRACK,
    ACTIONS(536), 1,
      anon_sym_DQUOTE,
    ACTIONS(538), 1,
      anon_sym_DOLLAR,
    ACTIONS(1194), 1,
      sym_variable,
    STATE(445), 1,
      sym_type_name_symbol,
    STATE(929), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(528), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(532), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(530), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1368), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(526), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(382), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [29391] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    ACTIONS(1182), 1,
      sym_variable,
    STATE(210), 1,
      sym_type_name_symbol,
    STATE(947), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(488), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(492), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(490), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1370), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(192), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [29460] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    ACTIONS(1182), 1,
      sym_variable,
    STATE(210), 1,
      sym_type_name_symbol,
    STATE(947), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(488), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(492), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(490), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1372), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(191), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [29529] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    ACTIONS(1182), 1,
      sym_variable,
    STATE(210), 1,
      sym_type_name_symbol,
    STATE(947), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(488), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(492), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(490), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1374), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(190), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [29598] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    ACTIONS(1182), 1,
      sym_variable,
    STATE(210), 1,
      sym_type_name_symbol,
    STATE(947), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(488), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(492), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(490), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1376), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(189), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [29667] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(372), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(943), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(362), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(366), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(364), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1378), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(704), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [29736] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(372), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(943), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(362), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(366), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(364), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1380), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(732), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [29805] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    ACTIONS(510), 1,
      anon_sym_LBRACK,
    ACTIONS(536), 1,
      anon_sym_DQUOTE,
    ACTIONS(538), 1,
      anon_sym_DOLLAR,
    ACTIONS(1194), 1,
      sym_variable,
    STATE(445), 1,
      sym_type_name_symbol,
    STATE(929), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(528), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(532), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(530), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1382), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(526), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(377), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [29874] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    ACTIONS(1182), 1,
      sym_variable,
    STATE(210), 1,
      sym_type_name_symbol,
    STATE(947), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(488), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(492), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(490), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1384), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(188), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [29943] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    ACTIONS(510), 1,
      anon_sym_LBRACK,
    ACTIONS(536), 1,
      anon_sym_DQUOTE,
    ACTIONS(538), 1,
      anon_sym_DOLLAR,
    ACTIONS(1194), 1,
      sym_variable,
    STATE(445), 1,
      sym_type_name_symbol,
    STATE(929), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(528), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(532), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(530), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1386), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(526), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(375), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [30012] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    ACTIONS(510), 1,
      anon_sym_LBRACK,
    ACTIONS(536), 1,
      anon_sym_DQUOTE,
    ACTIONS(538), 1,
      anon_sym_DOLLAR,
    ACTIONS(1194), 1,
      sym_variable,
    STATE(445), 1,
      sym_type_name_symbol,
    STATE(929), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(528), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(532), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(530), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1388), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(526), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(366), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [30081] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    ACTIONS(510), 1,
      anon_sym_LBRACK,
    ACTIONS(536), 1,
      anon_sym_DQUOTE,
    ACTIONS(538), 1,
      anon_sym_DOLLAR,
    ACTIONS(1194), 1,
      sym_variable,
    STATE(445), 1,
      sym_type_name_symbol,
    STATE(929), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(528), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(532), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(530), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1390), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(526), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(376), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [30150] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1392), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(823), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [30219] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1176), 1,
      sym_variable,
    ACTIONS(1178), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(939), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1170), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1174), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1172), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1394), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(905), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [30288] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1396), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(833), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [30357] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1176), 1,
      sym_variable,
    ACTIONS(1178), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(939), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1170), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1174), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1172), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1398), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(711), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [30426] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1176), 1,
      sym_variable,
    ACTIONS(1178), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(939), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1170), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1174), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1172), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1400), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(899), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [30495] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1176), 1,
      sym_variable,
    ACTIONS(1178), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(939), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1170), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1174), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1172), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1402), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(724), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [30564] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1176), 1,
      sym_variable,
    ACTIONS(1178), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(939), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1170), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1174), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1172), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1404), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(898), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [30633] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1406), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(824), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [30702] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(442), 1,
      anon_sym_DOLLAR,
    ACTIONS(1190), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(946), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(434), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(438), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(436), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1380), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(732), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [30771] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      anon_sym_LPAREN,
    ACTIONS(184), 1,
      anon_sym_LBRACK,
    ACTIONS(210), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      anon_sym_DOLLAR,
    ACTIONS(1188), 1,
      sym_variable,
    STATE(257), 1,
      sym_type_name_symbol,
    STATE(941), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(202), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(206), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(204), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1408), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(200), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(253), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [30840] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1176), 1,
      sym_variable,
    ACTIONS(1178), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(939), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1170), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1174), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1162), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1172), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(716), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [30909] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    ACTIONS(510), 1,
      anon_sym_LBRACK,
    ACTIONS(536), 1,
      anon_sym_DQUOTE,
    ACTIONS(538), 1,
      anon_sym_DOLLAR,
    ACTIONS(1194), 1,
      sym_variable,
    STATE(445), 1,
      sym_type_name_symbol,
    STATE(929), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(528), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(532), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(530), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1192), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(526), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(350), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [30978] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      anon_sym_LPAREN,
    ACTIONS(184), 1,
      anon_sym_LBRACK,
    ACTIONS(210), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      anon_sym_DOLLAR,
    ACTIONS(1188), 1,
      sym_variable,
    STATE(257), 1,
      sym_type_name_symbol,
    STATE(941), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(202), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(206), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(204), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1410), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(200), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(204), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [31047] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      anon_sym_LPAREN,
    ACTIONS(184), 1,
      anon_sym_LBRACK,
    ACTIONS(210), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      anon_sym_DOLLAR,
    ACTIONS(1188), 1,
      sym_variable,
    STATE(257), 1,
      sym_type_name_symbol,
    STATE(941), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(202), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(206), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(204), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1412), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(200), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(229), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [31116] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1414), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(844), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [31185] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      anon_sym_LPAREN,
    ACTIONS(184), 1,
      anon_sym_LBRACK,
    ACTIONS(210), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      anon_sym_DOLLAR,
    ACTIONS(1188), 1,
      sym_variable,
    STATE(257), 1,
      sym_type_name_symbol,
    STATE(941), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(202), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(206), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(204), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1416), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(200), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(228), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [31254] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1176), 1,
      sym_variable,
    ACTIONS(1178), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(939), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1170), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1174), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1172), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1418), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(888), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [31323] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1420), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(843), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [31392] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_DOLLAR,
    ACTIONS(1198), 1,
      sym_variable,
    STATE(62), 1,
      sym_type_name_symbol,
    STATE(945), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(45), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(49), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(47), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1422), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(43), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(147), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [31461] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      anon_sym_LPAREN,
    ACTIONS(184), 1,
      anon_sym_LBRACK,
    ACTIONS(210), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      anon_sym_DOLLAR,
    ACTIONS(1188), 1,
      sym_variable,
    STATE(257), 1,
      sym_type_name_symbol,
    STATE(941), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(202), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(206), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(204), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1424), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(200), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(227), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [31530] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(372), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(943), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(362), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(366), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(364), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1426), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(710), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [31599] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1428), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(822), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [31668] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(378), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_DQUOTE,
    ACTIONS(414), 1,
      anon_sym_DOLLAR,
    ACTIONS(1168), 1,
      sym_variable,
    STATE(112), 1,
      sym_type_name_symbol,
    STATE(932), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(404), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(408), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(406), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1430), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(402), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(90), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [31737] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    ACTIONS(1182), 1,
      sym_variable,
    STATE(210), 1,
      sym_type_name_symbol,
    STATE(947), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(488), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(492), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(490), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1432), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(193), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [31806] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    ACTIONS(1182), 1,
      sym_variable,
    STATE(210), 1,
      sym_type_name_symbol,
    STATE(947), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(488), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(492), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(490), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1434), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(197), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [31875] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(372), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(943), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(362), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(366), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(364), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1398), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(711), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [31944] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(378), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_DQUOTE,
    ACTIONS(414), 1,
      anon_sym_DOLLAR,
    ACTIONS(1168), 1,
      sym_variable,
    STATE(112), 1,
      sym_type_name_symbol,
    STATE(932), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(404), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(408), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(406), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1436), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(402), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(95), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [32013] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(372), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(943), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(362), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(366), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(364), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1438), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(712), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [32082] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(372), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(943), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(362), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(366), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(364), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1402), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(724), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [32151] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      anon_sym_LPAREN,
    ACTIONS(184), 1,
      anon_sym_LBRACK,
    ACTIONS(210), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      anon_sym_DOLLAR,
    ACTIONS(1188), 1,
      sym_variable,
    STATE(257), 1,
      sym_type_name_symbol,
    STATE(941), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(202), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(206), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(204), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1440), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(200), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(208), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [32220] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1442), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(791), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [32289] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    ACTIONS(510), 1,
      anon_sym_LBRACK,
    ACTIONS(536), 1,
      anon_sym_DQUOTE,
    ACTIONS(538), 1,
      anon_sym_DOLLAR,
    ACTIONS(1194), 1,
      sym_variable,
    STATE(445), 1,
      sym_type_name_symbol,
    STATE(929), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(528), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(532), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(530), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1444), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(526), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(384), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [32358] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(378), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_DQUOTE,
    ACTIONS(414), 1,
      anon_sym_DOLLAR,
    ACTIONS(1168), 1,
      sym_variable,
    STATE(112), 1,
      sym_type_name_symbol,
    STATE(932), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(404), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(408), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(406), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1446), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(402), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(91), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [32427] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      anon_sym_LPAREN,
    ACTIONS(184), 1,
      anon_sym_LBRACK,
    ACTIONS(210), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      anon_sym_DOLLAR,
    ACTIONS(1188), 1,
      sym_variable,
    STATE(257), 1,
      sym_type_name_symbol,
    STATE(941), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(202), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(206), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(204), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1448), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(200), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(234), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [32496] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(372), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(943), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(362), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(366), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(364), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1450), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(713), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [32565] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    ACTIONS(1182), 1,
      sym_variable,
    STATE(210), 1,
      sym_type_name_symbol,
    STATE(947), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(488), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(492), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(490), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1452), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(199), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [32634] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1454), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(825), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [32703] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1456), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(819), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [32772] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1458), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(786), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [32841] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    ACTIONS(1182), 1,
      sym_variable,
    STATE(210), 1,
      sym_type_name_symbol,
    STATE(947), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(488), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(492), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(490), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1460), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(200), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [32910] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1462), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(793), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [32979] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    ACTIONS(1182), 1,
      sym_variable,
    STATE(210), 1,
      sym_type_name_symbol,
    STATE(947), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(488), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(492), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(490), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1464), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(194), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [33048] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    ACTIONS(1182), 1,
      sym_variable,
    STATE(210), 1,
      sym_type_name_symbol,
    STATE(947), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(488), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(492), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(490), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1466), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(195), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [33117] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(496), 1,
      anon_sym_DQUOTE,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    ACTIONS(1182), 1,
      sym_variable,
    STATE(210), 1,
      sym_type_name_symbol,
    STATE(947), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(488), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(492), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(490), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1468), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(202), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [33186] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_DOLLAR,
    ACTIONS(1198), 1,
      sym_variable,
    STATE(62), 1,
      sym_type_name_symbol,
    STATE(945), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(45), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(49), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(47), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1470), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(43), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(109), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [33255] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1472), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(807), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [33324] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(372), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(943), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(362), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(366), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(364), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1162), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(716), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [33393] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1474), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(810), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [33462] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(442), 1,
      anon_sym_DOLLAR,
    ACTIONS(1190), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(946), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(434), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(438), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(436), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1476), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(751), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [33531] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      anon_sym_LPAREN,
    ACTIONS(184), 1,
      anon_sym_LBRACK,
    ACTIONS(210), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      anon_sym_DOLLAR,
    ACTIONS(1188), 1,
      sym_variable,
    STATE(257), 1,
      sym_type_name_symbol,
    STATE(941), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(202), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(206), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(204), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1478), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(200), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(255), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [33600] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1480), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(834), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [33669] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_DOLLAR,
    ACTIONS(1198), 1,
      sym_variable,
    STATE(62), 1,
      sym_type_name_symbol,
    STATE(945), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(45), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(49), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(47), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1482), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(43), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(105), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [33738] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1484), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(783), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [33807] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1486), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(850), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [33876] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(442), 1,
      anon_sym_DOLLAR,
    ACTIONS(1190), 1,
      sym_variable,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(946), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(434), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(438), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(436), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1364), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(718), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [33945] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1488), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(812), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [34014] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1490), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(849), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [34083] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1492), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(865), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [34152] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      anon_sym_DQUOTE,
    ACTIONS(1020), 1,
      sym_variable,
    ACTIONS(1022), 1,
      anon_sym_DOLLAR,
    STATE(744), 1,
      sym_type_name_symbol,
    STATE(942), 1,
      aux_sym_command_modifier_block_repeat1,
    ACTIONS(1014), 2,
      anon_sym_len,
      anon_sym_lines,
    ACTIONS(1018), 3,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_sudo,
    ACTIONS(1016), 4,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_nameof,
    ACTIONS(1494), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(360), 5,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Int,
      anon_sym_Bool,
      anon_sym_Null,
    STATE(848), 14,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_builtin_expr,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym_command_modifier_block,
      sym__expression,
  [34221] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      anon_sym_LPAREN