#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 95
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 38
#define ALIAS_COUNT 0
#define TOKEN_COUNT 21
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 4
#define MAX_ALIAS_SEQUENCE_LENGTH 5
#define PRODUCTION_ID_COUNT 4

enum ts_symbol_identifiers {
  anon_sym_DOLLAR = 1,
  anon_sym_CARET = 2,
  aux_sym__raw_character_token1 = 3,
  anon_sym_DOT = 4,
  sym_escape_char = 5,
  sym_capture_index = 6,
  anon_sym_b = 7,
  aux_sym_balanced_match_token1 = 8,
  anon_sym_PERCENTf = 9,
  sym_zero_or_more = 10,
  anon_sym_DASH = 11,
  sym_one_or_more = 12,
  sym_zero_or_one = 13,
  anon_sym_PERCENT = 14,
  aux_sym_class_token1 = 15,
  aux_sym_range_token1 = 16,
  anon_sym_LBRACK = 17,
  anon_sym_LPAREN = 18,
  anon_sym_RBRACK = 19,
  anon_sym_RPAREN = 20,
  sym_pattern = 21,
  sym_anchor_begin = 22,
  sym_anchor_end = 23,
  sym__raw_character = 24,
  sym_character = 25,
  sym_balanced_match = 26,
  sym_frontier_pattern = 27,
  sym_shortest_zero_or_more = 28,
  sym_class = 29,
  sym_class_pattern = 30,
  sym_range = 31,
  sym_set = 32,
  sym_negated_set = 33,
  sym_capture = 34,
  aux_sym_pattern_repeat1 = 35,
  aux_sym_set_repeat1 = 36,
  aux_sym_capture_repeat1 = 37,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_CARET] = "^",
  [aux_sym__raw_character_token1] = "_raw_character_token1",
  [anon_sym_DOT] = ".",
  [sym_escape_char] = "escape_char",
  [sym_capture_index] = "capture_index",
  [anon_sym_b] = "b",
  [aux_sym_balanced_match_token1] = "character",
  [anon_sym_PERCENTf] = "%f",
  [sym_zero_or_more] = "zero_or_more",
  [anon_sym_DASH] = "-",
  [sym_one_or_more] = "one_or_more",
  [sym_zero_or_one] = "zero_or_one",
  [anon_sym_PERCENT] = "%",
  [aux_sym_class_token1] = "class_token1",
  [aux_sym_range_token1] = "character",
  [anon_sym_LBRACK] = "[",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RBRACK] = "]",
  [anon_sym_RPAREN] = ")",
  [sym_pattern] = "pattern",
  [sym_anchor_begin] = "anchor_begin",
  [sym_anchor_end] = "anchor_end",
  [sym__raw_character] = "_raw_character",
  [sym_character] = "character",
  [sym_balanced_match] = "balanced_match",
  [sym_frontier_pattern] = "frontier_pattern",
  [sym_shortest_zero_or_more] = "shortest_zero_or_more",
  [sym_class] = "class",
  [sym_class_pattern] = "class_pattern",
  [sym_range] = "range",
  [sym_set] = "set",
  [sym_negated_set] = "negated_set",
  [sym_capture] = "capture",
  [aux_sym_pattern_repeat1] = "pattern_repeat1",
  [aux_sym_set_repeat1] = "set_repeat1",
  [aux_sym_capture_repeat1] = "capture_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_CARET] = anon_sym_CARET,
  [aux_sym__raw_character_token1] = aux_sym__raw_character_token1,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_escape_char] = sym_escape_char,
  [sym_capture_index] = sym_capture_index,
  [anon_sym_b] = anon_sym_b,
  [aux_sym_balanced_match_token1] = sym_character,
  [anon_sym_PERCENTf] = anon_sym_PERCENTf,
  [sym_zero_or_more] = sym_zero_or_more,
  [anon_sym_DASH] = anon_sym_DASH,
  [sym_one_or_more] = sym_one_or_more,
  [sym_zero_or_one] = sym_zero_or_one,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [aux_sym_class_token1] = aux_sym_class_token1,
  [aux_sym_range_token1] = sym_character,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym_pattern] = sym_pattern,
  [sym_anchor_begin] = sym_anchor_begin,
  [sym_anchor_end] = sym_anchor_end,
  [sym__raw_character] = sym__raw_character,
  [sym_character] = sym_character,
  [sym_balanced_match] = sym_balanced_match,
  [sym_frontier_pattern] = sym_frontier_pattern,
  [sym_shortest_zero_or_more] = sym_shortest_zero_or_more,
  [sym_class] = sym_class,
  [sym_class_pattern] = sym_class_pattern,
  [sym_range] = sym_range,
  [sym_set] = sym_set,
  [sym_negated_set] = sym_negated_set,
  [sym_capture] = sym_capture,
  [aux_sym_pattern_repeat1] = aux_sym_pattern_repeat1,
  [aux_sym_set_repeat1] = aux_sym_set_repeat1,
  [aux_sym_capture_repeat1] = aux_sym_capture_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__raw_character_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_char] = {
    .visible = true,
    .named = true,
  },
  [sym_capture_index] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_b] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_balanced_match_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PERCENTf] = {
    .visible = true,
    .named = false,
  },
  [sym_zero_or_more] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [sym_one_or_more] = {
    .visible = true,
    .named = true,
  },
  [sym_zero_or_one] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_class_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_range_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_anchor_begin] = {
    .visible = true,
    .named = true,
  },
  [sym_anchor_end] = {
    .visible = true,
    .named = true,
  },
  [sym__raw_character] = {
    .visible = false,
    .named = true,
  },
  [sym_character] = {
    .visible = true,
    .named = true,
  },
  [sym_balanced_match] = {
    .visible = true,
    .named = true,
  },
  [sym_frontier_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_shortest_zero_or_more] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_negated_set] = {
    .visible = true,
    .named = true,
  },
  [sym_capture] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_set_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_capture_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_first = 1,
  field_from = 2,
  field_last = 3,
  field_to = 4,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_first] = "first",
  [field_from] = "from",
  [field_last] = "last",
  [field_to] = "to",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 2},
  [3] = {.index = 2, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_first, 1},
    {field_last, 2},
  [2] =
    {field_from, 0},
    {field_to, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_character,
  },
  [3] = {
    [0] = sym_character,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__raw_character, 2,
    sym__raw_character,
    sym_character,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 6,
  [10] = 8,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 12,
  [17] = 17,
  [18] = 15,
  [19] = 12,
  [20] = 20,
  [21] = 21,
  [22] = 13,
  [23] = 17,
  [24] = 11,
  [25] = 14,
  [26] = 15,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 12,
  [32] = 15,
  [33] = 29,
  [34] = 20,
  [35] = 27,
  [36] = 28,
  [37] = 21,
  [38] = 30,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 40,
  [43] = 40,
  [44] = 44,
  [45] = 40,
  [46] = 41,
  [47] = 44,
  [48] = 44,
  [49] = 41,
  [50] = 44,
  [51] = 41,
  [52] = 52,
  [53] = 52,
  [54] = 52,
  [55] = 52,
  [56] = 28,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 21,
  [64] = 64,
  [65] = 65,
  [66] = 60,
  [67] = 21,
  [68] = 28,
  [69] = 65,
  [70] = 58,
  [71] = 61,
  [72] = 59,
  [73] = 30,
  [74] = 74,
  [75] = 20,
  [76] = 76,
  [77] = 77,
  [78] = 27,
  [79] = 79,
  [80] = 79,
  [81] = 79,
  [82] = 82,
  [83] = 82,
  [84] = 84,
  [85] = 84,
  [86] = 84,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 90,
  [92] = 92,
  [93] = 93,
  [94] = 90,
};

static TSCharacterRange aux_sym_class_token1_character_set_1[] = {
  {'A', 'A'}, {'C', 'D'}, {'G', 'G'}, {'L', 'L'}, {'P', 'P'}, {'S', 'S'}, {'U', 'U'}, {'W', 'X'},
  {'a', 'a'}, {'c', 'd'}, {'g', 'g'}, {'l', 'l'}, {'p', 'p'}, {'s', 's'}, {'u', 'u'}, {'w', 'x'},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(15);
      ADVANCE_MAP(
        '$', 16,
        '%', 30,
        '(', 35,
        ')', 37,
        '*', 25,
        '+', 27,
        '-', 26,
        '.', 19,
        '?', 28,
        '[', 34,
        ']', 36,
        '^', 17,
        'b', 22,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(13);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(21);
      if (set_contains(aux_sym_class_token1_character_set_1, 16, lookahead)) ADVANCE(31);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(6);
      if (lookahead == '%') ADVANCE(30);
      if (lookahead == '(') ADVANCE(35);
      if (lookahead == ')') ADVANCE(37);
      if (lookahead == '*') ADVANCE(25);
      if (lookahead == '+') ADVANCE(27);
      if (lookahead == '-') ADVANCE(26);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '?') ADVANCE(28);
      if (lookahead == '[') ADVANCE(34);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(18);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(6);
      if (lookahead == '%') ADVANCE(30);
      if (lookahead == '(') ADVANCE(35);
      if (lookahead == ')') ADVANCE(37);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '[') ADVANCE(34);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(18);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(6);
      if (lookahead == '%') ADVANCE(29);
      if (lookahead == '(') ADVANCE(35);
      if (lookahead == '-') ADVANCE(26);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == ']') ADVANCE(36);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(18);
      if (lookahead != 0 &&
          lookahead != '[') ADVANCE(18);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(6);
      if (lookahead == '%') ADVANCE(29);
      if (lookahead == '(') ADVANCE(35);
      if (lookahead == '-') ADVANCE(26);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '^') ADVANCE(17);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(18);
      if (lookahead != 0 &&
          lookahead != '[') ADVANCE(18);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(6);
      if (lookahead == '%') ADVANCE(29);
      if (lookahead == '(') ADVANCE(35);
      if (lookahead == '-') ADVANCE(26);
      if (lookahead == '.') ADVANCE(19);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(18);
      if (lookahead != 0 &&
          lookahead != '[') ADVANCE(18);
      END_STATE();
    case 6:
      if (lookahead == '.') ADVANCE(19);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      END_STATE();
    case 7:
      if (lookahead == 'b') ADVANCE(22);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(20);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(21);
      if (set_contains(aux_sym_class_token1_character_set_1, 16, lookahead)) ADVANCE(31);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || 'z' < lookahead)) ADVANCE(20);
      END_STATE();
    case 8:
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(33);
      if (lookahead != 0 &&
          lookahead != ']') ADVANCE(32);
      END_STATE();
    case 9:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(23);
      END_STATE();
    case 10:
      if (eof) ADVANCE(15);
      if (lookahead == '\n') SKIP(14);
      if (lookahead == '$') ADVANCE(16);
      if (lookahead == '%') ADVANCE(30);
      if (lookahead == '(') ADVANCE(35);
      if (lookahead == '*') ADVANCE(25);
      if (lookahead == '+') ADVANCE(27);
      if (lookahead == '-') ADVANCE(26);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '?') ADVANCE(28);
      if (lookahead == '[') ADVANCE(34);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(18);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 11:
      if (eof) ADVANCE(15);
      if (lookahead == '\n') SKIP(14);
      if (lookahead == '$') ADVANCE(16);
      if (lookahead == '%') ADVANCE(30);
      if (lookahead == '(') ADVANCE(35);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '[') ADVANCE(34);
      if (lookahead == '^') ADVANCE(17);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(18);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 12:
      if (eof) ADVANCE(15);
      if (lookahead == '\n') SKIP(14);
      if (lookahead == '$') ADVANCE(16);
      if (lookahead == '%') ADVANCE(30);
      if (lookahead == '(') ADVANCE(35);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '[') ADVANCE(34);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(18);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 13:
      if (eof) ADVANCE(15);
      if (lookahead == '.') ADVANCE(19);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(13);
      if (set_contains(aux_sym_class_token1_character_set_1, 16, lookahead)) ADVANCE(31);
      END_STATE();
    case 14:
      if (eof) ADVANCE(15);
      if (lookahead == '.') ADVANCE(19);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(14);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(aux_sym__raw_character_token1);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(sym_escape_char);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(sym_capture_index);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_b);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(aux_sym_balanced_match_token1);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_PERCENTf);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(sym_zero_or_more);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_one_or_more);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(sym_zero_or_one);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == 'f') ADVANCE(24);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(aux_sym_class_token1);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(aux_sym_range_token1);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(aux_sym_range_token1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(33);
      if (lookahead != 0 &&
          lookahead != ']') ADVANCE(32);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 11},
  [2] = {.lex_state = 12},
  [3] = {.lex_state = 12},
  [4] = {.lex_state = 12},
  [5] = {.lex_state = 12},
  [6] = {.lex_state = 2},
  [7] = {.lex_state = 2},
  [8] = {.lex_state = 2},
  [9] = {.lex_state = 2},
  [10] = {.lex_state = 2},
  [11] = {.lex_state = 10},
  [12] = {.lex_state = 10},
  [13] = {.lex_state = 10},
  [14] = {.lex_state = 10},
  [15] = {.lex_state = 10},
  [16] = {.lex_state = 10},
  [17] = {.lex_state = 10},
  [18] = {.lex_state = 10},
  [19] = {.lex_state = 1},
  [20] = {.lex_state = 10},
  [21] = {.lex_state = 10},
  [22] = {.lex_state = 1},
  [23] = {.lex_state = 1},
  [24] = {.lex_state = 1},
  [25] = {.lex_state = 1},
  [26] = {.lex_state = 1},
  [27] = {.lex_state = 10},
  [28] = {.lex_state = 10},
  [29] = {.lex_state = 10},
  [30] = {.lex_state = 10},
  [31] = {.lex_state = 1},
  [32] = {.lex_state = 1},
  [33] = {.lex_state = 1},
  [34] = {.lex_state = 1},
  [35] = {.lex_state = 1},
  [36] = {.lex_state = 1},
  [37] = {.lex_state = 1},
  [38] = {.lex_state = 1},
  [39] = {.lex_state = 3},
  [40] = {.lex_state = 4},
  [41] = {.lex_state = 3},
  [42] = {.lex_state = 4},
  [43] = {.lex_state = 4},
  [44] = {.lex_state = 3},
  [45] = {.lex_state = 4},
  [46] = {.lex_state = 3},
  [47] = {.lex_state = 3},
  [48] = {.lex_state = 3},
  [49] = {.lex_state = 3},
  [50] = {.lex_state = 3},
  [51] = {.lex_state = 3},
  [52] = {.lex_state = 5},
  [53] = {.lex_state = 5},
  [54] = {.lex_state = 5},
  [55] = {.lex_state = 5},
  [56] = {.lex_state = 12},
  [57] = {.lex_state = 12},
  [58] = {.lex_state = 12},
  [59] = {.lex_state = 12},
  [60] = {.lex_state = 12},
  [61] = {.lex_state = 12},
  [62] = {.lex_state = 12},
  [63] = {.lex_state = 12},
  [64] = {.lex_state = 12},
  [65] = {.lex_state = 12},
  [66] = {.lex_state = 2},
  [67] = {.lex_state = 2},
  [68] = {.lex_state = 2},
  [69] = {.lex_state = 2},
  [70] = {.lex_state = 2},
  [71] = {.lex_state = 2},
  [72] = {.lex_state = 2},
  [73] = {.lex_state = 3},
  [74] = {.lex_state = 3},
  [75] = {.lex_state = 3},
  [76] = {.lex_state = 3},
  [77] = {.lex_state = 3},
  [78] = {.lex_state = 3},
  [79] = {.lex_state = 7},
  [80] = {.lex_state = 7},
  [81] = {.lex_state = 7},
  [82] = {.lex_state = 0},
  [83] = {.lex_state = 0},
  [84] = {.lex_state = 9},
  [85] = {.lex_state = 9},
  [86] = {.lex_state = 9},
  [87] = {.lex_state = 0},
  [88] = {.lex_state = 0},
  [89] = {.lex_state = 8},
  [90] = {.lex_state = 9},
  [91] = {.lex_state = 9},
  [92] = {.lex_state = 0},
  [93] = {.lex_state = 0},
  [94] = {.lex_state = 9},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [sym_capture_index] = ACTIONS(1),
    [anon_sym_b] = ACTIONS(1),
    [anon_sym_PERCENTf] = ACTIONS(1),
    [sym_zero_or_more] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [sym_one_or_more] = ACTIONS(1),
    [sym_zero_or_one] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [aux_sym_class_token1] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
  },
  [1] = {
    [sym_pattern] = STATE(93),
    [sym_anchor_begin] = STATE(4),
    [sym_anchor_end] = STATE(92),
    [sym__raw_character] = STATE(14),
    [sym_character] = STATE(3),
    [sym_frontier_pattern] = STATE(11),
    [sym_class] = STATE(11),
    [sym_class_pattern] = STATE(3),
    [sym_set] = STATE(3),
    [sym_negated_set] = STATE(3),
    [sym_capture] = STATE(3),
    [aux_sym_pattern_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(3),
    [anon_sym_DOLLAR] = ACTIONS(5),
    [anon_sym_CARET] = ACTIONS(7),
    [aux_sym__raw_character_token1] = ACTIONS(9),
    [anon_sym_DOT] = ACTIONS(9),
    [anon_sym_PERCENTf] = ACTIONS(11),
    [anon_sym_PERCENT] = ACTIONS(13),
    [anon_sym_LBRACK] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(17),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 11,
    ACTIONS(5), 1,
      anon_sym_DOLLAR,
    ACTIONS(11), 1,
      anon_sym_PERCENTf,
    ACTIONS(13), 1,
      anon_sym_PERCENT,
    ACTIONS(15), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      ts_builtin_sym_end,
    STATE(14), 1,
      sym__raw_character,
    STATE(88), 1,
      sym_anchor_end,
    ACTIONS(9), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    STATE(11), 2,
      sym_frontier_pattern,
      sym_class,
    STATE(5), 6,
      sym_character,
      sym_class_pattern,
      sym_set,
      sym_negated_set,
      sym_capture,
      aux_sym_pattern_repeat1,
  [41] = 11,
    ACTIONS(5), 1,
      anon_sym_DOLLAR,
    ACTIONS(11), 1,
      anon_sym_PERCENTf,
    ACTIONS(13), 1,
      anon_sym_PERCENT,
    ACTIONS(15), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      ts_builtin_sym_end,
    STATE(14), 1,
      sym__raw_character,
    STATE(87), 1,
      sym_anchor_end,
    ACTIONS(9), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    STATE(11), 2,
      sym_frontier_pattern,
      sym_class,
    STATE(5), 6,
      sym_character,
      sym_class_pattern,
      sym_set,
      sym_negated_set,
      sym_capture,
      aux_sym_pattern_repeat1,
  [82] = 11,
    ACTIONS(5), 1,
      anon_sym_DOLLAR,
    ACTIONS(11), 1,
      anon_sym_PERCENTf,
    ACTIONS(13), 1,
      anon_sym_PERCENT,
    ACTIONS(15), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      ts_builtin_sym_end,
    STATE(14), 1,
      sym__raw_character,
    STATE(87), 1,
      sym_anchor_end,
    ACTIONS(9), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    STATE(11), 2,
      sym_frontier_pattern,
      sym_class,
    STATE(2), 6,
      sym_character,
      sym_class_pattern,
      sym_set,
      sym_negated_set,
      sym_capture,
      aux_sym_pattern_repeat1,
  [123] = 10,
    ACTIONS(23), 1,
      ts_builtin_sym_end,
    ACTIONS(25), 1,
      anon_sym_DOLLAR,
    ACTIONS(31), 1,
      anon_sym_PERCENTf,
    ACTIONS(34), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(40), 1,
      anon_sym_LPAREN,
    STATE(14), 1,
      sym__raw_character,
    ACTIONS(28), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    STATE(11), 2,
      sym_frontier_pattern,
      sym_class,
    STATE(5), 6,
      sym_character,
      sym_class_pattern,
      sym_set,
      sym_negated_set,
      sym_capture,
      aux_sym_pattern_repeat1,
  [161] = 9,
    ACTIONS(45), 1,
      anon_sym_PERCENTf,
    ACTIONS(47), 1,
      anon_sym_PERCENT,
    ACTIONS(49), 1,
      anon_sym_LBRACK,
    ACTIONS(51), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_RPAREN,
    STATE(25), 1,
      sym__raw_character,
    ACTIONS(43), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    STATE(24), 2,
      sym_frontier_pattern,
      sym_class,
    STATE(7), 6,
      sym_character,
      sym_class_pattern,
      sym_set,
      sym_negated_set,
      sym_capture,
      aux_sym_capture_repeat1,
  [196] = 9,
    ACTIONS(58), 1,
      anon_sym_PERCENTf,
    ACTIONS(61), 1,
      anon_sym_PERCENT,
    ACTIONS(64), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(70), 1,
      anon_sym_RPAREN,
    STATE(25), 1,
      sym__raw_character,
    ACTIONS(55), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    STATE(24), 2,
      sym_frontier_pattern,
      sym_class,
    STATE(7), 6,
      sym_character,
      sym_class_pattern,
      sym_set,
      sym_negated_set,
      sym_capture,
      aux_sym_capture_repeat1,
  [231] = 9,
    ACTIONS(45), 1,
      anon_sym_PERCENTf,
    ACTIONS(47), 1,
      anon_sym_PERCENT,
    ACTIONS(49), 1,
      anon_sym_LBRACK,
    ACTIONS(51), 1,
      anon_sym_LPAREN,
    ACTIONS(72), 1,
      anon_sym_RPAREN,
    STATE(25), 1,
      sym__raw_character,
    ACTIONS(43), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    STATE(24), 2,
      sym_frontier_pattern,
      sym_class,
    STATE(9), 6,
      sym_character,
      sym_class_pattern,
      sym_set,
      sym_negated_set,
      sym_capture,
      aux_sym_capture_repeat1,
  [266] = 9,
    ACTIONS(45), 1,
      anon_sym_PERCENTf,
    ACTIONS(47), 1,
      anon_sym_PERCENT,
    ACTIONS(49), 1,
      anon_sym_LBRACK,
    ACTIONS(51), 1,
      anon_sym_LPAREN,
    ACTIONS(74), 1,
      anon_sym_RPAREN,
    STATE(25), 1,
      sym__raw_character,
    ACTIONS(43), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    STATE(24), 2,
      sym_frontier_pattern,
      sym_class,
    STATE(7), 6,
      sym_character,
      sym_class_pattern,
      sym_set,
      sym_negated_set,
      sym_capture,
      aux_sym_capture_repeat1,
  [301] = 9,
    ACTIONS(45), 1,
      anon_sym_PERCENTf,
    ACTIONS(47), 1,
      anon_sym_PERCENT,
    ACTIONS(49), 1,
      anon_sym_LBRACK,
    ACTIONS(51), 1,
      anon_sym_LPAREN,
    ACTIONS(76), 1,
      anon_sym_RPAREN,
    STATE(25), 1,
      sym__raw_character,
    ACTIONS(43), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    STATE(24), 2,
      sym_frontier_pattern,
      sym_class,
    STATE(6), 6,
      sym_character,
      sym_class_pattern,
      sym_set,
      sym_negated_set,
      sym_capture,
      aux_sym_capture_repeat1,
  [336] = 5,
    ACTIONS(84), 1,
      anon_sym_DASH,
    STATE(58), 1,
      sym_shortest_zero_or_more,
    ACTIONS(80), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(82), 3,
      sym_zero_or_more,
      sym_one_or_more,
      sym_zero_or_one,
    ACTIONS(78), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [360] = 3,
    STATE(28), 1,
      sym_shortest_zero_or_more,
    ACTIONS(88), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(86), 9,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      sym_zero_or_more,
      anon_sym_DASH,
      sym_one_or_more,
      sym_zero_or_one,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [380] = 5,
    ACTIONS(84), 1,
      anon_sym_DASH,
    STATE(65), 1,
      sym_shortest_zero_or_more,
    ACTIONS(92), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(94), 3,
      sym_zero_or_more,
      sym_one_or_more,
      sym_zero_or_one,
    ACTIONS(90), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [404] = 5,
    ACTIONS(84), 1,
      anon_sym_DASH,
    STATE(61), 1,
      sym_shortest_zero_or_more,
    ACTIONS(98), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(100), 3,
      sym_zero_or_more,
      sym_one_or_more,
      sym_zero_or_one,
    ACTIONS(96), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [428] = 5,
    ACTIONS(84), 1,
      anon_sym_DASH,
    STATE(63), 1,
      sym_shortest_zero_or_more,
    ACTIONS(104), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(106), 3,
      sym_zero_or_more,
      sym_one_or_more,
      sym_zero_or_one,
    ACTIONS(102), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [452] = 5,
    ACTIONS(84), 1,
      anon_sym_DASH,
    STATE(56), 1,
      sym_shortest_zero_or_more,
    ACTIONS(88), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(108), 3,
      sym_zero_or_more,
      sym_one_or_more,
      sym_zero_or_one,
    ACTIONS(86), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [476] = 5,
    ACTIONS(84), 1,
      anon_sym_DASH,
    STATE(60), 1,
      sym_shortest_zero_or_more,
    ACTIONS(112), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(114), 3,
      sym_zero_or_more,
      sym_one_or_more,
      sym_zero_or_one,
    ACTIONS(110), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [500] = 3,
    STATE(21), 1,
      sym_shortest_zero_or_more,
    ACTIONS(104), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(102), 9,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      sym_zero_or_more,
      anon_sym_DASH,
      sym_one_or_more,
      sym_zero_or_one,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [520] = 5,
    ACTIONS(118), 1,
      anon_sym_DASH,
    STATE(68), 1,
      sym_shortest_zero_or_more,
    ACTIONS(88), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(116), 3,
      sym_zero_or_more,
      sym_one_or_more,
      sym_zero_or_one,
    ACTIONS(86), 4,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [543] = 2,
    ACTIONS(122), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(120), 9,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      sym_zero_or_more,
      anon_sym_DASH,
      sym_one_or_more,
      sym_zero_or_one,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [560] = 2,
    ACTIONS(126), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(124), 9,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      sym_zero_or_more,
      anon_sym_DASH,
      sym_one_or_more,
      sym_zero_or_one,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [577] = 5,
    ACTIONS(118), 1,
      anon_sym_DASH,
    STATE(69), 1,
      sym_shortest_zero_or_more,
    ACTIONS(92), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(128), 3,
      sym_zero_or_more,
      sym_one_or_more,
      sym_zero_or_one,
    ACTIONS(90), 4,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [600] = 5,
    ACTIONS(118), 1,
      anon_sym_DASH,
    STATE(66), 1,
      sym_shortest_zero_or_more,
    ACTIONS(112), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(130), 3,
      sym_zero_or_more,
      sym_one_or_more,
      sym_zero_or_one,
    ACTIONS(110), 4,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [623] = 5,
    ACTIONS(118), 1,
      anon_sym_DASH,
    STATE(70), 1,
      sym_shortest_zero_or_more,
    ACTIONS(80), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(132), 3,
      sym_zero_or_more,
      sym_one_or_more,
      sym_zero_or_one,
    ACTIONS(78), 4,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [646] = 5,
    ACTIONS(118), 1,
      anon_sym_DASH,
    STATE(71), 1,
      sym_shortest_zero_or_more,
    ACTIONS(98), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(134), 3,
      sym_zero_or_more,
      sym_one_or_more,
      sym_zero_or_one,
    ACTIONS(96), 4,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [669] = 5,
    ACTIONS(118), 1,
      anon_sym_DASH,
    STATE(67), 1,
      sym_shortest_zero_or_more,
    ACTIONS(104), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(136), 3,
      sym_zero_or_more,
      sym_one_or_more,
      sym_zero_or_one,
    ACTIONS(102), 4,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [692] = 2,
    ACTIONS(140), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(138), 9,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      sym_zero_or_more,
      anon_sym_DASH,
      sym_one_or_more,
      sym_zero_or_one,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [709] = 2,
    ACTIONS(144), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(142), 9,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      sym_zero_or_more,
      anon_sym_DASH,
      sym_one_or_more,
      sym_zero_or_one,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [726] = 2,
    ACTIONS(148), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(146), 9,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      sym_zero_or_more,
      anon_sym_DASH,
      sym_one_or_more,
      sym_zero_or_one,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [743] = 2,
    ACTIONS(152), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(150), 9,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      sym_zero_or_more,
      anon_sym_DASH,
      sym_one_or_more,
      sym_zero_or_one,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [760] = 3,
    STATE(36), 1,
      sym_shortest_zero_or_more,
    ACTIONS(88), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(86), 8,
      anon_sym_PERCENTf,
      sym_zero_or_more,
      anon_sym_DASH,
      sym_one_or_more,
      sym_zero_or_one,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [779] = 3,
    STATE(37), 1,
      sym_shortest_zero_or_more,
    ACTIONS(104), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(102), 8,
      anon_sym_PERCENTf,
      sym_zero_or_more,
      anon_sym_DASH,
      sym_one_or_more,
      sym_zero_or_one,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [798] = 2,
    ACTIONS(148), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(146), 8,
      anon_sym_PERCENTf,
      sym_zero_or_more,
      anon_sym_DASH,
      sym_one_or_more,
      sym_zero_or_one,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [814] = 2,
    ACTIONS(122), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(120), 8,
      anon_sym_PERCENTf,
      sym_zero_or_more,
      anon_sym_DASH,
      sym_one_or_more,
      sym_zero_or_one,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [830] = 2,
    ACTIONS(140), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(138), 8,
      anon_sym_PERCENTf,
      sym_zero_or_more,
      anon_sym_DASH,
      sym_one_or_more,
      sym_zero_or_one,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [846] = 2,
    ACTIONS(144), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(142), 8,
      anon_sym_PERCENTf,
      sym_zero_or_more,
      anon_sym_DASH,
      sym_one_or_more,
      sym_zero_or_one,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [862] = 2,
    ACTIONS(126), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(124), 8,
      anon_sym_PERCENTf,
      sym_zero_or_more,
      anon_sym_DASH,
      sym_one_or_more,
      sym_zero_or_one,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [878] = 2,
    ACTIONS(152), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(150), 8,
      anon_sym_PERCENTf,
      sym_zero_or_more,
      anon_sym_DASH,
      sym_one_or_more,
      sym_zero_or_one,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [894] = 6,
    ACTIONS(160), 1,
      anon_sym_PERCENT,
    ACTIONS(163), 1,
      anon_sym_RBRACK,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(154), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(157), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(39), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [917] = 6,
    ACTIONS(165), 1,
      anon_sym_CARET,
    ACTIONS(171), 1,
      anon_sym_PERCENT,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(167), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(44), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [940] = 6,
    ACTIONS(171), 1,
      anon_sym_PERCENT,
    ACTIONS(173), 1,
      anon_sym_RBRACK,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(167), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(39), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [963] = 6,
    ACTIONS(171), 1,
      anon_sym_PERCENT,
    ACTIONS(175), 1,
      anon_sym_CARET,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(167), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(47), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [986] = 6,
    ACTIONS(171), 1,
      anon_sym_PERCENT,
    ACTIONS(177), 1,
      anon_sym_CARET,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(167), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(50), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [1009] = 6,
    ACTIONS(171), 1,
      anon_sym_PERCENT,
    ACTIONS(179), 1,
      anon_sym_RBRACK,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(167), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(39), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [1032] = 6,
    ACTIONS(171), 1,
      anon_sym_PERCENT,
    ACTIONS(181), 1,
      anon_sym_CARET,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(167), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(48), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [1055] = 6,
    ACTIONS(171), 1,
      anon_sym_PERCENT,
    ACTIONS(183), 1,
      anon_sym_RBRACK,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(167), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(39), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [1078] = 6,
    ACTIONS(171), 1,
      anon_sym_PERCENT,
    ACTIONS(185), 1,
      anon_sym_RBRACK,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(167), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(39), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [1101] = 6,
    ACTIONS(171), 1,
      anon_sym_PERCENT,
    ACTIONS(187), 1,
      anon_sym_RBRACK,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(167), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(39), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [1124] = 6,
    ACTIONS(171), 1,
      anon_sym_PERCENT,
    ACTIONS(189), 1,
      anon_sym_RBRACK,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(167), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(39), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [1147] = 6,
    ACTIONS(171), 1,
      anon_sym_PERCENT,
    ACTIONS(191), 1,
      anon_sym_RBRACK,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(167), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(39), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [1170] = 6,
    ACTIONS(171), 1,
      anon_sym_PERCENT,
    ACTIONS(193), 1,
      anon_sym_RBRACK,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(167), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(39), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [1193] = 5,
    ACTIONS(171), 1,
      anon_sym_PERCENT,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(167), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(46), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [1213] = 5,
    ACTIONS(171), 1,
      anon_sym_PERCENT,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(167), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(49), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [1233] = 5,
    ACTIONS(171), 1,
      anon_sym_PERCENT,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(167), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(51), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [1253] = 5,
    ACTIONS(171), 1,
      anon_sym_PERCENT,
    STATE(77), 1,
      sym__raw_character,
    ACTIONS(167), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_LPAREN,
    STATE(41), 3,
      sym_class,
      sym_range,
      aux_sym_set_repeat1,
  [1273] = 2,
    ACTIONS(144), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(142), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [1286] = 2,
    ACTIONS(197), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(195), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [1299] = 2,
    ACTIONS(201), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(199), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [1312] = 2,
    ACTIONS(205), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(203), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [1325] = 2,
    ACTIONS(92), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(90), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [1338] = 2,
    ACTIONS(209), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(207), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [1351] = 2,
    ACTIONS(213), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(211), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [1364] = 2,
    ACTIONS(126), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(124), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [1377] = 3,
    ACTIONS(215), 1,
      ts_builtin_sym_end,
    ACTIONS(213), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(211), 4,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [1392] = 2,
    ACTIONS(219), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(217), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [1405] = 2,
    ACTIONS(92), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(90), 4,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1417] = 2,
    ACTIONS(126), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(124), 4,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1429] = 2,
    ACTIONS(144), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(142), 4,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1441] = 2,
    ACTIONS(219), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(217), 4,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1453] = 2,
    ACTIONS(201), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(199), 4,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1465] = 2,
    ACTIONS(209), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(207), 4,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1477] = 2,
    ACTIONS(205), 3,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
      anon_sym_PERCENT,
    ACTIONS(203), 4,
      anon_sym_PERCENTf,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1489] = 2,
    ACTIONS(152), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(150), 4,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LPAREN,
      anon_sym_RBRACK,
  [1500] = 2,
    ACTIONS(221), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(223), 4,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LPAREN,
      anon_sym_RBRACK,
  [1511] = 2,
    ACTIONS(122), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(120), 4,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LPAREN,
      anon_sym_RBRACK,
  [1522] = 2,
    ACTIONS(225), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(227), 4,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LPAREN,
      anon_sym_RBRACK,
  [1533] = 3,
    ACTIONS(229), 1,
      anon_sym_DASH,
    ACTIONS(225), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(227), 3,
      anon_sym_PERCENT,
      anon_sym_LPAREN,
      anon_sym_RBRACK,
  [1546] = 2,
    ACTIONS(140), 2,
      aux_sym__raw_character_token1,
      anon_sym_DOT,
    ACTIONS(138), 4,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LPAREN,
      anon_sym_RBRACK,
  [1557] = 4,
    ACTIONS(234), 1,
      anon_sym_b,
    ACTIONS(236), 1,
      aux_sym_class_token1,
    STATE(75), 1,
      sym_balanced_match,
    ACTIONS(232), 2,
      sym_escape_char,
      sym_capture_index,
  [1571] = 4,
    ACTIONS(240), 1,
      anon_sym_b,
    ACTIONS(242), 1,
      aux_sym_class_token1,
    STATE(34), 1,
      sym_balanced_match,
    ACTIONS(238), 2,
      sym_escape_char,
      sym_capture_index,
  [1585] = 4,
    ACTIONS(246), 1,
      anon_sym_b,
    ACTIONS(248), 1,
      aux_sym_class_token1,
    STATE(20), 1,
      sym_balanced_match,
    ACTIONS(244), 2,
      sym_escape_char,
      sym_capture_index,
  [1599] = 2,
    ACTIONS(250), 1,
      anon_sym_LBRACK,
    STATE(29), 2,
      sym_set,
      sym_negated_set,
  [1607] = 2,
    ACTIONS(252), 1,
      anon_sym_LBRACK,
    STATE(33), 2,
      sym_set,
      sym_negated_set,
  [1615] = 1,
    ACTIONS(254), 1,
      aux_sym_balanced_match_token1,
  [1619] = 1,
    ACTIONS(256), 1,
      aux_sym_balanced_match_token1,
  [1623] = 1,
    ACTIONS(258), 1,
      aux_sym_balanced_match_token1,
  [1627] = 1,
    ACTIONS(19), 1,
      ts_builtin_sym_end,
  [1631] = 1,
    ACTIONS(260), 1,
      ts_builtin_sym_end,
  [1635] = 1,
    ACTIONS(262), 1,
      aux_sym_range_token1,
  [1639] = 1,
    ACTIONS(264), 1,
      aux_sym_balanced_match_token1,
  [1643] = 1,
    ACTIONS(266), 1,
      aux_sym_balanced_match_token1,
  [1647] = 1,
    ACTIONS(21), 1,
      ts_builtin_sym_end,
  [1651] = 1,
    ACTIONS(268), 1,
      ts_builtin_sym_end,
  [1655] = 1,
    ACTIONS(270), 1,
      aux_sym_balanced_match_token1,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 41,
  [SMALL_STATE(4)] = 82,
  [SMALL_STATE(5)] = 123,
  [SMALL_STATE(6)] = 161,
  [SMALL_STATE(7)] = 196,
  [SMALL_STATE(8)] = 231,
  [SMALL_STATE(9)] = 266,
  [SMALL_STATE(10)] = 301,
  [SMALL_STATE(11)] = 336,
  [SMALL_STATE(12)] = 360,
  [SMALL_STATE(13)] = 380,
  [SMALL_STATE(14)] = 404,
  [SMALL_STATE(15)] = 428,
  [SMALL_STATE(16)] = 452,
  [SMALL_STATE(17)] = 476,
  [SMALL_STATE(18)] = 500,
  [SMALL_STATE(19)] = 520,
  [SMALL_STATE(20)] = 543,
  [SMALL_STATE(21)] = 560,
  [SMALL_STATE(22)] = 577,
  [SMALL_STATE(23)] = 600,
  [SMALL_STATE(24)] = 623,
  [SMALL_STATE(25)] = 646,
  [SMALL_STATE(26)] = 669,
  [SMALL_STATE(27)] = 692,
  [SMALL_STATE(28)] = 709,
  [SMALL_STATE(29)] = 726,
  [SMALL_STATE(30)] = 743,
  [SMALL_STATE(31)] = 760,
  [SMALL_STATE(32)] = 779,
  [SMALL_STATE(33)] = 798,
  [SMALL_STATE(34)] = 814,
  [SMALL_STATE(35)] = 830,
  [SMALL_STATE(36)] = 846,
  [SMALL_STATE(37)] = 862,
  [SMALL_STATE(38)] = 878,
  [SMALL_STATE(39)] = 894,
  [SMALL_STATE(40)] = 917,
  [SMALL_STATE(41)] = 940,
  [SMALL_STATE(42)] = 963,
  [SMALL_STATE(43)] = 986,
  [SMALL_STATE(44)] = 1009,
  [SMALL_STATE(45)] = 1032,
  [SMALL_STATE(46)] = 1055,
  [SMALL_STATE(47)] = 1078,
  [SMALL_STATE(48)] = 1101,
  [SMALL_STATE(49)] = 1124,
  [SMALL_STATE(50)] = 1147,
  [SMALL_STATE(51)] = 1170,
  [SMALL_STATE(52)] = 1193,
  [SMALL_STATE(53)] = 1213,
  [SMALL_STATE(54)] = 1233,
  [SMALL_STATE(55)] = 1253,
  [SMALL_STATE(56)] = 1273,
  [SMALL_STATE(57)] = 1286,
  [SMALL_STATE(58)] = 1299,
  [SMALL_STATE(59)] = 1312,
  [SMALL_STATE(60)] = 1325,
  [SMALL_STATE(61)] = 1338,
  [SMALL_STATE(62)] = 1351,
  [SMALL_STATE(63)] = 1364,
  [SMALL_STATE(64)] = 1377,
  [SMALL_STATE(65)] = 1392,
  [SMALL_STATE(66)] = 1405,
  [SMALL_STATE(67)] = 1417,
  [SMALL_STATE(68)] = 1429,
  [SMALL_STATE(69)] = 1441,
  [SMALL_STATE(70)] = 1453,
  [SMALL_STATE(71)] = 1465,
  [SMALL_STATE(72)] = 1477,
  [SMALL_STATE(73)] = 1489,
  [SMALL_STATE(74)] = 1500,
  [SMALL_STATE(75)] = 1511,
  [SMALL_STATE(76)] = 1522,
  [SMALL_STATE(77)] = 1533,
  [SMALL_STATE(78)] = 1546,
  [SMALL_STATE(79)] = 1557,
  [SMALL_STATE(80)] = 1571,
  [SMALL_STATE(81)] = 1585,
  [SMALL_STATE(82)] = 1599,
  [SMALL_STATE(83)] = 1607,
  [SMALL_STATE(84)] = 1615,
  [SMALL_STATE(85)] = 1619,
  [SMALL_STATE(86)] = 1623,
  [SMALL_STATE(87)] = 1627,
  [SMALL_STATE(88)] = 1631,
  [SMALL_STATE(89)] = 1635,
  [SMALL_STATE(90)] = 1639,
  [SMALL_STATE(91)] = 1643,
  [SMALL_STATE(92)] = 1647,
  [SMALL_STATE(93)] = 1651,
  [SMALL_STATE(94)] = 1655,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern, 0, 0, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [19] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern, 2, 0, 0),
  [21] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern, 1, 0, 0),
  [23] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_pattern_repeat1, 2, 0, 0),
  [25] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_pattern_repeat1, 2, 0, 0), SHIFT_REPEAT(62),
  [28] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_repeat1, 2, 0, 0), SHIFT_REPEAT(30),
  [31] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_pattern_repeat1, 2, 0, 0), SHIFT_REPEAT(82),
  [34] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_repeat1, 2, 0, 0), SHIFT_REPEAT(81),
  [37] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_pattern_repeat1, 2, 0, 0), SHIFT_REPEAT(45),
  [40] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_pattern_repeat1, 2, 0, 0), SHIFT_REPEAT(10),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [55] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_capture_repeat1, 2, 0, 0), SHIFT_REPEAT(38),
  [58] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_capture_repeat1, 2, 0, 0), SHIFT_REPEAT(83),
  [61] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_capture_repeat1, 2, 0, 0), SHIFT_REPEAT(80),
  [64] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_capture_repeat1, 2, 0, 0), SHIFT_REPEAT(42),
  [67] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_capture_repeat1, 2, 0, 0), SHIFT_REPEAT(8),
  [70] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_capture_repeat1, 2, 0, 0),
  [72] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [74] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [76] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [78] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_pattern, 1, 0, 0),
  [80] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_pattern, 1, 0, 0),
  [82] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [84] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [86] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_negated_set, 4, 0, 0),
  [88] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_negated_set, 4, 0, 0),
  [90] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_capture, 3, 0, 0),
  [92] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_capture, 3, 0, 0),
  [94] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [96] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_character, 1, 0, 0),
  [98] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_character, 1, 0, 0),
  [100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [102] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set, 3, 0, 0),
  [104] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set, 3, 0, 0),
  [106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [110] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_capture, 2, 0, 0),
  [112] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_capture, 2, 0, 0),
  [114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [120] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class, 2, 0, 0),
  [122] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class, 2, 0, 0),
  [124] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set, 4, 0, 0),
  [126] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set, 4, 0, 0),
  [128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [138] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_balanced_match, 3, 0, 2),
  [140] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_balanced_match, 3, 0, 2),
  [142] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_negated_set, 5, 0, 0),
  [144] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_negated_set, 5, 0, 0),
  [146] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_frontier_pattern, 2, 0, 0),
  [148] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_frontier_pattern, 2, 0, 0),
  [150] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__raw_character, 1, 0, 0),
  [152] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__raw_character, 1, 0, 0),
  [154] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_set_repeat1, 2, 0, 0), SHIFT_REPEAT(73),
  [157] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_set_repeat1, 2, 0, 0), SHIFT_REPEAT(76),
  [160] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_set_repeat1, 2, 0, 0), SHIFT_REPEAT(79),
  [163] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_set_repeat1, 2, 0, 0),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [167] = {.entry = {.count = 1, .reusable = false}}, SHIFT(73),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anchor_begin, 1, 0, 0),
  [197] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anchor_begin, 1, 0, 0),
  [199] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_pattern, 2, 0, 0),
  [201] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_pattern, 2, 0, 0),
  [203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shortest_zero_or_more, 1, 0, 0),
  [205] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shortest_zero_or_more, 1, 0, 0),
  [207] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_character, 2, 0, 0),
  [209] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_character, 2, 0, 0),
  [211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_pattern_repeat1, 1, 0, 1),
  [213] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_pattern_repeat1, 1, 0, 1),
  [215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anchor_end, 1, 0, 0),
  [217] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_capture, 4, 0, 0),
  [219] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_capture, 4, 0, 0),
  [221] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 3, 1, 3),
  [223] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 3, 1, 3),
  [225] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_set_repeat1, 1, 0, 1),
  [227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_set_repeat1, 1, 0, 1),
  [229] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_set_repeat1, 1, 0, 1), SHIFT(89),
  [232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [236] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [242] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [248] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern, 3, 0, 0),
  [262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [268] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_luap(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
