#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 843
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 112
#define ALIAS_COUNT 0
#define TOKEN_COUNT 52
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 4
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 4

enum {
  sym_keyword = 1,
  anon_sym_COMMA = 2,
  anon_sym_SEMI = 3,
  anon_sym_CR = 4,
  anon_sym_LF = 5,
  anon_sym_DOT = 6,
  anon_sym_DASH = 7,
  anon_sym_PIPE = 8,
  sym_assignment = 9,
  sym_unification = 10,
  anon_sym_EQ_EQ = 11,
  anon_sym_BANG_EQ = 12,
  anon_sym_LT = 13,
  anon_sym_GT = 14,
  anon_sym_GT_EQ = 15,
  anon_sym_LT_EQ = 16,
  anon_sym_PLUS = 17,
  anon_sym_STAR = 18,
  anon_sym_SLASH = 19,
  anon_sym_AMP = 20,
  anon_sym__ = 21,
  sym_var = 22,
  anon_sym_null = 23,
  anon_sym_DQUOTE = 24,
  aux_sym_string_token1 = 25,
  anon_sym_BQUOTE = 26,
  aux_sym_raw_string_token1 = 27,
  anon_sym_COLON = 28,
  anon_sym_set_LPAREN = 29,
  anon_sym_RPAREN = 30,
  sym_comment = 31,
  anon_sym_true = 32,
  anon_sym_false = 33,
  sym_open_paren = 34,
  sym_open_bracket = 35,
  sym_close_bracket = 36,
  sym_open_curly = 37,
  sym_close_curly = 38,
  sym_number = 39,
  sym_not = 40,
  sym_with = 41,
  sym_as = 42,
  sym_in = 43,
  sym_if = 44,
  sym_every = 45,
  sym_else = 46,
  sym_package = 47,
  sym_import = 48,
  sym_contains = 49,
  sym_some = 50,
  sym_default = 51,
  sym_source_file = 52,
  sym_module = 53,
  sym__package = 54,
  sym__import = 55,
  sym_policy = 56,
  sym_rule = 57,
  sym_rule_head = 58,
  sym_rule_head_comp = 59,
  sym_rule_args = 60,
  sym_rule_body = 61,
  sym_query = 62,
  sym_literal = 63,
  sym_with_modifier = 64,
  sym_some_decl = 65,
  sym_expr = 66,
  sym_expr_parens = 67,
  sym_expr_call = 68,
  sym_fn_name = 69,
  sym_fn_args = 70,
  sym_expr_infix = 71,
  sym_expr_every = 72,
  sym_expr_unary = 73,
  sym_term = 74,
  sym_array_compr = 75,
  sym_set_compr = 76,
  sym_object_compr = 77,
  sym_infix_operator = 78,
  sym_assignment_operator = 79,
  sym_bool_operator = 80,
  sym_arith_operator = 81,
  sym_bin_operator = 82,
  sym_ref = 83,
  sym_ref_arg = 84,
  sym_ref_arg_brack = 85,
  sym_ref_arg_dot = 86,
  sym_scalar = 87,
  sym_string = 88,
  sym_raw_string = 89,
  sym_array = 90,
  sym_object = 91,
  sym_object_item = 92,
  sym_set = 93,
  sym_non_empty_set = 94,
  sym_empty_set = 95,
  sym_boolean = 96,
  sym_membership = 97,
  sym_close_paren = 98,
  aux_sym_module_repeat1 = 99,
  aux_sym_policy_repeat1 = 100,
  aux_sym_rule_repeat1 = 101,
  aux_sym_rule_args_repeat1 = 102,
  aux_sym_query_repeat1 = 103,
  aux_sym_literal_repeat1 = 104,
  aux_sym_some_decl_repeat1 = 105,
  aux_sym_fn_args_repeat1 = 106,
  aux_sym_expr_every_repeat1 = 107,
  aux_sym_ref_repeat1 = 108,
  aux_sym_string_repeat1 = 109,
  aux_sym_raw_string_repeat1 = 110,
  aux_sym_object_repeat1 = 111,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_keyword] = "keyword",
  [anon_sym_COMMA] = ",",
  [anon_sym_SEMI] = ";",
  [anon_sym_CR] = "\r",
  [anon_sym_LF] = "\n",
  [anon_sym_DOT] = ".",
  [anon_sym_DASH] = "-",
  [anon_sym_PIPE] = "|",
  [sym_assignment] = "assignment",
  [sym_unification] = "unification",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_AMP] = "&",
  [anon_sym__] = "_",
  [sym_var] = "var",
  [anon_sym_null] = "null",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_BQUOTE] = "`",
  [aux_sym_raw_string_token1] = "raw_string_token1",
  [anon_sym_COLON] = ":",
  [anon_sym_set_LPAREN] = "set(",
  [anon_sym_RPAREN] = ")",
  [sym_comment] = "comment",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_open_paren] = "open_paren",
  [sym_open_bracket] = "open_bracket",
  [sym_close_bracket] = "close_bracket",
  [sym_open_curly] = "open_curly",
  [sym_close_curly] = "close_curly",
  [sym_number] = "number",
  [sym_not] = "not",
  [sym_with] = "with",
  [sym_as] = "as",
  [sym_in] = "in",
  [sym_if] = "if",
  [sym_every] = "every",
  [sym_else] = "else",
  [sym_package] = "package",
  [sym_import] = "import",
  [sym_contains] = "contains",
  [sym_some] = "some",
  [sym_default] = "default",
  [sym_source_file] = "source_file",
  [sym_module] = "module",
  [sym__package] = "_package",
  [sym__import] = "_import",
  [sym_policy] = "policy",
  [sym_rule] = "rule",
  [sym_rule_head] = "rule_head",
  [sym_rule_head_comp] = "rule_head_comp",
  [sym_rule_args] = "rule_args",
  [sym_rule_body] = "rule_body",
  [sym_query] = "query",
  [sym_literal] = "literal",
  [sym_with_modifier] = "with_modifier",
  [sym_some_decl] = "some_decl",
  [sym_expr] = "expr",
  [sym_expr_parens] = "expr_parens",
  [sym_expr_call] = "expr_call",
  [sym_fn_name] = "fn_name",
  [sym_fn_args] = "fn_args",
  [sym_expr_infix] = "expr_infix",
  [sym_expr_every] = "expr_every",
  [sym_expr_unary] = "expr_unary",
  [sym_term] = "term",
  [sym_array_compr] = "array_compr",
  [sym_set_compr] = "set_compr",
  [sym_object_compr] = "object_compr",
  [sym_infix_operator] = "infix_operator",
  [sym_assignment_operator] = "assignment_operator",
  [sym_bool_operator] = "bool_operator",
  [sym_arith_operator] = "arith_operator",
  [sym_bin_operator] = "bin_operator",
  [sym_ref] = "ref",
  [sym_ref_arg] = "ref_arg",
  [sym_ref_arg_brack] = "ref_arg_brack",
  [sym_ref_arg_dot] = "ref_arg_dot",
  [sym_scalar] = "scalar",
  [sym_string] = "string",
  [sym_raw_string] = "raw_string",
  [sym_array] = "array",
  [sym_object] = "object",
  [sym_object_item] = "object_item",
  [sym_set] = "set",
  [sym_non_empty_set] = "non_empty_set",
  [sym_empty_set] = "empty_set",
  [sym_boolean] = "boolean",
  [sym_membership] = "membership",
  [sym_close_paren] = "close_paren",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym_policy_repeat1] = "policy_repeat1",
  [aux_sym_rule_repeat1] = "rule_repeat1",
  [aux_sym_rule_args_repeat1] = "rule_args_repeat1",
  [aux_sym_query_repeat1] = "query_repeat1",
  [aux_sym_literal_repeat1] = "literal_repeat1",
  [aux_sym_some_decl_repeat1] = "some_decl_repeat1",
  [aux_sym_fn_args_repeat1] = "fn_args_repeat1",
  [aux_sym_expr_every_repeat1] = "expr_every_repeat1",
  [aux_sym_ref_repeat1] = "ref_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_raw_string_repeat1] = "raw_string_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_keyword] = sym_keyword,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_CR] = anon_sym_CR,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [sym_assignment] = sym_assignment,
  [sym_unification] = sym_unification,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym__] = anon_sym__,
  [sym_var] = sym_var,
  [anon_sym_null] = anon_sym_null,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [aux_sym_raw_string_token1] = aux_sym_raw_string_token1,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_set_LPAREN] = anon_sym_set_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym_comment] = sym_comment,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_open_paren] = sym_open_paren,
  [sym_open_bracket] = sym_open_bracket,
  [sym_close_bracket] = sym_close_bracket,
  [sym_open_curly] = sym_open_curly,
  [sym_close_curly] = sym_close_curly,
  [sym_number] = sym_number,
  [sym_not] = sym_not,
  [sym_with] = sym_with,
  [sym_as] = sym_as,
  [sym_in] = sym_in,
  [sym_if] = sym_if,
  [sym_every] = sym_every,
  [sym_else] = sym_else,
  [sym_package] = sym_package,
  [sym_import] = sym_import,
  [sym_contains] = sym_contains,
  [sym_some] = sym_some,
  [sym_default] = sym_default,
  [sym_source_file] = sym_source_file,
  [sym_module] = sym_module,
  [sym__package] = sym__package,
  [sym__import] = sym__import,
  [sym_policy] = sym_policy,
  [sym_rule] = sym_rule,
  [sym_rule_head] = sym_rule_head,
  [sym_rule_head_comp] = sym_rule_head_comp,
  [sym_rule_args] = sym_rule_args,
  [sym_rule_body] = sym_rule_body,
  [sym_query] = sym_query,
  [sym_literal] = sym_literal,
  [sym_with_modifier] = sym_with_modifier,
  [sym_some_decl] = sym_some_decl,
  [sym_expr] = sym_expr,
  [sym_expr_parens] = sym_expr_parens,
  [sym_expr_call] = sym_expr_call,
  [sym_fn_name] = sym_fn_name,
  [sym_fn_args] = sym_fn_args,
  [sym_expr_infix] = sym_expr_infix,
  [sym_expr_every] = sym_expr_every,
  [sym_expr_unary] = sym_expr_unary,
  [sym_term] = sym_term,
  [sym_array_compr] = sym_array_compr,
  [sym_set_compr] = sym_set_compr,
  [sym_object_compr] = sym_object_compr,
  [sym_infix_operator] = sym_infix_operator,
  [sym_assignment_operator] = sym_assignment_operator,
  [sym_bool_operator] = sym_bool_operator,
  [sym_arith_operator] = sym_arith_operator,
  [sym_bin_operator] = sym_bin_operator,
  [sym_ref] = sym_ref,
  [sym_ref_arg] = sym_ref_arg,
  [sym_ref_arg_brack] = sym_ref_arg_brack,
  [sym_ref_arg_dot] = sym_ref_arg_dot,
  [sym_scalar] = sym_scalar,
  [sym_string] = sym_string,
  [sym_raw_string] = sym_raw_string,
  [sym_array] = sym_array,
  [sym_object] = sym_object,
  [sym_object_item] = sym_object_item,
  [sym_set] = sym_set,
  [sym_non_empty_set] = sym_non_empty_set,
  [sym_empty_set] = sym_empty_set,
  [sym_boolean] = sym_boolean,
  [sym_membership] = sym_membership,
  [sym_close_paren] = sym_close_paren,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym_policy_repeat1] = aux_sym_policy_repeat1,
  [aux_sym_rule_repeat1] = aux_sym_rule_repeat1,
  [aux_sym_rule_args_repeat1] = aux_sym_rule_args_repeat1,
  [aux_sym_query_repeat1] = aux_sym_query_repeat1,
  [aux_sym_literal_repeat1] = aux_sym_literal_repeat1,
  [aux_sym_some_decl_repeat1] = aux_sym_some_decl_repeat1,
  [aux_sym_fn_args_repeat1] = aux_sym_fn_args_repeat1,
  [aux_sym_expr_every_repeat1] = aux_sym_expr_every_repeat1,
  [aux_sym_ref_repeat1] = aux_sym_ref_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_raw_string_repeat1] = aux_sym_raw_string_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_keyword] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_unification] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [sym_var] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_null] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_raw_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_open_paren] = {
    .visible = true,
    .named = true,
  },
  [sym_open_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym_close_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym_open_curly] = {
    .visible = true,
    .named = true,
  },
  [sym_close_curly] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_not] = {
    .visible = true,
    .named = true,
  },
  [sym_with] = {
    .visible = true,
    .named = true,
  },
  [sym_as] = {
    .visible = true,
    .named = true,
  },
  [sym_in] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_every] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_package] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_contains] = {
    .visible = true,
    .named = true,
  },
  [sym_some] = {
    .visible = true,
    .named = true,
  },
  [sym_default] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym__package] = {
    .visible = false,
    .named = true,
  },
  [sym__import] = {
    .visible = false,
    .named = true,
  },
  [sym_policy] = {
    .visible = true,
    .named = true,
  },
  [sym_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_rule_head] = {
    .visible = true,
    .named = true,
  },
  [sym_rule_head_comp] = {
    .visible = true,
    .named = true,
  },
  [sym_rule_args] = {
    .visible = true,
    .named = true,
  },
  [sym_rule_body] = {
    .visible = true,
    .named = true,
  },
  [sym_query] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_with_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_some_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_parens] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_call] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_name] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_args] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_infix] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_every] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_unary] = {
    .visible = true,
    .named = true,
  },
  [sym_term] = {
    .visible = true,
    .named = true,
  },
  [sym_array_compr] = {
    .visible = true,
    .named = true,
  },
  [sym_set_compr] = {
    .visible = true,
    .named = true,
  },
  [sym_object_compr] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_bool_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_arith_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_bin_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_ref_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_ref_arg_brack] = {
    .visible = true,
    .named = true,
  },
  [sym_ref_arg_dot] = {
    .visible = true,
    .named = true,
  },
  [sym_scalar] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_string] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_item] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_non_empty_set] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_set] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_membership] = {
    .visible = true,
    .named = true,
  },
  [sym_close_paren] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_policy_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_rule_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_rule_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_query_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_some_decl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_fn_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expr_every_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ref_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_raw_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_func_arguments = 1,
  field_func_name = 2,
  field_key = 3,
  field_value = 4,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_func_arguments] = "func_arguments",
  [field_func_name] = "func_name",
  [field_key] = "key",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_func_name, 0},
  [1] =
    {field_key, 0},
    {field_value, 2},
  [3] =
    {field_func_arguments, 2},
    {field_func_name, 0},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool anon_sym_LF_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < 160
      ? (c < ' '
        ? c == '\t'
        : c <= ' ')
      : (c <= 160 || c == 5760))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static inline bool anon_sym_DQUOTE_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ' '
      ? (c < '\r'
        ? (c >= '\t' && c <= '\n')
        : c <= '\r')
      : (c <= ' ' || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static inline bool aux_sym_string_token1_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ' '
      ? (c < '\r'
        ? c == '\t'
        : c <= '\r')
      : (c <= ' ' || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(35);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '&') ADVANCE(57);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(124);
      if (lookahead == '*') ADVANCE(55);
      if (lookahead == '+') ADVANCE(54);
      if (lookahead == ',') ADVANCE(36);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == ';') ADVANCE(37);
      if (lookahead == '<') ADVANCE(50);
      if (lookahead == '=') ADVANCE(47);
      if (lookahead == '>') ADVANCE(51);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '_') ADVANCE(58);
      if (lookahead == '`') ADVANCE(118);
      if (lookahead == 'a') ADVANCE(193);
      if (lookahead == 'c') ADVANCE(186);
      if (lookahead == 'd') ADVANCE(166);
      if (lookahead == 'e') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(163);
      if (lookahead == 'i') ADVANCE(173);
      if (lookahead == 'n') ADVANCE(187);
      if (lookahead == 's') ADVANCE(172);
      if (lookahead == 't') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(177);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '|') ADVANCE(44);
      if (lookahead == '}') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(39);
      if (lookahead == '\r') ADVANCE(38);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '&') ADVANCE(57);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '*') ADVANCE(55);
      if (lookahead == '+') ADVANCE(54);
      if (lookahead == ',') ADVANCE(36);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == ';') ADVANCE(37);
      if (lookahead == '<') ADVANCE(50);
      if (lookahead == '=') ADVANCE(47);
      if (lookahead == '>') ADVANCE(51);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == 'i') ADVANCE(23);
      if (lookahead == 'w') ADVANCE(22);
      if (lookahead == '|') ADVANCE(44);
      if (lookahead == '}') ADVANCE(134);
      if (anon_sym_LF_character_set_1(lookahead)) SKIP(1)
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(39);
      if (lookahead == '\r') ADVANCE(38);
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == ';') ADVANCE(37);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '`') ADVANCE(118);
      if (lookahead == 'e') ADVANCE(108);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'n') ADVANCE(88);
      if (lookahead == 's') ADVANCE(70);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '}') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (anon_sym_LF_character_set_1(lookahead)) SKIP(2)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(116);
      if (aux_sym_string_token1_character_set_1(lookahead)) ADVANCE(115);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(117);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(40);
      if (lookahead == '#') ADVANCE(125);
      if (aux_sym_string_token1_character_set_1(lookahead)) SKIP(4)
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '&') ADVANCE(57);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(124);
      if (lookahead == '*') ADVANCE(55);
      if (lookahead == '+') ADVANCE(54);
      if (lookahead == ',') ADVANCE(36);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == '<') ADVANCE(50);
      if (lookahead == '=') ADVANCE(47);
      if (lookahead == '>') ADVANCE(51);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == 'a') ADVANCE(24);
      if (lookahead == 'i') ADVANCE(23);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '|') ADVANCE(44);
      if (lookahead == '}') ADVANCE(134);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(5)
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(124);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == '`') ADVANCE(118);
      if (lookahead == 'e') ADVANCE(108);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'n') ADVANCE(105);
      if (lookahead == 's') ADVANCE(71);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == '{') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(6)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ',') ADVANCE(36);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == ':') ADVANCE(20);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == '`') ADVANCE(118);
      if (lookahead == 'e') ADVANCE(78);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'n') ADVANCE(88);
      if (lookahead == 's') ADVANCE(70);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == '{') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(7)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ',') ADVANCE(36);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == ':') ADVANCE(20);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == '`') ADVANCE(118);
      if (lookahead == 'e') ADVANCE(108);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(85);
      if (lookahead == 'n') ADVANCE(88);
      if (lookahead == 's') ADVANCE(70);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == '{') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(8)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 9:
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == ':') ADVANCE(20);
      if (lookahead == '=') ADVANCE(46);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == '`') ADVANCE(118);
      if (lookahead == 'e') ADVANCE(78);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(73);
      if (lookahead == 'n') ADVANCE(88);
      if (lookahead == 's') ADVANCE(70);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == '{') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(9)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == ':') ADVANCE(20);
      if (lookahead == '=') ADVANCE(46);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == '`') ADVANCE(118);
      if (lookahead == 'e') ADVANCE(108);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'n') ADVANCE(88);
      if (lookahead == 's') ADVANCE(70);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == '{') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(10)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == ':') ADVANCE(20);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == '`') ADVANCE(118);
      if (lookahead == 'c') ADVANCE(89);
      if (lookahead == 'e') ADVANCE(78);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(73);
      if (lookahead == 'n') ADVANCE(88);
      if (lookahead == 's') ADVANCE(70);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == '{') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(11)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == ':') ADVANCE(20);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == '`') ADVANCE(118);
      if (lookahead == 'e') ADVANCE(78);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'n') ADVANCE(88);
      if (lookahead == 's') ADVANCE(70);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == '{') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(12)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '`') ADVANCE(118);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'n') ADVANCE(105);
      if (lookahead == 's') ADVANCE(71);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '}') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(13)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == '_') ADVANCE(59);
      if (lookahead == '`') ADVANCE(118);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'n') ADVANCE(105);
      if (lookahead == 's') ADVANCE(71);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == '{') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(14)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(125);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(15)
      END_STATE();
    case 16:
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == 's') ADVANCE(71);
      if (lookahead == '{') ADVANCE(133);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(16)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 17:
      if (lookahead == '#') ADVANCE(125);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(17)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 18:
      if (lookahead == '#') ADVANCE(119);
      if (lookahead == '`') ADVANCE(118);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) ADVANCE(120);
      if (lookahead != 0) ADVANCE(121);
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(49);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(45);
      END_STATE();
    case 21:
      if (lookahead == 'h') ADVANCE(139);
      END_STATE();
    case 22:
      if (lookahead == 'i') ADVANCE(25);
      END_STATE();
    case 23:
      if (lookahead == 'n') ADVANCE(145);
      END_STATE();
    case 24:
      if (lookahead == 's') ADVANCE(142);
      END_STATE();
    case 25:
      if (lookahead == 't') ADVANCE(21);
      END_STATE();
    case 26:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(136);
      END_STATE();
    case 27:
      if (eof) ADVANCE(35);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '&') ADVANCE(57);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(124);
      if (lookahead == '*') ADVANCE(55);
      if (lookahead == '+') ADVANCE(54);
      if (lookahead == ',') ADVANCE(36);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == ':') ADVANCE(20);
      if (lookahead == '<') ADVANCE(50);
      if (lookahead == '=') ADVANCE(47);
      if (lookahead == '>') ADVANCE(51);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == '`') ADVANCE(118);
      if (lookahead == 'd') ADVANCE(64);
      if (lookahead == 'e') ADVANCE(78);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'n') ADVANCE(88);
      if (lookahead == 's') ADVANCE(70);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == 'w') ADVANCE(77);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '|') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(27)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 28:
      if (eof) ADVANCE(35);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '&') ADVANCE(57);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '*') ADVANCE(55);
      if (lookahead == '+') ADVANCE(54);
      if (lookahead == ',') ADVANCE(36);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == ':') ADVANCE(20);
      if (lookahead == '<') ADVANCE(50);
      if (lookahead == '=') ADVANCE(47);
      if (lookahead == '>') ADVANCE(51);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == '`') ADVANCE(118);
      if (lookahead == 'd') ADVANCE(64);
      if (lookahead == 'e') ADVANCE(78);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(85);
      if (lookahead == 'n') ADVANCE(88);
      if (lookahead == 's') ADVANCE(70);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == 'w') ADVANCE(77);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '|') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(28)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 29:
      if (eof) ADVANCE(35);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '&') ADVANCE(57);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ')') ADVANCE(124);
      if (lookahead == '*') ADVANCE(55);
      if (lookahead == '+') ADVANCE(54);
      if (lookahead == ',') ADVANCE(36);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == '<') ADVANCE(50);
      if (lookahead == '=') ADVANCE(47);
      if (lookahead == '>') ADVANCE(51);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == 'd') ADVANCE(64);
      if (lookahead == 'i') ADVANCE(83);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '|') ADVANCE(44);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(29)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 30:
      if (eof) ADVANCE(35);
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == ',') ADVANCE(36);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == ':') ADVANCE(20);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == '`') ADVANCE(118);
      if (lookahead == 'd') ADVANCE(64);
      if (lookahead == 'e') ADVANCE(78);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(85);
      if (lookahead == 'n') ADVANCE(88);
      if (lookahead == 's') ADVANCE(70);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == '{') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(30)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 31:
      if (eof) ADVANCE(35);
      if (lookahead == '"') ADVANCE(114);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == ':') ADVANCE(20);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == '`') ADVANCE(118);
      if (lookahead == 'd') ADVANCE(64);
      if (lookahead == 'e') ADVANCE(78);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 'n') ADVANCE(88);
      if (lookahead == 's') ADVANCE(70);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == '{') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(31)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 32:
      if (eof) ADVANCE(35);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == '(') ADVANCE(130);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == 'a') ADVANCE(96);
      if (lookahead == 'd') ADVANCE(64);
      if (lookahead == 'i') ADVANCE(83);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(32)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 33:
      if (eof) ADVANCE(35);
      if (lookahead == '#') ADVANCE(125);
      if (lookahead == 'd') ADVANCE(64);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(33)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 34:
      if (eof) ADVANCE(35);
      if (lookahead == '#') ADVANCE(125);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) SKIP(34)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\n') ADVANCE(39);
      if (lookahead == '\r') ADVANCE(38);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(39);
      if (lookahead == '\r') ADVANCE(38);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(40);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(136);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_assignment);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_unification);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_unification);
      if (lookahead == '=') ADVANCE(48);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(53);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(52);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym__);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == '(') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'a') ADVANCE(82);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'a') ADVANCE(106);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'a') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'e') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'e') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'e') ADVANCE(158);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'e') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'e') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'e') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'e') ADVANCE(100);
      if (lookahead == 'o') ADVANCE(84);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'e') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'f') ADVANCE(148);
      if (lookahead == 'n') ADVANCE(146);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'f') ADVANCE(148);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'f') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'h') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'i') ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'i') ADVANCE(102);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'l') ADVANCE(97);
      if (lookahead == 'v') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'l') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'l') ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'l') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'l') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'm') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'm') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'n') ADVANCE(146);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'n') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'n') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'o') ADVANCE(99);
      if (lookahead == 'u') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'o') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'o') ADVANCE(94);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'p') ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'r') ADVANCE(107);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'r') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'r') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 's') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 's') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 's') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 's') ADVANCE(68);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 't') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 't') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 't') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 't') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 't') ADVANCE(154);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 't') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'u') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'u') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'u') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'v') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_var);
      if (lookahead == 'y') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_var);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_var);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(111);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_null);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_null);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '#') ADVANCE(116);
      if (aux_sym_string_token1_character_set_1(lookahead)) ADVANCE(115);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(117);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '"' ||
          lookahead == '\\') ADVANCE(125);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(116);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(117);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym_raw_string_token1);
      if (lookahead == '\n') ADVANCE(121);
      if (lookahead == '`') ADVANCE(125);
      if (lookahead != 0) ADVANCE(119);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym_raw_string_token1);
      if (lookahead == '#') ADVANCE(119);
      if (anon_sym_DQUOTE_character_set_1(lookahead)) ADVANCE(120);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(121);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym_raw_string_token1);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(121);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(45);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_set_LPAREN);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(125);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_true);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_true);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_false);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_false);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_open_paren);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_open_bracket);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_close_bracket);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_open_curly);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_close_curly);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(136);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_not);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_not);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_with);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_with);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_with);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_as);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_as);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_as);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_in);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_in);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_in);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_if);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_if);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_every);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_every);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_else);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_else);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_import);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_import);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_contains);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_contains);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_some);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_some);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_default);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_default);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == '(') ADVANCE(123);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(182);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(176);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'a') ADVANCE(203);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(174);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(153);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(159);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(127);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(129);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(191);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'e') ADVANCE(198);
      if (lookahead == 'o') ADVANCE(183);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'f') ADVANCE(149);
      if (lookahead == 'm') ADVANCE(189);
      if (lookahead == 'n') ADVANCE(147);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'f') ADVANCE(165);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'h') ADVANCE(141);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'i') ADVANCE(184);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'i') ADVANCE(199);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(113);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(195);
      if (lookahead == 'v') ADVANCE(171);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(178);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(201);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'l') ADVANCE(196);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'm') ADVANCE(168);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(194);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'n') ADVANCE(202);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'o') ADVANCE(185);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'o') ADVANCE(197);
      if (lookahead == 'u') ADVANCE(180);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'o') ADVANCE(192);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'p') ADVANCE(188);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'r') ADVANCE(204);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'r') ADVANCE(205);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'r') ADVANCE(200);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 's') ADVANCE(144);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 's') ADVANCE(157);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 's') ADVANCE(167);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 's') ADVANCE(170);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 't') ADVANCE(138);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 't') ADVANCE(162);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 't') ADVANCE(175);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 't') ADVANCE(155);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 't') ADVANCE(161);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 't') ADVANCE(164);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'u') ADVANCE(181);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'u') ADVANCE(169);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == 'y') ADVANCE(151);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_keyword);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(206);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'p') ADVANCE(1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8203) ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 8288 ||
          lookahead == 12288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'a') ADVANCE(2);
      END_STATE();
    case 2:
      if (lookahead == 'c') ADVANCE(3);
      END_STATE();
    case 3:
      if (lookahead == 'k') ADVANCE(4);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(5);
      END_STATE();
    case 5:
      if (lookahead == 'g') ADVANCE(6);
      END_STATE();
    case 6:
      if (lookahead == 'e') ADVANCE(7);
      END_STATE();
    case 7:
      ACCEPT_TOKEN(sym_package);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 34},
  [2] = {.lex_state = 31},
  [3] = {.lex_state = 31},
  [4] = {.lex_state = 31},
  [5] = {.lex_state = 2},
  [6] = {.lex_state = 2},
  [7] = {.lex_state = 12},
  [8] = {.lex_state = 12},
  [9] = {.lex_state = 2},
  [10] = {.lex_state = 2},
  [11] = {.lex_state = 10},
  [12] = {.lex_state = 8},
  [13] = {.lex_state = 10},
  [14] = {.lex_state = 10},
  [15] = {.lex_state = 10},
  [16] = {.lex_state = 10},
  [17] = {.lex_state = 10},
  [18] = {.lex_state = 10},
  [19] = {.lex_state = 10},
  [20] = {.lex_state = 10},
  [21] = {.lex_state = 10},
  [22] = {.lex_state = 10},
  [23] = {.lex_state = 10},
  [24] = {.lex_state = 10},
  [25] = {.lex_state = 10},
  [26] = {.lex_state = 10},
  [27] = {.lex_state = 10},
  [28] = {.lex_state = 10},
  [29] = {.lex_state = 10},
  [30] = {.lex_state = 10},
  [31] = {.lex_state = 10},
  [32] = {.lex_state = 10},
  [33] = {.lex_state = 10},
  [34] = {.lex_state = 10},
  [35] = {.lex_state = 10},
  [36] = {.lex_state = 10},
  [37] = {.lex_state = 10},
  [38] = {.lex_state = 10},
  [39] = {.lex_state = 10},
  [40] = {.lex_state = 10},
  [41] = {.lex_state = 10},
  [42] = {.lex_state = 10},
  [43] = {.lex_state = 10},
  [44] = {.lex_state = 10},
  [45] = {.lex_state = 10},
  [46] = {.lex_state = 27},
  [47] = {.lex_state = 28},
  [48] = {.lex_state = 28},
  [49] = {.lex_state = 27},
  [50] = {.lex_state = 28},
  [51] = {.lex_state = 28},
  [52] = {.lex_state = 28},
  [53] = {.lex_state = 28},
  [54] = {.lex_state = 6},
  [55] = {.lex_state = 28},
  [56] = {.lex_state = 6},
  [57] = {.lex_state = 6},
  [58] = {.lex_state = 6},
  [59] = {.lex_state = 28},
  [60] = {.lex_state = 6},
  [61] = {.lex_state = 6},
  [62] = {.lex_state = 28},
  [63] = {.lex_state = 6},
  [64] = {.lex_state = 6},
  [65] = {.lex_state = 27},
  [66] = {.lex_state = 27},
  [67] = {.lex_state = 6},
  [68] = {.lex_state = 6},
  [69] = {.lex_state = 6},
  [70] = {.lex_state = 28},
  [71] = {.lex_state = 6},
  [72] = {.lex_state = 6},
  [73] = {.lex_state = 6},
  [74] = {.lex_state = 28},
  [75] = {.lex_state = 6},
  [76] = {.lex_state = 28},
  [77] = {.lex_state = 28},
  [78] = {.lex_state = 6},
  [79] = {.lex_state = 6},
  [80] = {.lex_state = 28},
  [81] = {.lex_state = 28},
  [82] = {.lex_state = 6},
  [83] = {.lex_state = 28},
  [84] = {.lex_state = 6},
  [85] = {.lex_state = 6},
  [86] = {.lex_state = 6},
  [87] = {.lex_state = 6},
  [88] = {.lex_state = 6},
  [89] = {.lex_state = 28},
  [90] = {.lex_state = 28},
  [91] = {.lex_state = 28},
  [92] = {.lex_state = 6},
  [93] = {.lex_state = 28},
  [94] = {.lex_state = 6},
  [95] = {.lex_state = 6},
  [96] = {.lex_state = 28},
  [97] = {.lex_state = 28},
  [98] = {.lex_state = 6},
  [99] = {.lex_state = 6},
  [100] = {.lex_state = 28},
  [101] = {.lex_state = 28},
  [102] = {.lex_state = 6},
  [103] = {.lex_state = 28},
  [104] = {.lex_state = 28},
  [105] = {.lex_state = 6},
  [106] = {.lex_state = 28},
  [107] = {.lex_state = 6},
  [108] = {.lex_state = 6},
  [109] = {.lex_state = 6},
  [110] = {.lex_state = 6},
  [111] = {.lex_state = 6},
  [112] = {.lex_state = 28},
  [113] = {.lex_state = 6},
  [114] = {.lex_state = 6},
  [115] = {.lex_state = 6},
  [116] = {.lex_state = 6},
  [117] = {.lex_state = 6},
  [118] = {.lex_state = 6},
  [119] = {.lex_state = 6},
  [120] = {.lex_state = 28},
  [121] = {.lex_state = 6},
  [122] = {.lex_state = 6},
  [123] = {.lex_state = 28},
  [124] = {.lex_state = 27},
  [125] = {.lex_state = 27},
  [126] = {.lex_state = 28},
  [127] = {.lex_state = 28},
  [128] = {.lex_state = 28},
  [129] = {.lex_state = 28},
  [130] = {.lex_state = 28},
  [131] = {.lex_state = 28},
  [132] = {.lex_state = 28},
  [133] = {.lex_state = 28},
  [134] = {.lex_state = 28},
  [135] = {.lex_state = 27},
  [136] = {.lex_state = 27},
  [137] = {.lex_state = 28},
  [138] = {.lex_state = 28},
  [139] = {.lex_state = 28},
  [140] = {.lex_state = 28},
  [141] = {.lex_state = 28},
  [142] = {.lex_state = 28},
  [143] = {.lex_state = 28},
  [144] = {.lex_state = 28},
  [145] = {.lex_state = 27},
  [146] = {.lex_state = 1},
  [147] = {.lex_state = 1},
  [148] = {.lex_state = 1},
  [149] = {.lex_state = 1},
  [150] = {.lex_state = 1},
  [151] = {.lex_state = 1},
  [152] = {.lex_state = 5},
  [153] = {.lex_state = 13},
  [154] = {.lex_state = 13},
  [155] = {.lex_state = 13},
  [156] = {.lex_state = 13},
  [157] = {.lex_state = 13},
  [158] = {.lex_state = 13},
  [159] = {.lex_state = 13},
  [160] = {.lex_state = 13},
  [161] = {.lex_state = 1},
  [162] = {.lex_state = 13},
  [163] = {.lex_state = 13},
  [164] = {.lex_state = 13},
  [165] = {.lex_state = 13},
  [166] = {.lex_state = 5},
  [167] = {.lex_state = 13},
  [168] = {.lex_state = 13},
  [169] = {.lex_state = 5},
  [170] = {.lex_state = 13},
  [171] = {.lex_state = 13},
  [172] = {.lex_state = 13},
  [173] = {.lex_state = 13},
  [174] = {.lex_state = 13},
  [175] = {.lex_state = 13},
  [176] = {.lex_state = 13},
  [177] = {.lex_state = 13},
  [178] = {.lex_state = 13},
  [179] = {.lex_state = 13},
  [180] = {.lex_state = 13},
  [181] = {.lex_state = 13},
  [182] = {.lex_state = 13},
  [183] = {.lex_state = 13},
  [184] = {.lex_state = 5},
  [185] = {.lex_state = 13},
  [186] = {.lex_state = 5},
  [187] = {.lex_state = 13},
  [188] = {.lex_state = 13},
  [189] = {.lex_state = 13},
  [190] = {.lex_state = 13},
  [191] = {.lex_state = 13},
  [192] = {.lex_state = 13},
  [193] = {.lex_state = 13},
  [194] = {.lex_state = 13},
  [195] = {.lex_state = 13},
  [196] = {.lex_state = 13},
  [197] = {.lex_state = 13},
  [198] = {.lex_state = 13},
  [199] = {.lex_state = 13},
  [200] = {.lex_state = 13},
  [201] = {.lex_state = 13},
  [202] = {.lex_state = 13},
  [203] = {.lex_state = 13},
  [204] = {.lex_state = 13},
  [205] = {.lex_state = 13},
  [206] = {.lex_state = 13},
  [207] = {.lex_state = 13},
  [208] = {.lex_state = 13},
  [209] = {.lex_state = 13},
  [210] = {.lex_state = 13},
  [211] = {.lex_state = 13},
  [212] = {.lex_state = 13},
  [213] = {.lex_state = 13},
  [214] = {.lex_state = 13},
  [215] = {.lex_state = 13},
  [216] = {.lex_state = 13},
  [217] = {.lex_state = 13},
  [218] = {.lex_state = 13},
  [219] = {.lex_state = 13},
  [220] = {.lex_state = 13},
  [221] = {.lex_state = 13},
  [222] = {.lex_state = 13},
  [223] = {.lex_state = 13},
  [224] = {.lex_state = 13},
  [225] = {.lex_state = 13},
  [226] = {.lex_state = 13},
  [227] = {.lex_state = 13},
  [228] = {.lex_state = 13},
  [229] = {.lex_state = 13},
  [230] = {.lex_state = 13},
  [231] = {.lex_state = 13},
  [232] = {.lex_state = 13},
  [233] = {.lex_state = 13},
  [234] = {.lex_state = 13},
  [235] = {.lex_state = 13},
  [236] = {.lex_state = 13},
  [237] = {.lex_state = 13},
  [238] = {.lex_state = 13},
  [239] = {.lex_state = 13},
  [240] = {.lex_state = 13},
  [241] = {.lex_state = 13},
  [242] = {.lex_state = 13},
  [243] = {.lex_state = 13},
  [244] = {.lex_state = 13},
  [245] = {.lex_state = 13},
  [246] = {.lex_state = 13},
  [247] = {.lex_state = 13},
  [248] = {.lex_state = 13},
  [249] = {.lex_state = 13},
  [250] = {.lex_state = 13},
  [251] = {.lex_state = 13},
  [252] = {.lex_state = 13},
  [253] = {.lex_state = 13},
  [254] = {.lex_state = 13},
  [255] = {.lex_state = 13},
  [256] = {.lex_state = 13},
  [257] = {.lex_state = 13},
  [258] = {.lex_state = 13},
  [259] = {.lex_state = 13},
  [260] = {.lex_state = 13},
  [261] = {.lex_state = 13},
  [262] = {.lex_state = 13},
  [263] = {.lex_state = 13},
  [264] = {.lex_state = 13},
  [265] = {.lex_state = 13},
  [266] = {.lex_state = 13},
  [267] = {.lex_state = 13},
  [268] = {.lex_state = 13},
  [269] = {.lex_state = 13},
  [270] = {.lex_state = 13},
  [271] = {.lex_state = 1},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 30},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 30},
  [276] = {.lex_state = 1},
  [277] = {.lex_state = 13},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 30},
  [280] = {.lex_state = 30},
  [281] = {.lex_state = 30},
  [282] = {.lex_state = 1},
  [283] = {.lex_state = 1},
  [284] = {.lex_state = 1},
  [285] = {.lex_state = 1},
  [286] = {.lex_state = 1},
  [287] = {.lex_state = 7},
  [288] = {.lex_state = 5},
  [289] = {.lex_state = 1},
  [290] = {.lex_state = 1},
  [291] = {.lex_state = 1},
  [292] = {.lex_state = 1},
  [293] = {.lex_state = 1},
  [294] = {.lex_state = 1},
  [295] = {.lex_state = 1},
  [296] = {.lex_state = 1},
  [297] = {.lex_state = 1},
  [298] = {.lex_state = 1},
  [299] = {.lex_state = 1},
  [300] = {.lex_state = 1},
  [301] = {.lex_state = 1},
  [302] = {.lex_state = 1},
  [303] = {.lex_state = 1},
  [304] = {.lex_state = 7},
  [305] = {.lex_state = 1},
  [306] = {.lex_state = 1},
  [307] = {.lex_state = 7},
  [308] = {.lex_state = 1},
  [309] = {.lex_state = 7},
  [310] = {.lex_state = 1},
  [311] = {.lex_state = 1},
  [312] = {.lex_state = 7},
  [313] = {.lex_state = 1},
  [314] = {.lex_state = 5},
  [315] = {.lex_state = 5},
  [316] = {.lex_state = 5},
  [317] = {.lex_state = 5},
  [318] = {.lex_state = 5},
  [319] = {.lex_state = 5},
  [320] = {.lex_state = 5},
  [321] = {.lex_state = 5},
  [322] = {.lex_state = 1},
  [323] = {.lex_state = 5},
  [324] = {.lex_state = 5},
  [325] = {.lex_state = 5},
  [326] = {.lex_state = 29},
  [327] = {.lex_state = 5},
  [328] = {.lex_state = 28},
  [329] = {.lex_state = 28},
  [330] = {.lex_state = 5},
  [331] = {.lex_state = 5},
  [332] = {.lex_state = 1},
  [333] = {.lex_state = 5},
  [334] = {.lex_state = 5},
  [335] = {.lex_state = 5},
  [336] = {.lex_state = 5},
  [337] = {.lex_state = 5},
  [338] = {.lex_state = 5},
  [339] = {.lex_state = 1},
  [340] = {.lex_state = 1},
  [341] = {.lex_state = 5},
  [342] = {.lex_state = 1},
  [343] = {.lex_state = 1},
  [344] = {.lex_state = 1},
  [345] = {.lex_state = 28},
  [346] = {.lex_state = 1},
  [347] = {.lex_state = 8},
  [348] = {.lex_state = 8},
  [349] = {.lex_state = 8},
  [350] = {.lex_state = 1},
  [351] = {.lex_state = 1},
  [352] = {.lex_state = 1},
  [353] = {.lex_state = 8},
  [354] = {.lex_state = 5},
  [355] = {.lex_state = 8},
  [356] = {.lex_state = 5},
  [357] = {.lex_state = 27},
  [358] = {.lex_state = 30},
  [359] = {.lex_state = 1},
  [360] = {.lex_state = 28},
  [361] = {.lex_state = 30},
  [362] = {.lex_state = 30},
  [363] = {.lex_state = 30},
  [364] = {.lex_state = 28},
  [365] = {.lex_state = 30},
  [366] = {.lex_state = 30},
  [367] = {.lex_state = 30},
  [368] = {.lex_state = 30},
  [369] = {.lex_state = 27},
  [370] = {.lex_state = 28},
  [371] = {.lex_state = 30},
  [372] = {.lex_state = 28},
  [373] = {.lex_state = 28},
  [374] = {.lex_state = 30},
  [375] = {.lex_state = 30},
  [376] = {.lex_state = 30},
  [377] = {.lex_state = 30},
  [378] = {.lex_state = 5},
  [379] = {.lex_state = 5},
  [380] = {.lex_state = 30},
  [381] = {.lex_state = 30},
  [382] = {.lex_state = 27},
  [383] = {.lex_state = 28},
  [384] = {.lex_state = 1},
  [385] = {.lex_state = 30},
  [386] = {.lex_state = 30},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 1},
  [389] = {.lex_state = 1},
  [390] = {.lex_state = 5},
  [391] = {.lex_state = 30},
  [392] = {.lex_state = 30},
  [393] = {.lex_state = 5},
  [394] = {.lex_state = 5},
  [395] = {.lex_state = 30},
  [396] = {.lex_state = 30},
  [397] = {.lex_state = 5},
  [398] = {.lex_state = 1},
  [399] = {.lex_state = 1},
  [400] = {.lex_state = 27},
  [401] = {.lex_state = 5},
  [402] = {.lex_state = 28},
  [403] = {.lex_state = 7},
  [404] = {.lex_state = 1},
  [405] = {.lex_state = 7},
  [406] = {.lex_state = 1},
  [407] = {.lex_state = 7},
  [408] = {.lex_state = 30},
  [409] = {.lex_state = 7},
  [410] = {.lex_state = 30},
  [411] = {.lex_state = 7},
  [412] = {.lex_state = 7},
  [413] = {.lex_state = 0},
  [414] = {.lex_state = 0},
  [415] = {.lex_state = 7},
  [416] = {.lex_state = 7},
  [417] = {.lex_state = 7},
  [418] = {.lex_state = 7},
  [419] = {.lex_state = 7},
  [420] = {.lex_state = 5},
  [421] = {.lex_state = 7},
  [422] = {.lex_state = 7},
  [423] = {.lex_state = 7},
  [424] = {.lex_state = 7},
  [425] = {.lex_state = 7},
  [426] = {.lex_state = 7},
  [427] = {.lex_state = 30},
  [428] = {.lex_state = 1},
  [429] = {.lex_state = 5},
  [430] = {.lex_state = 1},
  [431] = {.lex_state = 7},
  [432] = {.lex_state = 7},
  [433] = {.lex_state = 0},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 7},
  [436] = {.lex_state = 1},
  [437] = {.lex_state = 7},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 1},
  [440] = {.lex_state = 30},
  [441] = {.lex_state = 1},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 30},
  [445] = {.lex_state = 1},
  [446] = {.lex_state = 30},
  [447] = {.lex_state = 5},
  [448] = {.lex_state = 30},
  [449] = {.lex_state = 30},
  [450] = {.lex_state = 9},
  [451] = {.lex_state = 30},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 30},
  [454] = {.lex_state = 30},
  [455] = {.lex_state = 0},
  [456] = {.lex_state = 1},
  [457] = {.lex_state = 30},
  [458] = {.lex_state = 30},
  [459] = {.lex_state = 7},
  [460] = {.lex_state = 14},
  [461] = {.lex_state = 7},
  [462] = {.lex_state = 14},
  [463] = {.lex_state = 14},
  [464] = {.lex_state = 7},
  [465] = {.lex_state = 14},
  [466] = {.lex_state = 7},
  [467] = {.lex_state = 7},
  [468] = {.lex_state = 14},
  [469] = {.lex_state = 7},
  [470] = {.lex_state = 7},
  [471] = {.lex_state = 14},
  [472] = {.lex_state = 14},
  [473] = {.lex_state = 7},
  [474] = {.lex_state = 7},
  [475] = {.lex_state = 14},
  [476] = {.lex_state = 7},
  [477] = {.lex_state = 7},
  [478] = {.lex_state = 7},
  [479] = {.lex_state = 8},
  [480] = {.lex_state = 8},
  [481] = {.lex_state = 31},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 11},
  [484] = {.lex_state = 31},
  [485] = {.lex_state = 31},
  [486] = {.lex_state = 8},
  [487] = {.lex_state = 31},
  [488] = {.lex_state = 8},
  [489] = {.lex_state = 8},
  [490] = {.lex_state = 8},
  [491] = {.lex_state = 31},
  [492] = {.lex_state = 9},
  [493] = {.lex_state = 8},
  [494] = {.lex_state = 8},
  [495] = {.lex_state = 8},
  [496] = {.lex_state = 8},
  [497] = {.lex_state = 8},
  [498] = {.lex_state = 8},
  [499] = {.lex_state = 8},
  [500] = {.lex_state = 8},
  [501] = {.lex_state = 8},
  [502] = {.lex_state = 8},
  [503] = {.lex_state = 8},
  [504] = {.lex_state = 8},
  [505] = {.lex_state = 8},
  [506] = {.lex_state = 8},
  [507] = {.lex_state = 8},
  [508] = {.lex_state = 8},
  [509] = {.lex_state = 8},
  [510] = {.lex_state = 8},
  [511] = {.lex_state = 8},
  [512] = {.lex_state = 8},
  [513] = {.lex_state = 8},
  [514] = {.lex_state = 8},
  [515] = {.lex_state = 9},
  [516] = {.lex_state = 8},
  [517] = {.lex_state = 8},
  [518] = {.lex_state = 8},
  [519] = {.lex_state = 5},
  [520] = {.lex_state = 12},
  [521] = {.lex_state = 5},
  [522] = {.lex_state = 12},
  [523] = {.lex_state = 5},
  [524] = {.lex_state = 5},
  [525] = {.lex_state = 5},
  [526] = {.lex_state = 5},
  [527] = {.lex_state = 5},
  [528] = {.lex_state = 12},
  [529] = {.lex_state = 12},
  [530] = {.lex_state = 5},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 16},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 16},
  [539] = {.lex_state = 6},
  [540] = {.lex_state = 6},
  [541] = {.lex_state = 6},
  [542] = {.lex_state = 6},
  [543] = {.lex_state = 6},
  [544] = {.lex_state = 6},
  [545] = {.lex_state = 32},
  [546] = {.lex_state = 5},
  [547] = {.lex_state = 29},
  [548] = {.lex_state = 32},
  [549] = {.lex_state = 32},
  [550] = {.lex_state = 29},
  [551] = {.lex_state = 29},
  [552] = {.lex_state = 29},
  [553] = {.lex_state = 32},
  [554] = {.lex_state = 13},
  [555] = {.lex_state = 29},
  [556] = {.lex_state = 29},
  [557] = {.lex_state = 1},
  [558] = {.lex_state = 1},
  [559] = {.lex_state = 1},
  [560] = {.lex_state = 1},
  [561] = {.lex_state = 1},
  [562] = {.lex_state = 29},
  [563] = {.lex_state = 29},
  [564] = {.lex_state = 29},
  [565] = {.lex_state = 29},
  [566] = {.lex_state = 29},
  [567] = {.lex_state = 29},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 29},
  [570] = {.lex_state = 1},
  [571] = {.lex_state = 1},
  [572] = {.lex_state = 29},
  [573] = {.lex_state = 1},
  [574] = {.lex_state = 29},
  [575] = {.lex_state = 29},
  [576] = {.lex_state = 29},
  [577] = {.lex_state = 29},
  [578] = {.lex_state = 32},
  [579] = {.lex_state = 1},
  [580] = {.lex_state = 1},
  [581] = {.lex_state = 32},
  [582] = {.lex_state = 32},
  [583] = {.lex_state = 32},
  [584] = {.lex_state = 1},
  [585] = {.lex_state = 29},
  [586] = {.lex_state = 29},
  [587] = {.lex_state = 32},
  [588] = {.lex_state = 29},
  [589] = {.lex_state = 32},
  [590] = {.lex_state = 1},
  [591] = {.lex_state = 32},
  [592] = {.lex_state = 29},
  [593] = {.lex_state = 32},
  [594] = {.lex_state = 32},
  [595] = {.lex_state = 32},
  [596] = {.lex_state = 32},
  [597] = {.lex_state = 32},
  [598] = {.lex_state = 1},
  [599] = {.lex_state = 1},
  [600] = {.lex_state = 1},
  [601] = {.lex_state = 1},
  [602] = {.lex_state = 1},
  [603] = {.lex_state = 32},
  [604] = {.lex_state = 32},
  [605] = {.lex_state = 32},
  [606] = {.lex_state = 32},
  [607] = {.lex_state = 1},
  [608] = {.lex_state = 29},
  [609] = {.lex_state = 1},
  [610] = {.lex_state = 32},
  [611] = {.lex_state = 29},
  [612] = {.lex_state = 1},
  [613] = {.lex_state = 1},
  [614] = {.lex_state = 32},
  [615] = {.lex_state = 29},
  [616] = {.lex_state = 1},
  [617] = {.lex_state = 32},
  [618] = {.lex_state = 1},
  [619] = {.lex_state = 32},
  [620] = {.lex_state = 29},
  [621] = {.lex_state = 1},
  [622] = {.lex_state = 32},
  [623] = {.lex_state = 5},
  [624] = {.lex_state = 33},
  [625] = {.lex_state = 29},
  [626] = {.lex_state = 33},
  [627] = {.lex_state = 5},
  [628] = {.lex_state = 5},
  [629] = {.lex_state = 32},
  [630] = {.lex_state = 5},
  [631] = {.lex_state = 5},
  [632] = {.lex_state = 5},
  [633] = {.lex_state = 2},
  [634] = {.lex_state = 2},
  [635] = {.lex_state = 2},
  [636] = {.lex_state = 5},
  [637] = {.lex_state = 5},
  [638] = {.lex_state = 5},
  [639] = {.lex_state = 5},
  [640] = {.lex_state = 2},
  [641] = {.lex_state = 2},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 5},
  [644] = {.lex_state = 5},
  [645] = {.lex_state = 5},
  [646] = {.lex_state = 2},
  [647] = {.lex_state = 5},
  [648] = {.lex_state = 5},
  [649] = {.lex_state = 5},
  [650] = {.lex_state = 5},
  [651] = {.lex_state = 5},
  [652] = {.lex_state = 2},
  [653] = {.lex_state = 2},
  [654] = {.lex_state = 5},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 5},
  [657] = {.lex_state = 5},
  [658] = {.lex_state = 5},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 5},
  [663] = {.lex_state = 29},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 29},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 5},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 5},
  [671] = {.lex_state = 18},
  [672] = {.lex_state = 5},
  [673] = {.lex_state = 5},
  [674] = {.lex_state = 5},
  [675] = {.lex_state = 3},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 18},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 18},
  [682] = {.lex_state = 3},
  [683] = {.lex_state = 18},
  [684] = {.lex_state = 3},
  [685] = {.lex_state = 3},
  [686] = {.lex_state = 18},
  [687] = {.lex_state = 3},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 18},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 3},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 3},
  [699] = {.lex_state = 18},
  [700] = {.lex_state = 3},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 3},
  [705] = {.lex_state = 18},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 18},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 18},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 18},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 3},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 5},
  [719] = {.lex_state = 5},
  [720] = {.lex_state = 3},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 18},
  [724] = {.lex_state = 3},
  [725] = {.lex_state = 5},
  [726] = {.lex_state = 18},
  [727] = {.lex_state = 3},
  [728] = {.lex_state = 5},
  [729] = {.lex_state = 5},
  [730] = {.lex_state = 5},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 5},
  [733] = {.lex_state = 5},
  [734] = {.lex_state = 5},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 17},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 5},
  [742] = {.lex_state = 5},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 5},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 5},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 5},
  [750] = {.lex_state = 5},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 5},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 5},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 5},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 17},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 17},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 17},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 17},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 17},
  [789] = {.lex_state = 17},
  [790] = {.lex_state = 17},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 4},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 17},
  [800] = {.lex_state = 17},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 17},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 17},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 0},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 17},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 17},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 17},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 17},
  [819] = {.lex_state = 17},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 17},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 17},
  [829] = {.lex_state = 17},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 4},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 17},
  [842] = {.lex_state = 17},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_keyword] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [sym_assignment] = ACTIONS(1),
    [sym_unification] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_null] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_set_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_open_paren] = ACTIONS(1),
    [sym_open_bracket] = ACTIONS(1),
    [sym_close_bracket] = ACTIONS(1),
    [sym_open_curly] = ACTIONS(1),
    [sym_close_curly] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_not] = ACTIONS(1),
    [sym_with] = ACTIONS(1),
    [sym_as] = ACTIONS(1),
    [sym_in] = ACTIONS(1),
    [sym_if] = ACTIONS(1),
    [sym_every] = ACTIONS(1),
    [sym_else] = ACTIONS(1),
    [sym_package] = ACTIONS(1),
    [sym_import] = ACTIONS(1),
    [sym_contains] = ACTIONS(1),
    [sym_some] = ACTIONS(1),
    [sym_default] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(838),
    [sym_module] = STATE(832),
    [sym__package] = STATE(555),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [sym_package] = ACTIONS(7),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      ts_builtin_sym_end,
    ACTIONS(11), 1,
      anon_sym_DASH,
    ACTIONS(13), 1,
      sym_assignment,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(27), 1,
      sym_open_paren,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(31), 1,
      sym_open_curly,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(35), 1,
      sym_not,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(39), 1,
      sym_else,
    ACTIONS(41), 1,
      sym_some,
    STATE(46), 1,
      sym_expr,
    STATE(47), 1,
      sym_expr_call,
    STATE(129), 1,
      sym_raw_string,
    STATE(139), 1,
      sym_term,
    STATE(400), 1,
      sym_some_decl,
    STATE(484), 1,
      sym_literal,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(15), 2,
      sym_var,
      sym_default,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(3), 2,
      sym_rule_body,
      aux_sym_rule_repeat1,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [109] = 32,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      ts_builtin_sym_end,
    ACTIONS(45), 1,
      anon_sym_DASH,
    ACTIONS(48), 1,
      sym_assignment,
    ACTIONS(51), 1,
      sym_var,
    ACTIONS(54), 1,
      anon_sym_null,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(60), 1,
      anon_sym_BQUOTE,
    ACTIONS(63), 1,
      anon_sym_set_LPAREN,
    ACTIONS(69), 1,
      sym_open_paren,
    ACTIONS(72), 1,
      sym_open_bracket,
    ACTIONS(75), 1,
      sym_open_curly,
    ACTIONS(78), 1,
      sym_number,
    ACTIONS(81), 1,
      sym_not,
    ACTIONS(84), 1,
      sym_every,
    ACTIONS(87), 1,
      sym_else,
    ACTIONS(90), 1,
      sym_some,
    ACTIONS(93), 1,
      sym_default,
    STATE(46), 1,
      sym_expr,
    STATE(47), 1,
      sym_expr_call,
    STATE(129), 1,
      sym_raw_string,
    STATE(139), 1,
      sym_term,
    STATE(400), 1,
      sym_some_decl,
    STATE(484), 1,
      sym_literal,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(66), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(3), 2,
      sym_rule_body,
      aux_sym_rule_repeat1,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [220] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_DASH,
    ACTIONS(13), 1,
      sym_assignment,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(27), 1,
      sym_open_paren,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(31), 1,
      sym_open_curly,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(35), 1,
      sym_not,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(39), 1,
      sym_else,
    ACTIONS(41), 1,
      sym_some,
    ACTIONS(95), 1,
      ts_builtin_sym_end,
    STATE(46), 1,
      sym_expr,
    STATE(47), 1,
      sym_expr_call,
    STATE(129), 1,
      sym_raw_string,
    STATE(139), 1,
      sym_term,
    STATE(400), 1,
      sym_some_decl,
    STATE(484), 1,
      sym_literal,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(97), 2,
      sym_var,
      sym_default,
    STATE(3), 2,
      sym_rule_body,
      aux_sym_rule_repeat1,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [329] = 27,
    ACTIONS(101), 1,
      anon_sym_DASH,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(107), 1,
      anon_sym_DQUOTE,
    ACTIONS(109), 1,
      anon_sym_BQUOTE,
    ACTIONS(111), 1,
      anon_sym_set_LPAREN,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(117), 1,
      sym_open_paren,
    ACTIONS(119), 1,
      sym_open_bracket,
    ACTIONS(121), 1,
      sym_open_curly,
    ACTIONS(123), 1,
      sym_not,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(127), 1,
      sym_some,
    STATE(151), 1,
      sym_expr_call,
    STATE(272), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(456), 1,
      sym_term,
    STATE(602), 1,
      sym_some_decl,
    STATE(640), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(105), 2,
      anon_sym_null,
      sym_number,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    ACTIONS(99), 4,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [428] = 27,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(107), 1,
      anon_sym_DQUOTE,
    ACTIONS(109), 1,
      anon_sym_BQUOTE,
    ACTIONS(111), 1,
      anon_sym_set_LPAREN,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(117), 1,
      sym_open_paren,
    ACTIONS(119), 1,
      sym_open_bracket,
    ACTIONS(121), 1,
      sym_open_curly,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(640), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(105), 2,
      anon_sym_null,
      sym_number,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    ACTIONS(99), 4,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [527] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_DASH,
    ACTIONS(13), 1,
      sym_assignment,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(27), 1,
      sym_open_paren,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(31), 1,
      sym_open_curly,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(35), 1,
      sym_not,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(39), 1,
      sym_else,
    ACTIONS(41), 1,
      sym_some,
    ACTIONS(135), 1,
      sym_var,
    STATE(46), 1,
      sym_expr,
    STATE(47), 1,
      sym_expr_call,
    STATE(129), 1,
      sym_raw_string,
    STATE(139), 1,
      sym_term,
    STATE(400), 1,
      sym_some_decl,
    STATE(484), 1,
      sym_literal,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(4), 2,
      sym_rule_body,
      aux_sym_rule_repeat1,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [632] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_DASH,
    ACTIONS(13), 1,
      sym_assignment,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(27), 1,
      sym_open_paren,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(31), 1,
      sym_open_curly,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(35), 1,
      sym_not,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(39), 1,
      sym_else,
    ACTIONS(41), 1,
      sym_some,
    ACTIONS(135), 1,
      sym_var,
    STATE(46), 1,
      sym_expr,
    STATE(47), 1,
      sym_expr_call,
    STATE(129), 1,
      sym_raw_string,
    STATE(139), 1,
      sym_term,
    STATE(400), 1,
      sym_some_decl,
    STATE(484), 1,
      sym_literal,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(2), 2,
      sym_rule_body,
      aux_sym_rule_repeat1,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [737] = 27,
    ACTIONS(101), 1,
      anon_sym_DASH,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(107), 1,
      anon_sym_DQUOTE,
    ACTIONS(109), 1,
      anon_sym_BQUOTE,
    ACTIONS(111), 1,
      anon_sym_set_LPAREN,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(117), 1,
      sym_open_paren,
    ACTIONS(119), 1,
      sym_open_bracket,
    ACTIONS(121), 1,
      sym_open_curly,
    ACTIONS(123), 1,
      sym_not,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(127), 1,
      sym_some,
    STATE(151), 1,
      sym_expr_call,
    STATE(272), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(456), 1,
      sym_term,
    STATE(602), 1,
      sym_some_decl,
    STATE(635), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(105), 2,
      anon_sym_null,
      sym_number,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    ACTIONS(137), 4,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [836] = 27,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(107), 1,
      anon_sym_DQUOTE,
    ACTIONS(109), 1,
      anon_sym_BQUOTE,
    ACTIONS(111), 1,
      anon_sym_set_LPAREN,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(117), 1,
      sym_open_paren,
    ACTIONS(119), 1,
      sym_open_bracket,
    ACTIONS(121), 1,
      sym_open_curly,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(129), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(635), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(105), 2,
      anon_sym_null,
      sym_number,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    ACTIONS(137), 4,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [935] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_DASH,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(27), 1,
      sym_open_paren,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(35), 1,
      sym_not,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(41), 1,
      sym_some,
    ACTIONS(135), 1,
      sym_var,
    ACTIONS(139), 1,
      sym_assignment,
    ACTIONS(141), 1,
      sym_unification,
    ACTIONS(143), 1,
      sym_open_curly,
    STATE(46), 1,
      sym_expr,
    STATE(47), 1,
      sym_expr_call,
    STATE(129), 1,
      sym_raw_string,
    STATE(139), 1,
      sym_term,
    STATE(217), 1,
      sym_assignment_operator,
    STATE(400), 1,
      sym_some_decl,
    STATE(481), 1,
      sym_literal,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [1039] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_DASH,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(27), 1,
      sym_open_paren,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(35), 1,
      sym_not,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(41), 1,
      sym_some,
    ACTIONS(135), 1,
      sym_var,
    ACTIONS(145), 1,
      anon_sym_COMMA,
    ACTIONS(147), 1,
      sym_assignment,
    ACTIONS(149), 1,
      sym_open_curly,
    ACTIONS(151), 1,
      sym_in,
    STATE(46), 1,
      sym_expr,
    STATE(47), 1,
      sym_expr_call,
    STATE(129), 1,
      sym_raw_string,
    STATE(139), 1,
      sym_term,
    STATE(400), 1,
      sym_some_decl,
    STATE(487), 1,
      sym_literal,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [1143] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(155), 1,
      sym_var,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(384), 1,
      sym_term,
    STATE(398), 1,
      sym_membership,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(660), 1,
      sym_object_item,
    STATE(767), 1,
      sym_query,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(389), 2,
      sym_ref,
      sym_scalar,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [1246] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(155), 1,
      sym_var,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(384), 1,
      sym_term,
    STATE(398), 1,
      sym_membership,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(660), 1,
      sym_object_item,
    STATE(774), 1,
      sym_fn_name,
    STATE(839), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(389), 2,
      sym_ref,
      sym_scalar,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [1349] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(155), 1,
      sym_var,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(384), 1,
      sym_term,
    STATE(398), 1,
      sym_membership,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(660), 1,
      sym_object_item,
    STATE(774), 1,
      sym_fn_name,
    STATE(806), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(389), 2,
      sym_ref,
      sym_scalar,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [1452] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(823), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [1550] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(815), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [1648] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(771), 1,
      sym_query,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [1746] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(123), 1,
      sym_not,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(127), 1,
      sym_some,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(171), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(272), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(456), 1,
      sym_term,
    STATE(602), 1,
      sym_some_decl,
    STATE(634), 1,
      sym_literal,
    STATE(761), 1,
      sym_query,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [1844] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(796), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [1942] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(123), 1,
      sym_not,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(127), 1,
      sym_some,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(171), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(272), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(456), 1,
      sym_term,
    STATE(602), 1,
      sym_some_decl,
    STATE(634), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(837), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [2040] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(836), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [2138] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(840), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [2236] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(834), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [2334] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(833), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [2432] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(780), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [2530] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(831), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [2628] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(760), 1,
      sym_query,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [2726] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(123), 1,
      sym_not,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(127), 1,
      sym_some,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(171), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(272), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(456), 1,
      sym_term,
    STATE(602), 1,
      sym_some_decl,
    STATE(634), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(795), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [2824] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(759), 1,
      sym_query,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [2922] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(123), 1,
      sym_not,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(127), 1,
      sym_some,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(171), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(272), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(456), 1,
      sym_term,
    STATE(602), 1,
      sym_some_decl,
    STATE(634), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(824), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [3020] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(794), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [3118] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(805), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [3216] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(793), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [3314] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(822), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [3412] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(803), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [3510] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(778), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [3608] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(765), 1,
      sym_query,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [3706] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(762), 1,
      sym_query,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [3804] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(123), 1,
      sym_not,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(127), 1,
      sym_some,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(171), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(272), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(456), 1,
      sym_term,
    STATE(602), 1,
      sym_some_decl,
    STATE(634), 1,
      sym_literal,
    STATE(769), 1,
      sym_query,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [3902] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(784), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [4000] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(123), 1,
      sym_not,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(127), 1,
      sym_some,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(171), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(272), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(456), 1,
      sym_term,
    STATE(602), 1,
      sym_some_decl,
    STATE(634), 1,
      sym_literal,
    STATE(758), 1,
      sym_query,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [4098] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(123), 1,
      sym_not,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(127), 1,
      sym_some,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(171), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(272), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(456), 1,
      sym_term,
    STATE(602), 1,
      sym_some_decl,
    STATE(634), 1,
      sym_literal,
    STATE(764), 1,
      sym_query,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [4196] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(123), 1,
      sym_not,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(127), 1,
      sym_some,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(171), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(272), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(456), 1,
      sym_term,
    STATE(602), 1,
      sym_some_decl,
    STATE(634), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(807), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [4294] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(131), 1,
      sym_not,
    ACTIONS(133), 1,
      sym_some,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(276), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(584), 1,
      sym_some_decl,
    STATE(633), 1,
      sym_literal,
    STATE(774), 1,
      sym_fn_name,
    STATE(814), 1,
      sym_query,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [4392] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      sym_assignment,
    ACTIONS(181), 1,
      sym_unification,
    ACTIONS(189), 1,
      sym_with,
    STATE(118), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(177), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(185), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(382), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(183), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(173), 8,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(187), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [4461] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      anon_sym_DOT,
    STATE(52), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(77), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(191), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [4514] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      anon_sym_DOT,
    STATE(52), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(77), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(191), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [4567] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      sym_assignment,
    ACTIONS(181), 1,
      sym_unification,
    ACTIONS(189), 1,
      sym_with,
    STATE(118), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(177), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(185), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(357), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(183), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(197), 8,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(199), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [4636] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(203), 1,
      anon_sym_DOT,
    ACTIONS(208), 1,
      sym_open_bracket,
    STATE(50), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(77), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(206), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(201), 19,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_curly,
      sym_number,
  [4691] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(211), 1,
      anon_sym_DOT,
    STATE(52), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(77), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(191), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [4744] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      anon_sym_DOT,
    STATE(50), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(77), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(215), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(213), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [4797] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      anon_sym_DOT,
    STATE(52), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(77), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(191), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [4850] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(229), 1,
      anon_sym_RPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(70), 1,
      sym_close_paren,
    STATE(336), 1,
      sym_expr_call,
    STATE(387), 1,
      sym_expr,
    STATE(401), 1,
      sym_raw_string,
    STATE(524), 1,
      sym_term,
    STATE(751), 1,
      sym_fn_args,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [4942] = 6,
    ACTIONS(3), 1,
      sym_comment,
    STATE(78), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(243), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(241), 19,
      ts_builtin_sym_end,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [4994] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(245), 1,
      anon_sym_RPAREN,
    STATE(336), 1,
      sym_expr_call,
    STATE(371), 1,
      sym_close_paren,
    STATE(387), 1,
      sym_expr,
    STATE(401), 1,
      sym_raw_string,
    STATE(524), 1,
      sym_term,
    STATE(746), 1,
      sym_fn_args,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [5086] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(247), 1,
      anon_sym_RPAREN,
    STATE(336), 1,
      sym_expr_call,
    STATE(387), 1,
      sym_expr,
    STATE(401), 1,
      sym_raw_string,
    STATE(524), 1,
      sym_term,
    STATE(583), 1,
      sym_close_paren,
    STATE(748), 1,
      sym_fn_args,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [5178] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(249), 1,
      anon_sym_RPAREN,
    STATE(336), 1,
      sym_expr_call,
    STATE(387), 1,
      sym_expr,
    STATE(401), 1,
      sym_raw_string,
    STATE(524), 1,
      sym_term,
    STATE(588), 1,
      sym_close_paren,
    STATE(743), 1,
      sym_fn_args,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [5270] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      sym_assignment,
    ACTIONS(181), 1,
      sym_unification,
    STATE(78), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(177), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(185), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(183), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(251), 8,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(253), 11,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [5334] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(255), 1,
      anon_sym_RPAREN,
    STATE(289), 1,
      sym_close_paren,
    STATE(336), 1,
      sym_expr_call,
    STATE(387), 1,
      sym_expr,
    STATE(401), 1,
      sym_raw_string,
    STATE(524), 1,
      sym_term,
    STATE(754), 1,
      sym_fn_args,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [5426] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(257), 1,
      anon_sym_RPAREN,
    STATE(336), 1,
      sym_expr_call,
    STATE(387), 1,
      sym_expr,
    STATE(401), 1,
      sym_raw_string,
    STATE(504), 1,
      sym_close_paren,
    STATE(524), 1,
      sym_term,
    STATE(756), 1,
      sym_fn_args,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [5518] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      sym_assignment,
    ACTIONS(181), 1,
      sym_unification,
    STATE(78), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(177), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(185), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(183), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(259), 8,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(261), 11,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [5582] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(263), 1,
      anon_sym_RPAREN,
    STATE(319), 1,
      sym_close_paren,
    STATE(336), 1,
      sym_expr_call,
    STATE(387), 1,
      sym_expr,
    STATE(401), 1,
      sym_raw_string,
    STATE(524), 1,
      sym_term,
    STATE(752), 1,
      sym_fn_args,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [5674] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(265), 1,
      anon_sym_RPAREN,
    STATE(336), 1,
      sym_expr_call,
    STATE(387), 1,
      sym_expr,
    STATE(401), 1,
      sym_raw_string,
    STATE(411), 1,
      sym_close_paren,
    STATE(524), 1,
      sym_term,
    STATE(739), 1,
      sym_fn_args,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [5766] = 6,
    ACTIONS(3), 1,
      sym_comment,
    STATE(118), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(243), 13,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(241), 19,
      ts_builtin_sym_end,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [5817] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      sym_assignment,
    ACTIONS(181), 1,
      sym_unification,
    STATE(118), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(177), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(185), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(183), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(259), 8,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(261), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [5880] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(267), 1,
      anon_sym_DASH,
    STATE(354), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(482), 1,
      sym_expr,
    STATE(525), 1,
      sym_term,
    STATE(537), 1,
      sym_expr_infix,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(124), 3,
      sym_expr_parens,
      sym_expr_every,
      sym_expr_unary,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [5965] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(171), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(340), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(456), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [6048] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(267), 1,
      anon_sym_DASH,
    STATE(354), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(482), 1,
      sym_expr,
    STATE(523), 1,
      sym_term,
    STATE(534), 1,
      sym_expr_infix,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(124), 3,
      sym_expr_parens,
      sym_expr_every,
      sym_expr_unary,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [6133] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(271), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(269), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [6176] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(267), 1,
      anon_sym_DASH,
    STATE(356), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(482), 1,
      sym_expr,
    STATE(527), 1,
      sym_term,
    STATE(535), 1,
      sym_expr_infix,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(124), 3,
      sym_expr_parens,
      sym_expr_every,
      sym_expr_unary,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [6261] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(273), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(297), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(359), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [6344] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(267), 1,
      anon_sym_DASH,
    STATE(356), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(482), 1,
      sym_expr,
    STATE(526), 1,
      sym_term,
    STATE(536), 1,
      sym_expr_infix,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(124), 3,
      sym_expr_parens,
      sym_expr_every,
      sym_expr_unary,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [6429] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(275), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [6472] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(339), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [6555] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(279), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [6598] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(283), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [6641] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(135), 1,
      sym_var,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      sym_open_paren,
    ACTIONS(291), 1,
      sym_open_curly,
    ACTIONS(293), 1,
      sym_every,
    STATE(47), 1,
      sym_expr_call,
    STATE(55), 1,
      sym_expr,
    STATE(129), 1,
      sym_raw_string,
    STATE(130), 1,
      sym_term,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(143), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [6724] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(135), 1,
      sym_var,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      sym_open_paren,
    ACTIONS(291), 1,
      sym_open_curly,
    ACTIONS(293), 1,
      sym_every,
    STATE(47), 1,
      sym_expr_call,
    STATE(59), 1,
      sym_expr,
    STATE(126), 1,
      sym_term,
    STATE(129), 1,
      sym_raw_string,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(143), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [6807] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(295), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [6850] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(301), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(299), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [6893] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_DASH,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(27), 1,
      sym_open_paren,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(135), 1,
      sym_var,
    ACTIONS(291), 1,
      sym_open_curly,
    STATE(47), 1,
      sym_expr_call,
    STATE(49), 1,
      sym_expr,
    STATE(129), 1,
      sym_raw_string,
    STATE(139), 1,
      sym_term,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [6976] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(303), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [7019] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(135), 1,
      sym_var,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      sym_open_paren,
    ACTIONS(291), 1,
      sym_open_curly,
    ACTIONS(293), 1,
      sym_every,
    STATE(47), 1,
      sym_expr_call,
    STATE(59), 1,
      sym_expr,
    STATE(129), 1,
      sym_raw_string,
    STATE(130), 1,
      sym_term,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(143), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [7102] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(267), 1,
      anon_sym_DASH,
    STATE(336), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(442), 1,
      sym_expr,
    STATE(519), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [7185] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(336), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(414), 1,
      sym_expr,
    STATE(524), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [7268] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_DASH,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(27), 1,
      sym_open_paren,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(135), 1,
      sym_var,
    ACTIONS(291), 1,
      sym_open_curly,
    STATE(47), 1,
      sym_expr_call,
    STATE(66), 1,
      sym_expr,
    STATE(129), 1,
      sym_raw_string,
    STATE(139), 1,
      sym_term,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [7351] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(135), 1,
      sym_var,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      sym_open_paren,
    ACTIONS(291), 1,
      sym_open_curly,
    ACTIONS(293), 1,
      sym_every,
    STATE(47), 1,
      sym_expr_call,
    STATE(62), 1,
      sym_expr,
    STATE(129), 1,
      sym_raw_string,
    STATE(130), 1,
      sym_term,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(143), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [7434] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(309), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(307), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [7477] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(313), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(311), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [7520] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(317), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(315), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [7563] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(267), 1,
      anon_sym_DASH,
    STATE(336), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(433), 1,
      sym_expr,
    STATE(519), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [7646] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(321), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(319), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [7689] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(323), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(291), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(359), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [7772] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(323), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(291), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(439), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [7855] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(327), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(325), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [7898] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(279), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [7941] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(322), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [8024] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(171), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(332), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(456), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [8107] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(331), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(329), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [8150] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(335), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(333), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [8193] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(171), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(271), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(456), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [8276] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(339), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(337), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [8319] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(343), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(341), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [8362] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(267), 1,
      anon_sym_DASH,
    STATE(336), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(413), 1,
      sym_expr,
    STATE(519), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [8445] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(347), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(345), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [8488] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(336), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(452), 1,
      sym_expr,
    STATE(524), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [8571] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(323), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(299), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(439), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [8654] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(273), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(297), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(428), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [8737] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(153), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(151), 1,
      sym_expr_call,
    STATE(274), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(406), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [8820] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(273), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(295), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(428), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [8903] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(351), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(349), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [8946] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(323), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(301), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(439), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [9029] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(125), 1,
      sym_every,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(163), 1,
      sym_open_paren,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    ACTIONS(273), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_expr_call,
    STATE(293), 1,
      sym_expr,
    STATE(346), 1,
      sym_raw_string,
    STATE(428), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(404), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [9112] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(267), 1,
      anon_sym_DASH,
    STATE(336), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(455), 1,
      sym_expr,
    STATE(519), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [9195] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(267), 1,
      anon_sym_DASH,
    STATE(336), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(438), 1,
      sym_expr,
    STATE(519), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [9278] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(267), 1,
      anon_sym_DASH,
    STATE(336), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(443), 1,
      sym_expr,
    STATE(519), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [9361] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_DASH,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(27), 1,
      sym_open_paren,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(135), 1,
      sym_var,
    ACTIONS(291), 1,
      sym_open_curly,
    STATE(47), 1,
      sym_expr_call,
    STATE(65), 1,
      sym_expr,
    STATE(129), 1,
      sym_raw_string,
    STATE(139), 1,
      sym_term,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [9444] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(217), 1,
      anon_sym_DASH,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(336), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(434), 1,
      sym_expr,
    STATE(524), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(124), 4,
      sym_expr_parens,
      sym_expr_infix,
      sym_expr_every,
      sym_expr_unary,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [9527] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(355), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(353), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [9570] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(267), 1,
      anon_sym_DASH,
    STATE(356), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(482), 1,
      sym_expr,
    STATE(521), 1,
      sym_term,
    STATE(531), 1,
      sym_expr_infix,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(124), 3,
      sym_expr_parens,
      sym_expr_every,
      sym_expr_unary,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [9655] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_every,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(233), 1,
      sym_open_paren,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(267), 1,
      anon_sym_DASH,
    STATE(354), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(482), 1,
      sym_expr,
    STATE(530), 1,
      sym_term,
    STATE(533), 1,
      sym_expr_infix,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(124), 3,
      sym_expr_parens,
      sym_expr_every,
      sym_expr_unary,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [9740] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(359), 15,
      anon_sym_DOT,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(357), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [9783] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(363), 13,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(361), 21,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      anon_sym_RPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [9825] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(367), 13,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(365), 21,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      anon_sym_RPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [9867] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_COMMA,
    ACTIONS(363), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(361), 19,
      ts_builtin_sym_end,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [9911] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(371), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [9953] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(369), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [9995] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(377), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10037] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 1,
      anon_sym_COMMA,
    ACTIONS(363), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(361), 19,
      ts_builtin_sym_end,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10081] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(383), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10123] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(387), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10165] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(391), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10207] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(395), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10249] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 13,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(399), 21,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      anon_sym_RPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10291] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(405), 13,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(403), 21,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      anon_sym_RPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10333] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(409), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(407), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10375] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 1,
      anon_sym_COMMA,
    ACTIONS(418), 1,
      sym_in,
    ACTIONS(416), 13,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(411), 19,
      ts_builtin_sym_end,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10421] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 1,
      anon_sym_COMMA,
    ACTIONS(421), 1,
      sym_in,
    ACTIONS(363), 13,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(361), 19,
      ts_builtin_sym_end,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10467] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(423), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10509] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(405), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(403), 19,
      ts_builtin_sym_end,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10550] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(367), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(365), 19,
      ts_builtin_sym_end,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10591] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(363), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(361), 19,
      ts_builtin_sym_end,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10632] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 14,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(399), 19,
      ts_builtin_sym_end,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10673] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(321), 13,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(319), 19,
      ts_builtin_sym_end,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [10713] = 7,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(427), 1,
      anon_sym_DOT,
    ACTIONS(429), 1,
      sym_open_paren,
    ACTIONS(431), 1,
      sym_open_bracket,
    STATE(147), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(285), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 22,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [10758] = 6,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(431), 1,
      sym_open_bracket,
    ACTIONS(433), 1,
      anon_sym_DOT,
    STATE(148), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(285), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(215), 23,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [10801] = 6,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(435), 1,
      anon_sym_DOT,
    ACTIONS(438), 1,
      sym_open_bracket,
    STATE(148), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(285), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(206), 23,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [10844] = 6,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(431), 1,
      sym_open_bracket,
    ACTIONS(433), 1,
      anon_sym_DOT,
    STATE(147), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(285), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 23,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [10887] = 7,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(427), 1,
      anon_sym_DOT,
    ACTIONS(429), 1,
      sym_open_paren,
    ACTIONS(431), 1,
      sym_open_bracket,
    STATE(147), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(285), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 22,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_close_curly,
      sym_with,
      sym_in,
  [10932] = 6,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(431), 1,
      sym_open_bracket,
    ACTIONS(433), 1,
      anon_sym_DOT,
    STATE(147), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(285), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 23,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [10975] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_DOT,
    ACTIONS(444), 1,
      sym_open_bracket,
    STATE(152), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(320), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(206), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(201), 18,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [11019] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(447), 1,
      sym_var,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(420), 1,
      sym_membership,
    STATE(643), 1,
      sym_term,
    STATE(661), 1,
      sym_object_item,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(639), 2,
      sym_ref,
      sym_scalar,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [11089] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(449), 1,
      sym_close_bracket,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [11157] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(451), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [11225] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(453), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(662), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [11293] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(455), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(662), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [11361] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(457), 1,
      sym_close_bracket,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [11429] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(447), 1,
      sym_var,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(420), 1,
      sym_membership,
    STATE(644), 1,
      sym_term,
    STATE(669), 1,
      sym_object_item,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(639), 2,
      sym_ref,
      sym_scalar,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [11499] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(459), 1,
      sym_close_bracket,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [11567] = 6,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(431), 1,
      sym_open_bracket,
    ACTIONS(433), 1,
      anon_sym_DOT,
    STATE(147), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(285), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 22,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [11609] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(461), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [11677] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(463), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [11745] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(465), 1,
      sym_close_bracket,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [11813] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(467), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [11881] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(469), 1,
      anon_sym_DOT,
    ACTIONS(471), 1,
      sym_open_paren,
    ACTIONS(473), 1,
      sym_open_bracket,
    STATE(184), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(320), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(191), 18,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [11927] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(475), 1,
      sym_close_bracket,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(662), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [11995] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(477), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(662), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [12063] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_open_bracket,
    ACTIONS(479), 1,
      anon_sym_DOT,
    STATE(184), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(320), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(191), 18,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [12107] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(447), 1,
      sym_var,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(420), 1,
      sym_membership,
    STATE(636), 1,
      sym_term,
    STATE(668), 1,
      sym_object_item,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(639), 2,
      sym_ref,
      sym_scalar,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [12177] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(481), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(662), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [12245] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(667), 1,
      sym_term,
    STATE(740), 1,
      sym_rule_args,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [12313] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(447), 1,
      sym_var,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(420), 1,
      sym_membership,
    STATE(632), 1,
      sym_term,
    STATE(660), 1,
      sym_object_item,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(639), 2,
      sym_ref,
      sym_scalar,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [12383] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(483), 1,
      sym_close_bracket,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(662), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [12451] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(447), 1,
      sym_var,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(420), 1,
      sym_membership,
    STATE(637), 1,
      sym_term,
    STATE(664), 1,
      sym_object_item,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(639), 2,
      sym_ref,
      sym_scalar,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [12521] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(485), 1,
      sym_close_bracket,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(662), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [12589] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(487), 1,
      sym_close_bracket,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [12657] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(489), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(662), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [12725] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(491), 1,
      sym_close_bracket,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(662), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [12793] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(493), 1,
      sym_close_bracket,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [12861] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(447), 1,
      sym_var,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(420), 1,
      sym_membership,
    STATE(654), 1,
      sym_term,
    STATE(655), 1,
      sym_object_item,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(639), 2,
      sym_ref,
      sym_scalar,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [12931] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(495), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [12999] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(497), 1,
      sym_close_bracket,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(662), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [13067] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_open_bracket,
    ACTIONS(479), 1,
      anon_sym_DOT,
    STATE(152), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(320), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(215), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(213), 18,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [13111] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(499), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(662), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [13179] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_open_bracket,
    ACTIONS(479), 1,
      anon_sym_DOT,
    STATE(184), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(320), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(191), 18,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [13223] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(501), 1,
      sym_close_bracket,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(662), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [13291] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(503), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [13359] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(447), 1,
      sym_var,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(420), 1,
      sym_membership,
    STATE(657), 1,
      sym_term,
    STATE(721), 1,
      sym_object_item,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(639), 2,
      sym_ref,
      sym_scalar,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [13429] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(505), 1,
      sym_close_bracket,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [13497] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(507), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [13565] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(509), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(662), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [13633] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(511), 1,
      sym_close_bracket,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(662), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [13701] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(481), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(728), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [13769] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(447), 1,
      sym_var,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(420), 1,
      sym_membership,
    STATE(628), 1,
      sym_term,
    STATE(659), 1,
      sym_object_item,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(639), 2,
      sym_ref,
      sym_scalar,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [13839] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(513), 1,
      sym_close_bracket,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(662), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [13907] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(515), 1,
      sym_close_bracket,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [13975] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(447), 1,
      sym_var,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(420), 1,
      sym_membership,
    STATE(648), 1,
      sym_term,
    STATE(666), 1,
      sym_object_item,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(639), 2,
      sym_ref,
      sym_scalar,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [14045] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(517), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [14113] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(519), 1,
      sym_close_curly,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(662), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [14181] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(650), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [14246] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(747), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [14311] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(521), 1,
      sym_var,
    ACTIONS(524), 1,
      anon_sym_null,
    ACTIONS(527), 1,
      anon_sym_DQUOTE,
    ACTIONS(530), 1,
      anon_sym_BQUOTE,
    ACTIONS(533), 1,
      anon_sym_set_LPAREN,
    ACTIONS(539), 1,
      sym_open_bracket,
    ACTIONS(542), 1,
      sym_open_curly,
    ACTIONS(545), 1,
      sym_number,
    STATE(279), 1,
      sym_expr_call,
    STATE(451), 1,
      sym_term,
    STATE(457), 1,
      sym_raw_string,
    STATE(766), 1,
      sym_fn_name,
    ACTIONS(536), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(396), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(408), 2,
      sym_string,
      sym_boolean,
    STATE(458), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(281), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [14376] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(647), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [14441] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(548), 1,
      sym_var,
    ACTIONS(550), 1,
      anon_sym_null,
    ACTIONS(552), 1,
      anon_sym_DQUOTE,
    ACTIONS(554), 1,
      anon_sym_BQUOTE,
    ACTIONS(556), 1,
      anon_sym_set_LPAREN,
    ACTIONS(560), 1,
      sym_open_bracket,
    ACTIONS(562), 1,
      sym_open_curly,
    ACTIONS(564), 1,
      sym_number,
    STATE(279), 1,
      sym_expr_call,
    STATE(444), 1,
      sym_term,
    STATE(457), 1,
      sym_raw_string,
    STATE(766), 1,
      sym_fn_name,
    ACTIONS(558), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(396), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(408), 2,
      sym_string,
      sym_boolean,
    STATE(458), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(281), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [14506] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(741), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [14571] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(631), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [14636] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(574), 1,
      sym_close_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [14701] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(718), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [14766] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(135), 1,
      sym_var,
    ACTIONS(291), 1,
      sym_open_curly,
    STATE(48), 1,
      sym_expr_call,
    STATE(129), 1,
      sym_raw_string,
    STATE(383), 1,
      sym_term,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [14831] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(576), 1,
      sym_close_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [14896] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(578), 1,
      sym_close_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [14961] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(753), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [15026] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(649), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [15091] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(580), 1,
      sym_close_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [15156] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(658), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [15221] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(582), 1,
      sym_var,
    ACTIONS(584), 1,
      anon_sym_null,
    ACTIONS(586), 1,
      anon_sym_DQUOTE,
    ACTIONS(588), 1,
      anon_sym_BQUOTE,
    ACTIONS(590), 1,
      anon_sym_set_LPAREN,
    ACTIONS(594), 1,
      sym_open_bracket,
    ACTIONS(596), 1,
      sym_open_curly,
    ACTIONS(598), 1,
      sym_number,
    STATE(12), 1,
      sym_term,
    STATE(347), 1,
      sym_expr_call,
    STATE(512), 1,
      sym_raw_string,
    STATE(782), 1,
      sym_fn_name,
    ACTIONS(592), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(494), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(517), 2,
      sym_string,
      sym_boolean,
    STATE(513), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(355), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [15286] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(429), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [15351] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(670), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [15416] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(600), 1,
      sym_close_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [15481] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(161), 1,
      sym_expr_call,
    STATE(346), 1,
      sym_raw_string,
    STATE(561), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [15546] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(602), 1,
      sym_close_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [15611] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(757), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [15676] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(604), 1,
      sym_close_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [15741] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(548), 1,
      sym_var,
    ACTIONS(550), 1,
      anon_sym_null,
    ACTIONS(552), 1,
      anon_sym_DQUOTE,
    ACTIONS(554), 1,
      anon_sym_BQUOTE,
    ACTIONS(556), 1,
      anon_sym_set_LPAREN,
    ACTIONS(560), 1,
      sym_open_bracket,
    ACTIONS(562), 1,
      sym_open_curly,
    ACTIONS(564), 1,
      sym_number,
    STATE(279), 1,
      sym_expr_call,
    STATE(427), 1,
      sym_term,
    STATE(457), 1,
      sym_raw_string,
    STATE(766), 1,
      sym_fn_name,
    ACTIONS(558), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(396), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(408), 2,
      sym_string,
      sym_boolean,
    STATE(458), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(281), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [15806] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 1,
      sym_var,
    ACTIONS(608), 1,
      anon_sym_null,
    ACTIONS(610), 1,
      anon_sym_DQUOTE,
    ACTIONS(612), 1,
      anon_sym_BQUOTE,
    ACTIONS(614), 1,
      anon_sym_set_LPAREN,
    ACTIONS(618), 1,
      sym_open_bracket,
    ACTIONS(620), 1,
      sym_open_curly,
    ACTIONS(622), 1,
      sym_number,
    STATE(309), 1,
      sym_expr_call,
    STATE(459), 1,
      sym_term,
    STATE(470), 1,
      sym_raw_string,
    STATE(783), 1,
      sym_fn_name,
    ACTIONS(616), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(437), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(466), 2,
      sym_string,
      sym_boolean,
    STATE(469), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(307), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [15871] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(624), 1,
      sym_close_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [15936] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(582), 1,
      sym_var,
    ACTIONS(584), 1,
      anon_sym_null,
    ACTIONS(586), 1,
      anon_sym_DQUOTE,
    ACTIONS(588), 1,
      anon_sym_BQUOTE,
    ACTIONS(590), 1,
      anon_sym_set_LPAREN,
    ACTIONS(594), 1,
      sym_open_bracket,
    ACTIONS(596), 1,
      sym_open_curly,
    ACTIONS(598), 1,
      sym_number,
    STATE(347), 1,
      sym_expr_call,
    STATE(508), 1,
      sym_term,
    STATE(512), 1,
      sym_raw_string,
    STATE(782), 1,
      sym_fn_name,
    ACTIONS(592), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(494), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(517), 2,
      sym_string,
      sym_boolean,
    STATE(513), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(355), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [16001] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(627), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [16066] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(755), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [16131] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(161), 1,
      sym_expr_call,
    STATE(346), 1,
      sym_raw_string,
    STATE(571), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [16196] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(656), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [16261] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(645), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [16326] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(626), 1,
      sym_close_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [16391] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(628), 1,
      sym_close_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [16456] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(750), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [16521] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(135), 1,
      sym_var,
    ACTIONS(291), 1,
      sym_open_curly,
    STATE(48), 1,
      sym_expr_call,
    STATE(129), 1,
      sym_raw_string,
    STATE(328), 1,
      sym_term,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [16586] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(630), 1,
      sym_close_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [16651] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 1,
      sym_var,
    ACTIONS(608), 1,
      anon_sym_null,
    ACTIONS(610), 1,
      anon_sym_DQUOTE,
    ACTIONS(612), 1,
      anon_sym_BQUOTE,
    ACTIONS(614), 1,
      anon_sym_set_LPAREN,
    ACTIONS(618), 1,
      sym_open_bracket,
    ACTIONS(620), 1,
      sym_open_curly,
    ACTIONS(622), 1,
      sym_number,
    STATE(309), 1,
      sym_expr_call,
    STATE(461), 1,
      sym_term,
    STATE(470), 1,
      sym_raw_string,
    STATE(783), 1,
      sym_fn_name,
    ACTIONS(616), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(437), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(466), 2,
      sym_string,
      sym_boolean,
    STATE(469), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(307), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [16716] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(638), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [16781] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(548), 1,
      sym_var,
    ACTIONS(550), 1,
      anon_sym_null,
    ACTIONS(552), 1,
      anon_sym_DQUOTE,
    ACTIONS(554), 1,
      anon_sym_BQUOTE,
    ACTIONS(556), 1,
      anon_sym_set_LPAREN,
    ACTIONS(560), 1,
      sym_open_bracket,
    ACTIONS(562), 1,
      sym_open_curly,
    ACTIONS(564), 1,
      sym_number,
    STATE(279), 1,
      sym_expr_call,
    STATE(440), 1,
      sym_term,
    STATE(457), 1,
      sym_raw_string,
    STATE(766), 1,
      sym_fn_name,
    ACTIONS(558), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(396), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(408), 2,
      sym_string,
      sym_boolean,
    STATE(458), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(281), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [16846] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(651), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [16911] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(742), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [16976] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 1,
      sym_var,
    ACTIONS(608), 1,
      anon_sym_null,
    ACTIONS(610), 1,
      anon_sym_DQUOTE,
    ACTIONS(612), 1,
      anon_sym_BQUOTE,
    ACTIONS(614), 1,
      anon_sym_set_LPAREN,
    ACTIONS(618), 1,
      sym_open_bracket,
    ACTIONS(620), 1,
      sym_open_curly,
    ACTIONS(622), 1,
      sym_number,
    STATE(309), 1,
      sym_expr_call,
    STATE(464), 1,
      sym_term,
    STATE(470), 1,
      sym_raw_string,
    STATE(783), 1,
      sym_fn_name,
    ACTIONS(616), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(437), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(466), 2,
      sym_string,
      sym_boolean,
    STATE(469), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(307), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [17041] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(732), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [17106] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(161), 1,
      sym_expr_call,
    STATE(346), 1,
      sym_raw_string,
    STATE(570), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [17171] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(447), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [17236] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(161), 1,
      sym_expr_call,
    STATE(346), 1,
      sym_raw_string,
    STATE(557), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [17301] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(749), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [17366] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(719), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [17431] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(135), 1,
      sym_var,
    ACTIONS(291), 1,
      sym_open_curly,
    STATE(48), 1,
      sym_expr_call,
    STATE(128), 1,
      sym_term,
    STATE(129), 1,
      sym_raw_string,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [17496] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 1,
      sym_var,
    ACTIONS(608), 1,
      anon_sym_null,
    ACTIONS(610), 1,
      anon_sym_DQUOTE,
    ACTIONS(612), 1,
      anon_sym_BQUOTE,
    ACTIONS(614), 1,
      anon_sym_set_LPAREN,
    ACTIONS(618), 1,
      sym_open_bracket,
    ACTIONS(620), 1,
      sym_open_curly,
    ACTIONS(622), 1,
      sym_number,
    STATE(309), 1,
      sym_expr_call,
    STATE(470), 1,
      sym_raw_string,
    STATE(478), 1,
      sym_term,
    STATE(783), 1,
      sym_fn_name,
    ACTIONS(616), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(437), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(466), 2,
      sym_string,
      sym_boolean,
    STATE(469), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(307), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [17561] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(161), 1,
      sym_expr_call,
    STATE(346), 1,
      sym_raw_string,
    STATE(399), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [17626] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(548), 1,
      sym_var,
    ACTIONS(550), 1,
      anon_sym_null,
    ACTIONS(552), 1,
      anon_sym_DQUOTE,
    ACTIONS(554), 1,
      anon_sym_BQUOTE,
    ACTIONS(556), 1,
      anon_sym_set_LPAREN,
    ACTIONS(560), 1,
      sym_open_bracket,
    ACTIONS(562), 1,
      sym_open_curly,
    ACTIONS(564), 1,
      sym_number,
    STATE(279), 1,
      sym_expr_call,
    STATE(446), 1,
      sym_term,
    STATE(457), 1,
      sym_raw_string,
    STATE(766), 1,
      sym_fn_name,
    ACTIONS(558), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(396), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(408), 2,
      sym_string,
      sym_boolean,
    STATE(458), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(281), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [17691] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(630), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [17756] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(161), 1,
      sym_expr_call,
    STATE(346), 1,
      sym_raw_string,
    STATE(430), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [17821] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(161), 1,
      sym_expr_call,
    STATE(346), 1,
      sym_raw_string,
    STATE(388), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [17886] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(632), 1,
      sym_close_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [17951] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(634), 1,
      sym_close_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [18016] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(135), 1,
      sym_var,
    ACTIONS(291), 1,
      sym_open_curly,
    STATE(48), 1,
      sym_expr_call,
    STATE(129), 1,
      sym_raw_string,
    STATE(372), 1,
      sym_term,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [18081] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(161), 1,
      sym_expr_call,
    STATE(346), 1,
      sym_raw_string,
    STATE(616), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [18146] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(636), 1,
      sym_close_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [18211] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      sym_var,
    ACTIONS(105), 1,
      anon_sym_null,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(159), 1,
      anon_sym_BQUOTE,
    ACTIONS(161), 1,
      anon_sym_set_LPAREN,
    ACTIONS(165), 1,
      sym_open_bracket,
    ACTIONS(167), 1,
      sym_open_curly,
    ACTIONS(169), 1,
      sym_number,
    STATE(161), 1,
      sym_expr_call,
    STATE(346), 1,
      sym_raw_string,
    STATE(598), 1,
      sym_term,
    STATE(774), 1,
      sym_fn_name,
    ACTIONS(115), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(298), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(344), 2,
      sym_string,
      sym_boolean,
    STATE(398), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(149), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [18276] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(135), 1,
      sym_var,
    ACTIONS(291), 1,
      sym_open_curly,
    STATE(48), 1,
      sym_expr_call,
    STATE(129), 1,
      sym_raw_string,
    STATE(138), 1,
      sym_term,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [18341] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(673), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [18406] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(638), 1,
      sym_close_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [18471] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(582), 1,
      sym_var,
    ACTIONS(584), 1,
      anon_sym_null,
    ACTIONS(586), 1,
      anon_sym_DQUOTE,
    ACTIONS(588), 1,
      anon_sym_BQUOTE,
    ACTIONS(590), 1,
      anon_sym_set_LPAREN,
    ACTIONS(594), 1,
      sym_open_bracket,
    ACTIONS(596), 1,
      sym_open_curly,
    ACTIONS(598), 1,
      sym_number,
    STATE(347), 1,
      sym_expr_call,
    STATE(512), 1,
      sym_raw_string,
    STATE(518), 1,
      sym_term,
    STATE(782), 1,
      sym_fn_name,
    ACTIONS(592), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(494), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(517), 2,
      sym_string,
      sym_boolean,
    STATE(513), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(355), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [18536] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(640), 1,
      sym_close_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [18601] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_null,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_BQUOTE,
    ACTIONS(23), 1,
      anon_sym_set_LPAREN,
    ACTIONS(29), 1,
      sym_open_bracket,
    ACTIONS(33), 1,
      sym_number,
    ACTIONS(135), 1,
      sym_var,
    ACTIONS(291), 1,
      sym_open_curly,
    STATE(48), 1,
      sym_expr_call,
    STATE(129), 1,
      sym_raw_string,
    STATE(373), 1,
      sym_term,
    STATE(768), 1,
      sym_fn_name,
    ACTIONS(25), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(74), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(127), 2,
      sym_string,
      sym_boolean,
    STATE(133), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(53), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [18666] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      sym_var,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(227), 1,
      anon_sym_set_LPAREN,
    ACTIONS(235), 1,
      sym_open_bracket,
    ACTIONS(237), 1,
      sym_open_curly,
    ACTIONS(239), 1,
      sym_number,
    STATE(186), 1,
      sym_expr_call,
    STATE(401), 1,
      sym_raw_string,
    STATE(623), 1,
      sym_term,
    STATE(763), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(420), 3,
      sym_ref,
      sym_scalar,
      sym_membership,
    STATE(169), 6,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [18731] = 11,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(646), 1,
      sym_with,
    STATE(68), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(181), 2,
      sym_assignment,
      sym_unification,
    ACTIONS(644), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    STATE(621), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(199), 4,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
    ACTIONS(642), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(185), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [18781] = 11,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(646), 1,
      sym_with,
    STATE(68), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(181), 2,
      sym_assignment,
      sym_unification,
    ACTIONS(644), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    STATE(590), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(187), 4,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
    ACTIONS(642), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(185), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [18831] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(648), 1,
      anon_sym_DOT,
    ACTIONS(651), 1,
      sym_open_bracket,
    STATE(273), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(395), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(201), 10,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_curly,
      sym_number,
    ACTIONS(206), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [18873] = 11,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(654), 1,
      sym_with,
    STATE(75), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(181), 2,
      sym_assignment,
      sym_unification,
    ACTIONS(644), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    STATE(618), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(199), 4,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
    ACTIONS(642), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(185), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [18923] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(656), 1,
      anon_sym_DOT,
    STATE(273), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(395), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(215), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(213), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [18963] = 11,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(654), 1,
      sym_with,
    STATE(75), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(181), 2,
      sym_assignment,
      sym_unification,
    ACTIONS(644), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    STATE(607), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(187), 4,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
    ACTIONS(642), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(185), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [19013] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(566), 1,
      sym_var,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    STATE(401), 1,
      sym_raw_string,
    STATE(744), 1,
      sym_object_item,
    STATE(820), 1,
      sym_fn_name,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(776), 2,
      sym_ref,
      sym_scalar,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [19075] = 3,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(658), 1,
      sym_open_paren,
    ACTIONS(281), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [19109] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(656), 1,
      anon_sym_DOT,
    STATE(275), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(395), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(191), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [19149] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(660), 1,
      anon_sym_DOT,
    STATE(275), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(395), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(191), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [19189] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(656), 1,
      anon_sym_DOT,
    STATE(275), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(395), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(191), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [19229] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(297), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [19260] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(335), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [19291] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(301), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [19322] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(285), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [19353] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(281), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [19384] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(662), 1,
      anon_sym_DOT,
    STATE(312), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(435), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(213), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(215), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [19423] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(664), 1,
      sym_open_paren,
    ACTIONS(281), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(279), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [19458] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(271), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [19489] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(317), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [19520] = 9,
    ACTIONS(113), 1,
      sym_comment,
    STATE(113), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(181), 2,
      sym_assignment,
      sym_unification,
    ACTIONS(644), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(642), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(185), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(253), 6,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
      sym_with,
      sym_in,
  [19565] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(327), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [19596] = 5,
    ACTIONS(113), 1,
      sym_comment,
    STATE(114), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(243), 20,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_bracket,
      sym_with,
      sym_in,
  [19633] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(339), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [19664] = 9,
    ACTIONS(113), 1,
      sym_comment,
    STATE(114), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(181), 2,
      sym_assignment,
      sym_unification,
    ACTIONS(644), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(642), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(185), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(261), 6,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
      sym_with,
      sym_in,
  [19709] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(347), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [19740] = 9,
    ACTIONS(113), 1,
      sym_comment,
    STATE(114), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(181), 2,
      sym_assignment,
      sym_unification,
    ACTIONS(644), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(642), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(185), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(253), 6,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
      sym_with,
      sym_in,
  [19785] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(277), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [19816] = 9,
    ACTIONS(113), 1,
      sym_comment,
    STATE(113), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(181), 2,
      sym_assignment,
      sym_unification,
    ACTIONS(644), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(642), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(185), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(261), 6,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
      sym_with,
      sym_in,
  [19861] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(359), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [19892] = 5,
    ACTIONS(113), 1,
      sym_comment,
    STATE(113), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(243), 20,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_curly,
      sym_with,
      sym_in,
  [19929] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(351), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [19960] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(343), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [19991] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(666), 1,
      anon_sym_DOT,
    STATE(287), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(435), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(191), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(195), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [20030] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(355), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [20061] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(331), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [20092] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(662), 1,
      anon_sym_DOT,
    STATE(287), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(435), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(191), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(195), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [20131] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(313), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [20162] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(662), 1,
      anon_sym_DOT,
    STATE(287), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(435), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(191), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(195), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [20201] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(309), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [20232] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(305), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [20263] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(668), 1,
      anon_sym_DOT,
    ACTIONS(671), 1,
      sym_open_bracket,
    STATE(312), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(435), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(201), 9,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_curly,
      sym_number,
    ACTIONS(206), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [20304] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(321), 25,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [20335] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(327), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(325), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [20367] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(347), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(345), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [20399] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(321), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(319), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [20431] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(275), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [20463] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(295), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [20495] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(271), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(269), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [20527] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(283), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [20559] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(303), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [20591] = 9,
    ACTIONS(113), 1,
      sym_comment,
    STATE(75), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(181), 2,
      sym_assignment,
      sym_unification,
    ACTIONS(644), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(642), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(261), 5,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
      sym_with,
    ACTIONS(185), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [20635] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(355), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(353), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [20667] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(339), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(337), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [20699] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(301), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(299), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [20731] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(321), 7,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      sym_var,
      anon_sym_COLON,
      sym_import,
      sym_default,
    ACTIONS(319), 17,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_open_curly,
  [20763] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(279), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [20795] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(676), 1,
      anon_sym_COMMA,
    ACTIONS(680), 1,
      sym_in,
    STATE(329), 1,
      aux_sym_rule_args_repeat1,
    STATE(370), 1,
      aux_sym_some_decl_repeat1,
    ACTIONS(674), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(678), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [20835] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(684), 1,
      anon_sym_COMMA,
    ACTIONS(688), 1,
      sym_in,
    STATE(345), 1,
      aux_sym_rule_args_repeat1,
    STATE(364), 1,
      aux_sym_some_decl_repeat1,
    ACTIONS(682), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(686), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [20875] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(317), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(315), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [20907] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(351), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(349), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [20939] = 9,
    ACTIONS(113), 1,
      sym_comment,
    STATE(68), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(181), 2,
      sym_assignment,
      sym_unification,
    ACTIONS(644), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(642), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(261), 5,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
      sym_with,
    ACTIONS(185), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [20983] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(309), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(307), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [21015] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(313), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(311), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [21047] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(331), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(329), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [21079] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_open_bracket,
    ACTIONS(479), 1,
      anon_sym_DOT,
    STATE(184), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(320), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(191), 15,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_curly,
      sym_in,
  [21119] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(335), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(333), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [21151] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(359), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(357), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [21183] = 5,
    ACTIONS(113), 1,
      sym_comment,
    STATE(75), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(243), 19,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_curly,
      sym_with,
  [21219] = 5,
    ACTIONS(113), 1,
      sym_comment,
    STATE(68), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(243), 19,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_bracket,
      sym_with,
  [21255] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(343), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(341), 20,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_bracket,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [21287] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(397), 23,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [21316] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(409), 23,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [21345] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(373), 23,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [21374] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(692), 1,
      anon_sym_COMMA,
    STATE(345), 1,
      aux_sym_rule_args_repeat1,
    ACTIONS(690), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(695), 11,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [21409] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(379), 23,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [21438] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 1,
      anon_sym_DOT,
    STATE(348), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(495), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(191), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [21475] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 1,
      anon_sym_DOT,
    STATE(349), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(495), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(215), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(213), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [21512] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(699), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      sym_open_bracket,
    STATE(349), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(495), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(206), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(201), 9,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_curly,
      sym_number,
  [21551] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(389), 23,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [21580] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(385), 23,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [21609] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(425), 23,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_COLON,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [21638] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(705), 1,
      anon_sym_DOT,
    STATE(348), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(495), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(191), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [21675] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_open_bracket,
    ACTIONS(479), 1,
      anon_sym_DOT,
    STATE(184), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(320), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(191), 14,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_open_curly,
      sym_in,
  [21714] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 1,
      anon_sym_DOT,
    STATE(348), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(495), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(191), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [21751] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_open_bracket,
    ACTIONS(479), 1,
      anon_sym_DOT,
    STATE(184), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(320), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(191), 14,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_open_curly,
      sym_in,
  [21790] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(189), 1,
      sym_with,
    STATE(369), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    ACTIONS(709), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(707), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [21824] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(319), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(321), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [21854] = 3,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(375), 1,
      anon_sym_COMMA,
    ACTIONS(363), 21,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [21884] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 1,
      sym_in,
    STATE(360), 1,
      aux_sym_some_decl_repeat1,
    ACTIONS(251), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(253), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [21918] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(359), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [21948] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(345), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(347), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [21978] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(337), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(339), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22008] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      sym_in,
    STATE(360), 1,
      aux_sym_some_decl_repeat1,
    ACTIONS(714), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(716), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22042] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(325), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(327), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22072] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(341), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(343), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22102] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(335), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22132] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(315), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(317), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22162] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(722), 1,
      sym_with,
    STATE(369), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    ACTIONS(720), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(718), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [22196] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      sym_in,
    STATE(360), 1,
      aux_sym_some_decl_repeat1,
    ACTIONS(682), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(686), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22230] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(271), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22260] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(695), 11,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22290] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(695), 11,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22320] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(281), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22350] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(295), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(297), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22380] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(299), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(301), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22410] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(355), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22440] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(395), 18,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [22470] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(423), 18,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [22500] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(329), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(331), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22530] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(311), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(313), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22560] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(189), 1,
      sym_with,
    STATE(369), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    ACTIONS(199), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(197), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [22594] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 1,
      anon_sym_COMMA,
    ACTIONS(421), 1,
      sym_in,
    ACTIONS(725), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(727), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22628] = 5,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(729), 1,
      anon_sym_COMMA,
    ACTIONS(731), 1,
      sym_in,
    STATE(717), 1,
      aux_sym_rule_args_repeat1,
    ACTIONS(363), 19,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_curly,
      sym_with,
  [22662] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(281), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22692] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(307), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(309), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22722] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      sym_assignment,
    ACTIONS(181), 1,
      sym_unification,
    ACTIONS(733), 1,
      anon_sym_COMMA,
    ACTIONS(735), 1,
      anon_sym_RPAREN,
    STATE(119), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    STATE(706), 1,
      aux_sym_fn_args_repeat1,
    ACTIONS(177), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(185), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(183), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [22772] = 3,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(418), 3,
      anon_sym_COMMA,
      sym_close_curly,
      sym_in,
    ACTIONS(416), 19,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_bracket,
      sym_with,
  [22802] = 3,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(737), 1,
      anon_sym_COLON,
    ACTIONS(393), 21,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_curly,
      sym_with,
      sym_in,
  [22832] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(371), 18,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [22862] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(305), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22892] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(349), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(351), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [22922] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(409), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(407), 18,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [22952] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(383), 18,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [22982] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(285), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [23012] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(277), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [23042] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(387), 18,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [23072] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(393), 22,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [23100] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(375), 22,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [23128] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(189), 1,
      sym_with,
    STATE(382), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    ACTIONS(187), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(173), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [23162] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 4,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_COLON,
    ACTIONS(377), 18,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [23192] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(418), 11,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_with,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
  [23222] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(295), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(297), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23251] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(363), 21,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [23278] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(355), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23307] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(731), 1,
      sym_in,
    ACTIONS(739), 1,
      anon_sym_COMMA,
    ACTIONS(363), 19,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_curly,
      sym_with,
  [23338] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(299), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(301), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23367] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(371), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [23396] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(281), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23425] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(409), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(407), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [23454] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(271), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23483] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(315), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(317), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23512] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      sym_assignment,
    ACTIONS(181), 1,
      sym_unification,
    ACTIONS(249), 1,
      anon_sym_RPAREN,
    STATE(115), 1,
      sym_infix_operator,
    STATE(135), 1,
      sym_close_paren,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(177), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(185), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(183), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [23559] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      sym_assignment,
    ACTIONS(181), 1,
      sym_unification,
    STATE(119), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(177), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(185), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(259), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(183), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [23604] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(325), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(327), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23633] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(281), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23662] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(337), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(339), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23691] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(345), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(347), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23720] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(359), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23749] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(391), 18,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [23778] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(349), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(351), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23807] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(341), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(343), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23836] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(335), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23865] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(329), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(331), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(311), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(313), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23923] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(307), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(309), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [23952] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 1,
      anon_sym_COMMA,
    ACTIONS(418), 1,
      sym_in,
    ACTIONS(416), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(411), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [23985] = 3,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(741), 1,
      anon_sym_COMMA,
    ACTIONS(363), 20,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_bracket,
      sym_with,
      sym_in,
  [24014] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(369), 18,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_close_bracket,
      sym_open_curly,
      sym_close_curly,
      sym_as,
      sym_in,
  [24043] = 3,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(418), 2,
      anon_sym_COMMA,
      sym_in,
    ACTIONS(416), 19,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_curly,
      sym_with,
  [24072] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(319), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(321), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [24101] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(305), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [24130] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      sym_assignment,
    ACTIONS(181), 1,
      sym_unification,
    ACTIONS(255), 1,
      anon_sym_RPAREN,
    STATE(115), 1,
      sym_infix_operator,
    STATE(445), 1,
      sym_close_paren,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(177), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(185), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(183), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [24177] = 6,
    ACTIONS(3), 1,
      sym_comment,
    STATE(119), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(243), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(241), 13,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
  [24212] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(285), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [24241] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(405), 21,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [24268] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(277), 11,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [24297] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      sym_assignment,
    ACTIONS(181), 1,
      sym_unification,
    STATE(115), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(177), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(185), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(259), 2,
      anon_sym_RPAREN,
      sym_open_curly,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(183), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [24342] = 3,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(739), 1,
      anon_sym_COMMA,
    ACTIONS(363), 20,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_curly,
      sym_with,
      sym_in,
  [24371] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(745), 1,
      anon_sym_COMMA,
    ACTIONS(749), 1,
      sym_in,
    ACTIONS(747), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(743), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [24404] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(367), 21,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [24431] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      sym_assignment,
    ACTIONS(181), 1,
      sym_unification,
    ACTIONS(751), 1,
      anon_sym_RPAREN,
    STATE(115), 1,
      sym_infix_operator,
    STATE(135), 1,
      sym_close_paren,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(177), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(185), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(183), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [24478] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      sym_assignment,
    ACTIONS(181), 1,
      sym_unification,
    ACTIONS(229), 1,
      anon_sym_RPAREN,
    STATE(115), 1,
      sym_infix_operator,
    STATE(144), 1,
      sym_close_paren,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(177), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(185), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(183), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [24525] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(745), 1,
      anon_sym_COMMA,
    ACTIONS(749), 1,
      sym_in,
    ACTIONS(755), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(753), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [24558] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(401), 21,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [24585] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(369), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [24614] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(416), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(413), 4,
      anon_sym_COMMA,
      sym_close_bracket,
      sym_close_curly,
      sym_in,
    ACTIONS(411), 14,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_curly,
      sym_as,
  [24645] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(395), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [24674] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(423), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [24703] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 1,
      sym_if,
    STATE(226), 1,
      sym_assignment_operator,
    STATE(515), 1,
      sym_rule_head_comp,
    ACTIONS(141), 2,
      sym_assignment,
      sym_unification,
    ACTIONS(757), 8,
      anon_sym_DASH,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(759), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
  [24740] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(745), 1,
      anon_sym_COMMA,
    ACTIONS(749), 1,
      sym_in,
    ACTIONS(765), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(763), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [24773] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      sym_assignment,
    ACTIONS(181), 1,
      sym_unification,
    STATE(119), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(177), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(185), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(767), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(183), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [24818] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(383), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [24847] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(387), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [24876] = 6,
    ACTIONS(3), 1,
      sym_comment,
    STATE(115), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(243), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(241), 13,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_curly,
  [24911] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(731), 1,
      sym_in,
    ACTIONS(741), 1,
      anon_sym_COMMA,
    ACTIONS(363), 19,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      sym_unification,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      sym_close_bracket,
      sym_with,
  [24942] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(377), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [24971] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(391), 11,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [25000] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      anon_sym_COMMA,
    ACTIONS(775), 1,
      sym_in,
    ACTIONS(771), 9,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(773), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [25032] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(779), 1,
      sym_open_bracket,
    ACTIONS(781), 1,
      sym_open_curly,
    STATE(401), 1,
      sym_raw_string,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(777), 2,
      anon_sym__,
      sym_var,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(772), 4,
      sym_scalar,
      sym_array,
      sym_object,
      sym_set,
  [25082] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 1,
      anon_sym_COMMA,
    ACTIONS(418), 1,
      sym_in,
    ACTIONS(411), 9,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(416), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [25114] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(779), 1,
      sym_open_bracket,
    ACTIONS(781), 1,
      sym_open_curly,
    STATE(401), 1,
      sym_raw_string,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(783), 2,
      anon_sym__,
      sym_var,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(785), 4,
      sym_scalar,
      sym_array,
      sym_object,
      sym_set,
  [25164] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(779), 1,
      sym_open_bracket,
    ACTIONS(781), 1,
      sym_open_curly,
    STATE(401), 1,
      sym_raw_string,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(785), 2,
      anon_sym__,
      sym_var,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(826), 4,
      sym_scalar,
      sym_array,
      sym_object,
      sym_set,
  [25214] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      anon_sym_COMMA,
    ACTIONS(775), 1,
      sym_in,
    ACTIONS(791), 1,
      sym_if,
    ACTIONS(789), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
    ACTIONS(787), 9,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [25248] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(779), 1,
      sym_open_bracket,
    ACTIONS(781), 1,
      sym_open_curly,
    STATE(401), 1,
      sym_raw_string,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(793), 2,
      anon_sym__,
      sym_var,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(817), 4,
      sym_scalar,
      sym_array,
      sym_object,
      sym_set,
  [25298] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(371), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(373), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [25326] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(407), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(409), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [25354] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(779), 1,
      sym_open_bracket,
    ACTIONS(781), 1,
      sym_open_curly,
    STATE(401), 1,
      sym_raw_string,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(795), 2,
      anon_sym__,
      sym_var,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(808), 4,
      sym_scalar,
      sym_array,
      sym_object,
      sym_set,
  [25404] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(393), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [25432] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(379), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [25460] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(779), 1,
      sym_open_bracket,
    ACTIONS(781), 1,
      sym_open_curly,
    STATE(401), 1,
      sym_raw_string,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(797), 2,
      anon_sym__,
      sym_var,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(798), 4,
      sym_scalar,
      sym_array,
      sym_object,
      sym_set,
  [25510] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(779), 1,
      sym_open_bracket,
    ACTIONS(781), 1,
      sym_open_curly,
    STATE(401), 1,
      sym_raw_string,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(799), 2,
      anon_sym__,
      sym_var,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(787), 4,
      sym_scalar,
      sym_array,
      sym_object,
      sym_set,
  [25560] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(387), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(389), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [25588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(385), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [25616] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_null,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      anon_sym_BQUOTE,
    ACTIONS(239), 1,
      sym_number,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(779), 1,
      sym_open_bracket,
    ACTIONS(781), 1,
      sym_open_curly,
    STATE(401), 1,
      sym_raw_string,
    ACTIONS(231), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(801), 2,
      anon_sym__,
      sym_var,
    STATE(390), 2,
      sym_string,
      sym_boolean,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(773), 4,
      sym_scalar,
      sym_array,
      sym_object,
      sym_set,
  [25666] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(395), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(397), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [25694] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(423), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(425), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [25722] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
    ACTIONS(375), 10,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
  [25750] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(355), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(353), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [25777] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(347), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(345), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [25804] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(747), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(743), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [25831] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      sym_assignment,
    ACTIONS(181), 1,
      sym_unification,
    STATE(115), 1,
      sym_infix_operator,
    STATE(542), 1,
      sym_assignment_operator,
    ACTIONS(177), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(185), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(541), 3,
      sym_bool_operator,
      sym_arith_operator,
      sym_bin_operator,
    ACTIONS(175), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(183), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [25872] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 1,
      sym_open_paren,
    ACTIONS(809), 1,
      sym_open_bracket,
    ACTIONS(811), 1,
      sym_if,
    ACTIONS(813), 1,
      sym_contains,
    ACTIONS(803), 7,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_curly,
      sym_number,
    ACTIONS(805), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
  [25907] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(817), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(815), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [25934] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(821), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(819), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [25961] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(321), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(319), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [25988] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(825), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(823), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26015] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(309), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(307), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26042] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(313), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(311), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26069] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(331), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(329), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26096] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(765), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
      sym_default,
    ACTIONS(763), 10,
      ts_builtin_sym_end,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26123] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(321), 9,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_if,
      sym_every,
      sym_else,
      sym_some,
    ACTIONS(319), 10,
      anon_sym_DASH,
      sym_assignment,
      sym_unification,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26150] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(335), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(333), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26177] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(275), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26204] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(283), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26231] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(303), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26258] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(279), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26285] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(343), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(341), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26312] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(351), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(349), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26339] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(301), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(299), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26366] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(295), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26393] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(279), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26420] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(359), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(357), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26447] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(271), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(269), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26474] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(317), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(315), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26501] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(327), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(325), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26528] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(339), 9,
      anon_sym_DOT,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(337), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26555] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 1,
      anon_sym_COMMA,
    ACTIONS(418), 1,
      sym_in,
    ACTIONS(416), 7,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_some,
    ACTIONS(411), 9,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26585] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(423), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26611] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(383), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26637] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(387), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26663] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(377), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26689] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(391), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26715] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(409), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(407), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26741] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(831), 1,
      sym_if,
    ACTIONS(829), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
    ACTIONS(827), 9,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26769] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(395), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26795] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(371), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26821] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_in,
      sym_every,
      sym_some,
    ACTIONS(369), 10,
      anon_sym_COMMA,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26847] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(363), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(361), 13,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
      sym_open_curly,
  [26877] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
    ACTIONS(837), 9,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26902] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(841), 1,
      sym_open_curly,
    ACTIONS(363), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(361), 11,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
  [26933] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(845), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
    ACTIONS(843), 9,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [26958] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(847), 1,
      sym_open_curly,
    ACTIONS(363), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(361), 11,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
  [26989] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(363), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(361), 13,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_RPAREN,
  [27016] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(849), 1,
      sym_open_curly,
    ACTIONS(363), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(361), 11,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
  [27047] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(851), 1,
      sym_open_curly,
    ACTIONS(363), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(361), 11,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
  [27078] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(853), 1,
      sym_open_curly,
    ACTIONS(363), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(361), 11,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
  [27109] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(829), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
    ACTIONS(827), 9,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [27134] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(759), 8,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_not,
      sym_every,
      sym_else,
      sym_some,
    ACTIONS(757), 9,
      anon_sym_DASH,
      sym_assignment,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [27159] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(855), 1,
      sym_open_curly,
    ACTIONS(363), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(361), 11,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
  [27190] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      sym_open_curly,
    ACTIONS(363), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(361), 11,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
  [27215] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(857), 1,
      sym_var,
    ACTIONS(859), 1,
      anon_sym_set_LPAREN,
    ACTIONS(861), 1,
      sym_open_bracket,
    ACTIONS(863), 1,
      sym_open_curly,
    STATE(629), 1,
      sym_ref,
    STATE(777), 1,
      sym_fn_name,
    STATE(595), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(548), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [27250] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(855), 1,
      sym_open_curly,
    ACTIONS(363), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(361), 11,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
  [27275] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(847), 1,
      sym_open_curly,
    ACTIONS(363), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(361), 11,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
  [27300] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(853), 1,
      sym_open_curly,
    ACTIONS(363), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(361), 11,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
  [27325] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(851), 1,
      sym_open_curly,
    ACTIONS(363), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(361), 11,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
  [27350] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(849), 1,
      sym_open_curly,
    ACTIONS(363), 3,
      sym_unification,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(361), 11,
      anon_sym_DASH,
      anon_sym_PIPE,
      sym_assignment,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_AMP,
  [27375] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_set_LPAREN,
    ACTIONS(570), 1,
      sym_open_bracket,
    ACTIONS(572), 1,
      sym_open_curly,
    ACTIONS(865), 1,
      sym_var,
    STATE(665), 1,
      sym_ref,
    STATE(820), 1,
      sym_fn_name,
    STATE(572), 2,
      sym_non_empty_set,
      sym_empty_set,
    STATE(550), 7,
      sym_expr_call,
      sym_array_compr,
      sym_set_compr,
      sym_object_compr,
      sym_array,
      sym_object,
      sym_set,
  [27410] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(869), 5,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_every,
    ACTIONS(867), 8,
      anon_sym_DASH,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [27431] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(873), 5,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_every,
    ACTIONS(871), 8,
      anon_sym_DASH,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [27452] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(877), 5,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_every,
    ACTIONS(875), 8,
      anon_sym_DASH,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [27473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(877), 5,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_every,
    ACTIONS(875), 8,
      anon_sym_DASH,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [27494] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 5,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_every,
    ACTIONS(879), 8,
      anon_sym_DASH,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [27515] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(885), 5,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_every,
    ACTIONS(883), 8,
      anon_sym_DASH,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_paren,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [27536] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(191), 1,
      ts_builtin_sym_end,
    ACTIONS(471), 1,
      sym_open_paren,
    ACTIONS(887), 1,
      anon_sym_DOT,
    ACTIONS(889), 1,
      sym_open_bracket,
    STATE(549), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(591), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [27566] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(469), 1,
      anon_sym_DOT,
    ACTIONS(471), 1,
      sym_open_paren,
    ACTIONS(473), 1,
      sym_open_bracket,
    STATE(184), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(320), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(191), 5,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_COLON,
      sym_close_curly,
      sym_in,
  [27594] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(191), 1,
      ts_builtin_sym_end,
    ACTIONS(471), 1,
      sym_open_paren,
    ACTIONS(891), 1,
      anon_sym_DOT,
    ACTIONS(893), 1,
      sym_open_bracket,
    STATE(552), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(585), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 3,
      sym_var,
      sym_import,
      sym_default,
  [27623] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(191), 1,
      ts_builtin_sym_end,
    ACTIONS(889), 1,
      sym_open_bracket,
    ACTIONS(895), 1,
      anon_sym_DOT,
    STATE(549), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(591), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [27650] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 1,
      ts_builtin_sym_end,
    ACTIONS(889), 1,
      sym_open_bracket,
    ACTIONS(895), 1,
      anon_sym_DOT,
    STATE(553), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(591), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(215), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [27677] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(893), 1,
      sym_open_bracket,
    ACTIONS(897), 1,
      anon_sym_DOT,
    ACTIONS(191), 2,
      ts_builtin_sym_end,
      anon_sym_COLON,
    STATE(552), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(585), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(195), 3,
      sym_var,
      sym_import,
      sym_default,
  [27704] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 1,
      anon_sym_DOT,
    ACTIONS(902), 1,
      sym_open_bracket,
    ACTIONS(201), 2,
      ts_builtin_sym_end,
      anon_sym_COLON,
    STATE(551), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(585), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(206), 3,
      sym_var,
      sym_import,
      sym_default,
  [27731] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(893), 1,
      sym_open_bracket,
    ACTIONS(897), 1,
      anon_sym_DOT,
    ACTIONS(213), 2,
      ts_builtin_sym_end,
      anon_sym_COLON,
    STATE(551), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(585), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(215), 3,
      sym_var,
      sym_import,
      sym_default,
  [27758] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(201), 1,
      ts_builtin_sym_end,
    ACTIONS(905), 1,
      anon_sym_DOT,
    ACTIONS(908), 1,
      sym_open_bracket,
    STATE(553), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(591), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
    ACTIONS(206), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [27785] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(873), 4,
      sym_var,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(871), 6,
      anon_sym_DQUOTE,
      anon_sym_BQUOTE,
      anon_sym_set_LPAREN,
      sym_open_bracket,
      sym_open_curly,
      sym_number,
  [27803] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(911), 1,
      ts_builtin_sym_end,
    ACTIONS(913), 1,
      sym_var,
    ACTIONS(915), 1,
      sym_import,
    ACTIONS(917), 1,
      sym_default,
    STATE(8), 1,
      sym_rule_head,
    STATE(811), 1,
      sym_policy,
    STATE(556), 2,
      sym__import,
      aux_sym_module_repeat1,
    STATE(626), 2,
      sym_rule,
      aux_sym_policy_repeat1,
  [27833] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym_var,
    ACTIONS(915), 1,
      sym_import,
    ACTIONS(917), 1,
      sym_default,
    ACTIONS(919), 1,
      ts_builtin_sym_end,
    STATE(8), 1,
      sym_rule_head,
    STATE(779), 1,
      sym_policy,
    STATE(625), 2,
      sym__import,
      aux_sym_module_repeat1,
    STATE(626), 2,
      sym_rule,
      aux_sym_policy_repeat1,
  [27863] = 6,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(921), 1,
      anon_sym_COMMA,
    ACTIONS(923), 1,
      sym_in,
    STATE(558), 1,
      aux_sym_rule_args_repeat1,
    STATE(612), 1,
      aux_sym_some_decl_repeat1,
    ACTIONS(678), 5,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
      sym_with,
  [27886] = 6,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_COMMA,
    ACTIONS(927), 1,
      sym_in,
    STATE(560), 1,
      aux_sym_rule_args_repeat1,
    STATE(600), 1,
      aux_sym_some_decl_repeat1,
    ACTIONS(686), 5,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
      sym_with,
  [27909] = 6,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(925), 1,
      anon_sym_COMMA,
    ACTIONS(929), 1,
      sym_in,
    STATE(560), 1,
      aux_sym_rule_args_repeat1,
    STATE(580), 1,
      aux_sym_some_decl_repeat1,
    ACTIONS(686), 5,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
      sym_with,
  [27932] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(931), 1,
      anon_sym_COMMA,
    STATE(560), 1,
      aux_sym_rule_args_repeat1,
    ACTIONS(695), 7,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [27951] = 6,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(921), 1,
      anon_sym_COMMA,
    ACTIONS(934), 1,
      sym_in,
    STATE(559), 1,
      aux_sym_rule_args_repeat1,
    STATE(579), 1,
      aux_sym_some_decl_repeat1,
    ACTIONS(678), 5,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
      sym_with,
  [27974] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(339), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(337), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
  [27990] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(347), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(345), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
  [28006] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(303), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
  [28022] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(343), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(341), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
  [28038] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(331), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(329), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
  [28054] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(309), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(307), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
  [28070] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(191), 1,
      anon_sym_COLON,
    ACTIONS(471), 1,
      sym_open_paren,
    ACTIONS(891), 1,
      anon_sym_DOT,
    ACTIONS(893), 1,
      sym_open_bracket,
    STATE(552), 2,
      sym_ref_arg,
      aux_sym_ref_repeat1,
    STATE(585), 2,
      sym_ref_arg_brack,
      sym_ref_arg_dot,
  [28094] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(355), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(353), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
  [28110] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(695), 8,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [28124] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(695), 8,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [28138] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(275), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
  [28154] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(418), 8,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
      sym_close_curly,
      sym_with,
      sym_in,
  [28168] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(327), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(325), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
  [28184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(295), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
  [28200] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(664), 1,
      sym_open_paren,
    ACTIONS(281), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(279), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
  [28218] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(301), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(299), 5,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
      sym_close_bracket,
  [28234] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(664), 1,
      sym_open_paren,
    ACTIONS(279), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(281), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28252] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(929), 1,
      sym_in,
    STATE(601), 1,
      aux_sym_some_decl_repeat1,
    ACTIONS(686), 5,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
      sym_with,
  [28269] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(929), 1,
      sym_in,
    STATE(601), 1,
      aux_sym_some_decl_repeat1,
    ACTIONS(716), 5,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
      sym_with,
  [28286] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(341), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(343), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28301] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(319), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(321), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28316] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(271), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28331] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(654), 1,
      sym_with,
    STATE(607), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    ACTIONS(187), 4,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
  [28348] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(283), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
  [28363] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(279), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
  [28378] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(305), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28393] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(271), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(269), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
  [28408] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(281), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28423] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(646), 1,
      sym_with,
    STATE(609), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    ACTIONS(199), 4,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
  [28440] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(285), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28455] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(351), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(349), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
  [28470] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(295), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(297), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28485] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(315), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(317), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28500] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(277), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28515] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(307), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(309), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28530] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(311), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(313), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28545] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(731), 1,
      sym_in,
    ACTIONS(739), 1,
      anon_sym_COMMA,
    ACTIONS(727), 5,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
      sym_with,
  [28562] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(936), 1,
      sym_in,
    STATE(599), 1,
      aux_sym_some_decl_repeat1,
    ACTIONS(253), 5,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
      sym_with,
  [28579] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(927), 1,
      sym_in,
    STATE(599), 1,
      aux_sym_some_decl_repeat1,
    ACTIONS(716), 5,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
      sym_with,
  [28596] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(939), 1,
      sym_in,
    STATE(601), 1,
      aux_sym_some_decl_repeat1,
    ACTIONS(253), 5,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
      sym_with,
  [28613] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(646), 1,
      sym_with,
    STATE(590), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    ACTIONS(187), 4,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
  [28630] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(325), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(327), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28645] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(337), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(339), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28660] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(345), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(347), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28675] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(329), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(331), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28690] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(654), 1,
      sym_with,
    STATE(613), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    ACTIONS(199), 4,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
  [28707] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(317), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(315), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
  [28722] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(942), 1,
      sym_with,
    STATE(609), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    ACTIONS(720), 4,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
  [28739] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(299), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(301), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28754] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(335), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(333), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
  [28769] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(927), 1,
      sym_in,
    STATE(599), 1,
      aux_sym_some_decl_repeat1,
    ACTIONS(686), 5,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
      sym_with,
  [28786] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(945), 1,
      sym_with,
    STATE(613), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    ACTIONS(720), 4,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
  [28803] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(359), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28818] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(313), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(311), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
  [28833] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(731), 1,
      sym_in,
    ACTIONS(741), 1,
      anon_sym_COMMA,
    ACTIONS(727), 5,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
      sym_with,
  [28850] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(355), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28865] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(654), 1,
      sym_with,
    STATE(613), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    ACTIONS(709), 4,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_curly,
  [28882] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(335), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28897] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(359), 3,
      sym_var,
      sym_import,
      sym_default,
    ACTIONS(357), 4,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_COLON,
      sym_open_bracket,
  [28912] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(646), 1,
      sym_with,
    STATE(609), 2,
      sym_with_modifier,
      aux_sym_literal_repeat1,
    ACTIONS(709), 4,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
  [28929] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(349), 3,
      ts_builtin_sym_end,
      anon_sym_DOT,
      sym_open_bracket,
    ACTIONS(351), 4,
      sym_var,
      sym_as,
      sym_import,
      sym_default,
  [28944] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(411), 3,
      anon_sym_PIPE,
      sym_close_bracket,
      sym_close_curly,
    ACTIONS(413), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym_in,
  [28958] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(948), 1,
      ts_builtin_sym_end,
    ACTIONS(950), 1,
      sym_var,
    ACTIONS(953), 1,
      sym_default,
    STATE(8), 1,
      sym_rule_head,
    STATE(624), 2,
      sym_rule,
      aux_sym_policy_repeat1,
  [28978] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 1,
      ts_builtin_sym_end,
    ACTIONS(960), 1,
      sym_import,
    ACTIONS(958), 2,
      sym_var,
      sym_default,
    STATE(625), 2,
      sym__import,
      aux_sym_module_repeat1,
  [28996] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym_var,
    ACTIONS(917), 1,
      sym_default,
    ACTIONS(963), 1,
      ts_builtin_sym_end,
    STATE(8), 1,
      sym_rule_head,
    STATE(624), 2,
      sym_rule,
      aux_sym_policy_repeat1,
  [29016] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(965), 1,
      anon_sym_COMMA,
    ACTIONS(967), 1,
      anon_sym_PIPE,
    ACTIONS(969), 1,
      sym_close_bracket,
    STATE(678), 1,
      aux_sym_rule_args_repeat1,
  [29035] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(971), 1,
      anon_sym_COMMA,
    ACTIONS(973), 1,
      anon_sym_PIPE,
    ACTIONS(975), 1,
      sym_close_curly,
    STATE(676), 1,
      aux_sym_rule_args_repeat1,
  [29054] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(977), 1,
      ts_builtin_sym_end,
    ACTIONS(981), 1,
      sym_as,
    ACTIONS(979), 3,
      sym_var,
      sym_import,
      sym_default,
  [29069] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(983), 1,
      anon_sym_COMMA,
    ACTIONS(985), 1,
      anon_sym_PIPE,
    ACTIONS(987), 1,
      sym_close_bracket,
    STATE(715), 1,
      aux_sym_rule_args_repeat1,
  [29088] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(989), 1,
      anon_sym_COMMA,
    ACTIONS(991), 1,
      anon_sym_PIPE,
    ACTIONS(993), 1,
      sym_close_bracket,
    STATE(701), 1,
      aux_sym_rule_args_repeat1,
  [29107] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(995), 1,
      anon_sym_COMMA,
    ACTIONS(997), 1,
      anon_sym_PIPE,
    ACTIONS(999), 1,
      sym_close_curly,
    STATE(717), 1,
      aux_sym_rule_args_repeat1,
  [29126] = 5,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1003), 1,
      anon_sym_CR,
    ACTIONS(1005), 1,
      sym_close_curly,
    STATE(652), 1,
      aux_sym_query_repeat1,
    ACTIONS(1001), 2,
      anon_sym_SEMI,
      anon_sym_LF,
  [29143] = 5,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1005), 1,
      sym_close_bracket,
    ACTIONS(1009), 1,
      anon_sym_CR,
    STATE(653), 1,
      aux_sym_query_repeat1,
    ACTIONS(1007), 2,
      anon_sym_SEMI,
      anon_sym_LF,
  [29160] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1011), 5,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
      sym_close_curly,
  [29171] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1013), 1,
      anon_sym_COMMA,
    ACTIONS(1015), 1,
      anon_sym_PIPE,
    ACTIONS(1017), 1,
      sym_close_curly,
    STATE(737), 1,
      aux_sym_rule_args_repeat1,
  [29190] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1019), 1,
      anon_sym_COMMA,
    ACTIONS(1021), 1,
      anon_sym_PIPE,
    ACTIONS(1023), 1,
      sym_close_curly,
    STATE(711), 1,
      aux_sym_rule_args_repeat1,
  [29209] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1025), 1,
      anon_sym_COMMA,
    ACTIONS(1027), 1,
      anon_sym_PIPE,
    ACTIONS(1029), 1,
      sym_close_bracket,
    STATE(709), 1,
      aux_sym_rule_args_repeat1,
  [29228] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1031), 1,
      anon_sym_COLON,
    ACTIONS(391), 4,
      anon_sym_COMMA,
      anon_sym_PIPE,
      sym_close_curly,
      sym_in,
  [29241] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(137), 5,
      anon_sym_SEMI,
      anon_sym_CR,
      anon_sym_LF,
      sym_close_bracket,
      sym_close_curly,
  [29252] = 5,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(137), 1,
      sym_close_curly,
    ACTIONS(1036), 1,
      anon_sym_CR,
    STATE(641), 1,
      aux_sym_query_repeat1,
    ACTIONS(1033), 2,
      anon_sym_SEMI,
      anon_sym_LF,
  [29269] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1039), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
    ACTIONS(690), 3,
      anon_sym_RPAREN,
      sym_close_bracket,
      sym_close_curly,
  [29284] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1042), 1,
      anon_sym_COMMA,
    ACTIONS(1044), 1,
      anon_sym_PIPE,
    ACTIONS(1046), 1,
      sym_close_curly,
    STATE(679), 1,
      aux_sym_rule_args_repeat1,
  [29303] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1048), 1,
      anon_sym_COMMA,
    ACTIONS(1050), 1,
      anon_sym_PIPE,
    ACTIONS(1052), 1,
      sym_close_curly,
    STATE(703), 1,
      aux_sym_rule_args_repeat1,
  [29322] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1054), 1,
      anon_sym_COMMA,
    ACTIONS(1056), 1,
      anon_sym_PIPE,
    ACTIONS(1058), 1,
      sym_close_bracket,
    STATE(688), 1,
      aux_sym_rule_args_repeat1,
  [29341] = 5,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(137), 1,
      sym_close_bracket,
    ACTIONS(1063), 1,
      anon_sym_CR,
    STATE(646), 1,
      aux_sym_query_repeat1,
    ACTIONS(1060), 2,
      anon_sym_SEMI,
      anon_sym_LF,
  [29358] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1066), 1,
      anon_sym_COMMA,
    ACTIONS(1068), 1,
      anon_sym_PIPE,
    ACTIONS(1070), 1,
      sym_close_bracket,
    STATE(722), 1,
      aux_sym_rule_args_repeat1,
  [29377] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1072), 1,
      anon_sym_COMMA,
    ACTIONS(1074), 1,
      anon_sym_PIPE,
    ACTIONS(1076), 1,
      sym_close_curly,
    STATE(697), 1,
      aux_sym_rule_args_repeat1,
  [29396] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1078), 1,
      anon_sym_COMMA,
    ACTIONS(1080), 1,
      anon_sym_PIPE,
    ACTIONS(1082), 1,
      sym_close_bracket,
    STATE(680), 1,
      aux_sym_rule_args_repeat1,
  [29415] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(690), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym_close_bracket,
      sym_close_curly,
  [29428] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1084), 1,
      anon_sym_COMMA,
    ACTIONS(1086), 1,
      anon_sym_PIPE,
    ACTIONS(1088), 1,
      sym_close_bracket,
    STATE(694), 1,
      aux_sym_rule_args_repeat1,
  [29447] = 5,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1003), 1,
      anon_sym_CR,
    ACTIONS(1090), 1,
      sym_close_curly,
    STATE(641), 1,
      aux_sym_query_repeat1,
    ACTIONS(1001), 2,
      anon_sym_SEMI,
      anon_sym_LF,
  [29464] = 5,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1009), 1,
      anon_sym_CR,
    ACTIONS(1090), 1,
      sym_close_bracket,
    STATE(646), 1,
      aux_sym_query_repeat1,
    ACTIONS(1007), 2,
      anon_sym_SEMI,
      anon_sym_LF,
  [29481] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1092), 1,
      anon_sym_COMMA,
    ACTIONS(1094), 1,
      anon_sym_PIPE,
    ACTIONS(1096), 1,
      sym_close_curly,
    STATE(690), 1,
      aux_sym_rule_args_repeat1,
  [29500] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1098), 1,
      anon_sym_COMMA,
    ACTIONS(1100), 1,
      anon_sym_PIPE,
    ACTIONS(1102), 1,
      sym_close_curly,
    STATE(692), 1,
      aux_sym_object_repeat1,
  [29516] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1084), 1,
      anon_sym_COMMA,
    ACTIONS(1088), 1,
      sym_close_bracket,
    STATE(694), 1,
      aux_sym_rule_args_repeat1,
  [29532] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1048), 1,
      anon_sym_COMMA,
    ACTIONS(1052), 1,
      sym_close_curly,
    STATE(703), 1,
      aux_sym_rule_args_repeat1,
  [29548] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1104), 3,
      anon_sym_COMMA,
      anon_sym_PIPE,
      sym_close_curly,
  [29560] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1106), 1,
      anon_sym_COMMA,
    ACTIONS(1108), 1,
      anon_sym_PIPE,
    ACTIONS(1110), 1,
      sym_close_curly,
    STATE(691), 1,
      aux_sym_object_repeat1,
  [29576] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1112), 1,
      anon_sym_COMMA,
    ACTIONS(1114), 1,
      anon_sym_PIPE,
    ACTIONS(1116), 1,
      sym_close_curly,
    STATE(716), 1,
      aux_sym_object_repeat1,
  [29592] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1118), 1,
      anon_sym_COMMA,
    ACTIONS(1120), 1,
      anon_sym_PIPE,
    ACTIONS(1122), 1,
      sym_close_curly,
    STATE(735), 1,
      aux_sym_object_repeat1,
  [29608] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      sym_in,
    ACTIONS(690), 3,
      anon_sym_COMMA,
      sym_close_bracket,
      sym_close_curly,
  [29620] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      ts_builtin_sym_end,
    ACTIONS(1128), 3,
      sym_var,
      sym_import,
      sym_default,
  [29632] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1130), 1,
      anon_sym_COMMA,
    ACTIONS(1132), 1,
      anon_sym_PIPE,
    ACTIONS(1134), 1,
      sym_close_curly,
    STATE(713), 1,
      aux_sym_object_repeat1,
  [29648] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1136), 1,
      ts_builtin_sym_end,
    ACTIONS(1138), 3,
      sym_var,
      sym_import,
      sym_default,
  [29660] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1140), 1,
      anon_sym_COMMA,
    ACTIONS(1142), 1,
      anon_sym_PIPE,
    ACTIONS(1144), 1,
      sym_close_curly,
    STATE(695), 1,
      aux_sym_object_repeat1,
  [29676] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1146), 1,
      anon_sym_COMMA,
    ACTIONS(1148), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      aux_sym_rule_args_repeat1,
  [29692] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1150), 1,
      anon_sym_COMMA,
    ACTIONS(1152), 1,
      anon_sym_PIPE,
    ACTIONS(1154), 1,
      sym_close_curly,
    STATE(731), 1,
      aux_sym_object_repeat1,
  [29708] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1156), 1,
      anon_sym_COMMA,
    ACTIONS(1158), 1,
      anon_sym_PIPE,
    ACTIONS(1160), 1,
      sym_close_curly,
    STATE(736), 1,
      aux_sym_object_repeat1,
  [29724] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1162), 1,
      sym_as,
  [29737] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_BQUOTE,
    ACTIONS(1166), 1,
      aux_sym_raw_string_token1,
    STATE(712), 1,
      aux_sym_raw_string_repeat1,
  [29750] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1168), 1,
      anon_sym_COMMA,
    ACTIONS(1170), 1,
      sym_in,
    STATE(725), 1,
      aux_sym_expr_every_repeat1,
  [29763] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1172), 1,
      sym_as,
  [29776] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1168), 1,
      anon_sym_COMMA,
    ACTIONS(1174), 1,
      sym_in,
    STATE(725), 1,
      aux_sym_expr_every_repeat1,
  [29789] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1176), 1,
      anon_sym_DQUOTE,
    ACTIONS(1178), 1,
      aux_sym_string_token1,
    STATE(720), 1,
      aux_sym_string_repeat1,
  [29802] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      sym_close_curly,
    ACTIONS(1180), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [29815] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1166), 1,
      aux_sym_raw_string_token1,
    ACTIONS(1182), 1,
      anon_sym_BQUOTE,
    STATE(712), 1,
      aux_sym_raw_string_repeat1,
  [29828] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 1,
      sym_close_bracket,
    ACTIONS(1184), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [29841] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 1,
      sym_close_curly,
    ACTIONS(1186), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [29854] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(483), 1,
      sym_close_bracket,
    ACTIONS(1188), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [29867] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1166), 1,
      aux_sym_raw_string_token1,
    ACTIONS(1190), 1,
      anon_sym_BQUOTE,
    STATE(712), 1,
      aux_sym_raw_string_repeat1,
  [29880] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1178), 1,
      aux_sym_string_token1,
    ACTIONS(1192), 1,
      anon_sym_DQUOTE,
    STATE(720), 1,
      aux_sym_string_repeat1,
  [29893] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1194), 1,
      anon_sym_BQUOTE,
    ACTIONS(1196), 1,
      aux_sym_raw_string_token1,
    STATE(681), 1,
      aux_sym_raw_string_repeat1,
  [29906] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1198), 1,
      anon_sym_DQUOTE,
    ACTIONS(1200), 1,
      aux_sym_string_token1,
    STATE(687), 1,
      aux_sym_string_repeat1,
  [29919] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1202), 1,
      anon_sym_DQUOTE,
    ACTIONS(1204), 1,
      aux_sym_string_token1,
    STATE(682), 1,
      aux_sym_string_repeat1,
  [29932] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1206), 1,
      anon_sym_BQUOTE,
    ACTIONS(1208), 1,
      aux_sym_raw_string_token1,
    STATE(689), 1,
      aux_sym_raw_string_repeat1,
  [29945] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1178), 1,
      aux_sym_string_token1,
    ACTIONS(1210), 1,
      anon_sym_DQUOTE,
    STATE(720), 1,
      aux_sym_string_repeat1,
  [29958] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(485), 1,
      sym_close_bracket,
    ACTIONS(1212), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [29971] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1166), 1,
      aux_sym_raw_string_token1,
    ACTIONS(1214), 1,
      anon_sym_BQUOTE,
    STATE(712), 1,
      aux_sym_raw_string_repeat1,
  [29984] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 1,
      sym_close_curly,
    ACTIONS(1216), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [29997] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(636), 1,
      sym_close_curly,
    ACTIONS(1218), 1,
      anon_sym_COMMA,
    STATE(708), 1,
      aux_sym_object_repeat1,
  [30010] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(626), 1,
      sym_close_curly,
    ACTIONS(1220), 1,
      anon_sym_COMMA,
    STATE(708), 1,
      aux_sym_object_repeat1,
  [30023] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1178), 1,
      aux_sym_string_token1,
    ACTIONS(1222), 1,
      anon_sym_DQUOTE,
    STATE(720), 1,
      aux_sym_string_repeat1,
  [30036] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(511), 1,
      sym_close_bracket,
    ACTIONS(1224), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [30049] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(628), 1,
      sym_close_curly,
    ACTIONS(1226), 1,
      anon_sym_COMMA,
    STATE(708), 1,
      aux_sym_object_repeat1,
  [30062] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1228), 1,
      anon_sym_COMMA,
    ACTIONS(1230), 1,
      anon_sym_RPAREN,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [30075] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 1,
      sym_close_curly,
    ACTIONS(1232), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [30088] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1234), 1,
      anon_sym_DQUOTE,
    ACTIONS(1236), 1,
      aux_sym_string_token1,
    STATE(675), 1,
      aux_sym_string_repeat1,
  [30101] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1166), 1,
      aux_sym_raw_string_token1,
    ACTIONS(1238), 1,
      anon_sym_BQUOTE,
    STATE(712), 1,
      aux_sym_raw_string_repeat1,
  [30114] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1240), 1,
      anon_sym_DQUOTE,
    ACTIONS(1242), 1,
      aux_sym_string_token1,
    STATE(693), 1,
      aux_sym_string_repeat1,
  [30127] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 1,
      sym_close_bracket,
    ACTIONS(1244), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [30140] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(767), 1,
      anon_sym_RPAREN,
    ACTIONS(1246), 1,
      anon_sym_COMMA,
    STATE(702), 1,
      aux_sym_fn_args_repeat1,
  [30153] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(519), 1,
      sym_close_curly,
    ACTIONS(1249), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [30166] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1178), 1,
      aux_sym_string_token1,
    ACTIONS(1251), 1,
      anon_sym_DQUOTE,
    STATE(720), 1,
      aux_sym_string_repeat1,
  [30179] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1253), 1,
      anon_sym_BQUOTE,
    ACTIONS(1255), 1,
      aux_sym_raw_string_token1,
    STATE(677), 1,
      aux_sym_raw_string_repeat1,
  [30192] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 1,
      anon_sym_COMMA,
    ACTIONS(1257), 1,
      anon_sym_RPAREN,
    STATE(702), 1,
      aux_sym_fn_args_repeat1,
  [30205] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1259), 1,
      anon_sym_BQUOTE,
    ACTIONS(1261), 1,
      aux_sym_raw_string_token1,
    STATE(699), 1,
      aux_sym_raw_string_repeat1,
  [30218] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1263), 1,
      anon_sym_COMMA,
    ACTIONS(1266), 1,
      sym_close_curly,
    STATE(708), 1,
      aux_sym_object_repeat1,
  [30231] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(491), 1,
      sym_close_bracket,
    ACTIONS(1268), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [30244] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1270), 1,
      anon_sym_BQUOTE,
    ACTIONS(1272), 1,
      aux_sym_raw_string_token1,
    STATE(671), 1,
      aux_sym_raw_string_repeat1,
  [30257] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(477), 1,
      sym_close_curly,
    ACTIONS(1274), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [30270] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1276), 1,
      anon_sym_BQUOTE,
    ACTIONS(1278), 1,
      aux_sym_raw_string_token1,
    STATE(712), 1,
      aux_sym_raw_string_repeat1,
  [30283] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 1,
      sym_close_curly,
    ACTIONS(1281), 1,
      anon_sym_COMMA,
    STATE(708), 1,
      aux_sym_object_repeat1,
  [30296] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_DQUOTE,
    ACTIONS(1285), 1,
      aux_sym_string_token1,
    STATE(704), 1,
      aux_sym_string_repeat1,
  [30309] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      sym_close_bracket,
    ACTIONS(1287), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [30322] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(604), 1,
      sym_close_curly,
    ACTIONS(1289), 1,
      anon_sym_COMMA,
    STATE(708), 1,
      aux_sym_object_repeat1,
  [30335] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(481), 1,
      sym_close_curly,
    ACTIONS(1291), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [30348] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1293), 1,
      sym_in,
    ACTIONS(690), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [30359] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1295), 1,
      sym_as,
  [30372] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1297), 1,
      anon_sym_DQUOTE,
    ACTIONS(1299), 1,
      aux_sym_string_token1,
    STATE(720), 1,
      aux_sym_string_repeat1,
  [30385] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1156), 1,
      anon_sym_COMMA,
    ACTIONS(1160), 1,
      sym_close_curly,
    STATE(736), 1,
      aux_sym_object_repeat1,
  [30398] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 1,
      sym_close_bracket,
    ACTIONS(1302), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [30411] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1166), 1,
      aux_sym_raw_string_token1,
    ACTIONS(1304), 1,
      anon_sym_BQUOTE,
    STATE(712), 1,
      aux_sym_raw_string_repeat1,
  [30424] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1178), 1,
      aux_sym_string_token1,
    ACTIONS(1306), 1,
      anon_sym_DQUOTE,
    STATE(720), 1,
      aux_sym_string_repeat1,
  [30437] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1308), 1,
      anon_sym_COMMA,
    ACTIONS(1311), 1,
      sym_in,
    STATE(725), 1,
      aux_sym_expr_every_repeat1,
  [30450] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1313), 1,
      anon_sym_BQUOTE,
    ACTIONS(1315), 1,
      aux_sym_raw_string_token1,
    STATE(723), 1,
      aux_sym_raw_string_repeat1,
  [30463] = 4,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1317), 1,
      anon_sym_DQUOTE,
    ACTIONS(1319), 1,
      aux_sym_string_token1,
    STATE(724), 1,
      aux_sym_string_repeat1,
  [30476] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1321), 1,
      sym_in,
    ACTIONS(690), 2,
      anon_sym_COMMA,
      sym_close_curly,
  [30487] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1168), 1,
      anon_sym_COMMA,
    ACTIONS(1323), 1,
      sym_in,
    STATE(674), 1,
      aux_sym_expr_every_repeat1,
  [30500] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1168), 1,
      anon_sym_COMMA,
    ACTIONS(1325), 1,
      sym_in,
    STATE(733), 1,
      aux_sym_expr_every_repeat1,
  [30513] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(600), 1,
      sym_close_curly,
    ACTIONS(1327), 1,
      anon_sym_COMMA,
    STATE(708), 1,
      aux_sym_object_repeat1,
  [30526] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      sym_in,
    ACTIONS(1329), 1,
      anon_sym_COMMA,
    ACTIONS(1331), 1,
      sym_close_bracket,
  [30539] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1168), 1,
      anon_sym_COMMA,
    ACTIONS(1333), 1,
      sym_in,
    STATE(725), 1,
      aux_sym_expr_every_repeat1,
  [30552] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1168), 1,
      anon_sym_COMMA,
    ACTIONS(1335), 1,
      sym_in,
    STATE(672), 1,
      aux_sym_expr_every_repeat1,
  [30565] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 1,
      sym_close_curly,
    ACTIONS(1337), 1,
      anon_sym_COMMA,
    STATE(708), 1,
      aux_sym_object_repeat1,
  [30578] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(576), 1,
      sym_close_curly,
    ACTIONS(1339), 1,
      anon_sym_COMMA,
    STATE(708), 1,
      aux_sym_object_repeat1,
  [30591] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym_close_curly,
    ACTIONS(1341), 1,
      anon_sym_COMMA,
    STATE(642), 1,
      aux_sym_rule_args_repeat1,
  [30604] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1343), 1,
      sym_var,
    STATE(7), 1,
      sym_rule_head,
  [30614] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(265), 1,
      anon_sym_RPAREN,
    STATE(419), 1,
      sym_close_paren,
  [30624] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1345), 1,
      anon_sym_RPAREN,
    STATE(450), 1,
      sym_close_paren,
  [30634] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(1347), 1,
      sym_in,
  [30644] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(1293), 1,
      sym_in,
  [30654] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_RPAREN,
    STATE(620), 1,
      sym_close_paren,
  [30664] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1266), 2,
      anon_sym_COMMA,
      sym_close_curly,
  [30672] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1311), 2,
      anon_sym_COMMA,
      sym_in,
  [30680] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(245), 1,
      anon_sym_RPAREN,
    STATE(361), 1,
      sym_close_paren,
  [30690] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(1124), 1,
      sym_in,
  [30700] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(247), 1,
      anon_sym_RPAREN,
    STATE(614), 1,
      sym_close_paren,
  [30710] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(1349), 1,
      sym_in,
  [30720] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(1351), 1,
      sym_in,
  [30730] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(229), 1,
      anon_sym_RPAREN,
    STATE(123), 1,
      sym_close_paren,
  [30740] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(263), 1,
      anon_sym_RPAREN,
    STATE(338), 1,
      sym_close_paren,
  [30750] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(1353), 1,
      sym_in,
  [30760] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_RPAREN,
    STATE(300), 1,
      sym_close_paren,
  [30770] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(1355), 1,
      sym_in,
  [30780] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(257), 1,
      anon_sym_RPAREN,
    STATE(503), 1,
      sym_close_paren,
  [30790] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(1321), 1,
      sym_in,
  [30800] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1357), 1,
      sym_close_bracket,
  [30807] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1359), 1,
      sym_close_curly,
  [30814] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1361), 1,
      sym_close_curly,
  [30821] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1363), 1,
      sym_close_bracket,
  [30828] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1365), 1,
      sym_close_curly,
  [30835] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1367), 1,
      sym_open_paren,
  [30842] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1369), 1,
      sym_close_bracket,
  [30849] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1371), 1,
      sym_close_curly,
  [30856] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1373), 1,
      sym_open_paren,
  [30863] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1375), 1,
      sym_close_curly,
  [30870] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1377), 1,
      sym_open_paren,
  [30877] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1379), 1,
      sym_close_bracket,
  [30884] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1381), 1,
      sym_var,
  [30891] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1383), 1,
      sym_close_curly,
  [30898] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 1,
      sym_close_bracket,
  [30905] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1387), 1,
      sym_close_bracket,
  [30912] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1389), 1,
      sym_open_paren,
  [30919] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1391), 1,
      sym_var,
  [30926] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1031), 1,
      anon_sym_COLON,
  [30933] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 1,
      sym_open_paren,
  [30940] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1395), 1,
      sym_close_curly,
  [30947] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1397), 1,
      ts_builtin_sym_end,
  [30954] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1399), 1,
      sym_close_curly,
  [30961] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1401), 1,
      sym_var,
  [30968] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1403), 1,
      sym_open_paren,
  [30975] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1405), 1,
      sym_open_paren,
  [30982] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1407), 1,
      sym_close_curly,
  [30989] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1409), 1,
      sym_close_bracket,
  [30996] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1411), 1,
      sym_var,
  [31003] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1413), 1,
      sym_close_bracket,
  [31010] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1415), 1,
      sym_var,
  [31017] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1417), 1,
      sym_var,
  [31024] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1419), 1,
      sym_var,
  [31031] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1421), 1,
      anon_sym_RPAREN,
  [31038] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1423), 1,
      anon_sym_RPAREN,
  [31045] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1425), 1,
      sym_close_curly,
  [31052] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1427), 1,
      sym_close_curly,
  [31059] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 1,
      sym_close_bracket,
  [31066] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1431), 1,
      sym_close_curly,
  [31073] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1433), 1,
      anon_sym_LF,
  [31080] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1435), 1,
      sym_close_bracket,
  [31087] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1437), 1,
      sym_var,
  [31094] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1439), 1,
      sym_var,
  [31101] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1441), 1,
      anon_sym_RPAREN,
  [31108] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1443), 1,
      sym_var,
  [31115] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1445), 1,
      sym_close_curly,
  [31122] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1447), 1,
      sym_var,
  [31129] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1449), 1,
      sym_close_curly,
  [31136] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1451), 1,
      sym_close_curly,
  [31143] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1453), 1,
      sym_close_bracket,
  [31150] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1455), 1,
      sym_close_bracket,
  [31157] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1457), 1,
      anon_sym_RPAREN,
  [31164] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1459), 1,
      sym_var,
  [31171] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      ts_builtin_sym_end,
  [31178] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1461), 1,
      sym_var,
  [31185] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1463), 1,
      anon_sym_RPAREN,
  [31192] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1465), 1,
      sym_close_curly,
  [31199] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1467), 1,
      sym_close_curly,
  [31206] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1469), 1,
      sym_var,
  [31213] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1471), 1,
      sym_close_bracket,
  [31220] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1473), 1,
      sym_var,
  [31227] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1475), 1,
      sym_var,
  [31234] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1477), 1,
      sym_open_paren,
  [31241] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1479), 1,
      anon_sym_RPAREN,
  [31248] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1481), 1,
      sym_close_curly,
  [31255] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1483), 1,
      sym_close_curly,
  [31262] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1485), 1,
      sym_close_bracket,
  [31269] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1487), 1,
      sym_var,
  [31276] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1489), 1,
      sym_close_bracket,
  [31283] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1491), 1,
      anon_sym_RPAREN,
  [31290] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1493), 1,
      sym_var,
  [31297] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1495), 1,
      sym_var,
  [31304] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1497), 1,
      anon_sym_RPAREN,
  [31311] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1499), 1,
      sym_close_curly,
  [31318] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1501), 1,
      ts_builtin_sym_end,
  [31325] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1503), 1,
      sym_close_curly,
  [31332] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1505), 1,
      sym_close_curly,
  [31339] = 2,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(1507), 1,
      anon_sym_LF,
  [31346] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1509), 1,
      sym_close_curly,
  [31353] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      sym_close_bracket,
  [31360] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      ts_builtin_sym_end,
  [31367] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1515), 1,
      sym_close_curly,
  [31374] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1517), 1,
      sym_close_curly,
  [31381] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1519), 1,
      sym_var,
  [31388] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1521), 1,
      sym_var,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 109,
  [SMALL_STATE(4)] = 220,
  [SMALL_STATE(5)] = 329,
  [SMALL_STATE(6)] = 428,
  [SMALL_STATE(7)] = 527,
  [SMALL_STATE(8)] = 632,
  [SMALL_STATE(9)] = 737,
  [SMALL_STATE(10)] = 836,
  [SMALL_STATE(11)] = 935,
  [SMALL_STATE(12)] = 1039,
  [SMALL_STATE(13)] = 1143,
  [SMALL_STATE(14)] = 1246,
  [SMALL_STATE(15)] = 1349,
  [SMALL_STATE(16)] = 1452,
  [SMALL_STATE(17)] = 1550,
  [SMALL_STATE(18)] = 1648,
  [SMALL_STATE(19)] = 1746,
  [SMALL_STATE(20)] = 1844,
  [SMALL_STATE(21)] = 1942,
  [SMALL_STATE(22)] = 2040,
  [SMALL_STATE(23)] = 2138,
  [SMALL_STATE(24)] = 2236,
  [SMALL_STATE(25)] = 2334,
  [SMALL_STATE(26)] = 2432,
  [SMALL_STATE(27)] = 2530,
  [SMALL_STATE(28)] = 2628,
  [SMALL_STATE(29)] = 2726,
  [SMALL_STATE(30)] = 2824,
  [SMALL_STATE(31)] = 2922,
  [SMALL_STATE(32)] = 3020,
  [SMALL_STATE(33)] = 3118,
  [SMALL_STATE(34)] = 3216,
  [SMALL_STATE(35)] = 3314,
  [SMALL_STATE(36)] = 3412,
  [SMALL_STATE(37)] = 3510,
  [SMALL_STATE(38)] = 3608,
  [SMALL_STATE(39)] = 3706,
  [SMALL_STATE(40)] = 3804,
  [SMALL_STATE(41)] = 3902,
  [SMALL_STATE(42)] = 4000,
  [SMALL_STATE(43)] = 4098,
  [SMALL_STATE(44)] = 4196,
  [SMALL_STATE(45)] = 4294,
  [SMALL_STATE(46)] = 4392,
  [SMALL_STATE(47)] = 4461,
  [SMALL_STATE(48)] = 4514,
  [SMALL_STATE(49)] = 4567,
  [SMALL_STATE(50)] = 4636,
  [SMALL_STATE(51)] = 4691,
  [SMALL_STATE(52)] = 4744,
  [SMALL_STATE(53)] = 4797,
  [SMALL_STATE(54)] = 4850,
  [SMALL_STATE(55)] = 4942,
  [SMALL_STATE(56)] = 4994,
  [SMALL_STATE(57)] = 5086,
  [SMALL_STATE(58)] = 5178,
  [SMALL_STATE(59)] = 5270,
  [SMALL_STATE(60)] = 5334,
  [SMALL_STATE(61)] = 5426,
  [SMALL_STATE(62)] = 5518,
  [SMALL_STATE(63)] = 5582,
  [SMALL_STATE(64)] = 5674,
  [SMALL_STATE(65)] = 5766,
  [SMALL_STATE(66)] = 5817,
  [SMALL_STATE(67)] = 5880,
  [SMALL_STATE(68)] = 5965,
  [SMALL_STATE(69)] = 6048,
  [SMALL_STATE(70)] = 6133,
  [SMALL_STATE(71)] = 6176,
  [SMALL_STATE(72)] = 6261,
  [SMALL_STATE(73)] = 6344,
  [SMALL_STATE(74)] = 6429,
  [SMALL_STATE(75)] = 6472,
  [SMALL_STATE(76)] = 6555,
  [SMALL_STATE(77)] = 6598,
  [SMALL_STATE(78)] = 6641,
  [SMALL_STATE(79)] = 6724,
  [SMALL_STATE(80)] = 6807,
  [SMALL_STATE(81)] = 6850,
  [SMALL_STATE(82)] = 6893,
  [SMALL_STATE(83)] = 6976,
  [SMALL_STATE(84)] = 7019,
  [SMALL_STATE(85)] = 7102,
  [SMALL_STATE(86)] = 7185,
  [SMALL_STATE(87)] = 7268,
  [SMALL_STATE(88)] = 7351,
  [SMALL_STATE(89)] = 7434,
  [SMALL_STATE(90)] = 7477,
  [SMALL_STATE(91)] = 7520,
  [SMALL_STATE(92)] = 7563,
  [SMALL_STATE(93)] = 7646,
  [SMALL_STATE(94)] = 7689,
  [SMALL_STATE(95)] = 7772,
  [SMALL_STATE(96)] = 7855,
  [SMALL_STATE(97)] = 7898,
  [SMALL_STATE(98)] = 7941,
  [SMALL_STATE(99)] = 8024,
  [SMALL_STATE(100)] = 8107,
  [SMALL_STATE(101)] = 8150,
  [SMALL_STATE(102)] = 8193,
  [SMALL_STATE(103)] = 8276,
  [SMALL_STATE(104)] = 8319,
  [SMALL_STATE(105)] = 8362,
  [SMALL_STATE(106)] = 8445,
  [SMALL_STATE(107)] = 8488,
  [SMALL_STATE(108)] = 8571,
  [SMALL_STATE(109)] = 8654,
  [SMALL_STATE(110)] = 8737,
  [SMALL_STATE(111)] = 8820,
  [SMALL_STATE(112)] = 8903,
  [SMALL_STATE(113)] = 8946,
  [SMALL_STATE(114)] = 9029,
  [SMALL_STATE(115)] = 9112,
  [SMALL_STATE(116)] = 9195,
  [SMALL_STATE(117)] = 9278,
  [SMALL_STATE(118)] = 9361,
  [SMALL_STATE(119)] = 9444,
  [SMALL_STATE(120)] = 9527,
  [SMALL_STATE(121)] = 9570,
  [SMALL_STATE(122)] = 9655,
  [SMALL_STATE(123)] = 9740,
  [SMALL_STATE(124)] = 9783,
  [SMALL_STATE(125)] = 9825,
  [SMALL_STATE(126)] = 9867,
  [SMALL_STATE(127)] = 9911,
  [SMALL_STATE(128)] = 9953,
  [SMALL_STATE(129)] = 9995,
  [SMALL_STATE(130)] = 10037,
  [SMALL_STATE(131)] = 10081,
  [SMALL_STATE(132)] = 10123,
  [SMALL_STATE(133)] = 10165,
  [SMALL_STATE(134)] = 10207,
  [SMALL_STATE(135)] = 10249,
  [SMALL_STATE(136)] = 10291,
  [SMALL_STATE(137)] = 10333,
  [SMALL_STATE(138)] = 10375,
  [SMALL_STATE(139)] = 10421,
  [SMALL_STATE(140)] = 10467,
  [SMALL_STATE(141)] = 10509,
  [SMALL_STATE(142)] = 10550,
  [SMALL_STATE(143)] = 10591,
  [SMALL_STATE(144)] = 10632,
  [SMALL_STATE(145)] = 10673,
  [SMALL_STATE(146)] = 10713,
  [SMALL_STATE(147)] = 10758,
  [SMALL_STATE(148)] = 10801,
  [SMALL_STATE(149)] = 10844,
  [SMALL_STATE(150)] = 10887,
  [SMALL_STATE(151)] = 10932,
  [SMALL_STATE(152)] = 10975,
  [SMALL_STATE(153)] = 11019,
  [SMALL_STATE(154)] = 11089,
  [SMALL_STATE(155)] = 11157,
  [SMALL_STATE(156)] = 11225,
  [SMALL_STATE(157)] = 11293,
  [SMALL_STATE(158)] = 11361,
  [SMALL_STATE(159)] = 11429,
  [SMALL_STATE(160)] = 11499,
  [SMALL_STATE(161)] = 11567,
  [SMALL_STATE(162)] = 11609,
  [SMALL_STATE(163)] = 11677,
  [SMALL_STATE(164)] = 11745,
  [SMALL_STATE(165)] = 11813,
  [SMALL_STATE(166)] = 11881,
  [SMALL_STATE(167)] = 11927,
  [SMALL_STATE(168)] = 11995,
  [SMALL_STATE(169)] = 12063,
  [SMALL_STATE(170)] = 12107,
  [SMALL_STATE(171)] = 12177,
  [SMALL_STATE(172)] = 12245,
  [SMALL_STATE(173)] = 12313,
  [SMALL_STATE(174)] = 12383,
  [SMALL_STATE(175)] = 12451,
  [SMALL_STATE(176)] = 12521,
  [SMALL_STATE(177)] = 12589,
  [SMALL_STATE(178)] = 12657,
  [SMALL_STATE(179)] = 12725,
  [SMALL_STATE(180)] = 12793,
  [SMALL_STATE(181)] = 12861,
  [SMALL_STATE(182)] = 12931,
  [SMALL_STATE(183)] = 12999,
  [SMALL_STATE(184)] = 13067,
  [SMALL_STATE(185)] = 13111,
  [SMALL_STATE(186)] = 13179,
  [SMALL_STATE(187)] = 13223,
  [SMALL_STATE(188)] = 13291,
  [SMALL_STATE(189)] = 13359,
  [SMALL_STATE(190)] = 13429,
  [SMALL_STATE(191)] = 13497,
  [SMALL_STATE(192)] = 13565,
  [SMALL_STATE(193)] = 13633,
  [SMALL_STATE(194)] = 13701,
  [SMALL_STATE(195)] = 13769,
  [SMALL_STATE(196)] = 13839,
  [SMALL_STATE(197)] = 13907,
  [SMALL_STATE(198)] = 13975,
  [SMALL_STATE(199)] = 14045,
  [SMALL_STATE(200)] = 14113,
  [SMALL_STATE(201)] = 14181,
  [SMALL_STATE(202)] = 14246,
  [SMALL_STATE(203)] = 14311,
  [SMALL_STATE(204)] = 14376,
  [SMALL_STATE(205)] = 14441,
  [SMALL_STATE(206)] = 14506,
  [SMALL_STATE(207)] = 14571,
  [SMALL_STATE(208)] = 14636,
  [SMALL_STATE(209)] = 14701,
  [SMALL_STATE(210)] = 14766,
  [SMALL_STATE(211)] = 14831,
  [SMALL_STATE(212)] = 14896,
  [SMALL_STATE(213)] = 14961,
  [SMALL_STATE(214)] = 15026,
  [SMALL_STATE(215)] = 15091,
  [SMALL_STATE(216)] = 15156,
  [SMALL_STATE(217)] = 15221,
  [SMALL_STATE(218)] = 15286,
  [SMALL_STATE(219)] = 15351,
  [SMALL_STATE(220)] = 15416,
  [SMALL_STATE(221)] = 15481,
  [SMALL_STATE(222)] = 15546,
  [SMALL_STATE(223)] = 15611,
  [SMALL_STATE(224)] = 15676,
  [SMALL_STATE(225)] = 15741,
  [SMALL_STATE(226)] = 15806,
  [SMALL_STATE(227)] = 15871,
  [SMALL_STATE(228)] = 15936,
  [SMALL_STATE(229)] = 16001,
  [SMALL_STATE(230)] = 16066,
  [SMALL_STATE(231)] = 16131,
  [SMALL_STATE(232)] = 16196,
  [SMALL_STATE(233)] = 16261,
  [SMALL_STATE(234)] = 16326,
  [SMALL_STATE(235)] = 16391,
  [SMALL_STATE(236)] = 16456,
  [SMALL_STATE(237)] = 16521,
  [SMALL_STATE(238)] = 16586,
  [SMALL_STATE(239)] = 16651,
  [SMALL_STATE(240)] = 16716,
  [SMALL_STATE(241)] = 16781,
  [SMALL_STATE(242)] = 16846,
  [SMALL_STATE(243)] = 16911,
  [SMALL_STATE(244)] = 16976,
  [SMALL_STATE(245)] = 17041,
  [SMALL_STATE(246)] = 17106,
  [SMALL_STATE(247)] = 17171,
  [SMALL_STATE(248)] = 17236,
  [SMALL_STATE(249)] = 17301,
  [SMALL_STATE(250)] = 17366,
  [SMALL_STATE(251)] = 17431,
  [SMALL_STATE(252)] = 17496,
  [SMALL_STATE(253)] = 17561,
  [SMALL_STATE(254)] = 17626,
  [SMALL_STATE(255)] = 17691,
  [SMALL_STATE(256)] = 17756,
  [SMALL_STATE(257)] = 17821,
  [SMALL_STATE(258)] = 17886,
  [SMALL_STATE(259)] = 17951,
  [SMALL_STATE(260)] = 18016,
  [SMALL_STATE(261)] = 18081,
  [SMALL_STATE(262)] = 18146,
  [SMALL_STATE(263)] = 18211,
  [SMALL_STATE(264)] = 18276,
  [SMALL_STATE(265)] = 18341,
  [SMALL_STATE(266)] = 18406,
  [SMALL_STATE(267)] = 18471,
  [SMALL_STATE(268)] = 18536,
  [SMALL_STATE(269)] = 18601,
  [SMALL_STATE(270)] = 18666,
  [SMALL_STATE(271)] = 18731,
  [SMALL_STATE(272)] = 18781,
  [SMALL_STATE(273)] = 18831,
  [SMALL_STATE(274)] = 18873,
  [SMALL_STATE(275)] = 18923,
  [SMALL_STATE(276)] = 18963,
  [SMALL_STATE(277)] = 19013,
  [SMALL_STATE(278)] = 19075,
  [SMALL_STATE(279)] = 19109,
  [SMALL_STATE(280)] = 19149,
  [SMALL_STATE(281)] = 19189,
  [SMALL_STATE(282)] = 19229,
  [SMALL_STATE(283)] = 19260,
  [SMALL_STATE(284)] = 19291,
  [SMALL_STATE(285)] = 19322,
  [SMALL_STATE(286)] = 19353,
  [SMALL_STATE(287)] = 19384,
  [SMALL_STATE(288)] = 19423,
  [SMALL_STATE(289)] = 19458,
  [SMALL_STATE(290)] = 19489,
  [SMALL_STATE(291)] = 19520,
  [SMALL_STATE(292)] = 19565,
  [SMALL_STATE(293)] = 19596,
  [SMALL_STATE(294)] = 19633,
  [SMALL_STATE(295)] = 19664,
  [SMALL_STATE(296)] = 19709,
  [SMALL_STATE(297)] = 19740,
  [SMALL_STATE(298)] = 19785,
  [SMALL_STATE(299)] = 19816,
  [SMALL_STATE(300)] = 19861,
  [SMALL_STATE(301)] = 19892,
  [SMALL_STATE(302)] = 19929,
  [SMALL_STATE(303)] = 19960,
  [SMALL_STATE(304)] = 19991,
  [SMALL_STATE(305)] = 20030,
  [SMALL_STATE(306)] = 20061,
  [SMALL_STATE(307)] = 20092,
  [SMALL_STATE(308)] = 20131,
  [SMALL_STATE(309)] = 20162,
  [SMALL_STATE(310)] = 20201,
  [SMALL_STATE(311)] = 20232,
  [SMALL_STATE(312)] = 20263,
  [SMALL_STATE(313)] = 20304,
  [SMALL_STATE(314)] = 20335,
  [SMALL_STATE(315)] = 20367,
  [SMALL_STATE(316)] = 20399,
  [SMALL_STATE(317)] = 20431,
  [SMALL_STATE(318)] = 20463,
  [SMALL_STATE(319)] = 20495,
  [SMALL_STATE(320)] = 20527,
  [SMALL_STATE(321)] = 20559,
  [SMALL_STATE(322)] = 20591,
  [SMALL_STATE(323)] = 20635,
  [SMALL_STATE(324)] = 20667,
  [SMALL_STATE(325)] = 20699,
  [SMALL_STATE(326)] = 20731,
  [SMALL_STATE(327)] = 20763,
  [SMALL_STATE(328)] = 20795,
  [SMALL_STATE(329)] = 20835,
  [SMALL_STATE(330)] = 20875,
  [SMALL_STATE(331)] = 20907,
  [SMALL_STATE(332)] = 20939,
  [SMALL_STATE(333)] = 20983,
  [SMALL_STATE(334)] = 21015,
  [SMALL_STATE(335)] = 21047,
  [SMALL_STATE(336)] = 21079,
  [SMALL_STATE(337)] = 21119,
  [SMALL_STATE(338)] = 21151,
  [SMALL_STATE(339)] = 21183,
  [SMALL_STATE(340)] = 21219,
  [SMALL_STATE(341)] = 21255,
  [SMALL_STATE(342)] = 21287,
  [SMALL_STATE(343)] = 21316,
  [SMALL_STATE(344)] = 21345,
  [SMALL_STATE(345)] = 21374,
  [SMALL_STATE(346)] = 21409,
  [SMALL_STATE(347)] = 21438,
  [SMALL_STATE(348)] = 21475,
  [SMALL_STATE(349)] = 21512,
  [SMALL_STATE(350)] = 21551,
  [SMALL_STATE(351)] = 21580,
  [SMALL_STATE(352)] = 21609,
  [SMALL_STATE(353)] = 21638,
  [SMALL_STATE(354)] = 21675,
  [SMALL_STATE(355)] = 21714,
  [SMALL_STATE(356)] = 21751,
  [SMALL_STATE(357)] = 21790,
  [SMALL_STATE(358)] = 21824,
  [SMALL_STATE(359)] = 21854,
  [SMALL_STATE(360)] = 21884,
  [SMALL_STATE(361)] = 21918,
  [SMALL_STATE(362)] = 21948,
  [SMALL_STATE(363)] = 21978,
  [SMALL_STATE(364)] = 22008,
  [SMALL_STATE(365)] = 22042,
  [SMALL_STATE(366)] = 22072,
  [SMALL_STATE(367)] = 22102,
  [SMALL_STATE(368)] = 22132,
  [SMALL_STATE(369)] = 22162,
  [SMALL_STATE(370)] = 22196,
  [SMALL_STATE(371)] = 22230,
  [SMALL_STATE(372)] = 22260,
  [SMALL_STATE(373)] = 22290,
  [SMALL_STATE(374)] = 22320,
  [SMALL_STATE(375)] = 22350,
  [SMALL_STATE(376)] = 22380,
  [SMALL_STATE(377)] = 22410,
  [SMALL_STATE(378)] = 22440,
  [SMALL_STATE(379)] = 22470,
  [SMALL_STATE(380)] = 22500,
  [SMALL_STATE(381)] = 22530,
  [SMALL_STATE(382)] = 22560,
  [SMALL_STATE(383)] = 22594,
  [SMALL_STATE(384)] = 22628,
  [SMALL_STATE(385)] = 22662,
  [SMALL_STATE(386)] = 22692,
  [SMALL_STATE(387)] = 22722,
  [SMALL_STATE(388)] = 22772,
  [SMALL_STATE(389)] = 22802,
  [SMALL_STATE(390)] = 22832,
  [SMALL_STATE(391)] = 22862,
  [SMALL_STATE(392)] = 22892,
  [SMALL_STATE(393)] = 22922,
  [SMALL_STATE(394)] = 22952,
  [SMALL_STATE(395)] = 22982,
  [SMALL_STATE(396)] = 23012,
  [SMALL_STATE(397)] = 23042,
  [SMALL_STATE(398)] = 23072,
  [SMALL_STATE(399)] = 23100,
  [SMALL_STATE(400)] = 23128,
  [SMALL_STATE(401)] = 23162,
  [SMALL_STATE(402)] = 23192,
  [SMALL_STATE(403)] = 23222,
  [SMALL_STATE(404)] = 23251,
  [SMALL_STATE(405)] = 23278,
  [SMALL_STATE(406)] = 23307,
  [SMALL_STATE(407)] = 23338,
  [SMALL_STATE(408)] = 23367,
  [SMALL_STATE(409)] = 23396,
  [SMALL_STATE(410)] = 23425,
  [SMALL_STATE(411)] = 23454,
  [SMALL_STATE(412)] = 23483,
  [SMALL_STATE(413)] = 23512,
  [SMALL_STATE(414)] = 23559,
  [SMALL_STATE(415)] = 23604,
  [SMALL_STATE(416)] = 23633,
  [SMALL_STATE(417)] = 23662,
  [SMALL_STATE(418)] = 23691,
  [SMALL_STATE(419)] = 23720,
  [SMALL_STATE(420)] = 23749,
  [SMALL_STATE(421)] = 23778,
  [SMALL_STATE(422)] = 23807,
  [SMALL_STATE(423)] = 23836,
  [SMALL_STATE(424)] = 23865,
  [SMALL_STATE(425)] = 23894,
  [SMALL_STATE(426)] = 23923,
  [SMALL_STATE(427)] = 23952,
  [SMALL_STATE(428)] = 23985,
  [SMALL_STATE(429)] = 24014,
  [SMALL_STATE(430)] = 24043,
  [SMALL_STATE(431)] = 24072,
  [SMALL_STATE(432)] = 24101,
  [SMALL_STATE(433)] = 24130,
  [SMALL_STATE(434)] = 24177,
  [SMALL_STATE(435)] = 24212,
  [SMALL_STATE(436)] = 24241,
  [SMALL_STATE(437)] = 24268,
  [SMALL_STATE(438)] = 24297,
  [SMALL_STATE(439)] = 24342,
  [SMALL_STATE(440)] = 24371,
  [SMALL_STATE(441)] = 24404,
  [SMALL_STATE(442)] = 24431,
  [SMALL_STATE(443)] = 24478,
  [SMALL_STATE(444)] = 24525,
  [SMALL_STATE(445)] = 24558,
  [SMALL_STATE(446)] = 24585,
  [SMALL_STATE(447)] = 24614,
  [SMALL_STATE(448)] = 24645,
  [SMALL_STATE(449)] = 24674,
  [SMALL_STATE(450)] = 24703,
  [SMALL_STATE(451)] = 24740,
  [SMALL_STATE(452)] = 24773,
  [SMALL_STATE(453)] = 24818,
  [SMALL_STATE(454)] = 24847,
  [SMALL_STATE(455)] = 24876,
  [SMALL_STATE(456)] = 24911,
  [SMALL_STATE(457)] = 24942,
  [SMALL_STATE(458)] = 24971,
  [SMALL_STATE(459)] = 25000,
  [SMALL_STATE(460)] = 25032,
  [SMALL_STATE(461)] = 25082,
  [SMALL_STATE(462)] = 25114,
  [SMALL_STATE(463)] = 25164,
  [SMALL_STATE(464)] = 25214,
  [SMALL_STATE(465)] = 25248,
  [SMALL_STATE(466)] = 25298,
  [SMALL_STATE(467)] = 25326,
  [SMALL_STATE(468)] = 25354,
  [SMALL_STATE(469)] = 25404,
  [SMALL_STATE(470)] = 25432,
  [SMALL_STATE(471)] = 25460,
  [SMALL_STATE(472)] = 25510,
  [SMALL_STATE(473)] = 25560,
  [SMALL_STATE(474)] = 25588,
  [SMALL_STATE(475)] = 25616,
  [SMALL_STATE(476)] = 25666,
  [SMALL_STATE(477)] = 25694,
  [SMALL_STATE(478)] = 25722,
  [SMALL_STATE(479)] = 25750,
  [SMALL_STATE(480)] = 25777,
  [SMALL_STATE(481)] = 25804,
  [SMALL_STATE(482)] = 25831,
  [SMALL_STATE(483)] = 25872,
  [SMALL_STATE(484)] = 25907,
  [SMALL_STATE(485)] = 25934,
  [SMALL_STATE(486)] = 25961,
  [SMALL_STATE(487)] = 25988,
  [SMALL_STATE(488)] = 26015,
  [SMALL_STATE(489)] = 26042,
  [SMALL_STATE(490)] = 26069,
  [SMALL_STATE(491)] = 26096,
  [SMALL_STATE(492)] = 26123,
  [SMALL_STATE(493)] = 26150,
  [SMALL_STATE(494)] = 26177,
  [SMALL_STATE(495)] = 26204,
  [SMALL_STATE(496)] = 26231,
  [SMALL_STATE(497)] = 26258,
  [SMALL_STATE(498)] = 26285,
  [SMALL_STATE(499)] = 26312,
  [SMALL_STATE(500)] = 26339,
  [SMALL_STATE(501)] = 26366,
  [SMALL_STATE(502)] = 26393,
  [SMALL_STATE(503)] = 26420,
  [SMALL_STATE(504)] = 26447,
  [SMALL_STATE(505)] = 26474,
  [SMALL_STATE(506)] = 26501,
  [SMALL_STATE(507)] = 26528,
  [SMALL_STATE(508)] = 26555,
  [SMALL_STATE(509)] = 26585,
  [SMALL_STATE(510)] = 26611,
  [SMALL_STATE(511)] = 26637,
  [SMALL_STATE(512)] = 26663,
  [SMALL_STATE(513)] = 26689,
  [SMALL_STATE(514)] = 26715,
  [SMALL_STATE(515)] = 26741,
  [SMALL_STATE(516)] = 26769,
  [SMALL_STATE(517)] = 26795,
  [SMALL_STATE(518)] = 26821,
  [SMALL_STATE(519)] = 26847,
  [SMALL_STATE(520)] = 26877,
  [SMALL_STATE(521)] = 26902,
  [SMALL_STATE(522)] = 26933,
  [SMALL_STATE(523)] = 26958,
  [SMALL_STATE(524)] = 26989,
  [SMALL_STATE(525)] = 27016,
  [SMALL_STATE(526)] = 27047,
  [SMALL_STATE(527)] = 27078,
  [SMALL_STATE(528)] = 27109,
  [SMALL_STATE(529)] = 27134,
  [SMALL_STATE(530)] = 27159,
  [SMALL_STATE(531)] = 27190,
  [SMALL_STATE(532)] = 27215,
  [SMALL_STATE(533)] = 27250,
  [SMALL_STATE(534)] = 27275,
  [SMALL_STATE(535)] = 27300,
  [SMALL_STATE(536)] = 27325,
  [SMALL_STATE(537)] = 27350,
  [SMALL_STATE(538)] = 27375,
  [SMALL_STATE(539)] = 27410,
  [SMALL_STATE(540)] = 27431,
  [SMALL_STATE(541)] = 27452,
  [SMALL_STATE(542)] = 27473,
  [SMALL_STATE(543)] = 27494,
  [SMALL_STATE(544)] = 27515,
  [SMALL_STATE(545)] = 27536,
  [SMALL_STATE(546)] = 27566,
  [SMALL_STATE(547)] = 27594,
  [SMALL_STATE(548)] = 27623,
  [SMALL_STATE(549)] = 27650,
  [SMALL_STATE(550)] = 27677,
  [SMALL_STATE(551)] = 27704,
  [SMALL_STATE(552)] = 27731,
  [SMALL_STATE(553)] = 27758,
  [SMALL_STATE(554)] = 27785,
  [SMALL_STATE(555)] = 27803,
  [SMALL_STATE(556)] = 27833,
  [SMALL_STATE(557)] = 27863,
  [SMALL_STATE(558)] = 27886,
  [SMALL_STATE(559)] = 27909,
  [SMALL_STATE(560)] = 27932,
  [SMALL_STATE(561)] = 27951,
  [SMALL_STATE(562)] = 27974,
  [SMALL_STATE(563)] = 27990,
  [SMALL_STATE(564)] = 28006,
  [SMALL_STATE(565)] = 28022,
  [SMALL_STATE(566)] = 28038,
  [SMALL_STATE(567)] = 28054,
  [SMALL_STATE(568)] = 28070,
  [SMALL_STATE(569)] = 28094,
  [SMALL_STATE(570)] = 28110,
  [SMALL_STATE(571)] = 28124,
  [SMALL_STATE(572)] = 28138,
  [SMALL_STATE(573)] = 28154,
  [SMALL_STATE(574)] = 28168,
  [SMALL_STATE(575)] = 28184,
  [SMALL_STATE(576)] = 28200,
  [SMALL_STATE(577)] = 28218,
  [SMALL_STATE(578)] = 28234,
  [SMALL_STATE(579)] = 28252,
  [SMALL_STATE(580)] = 28269,
  [SMALL_STATE(581)] = 28286,
  [SMALL_STATE(582)] = 28301,
  [SMALL_STATE(583)] = 28316,
  [SMALL_STATE(584)] = 28331,
  [SMALL_STATE(585)] = 28348,
  [SMALL_STATE(586)] = 28363,
  [SMALL_STATE(587)] = 28378,
  [SMALL_STATE(588)] = 28393,
  [SMALL_STATE(589)] = 28408,
  [SMALL_STATE(590)] = 28423,
  [SMALL_STATE(591)] = 28440,
  [SMALL_STATE(592)] = 28455,
  [SMALL_STATE(593)] = 28470,
  [SMALL_STATE(594)] = 28485,
  [SMALL_STATE(595)] = 28500,
  [SMALL_STATE(596)] = 28515,
  [SMALL_STATE(597)] = 28530,
  [SMALL_STATE(598)] = 28545,
  [SMALL_STATE(599)] = 28562,
  [SMALL_STATE(600)] = 28579,
  [SMALL_STATE(601)] = 28596,
  [SMALL_STATE(602)] = 28613,
  [SMALL_STATE(603)] = 28630,
  [SMALL_STATE(604)] = 28645,
  [SMALL_STATE(605)] = 28660,
  [SMALL_STATE(606)] = 28675,
  [SMALL_STATE(607)] = 28690,
  [SMALL_STATE(608)] = 28707,
  [SMALL_STATE(609)] = 28722,
  [SMALL_STATE(610)] = 28739,
  [SMALL_STATE(611)] = 28754,
  [SMALL_STATE(612)] = 28769,
  [SMALL_STATE(613)] = 28786,
  [SMALL_STATE(614)] = 28803,
  [SMALL_STATE(615)] = 28818,
  [SMALL_STATE(616)] = 28833,
  [SMALL_STATE(617)] = 28850,
  [SMALL_STATE(618)] = 28865,
  [SMALL_STATE(619)] = 28882,
  [SMALL_STATE(620)] = 28897,
  [SMALL_STATE(621)] = 28912,
  [SMALL_STATE(622)] = 28929,
  [SMALL_STATE(623)] = 28944,
  [SMALL_STATE(624)] = 28958,
  [SMALL_STATE(625)] = 28978,
  [SMALL_STATE(626)] = 28996,
  [SMALL_STATE(627)] = 29016,
  [SMALL_STATE(628)] = 29035,
  [SMALL_STATE(629)] = 29054,
  [SMALL_STATE(630)] = 29069,
  [SMALL_STATE(631)] = 29088,
  [SMALL_STATE(632)] = 29107,
  [SMALL_STATE(633)] = 29126,
  [SMALL_STATE(634)] = 29143,
  [SMALL_STATE(635)] = 29160,
  [SMALL_STATE(636)] = 29171,
  [SMALL_STATE(637)] = 29190,
  [SMALL_STATE(638)] = 29209,
  [SMALL_STATE(639)] = 29228,
  [SMALL_STATE(640)] = 29241,
  [SMALL_STATE(641)] = 29252,
  [SMALL_STATE(642)] = 29269,
  [SMALL_STATE(643)] = 29284,
  [SMALL_STATE(644)] = 29303,
  [SMALL_STATE(645)] = 29322,
  [SMALL_STATE(646)] = 29341,
  [SMALL_STATE(647)] = 29358,
  [SMALL_STATE(648)] = 29377,
  [SMALL_STATE(649)] = 29396,
  [SMALL_STATE(650)] = 29415,
  [SMALL_STATE(651)] = 29428,
  [SMALL_STATE(652)] = 29447,
  [SMALL_STATE(653)] = 29464,
  [SMALL_STATE(654)] = 29481,
  [SMALL_STATE(655)] = 29500,
  [SMALL_STATE(656)] = 29516,
  [SMALL_STATE(657)] = 29532,
  [SMALL_STATE(658)] = 29548,
  [SMALL_STATE(659)] = 29560,
  [SMALL_STATE(660)] = 29576,
  [SMALL_STATE(661)] = 29592,
  [SMALL_STATE(662)] = 29608,
  [SMALL_STATE(663)] = 29620,
  [SMALL_STATE(664)] = 29632,
  [SMALL_STATE(665)] = 29648,
  [SMALL_STATE(666)] = 29660,
  [SMALL_STATE(667)] = 29676,
  [SMALL_STATE(668)] = 29692,
  [SMALL_STATE(669)] = 29708,
  [SMALL_STATE(670)] = 29724,
  [SMALL_STATE(671)] = 29737,
  [SMALL_STATE(672)] = 29750,
  [SMALL_STATE(673)] = 29763,
  [SMALL_STATE(674)] = 29776,
  [SMALL_STATE(675)] = 29789,
  [SMALL_STATE(676)] = 29802,
  [SMALL_STATE(677)] = 29815,
  [SMALL_STATE(678)] = 29828,
  [SMALL_STATE(679)] = 29841,
  [SMALL_STATE(680)] = 29854,
  [SMALL_STATE(681)] = 29867,
  [SMALL_STATE(682)] = 29880,
  [SMALL_STATE(683)] = 29893,
  [SMALL_STATE(684)] = 29906,
  [SMALL_STATE(685)] = 29919,
  [SMALL_STATE(686)] = 29932,
  [SMALL_STATE(687)] = 29945,
  [SMALL_STATE(688)] = 29958,
  [SMALL_STATE(689)] = 29971,
  [SMALL_STATE(690)] = 29984,
  [SMALL_STATE(691)] = 29997,
  [SMALL_STATE(692)] = 30010,
  [SMALL_STATE(693)] = 30023,
  [SMALL_STATE(694)] = 30036,
  [SMALL_STATE(695)] = 30049,
  [SMALL_STATE(696)] = 30062,
  [SMALL_STATE(697)] = 30075,
  [SMALL_STATE(698)] = 30088,
  [SMALL_STATE(699)] = 30101,
  [SMALL_STATE(700)] = 30114,
  [SMALL_STATE(701)] = 30127,
  [SMALL_STATE(702)] = 30140,
  [SMALL_STATE(703)] = 30153,
  [SMALL_STATE(704)] = 30166,
  [SMALL_STATE(705)] = 30179,
  [SMALL_STATE(706)] = 30192,
  [SMALL_STATE(707)] = 30205,
  [SMALL_STATE(708)] = 30218,
  [SMALL_STATE(709)] = 30231,
  [SMALL_STATE(710)] = 30244,
  [SMALL_STATE(711)] = 30257,
  [SMALL_STATE(712)] = 30270,
  [SMALL_STATE(713)] = 30283,
  [SMALL_STATE(714)] = 30296,
  [SMALL_STATE(715)] = 30309,
  [SMALL_STATE(716)] = 30322,
  [SMALL_STATE(717)] = 30335,
  [SMALL_STATE(718)] = 30348,
  [SMALL_STATE(719)] = 30359,
  [SMALL_STATE(720)] = 30372,
  [SMALL_STATE(721)] = 30385,
  [SMALL_STATE(722)] = 30398,
  [SMALL_STATE(723)] = 30411,
  [SMALL_STATE(724)] = 30424,
  [SMALL_STATE(725)] = 30437,
  [SMALL_STATE(726)] = 30450,
  [SMALL_STATE(727)] = 30463,
  [SMALL_STATE(728)] = 30476,
  [SMALL_STATE(729)] = 30487,
  [SMALL_STATE(730)] = 30500,
  [SMALL_STATE(731)] = 30513,
  [SMALL_STATE(732)] = 30526,
  [SMALL_STATE(733)] = 30539,
  [SMALL_STATE(734)] = 30552,
  [SMALL_STATE(735)] = 30565,
  [SMALL_STATE(736)] = 30578,
  [SMALL_STATE(737)] = 30591,
  [SMALL_STATE(738)] = 30604,
  [SMALL_STATE(739)] = 30614,
  [SMALL_STATE(740)] = 30624,
  [SMALL_STATE(741)] = 30634,
  [SMALL_STATE(742)] = 30644,
  [SMALL_STATE(743)] = 30654,
  [SMALL_STATE(744)] = 30664,
  [SMALL_STATE(745)] = 30672,
  [SMALL_STATE(746)] = 30680,
  [SMALL_STATE(747)] = 30690,
  [SMALL_STATE(748)] = 30700,
  [SMALL_STATE(749)] = 30710,
  [SMALL_STATE(750)] = 30720,
  [SMALL_STATE(751)] = 30730,
  [SMALL_STATE(752)] = 30740,
  [SMALL_STATE(753)] = 30750,
  [SMALL_STATE(754)] = 30760,
  [SMALL_STATE(755)] = 30770,
  [SMALL_STATE(756)] = 30780,
  [SMALL_STATE(757)] = 30790,
  [SMALL_STATE(758)] = 30800,
  [SMALL_STATE(759)] = 30807,
  [SMALL_STATE(760)] = 30814,
  [SMALL_STATE(761)] = 30821,
  [SMALL_STATE(762)] = 30828,
  [SMALL_STATE(763)] = 30835,
  [SMALL_STATE(764)] = 30842,
  [SMALL_STATE(765)] = 30849,
  [SMALL_STATE(766)] = 30856,
  [SMALL_STATE(767)] = 30863,
  [SMALL_STATE(768)] = 30870,
  [SMALL_STATE(769)] = 30877,
  [SMALL_STATE(770)] = 30884,
  [SMALL_STATE(771)] = 30891,
  [SMALL_STATE(772)] = 30898,
  [SMALL_STATE(773)] = 30905,
  [SMALL_STATE(774)] = 30912,
  [SMALL_STATE(775)] = 30919,
  [SMALL_STATE(776)] = 30926,
  [SMALL_STATE(777)] = 30933,
  [SMALL_STATE(778)] = 30940,
  [SMALL_STATE(779)] = 30947,
  [SMALL_STATE(780)] = 30954,
  [SMALL_STATE(781)] = 30961,
  [SMALL_STATE(782)] = 30968,
  [SMALL_STATE(783)] = 30975,
  [SMALL_STATE(784)] = 30982,
  [SMALL_STATE(785)] = 30989,
  [SMALL_STATE(786)] = 30996,
  [SMALL_STATE(787)] = 31003,
  [SMALL_STATE(788)] = 31010,
  [SMALL_STATE(789)] = 31017,
  [SMALL_STATE(790)] = 31024,
  [SMALL_STATE(791)] = 31031,
  [SMALL_STATE(792)] = 31038,
  [SMALL_STATE(793)] = 31045,
  [SMALL_STATE(794)] = 31052,
  [SMALL_STATE(795)] = 31059,
  [SMALL_STATE(796)] = 31066,
  [SMALL_STATE(797)] = 31073,
  [SMALL_STATE(798)] = 31080,
  [SMALL_STATE(799)] = 31087,
  [SMALL_STATE(800)] = 31094,
  [SMALL_STATE(801)] = 31101,
  [SMALL_STATE(802)] = 31108,
  [SMALL_STATE(803)] = 31115,
  [SMALL_STATE(804)] = 31122,
  [SMALL_STATE(805)] = 31129,
  [SMALL_STATE(806)] = 31136,
  [SMALL_STATE(807)] = 31143,
  [SMALL_STATE(808)] = 31150,
  [SMALL_STATE(809)] = 31157,
  [SMALL_STATE(810)] = 31164,
  [SMALL_STATE(811)] = 31171,
  [SMALL_STATE(812)] = 31178,
  [SMALL_STATE(813)] = 31185,
  [SMALL_STATE(814)] = 31192,
  [SMALL_STATE(815)] = 31199,
  [SMALL_STATE(816)] = 31206,
  [SMALL_STATE(817)] = 31213,
  [SMALL_STATE(818)] = 31220,
  [SMALL_STATE(819)] = 31227,
  [SMALL_STATE(820)] = 31234,
  [SMALL_STATE(821)] = 31241,
  [SMALL_STATE(822)] = 31248,
  [SMALL_STATE(823)] = 31255,
  [SMALL_STATE(824)] = 31262,
  [SMALL_STATE(825)] = 31269,
  [SMALL_STATE(826)] = 31276,
  [SMALL_STATE(827)] = 31283,
  [SMALL_STATE(828)] = 31290,
  [SMALL_STATE(829)] = 31297,
  [SMALL_STATE(830)] = 31304,
  [SMALL_STATE(831)] = 31311,
  [SMALL_STATE(832)] = 31318,
  [SMALL_STATE(833)] = 31325,
  [SMALL_STATE(834)] = 31332,
  [SMALL_STATE(835)] = 31339,
  [SMALL_STATE(836)] = 31346,
  [SMALL_STATE(837)] = 31353,
  [SMALL_STATE(838)] = 31360,
  [SMALL_STATE(839)] = 31367,
  [SMALL_STATE(840)] = 31374,
  [SMALL_STATE(841)] = 31381,
  [SMALL_STATE(842)] = 31388,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [9] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule, 2),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [15] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule, 2),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(700),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(707),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(830),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(781),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(11),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [43] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_rule_repeat1, 2),
  [45] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_rule_repeat1, 2), SHIFT_REPEAT(87),
  [48] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_rule_repeat1, 2), SHIFT_REPEAT(241),
  [51] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_rule_repeat1, 2), SHIFT_REPEAT(51),
  [54] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_rule_repeat1, 2), SHIFT_REPEAT(127),
  [57] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_rule_repeat1, 2), SHIFT_REPEAT(700),
  [60] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_rule_repeat1, 2), SHIFT_REPEAT(707),
  [63] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_rule_repeat1, 2), SHIFT_REPEAT(830),
  [66] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_rule_repeat1, 2), SHIFT_REPEAT(137),
  [69] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_rule_repeat1, 2), SHIFT_REPEAT(85),
  [72] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_rule_repeat1, 2), SHIFT_REPEAT(204),
  [75] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_rule_repeat1, 2), SHIFT_REPEAT(13),
  [78] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_rule_repeat1, 2), SHIFT_REPEAT(127),
  [81] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_rule_repeat1, 2), SHIFT_REPEAT(82),
  [84] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_rule_repeat1, 2), SHIFT_REPEAT(781),
  [87] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_rule_repeat1, 2), SHIFT_REPEAT(11),
  [90] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_rule_repeat1, 2), SHIFT_REPEAT(237),
  [93] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_rule_repeat1, 2),
  [95] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule, 3),
  [97] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule, 3),
  [99] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_query_repeat1, 1),
  [101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [103] = {.entry = {.count = 1, .reusable = false}}, SHIFT(146),
  [105] = {.entry = {.count = 1, .reusable = false}}, SHIFT(344),
  [107] = {.entry = {.count = 1, .reusable = false}}, SHIFT(714),
  [109] = {.entry = {.count = 1, .reusable = false}}, SHIFT(710),
  [111] = {.entry = {.count = 1, .reusable = false}}, SHIFT(801),
  [113] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [115] = {.entry = {.count = 1, .reusable = false}}, SHIFT(343),
  [117] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [121] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [123] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [125] = {.entry = {.count = 1, .reusable = false}}, SHIFT(841),
  [127] = {.entry = {.count = 1, .reusable = false}}, SHIFT(248),
  [129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [135] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [137] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_query_repeat1, 2),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [151] = {.entry = {.count = 1, .reusable = false}}, SHIFT(267),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [155] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(714),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(710),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(801),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 1),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(544),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [181] = {.entry = {.count = 1, .reusable = false}}, SHIFT(540),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(543),
  [187] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 1),
  [189] = {.entry = {.count = 1, .reusable = false}}, SHIFT(219),
  [191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ref, 1),
  [193] = {.entry = {.count = 1, .reusable = false}}, SHIFT(828),
  [195] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ref, 1),
  [197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 2),
  [199] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 2),
  [201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_ref_repeat1, 2),
  [203] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_ref_repeat1, 2), SHIFT_REPEAT(828),
  [206] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_ref_repeat1, 2),
  [208] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_ref_repeat1, 2), SHIFT_REPEAT(463),
  [211] = {.entry = {.count = 1, .reusable = false}}, SHIFT(829),
  [213] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ref, 2),
  [215] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ref, 2),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [219] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [221] = {.entry = {.count = 1, .reusable = false}}, SHIFT(390),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(684),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(686),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(791),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [231] = {.entry = {.count = 1, .reusable = false}}, SHIFT(393),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr_infix, 3),
  [243] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr_infix, 3),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [251] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_some_decl_repeat1, 2),
  [253] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_some_decl_repeat1, 2),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [259] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr_unary, 2),
  [261] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr_unary, 2),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr_call, 3, .production_id = 1),
  [271] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr_call, 3, .production_id = 1),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set, 1),
  [277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set, 1),
  [279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ref_arg_dot, 2),
  [281] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ref_arg_dot, 2),
  [283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ref_arg, 1),
  [285] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ref_arg, 1),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [293] = {.entry = {.count = 1, .reusable = false}}, SHIFT(842),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object, 3),
  [297] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object, 3),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_non_empty_set, 3),
  [301] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_non_empty_set, 3),
  [303] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_empty_set, 2),
  [305] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_empty_set, 2),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object, 5),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object, 5),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object_compr, 5),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object_compr, 5),
  [315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ref_arg_brack, 3),
  [317] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ref_arg_brack, 3),
  [319] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_close_paren, 1),
  [321] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_close_paren, 1),
  [323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 4),
  [327] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 4),
  [329] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_non_empty_set, 5),
  [331] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_non_empty_set, 5),
  [333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set_compr, 5),
  [335] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set_compr, 5),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_non_empty_set, 4),
  [339] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_non_empty_set, 4),
  [341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 5),
  [343] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 5),
  [345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object, 4),
  [347] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object, 4),
  [349] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_compr, 5),
  [351] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_compr, 5),
  [353] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 3),
  [355] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 3),
  [357] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr_call, 4, .production_id = 3),
  [359] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr_call, 4, .production_id = 3),
  [361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 1),
  [363] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 1),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr_every, 7),
  [367] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr_every, 7),
  [369] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_membership, 3),
  [371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar, 1),
  [373] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_scalar, 1),
  [375] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_membership, 3),
  [377] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 1),
  [379] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 1),
  [381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_raw_string, 2),
  [385] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_raw_string, 2),
  [387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2),
  [389] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 1),
  [393] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 1),
  [395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_raw_string, 3),
  [397] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_raw_string, 3),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr_parens, 3),
  [401] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr_parens, 3),
  [403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr_every, 8),
  [405] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr_every, 8),
  [407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1),
  [409] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1),
  [411] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_membership, 5),
  [413] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_membership, 3), REDUCE(sym_membership, 5),
  [416] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_membership, 5),
  [418] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_membership, 3), REDUCE(sym_membership, 5),
  [421] = {.entry = {.count = 1, .reusable = false}}, SHIFT(251),
  [423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3),
  [425] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3),
  [427] = {.entry = {.count = 1, .reusable = false}}, SHIFT(800),
  [429] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fn_name, 1),
  [431] = {.entry = {.count = 1, .reusable = false}}, SHIFT(471),
  [433] = {.entry = {.count = 1, .reusable = false}}, SHIFT(799),
  [435] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_ref_repeat1, 2), SHIFT_REPEAT(799),
  [438] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_ref_repeat1, 2), SHIFT_REPEAT(471),
  [441] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_ref_repeat1, 2), SHIFT_REPEAT(775),
  [444] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_ref_repeat1, 2), SHIFT_REPEAT(460),
  [447] = {.entry = {.count = 1, .reusable = false}}, SHIFT(546),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(790),
  [471] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_name, 1),
  [473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(775),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(603),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(604),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(606),
  [519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(562),
  [521] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_assignment_operator, 1), SHIFT(280),
  [524] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_assignment_operator, 1), SHIFT(408),
  [527] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_assignment_operator, 1), SHIFT(727),
  [530] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_assignment_operator, 1), SHIFT(726),
  [533] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_assignment_operator, 1), SHIFT(813),
  [536] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_assignment_operator, 1), SHIFT(410),
  [539] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_assignment_operator, 1), SHIFT(214),
  [542] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_assignment_operator, 1), SHIFT(195),
  [545] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_assignment_operator, 1), SHIFT(408),
  [548] = {.entry = {.count = 1, .reusable = false}}, SHIFT(280),
  [550] = {.entry = {.count = 1, .reusable = false}}, SHIFT(408),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(727),
  [554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(726),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(813),
  [558] = {.entry = {.count = 1, .reusable = false}}, SHIFT(410),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [566] = {.entry = {.count = 1, .reusable = false}}, SHIFT(568),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(827),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(596),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [582] = {.entry = {.count = 1, .reusable = false}}, SHIFT(353),
  [584] = {.entry = {.count = 1, .reusable = false}}, SHIFT(517),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(685),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(683),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(792),
  [592] = {.entry = {.count = 1, .reusable = false}}, SHIFT(514),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(605),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [606] = {.entry = {.count = 1, .reusable = false}}, SHIFT(304),
  [608] = {.entry = {.count = 1, .reusable = false}}, SHIFT(466),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(698),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(705),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(821),
  [616] = {.entry = {.count = 1, .reusable = false}}, SHIFT(467),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [630] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [632] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [638] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [642] = {.entry = {.count = 1, .reusable = false}}, SHIFT(544),
  [644] = {.entry = {.count = 1, .reusable = false}}, SHIFT(539),
  [646] = {.entry = {.count = 1, .reusable = false}}, SHIFT(265),
  [648] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_ref_repeat1, 2), SHIFT_REPEAT(810),
  [651] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_ref_repeat1, 2), SHIFT_REPEAT(468),
  [654] = {.entry = {.count = 1, .reusable = false}}, SHIFT(250),
  [656] = {.entry = {.count = 1, .reusable = false}}, SHIFT(810),
  [658] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fn_name, 3),
  [660] = {.entry = {.count = 1, .reusable = false}}, SHIFT(812),
  [662] = {.entry = {.count = 1, .reusable = false}}, SHIFT(818),
  [664] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_name, 3),
  [666] = {.entry = {.count = 1, .reusable = false}}, SHIFT(819),
  [668] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_ref_repeat1, 2), SHIFT_REPEAT(818),
  [671] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_ref_repeat1, 2), SHIFT_REPEAT(465),
  [674] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_some_decl, 2),
  [676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [678] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_some_decl, 2),
  [680] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [682] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_some_decl, 3),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [686] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_some_decl, 3),
  [688] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [690] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_rule_args_repeat1, 2),
  [692] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_rule_args_repeat1, 2), SHIFT_REPEAT(260),
  [695] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_rule_args_repeat1, 2),
  [697] = {.entry = {.count = 1, .reusable = false}}, SHIFT(788),
  [699] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_ref_repeat1, 2), SHIFT_REPEAT(788),
  [702] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_ref_repeat1, 2), SHIFT_REPEAT(472),
  [705] = {.entry = {.count = 1, .reusable = false}}, SHIFT(789),
  [707] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 3),
  [709] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 3),
  [711] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_some_decl_repeat1, 2), SHIFT_REPEAT(84),
  [714] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_some_decl, 4),
  [716] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_some_decl, 4),
  [718] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_literal_repeat1, 2),
  [720] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_literal_repeat1, 2),
  [722] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_literal_repeat1, 2), SHIFT_REPEAT(219),
  [725] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_with_modifier, 4),
  [727] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_with_modifier, 4),
  [729] = {.entry = {.count = 1, .reusable = false}}, SHIFT(194),
  [731] = {.entry = {.count = 1, .reusable = false}}, SHIFT(253),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [735] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_args, 1),
  [737] = {.entry = {.count = 1, .reusable = false}}, SHIFT(216),
  [739] = {.entry = {.count = 1, .reusable = false}}, SHIFT(236),
  [741] = {.entry = {.count = 1, .reusable = false}}, SHIFT(223),
  [743] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_body, 2),
  [745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [747] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule_body, 2),
  [749] = {.entry = {.count = 1, .reusable = false}}, SHIFT(254),
  [751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [753] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_body, 5),
  [755] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule_body, 5),
  [757] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_head, 4),
  [759] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule_head, 4),
  [761] = {.entry = {.count = 1, .reusable = false}}, SHIFT(528),
  [763] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_body, 3),
  [765] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule_body, 3),
  [767] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_fn_args_repeat1, 2),
  [769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [771] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_head_comp, 2),
  [773] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule_head_comp, 2),
  [775] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [777] = {.entry = {.count = 1, .reusable = false}}, SHIFT(772),
  [779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [783] = {.entry = {.count = 1, .reusable = false}}, SHIFT(785),
  [785] = {.entry = {.count = 1, .reusable = false}}, SHIFT(826),
  [787] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_head, 3),
  [789] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule_head, 3),
  [791] = {.entry = {.count = 1, .reusable = false}}, SHIFT(529),
  [793] = {.entry = {.count = 1, .reusable = false}}, SHIFT(817),
  [795] = {.entry = {.count = 1, .reusable = false}}, SHIFT(808),
  [797] = {.entry = {.count = 1, .reusable = false}}, SHIFT(798),
  [799] = {.entry = {.count = 1, .reusable = false}}, SHIFT(787),
  [801] = {.entry = {.count = 1, .reusable = false}}, SHIFT(773),
  [803] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_head, 1),
  [805] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule_head, 1),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [811] = {.entry = {.count = 1, .reusable = false}}, SHIFT(522),
  [813] = {.entry = {.count = 1, .reusable = false}}, SHIFT(244),
  [815] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_body, 1),
  [817] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule_body, 1),
  [819] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_body, 6),
  [821] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule_body, 6),
  [823] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_body, 4),
  [825] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule_body, 4),
  [827] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_head, 5),
  [829] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule_head, 5),
  [831] = {.entry = {.count = 1, .reusable = false}}, SHIFT(520),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [837] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_head, 6),
  [839] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule_head, 6),
  [841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [843] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_head, 2),
  [845] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule_head, 2),
  [847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [855] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [857] = {.entry = {.count = 1, .reusable = false}}, SHIFT(545),
  [859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(809),
  [861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [865] = {.entry = {.count = 1, .reusable = false}}, SHIFT(547),
  [867] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bin_operator, 1),
  [869] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bin_operator, 1),
  [871] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_operator, 1),
  [873] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment_operator, 1),
  [875] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_infix_operator, 1),
  [877] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_infix_operator, 1),
  [879] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bool_operator, 1),
  [881] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bool_operator, 1),
  [883] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arith_operator, 1),
  [885] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arith_operator, 1),
  [887] = {.entry = {.count = 1, .reusable = true}}, SHIFT(816),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [891] = {.entry = {.count = 1, .reusable = true}}, SHIFT(804),
  [893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(825),
  [897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(786),
  [899] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_ref_repeat1, 2), SHIFT_REPEAT(786),
  [902] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_ref_repeat1, 2), SHIFT_REPEAT(475),
  [905] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_ref_repeat1, 2), SHIFT_REPEAT(825),
  [908] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_ref_repeat1, 2), SHIFT_REPEAT(462),
  [911] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module, 1),
  [913] = {.entry = {.count = 1, .reusable = false}}, SHIFT(483),
  [915] = {.entry = {.count = 1, .reusable = false}}, SHIFT(532),
  [917] = {.entry = {.count = 1, .reusable = false}}, SHIFT(738),
  [919] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module, 2),
  [921] = {.entry = {.count = 1, .reusable = false}}, SHIFT(246),
  [923] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [925] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [927] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [929] = {.entry = {.count = 1, .reusable = false}}, SHIFT(95),
  [931] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_rule_args_repeat1, 2), SHIFT_REPEAT(231),
  [934] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [936] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_some_decl_repeat1, 2), SHIFT_REPEAT(109),
  [939] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_some_decl_repeat1, 2), SHIFT_REPEAT(95),
  [942] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_literal_repeat1, 2), SHIFT_REPEAT(265),
  [945] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_literal_repeat1, 2), SHIFT_REPEAT(250),
  [948] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_policy_repeat1, 2),
  [950] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_policy_repeat1, 2), SHIFT_REPEAT(483),
  [953] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_policy_repeat1, 2), SHIFT_REPEAT(738),
  [956] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_repeat1, 2),
  [958] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_module_repeat1, 2),
  [960] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_module_repeat1, 2), SHIFT_REPEAT(532),
  [963] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_policy, 1),
  [965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(617),
  [971] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [977] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__import, 2),
  [979] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__import, 2),
  [981] = {.entry = {.count = 1, .reusable = false}}, SHIFT(770),
  [983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [985] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [997] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1001] = {.entry = {.count = 1, .reusable = false}}, SHIFT(6),
  [1003] = {.entry = {.count = 1, .reusable = false}}, SHIFT(797),
  [1005] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 1),
  [1007] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [1009] = {.entry = {.count = 1, .reusable = false}}, SHIFT(835),
  [1011] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_query_repeat1, 3),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [1019] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [1021] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [1023] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [1025] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [1027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [1031] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [1033] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_query_repeat1, 2), SHIFT_REPEAT(6),
  [1036] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_query_repeat1, 2), SHIFT_REPEAT(797),
  [1039] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_rule_args_repeat1, 2), SHIFT_REPEAT(201),
  [1042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [1046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(610),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1060] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_query_repeat1, 2), SHIFT_REPEAT(5),
  [1063] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_query_repeat1, 2), SHIFT_REPEAT(835),
  [1066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [1068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [1070] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [1072] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [1074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [1078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1082] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [1086] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1088] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [1090] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 2),
  [1092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1098] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [1100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [1102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [1104] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object_item, 3, .production_id = 2),
  [1106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [1108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [1112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [1114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [1116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [1118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [1120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(593),
  [1124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [1126] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__import, 4),
  [1128] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__import, 4),
  [1130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [1132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [1136] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__package, 2),
  [1138] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__package, 2),
  [1140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [1142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [1146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [1148] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_args, 1),
  [1150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [1152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [1156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [1158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [1162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1164] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [1166] = {.entry = {.count = 1, .reusable = false}}, SHIFT(712),
  [1168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(802),
  [1170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [1172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [1174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1176] = {.entry = {.count = 1, .reusable = false}}, SHIFT(477),
  [1178] = {.entry = {.count = 1, .reusable = false}}, SHIFT(720),
  [1180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [1182] = {.entry = {.count = 1, .reusable = false}}, SHIFT(476),
  [1184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [1186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [1190] = {.entry = {.count = 1, .reusable = false}}, SHIFT(516),
  [1192] = {.entry = {.count = 1, .reusable = false}}, SHIFT(509),
  [1194] = {.entry = {.count = 1, .reusable = false}}, SHIFT(510),
  [1196] = {.entry = {.count = 1, .reusable = false}}, SHIFT(681),
  [1198] = {.entry = {.count = 1, .reusable = false}}, SHIFT(397),
  [1200] = {.entry = {.count = 1, .reusable = false}}, SHIFT(687),
  [1202] = {.entry = {.count = 1, .reusable = false}}, SHIFT(511),
  [1204] = {.entry = {.count = 1, .reusable = false}}, SHIFT(682),
  [1206] = {.entry = {.count = 1, .reusable = false}}, SHIFT(394),
  [1208] = {.entry = {.count = 1, .reusable = false}}, SHIFT(689),
  [1210] = {.entry = {.count = 1, .reusable = false}}, SHIFT(379),
  [1212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [1214] = {.entry = {.count = 1, .reusable = false}}, SHIFT(378),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [1218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [1220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1222] = {.entry = {.count = 1, .reusable = false}}, SHIFT(140),
  [1224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [1228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [1230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_args, 2),
  [1232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [1234] = {.entry = {.count = 1, .reusable = false}}, SHIFT(473),
  [1236] = {.entry = {.count = 1, .reusable = false}}, SHIFT(675),
  [1238] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [1240] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [1242] = {.entry = {.count = 1, .reusable = false}}, SHIFT(693),
  [1244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [1246] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fn_args_repeat1, 2), SHIFT_REPEAT(107),
  [1249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [1251] = {.entry = {.count = 1, .reusable = false}}, SHIFT(352),
  [1253] = {.entry = {.count = 1, .reusable = false}}, SHIFT(474),
  [1255] = {.entry = {.count = 1, .reusable = false}}, SHIFT(677),
  [1257] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_args, 2),
  [1259] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [1261] = {.entry = {.count = 1, .reusable = false}}, SHIFT(699),
  [1263] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_object_repeat1, 2), SHIFT_REPEAT(277),
  [1266] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_object_repeat1, 2),
  [1268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1270] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [1272] = {.entry = {.count = 1, .reusable = false}}, SHIFT(671),
  [1274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [1276] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_raw_string_repeat1, 2),
  [1278] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_raw_string_repeat1, 2), SHIFT_REPEAT(712),
  [1281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [1283] = {.entry = {.count = 1, .reusable = false}}, SHIFT(350),
  [1285] = {.entry = {.count = 1, .reusable = false}}, SHIFT(704),
  [1287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [1291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [1293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [1295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [1297] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2),
  [1299] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(720),
  [1302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [1304] = {.entry = {.count = 1, .reusable = false}}, SHIFT(448),
  [1306] = {.entry = {.count = 1, .reusable = false}}, SHIFT(449),
  [1308] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_expr_every_repeat1, 2), SHIFT_REPEAT(802),
  [1311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_expr_every_repeat1, 2),
  [1313] = {.entry = {.count = 1, .reusable = false}}, SHIFT(453),
  [1315] = {.entry = {.count = 1, .reusable = false}}, SHIFT(723),
  [1317] = {.entry = {.count = 1, .reusable = false}}, SHIFT(454),
  [1319] = {.entry = {.count = 1, .reusable = false}}, SHIFT(724),
  [1321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [1323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [1327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [1329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [1331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [1335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [1341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [1345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [1347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [1349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [1351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [1353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [1355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [1357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [1359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [1361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [1363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [1365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [1367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [1371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [1377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [1381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(663),
  [1383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [1387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
  [1389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [1397] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module, 3),
  [1399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(611),
  [1401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(729),
  [1403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(615),
  [1409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [1411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [1413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [1415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [1417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [1419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [1421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [1423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [1425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [1427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [1429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [1431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [1433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [1435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [1437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [1439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(745),
  [1445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [1447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [1449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [1451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [1453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [1455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [1457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [1459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [1461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [1463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [1465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [1467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [1469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(578),
  [1471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [1473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [1475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [1477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [1481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [1487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [1489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [1493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [1495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [1501] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [1503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [1505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [1509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(619),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(622),
  [1513] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [1517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [1519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(730),
  [1521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(734),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_rego(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_keyword,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
