/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.stage.Stage;
import org.jackhuang.hmcl.Main;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.SambaException;
import org.jackhuang.hmcl.task.AsyncTaskExecutor;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.upgrade.UpdateChecker;
import org.jackhuang.hmcl.upgrade.UpdateHandler;
import org.jackhuang.hmcl.util.CrashReporter;
import org.jackhuang.hmcl.util.DataSizeUnit;
import org.jackhuang.hmcl.util.FileSaver;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.CommandBuilder;
import org.jackhuang.hmcl.util.platform.NativeUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.SystemInfo;

public final class Launcher
extends Application {
    public static final CookieManager COOKIE_MANAGER = new CookieManager();
    public static final CrashReporter CRASH_REPORTER = new CrashReporter(true);

    public void start(Stage primaryStage) {
        Thread.currentThread().setUncaughtExceptionHandler(CRASH_REPORTER);
        CookieHandler.setDefault(COOKIE_MANAGER);
        Logger.LOG.info("JavaFX Version: " + System.getProperty("javafx.runtime.version"));
        try {
            Object pipeline = Class.forName("com.sun.prism.GraphicsPipeline").getMethod("getPipeline", new Class[0]).invoke(null, new Object[0]);
            Logger.LOG.info("Prism pipeline: " + (pipeline == null ? "null" : pipeline.getClass().getName()));
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to get prism pipeline", e);
        }
        try {
            try {
                ConfigHolder.init();
            }
            catch (SambaException ignored) {
                Main.showWarningAndContinue(I18n.i18n("fatal.samba"));
            }
            catch (IOException e) {
                Logger.LOG.error("Failed to load config", e);
                Launcher.checkConfigInTempDir();
                Launcher.checkConfigOwner();
                Main.showErrorAndExit(I18n.i18n("fatal.config_loading_failure", ConfigHolder.configLocation().getParent()));
            }
            if (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS && ConfigHolder.isNewlyCreated() && System.getProperty("user.dir").startsWith("/private/var/folders/")) {
                if (Launcher.showAlert(Alert.AlertType.WARNING, I18n.i18n("fatal.mac_app_translocation"), ButtonType.YES, ButtonType.NO) == ButtonType.NO) {
                    return;
                }
            } else {
                Launcher.checkConfigInTempDir();
            }
            if (ConfigHolder.isOwnerChanged() && Launcher.showAlert(Alert.AlertType.WARNING, I18n.i18n("fatal.config_change_owner_root"), ButtonType.YES, ButtonType.NO) == ButtonType.NO) {
                return;
            }
            if (ConfigHolder.isUnsupportedVersion()) {
                Launcher.showAlert(Alert.AlertType.WARNING, I18n.i18n("fatal.config_unsupported_version"), new ButtonType[0]);
            }
            if (Metadata.HMCL_CURRENT_DIRECTORY.toString().indexOf(61) >= 0) {
                Main.showWarningAndContinue(I18n.i18n("fatal.illegal_char"));
            }
            Platform.runLater(() -> {
                Platform.setImplicitExit((boolean)false);
                Controllers.initialize(primaryStage);
                UpdateChecker.init();
                primaryStage.show();
            });
        }
        catch (Throwable e) {
            CRASH_REPORTER.uncaughtException(Thread.currentThread(), e);
        }
    }

    private static ButtonType showAlert(Alert.AlertType alertType, String contentText, ButtonType ... buttons) {
        return new Alert(alertType, contentText, buttons).showAndWait().orElse(null);
    }

    private static boolean isConfigInTempDir() {
        String[] tempFolderNames;
        String configPath = ConfigHolder.configLocation().toString();
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (StringUtils.isNotBlank(tmpdir) && configPath.startsWith(tmpdir)) {
            return true;
        }
        for (String name : tempFolderNames = new String[]{"Temp", "Cache", "Caches"}) {
            if (!configPath.contains(File.separator + name + File.separator)) continue;
            return true;
        }
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
            return configPath.contains("\\Temporary Internet Files\\") || configPath.contains("\\INetCache\\") || configPath.contains("\\$Recycle.Bin\\") || configPath.contains("\\recycler\\");
        }
        if (OperatingSystem.CURRENT_OS.isLinuxOrBSD()) {
            return configPath.startsWith("/tmp/") || configPath.startsWith("/var/tmp/") || configPath.startsWith("/var/cache/") || configPath.startsWith("/dev/shm/") || configPath.contains("/Trash/");
        }
        if (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS) {
            return configPath.startsWith("/var/folders/") || configPath.startsWith("/private/var/folders/") || configPath.startsWith("/tmp/") || configPath.startsWith("/private/tmp/") || configPath.startsWith("/var/tmp/") || configPath.startsWith("/private/var/tmp/") || configPath.contains("/.Trash/");
        }
        return false;
    }

    private static void checkConfigInTempDir() {
        if (ConfigHolder.isNewlyCreated() && Launcher.isConfigInTempDir() && Launcher.showAlert(Alert.AlertType.WARNING, I18n.i18n("fatal.config_in_temp_dir"), ButtonType.YES, ButtonType.NO) == ButtonType.NO) {
            Main.exit(0);
        }
    }

    private static void checkConfigOwner() {
        Path mcDir;
        String owner;
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
            return;
        }
        String userName = System.getProperty("user.name");
        try {
            owner = Files.getOwner(ConfigHolder.configLocation(), new LinkOption[0]).getName();
        }
        catch (IOException ioe) {
            Logger.LOG.warning("Failed to get file owner", ioe);
            return;
        }
        if (Files.isWritable(ConfigHolder.configLocation()) || userName.equals("root") || userName.equals(owner)) {
            return;
        }
        ArrayList<String> files = new ArrayList<String>();
        files.add(ConfigHolder.configLocation().toString());
        if (Files.exists(Metadata.HMCL_GLOBAL_DIRECTORY, new LinkOption[0])) {
            files.add(Metadata.HMCL_GLOBAL_DIRECTORY.toString());
        }
        if (Files.exists(Metadata.HMCL_CURRENT_DIRECTORY, new LinkOption[0])) {
            files.add(Metadata.HMCL_CURRENT_DIRECTORY.toString());
        }
        if (Files.exists(mcDir = Paths.get(".minecraft", new String[0]).toAbsolutePath().normalize(), new LinkOption[0])) {
            files.add(mcDir.toString());
        }
        String command = new CommandBuilder().add("sudo", "chown", "-R", userName).addAll(files).toString();
        ButtonType copyAndExit = new ButtonType(I18n.i18n("button.copy_and_exit"));
        if (Launcher.showAlert(Alert.AlertType.ERROR, I18n.i18n("fatal.config_loading_failure.unix", owner, command), copyAndExit, ButtonType.CLOSE) == copyAndExit) {
            Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, command));
        }
        Main.exit(1);
    }

    public void stop() throws Exception {
        Controllers.onApplicationStop();
        FileSaver.shutdown();
        Logger.LOG.shutdown();
    }

    public static void main(String[] args) {
        if (UpdateHandler.processArguments(args)) {
            Logger.LOG.shutdown();
            return;
        }
        Thread.setDefaultUncaughtExceptionHandler(CRASH_REPORTER);
        AsyncTaskExecutor.setUncaughtExceptionHandler(new CrashReporter(false));
        try {
            Logger.LOG.info("*** " + Metadata.TITLE + " ***");
            Logger.LOG.info("Operating System: " + (OperatingSystem.OS_RELEASE_PRETTY_NAME == null ? OperatingSystem.SYSTEM_NAME + ' ' + OperatingSystem.SYSTEM_VERSION : OperatingSystem.OS_RELEASE_PRETTY_NAME + " (" + OperatingSystem.SYSTEM_NAME + ' ' + OperatingSystem.SYSTEM_VERSION + ')'));
            if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                Logger.LOG.info("Processor Identifier: " + System.getenv("PROCESSOR_IDENTIFIER"));
            }
            Logger.LOG.info("System Architecture: " + Architecture.SYSTEM_ARCH.getDisplayName());
            Logger.LOG.info("Native Encoding: " + OperatingSystem.NATIVE_CHARSET);
            Logger.LOG.info("JNU Encoding: " + System.getProperty("sun.jnu.encoding"));
            if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                Logger.LOG.info("Code Page: " + OperatingSystem.CODE_PAGE);
            }
            Logger.LOG.info("Java Architecture: " + Architecture.CURRENT_ARCH.getDisplayName());
            Logger.LOG.info("Java Version: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
            Logger.LOG.info("Java VM Version: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor"));
            Logger.LOG.info("Java Home: " + System.getProperty("java.home"));
            Logger.LOG.info("Current Directory: " + Metadata.CURRENT_DIRECTORY);
            Logger.LOG.info("HMCL Global Directory: " + Metadata.HMCL_GLOBAL_DIRECTORY);
            Logger.LOG.info("HMCL Current Directory: " + Metadata.HMCL_CURRENT_DIRECTORY);
            Logger.LOG.info("HMCL Jar Path: " + Lang.requireNonNullElse(JarUtils.thisJarPath(), "Not Found"));
            Logger.LOG.info("HMCL Log File: " + Lang.requireNonNullElse(Logger.LOG.getLogFile(), "In Memory"));
            Logger.LOG.info("JVM Max Memory: " + DataSizeUnit.MEGABYTES.formatBytes(Runtime.getRuntime().maxMemory()));
            try {
                for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
                    if (!"Metaspace".equals(bean.getName())) continue;
                    long bytes = bean.getUsage().getUsed();
                    Logger.LOG.info("Metaspace: " + DataSizeUnit.MEGABYTES.formatBytes(bytes));
                    break;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            Logger.LOG.info("Native Backend: " + (NativeUtils.USE_JNA ? "JNA" : "None"));
            if (OperatingSystem.CURRENT_OS.isLinuxOrBSD()) {
                Logger.LOG.info("XDG Session Type: " + System.getenv("XDG_SESSION_TYPE"));
                Logger.LOG.info("XDG Current Desktop: " + System.getenv("XDG_CURRENT_DESKTOP"));
            }
            Lang.thread(SystemInfo::initialize, "Detection System Information", true);
            Launcher.launch(Launcher.class, (String[])args);
        }
        catch (Throwable e) {
            CRASH_REPORTER.uncaughtException(Thread.currentThread(), e);
        }
    }

    public static void stopApplication() {
        Logger.LOG.info("Stopping application.\n" + StringUtils.getStackTrace(Thread.currentThread().getStackTrace()));
        FXUtils.runInFX(() -> {
            if (Controllers.getStage() == null) {
                return;
            }
            Controllers.getStage().close();
            Schedulers.shutdown();
            Controllers.shutdown();
            Platform.exit();
        });
    }

    public static void stopWithoutPlatform() {
        Logger.LOG.info("Stopping application without JavaFX Toolkit.\n" + StringUtils.getStackTrace(Thread.currentThread().getStackTrace()));
        FXUtils.runInFX(() -> {
            if (Controllers.getStage() == null) {
                return;
            }
            Controllers.getStage().close();
            Schedulers.shutdown();
            Controllers.shutdown();
            Lang.executeDelayed(System::gc, TimeUnit.SECONDS, 5L, true);
        });
    }
}

