/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public final class CrashReportAnalyzer {
    private static final Pattern CRASH_REPORT_LOCATION_PATTERN = Pattern.compile("#@!@# Game crashed! Crash report saved to: #@!@# (?<location>.*)");
    private static final Pattern CRASH_REPORT_STACK_TRACE_PATTERN = Pattern.compile("Description: (.*?)[\\n\\r]+(?<stacktrace>[\\w\\W\\n\\r]+)A detailed walkthrough of the error");
    private static final Pattern STACK_TRACE_LINE_PATTERN = Pattern.compile("at (?<method>.*?)\\((?<sourcefile>.*?)\\)");
    private static final Pattern STACK_TRACE_LINE_MODULE_PATTERN = Pattern.compile("\\{(?<tokens>.*)}");
    private static final Set<String> PACKAGE_KEYWORD_BLACK_LIST = new HashSet<String>(Arrays.asList("net", "minecraft", "item", "setup", "block", "assist", "optifine", "player", "unimi", "fastutil", "tileentity", "events", "common", "blockentity", "client", "entity", "mojang", "main", "gui", "world", "server", "dedicated", "map", "dsi", "renderer", "chunk", "model", "loading", "color", "pipeline", "inventory", "launcher", "physics", "particle", "gen", "registry", "worldgen", "texture", "biomes", "biome", "monster", "passive", "ai", "integrated", "tile", "state", "play", "override", "transformers", "structure", "nbt", "pathfinding", "chunk", "audio", "entities", "items", "renderers", "storage", "universal", "oshi", "platform", "java", "lang", "util", "nio", "io", "sun", "reflect", "zip", "jar", "jdk", "nashorn", "scripts", "runtime", "internal", "mods", "mod", "impl", "org", "com", "cn", "cc", "jp", "core", "config", "registries", "lib", "ruby", "mc", "codec", "recipe", "channel", "embedded", "done", "net", "netty", "network", "load", "github", "handler", "content", "feature", "file", "machine", "shader", "general", "helper", "init", "library", "api", "integration", "engine", "preload", "preinit", "hellominecraft", "jackhuang", "fml", "minecraftforge", "forge", "cpw", "modlauncher", "launchwrapper", "objectweb", "asm", "event", "eventhandler", "handshake", "modapi", "kcauldron", "fabricmc", "loader", "game", "knot", "launch", "mixin"));

    private CrashReportAnalyzer() {
    }

    public static Set<Result> analyze(String log) {
        HashSet<Result> results = new HashSet<Result>();
        for (Rule rule : Rule.values()) {
            Matcher matcher = rule.pattern.matcher(log);
            if (!matcher.find()) continue;
            results.add(new Result(rule, log, matcher));
        }
        return results;
    }

    @Nullable
    public static String findCrashReport(String log) throws IOException, InvalidPathException {
        Matcher matcher = CRASH_REPORT_LOCATION_PATTERN.matcher(log);
        if (matcher.find()) {
            return FileUtils.readText(Paths.get(matcher.group("location"), new String[0]));
        }
        return null;
    }

    public static String extractCrashReport(String rawLog) {
        int begin = rawLog.lastIndexOf("---- Minecraft Crash Report ----");
        int end = rawLog.lastIndexOf("#@!@# Game crashed! Crash report saved to");
        if (begin == -1 || end == -1 || begin >= end) {
            return null;
        }
        return rawLog.substring(begin, end);
    }

    public static Set<String> findKeywordsFromCrashReport(String crashReport) {
        Matcher matcher = CRASH_REPORT_STACK_TRACE_PATTERN.matcher(crashReport);
        HashSet<String> result = new HashSet<String>();
        if (matcher.find()) {
            for (String line : matcher.group("stacktrace").split("\\n")) {
                Matcher lineMatcher = STACK_TRACE_LINE_PATTERN.matcher(line);
                if (!lineMatcher.find()) continue;
                String[] method = lineMatcher.group("method").split("\\.");
                for (int i = 0; i < method.length - 2; ++i) {
                    if (PACKAGE_KEYWORD_BLACK_LIST.contains(method[i])) continue;
                    result.add(method[i]);
                }
                Matcher moduleMatcher = STACK_TRACE_LINE_MODULE_PATTERN.matcher(line);
                if (!moduleMatcher.find()) continue;
                for (String module : moduleMatcher.group("tokens").split(",")) {
                    String[] split = module.split(":");
                    if (split.length < 2 || !"xf".equals(split[0]) || PACKAGE_KEYWORD_BLACK_LIST.contains(split[1])) continue;
                    result.add(split[1]);
                }
            }
        }
        return result;
    }

    public static int getJavaVersionFromMajorVersion(int majorVersion) {
        if (majorVersion >= 46) {
            return majorVersion - 44;
        }
        return -1;
    }

    public static class Result {
        private final Rule rule;
        private final String log;
        private final Matcher matcher;

        public Result(Rule rule, String log, Matcher matcher) {
            this.rule = rule;
            this.log = log;
            this.matcher = matcher;
        }

        public Rule getRule() {
            return this.rule;
        }

        public String getLog() {
            return this.log;
        }

        public Matcher getMatcher() {
            return this.matcher;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            if (this.rule != result.rule) {
                return false;
            }
            if (!this.log.equals(result.log)) {
                return false;
            }
            return this.matcher.equals(result.matcher);
        }

        public int hashCode() {
            int result = this.rule.hashCode();
            result = 31 * result + this.log.hashCode();
            result = 31 * result + this.matcher.hashCode();
            return result;
        }
    }

    public static enum Rule {
        OPENJ9("(Open J9 is not supported|OpenJ9 is incompatible|\\.J9VMInternals\\.)", new String[0]),
        NEED_JDK11("(no such method: sun\\.misc\\.Unsafe\\.defineAnonymousClass\\(Class,byte\\[\\],Object\\[\\]\\)Class/invokeVirtual|java\\.lang\\.UnsupportedClassVersionError: icyllis/modernui/forge/MixinConnector has been compiled by a more recent version of the Java Runtime \\(class file version 55\\.0\\), this version of the Java Runtime only recognizes class file versions up to 52\\.0|java\\.lang\\.IllegalArgumentException: The requested compatibility level JAVA_11 could not be set\\. Level is not supported by the active JRE or ASM version)", new String[0]),
        TOO_OLD_JAVA("java\\.lang\\.UnsupportedClassVersionError: (.*?) version (?<expected>\\d+)\\.0", "expected"),
        JVM_32BIT("(Could not reserve enough space for (.*?)KB object heap|The specified size exceeds the maximum representable size|Invalid maximum heap size)", new String[0]),
        GL_OPERATION_FAILURE("(1282: Invalid operation|Maybe try a lower resolution resourcepack\\?)", new String[0]),
        OPENGL_NOT_SUPPORTED("The driver does not appear to support OpenGL", new String[0]),
        GRAPHICS_DRIVER("(Pixel format not accelerated|GLX: Failed to create context: GLXBadFBConfig|Couldn't set pixel format|net\\.minecraftforge\\.fml.client\\.SplashProgress|org\\.lwjgl\\.LWJGLException|EXCEPTION_ACCESS_VIOLATION(.|\\n|\\r)+# C {2}\\[(ig|atio|nvoglv))", new String[0]),
        MACOS_FAILED_TO_FIND_SERVICE_PORT_FOR_DISPLAY("java\\.lang\\.IllegalStateException: GLFW error before init: \\[0x10008\\]Cocoa: Failed to find service port for display", new String[0]),
        OUT_OF_MEMORY("(java\\.lang\\.OutOfMemoryError|The system is out of physical RAM or swap space|Out of Memory Error|Error occurred during initialization of VM\\RToo small maximum heap)", new String[0]),
        MEMORY_EXCEEDED("There is insufficient memory for the Java Runtime Environment to continue", new String[0]),
        RESOLUTION_TOO_HIGH("Maybe try a (lower resolution|lowerresolution) (resourcepack|texturepack)\\?", new String[0]),
        JDK_9("java\\.lang\\.ClassCastException: (java\\.base/jdk|class jdk)", new String[0]),
        MAC_JDK_8U261("Terminating app due to uncaught exception 'NSInternalInconsistencyException', reason: 'NSWindow drag regions should only be invalidated on the Main Thread!'", new String[0]),
        FILE_CHANGED("java\\.lang\\.SecurityException: SHA1 digest error for (?<file>.*)|signer information does not match signer information of other classes in the same package", "file"),
        NO_SUCH_METHOD_ERROR("java\\.lang\\.NoSuchMethodError: (?<class>.*?)", "class"),
        NO_CLASS_DEF_FOUND_ERROR("java\\.lang\\.NoClassDefFoundError: (?<class>.*)", "class"),
        ILLEGAL_ACCESS_ERROR("java\\.lang\\.IllegalAccessError: tried to access class (.*?) from class (?<class>.*?)", "class"),
        DUPLICATED_MOD("Found a duplicate mod (?<name>.*) at (?<path>.*)", "name", "path"),
        MOD_RESOLUTION("ModResolutionException: (?<reason>(.*)[\\n\\r]*( - (.*)[\\n\\r]*)+)", "reason"),
        FORGEMOD_RESOLUTION("Missing or unsupported mandatory dependencies:(?<reason>(.*)[\\n\\r]*(\t(.*)[\\n\\r]*)+)", "reason"),
        FORGE_FOUND_DUPLICATE_MODS("Found duplicate mods:(?<reason>(.*)\\R*(\t(.*)\\R*)+)", "reason"),
        MOD_RESOLUTION_CONFLICT("ModResolutionException: Found conflicting mods: (?<sourcemod>.*) conflicts with (?<destmod>.*)", "sourcemod", "destmod"),
        MOD_RESOLUTION_MISSING("ModResolutionException: Could not find required mod: (?<sourcemod>.*) requires (?<destmod>.*)", "sourcemod", "destmod"),
        MOD_RESOLUTION_MISSING_MINECRAFT("ModResolutionException: Could not find required mod: (?<mod>.*) requires \\{minecraft @ (?<version>.*)}", "mod", "version"),
        MOD_RESOLUTION_COLLECTION("ModResolutionException: Could not resolve valid mod collection \\(at: (?<sourcemod>.*) requires (?<destmod>.*)\\)", "sourcemod", "destmod"),
        FILE_ALREADY_EXISTS("java\\.nio\\.file\\.FileAlreadyExistsException: (?<file>.*)", "file"),
        LOADING_CRASHED_FORGE("LoaderExceptionModCrash: Caught exception from (?<name>.*?) \\((?<id>.*)\\)", "name", "id"),
        BOOTSTRAP_FAILED("Failed to create mod instance\\. ModID: (?<id>.*?),", "id"),
        LOADING_CRASHED_FABRIC("Could not execute entrypoint stage '(.*?)' due to errors, provided by '(?<id>.*)'!", "id"),
        FABRIC_VERSION_0_12("java\\.lang\\.NoClassDefFoundError: org/spongepowered/asm/mixin/transformer/FabricMixinTransformerProxy", new String[0]),
        MODLAUNCHER_8("java\\.lang\\.NoSuchMethodError: ('void sun\\.security\\.util\\.ManifestEntryVerifier\\.<init>\\(java\\.util\\.jar\\.Manifest\\)'|sun\\.security\\.util\\.ManifestEntryVerifier\\.<init>\\(Ljava/util/jar/Manifest;\\)V)", new String[0]),
        DEBUG_CRASH("Manually triggered debug crash", new String[0]),
        CONFIG("Failed loading config file (?<file>.*?) of type (.*?) for modid (?<id>.*)", "id", "file"),
        FABRIC_WARNINGS("(Warnings were found!|Incompatible mod set!|Incompatible mods found!)(.*?)[\\n\\r]+(?<reason>[^\\[]+)\\[", "reason"),
        ENTITY("Entity Type: (?<type>.*)[\\w\\W\\n\\r]*?Entity's Exact location: (?<location>.*)", "type", "location"),
        BLOCK("Block: (?<type>.*)[\\w\\W\\n\\r]*?Block location: (?<location>.*)", "type", "location"),
        UNSATISFIED_LINK_ERROR("java\\.lang\\.UnsatisfiedLinkError: Failed to locate library: (?<name>.*)", "name"),
        OPTIFINE_IS_NOT_COMPATIBLE_WITH_FORGE("(java\\.lang\\.NoSuchMethodError: 'java\\.lang\\.Class sun\\.misc\\.Unsafe\\.defineAnonymousClass\\(java\\.lang\\.Class, byte\\[\\], java\\.lang\\.Object\\[\\]\\)'|java\\.lang\\.NoSuchMethodError: 'void net\\.minecraft\\.client\\.renderer\\.texture\\.SpriteContents\\.\\<init\\>\\(net\\.minecraft\\.resources\\.ResourceLocation, |java\\.lang\\.NoSuchMethodError: 'void net\\.minecraftforge\\.client\\.gui\\.overlay\\.ForgeGui\\.renderSelectedItemName\\(net\\.minecraft\\.client\\.gui\\.GuiGraphics, int\\)'|java\\.lang\\.NoSuchMethodError: 'java\\.lang\\.String com\\.mojang\\.blaze3d\\.systems\\.RenderSystem\\.getBackendDescription\\(\\)'|java\\.lang\\.NoSuchMethodError: 'net\\.minecraft\\.network\\.chat\\.FormattedText net\\.minecraft\\.client\\.gui\\.Font\\.ellipsize\\(net\\.minecraft\\.network\\.chat\\.FormattedText, int\\)'|java\\.lang\\.NoSuchMethodError: 'void net\\.minecraft\\.server\\.level\\.DistanceManager\\.(.*?)\\(net\\.minecraft\\.server\\.level\\.TicketType, net\\.minecraft\\.world\\.level\\.ChunkPos, int, java\\.lang\\.Object, boolean\\)'|java\\.lang\\.NoSuchMethodError: 'void net\\.minecraft\\.client\\.renderer\\.block\\.model\\.BakedQuad\\.\\<init\\>\\(int\\[\\], int, net\\.minecraft\\.core\\.Direction, net\\.minecraft\\.client\\.renderer\\.texture\\.TextureAtlasSprite, boolean, boolean\\)'|TRANSFORMER/net\\.optifine/net\\.optifine\\.reflect\\.Reflector\\.\\<clinit\\>\\(Reflector\\.java)", new String[0]),
        MOD_FILES_ARE_DECOMPRESSED("(The directories below appear to be extracted jar files\\. Fix this before you continue|Extracted mod jars found, loading will NOT continue)", new String[0]),
        OPTIFINE_CAUSES_THE_WORLD_TO_FAIL_TO_LOAD("java\\.lang\\.NoSuchMethodError: net\\.minecraft\\.world\\.server\\.ChunkManager$ProxyTicketManager\\.shouldForceTicks\\(J\\)Z", new String[0]),
        TOO_MANY_MODS_LEAD_TO_EXCEEDING_THE_ID_LIMIT("maximum id range exceeded", new String[0]),
        MODMIXIN_FAILURE("(MixinApplyError|Mixin prepare failed |Mixin apply failed |mixin\\.injection\\.throwables\\.|\\.mixins\\.json\\] FAILED during \\))", new String[0]),
        MIXIN_APPLY_MOD_FAILED("Mixin apply for mod (?<id>.*) failed", "id"),
        FORGE_ERROR("An exception was thrown, the game will display an error screen and halt\\.\\R*(?<reason>.*\\R*(\\s*at .*\\R)+)", "reason"),
        MOD_RESOLUTION0("(\tMod File:|-- MOD |\tFailure message:)", new String[0]),
        FORGE_REPEAT_INSTALLATION("MultipleArgumentsForOptionException: Found multiple arguments for option (.*?), but you asked for only one", new String[0]),
        OPTIFINE_REPEAT_INSTALLATION("ResolutionException: Module optifine reads another module named optifine", new String[0]),
        JAVA_VERSION_IS_TOO_HIGH("(Unable to make protected final java\\.lang\\.Class java\\.lang\\.ClassLoader\\.defineClass|java\\.lang\\.NoSuchFieldException: ucp|Unsupported class file major version|because module java\\.base does not export|java\\.lang\\.ClassNotFoundException: jdk\\.nashorn\\.api\\.scripting\\.NashornScriptEngineFactory|java\\.lang\\.ClassNotFoundException: java\\.lang\\.invoke\\.LambdaMetafactory|Exception in thread \"main\" java\\.lang\\.NullPointerException: Cannot read the array length because \"urls\" is null)", new String[0]),
        INSTALL_MIXINBOOTSTRAP("java\\.lang\\.ClassNotFoundException: org\\.spongepowered\\.asm\\.launch\\.MixinTweaker", new String[0]),
        MOD_NAME("Invalid module name: '' is not a Java identifier", new String[0]),
        INCOMPLETE_FORGE_INSTALLATION("(java\\.io\\.UncheckedIOException: java\\.io\\.IOException: Invalid paths argument, contained no existing paths: \\[(.*?)(forge-(.*?)-client\\.jar|fmlcore-(.*?)\\.jar)\\]|Failed to find Minecraft resource version (.*?) at (.*?)forge-(.*?)-client\\.jar|Cannot find launch target fmlclient, unable to launch|java\\.lang\\.IllegalStateException: Could not find net/minecraft/client/Minecraft\\.class in classloader SecureModuleClassLoader)", new String[0]),
        NIGHT_CONFIG_FIXES("com\\.electronwill\\.nightconfig\\.core\\.io\\.ParsingException: Not enough data available", new String[0]),
        SHADERS_MOD("java\\.lang\\.RuntimeException: Shaders Mod detected\\. Please remove it, OptiFine has built-in support for shaders\\.", new String[0]),
        MOD_FOREST_OPTIFINE("Error occurred applying transform of coremod META-INF/asm/multipart\\.js function render", new String[0]),
        PERFORMANT_FOREST_OPTIFINE("org\\.spongepowered\\.asm\\.mixin\\.injection\\.throwables\\.InjectionError: Critical injection failure: Redirector OnisOnLadder\\(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/LivingEntity;\\)Z in performant\\.mixins\\.json:entity\\.LivingEntityMixin failed injection check, \\(0/1\\) succeeded\\. Scanned 1 target\\(s\\)\\. Using refmap performant\\.refmap\\.json", new String[0]),
        TWILIGHT_FOREST_OPTIFINE("java\\.lang\\.IllegalArgumentException: (.*) outside of image bounds (.*)", new String[0]),
        JADE_FOREST_OPTIFINE("Critical injection failure: LVT in net/minecraft/client/renderer/GameRenderer::m_109093_\\(FJZ\\)V has incompatible changes at opcode 760 in callback jade\\.mixins\\.json:GameRendererMixin-\\>@Inject::jade\\$runTick\\(FJZLorg/spongepowered/asm/mixin/injection/callback/CallbackInfo;IILcom/mojang/blaze3d/platform/Window;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/gui/GuiGraphics;\\)V\\.", new String[0]),
        NEOFORGE_FOREST_OPTIFINE("cpw\\.mods\\.modlauncher\\.InvalidLauncherSetupException: Invalid Services found OptiFine", new String[0]),
        RTSS_FOREST_SODIUM("RivaTuner Statistics Server \\(RTSS\\) is not compatible with Sodium", new String[0]);

        private final Pattern pattern;
        private final String[] groupNames;

        private Rule(String pattern, String ... groupNames) {
            this.pattern = Pattern.compile(pattern);
            this.groupNames = groupNames;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String[] getGroupNames() {
            return this.groupNames;
        }
    }
}

