/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXPopup;
import java.time.Instant;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.IconedMenuItem;
import org.jackhuang.hmcl.ui.construct.MenuSeparator;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.WorldListItem;
import org.jackhuang.hmcl.util.ChunkBaseApp;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public final class WorldListItemSkin
extends SkinBase<WorldListItem> {
    private final BorderPane root;

    public WorldListItemSkin(WorldListItem skinnable) {
        super((Control)skinnable);
        World world = skinnable.getWorld();
        this.root = new BorderPane();
        this.root.getStyleClass().add((Object)"md-list-cell");
        this.root.setPadding(new Insets(8.0));
        StackPane left = new StackPane();
        FXUtils.installSlowTooltip((Node)left, world.getFile().toString());
        this.root.setLeft((Node)left);
        left.setPadding(new Insets(0.0, 8.0, 0.0, 0.0));
        ImageView imageView = new ImageView();
        left.getChildren().add((Object)imageView);
        FXUtils.limitSize(imageView, 32.0, 32.0);
        imageView.setImage(world.getIcon() == null ? FXUtils.newBuiltinImage("/assets/img/unknown_server.png") : world.getIcon());
        TwoLineListItem item = new TwoLineListItem();
        this.root.setCenter((Node)item);
        item.setMouseTransparent(true);
        if (world.getWorldName() != null) {
            item.setTitle(StringUtils.parseColorEscapes(world.getWorldName()));
        }
        item.setSubtitle(I18n.i18n("world.datetime", I18n.formatDateTime(Instant.ofEpochMilli(world.getLastPlayed())), world.getGameVersion() == null ? I18n.i18n("message.unknown") : world.getGameVersion()));
        if (world.getGameVersion() != null) {
            item.getTags().add((Object)world.getGameVersion());
        }
        if (world.isLocked()) {
            item.getTags().add((Object)I18n.i18n("world.locked"));
        }
        HBox right = new HBox(8.0);
        this.root.setRight((Node)right);
        right.setAlignment(Pos.CENTER_RIGHT);
        JFXButton btnMore = new JFXButton();
        right.getChildren().add((Object)btnMore);
        btnMore.getStyleClass().add((Object)"toggle-icon4");
        btnMore.setGraphic(SVG.MORE_VERT.createIcon((Paint)Theme.blackFill(), -1.0));
        btnMore.setOnAction(event -> this.showPopupMenu(JFXPopup.PopupHPosition.RIGHT, 0.0, this.root.getHeight()));
        RipplerContainer container = new RipplerContainer((Node)this.root);
        container.setOnMouseClicked(event -> {
            if (event.getClickCount() != 1) {
                return;
            }
            if (event.getButton() == MouseButton.PRIMARY) {
                skinnable.showManagePage();
            } else if (event.getButton() == MouseButton.SECONDARY) {
                this.showPopupMenu(JFXPopup.PopupHPosition.LEFT, event.getX(), event.getY());
            }
        });
        this.getChildren().setAll((Object[])new Node[]{container});
    }

    public void showPopupMenu(JFXPopup.PopupHPosition hPosition, double initOffsetX, double initOffsetY) {
        PopupMenu popupMenu = new PopupMenu();
        JFXPopup popup = new JFXPopup((Region)popupMenu);
        WorldListItem item = (WorldListItem)this.getSkinnable();
        World world = item.getWorld();
        Object[] objectArray = new Node[1];
        objectArray[0] = new IconedMenuItem(SVG.SETTINGS, I18n.i18n("world.manage.button"), item::showManagePage, popup);
        popupMenu.getContent().addAll(objectArray);
        if (ChunkBaseApp.isSupported(world)) {
            popupMenu.getContent().addAll((Object[])new Node[]{new MenuSeparator(), new IconedMenuItem(SVG.EXPLORE, I18n.i18n("world.chunkbase.seed_map"), () -> ChunkBaseApp.openSeedMap(world), popup), new IconedMenuItem(SVG.VISIBILITY, I18n.i18n("world.chunkbase.stronghold"), () -> ChunkBaseApp.openStrongholdFinder(world), popup), new IconedMenuItem(SVG.FORT, I18n.i18n("world.chunkbase.nether_fortress"), () -> ChunkBaseApp.openNetherFortressFinder(world), popup)});
            if (GameVersionNumber.compare(world.getGameVersion(), "1.13") >= 0) {
                popupMenu.getContent().add((Object)new IconedMenuItem(SVG.LOCATION_CITY, I18n.i18n("world.chunkbase.end_city"), () -> ChunkBaseApp.openEndCityFinder(world), popup));
            }
        }
        Object[] objectArray2 = new Node[3];
        objectArray2[0] = new MenuSeparator();
        objectArray2[1] = new IconedMenuItem(SVG.OUTPUT, I18n.i18n("world.export"), item::export, popup);
        objectArray2[2] = new IconedMenuItem(SVG.FOLDER_OPEN, I18n.i18n("folder.world"), item::reveal, popup);
        popupMenu.getContent().addAll(objectArray2);
        popup.show((Node)this.root, JFXPopup.PopupVPosition.TOP, hPosition, initOffsetX, initOffsetY);
    }
}

