/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.upgrade;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class IntegrityChecker {
    public static final boolean DISABLE_SELF_INTEGRITY_CHECK = "true".equals(System.getProperty("hmcl.self_integrity_check.disable"));
    private static final String SIGNATURE_FILE = "META-INF/hmcl_signature";
    private static final String PUBLIC_KEY_FILE = "assets/hmcl_signature_publickey.der";
    private static volatile Boolean selfVerified = null;

    private IntegrityChecker() {
    }

    private static PublicKey getPublicKey() throws IOException {
        PublicKey publicKey;
        block9: {
            InputStream in = IntegrityChecker.class.getResourceAsStream("/assets/hmcl_signature_publickey.der");
            try {
                if (in == null) {
                    throw new IOException("Public key not found");
                }
                publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(IOUtils.readFullyAsByteArray(in)));
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (GeneralSecurityException e) {
                    throw new IOException("Failed to load public key", e);
                }
            }
            in.close();
        }
        return publicKey;
    }

    static void verifyJar(Path jarPath) throws IOException {
        PublicKey publickey = IntegrityChecker.getPublicKey();
        MessageDigest md = DigestUtils.getDigest("SHA-512");
        byte[] signature = null;
        TreeMap<String, byte[]> fileFingerprints = new TreeMap<String, byte[]>();
        try (ZipFile zip = new ZipFile(jarPath.toFile());){
            for (ZipEntry zipEntry : Lang.toIterable(zip.entries())) {
                String filename = zipEntry.getName();
                InputStream in = zip.getInputStream(zipEntry);
                try {
                    if (in == null) {
                        throw new IOException("entry is null");
                    }
                    if (SIGNATURE_FILE.equals(filename)) {
                        signature = IOUtils.readFullyAsByteArray(in);
                        continue;
                    }
                    md.reset();
                    fileFingerprints.put(filename, DigestUtils.digest(md, in));
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        if (signature == null) {
            throw new IOException("Signature is missing");
        }
        try {
            Signature verifier = Signature.getInstance("SHA512withRSA");
            verifier.initVerify(publickey);
            for (Map.Entry entry : fileFingerprints.entrySet()) {
                md.reset();
                verifier.update(md.digest(((String)entry.getKey()).getBytes(StandardCharsets.UTF_8)));
                verifier.update((byte[])entry.getValue());
            }
            if (!verifier.verify(signature)) {
                throw new IOException("Invalid signature: " + jarPath);
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to verify signature", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSelfVerified() {
        if (selfVerified != null) {
            return selfVerified;
        }
        Class<IntegrityChecker> clazz = IntegrityChecker.class;
        synchronized (IntegrityChecker.class) {
            if (selfVerified != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return selfVerified;
            }
            try {
                Path jarPath = JarUtils.thisJarPath();
                if (jarPath == null) {
                    throw new IOException("Failed to find current HMCL location");
                }
                IntegrityChecker.verifyJar(jarPath);
                Logger.LOG.info("Successfully verified current JAR");
                selfVerified = true;
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to verify myself, is the JAR corrupt?", e);
                selfVerified = false;
            }
            return selfVerified;
        }
    }

    public static boolean isOfficial() {
        return IntegrityChecker.isSelfVerified() || Metadata.GITHUB_SHA != null && Metadata.BUILD_CHANNEL.equals("nightly");
    }
}

