/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.versioning;

import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.jackhuang.hmcl.util.versioning.VersionRange;

public final class VersionNumber
implements Comparable<VersionNumber> {
    public static final VersionNumber ZERO = VersionNumber.asVersion("0");
    private static final int MAX_LONGITEM_LENGTH = 18;
    private final String value;
    private final ListItem items;
    private final String canonical;

    public static VersionNumber asVersion(String version) {
        Objects.requireNonNull(version);
        return new VersionNumber(version);
    }

    public static int compare(String version1, String version2) {
        return VersionNumber.asVersion(version1).compareTo(VersionNumber.asVersion(version2));
    }

    public static String normalize(String str) {
        return new VersionNumber(str).getCanonical();
    }

    public static boolean isIntVersionNumber(String version) {
        if (version.isEmpty()) {
            return false;
        }
        int idx = 0;
        boolean cont = true;
        do {
            int endIndex;
            int dotIndex;
            if ((dotIndex = version.indexOf(46, idx)) == idx || dotIndex == version.length() - 1) {
                return false;
            }
            if (dotIndex < 0) {
                cont = false;
                endIndex = version.length();
            } else {
                endIndex = dotIndex;
            }
            if (endIndex - idx > 9) {
                return false;
            }
            for (int i = idx; i < endIndex; ++i) {
                char ch = version.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                return false;
            }
            idx = endIndex + 1;
        } while (cont);
        return true;
    }

    public static VersionRange<VersionNumber> between(String minimum, String maximum) {
        return VersionRange.between(VersionNumber.asVersion(minimum), VersionNumber.asVersion(maximum));
    }

    public static VersionRange<VersionNumber> atLeast(String minimum) {
        return VersionRange.atLeast(VersionNumber.asVersion(minimum));
    }

    public static VersionRange<VersionNumber> atMost(String maximum) {
        return VersionRange.atMost(VersionNumber.asVersion(maximum));
    }

    private VersionNumber(String version) {
        this.value = version;
        ListItem list = this.items = new ListItem();
        ArrayDeque<ListItem> stack = new ArrayDeque<ListItem>();
        stack.push(list);
        boolean isDigit = false;
        int startIndex = 0;
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (c == '.') {
                if (i == startIndex) {
                    list.add(LongItem.ZERO);
                } else {
                    list.add(VersionNumber.parseItem(version.substring(startIndex, i)));
                }
                startIndex = i + 1;
                continue;
            }
            if ("!\"#$%&'()*+,-/:;<=>?@[\\]^_`{|}~".indexOf(c) != -1) {
                if (i == startIndex) {
                    list.add(LongItem.ZERO);
                } else {
                    list.add(VersionNumber.parseItem(version.substring(startIndex, i)));
                }
                startIndex = i + 1;
                ListItem listItem = list;
                list = new ListItem(c);
                listItem.add(list);
                stack.push(list);
                continue;
            }
            if (c >= '0' && c <= '9') {
                if (!isDigit && i > startIndex) {
                    list.add(VersionNumber.parseItem(version.substring(startIndex, i)));
                    startIndex = i;
                    ListItem listItem = list;
                    list = new ListItem();
                    listItem.add(list);
                    stack.push(list);
                }
                isDigit = true;
                continue;
            }
            if (isDigit && i > startIndex) {
                list.add(VersionNumber.parseItem(version.substring(startIndex, i)));
                startIndex = i;
                ListItem listItem = list;
                list = new ListItem();
                listItem.add(list);
                stack.push(list);
            }
            isDigit = false;
        }
        if (version.length() > startIndex) {
            list.add(VersionNumber.parseItem(version.substring(startIndex)));
        }
        while (!stack.isEmpty()) {
            list = (ListItem)stack.pop();
            list.normalize();
        }
        this.canonical = this.items.toString();
    }

    private VersionNumber(String version, ListItem items) {
        this.value = version;
        this.items = items;
        this.canonical = version;
    }

    private static Item parseItem(String buf) {
        int numberLength = 0;
        boolean leadingZero = true;
        for (int i = 0; i < buf.length(); ++i) {
            char ch = buf.charAt(i);
            if (ch >= '0' && ch <= '9') {
                if (ch != '0') {
                    leadingZero = false;
                }
                if (leadingZero) continue;
                ++numberLength;
                continue;
            }
            return new StringItem(buf);
        }
        if (numberLength == 0) {
            return LongItem.ZERO;
        }
        if (numberLength <= 18) {
            return new LongItem(Long.parseLong(buf));
        }
        return new BigIntegerItem(buf);
    }

    @Override
    public int compareTo(String o) {
        return this.compareTo(VersionNumber.asVersion(o));
    }

    @Override
    public int compareTo(VersionNumber o) {
        return this.items.compareTo(o.items);
    }

    public String toString() {
        return this.value;
    }

    public String getCanonical() {
        return this.canonical;
    }

    public boolean equals(Object o) {
        return o instanceof VersionNumber && this.canonical.equals(((VersionNumber)o).canonical);
    }

    public int hashCode() {
        return this.canonical.hashCode();
    }

    private static final class ListItem
    extends ArrayList<Item>
    implements Item {
        private final Character separator;

        ListItem() {
            this.separator = null;
        }

        ListItem(char separator) {
            this.separator = Character.valueOf(separator);
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public boolean isNull() {
            return this.size() == 0;
        }

        void normalize() {
            for (int i = this.size() - 1; i >= 0; --i) {
                Item lastItem = (Item)this.get(i);
                if (lastItem.isNull()) {
                    this.remove(i);
                    continue;
                }
                if (!(lastItem instanceof ListItem)) break;
            }
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                if (this.size() == 0) {
                    return 0;
                }
                Item first = (Item)this.get(0);
                return first.compareTo(null);
            }
            switch (item.getType()) {
                case 0: 
                case 1: {
                    return -1;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    Iterator left = this.iterator();
                    Iterator right = ((ListItem)item).iterator();
                    while (left.hasNext() || right.hasNext()) {
                        Item r;
                        Item l = left.hasNext() ? (Item)left.next() : null;
                        Item item2 = r = right.hasNext() ? (Item)right.next() : null;
                        int result = l == null ? (r == null ? 0 : -1 * r.compareTo(l)) : l.compareTo(r);
                        if (result == 0) continue;
                        return result;
                    }
                    return 0;
                }
            }
            throw new AssertionError((Object)("invalid item: " + item.getClass()));
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            if (this.separator != null) {
                buffer.append(this.separator.charValue());
            }
            int initLength = buffer.length();
            for (Item item : this) {
                if (buffer.length() > initLength && !(item instanceof ListItem)) {
                    buffer.append('.');
                }
                item.appendTo(buffer);
            }
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            this.appendTo(buffer);
            return buffer.toString();
        }
    }

    private static final class StringItem
    implements Item {
        private final String value;

        StringItem(String value) {
            this.value = value;
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public boolean isNull() {
            return this.value.isEmpty();
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return 1;
            }
            switch (item.getType()) {
                case 0: 
                case 1: {
                    return -1;
                }
                case 2: {
                    return this.value.compareTo(((StringItem)item).value);
                }
                case 3: {
                    return -1;
                }
            }
            throw new AssertionError((Object)("invalid item: " + item.getClass()));
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            buffer.append(this.value);
        }

        public String toString() {
            return this.value;
        }
    }

    private static final class BigIntegerItem
    implements Item {
        private final BigInteger value;

        BigIntegerItem(String str) {
            this.value = new BigInteger(str);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return 1;
            }
            switch (item.getType()) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return this.value.compareTo(((BigIntegerItem)item).value);
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 1;
                }
            }
            throw new AssertionError((Object)("invalid item: " + item.getClass()));
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            buffer.append(this.value);
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static final class LongItem
    implements Item {
        private final long value;
        public static final LongItem ZERO = new LongItem(0L);

        LongItem(long value) {
            this.value = value;
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public boolean isNull() {
            return this.value == 0L;
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return this.value == 0L ? 0 : 1;
            }
            switch (item.getType()) {
                case 0: {
                    long itemValue = ((LongItem)item).value;
                    return Long.compare(this.value, itemValue);
                }
                case 1: {
                    return -1;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 1;
                }
            }
            throw new AssertionError((Object)("invalid item: " + item.getClass()));
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            buffer.append(this.value);
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }

    private static interface Item {
        public static final int LONG_ITEM = 0;
        public static final int BIGINTEGER_ITEM = 1;
        public static final int STRING_ITEM = 2;
        public static final int LIST_ITEM = 3;

        public int compareTo(Item var1);

        public int getType();

        public boolean isNull();

        public void appendTo(StringBuilder var1);
    }
}

