/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth;

import java.util.UUID;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.AuthenticationException;

public abstract class OAuthAccount
extends Account {
    public abstract AuthInfo logInWhenCredentialsExpired() throws AuthenticationException;

    public static class WrongAccountException
    extends AuthenticationException {
        private final UUID expected;
        private final UUID actual;

        public WrongAccountException(UUID expected, UUID actual) {
            super("Expected account " + String.valueOf(expected) + ", but found " + String.valueOf(actual));
            this.expected = expected;
            this.actual = actual;
        }

        public UUID getExpected() {
            return this.expected;
        }

        public UUID getActual() {
            return this.actual;
        }
    }
}

