/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.modinfo;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jackhuang.hmcl.util.io.FileUtils;

@Immutable
public class PackMcMeta
implements Validation {
    @SerializedName(value="pack")
    private final PackInfo pack;

    public PackMcMeta() {
        this(new PackInfo());
    }

    public PackMcMeta(PackInfo packInfo) {
        this.pack = packInfo;
    }

    public PackInfo getPackInfo() {
        return this.pack;
    }

    @Override
    public void validate() throws JsonParseException {
        if (this.pack == null) {
            throw new JsonParseException("pack cannot be null");
        }
    }

    public static LocalModFile fromFile(ModManager modManager, Path modFile, FileSystem fs) throws IOException, JsonParseException {
        Path mcmod = fs.getPath("pack.mcmeta", new String[0]);
        if (Files.notExists(mcmod, new LinkOption[0])) {
            throw new IOException("File " + String.valueOf(modFile) + " is not a resource pack.");
        }
        PackMcMeta metadata = JsonUtils.fromNonNullJson(Files.readString(mcmod), PackMcMeta.class);
        return new LocalModFile(modManager, modManager.getLocalMod(FileUtils.getNameWithoutExtension(modFile), ModLoaderType.PACK), modFile, FileUtils.getNameWithoutExtension(modFile), metadata.pack.description, "", "", "", "", "");
    }

    @JsonAdapter(value=PackInfoDeserializer.class)
    public static class PackInfo {
        @SerializedName(value="pack_format")
        private final int packFormat;
        @SerializedName(value="description")
        private final LocalModFile.Description description;

        public PackInfo() {
            this(0, new LocalModFile.Description(Collections.emptyList()));
        }

        public PackInfo(int packFormat, LocalModFile.Description description) {
            this.packFormat = packFormat;
            this.description = description;
        }

        public int getPackFormat() {
            return this.packFormat;
        }

        public LocalModFile.Description getDescription() {
            return this.description;
        }
    }

    public static class PackInfoDeserializer
    implements JsonDeserializer<PackInfo> {
        private String parseText(JsonElement json) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                JsonPrimitive primitive = json.getAsJsonPrimitive();
                if (primitive.isBoolean()) {
                    return Boolean.toString(primitive.getAsBoolean());
                }
                if (primitive.isNumber()) {
                    return primitive.getAsNumber().toString();
                }
                if (primitive.isString()) {
                    return primitive.getAsString();
                }
                throw new JsonParseException("pack.mcmeta text not boolean nor number nor string???");
            }
            if (json.isJsonArray()) {
                JsonArray arr = json.getAsJsonArray();
                if (arr.size() == 0) {
                    return "";
                }
                return this.parseText(arr.get(0));
            }
            throw new JsonParseException("pack.mcmeta text should be a string, a boolean, a number or a list of raw JSON text components");
        }

        public LocalModFile.Description.Part deserialize(JsonElement json, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return new LocalModFile.Description.Part(this.parseText(json));
            }
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                String text = this.parseText(obj.get("text"));
                return new LocalModFile.Description.Part(text);
            }
            throw new JsonParseException("pack.mcmeta Raw JSON text should be string or an object");
        }

        @Override
        public PackInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ArrayList<LocalModFile.Description.Part> parts = new ArrayList<LocalModFile.Description.Part>();
            JsonObject packInfo = json.getAsJsonObject();
            int packFormat = packInfo.get("pack_format").getAsInt();
            JsonElement description = packInfo.get("description");
            if (description.isJsonPrimitive()) {
                parts.add(new LocalModFile.Description.Part(this.parseText(description)));
            } else if (description.isJsonArray()) {
                for (JsonElement element : description.getAsJsonArray()) {
                    JsonObject descriptionPart = element.getAsJsonObject();
                    parts.add(new LocalModFile.Description.Part(descriptionPart.get("text").getAsString(), descriptionPart.get("color").getAsString()));
                }
            } else {
                throw new JsonParseException("pack.mcmeta::pack::description should be String or array of text objects with text and color fields");
            }
            return new PackInfo(packFormat, new LocalModFile.Description(parts));
        }
    }
}

