/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.tree;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import kala.compress.archivers.zip.ZipArchiveEntry;
import kala.compress.archivers.zip.ZipArchiveReader;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.tree.ArchiveFileTree;
import org.jetbrains.annotations.NotNull;

public final class ZipFileTree
extends ArchiveFileTree<ZipArchiveReader, ZipArchiveEntry> {
    private final boolean closeReader;

    public ZipFileTree(ZipArchiveReader file) throws IOException {
        this(file, true);
    }

    public ZipFileTree(ZipArchiveReader file, boolean closeReader) throws IOException {
        super(file);
        this.closeReader = closeReader;
        try {
            for (ZipArchiveEntry zipArchiveEntry : file.getEntries()) {
                this.addEntry(zipArchiveEntry);
            }
        }
        catch (Throwable e) {
            if (closeReader) {
                IOUtils.closeQuietly(file, e);
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closeReader) {
            ((ZipArchiveReader)this.reader).close();
        }
    }

    @Override
    protected void copyAttributes(@NotNull ZipArchiveEntry source, @NotNull Path targetFile) throws IOException {
        BasicFileAttributeView targetView = Files.getFileAttributeView(targetFile, PosixFileAttributeView.class, new LinkOption[0]);
        if (targetView == null) {
            targetView = Files.getFileAttributeView(targetFile, BasicFileAttributeView.class, new LinkOption[0]);
        }
        if (targetView == null) {
            return;
        }
        targetView.setTimes(source.getLastModifiedTime(), source.getLastAccessTime(), source.getCreationTime());
        int unixMode = source.getUnixMode();
        if (unixMode != 0 && targetView instanceof PosixFileAttributeView) {
            PosixFileAttributeView posixView = (PosixFileAttributeView)targetView;
            EnumSet<PosixFilePermission> permissions = EnumSet.noneOf(PosixFilePermission.class);
            if ((unixMode & 0x100) != 0) {
                permissions.add(PosixFilePermission.OWNER_READ);
            }
            if ((unixMode & 0x80) != 0) {
                permissions.add(PosixFilePermission.OWNER_WRITE);
            }
            if ((unixMode & 0x40) != 0) {
                permissions.add(PosixFilePermission.OWNER_EXECUTE);
            }
            if ((unixMode & 0x20) != 0) {
                permissions.add(PosixFilePermission.GROUP_READ);
            }
            if ((unixMode & 0x10) != 0) {
                permissions.add(PosixFilePermission.GROUP_WRITE);
            }
            if ((unixMode & 8) != 0) {
                permissions.add(PosixFilePermission.GROUP_EXECUTE);
            }
            if ((unixMode & 4) != 0) {
                permissions.add(PosixFilePermission.OTHERS_READ);
            }
            if ((unixMode & 2) != 0) {
                permissions.add(PosixFilePermission.OTHERS_WRITE);
            }
            if ((unixMode & 1) != 0) {
                permissions.add(PosixFilePermission.OTHERS_EXECUTE);
            }
            posixView.setPermissions(permissions);
        }
    }

    @Override
    public InputStream getInputStream(ZipArchiveEntry entry) throws IOException {
        return ((ZipArchiveReader)this.getReader()).getInputStream(entry);
    }

    @Override
    public boolean isLink(ZipArchiveEntry entry) {
        return entry.isUnixSymlink();
    }

    @Override
    public String getLink(ZipArchiveEntry entry) throws IOException {
        return ((ZipArchiveReader)this.getReader()).getUnixSymlink(entry);
    }

    @Override
    public boolean isExecutable(ZipArchiveEntry entry) {
        return !entry.isDirectory() && !entry.isUnixSymlink() && (entry.getUnixMode() & 0x40) != 0;
    }
}

