/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class JFXTogglePane
extends StackPane {
    private Timeline toggleAnimation = null;
    private ObjectProperty<Control> toggleNode = new SimpleObjectProperty();
    private ObjectProperty<Node> contentNode = new SimpleObjectProperty();
    private DoubleProperty scalingFactor = new SimpleDoubleProperty(2.4);

    public JFXTogglePane() {
        this.clipProperty().addListener((o, oldVal, newVal) -> {
            if (newVal != null && this.getToggleNode() != null) {
                Control toggleNode = this.getToggleNode();
                newVal.layoutXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> JFXTogglePane.lambda$null$0((Region)toggleNode), (Observable[])new Observable[]{toggleNode.widthProperty(), toggleNode.layoutXProperty()}));
                newVal.layoutYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> JFXTogglePane.lambda$null$1((Region)toggleNode), (Observable[])new Observable[]{toggleNode.heightProperty(), toggleNode.layoutYProperty()}));
            }
        });
        this.widthProperty().addListener((o, oldVal, newVal) -> this.updateToggleAnimation());
        this.heightProperty().addListener((o, oldVal, newVal) -> this.updateToggleAnimation());
        this.toggleNode.addListener((o, oldVal, newVal) -> {
            if (newVal != null && this.getClip() != null) {
                this.getClip().layoutXProperty().unbind();
                this.getClip().layoutYProperty().unbind();
                this.getClip().layoutXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> newVal.getLayoutX() + newVal.getWidth() / 2.0, (Observable[])new Observable[]{newVal.widthProperty(), newVal.layoutXProperty()}));
                this.getClip().layoutYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> newVal.getLayoutY() + newVal.getHeight() / 2.0, (Observable[])new Observable[]{newVal.heightProperty(), newVal.layoutYProperty()}));
            }
            this.updateToggleAnimation();
            newVal.widthProperty().addListener((o1, oldVal1, newVal1) -> this.updateToggleAnimation());
            newVal.heightProperty().addListener((o1, oldVal1, newVal1) -> this.updateToggleAnimation());
            newVal.setOnMouseClicked(click -> this.togglePane());
        });
    }

    public void togglePane() {
        if (this.toggleAnimation == null) {
            this.updateToggleAnimation();
        }
        this.getClip().scaleXProperty().unbind();
        this.getClip().scaleYProperty().unbind();
        this.toggleAnimation.setRate(this.toggleAnimation.getRate() * -1.0);
        if (this.toggleAnimation.getCurrentTime().equals((Object)Duration.millis((double)0.0)) && this.toggleAnimation.getRate() == -1.0) {
            this.toggleAnimation.playFrom(Duration.millis((double)510.0));
        } else {
            this.toggleAnimation.play();
        }
    }

    private void updateToggleAnimation() {
        if (this.getContentNode() == null) {
            return;
        }
        double rateX = this.getWidth() / this.getClip().getLayoutBounds().getWidth();
        double rateY = this.getHeight() / this.getClip().getLayoutBounds().getHeight();
        double newRate = Math.max(rateX, rateY) * this.getScalingFactor();
        double animationRate = this.toggleAnimation == null ? -1.0 : this.toggleAnimation.getRate();
        this.toggleAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.getClip().scaleXProperty(), (Object)1, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.getClip().scaleYProperty(), (Object)1, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.getContentNode().opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)350.0), new KeyValue[]{new KeyValue((WritableValue)this.getClip().scaleXProperty(), (Object)newRate, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)350.0), new KeyValue[]{new KeyValue((WritableValue)this.getClip().scaleYProperty(), (Object)newRate, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)370.0), new KeyValue[]{new KeyValue((WritableValue)this.getContentNode().opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)510.0), new KeyValue[]{new KeyValue((WritableValue)this.getContentNode().opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})});
        this.toggleAnimation.setOnFinished(finish -> {
            if (this.toggleAnimation.getRate() == 1.0) {
                this.getClip().scaleXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                    double X = this.getWidth() / this.getClip().getLayoutBounds().getWidth();
                    double Y = this.getHeight() / this.getClip().getLayoutBounds().getHeight();
                    return Math.max(X, Y) * this.getScalingFactor();
                }, (Observable[])new Observable[]{this.widthProperty(), this.heightProperty()}));
                this.getClip().scaleYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                    double X = this.getWidth() / this.getClip().getLayoutBounds().getWidth();
                    double Y = this.getHeight() / this.getClip().getLayoutBounds().getHeight();
                    return Math.max(X, Y) * this.getScalingFactor();
                }, (Observable[])new Observable[]{this.widthProperty(), this.heightProperty()}));
            }
        });
        this.toggleAnimation.setRate(animationRate);
    }

    public final ObjectProperty<Control> toggleNodeProperty() {
        return this.toggleNode;
    }

    public final Control getToggleNode() {
        return (Control)this.toggleNodeProperty().get();
    }

    public final void setToggleNode(Control toggleNode) {
        this.toggleNodeProperty().set((Object)toggleNode);
    }

    public final ObjectProperty<Node> contentNodeProperty() {
        return this.contentNode;
    }

    public final Node getContentNode() {
        return (Node)this.contentNodeProperty().get();
    }

    public final void setContentNode(Node content) {
        this.contentNodeProperty().set((Object)content);
        content.setOpacity(0.0);
    }

    public final DoubleProperty scalingFactorProperty() {
        return this.scalingFactor;
    }

    public final double getScalingFactor() {
        return this.scalingFactorProperty().get();
    }

    public final void setScalingFactor(double scalingFactor) {
        this.scalingFactorProperty().set(scalingFactor);
    }

    private static /* synthetic */ Double lambda$null$1(Region toggleNode) throws Exception {
        return toggleNode.getLayoutY() + toggleNode.getHeight() / 2.0;
    }

    private static /* synthetic */ Double lambda$null$0(Region toggleNode) throws Exception {
        return toggleNode.getLayoutX() + toggleNode.getWidth() / 2.0;
    }
}

