/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.chardet.prober;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.glavo.chardet.DetectedCharset;
import org.glavo.chardet.prober.CharsetProber;
import org.glavo.chardet.prober.distributionanalysis.Big5DistributionAnalysis;
import org.glavo.chardet.prober.statemachine.Big5SMModel;
import org.glavo.chardet.prober.statemachine.CodingStateMachine;
import org.glavo.chardet.prober.statemachine.SMModel;

public final class Big5Prober
extends CharsetProber {
    private final CodingStateMachine codingSM = new CodingStateMachine(smModel);
    private CharsetProber.ProbingState state;
    private final Big5DistributionAnalysis distributionAnalyzer = new Big5DistributionAnalysis();
    private final ByteBuffer lastChar = ByteBuffer.allocate(2);
    private static final SMModel smModel = new Big5SMModel();

    public Big5Prober() {
        this.reset();
    }

    @Override
    public DetectedCharset getCharset() {
        return DetectedCharset.BIG5;
    }

    @Override
    public float getConfidence() {
        return this.distributionAnalyzer.getConfidence();
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(ByteBuffer buf, int offset, int length) {
        int maxPos = offset + length;
        for (int i = offset; i < maxPos; ++i) {
            int codingState = this.codingSM.nextState(buf.get(i));
            if (codingState == 1) {
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
            if (codingState == 2) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
                break;
            }
            if (codingState != 0) continue;
            int charLen = this.codingSM.getCurrentCharLen();
            if (i == offset) {
                this.lastChar.put(1, buf.get(offset));
                this.distributionAnalyzer.handleOneChar(this.lastChar, 0, charLen);
                continue;
            }
            this.distributionAnalyzer.handleOneChar(buf, i - 1, charLen);
        }
        this.lastChar.put(0, buf.get(maxPos - 1));
        if (this.state == CharsetProber.ProbingState.DETECTING && this.distributionAnalyzer.gotEnoughData() && this.getConfidence() > 0.95f) {
            this.state = CharsetProber.ProbingState.FOUND_IT;
        }
        return this.state;
    }

    @Override
    public final void reset() {
        this.codingSM.reset();
        this.state = CharsetProber.ProbingState.DETECTING;
        this.distributionAnalyzer.reset();
        Arrays.fill(this.lastChar.array(), (byte)0);
    }

    @Override
    public void setOption() {
    }
}

