/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.cleanroom;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.UnsupportedInstallationException;
import org.jackhuang.hmcl.download.VersionMismatchException;
import org.jackhuang.hmcl.download.cleanroom.CleanroomRemoteVersion;
import org.jackhuang.hmcl.download.forge.ForgeNewInstallProfile;
import org.jackhuang.hmcl.download.forge.ForgeNewInstallTask;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;

public final class CleanroomInstallTask
extends Task<Version> {
    private final DefaultDependencyManager dependencyManager;
    private final Version version;
    private final CleanroomRemoteVersion remote;
    private Path installer;
    private FileDownloadTask dependent;
    private Task<Version> task;
    private String selfVersion;

    public CleanroomInstallTask(DefaultDependencyManager dependencyManager, Version version, CleanroomRemoteVersion remoteVersion) {
        this.dependencyManager = dependencyManager;
        this.version = version;
        this.remote = remoteVersion;
        this.setSignificance(Task.TaskSignificance.MODERATE);
    }

    public CleanroomInstallTask(DefaultDependencyManager dependencyManager, Version version, String selfVersion, Path installer) {
        this.dependencyManager = dependencyManager;
        this.version = version;
        this.selfVersion = selfVersion;
        this.remote = null;
        this.installer = installer;
        this.setSignificance(Task.TaskSignificance.MODERATE);
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void preExecute() throws Exception {
        if (this.installer == null) {
            this.installer = Files.createTempFile("cleanroom-installer", ".jar", new FileAttribute[0]);
            this.dependent = new FileDownloadTask(this.dependencyManager.getDownloadProvider().injectURLsWithCandidates(this.remote.getUrls()), this.installer, null);
            this.dependent.setCacheRepository(this.dependencyManager.getCacheRepository());
            this.dependent.setCaching(true);
            this.dependent.addIntegrityCheckHandler(FileDownloadTask.ZIP_INTEGRITY_CHECK_HANDLER);
        }
    }

    @Override
    public boolean doPostExecute() {
        return true;
    }

    @Override
    public void postExecute() throws Exception {
        Files.deleteIfExists(this.installer);
        this.setResult(this.task.getResult());
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return this.dependent == null ? Collections.emptySet() : Collections.singleton(this.dependent);
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return Collections.singleton(this.task);
    }

    @Override
    public void execute() throws IOException, VersionMismatchException, UnsupportedInstallationException {
        this.task = this.selfVersion == null ? new ForgeNewInstallTask(this.dependencyManager, this.version, this.remote.getSelfVersion(), this.installer).thenApplyAsync(version -> version.setId(LibraryAnalyzer.LibraryType.CLEANROOM.getPatchId())) : new ForgeNewInstallTask(this.dependencyManager, this.version, this.selfVersion, this.installer).thenApplyAsync(version -> version.setId(LibraryAnalyzer.LibraryType.CLEANROOM.getPatchId()));
    }

    public static Task<Version> install(DefaultDependencyManager dependencyManager, Version version, Path installer) throws IOException, VersionMismatchException {
        Optional<String> gameVersion = dependencyManager.getGameRepository().getGameVersion(version);
        if (gameVersion.isEmpty()) {
            throw new IOException();
        }
        try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(installer);){
            String installProfileText = Files.readString(fs.getPath("install_profile.json", new String[0]));
            Map installProfile = JsonUtils.fromNonNullJson(installProfileText, Map.class);
            if (LibraryAnalyzer.LibraryType.CLEANROOM.getPatchId().equals(installProfile.get("profile"))) {
                ForgeNewInstallProfile profile = JsonUtils.fromNonNullJson(installProfileText, ForgeNewInstallProfile.class);
                if (!gameVersion.get().equals(profile.getMinecraft())) {
                    throw new VersionMismatchException(profile.getMinecraft(), gameVersion.get());
                }
                CleanroomInstallTask cleanroomInstallTask = new CleanroomInstallTask(dependencyManager, version, CleanroomInstallTask.modifyVersion(profile.getVersion()), installer);
                return cleanroomInstallTask;
            }
            throw new IOException();
        }
    }

    private static String modifyVersion(String version) {
        return version.replace("cleanroom-", "");
    }
}

