/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.modinfo;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public record PackMcMeta(@SerializedName(value="pack") PackInfo pack) implements Validation
{
    @Override
    public void validate() throws JsonParseException {
        if (this.pack == null) {
            throw new JsonParseException("pack cannot be null");
        }
    }

    public static LocalModFile fromFile(ModManager modManager, Path modFile, FileSystem fs) throws IOException, JsonParseException {
        Path mcmod = fs.getPath("pack.mcmeta", new String[0]);
        if (Files.notExists(mcmod, new LinkOption[0])) {
            throw new IOException("File " + String.valueOf(modFile) + " is not a resource pack.");
        }
        PackMcMeta metadata = JsonUtils.fromNonNullJson(Files.readString(mcmod), PackMcMeta.class);
        return new LocalModFile(modManager, modManager.getLocalMod(FileUtils.getNameWithoutExtension(modFile), ModLoaderType.PACK), modFile, FileUtils.getNameWithoutExtension(modFile), metadata.pack.description, "", "", "", "", "");
    }

    @JsonAdapter(value=PackInfoDeserializer.class)
    public record PackInfo(@SerializedName(value="pack_format") int packFormat, @SerializedName(value="min_format") PackVersion minPackVersion, @SerializedName(value="max_format") PackVersion maxPackVersion, @SerializedName(value="description") LocalModFile.Description description) {
        public PackVersion getEffectiveMinVersion() {
            return !this.minPackVersion.isUnspecified() ? this.minPackVersion : new PackVersion(this.packFormat, 0);
        }

        public PackVersion getEffectiveMaxVersion() {
            return !this.maxPackVersion.isUnspecified() ? this.maxPackVersion : new PackVersion(this.packFormat, 0);
        }
    }

    public static final class PackInfoDeserializer
    implements JsonDeserializer<PackInfo> {
        private List<LocalModFile.Description.Part> pairToPart(List<Pair<String, String>> lists, String color) {
            ArrayList<LocalModFile.Description.Part> parts = new ArrayList<LocalModFile.Description.Part>();
            for (Pair<String, String> list : lists) {
                parts.add(new LocalModFile.Description.Part(list.getKey(), list.getValue().isEmpty() ? color : list.getValue()));
            }
            return parts;
        }

        private void parseComponent(JsonElement element, List<LocalModFile.Description.Part> parts, String parentColor) throws JsonParseException {
            if (parentColor == null) {
                parentColor = "";
            }
            String color = parentColor;
            if (element instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)element;
                parts.addAll(this.pairToPart(StringUtils.parseMinecraftColorCodes(primitive.getAsString()), color));
            } else if (element instanceof JsonObject) {
                JsonPrimitive primitive;
                JsonObject jsonObj = (JsonObject)element;
                JsonElement jsonElement = jsonObj.get("color");
                if (jsonElement instanceof JsonPrimitive) {
                    primitive = (JsonPrimitive)jsonElement;
                    color = primitive.getAsString();
                }
                if ((jsonElement = jsonObj.get("text")) instanceof JsonPrimitive) {
                    primitive = (JsonPrimitive)jsonElement;
                    parts.addAll(this.pairToPart(StringUtils.parseMinecraftColorCodes(primitive.getAsString()), color));
                }
                if ((jsonElement = jsonObj.get("extra")) instanceof JsonArray) {
                    JsonArray jsonArray = (JsonArray)jsonElement;
                    this.parseComponent(jsonArray, parts, color);
                }
            } else if (element instanceof JsonArray) {
                JsonObject jsonObj;
                JsonElement jsonElement;
                JsonArray jsonArray = (JsonArray)element;
                if (!jsonArray.isEmpty() && (jsonElement = jsonArray.get(0)) instanceof JsonObject && (jsonElement = (jsonObj = (JsonObject)jsonElement).get("color")) instanceof JsonPrimitive) {
                    JsonPrimitive primitive = (JsonPrimitive)jsonElement;
                    color = primitive.getAsString();
                }
                for (JsonElement childElement : jsonArray) {
                    this.parseComponent(childElement, parts, color);
                }
            } else {
                Logger.LOG.warning("Skipping unsupported element in description. Expected a string, object, or array, but got type " + element.getClass().getSimpleName() + ". Value: " + String.valueOf(element));
            }
        }

        private List<LocalModFile.Description.Part> parseDescription(JsonElement json) throws JsonParseException {
            ArrayList<LocalModFile.Description.Part> parts = new ArrayList<LocalModFile.Description.Part>();
            if (json == null || json.isJsonNull()) {
                return parts;
            }
            try {
                this.parseComponent(json, parts, "");
            }
            catch (JsonParseException | IllegalStateException e) {
                parts.clear();
                Logger.LOG.warning("An unexpected error occurred while parsing a description component. The description may be incomplete.", e);
            }
            return parts;
        }

        @Override
        public PackInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonPrimitive primitive;
            JsonObject packInfo = json.getAsJsonObject();
            JsonElement jsonElement = packInfo.get("pack_format");
            int packFormat = jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isNumber() ? primitive.getAsInt() : 0;
            PackVersion minVersion = PackVersion.fromJson(packInfo.get("min_format"));
            PackVersion maxVersion = PackVersion.fromJson(packInfo.get("max_format"));
            List<LocalModFile.Description.Part> parts = this.parseDescription(packInfo.get("description"));
            return new PackInfo(packFormat, minVersion, maxVersion, new LocalModFile.Description(parts));
        }
    }

    public record PackVersion(int majorVersion, int minorVersion) implements Comparable<PackVersion>
    {
        public static final PackVersion UNSPECIFIED = new PackVersion(0, 0);

        @Override
        public String toString() {
            return this.minorVersion != 0 ? this.majorVersion + "." + this.minorVersion : String.valueOf(this.majorVersion);
        }

        @Override
        public int compareTo(PackVersion other) {
            int majorCompare = Integer.compare(this.majorVersion, other.majorVersion);
            if (majorCompare != 0) {
                return majorCompare;
            }
            return Integer.compare(this.minorVersion, other.minorVersion);
        }

        public boolean isUnspecified() {
            return this.equals(UNSPECIFIED);
        }

        public static PackVersion fromJson(JsonElement element) throws JsonParseException {
            if (element == null || element.isJsonNull()) {
                return UNSPECIFIED;
            }
            try {
                JsonPrimitive primitive;
                if (element instanceof JsonPrimitive && (primitive = (JsonPrimitive)element).isNumber()) {
                    return new PackVersion(element.getAsInt(), 0);
                }
                if (element instanceof JsonArray) {
                    JsonArray jsonArray = (JsonArray)element;
                    if (jsonArray.size() == 1 && jsonArray.get(0) instanceof JsonPrimitive) {
                        return new PackVersion(jsonArray.get(0).getAsInt(), 0);
                    }
                    if (jsonArray.size() == 2 && jsonArray.get(0) instanceof JsonPrimitive && jsonArray.get(1) instanceof JsonPrimitive) {
                        return new PackVersion(jsonArray.get(0).getAsInt(), jsonArray.get(1).getAsInt());
                    }
                    Logger.LOG.warning("Datapack version array must have 1 or 2 elements, but got " + jsonArray.size());
                }
            }
            catch (NumberFormatException e) {
                Logger.LOG.warning("Failed to parse datapack version component as a number. Value: " + String.valueOf(element), e);
            }
            return UNSPECIFIED;
        }
    }
}

