/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl;

import java.awt.Image;
import java.awt.Taskbar;
import java.awt.Toolkit;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CancellationException;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.java.JavaRuntime;
import org.jackhuang.hmcl.util.FileSaver;
import org.jackhuang.hmcl.util.SelfDependencyPatcher;
import org.jackhuang.hmcl.util.SwingUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class EntryPoint {
    private EntryPoint() {
    }

    public static void main(String[] args) {
        System.getProperties().putIfAbsent("java.net.useSystemProxies", "true");
        System.getProperties().putIfAbsent("javafx.autoproxy.disable", "true");
        System.getProperties().putIfAbsent("http.agent", "HMCL/" + Metadata.VERSION);
        EntryPoint.createHMCLDirectories();
        Logger.LOG.start(Metadata.HMCL_CURRENT_DIRECTORY.resolve("logs"));
        EntryPoint.setupJavaFXVMOptions();
        if (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS) {
            System.getProperties().putIfAbsent("apple.awt.application.appearance", "system");
            if (!EntryPoint.isInsideMacAppBundle()) {
                EntryPoint.initIcon();
            }
        }
        EntryPoint.checkJavaFX();
        EntryPoint.verifyJavaFX();
        EntryPoint.addEnableNativeAccess();
        EntryPoint.enableUnsafeMemoryAccess();
        Launcher.main(args);
    }

    public static void exit(int exitCode) {
        FileSaver.shutdown();
        Logger.LOG.shutdown();
        System.exit(exitCode);
    }

    private static void setupJavaFXVMOptions() {
        String uiScale;
        String animationFrameRate;
        if ("true".equalsIgnoreCase(System.getenv("HMCL_FORCE_GPU"))) {
            Logger.LOG.info("HMCL_FORCE_GPU: true");
            System.getProperties().putIfAbsent("prism.forceGPU", "true");
        }
        if ((animationFrameRate = System.getenv("HMCL_ANIMATION_FRAME_RATE")) != null) {
            Logger.LOG.info("HMCL_ANIMATION_FRAME_RATE: " + animationFrameRate);
            try {
                if (Integer.parseInt(animationFrameRate) <= 0) {
                    throw new NumberFormatException(animationFrameRate);
                }
                System.getProperties().putIfAbsent("javafx.animation.pulse", animationFrameRate);
            }
            catch (NumberFormatException e) {
                Logger.LOG.warning("Invalid animation frame rate: " + animationFrameRate);
            }
        }
        if ((uiScale = System.getProperty("hmcl.uiScale", System.getenv("HMCL_UI_SCALE"))) != null) {
            uiScale = uiScale.trim();
            Logger.LOG.info("HMCL_UI_SCALE: " + uiScale);
            try {
                float upperBound;
                float lowerBound;
                float scaleValue = uiScale.endsWith("%") ? (float)Integer.parseInt(uiScale.substring(0, uiScale.length() - 1)) / 100.0f : (uiScale.endsWith("dpi") || uiScale.endsWith("DPI") ? (float)Integer.parseInt(uiScale.substring(0, uiScale.length() - 3)) / 96.0f : Float.parseFloat(uiScale));
                if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                    lowerBound = 0.25f;
                    upperBound = 4.0f;
                } else {
                    lowerBound = 0.01f;
                    upperBound = 10.0f;
                }
                if (scaleValue >= lowerBound && scaleValue <= upperBound) {
                    if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                        System.getProperties().putIfAbsent("glass.win.uiScale", uiScale);
                    } else if (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS) {
                        Logger.LOG.warning("macOS does not support setting UI scale, so it will be ignored");
                    } else {
                        System.getProperties().putIfAbsent("glass.gtk.uiScale", uiScale);
                    }
                } else {
                    Logger.LOG.warning("UI scale out of range: " + uiScale);
                }
            }
            catch (Throwable e) {
                Logger.LOG.warning("Invalid UI scale: " + uiScale);
            }
        }
    }

    private static void createHMCLDirectories() {
        if (!Files.isDirectory(Metadata.HMCL_CURRENT_DIRECTORY, new LinkOption[0])) {
            try {
                Files.createDirectories(Metadata.HMCL_CURRENT_DIRECTORY, new FileAttribute[0]);
                if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                    try {
                        Files.setAttribute(Metadata.HMCL_CURRENT_DIRECTORY, "dos:hidden", true, new LinkOption[0]);
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Failed to set hidden attribute of " + String.valueOf(Metadata.HMCL_CURRENT_DIRECTORY), e);
                    }
                }
            }
            catch (IOException e) {
                System.err.println("Failed to create HMCL directory: " + String.valueOf(Metadata.HMCL_CURRENT_DIRECTORY));
                e.printStackTrace(System.err);
                EntryPoint.showErrorAndExit(I18n.i18n("fatal.create_hmcl_current_directory_failure", Metadata.HMCL_CURRENT_DIRECTORY));
            }
        }
        if (!Files.isDirectory(Metadata.HMCL_GLOBAL_DIRECTORY, new LinkOption[0])) {
            try {
                Files.createDirectories(Metadata.HMCL_GLOBAL_DIRECTORY, new FileAttribute[0]);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to create HMCL global directory " + String.valueOf(Metadata.HMCL_GLOBAL_DIRECTORY), e);
            }
        }
    }

    private static boolean isInsideMacAppBundle() {
        Path thisJar = JarUtils.thisJarPath();
        if (thisJar == null) {
            return false;
        }
        for (Path current = thisJar.getParent(); current != null && current.getParent() != null; current = current.getParent()) {
            if (!"Contents".equals(FileUtils.getName(current)) || !FileUtils.getName(current.getParent()).endsWith(".app") || !Files.exists(current.resolve("Info.plist"), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    private static void initIcon() {
        try {
            if (Taskbar.isTaskbarSupported()) {
                Image image = Toolkit.getDefaultToolkit().getImage(EntryPoint.class.getResource("/assets/img/icon-mac.png"));
                Taskbar.getTaskbar().setIconImage(image);
            }
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to set application icon", e);
        }
    }

    private static void checkJavaFX() {
        try {
            SelfDependencyPatcher.patch();
        }
        catch (SelfDependencyPatcher.PatchException e) {
            Logger.LOG.error("Unable to patch JVM", e);
            EntryPoint.showErrorAndExit(I18n.i18n("fatal.javafx.missing"));
        }
        catch (SelfDependencyPatcher.IncompatibleVersionException e) {
            Logger.LOG.error("Unable to patch JVM", e);
            EntryPoint.showErrorAndExit(I18n.i18n("fatal.javafx.incompatible"));
        }
        catch (CancellationException e) {
            Logger.LOG.error("User cancels downloading JavaFX", e);
            EntryPoint.exit(0);
        }
    }

    private static void verifyJavaFX() {
        try {
            Class.forName("javafx.beans.binding.Binding");
            Class.forName("javafx.stage.Stage");
            Class.forName("javafx.scene.control.Skin");
        }
        catch (Exception e) {
            Logger.LOG.warning("JavaFX is incomplete or not found", e);
            EntryPoint.showErrorAndExit(I18n.i18n("fatal.javafx.incomplete"));
        }
    }

    private static void addEnableNativeAccess() {
        if (JavaRuntime.CURRENT_VERSION > 21) {
            try {
                Module module = Class.forName("javafx.stage.Stage").getModule();
                if (module.isNamed()) {
                    try {
                        MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(Module.class, MethodHandles.lookup());
                        MethodHandle implAddEnableNativeAccess = lookup.findVirtual(Module.class, "implAddEnableNativeAccess", MethodType.methodType(Module.class));
                        Module module2 = implAddEnableNativeAccess.invokeExact(module);
                    }
                    catch (Throwable e) {
                        e.printStackTrace(System.err);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                Logger.LOG.error("Failed to add enable native access for JavaFX", e);
                EntryPoint.showErrorAndExit(I18n.i18n("fatal.javafx.incomplete"));
            }
        }
    }

    private static void enableUnsafeMemoryAccess() {
        if (JavaRuntime.CURRENT_VERSION == 24 || JavaRuntime.CURRENT_VERSION == 25) {
            try {
                Class<?> clazz = Class.forName("sun.misc.Unsafe");
                boolean bl = MethodHandles.privateLookupIn(clazz, MethodHandles.lookup()).findStatic(clazz, "trySetMemoryAccessWarned", MethodType.methodType(Boolean.TYPE)).invokeExact();
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to enable unsafe memory access", e);
            }
        }
    }

    private static void showErrorAndExit(String message) {
        SwingUtils.showErrorDialog(message);
        EntryPoint.exit(1);
    }
}

