/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.LineButton;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public class LineFileChooserButton
extends LineButton {
    private static final String DEFAULT_STYLE_CLASS = "line-file-select-button";
    private final StringProperty location = new StringPropertyBase(){

        public Object getBean() {
            return LineFileChooserButton.this;
        }

        public String getName() {
            return "location";
        }

        protected void invalidated() {
            LineFileChooserButton.this.setTrailingText(this.get());
        }
    };
    private final StringProperty fileChooserTitle = new SimpleStringProperty((Object)this, "fileChooserTitle");
    private ObjectProperty<Type> type;
    private ObjectProperty<String> initialFileName;
    private ObservableList<FileChooser.ExtensionFilter> extensionFilters;
    private BooleanProperty convertToRelativePath;

    public LineFileChooserButton() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setTrailingIcon(SVG.EDIT);
    }

    private String processPath(Path path) {
        if (this.isConvertToRelativePath() && path.isAbsolute()) {
            try {
                return Metadata.CURRENT_DIRECTORY.relativize(path).normalize().toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return path.normalize().toString();
    }

    @Override
    public void fire() {
        Path path;
        Type type;
        super.fire();
        Stage owner = Controllers.getStage();
        String windowTitle = this.getFileChooserTitle();
        Path initialDirectory = null;
        if (this.getLocation() != null) {
            try {
                Path file = FileUtils.toAbsolute(Path.of(this.getLocation(), new String[0]));
                if (Files.exists(file, new LinkOption[0])) {
                    if (Files.isRegularFile(file, new LinkOption[0])) {
                        initialDirectory = file.getParent();
                    } else if (Files.isDirectory(file, new LinkOption[0])) {
                        initialDirectory = file;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                Logger.LOG.warning("Failed to resolve path: " + this.getLocation());
            }
        }
        if ((type = this.getType()) == Type.OPEN_DIRECTORY) {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            if (windowTitle != null) {
                directoryChooser.setTitle(windowTitle);
            }
            if (initialDirectory != null) {
                directoryChooser.setInitialDirectory(initialDirectory.toFile());
            }
            path = FileUtils.toPath(directoryChooser.showDialog((Window)owner));
        } else {
            FileChooser fileChooser = new FileChooser();
            if (windowTitle != null) {
                fileChooser.setTitle(windowTitle);
            }
            if (initialDirectory != null) {
                fileChooser.setInitialDirectory(initialDirectory.toFile());
            }
            if (this.extensionFilters != null) {
                fileChooser.getExtensionFilters().setAll(this.extensionFilters);
            }
            fileChooser.setInitialFileName(this.getInitialFileName());
            path = FileUtils.toPath(switch (type.ordinal()) {
                case 0 -> fileChooser.showOpenDialog((Window)owner);
                case 2 -> fileChooser.showSaveDialog((Window)owner);
                default -> throw new AssertionError((Object)("Unknown Type: " + String.valueOf((Object)type)));
            });
        }
        if (path != null) {
            this.setLocation(this.processPath(path));
        }
    }

    public StringProperty locationProperty() {
        return this.location;
    }

    public String getLocation() {
        return (String)this.locationProperty().get();
    }

    public void setLocation(String location) {
        this.locationProperty().set((Object)location);
    }

    public StringProperty fileChooserTitleProperty() {
        return this.fileChooserTitle;
    }

    public String getFileChooserTitle() {
        return (String)this.fileChooserTitleProperty().get();
    }

    public void setFileChooserTitle(String fileChooserTitle) {
        this.fileChooserTitleProperty().set((Object)fileChooserTitle);
    }

    public ObjectProperty<Type> typeProperty() {
        if (this.type == null) {
            this.type = new SimpleObjectProperty((Object)this, "type", (Object)Type.OPEN_FILE);
        }
        return this.type;
    }

    public Type getType() {
        return this.type != null ? (Type)((Object)this.type.get()) : Type.OPEN_FILE;
    }

    public void setType(Type type) {
        this.typeProperty().set((Object)type);
    }

    public final ObjectProperty<String> initialFileNameProperty() {
        if (this.initialFileName == null) {
            this.initialFileName = new SimpleObjectProperty((Object)this, "initialFileName");
        }
        return this.initialFileName;
    }

    public final String getInitialFileName() {
        return this.initialFileName != null ? (String)this.initialFileName.get() : null;
    }

    public final void setInitialFileName(String value) {
        this.initialFileNameProperty().set((Object)value);
    }

    public ObservableList<FileChooser.ExtensionFilter> getExtensionFilters() {
        if (this.extensionFilters == null) {
            this.extensionFilters = FXCollections.observableArrayList();
        }
        return this.extensionFilters;
    }

    public BooleanProperty convertToRelativePathProperty() {
        if (this.convertToRelativePath == null) {
            this.convertToRelativePath = new BooleanPropertyBase(false){

                public Object getBean() {
                    return LineFileChooserButton.this;
                }

                public String getName() {
                    return "convertToRelativePath";
                }

                protected void invalidated() {
                    String location = LineFileChooserButton.this.getLocation();
                    if (location == null) {
                        return;
                    }
                    try {
                        LineFileChooserButton.this.setLocation(LineFileChooserButton.this.processPath(FileUtils.toAbsolute(Path.of(LineFileChooserButton.this.getLocation(), new String[0]))));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            };
        }
        return this.convertToRelativePath;
    }

    public boolean isConvertToRelativePath() {
        return this.convertToRelativePath != null && this.convertToRelativePath.get();
    }

    public void setConvertToRelativePath(boolean convertToRelativePath) {
        this.convertToRelativePathProperty().set(convertToRelativePath);
    }

    public static enum Type {
        OPEN_FILE,
        OPEN_DIRECTORY,
        SAVE_FILE;

    }
}

