/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.LineButton;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.HttpRequest;

public class HelpPage
extends SpinnerPane {
    private final VBox content = new VBox();

    public HelpPage() {
        this.content.setPadding(new Insets(10.0));
        this.content.setSpacing(10.0);
        this.content.setFillWidth(true);
        ScrollPane scrollPane = new ScrollPane((Node)this.content);
        scrollPane.setFitToWidth(true);
        FXUtils.smoothScrolling(scrollPane);
        this.setContent((Node)scrollPane);
        LineButton docPane = LineButton.createExternalLinkButton("https://docs.hmcl.net");
        docPane.setLargeTitle(true);
        docPane.setTitle(I18n.i18n("help.doc"));
        docPane.setSubtitle(I18n.i18n("help.detail"));
        ComponentList doc = new ComponentList();
        doc.getContent().setAll((Object[])new Node[]{docPane});
        this.content.getChildren().add((Object)doc);
        this.loadHelp();
    }

    private void loadHelp() {
        this.showSpinner();
        Task.supplyAsync(() -> HttpRequest.GET("https://docs.hmcl.net/index.json").getJson(JsonUtils.listTypeOf(HelpCategory.class))).thenAcceptAsync(Schedulers.javafx(), helpCategories -> {
            for (HelpCategory category : helpCategories) {
                ComponentList categoryPane = new ComponentList();
                for (Help help : category.items()) {
                    LineButton item = LineButton.createExternalLinkButton(help.url());
                    item.setLargeTitle(true);
                    item.setTitle(help.title());
                    item.setSubtitle(help.subtitle());
                    categoryPane.getContent().add((Object)item);
                }
                this.content.getChildren().add((Object)ComponentList.createComponentListTitle(category.title()));
                this.content.getChildren().add((Object)categoryPane);
            }
            this.hideSpinner();
        }).start();
    }

    private record HelpCategory(@SerializedName(value="title") String title, @SerializedName(value="items") List<Help> items) {
    }

    private record Help(@SerializedName(value="title") String title, @SerializedName(value="subtitle") String subtitle, @SerializedName(value="url") String url) {
    }
}

