/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.terracotta;

import com.jfoenix.controls.JFXProgressBar;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;
import org.jackhuang.hmcl.game.LauncherHelper;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.terracotta.TerracottaManager;
import org.jackhuang.hmcl.terracotta.TerracottaMetadata;
import org.jackhuang.hmcl.terracotta.TerracottaState;
import org.jackhuang.hmcl.terracotta.profile.TerracottaProfile;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.ComponentSublist;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.ui.construct.LineButton;
import org.jackhuang.hmcl.ui.construct.LinePane;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.i18n.LocaleUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.Zipper;
import org.jackhuang.hmcl.util.logging.Logger;

public class TerracottaControllerPage
extends StackPane {
    private static final String FEEDBACK_TIP = "terracotta-feedback";
    private static final ObjectProperty<TerracottaState> UI_STATE = new SimpleObjectProperty();
    private final WeakListenerHolder holder = new WeakListenerHolder();
    private static final double ICON_SIZE = 28.0;

    public TerracottaControllerPage() {
        this.holder.add(FXUtils.observeWeak(() -> TerracottaManager.switchDaemon(this.getScene() != null && Controllers.getStage().isFocused()), new Observable[]{this.sceneProperty(), Controllers.getStage().focusedProperty()}));
        TransitionPane transition = new TransitionPane();
        SimpleObjectProperty statusProperty = new SimpleObjectProperty();
        SimpleDoubleProperty progressProperty = new SimpleDoubleProperty();
        ObservableList nodesProperty = FXCollections.observableList(new ArrayList());
        FXUtils.applyDragListener((Node)this, path -> {
            TerracottaState.Fatal fatal;
            TerracottaState.Preparing preparing;
            TerracottaState state = (TerracottaState)UI_STATE.get();
            if (state instanceof TerracottaState.Uninitialized || state instanceof TerracottaState.Preparing && (preparing = (TerracottaState.Preparing)state).hasInstallFence() || state instanceof TerracottaState.Fatal && (fatal = (TerracottaState.Fatal)state).isRecoverable()) {
                return Files.isReadable(path) && FileUtils.getName(path).toLowerCase(Locale.ROOT).endsWith(".tar.gz");
            }
            return false;
        }, files -> {
            Path path = (Path)files.get(0);
            if (TerracottaManager.isInvalidBundle(path)) {
                Controllers.dialog(I18n.i18n("terracotta.from_local.file_name_mismatch", TerracottaMetadata.PACKAGE_NAME, FileUtils.getName(path)), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
                return;
            }
            TerracottaState.Preparing next = TerracottaManager.install(path);
            if (next != null) {
                UI_STATE.set((Object)next);
            }
        });
        ChangeListener listener = (arg_0, arg_1, arg_2) -> this.lambda$new$29((DoubleProperty)progressProperty, (ObjectProperty)statusProperty, nodesProperty, transition, arg_0, arg_1, arg_2);
        listener.changed(UI_STATE, null, (Object)((TerracottaState)UI_STATE.get()));
        this.holder.add(listener);
        UI_STATE.addListener((ChangeListener)new WeakChangeListener(listener));
        VBox content = new VBox(10.0);
        content.getChildren().add((Object)ComponentList.createComponentListTitle(I18n.i18n("terracotta.status")));
        if (!LocaleUtils.IS_CHINA_MAINLAND) {
            HintPane hintPane = new HintPane(MessageDialogPane.MessageType.WARNING);
            hintPane.setText(I18n.i18n("terracotta.unsupported.region"));
            content.getChildren().add((Object)hintPane);
        }
        content.getChildren().add((Object)transition);
        content.setPadding(new Insets(10.0));
        content.setFillWidth(true);
        ScrollPane scrollPane = new ScrollPane((Node)content);
        FXUtils.smoothScrolling(scrollPane);
        scrollPane.setFitToWidth(true);
        this.getChildren().setAll((Object[])new Node[]{scrollPane});
    }

    private ComponentSublist getThirdPartyDownloadNodes() {
        ComponentSublist locals = new ComponentSublist();
        LinePane header = new LinePane();
        header.setLargeTitle(true);
        header.setMinHeight(-1.0);
        header.setMouseTransparent(true);
        header.setLeading(FXUtils.newBuiltinImage("/assets/img/terracotta.png"));
        header.setTitle(I18n.i18n("terracotta.from_local.title"));
        header.setSubtitle(I18n.i18n("terracotta.from_local.desc"));
        locals.setHeaderLeft((Node)header);
        for (TerracottaMetadata.Link link : TerracottaMetadata.PACKAGE_LINKS) {
            LineButton item = new LineButton();
            item.setTrailingIcon(SVG.OPEN_IN_NEW);
            item.setTitle(link.description().getText(I18n.getLocale().getCandidateLocales()));
            item.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> Controllers.dialog(I18n.i18n("terracotta.from_local.guide", TerracottaMetadata.PACKAGE_NAME), I18n.i18n("message.info"), MessageDialogPane.MessageType.INFO, () -> FXUtils.openLink(link.link()))));
            locals.getContent().add((Object)item);
        }
        return locals;
    }

    private void copyCode(String code) {
        FXUtils.copyText(code, I18n.i18n("terracotta.status.host_ok.code.copy.toast"));
    }

    private static LineButton createLargeTitleLineButton() {
        LineButton lineButton = new LineButton();
        lineButton.setLargeTitle(true);
        return lineButton;
    }

    private /* synthetic */ void lambda$new$29(DoubleProperty progressProperty, ObjectProperty statusProperty, ObservableList nodesProperty, TransitionPane transition, ObservableValue _uiState, TerracottaState legacyState, TerracottaState state) {
        if (legacyState != null && legacyState.isUIFakeState() && !state.isUIFakeState() && legacyState.getClass() == state.getClass()) {
            return;
        }
        progressProperty.unbind();
        if (state instanceof TerracottaState.Bootstrap) {
            statusProperty.set((Object)I18n.i18n("terracotta.status.bootstrap"));
            progressProperty.set(-1.0);
            nodesProperty.setAll((Object[])new Node[0]);
        } else if (state instanceof TerracottaState.Uninitialized) {
            TerracottaState.Uninitialized uninitialized = (TerracottaState.Uninitialized)state;
            String fork = uninitialized.hasLegacy() ? "update" : "not_exist";
            statusProperty.set((Object)I18n.i18n("terracotta.status.uninitialized." + fork));
            progressProperty.set(0.0);
            TextFlow body = FXUtils.segmentToTextFlow(I18n.i18n("terracotta.confirm.desc"), Controllers::onHyperlinkAction);
            body.getStyleClass().add((Object)"terracotta-hint");
            body.setLineSpacing(4.0);
            LineButton download = TerracottaControllerPage.createLargeTitleLineButton();
            download.setLeading(FXUtils.newBuiltinImage("/assets/img/terracotta.png"));
            download.setTitle(I18n.i18n(String.format("terracotta.status.uninitialized.%s.title", fork)));
            download.setSubtitle(I18n.i18n("terracotta.status.uninitialized.desc"));
            download.setTrailingIcon(SVG.ARROW_FORWARD, 28.0);
            download.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
                Number number;
                Object feedback;
                TerracottaState.Preparing s = TerracottaManager.download();
                if (s != null) {
                    UI_STATE.set((Object)s);
                }
                if (uninitialized.hasLegacy() && I18n.isUseChinese() && (!((feedback = ConfigHolder.config().getShownTips().get((Object)FEEDBACK_TIP)) instanceof Number) || (number = (Number)feedback).intValue() < 1)) {
                    Controllers.confirm(I18n.i18n("terracotta.feedback.desc"), I18n.i18n("terracotta.feedback.title"), () -> {
                        FXUtils.openLink(TerracottaMetadata.FEEDBACK_LINK);
                        ConfigHolder.config().getShownTips().put((Object)FEEDBACK_TIP, (Object)1);
                    }, () -> {});
                }
            }));
            nodesProperty.setAll((Object[])new Node[]{body, download, this.getThirdPartyDownloadNodes()});
        } else if (state instanceof TerracottaState.Preparing) {
            statusProperty.set((Object)I18n.i18n("terracotta.status.preparing"));
            progressProperty.bind((ObservableValue)((TerracottaState.Preparing)state).progressProperty());
            nodesProperty.setAll((Object[])new Node[]{this.getThirdPartyDownloadNodes()});
        } else if (state instanceof TerracottaState.Launching) {
            statusProperty.set((Object)I18n.i18n("terracotta.status.launching"));
            progressProperty.set(-1.0);
            nodesProperty.setAll((Object[])new Node[0]);
        } else if (state instanceof TerracottaState.Unknown) {
            statusProperty.set((Object)I18n.i18n("terracotta.status.unknown"));
            progressProperty.set(-1.0);
            nodesProperty.setAll((Object[])new Node[0]);
        } else if (state instanceof TerracottaState.Waiting) {
            statusProperty.set((Object)I18n.i18n("terracotta.status.waiting"));
            progressProperty.set(1.0);
            TextFlow flow = FXUtils.segmentToTextFlow(I18n.i18n("terracotta.confirm.desc"), Controllers::onHyperlinkAction);
            flow.getStyleClass().add((Object)"terracotta-hint");
            flow.setLineSpacing(4.0);
            LineButton host = TerracottaControllerPage.createLargeTitleLineButton();
            host.setLeading(SVG.HOST, 28.0);
            host.setTitle(I18n.i18n("terracotta.status.waiting.host.title"));
            host.setSubtitle(I18n.i18n("terracotta.status.waiting.host.desc"));
            host.setTrailingIcon(SVG.ARROW_FORWARD, 28.0);
            host.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
                if (LauncherHelper.countMangedProcesses() >= 1) {
                    TerracottaState.HostScanning s1 = TerracottaManager.setScanning();
                    if (s1 != null) {
                        UI_STATE.set((Object)s1);
                    }
                } else {
                    Controllers.dialog((Region)new MessageDialogPane.Builder(I18n.i18n("terracotta.status.waiting.host.launch.desc"), I18n.i18n("terracotta.status.waiting.host.launch.title"), MessageDialogPane.MessageType.QUESTION).addAction(I18n.i18n("version.launch"), () -> {
                        Profile profile = Profiles.getSelectedProfile();
                        Versions.launch(profile, profile.getSelectedVersion(), launcherHelper -> {
                            launcherHelper.setKeep();
                            launcherHelper.setDisableOfflineSkin();
                        });
                    }).addCancel(I18n.i18n("terracotta.status.waiting.host.launch.skip"), () -> {
                        TerracottaState.HostScanning s1 = TerracottaManager.setScanning();
                        if (s1 != null) {
                            UI_STATE.set((Object)s1);
                        }
                    }).addCancel(() -> {}).build());
                }
            }));
            LineButton guest = TerracottaControllerPage.createLargeTitleLineButton();
            guest.setLeading(SVG.ADD_CIRCLE, 28.0);
            guest.setTitle(I18n.i18n("terracotta.status.waiting.guest.title"));
            guest.setSubtitle(I18n.i18n("terracotta.status.waiting.guest.desc"));
            guest.setTrailingIcon(SVG.ARROW_FORWARD, 28.0);
            guest.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> Controllers.prompt(I18n.i18n("terracotta.status.waiting.guest.prompt.title"), (code, handler) -> {
                Task<TerracottaState.GuestConnecting> task = TerracottaManager.setGuesting(code);
                if (task != null) {
                    task.whenComplete(Schedulers.javafx(), (s, e) -> {
                        if (e != null) {
                            handler.reject(I18n.i18n("terracotta.status.waiting.guest.prompt.invalid"));
                        } else {
                            handler.resolve();
                            UI_STATE.set(s);
                        }
                    }).setSignificance(Task.TaskSignificance.MINOR).start();
                } else {
                    handler.resolve();
                }
            })));
            if (ThreadLocalRandom.current().nextDouble() < 0.02) {
                LineButton feedback = TerracottaControllerPage.createLargeTitleLineButton();
                feedback.setLeading(SVG.FEEDBACK, 28.0);
                feedback.setTitle(I18n.i18n("terracotta.feedback.title"));
                feedback.setSubtitle(I18n.i18n("terracotta.feedback.desc"));
                feedback.setTrailingIcon(SVG.OPEN_IN_NEW, 28.0);
                FXUtils.onClicked((Node)feedback, () -> FXUtils.openLink(TerracottaMetadata.FEEDBACK_LINK));
                nodesProperty.setAll((Object[])new Node[]{flow, host, guest, feedback});
            } else {
                nodesProperty.setAll((Object[])new Node[]{flow, host, guest});
            }
        } else if (state instanceof TerracottaState.HostScanning) {
            statusProperty.set((Object)I18n.i18n("terracotta.status.scanning"));
            progressProperty.set(-1.0);
            TextFlow body = FXUtils.segmentToTextFlow(I18n.i18n("terracotta.status.scanning.desc"), Controllers::onHyperlinkAction);
            body.getStyleClass().add((Object)"terracotta-hint");
            body.setLineSpacing(4.0);
            LineButton room = TerracottaControllerPage.createLargeTitleLineButton();
            room.setLeading(SVG.ARROW_BACK, 28.0);
            room.setTitle(I18n.i18n("terracotta.back"));
            room.setSubtitle(I18n.i18n("terracotta.status.scanning.back"));
            room.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
                TerracottaState.Waiting s = TerracottaManager.setWaiting();
                if (s != null) {
                    UI_STATE.set((Object)s);
                }
            }));
            nodesProperty.setAll((Object[])new Node[]{body, room});
        } else if (state instanceof TerracottaState.HostStarting) {
            statusProperty.set((Object)I18n.i18n("terracotta.status.host_starting"));
            progressProperty.set(-1.0);
            LineButton room = TerracottaControllerPage.createLargeTitleLineButton();
            room.setLeading(SVG.ARROW_BACK, 28.0);
            room.setTitle(I18n.i18n("terracotta.back"));
            room.setSubtitle(I18n.i18n("terracotta.status.host_starting.back"));
            room.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
                TerracottaState.Waiting s = TerracottaManager.setWaiting();
                if (s != null) {
                    UI_STATE.set((Object)s);
                }
            }));
            nodesProperty.setAll((Object[])new Node[]{room});
        } else if (state instanceof TerracottaState.HostOK) {
            TerracottaState.HostOK hostOK = (TerracottaState.HostOK)state;
            if (hostOK.isForkOf(legacyState)) {
                Object patt0$temp = nodesProperty.get(nodesProperty.size() - 1);
                if (patt0$temp instanceof PlayerProfileUI) {
                    PlayerProfileUI profileUI = (PlayerProfileUI)((Object)patt0$temp);
                    profileUI.updateProfiles(hostOK.getProfiles());
                } else {
                    nodesProperty.add((Object)new PlayerProfileUI(hostOK.getProfiles()));
                }
                return;
            }
            String cs = hostOK.getCode();
            this.copyCode(cs);
            statusProperty.set((Object)I18n.i18n("terracotta.status.host_ok"));
            progressProperty.set(1.0);
            VBox code = new VBox(4.0);
            code.setAlignment(Pos.CENTER);
            Label desc = new Label(I18n.i18n("terracotta.status.host_ok.code"));
            desc.setMouseTransparent(true);
            Label label = new Label(cs);
            label.setMouseTransparent(true);
            label.setStyle("-fx-font-size: 24");
            label.setAlignment(Pos.CENTER);
            VBox.setMargin((Node)label, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
            code.getChildren().setAll((Object[])new Node[]{desc, label});
            code.setCursor(Cursor.HAND);
            FXUtils.onClicked((Node)code, () -> this.copyCode(cs));
            LineButton copy = TerracottaControllerPage.createLargeTitleLineButton();
            copy.setLeading(SVG.CONTENT_COPY, 28.0);
            copy.setTitle(I18n.i18n("terracotta.status.host_ok.code.copy"));
            copy.setSubtitle(I18n.i18n("terracotta.status.host_ok.code.desc"));
            FXUtils.onClicked((Node)copy, () -> this.copyCode(cs));
            LineButton back = TerracottaControllerPage.createLargeTitleLineButton();
            back.setLeading(SVG.ARROW_BACK, 28.0);
            back.setTitle(I18n.i18n("terracotta.back"));
            back.setSubtitle(I18n.i18n("terracotta.status.host_ok.back"));
            back.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
                TerracottaState.Waiting s = TerracottaManager.setWaiting();
                if (s != null) {
                    UI_STATE.set((Object)s);
                }
            }));
            if (hostOK.getProfiles().isEmpty()) {
                nodesProperty.setAll((Object[])new Node[]{code, copy, back});
            } else {
                nodesProperty.setAll((Object[])new Node[]{code, copy, back, new PlayerProfileUI(hostOK.getProfiles())});
            }
        } else if (state instanceof TerracottaState.GuestConnecting || state instanceof TerracottaState.GuestStarting) {
            TerracottaState.GuestStarting.Difficulty difficulty;
            statusProperty.set((Object)I18n.i18n("terracotta.status.guest_starting"));
            progressProperty.set(-1.0);
            LineButton room = TerracottaControllerPage.createLargeTitleLineButton();
            room.setLeading(SVG.ARROW_BACK, 28.0);
            room.setTitle(I18n.i18n("terracotta.back"));
            room.setSubtitle(I18n.i18n("terracotta.status.guest_starting.back"));
            room.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
                TerracottaState.Waiting s = TerracottaManager.setWaiting();
                if (s != null) {
                    UI_STATE.set((Object)s);
                }
            }));
            nodesProperty.clear();
            if (state instanceof TerracottaState.GuestStarting && (difficulty = ((TerracottaState.GuestStarting)state).getDifficulty()) != null && difficulty != TerracottaState.GuestStarting.Difficulty.UNKNOWN) {
                LineButton info = TerracottaControllerPage.createLargeTitleLineButton();
                info.setLeading(switch (difficulty) {
                    default -> throw new IncompatibleClassChangeError();
                    case TerracottaState.GuestStarting.Difficulty.UNKNOWN -> throw new AssertionError();
                    case TerracottaState.GuestStarting.Difficulty.EASIEST, TerracottaState.GuestStarting.Difficulty.SIMPLE -> SVG.INFO;
                    case TerracottaState.GuestStarting.Difficulty.MEDIUM, TerracottaState.GuestStarting.Difficulty.TOUGH -> SVG.WARNING;
                }, 28.0);
                String difficultyID = difficulty.name().toLowerCase(Locale.ROOT);
                info.setTitle(I18n.i18n(String.format("terracotta.difficulty.%s", difficultyID)));
                info.setSubtitle(I18n.i18n("terracotta.difficulty.estimate_only"));
                nodesProperty.add((Object)info);
            }
            nodesProperty.add((Object)room);
        } else if (state instanceof TerracottaState.GuestOK) {
            TerracottaState.GuestOK guestOK = (TerracottaState.GuestOK)state;
            if (guestOK.isForkOf(legacyState)) {
                Object patt0$temp = nodesProperty.get(nodesProperty.size() - 1);
                if (patt0$temp instanceof PlayerProfileUI) {
                    PlayerProfileUI profileUI = (PlayerProfileUI)((Object)patt0$temp);
                    profileUI.updateProfiles(guestOK.getProfiles());
                } else {
                    nodesProperty.add((Object)new PlayerProfileUI(guestOK.getProfiles()));
                }
                return;
            }
            statusProperty.set((Object)I18n.i18n("terracotta.status.guest_ok"));
            progressProperty.set(1.0);
            LineButton tutorial = TerracottaControllerPage.createLargeTitleLineButton();
            tutorial.setTitle(I18n.i18n("terracotta.status.guest_ok.title"));
            tutorial.setSubtitle(I18n.i18n("terracotta.status.guest_ok.desc", guestOK.getUrl()));
            LineButton back = TerracottaControllerPage.createLargeTitleLineButton();
            back.setLeading(SVG.ARROW_BACK, 28.0);
            back.setTitle(I18n.i18n("terracotta.back"));
            back.setSubtitle(I18n.i18n("terracotta.status.guest_ok.back"));
            back.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
                TerracottaState.Waiting s = TerracottaManager.setWaiting();
                if (s != null) {
                    UI_STATE.set((Object)s);
                }
            }));
            if (guestOK.getProfiles().isEmpty()) {
                nodesProperty.setAll((Object[])new Node[]{tutorial, back});
            } else {
                nodesProperty.setAll((Object[])new Node[]{tutorial, back, new PlayerProfileUI(guestOK.getProfiles())});
            }
        } else if (state instanceof TerracottaState.Exception) {
            TerracottaState.Exception exception = (TerracottaState.Exception)state;
            statusProperty.set((Object)I18n.i18n("terracotta.status.exception.desc." + exception.getType().name().toLowerCase(Locale.ROOT)));
            progressProperty.set(1.0);
            nodesProperty.setAll((Object[])new Node[0]);
            LineButton back = TerracottaControllerPage.createLargeTitleLineButton();
            back.setLeading(SVG.ARROW_BACK, 28.0);
            back.setTitle(I18n.i18n("terracotta.back"));
            back.setSubtitle(I18n.i18n("terracotta.status.exception.back"));
            back.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
                TerracottaState.Waiting s = TerracottaManager.setWaiting();
                if (s != null) {
                    UI_STATE.set((Object)s);
                }
            }));
            SpinnerPane exportLog = new SpinnerPane();
            LineButton exportLogInner = TerracottaControllerPage.createLargeTitleLineButton();
            exportLogInner.setLeading(SVG.OUTPUT, 28.0);
            exportLogInner.setTitle(I18n.i18n("terracotta.export_log"));
            exportLogInner.setSubtitle(I18n.i18n("terracotta.export_log.desc"));
            exportLog.setContent((Node)exportLogInner);
            ComponentList.setNoPadding((Node)exportLog);
            exportLog.minHeightProperty().bind((ObservableValue)back.heightProperty());
            exportLogInner.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
                exportLog.setLoading(true);
                TerracottaManager.exportLogs().thenAcceptAsync(Schedulers.io(), data -> {
                    if (data == null || data.isEmpty()) {
                        return;
                    }
                    Path path = Path.of("terracotta-log-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss")) + ".zip", new String[0]).toAbsolutePath();
                    try (Zipper zipper = new Zipper(path);){
                        zipper.putTextFile((String)data, StandardCharsets.UTF_8, "terracotta.log");
                        try (OutputStream os = zipper.putStream("hmcl-latest.log");){
                            Logger.LOG.exportLogs(os);
                        }
                    }
                    FXUtils.showFileInExplorer(path);
                }).thenRunAsync(() -> Thread.sleep(3000L)).whenComplete(Schedulers.javafx(), e -> exportLog.setLoading(false)).start();
            }));
            nodesProperty.setAll((Object[])new Node[]{back, exportLog});
        } else if (state instanceof TerracottaState.Fatal) {
            TerracottaState.Fatal fatal = (TerracottaState.Fatal)state;
            String message = I18n.i18n("terracotta.status.fatal." + fatal.getType().name().toLowerCase(Locale.ROOT));
            statusProperty.set((Object)message);
            progressProperty.set(1.0);
            if (fatal.isRecoverable()) {
                LineButton retry = TerracottaControllerPage.createLargeTitleLineButton();
                retry.setLeading(SVG.RESTORE, 28.0);
                retry.setTitle(I18n.i18n("terracotta.status.fatal.retry"));
                retry.setSubtitle(message);
                retry.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
                    TerracottaState s = TerracottaManager.recover();
                    if (s != null) {
                        UI_STATE.set((Object)s);
                    }
                }));
                if (fatal.getType() == TerracottaState.Fatal.Type.NETWORK) {
                    nodesProperty.setAll((Object[])new Node[]{retry, this.getThirdPartyDownloadNodes()});
                } else {
                    nodesProperty.setAll((Object[])new Node[]{retry});
                }
            } else {
                nodesProperty.setAll((Object[])new Node[0]);
            }
        } else {
            throw new AssertionError((Object)state.getClass().getName());
        }
        ComponentList components = new ComponentList();
        VBox statusPane = new VBox(8.0);
        VBox.setMargin((Node)statusPane, (Insets)new Insets(0.0, 0.0, 0.0, 4.0));
        Label status = new Label();
        status.textProperty().bind((ObservableValue)statusProperty);
        JFXProgressBar progress = new JFXProgressBar();
        progress.progressProperty().bind((ObservableValue)progressProperty);
        progress.setMaxWidth(Double.MAX_VALUE);
        statusPane.getChildren().setAll((Object[])new Node[]{status, progress});
        ObservableList<Node> children = components.getContent();
        children.add((Object)statusPane);
        children.addAll((Collection)nodesProperty);
        StackPane.setMargin((Node)components, (Insets)new Insets(0.0, 0.0, 5.0, 0.0));
        transition.setContent((Node)components, ContainerAnimations.SLIDE_UP_FADE_IN);
    }

    static {
        FXUtils.onChangeAndOperate(TerracottaManager.stateProperty(), state -> {
            if (state != null) {
                UI_STATE.set(state);
            }
        });
    }

    private static final class PlayerProfileUI
    extends VBox {
        private final TransitionPane transition;

        public PlayerProfileUI(List<TerracottaProfile> profiles) {
            super(8.0);
            VBox.setMargin((Node)this, (Insets)new Insets(0.0, 0.0, 0.0, 4.0));
            Label status = new Label();
            status.setText(I18n.i18n("terracotta.player_list"));
            this.transition = new TransitionPane();
            this.getChildren().setAll((Object[])new Node[]{status, this.transition});
            this.updateProfiles(profiles);
        }

        private void updateProfiles(List<TerracottaProfile> profiles) {
            VBox pane = new VBox(8.0);
            for (TerracottaProfile profile : profiles) {
                TwoLineListItem item = new TwoLineListItem();
                item.setTitle(profile.getName());
                item.setSubtitle(profile.getVendor());
                item.addTag(I18n.i18n("terracotta.player_kind." + profile.getType().name().toLowerCase(Locale.ROOT)));
                pane.getChildren().add((Object)item);
            }
            this.transition.setContent((Node)pane, ContainerAnimations.SLIDE_UP_FADE_IN);
        }
    }
}

