/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.logging.Logger;

public class ModCheckUpdatesTask
extends Task<List<LocalModFile.ModUpdate>> {
    private final List<Task<LocalModFile.ModUpdate>> dependents;

    public ModCheckUpdatesTask(String gameVersion, Collection<LocalModFile> mods) {
        this.dependents = mods.stream().map(mod -> Task.supplyAsync(Schedulers.io(), () -> {
            LocalModFile.ModUpdate candidate = null;
            for (RemoteMod.Type type : RemoteMod.Type.values()) {
                LocalModFile.ModUpdate update = null;
                try {
                    update = mod.checkUpdates(gameVersion, type.getRemoteModRepository());
                }
                catch (IOException e) {
                    Logger.LOG.warning(String.format("Cannot check update for mod %s.", mod.getFileName()), e);
                }
                if (update == null || candidate != null && !candidate.getCandidate().getDatePublished().isBefore(update.getCandidate().getDatePublished())) continue;
                candidate = update;
            }
            return candidate;
        }).setName(mod.getFileName()).setSignificance(Task.TaskSignificance.MAJOR).withCounter("update.checking")).toList();
        this.setStage("update.checking");
        this.getProperties().put("total", this.dependents.size());
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void preExecute() {
        this.notifyPropertiesChanged();
    }

    @Override
    public Collection<? extends Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public boolean isRelyingOnDependents() {
        return false;
    }

    @Override
    public void execute() throws Exception {
        this.setResult(this.dependents.stream().map(Task::getResult).filter(Objects::nonNull).toList());
    }
}

