/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import sun.tools.attach.HotSpotVirtualMachine;

public final class GameDumpGenerator {
    private static final int TOOL_VERSION = 9;
    private static final int DUMP_TIME = 3;
    private static final int RETRY_TIME = 3;

    private GameDumpGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDumpTo(long pid, Path path) throws IOException, InterruptedException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            VirtualMachine vm = GameDumpGenerator.attachVM(String.valueOf(pid), writer);
            try {
                GameDumpGenerator.writeDumpHeadTo(vm, writer);
                for (int i = 0; i < 3; ++i) {
                    if (i > 0) {
                        Thread.sleep(3000L);
                    }
                    writer.write("====================\n");
                    GameDumpGenerator.writeDumpBodyTo(vm, writer);
                }
            }
            finally {
                vm.detach();
            }
        }
    }

    private static void writeDumpHeadTo(VirtualMachine vm, Writer writer) throws IOException {
        writer.write("===== Minecraft JStack Dump =====\n");
        GameDumpGenerator.writeDumpHeadKeyValueTo("Tool Version", String.valueOf(9), writer, false);
        GameDumpGenerator.writeDumpHeadKeyValueTo("VM PID", vm.id(), writer, false);
        StringBuilder stringBuilder = new StringBuilder();
        GameDumpGenerator.execute(vm, "VM.command_line", stringBuilder);
        GameDumpGenerator.writeDumpHeadKeyValueTo("VM Command Line", Logger.filterForbiddenToken(stringBuilder.toString()), writer, true);
        stringBuilder.setLength(0);
        GameDumpGenerator.execute(vm, "VM.version", stringBuilder);
        GameDumpGenerator.writeDumpHeadKeyValueTo("VM Version", stringBuilder.toString(), writer, true);
        writer.write("\n\n");
    }

    public static void writeDumpHeadKeyValueTo(String key, String value, Writer writer, boolean multiline) throws IOException {
        writer.write(key);
        writer.write(58);
        writer.write(32);
        if (multiline) {
            writer.write(123);
            writer.write(10);
            int lineStart = 0;
            int lineEnd = value.indexOf("\n", lineStart);
            while (true) {
                if (lineEnd == -1) {
                    if (lineStart >= value.length()) break;
                    writer.write("    ");
                    writer.write(value, lineStart, value.length() - lineStart);
                    writer.write(10);
                    break;
                }
                writer.write("    ");
                writer.write(value, lineStart, lineEnd - lineStart);
                writer.write(10);
                lineStart = lineEnd + 1;
                lineEnd = value.indexOf("\n", lineStart);
            }
            writer.write(125);
        } else {
            writer.write(value);
        }
        writer.write(10);
    }

    private static void writeDumpBodyTo(VirtualMachine vm, Writer writer) throws IOException {
        GameDumpGenerator.execute(vm, "Thread.print -e -l", writer);
    }

    private static VirtualMachine attachVM(String lvmid, Writer writer) throws IOException, InterruptedException {
        for (int i = 0; i < 3; ++i) {
            try {
                return VirtualMachine.attach(lvmid);
            }
            catch (Throwable e) {
                Logger.LOG.warning("An exception encountered while attaching vm " + lvmid, e);
                writer.write(StringUtils.getStackTrace(e));
                writer.write(10);
                Thread.sleep(3000L);
                continue;
            }
        }
        String message = "Cannot attach VM " + lvmid;
        writer.write(message);
        throw new IOException(message);
    }

    private static void execute(VirtualMachine vm, String command, Appendable target) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(GameDumpGenerator.executeJVMCommand(vm, command), OperatingSystem.NATIVE_CHARSET);){
            int len;
            char[] data = new char[256];
            CharBuffer cb = CharBuffer.wrap(data);
            while ((len = reader.read(data)) > 0) {
                target.append(cb, 0, len);
            }
        }
        catch (Throwable throwable) {
            Logger.LOG.warning("An exception encountered while executing jcmd " + vm.id(), throwable);
            target.append(StringUtils.getStackTrace(throwable));
            target.append('\n');
        }
    }

    private static InputStream executeJVMCommand(VirtualMachine vm, String command) throws IOException, AttachNotSupportedException {
        if (vm instanceof HotSpotVirtualMachine) {
            return ((HotSpotVirtualMachine)vm).executeJCmd(command);
        }
        throw new AttachNotSupportedException("Unsupported VM implementation " + vm.getClass().getName());
    }
}

