/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import org.jackhuang.hmcl.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ProxyOption {

    public record Socks(@NotNull String host, int port, @Nullable String username, @Nullable String password) implements ProxyOption
    {
        public Socks(@NotNull String host, int port, @Nullable String username, @Nullable String password) {
            if (StringUtils.isBlank(host)) {
                throw new IllegalArgumentException("Host cannot be blank");
            }
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("Illegal port: " + port);
            }
        }
    }

    public record Http(@NotNull String host, int port, @Nullable String username, @Nullable String password) implements ProxyOption
    {
        public Http(@NotNull String host, int port, @Nullable String username, @Nullable String password) {
            if (StringUtils.isBlank(host)) {
                throw new IllegalArgumentException("Host cannot be blank");
            }
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("Illegal port: " + port);
            }
        }
    }

    public static final class Default
    implements ProxyOption {
        public static final Default INSTANCE = new Default();

        private Default() {
        }
    }

    public static final class Direct
    implements ProxyOption {
        public static final Direct INSTANCE = new Direct();

        private Direct() {
        }
    }
}

