/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.task;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import org.jackhuang.hmcl.event.EventManager;
import org.jackhuang.hmcl.task.AsyncTaskExecutor;
import org.jackhuang.hmcl.task.CompletableFutureTask;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.TaskCompletableFuture;
import org.jackhuang.hmcl.task.TaskEvent;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.task.TaskListener;
import org.jackhuang.hmcl.util.function.ExceptionalConsumer;
import org.jackhuang.hmcl.util.function.ExceptionalFunction;
import org.jackhuang.hmcl.util.function.ExceptionalRunnable;
import org.jackhuang.hmcl.util.function.ExceptionalSupplier;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class Task<T> {
    private TaskSignificance significance = TaskSignificance.MAJOR;
    private BooleanSupplier cancelled;
    private String stage = null;
    private String inheritedStage = null;
    Map<String, Object> properties;
    private Runnable notifyPropertiesChanged;
    private TaskState state = TaskState.READY;
    private Exception exception;
    private Executor executor = Schedulers.defaultScheduler();
    private boolean dependentsSucceeded = false;
    private boolean dependenciesSucceeded = false;
    private String name;
    private T result;
    private Consumer<T> resultConsumer;
    private volatile EventManager<TaskEvent> onDone;
    private final DoubleProperty progress = new SimpleDoubleProperty((Object)this, "progress", -1.0);
    private long lastUpdateProgressTime = 0L;
    private volatile double pendingProgress = -1.0;
    private static final VarHandle PENDING_PROGRESS_HANDLE;
    private static final String PACKAGE_PREFIX;
    private static final Predicate<StackWalker.StackFrame> PREDICATE;
    private static final Function<Stream<StackWalker.StackFrame>, Optional<StackWalker.StackFrame>> FUNCTION;
    private static final Function<StackWalker.StackFrame, String> FRAME_MAPPING;

    public final TaskSignificance getSignificance() {
        return this.significance;
    }

    public final Task<T> setSignificance(TaskSignificance significance) {
        this.significance = significance;
        return this;
    }

    final void setCancelled(BooleanSupplier cancelled) {
        this.cancelled = cancelled;
    }

    protected final boolean isCancelled() {
        if (Thread.interrupted()) {
            Thread.currentThread().interrupt();
            return true;
        }
        return this.cancelled != null && this.cancelled.getAsBoolean();
    }

    public String getStage() {
        return this.stage;
    }

    protected final void setStage(String stage) {
        this.stage = stage;
    }

    public String getInheritedStage() {
        return this.inheritedStage;
    }

    void setInheritedStage(String inheritedStage) {
        this.inheritedStage = inheritedStage;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }

    void setNotifyPropertiesChanged(Runnable runnable) {
        this.notifyPropertiesChanged = runnable;
    }

    protected void notifyPropertiesChanged() {
        if (this.notifyPropertiesChanged != null) {
            this.notifyPropertiesChanged.run();
        }
    }

    public final TaskState getState() {
        return this.state;
    }

    final void setState(TaskState state) {
        this.state = state;
    }

    @Nullable
    public final Exception getException() {
        return this.exception;
    }

    final void setException(Exception e) {
        this.exception = e;
    }

    public final Executor getExecutor() {
        return this.executor;
    }

    public final Task<T> setExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public boolean isDependentsSucceeded() {
        return this.dependentsSucceeded;
    }

    void setDependentsSucceeded() {
        this.dependentsSucceeded = true;
    }

    public boolean isDependenciesSucceeded() {
        return this.dependenciesSucceeded;
    }

    void setDependenciesSucceeded() {
        this.dependenciesSucceeded = true;
    }

    public boolean isRelyingOnDependents() {
        return true;
    }

    public boolean isRelyingOnDependencies() {
        return true;
    }

    public String getName() {
        return this.name != null ? this.name : this.getClass().getName();
    }

    public Task<T> setName(String name) {
        this.name = name;
        return this;
    }

    public String toString() {
        if (this.getClass().getName().equals(this.getName())) {
            return this.getName();
        }
        return this.getClass().getName() + "[" + this.getName() + "]";
    }

    public T getResult() {
        return this.result;
    }

    protected void setResult(T result) {
        this.result = result;
        if (this.resultConsumer != null) {
            this.resultConsumer.accept(result);
        }
    }

    public Task<T> storeTo(Consumer<T> action) {
        this.resultConsumer = action;
        action.accept(this.getResult());
        return this;
    }

    public boolean doPreExecute() {
        return false;
    }

    public void preExecute() throws Exception {
    }

    public abstract void execute() throws Exception;

    public boolean doPostExecute() {
        return false;
    }

    public void postExecute() throws Exception {
    }

    public Collection<? extends Task<?>> getDependents() {
        return Collections.emptySet();
    }

    public Collection<? extends Task<?>> getDependencies() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventManager<TaskEvent> onDone() {
        EventManager<TaskEvent> onDone = this.onDone;
        if (onDone == null) {
            Task task = this;
            synchronized (task) {
                onDone = this.onDone;
                if (onDone == null) {
                    this.onDone = onDone = new EventManager();
                }
            }
        }
        return onDone;
    }

    void fireDoneEvent(Object source, boolean failed) {
        EventManager<TaskEvent> onDone = this.onDone;
        if (onDone != null) {
            onDone.fireEvent(new TaskEvent(source, this, failed));
        }
    }

    public ReadOnlyDoubleProperty progressProperty() {
        return this.progress;
    }

    protected void updateProgress(long count, long total) {
        if (count < 0L || total < 0L) {
            throw new IllegalArgumentException("Invalid count or total: count=" + count + ", total=" + total);
        }
        double progress = total >= count ? 1.0 : (double)count / (double)total;
        this.updateProgress(progress);
    }

    protected void updateProgress(double progress) {
        if (progress < 0.0 || progress > 1.0 || Double.isNaN(progress)) {
            throw new IllegalArgumentException("Invalid progress: " + progress);
        }
        long now = System.currentTimeMillis();
        if (progress == 1.0 || now - this.lastUpdateProgressTime >= 1000L) {
            this.updateProgressImmediately(progress);
            this.lastUpdateProgressTime = now;
        }
    }

    protected void updateProgressImmediately(double progress) {
        if (PENDING_PROGRESS_HANDLE.getAndSet(this, progress) == -1.0) {
            Platform.runLater(() -> this.progress.set(PENDING_PROGRESS_HANDLE.getAndSet(this, -1.0)));
        }
    }

    public final T run() throws Exception {
        if (this.getSignificance().shouldLog()) {
            Logger.LOG.trace("Executing task: " + this.getName());
        }
        for (Task<?> task : this.getDependents()) {
            this.doSubTask(task);
        }
        this.execute();
        for (Task<?> task : this.getDependencies()) {
            this.doSubTask(task);
        }
        this.fireDoneEvent(this, false);
        return this.getResult();
    }

    private void doSubTask(Task<?> task) throws Exception {
        this.progress.bind((ObservableValue)task.progress);
        task.run();
        this.progress.unbind();
    }

    public final TaskExecutor executor() {
        return new AsyncTaskExecutor(this);
    }

    public final TaskExecutor executor(boolean start) {
        AsyncTaskExecutor executor = new AsyncTaskExecutor(this);
        if (start) {
            ((TaskExecutor)executor).start();
        }
        return executor;
    }

    public final TaskExecutor executor(TaskListener taskListener) {
        AsyncTaskExecutor executor = new AsyncTaskExecutor(this);
        executor.addTaskListener(taskListener);
        return executor;
    }

    public final void start() {
        this.executor().start();
    }

    public final boolean test() {
        return this.executor().test();
    }

    public <U, E extends Exception> Task<U> thenApplyAsync(ExceptionalFunction<T, U, E> fn) {
        return this.thenApplyAsync(Schedulers.defaultScheduler(), fn);
    }

    public <U, E extends Exception> Task<U> thenApplyAsync(Executor executor, ExceptionalFunction<T, U, E> fn) {
        return this.thenApplyAsync(Task.getCaller(), executor, fn).setSignificance(TaskSignificance.MODERATE);
    }

    public <U, E extends Exception> Task<U> thenApplyAsync(String name, Executor executor, ExceptionalFunction<T, U, E> fn) {
        return new UniApply<U>(fn).setExecutor(executor).setName(name);
    }

    public <E extends Exception> Task<Void> thenAcceptAsync(ExceptionalConsumer<T, E> action) {
        return this.thenAcceptAsync(Schedulers.defaultScheduler(), action);
    }

    public <E extends Exception> Task<Void> thenAcceptAsync(Executor executor, ExceptionalConsumer<T, E> action) {
        return this.thenAcceptAsync(Task.getCaller(), executor, action).setSignificance(TaskSignificance.MODERATE);
    }

    public <E extends Exception> Task<Void> thenAcceptAsync(String name, Executor executor, ExceptionalConsumer<T, E> action) {
        return this.thenApplyAsync(name, executor, result -> {
            action.accept(result);
            return null;
        });
    }

    public <E extends Exception> Task<Void> thenRunAsync(ExceptionalRunnable<E> action) {
        return this.thenRunAsync(Schedulers.defaultScheduler(), action);
    }

    public <E extends Exception> Task<Void> thenRunAsync(Executor executor, ExceptionalRunnable<E> action) {
        return this.thenRunAsync(Task.getCaller(), executor, action).setSignificance(TaskSignificance.MODERATE);
    }

    public <E extends Exception> Task<Void> thenRunAsync(String name, Executor executor, ExceptionalRunnable<E> action) {
        return this.thenApplyAsync(name, executor, ignore -> {
            action.run();
            return null;
        });
    }

    public final <U> Task<U> thenSupplyAsync(Callable<U> fn) {
        return this.thenComposeAsync(() -> Task.supplyAsync(fn));
    }

    public final <U> Task<U> thenSupplyAsync(String name, Callable<U> fn) {
        return this.thenComposeAsync(() -> Task.supplyAsync(name, fn));
    }

    public final <U> Task<U> thenComposeAsync(Task<U> other) {
        return this.thenComposeAsync(() -> other);
    }

    public final <U> Task<U> thenComposeAsync(ExceptionalSupplier<Task<U>, ?> fn) {
        return this.thenComposeAsync(Schedulers.defaultScheduler(), fn);
    }

    public final <U> Task<U> thenComposeAsync(Executor executor, ExceptionalSupplier<Task<U>, ?> fn) {
        return new UniCompose<U>(fn, true).setExecutor(executor);
    }

    public <U, E extends Exception> Task<U> thenComposeAsync(ExceptionalFunction<T, Task<U>, E> fn) {
        return this.thenComposeAsync(Schedulers.defaultScheduler(), fn);
    }

    public <U, E extends Exception> Task<U> thenComposeAsync(Executor executor, ExceptionalFunction<T, Task<U>, E> fn) {
        return new UniCompose<U>(fn, true).setExecutor(executor);
    }

    public final <U> Task<U> withComposeAsync(Task<U> other) {
        return this.withComposeAsync(() -> other);
    }

    public final <U, E extends Exception> Task<U> withComposeAsync(ExceptionalSupplier<Task<U>, E> fn) {
        return new UniCompose<U>(fn, false);
    }

    public <E extends Exception> Task<Void> withRunAsync(ExceptionalRunnable<E> action) {
        return this.withRunAsync(Schedulers.defaultScheduler(), action);
    }

    public <E extends Exception> Task<Void> withRunAsync(Executor executor, ExceptionalRunnable<E> action) {
        return this.withRunAsync(Task.getCaller(), executor, action).setSignificance(TaskSignificance.MODERATE);
    }

    public <E extends Exception> Task<Void> withRunAsync(String name, Executor executor, ExceptionalRunnable<E> action) {
        return new UniCompose<Void>(() -> Task.runAsync(name, executor, action), false);
    }

    public final Task<Void> whenComplete(FinalizedCallback action) {
        return this.whenComplete(Schedulers.defaultScheduler(), action);
    }

    public final Task<Void> whenComplete(Executor executor, final FinalizedCallback action) {
        return new Task<Void>(){
            {
                this.setSignificance(TaskSignificance.MODERATE);
            }

            @Override
            public void execute() throws Exception {
                if (this.isDependentsSucceeded() != (Task.this.getException() == null)) {
                    throw new AssertionError("When whenComplete succeeded, Task.exception must be null.", Task.this.getException());
                }
                action.execute(Task.this.getException());
                if (!this.isDependentsSucceeded()) {
                    this.setSignificance(TaskSignificance.MINOR);
                    if (Task.this.getException() == null) {
                        throw new AssertionError((Object)"When failed, exception cannot be null");
                    }
                    throw Task.this.getException();
                }
            }

            @Override
            public Collection<Task<?>> getDependents() {
                return Collections.singleton(Task.this);
            }

            @Override
            public boolean isRelyingOnDependents() {
                return false;
            }
        }.setExecutor(executor).setName(Task.getCaller()).setSignificance(TaskSignificance.MODERATE);
    }

    public Task<Void> whenComplete(Executor executor, FinalizedCallbackWithResult<T> action) {
        return this.whenComplete(executor, (Exception exception) -> action.execute(this.getResult(), exception));
    }

    public final <E1 extends Exception, E2 extends Exception> Task<Void> whenComplete(Executor executor, ExceptionalRunnable<E1> success, ExceptionalConsumer<Exception, E2> failure) {
        return this.whenComplete(executor, (Exception exception) -> {
            if (exception == null) {
                if (success != null) {
                    try {
                        success.run();
                    }
                    catch (Exception e) {
                        Logger.LOG.warning("Failed to execute " + String.valueOf(success), e);
                        if (failure != null) {
                            failure.accept(e);
                        }
                    }
                }
            } else if (failure != null) {
                failure.accept(exception);
            }
        });
    }

    public <E1 extends Exception, E2 extends Exception> Task<Void> whenComplete(Executor executor, ExceptionalConsumer<T, E1> success, ExceptionalConsumer<Exception, E2> failure) {
        return this.whenComplete(executor, () -> success.accept(this.getResult()), failure);
    }

    public Task<T> withStage(String stage) {
        return new StageTask(stage);
    }

    public Task<T> withFakeProgress(String name, BooleanSupplier done, double k) {
        return new FakeProgressTask(done, k).setExecutor(Schedulers.defaultScheduler()).setName(name).setSignificance(TaskSignificance.MAJOR);
    }

    public Task<T> withStagesHint(List<String> stages) {
        return new StagesHintTask(stages);
    }

    public Task<T> withCounter(String countStage) {
        return new CountTask(countStage);
    }

    public static Task<Void> runAsync(ExceptionalRunnable<?> closure) {
        return Task.runAsync(Schedulers.defaultScheduler(), closure);
    }

    public static Task<Void> runAsync(String name, ExceptionalRunnable<?> closure) {
        return Task.runAsync(name, Schedulers.defaultScheduler(), closure);
    }

    public static Task<Void> runAsync(Executor executor, ExceptionalRunnable<?> closure) {
        return Task.runAsync(Task.getCaller(), executor, closure).setSignificance(TaskSignificance.MODERATE);
    }

    public static Task<Void> runAsync(String name, Executor executor, ExceptionalRunnable<?> closure) {
        return new SimpleTask<Void>(closure.toCallable()).setExecutor(executor).setName(name);
    }

    public static <T> Task<T> composeAsync(ExceptionalSupplier<Task<T>, ?> fn) {
        return Task.composeAsync(Task.getCaller(), fn).setSignificance(TaskSignificance.MODERATE);
    }

    public static <T> Task<T> composeAsync(String name, final ExceptionalSupplier<Task<T>, ?> fn) {
        return new Task<T>(){
            Task<T> then;

            @Override
            public void execute() throws Exception {
                this.then = (Task)fn.get();
                if (this.then != null) {
                    this.then.storeTo(this::setResult);
                }
            }

            @Override
            public Collection<Task<?>> getDependencies() {
                return this.then == null ? Collections.emptySet() : Collections.singleton(this.then);
            }
        }.setName(name);
    }

    public static <T> Task<T> composeAsync(Executor executor, ExceptionalSupplier<Task<T>, ?> fn) {
        return Task.composeAsync(fn).setExecutor(executor);
    }

    public static <V> Task<V> supplyAsync(Callable<V> callable) {
        return Task.supplyAsync(Task.getCaller(), callable).setSignificance(TaskSignificance.MODERATE);
    }

    public static <V> Task<V> supplyAsync(Executor executor, Callable<V> callable) {
        return Task.supplyAsync(Task.getCaller(), executor, callable).setSignificance(TaskSignificance.MODERATE);
    }

    public static <V> Task<V> supplyAsync(String name, Callable<V> callable) {
        return Task.supplyAsync(name, Schedulers.defaultScheduler(), callable);
    }

    public static <V> Task<V> supplyAsync(String name, Executor executor, Callable<V> callable) {
        return new SimpleTask<V>(callable).setExecutor(executor).setName(name);
    }

    public static <V> Task<V> completed(V value) {
        return Task.fromCompletableFuture(CompletableFuture.completedFuture(value));
    }

    @SafeVarargs
    public static <T> Task<List<T>> allOf(Task<? extends T> ... tasks) {
        return Task.allOf(Arrays.asList(tasks));
    }

    public static <T> Task<List<T>> allOf(final Collection<? extends Task<? extends T>> tasks) {
        return new Task<List<T>>(){
            {
                this.setSignificance(TaskSignificance.MINOR);
            }

            @Override
            public void execute() {
                this.setResult(tasks.stream().map(Task::getResult).collect(Collectors.toList()));
            }

            @Override
            public Collection<? extends Task<?>> getDependents() {
                return tasks;
            }
        };
    }

    public static Task<?> runSequentially(Task<?> ... tasks) {
        if (tasks.length == 0) {
            return new SimpleTask<Object>(() -> null);
        }
        Task<?> task = tasks[0];
        for (int i = 1; i < tasks.length; ++i) {
            task = task.thenComposeAsync(tasks[i]);
        }
        return task;
    }

    public static <T> Task<T> fromCompletableFuture(final CompletableFuture<T> future) {
        return new CompletableFutureTask<T>(){

            @Override
            public CompletableFuture<T> getFuture(TaskCompletableFuture executor) {
                return future;
            }
        };
    }

    private static String getCaller() {
        return StackWalker.getInstance().walk(FUNCTION).map(FRAME_MAPPING).orElse("Unknown");
    }

    static {
        try {
            PENDING_PROGRESS_HANDLE = MethodHandles.lookup().findVarHandle(Task.class, "pendingProgress", Double.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
        PACKAGE_PREFIX = Task.class.getPackageName() + ".";
        PREDICATE = stackFrame -> !stackFrame.getClassName().startsWith(PACKAGE_PREFIX);
        FUNCTION = stream -> stream.filter(PREDICATE).findFirst();
        FRAME_MAPPING = frame -> {
            String fileName = frame.getFileName();
            if (fileName != null) {
                return frame.getClassName() + "." + frame.getMethodName() + "(" + fileName + ":" + frame.getLineNumber() + ")";
            }
            return frame.getClassName() + "." + frame.getMethodName();
        };
    }

    public static enum TaskSignificance {
        MAJOR,
        MODERATE,
        MINOR;


        public boolean shouldLog() {
            return this != MINOR;
        }

        public boolean shouldShow() {
            return this == MAJOR;
        }
    }

    public static enum TaskState {
        READY,
        RUNNING,
        EXECUTED,
        SUCCEEDED,
        FAILED;

    }

    private class UniApply<R>
    extends Task<R> {
        private final ExceptionalFunction<T, R, ?> callable;

        UniApply(ExceptionalFunction<T, R, ?> callable) {
            this.callable = callable;
        }

        @Override
        public Collection<Task<?>> getDependents() {
            return Collections.singleton(Task.this);
        }

        @Override
        public void execute() throws Exception {
            this.setResult(this.callable.apply(Task.this.getResult()));
        }
    }

    private final class UniCompose<U>
    extends Task<U> {
        private final boolean relyingOnDependents;
        private Task<U> succ;
        private final ExceptionalFunction<T, Task<U>, ?> fn;

        UniCompose(ExceptionalSupplier<Task<U>, ?> fn, boolean relyingOnDependents) {
            this((T result) -> (Task)fn.get(), relyingOnDependents);
        }

        UniCompose(ExceptionalFunction<T, Task<U>, ?> fn, boolean relyingOnDependents) {
            this.fn = fn;
            this.relyingOnDependents = relyingOnDependents;
            this.setSignificance(TaskSignificance.MODERATE);
            this.setName(fn.toString());
        }

        @Override
        public void execute() throws Exception {
            this.setName(this.fn.toString());
            this.succ = this.fn.apply(Task.this.getResult());
            if (this.succ != null) {
                this.succ.storeTo(this::setResult);
            }
        }

        @Override
        public Collection<Task<?>> getDependents() {
            return Collections.singleton(Task.this);
        }

        @Override
        public Collection<Task<?>> getDependencies() {
            return this.succ == null ? Collections.emptySet() : Collections.singleton(this.succ);
        }

        @Override
        public boolean isRelyingOnDependents() {
            return this.relyingOnDependents;
        }
    }

    @FunctionalInterface
    public static interface FinalizedCallback {
        public void execute(Exception var1) throws Exception;
    }

    @FunctionalInterface
    public static interface FinalizedCallbackWithResult<T> {
        public void execute(T var1, Exception var2) throws Exception;
    }

    private final class StageTask
    extends Task<T> {
        private StageTask(String stage) {
            this.setStage(stage);
        }

        @Override
        public Collection<Task<?>> getDependents() {
            return Collections.singleton(Task.this);
        }

        @Override
        public void execute() {
            this.setResult(Task.this.getResult());
        }
    }

    private final class FakeProgressTask
    extends Task<T> {
        private static final double MAX_VALUE = 0.98;
        private final BooleanSupplier done;
        private final double k;

        private FakeProgressTask(BooleanSupplier done, double k) {
            this.done = done;
            this.k = k;
        }

        @Override
        public Collection<Task<?>> getDependents() {
            return Collections.singleton(Task.this);
        }

        @Override
        public void execute() throws InterruptedException {
            if (!this.done.getAsBoolean()) {
                this.updateProgress(0.0);
                long start = System.currentTimeMillis();
                double k2 = this.k / 0.98;
                while (!this.done.getAsBoolean()) {
                    this.updateProgressImmediately(-this.k / ((double)(System.currentTimeMillis() - start) / 1000.0 + k2) + 0.98);
                    Thread.sleep(1000L);
                }
            }
            this.updateProgress(1.0);
            this.setResult(Task.this.getResult());
        }
    }

    public class StagesHintTask
    extends Task<T> {
        private final List<String> stages;

        public StagesHintTask(List<String> stages) {
            this.stages = stages;
        }

        @Override
        public Collection<Task<?>> getDependents() {
            return Collections.singleton(Task.this);
        }

        @Override
        public void execute() {
            this.setResult(Task.this.getResult());
        }

        public List<String> getStages() {
            return this.stages;
        }
    }

    public final class CountTask
    extends Task<T> {
        private final String countStage;

        private CountTask(String countStage) {
            this.countStage = countStage;
            this.setSignificance(TaskSignificance.MINOR);
        }

        public String getCountStage() {
            return this.countStage;
        }

        @Override
        public Collection<Task<?>> getDependents() {
            return Collections.singleton(Task.this);
        }

        @Override
        public void execute() throws Exception {
            this.setResult(Task.this.getResult());
        }

        @Override
        public boolean doPostExecute() {
            return true;
        }

        @Override
        public void postExecute() throws Exception {
            this.notifyPropertiesChanged();
        }
    }

    private static final class SimpleTask<T>
    extends Task<T> {
        private final Callable<T> callable;

        SimpleTask(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        public void execute() throws Exception {
            this.setResult(this.callable.call());
        }
    }
}

