/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.InsetsConverter;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import org.jackhuang.hmcl.ui.construct.ComponentSublist;
import org.jackhuang.hmcl.ui.construct.ComponentSublistWrapper;
import org.jackhuang.hmcl.ui.construct.OptionsListSkin;
import org.jetbrains.annotations.NotNull;

public final class OptionsList
extends Control {
    private final ObservableList<Element> elements = FXCollections.observableArrayList();
    private final StyleableObjectProperty<Insets> contentPadding = new StyleableObjectProperty<Insets>(){

        public Object getBean() {
            return OptionsList.this;
        }

        public String getName() {
            return "contentPadding";
        }

        public CssMetaData<OptionsList, Insets> getCssMetaData() {
            return StyleableProperties.CONTENT_PADDING;
        }
    };

    public OptionsList() {
        this.getStyleClass().add((Object)"options-list");
    }

    protected Skin<?> createDefaultSkin() {
        return new OptionsListSkin(this);
    }

    public ObservableList<Element> getElements() {
        return this.elements;
    }

    public void addTitle(String title) {
        this.elements.add((Object)new Title(title));
    }

    public void addNode(Node node) {
        this.elements.add((Object)new NodeElement(node));
    }

    public void addListElement(@NotNull Node node) {
        this.elements.add((Object)new ListElement(node));
    }

    public void addListElements(Node ... nodes) {
        for (Node node : nodes) {
            this.elements.add((Object)new ListElement(node));
        }
    }

    public StyleableObjectProperty<Insets> contentPaddingProperty() {
        return this.contentPadding;
    }

    public Insets getContentPadding() {
        return (Insets)this.contentPaddingProperty().get();
    }

    public void setContentPadding(Insets padding) {
        this.contentPaddingProperty().set((Object)padding);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return OptionsList.getClassCssMetaData();
    }

    public static final class Title
    extends Element {
        @NotNull
        private final String title;

        public Title(@NotNull String title) {
            this.title = title;
        }

        @Override
        protected Node createNode() {
            Label label = new Label(this.title);
            label.setPadding(new Insets(8.0, 0.0, 8.0, 0.0));
            return label;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof Title)) return false;
            Title that = (Title)obj;
            if (!Objects.equals(this.title, that.title)) return false;
            return true;
        }

        public int hashCode() {
            return this.title.hashCode();
        }

        public String toString() {
            return "Title[%s]".formatted(this.title);
        }
    }

    public static final class NodeElement
    extends Element {
        public NodeElement(@NotNull Node node) {
            this.node = node;
        }

        @Override
        protected Node createNode() {
            return this.node;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof NodeElement)) return false;
            NodeElement that = (NodeElement)obj;
            if (!this.node.equals(that.node)) return false;
            return true;
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public String toString() {
            return "NodeElement[node=%s]".formatted(this.node);
        }
    }

    public static final class ListElement
    extends Element {
        private final Node original;

        public ListElement(@NotNull Node node) {
            this.original = node;
        }

        @Override
        protected Node createNode() {
            Node node = this.original;
            if (node instanceof ComponentSublist) {
                ComponentSublist sublist = (ComponentSublist)node;
                return new ComponentSublistWrapper(sublist);
            }
            return this.original;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof ListElement)) return false;
            ListElement that = (ListElement)obj;
            if (!this.original.equals(that.original)) return false;
            return true;
        }

        public int hashCode() {
            return this.original.hashCode();
        }

        public String toString() {
            return "ListElement[node=%s]".formatted(this.original);
        }
    }

    private static final class StyleableProperties {
        private static final CssMetaData<OptionsList, Insets> CONTENT_PADDING = new CssMetaData<OptionsList, Insets>("-jfx-content-padding", InsetsConverter.getInstance()){

            public boolean isSettable(OptionsList styleable) {
                return styleable.contentPadding == null || !styleable.contentPadding.isBound();
            }

            public StyleableProperty<Insets> getStyleableProperty(OptionsList styleable) {
                return styleable.contentPaddingProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, CONTENT_PADDING);
            STYLEABLES = List.copyOf(styleables);
        }
    }

    public static abstract class Element {
        protected Node node;

        Node getNode() {
            if (this.node == null) {
                this.node = this.createNode();
            }
            return this.node;
        }

        protected abstract Node createNode();
    }
}

