/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.nbt;

import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum NBTTagType {
    BYTE,
    SHORT,
    INT,
    LONG,
    FLOAT,
    DOUBLE,
    BYTE_ARRAY,
    INT_ARRAY,
    LONG_ARRAY,
    STRING,
    LIST,
    COMPOUND;

    private static final Map<String, NBTTagType> lookupTable;
    private final String iconUrl;
    private final String tagClassName;

    public static NBTTagType typeOf(Tag tag) {
        NBTTagType type = lookupTable.get(tag.getClass().getSimpleName());
        if (type == null) {
            throw new IllegalArgumentException("Unknown tag: " + String.valueOf((Object)type));
        }
        return type;
    }

    private NBTTagType() {
        String className;
        String tagName;
        int idx = this.name().indexOf(95);
        if (idx < 0) {
            tagName = this.name().charAt(0) + this.name().substring(1).toLowerCase(Locale.ROOT);
            className = tagName + "Tag";
        } else {
            tagName = this.name().charAt(0) + this.name().substring(1, idx + 1).toLowerCase(Locale.ROOT) + this.name().charAt(idx + 1) + this.name().substring(idx + 2).toLowerCase(Locale.ROOT);
            className = tagName.substring(0, idx) + tagName.substring(idx + 1) + "Tag";
        }
        this.iconUrl = "/assets/img/nbt/TAG_" + tagName + ".png";
        this.tagClassName = className;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getTagClassName() {
        return this.tagClassName;
    }

    static {
        lookupTable = new HashMap<String, NBTTagType>();
        for (NBTTagType type : NBTTagType.values()) {
            lookupTable.put(type.getTagClassName(), type);
        }
    }
}

