/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.MultipleSourceVersionList;
import org.jackhuang.hmcl.download.VersionList;

public final class AutoDownloadProvider
implements DownloadProvider {
    private final List<DownloadProvider> versionListProviders;
    private final List<DownloadProvider> fileProviders;
    private final ConcurrentMap<String, VersionList<?>> versionLists = new ConcurrentHashMap();

    public AutoDownloadProvider(List<DownloadProvider> versionListProviders, List<DownloadProvider> fileProviders) {
        if (versionListProviders == null || versionListProviders.isEmpty()) {
            throw new IllegalArgumentException("versionListProviders must not be null or empty");
        }
        if (fileProviders == null || fileProviders.isEmpty()) {
            throw new IllegalArgumentException("fileProviders must not be null or empty");
        }
        this.versionListProviders = versionListProviders;
        this.fileProviders = fileProviders;
    }

    public AutoDownloadProvider(DownloadProvider ... downloadProviderCandidate) {
        if (downloadProviderCandidate.length == 0) {
            throw new IllegalArgumentException("Download provider must have at least one download provider");
        }
        this.versionListProviders = List.of(downloadProviderCandidate);
        this.fileProviders = this.versionListProviders;
    }

    private DownloadProvider getPreferredDownloadProvider() {
        return this.fileProviders.get(0);
    }

    private static List<URI> getAll(List<DownloadProvider> providers, Function<DownloadProvider, List<URI>> function) {
        LinkedHashSet result = new LinkedHashSet();
        for (DownloadProvider provider : providers) {
            result.addAll(function.apply(provider));
        }
        return List.copyOf(result);
    }

    @Override
    public List<URI> getVersionListURLs() {
        return AutoDownloadProvider.getAll(this.versionListProviders, DownloadProvider::getVersionListURLs);
    }

    @Override
    public String injectURL(String baseURL) {
        return this.getPreferredDownloadProvider().injectURL(baseURL);
    }

    @Override
    public List<URI> getAssetObjectCandidates(String assetObjectLocation) {
        return AutoDownloadProvider.getAll(this.fileProviders, provider -> provider.getAssetObjectCandidates(assetObjectLocation));
    }

    @Override
    public List<URI> injectURLWithCandidates(String baseURL) {
        return AutoDownloadProvider.getAll(this.fileProviders, provider -> provider.injectURLWithCandidates(baseURL));
    }

    @Override
    public List<URI> injectURLsWithCandidates(List<String> urls) {
        return AutoDownloadProvider.getAll(this.fileProviders, provider -> provider.injectURLsWithCandidates(urls));
    }

    @Override
    public VersionList<?> getVersionListById(String id) {
        return this.versionLists.computeIfAbsent(id, value -> {
            VersionList[] lists = new VersionList[this.versionListProviders.size()];
            for (int i = 0; i < this.versionListProviders.size(); ++i) {
                lists[i] = this.versionListProviders.get(i).getVersionListById((String)value);
            }
            return new MultipleSourceVersionList(lists);
        });
    }

    @Override
    public int getConcurrency() {
        return this.getPreferredDownloadProvider().getConcurrency();
    }

    public String toString() {
        return "AutoDownloadProvider[versionListProviders=%s, fileProviders=%s]".formatted(this.versionListProviders, this.fileProviders);
    }
}

