/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.modrinth;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.GameBuilder;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.mod.MinecraftInstanceTask;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackCompletionException;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.ModpackInstallTask;
import org.jackhuang.hmcl.mod.modrinth.ModrinthCompletionTask;
import org.jackhuang.hmcl.mod.modrinth.ModrinthManifest;
import org.jackhuang.hmcl.mod.modrinth.ModrinthModpackProvider;
import org.jackhuang.hmcl.task.CacheFileTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public class ModrinthInstallTask
extends Task<Void> {
    private static final Set<String> SUPPORTED_ICON_EXTS = Set.of("png", "jpg", "jpeg", "bmp", "gif", "webp", "apng");
    private final DefaultDependencyManager dependencyManager;
    private final DefaultGameRepository repository;
    private final Path zipFile;
    private final Modpack modpack;
    private final ModrinthManifest manifest;
    private final String name;
    private final String iconUrl;
    private final Path run;
    private final ModpackConfiguration<ModrinthManifest> config;
    private String iconExt;
    private Task<Path> downloadIconTask;
    private final List<Task<?>> dependents = new ArrayList(4);
    private final List<Task<?>> dependencies = new ArrayList(1);

    public ModrinthInstallTask(DefaultDependencyManager dependencyManager, Path zipFile, Modpack modpack, ModrinthManifest manifest, String name, String iconUrl) {
        String ext;
        this.dependencyManager = dependencyManager;
        this.zipFile = zipFile;
        this.modpack = modpack;
        this.manifest = manifest;
        this.name = name;
        this.iconUrl = iconUrl;
        this.repository = dependencyManager.getGameRepository();
        this.run = this.repository.getRunDirectory(name);
        Path json = this.repository.getModpackConfiguration(name);
        if (this.repository.hasVersion(name) && Files.notExists(json, new LinkOption[0])) {
            throw new IllegalArgumentException("Version " + name + " already exists.");
        }
        GameBuilder builder = dependencyManager.gameBuilder().name(name).gameVersion(manifest.getGameVersion());
        block17: for (Map.Entry<String, String> modLoader : manifest.getDependencies().entrySet()) {
            switch (modLoader.getKey()) {
                case "minecraft": {
                    continue block17;
                }
                case "forge": {
                    builder.version("forge", modLoader.getValue());
                    continue block17;
                }
                case "neoforge": 
                case "neo-forge": {
                    builder.version("neoforge", modLoader.getValue());
                    continue block17;
                }
                case "fabric-loader": {
                    builder.version("fabric", modLoader.getValue());
                    continue block17;
                }
                case "quilt-loader": {
                    builder.version("quilt", modLoader.getValue());
                    continue block17;
                }
            }
            throw new IllegalStateException("Unsupported mod loader " + modLoader.getKey());
        }
        this.dependents.add(builder.buildAsync());
        this.onDone().register(event -> {
            Exception ex = event.getTask().getException();
            if (event.isFailed() && !(ex instanceof ModpackCompletionException)) {
                this.repository.removeVersionFromDisk(name);
            }
        });
        ModpackConfiguration<ModrinthManifest> config = null;
        try {
            if (Files.exists(json, new LinkOption[0])) {
                config = JsonUtils.fromJsonFile(json, ModpackConfiguration.typeOf(ModrinthManifest.class));
                if (!ModrinthModpackProvider.INSTANCE.getName().equals(config.getType())) {
                    throw new IllegalArgumentException("Version " + name + " is not a Modrinth modpack. Cannot update this version.");
                }
            }
        }
        catch (JsonParseException | IOException modLoader) {
            // empty catch block
        }
        this.config = config;
        List<String> subDirectories = Arrays.asList("/client-overrides", "/overrides");
        this.dependents.add(new ModpackInstallTask<ModrinthManifest>(zipFile, this.run, modpack.getEncoding(), subDirectories, any -> true, config).withStage("hmcl.modpack"));
        this.dependents.add(new MinecraftInstanceTask<ModrinthManifest>(zipFile, modpack.getEncoding(), subDirectories, manifest, ModrinthModpackProvider.INSTANCE, manifest.getName(), manifest.getVersionId(), this.repository.getModpackConfiguration(name)).withStage("hmcl.modpack"));
        URI iconUri = NetworkUtils.toURIOrNull(iconUrl);
        if (iconUri != null && SUPPORTED_ICON_EXTS.contains(ext = FileUtils.getExtension(StringUtils.substringAfter(iconUri.getPath(), '/')).toLowerCase(Locale.ROOT))) {
            this.iconExt = ext;
            this.downloadIconTask = new CacheFileTask(iconUrl);
            this.dependents.add(this.downloadIconTask);
        }
        this.dependencies.add(new ModrinthCompletionTask(dependencyManager, name, manifest));
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void execute() throws Exception {
        if (this.config != null) {
            for (ModrinthManifest.File oldManifestFile : this.config.getManifest().getFiles()) {
                Path oldFile = this.run.resolve(oldManifestFile.getPath());
                if (!Files.exists(oldFile, new LinkOption[0]) || !this.manifest.getFiles().stream().noneMatch(oldManifestFile::equals)) continue;
                Files.deleteIfExists(oldFile);
            }
        }
        Path root = this.repository.getVersionRoot(this.name);
        Files.createDirectories(root, new FileAttribute[0]);
        JsonUtils.writeToJsonFile(root.resolve("modrinth.index.json"), this.manifest);
        if (this.iconExt != null) {
            try {
                Files.copy(this.downloadIconTask.getResult(), root.resolve("icon." + this.iconExt), new CopyOption[0]);
            }
            catch (Exception e) {
                Logger.LOG.warning("Failed to copy modpack icon", e);
            }
        }
    }
}

