/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.setting.Config;
import org.jackhuang.hmcl.setting.ConfigUpgrader;
import org.jackhuang.hmcl.setting.GlobalConfig;
import org.jackhuang.hmcl.setting.SambaException;
import org.jackhuang.hmcl.setting.Settings;
import org.jackhuang.hmcl.util.FileSaver;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class ConfigHolder {
    public static final String CONFIG_FILENAME = "hmcl.json";
    public static final String CONFIG_FILENAME_LINUX = ".hmcl.json";
    public static final Path GLOBAL_CONFIG_PATH = Metadata.HMCL_GLOBAL_DIRECTORY.resolve("config.json");
    private static Path configLocation;
    private static Config configInstance;
    private static GlobalConfig globalConfigInstance;
    private static boolean newlyCreated;
    private static boolean ownerChanged;
    private static boolean unsupportedVersion;

    private ConfigHolder() {
    }

    public static Config config() {
        if (configInstance == null) {
            throw new IllegalStateException("Configuration hasn't been loaded");
        }
        return configInstance;
    }

    public static GlobalConfig globalConfig() {
        if (globalConfigInstance == null) {
            throw new IllegalStateException("Configuration hasn't been loaded");
        }
        return globalConfigInstance;
    }

    public static Path configLocation() {
        return configLocation;
    }

    public static boolean isNewlyCreated() {
        return newlyCreated;
    }

    public static boolean isOwnerChanged() {
        return ownerChanged;
    }

    public static boolean isUnsupportedVersion() {
        return unsupportedVersion;
    }

    public static void init() throws IOException {
        if (configInstance != null) {
            throw new IllegalStateException("Configuration is already loaded");
        }
        configLocation = ConfigHolder.locateConfig();
        Logger.LOG.info("Config location: " + String.valueOf(configLocation));
        configInstance = ConfigHolder.loadConfig();
        if (!unsupportedVersion) {
            configInstance.addListener(source -> FileSaver.save(configLocation, configInstance.toJson()));
        }
        globalConfigInstance = ConfigHolder.loadGlobalConfig();
        globalConfigInstance.addListener(source -> FileSaver.save(GLOBAL_CONFIG_PATH, globalConfigInstance.toJson()));
        Locale.setDefault(ConfigHolder.config().getLocalization().getLocale());
        I18n.setLocale(configInstance.getLocalization());
        Logger.LOG.setLogRetention(ConfigHolder.globalConfig().getLogRetention());
        Settings.init();
        if (newlyCreated) {
            Logger.LOG.info("Creating config file " + String.valueOf(configLocation));
            FileUtils.saveSafely(configLocation, configInstance.toJson());
        }
        if (!Files.isWritable(configLocation)) {
            if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS && configLocation.getFileSystem() == FileSystems.getDefault() && configLocation.toFile().canWrite()) {
                Logger.LOG.warning("Config at " + String.valueOf(configLocation) + " is not writable, but it seems to be a Samba share or OpenJDK bug");
                throw new SambaException();
            }
            throw new IOException("Config at " + String.valueOf(configLocation) + " is not writable");
        }
    }

    private static Path locateConfig() {
        Path defaultConfigFile = Metadata.HMCL_CURRENT_DIRECTORY.resolve(CONFIG_FILENAME);
        if (Files.isRegularFile(defaultConfigFile, new LinkOption[0])) {
            return defaultConfigFile;
        }
        try {
            Path jarPath = JarUtils.thisJarPath();
            if (jarPath != null && Files.isRegularFile(jarPath, new LinkOption[0]) && Files.isWritable(jarPath)) {
                Path config = (jarPath = jarPath.getParent()).resolve(CONFIG_FILENAME);
                if (Files.isRegularFile(config, new LinkOption[0])) {
                    return config;
                }
                Path dotConfig = jarPath.resolve(CONFIG_FILENAME_LINUX);
                if (Files.isRegularFile(dotConfig, new LinkOption[0])) {
                    return dotConfig;
                }
            }
        }
        catch (Throwable jarPath) {
            // empty catch block
        }
        Path config = Paths.get(CONFIG_FILENAME, new String[0]);
        if (Files.isRegularFile(config, new LinkOption[0])) {
            return config;
        }
        Path dotConfig = Paths.get(CONFIG_FILENAME_LINUX, new String[0]);
        if (Files.isRegularFile(dotConfig, new LinkOption[0])) {
            return dotConfig;
        }
        return defaultConfigFile;
    }

    private static Config loadConfig() throws IOException {
        if (Files.exists(configLocation, new LinkOption[0])) {
            try {
                if (OperatingSystem.CURRENT_OS != OperatingSystem.WINDOWS && "root".equals(System.getProperty("user.name")) && !"root".equals(Files.getOwner(configLocation, new LinkOption[0]).getName())) {
                    ownerChanged = true;
                }
            }
            catch (IOException e1) {
                Logger.LOG.warning("Failed to get owner");
            }
            try {
                String content = Files.readString(configLocation);
                Config deserialized = Config.fromJson(content);
                if (deserialized != null) {
                    int configVersion = deserialized.getConfigVersion();
                    if (configVersion < 2) {
                        ConfigUpgrader.upgradeConfig(deserialized, content);
                    } else if (configVersion > 2) {
                        unsupportedVersion = true;
                        Logger.LOG.warning(String.format("Current HMCL only support the configuration version up to %d. However, the version now is %d.", 2, configVersion));
                    }
                    return deserialized;
                }
                Logger.LOG.info("Config is empty");
            }
            catch (JsonParseException e) {
                Logger.LOG.warning("Malformed config.", e);
            }
        }
        newlyCreated = true;
        return new Config();
    }

    private static GlobalConfig loadGlobalConfig() throws IOException {
        if (Files.exists(GLOBAL_CONFIG_PATH, new LinkOption[0])) {
            try {
                String content = Files.readString(GLOBAL_CONFIG_PATH);
                GlobalConfig deserialized = GlobalConfig.fromJson(content);
                if (deserialized != null) {
                    return deserialized;
                }
                Logger.LOG.info("Config is empty");
            }
            catch (JsonParseException e) {
                Logger.LOG.warning("Malformed config.", e);
            }
        }
        Logger.LOG.info("Creating an empty global config");
        return new GlobalConfig();
    }

    static {
        ownerChanged = false;
        unsupportedVersion = false;
    }
}

