/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.jetbrains.annotations.NotNull;

public final class AggregatedObservableList<T> {
    private final List<ObservableList<? extends T>> lists = new ArrayList<ObservableList<? extends T>>();
    private final List<Integer> sizes = new ArrayList<Integer>();
    private final List<InternalListModificationListener> listeners = new ArrayList<InternalListModificationListener>();
    private final ObservableList<T> aggregatedList = FXCollections.observableArrayList();

    public ObservableList<T> getAggregatedList() {
        return this.aggregatedList;
    }

    public void appendList(@NotNull ObservableList<? extends T> list) {
        assert (!this.lists.contains(list)) : "List is already contained: " + String.valueOf(list);
        this.lists.add(list);
        InternalListModificationListener listener = new InternalListModificationListener(list);
        list.addListener((ListChangeListener)listener);
        this.sizes.add(list.size());
        this.aggregatedList.addAll(list);
        this.listeners.add(listener);
        assert (this.lists.size() == this.sizes.size() && this.lists.size() == this.listeners.size()) : "lists.size=" + this.lists.size() + " not equal to sizes.size=" + this.sizes.size() + " or not equal to listeners.size=" + this.listeners.size();
    }

    public void prependList(@NotNull ObservableList<? extends T> list) {
        assert (!this.lists.contains(list)) : "List is already contained: " + String.valueOf(list);
        this.lists.add(0, list);
        InternalListModificationListener listener = new InternalListModificationListener(list);
        list.addListener((ListChangeListener)listener);
        this.sizes.add(0, list.size());
        this.aggregatedList.addAll(0, list);
        this.listeners.add(0, listener);
        assert (this.lists.size() == this.sizes.size() && this.lists.size() == this.listeners.size()) : "lists.size=" + this.lists.size() + " not equal to sizes.size=" + this.sizes.size() + " or not equal to listeners.size=" + this.listeners.size();
    }

    public void removeList(@NotNull ObservableList<? extends T> list) {
        assert (this.lists.size() == this.sizes.size() && this.lists.size() == this.listeners.size()) : "lists.size=" + this.lists.size() + " not equal to sizes.size=" + this.sizes.size() + " or not equal to listeners.size=" + this.listeners.size();
        int index = this.lists.indexOf(list);
        if (index < 0) {
            throw new IllegalArgumentException("Cannot remove a list that is not contained: " + String.valueOf(list) + " lists=" + String.valueOf(this.lists));
        }
        int startIndex = this.getStartIndex(list);
        int endIndex = this.getEndIndex(list, startIndex);
        this.lists.remove(list);
        this.sizes.remove(index);
        InternalListModificationListener listener = this.listeners.remove(index);
        list.removeListener((ListChangeListener)listener);
        this.aggregatedList.remove(startIndex, endIndex + 1);
        assert (this.lists.size() == this.sizes.size() && this.lists.size() == this.listeners.size()) : "lists.size=" + this.lists.size() + " not equal to sizes.size=" + this.sizes.size() + " or not equal to listeners.size=" + this.listeners.size();
    }

    private int getStartIndex(@NotNull ObservableList<? extends T> list) {
        int startIndex = 0;
        assert (this.lists.size() == this.sizes.size()) : "lists.size=" + this.lists.size() + " not equal to sizes.size=" + this.sizes.size();
        int listIndex = this.lists.indexOf(list);
        for (int i = 0; i < listIndex; ++i) {
            Integer size = this.sizes.get(i);
            startIndex += size.intValue();
        }
        return startIndex;
    }

    private int getEndIndex(@NotNull ObservableList<? extends T> list, int startIndex) {
        assert (this.lists.size() == this.sizes.size()) : "lists.size=" + this.lists.size() + " not equal to sizes.size=" + this.sizes.size();
        int index = this.lists.indexOf(list);
        return startIndex + this.sizes.get(index) - 1;
    }

    public String dump() {
        return this.dump(x -> x);
    }

    public String dump(Function<T, Object> function) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        this.aggregatedList.forEach(el -> sb.append(function.apply(el)).append(","));
        int length = sb.length();
        sb.replace(length - 1, length, "");
        sb.append("]");
        return sb.toString();
    }

    private final class InternalListModificationListener
    implements ListChangeListener<T> {
        @NotNull
        private final ObservableList<? extends T> list;

        public InternalListModificationListener(ObservableList<? extends T> list) {
            this.list = list;
        }

        public void onChanged(ListChangeListener.Change<? extends T> change) {
            ObservableList changedList = change.getList();
            int startIndex = AggregatedObservableList.this.getStartIndex(this.list);
            int index = AggregatedObservableList.this.lists.indexOf(this.list);
            int newSize = changedList.size();
            while (change.next()) {
                int from = change.getFrom();
                int to = change.getTo();
                if (change.wasPermutated()) {
                    ArrayList<Object> copy = new ArrayList<Object>(AggregatedObservableList.this.aggregatedList.subList(startIndex + from, startIndex + to));
                    for (int oldIndex = from; oldIndex < to; ++oldIndex) {
                        int newIndex = change.getPermutation(oldIndex);
                        copy.set(newIndex - from, AggregatedObservableList.this.aggregatedList.get(startIndex + oldIndex));
                    }
                    AggregatedObservableList.this.aggregatedList.subList(startIndex + from, startIndex + to).clear();
                    AggregatedObservableList.this.aggregatedList.addAll(startIndex + from, copy);
                    continue;
                }
                if (change.wasUpdated()) continue;
                if (change.wasRemoved()) {
                    List removed = change.getRemoved();
                    AggregatedObservableList.this.aggregatedList.remove(startIndex + from, startIndex + from + removed.size());
                }
                if (!change.wasAdded()) continue;
                List added = change.getAddedSubList();
                AggregatedObservableList.this.aggregatedList.addAll(startIndex + from, (Collection)added);
            }
            AggregatedObservableList.this.sizes.set(index, newSize);
        }
    }
}

