/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform.linux;

import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.util.KeyValuePairUtils;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.hardware.CentralProcessor;
import org.jackhuang.hmcl.util.platform.hardware.HardwareVendor;
import org.jetbrains.annotations.Nullable;

final class LinuxCPUDetector {
    private static TreeMap<Integer, Map<String, String>> loadCPUInfo() {
        try {
            List<Map<String, String>> list = KeyValuePairUtils.loadList(Paths.get("/proc/cpuinfo", new String[0]));
            TreeMap<Integer, Map<String, String>> result = new TreeMap<Integer, Map<String, String>>();
            for (Map<String, String> map : list) {
                String id = map.get("processor");
                if (id == null) continue;
                result.put(Integer.parseInt(id), map);
            }
            return result;
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to load /proc/cpuinfo", e);
            return null;
        }
    }

    private static String appleCodeToName(int code) {
        switch (code) {
            case 8103: {
                return "Apple M1";
            }
            case 6000: {
                return "Apple M1 Pro";
            }
            case 6001: {
                return "Apple M1 Max";
            }
            case 6002: {
                return "Apple M1 Ultra";
            }
            case 8112: {
                return "Apple M2";
            }
            case 6020: {
                return "Apple M2 Pro";
            }
            case 6021: {
                return "Apple M2 Max";
            }
            case 6022: {
                return "Apple M2 Ultra";
            }
            case 8122: {
                return "Apple M3";
            }
            case 6030: {
                return "Apple M3 Pro";
            }
            case 6031: 
            case 6034: {
                return "Apple M3 Max";
            }
            case 8132: {
                return "Apple M4";
            }
            case 6040: {
                return "Apple M4 Pro";
            }
            case 6041: {
                return "Apple M4 Max";
            }
        }
        return null;
    }

    private static void detectName(CentralProcessor.Builder builder, TreeMap<Integer, Map<String, String>> cpuInfo) {
        Map<String, String> firstCore = cpuInfo.firstEntry().getValue();
        String modelName = firstCore.get("model name");
        if (modelName == null) {
            modelName = firstCore.get("Model Name");
        }
        if (modelName == null) {
            modelName = firstCore.get("Model name");
        }
        if (modelName == null) {
            modelName = firstCore.get("cpu model");
        }
        if (modelName != null) {
            builder.setName(CentralProcessor.cleanName(modelName));
            builder.setVendor(HardwareVendor.of(firstCore.get("vendor_id")));
            if (builder.getVendor() == null && modelName.startsWith("Loongson")) {
                builder.setVendor(HardwareVendor.LOONGSON);
            }
            return;
        }
        try {
            Path compatiblePath = Paths.get("/proc/device-tree/compatible", new String[0]);
            if (Files.isRegularFile(compatiblePath, new LinkOption[0])) {
                String[] data = Files.readString(compatiblePath).split("\u0000");
                for (int i = data.length - 1; i >= 0; --i) {
                    String device = data[i];
                    int idx = device.indexOf(44);
                    if (idx <= 0 || idx >= device.length() - 1) continue;
                    String vendor = device.substring(0, idx);
                    String model = device.substring(idx + 1);
                    if (model.startsWith("generic-")) continue;
                    builder.setVendor(HardwareVendor.getKnown(vendor));
                    if (builder.getVendor() == null) {
                        builder.setVendor(HardwareVendor.of(StringUtils.capitalizeFirst(vendor)));
                    }
                    if (builder.getVendor() == HardwareVendor.APPLE) {
                        if (model.matches("t[0-9]+")) {
                            builder.setName(LinuxCPUDetector.appleCodeToName(Integer.parseInt(model.substring(1))));
                        }
                        if (builder.getName() == null) {
                            builder.setName("Apple Silicon " + model);
                        }
                    } else if (builder.getVendor() == HardwareVendor.QUALCOMM) {
                        if (model.startsWith("x")) {
                            builder.setName("Qualcomm Snapdragon X Elite " + model.toUpperCase(Locale.ROOT));
                        }
                    } else if (builder.getVendor() == HardwareVendor.BROADCOM) {
                        builder.setName("Broadcom " + model.toUpperCase(Locale.ROOT));
                    }
                    if (builder.getName() == null) {
                        builder.setName(String.valueOf(builder.getVendor()) + " " + model.toUpperCase(Locale.ROOT));
                    }
                    return;
                }
            }
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to detect CPU name from /proc/device-tree/compatible", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void detectCores(CentralProcessor.Builder builder, TreeMap<Integer, Map<String, String>> cpuInfo) {
        int logical = cpuInfo.size();
        try {
            Map<String, String> firstCore = cpuInfo.firstEntry().getValue();
            if (firstCore.containsKey("cpu cores") && firstCore.containsKey("physical id")) {
                TreeMap<Integer, Integer> cpuCores = new TreeMap<Integer, Integer>();
                TreeSet<Integer> physicalIds = new TreeSet<Integer>();
                for (Map<String, String> map : cpuInfo.values()) {
                    int cores = Integer.parseInt(map.get("cpu cores"));
                    int physicalId = Integer.parseInt(map.get("physical id"));
                    cpuCores.put(physicalId, cores);
                    physicalIds.add(physicalId);
                }
                int physical = 0;
                for (Integer value : cpuCores.values()) {
                    physical += value.intValue();
                }
                builder.setCores(new CentralProcessor.Cores(physical, logical, physicalIds.size()));
                return;
            }
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to detect cores in /proc/cpuinfo", e);
        }
        Path cpuDevicesDir = Paths.get("/sys/devices/system/cpu", new String[0]);
        if (Files.isRegularFile(cpuDevicesDir.resolve("cpu0/topology/physical_package_id"), new LinkOption[0]) && Files.isRegularFile(cpuDevicesDir.resolve("cpu0/topology/core_cpus_list"), new LinkOption[0])) {
            Pattern dirNamePattern = Pattern.compile("cpu[0-9]+");
            TreeSet<Integer> physicalPackageIds = new TreeSet<Integer>();
            TreeSet<Integer> physicalCores = new TreeSet<Integer>();
            boolean bl = false;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(cpuDevicesDir);){
                void var7_15;
                for (Path cpuDir : stream) {
                    if (!dirNamePattern.matcher(cpuDir.getFileName().toString()).matches() || !Files.isDirectory(cpuDir, new LinkOption[0])) continue;
                    physicalPackageIds.add(Integer.parseInt(Files.readString(cpuDir.resolve("topology/physical_package_id")).trim()));
                    boolean shouldCount = false;
                    for (String item : Files.readString(cpuDir.resolve("topology/core_cpus_list")).trim().split(",")) {
                        String range = item.trim();
                        int idx = range.indexOf(45);
                        if (idx < 0) {
                            shouldCount |= physicalCores.add(Integer.parseInt(range));
                            continue;
                        }
                        int first = Integer.parseInt(range.substring(0, idx));
                        int last = Integer.parseInt(range.substring(idx + 1));
                        for (int i = first; i <= last; ++i) {
                            shouldCount |= physicalCores.add(i);
                        }
                    }
                    if (!shouldCount) continue;
                    ++var7_15;
                }
                builder.setCores(new CentralProcessor.Cores((int)var7_15, logical, physicalPackageIds.size()));
                return;
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to detect cores in /sys/devices/system/cpu", e);
            }
        }
        builder.setCores(new CentralProcessor.Cores(logical));
    }

    @Nullable
    static CentralProcessor detect() {
        TreeMap<Integer, Map<String, String>> cpuInfo = LinuxCPUDetector.loadCPUInfo();
        if (cpuInfo == null || cpuInfo.isEmpty()) {
            return null;
        }
        CentralProcessor.Builder builder = new CentralProcessor.Builder();
        LinuxCPUDetector.detectName(builder, cpuInfo);
        if (builder.getName() == null) {
            return null;
        }
        LinuxCPUDetector.detectCores(builder, cpuInfo);
        return builder.build();
    }

    private LinuxCPUDetector() {
    }
}

