/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.pci.ids.model;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.glavo.pci.ids.internal.ArgumentValidator;
import org.glavo.pci.ids.model.DeviceSubclass;

public final class DeviceClass
implements Comparable<DeviceClass> {
    private final int id;
    private final String name;
    private final String comment;
    private final TreeMap<Integer, DeviceSubclass> subclasses;

    public DeviceClass(int id, String name, String comment) {
        ArgumentValidator.requireUnsignedByte(id, "Device class ID");
        ArgumentValidator.requireNonBlank(name, "Device class name");
        this.id = id;
        this.name = name;
        this.comment = comment;
        this.subclasses = new TreeMap();
    }

    public void addSubclass(DeviceSubclass subclass) {
        ArgumentValidator.requireNonNull(subclass, "Device subclass");
        this.subclasses.put(subclass.getId(), subclass);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public Map<Integer, DeviceSubclass> getSubclasses() {
        return Collections.unmodifiableMap(this.subclasses);
    }

    @Override
    public int compareTo(DeviceClass t) {
        return Integer.compare(this.id, t.id);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeviceClass)) {
            return false;
        }
        DeviceClass that = (DeviceClass)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public String toString() {
        return String.format("DeviceClass[id=%04x, name=%s]", this.getId(), this.getName());
    }
}

