/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.liteloader;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.jackhuang.hmcl.download.BMCLAPIDownloadProvider;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderRemoteVersion;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderVersion;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public final class LiteLoaderBMCLVersionList
extends VersionList<LiteLoaderRemoteVersion> {
    private final BMCLAPIDownloadProvider downloadProvider;

    public LiteLoaderBMCLVersionList(BMCLAPIDownloadProvider downloadProvider) {
        this.downloadProvider = downloadProvider;
    }

    @Override
    public boolean hasType() {
        return false;
    }

    @Override
    public CompletableFuture<?> refreshAsync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<?> refreshAsync(String gameVersion) {
        return HttpRequest.GET(this.downloadProvider.injectURL("https://bmclapi2.bangbang93.com/liteloader/list"), Pair.pair("mcversion", gameVersion)).getJsonAsync(LiteLoaderBMCLVersion.class).thenAccept(v -> {
            this.lock.writeLock().lock();
            try {
                this.versions.clear();
                this.versions.put(gameVersion, new LiteLoaderRemoteVersion(gameVersion, ((LiteLoaderBMCLVersion)v).version, RemoteVersion.Type.UNCATEGORIZED, Collections.singletonList(NetworkUtils.withQuery(this.downloadProvider.injectURL("https://bmclapi2.bangbang93.com/liteloader/download"), Collections.singletonMap("version", ((LiteLoaderBMCLVersion)v).version))), ((LiteLoaderBMCLVersion)v).build.getTweakClass(), ((LiteLoaderBMCLVersion)v).build.getLibraries()));
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    private static final class LiteLoaderBMCLVersion {
        private final LiteLoaderVersion build;
        private final String version;

        public LiteLoaderBMCLVersion(LiteLoaderVersion build, String version) {
            this.build = build;
            this.version = version;
        }
    }
}

