/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.mod.curse.CurseForgeRemoteModRepository;
import org.jackhuang.hmcl.mod.modrinth.ModrinthRemoteModRepository;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public class RemoteMod {
    public static final RemoteMod BROKEN = new RemoteMod("", "", "RemoteMod.BROKEN", "", Collections.emptyList(), "", "", new IMod(){

        @Override
        public List<RemoteMod> loadDependencies(RemoteModRepository modRepository) throws IOException {
            throw new IOException();
        }

        @Override
        public Stream<Version> loadVersions(RemoteModRepository modRepository) throws IOException {
            throw new IOException();
        }
    });
    private final String slug;
    private final String author;
    private final String title;
    private final String description;
    private final List<String> categories;
    private final String pageUrl;
    private final String iconUrl;
    private final IMod data;

    public RemoteMod(String slug, String author, String title, String description, List<String> categories, String pageUrl, String iconUrl, IMod data) {
        this.slug = slug;
        this.author = author;
        this.title = title;
        this.description = description;
        this.categories = categories;
        this.pageUrl = pageUrl;
        this.iconUrl = iconUrl;
        this.data = data;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public String getPageUrl() {
        return this.pageUrl;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public IMod getData() {
        return this.data;
    }

    public static interface IMod {
        public List<RemoteMod> loadDependencies(RemoteModRepository var1) throws IOException;

        public Stream<Version> loadVersions(RemoteModRepository var1) throws IOException;
    }

    public static class File {
        private final Map<String, String> hashes;
        private final String url;
        private final String filename;

        public File(Map<String, String> hashes, String url, String filename) {
            this.hashes = hashes;
            this.url = url;
            this.filename = filename;
        }

        public Map<String, String> getHashes() {
            return this.hashes;
        }

        public FileDownloadTask.IntegrityCheck getIntegrityCheck() {
            if (this.hashes.containsKey("md5")) {
                return new FileDownloadTask.IntegrityCheck("MD5", this.hashes.get("md5"));
            }
            if (this.hashes.containsKey("sha1")) {
                return new FileDownloadTask.IntegrityCheck("SHA-1", this.hashes.get("sha1"));
            }
            if (this.hashes.containsKey("sha256")) {
                return new FileDownloadTask.IntegrityCheck("SHA-256", this.hashes.get("sha256"));
            }
            if (this.hashes.containsKey("sha512")) {
                return new FileDownloadTask.IntegrityCheck("SHA-512", this.hashes.get("sha512"));
            }
            return null;
        }

        public String getUrl() {
            return NetworkUtils.encodeLocation(this.url);
        }

        public String getFilename() {
            return this.filename;
        }
    }

    public static class Version {
        private final IVersion self;
        private final String modid;
        private final String name;
        private final String version;
        private final String changelog;
        private final Instant datePublished;
        private final VersionType versionType;
        private final File file;
        private final List<Dependency> dependencies;
        private final List<String> gameVersions;
        private final List<ModLoaderType> loaders;

        public Version(IVersion self, String modid, String name, String version, String changelog, Instant datePublished, VersionType versionType, File file, List<Dependency> dependencies, List<String> gameVersions, List<ModLoaderType> loaders) {
            this.self = self;
            this.modid = modid;
            this.name = name;
            this.version = version;
            this.changelog = changelog;
            this.datePublished = datePublished;
            this.versionType = versionType;
            this.file = file;
            this.dependencies = dependencies;
            this.gameVersions = gameVersions;
            this.loaders = loaders;
        }

        public IVersion getSelf() {
            return this.self;
        }

        public String getModid() {
            return this.modid;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getChangelog() {
            return this.changelog;
        }

        public Instant getDatePublished() {
            return this.datePublished;
        }

        public VersionType getVersionType() {
            return this.versionType;
        }

        public File getFile() {
            return this.file;
        }

        public List<Dependency> getDependencies() {
            return this.dependencies;
        }

        public List<String> getGameVersions() {
            return this.gameVersions;
        }

        public List<ModLoaderType> getLoaders() {
            return this.loaders;
        }
    }

    public static interface IVersion {
        public Type getType();
    }

    public static enum Type {
        CURSEFORGE(CurseForgeRemoteModRepository.MODS),
        MODRINTH(ModrinthRemoteModRepository.MODS);

        private final RemoteModRepository remoteModRepository;

        public RemoteModRepository getRemoteModRepository() {
            return this.remoteModRepository;
        }

        private Type(RemoteModRepository remoteModRepository) {
            this.remoteModRepository = remoteModRepository;
        }
    }

    public static final class Dependency {
        private static Dependency BROKEN_DEPENDENCY = null;
        private final DependencyType type;
        private final RemoteModRepository remoteModRepository;
        private final String id;
        private transient RemoteMod remoteMod = null;

        private Dependency(DependencyType type, RemoteModRepository remoteModRepository, String modid) {
            this.type = type;
            this.remoteModRepository = remoteModRepository;
            this.id = modid;
        }

        public static Dependency ofGeneral(DependencyType type, RemoteModRepository remoteModRepository, String modid) {
            if (type == DependencyType.BROKEN) {
                return Dependency.ofBroken();
            }
            return new Dependency(type, remoteModRepository, modid);
        }

        public static Dependency ofBroken() {
            if (BROKEN_DEPENDENCY == null) {
                BROKEN_DEPENDENCY = new Dependency(DependencyType.BROKEN, null, null);
            }
            return BROKEN_DEPENDENCY;
        }

        public DependencyType getType() {
            return this.type;
        }

        public RemoteModRepository getRemoteModRepository() {
            return this.remoteModRepository;
        }

        public String getId() {
            return this.id;
        }

        public RemoteMod load() throws IOException {
            if (this.remoteMod == null) {
                this.remoteMod = this.type == DependencyType.BROKEN ? BROKEN : this.remoteModRepository.getModById(this.id);
            }
            return this.remoteMod;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Dependency that = (Dependency)o;
            if (this.type != that.type) {
                return false;
            }
            if (!this.remoteModRepository.equals(that.remoteModRepository)) {
                return false;
            }
            return this.id.equals(that.id);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.remoteModRepository.hashCode();
            result = 31 * result + this.id.hashCode();
            return result;
        }
    }

    public static enum DependencyType {
        REQUIRED,
        OPTIONAL,
        TOOL,
        INCLUDE,
        EMBEDDED,
        INCOMPATIBLE,
        BROKEN;

    }

    public static enum VersionType {
        Release,
        Beta,
        Alpha;

    }
}

