/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.export;

import com.jfoenix.controls.JFXButton;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.SVGPath;
import org.jackhuang.hmcl.mod.ModpackExportInfo;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackExportTask;
import org.jackhuang.hmcl.mod.multimc.MultiMCModpackExportTask;
import org.jackhuang.hmcl.mod.server.ServerModpackExportTask;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class ModpackTypeSelectionPage
extends VBox
implements WizardPage {
    private final WizardController controller;
    public static final String MODPACK_TYPE = "modpack.type";
    public static final String MODPACK_TYPE_MCBBS = "mcbbs";
    public static final String MODPACK_TYPE_MULTIMC = "multimc";
    public static final String MODPACK_TYPE_SERVER = "server";

    public ModpackTypeSelectionPage(WizardController controller) {
        this.controller = controller;
        this.setPadding(new Insets(10.0));
        Label title = new Label(I18n.i18n("modpack.export.as"));
        VBox.setMargin((Node)title, (Insets)new Insets(8.0, 0.0, 8.0, 12.0));
        this.getStyleClass().add((Object)"jfx-list-view");
        this.setMaxSize(400.0, 150.0);
        this.setSpacing(8.0);
        this.getChildren().setAll((Object[])new Node[]{title, this.createButton(MODPACK_TYPE_MCBBS, McbbsModpackExportTask.OPTION), this.createButton(MODPACK_TYPE_MULTIMC, MultiMCModpackExportTask.OPTION), this.createButton(MODPACK_TYPE_SERVER, ServerModpackExportTask.OPTION)});
    }

    private JFXButton createButton(String type, ModpackExportInfo.Options option) {
        JFXButton button = new JFXButton();
        button.getStyleClass().add((Object)"card");
        button.setOnAction(e -> {
            this.controller.getSettings().put(MODPACK_TYPE, type);
            this.controller.getSettings().put("modpack.info.option", option);
            this.controller.onNext();
        });
        button.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        BorderPane graphic = new BorderPane();
        graphic.setMouseTransparent(true);
        graphic.setLeft((Node)new TwoLineListItem(I18n.i18n("modpack.type." + type), I18n.i18n("modpack.type." + type + ".export")));
        SVGPath arrow = new SVGPath();
        arrow.setContent(SVG.ARROW_FORWARD.getPath());
        BorderPane.setAlignment((Node)arrow, (Pos)Pos.CENTER);
        graphic.setRight((Node)arrow);
        button.setGraphic((Node)graphic);
        return button;
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
    }

    @Override
    public String getTitle() {
        return I18n.i18n("modpack.wizard.step.3.title");
    }
}

